; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple=aarch64-unknown-unknown | FileCheck %s

@.str = private constant [513 x i8] c"01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901\00", align 1

declare dso_local i32 @memcmp(ptr, ptr, i64)

define i32 @length0(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
   %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 0) nounwind
   ret i32 %m
 }

define i1 @length0_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length0_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w0, #1 // =0x1
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 0) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i1 @length0_lt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length0_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 0) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i32 @length2(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ldrh w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    sub w0, w8, w9, lsr #16
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 2) nounwind
  ret i32 %m
}

define i32 @length2_const(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length2_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w9, [x0]
; CHECK-NEXT:    mov w8, #-12594 // =0xffffcece
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    add w0, w8, w9, lsr #16
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr getelementptr inbounds ([513 x i8], ptr @.str, i32 0, i32 1), i64 2) nounwind
  ret i32 %m
}

define i1 @length2_gt_const(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length2_gt_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w9, [x0]
; CHECK-NEXT:    mov w8, #-12594 // =0xffffcece
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    add w8, w8, w9, lsr #16
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr getelementptr inbounds ([513 x i8], ptr @.str, i32 0, i32 1), i64 2) nounwind
  %c = icmp sgt i32 %m, 0
  ret i1 %c
}

define i1 @length2_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length2_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ldrh w9, [x1]
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 2) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i1 @length2_lt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length2_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ldrh w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    sub w8, w8, w9, lsr #16
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 2) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i1 @length2_gt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length2_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ldrh w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    sub w8, w8, w9, lsr #16
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 2) nounwind
  %c = icmp sgt i32 %m, 0
  ret i1 %c
}

define i1 @length2_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length2_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    mov w9, #12849 // =0x3231
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr getelementptr inbounds ([513 x i8], ptr @.str, i32 0, i32 1), i64 2) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i1 @length2_eq_nobuiltin_attr(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length2_eq_nobuiltin_attr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #2 // =0x2
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 2) nounwind nobuiltin
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length3(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrb w8, [x0, #2]
; CHECK-NEXT:    ldrh w9, [x0]
; CHECK-NEXT:    ldrb w10, [x1, #2]
; CHECK-NEXT:    ldrh w11, [x1]
; CHECK-NEXT:    orr w8, w9, w8, lsl #16
; CHECK-NEXT:    orr w9, w11, w10, lsl #16
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cset w9, lo
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 3) nounwind
  ret i32 %m
}

define i1 @length3_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length3_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ldrh w9, [x1]
; CHECK-NEXT:    ldrb w10, [x0, #2]
; CHECK-NEXT:    ldrb w11, [x1, #2]
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    ccmp w10, w11, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 3) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length4(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cset w9, lo
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 4) nounwind
  ret i32 %m
}

define i1 @length4_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length4_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 4) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i1 @length4_lt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length4_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 4) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i32 @length4_lt_32(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length4_lt_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 4) nounwind
  %c = lshr i32 %m, 31
  ret i32 %c
}

define i1 @length4_gt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length4_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, hi
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 4) nounwind
  %c = icmp sgt i32 %m, 0
  ret i1 %c
}

define i1 @length4_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length4_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    mov w9, #12849 // =0x3231
; CHECK-NEXT:    movk w9, #13363, lsl #16
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr getelementptr inbounds ([513 x i8], ptr @.str, i32 0, i32 1), i64 4) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length5(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrb w8, [x0, #4]
; CHECK-NEXT:    ldr w9, [x0]
; CHECK-NEXT:    ldrb w10, [x1, #4]
; CHECK-NEXT:    ldr w11, [x1]
; CHECK-NEXT:    orr x8, x9, x8, lsl #32
; CHECK-NEXT:    orr x9, x11, x10, lsl #32
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cset w9, lo
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 5) nounwind
  ret i32 %m
}

define i1 @length5_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length5_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    ldrb w10, [x0, #4]
; CHECK-NEXT:    ldrb w11, [x1, #4]
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    ccmp w10, w11, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 5) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i1 @length5_lt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length5_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrb w8, [x0, #4]
; CHECK-NEXT:    ldr w9, [x0]
; CHECK-NEXT:    ldrb w10, [x1, #4]
; CHECK-NEXT:    ldr w11, [x1]
; CHECK-NEXT:    orr x8, x9, x8, lsl #32
; CHECK-NEXT:    orr x9, x11, x10, lsl #32
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 5) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i32 @length6(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0, #4]
; CHECK-NEXT:    ldr w9, [x0]
; CHECK-NEXT:    ldrh w10, [x1, #4]
; CHECK-NEXT:    ldr w11, [x1]
; CHECK-NEXT:    orr x8, x9, x8, lsl #32
; CHECK-NEXT:    orr x9, x11, x10, lsl #32
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cset w9, lo
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 6) nounwind
  ret i32 %m
}

define i32 @length6_lt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length6_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0, #4]
; CHECK-NEXT:    ldr w9, [x0]
; CHECK-NEXT:    ldrh w10, [x1, #4]
; CHECK-NEXT:    ldr w11, [x1]
; CHECK-NEXT:    orr x8, x9, x8, lsl #32
; CHECK-NEXT:    orr x9, x11, x10, lsl #32
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 6) nounwind
  %r = lshr i32 %m, 31
  ret i32 %r
}

define i32 @length7(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    b.ne .LBB24_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldur w8, [x0, #3]
; CHECK-NEXT:    ldur w9, [x1, #3]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    b.ne .LBB24_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB24_3: // %res_block
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 7) nounwind
  ret i32 %m
}

define i1 @length7_lt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length7_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    b.ne .LBB25_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldur w8, [x0, #3]
; CHECK-NEXT:    ldur w9, [x1, #3]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    b.ne .LBB25_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB25_3: // %res_block
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 7) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i1 @length7_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length7_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ldr w9, [x1]
; CHECK-NEXT:    ldur w10, [x0, #3]
; CHECK-NEXT:    ldur w11, [x1, #3]
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    ccmp w10, w11, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 7) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length8(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cset w9, lo
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 8) nounwind
  ret i32 %m
}

define i1 @length8_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length8_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 8) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i1 @length8_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length8_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x9, #12592 // =0x3130
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    movk x9, #13106, lsl #16
; CHECK-NEXT:    movk x9, #13620, lsl #32
; CHECK-NEXT:    movk x9, #14134, lsl #48
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 8) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length9(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB30_2
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldrb w8, [x0, #8]
; CHECK-NEXT:    ldrb w9, [x1, #8]
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB30_2: // %res_block
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 9) nounwind
  ret i32 %m
}

define i1 @length9_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length9_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    ldrb w10, [x0, #8]
; CHECK-NEXT:    ldrb w11, [x1, #8]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 9) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length10(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB32_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldrh w8, [x0, #8]
; CHECK-NEXT:    ldrh w9, [x1, #8]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    lsr w9, w9, #16
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB32_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB32_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 10) nounwind
  ret i32 %m
}

define i1 @length10_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length10_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    ldrh w10, [x0, #8]
; CHECK-NEXT:    ldrh w11, [x1, #8]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 10) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length11(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length11:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB34_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldur x8, [x0, #3]
; CHECK-NEXT:    ldur x9, [x1, #3]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB34_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB34_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 11) nounwind
  ret i32 %m
}

define i1 @length11_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length11_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    ldur x10, [x0, #3]
; CHECK-NEXT:    ldur x11, [x1, #3]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 11) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i1 @length12_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length12_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    ldr w10, [x0, #8]
; CHECK-NEXT:    ldr w11, [x1, #8]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 12) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length12(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB37_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr w8, [x0, #8]
; CHECK-NEXT:    ldr w9, [x1, #8]
; CHECK-NEXT:    rev w8, w8
; CHECK-NEXT:    rev w9, w9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB37_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB37_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 12) nounwind
  ret i32 %m
}

define i1 @length13_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length13_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    ldur x10, [x0, #5]
; CHECK-NEXT:    ldur x11, [x1, #5]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 13) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i1 @length14_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length14_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    ldur x10, [x0, #6]
; CHECK-NEXT:    ldur x11, [x1, #6]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 14) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length15(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB40_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldur x8, [x0, #7]
; CHECK-NEXT:    ldur x9, [x1, #7]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB40_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB40_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 15) nounwind
  ret i32 %m
}

define i1 @length15_lt(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length15_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB41_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldur x8, [x0, #7]
; CHECK-NEXT:    ldur x9, [x1, #7]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB41_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB41_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 15) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i32 @length15_const(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length15_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #14136 // =0x3738
; CHECK-NEXT:    ldr x9, [x0]
; CHECK-NEXT:    movk x8, #13622, lsl #16
; CHECK-NEXT:    movk x8, #13108, lsl #32
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    movk x8, #12594, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    b.ne .LBB42_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    mov x8, #13365 // =0x3435
; CHECK-NEXT:    ldur x9, [x0, #7]
; CHECK-NEXT:    movk x8, #12851, lsl #16
; CHECK-NEXT:    movk x8, #12337, lsl #32
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    movk x8, #14393, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    b.ne .LBB42_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB42_3: // %res_block
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr getelementptr inbounds ([513 x i8], ptr @.str, i32 0, i32 1), i64 15) nounwind
  ret i32 %m
}

define i1 @length15_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length15_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    ldur x10, [x0, #7]
; CHECK-NEXT:    ldur x11, [x1, #7]
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 15) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i1 @length15_gt_const(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length15_gt_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #14136 // =0x3738
; CHECK-NEXT:    ldr x9, [x0]
; CHECK-NEXT:    movk x8, #13622, lsl #16
; CHECK-NEXT:    movk x8, #13108, lsl #32
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    movk x8, #12594, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    b.ne .LBB44_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    mov x8, #13365 // =0x3435
; CHECK-NEXT:    ldur x9, [x0, #7]
; CHECK-NEXT:    movk x8, #12851, lsl #16
; CHECK-NEXT:    movk x8, #12337, lsl #32
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    movk x8, #14393, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    b.ne .LBB44_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB44_4
; CHECK-NEXT:  .LBB44_3: // %res_block
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB44_4: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr getelementptr inbounds ([513 x i8], ptr @.str, i32 0, i32 1), i64 15) nounwind
  %c = icmp sgt i32 %m, 0
  ret i1 %c
}


define i32 @length16(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB45_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB45_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB45_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 16) nounwind
  ret i32 %m
}

define i1 @length16_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length16_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 16) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length16_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length16_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB47_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB47_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB47_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 16) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length16_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length16_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB48_3
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB48_3
; CHECK-NEXT:  // %bb.2:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB48_4
; CHECK-NEXT:  .LBB48_3: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB48_4: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 16) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length16_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length16_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #12592 // =0x3130
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    movk x8, #13106, lsl #16
; CHECK-NEXT:    movk x8, #13620, lsl #32
; CHECK-NEXT:    movk x8, #14134, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov x8, #14648 // =0x3938
; CHECK-NEXT:    movk x8, #12592, lsl #16
; CHECK-NEXT:    movk x8, #13106, lsl #32
; CHECK-NEXT:    movk x8, #13620, lsl #48
; CHECK-NEXT:    ccmp x10, x8, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 16) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}


define i32 @length24(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length24:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB50_4
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB50_4
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB50_4
; CHECK-NEXT:  // %bb.3:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB50_4: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 24) nounwind
  ret i32 %m
}

define i1 @length24_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length24_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldr x12, [x0, #16]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldr x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x12, x13, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 24) nounwind
  %cmp = icmp eq i32 %call, 0
  ret i1 %cmp
}

define i1 @length24_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length24_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB52_4
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB52_4
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB52_4
; CHECK-NEXT:  // %bb.3:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB52_4: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 24) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length24_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length24_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB53_4
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB53_4
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB53_4
; CHECK-NEXT:  // %bb.3:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB53_5
; CHECK-NEXT:  .LBB53_4: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB53_5: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 24) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length24_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length24_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #12592 // =0x3130
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    movk x8, #13106, lsl #16
; CHECK-NEXT:    ldr x11, [x0, #16]
; CHECK-NEXT:    movk x8, #13620, lsl #32
; CHECK-NEXT:    movk x8, #14134, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov x8, #14648 // =0x3938
; CHECK-NEXT:    movk x8, #12592, lsl #16
; CHECK-NEXT:    movk x8, #13106, lsl #32
; CHECK-NEXT:    movk x8, #13620, lsl #48
; CHECK-NEXT:    ccmp x10, x8, #0, eq
; CHECK-NEXT:    mov x8, #14134 // =0x3736
; CHECK-NEXT:    movk x8, #14648, lsl #16
; CHECK-NEXT:    movk x8, #12592, lsl #32
; CHECK-NEXT:    movk x8, #13106, lsl #48
; CHECK-NEXT:    ccmp x11, x8, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 24) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length31(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length31:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB55_5
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB55_5
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB55_5
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldur x8, [x0, #23]
; CHECK-NEXT:    ldur x9, [x1, #23]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB55_5
; CHECK-NEXT:  // %bb.4:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB55_5: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 31) nounwind
  ret i32 %m
}

define i1 @length31_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length31_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldr x12, [x0, #16]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldr x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldur x8, [x0, #23]
; CHECK-NEXT:    ldur x9, [x1, #23]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x12, x13, #0, eq
; CHECK-NEXT:    ccmp x8, x9, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 31) nounwind
  %cmp = icmp eq i32 %call, 0
  ret i1 %cmp
}

define i1 @length31_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length31_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB57_5
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB57_5
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB57_5
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldur x8, [x0, #23]
; CHECK-NEXT:    ldur x9, [x1, #23]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB57_5
; CHECK-NEXT:  // %bb.4:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB57_5: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 31) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length31_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length31_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB58_5
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB58_5
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB58_5
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldur x8, [x0, #23]
; CHECK-NEXT:    ldur x9, [x1, #23]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB58_5
; CHECK-NEXT:  // %bb.4:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB58_6
; CHECK-NEXT:  .LBB58_5: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB58_6: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 31) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length31_eq_prefer128(ptr %x, ptr %y) nounwind "prefer-vector-width"="128" {
; CHECK-LABEL: length31_eq_prefer128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldr x12, [x0, #16]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldr x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldur x8, [x0, #23]
; CHECK-NEXT:    ldur x9, [x1, #23]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x12, x13, #0, eq
; CHECK-NEXT:    ccmp x8, x9, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 31) nounwind
  %cmp = icmp eq i32 %call, 0
  ret i1 %cmp
}

define i1 @length31_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length31_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #12592 // =0x3130
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    movk x8, #13106, lsl #16
; CHECK-NEXT:    ldr x11, [x0, #16]
; CHECK-NEXT:    movk x8, #13620, lsl #32
; CHECK-NEXT:    movk x8, #14134, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov x8, #14648 // =0x3938
; CHECK-NEXT:    ldur x9, [x0, #23]
; CHECK-NEXT:    movk x8, #12592, lsl #16
; CHECK-NEXT:    movk x8, #13106, lsl #32
; CHECK-NEXT:    movk x8, #13620, lsl #48
; CHECK-NEXT:    ccmp x10, x8, #0, eq
; CHECK-NEXT:    mov x8, #14134 // =0x3736
; CHECK-NEXT:    movk x8, #14648, lsl #16
; CHECK-NEXT:    movk x8, #12592, lsl #32
; CHECK-NEXT:    movk x8, #13106, lsl #48
; CHECK-NEXT:    ccmp x11, x8, #0, eq
; CHECK-NEXT:    mov x8, #13363 // =0x3433
; CHECK-NEXT:    movk x8, #13877, lsl #16
; CHECK-NEXT:    movk x8, #14391, lsl #32
; CHECK-NEXT:    movk x8, #12345, lsl #48
; CHECK-NEXT:    ccmp x9, x8, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 31) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length32(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB61_5
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB61_5
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB61_5
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB61_5
; CHECK-NEXT:  // %bb.4:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB61_5: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 32) nounwind
  ret i32 %m
}


define i1 @length32_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length32_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldp x12, x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldp x8, x9, [x0, #16]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x8, x12, #0, eq
; CHECK-NEXT:    ccmp x9, x13, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 32) nounwind
  %cmp = icmp eq i32 %call, 0
  ret i1 %cmp
}

define i1 @length32_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length32_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB63_5
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB63_5
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB63_5
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB63_5
; CHECK-NEXT:  // %bb.4:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB63_5: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 32) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length32_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length32_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB64_5
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB64_5
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB64_5
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB64_5
; CHECK-NEXT:  // %bb.4:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB64_6
; CHECK-NEXT:  .LBB64_5: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB64_6: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 32) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length32_eq_prefer128(ptr %x, ptr %y) nounwind "prefer-vector-width"="128" {
; CHECK-LABEL: length32_eq_prefer128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldp x12, x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldp x8, x9, [x0, #16]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x8, x12, #0, eq
; CHECK-NEXT:    ccmp x9, x13, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 32) nounwind
  %cmp = icmp eq i32 %call, 0
  ret i1 %cmp
}

define i1 @length32_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length32_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #12592 // =0x3130
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    movk x8, #13106, lsl #16
; CHECK-NEXT:    movk x8, #13620, lsl #32
; CHECK-NEXT:    movk x8, #14134, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov x8, #14648 // =0x3938
; CHECK-NEXT:    movk x8, #12592, lsl #16
; CHECK-NEXT:    ldp x9, x11, [x0, #16]
; CHECK-NEXT:    movk x8, #13106, lsl #32
; CHECK-NEXT:    movk x8, #13620, lsl #48
; CHECK-NEXT:    ccmp x10, x8, #0, eq
; CHECK-NEXT:    mov x8, #14134 // =0x3736
; CHECK-NEXT:    movk x8, #14648, lsl #16
; CHECK-NEXT:    movk x8, #12592, lsl #32
; CHECK-NEXT:    movk x8, #13106, lsl #48
; CHECK-NEXT:    ccmp x9, x8, #0, eq
; CHECK-NEXT:    mov x8, #13620 // =0x3534
; CHECK-NEXT:    movk x8, #14134, lsl #16
; CHECK-NEXT:    movk x8, #14648, lsl #32
; CHECK-NEXT:    movk x8, #12592, lsl #48
; CHECK-NEXT:    ccmp x11, x8, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 32) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length48(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length48:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB67_7
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB67_7
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB67_7
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB67_7
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB67_7
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB67_7
; CHECK-NEXT:  // %bb.6:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB67_7: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 48) nounwind
  ret i32 %m
}

define i1 @length48_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length48_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldp x12, x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldp x8, x9, [x0, #16]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x8, x12, #0, eq
; CHECK-NEXT:    ldp x8, x11, [x0, #32]
; CHECK-NEXT:    ldp x10, x12, [x1, #32]
; CHECK-NEXT:    ccmp x9, x13, #0, eq
; CHECK-NEXT:    ccmp x8, x10, #0, eq
; CHECK-NEXT:    ccmp x11, x12, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 48) nounwind
  %cmp = icmp eq i32 %call, 0
  ret i1 %cmp
}

define i1 @length48_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length48_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB69_7
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB69_7
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB69_7
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB69_7
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB69_7
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB69_7
; CHECK-NEXT:  // %bb.6:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB69_7: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 48) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length48_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length48_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB70_7
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB70_7
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB70_7
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB70_7
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB70_7
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB70_7
; CHECK-NEXT:  // %bb.6:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB70_8
; CHECK-NEXT:  .LBB70_7: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB70_8: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 48) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length48_eq_prefer128(ptr %x, ptr %y) nounwind "prefer-vector-width"="128" {
; CHECK-LABEL: length48_eq_prefer128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldp x12, x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldp x8, x9, [x0, #16]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x8, x12, #0, eq
; CHECK-NEXT:    ldp x8, x11, [x0, #32]
; CHECK-NEXT:    ldp x10, x12, [x1, #32]
; CHECK-NEXT:    ccmp x9, x13, #0, eq
; CHECK-NEXT:    ccmp x8, x10, #0, eq
; CHECK-NEXT:    ccmp x11, x12, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 48) nounwind
  %cmp = icmp eq i32 %call, 0
  ret i1 %cmp
}

define i1 @length48_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length48_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #12592 // =0x3130
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    movk x8, #13106, lsl #16
; CHECK-NEXT:    ldp x11, x12, [x0, #16]
; CHECK-NEXT:    movk x8, #13620, lsl #32
; CHECK-NEXT:    movk x8, #14134, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov x9, #14648 // =0x3938
; CHECK-NEXT:    movk x9, #12592, lsl #16
; CHECK-NEXT:    movk x9, #13106, lsl #32
; CHECK-NEXT:    movk x9, #13620, lsl #48
; CHECK-NEXT:    ccmp x10, x9, #0, eq
; CHECK-NEXT:    mov x9, #14134 // =0x3736
; CHECK-NEXT:    movk x9, #14648, lsl #16
; CHECK-NEXT:    movk x9, #12592, lsl #32
; CHECK-NEXT:    movk x9, #13106, lsl #48
; CHECK-NEXT:    ccmp x11, x9, #0, eq
; CHECK-NEXT:    mov x9, #13620 // =0x3534
; CHECK-NEXT:    movk x9, #14134, lsl #16
; CHECK-NEXT:    ldp x10, x11, [x0, #32]
; CHECK-NEXT:    movk x9, #14648, lsl #32
; CHECK-NEXT:    movk x9, #12592, lsl #48
; CHECK-NEXT:    ccmp x12, x9, #0, eq
; CHECK-NEXT:    mov x9, #13106 // =0x3332
; CHECK-NEXT:    movk x9, #13620, lsl #16
; CHECK-NEXT:    movk x9, #14134, lsl #32
; CHECK-NEXT:    movk x9, #14648, lsl #48
; CHECK-NEXT:    ccmp x10, x9, #0, eq
; CHECK-NEXT:    ccmp x11, x8, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 48) nounwind
  %c = icmp ne i32 %m, 0
  ret i1 %c
}

define i32 @length63(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length63:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.6: // %loadbb6
; CHECK-NEXT:    ldr x8, [x0, #48]
; CHECK-NEXT:    ldr x9, [x1, #48]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.7: // %loadbb7
; CHECK-NEXT:    ldur x8, [x0, #55]
; CHECK-NEXT:    ldur x9, [x1, #55]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB73_9
; CHECK-NEXT:  // %bb.8:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB73_9: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 63) nounwind
  ret i32 %m
}

define i1 @length63_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length63_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldp x12, x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldp x8, x9, [x0, #16]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x8, x12, #0, eq
; CHECK-NEXT:    ldp x8, x11, [x0, #32]
; CHECK-NEXT:    ldp x10, x12, [x1, #32]
; CHECK-NEXT:    ccmp x9, x13, #0, eq
; CHECK-NEXT:    ldr x9, [x0, #48]
; CHECK-NEXT:    ldr x13, [x1, #48]
; CHECK-NEXT:    ccmp x8, x10, #0, eq
; CHECK-NEXT:    ldur x8, [x0, #55]
; CHECK-NEXT:    ldur x10, [x1, #55]
; CHECK-NEXT:    ccmp x11, x12, #0, eq
; CHECK-NEXT:    ccmp x9, x13, #0, eq
; CHECK-NEXT:    ccmp x8, x10, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 63) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length63_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length63_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.6: // %loadbb6
; CHECK-NEXT:    ldr x8, [x0, #48]
; CHECK-NEXT:    ldr x9, [x1, #48]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.7: // %loadbb7
; CHECK-NEXT:    ldur x8, [x0, #55]
; CHECK-NEXT:    ldur x9, [x1, #55]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB75_9
; CHECK-NEXT:  // %bb.8:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB75_9: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 63) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length63_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length63_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.6: // %loadbb6
; CHECK-NEXT:    ldr x8, [x0, #48]
; CHECK-NEXT:    ldr x9, [x1, #48]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.7: // %loadbb7
; CHECK-NEXT:    ldur x8, [x0, #55]
; CHECK-NEXT:    ldur x9, [x1, #55]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB76_9
; CHECK-NEXT:  // %bb.8:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB76_10
; CHECK-NEXT:  .LBB76_9: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB76_10: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 63) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length63_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length63_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #12592 // =0x3130
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    movk x8, #13106, lsl #16
; CHECK-NEXT:    ldp x11, x12, [x0, #16]
; CHECK-NEXT:    movk x8, #13620, lsl #32
; CHECK-NEXT:    movk x8, #14134, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov x9, #14648 // =0x3938
; CHECK-NEXT:    movk x9, #12592, lsl #16
; CHECK-NEXT:    movk x9, #13106, lsl #32
; CHECK-NEXT:    movk x9, #13620, lsl #48
; CHECK-NEXT:    ccmp x10, x9, #0, eq
; CHECK-NEXT:    mov x10, #14134 // =0x3736
; CHECK-NEXT:    movk x10, #14648, lsl #16
; CHECK-NEXT:    movk x10, #12592, lsl #32
; CHECK-NEXT:    movk x10, #13106, lsl #48
; CHECK-NEXT:    ccmp x11, x10, #0, eq
; CHECK-NEXT:    mov x10, #13620 // =0x3534
; CHECK-NEXT:    movk x10, #14134, lsl #16
; CHECK-NEXT:    ldp x11, x13, [x0, #32]
; CHECK-NEXT:    movk x10, #14648, lsl #32
; CHECK-NEXT:    movk x10, #12592, lsl #48
; CHECK-NEXT:    ccmp x12, x10, #0, eq
; CHECK-NEXT:    mov x10, #13106 // =0x3332
; CHECK-NEXT:    ldr x12, [x0, #48]
; CHECK-NEXT:    movk x10, #13620, lsl #16
; CHECK-NEXT:    movk x10, #14134, lsl #32
; CHECK-NEXT:    movk x10, #14648, lsl #48
; CHECK-NEXT:    ccmp x11, x10, #0, eq
; CHECK-NEXT:    ldur x10, [x0, #55]
; CHECK-NEXT:    ccmp x13, x8, #0, eq
; CHECK-NEXT:    mov x8, #13877 // =0x3635
; CHECK-NEXT:    movk x8, #14391, lsl #16
; CHECK-NEXT:    ccmp x12, x9, #0, eq
; CHECK-NEXT:    movk x8, #12345, lsl #32
; CHECK-NEXT:    movk x8, #12849, lsl #48
; CHECK-NEXT:    ccmp x10, x8, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 63) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length64(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.6: // %loadbb6
; CHECK-NEXT:    ldr x8, [x0, #48]
; CHECK-NEXT:    ldr x9, [x1, #48]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.7: // %loadbb7
; CHECK-NEXT:    ldr x8, [x0, #56]
; CHECK-NEXT:    ldr x9, [x1, #56]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB78_9
; CHECK-NEXT:  // %bb.8:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB78_9: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w0, w8, hs
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 64) nounwind
  ret i32 %m
}

define i1 @length64_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length64_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x8, x11, [x1]
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    ldp x12, x13, [x1, #16]
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    ldp x8, x9, [x0, #16]
; CHECK-NEXT:    ccmp x10, x11, #0, eq
; CHECK-NEXT:    ccmp x8, x12, #0, eq
; CHECK-NEXT:    ldp x8, x11, [x0, #32]
; CHECK-NEXT:    ldp x10, x12, [x1, #32]
; CHECK-NEXT:    ccmp x9, x13, #0, eq
; CHECK-NEXT:    ldp x9, x13, [x1, #48]
; CHECK-NEXT:    ccmp x8, x10, #0, eq
; CHECK-NEXT:    ldp x8, x10, [x0, #48]
; CHECK-NEXT:    ccmp x11, x12, #0, eq
; CHECK-NEXT:    ccmp x8, x9, #0, eq
; CHECK-NEXT:    ccmp x10, x13, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 64) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length64_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length64_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.6: // %loadbb6
; CHECK-NEXT:    ldr x8, [x0, #48]
; CHECK-NEXT:    ldr x9, [x1, #48]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.7: // %loadbb7
; CHECK-NEXT:    ldr x8, [x0, #56]
; CHECK-NEXT:    ldr x9, [x1, #56]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB80_9
; CHECK-NEXT:  // %bb.8:
; CHECK-NEXT:    lsr w0, wzr, #31
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB80_9: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:    lsr w0, w8, #31
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 64) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length64_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length64_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldr x9, [x1]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.1: // %loadbb1
; CHECK-NEXT:    ldr x8, [x0, #8]
; CHECK-NEXT:    ldr x9, [x1, #8]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.2: // %loadbb2
; CHECK-NEXT:    ldr x8, [x0, #16]
; CHECK-NEXT:    ldr x9, [x1, #16]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.3: // %loadbb3
; CHECK-NEXT:    ldr x8, [x0, #24]
; CHECK-NEXT:    ldr x9, [x1, #24]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.4: // %loadbb4
; CHECK-NEXT:    ldr x8, [x0, #32]
; CHECK-NEXT:    ldr x9, [x1, #32]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.5: // %loadbb5
; CHECK-NEXT:    ldr x8, [x0, #40]
; CHECK-NEXT:    ldr x9, [x1, #40]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.6: // %loadbb6
; CHECK-NEXT:    ldr x8, [x0, #48]
; CHECK-NEXT:    ldr x9, [x1, #48]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.7: // %loadbb7
; CHECK-NEXT:    ldr x8, [x0, #56]
; CHECK-NEXT:    ldr x9, [x1, #56]
; CHECK-NEXT:    rev x8, x8
; CHECK-NEXT:    rev x9, x9
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    b.ne .LBB81_9
; CHECK-NEXT:  // %bb.8:
; CHECK-NEXT:    mov w8, wzr
; CHECK-NEXT:    b .LBB81_10
; CHECK-NEXT:  .LBB81_9: // %res_block
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    cneg w8, w8, hs
; CHECK-NEXT:  .LBB81_10: // %endblock
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 64) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length64_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length64_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #12592 // =0x3130
; CHECK-NEXT:    ldp x9, x10, [x0]
; CHECK-NEXT:    movk x8, #13106, lsl #16
; CHECK-NEXT:    ldp x11, x12, [x0, #16]
; CHECK-NEXT:    movk x8, #13620, lsl #32
; CHECK-NEXT:    ldp x13, x14, [x0, #32]
; CHECK-NEXT:    movk x8, #14134, lsl #48
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    mov x9, #14648 // =0x3938
; CHECK-NEXT:    movk x9, #12592, lsl #16
; CHECK-NEXT:    movk x9, #13106, lsl #32
; CHECK-NEXT:    movk x9, #13620, lsl #48
; CHECK-NEXT:    ccmp x10, x9, #0, eq
; CHECK-NEXT:    mov x10, #14134 // =0x3736
; CHECK-NEXT:    movk x10, #14648, lsl #16
; CHECK-NEXT:    movk x10, #12592, lsl #32
; CHECK-NEXT:    movk x10, #13106, lsl #48
; CHECK-NEXT:    ccmp x11, x10, #0, eq
; CHECK-NEXT:    mov x11, #13620 // =0x3534
; CHECK-NEXT:    movk x11, #14134, lsl #16
; CHECK-NEXT:    movk x11, #14648, lsl #32
; CHECK-NEXT:    movk x11, #12592, lsl #48
; CHECK-NEXT:    ccmp x12, x11, #0, eq
; CHECK-NEXT:    mov x11, #13106 // =0x3332
; CHECK-NEXT:    movk x11, #13620, lsl #16
; CHECK-NEXT:    movk x11, #14134, lsl #32
; CHECK-NEXT:    movk x11, #14648, lsl #48
; CHECK-NEXT:    ccmp x13, x11, #0, eq
; CHECK-NEXT:    ldp x11, x12, [x0, #48]
; CHECK-NEXT:    ccmp x14, x8, #0, eq
; CHECK-NEXT:    ccmp x11, x9, #0, eq
; CHECK-NEXT:    ccmp x12, x10, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 64) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length96(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length96:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #96 // =0x60
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 96) nounwind
  ret i32 %m
}

define i1 @length96_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length96_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #96 // =0x60
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 96) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length96_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length96_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #96 // =0x60
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 96) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length96_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length96_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #96 // =0x60
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 96) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length96_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length96_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #96 // =0x60
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 96) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length127(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length127:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #127 // =0x7f
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 127) nounwind
  ret i32 %m
}

define i1 @length127_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length127_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #127 // =0x7f
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 127) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length127_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length127_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #127 // =0x7f
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 127) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length127_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length127_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #127 // =0x7f
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 127) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length127_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length127_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #127 // =0x7f
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 127) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length128(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #128 // =0x80
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 128) nounwind
  ret i32 %m
}

define i1 @length128_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length128_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #128 // =0x80
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 128) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length128_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length128_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #128 // =0x80
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 128) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length128_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length128_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #128 // =0x80
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 128) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length128_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length128_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #128 // =0x80
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 128) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length192(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length192:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #192 // =0xc0
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 192) nounwind
  ret i32 %m
}

define i1 @length192_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length192_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #192 // =0xc0
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 192) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length192_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length192_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #192 // =0xc0
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 192) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length192_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length192_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #192 // =0xc0
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 192) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length192_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length192_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #192 // =0xc0
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 192) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length255(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length255:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #255 // =0xff
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 255) nounwind
  ret i32 %m
}

define i1 @length255_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length255_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #255 // =0xff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 255) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length255_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length255_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #255 // =0xff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 255) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length255_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length255_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #255 // =0xff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 255) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length255_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length255_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #255 // =0xff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 255) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length256(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length256:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #256 // =0x100
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 256) nounwind
  ret i32 %m
}

define i1 @length256_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length256_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #256 // =0x100
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 256) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length256_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length256_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #256 // =0x100
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 256) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length256_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length256_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #256 // =0x100
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 256) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length256_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length256_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #256 // =0x100
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 256) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length384(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length384:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #384 // =0x180
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 384) nounwind
  ret i32 %m
}

define i1 @length384_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length384_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #384 // =0x180
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 384) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length384_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length384_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #384 // =0x180
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 384) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length384_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length384_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #384 // =0x180
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 384) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length384_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length384_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #384 // =0x180
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 384) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length511(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length511:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #511 // =0x1ff
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 511) nounwind
  ret i32 %m
}

define i1 @length511_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length511_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #511 // =0x1ff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 511) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length511_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length511_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #511 // =0x1ff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 511) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length511_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length511_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #511 // =0x1ff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 511) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length511_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length511_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #511 // =0x1ff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 511) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @length512(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: length512:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w2, #512 // =0x200
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 512) nounwind
  ret i32 %m
}

define i1 @length512_eq(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length512_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #512 // =0x200
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 512) nounwind
  %cmp = icmp ne i32 %call, 0
  ret i1 %cmp
}

define i1 @length512_lt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length512_lt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #512 // =0x200
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    lsr w0, w0, #31
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 512) nounwind
  %cmp = icmp slt i32 %call, 0
  ret i1 %cmp
}

define i1 @length512_gt(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: length512_gt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov w2, #512 // =0x200
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 512) nounwind
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define i1 @length512_eq_const(ptr %X) nounwind {
; CHECK-LABEL: length512_eq_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    adrp x1, .L.str
; CHECK-NEXT:    add x1, x1, :lo12:.L.str
; CHECK-NEXT:    mov w2, #512 // =0x200
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr @.str, i64 512) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @huge_length(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: huge_length:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x2, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 9223372036854775807) nounwind
  ret i32 %m
}

define i1 @huge_length_eq(ptr %X, ptr %Y) nounwind {
; CHECK-LABEL: huge_length_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    mov x2, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 9223372036854775807) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}

define i32 @nonconst_length(ptr %X, ptr %Y, i64 %size) nounwind {
; CHECK-LABEL: nonconst_length:
; CHECK:       // %bb.0:
; CHECK-NEXT:    b memcmp
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 %size) nounwind
  ret i32 %m
}

define i1 @nonconst_length_eq(ptr %X, ptr %Y, i64 %size) nounwind {
; CHECK-LABEL: nonconst_length_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl memcmp
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %m = tail call i32 @memcmp(ptr %X, ptr %Y, i64 %size) nounwind
  %c = icmp eq i32 %m, 0
  ret i1 %c
}
