; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-none-elf -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,SDISEL
; RUN: llc -mtriple=aarch64-none-elf -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,GISEL

declare void @dummy()

define i32 @and_eq_ne_ult(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_eq_ne_ult:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #0, ne
; SDISEL-NEXT:    b.eq .LBB0_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.lo .LBB0_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB0_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_eq_ne_ult:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, eq
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ne
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB0_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.lo .LBB0_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB0_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp eq i32 %s0, %s1
  %c1 = icmp ne i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp ult i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}

define i32 @and_ne_ult_ule(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_ne_ult_ule:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #4, lo
; SDISEL-NEXT:    b.ne .LBB1_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.ls .LBB1_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB1_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ne_ult_ule:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ne
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lo
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB1_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.ls .LBB1_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB1_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ne i32 %s0, %s1
  %c1 = icmp ult i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp ule i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}

define i32 @and_ult_ule_ugt(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_ult_ule_ugt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #2, ls
; SDISEL-NEXT:    b.lo .LBB2_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.hi .LBB2_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB2_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ult_ule_ugt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, ls
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB2_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.hi .LBB2_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB2_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ult i32 %s0, %s1
  %c1 = icmp ule i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp ugt i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}

define i32 @and_ule_ugt_uge(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_ule_ugt_uge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #2, hi
; SDISEL-NEXT:    b.ls .LBB3_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.hs .LBB3_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB3_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ule_ugt_uge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, ls
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hi
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB3_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.hs .LBB3_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB3_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ule i32 %s0, %s1
  %c1 = icmp ugt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp uge i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}

define i32 @and_ugt_uge_slt(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_ugt_uge_slt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #0, hs
; SDISEL-NEXT:    b.hi .LBB4_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.lt .LBB4_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB4_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_ugt_uge_slt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hi
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, hs
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB4_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.lt .LBB4_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB4_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp ugt i32 %s0, %s1
  %c1 = icmp uge i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp slt i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}

define i32 @and_uge_slt_sle(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_uge_slt_sle:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #0, lt
; SDISEL-NEXT:    b.hs .LBB5_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.le .LBB5_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB5_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_uge_slt_sle:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, hs
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, lt
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB5_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.le .LBB5_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB5_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp uge i32 %s0, %s1
  %c1 = icmp slt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp sle i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}

define i32 @and_slt_sle_sgt(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_slt_sle_sgt:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #0, le
; SDISEL-NEXT:    b.lt .LBB6_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.gt .LBB6_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB6_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_slt_sle_sgt:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, lt
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, le
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB6_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.gt .LBB6_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB6_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp slt i32 %s0, %s1
  %c1 = icmp sle i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp sgt i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}

define i32 @and_sle_sgt_sge(i32 %s0, i32 %s1, i32 %s2, i32 %s3, i32 %s4, i32 %s5, ptr %p) {
; SDISEL-LABEL: and_sle_sgt_sge:
; SDISEL:       // %bb.0: // %entry
; SDISEL-NEXT:    cmp w2, w3
; SDISEL-NEXT:    ccmp w0, w1, #0, gt
; SDISEL-NEXT:    b.le .LBB7_3
; SDISEL-NEXT:  // %bb.1: // %entry
; SDISEL-NEXT:    cmp w4, w5
; SDISEL-NEXT:    b.ge .LBB7_3
; SDISEL-NEXT:  // %bb.2:
; SDISEL-NEXT:    mov w0, wzr
; SDISEL-NEXT:    ret
; SDISEL-NEXT:  .LBB7_3: // %if
; SDISEL-NEXT:    mov w0, #1 // =0x1
; SDISEL-NEXT:    str w0, [x6]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: and_sle_sgt_sge:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    cmp w0, w1
; GISEL-NEXT:    cset w8, le
; GISEL-NEXT:    cmp w2, w3
; GISEL-NEXT:    cset w9, gt
; GISEL-NEXT:    and w8, w8, w9
; GISEL-NEXT:    tbnz w8, #0, .LBB7_3
; GISEL-NEXT:  // %bb.1: // %entry
; GISEL-NEXT:    cmp w4, w5
; GISEL-NEXT:    mov w0, wzr
; GISEL-NEXT:    b.ge .LBB7_3
; GISEL-NEXT:  // %bb.2: // %common.ret
; GISEL-NEXT:    ret
; GISEL-NEXT:  .LBB7_3: // %if
; GISEL-NEXT:    mov w0, #1 // =0x1
; GISEL-NEXT:    str w0, [x6]
; GISEL-NEXT:    ret
entry:
  %c0 = icmp sle i32 %s0, %s1
  %c1 = icmp sgt i32 %s2, %s3
  %a = and i1 %c0, %c1
  %c2 = icmp sge i32 %s4, %s5
  %o = or i1 %a, %c2
  br i1 %o, label %if, label %else

if:
  store i32 1, ptr %p
  ret i32 1

else:
  ret i32 0
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
