/* SPDX-License-Identifier: GPL-2.0-or-later */
// =============================================================================
// Copyright Raspberry Pi Ltd. 2023
// vrbuild version: 56aac1a23c016cbbd229108f3b6efc1343842156-clean
// THIS FILE IS GENERATED BY VRBUILD - DO NOT EDIT
// =============================================================================
// Register block : VEC
// Version        : 1
// Bus type       : apb
// Description    : None
// =============================================================================
#ifndef VEC_REGS_DEFINED
#define VEC_REGS_DEFINED
#define VEC_REGS_RWTYPE_MSB 13
#define VEC_REGS_RWTYPE_LSB 12
// =============================================================================
// Register    : VEC_CONTROL
// JTAG access : synchronous
// Description : None
#define VEC_CONTROL_OFFSET 0x00000000
#define VEC_CONTROL_BITS   0x00000007
#define VEC_CONTROL_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_CONTROL_BARS
// Description : Write '1' to display colour bar test pattern
#define VEC_CONTROL_BARS_RESET  0x0
#define VEC_CONTROL_BARS_BITS   0x00000004
#define VEC_CONTROL_BARS_MSB    2
#define VEC_CONTROL_BARS_LSB    2
#define VEC_CONTROL_BARS_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_CONTROL_AUTO_REPEAT
// Description : Write '1' to re-display same frame continuously
#define VEC_CONTROL_AUTO_REPEAT_RESET  0x0
#define VEC_CONTROL_AUTO_REPEAT_BITS   0x00000002
#define VEC_CONTROL_AUTO_REPEAT_MSB    1
#define VEC_CONTROL_AUTO_REPEAT_LSB    1
#define VEC_CONTROL_AUTO_REPEAT_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_CONTROL_START_ARM
// Description : Write '1' before first DMA address is written This bit always
//               reads back as '0'
#define VEC_CONTROL_START_ARM_RESET  0x0
#define VEC_CONTROL_START_ARM_BITS   0x00000001
#define VEC_CONTROL_START_ARM_MSB    0
#define VEC_CONTROL_START_ARM_LSB    0
#define VEC_CONTROL_START_ARM_ACCESS "SC"
// =============================================================================
// Register    : VEC_IRQ_ENABLES
// JTAG access : synchronous
// Description : None
#define VEC_IRQ_ENABLES_OFFSET 0x00000004
#define VEC_IRQ_ENABLES_BITS   0x03ff003f
#define VEC_IRQ_ENABLES_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_ENABLES_MATCH_ROW
// Description : Raster line at which MATCH interrupt is signalled
#define VEC_IRQ_ENABLES_MATCH_ROW_RESET  0x000
#define VEC_IRQ_ENABLES_MATCH_ROW_BITS   0x03ff0000
#define VEC_IRQ_ENABLES_MATCH_ROW_MSB    25
#define VEC_IRQ_ENABLES_MATCH_ROW_LSB    16
#define VEC_IRQ_ENABLES_MATCH_ROW_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_ENABLES_MATCH
// Description : Output raster == match_row reached
#define VEC_IRQ_ENABLES_MATCH_RESET  0x0
#define VEC_IRQ_ENABLES_MATCH_BITS   0x00000020
#define VEC_IRQ_ENABLES_MATCH_MSB    5
#define VEC_IRQ_ENABLES_MATCH_LSB    5
#define VEC_IRQ_ENABLES_MATCH_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_ENABLES_ERROR
// Description : DMA address overwritten before it was taken
#define VEC_IRQ_ENABLES_ERROR_RESET  0x0
#define VEC_IRQ_ENABLES_ERROR_BITS   0x00000010
#define VEC_IRQ_ENABLES_ERROR_MSB    4
#define VEC_IRQ_ENABLES_ERROR_LSB    4
#define VEC_IRQ_ENABLES_ERROR_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_ENABLES_DONE
// Description : Last word sent to DAC after end of video (= all clear)
#define VEC_IRQ_ENABLES_DONE_RESET  0x0
#define VEC_IRQ_ENABLES_DONE_BITS   0x00000008
#define VEC_IRQ_ENABLES_DONE_MSB    3
#define VEC_IRQ_ENABLES_DONE_LSB    3
#define VEC_IRQ_ENABLES_DONE_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_ENABLES_FRAME
// Description : Start of frame
#define VEC_IRQ_ENABLES_FRAME_RESET  0x0
#define VEC_IRQ_ENABLES_FRAME_BITS   0x00000004
#define VEC_IRQ_ENABLES_FRAME_MSB    2
#define VEC_IRQ_ENABLES_FRAME_LSB    2
#define VEC_IRQ_ENABLES_FRAME_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_ENABLES_UNDERFLOW
// Description : Underflow has occurred
#define VEC_IRQ_ENABLES_UNDERFLOW_RESET  0x0
#define VEC_IRQ_ENABLES_UNDERFLOW_BITS   0x00000002
#define VEC_IRQ_ENABLES_UNDERFLOW_MSB    1
#define VEC_IRQ_ENABLES_UNDERFLOW_LSB    1
#define VEC_IRQ_ENABLES_UNDERFLOW_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_ENABLES_DMA
// Description : DMA ready to accept next frame start address
#define VEC_IRQ_ENABLES_DMA_RESET  0x0
#define VEC_IRQ_ENABLES_DMA_BITS   0x00000001
#define VEC_IRQ_ENABLES_DMA_MSB    0
#define VEC_IRQ_ENABLES_DMA_LSB    0
#define VEC_IRQ_ENABLES_DMA_ACCESS "RW"
// =============================================================================
// Register    : VEC_IRQ_FLAGS
// JTAG access : synchronous
// Description : None
#define VEC_IRQ_FLAGS_OFFSET 0x00000008
#define VEC_IRQ_FLAGS_BITS   0x0000003f
#define VEC_IRQ_FLAGS_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_FLAGS_MATCH
// Description : Output raster == match_row reached
#define VEC_IRQ_FLAGS_MATCH_RESET  0x0
#define VEC_IRQ_FLAGS_MATCH_BITS   0x00000020
#define VEC_IRQ_FLAGS_MATCH_MSB    5
#define VEC_IRQ_FLAGS_MATCH_LSB    5
#define VEC_IRQ_FLAGS_MATCH_ACCESS "WC"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_FLAGS_ERROR
// Description : DMA address overwritten before it was taken
#define VEC_IRQ_FLAGS_ERROR_RESET  0x0
#define VEC_IRQ_FLAGS_ERROR_BITS   0x00000010
#define VEC_IRQ_FLAGS_ERROR_MSB    4
#define VEC_IRQ_FLAGS_ERROR_LSB    4
#define VEC_IRQ_FLAGS_ERROR_ACCESS "WC"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_FLAGS_DONE
// Description : Last word sent to DAC after end of video (= all clear)
#define VEC_IRQ_FLAGS_DONE_RESET  0x0
#define VEC_IRQ_FLAGS_DONE_BITS   0x00000008
#define VEC_IRQ_FLAGS_DONE_MSB    3
#define VEC_IRQ_FLAGS_DONE_LSB    3
#define VEC_IRQ_FLAGS_DONE_ACCESS "WC"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_FLAGS_FRAME
// Description : Start of frame
#define VEC_IRQ_FLAGS_FRAME_RESET  0x0
#define VEC_IRQ_FLAGS_FRAME_BITS   0x00000004
#define VEC_IRQ_FLAGS_FRAME_MSB    2
#define VEC_IRQ_FLAGS_FRAME_LSB    2
#define VEC_IRQ_FLAGS_FRAME_ACCESS "WC"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_FLAGS_UNDERFLOW
// Description : Underflow has occurred
#define VEC_IRQ_FLAGS_UNDERFLOW_RESET  0x0
#define VEC_IRQ_FLAGS_UNDERFLOW_BITS   0x00000002
#define VEC_IRQ_FLAGS_UNDERFLOW_MSB    1
#define VEC_IRQ_FLAGS_UNDERFLOW_LSB    1
#define VEC_IRQ_FLAGS_UNDERFLOW_ACCESS "WC"
// -----------------------------------------------------------------------------
// Field       : VEC_IRQ_FLAGS_DMA
// Description : DMA ready to accept next frame start address
#define VEC_IRQ_FLAGS_DMA_RESET  0x0
#define VEC_IRQ_FLAGS_DMA_BITS   0x00000001
#define VEC_IRQ_FLAGS_DMA_MSB    0
#define VEC_IRQ_FLAGS_DMA_LSB    0
#define VEC_IRQ_FLAGS_DMA_ACCESS "WC"
// =============================================================================
// Register    : VEC_QOS
// JTAG access : synchronous
// Description : This register configures panic levels for the AXI ar_qos
//               quality of service field. Panic status is driven by the number
//               of rows held in the SRAM cache:
#define VEC_QOS_OFFSET 0x0000000c
#define VEC_QOS_BITS   0x000fffff
#define VEC_QOS_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_QOS_UQOS
// Description : Upper AXI QOS
#define VEC_QOS_UQOS_RESET  0x0
#define VEC_QOS_UQOS_BITS   0x000f0000
#define VEC_QOS_UQOS_MSB    19
#define VEC_QOS_UQOS_LSB    16
#define VEC_QOS_UQOS_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_QOS_ULEV
// Description : Upper trip level (resolution = 1 / 16 of cache size)
#define VEC_QOS_ULEV_RESET  0x0
#define VEC_QOS_ULEV_BITS   0x0000f000
#define VEC_QOS_ULEV_MSB    15
#define VEC_QOS_ULEV_LSB    12
#define VEC_QOS_ULEV_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_QOS_LQOS
// Description : Lower AXI QOS
#define VEC_QOS_LQOS_RESET  0x0
#define VEC_QOS_LQOS_BITS   0x00000f00
#define VEC_QOS_LQOS_MSB    11
#define VEC_QOS_LQOS_LSB    8
#define VEC_QOS_LQOS_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_QOS_LLEV
// Description : Lower trip level (resolution = 1 / 16 of cache size)
#define VEC_QOS_LLEV_RESET  0x0
#define VEC_QOS_LLEV_BITS   0x000000f0
#define VEC_QOS_LLEV_MSB    7
#define VEC_QOS_LLEV_LSB    4
#define VEC_QOS_LLEV_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_QOS_DQOS
// Description : Default QOS
#define VEC_QOS_DQOS_RESET  0x0
#define VEC_QOS_DQOS_BITS   0x0000000f
#define VEC_QOS_DQOS_MSB    3
#define VEC_QOS_DQOS_LSB    0
#define VEC_QOS_DQOS_ACCESS "RW"
// =============================================================================
// Register    : VEC_DMA_ADDR_L
// JTAG access : synchronous
// Description : Lower 32-bits
#define VEC_DMA_ADDR_L_OFFSET 0x00000010
#define VEC_DMA_ADDR_L_BITS   0xffffffff
#define VEC_DMA_ADDR_L_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DMA_ADDR_L_AXI_ADDR
// Description : Byte address of DMA transfer frame buffer.
#define VEC_DMA_ADDR_L_AXI_ADDR_RESET  0x00000000
#define VEC_DMA_ADDR_L_AXI_ADDR_BITS   0xffffffff
#define VEC_DMA_ADDR_L_AXI_ADDR_MSB    31
#define VEC_DMA_ADDR_L_AXI_ADDR_LSB    0
#define VEC_DMA_ADDR_L_AXI_ADDR_ACCESS "RWF"
// =============================================================================
// Register    : VEC_DMA_STRIDE
// JTAG access : synchronous
// Description : This register sets the line byte stride.
#define VEC_DMA_STRIDE_OFFSET 0x00000014
#define VEC_DMA_STRIDE_BITS   0xffffffff
#define VEC_DMA_STRIDE_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DMA_STRIDE_STRIDE
// Description : Byte stride
#define VEC_DMA_STRIDE_STRIDE_RESET  0x00000000
#define VEC_DMA_STRIDE_STRIDE_BITS   0xffffffff
#define VEC_DMA_STRIDE_STRIDE_MSB    31
#define VEC_DMA_STRIDE_STRIDE_LSB    0
#define VEC_DMA_STRIDE_STRIDE_ACCESS "RW"
// =============================================================================
// Register    : VEC_DMA_AREA
// JTAG access : synchronous
// Description : Interlaced pixel area. See example driver code.
#define VEC_DMA_AREA_OFFSET 0x00000018
#define VEC_DMA_AREA_BITS   0x03ff03ff
#define VEC_DMA_AREA_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DMA_AREA_COLS_MINUS1
// Description : Width
#define VEC_DMA_AREA_COLS_MINUS1_RESET  0x000
#define VEC_DMA_AREA_COLS_MINUS1_BITS   0x03ff0000
#define VEC_DMA_AREA_COLS_MINUS1_MSB    25
#define VEC_DMA_AREA_COLS_MINUS1_LSB    16
#define VEC_DMA_AREA_COLS_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DMA_AREA_ROWS_PER_FIELD_MINUS1
// Description : Lines per field = half of lines per interlaced frame
#define VEC_DMA_AREA_ROWS_PER_FIELD_MINUS1_RESET  0x000
#define VEC_DMA_AREA_ROWS_PER_FIELD_MINUS1_BITS   0x000003ff
#define VEC_DMA_AREA_ROWS_PER_FIELD_MINUS1_MSB    9
#define VEC_DMA_AREA_ROWS_PER_FIELD_MINUS1_LSB    0
#define VEC_DMA_AREA_ROWS_PER_FIELD_MINUS1_ACCESS "RW"
// =============================================================================
// Register    : VEC_YUV_SCALING
// JTAG access : synchronous
// Description : None
#define VEC_YUV_SCALING_OFFSET 0x0000001c
#define VEC_YUV_SCALING_BITS   0x3fffffff
#define VEC_YUV_SCALING_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_YUV_SCALING_U10_SCALE_Y
// Description : Y unsigned scaling factor - 8 binary places
#define VEC_YUV_SCALING_U10_SCALE_Y_RESET  0x000
#define VEC_YUV_SCALING_U10_SCALE_Y_BITS   0x3ff00000
#define VEC_YUV_SCALING_U10_SCALE_Y_MSB    29
#define VEC_YUV_SCALING_U10_SCALE_Y_LSB    20
#define VEC_YUV_SCALING_U10_SCALE_Y_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_YUV_SCALING_S10_SCALE_U
// Description : U signed scaling factor - 8 binary places
#define VEC_YUV_SCALING_S10_SCALE_U_RESET  0x000
#define VEC_YUV_SCALING_S10_SCALE_U_BITS   0x000ffc00
#define VEC_YUV_SCALING_S10_SCALE_U_MSB    19
#define VEC_YUV_SCALING_S10_SCALE_U_LSB    10
#define VEC_YUV_SCALING_S10_SCALE_U_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_YUV_SCALING_S10_SCALE_V
// Description : V signed scaling factor - 8 binary please
#define VEC_YUV_SCALING_S10_SCALE_V_RESET  0x000
#define VEC_YUV_SCALING_S10_SCALE_V_BITS   0x000003ff
#define VEC_YUV_SCALING_S10_SCALE_V_MSB    9
#define VEC_YUV_SCALING_S10_SCALE_V_LSB    0
#define VEC_YUV_SCALING_S10_SCALE_V_ACCESS "RW"
// =============================================================================
// Register    : VEC_BACK_PORCH
// JTAG access : synchronous
// Description : None
#define VEC_BACK_PORCH_OFFSET 0x00000020
#define VEC_BACK_PORCH_BITS   0x03ff03ff
#define VEC_BACK_PORCH_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_BACK_PORCH_HBP_MINUS1
// Description : Horizontal back porch
#define VEC_BACK_PORCH_HBP_MINUS1_RESET  0x000
#define VEC_BACK_PORCH_HBP_MINUS1_BITS   0x03ff0000
#define VEC_BACK_PORCH_HBP_MINUS1_MSB    25
#define VEC_BACK_PORCH_HBP_MINUS1_LSB    16
#define VEC_BACK_PORCH_HBP_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_BACK_PORCH_VBP_MINUS1
// Description : Vertical back porch
#define VEC_BACK_PORCH_VBP_MINUS1_RESET  0x000
#define VEC_BACK_PORCH_VBP_MINUS1_BITS   0x000003ff
#define VEC_BACK_PORCH_VBP_MINUS1_MSB    9
#define VEC_BACK_PORCH_VBP_MINUS1_LSB    0
#define VEC_BACK_PORCH_VBP_MINUS1_ACCESS "RW"
// =============================================================================
// Register    : VEC_FRONT_PORCH
// JTAG access : synchronous
// Description : None
#define VEC_FRONT_PORCH_OFFSET 0x00000024
#define VEC_FRONT_PORCH_BITS   0x03ff03ff
#define VEC_FRONT_PORCH_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_FRONT_PORCH_HFP_MINUS1
// Description : Horizontal front porch
#define VEC_FRONT_PORCH_HFP_MINUS1_RESET  0x000
#define VEC_FRONT_PORCH_HFP_MINUS1_BITS   0x03ff0000
#define VEC_FRONT_PORCH_HFP_MINUS1_MSB    25
#define VEC_FRONT_PORCH_HFP_MINUS1_LSB    16
#define VEC_FRONT_PORCH_HFP_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_FRONT_PORCH_VFP_MINUS1
// Description : Vertical front porch
#define VEC_FRONT_PORCH_VFP_MINUS1_RESET  0x000
#define VEC_FRONT_PORCH_VFP_MINUS1_BITS   0x000003ff
#define VEC_FRONT_PORCH_VFP_MINUS1_MSB    9
#define VEC_FRONT_PORCH_VFP_MINUS1_LSB    0
#define VEC_FRONT_PORCH_VFP_MINUS1_ACCESS "RW"
// =============================================================================
// Register    : VEC_SHIFT
// JTAG access : synchronous
// Description : Positions of R,G,B MS bits in the memory word. Note: due to an
//               unintended red/blue swap, these fields have been renamed since
//               a previous version. There is no functional change.
#define VEC_SHIFT_OFFSET 0x00000028
#define VEC_SHIFT_BITS   0x00007fff
#define VEC_SHIFT_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_SHIFT_SHIFT_R
// Description : Red MSB
#define VEC_SHIFT_SHIFT_R_RESET  0x00
#define VEC_SHIFT_SHIFT_R_BITS   0x00007c00
#define VEC_SHIFT_SHIFT_R_MSB    14
#define VEC_SHIFT_SHIFT_R_LSB    10
#define VEC_SHIFT_SHIFT_R_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_SHIFT_SHIFT_G
// Description : Green MSB
#define VEC_SHIFT_SHIFT_G_RESET  0x00
#define VEC_SHIFT_SHIFT_G_BITS   0x000003e0
#define VEC_SHIFT_SHIFT_G_MSB    9
#define VEC_SHIFT_SHIFT_G_LSB    5
#define VEC_SHIFT_SHIFT_G_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_SHIFT_SHIFT_B
// Description : Blue MSB
#define VEC_SHIFT_SHIFT_B_RESET  0x00
#define VEC_SHIFT_SHIFT_B_BITS   0x0000001f
#define VEC_SHIFT_SHIFT_B_MSB    4
#define VEC_SHIFT_SHIFT_B_LSB    0
#define VEC_SHIFT_SHIFT_B_ACCESS "RW"
// =============================================================================
// Register    : VEC_IMASK
// JTAG access : synchronous
// Description : Masks for R,G,B significant bits, left-justified within 10-bit
//               fields.
#define VEC_IMASK_OFFSET 0x0000002c
#define VEC_IMASK_BITS   0x3fffffff
#define VEC_IMASK_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_IMASK_MASK_R
// Description : Red mask
#define VEC_IMASK_MASK_R_RESET  0x000
#define VEC_IMASK_MASK_R_BITS   0x3ff00000
#define VEC_IMASK_MASK_R_MSB    29
#define VEC_IMASK_MASK_R_LSB    20
#define VEC_IMASK_MASK_R_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IMASK_MASK_G
// Description : Green mask
#define VEC_IMASK_MASK_G_RESET  0x000
#define VEC_IMASK_MASK_G_BITS   0x000ffc00
#define VEC_IMASK_MASK_G_MSB    19
#define VEC_IMASK_MASK_G_LSB    10
#define VEC_IMASK_MASK_G_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_IMASK_MASK_B
// Description : Blue mask
#define VEC_IMASK_MASK_B_RESET  0x000
#define VEC_IMASK_MASK_B_BITS   0x000003ff
#define VEC_IMASK_MASK_B_MSB    9
#define VEC_IMASK_MASK_B_LSB    0
#define VEC_IMASK_MASK_B_ACCESS "RW"
// =============================================================================
// Register    : VEC_MODE
// JTAG access : synchronous
// Description : None
#define VEC_MODE_OFFSET 0x00000030
#define VEC_MODE_BITS   0x01ff003f
#define VEC_MODE_RESET  0x01c00000
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_HIGH_WATER
// Description : ALWAYS WRITE 8'hE0
#define VEC_MODE_HIGH_WATER_RESET  0xe0
#define VEC_MODE_HIGH_WATER_BITS   0x01fe0000
#define VEC_MODE_HIGH_WATER_MSB    24
#define VEC_MODE_HIGH_WATER_LSB    17
#define VEC_MODE_HIGH_WATER_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_ALIGN16
// Description : Data: 0=BYTE aligned; 1=BEAT aligned
#define VEC_MODE_ALIGN16_RESET  0x0
#define VEC_MODE_ALIGN16_BITS   0x00010000
#define VEC_MODE_ALIGN16_MSB    16
#define VEC_MODE_ALIGN16_LSB    16
#define VEC_MODE_ALIGN16_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_VFP_EN
// Description : Enable vertical front porch
#define VEC_MODE_VFP_EN_RESET  0x0
#define VEC_MODE_VFP_EN_BITS   0x00000020
#define VEC_MODE_VFP_EN_MSB    5
#define VEC_MODE_VFP_EN_LSB    5
#define VEC_MODE_VFP_EN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_VBP_EN
// Description : Enable vertical back porch
#define VEC_MODE_VBP_EN_RESET  0x0
#define VEC_MODE_VBP_EN_BITS   0x00000010
#define VEC_MODE_VBP_EN_MSB    4
#define VEC_MODE_VBP_EN_LSB    4
#define VEC_MODE_VBP_EN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_HFP_EN
// Description : Enable horizontal front porch
#define VEC_MODE_HFP_EN_RESET  0x0
#define VEC_MODE_HFP_EN_BITS   0x00000008
#define VEC_MODE_HFP_EN_MSB    3
#define VEC_MODE_HFP_EN_LSB    3
#define VEC_MODE_HFP_EN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_HBP_EN
// Description : Enable horizontal back porch
#define VEC_MODE_HBP_EN_RESET  0x0
#define VEC_MODE_HBP_EN_BITS   0x00000004
#define VEC_MODE_HBP_EN_MSB    2
#define VEC_MODE_HBP_EN_LSB    2
#define VEC_MODE_HBP_EN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_FIELDS_PER_FRAME_MINUS1
// Description : Interlaced / progressive
#define VEC_MODE_FIELDS_PER_FRAME_MINUS1_RESET  0x0
#define VEC_MODE_FIELDS_PER_FRAME_MINUS1_BITS   0x00000002
#define VEC_MODE_FIELDS_PER_FRAME_MINUS1_MSB    1
#define VEC_MODE_FIELDS_PER_FRAME_MINUS1_LSB    1
#define VEC_MODE_FIELDS_PER_FRAME_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_MODE_FIRST_FIELD_ODD
// Description : Interlacing order: odd/even or even/odd
#define VEC_MODE_FIRST_FIELD_ODD_RESET  0x0
#define VEC_MODE_FIRST_FIELD_ODD_BITS   0x00000001
#define VEC_MODE_FIRST_FIELD_ODD_MSB    0
#define VEC_MODE_FIRST_FIELD_ODD_LSB    0
#define VEC_MODE_FIRST_FIELD_ODD_ACCESS "RW"
// =============================================================================
// Register    : VEC_RGBSZ
// JTAG access : synchronous
// Description : None
#define VEC_RGBSZ_OFFSET 0x00000034
#define VEC_RGBSZ_BITS   0x00030fff
#define VEC_RGBSZ_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_RGBSZ_BYTES_PER_PIXEL_MINUS1
// Description : Pixel stride
#define VEC_RGBSZ_BYTES_PER_PIXEL_MINUS1_RESET  0x0
#define VEC_RGBSZ_BYTES_PER_PIXEL_MINUS1_BITS   0x00030000
#define VEC_RGBSZ_BYTES_PER_PIXEL_MINUS1_MSB    17
#define VEC_RGBSZ_BYTES_PER_PIXEL_MINUS1_LSB    16
#define VEC_RGBSZ_BYTES_PER_PIXEL_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_RGBSZ_SCALE_R
// Description : Red number of bits for shift-and-OR scaling
#define VEC_RGBSZ_SCALE_R_RESET  0x0
#define VEC_RGBSZ_SCALE_R_BITS   0x00000f00
#define VEC_RGBSZ_SCALE_R_MSB    11
#define VEC_RGBSZ_SCALE_R_LSB    8
#define VEC_RGBSZ_SCALE_R_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_RGBSZ_SCALE_G
// Description : Green number of bits for shift-and-OR scaling
#define VEC_RGBSZ_SCALE_G_RESET  0x0
#define VEC_RGBSZ_SCALE_G_BITS   0x000000f0
#define VEC_RGBSZ_SCALE_G_MSB    7
#define VEC_RGBSZ_SCALE_G_LSB    4
#define VEC_RGBSZ_SCALE_G_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_RGBSZ_SCALE_B
// Description : Blue number of bits for shift-and-OR scaling
#define VEC_RGBSZ_SCALE_B_RESET  0x0
#define VEC_RGBSZ_SCALE_B_BITS   0x0000000f
#define VEC_RGBSZ_SCALE_B_MSB    3
#define VEC_RGBSZ_SCALE_B_LSB    0
#define VEC_RGBSZ_SCALE_B_ACCESS "RW"
// =============================================================================
// Register    : VEC_PANICS
// JTAG access : synchronous
// Description : None
#define VEC_PANICS_OFFSET 0x00000038
#define VEC_PANICS_BITS   0xffffffff
#define VEC_PANICS_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_PANICS_UCOUNT
// Description : Upper panic count
#define VEC_PANICS_UCOUNT_RESET  0x0000
#define VEC_PANICS_UCOUNT_BITS   0xffff0000
#define VEC_PANICS_UCOUNT_MSB    31
#define VEC_PANICS_UCOUNT_LSB    16
#define VEC_PANICS_UCOUNT_ACCESS "WC"
// -----------------------------------------------------------------------------
// Field       : VEC_PANICS_LCOUNT
// Description : Lower panic count
#define VEC_PANICS_LCOUNT_RESET  0x0000
#define VEC_PANICS_LCOUNT_BITS   0x0000ffff
#define VEC_PANICS_LCOUNT_MSB    15
#define VEC_PANICS_LCOUNT_LSB    0
#define VEC_PANICS_LCOUNT_ACCESS "WC"
// =============================================================================
// Register    : VEC_STATUS
// JTAG access : synchronous
// Description : None
#define VEC_STATUS_OFFSET 0x0000003c
#define VEC_STATUS_BITS   0xff000000
#define VEC_STATUS_RESET  0x0d000000
// -----------------------------------------------------------------------------
// Field       : VEC_STATUS_VERSION
// Description : VEC module version code
#define VEC_STATUS_VERSION_RESET  0x0d
#define VEC_STATUS_VERSION_BITS   0xff000000
#define VEC_STATUS_VERSION_MSB    31
#define VEC_STATUS_VERSION_LSB    24
#define VEC_STATUS_VERSION_ACCESS "RO"
// =============================================================================
// Register    : VEC_DMA_ADDR_H
// JTAG access : synchronous
// Description : Upper 32-bits
#define VEC_DMA_ADDR_H_OFFSET 0x00000040
#define VEC_DMA_ADDR_H_BITS   0xffffffff
#define VEC_DMA_ADDR_H_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DMA_ADDR_H_AXI_ADDR
// Description : Byte address of DMA transfer frame buffer.
#define VEC_DMA_ADDR_H_AXI_ADDR_RESET  0x00000000
#define VEC_DMA_ADDR_H_AXI_ADDR_BITS   0xffffffff
#define VEC_DMA_ADDR_H_AXI_ADDR_MSB    31
#define VEC_DMA_ADDR_H_AXI_ADDR_LSB    0
#define VEC_DMA_ADDR_H_AXI_ADDR_ACCESS "RW"
// =============================================================================
// Register    : VEC_BURST_ADDR_L
// JTAG access : synchronous
// Description : None
#define VEC_BURST_ADDR_L_OFFSET 0x00000044
#define VEC_BURST_ADDR_L_BITS   0xffffffff
#define VEC_BURST_ADDR_L_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_BURST_ADDR_L_BURST_ADDR
// Description : the lower 32-bits of the most recent read request sent to AXI
//               memory.
#define VEC_BURST_ADDR_L_BURST_ADDR_RESET  0x00000000
#define VEC_BURST_ADDR_L_BURST_ADDR_BITS   0xffffffff
#define VEC_BURST_ADDR_L_BURST_ADDR_MSB    31
#define VEC_BURST_ADDR_L_BURST_ADDR_LSB    0
#define VEC_BURST_ADDR_L_BURST_ADDR_ACCESS "RO"
// =============================================================================
// Register    : VEC_APB_TIMEOUT
// JTAG access : synchronous
// Description : None
#define VEC_APB_TIMEOUT_OFFSET 0x00000048
#define VEC_APB_TIMEOUT_BITS   0x000103ff
#define VEC_APB_TIMEOUT_RESET  0x00000014
// -----------------------------------------------------------------------------
// Field       : VEC_APB_TIMEOUT_SLVERR_EN
// Description : 1 = Assert PREADY and PSLVERR on timeout 0 = Assert PREADY only
#define VEC_APB_TIMEOUT_SLVERR_EN_RESET  0x0
#define VEC_APB_TIMEOUT_SLVERR_EN_BITS   0x00010000
#define VEC_APB_TIMEOUT_SLVERR_EN_MSB    16
#define VEC_APB_TIMEOUT_SLVERR_EN_LSB    16
#define VEC_APB_TIMEOUT_SLVERR_EN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_APB_TIMEOUT_TIMEOUT
// Description : Maximum AXI clock cycles to wait for responses from DAC clock
//               domain APB block
#define VEC_APB_TIMEOUT_TIMEOUT_RESET  0x014
#define VEC_APB_TIMEOUT_TIMEOUT_BITS   0x000003ff
#define VEC_APB_TIMEOUT_TIMEOUT_MSB    9
#define VEC_APB_TIMEOUT_TIMEOUT_LSB    0
#define VEC_APB_TIMEOUT_TIMEOUT_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_80
// JTAG access : synchronous
// Description : None
#define VEC_DAC_80_OFFSET 0x00000080
#define VEC_DAC_80_BITS   0x3fff3fff
#define VEC_DAC_80_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_80_U14_DE_BGN
// Description : Beginning of active data enable within each visible line
#define VEC_DAC_80_U14_DE_BGN_RESET  0x0000
#define VEC_DAC_80_U14_DE_BGN_BITS   0x3fff0000
#define VEC_DAC_80_U14_DE_BGN_MSB    29
#define VEC_DAC_80_U14_DE_BGN_LSB    16
#define VEC_DAC_80_U14_DE_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_80_U14_DE_END
// Description : End of active data enable within each visible line
#define VEC_DAC_80_U14_DE_END_RESET  0x0000
#define VEC_DAC_80_U14_DE_END_BITS   0x00003fff
#define VEC_DAC_80_U14_DE_END_MSB    13
#define VEC_DAC_80_U14_DE_END_LSB    0
#define VEC_DAC_80_U14_DE_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_84
// JTAG access : synchronous
// Description : None
#define VEC_DAC_84_OFFSET 0x00000084
#define VEC_DAC_84_BITS   0x1fff1fff
#define VEC_DAC_84_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_84_U13_ACTIVE_RISE
// Description : Horizontal blanking interval
#define VEC_DAC_84_U13_ACTIVE_RISE_RESET  0x0000
#define VEC_DAC_84_U13_ACTIVE_RISE_BITS   0x1fff0000
#define VEC_DAC_84_U13_ACTIVE_RISE_MSB    28
#define VEC_DAC_84_U13_ACTIVE_RISE_LSB    16
#define VEC_DAC_84_U13_ACTIVE_RISE_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_84_U13_ACTIVE_FALL
// Description : Horizontal blanking interval
#define VEC_DAC_84_U13_ACTIVE_FALL_RESET  0x0000
#define VEC_DAC_84_U13_ACTIVE_FALL_BITS   0x00001fff
#define VEC_DAC_84_U13_ACTIVE_FALL_MSB    12
#define VEC_DAC_84_U13_ACTIVE_FALL_LSB    0
#define VEC_DAC_84_U13_ACTIVE_FALL_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_88
// JTAG access : synchronous
// Description : None
#define VEC_DAC_88_OFFSET 0x00000088
#define VEC_DAC_88_BITS   0x1fff1fff
#define VEC_DAC_88_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_88_U13_HALF_LINE_PERIOD
// Description : Ratio of DAC clock to horizontal line rate, halved
#define VEC_DAC_88_U13_HALF_LINE_PERIOD_RESET  0x0000
#define VEC_DAC_88_U13_HALF_LINE_PERIOD_BITS   0x1fff0000
#define VEC_DAC_88_U13_HALF_LINE_PERIOD_MSB    28
#define VEC_DAC_88_U13_HALF_LINE_PERIOD_LSB    16
#define VEC_DAC_88_U13_HALF_LINE_PERIOD_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_88_U13_HORZ_SYNC
// Description : Width of horizontal sync pulses
#define VEC_DAC_88_U13_HORZ_SYNC_RESET  0x0000
#define VEC_DAC_88_U13_HORZ_SYNC_BITS   0x00001fff
#define VEC_DAC_88_U13_HORZ_SYNC_MSB    12
#define VEC_DAC_88_U13_HORZ_SYNC_LSB    0
#define VEC_DAC_88_U13_HORZ_SYNC_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_8C
// JTAG access : synchronous
// Description : None
#define VEC_DAC_8C_OFFSET 0x0000008c
#define VEC_DAC_8C_BITS   0x1fff1fff
#define VEC_DAC_8C_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_8C_U13_BURST_RISE
// Description : Start of raised-cosine colour burst envelope
#define VEC_DAC_8C_U13_BURST_RISE_RESET  0x0000
#define VEC_DAC_8C_U13_BURST_RISE_BITS   0x1fff0000
#define VEC_DAC_8C_U13_BURST_RISE_MSB    28
#define VEC_DAC_8C_U13_BURST_RISE_LSB    16
#define VEC_DAC_8C_U13_BURST_RISE_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_8C_U13_BURST_FALL
// Description : End of raised-cosine colour burst envelope
#define VEC_DAC_8C_U13_BURST_FALL_RESET  0x0000
#define VEC_DAC_8C_U13_BURST_FALL_BITS   0x00001fff
#define VEC_DAC_8C_U13_BURST_FALL_MSB    12
#define VEC_DAC_8C_U13_BURST_FALL_LSB    0
#define VEC_DAC_8C_U13_BURST_FALL_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_90
// JTAG access : synchronous
// Description : None
#define VEC_DAC_90_OFFSET 0x00000090
#define VEC_DAC_90_BITS   0x1fff3fff
#define VEC_DAC_90_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_90_U13_VERT_EQ
// Description : Width of vertical equalisation pulses (= half line minus
//               serration)
#define VEC_DAC_90_U13_VERT_EQ_RESET  0x0000
#define VEC_DAC_90_U13_VERT_EQ_BITS   0x1fff0000
#define VEC_DAC_90_U13_VERT_EQ_MSB    28
#define VEC_DAC_90_U13_VERT_EQ_LSB    16
#define VEC_DAC_90_U13_VERT_EQ_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_90_U14_VERT_SYNC
// Description : Width of vertical sync pulses
#define VEC_DAC_90_U14_VERT_SYNC_RESET  0x0000
#define VEC_DAC_90_U14_VERT_SYNC_BITS   0x00003fff
#define VEC_DAC_90_U14_VERT_SYNC_MSB    13
#define VEC_DAC_90_U14_VERT_SYNC_LSB    0
#define VEC_DAC_90_U14_VERT_SYNC_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_94
// JTAG access : synchronous
// Description : None
#define VEC_DAC_94_OFFSET 0x00000094
#define VEC_DAC_94_BITS   0x03ff03ff
#define VEC_DAC_94_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_94_U10_PRE_EQ_BGN
// Description : Half-lines, inclusive, relative to field datum, where vertical
//               pre-equalisation pulses start
#define VEC_DAC_94_U10_PRE_EQ_BGN_RESET  0x000
#define VEC_DAC_94_U10_PRE_EQ_BGN_BITS   0x03ff0000
#define VEC_DAC_94_U10_PRE_EQ_BGN_MSB    25
#define VEC_DAC_94_U10_PRE_EQ_BGN_LSB    16
#define VEC_DAC_94_U10_PRE_EQ_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_94_U10_PRE_EQ_END
// Description : Half-lines, inclusive, relative to field datum, where vertical
//               pre-equalisation pulses end
#define VEC_DAC_94_U10_PRE_EQ_END_RESET  0x000
#define VEC_DAC_94_U10_PRE_EQ_END_BITS   0x000003ff
#define VEC_DAC_94_U10_PRE_EQ_END_MSB    9
#define VEC_DAC_94_U10_PRE_EQ_END_LSB    0
#define VEC_DAC_94_U10_PRE_EQ_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_98
// JTAG access : synchronous
// Description : None
#define VEC_DAC_98_OFFSET 0x00000098
#define VEC_DAC_98_BITS   0x03ff03ff
#define VEC_DAC_98_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_98_U10_FIELD_SYNC_BGN
// Description : Half-lines containing vertical sync pulses (inclusive)
#define VEC_DAC_98_U10_FIELD_SYNC_BGN_RESET  0x000
#define VEC_DAC_98_U10_FIELD_SYNC_BGN_BITS   0x03ff0000
#define VEC_DAC_98_U10_FIELD_SYNC_BGN_MSB    25
#define VEC_DAC_98_U10_FIELD_SYNC_BGN_LSB    16
#define VEC_DAC_98_U10_FIELD_SYNC_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_98_U10_FIELD_SYNC_END
// Description : Half-lines containing vertical sync pulses (inclusive)
#define VEC_DAC_98_U10_FIELD_SYNC_END_RESET  0x000
#define VEC_DAC_98_U10_FIELD_SYNC_END_BITS   0x000003ff
#define VEC_DAC_98_U10_FIELD_SYNC_END_MSB    9
#define VEC_DAC_98_U10_FIELD_SYNC_END_LSB    0
#define VEC_DAC_98_U10_FIELD_SYNC_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_9C
// JTAG access : synchronous
// Description : None
#define VEC_DAC_9C_OFFSET 0x0000009c
#define VEC_DAC_9C_BITS   0x03ff03ff
#define VEC_DAC_9C_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_9C_U10_POST_EQ_BGN
// Description : Half-lines containing vertical post-equalisation pulses
#define VEC_DAC_9C_U10_POST_EQ_BGN_RESET  0x000
#define VEC_DAC_9C_U10_POST_EQ_BGN_BITS   0x03ff0000
#define VEC_DAC_9C_U10_POST_EQ_BGN_MSB    25
#define VEC_DAC_9C_U10_POST_EQ_BGN_LSB    16
#define VEC_DAC_9C_U10_POST_EQ_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_9C_U10_POST_EQ_END
// Description : Half-lines containing vertical post-equalisation pulses
#define VEC_DAC_9C_U10_POST_EQ_END_RESET  0x000
#define VEC_DAC_9C_U10_POST_EQ_END_BITS   0x000003ff
#define VEC_DAC_9C_U10_POST_EQ_END_MSB    9
#define VEC_DAC_9C_U10_POST_EQ_END_LSB    0
#define VEC_DAC_9C_U10_POST_EQ_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_A0
// JTAG access : synchronous
// Description : None
#define VEC_DAC_A0_OFFSET 0x000000a0
#define VEC_DAC_A0_BITS   0x03ff03ff
#define VEC_DAC_A0_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_A0_U10_FLD1_BURST_BGN
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_A0_U10_FLD1_BURST_BGN_RESET  0x000
#define VEC_DAC_A0_U10_FLD1_BURST_BGN_BITS   0x03ff0000
#define VEC_DAC_A0_U10_FLD1_BURST_BGN_MSB    25
#define VEC_DAC_A0_U10_FLD1_BURST_BGN_LSB    16
#define VEC_DAC_A0_U10_FLD1_BURST_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_A0_U10_FLD1_BURST_END
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_A0_U10_FLD1_BURST_END_RESET  0x000
#define VEC_DAC_A0_U10_FLD1_BURST_END_BITS   0x000003ff
#define VEC_DAC_A0_U10_FLD1_BURST_END_MSB    9
#define VEC_DAC_A0_U10_FLD1_BURST_END_LSB    0
#define VEC_DAC_A0_U10_FLD1_BURST_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_A4
// JTAG access : synchronous
// Description : None
#define VEC_DAC_A4_OFFSET 0x000000a4
#define VEC_DAC_A4_BITS   0x03ff03ff
#define VEC_DAC_A4_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_A4_U10_FLD2_BURST_BGN
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_A4_U10_FLD2_BURST_BGN_RESET  0x000
#define VEC_DAC_A4_U10_FLD2_BURST_BGN_BITS   0x03ff0000
#define VEC_DAC_A4_U10_FLD2_BURST_BGN_MSB    25
#define VEC_DAC_A4_U10_FLD2_BURST_BGN_LSB    16
#define VEC_DAC_A4_U10_FLD2_BURST_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_A4_U10_FLD2_BURST_END
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_A4_U10_FLD2_BURST_END_RESET  0x000
#define VEC_DAC_A4_U10_FLD2_BURST_END_BITS   0x000003ff
#define VEC_DAC_A4_U10_FLD2_BURST_END_MSB    9
#define VEC_DAC_A4_U10_FLD2_BURST_END_LSB    0
#define VEC_DAC_A4_U10_FLD2_BURST_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_A8
// JTAG access : synchronous
// Description : None
#define VEC_DAC_A8_OFFSET 0x000000a8
#define VEC_DAC_A8_BITS   0x03ff03ff
#define VEC_DAC_A8_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_A8_U10_FLD3_BURST_BGN
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_A8_U10_FLD3_BURST_BGN_RESET  0x000
#define VEC_DAC_A8_U10_FLD3_BURST_BGN_BITS   0x03ff0000
#define VEC_DAC_A8_U10_FLD3_BURST_BGN_MSB    25
#define VEC_DAC_A8_U10_FLD3_BURST_BGN_LSB    16
#define VEC_DAC_A8_U10_FLD3_BURST_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_A8_U10_FLD3_BURST_END
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_A8_U10_FLD3_BURST_END_RESET  0x000
#define VEC_DAC_A8_U10_FLD3_BURST_END_BITS   0x000003ff
#define VEC_DAC_A8_U10_FLD3_BURST_END_MSB    9
#define VEC_DAC_A8_U10_FLD3_BURST_END_LSB    0
#define VEC_DAC_A8_U10_FLD3_BURST_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_AC
// JTAG access : synchronous
// Description : None
#define VEC_DAC_AC_OFFSET 0x000000ac
#define VEC_DAC_AC_BITS   0x03ff03ff
#define VEC_DAC_AC_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_AC_U10_FLD4_BURST_BGN
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_AC_U10_FLD4_BURST_BGN_RESET  0x000
#define VEC_DAC_AC_U10_FLD4_BURST_BGN_BITS   0x03ff0000
#define VEC_DAC_AC_U10_FLD4_BURST_BGN_MSB    25
#define VEC_DAC_AC_U10_FLD4_BURST_BGN_LSB    16
#define VEC_DAC_AC_U10_FLD4_BURST_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_AC_U10_FLD4_BURST_END
// Description : First and last full frame lines (1-based numbering) within the
//               PAL/NTSC four field sequence which require a colour burst
#define VEC_DAC_AC_U10_FLD4_BURST_END_RESET  0x000
#define VEC_DAC_AC_U10_FLD4_BURST_END_BITS   0x000003ff
#define VEC_DAC_AC_U10_FLD4_BURST_END_MSB    9
#define VEC_DAC_AC_U10_FLD4_BURST_END_LSB    0
#define VEC_DAC_AC_U10_FLD4_BURST_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_B0
// JTAG access : synchronous
// Description : None
#define VEC_DAC_B0_OFFSET 0x000000b0
#define VEC_DAC_B0_BITS   0x03ff03ff
#define VEC_DAC_B0_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_B0_U10_FLD24_FULL_LINE_BGN
// Description : First and last full visible lines (1-based numbering) in the
//               PAL/NTSC four field sequence
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_BGN_RESET  0x000
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_BGN_BITS   0x03ff0000
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_BGN_MSB    25
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_BGN_LSB    16
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_B0_U10_FLD24_FULL_LINE_END
// Description : First and last full visible lines (1-based numbering) in the
//               PAL/NTSC four field sequence
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_END_RESET  0x000
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_END_BITS   0x000003ff
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_END_MSB    9
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_END_LSB    0
#define VEC_DAC_B0_U10_FLD24_FULL_LINE_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_B4
// JTAG access : synchronous
// Description : None
#define VEC_DAC_B4_OFFSET 0x000000b4
#define VEC_DAC_B4_BITS   0x03ff03ff
#define VEC_DAC_B4_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_B4_U10_FLD13_FULL_LINE_BGN
// Description : First and last full visible lines (1-based numbering) in the
//               PAL/NTSC four field sequence
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_BGN_RESET  0x000
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_BGN_BITS   0x03ff0000
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_BGN_MSB    25
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_BGN_LSB    16
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_BGN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_B4_U10_FLD13_FULL_LINE_END
// Description : First and last full visible lines (1-based numbering) in the
//               PAL/NTSC four field sequence
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_END_RESET  0x000
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_END_BITS   0x000003ff
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_END_MSB    9
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_END_LSB    0
#define VEC_DAC_B4_U10_FLD13_FULL_LINE_END_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_B8
// JTAG access : synchronous
// Description : None
#define VEC_DAC_B8_OFFSET 0x000000b8
#define VEC_DAC_B8_BITS   0x03ff03ff
#define VEC_DAC_B8_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_B8_U10_BOT_HALF_LINE
// Description : Top and bottom visible half-lines in 1-based standard full
//               frame numbering, for interlaced modes. Set to zero to disable.
#define VEC_DAC_B8_U10_BOT_HALF_LINE_RESET  0x000
#define VEC_DAC_B8_U10_BOT_HALF_LINE_BITS   0x03ff0000
#define VEC_DAC_B8_U10_BOT_HALF_LINE_MSB    25
#define VEC_DAC_B8_U10_BOT_HALF_LINE_LSB    16
#define VEC_DAC_B8_U10_BOT_HALF_LINE_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_B8_U10_TOP_HALF_LINE
// Description : Top and bottom visible half-lines in 1-based standard full
//               frame numbering, for interlaced modes. Set to zero to disable.
#define VEC_DAC_B8_U10_TOP_HALF_LINE_RESET  0x000
#define VEC_DAC_B8_U10_TOP_HALF_LINE_BITS   0x000003ff
#define VEC_DAC_B8_U10_TOP_HALF_LINE_MSB    9
#define VEC_DAC_B8_U10_TOP_HALF_LINE_LSB    0
#define VEC_DAC_B8_U10_TOP_HALF_LINE_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_BC
// JTAG access : synchronous
// Description : None
#define VEC_DAC_BC_OFFSET 0x000000bc
#define VEC_DAC_BC_BITS   0x07ff07ff
#define VEC_DAC_BC_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_BC_S11_PEDESTAL
// Description : NTSC pedestal. For 7.5 IRE, this field is 1024 * 7.5/100. For
//               PAL, or Japanese NTSC, this field should be zero.
#define VEC_DAC_BC_S11_PEDESTAL_RESET  0x000
#define VEC_DAC_BC_S11_PEDESTAL_BITS   0x07ff0000
#define VEC_DAC_BC_S11_PEDESTAL_MSB    26
#define VEC_DAC_BC_S11_PEDESTAL_LSB    16
#define VEC_DAC_BC_S11_PEDESTAL_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_BC_U11_HALF_LINES_PER_FIELD
// Description : Mode = 625 PAL, Lines per field = 312.5,
//               u11_half_lines_per_field = 1+2*312 Mode = 525 NTSC, Lines per
//               field = 262.5, u11_half_lines_per_field = 1+2*262
#define VEC_DAC_BC_U11_HALF_LINES_PER_FIELD_RESET  0x000
#define VEC_DAC_BC_U11_HALF_LINES_PER_FIELD_BITS   0x000007ff
#define VEC_DAC_BC_U11_HALF_LINES_PER_FIELD_MSB    10
#define VEC_DAC_BC_U11_HALF_LINES_PER_FIELD_LSB    0
#define VEC_DAC_BC_U11_HALF_LINES_PER_FIELD_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_C0
// JTAG access : synchronous
// Description : Synopsis DesignWare control
#define VEC_DAC_C0_OFFSET 0x000000c0
#define VEC_DAC_C0_BITS   0x000fffff
#define VEC_DAC_C0_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C0_DWC_CABLE_ENCTR3
// Description : Synopsis test input
#define VEC_DAC_C0_DWC_CABLE_ENCTR3_RESET  0x0
#define VEC_DAC_C0_DWC_CABLE_ENCTR3_BITS   0x00080000
#define VEC_DAC_C0_DWC_CABLE_ENCTR3_MSB    19
#define VEC_DAC_C0_DWC_CABLE_ENCTR3_LSB    19
#define VEC_DAC_C0_DWC_CABLE_ENCTR3_ACCESS "RO"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C0_DWC_CABLE_CABLEOUT
// Description : cable detect state
#define VEC_DAC_C0_DWC_CABLE_CABLEOUT_RESET  0x0
#define VEC_DAC_C0_DWC_CABLE_CABLEOUT_BITS   0x00070000
#define VEC_DAC_C0_DWC_CABLE_CABLEOUT_MSB    18
#define VEC_DAC_C0_DWC_CABLE_CABLEOUT_LSB    16
#define VEC_DAC_C0_DWC_CABLE_CABLEOUT_ACCESS "RO"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C0_DWC_MUX_2
// Description : Select DAC channel 2 output
#define VEC_DAC_C0_DWC_MUX_2_RESET  0x0
#define VEC_DAC_C0_DWC_MUX_2_BITS   0x0000c000
#define VEC_DAC_C0_DWC_MUX_2_MSB    15
#define VEC_DAC_C0_DWC_MUX_2_LSB    14
#define VEC_DAC_C0_DWC_MUX_2_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C0_DWC_MUX_1
// Description : Select DAC channel 1 output
#define VEC_DAC_C0_DWC_MUX_1_RESET  0x0
#define VEC_DAC_C0_DWC_MUX_1_BITS   0x00003000
#define VEC_DAC_C0_DWC_MUX_1_MSB    13
#define VEC_DAC_C0_DWC_MUX_1_LSB    12
#define VEC_DAC_C0_DWC_MUX_1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C0_DWC_MUX_0
// Description : Select DAC channel 0 output
#define VEC_DAC_C0_DWC_MUX_0_RESET  0x0
#define VEC_DAC_C0_DWC_MUX_0_BITS   0x00000c00
#define VEC_DAC_C0_DWC_MUX_0_MSB    11
#define VEC_DAC_C0_DWC_MUX_0_LSB    10
#define VEC_DAC_C0_DWC_MUX_0_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C0_DWC_TEST
// Description : Fixed DAC command word
#define VEC_DAC_C0_DWC_TEST_RESET  0x000
#define VEC_DAC_C0_DWC_TEST_BITS   0x000003ff
#define VEC_DAC_C0_DWC_TEST_MSB    9
#define VEC_DAC_C0_DWC_TEST_LSB    0
#define VEC_DAC_C0_DWC_TEST_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_C4
// JTAG access : synchronous
// Description : Synopsis DAC control
#define VEC_DAC_C4_OFFSET 0x000000c4
#define VEC_DAC_C4_BITS   0x1fffffff
#define VEC_DAC_C4_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_ENCTR
// Description : Always write3'b000
#define VEC_DAC_C4_ENCTR_RESET  0x0
#define VEC_DAC_C4_ENCTR_BITS   0x1c000000
#define VEC_DAC_C4_ENCTR_MSB    28
#define VEC_DAC_C4_ENCTR_LSB    26
#define VEC_DAC_C4_ENCTR_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_ENSC
// Description : Enable cable detect - write 3'b000
#define VEC_DAC_C4_ENSC_RESET  0x0
#define VEC_DAC_C4_ENSC_BITS   0x03800000
#define VEC_DAC_C4_ENSC_MSB    25
#define VEC_DAC_C4_ENSC_LSB    23
#define VEC_DAC_C4_ENSC_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_ENDAC
// Description : Enable DAC channel
#define VEC_DAC_C4_ENDAC_RESET  0x0
#define VEC_DAC_C4_ENDAC_BITS   0x00700000
#define VEC_DAC_C4_ENDAC_MSB    22
#define VEC_DAC_C4_ENDAC_LSB    20
#define VEC_DAC_C4_ENDAC_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_ENVBG
// Description : Enable internal bandgap reference - write '1'
#define VEC_DAC_C4_ENVBG_RESET  0x0
#define VEC_DAC_C4_ENVBG_BITS   0x00080000
#define VEC_DAC_C4_ENVBG_MSB    19
#define VEC_DAC_C4_ENVBG_LSB    19
#define VEC_DAC_C4_ENVBG_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_ENEXTREF
// Description : Enable external reference - write '0'
#define VEC_DAC_C4_ENEXTREF_RESET  0x0
#define VEC_DAC_C4_ENEXTREF_BITS   0x00040000
#define VEC_DAC_C4_ENEXTREF_MSB    18
#define VEC_DAC_C4_ENEXTREF_LSB    18
#define VEC_DAC_C4_ENEXTREF_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_DAC2GC
// Description : DAC channel 2 gain control - write 6'd63
#define VEC_DAC_C4_DAC2GC_RESET  0x00
#define VEC_DAC_C4_DAC2GC_BITS   0x0003f000
#define VEC_DAC_C4_DAC2GC_MSB    17
#define VEC_DAC_C4_DAC2GC_LSB    12
#define VEC_DAC_C4_DAC2GC_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_DAC1GC
// Description : DAC channel 1 gain control - write 6'd63
#define VEC_DAC_C4_DAC1GC_RESET  0x00
#define VEC_DAC_C4_DAC1GC_BITS   0x00000fc0
#define VEC_DAC_C4_DAC1GC_MSB    11
#define VEC_DAC_C4_DAC1GC_LSB    6
#define VEC_DAC_C4_DAC1GC_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C4_DAC0GC
// Description : DAC channel 0 gain control - write 6'd63
#define VEC_DAC_C4_DAC0GC_RESET  0x00
#define VEC_DAC_C4_DAC0GC_BITS   0x0000003f
#define VEC_DAC_C4_DAC0GC_MSB    5
#define VEC_DAC_C4_DAC0GC_LSB    0
#define VEC_DAC_C4_DAC0GC_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_C8
// JTAG access : synchronous
// Description : None
#define VEC_DAC_C8_OFFSET 0x000000c8
#define VEC_DAC_C8_BITS   0xffffffff
#define VEC_DAC_C8_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C8_U16_SCALE_SYNC
// Description : Scaling applied prior to final summation to form the DAC
//               command word(s)
#define VEC_DAC_C8_U16_SCALE_SYNC_RESET  0x0000
#define VEC_DAC_C8_U16_SCALE_SYNC_BITS   0xffff0000
#define VEC_DAC_C8_U16_SCALE_SYNC_MSB    31
#define VEC_DAC_C8_U16_SCALE_SYNC_LSB    16
#define VEC_DAC_C8_U16_SCALE_SYNC_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_C8_U16_SCALE_LUMA
// Description : Scaling applied prior to final summation to form the DAC
//               command word(s)
#define VEC_DAC_C8_U16_SCALE_LUMA_RESET  0x0000
#define VEC_DAC_C8_U16_SCALE_LUMA_BITS   0x0000ffff
#define VEC_DAC_C8_U16_SCALE_LUMA_MSB    15
#define VEC_DAC_C8_U16_SCALE_LUMA_LSB    0
#define VEC_DAC_C8_U16_SCALE_LUMA_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_CC
// JTAG access : synchronous
// Description : None
#define VEC_DAC_CC_OFFSET 0x000000cc
#define VEC_DAC_CC_BITS   0xffffffff
#define VEC_DAC_CC_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_CC_S16_SCALE_BURST
// Description : Scaling applied prior to final summation to form the DAC
//               command word(s)
#define VEC_DAC_CC_S16_SCALE_BURST_RESET  0x0000
#define VEC_DAC_CC_S16_SCALE_BURST_BITS   0xffff0000
#define VEC_DAC_CC_S16_SCALE_BURST_MSB    31
#define VEC_DAC_CC_S16_SCALE_BURST_LSB    16
#define VEC_DAC_CC_S16_SCALE_BURST_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_CC_S16_SCALE_CHROMA
// Description : Scaling applied prior to final summation to form the DAC
//               command word(s)
#define VEC_DAC_CC_S16_SCALE_CHROMA_RESET  0x0000
#define VEC_DAC_CC_S16_SCALE_CHROMA_BITS   0x0000ffff
#define VEC_DAC_CC_S16_SCALE_CHROMA_MSB    15
#define VEC_DAC_CC_S16_SCALE_CHROMA_LSB    0
#define VEC_DAC_CC_S16_SCALE_CHROMA_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_D0
// JTAG access : synchronous
// Description : None
#define VEC_DAC_D0_OFFSET 0x000000d0
#define VEC_DAC_D0_BITS   0xffffffff
#define VEC_DAC_D0_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_D0_S16_OFFSET_LUMA
// Description : These offsets are applied to the chroma and luma channels
//               before the final MUX
#define VEC_DAC_D0_S16_OFFSET_LUMA_RESET  0x0000
#define VEC_DAC_D0_S16_OFFSET_LUMA_BITS   0xffff0000
#define VEC_DAC_D0_S16_OFFSET_LUMA_MSB    31
#define VEC_DAC_D0_S16_OFFSET_LUMA_LSB    16
#define VEC_DAC_D0_S16_OFFSET_LUMA_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_D0_S16_OFFSET_CHRO
// Description : These offsets are applied to the chroma and luma channels
//               before the final MUX
#define VEC_DAC_D0_S16_OFFSET_CHRO_RESET  0x0000
#define VEC_DAC_D0_S16_OFFSET_CHRO_BITS   0x0000ffff
#define VEC_DAC_D0_S16_OFFSET_CHRO_MSB    15
#define VEC_DAC_D0_S16_OFFSET_CHRO_LSB    0
#define VEC_DAC_D0_S16_OFFSET_CHRO_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_D4
// JTAG access : synchronous
// Description : None
#define VEC_DAC_D4_OFFSET 0x000000d4
#define VEC_DAC_D4_BITS   0xffffffff
#define VEC_DAC_D4_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_D4_NCO_FREQ
// Description : This 64-bit frequency command is applied to the phase
//               accumulator of the NCO (numerically controlled oscillator)
//               which generates the colour sub-carrier. This value is computed
//               as ratio of sub-carrier frequency to DAC clock multiplied by
//               2^64.
#define VEC_DAC_D4_NCO_FREQ_RESET  0x00000000
#define VEC_DAC_D4_NCO_FREQ_BITS   0xffffffff
#define VEC_DAC_D4_NCO_FREQ_MSB    31
#define VEC_DAC_D4_NCO_FREQ_LSB    0
#define VEC_DAC_D4_NCO_FREQ_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_D8
// JTAG access : synchronous
// Description : None
#define VEC_DAC_D8_OFFSET 0x000000d8
#define VEC_DAC_D8_BITS   0xffffffff
#define VEC_DAC_D8_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_D8_NCO_FREQ
// Description : This 64-bit frequency command is applied to the phase
//               accumulator of the NCO (numerically controlled oscillator)
//               which generates the colour sub-carrier. This value is computed
//               as ratio of sub-carrier frequency to DAC clock multiplied by
//               2^64.
#define VEC_DAC_D8_NCO_FREQ_RESET  0x00000000
#define VEC_DAC_D8_NCO_FREQ_BITS   0xffffffff
#define VEC_DAC_D8_NCO_FREQ_MSB    31
#define VEC_DAC_D8_NCO_FREQ_LSB    0
#define VEC_DAC_D8_NCO_FREQ_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_DC
// JTAG access : synchronous
// Description : None
#define VEC_DAC_DC_OFFSET 0x000000dc
#define VEC_DAC_DC_BITS   0xffffffff
#define VEC_DAC_DC_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_DC_FIR_COEFF_CHROMA_0_6
// Description : FIR filter coefficients
#define VEC_DAC_DC_FIR_COEFF_CHROMA_0_6_RESET  0x0000
#define VEC_DAC_DC_FIR_COEFF_CHROMA_0_6_BITS   0xffff0000
#define VEC_DAC_DC_FIR_COEFF_CHROMA_0_6_MSB    31
#define VEC_DAC_DC_FIR_COEFF_CHROMA_0_6_LSB    16
#define VEC_DAC_DC_FIR_COEFF_CHROMA_0_6_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_DC_FIR_COEFF_LUMA_0_6
// Description : FIR filter coefficients
#define VEC_DAC_DC_FIR_COEFF_LUMA_0_6_RESET  0x0000
#define VEC_DAC_DC_FIR_COEFF_LUMA_0_6_BITS   0x0000ffff
#define VEC_DAC_DC_FIR_COEFF_LUMA_0_6_MSB    15
#define VEC_DAC_DC_FIR_COEFF_LUMA_0_6_LSB    0
#define VEC_DAC_DC_FIR_COEFF_LUMA_0_6_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_E0
// JTAG access : synchronous
// Description : None
#define VEC_DAC_E0_OFFSET 0x000000e0
#define VEC_DAC_E0_BITS   0xffffffff
#define VEC_DAC_E0_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_E0_FIR_COEFF_CHROMA_1_5
// Description : FIR filter coefficients
#define VEC_DAC_E0_FIR_COEFF_CHROMA_1_5_RESET  0x0000
#define VEC_DAC_E0_FIR_COEFF_CHROMA_1_5_BITS   0xffff0000
#define VEC_DAC_E0_FIR_COEFF_CHROMA_1_5_MSB    31
#define VEC_DAC_E0_FIR_COEFF_CHROMA_1_5_LSB    16
#define VEC_DAC_E0_FIR_COEFF_CHROMA_1_5_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_E0_FIR_COEFF_LUMA_1_5
// Description : FIR filter coefficients
#define VEC_DAC_E0_FIR_COEFF_LUMA_1_5_RESET  0x0000
#define VEC_DAC_E0_FIR_COEFF_LUMA_1_5_BITS   0x0000ffff
#define VEC_DAC_E0_FIR_COEFF_LUMA_1_5_MSB    15
#define VEC_DAC_E0_FIR_COEFF_LUMA_1_5_LSB    0
#define VEC_DAC_E0_FIR_COEFF_LUMA_1_5_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_E4
// JTAG access : synchronous
// Description : None
#define VEC_DAC_E4_OFFSET 0x000000e4
#define VEC_DAC_E4_BITS   0xffffffff
#define VEC_DAC_E4_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_E4_FIR_COEFF_CHROMA_2_4
// Description : FIR filter coefficients
#define VEC_DAC_E4_FIR_COEFF_CHROMA_2_4_RESET  0x0000
#define VEC_DAC_E4_FIR_COEFF_CHROMA_2_4_BITS   0xffff0000
#define VEC_DAC_E4_FIR_COEFF_CHROMA_2_4_MSB    31
#define VEC_DAC_E4_FIR_COEFF_CHROMA_2_4_LSB    16
#define VEC_DAC_E4_FIR_COEFF_CHROMA_2_4_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_E4_FIR_COEFF_LUMA_2_4
// Description : FIR filter coefficients
#define VEC_DAC_E4_FIR_COEFF_LUMA_2_4_RESET  0x0000
#define VEC_DAC_E4_FIR_COEFF_LUMA_2_4_BITS   0x0000ffff
#define VEC_DAC_E4_FIR_COEFF_LUMA_2_4_MSB    15
#define VEC_DAC_E4_FIR_COEFF_LUMA_2_4_LSB    0
#define VEC_DAC_E4_FIR_COEFF_LUMA_2_4_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_E8
// JTAG access : synchronous
// Description : None
#define VEC_DAC_E8_OFFSET 0x000000e8
#define VEC_DAC_E8_BITS   0xffffffff
#define VEC_DAC_E8_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_E8_FIR_COEFF_CHROMA_3
// Description : FIR filter coefficients
#define VEC_DAC_E8_FIR_COEFF_CHROMA_3_RESET  0x0000
#define VEC_DAC_E8_FIR_COEFF_CHROMA_3_BITS   0xffff0000
#define VEC_DAC_E8_FIR_COEFF_CHROMA_3_MSB    31
#define VEC_DAC_E8_FIR_COEFF_CHROMA_3_LSB    16
#define VEC_DAC_E8_FIR_COEFF_CHROMA_3_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_E8_FIR_COEFF_LUMA_3
// Description : FIR filter coefficients
#define VEC_DAC_E8_FIR_COEFF_LUMA_3_RESET  0x0000
#define VEC_DAC_E8_FIR_COEFF_LUMA_3_BITS   0x0000ffff
#define VEC_DAC_E8_FIR_COEFF_LUMA_3_MSB    15
#define VEC_DAC_E8_FIR_COEFF_LUMA_3_LSB    0
#define VEC_DAC_E8_FIR_COEFF_LUMA_3_ACCESS "RW"
// =============================================================================
// Register    : VEC_DAC_EC
// JTAG access : synchronous
// Description : Misc. control
#define VEC_DAC_EC_OFFSET 0x000000ec
#define VEC_DAC_EC_BITS   0x001fffff
#define VEC_DAC_EC_RESET  0x00000000
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_SLOW_CLOCK
// Description : Doubles the raised-cosine rate
#define VEC_DAC_EC_SLOW_CLOCK_RESET  0x0
#define VEC_DAC_EC_SLOW_CLOCK_BITS   0x00100000
#define VEC_DAC_EC_SLOW_CLOCK_MSB    20
#define VEC_DAC_EC_SLOW_CLOCK_LSB    20
#define VEC_DAC_EC_SLOW_CLOCK_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_FIR_RMINUS1
// Description : Select 1, 3, 5 or 7 FIR taps
#define VEC_DAC_EC_FIR_RMINUS1_RESET  0x0
#define VEC_DAC_EC_FIR_RMINUS1_BITS   0x000c0000
#define VEC_DAC_EC_FIR_RMINUS1_MSB    19
#define VEC_DAC_EC_FIR_RMINUS1_LSB    18
#define VEC_DAC_EC_FIR_RMINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_VERT_FULL_NOT_HALF
// Description : Disable half-line pulses during VBI
#define VEC_DAC_EC_VERT_FULL_NOT_HALF_RESET  0x0
#define VEC_DAC_EC_VERT_FULL_NOT_HALF_BITS   0x00020000
#define VEC_DAC_EC_VERT_FULL_NOT_HALF_MSB    17
#define VEC_DAC_EC_VERT_FULL_NOT_HALF_LSB    17
#define VEC_DAC_EC_VERT_FULL_NOT_HALF_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_SEQ_EN
// Description : Enable NCO reset
#define VEC_DAC_EC_SEQ_EN_RESET  0x0
#define VEC_DAC_EC_SEQ_EN_BITS   0x00010000
#define VEC_DAC_EC_SEQ_EN_MSB    16
#define VEC_DAC_EC_SEQ_EN_LSB    16
#define VEC_DAC_EC_SEQ_EN_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_U2_FLD_MASK
// Description : Field sequence
#define VEC_DAC_EC_U2_FLD_MASK_RESET  0x0
#define VEC_DAC_EC_U2_FLD_MASK_BITS   0x0000c000
#define VEC_DAC_EC_U2_FLD_MASK_MSB    15
#define VEC_DAC_EC_U2_FLD_MASK_LSB    14
#define VEC_DAC_EC_U2_FLD_MASK_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_U4_SEQ_MASK
// Description : NCO reset sequence
#define VEC_DAC_EC_U4_SEQ_MASK_RESET  0x0
#define VEC_DAC_EC_U4_SEQ_MASK_BITS   0x00003c00
#define VEC_DAC_EC_U4_SEQ_MASK_MSB    13
#define VEC_DAC_EC_U4_SEQ_MASK_LSB    10
#define VEC_DAC_EC_U4_SEQ_MASK_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_INTERP_RATE_MINUS1
// Description : Interpolation rate 2<=R<=16
#define VEC_DAC_EC_INTERP_RATE_MINUS1_RESET  0x0
#define VEC_DAC_EC_INTERP_RATE_MINUS1_BITS   0x000003c0
#define VEC_DAC_EC_INTERP_RATE_MINUS1_MSB    9
#define VEC_DAC_EC_INTERP_RATE_MINUS1_LSB    6
#define VEC_DAC_EC_INTERP_RATE_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_INTERP_SHIFT_MINUS1
// Description : Power-of-2 scaling after interpolation
#define VEC_DAC_EC_INTERP_SHIFT_MINUS1_RESET  0x0
#define VEC_DAC_EC_INTERP_SHIFT_MINUS1_BITS   0x0000003c
#define VEC_DAC_EC_INTERP_SHIFT_MINUS1_MSB    5
#define VEC_DAC_EC_INTERP_SHIFT_MINUS1_LSB    2
#define VEC_DAC_EC_INTERP_SHIFT_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_FIELDS_PER_FRAME_MINUS1
// Description : Interlaced / progressive
#define VEC_DAC_EC_FIELDS_PER_FRAME_MINUS1_RESET  0x0
#define VEC_DAC_EC_FIELDS_PER_FRAME_MINUS1_BITS   0x00000002
#define VEC_DAC_EC_FIELDS_PER_FRAME_MINUS1_MSB    1
#define VEC_DAC_EC_FIELDS_PER_FRAME_MINUS1_LSB    1
#define VEC_DAC_EC_FIELDS_PER_FRAME_MINUS1_ACCESS "RW"
// -----------------------------------------------------------------------------
// Field       : VEC_DAC_EC_PAL_EN
// Description : Enable phase alternate line (PAL) mode
#define VEC_DAC_EC_PAL_EN_RESET  0x0
#define VEC_DAC_EC_PAL_EN_BITS   0x00000001
#define VEC_DAC_EC_PAL_EN_MSB    0
#define VEC_DAC_EC_PAL_EN_LSB    0
#define VEC_DAC_EC_PAL_EN_ACCESS "RW"
// =============================================================================
#endif // VEC_REGS_DEFINED
