; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-linux | FileCheck %s -check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-linux | FileCheck %s -check-prefixes=X64,X64-GENERIC
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+ndd | FileCheck %s -check-prefixes=X64,X64-NDD

define i1 @isnan_f(float %x) {
; X86-LABEL: isnan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
;
; X64-LABEL: isnan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    setp %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 3)  ; "nan"
  ret i1 %0
}

define i1 @isnot_nan_f(float %x) {
; X86-LABEL: isnot_nan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %al
; X86-NEXT:    retl
;
; X64-LABEL: isnot_nan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    setnp %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1020)  ; 0x3fc = "zero|subnormal|normal|inf"
  ret i1 %0
}

define i1 @issignaling_f(float %x) {
; X86-LABEL: issignaling_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setl %cl
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: issignaling_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setl %cl
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1)  ; "snan"
  ret i1 %0
}

define i1 @not_issignaling_f(float %x) {
; X86-LABEL: not_issignaling_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %cl
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setl %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issignaling_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setge %cl
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setl %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1022)  ; ~"snan"
  ret i1 %0
}

define i1 @isquiet_f(float %x) {
; X86-LABEL: isquiet_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-LABEL: isquiet_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 2)  ; "qnan"
  ret i1 %0
}

define i1 @not_isquiet_f(float %x) {
; X86-LABEL: not_isquiet_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isquiet_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setl %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1021)  ; ~"qnan"
  ret i1 %0
}

define i1 @isinf_f(float %x) {
; X86-LABEL: isinf_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: isinf_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 516)  ; 0x204 = "inf"
  ret i1 %0
}

define i1 @not_isinf_f(float %x) {
; X86-LABEL: not_isinf_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isinf_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 507)  ; ~0x204 = "~inf"
  ret i1 %0
}

define i1 @is_plus_inf_f(float %x) {
; X86-LABEL: is_plus_inf_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cmpl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: is_plus_inf_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 512)  ; 0x200 = "+inf"
  ret i1 %0
}

define i1 @is_minus_inf_f(float %x) {
; X86-LABEL: is_minus_inf_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cmpl $-8388608, {{[0-9]+}}(%esp) # imm = 0xFF800000
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: is_minus_inf_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 4)  ; "-inf"
  ret i1 %0
}

define i1 @not_is_minus_inf_f(float %x) {
; X86-LABEL: not_is_minus_inf_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cmpl $-8388608, {{[0-9]+}}(%esp) # imm = 0xFF800000
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_minus_inf_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1019)  ; ~"-inf"
  ret i1 %0
}

define i1 @isfinite_f(float %x) {
; X86-LABEL: isfinite_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-LABEL: isfinite_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setl %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 504)  ; 0x1f8 = "finite"
  ret i1 %0
}

define i1 @not_isfinite_f(float %x) {
; X86-LABEL: not_isfinite_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isfinite_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 519)  ; ~0x1f8 = "~finite"
  ret i1 %0
}

define i1 @is_plus_finite_f(float %x) {
; X86-LABEL: is_plus_finite_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cmpl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: is_plus_finite_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 448)  ; 0x1c0 = "+finite"
  ret i1 %0
}

define i1 @not_is_plus_finite_f(float %x) {
; X86-LABEL: not_is_plus_finite_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cmpl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_plus_finite_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 575)  ; ~0x1c0 = ~"+finite"
  ret i1 %0
}

define i1 @is_minus_finite_f(float %x) {
; X86-LABEL: is_minus_finite_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sets %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: is_minus_finite_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    sets %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setl %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 56)  ; 0x38 = "-finite"
  ret i1 %0
}

define i1 @not_is_minus_finite_f(float %x) {
; X86-LABEL: not_is_minus_finite_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setns %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setge %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_minus_finite_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    setns %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setge %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 967)  ; ~0x38 = ~"-finite"
  ret i1 %0
}

define i1 @isnormal_f(float %x) #1 {
; X86-LABEL: isnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: isnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 264)  ; 0x108 = "normal"
  ret i1 %0
}

define i1 @not_isnormal_f(float %x) #1 {
; X86-LABEL: not_isnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 759)  ; ~0x108 = "~normal"
  ret i1 %0
}

define i1 @is_plus_normal_f(float %x) {
; X86-LABEL: is_plus_normal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setns %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setb %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: is_plus_normal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    setns %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NEXT:    setb %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 256)  ; 0x100 = "+normal"
  ret i1 %0
}

define i1 @issubnormal_f(float %x) {
; X86-LABEL: issubnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 144)  ; 0x90 = "subnormal"
  ret i1 %0
}

define i1 @issubnormal_f_daz(float %x) #0 {
; X86-LABEL: issubnormal_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 144)  ; 0x90 = "subnormal"
  ret i1 %0
}

define i1 @issubnormal_f_maybe_daz(float %x) #1 {
; X86-LABEL: issubnormal_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 144)  ; 0x90 = "subnormal"
  ret i1 %0
}

define i1 @not_issubnormal_f(float %x) {
; X86-LABEL: not_issubnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 879)  ; ~0x90 = "~subnormal"
  ret i1 %0
}

define i1 @not_issubnormal_f_daz(float %x) #0 {
; X86-LABEL: not_issubnormal_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 879)  ; ~0x90 = "~subnormal"
  ret i1 %0
}

define i1 @not_issubnormal_f_maybe_daz(float %x) #1 {
; X86-LABEL: not_issubnormal_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 879)  ; ~0x90 = "~subnormal"
  ret i1 %0
}

define i1 @is_plus_subnormal_f(float %x) {
; X86-LABEL: is_plus_subnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: is_plus_subnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 128)  ; 0x80 = "+subnormal"
  ret i1 %0
}

define i1 @not_is_plus_subnormal_f(float %x) {
; X86-LABEL: not_is_plus_subnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_plus_subnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 895)  ; ~0x80 = ~"+subnormal"
  ret i1 %0
}

define i1 @is_minus_subnormal_f(float %x) {
; X86-LABEL: is_minus_subnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sets %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setb %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: is_minus_subnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    sets %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setb %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 16)  ; 0x10 = "-subnormal"
  ret i1 %0
}

define i1 @not_is_minus_subnormal_f(float %x) {
; X86-LABEL: not_is_minus_subnormal_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setns %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setae %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_minus_subnormal_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    setns %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setae %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1007)  ; ~0x10 = ~"-subnormal"
  ret i1 %0
}

define i1 @iszero_f(float %x) {
; X86-LABEL: iszero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 96)  ; 0x60 = "zero"
  ret i1 %0
}

define i1 @iszero_f_daz(float %x) #0 {
; X86-LABEL: iszero_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 96)  ; 0x60 = "zero"
  ret i1 %0
}

define i1 @iszero_f_maybe_daz(float %x) #1 {
; X86-LABEL: iszero_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 96)  ; 0x60 = "zero"
  ret i1 %0
}

define i1 @not_iszero_f(float %x) {
; X86-LABEL: not_iszero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_iszero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 927)  ; ~0x60 = "~zero"
  ret i1 %0
}

define i1 @not_iszero_f_daz(float %x) #0 {
; X86-LABEL: not_iszero_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_iszero_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 927)  ; ~0x60 = "~zero"
  ret i1 %0
}

define i1 @not_iszero_f_maybe_daz(float %x) #1 {
; X86-LABEL: not_iszero_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_iszero_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 927)  ; ~0x60 = "~zero"
  ret i1 %0
}

define i1 @issubnormal_or_zero_f(float %x) {
; X86-LABEL: issubnormal_or_zero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_or_zero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 240)  ; 0xf0 = "subnormal|zero"
  ret i1 %0
}

define i1 @issubnormal_or_zero_f_daz(float %x) #0 {
; X86-LABEL: issubnormal_or_zero_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_or_zero_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 240)  ; 0xf0 = "subnormal|zero"
  ret i1 %0
}

define i1 @issubnormal_or_zero_f_maybe_daz(float %x) #1 {
; X86-LABEL: issubnormal_or_zero_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_or_zero_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 240)  ; 0xf0 = "subnormal|zero"
  ret i1 %0
}

define i1 @not_issubnormal_or_zero_f(float %x) {
; X86-LABEL: not_issubnormal_or_zero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_or_zero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 783)  ; ~0xf0 = "~(subnormal|zero)"
  ret i1 %0
}

define i1 @not_issubnormal_or_zero_f_daz(float %x) #0 {
; X86-LABEL: not_issubnormal_or_zero_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_or_zero_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 783)  ; ~0xf0 = "~(subnormal|zero)"
  ret i1 %0
}

define i1 @not_issubnormal_or_zero_f_maybe_daz(float %x) #1 {
; X86-LABEL: not_issubnormal_or_zero_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2139095040, {{[0-9]+}}(%esp) # imm = 0x7F800000
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_or_zero_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 783)  ; ~0xf0 = "~(subnormal|zero)"
  ret i1 %0
}

define i1 @is_plus_zero_f(float %x) {
; X86-LABEL: is_plus_zero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cmpl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: is_plus_zero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 64)  ; 0x40 = "+zero"
  ret i1 %0
}

define i1 @not_is_plus_zero_f(float %x) {
; X86-LABEL: not_is_plus_zero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    cmpl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_plus_zero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 959)  ; ~0x40 = ~"+zero"
  ret i1 %0
}

define i1 @is_minus_zero_f(float %x) {
; X86-LABEL: is_minus_zero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seto %al
; X86-NEXT:    retl
;
; X64-LABEL: is_minus_zero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    seto %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 32)  ; 0x20 = "-zero"
  ret i1 %0
}

define i1 @not_is_minus_zero_f(float %x) {
; X86-LABEL: not_is_minus_zero_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setno %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_minus_zero_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    setno %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 991)  ; ~0x20 = ~"-zero"
  ret i1 %0
}

define i1 @isnan_f_strictfp(float %x) strictfp {
; X86-LABEL: isnan_f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-LABEL: isnan_f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 3) strictfp ; "nan"
  ret i1 %0
}

define i1 @not_isnan_f_strictfp(float %x) strictfp {
; X86-LABEL: not_isnan_f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isnan_f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setl %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1020) strictfp ; ~"nan"
  ret i1 %0
}

define i1 @isfinite_f_strictfp(float %x) strictfp {
; X86-LABEL: isfinite_f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-LABEL: isfinite_f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setl %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 504) strictfp ; 0x1f8 = "finite"
  ret i1 %0
}

define i1 @not_isfinite_f_strictfp(float %x) strictfp {
; X86-LABEL: not_isfinite_f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isfinite_f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 519) strictfp ; ~0x1f8 = ~"finite"
  ret i1 %0
}

define i1 @iszero_f_strictfp(float %x) strictfp {
; X86-LABEL: iszero_f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 96) strictfp ; 0x60 = "zero"
  ret i1 %0
}

define i1 @not_iszero_f_strictfp(float %x) strictfp {
; X86-LABEL: not_iszero_f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    testl $2147483647, {{[0-9]+}}(%esp) # imm = 0x7FFFFFFF
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_iszero_f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 927) strictfp ; ~0x60 = ~"zero"
  ret i1 %0
}

define i1 @isnan_d(double %x) {
; X86-LABEL: isnan_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
;
; X64-LABEL: isnan_d:
; X64:       # %bb.0: # %entry
; X64-NEXT:    ucomisd %xmm0, %xmm0
; X64-NEXT:    setp %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 3)  ; "nan"
  ret i1 %0
}

define i1 @isinf_d(double %x) {
; X86-LABEL: isinf_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    xorl $2146435072, %eax # imm = 0x7FF00000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: isinf_d:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movq %xmm0, %rax
; X64-GENERIC-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    andq %rax, %rcx
; X64-GENERIC-NEXT:    movabsq $9218868437227405312, %rax # imm = 0x7FF0000000000000
; X64-GENERIC-NEXT:    cmpq %rax, %rcx
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: isinf_d:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movq %xmm0, %rax
; X64-NDD-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-NDD-NEXT:    andq %rcx, %rax
; X64-NDD-NEXT:    movabsq $9218868437227405312, %rcx # imm = 0x7FF0000000000000
; X64-NDD-NEXT:    cmpq %rcx, %rax
; X64-NDD-NEXT:    sete %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 516)  ; 0x204 = "inf"
  ret i1 %0
}

define i1 @isfinite_d(double %x) {
; X86-LABEL: isfinite_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2146435072, %eax # imm = 0x7FF00000
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: isfinite_d:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movq %xmm0, %rax
; X64-GENERIC-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    andq %rax, %rcx
; X64-GENERIC-NEXT:    movabsq $9218868437227405312, %rax # imm = 0x7FF0000000000000
; X64-GENERIC-NEXT:    cmpq %rax, %rcx
; X64-GENERIC-NEXT:    setl %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: isfinite_d:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movq %xmm0, %rax
; X64-NDD-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-NDD-NEXT:    andq %rcx, %rax
; X64-NDD-NEXT:    movabsq $9218868437227405312, %rcx # imm = 0x7FF0000000000000
; X64-NDD-NEXT:    cmpq %rcx, %rax
; X64-NDD-NEXT:    setl %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 504)  ; 0x1f8 = "finite"
  ret i1 %0
}

define i1 @isnormal_d(double %x) {
; X86-LABEL: isnormal_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $-1048576, %eax # imm = 0xFFF00000
; X86-NEXT:    shrl $21, %eax
; X86-NEXT:    cmpl $1023, %eax # imm = 0x3FF
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: isnormal_d:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movq %xmm0, %rax
; X64-GENERIC-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    andq %rax, %rcx
; X64-GENERIC-NEXT:    movabsq $-4503599627370496, %rax # imm = 0xFFF0000000000000
; X64-GENERIC-NEXT:    addq %rcx, %rax
; X64-GENERIC-NEXT:    shrq $53, %rax
; X64-GENERIC-NEXT:    cmpl $1023, %eax # imm = 0x3FF
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: isnormal_d:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movq %xmm0, %rax
; X64-NDD-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-NDD-NEXT:    andq %rcx, %rax
; X64-NDD-NEXT:    movabsq $-4503599627370496, %rcx # imm = 0xFFF0000000000000
; X64-NDD-NEXT:    addq %rcx, %rax
; X64-NDD-NEXT:    shrq $53, %rax
; X64-NDD-NEXT:    cmpl $1023, %eax # imm = 0x3FF
; X64-NDD-NEXT:    setb %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 264)  ; 0x108 = "normal"
  ret i1 %0
}

define i1 @issubnormal_d(double %x) {
; X86-LABEL: issubnormal_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    addl $-1, %eax
; X86-NEXT:    adcl $-1, %ecx
; X86-NEXT:    cmpl $-1, %eax
; X86-NEXT:    sbbl $1048575, %ecx # imm = 0xFFFFF
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: issubnormal_d:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movq %xmm0, %rax
; X64-GENERIC-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    andq %rax, %rcx
; X64-GENERIC-NEXT:    decq %rcx
; X64-GENERIC-NEXT:    movabsq $4503599627370495, %rax # imm = 0xFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    cmpq %rax, %rcx
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: issubnormal_d:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movq %xmm0, %rax
; X64-NDD-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-NDD-NEXT:    andq %rcx, %rax
; X64-NDD-NEXT:    decq %rax
; X64-NDD-NEXT:    movabsq $4503599627370495, %rcx # imm = 0xFFFFFFFFFFFFF
; X64-NDD-NEXT:    cmpq %rcx, %rax
; X64-NDD-NEXT:    setb %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 144)  ; 0x90 = "subnormal"
  ret i1 %0
}

define i1 @iszero_d(double %x) {
; X86-LABEL: iszero_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_d:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movq %xmm0, %rax
; X64-NEXT:    shlq %rax
; X64-NEXT:    testq %rax, %rax
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 96)  ; 0x60 = "zero"
  ret i1 %0
}

define i1 @issignaling_d(double %x) {
; X86-LABEL: issignaling_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    xorl %ecx, %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $2146435072, %ecx # imm = 0x7FF00000
; X86-NEXT:    sbbl %eax, %ecx
; X86-NEXT:    setl %cl
; X86-NEXT:    cmpl $2146959360, %eax # imm = 0x7FF80000
; X86-NEXT:    setl %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: issignaling_d:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movq %xmm0, %rax
; X64-GENERIC-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    andq %rax, %rcx
; X64-GENERIC-NEXT:    movabsq $9221120237041090560, %rax # imm = 0x7FF8000000000000
; X64-GENERIC-NEXT:    cmpq %rax, %rcx
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    movabsq $9218868437227405312, %rax # imm = 0x7FF0000000000000
; X64-GENERIC-NEXT:    cmpq %rax, %rcx
; X64-GENERIC-NEXT:    setg %al
; X64-GENERIC-NEXT:    andb %dl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: issignaling_d:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movq %xmm0, %rax
; X64-NDD-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-NDD-NEXT:    andq %rcx, %rax
; X64-NDD-NEXT:    movabsq $9221120237041090560, %rcx # imm = 0x7FF8000000000000
; X64-NDD-NEXT:    cmpq %rcx, %rax
; X64-NDD-NEXT:    setl %cl
; X64-NDD-NEXT:    movabsq $9218868437227405312, %rdx # imm = 0x7FF0000000000000
; X64-NDD-NEXT:    cmpq %rdx, %rax
; X64-NDD-NEXT:    setg %al
; X64-NDD-NEXT:    andb %cl, %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 1)  ; "snan"
  ret i1 %0
}

define i1 @isquiet_d(double %x) {
; X86-LABEL: isquiet_d:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2146959360, %eax # imm = 0x7FF80000
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: isquiet_d:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movq %xmm0, %rax
; X64-GENERIC-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    andq %rax, %rcx
; X64-GENERIC-NEXT:    movabsq $9221120237041090559, %rax # imm = 0x7FF7FFFFFFFFFFFF
; X64-GENERIC-NEXT:    cmpq %rax, %rcx
; X64-GENERIC-NEXT:    setg %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: isquiet_d:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movq %xmm0, %rax
; X64-NDD-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-NDD-NEXT:    andq %rcx, %rax
; X64-NDD-NEXT:    movabsq $9221120237041090559, %rcx # imm = 0x7FF7FFFFFFFFFFFF
; X64-NDD-NEXT:    cmpq %rcx, %rax
; X64-NDD-NEXT:    setg %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 2)  ; "qnan"
  ret i1 %0
}

define i1 @isnan_d_strictfp(double %x) strictfp {
; X86-LABEL: isnan_d_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    xorl %ecx, %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $2146435072, %ecx # imm = 0x7FF00000
; X86-NEXT:    sbbl %eax, %ecx
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: isnan_d_strictfp:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movq %xmm0, %rax
; X64-GENERIC-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-GENERIC-NEXT:    andq %rax, %rcx
; X64-GENERIC-NEXT:    movabsq $9218868437227405312, %rax # imm = 0x7FF0000000000000
; X64-GENERIC-NEXT:    cmpq %rax, %rcx
; X64-GENERIC-NEXT:    setg %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: isnan_d_strictfp:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movq %xmm0, %rax
; X64-NDD-NEXT:    movabsq $9223372036854775807, %rcx # imm = 0x7FFFFFFFFFFFFFFF
; X64-NDD-NEXT:    andq %rcx, %rax
; X64-NDD-NEXT:    movabsq $9218868437227405312, %rcx # imm = 0x7FF0000000000000
; X64-NDD-NEXT:    cmpq %rcx, %rax
; X64-NDD-NEXT:    setg %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 3) strictfp ; "nan"
  ret i1 %0
}

define i1 @iszero_d_strictfp(double %x) strictfp {
; X86-LABEL: iszero_d_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_d_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movq %xmm0, %rax
; X64-NEXT:    shlq %rax
; X64-NEXT:    testq %rax, %rax
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f64(double %x, i32 96) strictfp ; 0x60 = "zero"
  ret i1 %0
}



define <1 x i1> @isnan_v1f(<1 x float> %x) {
; X86-LABEL: isnan_v1f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
;
; X64-LABEL: isnan_v1f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    ucomiss %xmm0, %xmm0
; X64-NEXT:    setp %al
; X64-NEXT:    retq
entry:
  %0 = tail call <1 x i1> @llvm.is.fpclass.v1f32(<1 x float> %x, i32 3)  ; "nan"
  ret <1 x i1> %0
}

define <1 x i1> @isnan_v1f_strictfp(<1 x float> %x) strictfp {
; X86-LABEL: isnan_v1f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-LABEL: isnan_v1f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %0 = tail call <1 x i1> @llvm.is.fpclass.v1f32(<1 x float> %x, i32 3) strictfp ; "nan"
  ret <1 x i1> %0
}

define <2 x i1> @isnan_v2f(<2 x float> %x) {
; X86-LABEL: isnan_v2f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %cl
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %dl
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: isnan_v2f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cmpunordps %xmm0, %xmm0
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %x, i32 3)  ; "nan"
  ret <2 x i1> %0
}


define <2 x i1> @isnot_nan_v2f(<2 x float> %x) {
; X86-LABEL: isnot_nan_v2f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %cl
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %dl
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: isnot_nan_v2f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cmpordps %xmm0, %xmm0
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %x, i32 1020)  ; 0x3fc = "zero|subnormal|normal|inf"
  ret <2 x i1> %0
}

define <2 x i1> @isnan_v2f_strictfp(<2 x float> %x) strictfp {
; X86-LABEL: isnan_v2f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl %ecx, %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %al
; X86-NEXT:    andl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X86-NEXT:    setge %dl
; X86-NEXT:    retl
;
; X64-LABEL: isnan_v2f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; X64-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x i1> @llvm.is.fpclass.v2f32(<2 x float> %x, i32 3) strictfp ; "nan"
  ret <2 x i1> %0
}

define <4 x i1> @isnan_v4f(<4 x float> %x) {
; X86-LABEL: isnan_v4f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %dh
; X86-NEXT:    shlb $2, %dh
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %dl
; X86-NEXT:    shlb $3, %dl
; X86-NEXT:    orb %dh, %dl
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %dh
; X86-NEXT:    fucomp %st(0)
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    addb %al, %al
; X86-NEXT:    orb %dh, %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    movb %al, (%ecx)
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    retl $4
;
; X64-LABEL: isnan_v4f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cmpunordps %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i1> @llvm.is.fpclass.v4f32(<4 x float> %x, i32 3)  ; "nan"
  ret <4 x i1> %0
}

define <4 x i1> @isnan_v4f_strictfp(<4 x float> %x) strictfp {
; X86-LABEL: isnan_v4f_strictfp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %esi, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    andl %ecx, %edx
; X86-NEXT:    cmpl $2139095041, %edx # imm = 0x7F800001
; X86-NEXT:    setge %dh
; X86-NEXT:    shlb $2, %dh
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    andl %ecx, %esi
; X86-NEXT:    cmpl $2139095041, %esi # imm = 0x7F800001
; X86-NEXT:    setge %dl
; X86-NEXT:    shlb $3, %dl
; X86-NEXT:    orb %dh, %dl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    andl %ecx, %esi
; X86-NEXT:    cmpl $2139095041, %esi # imm = 0x7F800001
; X86-NEXT:    setge %dh
; X86-NEXT:    andl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X86-NEXT:    setge %cl
; X86-NEXT:    addb %cl, %cl
; X86-NEXT:    orb %dh, %cl
; X86-NEXT:    orb %dl, %cl
; X86-NEXT:    movb %cl, (%eax)
; X86-NEXT:    popl %esi
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl $4
;
; X64-LABEL: isnan_v4f_strictfp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x i1> @llvm.is.fpclass.v4f32(<4 x float> %x, i32 3) strictfp ; "nan"
  ret <4 x i1> %0
}

define i1 @isnone_f(float %x) {
; X86-LABEL: isnone_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: isnone_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 0)
  ret i1 %0
}

define i1 @isany_f(float %x) {
; X86-LABEL: isany_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb $1, %al
; X86-NEXT:    retl
;
; X64-LABEL: isany_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movb $1, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1023)
  ret i1 %0
}


define i1 @iszero_or_nan_f(float %x) {
; X86-LABEL: iszero_or_nan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fldz
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_or_nan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 99)  ; 0x60|0x3 = "zero|nan"
  ret i1 %0
}

define i1 @iszero_or_nan_f_daz(float %x) #0 {
; X86-LABEL: iszero_or_nan_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %cl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_or_nan_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %cl
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    sete %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 99)  ; 0x60|0x3 = "zero|nan"
  ret i1 %0
}

define i1 @iszero_or_nan_f_maybe_daz(float %x) #1 {
; X86-LABEL: iszero_or_nan_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %cl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_or_nan_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %cl
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    sete %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 99)  ; 0x60|0x3 = "zero|nan"
  ret i1 %0
}

define i1 @not_iszero_or_nan_f(float %x) {
; X86-LABEL: not_iszero_or_nan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fldz
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_iszero_or_nan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 924)  ; ~0x60 = "~(zero|nan)"
  ret i1 %0
}

define i1 @not_iszero_or_nan_f_daz(float %x) #0 {
; X86-LABEL: not_iszero_or_nan_f_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setl %cl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setne %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_iszero_or_nan_f_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setl %cl
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    setne %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 924)  ; ~(0x60|0x3) = "~(zero|nan)"
  ret i1 %0
}

define i1 @not_iszero_or_nan_f_maybe_daz(float %x) #1 {
; X86-LABEL: not_iszero_or_nan_f_maybe_daz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setl %cl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setne %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_iszero_or_nan_f_maybe_daz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setl %cl
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    setne %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 924)  ; ~(0x60|0x3) = "~(zero|nan)"
  ret i1 %0
}

define i1 @iszero_or_qnan_f(float %x) {
; X86-LABEL: iszero_or_qnan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %cl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: iszero_or_qnan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setge %cl
; X64-NEXT:    testl %eax, %eax
; X64-NEXT:    sete %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 98)  ; 0x60|0x2 = "zero|qnan"
  ret i1 %0
}

define i1 @iszero_or_snan_f(float %x) {
; X86-LABEL: iszero_or_snan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setl %cl
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %dl
; X86-NEXT:    andb %cl, %dl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: iszero_or_snan_f:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %cl
; X64-GENERIC-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %dl
; X64-GENERIC-NEXT:    andb %cl, %dl
; X64-GENERIC-NEXT:    testl %eax, %eax
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: iszero_or_snan_f:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %cl
; X64-NDD-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NDD-NEXT:    setge %dl
; X64-NDD-NEXT:    andb %dl, %cl
; X64-NDD-NEXT:    testl %eax, %eax
; X64-NDD-NEXT:    sete %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 97)  ; 0x60|0x1 = "zero|snan"
  ret i1 %0
}

define i1 @not_iszero_or_qnan_f(float %x) {
; X86-LABEL: not_iszero_or_qnan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %esi, -8
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setl %cl
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %dl
; X86-NEXT:    andb %cl, %dl
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    leal -1(%eax), %esi
; X86-NEXT:    cmpl $8388607, %esi # imm = 0x7FFFFF
; X86-NEXT:    setb %ch
; X86-NEXT:    orb %cl, %ch
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setb %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    orb %ch, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_iszero_or_qnan_f:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %cl
; X64-GENERIC-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %dl
; X64-GENERIC-NEXT:    andb %cl, %dl
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %cl
; X64-GENERIC-NEXT:    leal -1(%rax), %esi
; X64-GENERIC-NEXT:    cmpl $8388607, %esi # imm = 0x7FFFFF
; X64-GENERIC-NEXT:    setb %sil
; X64-GENERIC-NEXT:    orb %cl, %sil
; X64-GENERIC-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    orb %sil, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_iszero_or_qnan_f:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %cl
; X64-NDD-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NDD-NEXT:    setge %dl
; X64-NDD-NEXT:    andb %dl, %cl
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %dl
; X64-NDD-NEXT:    decl %eax, %esi
; X64-NDD-NEXT:    cmpl $8388607, %esi # imm = 0x7FFFFF
; X64-NDD-NEXT:    setb %sil
; X64-NDD-NEXT:    orb %sil, %dl
; X64-NDD-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NDD-NEXT:    setb %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    orb %dl, %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 925)  ; ~(0x60|0x2) = "~(zero|qnan)"
  ret i1 %0
}

define i1 @not_iszero_or_snan_f(float %x) {
; X86-LABEL: not_iszero_or_snan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    leal -1(%eax), %edx
; X86-NEXT:    cmpl $8388607, %edx # imm = 0x7FFFFF
; X86-NEXT:    setb %dl
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %ch
; X86-NEXT:    orb %cl, %ch
; X86-NEXT:    orb %dl, %ch
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setb %al
; X86-NEXT:    orb %ch, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_iszero_or_snan_f:
; X64-GENERIC:       # %bb.0: # %entry
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %cl
; X64-GENERIC-NEXT:    leal -1(%rax), %edx
; X64-GENERIC-NEXT:    cmpl $8388607, %edx # imm = 0x7FFFFF
; X64-GENERIC-NEXT:    setb %dl
; X64-GENERIC-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setge %sil
; X64-GENERIC-NEXT:    orb %cl, %sil
; X64-GENERIC-NEXT:    orb %dl, %sil
; X64-GENERIC-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    orb %sil, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_iszero_or_snan_f:
; X64-NDD:       # %bb.0: # %entry
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %cl
; X64-NDD-NEXT:    decl %eax, %edx
; X64-NDD-NEXT:    cmpl $8388607, %edx # imm = 0x7FFFFF
; X64-NDD-NEXT:    setb %dl
; X64-NDD-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NDD-NEXT:    setge %sil
; X64-NDD-NEXT:    orb %sil, %cl
; X64-NDD-NEXT:    orb %dl, %cl
; X64-NDD-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NDD-NEXT:    setb %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 926)  ; ~(0x60|0x1) = "~(zero|snan)"
  ret i1 %0
}

define i1 @isinf_or_nan_f(float %x) {
; X86-LABEL: isinf_or_nan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-LABEL: isinf_or_nan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 519)  ; 0x204|0x3 = "inf|nan"
  ret i1 %0
}

define i1 @not_isinf_or_nan_f(float %x) {
; X86-LABEL: not_isinf_or_nan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isinf_or_nan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setl %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 504)  ; ~(0x204|0x3) = "~(inf|nan)"
  ret i1 %0
}

define i1 @isfinite_or_nan_f(float %x) {
; X86-LABEL: isfinite_or_nan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: isfinite_or_nan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 507)  ; 0x1f8|0x3 = "finite|nan"
  ret i1 %0
}

define i1 @not_isfinite_or_nan_f(float %x) {
; X86-LABEL: not_isfinite_or_nan_f:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: not_isfinite_or_nan_f:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f32(float %x, i32 516)  ; ~(0x1f8|0x3) = "~(finite|nan)"
  ret i1 %0
}

define i1 @is_plus_inf_or_nan_f(float %x) {
; X86-LABEL: is_plus_inf_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: is_plus_inf_or_nan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 515)  ; 0x200|0x3 = "+inf|nan"
  ret i1 %class
}

define i1 @is_minus_inf_or_nan_f(float %x) {
; X86-LABEL: is_minus_inf_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: is_minus_inf_or_nan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 7)  ; "-inf|nan"
  ret i1 %class
}

define i1 @not_is_plus_inf_or_nan_f(float %x) {
; X86-LABEL: not_is_plus_inf_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_plus_inf_or_nan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setl %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 508)  ; ~(0x200|0x3) = "~(+inf|nan)"
  ret i1 %class
}

define i1 @not_is_minus_inf_or_nan_f(float %x) {
; X86-LABEL: not_is_minus_inf_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_is_minus_inf_or_nan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setl %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1016)  ; "~(-inf|nan)"
  ret i1 %class
}

define i1 @is_plus_inf_or_snan_f(float %x) {
; X86-LABEL: is_plus_inf_or_snan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X86-NEXT:    setl %dl
; X86-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X86-NEXT:    setge %cl
; X86-NEXT:    andb %dl, %cl
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: is_plus_inf_or_snan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    movl %eax, %ecx
; X64-GENERIC-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %cl
; X64-GENERIC-NEXT:    andb %dl, %cl
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    orb %cl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: is_plus_inf_or_snan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax, %ecx # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %dl
; X64-NDD-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-NDD-NEXT:    setge %cl
; X64-NDD-NEXT:    andb %dl, %cl
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 513)  ; 0x200|0x1 = "+inf|snan"
  ret i1 %class
}

define i1 @is_plus_inf_or_qnan_f(float %x) {
; X86-LABEL: is_plus_inf_or_qnan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: is_plus_inf_or_qnan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setge %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 514)  ; 0x200|0x1 = "+inf|qnan"
  ret i1 %class
}

define i1 @not_is_plus_inf_or_snan_f(float %x) {
; X86-LABEL: not_is_plus_inf_or_snan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %dl
; X86-NEXT:    orb %cl, %dl
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_is_plus_inf_or_snan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    sete %cl
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    orb %cl, %dl
; X64-GENERIC-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setge %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_is_plus_inf_or_snan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    sete %cl
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    setl %dl
; X64-NDD-NEXT:    orb %dl, %cl
; X64-NDD-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NDD-NEXT:    setge %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 510) ; ~(+inf|snan)
  ret i1 %class
}

define i1 @not_is_plus_inf_or_qnan_f(float %x) {
; X86-LABEL: not_is_plus_inf_or_qnan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X86-NEXT:    setl %dl
; X86-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X86-NEXT:    setge %dh
; X86-NEXT:    andb %dl, %dh
; X86-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    sete %dl
; X86-NEXT:    cmpl $2139095040, %ecx # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    orb %dh, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_is_plus_inf_or_qnan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    movl %eax, %ecx
; X64-GENERIC-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %sil
; X64-GENERIC-NEXT:    andb %dl, %sil
; X64-GENERIC-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    sete %dl
; X64-GENERIC-NEXT:    cmpl $2139095040, %ecx # imm = 0x7F800000
; X64-GENERIC-NEXT:    setl %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    orb %sil, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_is_plus_inf_or_qnan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax, %ecx # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %dl
; X64-NDD-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-NDD-NEXT:    setge %sil
; X64-NDD-NEXT:    andb %sil, %dl
; X64-NDD-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    sete %al
; X64-NDD-NEXT:    cmpl $2139095040, %ecx # imm = 0x7F800000
; X64-NDD-NEXT:    setl %cl
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    orb %dl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 509) ; ~(+inf|qnan)
  ret i1 %class
}

define i1 @is_minus_inf_or_snan_f(float %x) {
; X86-LABEL: is_minus_inf_or_snan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X86-NEXT:    setl %dl
; X86-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X86-NEXT:    setge %cl
; X86-NEXT:    andb %dl, %cl
; X86-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    sete %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: is_minus_inf_or_snan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    movl %eax, %ecx
; X64-GENERIC-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %cl
; X64-GENERIC-NEXT:    andb %dl, %cl
; X64-GENERIC-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    orb %cl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: is_minus_inf_or_snan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax, %ecx # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %dl
; X64-NDD-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-NDD-NEXT:    setge %cl
; X64-NDD-NEXT:    andb %dl, %cl
; X64-NDD-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    sete %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 5)  ; "-inf|snan"
  ret i1 %class
}

define i1 @is_minus_inf_or_qnan_f(float %x) {
; X86-LABEL: is_minus_inf_or_qnan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: is_minus_inf_or_qnan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl $-8388608, %eax # imm = 0xFF800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setge %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 6)  ; "-inf|qnan"
  ret i1 %class
}

define i1 @not_is_minus_inf_or_snan_f(float %x) {
; X86-LABEL: not_is_minus_inf_or_snan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setl %dl
; X86-NEXT:    orb %cl, %dl
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_is_minus_inf_or_snan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %cl
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    orb %cl, %dl
; X64-GENERIC-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setge %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_is_minus_inf_or_snan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %cl
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    setl %dl
; X64-NDD-NEXT:    orb %dl, %cl
; X64-NDD-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NDD-NEXT:    setge %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1018)  ; "~(-inf|snan)"
  ret i1 %class
}

define i1 @not_is_minus_inf_or_qnan_f(float %x) {
; X86-LABEL: not_is_minus_inf_or_qnan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X86-NEXT:    setl %dl
; X86-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X86-NEXT:    setge %dh
; X86-NEXT:    andb %dl, %dh
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %dl
; X86-NEXT:    cmpl $2139095040, %ecx # imm = 0x7F800000
; X86-NEXT:    setl %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    orb %dh, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_is_minus_inf_or_qnan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    movl %eax, %ecx
; X64-GENERIC-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %sil
; X64-GENERIC-NEXT:    andb %dl, %sil
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %dl
; X64-GENERIC-NEXT:    cmpl $2139095040, %ecx # imm = 0x7F800000
; X64-GENERIC-NEXT:    setl %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    orb %sil, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_is_minus_inf_or_qnan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax, %ecx # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %dl
; X64-NDD-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-NDD-NEXT:    setge %sil
; X64-NDD-NEXT:    andb %sil, %dl
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %al
; X64-NDD-NEXT:    cmpl $2139095040, %ecx # imm = 0x7F800000
; X64-NDD-NEXT:    setl %cl
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    orb %dl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 1017)  ; "-inf|qnan"
  ret i1 %class
}

define i1 @issubnormal_or_nan_f(float %x) {
; X86-LABEL: issubnormal_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %cl
; X86-NEXT:    decl %eax
; X86-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X86-NEXT:    setb %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_or_nan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %cl
; X64-NEXT:    decl %eax
; X64-NEXT:    cmpl $8388607, %eax # imm = 0x7FFFFF
; X64-NEXT:    setb %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 147)  ; 0x90|0x3 = "subnormal|nan"
  ret i1 %class
}

define i1 @issubnormal_or_zero_or_nan_f(float %x) {
; X86-LABEL: issubnormal_or_zero_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_or_zero_or_nan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setge %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 243)  ; 0xf0|0x3 = "subnormal|zero|nan"
  ret i1 %class
}

define i1 @issubnormal_or_zero_or_nan_f_daz(float %x) #0 {
; X86-LABEL: issubnormal_or_zero_or_nan_f_daz:
; X86:       # %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fldz
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_or_zero_or_nan_f_daz:
; X64:       # %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 243)  ; 0xf0|0x3 = "subnormal|zero|nan"
  ret i1 %class
}

define i1 @issubnormal_or_zero_or_snan_f(float %x) {
; X86-LABEL: issubnormal_or_zero_or_snan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X86-NEXT:    setl %dl
; X86-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X86-NEXT:    setge %cl
; X86-NEXT:    andb %dl, %cl
; X86-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: issubnormal_or_zero_or_snan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    movl %eax, %ecx
; X64-GENERIC-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %dl
; X64-GENERIC-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %cl
; X64-GENERIC-NEXT:    andb %dl, %cl
; X64-GENERIC-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    orb %cl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: issubnormal_or_zero_or_snan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax, %ecx # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %ecx # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %dl
; X64-NDD-NEXT:    cmpl $2139095041, %ecx # imm = 0x7F800001
; X64-NDD-NEXT:    setge %cl
; X64-NDD-NEXT:    andb %dl, %cl
; X64-NDD-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 241)  ; 0x90|0x1 = "subnormal|snan"
  ret i1 %class
}

define i1 @issubnormal_or_zero_or_qnan_f(float %x) {
; X86-LABEL: issubnormal_or_zero_or_qnan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: issubnormal_or_zero_or_qnan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    sete %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NEXT:    setge %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 242)  ; 0x90|0x2 = "subnormal|qnan"
  ret i1 %class
}

define i1 @not_issubnormal_or_nan_f(float %x) {
; X86-LABEL: not_issubnormal_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %dl
; X86-NEXT:    orb %cl, %dl
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setb %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_issubnormal_or_nan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %cl
; X64-GENERIC-NEXT:    testl %eax, %eax
; X64-GENERIC-NEXT:    sete %dl
; X64-GENERIC-NEXT:    orb %cl, %dl
; X64-GENERIC-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_issubnormal_or_nan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %cl
; X64-NDD-NEXT:    testl %eax, %eax
; X64-NDD-NEXT:    sete %dl
; X64-NDD-NEXT:    orb %dl, %cl
; X64-NDD-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NDD-NEXT:    setb %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 876)  ; ~(0x90|0x3) = ~"subnormal|nan"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_or_nan_f(float %x) {
; X86-LABEL: not_issubnormal_or_zero_or_nan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    setne %cl
; X86-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setl %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_or_zero_or_nan_f:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    testl $2139095040, %eax # imm = 0x7F800000
; X64-NEXT:    setne %cl
; X64-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NEXT:    setl %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 780)  ; ~(0xf0|0x3) = ~"subnormal|zero|nan"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_or_nan_f_daz(float %x) #0 {
; X86-LABEL: not_issubnormal_or_zero_or_nan_f_daz:
; X86:       # %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fldz
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; X64-LABEL: not_issubnormal_or_zero_or_nan_f_daz:
; X64:       # %bb.0:
; X64-NEXT:    xorps %xmm1, %xmm1
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 780)  ; ~(0xf0|0x3) = ~"subnormal|zero|nan"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_or_snan_f(float %x) {
; X86-LABEL: not_issubnormal_or_zero_or_snan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setge %cl
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %dl
; X86-NEXT:    orb %cl, %dl
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setb %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_issubnormal_or_zero_or_snan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setge %cl
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %dl
; X64-GENERIC-NEXT:    orb %cl, %dl
; X64-GENERIC-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    orb %dl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_issubnormal_or_zero_or_snan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NDD-NEXT:    setge %cl
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %dl
; X64-NDD-NEXT:    orb %dl, %cl
; X64-NDD-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NDD-NEXT:    setb %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 782)  ; ~(0x90|0x1) = ~"subnormal|snan"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_or_qnan_f(float %x) {
; X86-LABEL: not_issubnormal_or_zero_or_qnan_f:
; X86:       # %bb.0:
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X86-NEXT:    setl %cl
; X86-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X86-NEXT:    setge %dl
; X86-NEXT:    andb %cl, %dl
; X86-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X86-NEXT:    sete %cl
; X86-NEXT:    orb %dl, %cl
; X86-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X86-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X86-NEXT:    setb %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: not_issubnormal_or_zero_or_qnan_f:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movd %xmm0, %eax
; X64-GENERIC-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-GENERIC-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-GENERIC-NEXT:    setl %cl
; X64-GENERIC-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-GENERIC-NEXT:    setge %dl
; X64-GENERIC-NEXT:    andb %cl, %dl
; X64-GENERIC-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-GENERIC-NEXT:    sete %cl
; X64-GENERIC-NEXT:    orb %dl, %cl
; X64-GENERIC-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-GENERIC-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    orb %cl, %al
; X64-GENERIC-NEXT:    retq
;
; X64-NDD-LABEL: not_issubnormal_or_zero_or_qnan_f:
; X64-NDD:       # %bb.0:
; X64-NDD-NEXT:    movd %xmm0, %eax
; X64-NDD-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NDD-NEXT:    cmpl $2143289344, %eax # imm = 0x7FC00000
; X64-NDD-NEXT:    setl %cl
; X64-NDD-NEXT:    cmpl $2139095041, %eax # imm = 0x7F800001
; X64-NDD-NEXT:    setge %dl
; X64-NDD-NEXT:    andb %dl, %cl
; X64-NDD-NEXT:    cmpl $2139095040, %eax # imm = 0x7F800000
; X64-NDD-NEXT:    sete %dl
; X64-NDD-NEXT:    orb %dl, %cl
; X64-NDD-NEXT:    addl $-8388608, %eax # imm = 0xFF800000
; X64-NDD-NEXT:    cmpl $2130706432, %eax # imm = 0x7F000000
; X64-NDD-NEXT:    setb %al
; X64-NDD-NEXT:    orb %cl, %al
; X64-NDD-NEXT:    retq
  %class = tail call i1 @llvm.is.fpclass.f32(float %x, i32 781)  ; ~(0x90|0x2) = ~"subnormal|qnan"
  ret i1 %class
}

declare i1 @llvm.is.fpclass.f32(float, i32)
declare i1 @llvm.is.fpclass.f64(double, i32)
declare <1 x i1> @llvm.is.fpclass.v1f32(<1 x float>, i32)
declare <2 x i1> @llvm.is.fpclass.v2f32(<2 x float>, i32)
declare <4 x i1> @llvm.is.fpclass.v4f32(<4 x float>, i32)

; Assume DAZ
attributes #0 = { "denormal-fp-math"="ieee,preserve-sign" }

; Maybe daz
attributes #1 = { "denormal-fp-math"="ieee,dynamic" }
