; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,RV32 %s
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck --check-prefixes=CHECK,RV64 %s

define void @gather_const_v16i8(ptr %x) {
; CHECK-LABEL: gather_const_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lbu a1, 12(a0)
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, ptr %x
  %b = extractelement <16 x i8> %a, i32 12
  %c = insertelement <16 x i8> poison, i8 %b, i32 0
  %d = shufflevector <16 x i8> %c, <16 x i8> poison, <16 x i32> zeroinitializer
  store <16 x i8> %d, ptr %x
  ret void
}

define void @gather_const_v8i16(ptr %x) {
; CHECK-LABEL: gather_const_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lh a1, 10(a0)
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %b = extractelement <8 x i16> %a, i32 5
  %c = insertelement <8 x i16> poison, i16 %b, i32 0
  %d = shufflevector <8 x i16> %c, <8 x i16> poison, <8 x i32> zeroinitializer
  store <8 x i16> %d, ptr %x
  ret void
}

define void @gather_const_v4i32(ptr %x) {
; CHECK-LABEL: gather_const_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw a1, 12(a0)
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, ptr %x
  %b = extractelement <4 x i32> %a, i32 3
  %c = insertelement <4 x i32> poison, i32 %b, i32 0
  %d = shufflevector <4 x i32> %c, <4 x i32> poison, <4 x i32> zeroinitializer
  store <4 x i32> %d, ptr %x
  ret void
}

define void @gather_const_v2i64(ptr %x) {
; RV32-LABEL: gather_const_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, a0, 8
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v8, (a1), zero
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: gather_const_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    ld a1, 8(a0)
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vmv.v.x v8, a1
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %b = extractelement <2 x i64> %a, i32 1
  %c = insertelement <2 x i64> poison, i64 %b, i32 0
  %d = shufflevector <2 x i64> %c, <2 x i64> poison, <2 x i32> zeroinitializer
  store <2 x i64> %d, ptr %x
  ret void
}

define void @gather_const_v64i8(ptr %x) {
; CHECK-LABEL: gather_const_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lbu a1, 32(a0)
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <64 x i8>, ptr %x
  %b = extractelement <64 x i8> %a, i32 32
  %c = insertelement <64 x i8> poison, i8 %b, i32 0
  %d = shufflevector <64 x i8> %c, <64 x i8> poison, <64 x i32> zeroinitializer
  store <64 x i8> %d, ptr %x
  ret void
}

define void @gather_const_v16i16(ptr %x) {
; CHECK-LABEL: gather_const_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lh a1, 50(a0)
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <32 x i16>, ptr %x
  %b = extractelement <32 x i16> %a, i32 25
  %c = insertelement <32 x i16> poison, i16 %b, i32 0
  %d = shufflevector <32 x i16> %c, <32 x i16> poison, <32 x i32> zeroinitializer
  store <32 x i16> %d, ptr %x
  ret void
}

define void @gather_const_v16i32(ptr %x) {
; CHECK-LABEL: gather_const_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw a1, 36(a0)
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i32>, ptr %x
  %b = extractelement <16 x i32> %a, i32 9
  %c = insertelement <16 x i32> poison, i32 %b, i32 0
  %d = shufflevector <16 x i32> %c, <16 x i32> poison, <16 x i32> zeroinitializer
  store <16 x i32> %d, ptr %x
  ret void
}

define void @gather_const_v8i64(ptr %x) {
; RV32-LABEL: gather_const_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, a0, 24
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v8, (a1), zero
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: gather_const_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    ld a1, 24(a0)
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vmv.v.x v8, a1
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
  %a = load <8 x i64>, ptr %x
  %b = extractelement <8 x i64> %a, i32 3
  %c = insertelement <8 x i64> poison, i64 %b, i32 0
  %d = shufflevector <8 x i64> %c, <8 x i64> poison, <8 x i32> zeroinitializer
  store <8 x i64> %d, ptr %x
  ret void
}

define void @splat_concat_low(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: splat_concat_low:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lh a0, 2(a0)
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vse16.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <4 x i16>, ptr %x
  %b = load <4 x i16>, ptr %y
  %c = shufflevector <4 x i16> %a, <4 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %d = shufflevector <8 x i16> %c, <8 x i16> poison, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  store <8 x i16> %d, ptr %z
  ret void
}

define void @splat_concat_high(ptr %x, ptr %y, ptr %z) {
; CHECK-LABEL: splat_concat_high:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lh a0, 2(a1)
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vse16.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <4 x i16>, ptr %x
  %b = load <4 x i16>, ptr %y
  %c = shufflevector <4 x i16> %a, <4 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %d = shufflevector <8 x i16> %c, <8 x i16> poison, <8 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>
  store <8 x i16> %d, ptr %z
  ret void
}
