; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx600 < %s | FileCheck --check-prefixes=GFX6 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx700 < %s | FileCheck --check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 < %s | FileCheck --check-prefixes=GFX10-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX10-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -O0 -mcpu=gfx700 -amdgcn-skip-cache-invalidations < %s | FileCheck --check-prefixes=SKIP-CACHE-INV %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX90A-NOTTGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx90a -mattr=+tgsplit < %s | FileCheck -check-prefixes=GFX90A-TGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx940 < %s | FileCheck -check-prefixes=GFX940-NOTTGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx940 -mattr=+tgsplit < %s | FileCheck -check-prefixes=GFX940-TGSPLIT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 < %s | FileCheck --check-prefixes=GFX11-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX11-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 < %s | FileCheck --check-prefixes=GFX12-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX12-CU %s

define amdgpu_kernel void @local_singlethread_unordered_load(
; GFX6-LABEL: local_singlethread_unordered_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_unordered_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_unordered_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_unordered_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_unordered_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_unordered_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_unordered_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_unordered_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_unordered_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_unordered_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_unordered_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_unordered_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_unordered_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread") unordered, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_load(
; GFX6-LABEL: local_singlethread_monotonic_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread") monotonic, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_load(
; GFX6-LABEL: local_singlethread_acquire_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread") acquire, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_load(
; GFX6-LABEL: local_singlethread_seq_cst_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread") seq_cst, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_unordered_store(
; GFX6-LABEL: local_singlethread_unordered_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_unordered_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_unordered_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_unordered_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_unordered_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_unordered_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_unordered_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_unordered_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_unordered_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_unordered_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_unordered_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_unordered_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_unordered_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread") unordered, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_store(
; GFX6-LABEL: local_singlethread_monotonic_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread") monotonic, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_release_store(
; GFX6-LABEL: local_singlethread_release_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread") release, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_store(
; GFX6-LABEL: local_singlethread_seq_cst_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread") seq_cst, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_atomicrmw(
; GFX6-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_atomicrmw(
; GFX6-LABEL: local_singlethread_acquire_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_release_atomicrmw(
; GFX6-LABEL: local_singlethread_release_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") release
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_atomicrmw(
; GFX6-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") acq_rel
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_atomicrmw(
; GFX6-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_ret_atomicrmw(
; GFX6-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_ret_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_ret_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") acquire
  store i32 %val, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_ret_atomicrmw(
; GFX6-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_ret_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") acq_rel
  store i32 %val, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_ret_atomicrmw(
; GFX6-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_ret_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread") seq_cst
  store i32 %val, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") monotonic monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acquire monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_release_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") release monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acq_rel monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") seq_cst monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") monotonic acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acquire acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_release_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") release acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acq_rel acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") seq_cst acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") monotonic seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acquire seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_release_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") release seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acq_rel seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") seq_cst seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") monotonic monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acquire monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_release_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") release monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acq_rel monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") seq_cst monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") monotonic acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acquire acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_release_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") release acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acq_rel acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") seq_cst acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_monotonic_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_monotonic_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") monotonic seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_acquire_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acquire_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acquire seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_release_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_release_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") release seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_acq_rel_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_acq_rel_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") acq_rel seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_seq_cst_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_seq_cst_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread") seq_cst seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_unordered_load(
; GFX6-LABEL: local_singlethread_one_as_unordered_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_unordered_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_unordered_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_unordered_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_unordered_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_unordered_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_unordered_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_unordered_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_unordered_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_unordered_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_unordered_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_unordered_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_unordered_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread-one-as") unordered, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_load(
; GFX6-LABEL: local_singlethread_one_as_monotonic_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread-one-as") monotonic, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_load(
; GFX6-LABEL: local_singlethread_one_as_acquire_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread-one-as") acquire, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_load(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr4
; GFX6-NEXT:    ; kill: def $sgpr6 killed $sgpr5
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    ds_read_b32 v1, v0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    ds_read_b32 v1, v0
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    ds_read_b32 v1, v0
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    ds_read_b32 v1, v0
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    ds_read_b32 v1, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    ds_read_b32 v1, v0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    ds_load_b32 v1, v0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    ds_load_b32 v1, v0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    ds_load_b32 v1, v0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    ds_load_b32 v1, v0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %in, ptr addrspace(3) %out) {
entry:
  %val = load atomic i32, ptr addrspace(3) %in syncscope("singlethread-one-as") seq_cst, align 4
  store i32 %val, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_unordered_store(
; GFX6-LABEL: local_singlethread_one_as_unordered_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_unordered_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_unordered_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_unordered_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_unordered_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_unordered_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_unordered_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_unordered_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_unordered_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_unordered_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_unordered_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_unordered_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_unordered_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread-one-as") unordered, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_store(
; GFX6-LABEL: local_singlethread_one_as_monotonic_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread-one-as") monotonic, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_store(
; GFX6-LABEL: local_singlethread_one_as_release_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread-one-as") release, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_store(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    i32 %in, ptr addrspace(3) %out) {
entry:
  store atomic i32 %in, ptr addrspace(3) %out syncscope("singlethread-one-as") seq_cst, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") release
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") acq_rel
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr5
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s5
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v0, v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v0, v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_ret_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_ret_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") acquire
  store i32 %val, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_ret_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_ret_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") acq_rel
  store i32 %val, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_ret_atomicrmw(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    ds_wrxchg_rtn_b32 v1, v0, v1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_ret_atomicrmw:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[2:3], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[2:3], 0x4
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    ds_storexchg_rtn_b32 v1, v0, v1
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in) {
entry:
  %val = atomicrmw volatile xchg ptr addrspace(3) %out, i32 %in syncscope("singlethread-one-as") seq_cst
  store i32 %val, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") monotonic monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acquire monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") release monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acq_rel monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_monotonic_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_monotonic_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") seq_cst monotonic
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") monotonic acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acquire acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") release acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acq_rel acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_acquire_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_acquire_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") seq_cst acquire
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") monotonic seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acquire seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") release seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acq_rel seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_seq_cst_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX6-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX6-NEXT:    ; kill: def $sgpr4 killed $sgpr6
; GFX6-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX6-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x1
; GFX7-NEXT:    s_load_dword s5, s[8:9], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-WGP-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-WGP-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX10-CU-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX10-CU-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[8:9], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[8:9], 0x4
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[8:9], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s5
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[4:5], 0x4
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[4:5], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s1
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-TGSPLIT-NEXT:    ds_cmpst_b32 v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_seq_cst_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    ds_cmpstore_b32 v0, v1, v2 offset:16
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") seq_cst seq_cst
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") monotonic monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acquire monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") release monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acq_rel monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_monotonic_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") seq_cst monotonic
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") monotonic acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acquire acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") release acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acq_rel acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_acquire_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") seq_cst acquire
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_monotonic_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") monotonic seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acquire_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acquire seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_release_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_release_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") release seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_acq_rel_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") acq_rel seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg(
; GFX6-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX6-NEXT:    ; kill: def $sgpr5 killed $sgpr4
; GFX6-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX6-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    ds_write_b32 v0, v1
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX7-NEXT:    s_load_dword s5, s[6:7], 0x1
; GFX7-NEXT:    s_load_dword s6, s[6:7], 0x2
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    ds_write_b32 v0, v1
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-WGP-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    ds_write_b32 v0, v1
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX10-CU-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    ds_write_b32 v0, v1
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[2:3], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dword s1, s[2:3], 0x1
; SKIP-CACHE-INV-NEXT:    s_load_dword s2, s[2:3], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; SKIP-CACHE-INV-NEXT:    s_mov_b32 m0, -1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    ds_write_b32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX90A-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX90A-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-NOTTGSPLIT-NEXT:    s_nop 0
; GFX90A-NOTTGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX90A-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX90A-TGSPLIT:       ; %bb.0: ; %entry
; GFX90A-TGSPLIT-NEXT:    s_load_dword s4, s[6:7], 0x0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s5, s[6:7], 0x4
; GFX90A-TGSPLIT-NEXT:    s_nop 0
; GFX90A-TGSPLIT-NEXT:    s_load_dword s6, s[6:7], 0x8
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s6
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX90A-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s4
; GFX90A-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX90A-TGSPLIT-NEXT:    s_endpgm
;
; GFX940-NOTTGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX940-NOTTGSPLIT:       ; %bb.0: ; %entry
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-NOTTGSPLIT-NEXT:    s_nop 0
; GFX940-NOTTGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-NOTTGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-NOTTGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NOTTGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NOTTGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-NOTTGSPLIT-NEXT:    s_endpgm
;
; GFX940-TGSPLIT-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX940-TGSPLIT:       ; %bb.0: ; %entry
; GFX940-TGSPLIT-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX940-TGSPLIT-NEXT:    s_load_dword s1, s[2:3], 0x4
; GFX940-TGSPLIT-NEXT:    s_nop 0
; GFX940-TGSPLIT-NEXT:    s_load_dword s2, s[2:3], 0x8
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v2, s1
; GFX940-TGSPLIT-NEXT:    ds_cmpst_rtn_b32 v1, v0, v1, v2 offset:16
; GFX940-TGSPLIT-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-TGSPLIT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-TGSPLIT-NEXT:    ds_write_b32 v0, v1
; GFX940-TGSPLIT-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    ds_store_b32 v0, v1
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX11-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    ds_store_b32 v0, v1
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-WGP-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    ds_store_b32 v0, v1
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: local_singlethread_one_as_seq_cst_seq_cst_ret_cmpxchg:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b32 s2, s[4:5], 0x4
; GFX12-CU-NEXT:    s_load_b32 s1, s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    ds_cmpstore_rtn_b32 v1, v0, v1, v2 offset:16
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    ds_store_b32 v0, v1
; GFX12-CU-NEXT:    s_endpgm
    ptr addrspace(3) %out, i32 %in, i32 %old) {
entry:
  %gep = getelementptr i32, ptr addrspace(3) %out, i32 4
  %val = cmpxchg volatile ptr addrspace(3) %gep, i32 %old, i32 %in syncscope("singlethread-one-as") seq_cst seq_cst
  %val0 = extractvalue { i32, i1 } %val, 0
  store i32 %val0, ptr addrspace(3) %out, align 4
  ret void
}
