; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -global-isel-abort=2 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i8 @scmp.8.8(i8 %x, i8 %y) nounwind {
; CHECK-SD-LABEL: scmp.8.8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sxtb w8, w0
; CHECK-SD-NEXT:    cmp w8, w1, sxtb
; CHECK-SD-NEXT:    cset w8, gt
; CHECK-SD-NEXT:    csinv w0, w8, wzr, ge
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scmp.8.8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sxtb w8, w0
; CHECK-GI-NEXT:    sxtb w9, w1
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    cset w8, gt
; CHECK-GI-NEXT:    csinv w0, w8, wzr, ge
; CHECK-GI-NEXT:    ret
  %1 = call i8 @llvm.scmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @scmp.8.16(i16 %x, i16 %y) nounwind {
; CHECK-SD-LABEL: scmp.8.16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sxth w8, w0
; CHECK-SD-NEXT:    cmp w8, w1, sxth
; CHECK-SD-NEXT:    cset w8, gt
; CHECK-SD-NEXT:    csinv w0, w8, wzr, ge
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scmp.8.16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sxth w8, w0
; CHECK-GI-NEXT:    sxth w9, w1
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    cset w8, gt
; CHECK-GI-NEXT:    csinv w0, w8, wzr, ge
; CHECK-GI-NEXT:    ret
  %1 = call i8 @llvm.scmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @scmp.8.32(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: scmp.8.32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    cset w8, gt
; CHECK-NEXT:    csinv w0, w8, wzr, ge
; CHECK-NEXT:    ret
  %1 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @scmp.8.64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: scmp.8.64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x1
; CHECK-NEXT:    cset w8, gt
; CHECK-NEXT:    csinv w0, w8, wzr, ge
; CHECK-NEXT:    ret
  %1 = call i8 @llvm.scmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @scmp.8.128(i128 %x, i128 %y) nounwind {
; CHECK-SD-LABEL: scmp.8.128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp x2, x0
; CHECK-SD-NEXT:    sbcs xzr, x3, x1
; CHECK-SD-NEXT:    cset w8, lt
; CHECK-SD-NEXT:    cmp x0, x2
; CHECK-SD-NEXT:    sbcs xzr, x1, x3
; CHECK-SD-NEXT:    csinv w0, w8, wzr, ge
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scmp.8.128:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    cset w8, gt
; CHECK-GI-NEXT:    cmp x0, x2
; CHECK-GI-NEXT:    cset w9, hi
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    csel w8, w9, w8, eq
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    cset w8, ne
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    cset w9, lt
; CHECK-GI-NEXT:    cmp x0, x2
; CHECK-GI-NEXT:    cset w10, lo
; CHECK-GI-NEXT:    cmp x1, x3
; CHECK-GI-NEXT:    csel w9, w10, w9, eq
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csinv w0, w8, wzr, eq
; CHECK-GI-NEXT:    ret
  %1 = call i8 @llvm.scmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @scmp.32.32(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: scmp.32.32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    cset w8, gt
; CHECK-NEXT:    csinv w0, w8, wzr, ge
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.scmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @scmp.32.64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: scmp.32.64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x1
; CHECK-NEXT:    cset w8, gt
; CHECK-NEXT:    csinv w0, w8, wzr, ge
; CHECK-NEXT:    ret
  %1 = call i32 @llvm.scmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @scmp.64.64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: scmp.64.64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x1
; CHECK-NEXT:    cset x8, gt
; CHECK-NEXT:    csinv x0, x8, xzr, ge
; CHECK-NEXT:    ret
  %1 = call i64 @llvm.scmp(i64 %x, i64 %y)
  ret i64 %1
}
