; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 %s -o - -global-isel -global-isel-abort=2 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <1 x i64> @v1i64(<1 x i64> %a) {
; CHECK-SD-LABEL: v1i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v1i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    lsr x8, x8, #31
; CHECK-GI-NEXT:    and x8, x8, #0x100000001
; CHECK-GI-NEXT:    lsl x9, x8, #32
; CHECK-GI-NEXT:    sub x8, x9, x8
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
  %b = lshr <1 x i64> %a, <i64 31>
  %c = and <1 x i64> %b, <i64 4294967297>
  %d = mul nuw <1 x i64> %c, <i64 4294967295>
  ret <1 x i64> %d
}

define <2 x i64> @v2i64(<2 x i64> %a) {
; CHECK-LABEL: v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmlt v0.4s, v0.4s, #0
; CHECK-NEXT:    ret
  %b = lshr <2 x i64> %a, <i64 31, i64 31>
  %c = and <2 x i64> %b, <i64 4294967297, i64 4294967297>
  %d = mul nuw <2 x i64> %c, <i64 4294967295, i64 4294967295>
  ret <2 x i64> %d
}

define <2 x i32> @v2i32(<2 x i32> %a) {
; CHECK-LABEL: v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmlt v0.4h, v0.4h, #0
; CHECK-NEXT:    ret
  %b = lshr <2 x i32> %a, <i32 15, i32 15>
  %c = and <2 x i32> %b, <i32 65537, i32 65537>
  %d = mul nuw <2 x i32> %c, <i32 65535, i32 65535>
  ret <2 x i32> %d
}

define <4 x i32> @v4i32(<4 x i32> %a) {
; CHECK-LABEL: v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmlt v0.8h, v0.8h, #0
; CHECK-NEXT:    ret
  %b = lshr <4 x i32> %a, <i32 15, i32 15, i32 15, i32 15>
  %c = and <4 x i32> %b, <i32 65537, i32 65537, i32 65537, i32 65537>
  %d = mul nuw <4 x i32> %c, <i32 65535, i32 65535, i32 65535, i32 65535>
  ret <4 x i32> %d
}

define <8 x i32> @v8i32(<8 x i32> %a) {
; CHECK-LABEL: v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmlt v0.8h, v0.8h, #0
; CHECK-NEXT:    cmlt v1.8h, v1.8h, #0
; CHECK-NEXT:    ret
  %b = lshr <8 x i32> %a, <i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15>
  %c = and <8 x i32> %b, <i32 65537, i32 65537, i32 65537, i32 65537, i32 65537, i32 65537, i32 65537, i32 65537>
  %d = mul nuw <8 x i32> %c, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  ret <8 x i32> %d
}

define <4 x i16> @v4i16(<4 x i16> %a) {
; CHECK-LABEL: v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmlt v0.8b, v0.8b, #0
; CHECK-NEXT:    ret
  %b = lshr <4 x i16> %a, <i16 7, i16 7, i16 7, i16 7>
  %c = and <4 x i16> %b, <i16 257, i16 257, i16 257, i16 257>
  %d = mul nuw <4 x i16> %c, <i16 255, i16 255, i16 255, i16 255>
  ret <4 x i16> %d
}

define <8 x i16> @v8i16(<8 x i16> %a) {
; CHECK-LABEL: v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmlt v0.16b, v0.16b, #0
; CHECK-NEXT:    ret
  %b = lshr <8 x i16> %a, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  %c = and <8 x i16> %b, <i16 257, i16 257, i16 257, i16 257, i16 257, i16 257, i16 257, i16 257>
  %d = mul nuw <8 x i16> %c, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  ret <8 x i16> %d
}

define <8 x i8> @v8i8(<8 x i8> %a) {
; CHECK-LABEL: v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8b, #17
; CHECK-NEXT:    ushr v0.8b, v0.8b, #3
; CHECK-NEXT:    movi v2.8b, #15
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    mul v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    ret
  %b = lshr <8 x i8> %a, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %c = and <8 x i8> %b, <i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17>
  %d = mul nuw <8 x i8> %c, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  ret <8 x i8> %d
}

define <16 x i8> @v16i8(<16 x i8> %a) {
; CHECK-LABEL: v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #17
; CHECK-NEXT:    ushr v0.16b, v0.16b, #3
; CHECK-NEXT:    movi v2.16b, #15
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mul v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %b = lshr <16 x i8> %a, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %c = and <16 x i8> %b, <i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17>
  %d = mul nuw <16 x i8> %c, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  ret <16 x i8> %d
}

