; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -O0 -stop-after=irtranslator -verify-machineinstrs -o - %s | FileCheck %s

define i12 @v1i12(<1 x i12> %v) {
  ; CHECK-LABEL: name: v1i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s12) = G_TRUNC [[COPY]](s32)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <1 x i12> %v, i32 0
  ret i12 %r
}

define i12 @v2i12(<2 x i12> %v) {
  ; CHECK-LABEL: name: v2i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $d0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<2 x s32>) = COPY $d0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<2 x s12>) = G_TRUNC [[COPY]](<2 x s32>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<2 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <2 x i12> %v, i32 1
  ret i12 %r
}

define i12 @v3i12(<3 x i12> %v) {
  ; CHECK-LABEL: name: v3i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1, $w2
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $w2
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<3 x s12>) = G_TRUNC [[BUILD_VECTOR]](<3 x s32>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<3 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <3 x i12> %v, i32 1
  ret i12 %r
}

define i12 @v4i12(<4 x i12> %v) {
  ; CHECK-LABEL: name: v4i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $d0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<4 x s16>) = COPY $d0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<4 x s12>) = G_TRUNC [[COPY]](<4 x s16>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<4 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <4 x i12> %v, i32 1
  ret i12 %r
}

define i12 @v5i12(<5 x i12> %v) {
  ; CHECK-LABEL: name: v5i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1, $w2, $w3, $w4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $w2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $w3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $w4
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<5 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<5 x s12>) = G_TRUNC [[BUILD_VECTOR]](<5 x s32>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<5 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <5 x i12> %v, i32 1
  ret i12 %r
}

define i12 @v6i12(<6 x i12> %v) {
  ; CHECK-LABEL: name: v6i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1, $w2, $w3, $w4, $w5
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $w2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $w3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $w4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $w5
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<6 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<6 x s12>) = G_TRUNC [[BUILD_VECTOR]](<6 x s32>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<6 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <6 x i12> %v, i32 1
  ret i12 %r
}

define i12 @v7i12(<7 x i12> %v) {
  ; CHECK-LABEL: name: v7i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1, $w2, $w3, $w4, $w5, $w6
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $w2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $w3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $w4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $w5
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $w6
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<7 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<7 x s12>) = G_TRUNC [[BUILD_VECTOR]](<7 x s32>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<7 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <7 x i12> %v, i32 1
  ret i12 %r
}

define i12 @v8i12(<8 x i12> %v) {
  ; CHECK-LABEL: name: v8i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $q0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<8 x s16>) = COPY $q0
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<8 x s12>) = G_TRUNC [[COPY]](<8 x s16>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<8 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <8 x i12> %v, i32 1
  ret i12 %r
}

define i12 @v12i12(<12 x i12> %v) {
  ; CHECK-LABEL: name: v12i12
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $w0, $w1, $w2, $w3, $w4, $w5, $w6, $w7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $w2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $w3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $w4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $w5
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $w6
  ; CHECK-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $w7
  ; CHECK-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK-NEXT:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (invariant load (s32) from %fixed-stack.3, align 16)
  ; CHECK-NEXT:   [[FRAME_INDEX1:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK-NEXT:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p0) :: (invariant load (s32) from %fixed-stack.2, align 8)
  ; CHECK-NEXT:   [[FRAME_INDEX2:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK-NEXT:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p0) :: (invariant load (s32) from %fixed-stack.1, align 16)
  ; CHECK-NEXT:   [[FRAME_INDEX3:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK-NEXT:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p0) :: (invariant load (s32) from %fixed-stack.0, align 8)
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<12 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[LOAD]](s32), [[LOAD1]](s32), [[LOAD2]](s32), [[LOAD3]](s32)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(<12 x s12>) = G_TRUNC [[BUILD_VECTOR]](<12 x s32>)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s12) = G_EXTRACT_VECTOR_ELT [[TRUNC]](<12 x s12>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[EVEC]](s12)
  ; CHECK-NEXT:   $w0 = COPY [[ANYEXT]](s32)
  ; CHECK-NEXT:   RET_ReallyLR implicit $w0
  %r = extractelement <12 x i12> %v, i32 1
  ret i12 %r
}


define i100 @v1i100(<1 x i100> %v) {
  ; CHECK-LABEL: name: v1i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s128) = G_ANYEXT [[TRUNC]](s100)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](s128)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1
  %r = extractelement <1 x i100> %v, i32 0
  ret i100 %r
}

define i100 @v2i100(<2 x i100> %v) {
  ; CHECK-LABEL: name: v2i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s100>) = G_BUILD_VECTOR [[TRUNC]](s100), [[TRUNC1]](s100)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s100) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<2 x s100>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s128) = G_ANYEXT [[EVEC]](s100)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](s128)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1
  %r = extractelement <2 x i100> %v, i32 1
  ret i100 %r
}

define i100 @v3i100(<3 x i100> %v) {
  ; CHECK-LABEL: name: v3i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3, $x4, $x5
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[MV2:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY4]](s64), [[COPY5]](s64)
  ; CHECK-NEXT:   [[TRUNC2:%[0-9]+]]:_(s100) = G_TRUNC [[MV2]](s128)
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s100>) = G_BUILD_VECTOR [[TRUNC]](s100), [[TRUNC1]](s100), [[TRUNC2]](s100)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s100) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<3 x s100>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s128) = G_ANYEXT [[EVEC]](s100)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](s128)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1
  %r = extractelement <3 x i100> %v, i32 1
  ret i100 %r
}

define i100 @v4i100(<4 x i100> %v) {
  ; CHECK-LABEL: name: v4i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK-NEXT:   [[COPY7:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[MV2:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY4]](s64), [[COPY5]](s64)
  ; CHECK-NEXT:   [[TRUNC2:%[0-9]+]]:_(s100) = G_TRUNC [[MV2]](s128)
  ; CHECK-NEXT:   [[MV3:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY6]](s64), [[COPY7]](s64)
  ; CHECK-NEXT:   [[TRUNC3:%[0-9]+]]:_(s100) = G_TRUNC [[MV3]](s128)
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<4 x s100>) = G_BUILD_VECTOR [[TRUNC]](s100), [[TRUNC1]](s100), [[TRUNC2]](s100), [[TRUNC3]](s100)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s100) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<4 x s100>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s128) = G_ANYEXT [[EVEC]](s100)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](s128)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1
  %r = extractelement <4 x i100> %v, i32 1
  ret i100 %r
}

define i100 @v8i100(<8 x i100> %v) {
  ; CHECK-LABEL: name: v8i100
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x6
  ; CHECK-NEXT:   [[COPY7:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.7
  ; CHECK-NEXT:   [[LOAD:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX]](p0) :: (invariant load (s64) from %fixed-stack.7, align 16)
  ; CHECK-NEXT:   [[FRAME_INDEX1:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.6
  ; CHECK-NEXT:   [[LOAD1:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX1]](p0) :: (invariant load (s64) from %fixed-stack.6)
  ; CHECK-NEXT:   [[FRAME_INDEX2:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.5
  ; CHECK-NEXT:   [[LOAD2:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX2]](p0) :: (invariant load (s64) from %fixed-stack.5, align 16)
  ; CHECK-NEXT:   [[FRAME_INDEX3:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.4
  ; CHECK-NEXT:   [[LOAD3:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX3]](p0) :: (invariant load (s64) from %fixed-stack.4)
  ; CHECK-NEXT:   [[FRAME_INDEX4:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK-NEXT:   [[LOAD4:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX4]](p0) :: (invariant load (s64) from %fixed-stack.3, align 16)
  ; CHECK-NEXT:   [[FRAME_INDEX5:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK-NEXT:   [[LOAD5:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX5]](p0) :: (invariant load (s64) from %fixed-stack.2)
  ; CHECK-NEXT:   [[FRAME_INDEX6:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK-NEXT:   [[LOAD6:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX6]](p0) :: (invariant load (s64) from %fixed-stack.1, align 16)
  ; CHECK-NEXT:   [[FRAME_INDEX7:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK-NEXT:   [[LOAD7:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX7]](p0) :: (invariant load (s64) from %fixed-stack.0)
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s100) = G_TRUNC [[MV]](s128)
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s100) = G_TRUNC [[MV1]](s128)
  ; CHECK-NEXT:   [[MV2:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY4]](s64), [[COPY5]](s64)
  ; CHECK-NEXT:   [[TRUNC2:%[0-9]+]]:_(s100) = G_TRUNC [[MV2]](s128)
  ; CHECK-NEXT:   [[MV3:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY6]](s64), [[COPY7]](s64)
  ; CHECK-NEXT:   [[TRUNC3:%[0-9]+]]:_(s100) = G_TRUNC [[MV3]](s128)
  ; CHECK-NEXT:   [[MV4:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[LOAD]](s64), [[LOAD1]](s64)
  ; CHECK-NEXT:   [[TRUNC4:%[0-9]+]]:_(s100) = G_TRUNC [[MV4]](s128)
  ; CHECK-NEXT:   [[MV5:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[LOAD2]](s64), [[LOAD3]](s64)
  ; CHECK-NEXT:   [[TRUNC5:%[0-9]+]]:_(s100) = G_TRUNC [[MV5]](s128)
  ; CHECK-NEXT:   [[MV6:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[LOAD4]](s64), [[LOAD5]](s64)
  ; CHECK-NEXT:   [[TRUNC6:%[0-9]+]]:_(s100) = G_TRUNC [[MV6]](s128)
  ; CHECK-NEXT:   [[MV7:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[LOAD6]](s64), [[LOAD7]](s64)
  ; CHECK-NEXT:   [[TRUNC7:%[0-9]+]]:_(s100) = G_TRUNC [[MV7]](s128)
  ; CHECK-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s100>) = G_BUILD_VECTOR [[TRUNC]](s100), [[TRUNC1]](s100), [[TRUNC2]](s100), [[TRUNC3]](s100), [[TRUNC4]](s100), [[TRUNC5]](s100), [[TRUNC6]](s100), [[TRUNC7]](s100)
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s100) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<8 x s100>), [[C]](s64)
  ; CHECK-NEXT:   [[ANYEXT:%[0-9]+]]:_(s128) = G_ANYEXT [[EVEC]](s100)
  ; CHECK-NEXT:   [[UV:%[0-9]+]]:_(s64), [[UV1:%[0-9]+]]:_(s64) = G_UNMERGE_VALUES [[ANYEXT]](s128)
  ; CHECK-NEXT:   $x0 = COPY [[UV]](s64)
  ; CHECK-NEXT:   $x1 = COPY [[UV1]](s64)
  ; CHECK-NEXT:   RET_ReallyLR implicit $x0, implicit $x1
  %r = extractelement <8 x i100> %v, i32 1
  ret i100 %r
}
