.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_execute n "26 September 2016" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_execute \- send a query and optionally loop over the results
.SH SYNOPSIS
.nf

pg_execute [\-array \*(T<arrayVar\*(T>] [\-oid \*(T<oidVar\*(T>] \*(T<conn\*(T> \*(T<commandString\*(T> [\*(T<procedure\*(T>]
.fi
.SH DESCRIPTION
\*(T<\fBpg_execute\fR\*(T> submits a command to the
PostgreSQL server.
.PP
If the command is not a \fBSELECT\fR statement, the
number of rows affected by the command is returned. If the command
is an \fBINSERT\fR statement and a single row is
inserted, the OID of the inserted row is stored in the variable
\*(T<oidVar\*(T> if the optional \*(T<\-oid\*(T>
argument is supplied.
.PP
If the command is a \fBSELECT\fR statement, then, for
each row in the result, the row values are stored in the
\*(T<arrayVar\*(T> variable, if supplied, using the
column names as the array indices, else in variables named by the
column names, and then the optional
\*(T<procedure\*(T> is executed if supplied.
(Omitting the \*(T<procedure\*(T> probably makes sense
only if the query will return a single row.) The number of rows
selected is returned.
.PP
The \*(T<procedure\*(T> can use the Tcl commands
\*(T<break\*(T>, \*(T<continue\*(T>, and
\*(T<return\*(T> with the expected behavior. Note that if
the \*(T<procedure\*(T> executes
\*(T<return\*(T>, then \*(T<\fBpg_execute\fR\*(T>
does not return the number of affected rows.
.PP
\*(T<\fBpg_execute\fR\*(T> is a newer function which provides
a superset of the features of \*(T<\fBpg_select\fR\*(T> and
can replace \*(T<\fBpg_exec\fR\*(T> in many cases where access
to the result handle is not needed.
.PP
For server-handled errors, \*(T<\fBpg_execute\fR\*(T> will
throw a Tcl error and return a two-element list. The first element
is an error code, such as \*(T<PGRES_FATAL_ERROR\*(T>, and
the second element is the server error text. For more serious
errors, such as failure to communicate with the server,
\*(T<\fBpg_execute\fR\*(T> will throw a Tcl error and return
just the error message text.
.SH ARGUMENTS
.TP 
\*(T<\fB\-array \fR\*(T>\*(T<\fBarrayVar\fR\*(T>
Specifies the name of an array variable where result rows are
stored, indexed by the column names. This is ignored if
\*(T<commandString\*(T> is not a \fBSELECT\fR
statement.
.TP 
\*(T<\fB\-oid \fR\*(T>\*(T<\fBoidVar\fR\*(T>
Specifies the name of a variable into which the OID from an
\fBINSERT\fR statement will be stored.
.TP 
\*(T<conn\*(T>
The handle of the connection on which to execute the command.
.TP 
\*(T<commandString\*(T>
The SQL command to execute.
.TP 
\*(T<procedure\*(T>
Optional procedure to execute for each result row of a
\fBSELECT\fR statement.
.SH "RETURN VALUE"
The number of rows affected or returned by the command.
.SH EXAMPLES
In the following examples, error checking with
\*(T<catch\*(T> has been omitted for clarity.
.PP
Insert a row and save the OID in \*(T<result_oid\*(T>:

.nf
\*(T<
pg_execute \-oid result_oid $pgconn "INSERT INTO mytable VALUES (1);"
\*(T>
.fi
.PP
Print the columns \*(T<item\*(T> and \*(T<value\*(T> from each
row:

.nf
\*(T<
pg_execute \-array d $pgconn "SELECT item, value FROM mytable;" {
    puts "Item=$d(item) Value=$d(value)"
}
\*(T>
.fi
.PP
Find the maximum and minimum values and store them in
\*(T<$s(max)\*(T> and \*(T<$s(min)\*(T>:

.nf
\*(T<
pg_execute \-array s $pgconn "SELECT max(value) AS max, min(value) AS min FROM mytable;"
\*(T>
.fi
.PP
Find the maximum and minimum values and store them in
\*(T<$max\*(T> and \*(T<$min\*(T>:

.nf
\*(T<
pg_execute $pgconn "SELECT max(value) AS max, min(value) AS min FROM mytable;"
\*(T>
.fi
