/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 *  Copyright (C) 2001 Ben. Herrenschmidt (benh@kernel.crashing.org)
 */

static struct cpu_spec cpu_specs[] __initdata = {
	{	/* STB 04xxx */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x41810000,
		.cpu_name		= "STB04xxx",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* NP405L */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x41610000,
		.cpu_name		= "NP405L",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* NP4GS3 */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x40B10000,
		.cpu_name		= "NP4GS3",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{   /* NP405H */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x41410000,
		.cpu_name		= "NP405H",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405GPr */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x50910000,
		.cpu_name		= "405GPr",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{   /* STBx25xx */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x51510000,
		.cpu_name		= "STBx25xx",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405LP */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x41F10000,
		.cpu_name		= "405LP",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EP */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x51210000,
		.cpu_name		= "405EP",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EX Rev. A/B with Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x12910007,
		.cpu_name		= "405EX Rev. A/B",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EX Rev. C without Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x1291000d,
		.cpu_name		= "405EX Rev. C",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EX Rev. C with Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x1291000f,
		.cpu_name		= "405EX Rev. C",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EX Rev. D without Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x12910003,
		.cpu_name		= "405EX Rev. D",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EX Rev. D with Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x12910005,
		.cpu_name		= "405EX Rev. D",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EXr Rev. A/B without Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x12910001,
		.cpu_name		= "405EXr Rev. A/B",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EXr Rev. C without Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x12910009,
		.cpu_name		= "405EXr Rev. C",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EXr Rev. C with Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x1291000b,
		.cpu_name		= "405EXr Rev. C",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EXr Rev. D without Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x12910000,
		.cpu_name		= "405EXr Rev. D",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* 405EXr Rev. D with Security */
		.pvr_mask		= 0xffff000f,
		.pvr_value		= 0x12910002,
		.cpu_name		= "405EXr Rev. D",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{
		/* 405EZ */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x41510000,
		.cpu_name		= "405EZ",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* APM8018X */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x7ff11432,
		.cpu_name		= "APM8018X",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	},
	{	/* default match */
		.pvr_mask		= 0x00000000,
		.pvr_value		= 0x00000000,
		.cpu_name		= "(generic 40x PPC)",
		.cpu_features		= CPU_FTRS_40X,
		.cpu_user_features	= PPC_FEATURE_32 | PPC_FEATURE_HAS_MMU |
					  PPC_FEATURE_HAS_4xxMAC,
		.mmu_features		= MMU_FTR_TYPE_40x,
		.icache_bsize		= 32,
		.dcache_bsize		= 32,
		.machine_check		= machine_check_4xx,
		.platform		= "ppc405",
	}
};
