/***********************************************************************************************************************
 * Copyright [2020-2021] Renesas Electronics Corporation and/or its affiliates.  All Rights Reserved.
 *
 * This software and documentation are supplied by Renesas Electronics America Inc. and may only be used with products
 * of Renesas Electronics Corp. and its affiliates ("Renesas").  No other uses are authorized.  Renesas products are
 * sold pursuant to Renesas terms and conditions of sale.  Purchasers are solely responsible for the selection and use
 * of Renesas products and Renesas assumes no liability.  No license, express or implied, to any intellectual property
 * right is granted by Renesas. This software is protected under all applicable laws, including copyright laws. Renesas
 * reserves the right to change or discontinue this software and/or this documentation. THE SOFTWARE AND DOCUMENTATION
 * IS DELIVERED TO YOU "AS IS," AND RENESAS MAKES NO REPRESENTATIONS OR WARRANTIES, AND TO THE FULLEST EXTENT
 * PERMISSIBLE UNDER APPLICABLE LAW, DISCLAIMS ALL WARRANTIES, WHETHER EXPLICITLY OR IMPLICITLY, INCLUDING WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NONINFRINGEMENT, WITH RESPECT TO THE SOFTWARE OR
 * DOCUMENTATION.  RENESAS SHALL HAVE NO LIABILITY ARISING OUT OF ANY SECURITY VULNERABILITY OR BREACH.  TO THE MAXIMUM
 * EXTENT PERMITTED BY LAW, IN NO EVENT WILL RENESAS BE LIABLE TO YOU IN CONNECTION WITH THE SOFTWARE OR DOCUMENTATION
 * (OR ANY PERSON OR ENTITY CLAIMING RIGHTS DERIVED FROM YOU) FOR ANY LOSS, DAMAGES, OR CLAIMS WHATSOEVER, INCLUDING,
 * WITHOUT LIMITATION, ANY DIRECT, CONSEQUENTIAL, SPECIAL, INDIRECT, PUNITIVE, OR INCIDENTAL DAMAGES; ANY LOST PROFITS,
 * OTHER ECONOMIC DAMAGE, PROPERTY DAMAGE, OR PERSONAL INJURY; AND EVEN IF RENESAS HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH LOSS, DAMAGES, CLAIMS OR COSTS.
 **********************************************************************************************************************/

/* Ensure Renesas MCU variation definitions are included to ensure MCU
 * specific register variations are handled correctly. */
#ifndef BSP_FEATURE_H
 #error "INTERNAL ERROR: bsp_feature.h must be included before renesas.h."
#endif

/** @addtogroup Renesas
 * @{
 */

/** @addtogroup RA
 * @{
 */

#ifndef RA_H
 #define RA_H

 #ifdef __cplusplus
extern "C" {
 #endif

 #include "cmsis_compiler.h"

/** @addtogroup Configuration_of_CMSIS
 * @{
 */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */
/* IRQn_Type is generated as part of an FSP project. It can be found in vector_data.h. */

/** @} */ /* End of group Configuration_of_CMSIS */

/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

 #if   __ARM_ARCH_7EM__
  #define RENESAS_CORTEX_M4
 #elif __ARM_ARCH_6M__
  #define RENESAS_CORTEX_M0PLUS
 #elif __ARM_ARCH_8M_BASE__
  #define RENESAS_CORTEX_M23
 #elif __ARM_ARCH_8M_MAIN__
  #define RENESAS_CORTEX_M33
 #else
  #warning Unsupported Architecture
 #endif

/* ----------------Configuration of the Cortex-M Processor and Core Peripherals---------------- */
 #ifdef RENESAS_CORTEX_M4
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          4  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             1  /*!< FPU present or not                                                    */
  #include "core_cm4.h"                /*!< Cortex-M4 processor and core peripherals                              */
 #elif defined(RENESAS_CORTEX_M0PLUS)
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          2  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             0  /*!< FPU present or not                                                    */
  #define __VTOR_PRESENT            1  /*!< Vector table VTOR register available or not                           */
  #include "core_cm0plus.h"            /*!< Cortex-M0 processor and core peripherals                              */
 #elif defined(RENESAS_CORTEX_M23)
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          2  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             0  /*!< FPU present or not                                                    */
  #define __VTOR_PRESENT            1  /*!< Vector table VTOR register available or not                           */
  #include "core_cm23.h"               /*!< Cortex-M23 processor and core peripherals                             */
 #elif defined(RENESAS_CORTEX_M33)
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          4  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             1  /*!< FPU present or not                                                    */
  #define __VTOR_PRESENT            1  /*!< Vector table VTOR register available or not                           */
  #define __DSP_PRESENT             1  /*!< DSP present or not                                                    */
  #include "core_cm33.h"               /*!< Cortex-M33 processor and core peripherals                             */
 #endif

 #include "system.h"                   /*!< System                                                                */

 #ifndef __IM                          /*!< Fallback for older CMSIS versions                                         */
  #define __IM     __I
 #endif
 #ifndef __OM                          /*!< Fallback for older CMSIS versions                                         */
  #define __OM     __O
 #endif
 #ifndef __IOM                         /*!< Fallback for older CMSIS versions                                         */
  #define __IOM    __IO
 #endif

/* ========================================  Start of section using anonymous unions  ======================================== */
 #if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
 #elif defined(__ICCARM__)
  #pragma language=extended
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning 586
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #else
  #warning Not supported compiler type
 #endif

/* =========================================================================================================================== */
/* ================                              Device Specific Cluster Section                              ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_clusters
 * @{
 */

/**
 * @brief R_BUS_CSa [CSa] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t MOD;            /*!< (@ 0x00000002) Mode Register                                              */

        struct
        {
            __IOM uint16_t WRMOD : 1;  /*!< [0..0] Write Access Mode Select                                           */
            uint16_t             : 2;
            __IOM uint16_t EWENB : 1;  /*!< [3..3] External Wait Enable                                               */
            uint16_t             : 4;
            __IOM uint16_t PRENB : 1;  /*!< [8..8] Page Read Access Enable                                            */
            __IOM uint16_t PWENB : 1;  /*!< [9..9] Page Write Access Enable                                           */
            uint16_t             : 5;
            __IOM uint16_t PRMOD : 1;  /*!< [15..15] Page Read Access Mode Select                                     */
        } MOD_b;
    };

    union
    {
        __IOM uint32_t WCR1;             /*!< (@ 0x00000004) Wait Control Register 1                                    */

        struct
        {
            __IOM uint32_t CSPWWAIT : 3; /*!< [2..0] Page Write Cycle Wait SelectNOTE: The CSPWWAIT value
                                          *   is valid only when the PWENB bit in CSnMOD is set to 1.                   */
            uint32_t                : 5;
            __IOM uint32_t CSPRWAIT : 3; /*!< [10..8] Page Read Cycle Wait SelectNOTE: The CSPRWAIT value
                                          *   is valid only when the PRENB bit in CSnMOD is set to 1.                   */
            uint32_t               : 5;
            __IOM uint32_t CSWWAIT : 5;  /*!< [20..16] Normal Write Cycle Wait Select                                   */
            uint32_t               : 3;
            __IOM uint32_t CSRWAIT : 5;  /*!< [28..24] Normal Read Cycle Wait Select                                    */
            uint32_t               : 3;
        } WCR1_b;
    };

    union
    {
        __IOM uint32_t WCR2;           /*!< (@ 0x00000008) Wait Control Register 2                                    */

        struct
        {
            __IOM uint32_t CSROFF : 3; /*!< [2..0] Read-Access CS Extension Cycle Select                              */
            uint32_t              : 1;
            __IOM uint32_t CSWOFF : 3; /*!< [6..4] Write-Access CS Extension Cycle Select                             */
            uint32_t              : 1;
            __IOM uint32_t WDOFF  : 3; /*!< [10..8] Write Data Output Extension Cycle Select                          */
            uint32_t              : 1;
            __IOM uint32_t AWAIT  : 2; /*!< [13..12] CS Assert Wait Select                                            */
            uint32_t              : 2;
            __IOM uint32_t RDON   : 3; /*!< [18..16] RD Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WRON   : 3; /*!< [22..20] WR Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WDON   : 3; /*!< [26..24] Write Data Output Wait Select                                    */
            uint32_t              : 1;
            __IOM uint32_t CSON   : 3; /*!< [30..28] CS Assert Wait Select                                            */
            uint32_t              : 1;
        } WCR2_b;
    };
    __IM uint32_t RESERVED1;
} R_BUS_CSa_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_CSb [CSb] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CR;             /*!< (@ 0x00000002) Control Register                                           */

        struct
        {
            __IOM uint16_t EXENB : 1;  /*!< [0..0] Operation Enable                                                   */
            uint16_t             : 3;
            __IOM uint16_t BSIZE : 2;  /*!< [5..4] External Bus Width Select                                          */
            uint16_t             : 2;
            __IOM uint16_t EMODE : 1;  /*!< [8..8] Endian Mode                                                        */
            uint16_t             : 3;
            __IOM uint16_t MPXEN : 1;  /*!< [12..12] Address/Data Multiplexed I/O Interface Select                    */
            uint16_t             : 3;
        } CR_b;
    };
    __IM uint16_t RESERVED1[3];

    union
    {
        __IOM uint16_t REC;            /*!< (@ 0x0000000A) Recovery Cycle Register                                    */

        struct
        {
            __IOM uint16_t RRCV : 4;   /*!< [3..0] Read Recovery                                                      */
            uint16_t            : 4;
            __IOM uint16_t WRCV : 4;   /*!< [11..8] Write Recovery                                                    */
            uint16_t            : 4;
        } REC_b;
    };
    __IM uint16_t RESERVED2[2];
} R_BUS_CSb_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_SDRAM [SDRAM] (SDRAM Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t SDCCR;           /*!< (@ 0x00000000) SDC Control Register                                       */

        struct
        {
            __IOM uint8_t EXENB : 1;   /*!< [0..0] Operation Enable                                                   */
            uint8_t             : 3;
            __IOM uint8_t BSIZE : 2;   /*!< [5..4] SDRAM Bus Width Select                                             */
            uint8_t             : 2;
        } SDCCR_b;
    };

    union
    {
        __IOM uint8_t SDCMOD;          /*!< (@ 0x00000001) SDC Mode Register                                          */

        struct
        {
            __IOM uint8_t EMODE : 1;   /*!< [0..0] Endian Mode                                                        */
            uint8_t             : 7;
        } SDCMOD_b;
    };

    union
    {
        __IOM uint8_t SDAMOD;          /*!< (@ 0x00000002) SDRAM Access Mode Register                                 */

        struct
        {
            __IOM uint8_t BE : 1;      /*!< [0..0] Continuous Access Enable                                           */
            uint8_t          : 7;
        } SDAMOD_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint32_t RESERVED1[3];

    union
    {
        __IOM uint8_t SDSELF;          /*!< (@ 0x00000010) SDRAM Self-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t SFEN : 1;    /*!< [0..0] SDRAM Self-Refresh Enable                                          */
            uint8_t            : 7;
        } SDSELF_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t SDRFCR;         /*!< (@ 0x00000014) SDRAM Refresh Control Register                             */

        struct
        {
            __IOM uint16_t RFC  : 12;  /*!< [11..0] Auto-Refresh Request Interval Setting                             */
            __IOM uint16_t REFW : 4;   /*!< [15..12] Auto-Refresh Cycle/ Self-Refresh Clearing Cycle Count
                                        *   Setting. ( REFW+1 Cycles )                                                */
        } SDRFCR_b;
    };

    union
    {
        __IOM uint8_t SDRFEN;          /*!< (@ 0x00000016) SDRAM Auto-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t RFEN : 1;    /*!< [0..0] Auto-Refresh Operation Enable                                      */
            uint8_t            : 7;
        } SDRFEN_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint8_t SDICR;           /*!< (@ 0x00000020) SDRAM Initialization Sequence Control Register             */

        struct
        {
            __IOM uint8_t INIRQ : 1;   /*!< [0..0] Initialization Sequence Start                                      */
            uint8_t             : 7;
        } SDICR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t SDIR;           /*!< (@ 0x00000024) SDRAM Initialization Register                              */

        struct
        {
            __IOM uint16_t ARFI : 4;   /*!< [3..0] Initialization Auto-Refresh Interval ( PRF+3 cycles )              */
            __IOM uint16_t ARFC : 4;   /*!< [7..4] Initialization Auto-Refresh Count                                  */
            __IOM uint16_t PRC  : 3;   /*!< [10..8] Initialization Precharge Cycle Count ( PRF+3 cycles
                                        *   )                                                                         */
            uint16_t : 5;
        } SDIR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[6];

    union
    {
        __IOM uint8_t SDADR;           /*!< (@ 0x00000040) SDRAM Address Register                                     */

        struct
        {
            __IOM uint8_t MXC : 2;     /*!< [1..0] Address Multiplex Select                                           */
            uint8_t           : 6;
        } SDADR_b;
    };
    __IM uint8_t  RESERVED10;
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint32_t SDTR;           /*!< (@ 0x00000044) SDRAM Timing Register                                      */

        struct
        {
            __IOM uint32_t CL  : 3;    /*!< [2..0] SDRAMC Column Latency                                              */
            uint32_t           : 5;
            __IOM uint32_t WR  : 1;    /*!< [8..8] Write Recovery Interval                                            */
            __IOM uint32_t RP  : 3;    /*!< [11..9] Row Precharge Interval ( RP+1 cycles )                            */
            __IOM uint32_t RCD : 2;    /*!< [13..12] Row Column Latency ( RCD+1 cycles )                              */
            uint32_t           : 2;
            __IOM uint32_t RAS : 3;    /*!< [18..16] Row Active Interval                                              */
            uint32_t           : 13;
        } SDTR_b;
    };

    union
    {
        __IOM uint16_t SDMOD;          /*!< (@ 0x00000048) SDRAM Mode Register                                        */

        struct
        {
            __IOM uint16_t MR : 15;    /*!< [14..0] Mode Register SettingWriting to these bits: Mode register
                                        *   set command is issued.                                                    */
            uint16_t : 1;
        } SDMOD_b;
    };
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13;

    union
    {
        __IM uint8_t SDSR;             /*!< (@ 0x00000050) SDRAM Status Register                                      */

        struct
        {
            __IM uint8_t MRSST : 1;    /*!< [0..0] Mode Register Setting Status                                       */
            uint8_t            : 2;
            __IM uint8_t INIST : 1;    /*!< [3..3] Initialization Status                                              */
            __IM uint8_t SRFST : 1;    /*!< [4..4] Self-Refresh Transition/Recovery Status                            */
            uint8_t            : 3;
        } SDSR_b;
    };
    __IM uint8_t  RESERVED14;
    __IM uint16_t RESERVED15;
} R_BUS_SDRAM_Type;                    /*!< Size = 84 (0x54)                                                          */

/**
 * @brief R_BUS_BUSERR [BUSERR] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Error Address Register                                 */

        struct
        {
            __IM uint32_t BERAD : 32;  /*!< [31..0] Bus Error AddressWhen a bus error occurs, It stores
                                        *   an error address.                                                         */
        } ADD_b;
    };

    union
    {
        __IM uint8_t STAT;             /*!< (@ 0x00000004) Bus Error Status Register                                  */

        struct
        {
            __IM uint8_t ACCSTAT : 1;  /*!< [0..0] Error access statusThe status at the time of the error             */
            uint8_t              : 6;
            __IM uint8_t ERRSTAT : 1;  /*!< [7..7] Bus Error StatusWhen bus error assert, error flag occurs.          */
        } STAT_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_BUSERR_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_BUSM [BUSM] (Master Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Master Bus Control Register                                */

        struct
        {
            uint16_t             : 15;
            __IOM uint16_t IERES : 1;  /*!< [15..15] Ignore Error Responses                                           */
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSM_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_BUS_BUSS [BUSS] (Slave Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Slave Bus Control Register                                 */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t ARBMET : 2; /*!< [5..4] Arbitration MethodSpecify the priority between groups              */
            uint16_t              : 10;
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSS_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_CAN0_MB [MB] (Mailbox)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) Mailbox ID Register                                        */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 1;
            __IOM uint32_t RTR : 1;    /*!< [30..30] Remote Transmission Request                                      */
            __IOM uint32_t IDE : 1;    /*!< [31..31] ID Extension                                                     */
        } ID_b;
    };

    union
    {
        __IOM uint16_t DL;             /*!< (@ 0x00000004) Mailbox DLC Register                                       */

        struct
        {
            __IOM uint16_t DLC : 4;    /*!< [3..0] Data Length Code                                                   */
            uint16_t           : 12;
        } DL_b;
    };

    union
    {
        __IOM uint8_t D[8];            /*!< (@ 0x00000006) Mailbox Data Register                                      */

        struct
        {
            __IOM uint8_t DATA : 8;    /*!< [7..0] DATA0 to DATA7 store the transmitted or received CAN
                                        *   message data. Transmission or reception starts from DATA0.
                                        *   The bit order on the CAN bus is MSB-first, and transmission
                                        *   or reception starts from bit 7                                            */
        } D_b[8];
    };

    union
    {
        __IOM uint16_t TS;             /*!< (@ 0x0000000E) Mailbox Timestamp Register                                 */

        struct
        {
            __IOM uint16_t TSL : 8;    /*!< [7..0] Time Stamp Higher ByteBits TSL[7:0] store the counter
                                        *   value of the time stamp when received messages are stored
                                        *   in the mailbox.                                                           */
            __IOM uint16_t TSH : 8;    /*!< [15..8] Time Stamp Lower ByteBits TSH[7:0] store the counter
                                        *   value of the time stamp when received messages are stored
                                        *   in the mailbox.                                                           */
        } TS_b;
    };
} R_CAN0_MB_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_ELC_ELSEGR [ELSEGR] (Event Link Software Event Generation Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t BY;              /*!< (@ 0x00000000) Event Link Software Event Generation Register              */

        struct
        {
            __OM uint8_t SEG : 1;      /*!< [0..0] Software Event Generation                                          */
            uint8_t          : 5;
            __IOM uint8_t WE : 1;      /*!< [6..6] SEG Bit Write Enable                                               */
            __OM uint8_t  WI : 1;      /*!< [7..7] ELSEGR Register Write Disable                                      */
        } BY_b;
    };
    __IM uint8_t RESERVED;
} R_ELC_ELSEGR_Type;                   /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_ELC_ELSR [ELSR] (Event Link Setting Register [0..22])
 */
typedef struct
{
    union
    {
        __IOM uint16_t HA;             /*!< (@ 0x00000000) Event Link Setting Register                                */

        struct
        {
            __IOM uint16_t ELS : 9;    /*!< [8..0] Event Link Select                                                  */
            uint16_t           : 7;
        } HA_b;
    };
    __IM uint16_t RESERVED;
} R_ELC_ELSR_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_ETHERC_EPTPC_COMMON_TM [TM] (Timer Setting Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t STTRU;            /*!< (@ 0x00000000) Timer Start Time Setting Register                          */

        struct
        {
            __IOM uint32_t TMSTTRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                          *   bits of the start time of the pulse output timer in nanoseconds.          */
        } STTRU_b;
    };

    union
    {
        __IOM uint32_t STTRL;            /*!< (@ 0x00000004) Timer Start Time Setting Register                          */

        struct
        {
            __IOM uint32_t TMSTTRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                          *   of the start time of the pulse output timer in nanoseconds.               */
        } STTRL_b;
    };

    union
    {
        __IOM uint32_t CYCR;            /*!< (@ 0x00000008) Timer Cycle Setting Registers                              */

        struct
        {
            __IOM uint32_t TMCYCR : 30; /*!< [29..0] These bits set the cycle of the pulse output timer in
                                         *   nanoseconds. Set a value that is equivalent to at least
                                         *   four cycles of the STCA clock.                                            */
            uint32_t : 2;
        } CYCR_b;
    };

    union
    {
        __IOM uint32_t PLSR;            /*!< (@ 0x0000000C) Timer Pulse Width Setting Register                         */

        struct
        {
            __IOM uint32_t TMPLSR : 29; /*!< [28..0] These bits set the width at high level of the pulse
                                         *   signal from the timer in nanoseconds. Set a value that
                                         *   is equivalent to at least two cycles of the STCA clock.                   */
            uint32_t : 3;
        } PLSR_b;
    };
} R_ETHERC_EPTPC_COMMON_TM_Type;        /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_ETHERC_EPTPC_COMMON_PR [PR] (Local MAC Address Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t MACRU;            /*!< (@ 0x00000000) Channel Local MAC Address Register                         */

        struct
        {
            __IOM uint32_t PRMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the local MAC address for Ethernet port 0.                        */
            uint32_t : 8;
        } MACRU_b;
    };

    union
    {
        __IOM uint32_t MACRL;            /*!< (@ 0x00000004) Channel Local MAC Address Register                         */

        struct
        {
            __IOM uint32_t PRMACRL : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the local MAC address for Ethernet port 0.                        */
            uint32_t : 8;
        } MACRL_b;
    };
} R_ETHERC_EPTPC_COMMON_PR_Type;         /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_GLCDC_BG [BG] (Background Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t EN;             /*!< (@ 0x00000000) Background Plane Setting Operation Control Register        */

        struct
        {
            __IOM uint32_t EN  : 1;    /*!< [0..0] Background plane generation module operation enable                */
            uint32_t           : 7;
            __IOM uint32_t VEN : 1;    /*!< [8..8] Control of LCDC internal register value reflection to
                                        *   internal operations                                                       */
            uint32_t             : 7;
            __IOM uint32_t SWRST : 1;  /*!< [16..16] Entire module SW reset control                                   */
            uint32_t             : 15;
        } EN_b;
    };

    union
    {
        __IOM uint32_t PERI;           /*!< (@ 0x00000004) Background Plane Setting Free-Running Period
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t FH : 11;    /*!< [10..0] Background plane horizontal synchronization signal period
                                        *   on the basis of pixel clock (PXCLK).                                      */
            uint32_t          : 5;
            __IOM uint32_t FV : 11;    /*!< [26..16] Background plane vertical synchronization signal period
                                        *   on the basis of line.                                                     */
            uint32_t : 5;
        } PERI_b;
    };

    union
    {
        __IOM uint32_t SYNC;           /*!< (@ 0x00000008) Background Plane Setting Synchronization Position
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t HP : 4;     /*!< [3..0] Background plane horizontal synchronization signal assertion
                                        *   position on the basis of pixel clock (PXCLK).                             */
            uint32_t          : 12;
            __IOM uint32_t VP : 4;     /*!< [19..16] Background plane vertical synchronization signal assertion
                                        *   position on the basis of line.                                            */
            uint32_t : 12;
        } SYNC_b;
    };

    union
    {
        __IOM uint32_t VSIZE;          /*!< (@ 0x0000000C) Background Plane Setting Full Image Vertical
                                        *                  Size Register                                              */

        struct
        {
            __IOM uint32_t VW : 11;    /*!< [10..0] Background plane vertical valid pixel width on the basis
                                        *   of line                                                                   */
            uint32_t          : 5;
            __IOM uint32_t VP : 11;    /*!< [26..16] Background plane vertical valid pixel start position
                                        *   on the basis of line                                                      */
            uint32_t : 5;
        } VSIZE_b;
    };

    union
    {
        __IOM uint32_t HSIZE;          /*!< (@ 0x00000010) Background Plane Setting Full Image Horizontal
                                        *                  Size Register                                              */

        struct
        {
            __IOM uint32_t HW : 11;    /*!< [10..0] Background plane horizontall valid pixel width on the
                                        *   basis of pixel clock (PXCLK) Note: When serial RGB is selected
                                        *   as the output format for the output control block, add
                                        *   two to the horizontal enable signal width and set the resulting
                                        *   value to this field.                                                      */
            uint32_t          : 5;
            __IOM uint32_t HP : 11;    /*!< [26..16] Background plane horizontal valid pixel start position
                                        *   on the basis of pixel clock (PXCLK).                                      */
            uint32_t : 5;
        } HSIZE_b;
    };

    union
    {
        __IOM uint32_t BGC;            /*!< (@ 0x00000014) Background Plane Setting Background Color Register         */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B value for background plane valid pixel area Unsigned;
                                        *   8-bit integer                                                             */
            __IOM uint32_t G : 8;      /*!< [15..8] G value for background plane valid pixel area Unsigned;
                                        *   8-bit integer                                                             */
            __IOM uint32_t R : 8;      /*!< [23..16] R value for background plane valid pixel area. Unsigned;
                                        *   8-bit integer.                                                            */
            uint32_t : 8;
        } BGC_b;
    };

    union
    {
        __IM uint32_t MON;             /*!< (@ 0x00000018) Background Plane Setting Status Monitor Register           */

        struct
        {
            __IM uint32_t EN  : 1;     /*!< [0..0] Background plane generation module operation state monitor.        */
            uint32_t          : 7;
            __IM uint32_t VEN : 1;     /*!< [8..8] Entire module internal operation reflection control signal
                                        *   monitor. The signal state for controlling reflection of
                                        *   the register values to the internal operations upon assertion
                                        *   of the vertical synchronization signal.                                   */
            uint32_t            : 7;
            __IM uint32_t SWRST : 1;   /*!< [16..16] Entire module SW reset state monitor.                            */
            uint32_t            : 15;
        } MON_b;
    };
} R_GLCDC_BG_Type;                     /*!< Size = 28 (0x1c)                                                          */

/**
 * @brief R_GLCDC_GR [GR] (Layer Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t VEN;            /*!< (@ 0x00000000) Graphics Register Update Control Register                  */

        struct
        {
            __IOM uint32_t PVEN : 1;   /*!< [0..0] Control of graphics n module register value reflection
                                        *   to internal operations. Reflection of the register values
                                        *   to the internal operation at the assertion of the vertical
                                        *   synchronization signal (VS).                                              */
            uint32_t : 31;
        } VEN_b;
    };

    union
    {
        __IOM uint32_t FLMRD;          /*!< (@ 0x00000004) Graphics Frame Buffer Read Control Register                */

        struct
        {
            __IOM uint32_t RENB : 1;   /*!< [0..0] Graphics data (frame buffer data) read enable.                     */
            uint32_t            : 31;
        } FLMRD_b;
    };

    union
    {
        __IM uint32_t FLM1;            /*!< (@ 0x00000008) Graphics Frame Buffer Control Register 1                   */

        struct
        {
            __IM uint32_t BSTMD : 2;   /*!< [1..0] Burst transfer control for graphics data (frame buffer
                                        *   data) access                                                              */
            uint32_t : 30;
        } FLM1_b;
    };

    union
    {
        __IOM uint32_t FLM2;           /*!< (@ 0x0000000C) Graphics Frame Buffer Control Register 2                   */

        struct
        {
            __IOM uint32_t BASE : 32;  /*!< [31..0] Base address for accessing graphics data (frame buffer
                                        *   data) Set the head address in the frame buffer where graphics
                                        *   data is to be stored. GRn_FLM2.BASE[5:0] should be fixed
                                        *   to 0 during 64-byte burst transfer.                                       */
        } FLM2_b;
    };

    union
    {
        __IOM uint32_t FLM3;           /*!< (@ 0x00000010) Graphics Frame Buffer Control Register 3                   */

        struct
        {
            uint32_t             : 16;
            __IOM uint32_t LNOFF : 16; /*!< [31..16] Macro line offset address for accessing graphics data
                                        *   (frame buffer data) Signed; 16-bit integer                                */
        } FLM3_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t FLM5;             /*!< (@ 0x00000018) Graphics Frame Buffer Control Register 5                   */

        struct
        {
            __IOM uint32_t DATANUM : 16; /*!< [15..0] Number of data transfer times per line for accessing
                                          *   graphics data (frame buffer data), where one transfer is
                                          *   defined as 16-beat burst access (64-byte boundary)                        */
            __IOM uint32_t LNNUM : 11;   /*!< [26..16] Number of lines per frame for accessing graphics data
                                          *   (frame buffer data).                                                      */
            uint32_t : 5;
        } FLM5_b;
    };

    union
    {
        __IOM uint32_t FLM6;           /*!< (@ 0x0000001C) Graphics Frame Buffer Control Register 6                   */

        struct
        {
            uint32_t              : 28;
            __IOM uint32_t FORMAT : 3; /*!< [30..28] Data format for accessing graphics data (frame buffer
                                        *   data).                                                                    */
            uint32_t : 1;
        } FLM6_b;
    };

    union
    {
        __IOM uint32_t AB1;               /*!< (@ 0x00000020) Graphics Alpha Blending Control Register 1                 */

        struct
        {
            __IOM uint32_t DISPSEL   : 2; /*!< [1..0] Graphics display plane control.                                    */
            uint32_t                 : 2;
            __IOM uint32_t GRCDISPON : 1; /*!< [4..4] Graphics image area border display control.                        */
            uint32_t                 : 3;
            __IOM uint32_t ARCDISPON : 1; /*!< [8..8] Image area border display control for rectangular area
                                           *   alpha blending.                                                           */
            uint32_t             : 3;
            __IOM uint32_t ARCON : 1;     /*!< [12..12] Rectangular area alpha blending control.                         */
            uint32_t             : 19;
        } AB1_b;
    };

    union
    {
        __IOM uint32_t AB2;            /*!< (@ 0x00000024) Graphics Alpha Blending Control Register 2                 */

        struct
        {
            __IOM uint32_t GRCVW : 11; /*!< [10..0] Vertical width of graphics image area.                            */
            uint32_t             : 5;
            __IOM uint32_t GRCVS : 11; /*!< [26..16] Vertical start position of graphics image area.                  */
            uint32_t             : 5;
        } AB2_b;
    };

    union
    {
        __IOM uint32_t AB3;            /*!< (@ 0x00000028) Graphics Alpha Blending Control Register 3                 */

        struct
        {
            __IOM uint32_t GRCHW : 11; /*!< [10..0] Horizontal width of graphics image area.                          */
            uint32_t             : 5;
            __IOM uint32_t GRCHS : 11; /*!< [26..16] Horizontal start position of graphics image area.                */
            uint32_t             : 5;
        } AB3_b;
    };

    union
    {
        __IOM uint32_t AB4;            /*!< (@ 0x0000002C) Graphics Alpha Blending Control Register 4                 */

        struct
        {
            __IOM uint32_t ARCVW : 11; /*!< [10..0] Vertical width of rectangular area alpha blending image
                                        *   area.                                                                     */
            uint32_t             : 5;
            __IOM uint32_t ARCVS : 11; /*!< [26..16] Vertical start position of rectangular area alpha blending
                                        *   image area                                                                */
            uint32_t : 5;
        } AB4_b;
    };

    union
    {
        __IOM uint32_t AB5;            /*!< (@ 0x00000030) Graphics Alpha Blending Control Register 5                 */

        struct
        {
            __IOM uint32_t ARCHW : 11; /*!< [10..0] Horizontal width of rectangular area alpha blending
                                        *   image area.                                                               */
            uint32_t             : 5;
            __IOM uint32_t ARCHS : 11; /*!< [26..16] Horizontal start position of rectangular area alpha
                                        *   blending image area.                                                      */
            uint32_t : 5;
        } AB5_b;
    };

    union
    {
        __IOM uint32_t AB6;             /*!< (@ 0x00000034) Graphics Alpha Blending Control Register 6                 */

        struct
        {
            __IOM uint32_t ARCRATE : 8; /*!< [7..0] Frame rate for alpha blending in rectangular area.                 */
            uint32_t               : 8;
            __IOM uint32_t ARCCOEF : 9; /*!< [24..16] Alpha coefficient for alpha blending in rectangular
                                         *   area (-255 to 255). [8]: Sign (0: addition, 1: subtraction)
                                         *   [7:0]: Variation (absolute value)                                         */
            uint32_t : 7;
        } AB6_b;
    };

    union
    {
        __IOM uint32_t AB7;            /*!< (@ 0x00000038) Graphics Alpha Blending Control Register 7                 */

        struct
        {
            __IOM uint32_t CKON   : 1; /*!< [0..0] RGB-index chroma-key processing control.                           */
            uint32_t              : 15;
            __IOM uint32_t ARCDEF : 8; /*!< [23..16] Initial alpha value for alpha blending in rectangular
                                        *   area.                                                                     */
            uint32_t : 8;
        } AB7_b;
    };

    union
    {
        __IOM uint32_t AB8;            /*!< (@ 0x0000003C) Graphics Alpha Blending Control Register 8                 */

        struct
        {
            __IOM uint32_t CKKR : 8;   /*!< [7..0] R signal for RGB-index chroma-key processing Unsigned;
                                        *   8 bits.                                                                   */
            __IOM uint32_t CKKB : 8;   /*!< [15..8] B signal for RGB-index chroma-key processing Unsigned;
                                        *   8 bits.                                                                   */
            __IOM uint32_t CKKG : 8;   /*!< [23..16] G signal for RGB-index chroma-key processing Unsigned;
                                        *   8 bits.                                                                   */
            uint32_t : 8;
        } AB8_b;
    };

    union
    {
        __IOM uint32_t AB9;            /*!< (@ 0x00000040) Graphics Alpha Blending Control Register 9                 */

        struct
        {
            __IOM uint32_t CKR : 8;    /*!< [7..0] R value after RGB-index chroma-key processing replacement
                                        *   Unsigned; 8 bits.                                                         */
            __IOM uint32_t CKB : 8;    /*!< [15..8] B value after RGB-index chroma-key processing replacement
                                        *   Unsigned; 8 bits.                                                         */
            __IOM uint32_t CKG : 8;    /*!< [23..16] G value after RGB-index chroma-key processing replacement
                                        *   Unsigned; 8 bits.                                                         */
            __IOM uint32_t CKA : 8;    /*!< [31..24] A value after RGB-index chroma-key processing replacement.       */
        } AB9_b;
    };
    __IM uint32_t RESERVED1[2];

    union
    {
        __IOM uint32_t BASE;           /*!< (@ 0x0000004C) Graphics Background Color Control Register                 */

        struct
        {
            __IOM uint32_t R : 8;      /*!< [7..0] Background color R value Unsigned; 8 bits                          */
            __IOM uint32_t B : 8;      /*!< [15..8] Background color B value Unsigned; 8 bits                         */
            __IOM uint32_t G : 8;      /*!< [23..16] Background color G value Unsigned; 8 bits                        */
            uint32_t         : 8;
        } BASE_b;
    };

    union
    {
        __IOM uint32_t CLUTINT;        /*!< (@ 0x00000050) Graphics CLUT Table Interrupt Control Register             */

        struct
        {
            __IOM uint32_t LINE : 11;  /*!< [10..0] Number of detection lines                                         */
            uint32_t            : 5;
            __IOM uint32_t SEL  : 1;   /*!< [16..16] CLUT table control                                               */
            uint32_t            : 15;
        } CLUTINT_b;
    };

    union
    {
        __IM uint32_t MON;             /*!< (@ 0x00000054) Graphics Status Monitor Register                           */

        struct
        {
            __IM uint32_t ARCST   : 1; /*!< [0..0] Status monitor for alpha blending in rectangular area              */
            uint32_t              : 15;
            __IM uint32_t UNDFLST : 1; /*!< [16..16] Status monitor for underflow                                     */
            uint32_t              : 15;
        } MON_b;
    };
    __IM uint32_t RESERVED2[42];
} R_GLCDC_GR_Type;                     /*!< Size = 256 (0x100)                                                        */

/**
 * @brief R_GLCDC_GAM [GAM] (Gamma Settings)
 */
typedef struct
{
    union
    {
        __IOM uint32_t LATCH;          /*!< (@ 0x00000000) Gamma Register Update Control Register                     */

        struct
        {
            __IOM uint32_t VEN : 1;    /*!< [0..0] Control of gamma correction x module register value reflection
                                        *   to internal operations. The register values to be reflected
                                        *   to the internal operations at the assertion of the vertical
                                        *   synchronization signal (VS).                                              */
            uint32_t : 31;
        } LATCH_b;
    };

    union
    {
        __IOM uint32_t GAM_SW;         /*!< (@ 0x00000004) Gamma Correction Block Function Switch Register            */

        struct
        {
            __IOM uint32_t GAMON : 1;  /*!< [0..0] Gamma correction on/off control                                    */
            uint32_t             : 31;
        } GAM_SW_b;
    };

    union
    {
        __IOM uint32_t LUT[8];         /*!< (@ 0x00000008) Gamma Correction Block Table Setting Register              */

        struct
        {
            __IOM uint32_t _HIGH : 11; /*!< [10..0] Gain value of area 0. Unsigned 11-bit fixed point.                */
            uint32_t             : 5;
            __IOM uint32_t _LOW  : 11; /*!< [26..16] Gain value of area 0. Unsigned 11-bit fixed point.               */
            uint32_t             : 5;
        } LUT_b[8];
    };

    union
    {
        __IOM uint32_t AREA[5];        /*!< (@ 0x00000028) Gamma Correction Block Area Setting Register               */

        struct
        {
            __IOM uint32_t _HIGH : 10; /*!< [9..0] Start threshold of area 1 Unsigned 10-bit integer                  */
            __IOM uint32_t _MID  : 10; /*!< [19..10] Start threshold of area 1 Unsigned 10-bit integer                */
            __IOM uint32_t _LOW  : 10; /*!< [29..20] Start threshold of area 1 Unsigned 10-bit integer                */
            uint32_t             : 2;
        } AREA_b[5];
    };
    __IM uint32_t RESERVED;
} R_GLCDC_GAM_Type;                    /*!< Size = 64 (0x40)                                                          */

/**
 * @brief R_GLCDC_OUT [OUT] (Output Control Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t VLATCH;         /*!< (@ 0x00000000) Output Control Block Register Update Control
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t VEN : 1;    /*!< [0..0] Control of output control module register value reflection
                                        *   to internal operations. The register values to be reflected
                                        *   to the internal operations at the assertion of the vertical
                                        *   synchronization signal (VS).                                              */
            uint32_t : 31;
        } VLATCH_b;
    };

    union
    {
        __IOM uint32_t SET;              /*!< (@ 0x00000004) Output Control Block Output Interface Register             */

        struct
        {
            __IOM uint32_t PHASE    : 2; /*!< [1..0] Data delay in serial RGB format (based on OUTCLK)                  */
            uint32_t                : 2;
            __IOM uint32_t DIRSEL   : 1; /*!< [4..4] Invalid data position control in serial RGB format                 */
            uint32_t                : 3;
            __IOM uint32_t FRQSEL   : 2; /*!< [9..8] Clock frequency division control                                   */
            uint32_t                : 2;
            __IOM uint32_t FORMAT   : 2; /*!< [13..12] Output format select                                             */
            uint32_t                : 10;
            __IOM uint32_t SWAPON   : 1; /*!< [24..24] Pixel order control                                              */
            uint32_t                : 3;
            __IOM uint32_t ENDIANON : 1; /*!< [28..28] Bit endian change control                                        */
            uint32_t                : 3;
        } SET_b;
    };

    union
    {
        __IOM uint32_t BRIGHT1;        /*!< (@ 0x00000008) Output Control Block Brightness Correction Register
                                        *                  1                                                          */

        struct
        {
            __IOM uint32_t BRTG : 10;  /*!< [9..0] Brightness (DC) adjustment of G signal Unsigned; 10 bits;
                                        +512 with offset; integer                                                 */
            uint32_t : 22;
        } BRIGHT1_b;
    };

    union
    {
        __IOM uint32_t BRIGHT2;        /*!< (@ 0x0000000C) Output Control Block Brightness Correction Register
                                        *                  2                                                          */

        struct
        {
            __IOM uint32_t BRTR : 10;  /*!< [9..0] Brightness (DC) adjustment of R signal Unsigned; 10 bits;
                                        +512 with offset; integer                                                 */
            uint32_t            : 6;
            __IOM uint32_t BRTB : 10;  /*!< [25..16] Brightness (DC) adjustment of B signal Unsigned; 10
                                        *   bits; +512 with offset; integer                                           */
            uint32_t : 6;
        } BRIGHT2_b;
    };

    union
    {
        __IOM uint32_t CONTRAST;       /*!< (@ 0x00000010) Output Control Block Contrast Correction Register          */

        struct
        {
            __IOM uint32_t CONTR : 8;  /*!< [7..0] Contrast (GAIN) adjustment of R signal Unsigned; 8 bits
                                        *   fixed point                                                               */
            __IOM uint32_t CONTB : 8;  /*!< [15..8] Contrast (GAIN) adjustment of B signal Unsigned; 8 bits
                                        *   fixed point                                                               */
            __IOM uint32_t CONTG : 8;  /*!< [23..16] Contrast (GAIN) adjustment of G signal Unsigned; 8
                                        *   bits fixed point.                                                         */
            uint32_t : 8;
        } CONTRAST_b;
    };

    union
    {
        __IOM uint32_t PDTHA;          /*!< (@ 0x00000014) Output Control Block Panel Dither Correction
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t PD : 2;     /*!< [1..0] Pattern value (D) of 2 x 2 pattern dither Unsigned 2-bit
                                        *   integer                                                                   */
            uint32_t          : 2;
            __IOM uint32_t PC : 2;     /*!< [5..4] Pattern value (C) of 2 x 2 pattern dither Unsigned 2-bit
                                        *   integer                                                                   */
            uint32_t          : 2;
            __IOM uint32_t PB : 2;     /*!< [9..8] Pattern value (B) of 2 x 2 pattern dither Unsigned 2-bit
                                        *   integer                                                                   */
            uint32_t          : 2;
            __IOM uint32_t PA : 2;     /*!< [13..12] Pattern value (A) of 2 x 2 pattern dither Unsigned
                                        *   2-bit integer                                                             */
            uint32_t            : 2;
            __IOM uint32_t FORM : 2;   /*!< [17..16] Output format select                                             */
            uint32_t            : 2;
            __IOM uint32_t SEL  : 2;   /*!< [21..20] Operation mode                                                   */
            uint32_t            : 10;
        } PDTHA_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t CLKPHASE;       /*!< (@ 0x00000024) Output Control Block Output Phase Control Register         */

        struct
        {
            uint32_t                 : 3;
            __IOM uint32_t TCON3EDGE : 1; /*!< [3..3] LCD_TCON3 Output Phase Control                                     */
            __IOM uint32_t TCON2EDGE : 1; /*!< [4..4] LCD_TCON2 Output Phase Control                                     */
            __IOM uint32_t TCON1EDGE : 1; /*!< [5..5] LCD_TCON1 Output Phase Control                                     */
            __IOM uint32_t TCON0EDGE : 1; /*!< [6..6] LCD_TCON0 Output Phase Control                                     */
            uint32_t                 : 1;
            __IOM uint32_t LCDEDGE   : 1; /*!< [8..8] LCD_DATA Output Phase Control                                      */
            uint32_t                 : 3;
            __IOM uint32_t FRONTGAM  : 1; /*!< [12..12] Correction control                                               */
            uint32_t                 : 19;
        } CLKPHASE_b;
    };
} R_GLCDC_OUT_Type;                       /*!< Size = 40 (0x28)                                                          */

/**
 * @brief R_GLCDC_TCON [TCON] (Timing Control Registers)
 */
typedef struct
{
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t TIM;             /*!< (@ 0x00000004) TCON Reference Timing Setting Register                     */

        struct
        {
            __IOM uint32_t OFFSET : 11; /*!< [10..0] Horizontal synchronization signal generation reference
                                         *   timing Sets the offset from the assertion of the internal
                                         *   horizontal synchronization signal in terms of pixels.                     */
            uint32_t            : 5;
            __IOM uint32_t HALF : 11;   /*!< [26..16] Vertical synchronization signal generation change timing
                                         *   Sets the delay from the assertion of the internal horizontal
                                         *   synchronization signal in terms of pixels.                                */
            uint32_t : 5;
        } TIM_b;
    };

    union
    {
        __IOM uint32_t STVA1;          /*!< (@ 0x00000008) TCON Vertical Timing Setting Register A1                   */

        struct
        {
            __IOM uint32_t VW : 11;    /*!< [10..0] STVx1 second change timing Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t VS : 11;    /*!< [26..16] STVx1 first change timing                                        */
            uint32_t          : 5;
        } STVA1_b;
    };

    union
    {
        __IOM uint32_t STVA2;          /*!< (@ 0x0000000C) TCON Vertical Timing Setting Register A2                   */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for VSOUT (controlled by
                                        *   TCON_STVA2 register)/VEOUT (controlled by the TCON_STVB2
                                        *   register) pin                                                             */
            uint32_t           : 1;
            __IOM uint32_t INV : 1;    /*!< [4..4] STVx signal polarity inversion control                             */
            uint32_t           : 27;
        } STVA2_b;
    };

    union
    {
        __IOM uint32_t STVB1;          /*!< (@ 0x00000010) TCON Vertical Timing Setting Register B1                   */

        struct
        {
            __IOM uint32_t VW : 11;    /*!< [10..0] STVx1 second change timing Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t VS : 11;    /*!< [26..16] STVx1 first change timing                                        */
            uint32_t          : 5;
        } STVB1_b;
    };

    union
    {
        __IOM uint32_t STVB2;          /*!< (@ 0x00000014) TCON Vertical Timing Setting Register B2                   */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for VSOUT (controlled by
                                        *   TCON_STVA2 register)/VEOUT (controlled by the TCON_STVB2
                                        *   register) pin                                                             */
            uint32_t           : 1;
            __IOM uint32_t INV : 1;    /*!< [4..4] STVx signal polarity inversion control                             */
            uint32_t           : 27;
        } STVB2_b;
    };

    union
    {
        __IOM uint32_t STHA1;          /*!< (@ 0x00000018) TCON Horizontal Timing Setting Register STHA1              */

        struct
        {
            __IOM uint32_t HW : 11;    /*!< [10..0] STHx1 second change timing. Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t HS : 11;    /*!< [26..16] STHx1 first change timing                                        */
            uint32_t          : 5;
        } STHA1_b;
    };

    union
    {
        __IOM uint32_t STHA2;          /*!< (@ 0x0000001C) TCON Horizontal Timing Setting Register STHA2              */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for LCD_TCON2 (controlled
                                        *   by TCON_STHA2 register)/LCD_TCON3 (controlled by the TCON_STHB2
                                        *   register) pin.                                                            */
            uint32_t             : 1;
            __IOM uint32_t INV   : 1;  /*!< [4..4] STVx signal polarity inversion control.                            */
            uint32_t             : 3;
            __IOM uint32_t HSSEL : 1;  /*!< [8..8] STHx signal generation reference timing control.                   */
            uint32_t             : 23;
        } STHA2_b;
    };

    union
    {
        __IOM uint32_t STHB1;          /*!< (@ 0x00000020) TCON Horizontal Timing Setting Register STHB1              */

        struct
        {
            __IOM uint32_t HW : 11;    /*!< [10..0] STHx1 second change timing. Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t HS : 11;    /*!< [26..16] STHx1 first change timing                                        */
            uint32_t          : 5;
        } STHB1_b;
    };

    union
    {
        __IOM uint32_t STHB2;          /*!< (@ 0x00000024) TCON Horizontal Timing Setting Register STHB2              */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for LCD_TCON2 (controlled
                                        *   by TCON_STHA2 register)/LCD_TCON3 (controlled by the TCON_STHB2
                                        *   register) pin.                                                            */
            uint32_t             : 1;
            __IOM uint32_t INV   : 1;  /*!< [4..4] STVx signal polarity inversion control.                            */
            uint32_t             : 3;
            __IOM uint32_t HSSEL : 1;  /*!< [8..8] STHx signal generation reference timing control.                   */
            uint32_t             : 23;
        } STHB2_b;
    };

    union
    {
        __IOM uint32_t DE;             /*!< (@ 0x00000028) TCON Data Enable Polarity Setting Register                 */

        struct
        {
            __IOM uint32_t INV : 1;    /*!< [0..0] DE signal polarity inversion control.                              */
            uint32_t           : 31;
        } DE_b;
    };
} R_GLCDC_TCON_Type;                   /*!< Size = 44 (0x2c)                                                          */

/**
 * @brief R_GLCDC_SYSCNT [SYSCNT] (GLCDC System Control Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t DTCTEN;            /*!< (@ 0x00000000) System control block State Detection Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint32_t VPOSDTC   : 1; /*!< [0..0] Specified line detection control                                   */
            __IOM uint32_t L1UNDFDTC : 1; /*!< [1..1] Graphics 1 underflow detection control                             */
            __IOM uint32_t L2UNDFDTC : 1; /*!< [2..2] Graphics 2 underflow detection control                             */
            uint32_t                 : 29;
        } DTCTEN_b;
    };

    union
    {
        __IOM uint32_t INTEN;               /*!< (@ 0x00000004) System control block Interrupt Request Enable
                                             *                  Control Register                                           */

        struct
        {
            __IOM uint32_t VPOSINTEN   : 1; /*!< [0..0] Interrupt request signal GLCDC_VPOS enable control.                */
            __IOM uint32_t L1UNDFINTEN : 1; /*!< [1..1] Interrupt request signal GLCDC_L1UNDF enable control.              */
            __IOM uint32_t L2UNDFINTEN : 1; /*!< [2..2] Interrupt request signal GLCDC_L2UNDF enable control.              */
            uint32_t                   : 29;
        } INTEN_b;
    };

    union
    {
        __IOM uint32_t STCLR;             /*!< (@ 0x00000008) System control block Status Clear Register                 */

        struct
        {
            __IOM uint32_t VPOSCLR   : 1; /*!< [0..0] Graphics 2 specified line detection flag clear field               */
            __IOM uint32_t L1UNDFCLR : 1; /*!< [1..1] Graphics 1 underflow detection flag clear field                    */
            __IOM uint32_t L2UNDFCLR : 1; /*!< [2..2] Graphics 2 underflow detection flag clear field                    */
            uint32_t                 : 29;
        } STCLR_b;
    };

    union
    {
        __IM uint32_t STMON;           /*!< (@ 0x0000000C) System control block Status Monitor Register               */

        struct
        {
            __IM uint32_t VPOS   : 1;  /*!< [0..0] Graphics 2 specified line detection flag                           */
            __IM uint32_t L1UNDF : 1;  /*!< [1..1] Graphics 1 underflow detection flag                                */
            __IM uint32_t L2UNDF : 1;  /*!< [2..2] Graphics 2 underflow detection flag                                */
            uint32_t             : 29;
        } STMON_b;
    };

    union
    {
        __IOM uint32_t PANEL_CLK;      /*!< (@ 0x00000010) System control block Version and Panel Clock
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint32_t DCDR : 6;   /*!< [5..0] Clock division ratio setting control Refer toTable 2.7.1
                                        *   for details about setting value. Note: Settings that are
                                        *   not listed in table 2.7.1 are prohibited.                                 */
            __IOM uint32_t CLKEN : 1;  /*!< [6..6] Panel clock output enable control Note: Before changing
                                        *   the PIXSEL,CLKSEL or DCDR bit, this bit must be set to
                                        *   0.                                                                        */
            uint32_t              : 1;
            __IOM uint32_t CLKSEL : 1; /*!< [8..8] Panel clock supply source select                                   */
            uint32_t              : 3;
            __IOM uint32_t PIXSEL : 1; /*!< [12..12] Pixel clock select control. Must be set to the same
                                        *   value as OUT_SET.FRQSEL[1].                                               */
            uint32_t          : 3;
            __IM uint32_t VER : 16;    /*!< [31..16] Version information Version information of the GLCDC             */
        } PANEL_CLK_b;
    };
} R_GLCDC_SYSCNT_Type;                 /*!< Size = 20 (0x14)                                                          */

/**
 * @brief R_GPT_ODC_GTDLYR [GTDLYR] (PWM DELAY RISING)
 */
typedef struct
{
    union
    {
        __IOM uint16_t A;              /*!< (@ 0x00000000) GTIOCA Output Delay Register                               */

        struct
        {
            __IOM uint16_t DLY : 5;    /*!< [4..0] GTIOCnA Output Rising Edge Delay Setting                           */
            uint16_t           : 11;
        } A_b;
    };

    union
    {
        __IOM uint16_t B;              /*!< (@ 0x00000002) GTIOCB Output Delay Register                               */

        struct
        {
            __IOM uint16_t DLY : 5;    /*!< [4..0] GTIOCnA Output Rising Edge Delay Setting                           */
            uint16_t           : 11;
        } B_b;
    };
} R_GPT_ODC_GTDLYR_Type;               /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_IIC0_SAR [SAR] (Slave Address Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t L;               /*!< (@ 0x00000000) Slave Address Register L                                   */

        struct
        {
            __IOM uint8_t SVA : 8;     /*!< [7..0] A slave address is set.7-Bit Address = SVA[7:1] 10-Bit
                                        *   Address = { SVA9,SVA8,SVA[7:0] }                                          */
        } L_b;
    };

    union
    {
        __IOM uint8_t U;               /*!< (@ 0x00000001) Slave Address Register U                                   */

        struct
        {
            __IOM uint8_t FS   : 1;    /*!< [0..0] 7-Bit/10-Bit Address Format Selection                              */
            __IOM uint8_t SVA8 : 1;    /*!< [1..1] 10-Bit Address(bit8)                                               */
            __IOM uint8_t SVA9 : 1;    /*!< [2..2] 10-Bit Address(bit9)                                               */
            uint8_t            : 5;
        } U_b;
    };
} R_IIC0_SAR_Type;                     /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_MPU_MMPU_MMPU_REGION [REGION] (Address Region registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t C;              /*!< (@ 0x00000000) Access Control Register                                    */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Region enable                                                      */
            __IOM uint16_t RP     : 1; /*!< [1..1] Read protection                                                    */
            __IOM uint16_t WP     : 1; /*!< [2..2] Write protection                                                   */
            uint16_t              : 13;
        } C_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint32_t S;                /*!< (@ 0x00000004) Start Address Register                                     */

        struct
        {
            __IOM uint32_t MMPUSmn : 32; /*!< [31..0] Address where the region starts, for use in region determination.NOTE:
                                          *   The low-order 2 bits are fixed to 0.                                      */
        } S_b;
    };

    union
    {
        __IOM uint32_t E;                /*!< (@ 0x00000008) End Address Register                                       */

        struct
        {
            __IOM uint32_t MMPUEmn : 32; /*!< [31..0] Region end address registerAddress where the region
                                          *   end, for use in region determination.NOTE: The low-order
                                          *   2 bits are fixed to 1.                                                    */
        } E_b;
    };
    __IM uint32_t RESERVED1;
} R_MPU_MMPU_MMPU_REGION_Type;           /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_MPU_MMPU_MMPU [MMPU] (Bus Master MPU Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000000) Bus Master MPU Control Register                            */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t OAD    : 1; /*!< [1..1] Operation after detection                                          */
            uint16_t              : 6;
            __OM uint16_t KEY     : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } CTL_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[63];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t PT;                        /*!< (@ 0x00000102) Protection of Register                                     */

        struct
        {
            __IOM uint16_t PROTECT : 1;           /*!< [0..0] Protection of region register                                      */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8;           /*!< [15..8] Write Keyword The data written to these bits are not
                                                   *   stored.                                                                   */
        } PT_b;
    };
    __IM uint32_t RESERVED3[63];
    __IOM R_MPU_MMPU_MMPU_REGION_Type REGION[32]; /*!< (@ 0x00000200) Address Region registers                                   */
} R_MPU_MMPU_MMPU_Type;                           /*!< Size = 1024 (0x400)                                                       */

/**
 * @brief R_MPU_SMPU_SMPU [SMPU] (Access Control Structure for MBIU)
 */
typedef struct
{
    union
    {
        __IOM uint16_t R;              /*!< (@ 0x00000000) Access Control Register for MBIU                           */

        struct
        {
            uint16_t              : 2;
            __IOM uint16_t RPGRPA : 1;   /*!< [2..2] Master Group A Read protection                                     */
            __IOM uint16_t WPGRPA : 1;   /*!< [3..3] Master Group A Write protection                                    */
            __IOM uint16_t RPGRPB : 1;   /*!< [4..4] Master Group B Read protection                                     */
            __IOM uint16_t WPGRPB : 1;   /*!< [5..5] Master Group B Write protection                                    */
            __IOM uint16_t RPGRPC : 1;   /*!< [6..6] Master Group C Read protection                                     */
            __IOM uint16_t WPGRPC : 1;   /*!< [7..7] Master Group C Write protection                                    */
            uint16_t              : 4;
            __IOM uint16_t RPFLI  : 1;   /*!< [12..12] Code Flash Memory Read Protection                                */
            __IOM uint16_t WPFLI  : 1;   /*!< [13..13] Code Flash Memory Write Protection (Note: This bit
                                          *   is read as 1. The write value should be 1.)                               */
            __IOM uint16_t RPSRAMHS : 1; /*!< [14..14] SRAMHS Read Protection                                           */
            __IOM uint16_t WPSRAMHS : 1; /*!< [15..15] SRAMHS Write Protection                                          */
        } R_b;
    };
    __IM uint16_t RESERVED;
} R_MPU_SMPU_SMPU_Type;                  /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_MPU_SPMON_SP [SP] (Stack Pointer Monitor)
 */
typedef struct
{
    union
    {
        __IOM uint16_t OAD;            /*!< (@ 0x00000000) Stack Pointer Monitor Operation After Detection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint16_t OAD : 1;    /*!< [0..0] Operation after detection                                          */
            uint16_t           : 7;
            __OM uint16_t KEY  : 8;    /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } OAD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000004) Stack Pointer Monitor Access Control Register              */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Stack Pointer Monitor Enable                                       */
            uint16_t              : 7;
            __IOM uint16_t ERROR  : 1; /*!< [8..8] Stack Pointer Monitor Error Flag                                   */
            uint16_t              : 7;
        } CTL_b;
    };

    union
    {
        __IOM uint16_t PT;              /*!< (@ 0x00000006) Stack Pointer Monitor Protection Register                  */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of register (MSPMPUAC, MSPMPUSA and MSPMPUSE)           */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                         *   stored.                                                                   */
        } PT_b;
    };

    union
    {
        __IOM uint32_t SA;                /*!< (@ 0x00000008) Stack Pointer Monitor Start Address Register               */

        struct
        {
            __IOM uint32_t MSPMPUSA : 32; /*!< [31..0] Region start address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFF
                                           *   The low-order 2 bits are fixed to 0.                                      */
        } SA_b;
    };

    union
    {
        __IOM uint32_t EA;                /*!< (@ 0x0000000C) Stack Pointer Monitor End Address Register                 */

        struct
        {
            __IOM uint32_t MSPMPUEA : 32; /*!< [31..0] Region end address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFF
                                           *   The low-order 2 bits are fixed to 1.                                      */
        } EA_b;
    };
} R_MPU_SPMON_SP_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_OPAMP_AMP [AMP] (Input and Output Selectors for Operational Amplifier [0..3])
 */
typedef struct
{
    __IOM uint8_t OS;                  /*!< (@ 0x00000000) Output Select Register                                     */
    __IOM uint8_t MS;                  /*!< (@ 0x00000001) Minus Input Select Register                                */
    __IOM uint8_t PS;                  /*!< (@ 0x00000002) Plus Input Select Register                                 */
} R_OPAMP_AMP_Type;                    /*!< Size = 3 (0x3)                                                            */

/**
 * @brief R_OPAMP_AMPOT [AMPOT] (Operational Amplifier n Offset Trimming Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t P;               /*!< (@ 0x00000000) Operational Amplifier n Offset Trimming Pch Register       */

        struct
        {
            __IOM uint8_t TRMP : 5;    /*!< [4..0] AMPn input offset trimming Pch side                                */
            uint8_t            : 3;
        } P_b;
    };

    union
    {
        __IOM uint8_t N;               /*!< (@ 0x00000001) Operational Amplifier n Offset Trimming Nch Register       */

        struct
        {
            __IOM uint8_t TRMN : 5;    /*!< [4..0] AMPn input offset trimming Nch side                                */
            uint8_t            : 3;
        } N_b;
    };
} R_OPAMP_AMPOT_Type;                  /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_PFS_PORT_PIN [PIN] (Pin Function Selects)
 */
typedef struct
{
    union
    {
        union
        {
            __IOM uint32_t PmnPFS;        /*!< (@ 0x00000000) Pin Function Control Register                              */

            struct
            {
                __IOM uint32_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                __IM uint32_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                __IOM uint32_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                uint32_t             : 1;
                __IOM uint32_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                __IOM uint32_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                __IOM uint32_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                uint32_t             : 3;
                __IOM uint32_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                __IOM uint32_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                __IOM uint32_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                __IOM uint32_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                __IOM uint32_t PMR   : 1; /*!< [16..16] Port Mode Control                                                */
                uint32_t             : 7;
                __IOM uint32_t PSEL  : 5; /*!< [28..24] Port Function SelectThese bits select the peripheral
                                           *   function. For individual pin functions, see the MPC table                 */
                uint32_t : 3;
            } PmnPFS_b;
        };

        struct
        {
            union
            {
                struct
                {
                    __IM uint16_t RESERVED;

                    union
                    {
                        __IOM uint16_t PmnPFS_HA;     /*!< (@ 0x00000002) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint16_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint16_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint16_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint16_t             : 1;
                            __IOM uint16_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint16_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint16_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint16_t             : 3;
                            __IOM uint16_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                            __IOM uint16_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                            __IOM uint16_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                            __IOM uint16_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                        } PmnPFS_HA_b;
                    };
                };

                struct
                {
                    __IM uint16_t RESERVED1;
                    __IM uint8_t  RESERVED2;

                    union
                    {
                        __IOM uint8_t PmnPFS_BY;     /*!< (@ 0x00000003) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint8_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint8_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint8_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint8_t             : 1;
                            __IOM uint8_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint8_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint8_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint8_t             : 1;
                        } PmnPFS_BY_b;
                    };
                };
            };
        };
    };
} R_PFS_PORT_PIN_Type;                 /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_PFS_PORT [PORT] (Port [0..11])
 */
typedef struct
{
    __IOM R_PFS_PORT_PIN_Type PIN[16]; /*!< (@ 0x00000000) Pin Function Selects                                       */
} R_PFS_PORT_Type;                     /*!< Size = 64 (0x40)                                                          */

/**
 * @brief R_PMISC_PMSAR [PMSAR] (Port Security Attribution Register)
 */
typedef struct
{
    __IOM uint16_t PMSAR;              /*!< (@ 0x00000000) Port Security Attribution Register                         */
} R_PMISC_PMSAR_Type;                  /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_RTC_RTCCR [RTCCR] (Time Capture Control Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t RTCCR;           /*!< (@ 0x00000000) Time Capture Control Register                              */

        struct
        {
            __IOM uint8_t TCCT : 2;    /*!< [1..0] Time Capture Control                                               */
            __IM uint8_t  TCST : 1;    /*!< [2..2] Time Capture Status                                                */
            uint8_t            : 1;
            __IOM uint8_t TCNF : 2;    /*!< [5..4] Time Capture Noise Filter Control                                  */
            uint8_t            : 2;
        } RTCCR_b;
    };
    __IM uint8_t RESERVED;
} R_RTC_RTCCR_Type;                    /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_RTC_CP [CP] (Capture registers)
 */
typedef struct
{
    __IM uint8_t RESERVED[2];

    union
    {
        union
        {
            __IM uint8_t RSEC;          /*!< (@ 0x00000002) Second Capture Register                                    */

            struct
            {
                __IM uint8_t SEC1 : 4;  /*!< [3..0] 1-Second Capture Capture value for the ones place of
                                         *   seconds                                                                   */
                __IM uint8_t SEC10 : 3; /*!< [6..4] 10-Second Capture Capture value for the tens place of
                                         *   seconds                                                                   */
                uint8_t : 1;
            } RSEC_b;
        };

        union
        {
            __IM uint8_t BCNT0;           /*!< (@ 0x00000002) BCNT0 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT0CP : 8; /*!< [7..0] BCNT0CP is a read-only register that captures the BCNT0
                                           *   value when a time capture event is detected.                              */
            } BCNT0_b;
        };
    };
    __IM uint8_t RESERVED1;

    union
    {
        union
        {
            __IM uint8_t RMIN;          /*!< (@ 0x00000004) Minute Capture Register                                    */

            struct
            {
                __IM uint8_t MIN1 : 4;  /*!< [3..0] 1-Minute Capture Capture value for the ones place of
                                         *   minutes                                                                   */
                __IM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Capture Capture value for the tens place of
                                         *   minutes                                                                   */
                uint8_t : 1;
            } RMIN_b;
        };

        union
        {
            __IM uint8_t BCNT1;           /*!< (@ 0x00000004) BCNT1 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT1CP : 8; /*!< [7..0] BCNT1CP is a read-only register that captures the BCNT1
                                           *   value when a time capture event is detected.                              */
            } BCNT1_b;
        };
    };
    __IM uint8_t RESERVED2;

    union
    {
        union
        {
            __IM uint8_t RHR;          /*!< (@ 0x00000006) Hour Capture Register                                      */

            struct
            {
                __IM uint8_t HR1 : 4;  /*!< [3..0] 1-Minute Capture Capture value for the ones place of
                                        *   minutes                                                                   */
                __IM uint8_t HR10 : 2; /*!< [5..4] 10-Minute Capture Capture value for the tens place of
                                        *   minutes                                                                   */
                __IM uint8_t PM : 1;   /*!< [6..6] A.m./p.m. select for time counter setting.                         */
                uint8_t         : 1;
            } RHR_b;
        };

        union
        {
            __IM uint8_t BCNT2;           /*!< (@ 0x00000006) BCNT2 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT2CP : 8; /*!< [7..0] BCNT2CP is a read-only register that captures the BCNT2
                                           *   value when a time capture event is detected.                              */
            } BCNT2_b;
        };
    };
    __IM uint8_t RESERVED3[3];

    union
    {
        union
        {
            __IM uint8_t RDAY;           /*!< (@ 0x0000000A) Date Capture Register                                      */

            struct
            {
                __IM uint8_t DATE1  : 4; /*!< [3..0] 1-Day Capture Capture value for the ones place of minutes          */
                __IM uint8_t DATE10 : 2; /*!< [5..4] 10-Day Capture Capture value for the tens place of minutes         */
                uint8_t             : 2;
            } RDAY_b;
        };

        union
        {
            __IM uint8_t BCNT3;           /*!< (@ 0x0000000A) BCNT3 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT3CP : 8; /*!< [7..0] BCNT3CP is a read-only register that captures the BCNT3
                                           *   value when a time capture event is detected.                              */
            } BCNT3_b;
        };
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IM uint8_t RMON;             /*!< (@ 0x0000000C) Month Capture Register                                     */

        struct
        {
            __IM uint8_t MON1  : 4;    /*!< [3..0] 1-Month Capture Capture value for the ones place of months         */
            __IM uint8_t MON10 : 1;    /*!< [4..4] 10-Month Capture Capture value for the tens place of
                                        *   months                                                                    */
            uint8_t : 3;
        } RMON_b;
    };
    __IM uint8_t RESERVED5[3];
} R_RTC_CP_Type;                       /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_USB_FS0_PIPE_TR [PIPE_TR] (Pipe Transaction Counter Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t E;              /*!< (@ 0x00000000) Pipe Transaction Counter Enable Register                   */

        struct
        {
            uint16_t             : 8;
            __IOM uint16_t TRCLR : 1;  /*!< [8..8] Transaction Counter Clear                                          */
            __IOM uint16_t TRENB : 1;  /*!< [9..9] Transaction Counter Enable                                         */
            uint16_t             : 6;
        } E_b;
    };

    union
    {
        __IOM uint16_t N;               /*!< (@ 0x00000002) Pipe Transaction Counter Register                          */

        struct
        {
            __IOM uint16_t TRNCNT : 16; /*!< [15..0] Transaction Counter                                               */
        } N_b;
    };
} R_USB_FS0_PIPE_TR_Type;               /*!< Size = 4 (0x4)                                                            */

/**
 * @brief USB_HS0_PIPE_TR [PIPE_TR] (Pipe Transaction Counter Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t E;              /*!< (@ 0x00000000) Pipe Transaction Counter Enable Register                   */

        struct
        {
            uint16_t             : 8;
            __IOM uint16_t TRCLR : 1;  /*!< [8..8] Transaction Counter Clear                                          */
            __IOM uint16_t TRENB : 1;  /*!< [9..9] Transaction Counter Enable                                         */
        } E_b;
    };

    union
    {
        __IOM uint16_t N;               /*!< (@ 0x00000002) Pipe Transaction Counter Register                          */

        struct
        {
            __IOM uint16_t TRNCNT : 16; /*!< [15..0] Transaction Counter                                               */
        } N_b;
    };
} R_USB_HS0_PIPE_TR_Type;               /*!< Size = 4 (0x4)                                                           */

/** @} */ /* End of group Device_Peripheral_clusters */

/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                         R_ACMPHS0                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief High-Speed Analog Comparator (R_ACMPHS0)
 */

typedef struct                         /*!< (@ 0x40085000) R_ACMPHS0 Structure                                        */
{
    union
    {
        __IOM uint8_t CMPCTL;          /*!< (@ 0x00000000) Comparator Control Register                                */

        struct
        {
            __IOM uint8_t CINV   : 1;  /*!< [0..0] Comparator output polarity selection                               */
            __IOM uint8_t COE    : 1;  /*!< [1..1] Comparator output enable                                           */
            __IOM uint8_t CSTEN  : 1;  /*!< [2..2] Interrupt Select                                                   */
            __IOM uint8_t CEG    : 2;  /*!< [4..3] Selection of valid edge (Edge selector)                            */
            __IOM uint8_t CDFS   : 2;  /*!< [6..5] Noise filter selection                                             */
            __IOM uint8_t HCMPON : 1;  /*!< [7..7] Comparator operation control                                       */
        } CMPCTL_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t CMPSEL0;         /*!< (@ 0x00000004) Comparator Input Select Register                           */

        struct
        {
            __IOM uint8_t CMPSEL : 4;  /*!< [3..0] Comparator Input Selection                                         */
            uint8_t              : 4;
        } CMPSEL0_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t CMPSEL1;         /*!< (@ 0x00000008) Comparator Reference Voltage Select Register               */

        struct
        {
            __IOM uint8_t CRVS : 6;    /*!< [5..0] Reference Voltage Selection                                        */
            uint8_t            : 2;
        } CMPSEL1_b;
    };
    __IM uint8_t RESERVED2[3];

    union
    {
        __IM uint8_t CMPMON;           /*!< (@ 0x0000000C) Comparator Output Monitor Register                         */

        struct
        {
            __IM uint8_t CMPMON : 1;   /*!< [0..0] Comparator output monitor                                          */
            uint8_t             : 7;
        } CMPMON_b;
    };
    __IM uint8_t RESERVED3[3];

    union
    {
        __IOM uint8_t CPIOC;           /*!< (@ 0x00000010) Comparator Output Control Register                         */

        struct
        {
            __IOM uint8_t CPOE   : 1;  /*!< [0..0] Comparator output selection                                        */
            uint8_t              : 6;
            __IOM uint8_t VREFEN : 1;  /*!< [7..7] Internal Vref enable                                               */
        } CPIOC_b;
    };
} R_ACMPHS0_Type;                      /*!< Size = 17 (0x11)                                                          */

/* =========================================================================================================================== */
/* ================                                         R_ACMPLP                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Low-Power Analog Comparator (R_ACMPLP)
 */

typedef struct                         /*!< (@ 0x40085E00) R_ACMPLP Structure                                         */
{
    union
    {
        __IOM uint8_t COMPMDR;         /*!< (@ 0x00000000) ACMPLP Mode Setting Register                               */

        struct
        {
            __IOM uint8_t C0ENB : 1;   /*!< [0..0] ACMPLP0 Operation Enable                                           */
            __IOM uint8_t C0WDE : 1;   /*!< [1..1] ACMPLP0 Window Function Mode Enable                                */
            __IOM uint8_t C0VRF : 1;   /*!< [2..2] ACMPLP0 Reference Voltage Selection                                */
            __IM uint8_t  C0MON : 1;   /*!< [3..3] ACMPLP0 Monitor Flag                                               */
            __IOM uint8_t C1ENB : 1;   /*!< [4..4] ACMPLP1 Operation Enable                                           */
            __IOM uint8_t C1WDE : 1;   /*!< [5..5] ACMPLP1 Window Function Mode Enable                                */
            __IOM uint8_t C1VRF : 1;   /*!< [6..6] ACMPLP1 Reference Voltage Selection                                */
            __IM uint8_t  C1MON : 1;   /*!< [7..7] ACMPLP1 Monitor Flag                                               */
        } COMPMDR_b;
    };

    union
    {
        __IOM uint8_t COMPFIR;         /*!< (@ 0x00000001) ACMPLP Filter Control Register                             */

        struct
        {
            __IOM uint8_t C0FCK : 2;   /*!< [1..0] ACMPLP0 Filter Select                                              */
            __IOM uint8_t C0EPO : 1;   /*!< [2..2] ACMPLP0 Edge Polarity Switching                                    */
            __IOM uint8_t C0EDG : 1;   /*!< [3..3] ACMPLP0 Edge Detection Selection                                   */
            __IOM uint8_t C1FCK : 2;   /*!< [5..4] ACMPLP1 Filter Select                                              */
            __IOM uint8_t C1EPO : 1;   /*!< [6..6] ACMPLP1 Edge Polarity Switching                                    */
            __IOM uint8_t C1EDG : 1;   /*!< [7..7] ACMPLP1 Edge Detection Selection                                   */
        } COMPFIR_b;
    };

    union
    {
        __IOM uint8_t COMPOCR;         /*!< (@ 0x00000002) ACMPLP Output Control Register                             */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t C0OE  : 1;   /*!< [1..1] ACMPLP0 VCOUT Pin Output Enable                                    */
            __IOM uint8_t C0OP  : 1;   /*!< [2..2] ACMPLP0 VCOUT Output Polarity Selection                            */
            uint8_t             : 2;
            __IOM uint8_t C1OE  : 1;   /*!< [5..5] ACMPLP1 VCOUT Pin Output Enable                                    */
            __IOM uint8_t C1OP  : 1;   /*!< [6..6] ACMPLP1 VCOUT Output Polarity Selection                            */
            __IOM uint8_t SPDMD : 1;   /*!< [7..7] ACMPLP0/ACMPLP1 Speed Selection                                    */
        } COMPOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t COMPSEL0;        /*!< (@ 0x00000004) Comparator Input Select Register                           */

        struct
        {
            __IOM uint8_t IVCMP0 : 3;  /*!< [2..0] ACMPLP0 Input (IVCMP0) Selection                                   */
            uint8_t              : 1;
            __IOM uint8_t IVCMP1 : 3;  /*!< [6..4] ACMPLP1 Input (IVCMP1) Selection                                   */
            uint8_t              : 1;
        } COMPSEL0_b;
    };

    union
    {
        __IOM uint8_t COMPSEL1;        /*!< (@ 0x00000005) Comparator Reference voltage Select Register               */

        struct
        {
            __IOM uint8_t IVREF0 : 3;  /*!< [2..0] ACMPLP0 Reference Voltage (IVREF0) Selection                       */
            uint8_t              : 1;
            __IOM uint8_t IVREF1 : 3;  /*!< [6..4] ACMPLP1 Reference Voltage(IVREF1) Selection                        */
            __IOM uint8_t C1VRF2 : 1;  /*!< [7..7] ACMPLP1 Reference Voltage Selection                                */
        } COMPSEL1_b;
    };
} R_ACMPLP_Type;                       /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief A/D Converter (R_ADC0)
 */

typedef struct                         /*!< (@ 0x4005C000) R_ADC0 Structure                                           */
{
    union
    {
        __IOM uint16_t ADCSR;          /*!< (@ 0x00000000) A/D Control Register                                       */

        struct
        {
            __IOM uint16_t DBLANS : 5; /*!< [4..0] Double Trigger Channel SelectThese bits select one analog
                                        *   input channel for double triggered operation. The setting
                                        *   is only effective while double trigger mode is selected.                  */
            uint16_t              : 1;
            __IOM uint16_t GBADIE : 1; /*!< [6..6] Group B Scan End Interrupt Enable                                  */
            __IOM uint16_t DBLE   : 1; /*!< [7..7] Double Trigger Mode Select                                         */
            __IOM uint16_t EXTRG  : 1; /*!< [8..8] Trigger Select                                                     */
            __IOM uint16_t TRGE   : 1; /*!< [9..9] Trigger Start Enable                                               */
            __IOM uint16_t ADHSC  : 1; /*!< [10..10] A/D Conversion Operation Mode Select                             */
            uint16_t              : 1;
            __IOM uint16_t ADIE   : 1; /*!< [12..12] Scan End Interrupt Enable                                        */
            __IOM uint16_t ADCS   : 2; /*!< [14..13] Scan Mode Select                                                 */
            __IOM uint16_t ADST   : 1; /*!< [15..15] A/D Conversion Start                                             */
        } ADCSR_b;
    };

    union
    {
        __IOM uint8_t ADREF;           /*!< (@ 0x00000002) A/D status register                                        */

        struct
        {
            __IOM uint8_t ADF : 1;     /*!< [0..0] Scanning end flag bitThis bit is a status bit that becomes
                                        *   "1" while scanning.                                                       */
            uint8_t              : 6;
            __IM uint8_t ADSCACT : 1;  /*!< [7..7] Scanning status bit                                                */
        } ADREF_b;
    };

    union
    {
        __IOM uint8_t ADEXREF;         /*!< (@ 0x00000003) A/D enhancing status register                              */

        struct
        {
            __IOM uint8_t GBADF : 1;   /*!< [0..0] Group B scanning end flag bit.                                     */
            uint8_t             : 7;
        } ADEXREF_b;
    };

    union
    {
        __IOM uint16_t ADANSA[2];      /*!< (@ 0x00000004) A/D Channel Select Register                                */

        struct
        {
            __IOM uint16_t ANSA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSA_b[2];
    };

    union
    {
        __IOM uint16_t ADADS[2];       /*!< (@ 0x00000008) A/D-Converted Value Addition/Average Channel
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint16_t ADS0  : 1;  /*!< [0..0] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS1  : 1;  /*!< [1..1] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS2  : 1;  /*!< [2..2] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS3  : 1;  /*!< [3..3] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS4  : 1;  /*!< [4..4] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS5  : 1;  /*!< [5..5] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS6  : 1;  /*!< [6..6] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS7  : 1;  /*!< [7..7] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS8  : 1;  /*!< [8..8] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS9  : 1;  /*!< [9..9] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS10 : 1;  /*!< [10..10] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS11 : 1;  /*!< [11..11] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS12 : 1;  /*!< [12..12] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS13 : 1;  /*!< [13..13] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS14 : 1;  /*!< [14..14] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS15 : 1;  /*!< [15..15] A/D-Converted Value Addition/Average Channel Select              */
        } ADADS_b[2];
    };

    union
    {
        __IOM uint8_t ADADC;           /*!< (@ 0x0000000C) A/D-Converted Value Addition/Average Count Select
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t ADC : 3;     /*!< [2..0] Addition frequency selection bit.NOTE: AVEE bit is valid
                                        *   at the only setting of ADC[2:0] bits = 001b or 011b. When
                                        *   average mode is selected by setting the ADADC.AVEE bit
                                        *   to 1, do not set the addition count to three times (ADADC.ADC[2:0]
                                        *   = 010b)                                                                   */
            uint8_t            : 4;
            __IOM uint8_t AVEE : 1;    /*!< [7..7] Average Mode Enable. NOTE:When average mode is deselected
                                        *   by setting the ADADC.AVEE bit to 0, set the addition count
                                        *   to 1, 2, 3, 4 or 16-time conversion. 16-time conversion
                                        *   can only be used with 12-bit accuracy selected. NOTE: AVEE
                                        *   bit is valid at the only setting of ADC[2:0] bits = 001b
                                        *   or 011b. When average mode is selected by setting the ADADC.AVEE
                                        *   bit to 1, do not set the addition count to three times
                                        *   (ADADC.ADC[2:0] = 010b)                                                   */
        } ADADC_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t ADCER;          /*!< (@ 0x0000000E) A/D Control Extended Register                              */

        struct
        {
            uint16_t               : 1;
            __IOM uint16_t ADPRC   : 2; /*!< [2..1] A/D Conversion Accuracy Specify                                    */
            uint16_t               : 1;
            __IOM uint16_t DCE     : 1; /*!< [4..4] Discharge Enable                                                   */
            __IOM uint16_t ACE     : 1; /*!< [5..5] A/D Data Register Automatic Clearing Enable                        */
            uint16_t               : 2;
            __IOM uint16_t DIAGVAL : 2; /*!< [9..8] Self-Diagnosis Conversion Voltage Select                           */
            __IOM uint16_t DIAGLD  : 1; /*!< [10..10] Self-Diagnosis Mode Select                                       */
            __IOM uint16_t DIAGM   : 1; /*!< [11..11] Self-Diagnosis Enable                                            */
            uint16_t               : 2;
            __IOM uint16_t ADINV   : 1; /*!< [14..14] Single-Ended Input A/D Converted Data Inversion Select           */
            __IOM uint16_t ADRFMT  : 1; /*!< [15..15] A/D Data Register Format Select                                  */
        } ADCER_b;
    };

    union
    {
        __IOM uint16_t ADSTRGR;        /*!< (@ 0x00000010) A/D Conversion Start Trigger Select Register               */

        struct
        {
            __IOM uint16_t TRSB : 6;   /*!< [5..0] A/D Conversion Start Trigger Select for Group BSelect
                                        *   the A/D conversion start trigger for group B in group scan
                                        *   mode.                                                                     */
            uint16_t            : 2;
            __IOM uint16_t TRSA : 6;   /*!< [13..8] A/D Conversion Start Trigger SelectSelect the A/D conversion
                                        *   start trigger in single scan mode and continuous mode.
                                        *   In group scan mode, the A/D conversion start trigger for
                                        *   group A is selected.                                                      */
            uint16_t : 2;
        } ADSTRGR_b;
    };

    union
    {
        __IOM uint16_t ADEXICR;        /*!< (@ 0x00000012) A/D Conversion Extended Input Control Register             */

        struct
        {
            __IOM uint16_t TSSAD : 1;  /*!< [0..0] Temperature Sensor Output A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            __IOM uint16_t OCSAD : 1;  /*!< [1..1] Internal Reference Voltage A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            uint16_t            : 6;
            __IOM uint16_t TSSA : 1;   /*!< [8..8] Temperature Sensor Output A/D Conversion Select                    */
            __IOM uint16_t OCSA : 1;   /*!< [9..9] Internal Reference Voltage A/D Conversion Select                   */
            __IOM uint16_t TSSB : 1;   /*!< [10..10] Temperature Sensor Output A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            __IOM uint16_t OCSB : 1;   /*!< [11..11] Internal Reference Voltage A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            uint16_t             : 2;
            __IOM uint16_t EXSEL : 1;  /*!< [14..14] Extended Analog Input Select                                     */
            __IOM uint16_t EXOEN : 1;  /*!< [15..15] Extended Analog Output Control                                   */
        } ADEXICR_b;
    };

    union
    {
        __IOM uint16_t ADANSB[2];      /*!< (@ 0x00000014) A/D Channel Select Register B                              */

        struct
        {
            __IOM uint16_t ANSB0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSB1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSB2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSB3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSB4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSB5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSB6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSB7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSB8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSB9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSB10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSB11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSB12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSB13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSB14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSB15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSB_b[2];
    };

    union
    {
        __IM uint16_t ADDBLDR;          /*!< (@ 0x00000018) A/D Data Duplication Register                              */

        struct
        {
            __IM uint16_t ADDBLDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                         *   result of A/D conversion in response to the second trigger
                                         *   in double trigger mode.                                                   */
        } ADDBLDR_b;
    };

    union
    {
        __IM uint16_t ADTSDR;          /*!< (@ 0x0000001A) A/D Temperature Sensor Data Register                       */

        struct
        {
            __IM uint16_t ADTSDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D conversion result of temperature sensor output.                       */
        } ADTSDR_b;
    };

    union
    {
        __IM uint16_t ADOCDR;          /*!< (@ 0x0000001C) A/D Internal Reference Voltage Data Register               */

        struct
        {
            __IM uint16_t ADOCDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D result of internal reference voltage.                                 */
        } ADOCDR_b;
    };

    union
    {
        union
        {
            __IM uint16_t ADRD_RIGHT;     /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Right Justified           */

            struct
            {
                __IM uint16_t AD : 14;    /*!< [13..0] A/D-converted value (right-justified)The format for
                                           *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
                __IM uint16_t DIAGST : 2; /*!< [15..14] Self-Diagnosis Status                                            */
            } ADRD_RIGHT_b;
        };

        union
        {
            __IM uint16_t ADRD_LEFT;       /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Left Justified            */

            struct
            {
                __IM uint16_t DIAGST : 2;  /*!< [1..0] Self-Diagnosis Status                                              */
                __IM uint16_t AD     : 14; /*!< [15..2] A/D-converted value (right-justified)The format for
                                            *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
            } ADRD_LEFT_b;
        };
    };

    union
    {
        __IM uint16_t ADDR[28];        /*!< (@ 0x00000020) A/D Data Register                                          */

        struct
        {
            __IM uint16_t ADDR : 16;   /*!< [15..0] The ADDR register is a 16-bit read-only registers for
                                        *   storing the result of A/D conversion.                                     */
        } ADDR_b[28];
    };
    __IM uint16_t RESERVED1[5];

    union
    {
        __IOM uint8_t ADAMPOFF;        /*!< (@ 0x00000062) A/D RRAMP off state register                               */

        struct
        {
            __IOM uint8_t OPOFF : 8;   /*!< [7..0] OPOFF                                                              */
        } ADAMPOFF_b;
    };

    union
    {
        __IOM uint8_t ADTSTPR;         /*!< (@ 0x00000063) A/D Test Protecting Release Register                       */

        struct
        {
            __IOM uint8_t PRO  : 1;    /*!< [0..0] Test register protecting bit.                                      */
            __IOM uint8_t B0WI : 1;    /*!< [1..1] Bit 0 writing permission bit.                                      */
            uint8_t            : 6;
        } ADTSTPR_b;
    };

    union
    {
        __IOM uint16_t ADDDACER;       /*!< (@ 0x00000064) A/D RRAMP Discharge Period Register                        */

        struct
        {
            __IOM uint16_t WRION  : 5; /*!< [4..0] WRION                                                              */
            uint16_t              : 3;
            __IOM uint16_t WRIOFF : 5; /*!< [12..8] WRIOFF                                                            */
            uint16_t              : 2;
            __IOM uint16_t ADHS   : 1; /*!< [15..15] ADHS                                                             */
        } ADDDACER_b;
    };

    union
    {
        __IOM uint16_t ADSHCR;         /*!< (@ 0x00000066) A/D Sample and Hold Circuit Control Register               */

        struct
        {
            __IOM uint16_t SSTSH : 8;  /*!< [7..0] Channel-Dedicated Sample-and-Hold Circuit Sampling Time
                                        *   Setting Set the sampling time (4 to 255 states)                           */
            __IOM uint16_t SHANS0 : 1; /*!< [8..8] AN000 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS1 : 1; /*!< [9..9] AN001 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS2 : 1; /*!< [10..10] AN002 sample-and-hold circuit Select                             */
            uint16_t              : 5;
        } ADSHCR_b;
    };

    union
    {
        __IOM uint16_t ADEXTSTR;       /*!< (@ 0x00000068) A/D Enhancing Test Register                                */

        struct
        {
            __IOM uint16_t SHTEST : 3; /*!< [2..0] Test mode bit for S&H circuit.Test mode bit of S&H circuit
                                        *   only for channel.                                                         */
            uint16_t             : 1;
            __IOM uint16_t SWTST : 2;  /*!< [5..4] Test selection bit for pressure switch.                            */
            uint16_t             : 2;
            __IOM uint16_t SHTRM : 2;  /*!< [9..8] Current adjustment trim bit for S&H circuit.Trim bit
                                        *   for adjustment to hardening of process.                                   */
            uint16_t              : 1;
            __IOM uint16_t ADTRM3 : 1; /*!< [11..11] Trim bit 3 for A/D hard macro.3bit Flash comparator
                                        *   power save bit for A/D hard macro to hardening of process.                */
            __IOM uint16_t ADTRM2 : 2; /*!< [13..12] Trim bit 2 for A/D hard macro.Bias adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
            __IOM uint16_t ADTRM1 : 2; /*!< [15..14] Trim bit 1 for A/D hard macro.Timing adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
        } ADEXTSTR_b;
    };

    union
    {
        __IOM uint16_t ADTSTRA;           /*!< (@ 0x0000006A) A/D Test Register A                                        */

        struct
        {
            __IOM uint16_t ATBUSSEL : 1;  /*!< [0..0] Analog test bus selection bit.                                     */
            __IOM uint16_t TSTSWREF : 3;  /*!< [3..1] Pressure switch refreshing setting bit for S&H circuit
                                           *   amplifier test.Refreshing the pressure switch that opens
                                           *   for the DAC output voltage charge period when the amplifier
                                           *   of the S&H circuit is tested only for the channel is set.                 */
            uint16_t            : 1;
            __IOM uint16_t OCSW : 1;      /*!< [5..5] Internal reference voltage analog switch test control
                                           *   bit.                                                                      */
            __IOM uint16_t TSSW : 1;      /*!< [6..6] Temperature sensor output analogue switch test control
                                           *   bit                                                                       */
            uint16_t                 : 1;
            __IOM uint16_t ADTEST_AD : 4; /*!< [11..8] Test bit for A/D analog module Bit for test of A/D analog
                                           *   module Details are described to the bit explanation.                      */
            __IOM uint16_t ADTEST_IO : 4; /*!< [15..12] Test bit for analog I/ODetails are described to the
                                           *   bit explanation.                                                          */
        } ADTSTRA_b;
    };

    union
    {
        __IOM uint16_t ADTSTRB;        /*!< (@ 0x0000006C) A/D Test Register B                                        */

        struct
        {
            __IOM uint16_t ADVAL : 15; /*!< [14..0] Signal input bit bit14-0 for A/D analog module test.It
                                        *   corresponds to ADVAL 14:0 input of A/D analog module.                     */
            uint16_t : 1;
        } ADTSTRB_b;
    };

    union
    {
        __IOM uint16_t ADTSTRC;         /*!< (@ 0x0000006E) A/D Test Register C                                        */

        struct
        {
            __IOM uint16_t ADMD : 8;    /*!< [7..0] Bit for A/D analog module test.ADMODE 6:0 input of A/D
                                         *   analog module.                                                            */
            uint16_t               : 4;
            __IOM uint16_t SYNCERR : 1; /*!< [12..12] Synchronous analog to digital conversion error bit.              */
            uint16_t               : 3;
        } ADTSTRC_b;
    };

    union
    {
        __IOM uint16_t ADTSTRD;         /*!< (@ 0x00000070) A/D Test Register D                                        */

        struct
        {
            __IOM uint16_t ADVAL16 : 1; /*!< [0..0] Signal input bit bit16 for A/D analog module test.It
                                         *   corresponds to ADVAL 16 input of A/D analog module.                       */
            uint16_t : 15;
        } ADTSTRD_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR0;      /*!< (@ 0x00000072) A/D Channel Switch Test Control Register 0                 */

        struct
        {
            __IOM uint16_t CHSW00 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW01 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW02 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW03 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW04 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW05 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR0_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR1;      /*!< (@ 0x00000074) A/D Channel Switch Test Control Register 1                 */

        struct
        {
            __IOM uint16_t CHSW16 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW17 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW18 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW19 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW20 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW21 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR1_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR2;        /*!< (@ 0x00000076) A/D Channel Switch Test Control Register 2                 */

        struct
        {
            __IOM uint16_t EX0SW : 1;    /*!< [0..0] Test control of 0 enhancing input channel switches bit
                                          *   (ANEX0 switch)                                                            */
            __IOM uint16_t EX1SW : 1;    /*!< [1..1] Test control of one enhancing input channel switch bit
                                          *   (ANEX1 switch).                                                           */
            uint16_t                : 2;
            __IOM uint16_t SHBYPS0  : 1; /*!< [4..4] S&H circuit by-pass switch control bit 0.                          */
            __IOM uint16_t SHBYPS1  : 1; /*!< [5..5] S&H circuit by-pass switch control bit 1.                          */
            __IOM uint16_t SHBYPS2  : 1; /*!< [6..6] S&H circuit by-pass switch control bit 2.                          */
            uint16_t                : 1;
            __IOM uint16_t GRP0SW   : 1; /*!< [8..8] Test control of 0 group switches bit.                              */
            __IOM uint16_t GRP1SW   : 1; /*!< [9..9] Test control of one group switch bit.                              */
            __IOM uint16_t GRP2SW   : 1; /*!< [10..10] Test control of two group switches bit                           */
            __IOM uint16_t GRP3SW   : 1; /*!< [11..11] Test control of two group switches bit                           */
            __IOM uint16_t GRPEX1SW : 1; /*!< [12..12] Switch test control bit of enhancing analog ANEX1                */
            uint16_t                : 3;
        } ADSWTSTR2_b;
    };
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint8_t ADDISCR;         /*!< (@ 0x0000007A) A/D Disconnection Detection Control Register               */

        struct
        {
            __IOM uint8_t ADNDIS : 4;  /*!< [3..0] The charging time                                                  */
            __IOM uint8_t CHARGE : 1;  /*!< [4..4] Selection of Precharge or Discharge                                */
            uint8_t              : 3;
        } ADDISCR_b;
    };

    union
    {
        __IOM uint8_t ADSWCR;          /*!< (@ 0x0000007B) A/D Pressure Switch Control Register                       */

        struct
        {
            __IOM uint8_t ADSWREF : 3; /*!< [2..0] These bits are read as 0. The write value should be 0.Refreshing
                                        *   the pressure switch in A/D analog module is set.                          */
            uint8_t               : 1;
            __IOM uint8_t SHSWREF : 3; /*!< [6..4] S&H Boost Switch Refresh Interval Setting                          */
            uint8_t               : 1;
        } ADSWCR_b;
    };

    union
    {
        __IOM uint8_t ADSHMSR;         /*!< (@ 0x0000007C) A/D Sample and Hold Operation Mode Select Register         */

        struct
        {
            __IOM uint8_t SHMD : 1;    /*!< [0..0] Channel-Dedicated Sample-and-Hold Circuit Operation Mode
                                        *   Select                                                                    */
            uint8_t : 7;
        } ADSHMSR_b;
    };

    union
    {
        __IOM uint8_t ADICR;           /*!< (@ 0x0000007D) A/D Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t ADIC : 2;    /*!< [1..0] A/D Interrupt Control                                              */
            uint8_t            : 6;
        } ADICR_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t ADGSPCR;         /*!< (@ 0x00000080) A/D Group Scan Priority Control Register                   */

        struct
        {
            __IOM uint16_t PGS : 1;     /*!< [0..0] Group A priority control setting bit.Note: When the PGS
                                         *   bit is to be set to 1, the ADCSR.ADCS[1:0] bits must be
                                         *   set to 01b (group scan mode). If the bits are set to any
                                         *   other values, proper operation is not guaranteed.                         */
            __IOM uint16_t GBRSCN : 1;  /*!< [1..1] Group B Restart Setting(Enabled only when PGS = 1. Reserved
                                         *   when PGS = 0.)                                                            */
            uint16_t               : 6;
            __IOM uint16_t GBEXTRG : 1; /*!< [8..8] External trigger selection bit for group B.                        */
            uint16_t               : 6;
            __IOM uint16_t GBRP    : 1; /*!< [15..15] Group B Single Scan Continuous Start(Enabled only when
                                         *   PGS = 1. Reserved when PGS = 0.)Note: When the GBRP bit
                                         *   has been set to 1, single scan is performed continuously
                                         *   for group B regardless of the setting of the GBRSCN bit.                  */
        } ADGSPCR_b;
    };

    union
    {
        __IM uint16_t ADGSCS;          /*!< (@ 0x00000082) A/D Conversion Channel Status Register (for Group
                                        *                  Scan)                                                      */

        struct
        {
            __IM uint16_t CHSELGB : 8; /*!< [7..0] Channel status of Group B scan                                     */
            __IM uint16_t CHSELGA : 8; /*!< [15..8] Channel status of Group A scan                                    */
        } ADGSCS_b;
    };

    union
    {
        __IM uint16_t ADDBLDRA;          /*!< (@ 0x00000084) A/D Data Duplexing Register A                              */

        struct
        {
            __IM uint16_t ADDBLDRA : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRA_b;
    };

    union
    {
        __IM uint16_t ADDBLDRB;          /*!< (@ 0x00000086) A/D Data Duplexing Register B                              */

        struct
        {
            __IM uint16_t ADDBLDRB : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRB_b;
    };

    union
    {
        __IOM uint8_t ADSER;           /*!< (@ 0x00000088) A/D Sampling Extension Register                            */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t SMPEX : 1;   /*!< [7..7] Sampling extension control                                         */
        } ADSER_b;
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint8_t ADHVREFCNT;      /*!< (@ 0x0000008A) A/D High-Potential/Low-Potential Reference Voltage
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint8_t HVSEL : 2;   /*!< [1..0] High-Potential Reference Voltage Select                            */
            uint8_t             : 2;
            __IOM uint8_t LVSEL : 1;   /*!< [4..4] Low-Potential Reference Voltage Select                             */
            uint8_t             : 2;
            __IOM uint8_t ADSLP : 1;   /*!< [7..7] Sleep                                                              */
        } ADHVREFCNT_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IM uint8_t ADWINMON;         /*!< (@ 0x0000008C) A/D Compare Function Window A/B Status Monitor
                                        *                  Register                                                   */

        struct
        {
            __IM uint8_t MONCOMB : 1;  /*!< [0..0] Combination result monitorThis bit indicates the combination
                                        *   result.This bit is valid when both window A operation and
                                        *   window B operation are enabled.                                           */
            uint8_t              : 3;
            __IM uint8_t MONCMPA : 1;  /*!< [4..4] Comparison Result Monitor A                                        */
            __IM uint8_t MONCMPB : 1;  /*!< [5..5] Comparison Result Monitor B                                        */
            uint8_t              : 2;
        } ADWINMON_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t ADCMPCR;        /*!< (@ 0x00000090) A/D Compare Function Control Register                      */

        struct
        {
            __IOM uint16_t CMPAB : 2;  /*!< [1..0] Window A/B Composite Conditions SettingNOTE: These bits
                                        *   are valid when both window A and window B are enabled (CMPAE
                                        *   = 1 and CMPBE = 1).                                                       */
            uint16_t              : 7;
            __IOM uint16_t CMPBE  : 1; /*!< [9..9] Compare Window B Operation Enable                                  */
            uint16_t              : 1;
            __IOM uint16_t CMPAE  : 1; /*!< [11..11] Compare Window A Operation Enable                                */
            uint16_t              : 1;
            __IOM uint16_t CMPBIE : 1; /*!< [13..13] Compare B Interrupt Enable                                       */
            __IOM uint16_t WCMPE  : 1; /*!< [14..14] Window Function Setting                                          */
            __IOM uint16_t CMPAIE : 1; /*!< [15..15] Compare A Interrupt Enable                                       */
        } ADCMPCR_b;
    };

    union
    {
        __IOM uint8_t ADCMPANSER;      /*!< (@ 0x00000092) A/D Compare Function Window A Extended Input
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint8_t CMPTSA : 1;  /*!< [0..0] Temperature sensor output Compare selection bit.                   */
            __IOM uint8_t CMPOCA : 1;  /*!< [1..1] Internal reference voltage Compare selection bit.                  */
            uint8_t              : 6;
        } ADCMPANSER_b;
    };

    union
    {
        __IOM uint8_t ADCMPLER;        /*!< (@ 0x00000093) A/D Compare Function Window A Extended Input
                                        *                  Comparison Condition Setting Register                      */

        struct
        {
            __IOM uint8_t CMPLTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Comparison
                                        *   Condition Select                                                          */
            __IOM uint8_t CMPLOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage ComparisonCondition
                                        *   Select                                                                    */
            uint8_t : 6;
        } ADCMPLER_b;
    };

    union
    {
        __IOM uint16_t ADCMPANSR[2];     /*!< (@ 0x00000094) A/D Compare Function Window A Channel Select
                                          *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPCHA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t CMPCHA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t CMPCHA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t CMPCHA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t CMPCHA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t CMPCHA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t CMPCHA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t CMPCHA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t CMPCHA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t CMPCHA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t CMPCHA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t CMPCHA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t CMPCHA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t CMPCHA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t CMPCHA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t CMPCHA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADCMPANSR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPLR[2];        /*!< (@ 0x00000098) A/D Compare Function Window A Comparison Condition
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t CMPLCHA0  : 1; /*!< [0..0] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA1  : 1; /*!< [1..1] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA2  : 1; /*!< [2..2] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA3  : 1; /*!< [3..3] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA4  : 1; /*!< [4..4] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA5  : 1; /*!< [5..5] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA6  : 1; /*!< [6..6] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA7  : 1; /*!< [7..7] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA8  : 1; /*!< [8..8] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA9  : 1; /*!< [9..9] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA10 : 1; /*!< [10..10] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA11 : 1; /*!< [11..11] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA12 : 1; /*!< [12..12] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA13 : 1; /*!< [13..13] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA14 : 1; /*!< [14..14] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA15 : 1; /*!< [15..15] Comparison condition of input                                    */
        } ADCMPLR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPDR0;          /*!< (@ 0x0000009C) A/D Compare Function Window A Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR0 : 16; /*!< [15..0] The ADCMPDR0 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR0 sets the lower-side
                                           *   level of window A.                                                        */
        } ADCMPDR0_b;
    };

    union
    {
        __IOM uint16_t ADCMPDR1;          /*!< (@ 0x0000009E) A/D Compare Function Window A Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR1 : 16; /*!< [15..0] The ADCMPDR1 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR1 sets the upper-side
                                           *   level of window A..                                                       */
        } ADCMPDR1_b;
    };

    union
    {
        __IOM uint16_t ADCMPSR[2];         /*!< (@ 0x000000A0) A/D Compare Function Window A Channel Status
                                            *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPSTCHA0  : 1; /*!< [0..0] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA1  : 1; /*!< [1..1] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA2  : 1; /*!< [2..2] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA3  : 1; /*!< [3..3] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA4  : 1; /*!< [4..4] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA5  : 1; /*!< [5..5] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA6  : 1; /*!< [6..6] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA7  : 1; /*!< [7..7] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA8  : 1; /*!< [8..8] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA9  : 1; /*!< [9..9] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA10 : 1; /*!< [10..10] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA11 : 1; /*!< [11..11] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA12 : 1; /*!< [12..12] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA13 : 1; /*!< [13..13] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA14 : 1; /*!< [14..14] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA15 : 1; /*!< [15..15] Compare window A flag of input                                   */
        } ADCMPSR_b[2];
    };

    union
    {
        __IOM uint8_t ADCMPSER;         /*!< (@ 0x000000A4) A/D Compare Function Window A Extended Input
                                         *                  Channel Status Register                                    */

        struct
        {
            __IOM uint8_t CMPSTTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            __IOM uint8_t CMPSTOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            uint8_t : 6;
        } ADCMPSER_b;
    };
    __IM uint8_t RESERVED8;

    union
    {
        __IOM uint8_t ADCMPBNSR;       /*!< (@ 0x000000A6) A/D Compare Function Window B Channel Selection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t CMPCHB : 6;  /*!< [5..0] Compare window B channel selection bit.The channel that
                                        *   compares it on the condition of compare window B is selected.             */
            uint8_t             : 1;
            __IOM uint8_t CMPLB : 1;   /*!< [7..7] Compare window B Compare condition setting bit.                    */
        } ADCMPBNSR_b;
    };
    __IM uint8_t RESERVED9;

    union
    {
        __IOM uint16_t ADWINLLB;          /*!< (@ 0x000000A8) A/D Compare Function Window B Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINLLB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the lower level of the window B.                              */
        } ADWINLLB_b;
    };

    union
    {
        __IOM uint16_t ADWINULB;          /*!< (@ 0x000000AA) A/D Compare Function Window B Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINULB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the higher level of the window B.                             */
        } ADWINULB_b;
    };

    union
    {
        __IOM uint8_t ADCMPBSR;        /*!< (@ 0x000000AC) A/D Compare Function Window B Status Register              */

        struct
        {
            __IOM uint8_t CMPSTB : 1;  /*!< [0..0] Compare window B flag.It is a status flag that shows
                                        *   the comparative result of CH (AN000-AN027, temperature
                                        *   sensor, and internal reference voltage) made the object
                                        *   of window B relation condition.                                           */
            uint8_t : 7;
        } ADCMPBSR_b;
    };
    __IM uint8_t  RESERVED10;
    __IM uint16_t RESERVED11;

    union
    {
        __IM uint16_t ADBUF0;          /*!< (@ 0x000000B0) A/D Data Buffer Register 0                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF0_b;
    };

    union
    {
        __IM uint16_t ADBUF1;          /*!< (@ 0x000000B2) A/D Data Buffer Register 1                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF1_b;
    };

    union
    {
        __IM uint16_t ADBUF2;          /*!< (@ 0x000000B4) A/D Data Buffer Register 2                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF2_b;
    };

    union
    {
        __IM uint16_t ADBUF3;          /*!< (@ 0x000000B6) A/D Data Buffer Register 3                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF3_b;
    };

    union
    {
        __IM uint16_t ADBUF4;          /*!< (@ 0x000000B8) A/D Data Buffer Register 4                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF4_b;
    };

    union
    {
        __IM uint16_t ADBUF5;          /*!< (@ 0x000000BA) A/D Data Buffer Register 5                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF5_b;
    };

    union
    {
        __IM uint16_t ADBUF6;          /*!< (@ 0x000000BC) A/D Data Buffer Register 6                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF6_b;
    };

    union
    {
        __IM uint16_t ADBUF7;          /*!< (@ 0x000000BE) A/D Data Buffer Register 7                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF7_b;
    };

    union
    {
        __IM uint16_t ADBUF8;          /*!< (@ 0x000000C0) A/D Data Buffer Register 8                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF8_b;
    };

    union
    {
        __IM uint16_t ADBUF9;          /*!< (@ 0x000000C2) A/D Data Buffer Register 9                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF9_b;
    };

    union
    {
        __IM uint16_t ADBUF10;         /*!< (@ 0x000000C4) A/D Data Buffer Register 10                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF10_b;
    };

    union
    {
        __IM uint16_t ADBUF11;         /*!< (@ 0x000000C6) A/D Data Buffer Register 11                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF11_b;
    };

    union
    {
        __IM uint16_t ADBUF12;         /*!< (@ 0x000000C8) A/D Data Buffer Register 12                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF12_b;
    };

    union
    {
        __IM uint16_t ADBUF13;         /*!< (@ 0x000000CA) A/D Data Buffer Register 13                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF13_b;
    };

    union
    {
        __IM uint16_t ADBUF14;         /*!< (@ 0x000000CC) A/D Data Buffer Register 14                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF14_b;
    };

    union
    {
        __IM uint16_t ADBUF15;         /*!< (@ 0x000000CE) A/D Data Buffer Register 15                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF15_b;
    };

    union
    {
        __IOM uint8_t ADBUFEN;         /*!< (@ 0x000000D0) A/D Data Buffer Enable Register                            */

        struct
        {
            __IOM uint8_t BUFEN : 1;   /*!< [0..0] Data Buffer Enable                                                 */
            uint8_t             : 7;
        } ADBUFEN_b;
    };
    __IM uint8_t RESERVED12;

    union
    {
        __IOM uint8_t ADBUFPTR;        /*!< (@ 0x000000D2) A/D Data Buffer Pointer Register                           */

        struct
        {
            __IM uint8_t BUFPTR : 4;   /*!< [3..0] Data Buffer PointerThese bits indicate the number of
                                        *   data buffer to which the next A/D converted data is transferred.          */
            __IM uint8_t PTROVF : 1;   /*!< [4..4] Pointer Overflow Flag                                              */
            uint8_t             : 3;
        } ADBUFPTR_b;
    };
    __IM uint8_t  RESERVED13;
    __IM uint16_t RESERVED14[4];
    __IM uint8_t  RESERVED15;

    union
    {
        __IOM uint8_t ADSSTRL;         /*!< (@ 0x000000DD) A/D Sampling State Register L                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (AN016-AN027)                                */
        } ADSSTRL_b;
    };

    union
    {
        __IOM uint8_t ADSSTRT;         /*!< (@ 0x000000DE) A/D Sampling State Register T                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (temperature sensor output)                  */
        } ADSSTRT_b;
    };

    union
    {
        __IOM uint8_t ADSSTRO;         /*!< (@ 0x000000DF) A/D Sampling State Register O                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (Internal reference voltage)                 */
        } ADSSTRO_b;
    };

    union
    {
        __IOM uint8_t ADSSTR[16];      /*!< (@ 0x000000E0) A/D Sampling State Registers                               */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling time setting                                              */
        } ADSSTR_b[16];
    };

    union
    {
        __IOM uint16_t ADANIM;         /*!< (@ 0x000000F0) A/D Channel Input Mode Select Register                     */

        struct
        {
            __IOM uint16_t ANIM0 : 1;  /*!< [0..0] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM1 : 1;  /*!< [1..1] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM2 : 1;  /*!< [2..2] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM3 : 1;  /*!< [3..3] Analog Channel Input Mode Select                                   */
            uint16_t             : 12;
        } ADANIM_b;
    };

    union
    {
        __IOM uint8_t ADCALEXE;        /*!< (@ 0x000000F2) A/D Calibration Execution Register                         */

        struct
        {
            uint8_t              : 6;
            __IM uint8_t  CALMON : 1;  /*!< [6..6] Calibration Status Flag                                            */
            __IOM uint8_t CALEXE : 1;  /*!< [7..7] Calibration Start                                                  */
        } ADCALEXE_b;
    };
    __IM uint8_t RESERVED16;

    union
    {
        __IOM uint8_t VREFAMPCNT;        /*!< (@ 0x000000F4) A/D Dedicated Reference Voltage Circuit Control
                                          *                  Register                                                   */

        struct
        {
            __IOM uint8_t OLDETEN   : 1; /*!< [0..0] OLDET Enable                                                       */
            __IOM uint8_t VREFADCG  : 2; /*!< [2..1] VREFADC Output Voltage Control                                     */
            __IOM uint8_t VREFADCEN : 1; /*!< [3..3] VREFADCG Enable                                                    */
            __IOM uint8_t BGREN     : 1; /*!< [4..4] BGR Enable                                                         */
            uint8_t                 : 2;
            __IOM uint8_t ADSLP     : 1; /*!< [7..7] Sleep                                                              */
        } VREFAMPCNT_b;
    };
    __IM uint8_t  RESERVED17;
    __IM uint16_t RESERVED18;

    union
    {
        __IOM uint16_t ADRD;           /*!< (@ 0x000000F8) A/D Self-Diagnosis Data Register                           */

        struct
        {
            __IM uint16_t AD : 16;     /*!< [15..0] Converted Value 15 to 0                                           */
        } ADRD_b;
    };

    union
    {
        __IM uint8_t ADRST;            /*!< (@ 0x000000FA) A/D Self-Diagnostic Status Register                        */

        struct
        {
            __IM uint8_t DIAGST : 2;   /*!< [1..0] Self-Diagnosis Status                                              */
            uint8_t             : 6;
        } ADRST_b;
    };
    __IM uint8_t  RESERVED19;
    __IM uint16_t RESERVED20[82];

    union
    {
        __IOM uint16_t ADPGACR;           /*!< (@ 0x000001A0) A/D Programmable Gain Amplifier Control Register           */

        struct
        {
            __IOM uint16_t P000SEL0  : 1; /*!< [0..0] A through amplifier is enable for PGA P000                         */
            __IOM uint16_t P000SEL1  : 1; /*!< [1..1] The amplifier passing is enable for PGA P000                       */
            __IOM uint16_t P000ENAMP : 1; /*!< [2..2] Amplifier enable bit for PGA P000                                  */
            __IOM uint16_t P000GEN   : 1; /*!< [3..3] PGA P000 gain setting and enable bit                               */
            __IOM uint16_t P001SEL0  : 1; /*!< [4..4] A through amplifier is enable for PGA P001                         */
            __IOM uint16_t P001SEL1  : 1; /*!< [5..5] The amplifier passing is enable for PGA P001                       */
            __IOM uint16_t P001ENAMP : 1; /*!< [6..6] Amplifier enable bit for PGA P001                                  */
            __IOM uint16_t P001GEN   : 1; /*!< [7..7] PGA P001 gain setting and enable bit                               */
            __IOM uint16_t P002SEL0  : 1; /*!< [8..8] A through amplifier is enable for PGA P002                         */
            __IOM uint16_t P002SEL1  : 1; /*!< [9..9] The amplifier passing is enable for PGA P002                       */
            __IOM uint16_t P002ENAMP : 1; /*!< [10..10] Amplifier enable bit for PGA P002                                */
            __IOM uint16_t P002GEN   : 1; /*!< [11..11] PGA P002 gain setting and enable bit                             */
            __IOM uint16_t P003SEL0  : 1; /*!< [12..12] A through amplifier is enable for PGA P003                       */
            __IOM uint16_t P003SEL1  : 1; /*!< [13..13] The amplifier passing is enable for PGA P003                     */
            __IOM uint16_t P003ENAMP : 1; /*!< [14..14] Amplifier enable bit for PGA P003                                */
            __IOM uint16_t P003GEN   : 1; /*!< [15..15] PGA P003 gain setting and enable bit                             */
        } ADPGACR_b;
    };

    union
    {
        __IOM uint16_t ADPGAGS0;         /*!< (@ 0x000001A2) A/D Programmable Gain Amplifier Gain Setting
                                          *                  Register 0                                                 */

        struct
        {
            __IOM uint16_t P000GAIN : 4; /*!< [3..0] PGA P000 gain setting bit.The gain magnification of (ADPGSDCR0.P000GEN=
                                          *   b) when the shingle end is input and each PGA P000 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P000GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P000DG 1:0.                    */
            __IOM uint16_t P001GAIN : 4; /*!< [7..4] PGA P001 gain setting bit.The gain magnification of (ADPGSDCR0.P001GEN=
                                          *   b) when the shingle end is input and each PGA P001 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P001GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P001DG 1:0.                    */
            __IOM uint16_t P002GAIN : 4; /*!< [11..8] PGA P002 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P002GEN=0b) when the shingle end is input and
                                          *   each PGA P002 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P002GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P002DG 1:0.                                                     */
            __IOM uint16_t P003GAIN : 4; /*!< [15..12] PGA P003 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P003GEN=0b) when the shingle end is input and
                                          *   each PGA P003 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P003GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P003DG 1:0.                                                     */
        } ADPGAGS0_b;
    };
    __IM uint16_t RESERVED21[6];

    union
    {
        __IOM uint16_t ADPGADCR0;       /*!< (@ 0x000001B0) A/D Programmable Gain Amplifier Differential
                                         *                  Input Control Register                                     */

        struct
        {
            __IOM uint16_t P000DG : 2;  /*!< [1..0] P000 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P000DEN, P000GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P000DEN : 1; /*!< [3..3] P000 Differential Input Enable                                     */
            __IOM uint16_t P001DG  : 2; /*!< [5..4] P001 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P001DEN, P001GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P001DEN : 1; /*!< [7..7] P001 Differential Input Enable                                     */
            __IOM uint16_t P002DG  : 2; /*!< [9..8] P002 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P002DEN, P002GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P002DEN : 1; /*!< [11..11] P002 Differential Input Enable                                   */
            __IOM uint16_t P003DG  : 2; /*!< [13..12] P003 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P003DEN, P003GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P003DEN : 1; /*!< [15..15] P003 Differential Input Enable                                   */
        } ADPGADCR0_b;
    };
    __IM uint16_t RESERVED22;

    union
    {
        __IOM uint8_t ADPGADBS0;       /*!< (@ 0x000001B4) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 0                               */

        struct
        {
            __IOM uint8_t P0BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P000 to P002 Bias Voltage
                                        *   SelectNOTE: This bit selects the input bias voltage value
                                        *   when differential inputs are used.                                        */
            uint8_t : 7;
        } ADPGADBS0_b;
    };

    union
    {
        __IOM uint8_t ADPGADBS1;       /*!< (@ 0x000001B5) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 1                               */

        struct
        {
            __IOM uint8_t P3BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P003 Bias Voltage SelectNOTE:
                                        *   This bit selects the input bias voltage value when differential
                                        *   inputs are used.                                                          */
            uint8_t : 7;
        } ADPGADBS1_b;
    };
    __IM uint16_t RESERVED23[21];

    union
    {
        __IOM uint8_t ADREFMON;        /*!< (@ 0x000001E0) A/D External Reference Voltage Monitor Register            */

        struct
        {
            __IOM uint8_t PGAMON : 3;  /*!< [2..0] PGA Monitor Output Enable                                          */
            uint8_t              : 1;
            __IOM uint8_t MONSEL : 4;  /*!< [7..4] Monitor output selection bit.                                      */
        } ADREFMON_b;
    };
    __IM uint8_t  RESERVED24;
    __IM uint16_t RESERVED25;
} R_ADC0_Type;                         /*!< Size = 484 (0x1e4)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PSCU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Peripheral Security Control Unit (R_PSCU)
 */

typedef struct                         /*!< (@ 0x400E0000) R_PSCU Structure                                           */
{
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t PSARB;          /*!< (@ 0x00000004) Peripheral Security Attribution Register B                 */

        struct
        {
            uint32_t               : 1;
            __IOM uint32_t PSARB1  : 1; /*!< [1..1] CAN1 and the MSTPCRB.MSTPB1 bit security attribution               */
            __IOM uint32_t PSARB2  : 1; /*!< [2..2] CAN0 and the MSTPCRB.MSTPB2 bit security attribution               */
            __IOM uint32_t PSARB3  : 1; /*!< [3..3] CEC and the MSTPCRB.MSTPB3 bit security attribution                */
            uint32_t               : 2;
            __IM uint32_t  PSARB6  : 1; /*!< [6..6] QSPI and the MSTPCRB.MSTPB6 bit security attribution               */
            __IOM uint32_t PSARB7  : 1; /*!< [7..7] IIC2 and the MSTPCRB.MSTPB7 bit security attribution               */
            __IOM uint32_t PSARB8  : 1; /*!< [8..8] IIC1 and the MSTPCRB.MSTPB8 bit security attribution               */
            __IOM uint32_t PSARB9  : 1; /*!< [9..9] IIC0 and the MSTPCRB.MSTPB9 bit security attribution               */
            uint32_t               : 1;
            __IOM uint32_t PSARB11 : 1; /*!< [11..11] USBFS and the MSTPCRB.MSTPB11 bit security attribution           */
            __IOM uint32_t PSARB12 : 1; /*!< [12..12] USBHS and the MSTPCRB.MSTPB12 bit security attribution           */
            uint32_t               : 2;
            __IM uint32_t PSARB15  : 1; /*!< [15..15] ETHER0/EDMAC0, the MSTPCRB.MSTPB15 bit and the PFENET.PHYMODE0
                                         *   bit security attribution                                                  */
            __IM uint32_t PSARB16  : 1; /*!< [16..16] OSPI and the MSTPCRB.MSTPB16 bit security attribution            */
            uint32_t               : 1;
            __IOM uint32_t PSARB18 : 1; /*!< [18..18] RSPI1 and the MSTPCRB.MSTPB18 bit security attribution           */
            __IOM uint32_t PSARB19 : 1; /*!< [19..19] RSPI0 and the MSTPCRB.MSTPB19 bit security attribution           */
            uint32_t               : 2;
            __IOM uint32_t PSARB22 : 1; /*!< [22..22] SCI9 and the MSTPCRB.MSTPB22 bit security attribution            */
            __IOM uint32_t PSARB23 : 1; /*!< [23..23] SCI8 and the MSTPCRB.MSTPB23 bit security attribution            */
            __IOM uint32_t PSARB24 : 1; /*!< [24..24] SCI7 and the MSTPCRB.MSTPB24 bit security attribution            */
            __IOM uint32_t PSARB25 : 1; /*!< [25..25] SCI6 and the MSTPCRB.MSTPB25 bit security attribution            */
            __IOM uint32_t PSARB26 : 1; /*!< [26..26] SCI5 and the MSTPCRB.MSTPB26 bit security attribution            */
            __IOM uint32_t PSARB27 : 1; /*!< [27..27] SCI4 and the MSTPCRB.MSTPB27 bit security attribution            */
            __IOM uint32_t PSARB28 : 1; /*!< [28..28] SCI3 and the MSTPCRB.MSTPB28 bit security attribution            */
            __IOM uint32_t PSARB29 : 1; /*!< [29..29] SCI2 and the MSTPCRB.MSTPB29 bit security attribution            */
            __IOM uint32_t PSARB30 : 1; /*!< [30..30] SCI1 and the MSTPCRB.MSTPB30 bit security attribution            */
            __IOM uint32_t PSARB31 : 1; /*!< [31..31] SCI0 and the MSTPCRB.MSTPB31 bit security attribution            */
        } PSARB_b;
    };

    union
    {
        __IOM uint32_t PSARC;           /*!< (@ 0x00000008) Peripheral Security Attribution Register C                 */

        struct
        {
            __IOM uint32_t PSARC0  : 1; /*!< [0..0] CAC and the MSTPCRC.MSTPC0 bit security attribution                */
            __IOM uint32_t PSARC1  : 1; /*!< [1..1] CRC and the MSTPCRC.MSTPC1 bit security attribution                */
            uint32_t               : 1;
            __IOM uint32_t PSARC3  : 1; /*!< [3..3] CTSU and the MSTPCRC.MSTPC3 bit security attribution               */
            uint32_t               : 4;
            __IOM uint32_t PSARC8  : 1; /*!< [8..8] SSIE0 and the MSTPCRC.MSTPC8 bit security attribution              */
            uint32_t               : 3;
            __IOM uint32_t PSARC12 : 1; /*!< [12..12] SDHI0 and the MSTPCRC.MSTPC12 bit security attribution           */
            __IOM uint32_t PSARC13 : 1; /*!< [13..13] DOC and the MSTPCRC.MSTPC13 bit security attribution             */
            uint32_t               : 12;
            __IOM uint32_t PSARC26 : 1; /*!< [26..26] CANFD1 and the MSTPCRC.MSTPC26 bit security attribution          */
            __IOM uint32_t PSARC27 : 1; /*!< [27..27] CANFD0 and the MSTPCRC.MSTPC27 bit security attribution          */
            uint32_t               : 3;
            __IOM uint32_t PSARC31 : 1; /*!< [31..31] TSIP and the MSTPCRC.MSTPC31 bit security attribution            */
        } PSARC_b;
    };

    union
    {
        __IOM uint32_t PSARD;           /*!< (@ 0x0000000C) Peripheral Security Attribution Register D                 */

        struct
        {
            __IOM uint32_t PSARD0  : 1; /*!< [0..0] AGT3 and the MSTPCRD.MSTPD0 bit security attribution               */
            __IOM uint32_t PSARD1  : 1; /*!< [1..1] AGT2 and the MSTPCRD.MSTPD1 bit security attribution               */
            __IOM uint32_t PSARD2  : 1; /*!< [2..2] AGT1 and the MSTPCRD.MSTPD2 bit security attribution               */
            __IOM uint32_t PSARD3  : 1; /*!< [3..3] AGT0 and the MSTPCRD.MSTPD3 bit security attribution               */
            uint32_t               : 7;
            __IOM uint32_t PSARD11 : 1; /*!< [11..11] PGI3 and the MSTPCRD.MSTPD11 bit security attribution            */
            __IOM uint32_t PSARD12 : 1; /*!< [12..12] PGI2 and the MSTPCRD.MSTPD12 bit security attribution            */
            __IOM uint32_t PSARD13 : 1; /*!< [13..13] PGI1 and the MSTPCRD.MSTPD13 bit security attribution            */
            __IOM uint32_t PSARD14 : 1; /*!< [14..14] PGI0 and the MSTPCRD.MSTPD14 bit security attribution            */
            __IOM uint32_t PSARD15 : 1; /*!< [15..15] ADC1 and the MSTPCRD.MSTPD15 bit security attribution            */
            __IOM uint32_t PSARD16 : 1; /*!< [16..16] ADC0 and the MSTPCRD.MSTPD16 bit security attribution            */
            uint32_t               : 3;
            __IOM uint32_t PSARD20 : 1; /*!< [20..20] DAC12 and the MSTPCRD.MSTPD20 bit security attribution           */
            uint32_t               : 1;
            __IOM uint32_t PSARD22 : 1; /*!< [22..22] TSN and the MSTPCRD.MSTPD22 bit security attribution             */
            uint32_t               : 9;
        } PSARD_b;
    };

    union
    {
        __IOM uint32_t PSARE;           /*!< (@ 0x00000010) Peripheral Security Attribution Register E                 */

        struct
        {
            __IOM uint32_t PSARE0  : 1; /*!< [0..0] WDT security attribution                                           */
            __IOM uint32_t PSARE1  : 1; /*!< [1..1] IWDT security attribution                                          */
            __IOM uint32_t PSARE2  : 1; /*!< [2..2] RTC security attribution                                           */
            uint32_t               : 11;
            __IOM uint32_t PSARE14 : 1; /*!< [14..14] AGT5 and the MSTPCRE.MSTPE14 bit security attribution            */
            __IOM uint32_t PSARE15 : 1; /*!< [15..15] AGT4 and the MSTPCRE.MSTPE15 bit security attribution            */
            uint32_t               : 6;
            __IOM uint32_t PSARE22 : 1; /*!< [22..22] GPT9 and the MSTPCRE.MSTPE22 bit security attribution            */
            __IOM uint32_t PSARE23 : 1; /*!< [23..23] GPT8 and the MSTPCRE.MSTPE23 bit security attribution            */
            __IOM uint32_t PSARE24 : 1; /*!< [24..24] GPT7 and the MSTPCRE.MSTPE24 bit security attribution            */
            __IOM uint32_t PSARE25 : 1; /*!< [25..25] GPT6 and the MSTPCRE.MSTPE25 bit security attribution            */
            __IOM uint32_t PSARE26 : 1; /*!< [26..26] GPT5 and the MSTPCRE.MSTPE26 bit security attribution            */
            __IOM uint32_t PSARE27 : 1; /*!< [27..27] GPT4 and the MSTPCRE.MSTPE27 bit security attribution            */
            __IOM uint32_t PSARE28 : 1; /*!< [28..28] GPT3 and the MSTPCRE.MSTPE28 bit security attribution            */
            __IOM uint32_t PSARE29 : 1; /*!< [29..29] GPT2 and the MSTPCRE.MSTPE29 bit security attribution            */
            __IOM uint32_t PSARE30 : 1; /*!< [30..30] GPT1 and the MSTPCRE.MSTPE30 bit security attribution            */
            __IOM uint32_t PSARE31 : 1; /*!< [31..31] GPT0 and the MSTPCRE.MSTPE31 bit security attribution            */
        } PSARE_b;
    };

    union
    {
        __IOM uint32_t MSSAR;          /*!< (@ 0x00000014) Module Stop Security Attribution Register                  */

        struct
        {
            __IOM uint32_t MSSAR0 : 1; /*!< [0..0] The MSTPCRC.MSTPC14 bit security attribution                       */
            __IOM uint32_t MSSAR1 : 1; /*!< [1..1] The MSTPCRA.MSTPA22 bit security attribution                       */
            __IOM uint32_t MSSAR2 : 1; /*!< [2..2] The MSTPCRA.MSTPA7 bit security attribution                        */
            __IOM uint32_t MSSAR3 : 1; /*!< [3..3] The MSTPCRA.MSTPA0 bit security attribution                        */
            uint32_t              : 28;
        } MSSAR_b;
    };

    union
    {
        __IM uint32_t CFSAMONA;        /*!< (@ 0x00000018) Code Flash Security Attribution Monitor Register
                                        *                  A                                                          */

        struct
        {
            uint32_t           : 15;
            __IM uint32_t CFS1 : 9;    /*!< [23..15] Code Flash Secure area 1                                         */
            uint32_t           : 8;
        } CFSAMONA_b;
    };

    union
    {
        __IM uint32_t CFSAMONB;        /*!< (@ 0x0000001C) Code Flash Security Attribution Monitor Register
                                        *                  B                                                          */

        struct
        {
            uint32_t           : 10;
            __IM uint32_t CFS2 : 14;   /*!< [23..10] Code Flash Secure area 2                                         */
            uint32_t           : 8;
        } CFSAMONB_b;
    };

    union
    {
        __IM uint32_t DFSAMON;         /*!< (@ 0x00000020) Data Flash Security Attribution Monitor Register           */

        struct
        {
            uint32_t          : 10;
            __IM uint32_t DFS : 6;     /*!< [15..10] Data flash Secure area                                           */
            uint32_t          : 16;
        } DFSAMON_b;
    };

    union
    {
        __IM uint32_t SSAMONA;         /*!< (@ 0x00000024) SRAM Security Attribution Monitor Register A               */

        struct
        {
            uint32_t          : 13;
            __IM uint32_t SS1 : 8;     /*!< [20..13] SRAM Secure area 1                                               */
            uint32_t          : 11;
        } SSAMONA_b;
    };

    union
    {
        __IM uint32_t SSAMONB;         /*!< (@ 0x00000028) SRAM Security Attribution Monitor Register B               */

        struct
        {
            uint32_t          : 10;
            __IM uint32_t SS2 : 11;    /*!< [20..10] SRAM secure area 2                                               */
            uint32_t          : 11;
        } SSAMONB_b;
    };

    union
    {
        __IM uint32_t DLMMON;          /*!< (@ 0x0000002C) Device Lifecycle Management State Monitor Register         */

        struct
        {
            __IM uint32_t DLMMON : 4;  /*!< [3..0] Device Lifecycle Management State Monitor                          */
            uint32_t             : 28;
        } DLMMON_b;
    };
} R_PSCU_Type;                         /*!< Size = 48 (0x30)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_AGT0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Asynchronous General Purpose Timer (R_AGT0)
 */

typedef struct                         /*!< (@ 0x40084000) R_AGT0 Structure                                           */
{
    union
    {
        __IOM uint16_t AGT;            /*!< (@ 0x00000000) AGT Counter Register                                       */

        struct
        {
            __IOM uint16_t AGT : 16;   /*!< [15..0] 16bit counter and reload registerNOTE : When 1 is written
                                        *   to the TSTOP bit in the AGTCRn register, the 16-bit counter
                                        *   is forcibly stopped and set to FFFFH.                                     */
        } AGT_b;
    };

    union
    {
        __IOM uint16_t AGTCMA;          /*!< (@ 0x00000002) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint16_t AGTCMA : 16; /*!< [15..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint16_t AGTCMB;          /*!< (@ 0x00000004) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint16_t AGTCMB : 16; /*!< [15..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint8_t AGTCR;           /*!< (@ 0x00000008) AGT Control Register                                       */

        struct
        {
            __IOM uint8_t TSTART : 1;  /*!< [0..0] AGT count start                                                    */
            __IM uint8_t  TCSTF  : 1;  /*!< [1..1] AGT count status flag                                              */
            __OM uint8_t  TSTOP  : 1;  /*!< [2..2] AGT count forced stop                                              */
            uint8_t              : 1;
            __IOM uint8_t TEDGF  : 1;  /*!< [4..4] Active edge judgment flag                                          */
            __IOM uint8_t TUNDF  : 1;  /*!< [5..5] Underflow flag                                                     */
            __IOM uint8_t TCMAF  : 1;  /*!< [6..6] Compare match A flag                                               */
            __IOM uint8_t TCMBF  : 1;  /*!< [7..7] Compare match B flag                                               */
        } AGTCR_b;
    };

    union
    {
        __IOM uint8_t AGTMR1;          /*!< (@ 0x00000009) AGT Mode Register 1                                        */

        struct
        {
            __IOM uint8_t TMOD   : 3;  /*!< [2..0] Operating mode                                                     */
            __IOM uint8_t TEDGPL : 1;  /*!< [3..3] Edge polarity                                                      */
            __IOM uint8_t TCK    : 3;  /*!< [6..4] Count source                                                       */
            uint8_t              : 1;
        } AGTMR1_b;
    };

    union
    {
        __IOM uint8_t AGTMR2;          /*!< (@ 0x0000000A) AGT Mode Register 2                                        */

        struct
        {
            __IOM uint8_t CKS : 3;     /*!< [2..0] AGTLCLK/AGTSCLK count source clock frequency division
                                        *   ratio                                                                     */
            uint8_t           : 4;
            __IOM uint8_t LPM : 1;     /*!< [7..7] Low Power Mode                                                     */
        } AGTMR2_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t AGTIOC;          /*!< (@ 0x0000000C) AGT I/O Control Register                                   */

        struct
        {
            __IOM uint8_t TEDGSEL : 1; /*!< [0..0] I/O polarity switchFunction varies depending on the operating
                                        *   mode.                                                                     */
            uint8_t             : 1;
            __IOM uint8_t TOE   : 1;   /*!< [2..2] AGTOn output enable                                                */
            uint8_t             : 1;
            __IOM uint8_t TIPF  : 2;   /*!< [5..4] Input filter                                                       */
            __IOM uint8_t TIOGT : 2;   /*!< [7..6] Count control                                                      */
        } AGTIOC_b;
    };

    union
    {
        __IOM uint8_t AGTISR;          /*!< (@ 0x0000000D) AGT Event Pin Select Register                              */

        struct
        {
            uint8_t            : 2;
            __IOM uint8_t EEPS : 1;    /*!< [2..2] AGTEE polarty selection                                            */
            uint8_t            : 5;
        } AGTISR_b;
    };

    union
    {
        __IOM uint8_t AGTCMSR;         /*!< (@ 0x0000000E) AGT Compare Match Function Select Register                 */

        struct
        {
            __IOM uint8_t TCMEA  : 1;  /*!< [0..0] Compare match A register enable                                    */
            __IOM uint8_t TOEA   : 1;  /*!< [1..1] AGTOA output enable                                                */
            __IOM uint8_t TOPOLA : 1;  /*!< [2..2] AGTOA polarity select                                              */
            uint8_t              : 1;
            __IOM uint8_t TCMEB  : 1;  /*!< [4..4] Compare match B register enable                                    */
            __IOM uint8_t TOEB   : 1;  /*!< [5..5] AGTOB output enable                                                */
            __IOM uint8_t TOPOLB : 1;  /*!< [6..6] AGTOB polarity select                                              */
            uint8_t              : 1;
        } AGTCMSR_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL;        /*!< (@ 0x0000000F) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_b;
    };
} R_AGT0_Type;                         /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Interface (R_BUS)
 */

typedef struct                          /*!< (@ 0x40003000) R_BUS Structure                                            */
{
    __IOM R_BUS_CSa_Type CSa[8];        /*!< (@ 0x00000000) CS Registers                                               */
    __IM uint32_t        RESERVED[480];
    __IOM R_BUS_CSb_Type CSb[8];        /*!< (@ 0x00000800) CS Registers                                               */

    union
    {
        __IOM uint16_t CSRECEN;         /*!< (@ 0x00000880) CS Recovery Cycle Insertion Enable Register                */

        struct
        {
            __IOM uint16_t RCVEN0  : 1; /*!< [0..0] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN1  : 1; /*!< [1..1] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN2  : 1; /*!< [2..2] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN3  : 1; /*!< [3..3] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN4  : 1; /*!< [4..4] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN5  : 1; /*!< [5..5] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN6  : 1; /*!< [6..6] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN7  : 1; /*!< [7..7] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVENM0 : 1; /*!< [8..8] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM1 : 1; /*!< [9..9] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM2 : 1; /*!< [10..10] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM3 : 1; /*!< [11..11] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM4 : 1; /*!< [12..12] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM5 : 1; /*!< [13..13] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM6 : 1; /*!< [14..14] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM7 : 1; /*!< [15..15] Multiplexed Bus Recovery Cycle Insertion Enable                  */
        } CSRECEN_b;
    };
    __IM uint16_t           RESERVED1;
    __IM uint32_t           RESERVED2[223];
    __IOM R_BUS_SDRAM_Type  SDRAM;      /*!< (@ 0x00000C00) SDRAM Registers                                            */
    __IM uint32_t           RESERVED3[235];
    __IOM R_BUS_BUSM_Type   BUSM[6];    /*!< (@ 0x00001000) Master Bus Control Register Array                          */
    __IM uint32_t           RESERVED4[58];
    __IOM R_BUS_BUSS_Type   BUSS[16];   /*!< (@ 0x00001100) Slave Bus Control Register Array                           */
    __IM uint32_t           RESERVED5[432];
    __IOM R_BUS_BUSERR_Type BUSERR[11]; /*!< (@ 0x00001800) Bus Error Registers                                        */
} R_BUS_Type;                           /*!< Size = 6320 (0x18b0)                                                      */

/* =========================================================================================================================== */
/* ================                                           R_CAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Clock Frequency Accuracy Measurement Circuit (R_CAC)
 */

typedef struct                         /*!< (@ 0x40044600) R_CAC Structure                                            */
{
    union
    {
        __IOM uint8_t CACR0;           /*!< (@ 0x00000000) CAC Control Register 0                                     */

        struct
        {
            __IOM uint8_t CFME : 1;    /*!< [0..0] Clock Frequency Measurement Enable.                                */
            uint8_t            : 7;
        } CACR0_b;
    };

    union
    {
        __IOM uint8_t CACR1;           /*!< (@ 0x00000001) CAC Control Register 1                                     */

        struct
        {
            __IOM uint8_t CACREFE : 1; /*!< [0..0] CACREF Pin Input Enable                                            */
            __IOM uint8_t FMCS    : 3; /*!< [3..1] Measurement Target Clock Select                                    */
            __IOM uint8_t TCSS    : 2; /*!< [5..4] Measurement Target Clock Frequency Division Ratio Select           */
            __IOM uint8_t EDGES   : 2; /*!< [7..6] Valid Edge Select                                                  */
        } CACR1_b;
    };

    union
    {
        __IOM uint8_t CACR2;           /*!< (@ 0x00000002) CAC Control Register 2                                     */

        struct
        {
            __IOM uint8_t RPS  : 1;    /*!< [0..0] Reference Signal Select                                            */
            __IOM uint8_t RSCS : 3;    /*!< [3..1] Measurement Reference Clock Select                                 */
            __IOM uint8_t RCDS : 2;    /*!< [5..4] Measurement Reference Clock Frequency Division Ratio
                                        *   Select                                                                    */
            __IOM uint8_t DFS : 2;     /*!< [7..6] Digital Filter Selection                                           */
        } CACR2_b;
    };

    union
    {
        __IOM uint8_t CAICR;           /*!< (@ 0x00000003) CAC Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t FERRIE : 1;  /*!< [0..0] Frequency Error Interrupt Request Enable                           */
            __IOM uint8_t MENDIE : 1;  /*!< [1..1] Measurement End Interrupt Request Enable                           */
            __IOM uint8_t OVFIE  : 1;  /*!< [2..2] Overflow Interrupt Request Enable                                  */
            uint8_t              : 1;
            __OM uint8_t FERRFCL : 1;  /*!< [4..4] FERRF Clear                                                        */
            __OM uint8_t MENDFCL : 1;  /*!< [5..5] MENDF Clear                                                        */
            __OM uint8_t OVFFCL  : 1;  /*!< [6..6] OVFF Clear                                                         */
            uint8_t              : 1;
        } CAICR_b;
    };

    union
    {
        __IM uint8_t CASTR;            /*!< (@ 0x00000004) CAC Status Register                                        */

        struct
        {
            __IM uint8_t FERRF : 1;    /*!< [0..0] Frequency Error Flag                                               */
            __IM uint8_t MENDF : 1;    /*!< [1..1] Measurement End Flag                                               */
            __IM uint8_t OVFF  : 1;    /*!< [2..2] Counter Overflow Flag                                              */
            uint8_t            : 5;
        } CASTR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t CAULVR;          /*!< (@ 0x00000006) CAC Upper-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CAULVR : 16; /*!< [15..0] CAULVR is a 16-bit readable/writable register that stores
                                         *   the upper-limit value of the frequency.                                   */
        } CAULVR_b;
    };

    union
    {
        __IOM uint16_t CALLVR;          /*!< (@ 0x00000008) CAC Lower-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CALLVR : 16; /*!< [15..0] CALLVR is a 16-bit readable/writable register that stores
                                         *   the lower-limit value of the frequency.                                   */
        } CALLVR_b;
    };

    union
    {
        __IM uint16_t CACNTBR;          /*!< (@ 0x0000000A) CAC Counter Buffer Register                                */

        struct
        {
            __IM uint16_t CACNTBR : 16; /*!< [15..0] CACNTBR is a 16-bit read-only register that retains
                                         *   the counter value at the time a valid reference signal
                                         *   edge is input                                                             */
        } CACNTBR_b;
    };
} R_CAC_Type;                           /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                          R_CAN0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Controller Area Network (CAN) Module (R_CAN0)
 */

typedef struct                         /*!< (@ 0x40050000) R_CAN0 Structure                                           */
{
    __IM uint32_t        RESERVED[128];
    __IOM R_CAN0_MB_Type MB[32];       /*!< (@ 0x00000200) Mailbox                                                    */

    union
    {
        __IOM uint32_t MKR[8];         /*!< (@ 0x00000400) Mask Register                                              */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 3;
        } MKR_b[8];
    };

    union
    {
        __IOM uint32_t FIDCR[2];       /*!< (@ 0x00000420) FIFO Received ID Compare Registers                         */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 1;
            __IOM uint32_t RTR : 1;    /*!< [30..30] Remote Transmission Request                                      */
            __IOM uint32_t IDE : 1;    /*!< [31..31] ID Extension                                                     */
        } FIDCR_b[2];
    };

    union
    {
        __IOM uint32_t MKIVLR;         /*!< (@ 0x00000428) Mask Invalid Register                                      */

        struct
        {
            __IOM uint32_t MB0  : 1;   /*!< [0..0] mailbox 0 Mask Invalid                                             */
            __IOM uint32_t MB1  : 1;   /*!< [1..1] mailbox 1 Mask Invalid                                             */
            __IOM uint32_t MB2  : 1;   /*!< [2..2] mailbox 2 Mask Invalid                                             */
            __IOM uint32_t MB3  : 1;   /*!< [3..3] mailbox 3 Mask Invalid                                             */
            __IOM uint32_t MB4  : 1;   /*!< [4..4] mailbox 4 Mask Invalid                                             */
            __IOM uint32_t MB5  : 1;   /*!< [5..5] mailbox 5 Mask Invalid                                             */
            __IOM uint32_t MB6  : 1;   /*!< [6..6] mailbox 6 Mask Invalid                                             */
            __IOM uint32_t MB7  : 1;   /*!< [7..7] mailbox 7 Mask Invalid                                             */
            __IOM uint32_t MB8  : 1;   /*!< [8..8] mailbox 8 Mask Invalid                                             */
            __IOM uint32_t MB9  : 1;   /*!< [9..9] mailbox 9 Mask Invalid                                             */
            __IOM uint32_t MB10 : 1;   /*!< [10..10] mailbox 10 Mask Invalid                                          */
            __IOM uint32_t MB11 : 1;   /*!< [11..11] mailbox 11 Mask Invalid                                          */
            __IOM uint32_t MB12 : 1;   /*!< [12..12] mailbox 12 Mask Invalid                                          */
            __IOM uint32_t MB13 : 1;   /*!< [13..13] mailbox 13 Mask Invalid                                          */
            __IOM uint32_t MB14 : 1;   /*!< [14..14] mailbox 14 Mask Invalid                                          */
            __IOM uint32_t MB15 : 1;   /*!< [15..15] mailbox 15 Mask Invalid                                          */
            __IOM uint32_t MB16 : 1;   /*!< [16..16] mailbox 16 Mask Invalid                                          */
            __IOM uint32_t MB17 : 1;   /*!< [17..17] mailbox 17 Mask Invalid                                          */
            __IOM uint32_t MB18 : 1;   /*!< [18..18] mailbox 18 Mask Invalid                                          */
            __IOM uint32_t MB19 : 1;   /*!< [19..19] mailbox 19 Mask Invalid                                          */
            __IOM uint32_t MB20 : 1;   /*!< [20..20] mailbox 20 Mask Invalid                                          */
            __IOM uint32_t MB21 : 1;   /*!< [21..21] mailbox 21 Mask Invalid                                          */
            __IOM uint32_t MB22 : 1;   /*!< [22..22] mailbox 22 Mask Invalid                                          */
            __IOM uint32_t MB23 : 1;   /*!< [23..23] mailbox 23 Mask Invalid                                          */
            __IOM uint32_t MB24 : 1;   /*!< [24..24] mailbox 24 Mask Invalid                                          */
            __IOM uint32_t MB25 : 1;   /*!< [25..25] mailbox 25 Mask Invalid                                          */
            __IOM uint32_t MB26 : 1;   /*!< [26..26] mailbox 26 Mask Invalid                                          */
            __IOM uint32_t MB27 : 1;   /*!< [27..27] mailbox 27 Mask Invalid                                          */
            __IOM uint32_t MB28 : 1;   /*!< [28..28] mailbox 28 Mask Invalid                                          */
            __IOM uint32_t MB29 : 1;   /*!< [29..29] mailbox 29 Mask Invalid                                          */
            __IOM uint32_t MB30 : 1;   /*!< [30..30] mailbox 30 Mask Invalid                                          */
            __IOM uint32_t MB31 : 1;   /*!< [31..31] mailbox 31 Mask Invalid                                          */
        } MKIVLR_b;
    };

    union
    {
        union
        {
            __IOM uint32_t MIER;         /*!< (@ 0x0000042C) Mailbox Interrupt Enable Register                          */

            struct
            {
                __IOM uint32_t MB0  : 1; /*!< [0..0] mailbox 0 Interrupt Enable                                         */
                __IOM uint32_t MB1  : 1; /*!< [1..1] mailbox 1 Interrupt Enable                                         */
                __IOM uint32_t MB2  : 1; /*!< [2..2] mailbox 2 Interrupt Enable                                         */
                __IOM uint32_t MB3  : 1; /*!< [3..3] mailbox 3 Interrupt Enable                                         */
                __IOM uint32_t MB4  : 1; /*!< [4..4] mailbox 4 Interrupt Enable                                         */
                __IOM uint32_t MB5  : 1; /*!< [5..5] mailbox 5 Interrupt Enable                                         */
                __IOM uint32_t MB6  : 1; /*!< [6..6] mailbox 6 Interrupt Enable                                         */
                __IOM uint32_t MB7  : 1; /*!< [7..7] mailbox 7 Interrupt Enable                                         */
                __IOM uint32_t MB8  : 1; /*!< [8..8] mailbox 8 Interrupt Enable                                         */
                __IOM uint32_t MB9  : 1; /*!< [9..9] mailbox 9 Interrupt Enable                                         */
                __IOM uint32_t MB10 : 1; /*!< [10..10] mailbox 10 Interrupt Enable                                      */
                __IOM uint32_t MB11 : 1; /*!< [11..11] mailbox 11 Interrupt Enable                                      */
                __IOM uint32_t MB12 : 1; /*!< [12..12] mailbox 12 Interrupt Enable                                      */
                __IOM uint32_t MB13 : 1; /*!< [13..13] mailbox 13 Interrupt Enable                                      */
                __IOM uint32_t MB14 : 1; /*!< [14..14] mailbox 14 Interrupt Enable                                      */
                __IOM uint32_t MB15 : 1; /*!< [15..15] mailbox 15 Interrupt Enable                                      */
                __IOM uint32_t MB16 : 1; /*!< [16..16] mailbox 16 Interrupt Enable                                      */
                __IOM uint32_t MB17 : 1; /*!< [17..17] mailbox 17 Interrupt Enable                                      */
                __IOM uint32_t MB18 : 1; /*!< [18..18] mailbox 18 Interrupt Enable                                      */
                __IOM uint32_t MB19 : 1; /*!< [19..19] mailbox 19 Interrupt Enable                                      */
                __IOM uint32_t MB20 : 1; /*!< [20..20] mailbox 20 Interrupt Enable                                      */
                __IOM uint32_t MB21 : 1; /*!< [21..21] mailbox 21 Interrupt Enable                                      */
                __IOM uint32_t MB22 : 1; /*!< [22..22] mailbox 22 Interrupt Enable                                      */
                __IOM uint32_t MB23 : 1; /*!< [23..23] mailbox 23 Interrupt Enable                                      */
                __IOM uint32_t MB24 : 1; /*!< [24..24] mailbox 24 Interrupt Enable                                      */
                __IOM uint32_t MB25 : 1; /*!< [25..25] mailbox 25 Interrupt Enable                                      */
                __IOM uint32_t MB26 : 1; /*!< [26..26] mailbox 26 Interrupt Enable                                      */
                __IOM uint32_t MB27 : 1; /*!< [27..27] mailbox 27 Interrupt Enable                                      */
                __IOM uint32_t MB28 : 1; /*!< [28..28] mailbox 28 Interrupt Enable                                      */
                __IOM uint32_t MB29 : 1; /*!< [29..29] mailbox 29 Interrupt Enable                                      */
                __IOM uint32_t MB30 : 1; /*!< [30..30] mailbox 30 Interrupt Enable                                      */
                __IOM uint32_t MB31 : 1; /*!< [31..31] mailbox 31 Interrupt Enable                                      */
            } MIER_b;
        };

        union
        {
            __IOM uint32_t MIER_FIFO;    /*!< (@ 0x0000042C) Mailbox Interrupt Enable Register for FIFO Mailbox
                                          *                  Mode                                                       */

            struct
            {
                __IOM uint32_t MB0  : 1; /*!< [0..0] mailbox 0 Interrupt Enable                                         */
                __IOM uint32_t MB1  : 1; /*!< [1..1] mailbox 1 Interrupt Enable                                         */
                __IOM uint32_t MB2  : 1; /*!< [2..2] mailbox 2 Interrupt Enable                                         */
                __IOM uint32_t MB3  : 1; /*!< [3..3] mailbox 3 Interrupt Enable                                         */
                __IOM uint32_t MB4  : 1; /*!< [4..4] mailbox 4 Interrupt Enable                                         */
                __IOM uint32_t MB5  : 1; /*!< [5..5] mailbox 5 Interrupt Enable                                         */
                __IOM uint32_t MB6  : 1; /*!< [6..6] mailbox 6 Interrupt Enable                                         */
                __IOM uint32_t MB7  : 1; /*!< [7..7] mailbox 7 Interrupt Enable                                         */
                __IOM uint32_t MB8  : 1; /*!< [8..8] mailbox 8 Interrupt Enable                                         */
                __IOM uint32_t MB9  : 1; /*!< [9..9] mailbox 9 Interrupt Enable                                         */
                __IOM uint32_t MB10 : 1; /*!< [10..10] mailbox 10 Interrupt Enable                                      */
                __IOM uint32_t MB11 : 1; /*!< [11..11] mailbox 11 Interrupt Enable                                      */
                __IOM uint32_t MB12 : 1; /*!< [12..12] mailbox 12 Interrupt Enable                                      */
                __IOM uint32_t MB13 : 1; /*!< [13..13] mailbox 13 Interrupt Enable                                      */
                __IOM uint32_t MB14 : 1; /*!< [14..14] mailbox 14 Interrupt Enable                                      */
                __IOM uint32_t MB15 : 1; /*!< [15..15] mailbox 15 Interrupt Enable                                      */
                __IOM uint32_t MB16 : 1; /*!< [16..16] mailbox 16 Interrupt Enable                                      */
                __IOM uint32_t MB17 : 1; /*!< [17..17] mailbox 17 Interrupt Enable                                      */
                __IOM uint32_t MB18 : 1; /*!< [18..18] mailbox 18 Interrupt Enable                                      */
                __IOM uint32_t MB19 : 1; /*!< [19..19] mailbox 19 Interrupt Enable                                      */
                __IOM uint32_t MB20 : 1; /*!< [20..20] mailbox 20 Interrupt Enable                                      */
                __IOM uint32_t MB21 : 1; /*!< [21..21] mailbox 21 Interrupt Enable                                      */
                __IOM uint32_t MB22 : 1; /*!< [22..22] mailbox 22 Interrupt Enable                                      */
                __IOM uint32_t MB23 : 1; /*!< [23..23] mailbox 23 Interrupt Enable                                      */
                __IOM uint32_t MB24 : 1; /*!< [24..24] Transmit FIFO Interrupt Enable                                   */
                __IOM uint32_t MB25 : 1; /*!< [25..25] Transmit FIFO Interrupt Generation Timing Control                */
                uint32_t            : 2;
                __IOM uint32_t MB28 : 1; /*!< [28..28] Receive FIFO Interrupt Enable                                    */
                __IOM uint32_t MB29 : 1; /*!< [29..29] Receive FIFO Interrupt Generation Timing Control                 */
                uint32_t            : 2;
            } MIER_FIFO_b;
        };
    };
    __IM uint32_t RESERVED1[252];

    union
    {
        union
        {
            __IOM uint8_t MCTL_TX[32];       /*!< (@ 0x00000820) Message Control Register for Transmit                      */

            struct
            {
                __IOM uint8_t SENTDATA  : 1; /*!< [0..0] Transmission Complete Flag                                         */
                __IM uint8_t  TRMACTIVE : 1; /*!< [1..1] Transmission-in-Progress Status Flag (Transmit mailbox
                                              *   setting enabled)                                                          */
                __IOM uint8_t TRMABT : 1;    /*!< [2..2] Transmission Abort Complete Flag (Transmit mailbox setting
                                              *   enabled)                                                                  */
                uint8_t               : 1;
                __IOM uint8_t ONESHOT : 1;   /*!< [4..4] One-Shot Enable                                                    */
                uint8_t               : 1;
                __IOM uint8_t RECREQ  : 1;   /*!< [6..6] Receive Mailbox Request                                            */
                __IOM uint8_t TRMREQ  : 1;   /*!< [7..7] Transmit Mailbox Request                                           */
            } MCTL_TX_b[32];
        };

        union
        {
            __IOM uint8_t MCTL_RX[32];       /*!< (@ 0x00000820) Message Control Register for Receive                       */

            struct
            {
                __IOM uint8_t NEWDATA   : 1; /*!< [0..0] Reception Complete Flag                                            */
                __IM uint8_t  INVALDATA : 1; /*!< [1..1] Reception-in-Progress Status Flag (Receive mailbox setting
                                              *   enabled)                                                                  */
                __IOM uint8_t MSGLOST : 1;   /*!< [2..2] Message Lost Flag(Receive mailbox setting enabled)                 */
                uint8_t               : 1;
                __IOM uint8_t ONESHOT : 1;   /*!< [4..4] One-Shot Enable                                                    */
                uint8_t               : 1;
                __IOM uint8_t RECREQ  : 1;   /*!< [6..6] Receive Mailbox Request                                            */
                __IOM uint8_t TRMREQ  : 1;   /*!< [7..7] Transmit Mailbox Request                                           */
            } MCTL_RX_b[32];
        };
    };

    union
    {
        __IOM uint16_t CTLR;           /*!< (@ 0x00000840) Control Register                                           */

        struct
        {
            __IOM uint16_t MBM  : 1;   /*!< [0..0] CAN Mailbox Mode Select                                            */
            __IOM uint16_t IDFM : 2;   /*!< [2..1] ID Format Mode Select                                              */
            __IOM uint16_t MLM  : 1;   /*!< [3..3] Message Lost Mode Select                                           */
            __IOM uint16_t TPM  : 1;   /*!< [4..4] Transmission Priority Mode Select                                  */
            __IOM uint16_t TSRC : 1;   /*!< [5..5] Time Stamp Counter Reset Command                                   */
            __IOM uint16_t TSPS : 2;   /*!< [7..6] Time Stamp Prescaler Select                                        */
            __IOM uint16_t CANM : 2;   /*!< [9..8] CAN Operating Mode Select                                          */
            __IOM uint16_t SLPM : 1;   /*!< [10..10] CAN Sleep Mode                                                   */
            __IOM uint16_t BOM  : 2;   /*!< [12..11] Bus-Off Recovery Mode by a program request                       */
            __IOM uint16_t RBOC : 1;   /*!< [13..13] Forcible Return From Bus-Off                                     */
            uint16_t            : 2;
        } CTLR_b;
    };

    union
    {
        __IM uint16_t STR;             /*!< (@ 0x00000842) Status Register                                            */

        struct
        {
            __IM uint16_t NDST  : 1;   /*!< [0..0] NEWDATA Status Flag                                                */
            __IM uint16_t SDST  : 1;   /*!< [1..1] SENTDATA Status Flag                                               */
            __IM uint16_t RFST  : 1;   /*!< [2..2] Receive FIFO Status Flag                                           */
            __IM uint16_t TFST  : 1;   /*!< [3..3] Transmit FIFO Status Flag                                          */
            __IM uint16_t NMLST : 1;   /*!< [4..4] Normal Mailbox Message Lost Status Flag                            */
            __IM uint16_t FMLST : 1;   /*!< [5..5] FIFO Mailbox Message Lost Status Flag                              */
            __IM uint16_t TABST : 1;   /*!< [6..6] Transmission Abort Status Flag                                     */
            __IM uint16_t EST   : 1;   /*!< [7..7] Error Status Flag                                                  */
            __IM uint16_t RSTST : 1;   /*!< [8..8] CAN Reset Status Flag                                              */
            __IM uint16_t HLTST : 1;   /*!< [9..9] CAN Halt Status Flag                                               */
            __IM uint16_t SLPST : 1;   /*!< [10..10] CAN Sleep Status Flag                                            */
            __IM uint16_t EPST  : 1;   /*!< [11..11] Error-Passive Status Flag                                        */
            __IM uint16_t BOST  : 1;   /*!< [12..12] Bus-Off Status Flag                                              */
            __IM uint16_t TRMST : 1;   /*!< [13..13] Transmit Status Flag (transmitter)                               */
            __IM uint16_t RECST : 1;   /*!< [14..14] Receive Status Flag (receiver)                                   */
            uint16_t            : 1;
        } STR_b;
    };

    union
    {
        __IOM uint32_t BCR;            /*!< (@ 0x00000844) Bit Configuration Register                                 */

        struct
        {
            __IOM uint32_t CCLKS : 1;  /*!< [0..0] CAN Clock Source Selection                                         */
            uint32_t             : 7;
            __IOM uint32_t TSEG2 : 3;  /*!< [10..8] Time Segment 2 Control                                            */
            uint32_t             : 1;
            __IOM uint32_t SJW   : 2;  /*!< [13..12] Resynchronization Jump Width Control                             */
            uint32_t             : 2;
            __IOM uint32_t BRP   : 10; /*!< [25..16] Prescaler Division Ratio Select . These bits set the
                                        *   frequency of the CAN communication clock (fCANCLK).                       */
            uint32_t             : 2;
            __IOM uint32_t TSEG1 : 4;  /*!< [31..28] Time Segment 1 Control                                           */
        } BCR_b;
    };

    union
    {
        __IOM uint8_t RFCR;            /*!< (@ 0x00000848) Receive FIFO Control Register                              */

        struct
        {
            __IOM uint8_t RFE   : 1;   /*!< [0..0] Receive FIFO Enable                                                */
            __IM uint8_t  RFUST : 3;   /*!< [3..1] Receive FIFO Unread Message Number Status                          */
            __IOM uint8_t RFMLF : 1;   /*!< [4..4] Receive FIFO Message Lost Flag                                     */
            __IM uint8_t  RFFST : 1;   /*!< [5..5] Receive FIFO Full Status Flag                                      */
            __IM uint8_t  RFWST : 1;   /*!< [6..6] Receive FIFO Buffer Warning Status Flag                            */
            __IM uint8_t  RFEST : 1;   /*!< [7..7] Receive FIFO Empty Status Flag                                     */
        } RFCR_b;
    };

    union
    {
        __OM uint8_t RFPCR;            /*!< (@ 0x00000849) Receive FIFO Pointer Control Register                      */

        struct
        {
            __OM uint8_t RFPCR : 8;    /*!< [7..0] The CPU-side pointer for the receive FIFO is incremented
                                        *   by writing FFh to RFPCR.                                                  */
        } RFPCR_b;
    };

    union
    {
        __IOM uint8_t TFCR;            /*!< (@ 0x0000084A) Transmit FIFO Control Register                             */

        struct
        {
            __IOM uint8_t TFE   : 1;   /*!< [0..0] Transmit FIFO Enable                                               */
            __IM uint8_t  TFUST : 3;   /*!< [3..1] Transmit FIFO Unsent Message Number Status                         */
            uint8_t             : 2;
            __IM uint8_t TFFST  : 1;   /*!< [6..6] Transmit FIFO Full Status                                          */
            __IM uint8_t TFEST  : 1;   /*!< [7..7] Transmit FIFO Empty Status                                         */
        } TFCR_b;
    };

    union
    {
        __OM uint8_t TFPCR;            /*!< (@ 0x0000084B) Transmit FIFO Pointer Control Register                     */

        struct
        {
            __OM uint8_t TFPCR : 8;    /*!< [7..0] The CPU-side pointer for the transmit FIFO is incremented
                                        *   by writing FFh to TFPCR.                                                  */
        } TFPCR_b;
    };

    union
    {
        __IOM uint8_t EIER;            /*!< (@ 0x0000084C) Error Interrupt Enable Register                            */

        struct
        {
            __IOM uint8_t BEIE  : 1;   /*!< [0..0] Bus Error Interrupt Enable                                         */
            __IOM uint8_t EWIE  : 1;   /*!< [1..1] Error-Warning Interrupt Enable                                     */
            __IOM uint8_t EPIE  : 1;   /*!< [2..2] Error-Passive Interrupt Enable                                     */
            __IOM uint8_t BOEIE : 1;   /*!< [3..3] Bus-Off Entry Interrupt Enable                                     */
            __IOM uint8_t BORIE : 1;   /*!< [4..4] Bus-Off Recovery Interrupt Enable                                  */
            __IOM uint8_t ORIE  : 1;   /*!< [5..5] Overrun Interrupt Enable                                           */
            __IOM uint8_t OLIE  : 1;   /*!< [6..6] Overload Frame Transmit Interrupt Enable                           */
            __IOM uint8_t BLIE  : 1;   /*!< [7..7] Bus Lock Interrupt Enable                                          */
        } EIER_b;
    };

    union
    {
        __IOM uint8_t EIFR;            /*!< (@ 0x0000084D) Error Interrupt Factor Judge Register                      */

        struct
        {
            __IOM uint8_t BEIF  : 1;   /*!< [0..0] Bus Error Detect Flag                                              */
            __IOM uint8_t EWIF  : 1;   /*!< [1..1] Error-Warning Detect Flag                                          */
            __IOM uint8_t EPIF  : 1;   /*!< [2..2] Error-Passive Detect Flag                                          */
            __IOM uint8_t BOEIF : 1;   /*!< [3..3] Bus-Off Entry Detect Flag                                          */
            __IOM uint8_t BORIF : 1;   /*!< [4..4] Bus-Off Recovery Detect Flag                                       */
            __IOM uint8_t ORIF  : 1;   /*!< [5..5] Receive Overrun Detect Flag                                        */
            __IOM uint8_t OLIF  : 1;   /*!< [6..6] Overload Frame Transmission Detect Flag                            */
            __IOM uint8_t BLIF  : 1;   /*!< [7..7] Bus Lock Detect Flag                                               */
        } EIFR_b;
    };

    union
    {
        __IM uint8_t RECR;             /*!< (@ 0x0000084E) Receive Error Count Register                               */

        struct
        {
            __IM uint8_t RECR : 8;     /*!< [7..0] Receive error count functionRECR increments or decrements
                                        *   the counter value according to the error status of the
                                        *   CAN module during reception.                                              */
        } RECR_b;
    };

    union
    {
        __IM uint8_t TECR;             /*!< (@ 0x0000084F) Transmit Error Count Register                              */

        struct
        {
            __IM uint8_t TECR : 8;     /*!< [7..0] Transmit error count functionTECR increments or decrements
                                        *   the counter value according to the error status of the
                                        *   CAN module during transmission.                                           */
        } TECR_b;
    };

    union
    {
        __IOM uint8_t ECSR;            /*!< (@ 0x00000850) Error Code Store Register                                  */

        struct
        {
            __IOM uint8_t SEF  : 1;    /*!< [0..0] Stuff Error Flag                                                   */
            __IOM uint8_t FEF  : 1;    /*!< [1..1] Form Error Flag                                                    */
            __IOM uint8_t AEF  : 1;    /*!< [2..2] ACK Error Flag                                                     */
            __IOM uint8_t CEF  : 1;    /*!< [3..3] CRC Error Flag                                                     */
            __IOM uint8_t BE1F : 1;    /*!< [4..4] Bit Error (recessive) Flag                                         */
            __IOM uint8_t BE0F : 1;    /*!< [5..5] Bit Error (dominant) Flag                                          */
            __IOM uint8_t ADEF : 1;    /*!< [6..6] ACK Delimiter Error Flag                                           */
            __IOM uint8_t EDPM : 1;    /*!< [7..7] Error Display Mode Select                                          */
        } ECSR_b;
    };

    union
    {
        __IOM uint8_t CSSR;            /*!< (@ 0x00000851) Channel Search Support Register                            */

        struct
        {
            __IOM uint8_t CSSR : 8;    /*!< [7..0] When the value for the channel search is input, the channel
                                        *   number is output to MSSR.                                                 */
        } CSSR_b;
    };

    union
    {
        __IM uint8_t MSSR;             /*!< (@ 0x00000852) Mailbox Search Status Register                             */

        struct
        {
            __IM uint8_t MBNST : 5;    /*!< [4..0] Search Result Mailbox Number Status These bits output
                                        *   the smallest mailbox number that is searched in each mode
                                        *   of MSMR.                                                                  */
            uint8_t           : 2;
            __IM uint8_t SEST : 1;     /*!< [7..7] Search Result Status                                               */
        } MSSR_b;
    };

    union
    {
        __IOM uint8_t MSMR;            /*!< (@ 0x00000853) Mailbox Search Mode Register                               */

        struct
        {
            __IOM uint8_t MBSM : 2;    /*!< [1..0] Mailbox Search Mode Select                                         */
            uint8_t            : 6;
        } MSMR_b;
    };

    union
    {
        __IM uint16_t TSR;             /*!< (@ 0x00000854) Time Stamp Register                                        */

        struct
        {
            __IM uint16_t TSR : 16;    /*!< [15..0] Free-running counter value for the time stamp function            */
        } TSR_b;
    };

    union
    {
        __IOM uint16_t AFSR;           /*!< (@ 0x00000856) Acceptance Filter Support Register                         */

        struct
        {
            __IOM uint16_t AFSR : 16;  /*!< [15..0] After the standard ID of a received message is written,
                                        *   the value converted for data table search can be read.                    */
        } AFSR_b;
    };

    union
    {
        __IOM uint8_t TCR;             /*!< (@ 0x00000858) Test Control Register                                      */

        struct
        {
            __IOM uint8_t TSTE : 1;    /*!< [0..0] CAN Test Mode Enable                                               */
            __IOM uint8_t TSTM : 2;    /*!< [2..1] CAN Test Mode Select                                               */
            uint8_t            : 5;
        } TCR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_CAN0_Type;                         /*!< Size = 2140 (0x85c)                                                       */

/* =========================================================================================================================== */
/* ================                                           R_CRC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Cyclic Redundancy Check (CRC) Calculator (R_CRC)
 */

typedef struct                         /*!< (@ 0x40074000) R_CRC Structure                                            */
{
    union
    {
        __IOM uint8_t CRCCR0;          /*!< (@ 0x00000000) CRC Control Register0                                      */

        struct
        {
            __IOM uint8_t GPS    : 3;  /*!< [2..0] CRC Generating Polynomial Switching                                */
            uint8_t              : 3;
            __IOM uint8_t LMS    : 1;  /*!< [6..6] CRC Calculation Switching                                          */
            __OM uint8_t  DORCLR : 1;  /*!< [7..7] CRCDOR Register Clear                                              */
        } CRCCR0_b;
    };

    union
    {
        __IOM uint8_t CRCCR1;          /*!< (@ 0x00000001) CRC Control Register1                                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t CRCSWR : 1;  /*!< [6..6] Snoop-on-write/read switch bit                                     */
            __IOM uint8_t CRCSEN : 1;  /*!< [7..7] Snoop enable bit                                                   */
        } CRCCR1_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        union
        {
            __IOM uint32_t CRCDIR;          /*!< (@ 0x00000004) CRC Data Input Register                                    */

            struct
            {
                __IOM uint32_t CRCDIR : 32; /*!< [31..0] Calculation input Data (Case of CRC-32, CRC-32C )                 */
            } CRCDIR_b;
        };

        union
        {
            __IOM uint8_t CRCDIR_BY;         /*!< (@ 0x00000004) CRC Data Input Register (byte access)                      */

            struct
            {
                __IOM uint8_t CRCDIR_BY : 8; /*!< [7..0] Calculation input Data ( Case of CRC-8, CRC-16 or CRC-CCITT
                                              *   )                                                                         */
            } CRCDIR_BY_b;
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CRCDOR;          /*!< (@ 0x00000008) CRC Data Output Register                                   */

            struct
            {
                __IOM uint32_t CRCDOR : 32; /*!< [31..0] Calculation output Data (Case of CRC-32, CRC-32C )                */
            } CRCDOR_b;
        };

        union
        {
            __IOM uint16_t CRCDOR_HA;          /*!< (@ 0x00000008) CRC Data Output Register (halfword access)                 */

            struct
            {
                __IOM uint16_t CRCDOR_HA : 16; /*!< [15..0] Calculation output Data (Case of CRC-16 or CRC-CCITT
                                                *   )                                                                         */
            } CRCDOR_HA_b;
        };

        union
        {
            __IOM uint8_t CRCDOR_BY;         /*!< (@ 0x00000008) CRC Data Output Register(byte access)                      */

            struct
            {
                __IOM uint8_t CRCDOR_BY : 8; /*!< [7..0] Calculation output Data (Case of CRC-8 )                           */
            } CRCDOR_BY_b;
        };
    };

    union
    {
        __IOM uint16_t CRCSAR;         /*!< (@ 0x0000000C) Snoop Address Register                                     */

        struct
        {
            __IOM uint16_t CRCSA : 14; /*!< [13..0] snoop address bitSet the I/O register address to snoop            */
            uint16_t             : 2;
        } CRCSAR_b;
    };
    __IM uint16_t RESERVED1;
} R_CRC_Type;                          /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_CTSU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Capacitive Touch Sensing Unit (R_CTSU)
 */

typedef struct                            /*!< (@ 0x40081000) R_CTSU Structure                                           */
{
    union
    {
        __IOM uint8_t CTSUCR0;            /*!< (@ 0x00000000) CTSU Control Register 0                                    */

        struct
        {
            __IOM uint8_t CTSUSTRT   : 1; /*!< [0..0] CTSU Measurement Operation Start                                   */
            __IOM uint8_t CTSUCAP    : 1; /*!< [1..1] CTSU Measurement Operation Start Trigger Select                    */
            __IOM uint8_t CTSUSNZ    : 1; /*!< [2..2] CTSU Wait State Power-Saving Enable                                */
            __IOM uint8_t CTSUIOC    : 1; /*!< [3..3] CTSU Transmit Pin Control                                          */
            __IOM uint8_t CTSUINIT   : 1; /*!< [4..4] CTSU Control Block Initialization                                  */
            uint8_t                  : 2;
            __IOM uint8_t CTSUTXVSEL : 1; /*!< [7..7] CTSU Transmission power supply selection                           */
        } CTSUCR0_b;
    };

    union
    {
        __IOM uint8_t CTSUCR1;            /*!< (@ 0x00000001) CTSU Control Register 1                                    */

        struct
        {
            __IOM uint8_t CTSUPON    : 1; /*!< [0..0] CTSU Power Supply Enable                                           */
            __IOM uint8_t CTSUCSW    : 1; /*!< [1..1] CTSU LPF Capacitance Charging Control                              */
            __IOM uint8_t CTSUATUNE0 : 1; /*!< [2..2] CTSU Power Supply Operating Mode Setting                           */
            __IOM uint8_t CTSUATUNE1 : 1; /*!< [3..3] CTSU Power Supply Capacity Adjustment                              */
            __IOM uint8_t CTSUCLK    : 2; /*!< [5..4] CTSU Operating Clock Select                                        */
            __IOM uint8_t CTSUMD     : 2; /*!< [7..6] CTSU Measurement Mode Select                                       */
        } CTSUCR1_b;
    };

    union
    {
        __IOM uint8_t CTSUSDPRS;           /*!< (@ 0x00000002) CTSU Synchronous Noise Reduction Setting Register          */

        struct
        {
            __IOM uint8_t CTSUPRRATIO : 4; /*!< [3..0] CTSU Measurement Time and Pulse Count AdjustmentRecommended
                                            *   setting: 3 (0011b)                                                        */
            __IOM uint8_t CTSUPRMODE : 2;  /*!< [5..4] CTSU Base Period and Pulse Count Setting                           */
            __IOM uint8_t CTSUSOFF   : 1;  /*!< [6..6] CTSU High-Pass Noise Reduction Function Off Setting                */
            uint8_t                  : 1;
        } CTSUSDPRS_b;
    };

    union
    {
        __IOM uint8_t CTSUSST;         /*!< (@ 0x00000003) CTSU Sensor Stabilization Wait Control Register            */

        struct
        {
            __IOM uint8_t CTSUSST : 8; /*!< [7..0] CTSU Sensor Stabilization Wait ControlNOTE: The value
                                        *   of these bits should be fixed to 00010000b.                               */
        } CTSUSST_b;
    };

    union
    {
        __IOM uint8_t CTSUMCH0;         /*!< (@ 0x00000004) CTSU Measurement Channel Register 0                        */

        struct
        {
            __IOM uint8_t CTSUMCH0 : 6; /*!< [5..0] CTSU Measurement Channel 0.Note1: Writing to these bits
                                         *   is only enabled in self-capacitance single-scan mode (CTSUCR1.CTSUMD[1:0]
                                         *   bits = 00b).Note2: If the value of CTSUMCH0 was set to
                                         *   b'111111 in mode other than self-capacitor single scan
                                         *   mode, the measurement is stopped.                                         */
            uint8_t : 2;
        } CTSUMCH0_b;
    };

    union
    {
        __IOM uint8_t CTSUMCH1;        /*!< (@ 0x00000005) CTSU Measurement Channel Register 1                        */

        struct
        {
            __IM uint8_t CTSUMCH1 : 6; /*!< [5..0] CTSU Measurement Channel 1Note1: If the value of CTSUMCH1
                                        *   was set to b'111111, the measurement is stopped.                          */
            uint8_t : 2;
        } CTSUMCH1_b;
    };

    union
    {
        __IOM uint8_t CTSUCHAC[5];     /*!< (@ 0x00000006) CTSU Channel Enable Control Register                       */

        struct
        {
            __IOM uint8_t TS0 : 1;     /*!< [0..0] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS1 : 1;     /*!< [1..1] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS2 : 1;     /*!< [2..2] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS3 : 1;     /*!< [3..3] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS4 : 1;     /*!< [4..4] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS5 : 1;     /*!< [5..5] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS6 : 1;     /*!< [6..6] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS7 : 1;     /*!< [7..7] CTSU Channel Enable Control                                        */
        } CTSUCHAC_b[5];
    };

    union
    {
        __IOM uint8_t CTSUCHTRC[5];    /*!< (@ 0x0000000B) CTSU Channel Transmit/Receive Control Register             */

        struct
        {
            __IOM uint8_t TS0 : 1;     /*!< [0..0] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS1 : 1;     /*!< [1..1] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS2 : 1;     /*!< [2..2] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS3 : 1;     /*!< [3..3] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS4 : 1;     /*!< [4..4] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS5 : 1;     /*!< [5..5] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS6 : 1;     /*!< [6..6] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS7 : 1;     /*!< [7..7] CTSU Channel Transmit/Receive Control                              */
        } CTSUCHTRC_b[5];
    };

    union
    {
        __IOM uint8_t CTSUDCLKC;         /*!< (@ 0x00000010) CTSU High-Pass Noise Reduction Control Register            */

        struct
        {
            __IOM uint8_t CTSUSSMOD : 2; /*!< [1..0] CTSU Diffusion Clock Mode SelectNOTE: This bit should
                                          *   be set to 00b.                                                            */
            uint8_t                 : 2;
            __IOM uint8_t CTSUSSCNT : 2; /*!< [5..4] CTSU Diffusion Clock Mode ControlNOTE: This bit should
                                          *   be set to 11b.                                                            */
            uint8_t : 2;
        } CTSUDCLKC_b;
    };

    union
    {
        __IOM uint8_t CTSUST;           /*!< (@ 0x00000011) CTSU Status Register                                       */

        struct
        {
            __IM uint8_t CTSUSTC   : 3; /*!< [2..0] CTSU Measurement Status Counter                                    */
            uint8_t                : 1;
            __IM uint8_t  CTSUDTSR : 1; /*!< [4..4] CTSU Data Transfer Status Flag                                     */
            __IOM uint8_t CTSUSOVF : 1; /*!< [5..5] CTSU Sensor Counter Overflow Flag                                  */
            __IOM uint8_t CTSUROVF : 1; /*!< [6..6] CTSU Reference Counter Overflow Flag                               */
            __IM uint8_t  CTSUPS   : 1; /*!< [7..7] CTSU Mutual Capacitance Status Flag                                */
        } CTSUST_b;
    };

    union
    {
        __IOM uint16_t CTSUSSC;        /*!< (@ 0x00000012) CTSU High-Pass Noise Reduction Spectrum Diffusion
                                        *                  Control Register                                           */

        struct
        {
            uint16_t                 : 8;
            __IOM uint16_t CTSUSSDIV : 4; /*!< [11..8] CTSU Spectrum Diffusion Frequency Division Setting                */
            uint16_t                 : 4;
        } CTSUSSC_b;
    };

    union
    {
        __IOM uint16_t CTSUSO0;          /*!< (@ 0x00000014) CTSU Sensor Offset Register 0                              */

        struct
        {
            __IOM uint16_t CTSUSO : 10;  /*!< [9..0] CTSU Sensor Offset AdjustmentCurrent offset amount is
                                          *   CTSUSO ( 0 to 1023 )                                                      */
            __IOM uint16_t CTSUSNUM : 6; /*!< [15..10] CTSU Measurement Count Setting                                   */
        } CTSUSO0_b;
    };

    union
    {
        __IOM uint16_t CTSUSO1;           /*!< (@ 0x00000016) CTSU Sensor Offset Register 1                              */

        struct
        {
            __IOM uint16_t CTSURICOA : 8; /*!< [7..0] CTSU Reference ICO Current AdjustmentCurrent offset amount
                                           *   is CTSUSO ( 0 to 255 )                                                    */
            __IOM uint16_t CTSUSDPA : 5;  /*!< [12..8] CTSU Base Clock SettingOperating clock divided by (
                                           *   CTSUSDPA + 1 ) x 2                                                        */
            __IOM uint16_t CTSUICOG : 2;  /*!< [14..13] CTSU ICO Gain Adjustment                                         */
            uint16_t                : 1;
        } CTSUSO1_b;
    };

    union
    {
        __IM uint16_t CTSUSC;          /*!< (@ 0x00000018) CTSU Sensor Counter                                        */

        struct
        {
            __IM uint16_t CTSUSC : 16; /*!< [15..0] CTSU Sensor CounterThese bits indicate the measurement
                                        *   result of the CTSU. These bits indicate FFFFh when an overflow
                                        *   occurs.                                                                   */
        } CTSUSC_b;
    };

    union
    {
        __IM uint16_t CTSURC;          /*!< (@ 0x0000001A) CTSU Reference Counter                                     */

        struct
        {
            __IM uint16_t CTSURC : 16; /*!< [15..0] CTSU Reference CounterThese bits indicate the measurement
                                        *   result of the reference ICO.These bits indicate FFFFh when
                                        *   an overflow occurs.                                                       */
        } CTSURC_b;
    };

    union
    {
        __IM uint16_t CTSUERRS;          /*!< (@ 0x0000001C) CTSU Error Status Register                                 */

        struct
        {
            __IOM uint16_t CTSUSPMD : 2; /*!< [1..0] Calibration Mode                                                   */
            __IOM uint16_t CTSUTSOD : 1; /*!< [2..2] TS Pin Fixed Output                                                */
            __IOM uint16_t CTSUDRV  : 1; /*!< [3..3] Calibration Setting 1                                              */
            uint16_t                : 3;
            __IOM uint16_t CTSUTSOC : 1; /*!< [7..7] Calibration Setting 2                                              */
            uint16_t                : 7;
            __IM uint16_t CTSUICOMP : 1; /*!< [15..15] TSCAP Voltage Error Monitor                                      */
        } CTSUERRS_b;
    };
    __IM uint16_t RESERVED;
    __IOM uint8_t CTSUTRMR;              /*!< (@ 0x00000020) CTSU Reference Current Calibration Register                */
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
} R_CTSU_Type;                           /*!< Size = 36 (0x24)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_CTSU2                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Capacitive Touch Sensing Unit (R_CTSU2)
 */

typedef struct                         /*!< (@ 0x40082000) R_CTSU2 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t CTSUCRA;        /*!< (@ 0x00000000) CTSU Control Register A                                    */

            struct
            {
                __IOM uint32_t STRT   : 1; /*!< [0..0] CTSU Measurement Operation Start                                   */
                __IOM uint32_t CAP    : 1; /*!< [1..1] CTSU Measurement Operation Start Trigger Select                    */
                __IOM uint32_t SNZ    : 1; /*!< [2..2] CTSU Wait State Power-Saving Enable                                */
                __IOM uint32_t CFCON  : 1; /*!< [3..3] CTSU CFC Power on Control                                          */
                __OM uint32_t  INIT   : 1; /*!< [4..4] CTSU Control Block Initialization                                  */
                __IOM uint32_t PUMPON : 1; /*!< [5..5] CTSU Boost Circuit Control                                         */
                __IOM uint32_t TXVSEL : 2; /*!< [7..6] CTSU Transmission Power Supply Selection                           */
                __IOM uint32_t PON    : 1; /*!< [8..8] CTSU Power Supply Enable                                           */
                __IOM uint32_t CSW    : 1; /*!< [9..9] CTSU LPF Capacitance Charging Control                              */
                __IOM uint32_t ATUNE0 : 1; /*!< [10..10] CTSU Power Supply Operating Mode Setting                         */
                __IOM uint32_t ATUNE1 : 1; /*!< [11..11] CTSU Current Range Adjustment                                    */
                __IOM uint32_t CLK    : 2; /*!< [13..12] CTSU Operating Clock Select                                      */
                __IOM uint32_t MD0    : 1; /*!< [14..14] CTSU Measurement Mode Select 0                                   */
                __IOM uint32_t MD1    : 1; /*!< [15..15] CTSU Measurement Mode Select 1                                   */
                __IOM uint32_t MD2    : 1; /*!< [16..16] CTSU Measurement Mode Select 2                                   */
                __IOM uint32_t ATUNE2 : 1; /*!< [17..17] CTSU Current Range Adjustment                                    */
                __IOM uint32_t LOAD   : 2; /*!< [19..18] CTSU Measurement Load Control                                    */
                __IOM uint32_t POSEL  : 2; /*!< [21..20] CTSU Non-measured Channel Output Select                          */
                __IOM uint32_t SDPSEL : 1; /*!< [22..22] CTSU Sensor Drive Pulse Select                                   */
                __IOM uint32_t PCSEL  : 1; /*!< [23..23] CTSU Boost Circuit Clock Select                                  */
                __IOM uint32_t STCLK  : 6; /*!< [29..24] CTSU STCLK Select                                                */
                __IOM uint32_t DCMODE : 1; /*!< [30..30] CTSU Current Measurement Mode Select                             */
                __IOM uint32_t DCBACK : 1; /*!< [31..31] CTSU Current Measurement Feedback Select                         */
            } CTSUCRA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCRAL;   /*!< (@ 0x00000000) CTSU Control Register A                                    */

                struct
                {
                    __IOM uint8_t CTSUCR0; /*!< (@ 0x00000000) CTSU Control Register A                                    */
                    __IOM uint8_t CTSUCR1; /*!< (@ 0x00000001) CTSU Control Register A                                    */
                };
            };

            union
            {
                __IOM uint16_t CTSUCRAH;   /*!< (@ 0x00000002) CTSU Control Register A                                    */

                struct
                {
                    __IOM uint8_t CTSUCR2; /*!< (@ 0x00000002) CTSU Control Register A                                    */
                    __IOM uint8_t CTSUCR3; /*!< (@ 0x00000003) CTSU Control Register A                                    */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCRB;         /*!< (@ 0x00000004) CTSU Control Register B                                    */

            struct
            {
                __IOM uint32_t PRRATIO : 4; /*!< [3..0] CTSU Measurement Time and Pulse Count Adjustment                   */
                __IOM uint32_t PRMODE  : 2; /*!< [5..4] CTSU Base Period and Pulse Count Setting                           */
                __IOM uint32_t SOFF    : 1; /*!< [6..6] CTSU High-Pass Noise Reduction Function Off Setting                */
                __IOM uint32_t PROFF   : 1; /*!< [7..7] CTSU Random Number Off Control                                     */
                __IOM uint32_t SST     : 8; /*!< [15..8] CTSU Sensor Stabilization Wait Control                            */
                uint32_t               : 8;
                __IOM uint32_t SSMOD   : 3; /*!< [26..24] CTSU SUCLK Diffusion Mode Select                                 */
                uint32_t               : 1;
                __IOM uint32_t SSCNT   : 2; /*!< [29..28] CTSU SUCLK Diffusion Control                                     */
                uint32_t               : 2;
            } CTSUCRB_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCRBL;     /*!< (@ 0x00000004) CTSU Control Register B                                    */

                struct
                {
                    __IOM uint8_t CTSUSDPRS; /*!< (@ 0x00000004) CTSU Control Register B                                    */
                    __IOM uint8_t CTSUSST;   /*!< (@ 0x00000005) CTSU Control Register B                                    */
                };
            };

            union
            {
                __IOM uint16_t CTSUCRBH; /*!< (@ 0x00000006) CTSU Control Register B                                    */

                struct
                {
                    __IM uint8_t  RESERVED;
                    __IOM uint8_t CTSUDCLKC; /*!< (@ 0x00000007) CTSU Control Register B                                    */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUMCH;      /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */

            struct
            {
                __IOM uint32_t MCH0 : 6; /*!< [5..0] CTSU Measurement Channel 0                                         */
                uint32_t            : 2;
                __IOM uint32_t MCH1 : 6; /*!< [13..8] CTSU Measurement Channel 1                                        */
                uint32_t            : 2;
                __IOM uint32_t MCA0 : 1; /*!< [16..16] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA1 : 1; /*!< [17..17] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA2 : 1; /*!< [18..18] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA3 : 1; /*!< [19..19] CTSU Multiple Valid Clock Control                                */
                uint32_t            : 12;
            } CTSUMCH_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUMCHL;    /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */

                struct
                {
                    __IOM uint8_t CTSUMCH0; /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */
                    __IOM uint8_t CTSUMCH1; /*!< (@ 0x00000009) CTSU Measurement Channel Register                          */
                };
            };

            union
            {
                __IOM uint16_t CTSUMCHH; /*!< (@ 0x0000000A) CTSU Measurement Channel Register                          */
                __IOM uint8_t  CTSUMFAF; /*!< (@ 0x0000000A) CTSU Measurement Channel Register                          */
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHACA;      /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */

            struct
            {
                __IOM uint32_t CHAC00 : 1; /*!< [0..0] CTSU Channel Enable Control A                                      */
                uint32_t              : 1;
                __IOM uint32_t CHAC02 : 1; /*!< [2..2] CTSU Channel Enable Control A                                      */
                uint32_t              : 1;
                __IOM uint32_t CHAC04 : 1; /*!< [4..4] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC05 : 1; /*!< [5..5] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC06 : 1; /*!< [6..6] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC07 : 1; /*!< [7..7] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC08 : 1; /*!< [8..8] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC09 : 1; /*!< [9..9] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC10 : 1; /*!< [10..10] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC11 : 1; /*!< [11..11] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC12 : 1; /*!< [12..12] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC13 : 1; /*!< [13..13] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC14 : 1; /*!< [14..14] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC15 : 1; /*!< [15..15] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC16 : 1; /*!< [16..16] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC17 : 1; /*!< [17..17] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC18 : 1; /*!< [18..18] CTSU Channel Enable Control A                                    */
                uint32_t              : 2;
                __IOM uint32_t CHAC21 : 1; /*!< [21..21] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC22 : 1; /*!< [22..22] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC23 : 1; /*!< [23..23] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC24 : 1; /*!< [24..24] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC25 : 1; /*!< [25..25] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC26 : 1; /*!< [26..26] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC27 : 1; /*!< [27..27] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC28 : 1; /*!< [28..28] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC29 : 1; /*!< [29..29] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC30 : 1; /*!< [30..30] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC31 : 1; /*!< [31..31] CTSU Channel Enable Control A                                    */
            } CTSUCHACA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCHACAL;   /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */

                struct
                {
                    __IOM uint8_t CTSUCHAC0; /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */
                    __IOM uint8_t CTSUCHAC1; /*!< (@ 0x0000000D) CTSU Channel Enable Control Register A                     */
                };
            };

            union
            {
                __IOM uint16_t CTSUCHACAH;   /*!< (@ 0x0000000E) CTSU Channel Enable Control Register A                     */

                struct
                {
                    __IOM uint8_t CTSUCHAC2; /*!< (@ 0x0000000E) CTSU Channel Enable Control Register A                     */
                    __IOM uint8_t CTSUCHAC3; /*!< (@ 0x0000000F) CTSU Channel Enable Control Register A                     */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHACB;      /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */

            struct
            {
                __IOM uint32_t CHAC32 : 1; /*!< [0..0] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC33 : 1; /*!< [1..1] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC34 : 1; /*!< [2..2] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC35 : 1; /*!< [3..3] CTSU Channel Enable Control B                                      */
                uint32_t              : 28;
            } CTSUCHACB_b;
        };
        __IOM uint16_t CTSUCHACBL;         /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */
        __IOM uint8_t  CTSUCHAC4;          /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHTRCA;      /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                             *                  A                                                          */

            struct
            {
                __IOM uint32_t CHTRC   : 1; /*!< [0..0] CTSU Channel Transmit/Receive Control A                            */
                uint32_t               : 1;
                __IOM uint32_t CHTRC02 : 1; /*!< [2..2] CTSU Channel Transmit/Receive Control A                            */
                uint32_t               : 1;
                __IOM uint32_t CHTRC04 : 1; /*!< [4..4] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC05 : 1; /*!< [5..5] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC06 : 1; /*!< [6..6] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC07 : 1; /*!< [7..7] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC08 : 1; /*!< [8..8] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC09 : 1; /*!< [9..9] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC10 : 1; /*!< [10..10] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC11 : 1; /*!< [11..11] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC12 : 1; /*!< [12..12] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC13 : 1; /*!< [13..13] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC14 : 1; /*!< [14..14] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC15 : 1; /*!< [15..15] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC16 : 1; /*!< [16..16] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC17 : 1; /*!< [17..17] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC18 : 1; /*!< [18..18] CTSU Channel Transmit/Receive Control A                          */
                uint32_t               : 2;
                __IOM uint32_t CHTRC21 : 1; /*!< [21..21] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC22 : 1; /*!< [22..22] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC23 : 1; /*!< [23..23] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC24 : 1; /*!< [24..24] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC25 : 1; /*!< [25..25] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC26 : 1; /*!< [26..26] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC27 : 1; /*!< [27..27] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC28 : 1; /*!< [28..28] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC29 : 1; /*!< [29..29] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC30 : 1; /*!< [30..30] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC31 : 1; /*!< [31..31] CTSU Channel Transmit/Receive Control A                          */
            } CTSUCHTRCA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCHTRCAL;   /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */

                struct
                {
                    __IOM uint8_t CTSUCHTRC0; /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                    __IOM uint8_t CTSUCHTRC1; /*!< (@ 0x00000015) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                };
            };

            union
            {
                __IOM uint16_t CTSUCHTRCAH;   /*!< (@ 0x00000016) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */

                struct
                {
                    __IOM uint8_t CTSUCHTRC2; /*!< (@ 0x00000016) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                    __IOM uint8_t CTSUCHTRC3; /*!< (@ 0x00000017) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHTRCB;      /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */

            struct
            {
                __IOM uint32_t CHTRC32 : 1; /*!< [0..0] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC33 : 1; /*!< [1..1] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC34 : 1; /*!< [2..2] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC35 : 1; /*!< [3..3] CTSU Channel Transmit/Receive Control B                            */
                uint32_t               : 28;
            } CTSUCHTRCB_b;
        };
        __IOM uint16_t CTSUCHTRCBL;         /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */
        __IOM uint8_t CTSUCHTRC4;           /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSR;          /*!< (@ 0x0000001C) CTSU Status Register                                       */

            struct
            {
                __IOM uint32_t MFC     : 2; /*!< [1..0] CTSU Multi-clock Counter                                           */
                uint32_t               : 3;
                __OM uint32_t ICOMPRST : 1; /*!< [5..5] CTSU CTSUICOMP1 Flag Reset                                         */
                __IM uint32_t ICOMP1   : 1; /*!< [6..6] CTSU Sense Current Error Monitor                                   */
                __IM uint32_t ICOMP0   : 1; /*!< [7..7] TSCAP Voltage Error Monitor                                        */
                __IM uint32_t STC      : 3; /*!< [10..8] CTSU Measurement Status Counter                                   */
                uint32_t               : 1;
                __IM uint32_t  DTSR    : 1; /*!< [12..12] CTSU Data Transfer Status Flag                                   */
                __IOM uint32_t SENSOVF : 1; /*!< [13..13] CTSU Sensor Counter Overflow Flag                                */
                uint32_t               : 1;
                __IM uint32_t  PS      : 1; /*!< [15..15] CTSU Mutual Capacitance Status Flag                              */
                __IOM uint32_t CFCRDCH : 6; /*!< [21..16] CTSU CFC Read Channel Select                                     */
                uint32_t               : 10;
            } CTSUSR_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUSRL;    /*!< (@ 0x0000001C) CTSU Status Register                                       */

                struct
                {
                    __IOM uint8_t CTSUSR0; /*!< (@ 0x0000001C) CTSU Status Register                                       */
                    __IOM uint8_t CTSUST;  /*!< (@ 0x0000001D) CTSU Status Register                                       */
                };
            };

            union
            {
                __IOM uint16_t CTSUSRH; /*!< (@ 0x0000001E) CTSU Status Register                                       */
                __IOM uint8_t  CTSUSR2; /*!< (@ 0x0000001E) CTSU Status Register                                       */
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSO;         /*!< (@ 0x00000020) CTSU Sensor Offset Register                                */

            struct
            {
                __IOM uint32_t SO    : 10; /*!< [9..0] CTSU Sensor Offset Adjustment                                      */
                __IOM uint32_t SNUM  : 8;  /*!< [17..10] CTSU Measurement Count Setting                                   */
                uint32_t             : 2;
                __IOM uint32_t SSDIV : 4;  /*!< [23..20] CTSU Spectrum Diffusion Frequency Division Setting               */
                __IOM uint32_t SDPA  : 8;  /*!< [31..24] CTSU Base Clock Setting                                          */
            } CTSUSO_b;
        };

        struct
        {
            __IOM uint16_t CTSUSO0;    /*!< (@ 0x00000020) CTSU Sensor Offset Register                                */
            __IOM uint16_t CTSUSO1;    /*!< (@ 0x00000022) CTSU Sensor Offset Register                                */
        };
    };

    union
    {
        union
        {
            __IM uint32_t CTSUSCNT;         /*!< (@ 0x00000024) CTSU Sensor Counter Register                               */

            struct
            {
                __IM uint32_t SENSCNT : 16; /*!< [15..0] CTSU Sensor Counter                                               */
                __IM uint32_t SUCKCNT : 16; /*!< [31..16] CTSU SUCLK Counter                                               */
            } CTSUSCNT_b;
        };
        __IM uint16_t CTSUSC;               /*!< (@ 0x00000024) CTSU Sensor Counter Register                               */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCALIB;  /*!< (@ 0x00000028) CTSU Calibration Register                                  */

            struct
            {
                uint32_t                : 2;
                __IOM uint32_t TSOD     : 1; /*!< [2..2] CTSU TS Pins Fixed Output Select                                   */
                __IOM uint32_t DRV      : 1; /*!< [3..3] CTSU Power Supply Forced Start                                     */
                __IOM uint32_t CLKSEL   : 2; /*!< [5..4] CTSU Observation Clock Select                                      */
                __IOM uint32_t SUCLKEN  : 1; /*!< [6..6] CTSU SUCLK Enable Control                                          */
                __IOM uint32_t TSOC     : 1; /*!< [7..7] CTSU Switched Capacitor Operation Stop                             */
                __IOM uint32_t CNTRDSEL : 1; /*!< [8..8] CTSU Read Count Select of Sensor Counter                           */
                __IOM uint32_t IOC      : 1; /*!< [9..9] CTSU Transfer Pins Control                                         */
                __IOM uint32_t CFCRDMD  : 1; /*!< [10..10] CTSU CFC Counter Read Mode Select                                */
                __IOM uint32_t DCOFF    : 1; /*!< [11..11] CTSU Down Converter Control                                      */
                uint32_t                : 4;
                __IOM uint32_t CFCSEL   : 6; /*!< [21..16] CTSU Observation CFC Clock Select                                */
                __IOM uint32_t CFCMODE  : 1; /*!< [22..22] CTSU CFC Current Source Switching                                */
                uint32_t                : 2;
                __IOM uint32_t DACCARRY : 1; /*!< [25..25] CTSU DAC Upper Current Source Carry Control                      */
                uint32_t                : 1;
                __IOM uint32_t SUCARRY  : 1; /*!< [27..27] CTSU CCO Carry Control                                           */
                __IOM uint32_t DACCLK   : 1; /*!< [28..28] CTSU DAC Modulation Circuit Clock Select                         */
                __IOM uint32_t CCOCLK   : 1; /*!< [29..29] CTSU CCO Modulation Circuit Clock Select                         */
                __IOM uint32_t CCOCALIB : 1; /*!< [30..30] CTSU CCO Calibration Mode Select                                 */
                __IOM uint32_t TXREV    : 1; /*!< [31..31] CTSU Transmit Pin Inverted Output                                */
            } CTSUCALIB_b;
        };

        struct
        {
            __IOM uint16_t CTSUDBGR0;  /*!< (@ 0x00000028) CTSU Calibration Register                                  */
            __IOM uint16_t CTSUDBGR1;  /*!< (@ 0x0000002A) CTSU Calibration Register                                  */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSUCLKA;       /*!< (@ 0x0000002C) CTSU Sensor Unit Clock Control Register A                  */

            struct
            {
                __IOM uint32_t SUADJ0   : 8; /*!< [7..0] CTSU SUCLK Frequency Adjustment                                    */
                __IOM uint32_t SUMULTI0 : 8; /*!< [15..8] CTSU SUCLK Multiplier Rate Setting                                */
                __IOM uint32_t SUADJ1   : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
                __IOM uint32_t SUMULTI1 : 8; /*!< [31..24] CTSU SUCLK Multiplier Rate Setting                               */
            } CTSUSUCLKA_b;
        };

        struct
        {
            __IOM uint16_t CTSUSUCLK0; /*!< (@ 0x0000002C) CTSU Sensor Unit Clock Control Register A                  */
            __IOM uint16_t CTSUSUCLK1; /*!< (@ 0x0000002E) CTSU Sensor Unit Clock Control Register A                  */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSUCLKB;       /*!< (@ 0x00000030) CTSU Sensor Unit Clock Control Register B                  */

            struct
            {
                __IOM uint32_t SUADJ2   : 8; /*!< [7..0] CTSU SUCLK Frequency Adjustment                                    */
                __IOM uint32_t SUMULTI2 : 8; /*!< [15..8] CTSU SUCLK Multiplier Rate Setting                                */
                __IOM uint32_t SUADJ3   : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
                __IOM uint32_t SUMULTI3 : 8; /*!< [31..24] CTSU SUCLK Multiplier Rate Setting                               */
            } CTSUSUCLKB_b;
        };

        struct
        {
            __IOM uint16_t CTSUSUCLK2; /*!< (@ 0x00000030) CTSU Sensor Unit Clock Control Register B                  */
            __IOM uint16_t CTSUSUCLK3; /*!< (@ 0x00000032) CTSU Sensor Unit Clock Control Register B                  */
        };
    };

    union
    {
        union
        {
            __IM uint32_t CTSUCFCCNT;      /*!< (@ 0x00000034) CTSU CFC Counter Register                                  */

            struct
            {
                __IM uint32_t CFCCNT : 16; /*!< [15..0] CTSU CFC Counter                                                  */
                uint32_t             : 16;
            } CTSUCFCCNT_b;
        };
        __IM uint16_t CTSUCFCCNTL;         /*!< (@ 0x00000034) CTSU CFC Counter Register                                  */
    };
} R_CTSU2_Type;                            /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief D/A Converter (R_DAC)
 */

typedef struct                         /*!< (@ 0x4005E000) R_DAC Structure                                            */
{
    union
    {
        __IOM uint16_t DADR[2];        /*!< (@ 0x00000000) D/A Data Register                                          */

        struct
        {
            __IOM uint16_t DADR : 16;  /*!< [15..0] D/A Data RegisterNOTE: When DADPR.DPSEL = 0, the high-order
                                        *   4 bits are fixed to 0: right justified format. When DADPR.DPSEL
                                        *   = 1, the low-order 4 bits are fixed to 0: left justified
                                        *   format.                                                                   */
        } DADR_b[2];
    };

    union
    {
        __IOM uint8_t DACR;            /*!< (@ 0x00000004) D/A Control Register                                       */

        struct
        {
            uint8_t             : 5;
            __IOM uint8_t DAE   : 1;   /*!< [5..5] D/A Enable                                                         */
            __IOM uint8_t DAOE0 : 1;   /*!< [6..6] D/A Output Enable 0                                                */
            __IOM uint8_t DAOE1 : 1;   /*!< [7..7] D/A Output Enable 0                                                */
        } DACR_b;
    };

    union
    {
        __IOM uint8_t DADPR;           /*!< (@ 0x00000005) DADR0 Format Select Register                               */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t DPSEL : 1;   /*!< [7..7] DADRm Format Select                                                */
        } DADPR_b;
    };

    union
    {
        __IOM uint8_t DAADSCR;         /*!< (@ 0x00000006) D/A-A/D Synchronous Start Control Register                 */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t DAADST : 1;  /*!< [7..7] D/A-A/D Synchronous Conversion                                     */
        } DAADSCR_b;
    };

    union
    {
        __IOM uint8_t DAVREFCR;        /*!< (@ 0x00000007) D/A VREF Control Register                                  */

        struct
        {
            __IOM uint8_t REF : 3;     /*!< [2..0] D/A Reference Voltage Select                                       */
            uint8_t           : 5;
        } DAVREFCR_b;
    };

    union
    {
        __IOM uint8_t DAAMPCR;         /*!< (@ 0x00000008) D/A Output Amplifier Control Register                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAAMP0 : 1;  /*!< [6..6] Amplifier Control                                                  */
            __IOM uint8_t DAAMP1 : 1;  /*!< [7..7] Amplifier Control                                                  */
        } DAAMPCR_b;
    };

    union
    {
        __IOM uint8_t DAPC;            /*!< (@ 0x00000009) D/A Switch Charge Pump Control Register                    */

        struct
        {
            __IOM uint8_t PUMPEN : 1;  /*!< [0..0] Charge Pump Enable                                                 */
            uint8_t              : 7;
        } DAPC_b;
    };
    __IM uint16_t RESERVED[9];

    union
    {
        __IOM uint8_t DAASWCR;         /*!< (@ 0x0000001C) D/A Amplifier Stabilization Wait Control Register          */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAASW0 : 1;  /*!< [6..6] Set the DAASW0 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 0. When DAASW0 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   0. When the DAASW0 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 0 is output
                                        *   through the output amplifier.                                             */
            __IOM uint8_t DAASW1 : 1;  /*!< [7..7] Set the DAASW1 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 1. When DAASW1 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   1. When the DAASW1 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 1 is output
                                        *   through the output amplifier.                                             */
        } DAASWCR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2[2129];

    union
    {
        __IOM uint8_t DAADUSR;         /*!< (@ 0x000010C0) D/A A/D Synchronous Unit Select Register                   */

        struct
        {
            uint8_t                : 6;
            __IOM uint8_t AMADSEL1 : 1; /*!< [6..6] The DAADUSR register selects the target ADC12 unit for
                                         *   D/A and A/D synchronous conversions. Set bit [1] to 1 to
                                         *   select unit 1 as the target synchronous unit for the MCU.
                                         *   When setting the DAADSCR.DAADST bit to 1 for synchronous
                                         *   conversions, select the target unit in this register in
                                         *   advance. Only set the DAADUSR register while the ADCSR.ADST
                                         *   bit of the ADC12 is set to 0 and the DAADSCR.DAADST bit
                                         *   is set to 0.                                                              */
            uint8_t : 1;
        } DAADUSR_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;
} R_DAC_Type;                          /*!< Size = 4292 (0x10c4)                                                      */

/* =========================================================================================================================== */
/* ================                                          R_DAC8                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief 8-Bit D/A Converter (R_DAC8)
 */

typedef struct                         /*!< (@ 0x4009E000) R_DAC8 Structure                                           */
{
    union
    {
        __IOM uint8_t DACS[2];         /*!< (@ 0x00000000) D/A Conversion Value Setting Register [0..1]               */

        struct
        {
            __IOM uint8_t DACS : 8;    /*!< [7..0] DACS D/A conversion store data                                     */
        } DACS_b[2];
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t DAM;             /*!< (@ 0x00000003) D/A Converter Mode Register                                */

        struct
        {
            __IOM uint8_t DAMD0 : 1;   /*!< [0..0] D/A operation mode select 0                                        */
            __IOM uint8_t DAMD1 : 1;   /*!< [1..1] D/A operation mode select 1                                        */
            uint8_t             : 2;
            __IOM uint8_t DACE0 : 1;   /*!< [4..4] D/A operation enable 0                                             */
            __IOM uint8_t DACE1 : 1;   /*!< [5..5] D/A operation enable 1                                             */
            uint8_t             : 2;
        } DAM_b;
    };
    __IM uint8_t RESERVED1[2];

    union
    {
        __IOM uint8_t DACADSCR;        /*!< (@ 0x00000006) D/A A/D Synchronous Start Control Register                 */

        struct
        {
            __IOM uint8_t DACADST : 1; /*!< [0..0] D/A A/D Synchronous Conversion                                     */
            uint8_t               : 7;
        } DACADSCR_b;
    };

    union
    {
        __IOM uint8_t DACPC;           /*!< (@ 0x00000007) D/A SW Charge Pump Control Register                        */

        struct
        {
            __IOM uint8_t PUMPEN : 1;  /*!< [0..0] Charge pump enable                                                 */
            uint8_t              : 7;
        } DACPC_b;
    };
} R_DAC8_Type;                         /*!< Size = 8 (0x8)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_DALI0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Digital Addressable Lighting Interface (R_DALI0)
 */

typedef struct                         /*!< (@ 0x4008F000) R_DALI0 Structure                                          */
{
    union
    {
        __IOM uint16_t BTVTHR1;        /*!< (@ 0x00000000) DALI Bit Timing Violation Threshold Register
                                        *                  1                                                          */

        struct
        {
            __IOM uint16_t BTV1 : 7;   /*!< [6..0] Bit Timing Violation Threshold 1Specifies the bit timing
                                        *   violation threshold value 1.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            uint16_t            : 1;
            __IOM uint16_t BTV2 : 8;   /*!< [15..8] Bit Timing Violation Threshold 2Specifies the bit timing
                                        *   violation threshold value 2.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
        } BTVTHR1_b;
    };

    union
    {
        __IOM uint16_t BTVTHR2;        /*!< (@ 0x00000002) DALI Bit Timing Violation Threshold Register
                                        *                  2                                                          */

        struct
        {
            __IOM uint16_t BTV3 : 8;   /*!< [7..0] Bit Timing Violation Threshold 3Specifies the bit timing
                                        *   violation threshold value 3.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            __IOM uint16_t BTV4 : 8;   /*!< [15..8] Bit Timing Violation Threshold 4Specifies the bit timing
                                        *   violation threshold value 4.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
        } BTVTHR2_b;
    };

    union
    {
        __IOM uint16_t BTVTHR3;        /*!< (@ 0x00000004) DALI Bit Timing Violation Threshold Register
                                        *                  3                                                          */

        struct
        {
            __IOM uint16_t BTV5 : 8;   /*!< [7..0] Bit Timing Violation Threshold 5Specifies the bit timing
                                        *   violation threshold value 5.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            uint16_t : 8;
        } BTVTHR3_b;
    };

    union
    {
        __IOM uint16_t BTVTHR4;        /*!< (@ 0x00000006) DALI Bit Timing Violation Threshold Register
                                        *                  4                                                          */

        struct
        {
            __IOM uint16_t BTV6 : 9;   /*!< [8..0] Bit Timing Violation Threshold 6Specifies the bit timing
                                        *   violation threshold value 6.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            uint16_t : 7;
        } BTVTHR4_b;
    };

    union
    {
        __IOM uint16_t COLTHR1;        /*!< (@ 0x00000008) DALI Collision Threshold Register 1                        */

        struct
        {
            __IOM uint16_t COL1 : 6;   /*!< [5..0] Collision Threshold 1Specifies the collision threshold
                                        *   value 1.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t            : 2;
            __IOM uint16_t COL2 : 6;   /*!< [13..8] Collision Threshold 2Specifies the collision threshold
                                        *   value 2.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 2;
        } COLTHR1_b;
    };

    union
    {
        __IOM uint16_t COLTHR2;        /*!< (@ 0x0000000A) DALI Collision Threshold Register 2                        */

        struct
        {
            __IOM uint16_t COL3 : 7;   /*!< [6..0] Collision Threshold 3Specifies the collision threshold
                                        *   value 3.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t            : 1;
            __IOM uint16_t COL4 : 7;   /*!< [14..8] Collision Threshold 4Specifies the collision threshold
                                        *   value 4.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 1;
        } COLTHR2_b;
    };

    union
    {
        __IOM uint16_t COLTHR3;        /*!< (@ 0x0000000C) DALI Collision Threshold Register 3                        */

        struct
        {
            __IOM uint16_t COL5 : 7;   /*!< [6..0] Collision Threshold 5Specifies the collision threshold
                                        *   value 5.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t            : 1;
            __IOM uint16_t COL6 : 7;   /*!< [14..8] Collision Threshold 6Specifies the collision threshold
                                        *   value 6.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 1;
        } COLTHR3_b;
    };

    union
    {
        __IOM uint16_t COLTHR4;        /*!< (@ 0x0000000E) DALI Collision Threshold Register 4                        */

        struct
        {
            __IOM uint16_t COL7 : 8;   /*!< [7..0] Collision Threshold 7Specifies the collision threshold
                                        *   value 7.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            __IOM uint16_t COL8 : 8;   /*!< [15..8] Collision Threshold 8Specifies the collision threshold
                                        *   value 8.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
        } COLTHR4_b;
    };

    union
    {
        __IOM uint16_t COLTHR5;        /*!< (@ 0x00000010) DALI Collision Threshold Register 5                        */

        struct
        {
            __IOM uint16_t COL9 : 8;   /*!< [7..0] Collision Threshold 9Specifies the collision threshold
                                        *   value 9.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 8;
        } COLTHR5_b;
    };

    union
    {
        __IOM uint16_t CNFR1;          /*!< (@ 0x00000012) DALI Configuration Register 1                              */

        struct
        {
            __IOM uint16_t BR  : 8;    /*!< [7..0] Clock SelectBit rate setting example is shown in Table             */
            __IOM uint16_t CKS : 2;    /*!< [9..8] Clock Select                                                       */
            uint16_t           : 2;
            __IOM uint16_t CHL : 3;    /*!< [14..12] Character Length                                                 */
            uint16_t           : 1;
        } CNFR1_b;
    };

    union
    {
        __IOM uint16_t CNFR2;          /*!< (@ 0x00000014) DALI Configuration Register 2                              */

        struct
        {
            __IOM uint16_t BTVE : 1;   /*!< [0..0] Bit Timing Violation EnableNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t BTVM : 1;   /*!< [1..1] Bit Timing Violation ModeNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t SGA : 1;    /*!< [2..2] Save an Edge of Gray Area ModeNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t TXWE : 1;   /*!< [3..3] DTX Width Modulation EnableNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t CDE : 1;    /*!< [4..4] Collision Detect EnableNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t CDM0 : 1;   /*!< [5..5] Collision Detect ModeNote: The bit must be modified only
                                        *   when the DALI0.STR1.BBF bit is 0.                                         */
            uint16_t : 10;
        } CNFR2_b;
    };

    union
    {
        __IOM uint16_t TXWR1;          /*!< (@ 0x00000016) DALI DTX Width Register 1                                  */

        struct
        {
            __IOM uint16_t TXLW : 7;   /*!< [6..0] DTX Low WidthDTX0 pin low level width                              */
            uint16_t            : 9;
        } TXWR1_b;
    };
    __IM uint16_t RESERVED[3];

    union
    {
        __IOM uint16_t TDR1H;          /*!< (@ 0x0000001E) DALI Transmit Data Register 1H                             */

        struct
        {
            __IOM uint16_t DTDR : 16;  /*!< [15..0] Upper 16-bit DALI transmit data                                   */
        } TDR1H_b;
    };

    union
    {
        __IOM uint16_t TDR1L;          /*!< (@ 0x00000020) DALI Transmit Data Register 1L                             */

        struct
        {
            __IOM uint16_t DTDR : 16;  /*!< [15..0] Lower 16-bit DALI transmit data                                   */
        } TDR1L_b;
    };

    union
    {
        __OM uint16_t TRSTR1;          /*!< (@ 0x00000022) DALI Transmit Control Register 1                           */

        struct
        {
            __OM uint16_t TRST : 1;    /*!< [0..0] Transmission Start Trigger                                         */
            uint16_t           : 15;
        } TRSTR1_b;
    };
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t CTR1;           /*!< (@ 0x00000026) DALI Control Register 1                                    */

        struct
        {
            __IOM uint16_t TE   : 1;   /*!< [0..0] Transmit Enabling                                                  */
            __IOM uint16_t RE   : 1;   /*!< [1..1] Receive Enabling                                                   */
            uint16_t            : 6;
            __IOM uint16_t SDIE : 1;   /*!< [8..8] DALI_SDI Output Enabling                                           */
            __IOM uint16_t DEIE : 1;   /*!< [9..9] DALI_DEI Output Enabling                                           */
            __IOM uint16_t CLIE : 1;   /*!< [10..10] DALI_CLI Output Enabling                                         */
            __IOM uint16_t BPIE : 1;   /*!< [11..11] DALI_BPI Output Enabling                                         */
            __IOM uint16_t FEIE : 1;   /*!< [12..12] DALI_FEI Output Enabling                                         */
            uint16_t            : 3;
        } CTR1_b;
    };

    union
    {
        __IOM uint16_t TXDCTR1;        /*!< (@ 0x00000028) DALI DTX Control Register 1                                */

        struct
        {
            __IOM uint16_t TXAS : 1;   /*!< [0..0] DTX Assert LevelNote 1. The bit must be modified only
                                        *   when the DALI0.CTR1.TE bit is 0.                                          */
            __IOM uint16_t TXASE : 1;  /*!< [1..1] DTX Assert EnablingNote 1. The bit must be modified only
                                        *   when the DALI0.CTR1.TE bit is 0.                                          */
            uint16_t : 14;
        } TXDCTR1_b;
    };
    __IM uint16_t RESERVED2[2];

    union
    {
        __IM uint16_t RDR1H;           /*!< (@ 0x0000002E) DALI Reception Data Register 1H                            */

        struct
        {
            __IM uint16_t DRDR : 16;   /*!< [15..0] Upper 16-bit of DALI receive data                                 */
        } RDR1H_b;
    };

    union
    {
        __IM uint16_t RDR1L;           /*!< (@ 0x00000030) DALI Reception Data Register 1L                            */

        struct
        {
            __IM uint16_t DRDR : 16;   /*!< [15..0] Lower 16-bit of DALI receive data                                 */
        } RDR1L_b;
    };

    union
    {
        __IM uint16_t STR1;            /*!< (@ 0x00000032) DALI Status Register 1                                     */

        struct
        {
            __IM uint16_t MFEF  : 1;   /*!< [0..0] Manchester Flaming Error Flag                                      */
            __IM uint16_t OVF   : 1;   /*!< [1..1] Overrun Error Flag                                                 */
            __IM uint16_t BTVF  : 1;   /*!< [2..2] Bit Timing Violation Flag                                          */
            __IM uint16_t RDRF  : 1;   /*!< [3..3] Receive Data Register Full Flag                                    */
            __IM uint16_t TENDF : 1;   /*!< [4..4] Transmit End Flag                                                  */
            __IM uint16_t BBF   : 1;   /*!< [5..5] Bus BUSY Flag                                                      */
            __IM uint16_t BPDF  : 1;   /*!< [6..6] Bus Power Down Flag                                                */
            __IM uint16_t O32F  : 1;   /*!< [7..7] Over 32-Bit Data Reception Flag                                    */
            __IM uint16_t CDF   : 1;   /*!< [8..8] Collision Detect Flag                                              */
            __IM uint16_t DAF   : 1;   /*!< [9..9] Destroy Area Flag                                                  */
            __IM uint16_t RDBL  : 6;   /*!< [15..10] Receive Data Bit LengthThese bits store the bit length
                                        *   for data received successfully                                            */
        } STR1_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IM uint16_t COLR1;           /*!< (@ 0x00000036) DALI Collision Register 1                                  */

        struct
        {
            __IM uint16_t CFTF2  : 4;  /*!< [3..0] Collision Detect Timing Flag 2                                     */
            __IM uint16_t CDTF1  : 1;  /*!< [4..4] Collision Detect Timing Flag 1                                     */
            uint16_t             : 5;
            __IM uint16_t CLDAF  : 1;  /*!< [10..10] Collision Last Destroy Area Flag                                 */
            __IM uint16_t RXDMON : 1;  /*!< [11..11] DRX MonitorThis bit monitors the DRX0 pin value after
                                        *   the DRX0 pin is synchronized                                              */
            __IM uint16_t RXDCEG : 1;  /*!< [12..12] DRX Collision Edge                                               */
            __IM uint16_t TXDCV  : 1;  /*!< [13..13] DTX Collision Value                                              */
            uint16_t             : 2;
        } COLR1_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __OM uint16_t FECR1;           /*!< (@ 0x0000003A) DALI Flag Error Clear Register 1                           */

        struct
        {
            __OM uint16_t MFEFC  : 1;  /*!< [0..0] Manchester Flaming Error Flag Clear                                */
            __OM uint16_t OVFC   : 1;  /*!< [1..1] Overrun Error Flag Clear                                           */
            __OM uint16_t BTVFC  : 1;  /*!< [2..2] Bit Timing Violation Flag Clear                                    */
            __OM uint16_t RDRFC  : 1;  /*!< [3..3] Receive Data Register Full Flag Clear                              */
            __OM uint16_t TENDFC : 1;  /*!< [4..4] Transmit End Flag Clear                                            */
            __OM uint16_t BBFC   : 1;  /*!< [5..5] Bus BUSY Flag ClearNote1: Do not clear DALI0.STR1.BBF
                                        *   bit when DALI0.CTR1.TE bit or DALI0.CTR1.RE bit is 1.                     */
            __OM uint16_t BPDFC : 1;   /*!< [6..6] Bus Power Down Flag Clear                                          */
            __OM uint16_t O32FC : 1;   /*!< [7..7] Over 32-Bit Data Reception Flag Clear                              */
            __OM uint16_t CDFC  : 1;   /*!< [8..8] Collision Detect Flag Clear                                        */
            __OM uint16_t DAFC  : 1;   /*!< [9..9] Destroy Area Flag Clear                                            */
            uint16_t            : 6;
        } FECR1_b;
    };

    union
    {
        __OM uint16_t SWRR1;           /*!< (@ 0x0000003C) DALI Software Reset Register 1                             */

        struct
        {
            __OM uint16_t SWR : 1;     /*!< [0..0] Software ResetWriting 1 to this bit causes a software
                                        *   reset.                                                                    */
            uint16_t : 15;
        } SWRR1_b;
    };
} R_DALI0_Type;                        /*!< Size = 62 (0x3e)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_DEBUG                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Debug Function (R_DEBUG)
 */

typedef struct                         /*!< (@ 0x4001B000) R_DEBUG Structure                                          */
{
    union
    {
        __IM uint32_t DBGSTR;          /*!< (@ 0x00000000) Debug Status Register                                      */

        struct
        {
            uint32_t                   : 28;
            __IM uint32_t CDBGPWRUPREQ : 1; /*!< [28..28] Debug power-up request                                           */
            __IM uint32_t CDBGPWRUPACK : 1; /*!< [29..29] Debug power-up acknowledge                                       */
            uint32_t                   : 2;
        } DBGSTR_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t DBGSTOPCR;             /*!< (@ 0x00000010) Debug Stop Control Register                                */

        struct
        {
            __IOM uint32_t DBGSTOP_IWDT  : 1; /*!< [0..0] Mask bit for IWDT reset/interrupt                                  */
            __IOM uint32_t DBGSTOP_WDT   : 1; /*!< [1..1] Mask bit for WDT reset/interrupt                                   */
            uint32_t                     : 14;
            __IOM uint32_t DBGSTOP_LVD0  : 1; /*!< [16..16] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD1  : 1; /*!< [17..17] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD2  : 1; /*!< [18..18] Mask bit for LVD reset/interupt                                  */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_RPER  : 1; /*!< [24..24] Mask bit for SRAM parity error                                   */
            __IOM uint32_t DBGSTOP_RECCR : 1; /*!< [25..25] Mask bit for SRAM ECC error                                      */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_CPER  : 1; /*!< [31..31] Mask bit for Cache SRAM parity error reset/interrupt             */
        } DBGSTOPCR_b;
    };
} R_DEBUG_Type;                               /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DMA                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief DMA Controller Common (R_DMA)
 */

typedef struct                         /*!< (@ 0x40005200) R_DMA Structure                                            */
{
    union
    {
        __IOM uint8_t DMAST;           /*!< (@ 0x00000000) DMAC Module Activation Register                            */

        struct
        {
            __IOM uint8_t DMST : 1;    /*!< [0..0] DMAC Operation Enable                                              */
            uint8_t            : 7;
        } DMAST_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[15];

    union
    {
        __IOM uint32_t DMECHR;          /*!< (@ 0x00000040) DMAC Error Channel Register                                */

        struct
        {
            __IM uint32_t DMECH    : 3; /*!< [2..0] DMAC Error channel                                                 */
            uint32_t               : 5;
            __IM uint32_t DMECHSAM : 1; /*!< [8..8] DMAC Error channel Security Attribution Monitor                    */
            uint32_t               : 7;
            __IOM uint32_t DMESTA  : 1; /*!< [16..16] DMAC Error Status                                                */
            uint32_t               : 15;
        } DMECHR_b;
    };
} R_DMA_Type;                           /*!< Size = 68 (0x44)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_DMAC0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief DMA Controller (R_DMAC0)
 */

typedef struct                         /*!< (@ 0x40005000) R_DMAC0 Structure                                          */
{
    union
    {
        __IOM uint32_t DMSAR;          /*!< (@ 0x00000000) DMA Source Address Register                                */

        struct
        {
            __IOM uint32_t DMSAR : 32; /*!< [31..0] Specifies the transfer source start address.                      */
        } DMSAR_b;
    };

    union
    {
        __IOM uint32_t DMDAR;          /*!< (@ 0x00000004) DMA Destination Address Register                           */

        struct
        {
            __IOM uint32_t DMDAR : 32; /*!< [31..0] Specifies the transfer destination start address.                 */
        } DMDAR_b;
    };

    union
    {
        __IOM uint32_t DMCRA;           /*!< (@ 0x00000008) DMA Transfer Count Register                                */

        struct
        {
            __IOM uint32_t DMCRAL : 16; /*!< [15..0] Lower bits of transfer count                                      */
            __IOM uint32_t DMCRAH : 10; /*!< [25..16] Upper bits of transfer count                                     */
            uint32_t              : 6;
        } DMCRA_b;
    };

    union
    {
        __IOM uint16_t DMCRB;          /*!< (@ 0x0000000C) DMA Block Transfer Count Register                          */

        struct
        {
            __IOM uint16_t DMCRB : 16; /*!< [15..0] Specifies the number of block transfer operations or
                                        *   repeat transfer operations.                                               */
        } DMCRB_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t DMTMD;          /*!< (@ 0x00000010) DMA Transfer Mode Register                                 */

        struct
        {
            __IOM uint16_t DCTG : 2;   /*!< [1..0] Transfer Request Source Select                                     */
            uint16_t            : 6;
            __IOM uint16_t SZ   : 2;   /*!< [9..8] Transfer Data Size Select                                          */
            __IOM uint16_t TKP  : 1;   /*!< [10..10] Transfer Keeping                                                 */
            uint16_t            : 1;
            __IOM uint16_t DTS  : 2;   /*!< [13..12] Repeat Area Select                                               */
            __IOM uint16_t MD   : 2;   /*!< [15..14] Transfer Mode Select                                             */
        } DMTMD_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t DMINT;           /*!< (@ 0x00000013) DMA Interrupt Setting Register                             */

        struct
        {
            __IOM uint8_t DARIE : 1;   /*!< [0..0] Destination Address Extended Repeat Area Overflow Interrupt
                                        *   Enable                                                                    */
            __IOM uint8_t SARIE : 1;   /*!< [1..1] Source Address Extended Repeat Area Overflow Interrupt
                                        *   Enable                                                                    */
            __IOM uint8_t RPTIE : 1;   /*!< [2..2] Repeat Size End Interrupt Enable                                   */
            __IOM uint8_t ESIE  : 1;   /*!< [3..3] Transfer Escape End Interrupt Enable                               */
            __IOM uint8_t DTIE  : 1;   /*!< [4..4] Transfer End Interrupt Enable                                      */
            uint8_t             : 3;
        } DMINT_b;
    };

    union
    {
        __IOM uint16_t DMAMD;          /*!< (@ 0x00000014) DMA Address Mode Register                                  */

        struct
        {
            __IOM uint16_t DARA : 5;   /*!< [4..0] Destination Address Extended Repeat Area Specifies the
                                        *   extended repeat area on the destination address. For details
                                        *   on the settings.                                                          */
            __IOM uint16_t DADR : 1;   /*!< [5..5] Destination Address Update Select After Reload                     */
            __IOM uint16_t DM   : 2;   /*!< [7..6] Destination Address Update Mode                                    */
            __IOM uint16_t SARA : 5;   /*!< [12..8] Source Address Extended Repeat Area Specifies the extended
                                        *   repeat area on the source address. For details on the settings.           */
            __IOM uint16_t SADR : 1;   /*!< [13..13] Source Address Update Select After Reload                        */
            __IOM uint16_t SM   : 2;   /*!< [15..14] Source Address Update Mode                                       */
        } DMAMD_b;
    };
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint32_t DMOFR;          /*!< (@ 0x00000018) DMA Offset Register                                        */

        struct
        {
            __IOM uint32_t DMOFR : 32; /*!< [31..0] Specifies the offset when offset addition is selected
                                        *   as the address update mode for transfer source or destination.            */
        } DMOFR_b;
    };

    union
    {
        __IOM uint8_t DMCNT;           /*!< (@ 0x0000001C) DMA Transfer Enable Register                               */

        struct
        {
            __IOM uint8_t DTE : 1;     /*!< [0..0] DMA Transfer Enable                                                */
            uint8_t           : 7;
        } DMCNT_b;
    };

    union
    {
        __IOM uint8_t DMREQ;           /*!< (@ 0x0000001D) DMA Software Start Register                                */

        struct
        {
            __IOM uint8_t SWREQ : 1;   /*!< [0..0] DMA Software Start                                                 */
            uint8_t             : 3;
            __IOM uint8_t CLRS  : 1;   /*!< [4..4] DMA Software Start Bit Auto Clear Select                           */
            uint8_t             : 3;
        } DMREQ_b;
    };

    union
    {
        __IOM uint8_t DMSTS;            /*!< (@ 0x0000001E) DMA Status Register                                        */

        struct
        {
            __IOM uint8_t ESIF : 1;     /*!< [0..0] Transfer Escape End Interrupt Flag                                 */
            uint8_t            : 3;
            __IOM uint8_t DTIF : 1;     /*!< [4..4] Transfer End Interrupt Flag                                        */
            uint8_t            : 2;
            __IM uint8_t ACT   : 1;     /*!< [7..7] DMA Active Flag                                                    */
        } DMSTS_b;
    };
    __IM uint8_t   RESERVED3;
    __IOM uint32_t DMSRR;               /*!< (@ 0x00000020) DMA Source Reload Address Register                         */
    __IOM uint32_t DMDRR;               /*!< (@ 0x00000024) DMA Destination Reload Address Register                    */

    union
    {
        __IOM uint32_t DMSBS;           /*!< (@ 0x00000028) DMA Source Buffer Size Register                            */

        struct
        {
            __IOM uint32_t DMSBSL : 16; /*!< [15..0] Functions as data transfer counter in repeat-block transfer
                                         *   mode                                                                      */
            __IOM uint32_t DMSBSH : 16; /*!< [31..16] Specifies the repeat-area size in repeat-block transfer
                                         *   mode                                                                      */
        } DMSBS_b;
    };

    union
    {
        __IOM uint32_t DMDBS;           /*!< (@ 0x0000002C) DMA Destination Buffer Size Register                       */

        struct
        {
            __IOM uint32_t DMDBSL : 16; /*!< [15..0] Functions as data transfer counter in repeat-block transfer
                                         *   mode                                                                      */
            __IOM uint32_t DMDBSH : 16; /*!< [31..16] Specifies the repeat-area size in repeat-block transfer
                                         *   mode                                                                      */
        } DMDBS_b;
    };

    union
    {
        __IOM uint8_t DMBWR;           /*!< (@ 0x00000030) DMA Bufferable Write Enable Register                       */

        struct
        {
            __IOM uint8_t BWE : 1;     /*!< [0..0] Bufferable Write Enable                                            */
            uint8_t           : 7;
        } DMBWR_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint16_t RESERVED5;
} R_DMAC0_Type;                        /*!< Size = 52 (0x34)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DOC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Operation Circuit (R_DOC)
 */

typedef struct                         /*!< (@ 0x40054100) R_DOC Structure                                            */
{
    union
    {
        __IOM uint8_t DOCR;            /*!< (@ 0x00000000) DOC Control Register                                       */

        struct
        {
            __IOM uint8_t OMS     : 2; /*!< [1..0] Operating Mode Select                                              */
            __IOM uint8_t DCSEL   : 1; /*!< [2..2] Detection Condition Select                                         */
            uint8_t               : 2;
            __IM uint8_t  DOPCF   : 1; /*!< [5..5] Data Operation Circuit Flag                                        */
            __IOM uint8_t DOPCFCL : 1; /*!< [6..6] DOPCF Clear                                                        */
            uint8_t               : 1;
        } DOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t DODIR;          /*!< (@ 0x00000002) DOC Data Input Register                                    */

        struct
        {
            __IOM uint16_t DODIR : 16; /*!< [15..0] 16-bit read-write register in which 16-bit data for
                                        *   use in the operations are stored.                                         */
        } DODIR_b;
    };

    union
    {
        __IOM uint16_t DODSR;          /*!< (@ 0x00000004) DOC Data Setting Register                                  */

        struct
        {
            __IOM uint16_t DODSR : 16; /*!< [15..0] This register stores 16-bit data for use as a reference
                                        *   in data comparison mode. This register also stores the
                                        *   results of operations in data addition and data subtraction
                                        *   modes.                                                                    */
        } DODSR_b;
    };
} R_DOC_Type;                          /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_DRW                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief 2D Drawing Engine (R_DRW)
 */

typedef struct                         /*!< (@ 0x400E4000) R_DRW Structure                                            */
{
    union
    {
        union
        {
            __OM uint32_t CONTROL;               /*!< (@ 0x00000000) Geometry Control Register                                  */

            struct
            {
                __OM uint32_t LIM1ENABLE    : 1; /*!< [0..0] Enable limiter 1                                                   */
                __OM uint32_t LIM2ENABLE    : 1; /*!< [1..1] Enable limiter 2                                                   */
                __OM uint32_t LIM3ENABLE    : 1; /*!< [2..2] Enable limiter 3                                                   */
                __OM uint32_t LIM4ENABLE    : 1; /*!< [3..3] Enable limiter 4                                                   */
                __OM uint32_t LIM5ENABLE    : 1; /*!< [4..4] Enable limiter 5                                                   */
                __OM uint32_t LIM6ENABLE    : 1; /*!< [5..5] Enable limiter 6                                                   */
                __OM uint32_t QUAD1ENABLE   : 1; /*!< [6..6] Enable quadratic coupling of limiters 1 and 2                      */
                __OM uint32_t QUAD2ENABLE   : 1; /*!< [7..7] Enable quadratic coupling of limiters 3 and 4                      */
                __OM uint32_t QUAD3ENABLE   : 1; /*!< [8..8] Enable quadratic coupling of limiters 5 and 6                      */
                __OM uint32_t LIM1THRESHOLD : 1; /*!< [9..9] Enable limiter 1 threshold mode                                    */
                __OM uint32_t LIM2THRESHOLD : 1; /*!< [10..10] Enable limiter 2 threshold mode                                  */
                __OM uint32_t LIM3THRESHOLD : 1; /*!< [11..11] Enable limiter 3 threshold mode                                  */
                __OM uint32_t LIM4THRESHOLD : 1; /*!< [12..12] Enable limiter 4 threshold mode                                  */
                __OM uint32_t LIM5THRESHOLD : 1; /*!< [13..13] Enable limiter 5 threshold mode                                  */
                __OM uint32_t LIM6THRESHOLD : 1; /*!< [14..14] Enable limiter 6 threshold mode                                  */
                __OM uint32_t BAND1ENABLE   : 1; /*!< [15..15] Enable band postprocess for limiter 1 (see L1BAND)               */
                __OM uint32_t BAND2ENABLE   : 1; /*!< [16..16] Enable band postprocess for limiter 1 (see L1BAND)               */
                __OM uint32_t UNION12       : 1; /*!< [17..17] Combine limter 1 & 2 as union (output is called A)               */
                __OM uint32_t UNION34       : 1; /*!< [18..18] Combine limter 3 & 4 as union (output is called B)               */
                __OM uint32_t UNION56       : 1; /*!< [19..19] Combine limter 5 & 6 as union (output is called D)               */
                __OM uint32_t UNIONAB       : 1; /*!< [20..20] Combine outputs A & B as union (output is called C)              */
                __OM uint32_t UNIONCD       : 1; /*!< [21..21] Combine outputs C & D as union (output is final)                 */
                __OM uint32_t SPANABORT     : 1; /*!< [22..22] Shape is horizontally convex, only a single span per
                                                  *   scanline                                                                  */
                __OM uint32_t SPANSTORE : 1;     /*!< [23..23] Nextline span start is always equal or left to current-line
                                                  *   span start                                                                */
                uint32_t : 8;
            } CONTROL_b;
        };

        union
        {
            __IM uint32_t STATUS;               /*!< (@ 0x00000000) Status Control Register                                    */

            struct
            {
                __IM uint32_t BUSYENUM     : 1; /*!< [0..0] Enumeration unit status                                            */
                __IM uint32_t BUSYWRITE    : 1; /*!< [1..1] Framebuffer writeback status                                       */
                __IM uint32_t CACHEDIRTY   : 1; /*!< [2..2] Framebuffer cache status                                           */
                __IM uint32_t DLISTACTIVE  : 1; /*!< [3..3] Display list reader status                                         */
                __IM uint32_t ENUMIRQ      : 1; /*!< [4..4] enumeration finished interrupt triggered                           */
                __IM uint32_t DLISTIRQ     : 1; /*!< [5..5] display list finished interrupt triggered                          */
                __IM uint32_t BUSIRQ       : 1; /*!< [6..6] bus error interrupt triggered                                      */
                uint32_t                   : 1;
                __IM uint32_t BUSERRMFB    : 1; /*!< [8..8] framebuffer bus error interrupt triggered                          */
                __IM uint32_t BUSERRMTXMRL : 1; /*!< [9..9] texture bus error interrupt triggered                              */
                __IM uint32_t BUSERRMDL    : 1; /*!< [10..10] display list bus error interrupt triggered                       */
                uint32_t                   : 21;
            } STATUS_b;
        };
    };

    union
    {
        union
        {
            __OM uint32_t CONTROL2;                /*!< (@ 0x00000004) Surface Control Register                                   */

            struct
            {
                __OM uint32_t PATTERNENABLE : 1;   /*!< [0..0] Pixel source is a pattern color (blend of COLOR1 and
                                                    *   COLOR2 depending on PATTERN and pattern index)                            */
                __OM uint32_t TEXTUREENABLE : 1;   /*!< [1..1] Pixel source is read from texture and used as an alpha
                                                    *   to blend between COLOR1 and COLOR2                                        */
                __OM uint32_t PATTERNSOURCEL5 : 1; /*!< [2..2] Limiter 5 is used as pattern index instead of the default
                                                    *   U limiter.Limiter 5 can be combined with limiter 6 to form
                                                    *   a quadratic limiter which can be used to make quadratic
                                                    *   pattern functions to draw radial patterns.                                */
                __OM uint32_t USEACB       : 1;    /*!< [3..3] Alpha blend mode                                                   */
                __OM uint32_t READFORMAT32 : 2;    /*!< [5..4] Bit 4 and 3 of the texture buffer format.See READFORMAT
                                                    *   above for description                                                     */
                __OM uint32_t BSFA : 1;            /*!< [6..6] Blend source factor for alpha channel in alpha channel
                                                    *   blending mode (USEACB = 1)                                                */
                __OM uint32_t BDFA : 1;            /*!< [7..7] Blend destinetion factor for alpha channel in alpha channel
                                                    *   blending mode (USEACB = 1)                                                */
                __OM uint32_t WRITEFORMAT2 : 1;    /*!< [8..8] Bit 3 of framebuffer pixel formatSee WRITEFORMAT above
                                                    *   description.                                                              */
                __OM uint32_t BSF : 1;             /*!< [9..9] Blend source factorsrc factor is alpha (factor is 1 per
                                                    *   default)                                                                  */
                __OM uint32_t BDF : 1;             /*!< [10..10] Blend destination factordst factor is alpha (factor
                                                    *   is 1 per default)                                                         */
                __OM uint32_t BSI : 1;             /*!< [11..11] Blend source factor is invertedsrc factor will be inverted
                                                    *   (meaning 1-a or 1-1 depending on BSF)                                     */
                __OM uint32_t BDI : 1;             /*!< [12..12] Blend destination factor is inverteddst factor will
                                                    *   be inverted (meaning 1-a or 1-1 depending on BDF)                         */
                __OM uint32_t BC2           : 1;   /*!< [13..13] Blend color 2 instead of framebuffer pixel                       */
                __OM uint32_t TEXTURECLAMPX : 1;   /*!< [14..14] Calculating U limiter outside use textureThe bit describes
                                                    *   what happens if the U limiter (x direction in texture space)
                                                    *   calculates a U value outside of the used texture                          */
                __OM uint32_t TEXTURECLAMPY : 1;   /*!< [15..15] Calculating V limiter outside use textureThe bit describes
                                                    *   what happens if the V limiter (y direction in texture space)
                                                    *   calculates a V value outside of the used texture                          */
                __OM uint32_t TEXTUREFILTERX : 1;  /*!< [16..16] Linear filtering on texture U axis                               */
                __OM uint32_t TEXTUREFILTERY : 1;  /*!< [17..17] Linear filtering on texture V axis                               */
                __OM uint32_t READFORMAT10   : 2;  /*!< [19..18] Pixel format of the texture buffer{READFORMAT32,READFORMAT10}0000:
                                                    *   8 bpp a(8)0001: 16 bpp RGB(565)0010: 32 bpp aRGB(8888)0011:
                                                    *   16 bpp aRGB(4444)0100: 16 bpp aRGB(1555)0101: 8 bpp aCLUT(44)
                                                    *   4 bit alpha and 4 bit indexed color1001: 8 bpp CLUT(8)/I(8),
                                                    *   8 bit indexed color/luminance1010: 4 bpp CLUT(4)/I(4),
                                                    *   4 bit indexed color/luminance1011: 2 bpp CLUT(2)/I(2),
                                                    *   2 bit indexed color/luminance 1100: 1 bpp CLUT(1)/I(1),
                                                    *   1 bit indexed color/luminance                                             */
                __OM uint32_t WRITEFORMAT10 : 2;   /*!< [21..20] Pixel format of the framebuffer                                  */
                __OM uint32_t WRITEALPHA    : 2;   /*!< [23..22] Writeback alpha source for framebufferSet the 'alpha
                                                    *   source' for the framebuffer(USEACB = 0)Blend alpha in color
                                                    *   2 instead of framebuffer alpha((USEACB = 1))In not alpha
                                                    *   channel blending mode (USEACB = 0):Set the 'alpha source'
                                                    *   for the framebuffer.In alpha channel blending mode (USEACB
                                                    *   = 1):Blend alpha in color 2 instead of framebuffer alpha00B:
                                                    *   BC2A = 1: use alpha from framebuffer as destination (DST_A)else:
                                                    *   BC2A = 0: use alpha in color 2 as destination (DST_A)                     */
                __OM uint32_t RLEENABLE    : 1;    /*!< [24..24] RLE enable                                                       */
                __OM uint32_t CLUTENABLE   : 1;    /*!< [25..25] CLUT enable                                                      */
                __OM uint32_t COLKEYENABLE : 1;    /*!< [26..26] color keying enable                                              */
                __OM uint32_t CLUTFORMAT   : 1;    /*!< [27..27] Format of the CLUT                                               */
                __OM uint32_t BSIA         : 1;    /*!< [28..28] Blend source factor inverted in alpha channel (USEACB
                                                    *   = 1)                                                                      */
                __OM uint32_t BDIA : 1;            /*!< [29..29] Blend destination factor inverted in alpha channel
                                                    *   (USEACB = 1)                                                              */
                __OM uint32_t RLEPIXELWIDTH : 2;   /*!< [31..30] Texel width for RLE unit                                         */
            } CONTROL2_b;
        };

        union
        {
            __IM uint32_t HWREVISION;          /*!< (@ 0x00000004) Hardware Version and Feature Set ID Register               */

            struct
            {
                __IM uint32_t REV        : 12; /*!< [11..0] Revision number                                                   */
                uint32_t                 : 5;
                __IM uint32_t DLR        : 1;  /*!< [17..17] Display list reader feature                                      */
                __IM uint32_t FBCACHE    : 1;  /*!< [18..18] Framebuffer cache feature                                        */
                __IM uint32_t TXCACHE    : 1;  /*!< [19..19] Texture cache feature                                            */
                __IM uint32_t PERFCOUNT  : 1;  /*!< [20..20] Two performance counter feature                                  */
                __IM uint32_t TEXCLU     : 1;  /*!< [21..21] Texture CLUT with 16 or 256 entries feature                      */
                uint32_t                 : 1;
                __IM uint32_t RLEUNIT    : 1;  /*!< [23..23] RLE unit feature                                                 */
                __IM uint32_t TEXCLUT256 : 1;  /*!< [24..24] Texture CLUT feature                                             */
                __IM uint32_t COLORKEY   : 1;  /*!< [25..25] Colorkey feature                                                 */
                uint32_t                 : 1;
                __IM uint32_t ACBLEND    : 1;  /*!< [27..27] Alpha channel blending feature                                   */
                uint32_t                 : 4;
            } HWREVISION_b;
        };
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __OM uint32_t L1START;         /*!< (@ 0x00000010) Limiter 1 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L1START_b;
    };

    union
    {
        __OM uint32_t L2START;         /*!< (@ 0x00000014) Limiter 2 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L2START_b;
    };

    union
    {
        __OM uint32_t L3START;         /*!< (@ 0x00000018) Limiter 3 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L3START_b;
    };

    union
    {
        __OM uint32_t L4START;         /*!< (@ 0x0000001C) Limiter 4 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L4START_b;
    };

    union
    {
        __OM uint32_t L5START;         /*!< (@ 0x00000020) Limiter 5 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L5START_b;
    };

    union
    {
        __OM uint32_t L6START;         /*!< (@ 0x00000024) Limiter 6 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L6START_b;
    };

    union
    {
        __OM uint32_t L1XADD;          /*!< (@ 0x00000028) Limiter 1 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L1XADD_b;
    };

    union
    {
        __OM uint32_t L2XADD;          /*!< (@ 0x0000002C) Limiter 2 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L2XADD_b;
    };

    union
    {
        __OM uint32_t L3XADD;          /*!< (@ 0x00000030) Limiter 3 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L3XADD_b;
    };

    union
    {
        __OM uint32_t L4XADD;          /*!< (@ 0x00000034) Limiter 4 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L4XADD_b;
    };

    union
    {
        __OM uint32_t L5XADD;          /*!< (@ 0x00000038) Limiter 5 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L5XADD_b;
    };

    union
    {
        __OM uint32_t L6XADD;          /*!< (@ 0x0000003C) Limiter 6 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L6XADD_b;
    };

    union
    {
        __OM uint32_t L1YADD;          /*!< (@ 0x00000040) Limiter 1 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L1YADD_b;
    };

    union
    {
        __OM uint32_t L2YADD;          /*!< (@ 0x00000044) Limiter 2 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L2YADD_b;
    };

    union
    {
        __OM uint32_t L3YADD;          /*!< (@ 0x00000048) Limiter 3 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L3YADD_b;
    };

    union
    {
        __OM uint32_t L4YADD;          /*!< (@ 0x0000004C) Limiter 4 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L4YADD_b;
    };

    union
    {
        __OM uint32_t L5YADD;          /*!< (@ 0x00000050) Limiter 5 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L5YADD_b;
    };

    union
    {
        __OM uint32_t L6YADD;          /*!< (@ 0x00000054) Limiter 6 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L6YADD_b;
    };

    union
    {
        __OM uint32_t L1BAND;          /*!< (@ 0x00000058) Limiter 1 Band Width Parameter Register                    */

        struct
        {
            __OM uint32_t LBAND : 32;  /*!< [31..0] Limiter m band width parameter                                    */
        } L1BAND_b;
    };

    union
    {
        __OM uint32_t L2BAND;          /*!< (@ 0x0000005C) Limiter 2 Band Width Parameter Register                    */

        struct
        {
            __OM uint32_t LBAND : 32;  /*!< [31..0] Limiter m band width parameter                                    */
        } L2BAND_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __OM uint32_t COLOR1;          /*!< (@ 0x00000064) Base Color Register                                        */

        struct
        {
            __OM uint32_t COLOR1B : 8; /*!< [7..0] Blue channel of color 1                                            */
            __OM uint32_t COLOR1G : 8; /*!< [15..8] Green channel of color 1                                          */
            __OM uint32_t COLOR1R : 8; /*!< [23..16] Red channel of color 1                                           */
            __OM uint32_t COLOR1A : 8; /*!< [31..24] Alpha channel of color 1(0x00: transparent. . . 0xFF:
                                        *   opaque)                                                                   */
        } COLOR1_b;
    };

    union
    {
        __OM uint32_t COLOR2;          /*!< (@ 0x00000068) Secondary Color Register                                   */

        struct
        {
            __OM uint32_t COLOR2B : 8; /*!< [7..0] Blue channel of color 2                                            */
            __OM uint32_t COLOR2G : 8; /*!< [15..8] Green channel of color 2                                          */
            __OM uint32_t COLOR2R : 8; /*!< [23..16] Red channel of color 2                                           */
            __OM uint32_t COLOR2A : 8; /*!< [31..24] Alpha channel of color 2(0x00: transparent. . . 0xFF:
                                        *   opaque)                                                                   */
        } COLOR2_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __OM uint32_t PATTERN;         /*!< (@ 0x00000074) Pattern Register                                           */

        struct
        {
            __OM uint32_t PATTERN : 8; /*!< [7..0] Bitmap of the pattern                                              */
            uint32_t              : 24;
        } PATTERN_b;
    };

    union
    {
        __OM uint32_t SIZE;            /*!< (@ 0x00000078) Bounding Box Dimension Register                            */

        struct
        {
            __OM uint32_t SIZEX : 16;  /*!< [15..0] Width of the bounding box in pixelsvalid range: 0 to
                                        *   1024                                                                      */
            __OM uint32_t SIZEY : 16;  /*!< [31..16] Height of the bounding box in pixelsvalid range: 0
                                        *   to 1024                                                                   */
        } SIZE_b;
    };

    union
    {
        __OM uint32_t PITCH;           /*!< (@ 0x0000007C) Framebuffer Pitch And Spanstore Delay Register             */

        struct
        {
            __OM uint32_t PITCH : 16;  /*!< [15..0] pitch of the framebuffer. A negative width can be used
                                        *   to render bottom-up instead of top-down                                   */
            __OM uint32_t SSD : 16;    /*!< [31..16] Spanstore delay                                                  */
        } PITCH_b;
    };

    union
    {
        __OM uint32_t ORIGIN;          /*!< (@ 0x00000080) Framebuffer Base Address Register                          */

        struct
        {
            __OM uint32_t ORIGIN : 32; /*!< [31..0] Address of the first pixel in framebuffer                         */
        } ORIGIN_b;
    };
    __IM uint32_t RESERVED3[3];

    union
    {
        __OM uint32_t LUSTART;          /*!< (@ 0x00000090) U Limiter Start Value Register                             */

        struct
        {
            __OM uint32_t LUSTART : 32; /*!< [31..0] U limiter start value                                             */
        } LUSTART_b;
    };

    union
    {
        __OM uint32_t LUXADD;          /*!< (@ 0x00000094) U Limiter X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LUXADD : 32; /*!< [31..0] U limiter x-axis increment                                        */
        } LUXADD_b;
    };

    union
    {
        __OM uint32_t LUYADD;          /*!< (@ 0x00000098) U Limiter Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LUYADD : 32; /*!< [31..0] U limiter y-axis increment                                        */
        } LUYADD_b;
    };

    union
    {
        __OM uint32_t LVSTARTI;          /*!< (@ 0x0000009C) V Limiter Start Value Integer Part Register                */

        struct
        {
            __OM uint32_t LVSTARTI : 32; /*!< [31..0] V limiter start value integer part                                */
        } LVSTARTI_b;
    };

    union
    {
        __OM uint32_t LVSTARTF;          /*!< (@ 0x000000A0) V Limiter Start Value Fractional Part Register             */

        struct
        {
            __OM uint32_t LVSTARTF : 16; /*!< [15..0] V limiter start value fractional part                             */
            uint32_t               : 16;
        } LVSTARTF_b;
    };

    union
    {
        __OM uint32_t LVXADDI;          /*!< (@ 0x000000A4) V Limiter X-Axis Increment Integer Part Register           */

        struct
        {
            __OM uint32_t LVXADDI : 32; /*!< [31..0] V limiter x-axis increment integer part                           */
        } LVXADDI_b;
    };

    union
    {
        __OM uint32_t LVYADDI;          /*!< (@ 0x000000A8) V Limiter Y-Axis Increment Integer Part Register           */

        struct
        {
            __OM uint32_t LVYADDI : 32; /*!< [31..0] V limiter y-axis increment integer part                           */
        } LVYADDI_b;
    };

    union
    {
        __OM uint32_t LVYXADDF;         /*!< (@ 0x000000AC) V Limiter Increment Fractional Parts Register              */

        struct
        {
            __OM uint32_t LVXADDF : 16; /*!< [15..0] V xlimiter increment fractional part                              */
            __OM uint32_t LVYADDF : 16; /*!< [31..16] V y limiter increment fractional part                            */
        } LVYXADDF_b;
    };
    __IM uint32_t RESERVED4;

    union
    {
        __OM uint32_t TEXPITCH;          /*!< (@ 0x000000B4) Texels Per Texture Line Register                           */

        struct
        {
            __OM uint32_t TEXPITCH : 32; /*!< [31..0] Texels per texture linevalid range: 0 to 2048                     */
        } TEXPITCH_b;
    };

    union
    {
        __OM uint32_t TEXMASK;           /*!< (@ 0x000000B8) Texture Size or Texture Address Mask Register              */

        struct
        {
            __OM uint32_t TEXUMASK : 11; /*!< [10..0] U maskSet TEXUMASK[10:0] = texture_width -1In texture
                                          *   wrapping mode (CONTROL2.TEXTURECLAMPX = 0): texture_width
                                          *   must be a power of 2.In texture clamping mode (CONTROL2.TEXTURECLAMPX
                                          *   = 1):all widths up to 2048 are allowed.                                   */
            __OM uint32_t TEXVMASK : 21; /*!< [31..11] V maskSet TEXVMASK[20:0] = TEXPITCH * (texture_height
                                          *   - 1).In texture wrapping mode (CONTROL2.TEXTURECLAMPY =
                                          *   0): texture_height must be a power of 2In texture clamping
                                          *   mode (CONTROL2.TEXTURECLAMPY = 1):all heights up to 1024
                                          *   are allowed.                                                              */
        } TEXMASK_b;
    };

    union
    {
        __OM uint32_t TEXORIGIN;          /*!< (@ 0x000000BC) Texture Base Address Register                              */

        struct
        {
            __OM uint32_t TEXORIGIN : 32; /*!< [31..0] Texture base address                                              */
        } TEXORIGIN_b;
    };

    union
    {
        __OM uint32_t IRQCTL;              /*!< (@ 0x000000C0) Interrupt Control Register                                 */

        struct
        {
            __OM uint32_t ENUMIRQEN   : 1; /*!< [0..0] ENUMIRQ interrupt mask enable                                      */
            __OM uint32_t DLISTIRQEN  : 1; /*!< [1..1] DLISTIRQ interrupt mask enable                                     */
            __OM uint32_t ENUMIRQCLR  : 1; /*!< [2..2] Clear enumeration interrupt ENUMIRQ                                */
            __OM uint32_t DLISTIRQCLR : 1; /*!< [3..3] Clear display list interrupt DLISTIRQ                              */
            __OM uint32_t BUSIRQEN    : 1; /*!< [4..4] BUSIRQ interrupt mask enable                                       */
            __OM uint32_t BUSIRQCLR   : 1; /*!< [5..5] Clear bus error interrupt BUSIRQ                                   */
            uint32_t                  : 26;
        } IRQCTL_b;
    };

    union
    {
        __OM uint32_t CACHECTL;          /*!< (@ 0x000000C4) Cache Control Register                                     */

        struct
        {
            __OM uint32_t CENABLEFX : 1; /*!< [0..0] Framebuffer cache enable                                           */
            __OM uint32_t CFLUSHFX  : 1; /*!< [1..1] Flush framebuffer cache                                            */
            __OM uint32_t CENABLETX : 1; /*!< [2..2] Texture cache enable                                               */
            __OM uint32_t CFLUSHTX  : 1; /*!< [3..3] Flush texture cache                                                */
            uint32_t                : 28;
        } CACHECTL_b;
    };

    union
    {
        __OM uint32_t DLISTSTART;          /*!< (@ 0x000000C8) Display List Start Address Register                        */

        struct
        {
            __OM uint32_t DLISTSTART : 32; /*!< [31..0] Display list start address                                        */
        } DLISTSTART_b;
    };

    union
    {
        __IOM uint32_t PERFCOUNT1;         /*!< (@ 0x000000CC) Performance Counter 1                                      */

        struct
        {
            __IOM uint32_t PERFCOUNT : 32; /*!< [31..0] Counter value.The counter is reset by writing PERFCOUNT
                                            *   = 0000 0000H.                                                             */
        } PERFCOUNT1_b;
    };

    union
    {
        __IOM uint32_t PERFCOUNT2;         /*!< (@ 0x000000D0) Performance Counter 2                                      */

        struct
        {
            __IOM uint32_t PERFCOUNT : 32; /*!< [31..0] Counter value.The counter is reset by writing PERFCOUNT
                                            *   = 0000 0000H.                                                             */
        } PERFCOUNT2_b;
    };

    union
    {
        __OM uint32_t PERFTRIGGER;           /*!< (@ 0x000000D4) Performance Counters Control Register                      */

        struct
        {
            __OM uint32_t PERFTRIGGER1 : 16; /*!< [15..0] Selects the internal event that will increment PERFCOUNT1
                                              *   register.                                                                 */
            __OM uint32_t PERFTRIGGER2 : 16; /*!< [31..16] Selects the internal event that will increment PERFCOUNT2
                                              *   register                                                                  */
        } PERFTRIGGER_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __OM uint32_t TEXCLADDR;       /*!< (@ 0x000000DC) CLUT Start Address Register                                */

        struct
        {
            __OM uint32_t CLADDR : 8;  /*!< [7..0] Texture CLUT start address for indexed texture format              */
            uint32_t             : 24;
        } TEXCLADDR_b;
    };

    union
    {
        __OM uint32_t TEXCLDATA;       /*!< (@ 0x000000E0) CLUT Data Register                                         */

        struct
        {
            __OM uint32_t CLDATA : 32; /*!< [31..0] Texture CLUT data for Indexed texture format                      */
        } TEXCLDATA_b;
    };

    union
    {
        __OM uint32_t TEXCLOFFSET;      /*!< (@ 0x000000E4) CLUT Offset Register                                       */

        struct
        {
            __OM uint32_t CLOFFSET : 8; /*!< [7..0] Texture CLUT offset for Indexed texture format. CLOFFSET[7:0]
                                         *   is or'ed with the original index                                          */
            uint32_t : 24;
        } TEXCLOFFSET_b;
    };

    union
    {
        __OM uint32_t COLKEY;          /*!< (@ 0x000000E8) Color Key Register                                         */

        struct
        {
            __OM uint32_t COLKEYB : 8; /*!< [7..0] Blue channel of color key                                          */
            __OM uint32_t COLKEYG : 8; /*!< [15..8] Green channel of color key                                        */
            __OM uint32_t COLKEYR : 8; /*!< [23..16] Red channel of color key                                         */
            uint32_t              : 8;
        } COLKEY_b;
    };
} R_DRW_Type;                          /*!< Size = 236 (0xec)                                                         */

/* =========================================================================================================================== */
/* ================                                           R_DTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Transfer Controller (R_DTC)
 */

typedef struct                         /*!< (@ 0x40005400) R_DTC Structure                                            */
{
    union
    {
        __IOM uint8_t DTCCR;           /*!< (@ 0x00000000) DTC Control Register                                       */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t RRS : 1;     /*!< [4..4] DTC Transfer Information Read Skip Enable.                         */
            uint8_t           : 3;
        } DTCCR_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint32_t DTCVBR;          /*!< (@ 0x00000004) DTC Vector Base Register                                   */

        struct
        {
            __IOM uint32_t DTCVBR : 32; /*!< [31..0] DTC Vector Base Address.Note: A value cannot be set
                                         *   in the lower-order 10 bits. These bits are fixed to 0.                    */
        } DTCVBR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint8_t DTCST;           /*!< (@ 0x0000000C) DTC Module Start Register                                  */

        struct
        {
            __IOM uint8_t DTCST : 1;   /*!< [0..0] DTC Module Start                                                   */
            uint8_t             : 7;
        } DTCST_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IM uint16_t DTCSTS;          /*!< (@ 0x0000000E) DTC Status Register                                        */

        struct
        {
            __IM uint16_t VECN : 8;    /*!< [7..0] DTC-Activating Vector Number MonitoringThese bits indicate
                                        *   the vector number for the activating source when DTC transfer
                                        *   is in progress.The value is only valid if DTC transfer
                                        *   is in progress (the value of the ACT flag is 1)                           */
            uint16_t          : 7;
            __IM uint16_t ACT : 1;     /*!< [15..15] DTC Active Flag                                                  */
        } DTCSTS_b;
    };

    union
    {
        __IOM uint8_t DTCCR_SEC;       /*!< (@ 0x00000010) DTC Control Register for secure Region                     */

        struct
        {
            uint8_t            : 4;
            __IOM uint8_t RRSS : 1;    /*!< [4..4] DTC Transfer Information Read Skip Enable for Secure               */
            uint8_t            : 3;
        } DTCCR_SEC_b;
    };
    __IM uint8_t   RESERVED4;
    __IM uint16_t  RESERVED5;
    __IOM uint32_t DTCVBR_SEC;         /*!< (@ 0x00000014) DTC Vector Base Register for secure Region                 */
    __IM uint32_t  RESERVED6[2];

    union
    {
        __IOM uint32_t DTEVR;          /*!< (@ 0x00000020) DTC Error Vector Register                                  */

        struct
        {
            __IM uint32_t DTEV    : 8; /*!< [7..0] DTC Error Vector Number                                            */
            __IM uint32_t DTEVSAM : 1; /*!< [8..8] DTC Error Vector Number SA Monitor                                 */
            uint32_t              : 7;
            __IOM uint32_t DTESTA : 1; /*!< [16..16] DTC Error Status Flag                                            */
            uint32_t              : 15;
        } DTEVR_b;
    };
} R_DTC_Type;                          /*!< Size = 36 (0x24)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_ELC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Event Link Controller (R_ELC)
 */

typedef struct                         /*!< (@ 0x40041000) R_ELC Structure                                            */
{
    union
    {
        __IOM uint8_t ELCR;            /*!< (@ 0x00000000) Event Link Controller Register                             */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t ELCON : 1;   /*!< [7..7] All Event Link Enable                                              */
        } ELCR_b;
    };
    __IM uint8_t            RESERVED;
    __IOM R_ELC_ELSEGR_Type ELSEGR[2]; /*!< (@ 0x00000002) Event Link Software Event Generation Register              */
    __IM uint16_t           RESERVED1[5];
    __IOM R_ELC_ELSR_Type   ELSR[23];  /*!< (@ 0x00000010) Event Link Setting Register [0..22]                        */
    __IM uint16_t           RESERVED2[4];

    union
    {
        __IOM uint16_t ELCSARA;         /*!< (@ 0x00000074) Event Link Controller Security Attribution Register
                                         *                  A                                                          */

        struct
        {
            __IOM uint16_t ELSEGR0 : 1; /*!< [0..0] Event Link Software Event Generation Register 0 Security
                                         *   Attribution                                                               */
            __IOM uint16_t ELSEGR1 : 1; /*!< [1..1] Event Link Software Event Generation Register 1Security
                                         *   Attribution                                                               */
            __IOM uint16_t ELCR : 1;    /*!< [2..2] Event Link Controller RegisterSecurity Attribution                 */
            uint16_t            : 13;
        } ELCSARA_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t ELCSARB;        /*!< (@ 0x00000078) Event Link Controller Security Attribution Register
                                        *                  B                                                          */

        struct
        {
            __IOM uint16_t ELSR0  : 1; /*!< [0..0] Event Link Setting Register 0Security Attribution                  */
            __IOM uint16_t ELSR1  : 1; /*!< [1..1] Event Link Setting Register 1Security Attribution                  */
            __IOM uint16_t ELSR2  : 1; /*!< [2..2] Event Link Setting Register 2Security Attribution                  */
            __IOM uint16_t ELSR3  : 1; /*!< [3..3] Event Link Setting Register 3Security Attribution                  */
            __IOM uint16_t ELSR4  : 1; /*!< [4..4] Event Link Setting Register 4Security Attribution                  */
            __IOM uint16_t ELSR5  : 1; /*!< [5..5] Event Link Setting Register 5Security Attribution                  */
            __IOM uint16_t ELSR6  : 1; /*!< [6..6] Event Link Setting Register 6Security Attribution                  */
            __IOM uint16_t ELSR7  : 1; /*!< [7..7] Event Link Setting Register 7Security Attribution                  */
            __IOM uint16_t ELSR8  : 1; /*!< [8..8] Event Link Setting Register 8Security Attribution                  */
            __IOM uint16_t ELSR9  : 1; /*!< [9..9] Event Link Setting Register 9Security Attribution                  */
            __IOM uint16_t ELSR10 : 1; /*!< [10..10] Event Link Setting Register 10Security Attribution               */
            __IOM uint16_t ELSR11 : 1; /*!< [11..11] Event Link Setting Register 11Security Attribution               */
            __IOM uint16_t ELSR12 : 1; /*!< [12..12] Event Link Setting Register 12Security Attribution               */
            __IOM uint16_t ELSR13 : 1; /*!< [13..13] Event Link Setting Register 13Security Attribution               */
            __IOM uint16_t ELSR14 : 1; /*!< [14..14] Event Link Setting Register 14Security Attribution               */
            __IOM uint16_t ELSR15 : 1; /*!< [15..15] Event Link Setting Register 15Security Attribution               */
        } ELCSARB_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint16_t ELCSARC;        /*!< (@ 0x0000007C) Event Link Controller Security Attribution Register
                                        *                  C                                                          */

        struct
        {
            __IOM uint16_t ELSR16 : 1; /*!< [0..0] Event Link Setting Register 16Security Attribution                 */
            __IOM uint16_t ELSR17 : 1; /*!< [1..1] Event Link Setting Register 17Security Attribution                 */
            __IOM uint16_t ELSR18 : 1; /*!< [2..2] Event Link Setting Register 18Security Attribution                 */
            uint16_t              : 13;
        } ELCSARC_b;
    };
} R_ELC_Type;                          /*!< Size = 126 (0x7e)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_ETHERC0                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet MAC Controller (R_ETHERC0)
 */

typedef struct                         /*!< (@ 0x40064100) R_ETHERC0 Structure                                        */
{
    union
    {
        __IOM uint32_t ECMR;           /*!< (@ 0x00000000) ETHERC Mode Register                                       */

        struct
        {
            __IOM uint32_t PRM   : 1;  /*!< [0..0] Promiscuous Mode                                                   */
            __IOM uint32_t DM    : 1;  /*!< [1..1] Duplex Mode                                                        */
            __IOM uint32_t RTM   : 1;  /*!< [2..2] Bit Rate                                                           */
            __IOM uint32_t ILB   : 1;  /*!< [3..3] Internal Loopback Mode                                             */
            uint32_t             : 1;
            __IOM uint32_t TE    : 1;  /*!< [5..5] Transmission Enable                                                */
            __IOM uint32_t RE    : 1;  /*!< [6..6] Reception Enable                                                   */
            uint32_t             : 2;
            __IOM uint32_t MPDE  : 1;  /*!< [9..9] Magic Packet Detection Enable                                      */
            uint32_t             : 2;
            __IOM uint32_t PRCEF : 1;  /*!< [12..12] CRC Error Frame Receive Mode                                     */
            uint32_t             : 3;
            __IOM uint32_t TXF   : 1;  /*!< [16..16] Transmit Flow Control Operating Mode                             */
            __IOM uint32_t RXF   : 1;  /*!< [17..17] Receive Flow Control Operating Mode                              */
            __IOM uint32_t PFR   : 1;  /*!< [18..18] PAUSE Frame Receive Mode                                         */
            __IOM uint32_t ZPF   : 1;  /*!< [19..19] 0 Time PAUSE Frame Enable                                        */
            __IOM uint32_t TPC   : 1;  /*!< [20..20] PAUSE Frame Transmit                                             */
            uint32_t             : 11;
        } ECMR_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t RFLR;           /*!< (@ 0x00000008) Receive Frame Maximum Length Register                      */

        struct
        {
            __IOM uint32_t RFL : 12;   /*!< [11..0] Receive Frame Maximum LengthThe set value becomes the
                                        *   maximum frame length. The minimum value that can be set
                                        *   is 1,518 bytes, and the maximum value that can be set is
                                        *   2,048 bytes. Values that are less than 1,518 bytes are
                                        *   regarded as 1,518 bytes, and values larger than 2,048 bytes
                                        *   are regarded as 2,048 bytes.                                              */
            uint32_t : 20;
        } RFLR_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t ECSR;           /*!< (@ 0x00000010) ETHERC Status Register                                     */

        struct
        {
            __IOM uint32_t ICD   : 1;  /*!< [0..0] False Carrier Detect Flag                                          */
            __IOM uint32_t MPD   : 1;  /*!< [1..1] Magic Packet Detect Flag                                           */
            __IOM uint32_t LCHNG : 1;  /*!< [2..2] LCHNG Link Signal Change Flag                                      */
            uint32_t             : 1;
            __IOM uint32_t PSRTO : 1;  /*!< [4..4] PAUSE Frame Retransmit Over Flag                                   */
            __IOM uint32_t BFR   : 1;  /*!< [5..5] Continuous Broadcast Frame Reception Flag                          */
            uint32_t             : 26;
        } ECSR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t ECSIPR;          /*!< (@ 0x00000018) ETHERC Interrupt Enable Register                           */

        struct
        {
            __IOM uint32_t ICDIP   : 1; /*!< [0..0] False Carrier Detect Interrupt Enable                              */
            __IOM uint32_t MPDIP   : 1; /*!< [1..1] Magic Packet Detect Interrupt Enable                               */
            __IOM uint32_t LCHNGIP : 1; /*!< [2..2] LINK Signal Change Interrupt Enable                                */
            uint32_t               : 1;
            __IOM uint32_t PSRTOIP : 1; /*!< [4..4] PAUSE Frame Retransmit Over Interrupt Enable                       */
            __IOM uint32_t BFSIPR  : 1; /*!< [5..5] Continuous Broadcast Frame Reception Interrupt Enable              */
            uint32_t               : 26;
        } ECSIPR_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t PIR;            /*!< (@ 0x00000020) PHY Interface Register                                     */

        struct
        {
            __IOM uint32_t MDC : 1;    /*!< [0..0] MII/RMII Management Data ClockThe MDC bit value is output
                                        *   from the ETn_MDC pin to supply the management data clock
                                        *   to the MII or RMII.                                                       */
            __IOM uint32_t MMD : 1;    /*!< [1..1] MII/RMII Management Mode                                           */
            __IOM uint32_t MDO : 1;    /*!< [2..2] MII/RMII Management Data-OutThe MDO bit value is output
                                        *   from the ETn_MDIO pin when the MMD bit is 1 (write). The
                                        *   value is not output when the MMD bit is 0 (read).                         */
            __IM uint32_t MDI : 1;     /*!< [3..3] MII/RMII Management Data-InThis bit indicates the level
                                        *   of the ETn_MDIO pin. The write value should be 0.                         */
            uint32_t : 28;
        } PIR_b;
    };
    __IM uint32_t RESERVED4;

    union
    {
        __IM uint32_t PSR;             /*!< (@ 0x00000028) PHY Status Register                                        */

        struct
        {
            __IM uint32_t LMON : 1;    /*!< [0..0] ETn_LINKSTA Pin Status FlagThe link status can be read
                                        *   by connecting the link signal output from the PHY-LSI to
                                        *   the ETn_LINKSTA pin. For details on the polarity, refer
                                        *   to the specifications of the connected PHY-LSI.                           */
            uint32_t : 31;
        } PSR_b;
    };
    __IM uint32_t RESERVED5[5];

    union
    {
        __IOM uint32_t RDMLR;          /*!< (@ 0x00000040) Random Number Generation Counter Upper Limit
                                        *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t RMD : 20;   /*!< [19..0] Random Number Generation Counter                                  */
            uint32_t           : 12;
        } RDMLR_b;
    };
    __IM uint32_t RESERVED6[3];

    union
    {
        __IOM uint32_t IPGR;           /*!< (@ 0x00000050) IPG Register                                               */

        struct
        {
            __IOM uint32_t IPG : 5;    /*!< [4..0] Interpacket Gap Range:"16bit time(0x00)"-"140bit time(0x1F)"       */
            uint32_t           : 27;
        } IPGR_b;
    };

    union
    {
        __IOM uint32_t APR;            /*!< (@ 0x00000054) Automatic PAUSE Frame Register                             */

        struct
        {
            __IOM uint32_t AP : 16;    /*!< [15..0] Automatic PAUSE Time SettingThese bits set the value
                                        *   of the pause_time parameter for a PAUSE frame that is automatically
                                        *   transmitted. Transmission is not performed until the set
                                        *   value multiplied by 512 bit time has elapsed.                             */
            uint32_t : 16;
        } APR_b;
    };

    union
    {
        __OM uint32_t MPR;             /*!< (@ 0x00000058) Manual PAUSE Frame Register                                */

        struct
        {
            __OM uint32_t MP : 16;     /*!< [15..0] Manual PAUSE Time SettingThese bits set the value of
                                        *   the pause_time parameter for a PAUSE frame that is manually
                                        *   transmitted. Transmission is not performed until the set
                                        *   value multiplied by 512 bit time has elapsed. The read
                                        *   value is undefined.                                                       */
            uint32_t : 16;
        } MPR_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IM uint32_t RFCF;            /*!< (@ 0x00000060) Received PAUSE Frame Counter                               */

        struct
        {
            __IM uint32_t RPAUSE : 8;  /*!< [7..0] Received PAUSE Frame CountNumber of received PAUSE frames          */
            uint32_t             : 24;
        } RFCF_b;
    };

    union
    {
        __IOM uint32_t TPAUSER;         /*!< (@ 0x00000064) PAUSE Frame Retransmit Count Setting Register              */

        struct
        {
            __IOM uint32_t TPAUSE : 16; /*!< [15..0] Automatic PAUSE Frame Retransmit Setting                          */
            uint32_t              : 16;
        } TPAUSER_b;
    };
    __IM uint32_t TPAUSECR;             /*!< (@ 0x00000068) PAUSE Frame Retransmit Counter                             */

    union
    {
        __IOM uint32_t BCFRR;           /*!< (@ 0x0000006C) Broadcast Frame Receive Count Setting Register             */

        struct
        {
            __IOM uint32_t BCF : 16;    /*!< [15..0] Broadcast Frame Continuous Receive Count Setting                  */
            uint32_t           : 16;
        } BCFRR_b;
    };
    __IM uint32_t RESERVED8[20];

    union
    {
        __IOM uint32_t MAHR;           /*!< (@ 0x000000C0) MAC Address Upper Bit Register                             */

        struct
        {
            __IOM uint32_t MAHR : 32;  /*!< [31..0] MAC Address Upper Bit RegisterThe MAHR register sets
                                        *   the upper 32 bits (b47 to b16) of the 48-bit MAC address.                 */
        } MAHR_b;
    };
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint32_t MALR;           /*!< (@ 0x000000C8) MAC Address Lower Bit Register                             */

        struct
        {
            __IOM uint32_t MALR : 16;  /*!< [15..0] MAC Address Lower Bit RegisterThe MALR register sets
                                        *   the lower 16 bits of the 48-bit MAC address.                              */
            uint32_t : 16;
        } MALR_b;
    };
    __IM uint32_t RESERVED10;

    union
    {
        __IOM uint32_t TROCR;          /*!< (@ 0x000000D0) Transmit Retry Over Counter Register                       */

        struct
        {
            __IOM uint32_t TROCR : 32; /*!< [31..0] Transmit Retry Over Counter RegisterThe TROCR register
                                        *   is a counter indicating the number of frames that fail
                                        *   to be retransmitted.                                                      */
        } TROCR_b;
    };
    __IOM uint32_t CDCR;               /*!< (@ 0x000000D4) Late Collision Detect Counter Register                     */

    union
    {
        __IOM uint32_t LCCR;           /*!< (@ 0x000000D8) Lost Carrier Counter Register                              */

        struct
        {
            __IOM uint32_t LCCR : 32;  /*!< [31..0] Lost Carrier Counter RegisterThe LCCR register is a
                                        *   counter indicating the number of times a loss of carrier
                                        *   is detected during frame transmission.                                    */
        } LCCR_b;
    };

    union
    {
        __IOM uint32_t CNDCR;          /*!< (@ 0x000000DC) Carrier Not Detect Counter Register                        */

        struct
        {
            __IOM uint32_t CNDCR : 32; /*!< [31..0] Carrier Not Detect Counter RegisterThe CNDCR register
                                        *   is a counter indicating the number of times a carrier is
                                        *   not detected during preamble transmission.                                */
        } CNDCR_b;
    };
    __IM uint32_t RESERVED11;

    union
    {
        __IOM uint32_t CEFCR;          /*!< (@ 0x000000E4) CRC Error Frame Receive Counter Register                   */

        struct
        {
            __IOM uint32_t CEFCR : 32; /*!< [31..0] CRC Error Frame Receive Counter RegisterThe CEFCR register
                                        *   is a counter indicating the number of received frames where
                                        *   a CRC error has been detected.                                            */
        } CEFCR_b;
    };

    union
    {
        __IOM uint32_t FRECR;          /*!< (@ 0x000000E8) Frame Receive Error Counter Register                       */

        struct
        {
            __IOM uint32_t FRECR : 32; /*!< [31..0] Frame Receive Error Counter RegisterThe FRECR register
                                        *   is a counter indicating the number of times a frame receive
                                        *   error has occurred.                                                       */
        } FRECR_b;
    };

    union
    {
        __IOM uint32_t TSFRCR;          /*!< (@ 0x000000EC) Too-Short Frame Receive Counter Register                   */

        struct
        {
            __IOM uint32_t TSFRCR : 32; /*!< [31..0] Too-Short Frame Receive Counter RegisterThe TSFRCR register
                                         *   is a counter indicating the number of times a short frame
                                         *   that is shorter than 64 bytes has been received.                          */
        } TSFRCR_b;
    };

    union
    {
        __IOM uint32_t TLFRCR;          /*!< (@ 0x000000F0) Too-Long Frame Receive Counter Register                    */

        struct
        {
            __IOM uint32_t TLFRCR : 32; /*!< [31..0] Too-Long Frame Receive Counter RegisterThe TLFRCR register
                                         *   is a counter indicating the number of times a long frame
                                         *   that is longer than the RFLR register value has been received.            */
        } TLFRCR_b;
    };

    union
    {
        __IOM uint32_t RFCR;           /*!< (@ 0x000000F4) Received Alignment Error Frame Counter Register            */

        struct
        {
            __IOM uint32_t RFCR : 32;  /*!< [31..0] Received Alignment Error Frame Counter RegisterThe RFCR
                                        *   register is a counter indicating the number of times a
                                        *   frame has been received with the alignment error (frame
                                        *   is not an integral number of octets).                                     */
        } RFCR_b;
    };

    union
    {
        __IOM uint32_t MAFCR;          /*!< (@ 0x000000F8) Multicast Address Frame Receive Counter Register           */

        struct
        {
            __IOM uint32_t MAFCR : 32; /*!< [31..0] Multicast Address Frame Receive Counter RegisterThe
                                        *   MAFCR register is a counter indicating the number of times
                                        *   a frame where the multicast address is set has been received.             */
        } MAFCR_b;
    };
} R_ETHERC0_Type;                      /*!< Size = 252 (0xfc)                                                         */

/* =========================================================================================================================== */
/* ================                                      R_ETHERC_EDMAC                                       ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet DMA Controller (R_ETHERC_EDMAC)
 */

typedef struct                         /*!< (@ 0x40064000) R_ETHERC_EDMAC Structure                                   */
{
    union
    {
        __IOM uint32_t EDMR;           /*!< (@ 0x00000000) EDMAC Mode Register                                        */

        struct
        {
            __OM uint32_t SWR : 1;     /*!< [0..0] Software Reset                                                     */
            uint32_t          : 3;
            __IOM uint32_t DL : 2;     /*!< [5..4] Transmit/Receive DescriptorLength                                  */
            __IOM uint32_t DE : 1;     /*!< [6..6] Big Endian Mode/Little Endian ModeNOTE: This setting
                                        *   applies to data for the transmit/receive buffer. It does
                                        *   not apply to transmit/receive descriptors and registers.                  */
            uint32_t : 25;
        } EDMR_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t EDTRR;          /*!< (@ 0x00000008) EDMAC Transmit Request Register                            */

        struct
        {
            __OM uint32_t TR : 1;      /*!< [0..0] Transmit Request                                                   */
            uint32_t         : 31;
        } EDTRR_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t EDRRR;          /*!< (@ 0x00000010) EDMAC Receive Request Register                             */

        struct
        {
            __IOM uint32_t RR : 1;     /*!< [0..0] Receive Request                                                    */
            uint32_t          : 31;
        } EDRRR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t TDLAR;          /*!< (@ 0x00000018) Transmit Descriptor List Start Address Register            */

        struct
        {
            __IOM uint32_t TDLAR : 32; /*!< [31..0] The start address of the transmit descriptor list is
                                        *   set. Set the start address according to the descriptor
                                        *   length selected by the EDMR.DL[1:0] bits.16-byte boundary:
                                        *   Lower 4 bits = 0000b32-byte boundary: Lower 5 bits = 00000b64-byte
                                        *   boundary: Lower 6 bits = 000000b                                          */
        } TDLAR_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t RDLAR;          /*!< (@ 0x00000020) Receive Descriptor List Start Address Register             */

        struct
        {
            __IOM uint32_t RDLAR : 32; /*!< [31..0] The start address of the receive descriptor list is
                                        *   set. Set the start address according to the descriptor
                                        *   length selected by the EDMR.DL[1:0] bits.16-byte boundary:
                                        *   Lower 4 bits = 0000b32-byte boundary: Lower 5 bits = 00000b64-byte
                                        *   boundary: Lower 6 bits = 000000b                                          */
        } RDLAR_b;
    };
    __IM uint32_t RESERVED4;

    union
    {
        __IOM uint32_t EESR;           /*!< (@ 0x00000028) ETHERC/EDMAC Status Register                               */

        struct
        {
            __IOM uint32_t CERF : 1;   /*!< [0..0] CRC Error Flag                                                     */
            __IOM uint32_t PRE  : 1;   /*!< [1..1] PHY-LSI Receive Error Flag                                         */
            __IOM uint32_t RTSF : 1;   /*!< [2..2] Frame-Too-Short Error Flag                                         */
            __IOM uint32_t RTLF : 1;   /*!< [3..3] Frame-Too-Long Error Flag                                          */
            __IOM uint32_t RRF  : 1;   /*!< [4..4] Alignment Error Flag                                               */
            uint32_t            : 2;
            __IOM uint32_t RMAF : 1;   /*!< [7..7] Multicast Address Frame Receive Flag                               */
            __IOM uint32_t TRO  : 1;   /*!< [8..8] Transmit Retry Over Flag                                           */
            __IOM uint32_t CD   : 1;   /*!< [9..9] Late Collision Detect Flag                                         */
            __IOM uint32_t DLC  : 1;   /*!< [10..10] Loss of Carrier Detect Flag                                      */
            __IOM uint32_t CND  : 1;   /*!< [11..11] Carrier Not Detect Flag                                          */
            uint32_t            : 4;
            __IOM uint32_t RFOF : 1;   /*!< [16..16] Receive FIFO Overflow Flag                                       */
            __IOM uint32_t RDE  : 1;   /*!< [17..17] Receive Descriptor Empty Flag                                    */
            __IOM uint32_t FR   : 1;   /*!< [18..18] Frame Receive Flag                                               */
            __IOM uint32_t TFUF : 1;   /*!< [19..19] Transmit FIFO Underflow Flag                                     */
            __IOM uint32_t TDE  : 1;   /*!< [20..20] Transmit Descriptor Empty Flag                                   */
            __IOM uint32_t TC   : 1;   /*!< [21..21] Frame Transfer Complete Flag                                     */
            __IM uint32_t  ECI  : 1;   /*!< [22..22] ETHERC Status Register Source FlagNOTE: When the source
                                        *   in the ETHERCn.ECSR register is cleared, the ECI flag is
                                        *   also cleared.                                                             */
            __IOM uint32_t ADE   : 1;  /*!< [23..23] Address Error Flag                                               */
            __IOM uint32_t RFCOF : 1;  /*!< [24..24] Receive Frame Counter Overflow Flag                              */
            __IOM uint32_t RABT  : 1;  /*!< [25..25] Receive Abort Detect Flag                                        */
            __IOM uint32_t TABT  : 1;  /*!< [26..26] Transmit Abort Detect Flag                                       */
            uint32_t             : 3;
            __IOM uint32_t TWB   : 1;  /*!< [30..30] Write-Back Complete Flag                                         */
            uint32_t             : 1;
        } EESR_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t EESIPR;          /*!< (@ 0x00000030) ETHERC/EDMAC Status Interrupt Enable Register              */

        struct
        {
            __IOM uint32_t CERFIP  : 1; /*!< [0..0] CRC Error Interrupt Request Enable                                 */
            __IOM uint32_t PREIP   : 1; /*!< [1..1] PHY-LSI Receive Error Interrupt Request Enable                     */
            __IOM uint32_t RTSFIP  : 1; /*!< [2..2] Frame-Too-Short Error Interrupt Request Enable                     */
            __IOM uint32_t RTLFIP  : 1; /*!< [3..3] Frame-Too-Long Error Interrupt Request Enable                      */
            __IOM uint32_t RRFIP   : 1; /*!< [4..4] Alignment Error Interrupt Request Enable                           */
            uint32_t               : 2;
            __IOM uint32_t RMAFIP  : 1; /*!< [7..7] Multicast Address Frame Receive Interrupt Request Enable           */
            __IOM uint32_t TROIP   : 1; /*!< [8..8] Transmit Retry Over Interrupt Request Enable                       */
            __IOM uint32_t CDIP    : 1; /*!< [9..9] Late Collision Detect Interrupt Request Enable                     */
            __IOM uint32_t DLCIP   : 1; /*!< [10..10] Loss of Carrier Detect Interrupt Request Enable                  */
            __IOM uint32_t CNDIP   : 1; /*!< [11..11] Carrier Not Detect Interrupt Request Enable                      */
            uint32_t               : 4;
            __IOM uint32_t RFOFIP  : 1; /*!< [16..16] Receive FIFO Overflow Interrupt Request Enable                   */
            __IOM uint32_t RDEIP   : 1; /*!< [17..17] Receive Descriptor Empty Interrupt Request Enable                */
            __IOM uint32_t FRIP    : 1; /*!< [18..18] Frame Receive Interrupt Request Enable                           */
            __IOM uint32_t TFUFIP  : 1; /*!< [19..19] Transmit FIFO Underflow Interrupt Request Enable                 */
            __IOM uint32_t TDEIP   : 1; /*!< [20..20] Transmit Descriptor Empty Interrupt Request Enable               */
            __IOM uint32_t TCIP    : 1; /*!< [21..21] Frame Transfer Complete Interrupt Request Enable                 */
            __IOM uint32_t ECIIP   : 1; /*!< [22..22] ETHERC Status Register Source Interrupt Request Enable           */
            __IOM uint32_t ADEIP   : 1; /*!< [23..23] Address Error Interrupt Request Enable                           */
            __IOM uint32_t RFCOFIP : 1; /*!< [24..24] Receive Frame Counter Overflow Interrupt Request Enable          */
            __IOM uint32_t RABTIP  : 1; /*!< [25..25] Receive Abort Detect Interrupt Request Enable                    */
            __IOM uint32_t TABTIP  : 1; /*!< [26..26] Transmit Abort Detect Interrupt Request Enable                   */
            uint32_t               : 3;
            __IOM uint32_t TWBIP   : 1; /*!< [30..30] Write-Back Complete Interrupt Request Enable                     */
            uint32_t               : 1;
        } EESIPR_b;
    };
    __IM uint32_t RESERVED6;

    union
    {
        __IOM uint32_t TRSCER;         /*!< (@ 0x00000038) ETHERC/EDMAC Transmit/Receive Status Copy Enable
                                        *                  Register                                                   */

        struct
        {
            uint32_t              : 4;
            __IOM uint32_t RRFCE  : 1; /*!< [4..4] RRF Flag Copy Enable                                               */
            uint32_t              : 2;
            __IOM uint32_t RMAFCE : 1; /*!< [7..7] RMAF Flag Copy Enable                                              */
            uint32_t              : 24;
        } TRSCER_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IOM uint32_t RMFCR;          /*!< (@ 0x00000040) Missed-Frame Counter Register                              */

        struct
        {
            __IOM uint32_t MFC : 16;   /*!< [15..0] Missed-Frame CounterThese bits indicate the number of
                                        *   frames that are discarded and not transferred to the receive
                                        *   buffer during reception.                                                  */
            uint32_t : 16;
        } RMFCR_b;
    };
    __IM uint32_t RESERVED8;

    union
    {
        __IOM uint32_t TFTR;           /*!< (@ 0x00000048) Transmit FIFO Threshold Register                           */

        struct
        {
            __IOM uint32_t TFT : 11;   /*!< [10..0] Transmit FIFO Threshold00Dh to 200h: The threshold is
                                        *   the set value multiplied by 4. Example: 00Dh: 52 bytes
                                        *   040h: 256 bytes 100h: 1024 bytes 200h: 2048 bytes                         */
            uint32_t : 21;
        } TFTR_b;
    };
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint32_t FDR;            /*!< (@ 0x00000050) Transmit FIFO Threshold Register                           */

        struct
        {
            __IOM uint32_t RFD : 5;    /*!< [4..0] Transmit FIFO Depth                                                */
            uint32_t           : 3;
            __IOM uint32_t TFD : 5;    /*!< [12..8] Receive FIFO Depth                                                */
            uint32_t           : 19;
        } FDR_b;
    };
    __IM uint32_t RESERVED10;

    union
    {
        __IOM uint32_t RMCR;           /*!< (@ 0x00000058) Receive Method Control Register                            */

        struct
        {
            __IOM uint32_t RNR : 1;    /*!< [0..0] Receive Request Reset                                              */
            uint32_t           : 31;
        } RMCR_b;
    };
    __IM uint32_t RESERVED11[2];

    union
    {
        __IOM uint32_t TFUCR;          /*!< (@ 0x00000064) Transmit FIFO Underflow Counter                            */

        struct
        {
            __IOM uint32_t UNDER : 16; /*!< [15..0] Transmit FIFO Underflow CountThese bits indicate how
                                        *   many times the transmit FIFO has underflowed. The counter
                                        *   stops when the counter value reaches FFFFh.                               */
            uint32_t : 16;
        } TFUCR_b;
    };

    union
    {
        __IOM uint32_t RFOCR;          /*!< (@ 0x00000068) Receive FIFO Overflow Counter                              */

        struct
        {
            __IOM uint32_t OVER : 16;  /*!< [15..0] Receive FIFO Overflow CountThese bits indicate how many
                                        *   times the receive FIFO has overflowed. The counter stops
                                        *   when the counter value reaches FFFFh.                                     */
            uint32_t : 16;
        } RFOCR_b;
    };

    union
    {
        __IOM uint32_t IOSR;           /*!< (@ 0x0000006C) Independent Output Signal Setting Register                 */

        struct
        {
            __IOM uint32_t ELB : 1;    /*!< [0..0] External Loopback Mode                                             */
            uint32_t           : 31;
        } IOSR_b;
    };

    union
    {
        __IOM uint32_t FCFTR;          /*!< (@ 0x00000070) Flow Control Start FIFO Threshold Setting Register         */

        struct
        {
            __IOM uint32_t RFDO : 3;   /*!< [2..0] Receive FIFO Data PAUSE Output Threshold(When (RFDO+1)x256-32
                                        *   bytes of data is stored in the receive FIFO.)                             */
            uint32_t            : 13;
            __IOM uint32_t RFFO : 3;   /*!< [18..16] Receive FIFO Frame PAUSE Output Threshold(When ((RFFO+1)x2)
                                        *   receive frames have been stored in the receive FIFO.)                     */
            uint32_t : 13;
        } FCFTR_b;
    };
    __IM uint32_t RESERVED12;

    union
    {
        __IOM uint32_t RPADIR;         /*!< (@ 0x00000078) Receive Data Padding Insert Register                       */

        struct
        {
            __IOM uint32_t PADR : 6;   /*!< [5..0] Padding Slot                                                       */
            uint32_t            : 10;
            __IOM uint32_t PADS : 2;   /*!< [17..16] Padding Size                                                     */
            uint32_t            : 14;
        } RPADIR_b;
    };

    union
    {
        __IOM uint32_t TRIMD;          /*!< (@ 0x0000007C) Transmit Interrupt Setting Register                        */

        struct
        {
            __IOM uint32_t TIS : 1;    /*!< [0..0] Transmit Interrupt EnableSet the EESR.TWB flag to 1 in
                                        *   the mode selected by the TIM bit to notify an interrupt.                  */
            uint32_t           : 3;
            __IOM uint32_t TIM : 1;    /*!< [4..4] Transmit Interrupt Mode                                            */
            uint32_t           : 27;
        } TRIMD_b;
    };
    __IM uint32_t RESERVED13[18];

    union
    {
        __IOM uint32_t RBWAR;          /*!< (@ 0x000000C8) Receive Buffer Write Address Register                      */

        struct
        {
            __IM uint32_t RBWAR : 32;  /*!< [31..0] Receive Buffer Write Address RegisterThe RBWAR register
                                        *   indicates the last address that the EDMAC has written data
                                        *   to when writing to the receive buffer.Refer to the address
                                        *   indicated by the RBWAR register to recognize which address
                                        *   in the receive buffer the EDMAC is writing data to. Note
                                        *   that the address that the EDMAC is outputting to the receive
                                        *   buffer may not match the read value of the RBWAR register
                                        *   during data reception.                                                    */
        } RBWAR_b;
    };

    union
    {
        __IOM uint32_t RDFAR;          /*!< (@ 0x000000CC) Receive Descriptor Fetch Address Register                  */

        struct
        {
            __IM uint32_t RDFAR : 32;  /*!< [31..0] Receive Descriptor Fetch Address RegisterThe RDFAR register
                                        *   indicates the start address of the last fetched receive
                                        *   descriptor when the EDMAC fetches descriptor information
                                        *   from the receive descriptor.Refer to the address indicated
                                        *   by the RDFAR register to recognize which receive descriptor
                                        *   information the EDMAC is using for the current processing.
                                        *   Note that the address of the receive descriptor that the
                                        *   EDMAC fetches may not match the read value of the RDFAR
                                        *   register during data reception.                                           */
        } RDFAR_b;
    };
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint32_t TBRAR;          /*!< (@ 0x000000D4) Transmit Buffer Read Address Register                      */

        struct
        {
            __IM uint32_t TBRAR : 32;  /*!< [31..0] Transmit Buffer Read Address RegisterThe TBRAR register
                                        *   indicates the last address that the EDMAC has read data
                                        *   from when reading data from the transmit buffer.Refer to
                                        *   the address indicated by the TBRAR register to recognize
                                        *   which address in the transmit buffer the EDMAC is reading
                                        *   from. Note that the address that the EDMAC is outputting
                                        *   to the transmit buffer may not match the read value of
                                        *   the TBRAR register.                                                       */
        } TBRAR_b;
    };

    union
    {
        __IM uint32_t TDFAR;           /*!< (@ 0x000000D8) Transmit Descriptor Fetch Address Register                 */

        struct
        {
            __IM uint32_t TDFAR : 32;  /*!< [31..0] Transmit Descriptor Fetch Address RegisterThe TDFAR
                                        *   register indicates the start address of the last fetched
                                        *   transmit descriptor when the EDMAC fetches descriptor information
                                        *   from the transmit descriptor.Refer to the address indicated
                                        *   by the TDFAR register to recognize which transmit descriptor
                                        *   information the EDMAC is using for the current processing.
                                        *   Note that the address of the transmit descriptor that the
                                        *   EDMAC fetches may not match the read value of the TDFAR
                                        *   register.                                                                 */
        } TDFAR_b;
    };
} R_ETHERC_EDMAC_Type;                 /*!< Size = 220 (0xdc)                                                         */

/* =========================================================================================================================== */
/* ================                                      R_ETHERC_EPTPC                                       ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet PTP Controller (R_ETHERC_EPTPC)
 */

typedef struct                         /*!< (@ 0x40065800) R_ETHERC_EPTPC Structure                                   */
{
    union
    {
        __IOM uint32_t SYSR;           /*!< (@ 0x00000000) SYNFP Status Register                                      */

        struct
        {
            __IOM uint32_t OFMUD  : 1; /*!< [0..0] offsetFromMaster Value Update Flag                                 */
            __IOM uint32_t INTCHG : 1; /*!< [1..1] Receive logMessageInterval Value Change Detection Flag             */
            __IOM uint32_t MPDUD  : 1; /*!< [2..2] meanPathDelay Value Update Flag                                    */
            uint32_t              : 1;
            __IOM uint32_t DRPTO  : 1; /*!< [4..4] Delay_Resp/Pdelay_Resp Reception Timeout Detection Flag            */
            __IOM uint32_t INTDEV : 1; /*!< [5..5] Receive logMessageInterval Value Out-of-Range Flag                 */
            __IOM uint32_t DRQOVR : 1; /*!< [6..6] Delay_Req Reception FIFO Overflow Detection Flag                   */
            uint32_t              : 5;
            __IOM uint32_t RECLP  : 1; /*!< [12..12] Loop Reception Detection Flag                                    */
            uint32_t              : 1;
            __IOM uint32_t INFABT : 1; /*!< [14..14] Control Information Abnormality Detection Flag                   */
            uint32_t              : 1;
            __IOM uint32_t RESDN  : 1; /*!< [16..16] Response Stop Completion Detection Flag                          */
            __IOM uint32_t GENDN  : 1; /*!< [17..17] Generation Stop Completion Detection Flag                        */
            uint32_t              : 14;
        } SYSR_b;
    };

    union
    {
        __IOM uint32_t SYIPR;          /*!< (@ 0x00000004) SYNFP Status Notification Permission Register              */

        struct
        {
            __IOM uint32_t OFMUD  : 1; /*!< [0..0] SYSR.OFMUD Status Notification Permission                          */
            __IOM uint32_t INTCHG : 1; /*!< [1..1] SYSR.INTCHG Status Notification Permission                         */
            __IOM uint32_t MPDUD  : 1; /*!< [2..2] SYSR.MPDUD Status Notification Permission                          */
            uint32_t              : 1;
            __IOM uint32_t DRPTO  : 1; /*!< [4..4] SYSR.DRPTO Status Notification Permission                          */
            __IOM uint32_t INTDEV : 1; /*!< [5..5] SYSR.INTDEV Status Notification Permission                         */
            __IOM uint32_t DRQOVR : 1; /*!< [6..6] SYSR.DRQOVR Status Notification Permission                         */
            uint32_t              : 5;
            __IOM uint32_t RECLP  : 1; /*!< [12..12] SYSR.RECLP Status Notification Permission                        */
            uint32_t              : 1;
            __IOM uint32_t INFABT : 1; /*!< [14..14] SYSR.INFABT Status Notification Permission                       */
            uint32_t              : 1;
            __IOM uint32_t RESDN  : 1; /*!< [16..16] SYSR.RESDN Status Notification Permission                        */
            __IOM uint32_t GENDN  : 1; /*!< [17..17] SYSR.GENDN Status Notification Permission                        */
            uint32_t              : 14;
        } SYIPR_b;
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __IOM uint32_t SYMACRU;          /*!< (@ 0x00000010) SYNFP MAC Address Registers                                */

        struct
        {
            __IOM uint32_t SYMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the local MAC address.                                            */
            uint32_t : 8;
        } SYMACRU_b;
    };

    union
    {
        __IOM uint32_t SYMACRL;          /*!< (@ 0x00000014) SYNFP MAC Address Registers                                */

        struct
        {
            __IOM uint32_t SYMACRL : 24; /*!< [23..0] These bits hold the setting for the lower-order 24 bits
                                          *   of the local MAC address.                                                 */
            uint32_t : 8;
        } SYMACRL_b;
    };

    union
    {
        __IOM uint32_t SYLLCCTLR;      /*!< (@ 0x00000018) SYNFP LLC-CTL Value Register                               */

        struct
        {
            __IOM uint32_t CTL : 8;    /*!< [7..0] LLC-CTL FieldThese bits specify the value used for the
                                        *   control field in the LLC sublayer when generating IEEE802.3
                                        *   frames.                                                                   */
            uint32_t : 24;
        } SYLLCCTLR_b;
    };

    union
    {
        __IOM uint32_t SYIPADDRR;          /*!< (@ 0x0000001C) SYNFP Local IP Address Register                            */

        struct
        {
            __IOM uint32_t SYIPADDRR : 32; /*!< [31..0] These bits hold the setting for the local IP address.             */
        } SYIPADDRR_b;
    };
    __IM uint32_t RESERVED1[8];

    union
    {
        __IOM uint32_t SYSPVRR;        /*!< (@ 0x00000040) SYNFP Specification Version Setting Register               */

        struct
        {
            __IOM uint32_t VER : 4;    /*!< [3..0] versionPTP Field ValueThese bits are used to set the
                                        *   versionPTP field value of the PTP v2 header.When a message
                                        *   is received, this value is compared with the versionPTP
                                        *   field of the received frame.In generating messages, the
                                        *   value is used for the versionPTP field of the frame for
                                        *   transmission.Set these bits to 0010b (PTP v2).                            */
            __IOM uint32_t TRSP : 4;   /*!< [7..4] transportSpecific Field ValueThese bits are used to set
                                        *   the transportSpecific field value of the PTP v2 header.When
                                        *   a message is received, this value is compared with the
                                        *   transportSpecific field of the received frame.In generating
                                        *   messages, the value is used for the transportSpecific field
                                        *   of the frame for transmission.Set these bits to 0000b (IEEE
                                        *   1588).                                                                    */
            uint32_t : 24;
        } SYSPVRR_b;
    };

    union
    {
        __IOM uint32_t SYDOMR;         /*!< (@ 0x00000044) SYNFP Domain Number Setting Register                       */

        struct
        {
            __IOM uint32_t DNUM : 8;   /*!< [7..0] domainNumber Field Value SettingThese bits are used to
                                        *   set the domainNumber field value of the PTP v2 header.When
                                        *   a message is received, this value is compared with the
                                        *   domainNumber field of the received frame as a condition
                                        *   for PTP reception processing.In generating messages, the
                                        *   value is used for the domainNumber field of the frame for
                                        *   transmission.                                                             */
            uint32_t : 24;
        } SYDOMR_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t ANFR;           /*!< (@ 0x00000050) Announce Message Flag Field Setting Register               */

        struct
        {
            __IOM uint32_t FLAG0 : 1;  /*!< [0..0] leap61This bit is used to set the logical value of the
                                        *   leap61 member of timePropertiesDS.                                        */
            __IOM uint32_t FLAG1 : 1;  /*!< [1..1] leap59This bit is used to set the logical value of the
                                        *   leap59 member of timePropertiesDS.                                        */
            __IOM uint32_t FLAG2 : 1;  /*!< [2..2] currentUtcOffsetValidThis bit is used to set the logical
                                        *   value of the currentUtcOffsetValid member of timePropertiesDS.            */
            __IOM uint32_t FLAG3 : 1;  /*!< [3..3] ptpTimescaleThis bit is used to set the logical value
                                        *   of the ptpTimescale member of timePropertiesDS.                           */
            __IOM uint32_t FLAG4 : 1;  /*!< [4..4] timeTraceableThis bit is used to set the logical value
                                        *   of the timeTraceable member of timePropertiesDS.                          */
            __IOM uint32_t FLAG5 : 1;  /*!< [5..5] frequencyTraceableThis bit is used to set the logical
                                        *   value of the frequencyTraceable member of timePropertiesDS.               */
            uint32_t              : 2;
            __IOM uint32_t FLAG8  : 1; /*!< [8..8] alternateMasterFlag                                                */
            uint32_t              : 1;
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } ANFR_b;
    };

    union
    {
        __IOM uint32_t SYNFR;          /*!< (@ 0x00000054) Sync Message Flag Field Setting Register                   */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t FLAG8  : 1; /*!< [8..8] alternateMasterFlag                                                */
            __IOM uint32_t FLAG9  : 1; /*!< [9..9] twoStepFlag                                                        */
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } SYNFR_b;
    };

    union
    {
        __IOM uint32_t DYRQFR;         /*!< (@ 0x00000058) Delay_Req Message Flag Field Setting Register              */

        struct
        {
            uint32_t              : 10;
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } DYRQFR_b;
    };

    union
    {
        __IOM uint32_t DYRPFR;         /*!< (@ 0x0000005C) Delay_Resp Message Flag Field Setting Register             */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t FLAG8  : 1; /*!< [8..8] alternateMasterFlag                                                */
            __IOM uint32_t FLAG9  : 1; /*!< [9..9] woStepFlag                                                         */
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } DYRPFR_b;
    };

    union
    {
        __IOM uint32_t SYCIDRU;          /*!< (@ 0x00000060) SYNFP Local Clock ID Registers                             */

        struct
        {
            __IOM uint32_t SYCIDRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                          *   bits of the clock-ID of your port.                                        */
        } SYCIDRU_b;
    };

    union
    {
        __IOM uint32_t SYCIDRL;          /*!< (@ 0x00000064) SYNFP Local Clock ID Registers                             */

        struct
        {
            __IOM uint32_t SYCIDRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                          *   of the clock-ID of your port.                                             */
        } SYCIDRL_b;
    };

    union
    {
        __IOM uint32_t SYPNUMR;        /*!< (@ 0x00000068) SYNFP Local Port Number Register                           */

        struct
        {
            __IOM uint32_t PNUM : 16;  /*!< [15..0] Local Port Number SettingThese bits hold the setting
                                        *   for the port number of the local port.                                    */
            uint32_t : 16;
        } SYPNUMR_b;
    };
    __IM uint32_t RESERVED3[5];

    union
    {
        __OM uint32_t SYRVLDR;         /*!< (@ 0x00000080) SYNFP Register Value Load Directive Register               */

        struct
        {
            __OM uint32_t BMUP : 1;    /*!< [0..0] BMC Update                                                         */
            __OM uint32_t STUP : 1;    /*!< [1..1] State Update                                                       */
            __OM uint32_t ANUP : 1;    /*!< [2..2] Announce Message Generation Information Update                     */
            uint32_t           : 29;
        } SYRVLDR_b;
    };
    __IM uint32_t RESERVED4[3];

    union
    {
        __IOM uint32_t SYRFL1R;        /*!< (@ 0x00000090) SYNFP Reception Filter Register 1                          */

        struct
        {
            __IOM uint32_t ANCE0  : 1; /*!< [0..0] Announce Message Processing                                        */
            __IOM uint32_t ANCE1  : 1; /*!< [1..1] Announce Message Processing                                        */
            uint32_t              : 2;
            __IOM uint32_t SYNC0  : 1; /*!< [4..4] Sync Message Processing                                            */
            __IOM uint32_t SYNC1  : 1; /*!< [5..5] Sync Message Processing                                            */
            __IOM uint32_t SYNC2  : 1; /*!< [6..6] Sync Message Processing                                            */
            uint32_t              : 1;
            __IOM uint32_t FUP0   : 1; /*!< [8..8] Follow_Up Message Processing                                       */
            __IOM uint32_t FUP1   : 1; /*!< [9..9] Follow_Up Message Processing                                       */
            __IOM uint32_t FUP2   : 1; /*!< [10..10] Follow_Up Message Processing                                     */
            uint32_t              : 1;
            __IOM uint32_t DRQ0   : 1; /*!< [12..12] Delay_Req Message Processing                                     */
            __IOM uint32_t DRQ1   : 1; /*!< [13..13] Delay_Req Message Processing                                     */
            __IOM uint32_t DRQ2   : 1; /*!< [14..14] Delay_Req Message Processing                                     */
            uint32_t              : 1;
            __IOM uint32_t DRP0   : 1; /*!< [16..16] Delay_Resp Message Processing                                    */
            __IOM uint32_t DRP1   : 1; /*!< [17..17] Delay_Resp Message Processing                                    */
            __IOM uint32_t DRP2   : 1; /*!< [18..18] Delay_Resp Message Processing                                    */
            uint32_t              : 1;
            __IOM uint32_t PDRQ0  : 1; /*!< [20..20] Pdelay_Req Message Processing                                    */
            __IOM uint32_t PDRQ1  : 1; /*!< [21..21] Pdelay_Req Message Processing                                    */
            __IOM uint32_t PDRQ2  : 1; /*!< [22..22] Pdelay_Req Message Processing                                    */
            uint32_t              : 1;
            __IOM uint32_t PDRP0  : 1; /*!< [24..24] Pdelay_Resp Message Processing                                   */
            __IOM uint32_t PDRP1  : 1; /*!< [25..25] Pdelay_Resp Message Processing                                   */
            __IOM uint32_t PDRP2  : 1; /*!< [26..26] Pdelay_Resp Message Processing                                   */
            uint32_t              : 1;
            __IOM uint32_t PDFUP0 : 1; /*!< [28..28] Pdelay_Resp_Follow_Up Message Processing                         */
            __IOM uint32_t PDFUP1 : 1; /*!< [29..29] Pdelay_Resp_Follow_Up Message Processing                         */
            __IOM uint32_t PDFUP2 : 1; /*!< [30..30] Pdelay_Resp_Follow_Up Message Processing                         */
            uint32_t              : 1;
        } SYRFL1R_b;
    };

    union
    {
        __IOM uint32_t SYRFL2R;        /*!< (@ 0x00000094) SYNFP Reception Filter Register 2                          */

        struct
        {
            __IOM uint32_t MAN0 : 1;   /*!< [0..0] Management Message Processing Setting                              */
            __IOM uint32_t MAN1 : 1;   /*!< [1..1] Management Message Processing Setting                              */
            uint32_t            : 2;
            __IOM uint32_t SIG0 : 1;   /*!< [4..4] Signaling Message Processing Setting                               */
            __IOM uint32_t SIG1 : 1;   /*!< [5..5] Signaling Message Processing Setting                               */
            uint32_t            : 22;
            __IOM uint32_t ILL0 : 1;   /*!< [28..28] Illegal Message Processing Setting                               */
            __IOM uint32_t ILL1 : 1;   /*!< [29..29] Illegal Message Processing Setting                               */
            uint32_t            : 2;
        } SYRFL2R_b;
    };

    union
    {
        __IOM uint32_t SYTRENR;        /*!< (@ 0x00000098) SYNFP Transmission Enable Register                         */

        struct
        {
            __IOM uint32_t ANCE : 1;   /*!< [0..0] Announce Message Transmission Enable                               */
            uint32_t            : 3;
            __IOM uint32_t SYNC : 1;   /*!< [4..4] Sync Message Transmission Enable                                   */
            uint32_t            : 3;
            __IOM uint32_t DRQ  : 1;   /*!< [8..8] Delay_Req Message Transmission Enable                              */
            uint32_t            : 3;
            __IOM uint32_t PDRQ : 1;   /*!< [12..12] Pdelay_Req Message Transmission Enable                           */
            uint32_t            : 19;
        } SYTRENR_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t MTCIDU;          /*!< (@ 0x000000A0) Master Clock ID Registers                                  */

        struct
        {
            __IOM uint32_t MTCIDU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                         *   bits of the clock-ID of the master clock.                                 */
        } MTCIDU_b;
    };

    union
    {
        __IOM uint32_t MTCIDL;          /*!< (@ 0x000000A4) Master Clock ID Registers                                  */

        struct
        {
            __IOM uint32_t MTCIDL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                         *   of the clock-ID of the master clock.                                      */
        } MTCIDL_b;
    };

    union
    {
        __IOM uint32_t MTPID;          /*!< (@ 0x000000A8) Master clock port number register                          */

        struct
        {
            __IOM uint32_t PNUM : 16;  /*!< [15..0] Master Clock Port Number SettingThese bits hold the
                                        *   setting for the port number of the master clock.                          */
            uint32_t : 16;
        } MTPID_b;
    };
    __IM uint32_t RESERVED6[5];

    union
    {
        __IOM uint32_t SYTLIR;         /*!< (@ 0x000000C0) SYNFP Transmission Interval Setting Register               */

        struct
        {
            __IOM uint32_t ANCE : 8;   /*!< [7..0] Announce Message Transmission Interval SettingThese bits
                                        *   set the interval for the transmission of Announce messages.               */
            __IOM uint32_t SYNC : 8;   /*!< [15..8] Sync Message Transmission Interval SettingThese bits
                                        *   set the interval for the transmission of Sync messages.
                                        *   The setting is also placed in the logMessageInterval field
                                        *   of transmitted Sync messages.                                             */
            __IOM uint32_t DREQ : 8;   /*!< [23..16] Delay_Req Transmission Interval Average Value/ Pdelay_Req
                                        *   Transmission Interval SettingThe bits set the average interval
                                        *   for the transmission of Delay_Req messages and the interval
                                        *   for the transmission of Pdelay_Req messages.The setting
                                        *   is also placed in the logMessageInterval field of Delay_Resp
                                        *   messages.                                                                 */
            uint32_t : 8;
        } SYTLIR_b;
    };

    union
    {
        __IM uint32_t SYRLIR;          /*!< (@ 0x000000C4) SYNFP Received logMessageInterval Value Indication
                                        *                  Register                                                   */

        struct
        {
            __IM uint32_t ANCE : 8;    /*!< [7..0] Announce Message logMessageInterval Field IndicationThese
                                        *   bits indicate the logMessageInterval field value of a received
                                        *   Announce message.                                                         */
            __IM uint32_t SYNC : 8;    /*!< [15..8] Sync Message logMessageInterval Field IndicationThese
                                        *   bits indicate the logMessageInterval field value of a received
                                        *   Sync message.                                                             */
            __IM uint32_t DRESP : 8;   /*!< [23..16] Delay_Resp Message logMessageInterval Field IndicationThese
                                        *   bits indicate the logMessageInterval field value of a received
                                        *   Delay_Resp message.                                                       */
            uint32_t : 8;
        } SYRLIR_b;
    };

    union
    {
        __IM uint32_t OFMRU;           /*!< (@ 0x000000C8) offsetFromMaster Value Registers                           */

        struct
        {
            __IM uint32_t OFMRU : 32;  /*!< [31..0] These bits indicate the higher-order 32 bits of the
                                        *   calculated offsetFromMaster value.                                        */
        } OFMRU_b;
    };

    union
    {
        __IM uint32_t OFMRL;           /*!< (@ 0x000000CC) offsetFromMaster Value Registers                           */

        struct
        {
            __IM uint32_t OFMRL : 32;  /*!< [31..0] These bits indicate the lower-order 32 bits of the calculated
                                        *   offsetFromMaster value.                                                   */
        } OFMRL_b;
    };

    union
    {
        __IM uint32_t MPDRU;           /*!< (@ 0x000000D0) meanPathDelay Value Registers                              */

        struct
        {
            __IM uint32_t MPDRU : 32;  /*!< [31..0] These bits indicate the higher-order 32 bits of the
                                        *   calculated meanPathDelay value.                                           */
        } MPDRU_b;
    };

    union
    {
        __IM uint32_t MPDRL;           /*!< (@ 0x000000D4) meanPathDelay Value Registers                              */

        struct
        {
            __IM uint32_t MPDRL : 32;  /*!< [31..0] These bits indicate the lower-order 32 bits of the calculated
                                        *   meanPathDelay value.                                                      */
        } MPDRL_b;
    };
    __IM uint32_t RESERVED7[2];

    union
    {
        __IOM uint32_t GMPR;           /*!< (@ 0x000000E0) grandmasterPriority Field Setting Register                 */

        struct
        {
            __IOM uint32_t GMPR2 : 8;  /*!< [7..0] grandmasterPriority2 Field Value SettingThese bits are
                                        *   used to set the value of the grandmasterPriority2 fields
                                        *   of Announce messages.                                                     */
            uint32_t             : 8;
            __IOM uint32_t GMPR1 : 8;  /*!< [23..16] grandmasterPriority1 Field Value SettingThese bits
                                        *   are used to set the value of the grandmasterPriority1 fields
                                        *   of Announce messages.                                                     */
            uint32_t : 8;
        } GMPR_b;
    };

    union
    {
        __IOM uint32_t GMCQR;          /*!< (@ 0x000000E4) grandmasterClockQuality Field Setting Register             */

        struct
        {
            __IOM uint32_t GMCQR : 32; /*!< [31..0] These bits are used to set the value of the grandmasterClockQuality
                                        *   fields of Announce messages. The correspondence between
                                        *   bits and the grandmasterClockQuality fields is as listed
                                        *   below.b31 to b24: clockClassb23 to b16: clockAccuracyb15
                                        *   to b0: offsetScaledLogVariance                                            */
        } GMCQR_b;
    };

    union
    {
        __IOM uint32_t GMIDRU;          /*!< (@ 0x000000E8) grandmasterIdentity Field Setting Registers                */

        struct
        {
            __IOM uint32_t GMIDRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                         *   bits of the value of the grandmasterIdentity fields of
                                         *   Announce messages.                                                        */
        } GMIDRU_b;
    };

    union
    {
        __IOM uint32_t GMIDRL;          /*!< (@ 0x000000EC) grandmasterIdentity Field Setting Registers                */

        struct
        {
            __IOM uint32_t GMIDRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                         *   of the value of the grandmasterIdentity fields of Announce
                                         *   messages.                                                                 */
        } GMIDRL_b;
    };

    union
    {
        __IOM uint32_t CUOTSR;         /*!< (@ 0x000000F0) currentUtcOffset/timeSource Field Setting Register         */

        struct
        {
            __IOM uint32_t TSRC : 8;   /*!< [7..0] timeSource Field SettingThese bits set the value of the
                                        *   timeSource fields of Announce messages.                                   */
            uint32_t            : 8;
            __IOM uint32_t CUTO : 16;  /*!< [31..16] currentUtcOffset Field SettingThese bits set the value
                                        *   of the currentUtcOffset fields of Announce messages.                      */
        } CUOTSR_b;
    };

    union
    {
        __IOM uint32_t SRR;            /*!< (@ 0x000000F4) stepsRemoved Field Setting Register                        */

        struct
        {
            __IOM uint32_t SRMV : 16;  /*!< [15..0] stepsRemoved Field Value SettingThese bits set the value
                                        *   of the stepsRemoved fields of Announce messages.                          */
            uint32_t : 16;
        } SRR_b;
    };
    __IM uint32_t RESERVED8[2];

    union
    {
        __IOM uint32_t PPMACRU;          /*!< (@ 0x00000100) PTP-primary Message Destination MAC Address Setting
                                          *                  Registers                                                  */

        struct
        {
            __IOM uint32_t PPMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the destination MAC address for PTP-primary messages.             */
            uint32_t : 8;
        } PPMACRU_b;
    };

    union
    {
        __IOM uint32_t PPMACRL;          /*!< (@ 0x00000104) PTP-primary Message Destination MAC Address Setting
                                          *                  Registers                                                  */

        struct
        {
            __IOM uint32_t PPMACRL : 24; /*!< [23..0] These bits hold the setting for the lower-order 24 bits
                                          *   of the destination MAC address for PTP-primary messages.                  */
            uint32_t : 8;
        } PPMACRL_b;
    };

    union
    {
        __IOM uint32_t PDMACRU;          /*!< (@ 0x00000108) PTP-pdelay Message MAC Address Setting Registers           */

        struct
        {
            __IOM uint32_t PDMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the destination MAC address for PTP-pdelay messages.              */
            uint32_t : 8;
        } PDMACRU_b;
    };

    union
    {
        __IOM uint32_t PDMACRL;          /*!< (@ 0x0000010C) PTP-pdelay Message MAC Address Setting Registers           */

        struct
        {
            __IOM uint32_t PDMACRL : 24; /*!< [23..0] These bits hold the setting for the lower-order 24 bits
                                          *   of the destination MAC address for PTP-pdelay messages.                   */
            uint32_t : 8;
        } PDMACRL_b;
    };

    union
    {
        __IOM uint32_t PETYPER;        /*!< (@ 0x00000110) PTP Message EtherType Setting Register                     */

        struct
        {
            __IOM uint32_t TYPE : 16;  /*!< [15..0] PTP Message EtherType Value SettingThese bits hold the
                                        *   setting for the EtherType field value for frames in the
                                        *   Ethernet II format.                                                       */
            uint32_t : 16;
        } PETYPER_b;
    };
    __IM uint32_t RESERVED9[3];

    union
    {
        __IOM uint32_t PPIPR;          /*!< (@ 0x00000120) PTP-primary Message Destination IP Address Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t PPIPR : 32; /*!< [31..0] These bits hold the setting for the destination IP address
                                        *   for PTPprimary messages.                                                  */
        } PPIPR_b;
    };

    union
    {
        __IOM uint32_t PDIPR;          /*!< (@ 0x00000124) PTP-pdelay Message Destination IP Address Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t PDIPR : 32; /*!< [31..0] These bits hold the setting for the destination IP address
                                        *   for PTPpdelay messages.                                                   */
        } PDIPR_b;
    };

    union
    {
        __IOM uint32_t PETOSR;         /*!< (@ 0x00000128) PTP Event Message TOS Setting Register                     */

        struct
        {
            __IOM uint32_t EVTO : 8;   /*!< [7..0] PTP Event Message TOS Field Value SettingThese bits hold
                                        *   the setting for the value of the TOS field within the IPv4
                                        *   headers of PTP event messages.                                            */
            uint32_t : 24;
        } PETOSR_b;
    };

    union
    {
        __IOM uint32_t PGTOSR;         /*!< (@ 0x0000012C) PTP general Message TOS Setting Register                   */

        struct
        {
            __IOM uint32_t GETO : 8;   /*!< [7..0] PTP general Message TOS Field Value SettingThese bits
                                        *   hold the setting for the value of the TOS field within
                                        *   the IPv4 headers of PTP general messages.                                 */
            uint32_t : 24;
        } PGTOSR_b;
    };

    union
    {
        __IOM uint32_t PPTTLR;         /*!< (@ 0x00000130) PTP-primary Message TTL Setting Register                   */

        struct
        {
            __IOM uint32_t PRTL : 8;   /*!< [7..0] PTP-primary Message TTL Field Value SettingThese bits
                                        *   hold the setting for the value of the TTL field within
                                        *   the IPv4 headers of PTP-primary messages.                                 */
            uint32_t : 24;
        } PPTTLR_b;
    };

    union
    {
        __IOM uint32_t PDTTLR;         /*!< (@ 0x00000134) PTP-pdelay Message TTL Setting Register                    */

        struct
        {
            __IOM uint32_t PDTL : 8;   /*!< [7..0] PTP-pdelay Message TTL Field ValueThese bits hold the
                                        *   setting for the value of the TTL field within the IPv4
                                        *   headers of PTP-pdelay messages.                                           */
            uint32_t : 24;
        } PDTTLR_b;
    };

    union
    {
        __IOM uint32_t PEUDPR;         /*!< (@ 0x00000138) PTP Event Message UDP Destination Port Number
                                        *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t EVUPT : 16; /*!< [15..0] PTP Event Message Destination Port Number SettingThese
                                        *   bits hold the setting for the value of the destination
                                        *   port number field within the UDP headers of PTP event messages.           */
            uint32_t : 16;
        } PEUDPR_b;
    };

    union
    {
        __IOM uint32_t PGUDPR;         /*!< (@ 0x0000013C) PTP general Message UDP Destination Port Number
                                        *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t GEUPT : 16; /*!< [15..0] PTP general Message Destination Port NumberThese bits
                                        *   hold the setting for the value of the destination port
                                        *   number field within the UDP headers of PTP general messages.              */
            uint32_t : 16;
        } PGUDPR_b;
    };

    union
    {
        __IOM uint32_t FFLTR;          /*!< (@ 0x00000140) Frame Reception Filter Setting Register                    */

        struct
        {
            __IOM uint32_t SEL : 1;    /*!< [0..0] Receive MAC Address SelectNOTE: The setting of these
                                        *   bits is only effective when EXTPRM=0, ENB=1and RPT=1.                     */
            __IOM uint32_t PRT : 1;    /*!< [1..1] Frame Reception EnableNOTE: The setting of these bits
                                        *   is only effective when EXTPRM=0 and ENB=1.                                */
            __IOM uint32_t ENB : 1;    /*!< [2..2] Reception Filter EnableNOTE: The setting of these bits
                                        *   is only effective when EXTPRM=0.                                          */
            uint32_t              : 13;
            __IOM uint32_t EXTPRM : 1; /*!< [16..16] Extended Promiscuous ModeSetting                                 */
            uint32_t              : 15;
        } FFLTR_b;
    };
    __IM uint32_t RESERVED10[31];

    union
    {
        __IOM uint32_t DASYMRU;          /*!< (@ 0x000001C0) Asymmetric Delay Setting Registers                         */

        struct
        {
            __IOM uint32_t DASYMRU : 16; /*!< [15..0] These bits hold the setting for the higher-order 16
                                          *   bits of the asymmetric delay value.                                       */
            uint32_t : 16;
        } DASYMRU_b;
    };

    union
    {
        __IOM uint32_t DASYMRL;          /*!< (@ 0x000001C4) Asymmetric Delay Setting Registers                         */

        struct
        {
            __IOM uint32_t DASYMRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                          *   of the asymmetric delay value.                                            */
        } DASYMRL_b;
    };

    union
    {
        __IOM uint32_t TSLATR;         /*!< (@ 0x000001C8) Timestamp Latency Setting Register                         */

        struct
        {
            __IOM uint32_t EGP : 16;   /*!< [15..0] Input Port Timestamp Latency SettingThese bits hold
                                        *   the setting for the time stamp latency (ns) for the input
                                        *   ports.                                                                    */
            __IOM uint32_t INGP : 16;  /*!< [31..16] Output Port Timestamp Latency SettingThese bits hold
                                        *   the setting for the time stamp latency (ns) for the output
                                        *   ports.                                                                    */
        } TSLATR_b;
    };

    union
    {
        __IOM uint32_t SYCONFR;        /*!< (@ 0x000001CC) SYNFP Operation Setting Register                           */

        struct
        {
            __IOM uint32_t TCYC : 8;   /*!< [7..0] PTP Message Transmission Interval SettingThese bits are
                                        *   used to set the time from the completion of one transmission
                                        *   to the start of the next in cycles of the transmission
                                        *   clock. A value n in these bits means that a transmission
                                        *   interval of n cycles will be secured.No interval is secured
                                        *   if the setting is 00h.We recommend the setting 28h (40
                                        *   cycles).                                                                  */
            uint32_t              : 4;
            __IOM uint32_t SBDIS  : 1; /*!< [12..12] Sync Message Transmission Bandwidth Securing Disable             */
            uint32_t              : 3;
            __IOM uint32_t FILDIS : 1; /*!< [16..16] Receive Message domainNumber Filter Disable                      */
            uint32_t              : 3;
            __IOM uint32_t TCMOD  : 1; /*!< [20..20] TC Mode Setting                                                  */
            uint32_t              : 11;
        } SYCONFR_b;
    };

    union
    {
        __IOM uint32_t SYFORMR;        /*!< (@ 0x000001D0) SYNFP Frame Format Setting Register                        */

        struct
        {
            __IOM uint32_t FORM0 : 1;  /*!< [0..0] Ethernet/UDP Encapsulation                                         */
            __IOM uint32_t FORM1 : 1;  /*!< [1..1] Ethernet Frame Format Setting                                      */
            uint32_t             : 30;
        } SYFORMR_b;
    };

    union
    {
        __IOM uint32_t RSTOUTR;          /*!< (@ 0x000001D4) Response Message Reception Timeout Register                */

        struct
        {
            __IOM uint32_t RSTOUTR : 32; /*!< [31..0] Response Message Reception Timeout Time SettingA response
                                          *   message not being received within n x 1024 (ns), where
                                          *   n is the setting, is judged to represent a timeout.                       */
        } RSTOUTR_b;
    };
} R_ETHERC_EPTPC_Type;                   /*!< Size = 472 (0x1d8)                                                        */

/* =========================================================================================================================== */
/* ================                                    R_ETHERC_EPTPC_CFG                                     ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet PTP Configuration (R_ETHERC_EPTPC_CFG)
 */

typedef struct                         /*!< (@ 0x40064500) R_ETHERC_EPTPC_CFG Structure                               */
{
    union
    {
        __IOM uint32_t PTRSTR;         /*!< (@ 0x00000000) EPTPC Reset Register                                       */

        struct
        {
            __IOM uint32_t RESET : 1;  /*!< [0..0] EPTPC Software Reset                                               */
            uint32_t             : 31;
        } PTRSTR_b;
    };

    union
    {
        __IOM uint32_t STCSELR;         /*!< (@ 0x00000004) STCA Clock Select Register                                 */

        struct
        {
            __IOM uint32_t SCLKDIV : 3; /*!< [2..0] PCLKA Clock Frequency Division                                     */
            uint32_t               : 5;
            __IOM uint32_t SCLKSEL : 3; /*!< [10..8] STCA Clock Select                                                 */
            uint32_t               : 21;
        } STCSELR_b;
    };

    union
    {
        __IOM uint32_t BYPASS;          /*!< (@ 0x00000008) Bypass 1588 module Register                                */

        struct
        {
            __IOM uint32_t BYPASS0 : 1; /*!< [0..0] Bypass 1588 module for Ether 0ch                                   */
            uint32_t               : 15;
            __IOM uint32_t BYPASS1 : 1; /*!< [16..16] Bypass 1588 module for Ether 1ch                                 */
            uint32_t               : 15;
        } BYPASS_b;
    };
} R_ETHERC_EPTPC_CFG_Type;              /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                   R_ETHERC_EPTPC_COMMON                                   ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet PTP Controller Common (R_ETHERC_EPTPC_COMMON)
 */

typedef struct                         /*!< (@ 0x40065000) R_ETHERC_EPTPC_COMMON Structure                            */
{
    union
    {
        __IOM uint32_t MIESR;          /*!< (@ 0x00000000) MINT Interrupt Source Status Register                      */

        struct
        {
            __IM uint32_t ST    : 1;   /*!< [0..0] STCA Status Flag                                                   */
            __IM uint32_t SY0   : 1;   /*!< [1..1] SYNFP0 Status Flag                                                 */
            __IM uint32_t SY1   : 1;   /*!< [2..2] SYNFP1 Status Flag                                                 */
            __IM uint32_t PRC   : 1;   /*!< [3..3] PRC-TC Status Flag                                                 */
            uint32_t            : 12;
            __IOM uint32_t CYC0 : 1;   /*!< [16..16] Pulse Output Timer 0 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC1 : 1;   /*!< [17..17] Pulse Output Timer 1 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC2 : 1;   /*!< [18..18] Pulse Output Timer 2 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC3 : 1;   /*!< [19..19] Pulse Output Timer 3 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC4 : 1;   /*!< [20..20] Pulse Output Timer 4 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC5 : 1;   /*!< [21..21] Pulse Output Timer 5 Rising Edge Detection Flag                  */
            uint32_t            : 10;
        } MIESR_b;
    };

    union
    {
        __IOM uint32_t MIEIPR;         /*!< (@ 0x00000004) MINT Interrupt Request Permission Register                 */

        struct
        {
            __IOM uint32_t ST   : 1;   /*!< [0..0] STCA Status Interrupt Request Permission                           */
            __IOM uint32_t SY0  : 1;   /*!< [1..1] SYNFP0 Status Interrupt Request Permission                         */
            __IOM uint32_t SY1  : 1;   /*!< [2..2] SYNFP1 Status Interrupt Request Permission                         */
            __IOM uint32_t PRC  : 1;   /*!< [3..3] PRC-TC Status Interrupt Request Permission                         */
            uint32_t            : 12;
            __IOM uint32_t CYC0 : 1;   /*!< [16..16] Pulse Output Timer 0 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC1 : 1;   /*!< [17..17] Pulse Output Timer 1 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC2 : 1;   /*!< [18..18] Pulse Output Timer 2 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC3 : 1;   /*!< [19..19] Pulse Output Timer 3 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC4 : 1;   /*!< [20..20] Pulse Output Timer 4 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC5 : 1;   /*!< [21..21] Pulse Output Timer 5 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            uint32_t : 10;
        } MIEIPR_b;
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __IOM uint32_t ELIPPR;         /*!< (@ 0x00000010) ELC Output/ETHER_IPLS Interrupt Request Permission
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t CYCP0 : 1;  /*!< [0..0] Pulse Output Timer 0 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP1 : 1;  /*!< [1..1] Pulse Output Timer 1 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP2 : 1;  /*!< [2..2] Pulse Output Timer 2 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP3 : 1;  /*!< [3..3] Pulse Output Timer 3 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP4 : 1;  /*!< [4..4] Pulse Output Timer 4 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP5 : 1;  /*!< [5..5] Pulse Output Timer 5 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            uint32_t             : 2;
            __IOM uint32_t CYCN0 : 1;  /*!< [8..8] Pulse Output Timer 0 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN1 : 1;  /*!< [9..9] Pulse Output Timer 1 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN2 : 1;  /*!< [10..10] Pulse Output Timer 2 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN3 : 1;  /*!< [11..11] Pulse Output Timer 3 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN4 : 1;  /*!< [12..12] Pulse Output Timer 4 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN5 : 1;  /*!< [13..13] Pulse Output Timer 5 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            uint32_t            : 2;
            __IOM uint32_t PLSP : 1;   /*!< [16..16] Pulse Output Timer Rising Edge Detection IPLS Interrupt
                                        *   Request Permission                                                        */
            uint32_t            : 7;
            __IOM uint32_t PLSN : 1;   /*!< [24..24] Pulse Output Timer Falling Edge Detection IPLS Interrupt
                                        *   Request Permission                                                        */
            uint32_t : 7;
        } ELIPPR_b;
    };

    union
    {
        __IOM uint32_t ELIPACR;        /*!< (@ 0x00000014) ELC Output/IPLS Interrupt Permission Automatic
                                        *                  Clearing Register                                          */

        struct
        {
            __IOM uint32_t CYCP0 : 1;  /*!< [0..0] ELIPPR.CYCP0 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP1 : 1;  /*!< [1..1] ELIPPR.CYCP1 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP2 : 1;  /*!< [2..2] ELIPPR.CYCP2 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP3 : 1;  /*!< [3..3] ELIPPR.CYCP3 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP4 : 1;  /*!< [4..4] ELIPPR.CYCP4 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP5 : 1;  /*!< [5..5] ELIPPR.CYCP5 Bit Automatic Clearing                                */
            uint32_t             : 2;
            __IOM uint32_t CYCN0 : 1;  /*!< [8..8] ELIPPR.CYCN0 Bit Automatic Clearing                                */
            __IOM uint32_t CYCN1 : 1;  /*!< [9..9] ELIPPR.CYCN1 Bit Automatic Clearing                                */
            __IOM uint32_t CYCN2 : 1;  /*!< [10..10] ELIPPR.CYCN2 Bit Automatic Clearing                              */
            __IOM uint32_t CYCN3 : 1;  /*!< [11..11] ELIPPR.CYCN3 Bit Automatic Clearing                              */
            __IOM uint32_t CYCN4 : 1;  /*!< [12..12] ELIPPR.CYCN4 Bit Automatic Clearing                              */
            __IOM uint32_t CYCN5 : 1;  /*!< [13..13] ELIPPR.CYCN5 Bit Automatic Clearing                              */
            uint32_t             : 2;
            __IOM uint32_t PLSP  : 1;  /*!< [16..16] ELIPPR.PLSP Bit Automatic Clearing                               */
            uint32_t             : 7;
            __IOM uint32_t PLSN  : 1;  /*!< [24..24] ELIPPR.PLSN Bit Automatic Clearing                               */
            uint32_t             : 7;
        } ELIPACR_b;
    };
    __IM uint32_t RESERVED1[10];

    union
    {
        __IOM uint32_t STSR;            /*!< (@ 0x00000040) STCA Status Register                                       */

        struct
        {
            __IOM uint32_t SYNC    : 1; /*!< [0..0] Synchronized State Detection Flag                                  */
            __IOM uint32_t SYNCOUT : 1; /*!< [1..1] Synchronization Loss Detection Flag                                */
            uint32_t               : 1;
            __IOM uint32_t SYNTOUT : 1; /*!< [3..3] Sync Message Reception Timeout Detection Flag                      */
            __IOM uint32_t W10D    : 1; /*!< [4..4] Worst 10 Acquisition Completion Flag                               */
            uint32_t               : 27;
        } STSR_b;
    };

    union
    {
        __IOM uint32_t STIPR;           /*!< (@ 0x00000044) STCA Status Notification Permission Register               */

        struct
        {
            __IOM uint32_t SYNC    : 1; /*!< [0..0] SYNC Status Notification Enable                                    */
            __IOM uint32_t SYNCOUT : 1; /*!< [1..1] SYNCOUT Status Notification Enable                                 */
            uint32_t               : 1;
            __IOM uint32_t SYNTOUT : 1; /*!< [3..3] SYNTOUT Status Notification Enable                                 */
            __IOM uint32_t W10D    : 1; /*!< [4..4] W10D Status Notification Enable                                    */
            uint32_t               : 27;
        } STIPR_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t STCFR;          /*!< (@ 0x00000050) STCA Clock Frequency Setting Register                      */

        struct
        {
            __IOM uint32_t STCF : 2;   /*!< [1..0] STCA Clock Frequency                                               */
            uint32_t            : 30;
        } STCFR_b;
    };

    union
    {
        __IOM uint32_t STMR;           /*!< (@ 0x00000054) STCA Operating Mode Register                               */

        struct
        {
            __IOM uint32_t WINT  : 8;  /*!< [7..0] Worst 10 Acquisition Time                                          */
            uint32_t             : 5;
            __IOM uint32_t CMOD  : 1;  /*!< [13..13] Time Synchronization Correction Mode                             */
            uint32_t             : 1;
            __IOM uint32_t W10S  : 1;  /*!< [15..15] Worst 10 Acquisition Control Select                              */
            __IOM uint32_t SYTH  : 4;  /*!< [19..16] Synchronized State Detection Threshold Setting                   */
            __IOM uint32_t DVTH  : 4;  /*!< [23..20] Synchronization Loss Detection Threshold Setting                 */
            uint32_t             : 4;
            __IOM uint32_t ALEN0 : 1;  /*!< [28..28] Alarm Detection Enable 0                                         */
            __IOM uint32_t ALEN1 : 1;  /*!< [29..29] Alarm Detection Enable 1                                         */
            uint32_t             : 2;
        } STMR_b;
    };

    union
    {
        __IOM uint32_t SYNTOR;          /*!< (@ 0x00000058) Sync Message Reception Timeout Register                    */

        struct
        {
            __IOM uint32_t SYNTOR : 32; /*!< [31..0] A Sync message not being received within 1024 x n (ns),
                                         *   where n is the setting, leads to a timeout for reception
                                         *   of Sync messages, leading to the STSR.SYNTOUT flag being
                                         *   set to 1.                                                                 */
        } SYNTOR_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t IPTSELR;         /*!< (@ 0x00000060) IPLS Interrupt Request Timer Select Register               */

        struct
        {
            __IOM uint32_t IPTSEL0 : 1; /*!< [0..0] Pulse Output Timer 0 Select                                        */
            __IOM uint32_t IPTSEL1 : 1; /*!< [1..1] Pulse Output Timer 1 Select                                        */
            __IOM uint32_t IPTSEL2 : 1; /*!< [2..2] Pulse Output Timer 2 Select                                        */
            __IOM uint32_t IPTSEL3 : 1; /*!< [3..3] Pulse Output Timer 3 Select                                        */
            __IOM uint32_t IPTSEL4 : 1; /*!< [4..4] Pulse Output Timer 4 Select                                        */
            __IOM uint32_t IPTSEL5 : 1; /*!< [5..5] Pulse Output Timer 5 Select                                        */
            uint32_t               : 26;
        } IPTSELR_b;
    };

    union
    {
        __IOM uint32_t MITSELR;         /*!< (@ 0x00000064) MINT Interrupt Request Timer Select Register               */

        struct
        {
            __IOM uint32_t MINTEN0 : 1; /*!< [0..0] Pulse Output Timer 0 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN1 : 1; /*!< [1..1] Pulse Output Timer 1 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN2 : 1; /*!< [2..2] Pulse Output Timer 2 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN3 : 1; /*!< [3..3] Pulse Output Timer 3 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN4 : 1; /*!< [4..4] Pulse Output Timer 4 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN5 : 1; /*!< [5..5] Pulse Output Timer 5 MINT Interrupt Output Enable                  */
            uint32_t               : 26;
        } MITSELR_b;
    };

    union
    {
        __IOM uint32_t ELTSELR;         /*!< (@ 0x00000068) ELC Output Timer Select Register                           */

        struct
        {
            __IOM uint32_t ELTDIS0 : 1; /*!< [0..0] Pulse Output Timer 0 Event Generation Disable                      */
            __IOM uint32_t ELTDIS1 : 1; /*!< [1..1] Pulse Output Timer 1 Event Generation Disable                      */
            __IOM uint32_t ELTDIS2 : 1; /*!< [2..2] Pulse Output Timer 2 Event Generation Disable                      */
            __IOM uint32_t ELTDIS3 : 1; /*!< [3..3] Pulse Output Timer 3 Event Generation Disable                      */
            __IOM uint32_t ELTDIS4 : 1; /*!< [4..4] Pulse Output Timer 4 Event Generation Disable                      */
            __IOM uint32_t ELTDIS5 : 1; /*!< [5..5] Pulse Output Timer 5 Event Generation Disable                      */
            uint32_t               : 26;
        } ELTSELR_b;
    };

    union
    {
        __IOM uint32_t STCHSELR;       /*!< (@ 0x0000006C) Time Synchronization Channel Select Register               */

        struct
        {
            __IOM uint32_t SYSEL : 1;  /*!< [0..0] Timer Information Input SelectNOTE: Do not change the
                                        *   value of this bit while the SYNSTARTR.STR bit is 1.                       */
            uint32_t : 31;
        } STCHSELR_b;
    };
    __IM uint32_t RESERVED4[4];

    union
    {
        __IOM uint32_t SYNSTARTR;      /*!< (@ 0x00000080) Slave Time Synchronization Start Register                  */

        struct
        {
            __IOM uint32_t STR : 1;    /*!< [0..0] Slave Time Synchronization Control                                 */
            uint32_t           : 31;
        } SYNSTARTR_b;
    };

    union
    {
        __OM uint32_t LCIVLDR;         /*!< (@ 0x00000084) Local Time Counter Initial Value Load Directive
                                        *                  Register                                                   */

        struct
        {
            __OM uint32_t LOAD : 1;    /*!< [0..0] Local Time Counter Initial Value Load Directive                    */
            uint32_t           : 31;
        } LCIVLDR_b;
    };
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint32_t SYNTDARU;          /*!< (@ 0x00000090) Synchronization Loss Detection Threshold Registers         */

        struct
        {
            __IOM uint32_t SYNTDARU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                           *   bits of the threshold for detection of loss of synchronization.           */
        } SYNTDARU_b;
    };

    union
    {
        __IOM uint32_t SYNTDARL;          /*!< (@ 0x00000094) Synchronization Loss Detection Threshold Registers         */

        struct
        {
            __IOM uint32_t SYNTDARL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the threshold for detection of loss of synchronization.                */
        } SYNTDARL_b;
    };

    union
    {
        __IOM uint32_t SYNTDBRU;          /*!< (@ 0x00000098) Synchronization Detection Threshold Registers              */

        struct
        {
            __IOM uint32_t SYNTDBRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                           *   bits of the threshold for detection of synchronization.                   */
        } SYNTDBRU_b;
    };

    union
    {
        __IOM uint32_t SYNTDBRL;          /*!< (@ 0x0000009C) Synchronization Detection Threshold Registers              */

        struct
        {
            __IOM uint32_t SYNTDBRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the threshold for detection of synchronization.                        */
        } SYNTDBRL_b;
    };
    __IM uint32_t RESERVED6[4];

    union
    {
        __IOM uint32_t LCIVRU;          /*!< (@ 0x000000B0) Local Time Counter Initial Value Registers                 */

        struct
        {
            __IOM uint32_t LCIVRU : 16; /*!< [15..0] These bits hold the setting for the higher-order 16
                                         *   bits of the integer portion of the initial value for the
                                         *   local timer counter.                                                      */
            uint32_t : 16;
        } LCIVRU_b;
    };

    union
    {
        __IOM uint32_t LCIVRM;          /*!< (@ 0x000000B4) Local Time Counter Initial Value Registers                 */

        struct
        {
            __IOM uint32_t LCIVRM : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                         *   of the integer portion of the initial value for the local
                                         *   timer counter.                                                            */
        } LCIVRM_b;
    };

    union
    {
        __IOM uint32_t LCIVRL;          /*!< (@ 0x000000B8) Local Time Counter Initial Value Registers                 */

        struct
        {
            __IOM uint32_t LCIVRL : 32; /*!< [31..0] These bits hold the setting for the fractional portion
                                         *   of the initial value of the local timer counter in nanoseconds.           */
        } LCIVRL_b;
    };
    __IM uint32_t RESERVED7[26];

    union
    {
        __IOM uint32_t GETW10R;        /*!< (@ 0x00000124) Worst 10 Acquisition Directive Register                    */

        struct
        {
            __IOM uint32_t GW10 : 1;   /*!< [0..0] Worst 10 Acquisition Directive                                     */
            uint32_t            : 31;
        } GETW10R_b;
    };

    union
    {
        __IOM uint32_t PLIMITRU;          /*!< (@ 0x00000128) Positive Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t PLIMITRU : 31; /*!< [30..0] These bits hold the setting for the higher-order 31
                                           *   bits of the limit for the positive gradient.                              */
            uint32_t : 1;
        } PLIMITRU_b;
    };

    union
    {
        __IOM uint32_t PLIMITRM;          /*!< (@ 0x0000012C) Positive Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t PLIMITRM : 32; /*!< [31..0] These bits hold the setting for the middle-order 32
                                           *   bits of the limit for the positive gradient.                              */
        } PLIMITRM_b;
    };

    union
    {
        __IOM uint32_t PLIMITRL;          /*!< (@ 0x00000130) Positive Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t PLIMITRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the limit for the positive gradient.                                   */
        } PLIMITRL_b;
    };

    union
    {
        __IOM uint32_t MLIMITRU;          /*!< (@ 0x00000134) Negative Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t MLIMITRU : 31; /*!< [30..0] These bits hold the setting for the higher-order 31
                                           *   bits of the limit for the negative gradient.                              */
            uint32_t : 1;
        } MLIMITRU_b;
    };

    union
    {
        __IOM uint32_t MLIMITRM;          /*!< (@ 0x00000138) Negative Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t MLIMITRM : 32; /*!< [31..0] These bits hold the setting for the middle-order 32
                                           *   bits of the limit for the negative gradient.                              */
        } MLIMITRM_b;
    };

    union
    {
        __IOM uint32_t MLIMITRL;          /*!< (@ 0x0000013C) Negative Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t MLIMITRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the limit for the negative gradient.                                   */
        } MLIMITRL_b;
    };

    union
    {
        __IOM uint32_t GETINFOR;       /*!< (@ 0x00000140) Statistical Information Retention Control Register         */

        struct
        {
            __IOM uint32_t INFO : 1;   /*!< [0..0] Information Retention ControlNOTE: Once information fetching
                                        *   is directed, values of various statistical information
                                        *   read before completion of information fetching are not
                                        *   guaranteed.                                                               */
            uint32_t : 31;
        } GETINFOR_b;
    };
    __IM uint32_t RESERVED8[11];

    union
    {
        __IM uint32_t LCCVRU;          /*!< (@ 0x00000170) Local Time Counters                                        */

        struct
        {
            __IM uint32_t LCCVRU : 16; /*!< [15..0] These bits are for reading the higher-order 16 bits
                                        *   of the integer portion of the local timer counter's value.                */
            uint32_t : 16;
        } LCCVRU_b;
    };

    union
    {
        __IM uint32_t LCCVRM;          /*!< (@ 0x00000174) Local Time Counters                                        */

        struct
        {
            __IM uint32_t LCCVRM : 32; /*!< [31..0] These bits are for reading the lower-order 32 bits of
                                        *   the integer portion of the local timer counter's value.                   */
        } LCCVRM_b;
    };

    union
    {
        __IM uint32_t LCCVRL;          /*!< (@ 0x00000178) Local Time Counters                                        */

        struct
        {
            __IM uint32_t LCCVRL : 32; /*!< [31..0] These bits are for reading the fractional portion of
                                        *   the local timer counter's value (in nanoseconds).                         */
        } LCCVRL_b;
    };
    __IM uint32_t RESERVED9[37];

    union
    {
        __IM uint32_t PW10VRU;          /*!< (@ 0x00000210) Positive Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t PW10VRU : 32; /*!< [31..0] These bits are for reading the higher-order 32 bits
                                         *   of the positive gradient value.                                           */
        } PW10VRU_b;
    };

    union
    {
        __IM uint32_t PW10VRM;          /*!< (@ 0x00000214) Positive Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t PW10VRM : 32; /*!< [31..0] These bits are for reading the middle-order 32 bits
                                         *   of the positive gradient value.                                           */
        } PW10VRM_b;
    };

    union
    {
        __IM uint32_t PW10VRL;          /*!< (@ 0x00000218) Positive Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t PW10VRL : 32; /*!< [31..0] These bits are for reading the lower-order 32 bits of
                                         *   the positive gradient value.                                              */
        } PW10VRL_b;
    };
    __IM uint32_t RESERVED10[45];

    union
    {
        __IM uint32_t MW10RU;          /*!< (@ 0x000002D0) Negative Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t MW10RU : 32; /*!< [31..0] These bits are for reading the higher-order 32 bits
                                        *   of the negative gradient value.                                           */
        } MW10RU_b;
    };

    union
    {
        __IM uint32_t MW10RM;          /*!< (@ 0x000002D4) Negative Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t MW10RM : 32; /*!< [31..0] These bits are for reading the middle-order 32 bits
                                        *   of the negative gradient value.                                           */
        } MW10RM_b;
    };

    union
    {
        __IM uint32_t MW10RL;                  /*!< (@ 0x000002D8) Negative Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t MW10RL : 32;         /*!< [31..0] These bits are for reading the lower-order 32 bits of
                                                *   the negative gradient value.                                              */
        } MW10RL_b;
    };
    __IM uint32_t RESERVED11[9];
    __IOM R_ETHERC_EPTPC_COMMON_TM_Type TM[6]; /*!< (@ 0x00000300) Timer Setting Registers                                    */
    __IM uint32_t RESERVED12[7];

    union
    {
        __IOM uint32_t TMSTARTR;       /*!< (@ 0x0000037C) Timer Start Register                                       */

        struct
        {
            __IOM uint32_t EN0 : 1;    /*!< [0..0] Pulse Output Timer 0 Start                                         */
            __IOM uint32_t EN1 : 1;    /*!< [1..1] Pulse Output Timer 1 Start                                         */
            __IOM uint32_t EN2 : 1;    /*!< [2..2] Pulse Output Timer 2 Start                                         */
            __IOM uint32_t EN3 : 1;    /*!< [3..3] Pulse Output Timer 3 Start                                         */
            __IOM uint32_t EN4 : 1;    /*!< [4..4] Pulse Output Timer 4 Start                                         */
            __IOM uint32_t EN5 : 1;    /*!< [5..5] Pulse Output Timer 5 Start                                         */
            uint32_t           : 26;
        } TMSTARTR_b;
    };
    __IM uint32_t RESERVED13[32];

    union
    {
        __IOM uint32_t PRSR;           /*!< (@ 0x00000400) PRC-TC Status Register                                     */

        struct
        {
            __IOM uint32_t OVRE0 : 1;  /*!< [0..0] Relay Packet Overflow Detection Flag 0                             */
            __IOM uint32_t OVRE1 : 1;  /*!< [1..1] Relay Packet Overflow Detection Flag 1                             */
            __IOM uint32_t OVRE2 : 1;  /*!< [2..2] Relay Packet Overflow Detection Flag 2                             */
            __IOM uint32_t OVRE3 : 1;  /*!< [3..3] Relay Packet Overflow Detection Flag 3                             */
            uint32_t             : 4;
            __IOM uint32_t MACE  : 1;  /*!< [8..8] Originating MAC Address Mismatch Detection Flag                    */
            uint32_t             : 19;
            __IOM uint32_t URE0  : 1;  /*!< [28..28] Relay Packet Underflow Detection Flag 0                          */
            __IOM uint32_t URE1  : 1;  /*!< [29..29] Relay Packet Underflow Detection Flag 1                          */
            uint32_t             : 2;
        } PRSR_b;
    };

    union
    {
        __IOM uint32_t PRIPR;          /*!< (@ 0x00000404) PRC-TC Status Notification Permission Register             */

        struct
        {
            __IOM uint32_t OVRE0 : 1;  /*!< [0..0] PRSR.OVRE0 Status Notification Permission                          */
            __IOM uint32_t OVRE1 : 1;  /*!< [1..1] PRSR.OVRE1 Status Notification Permission                          */
            __IOM uint32_t OVRE2 : 1;  /*!< [2..2] PRSR.OVRE2 Status Notification Permission                          */
            __IOM uint32_t OVRE3 : 1;  /*!< [3..3] PRSR.OVRE3 Status Notification Permission                          */
            uint32_t             : 4;
            __IOM uint32_t MACE  : 1;  /*!< [8..8] PRSR.MACE Status Notification Permission                           */
            uint32_t             : 19;
            __IOM uint32_t URE0  : 1;  /*!< [28..28] PRSR.URE0 Status Notification Permission                         */
            __IOM uint32_t URE1  : 1;  /*!< [29..29] PRSR.URE1 Status Notification Permission                         */
            uint32_t             : 2;
        } PRIPR_b;
    };
    __IM uint32_t RESERVED14[2];
    __IOM R_ETHERC_EPTPC_COMMON_PR_Type PR[2]; /*!< (@ 0x00000410) Local MAC Address Registers                                */

    union
    {
        __IOM uint32_t TRNDISR;                /*!< (@ 0x00000420) Packet Transmission Control Register                       */

        struct
        {
            __IOM uint32_t TDIS : 2;           /*!< [1..0] Packet Transmission Control                                        */
            uint32_t            : 30;
        } TRNDISR_b;
    };
    __IM uint32_t RESERVED15[3];

    union
    {
        __IOM uint32_t TRNMR;          /*!< (@ 0x00000430) Relay Mode Register                                        */

        struct
        {
            __IOM uint32_t MOD  : 1;   /*!< [0..0] Cut-Through Mode                                                   */
            uint32_t            : 7;
            __IOM uint32_t FWD0 : 1;   /*!< [8..8] Channel 0 Relay Enable                                             */
            __IOM uint32_t FWD1 : 1;   /*!< [9..9] Channel 1 Relay Enable                                             */
            uint32_t            : 22;
        } TRNMR_b;
    };

    union
    {
        __IOM uint32_t TRNCTTDR;       /*!< (@ 0x00000434) Cut-Through Transfer Start Threshold Register              */

        struct
        {
            __IOM uint32_t THVAL : 11; /*!< [10..0] FIFO Read Start ThresholdThreshold for starting to read
                                        *   data from the relay FIFO in cut-through mode (specified
                                        *   as the number of bytes)NOTE1: A value cannot be set in
                                        *   the lower-order 2 bits. These bits are fixed to 0.NOTE2:
                                        *   A value of less than 96 bytes cannot be set.                              */
            uint32_t : 21;
        } TRNCTTDR_b;
    };
} R_ETHERC_EPTPC_COMMON_Type;          /*!< Size = 1080 (0x438)                                                       */

/* =========================================================================================================================== */
/* ================                                       R_FACI_HP_CMD                                       ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface Command-Issuing Area (R_FACI_HP_CMD)
 */

typedef struct                         /*!< (@ 0x407E0000) R_FACI_HP_CMD Structure                                    */
{
    union
    {
        __IOM uint16_t FACI_CMD16;     /*!< (@ 0x00000000) FACI Command Issuing Area (halfword access)                */
        __IOM uint8_t  FACI_CMD8;      /*!< (@ 0x00000000) FACI Command Issuing Area (halfword access)                */
    };
} R_FACI_HP_CMD_Type;                  /*!< Size = 2 (0x2)                                                            */

/* =========================================================================================================================== */
/* ================                                         R_FACI_HP                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface (R_FACI_HP)
 */

typedef struct                         /*!< (@ 0x407FE000) R_FACI_HP Structure                                        */
{
    __IM uint32_t RESERVED[4];

    union
    {
        __IOM uint8_t FASTAT;          /*!< (@ 0x00000010) Flash Access Status                                        */

        struct
        {
            __IM uint8_t ECRCT  : 1;   /*!< [0..0] ECRCT                                                              */
            uint8_t             : 2;
            __IOM uint8_t DFAE  : 1;   /*!< [3..3] Data Flash Access Error                                            */
            __IM uint8_t  CMDLK : 1;   /*!< [4..4] Command Lock                                                       */
            uint8_t             : 2;
            __IOM uint8_t CFAE  : 1;   /*!< [7..7] Code Flash Access Error                                            */
        } FASTAT_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint8_t FAEINT;          /*!< (@ 0x00000014) Flash Access Error Interrupt Enable                        */

        struct
        {
            __IOM uint8_t ECRCTIE : 1; /*!< [0..0] Error Correct Interrupt Enable                                     */
            uint8_t               : 2;
            __IOM uint8_t DFAEIE  : 1; /*!< [3..3] Data Flash Access Error Interrupt Enable                           */
            __IOM uint8_t CMDLKIE : 1; /*!< [4..4] Command Lock Interrupt Enable                                      */
            uint8_t               : 2;
            __IOM uint8_t CFAEIE  : 1; /*!< [7..7] Code Flash Access Error Interrupt Enable                           */
        } FAEINT_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint8_t FRDYIE;          /*!< (@ 0x00000018) Flash Ready Interrupt Enable                               */

        struct
        {
            __IOM uint8_t FRDYIE : 1;  /*!< [0..0] FRDY Interrupt Enable                                              */
            uint8_t              : 7;
        } FRDYIE_b;
    };
    __IM uint8_t  RESERVED5;
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[5];

    union
    {
        __IOM uint32_t FSADDR;         /*!< (@ 0x00000030) Flash Start Address                                        */

        struct
        {
            __IOM uint32_t FSA : 32;   /*!< [31..0] Start Address of Flash Sequencer Command Target Area
                                        *   These bits can be written when FRDY bit of FSTATR register
                                        *   is "1". Writing to these bits in FRDY = "0" is ignored.                   */
        } FSADDR_b;
    };

    union
    {
        __IOM uint32_t FEADDR;         /*!< (@ 0x00000034) Flash End Address                                          */

        struct
        {
            __IOM uint32_t FEA : 32;   /*!< [31..0] End Address of Flash Sequencer Command Target Area Specifies
                                        *   end address of target area in "Blank Check" command. These
                                        *   bits can be written when FRDY bit of FSTATR register is
                                        *   "1". Writing to these bits in FRDY = "0" is ignored.                      */
        } FEADDR_b;
    };
    __IM uint32_t RESERVED8[3];

    union
    {
        __IOM uint16_t FMEPROT;        /*!< (@ 0x00000044) Flash P/E Mode Entry Protection Register                   */

        struct
        {
            __IOM uint16_t CEPROT : 1; /*!< [0..0] Code Flash P/E Mode Entry ProtectionWriting to this bit
                                        *   is only possible when the FRDY bit in the FSTATR register
                                        *   is 1. Writing to this bit while the FRDY bit = 0 isignored.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY bits is D9h.Written values
                                        *   are not retained by these bits (always read as 0x00).Only
                                        *   secure access can write to this register. Both secure access
                                        *   and non-secure read access are allowed. Non-secure writeaccess
                                        *   is denied, but TrustZo                                                    */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FMEPROT_b;
    };
    __IM uint16_t RESERVED9;
    __IM uint32_t RESERVED10[12];

    union
    {
        __IOM uint16_t FBPROT0;        /*!< (@ 0x00000078) Flash Block Protection Register                            */

        struct
        {
            __IOM uint16_t BPCN0 : 1;  /*!< [0..0] Block Protection for Non-secure CancelThis bit can be
                                        *   written when the FRDY bit in the FSTATR register is 1.
                                        *   Writing to this bit is ignored when the FRDY bit is 0.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY[7:0] bits is 0x78.Written
                                        *   values are not retained by these bits (always read as 0x00).              */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FBPROT0_b;
    };
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint16_t FBPROT1;        /*!< (@ 0x0000007C) Flash Block Protection for Secure Register                 */

        struct
        {
            __IOM uint16_t BPCN1 : 1;  /*!< [0..0] Block Protection for Secure CancelWriting to this bit
                                        *   is only possible when the FRDY bit in the FSTATR register
                                        *   is 1. Writing to this bit while FRDY bit = 0 is ignored.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY[7:0] bits is 0xB1.Written
                                        *   values are not retained by these bits (always read as 0x00).              */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FBPROT1_b;
    };
    __IM uint16_t RESERVED12;

    union
    {
        __IM uint32_t FSTATR;          /*!< (@ 0x00000080) Flash Status                                               */

        struct
        {
            uint32_t                 : 6;
            __IM uint32_t FLWEERR    : 1; /*!< [6..6] Flash Write/Erase Protect Error Flag                               */
            uint32_t                 : 1;
            __IM uint32_t PRGSPD     : 1; /*!< [8..8] Programming-Suspended Status                                       */
            __IM uint32_t ERSSPD     : 1; /*!< [9..9] Erasure-Suspended Status                                           */
            __IM uint32_t DBFULL     : 1; /*!< [10..10] Data Buffer Full                                                 */
            __IM uint32_t SUSRDY     : 1; /*!< [11..11] Suspend Ready                                                    */
            __IM uint32_t PRGERR     : 1; /*!< [12..12] Programming Error                                                */
            __IM uint32_t ERSERR     : 1; /*!< [13..13] Erasure Error                                                    */
            __IM uint32_t ILGLERR    : 1; /*!< [14..14] Illegal Command Error                                            */
            __IM uint32_t FRDY       : 1; /*!< [15..15] Flash Ready                                                      */
            uint32_t                 : 4;
            __IM uint32_t  OTERR     : 1; /*!< [20..20] Other Error                                                      */
            __IOM uint32_t SECERR    : 1; /*!< [21..21] Security Error                                                   */
            __IM uint32_t  FESETERR  : 1; /*!< [22..22] FENTRY Setting Error                                             */
            __IM uint32_t  ILGCOMERR : 1; /*!< [23..23] Illegal Command Error                                            */
            uint32_t                 : 8;
        } FSTATR_b;
    };

    union
    {
        __IOM uint16_t FENTRYR;         /*!< (@ 0x00000084) Program/Erase Mode Entry                                   */

        struct
        {
            __IOM uint16_t FENTRYC : 1; /*!< [0..0] Code Flash P/E Mode Entry These bits can be written when
                                         *   FRDY bit in FSTATR register is "1". Writing to this bit
                                         *   in FRDY = "0" is ignored. Writing to these bits is enabled
                                         *   only when this register is accessed in 16-bit size and
                                         *   H'AA is written to KEY bits                                               */
            uint16_t               : 6;
            __IOM uint16_t FENTRYD : 1; /*!< [7..7] Data Flash P/E Mode Entry These bits can be written when
                                         *   FRDY bit in FSTATR register is "1". Writing to this bit
                                         *   in FRDY = "0" is ignored. Writing to these bits is enabled
                                         *   only when this register is accessed in 16-bit size and
                                         *   H'AA is written to KEY bits.                                              */
            __OM uint16_t KEY : 8;      /*!< [15..8] KEY Code                                                          */
        } FENTRYR_b;
    };
    __IM uint16_t RESERVED13;
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint16_t FSUINITR;       /*!< (@ 0x0000008C) Flash Sequencer Set-up Initialize                          */

        struct
        {
            __IOM uint16_t SUINIT : 1; /*!< [0..0] Set-up Initialization This bit can be written when FRDY
                                        *   bit of FSTATR register is "1". Writing to this bit in FRDY
                                        *   = "0" is ignored. Writing to these bits is enabled only
                                        *   when this register is accessed in 16-bit size and H'2D
                                        *   is written to KEY bits.                                                   */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FSUINITR_b;
    };
    __IM uint16_t RESERVED15;
    __IM uint32_t RESERVED16[4];

    union
    {
        __IM uint16_t FCMDR;           /*!< (@ 0x000000A0) Flash Sequencer Command                                    */

        struct
        {
            __IM uint16_t PCMDR : 8;   /*!< [7..0] Previous Command Register                                          */
            __IM uint16_t CMDR  : 8;   /*!< [15..8] Command Register                                                  */
        } FCMDR_b;
    };
    __IM uint16_t RESERVED17;
    __IM uint32_t RESERVED18[7];

    union
    {
        __IM uint16_t FPESTAT;         /*!< (@ 0x000000C0) Program/Erase Error Status                                 */

        struct
        {
            __IM uint16_t PEERRST : 8; /*!< [7..0] P/E Error Status                                                   */
            uint16_t              : 8;
        } FPESTAT_b;
    };
    __IM uint16_t RESERVED19;
    __IM uint32_t RESERVED20[3];

    union
    {
        __IOM uint8_t FBCCNT;          /*!< (@ 0x000000D0) Blank Check Control                                        */

        struct
        {
            __IOM uint8_t BCDIR : 1;   /*!< [0..0] Blank Check Direction                                              */
            uint8_t             : 7;
        } FBCCNT_b;
    };
    __IM uint8_t  RESERVED21;
    __IM uint16_t RESERVED22;

    union
    {
        __IM uint8_t FBCSTAT;          /*!< (@ 0x000000D4) Blank Check Status                                         */

        struct
        {
            __IM uint8_t BCST : 1;     /*!< [0..0] Blank Check Status Bit                                             */
            uint8_t           : 7;
        } FBCSTAT_b;
    };
    __IM uint8_t  RESERVED23;
    __IM uint16_t RESERVED24;

    union
    {
        __IM uint32_t FPSADDR;         /*!< (@ 0x000000D8) Programmed Area Start Address                              */

        struct
        {
            __IM uint32_t PSADR : 19;  /*!< [18..0] Programmed Area Start Address NOTE: Indicates address
                                        *   of the first programmed data which is found in "Blank Check"
                                        *   command execution.                                                        */
            uint32_t : 13;
        } FPSADDR_b;
    };

    union
    {
        __IM uint32_t FAWMON;          /*!< (@ 0x000000DC) Flash Access Window Monitor                                */

        struct
        {
            __IM uint32_t FAWS : 11;   /*!< [10..0] Start Sector Address for Access Window NOTE: These bits
                                        *   indicate the start sector address for setting the access
                                        *   window that is located in the configuration area.                         */
            uint32_t           : 4;
            __IM uint32_t FSPR : 1;    /*!< [15..15] Protection Flag of programming the Access Window, Boot
                                        *   Flag and Temporary Boot Swap Control and "Config Clear"
                                        *   command execution                                                         */
            __IM uint32_t FAWE : 11;   /*!< [26..16] End Sector Address for Access Window NOTE: These bits
                                        *   indicate the end sector address for setting the access
                                        *   window that is located in the configuration area.                         */
            uint32_t            : 4;
            __IM uint32_t BTFLG : 1;   /*!< [31..31] Flag of Start-Up area select for Boot Swap                       */
        } FAWMON_b;
    };

    union
    {
        __IOM uint16_t FCPSR;           /*!< (@ 0x000000E0) FCU Process Switch                                         */

        struct
        {
            __IOM uint16_t ESUSPMD : 1; /*!< [0..0] Erasure-Suspended Mode                                             */
            uint16_t               : 15;
        } FCPSR_b;
    };
    __IM uint16_t RESERVED25;

    union
    {
        __IOM uint16_t FPCKAR;         /*!< (@ 0x000000E4) Flash Sequencer Processing Clock Frequency Notification    */

        struct
        {
            __IOM uint16_t PCKA : 8;   /*!< [7..0] Flash Sequencer Processing Clock Frequency These bits
                                        *   can be written when FRDY bit in FSTATR register is "1".
                                        *   Writing to this bit in FRDY = "0" is ignored. Writing to
                                        *   these bits is enabled only when this register is accessed
                                        *   in 16-bit size and H'1E is written to KEY bits.                           */
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FPCKAR_b;
    };
    __IM uint16_t RESERVED26;

    union
    {
        __IOM uint16_t FSUACR;         /*!< (@ 0x000000E8) Flash Start-Up Area Control Register                       */

        struct
        {
            __IOM uint16_t SAS : 2;    /*!< [1..0] Start Up Area Select These bits can be written when FRDY
                                        *   bit in FSTATR register is "1". Writing to this bit in FRDY
                                        *   = "0" is ignored. Writing to these bits is enabled only
                                        *   when this register is accessed in 16-bit size and H'66
                                        *   is written to KEY bits.                                                   */
            uint16_t          : 6;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FSUACR_b;
    };
    __IM uint16_t RESERVED27;
} R_FACI_HP_Type;                      /*!< Size = 236 (0xec)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_FACI_LP                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface (R_FACI_LP)
 */

typedef struct                         /*!< (@ 0x407EC000) R_FACI_LP Structure                                        */
{
    __IM uint32_t RESERVED[36];
    __IOM uint8_t DFLCTL;              /*!< (@ 0x00000090) Flash P/E Mode Control Register                            */
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[27];

    union
    {
        __IOM uint8_t FPMCR;           /*!< (@ 0x00000100) Flash P/E Mode Control Register                            */

        struct
        {
            uint8_t            : 1;
            __IOM uint8_t FMS0 : 1;    /*!< [1..1] Flash Operating Mode Select 0FMS2,1,0: 000: Read mode
                                        *   011: Discharge mode 1 111: Discharge mode 2 101: Code Flash
                                        *   P/E mode 010: Data flash P/E mode Others: Setting prohibited.             */
            uint8_t             : 1;
            __IOM uint8_t RPDIS : 1;   /*!< [3..3] Code Flash P/E Disable                                             */
            __IOM uint8_t FMS1  : 1;   /*!< [4..4] The bit to make data flash a programming modeRefer to
                                        *   the description of the FMS0 bit.                                          */
            uint8_t            : 1;
            __IOM uint8_t VLPE : 1;    /*!< [6..6] Low-Voltage P/E Mode Enable                                        */
            __IOM uint8_t FMS2 : 1;    /*!< [7..7] Flash Operating Mode Select 2.Refer to the description
                                        *   of the FMS0 bit.                                                          */
        } FPMCR_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint16_t RESERVED5;

    union
    {
        __IOM uint8_t FASR;            /*!< (@ 0x00000104) Flash Area Select Register                                 */

        struct
        {
            __IOM uint8_t EXS : 1;     /*!< [0..0] Extra area select                                                  */
            uint8_t           : 7;
        } FASR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t FSARL;             /*!< (@ 0x00000108) Flash Processing Start Address Register L                  */

        struct
        {
            __IOM uint16_t FSAR15_0 : 16; /*!< [15..0] Start address                                                     */
        } FSARL_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint16_t FSARH;             /*!< (@ 0x00000110) Flash Processing Start Address Register H                  */

        struct
        {
            __IOM uint16_t FSAR20_16 : 5; /*!< [4..0] Start address                                                      */
            uint16_t                 : 4;
            __IOM uint16_t FSAR31_25 : 7; /*!< [15..9] Start address                                                     */
        } FSARH_b;
    };
    __IM uint16_t RESERVED10;

    union
    {
        __IOM uint8_t FCR;             /*!< (@ 0x00000114) Flash Control Register                                     */

        struct
        {
            __IOM uint8_t CMD  : 4;    /*!< [3..0] Software Command Setting                                           */
            __IOM uint8_t DRC  : 1;    /*!< [4..4] Data Read Completion                                               */
            uint8_t            : 1;
            __IOM uint8_t STOP : 1;    /*!< [6..6] Forced Processing Stop                                             */
            __IOM uint8_t OPST : 1;    /*!< [7..7] Processing Start                                                   */
        } FCR_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;

    union
    {
        __IOM uint16_t FEARL;             /*!< (@ 0x00000118) Flash Processing End Address Register L                    */

        struct
        {
            __IOM uint16_t FEAR15_0 : 16; /*!< [15..0] End address                                                       */
        } FEARL_b;
    };
    __IM uint16_t RESERVED13;
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint32_t FEARH;             /*!< (@ 0x00000120) Flash Processing End Address Register H                    */

        struct
        {
            __IOM uint32_t FEAR20_16 : 5; /*!< [4..0] End address                                                        */
            uint32_t                 : 4;
            __IOM uint32_t FEAR31_25 : 7; /*!< [15..9] End address                                                       */
            uint32_t                 : 16;
        } FEARH_b;
    };

    union
    {
        __IOM uint32_t FRESETR;        /*!< (@ 0x00000124) Flash Reset Register                                       */

        struct
        {
            __IOM uint32_t FRESET : 1; /*!< [0..0] Software Reset of the registers                                    */
            uint32_t              : 31;
        } FRESETR_b;
    };

    union
    {
        __IM uint32_t FSTATR00;         /*!< (@ 0x00000128) Flash Status Register00                                    */

        struct
        {
            __IM uint32_t ERERR0   : 1; /*!< [0..0] Erase Error Flag0                                                  */
            __IM uint32_t PRGERR0  : 1; /*!< [1..1] Program Error Flag0                                                */
            __IM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t BCERR0   : 1; /*!< [3..3] Blank Check Error Flag0                                            */
            __IM uint32_t ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t               : 26;
        } FSTATR00_b;
    };

    union
    {
        __IM uint32_t FSTATR1;         /*!< (@ 0x0000012C) Flash Status Register1                                     */

        struct
        {
            uint32_t            : 1;
            __IM uint32_t DRRDY : 1;   /*!< [1..1] Data read request                                                  */
            uint32_t            : 4;
            __IM uint32_t FRDY  : 1;   /*!< [6..6] End status signal of a sequencer                                   */
            __IM uint32_t EXRDY : 1;   /*!< [7..7] End status signal of a Extra programming sequencer                 */
            uint32_t            : 24;
        } FSTATR1_b;
    };

    union
    {
        __IOM uint32_t FWBL0;          /*!< (@ 0x00000130) Flash Write Buffer Register L0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBL0_b;
    };
    __IM uint32_t RESERVED15;

    union
    {
        __IOM uint32_t FWBH0;          /*!< (@ 0x00000138) Flash Write Buffer Register H0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBH0_b;
    };

    union
    {
        __IM uint32_t FSTATR01;        /*!< (@ 0x0000013C) Flash Status Register01                                    */

        struct
        {
            __IM uint32_t ERERR1  : 1; /*!< [0..0] Erase Error Flag1                                                  */
            __IM uint32_t PRGERR1 : 1; /*!< [1..1] Program Error Flag1                                                */
            uint32_t              : 1;
            __IM uint32_t BCERR1  : 1; /*!< [3..3] Blank Check Error Flag1                                            */
            uint32_t              : 28;
        } FSTATR01_b;
    };

    union
    {
        __IOM uint32_t FWBL1;               /*!< (@ 0x00000140) Flash Write Buffer Register L1                             */

        struct
        {
            __IOM uint32_t WDATA47_32 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBL1_b;
    };

    union
    {
        __IOM uint32_t FWBH1;               /*!< (@ 0x00000144) Flash Write Buffer Register H1                             */

        struct
        {
            __IOM uint32_t WDATA63_48 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBH1_b;
    };

    union
    {
        __IM uint32_t FRBL1;               /*!< (@ 0x00000148) Flash Read Buffer Register L1                              */

        struct
        {
            __IM uint32_t RDATA47_32 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBL1_b;
    };

    union
    {
        __IM uint32_t FRBH1;               /*!< (@ 0x0000014C) Flash Read Buffer Register H1                              */

        struct
        {
            __IM uint32_t RDATA63_48 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBH1_b;
    };
    __IM uint32_t RESERVED16[12];

    union
    {
        __OM uint32_t FPR;             /*!< (@ 0x00000180) Protection Unlock Register                                 */

        struct
        {
            __OM uint32_t FPR : 8;     /*!< [7..0] Protection Unlock Register                                         */
            uint32_t          : 24;
        } FPR_b;
    };

    union
    {
        __IM uint32_t FPSR;            /*!< (@ 0x00000184) Protection Unlock Status Register                          */

        struct
        {
            __IM uint32_t PERR : 1;    /*!< [0..0] Protect Error Flag                                                 */
            uint32_t           : 31;
        } FPSR_b;
    };

    union
    {
        __IM uint32_t FRBL0;           /*!< (@ 0x00000188) Flash Read Buffer Register L0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBL0_b;
    };
    __IM uint32_t RESERVED17;

    union
    {
        __IM uint32_t FRBH0;           /*!< (@ 0x00000190) Flash Read Buffer Register H0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBH0_b;
    };
    __IM uint32_t RESERVED18[11];

    union
    {
        __IM uint32_t FSCMR;           /*!< (@ 0x000001C0) Flash Start-Up Setting Monitor Register                    */

        struct
        {
            uint32_t            : 8;
            __IM uint32_t SASMF : 1;   /*!< [8..8] Start-up Area Setting Monitor Flag                                 */
            uint32_t            : 5;
            __IM uint32_t FSPR  : 1;   /*!< [14..14] Access Window Protection Flag                                    */
            uint32_t            : 17;
        } FSCMR_b;
    };
    __IM uint32_t RESERVED19;

    union
    {
        __IM uint32_t FAWSMR;          /*!< (@ 0x000001C8) Flash Access Window Start Address Monitor Register         */

        struct
        {
            __IM uint32_t FAWS : 12;   /*!< [11..0] Flash Access Window Start Address                                 */
            uint32_t           : 20;
        } FAWSMR_b;
    };
    __IM uint32_t RESERVED20;

    union
    {
        __IM uint32_t FAWEMR;          /*!< (@ 0x000001D0) Flash Access Window End Address Monitor Register           */

        struct
        {
            __IM uint32_t FAWE : 12;   /*!< [11..0] Flash Access Window End Address                                   */
            uint32_t           : 20;
        } FAWEMR_b;
    };
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint32_t FISR;           /*!< (@ 0x000001D8) Flash Initial Setting Register                             */

        struct
        {
            __IOM uint32_t PCKA : 6;   /*!< [5..0] Peripheral Clock Notification                                      */
            __IOM uint32_t SAS  : 2;   /*!< [7..6] Temporary boot swap mode                                           */
            uint32_t            : 24;
        } FISR_b;
    };

    union
    {
        __IOM uint32_t FEXCR;          /*!< (@ 0x000001DC) Flash Extra Area Control Register                          */

        struct
        {
            __IOM uint32_t CMD  : 3;   /*!< [2..0] Processing Start)                                                  */
            uint32_t            : 4;
            __IOM uint32_t OPST : 1;   /*!< [7..7] Software Command Setting                                           */
            uint32_t            : 24;
        } FEXCR_b;
    };

    union
    {
        __IM uint32_t FEAML;           /*!< (@ 0x000001E0) Flash Error Address Monitor Register L                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAML_b;
    };
    __IM uint32_t RESERVED22;

    union
    {
        __IM uint32_t FEAMH;           /*!< (@ 0x000001E8) Flash Error Address Monitor Register H                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAMH_b;
    };
    __IM uint32_t RESERVED23;

    union
    {
        __IM uint32_t FSTATR2;           /*!< (@ 0x000001F0) Flash Status Register2                                     */

        struct
        {
            __IM uint32_t  ERERR    : 1; /*!< [0..0] Erase Error Flag                                                   */
            __IM uint32_t  PRGERR1  : 1; /*!< [1..1] Program Error Flag                                                 */
            __IOM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t  BCERR    : 1; /*!< [3..3] Blank Check Error Flag                                             */
            __IM uint32_t  ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t  EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t                : 26;
        } FSTATR2_b;
    };
    __IM uint32_t  RESERVED24[3951];
    __IOM uint16_t FENTRYR_MF4;        /*!< (@ 0x00003FB0) Flash P/E Mode Entry Register for MF4                      */
    __IOM uint16_t FENTRYR;            /*!< (@ 0x00003FB2) Flash P/E Mode Entry Register                              */
    __IM uint32_t  RESERVED25[3];
    __IOM uint8_t  FLWAITR;            /*!< (@ 0x00003FC0) Flash Wait Cycle Register                                  */
    __IM uint8_t   RESERVED26;
    __IM uint16_t  RESERVED27;
    __IM uint32_t  RESERVED28;
    __IOM uint8_t  PFBER;              /*!< (@ 0x00003FC8) Prefetch Buffer Enable Register                            */
    __IM uint8_t   RESERVED29;
    __IM uint16_t  RESERVED30;
} R_FACI_LP_Type;                      /*!< Size = 16332 (0x3fcc)                                                     */

/* =========================================================================================================================== */
/* ================                                        R_CTSUTRIM                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief CTSU Trimming Registers (R_CTSUTRIM)
 */

typedef struct                         /*!< (@ 0x407EC000) R_CTSUTRIM Structure                                       */
{
    __IM uint32_t RESERVED[233];

    union
    {
        __IOM uint32_t CTSUTRIMA;         /*!< (@ 0x000003A4) CTSU Trimming Register A                                   */

        struct
        {
            __IOM uint32_t RTRIM     : 8; /*!< [7..0] CTSU Reference Resistance Adjustment                               */
            __IOM uint32_t DACTRIM   : 8; /*!< [15..8] Linearity Adjustment of Offset Current                            */
            __IOM uint32_t SUADJD    : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
            __IOM uint32_t SUADJTRIM : 8; /*!< [31..24] Coefficient of variation for the reference load resistance
                                           *   (120k)                                                                    */
        } CTSUTRIMA_b;
    };

    union
    {
        __IOM uint32_t CTSUTRIMB;        /*!< (@ 0x000003A8) CTSU Trimming Register B                                   */

        struct
        {
            __IOM uint32_t TRESULT0 : 8; /*!< [7..0] Coefficient of variation for the reference load resistance
                                          *   (7.5k)                                                                    */
            __IOM uint32_t TRESULT1 : 8; /*!< [15..8] Coefficient of variation for the reference load resistance
                                          *   (15k)                                                                     */
            __IOM uint32_t TRESULT2 : 8; /*!< [23..16] Coefficient of variation for the reference load resistance
                                          *   (30k)                                                                     */
            __IOM uint32_t TRESULT3 : 8; /*!< [31..24] Coefficient of variation for the reference load resistance
                                          *   (60k)                                                                     */
        } CTSUTRIMB_b;
    };
} R_CTSUTRIM_Type;                       /*!< Size = 940 (0x3ac)                                                        */

/* =========================================================================================================================== */
/* ================                                         R_FCACHE                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Memory Cache (R_FCACHE)
 */

typedef struct                         /*!< (@ 0x4001C000) R_FCACHE Structure                                         */
{
    __IM uint16_t RESERVED[128];

    union
    {
        __IOM uint16_t FCACHEE;          /*!< (@ 0x00000100) Flash Cache Enable Register                                */

        struct
        {
            __IOM uint16_t FCACHEEN : 1; /*!< [0..0] FCACHE Enable                                                      */
            uint16_t                : 15;
        } FCACHEE_b;
    };
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t FCACHEIV;         /*!< (@ 0x00000104) Flash Cache Invalidate Register                            */

        struct
        {
            __IOM uint16_t FCACHEIV : 1; /*!< [0..0] Flash Cache Invalidate Register                                    */
            uint16_t                : 15;
        } FCACHEIV_b;
    };
    __IM uint16_t RESERVED2[11];

    union
    {
        __IOM uint8_t FLWT;            /*!< (@ 0x0000011C) Flash Wait Cycle Register                                  */

        struct
        {
            __IOM uint8_t FLWT : 3;    /*!< [2..0] Flash Wait Cycle                                                   */
            uint8_t            : 5;
        } FLWT_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4[17];

    union
    {
        __IOM uint16_t FSAR;             /*!< (@ 0x00000140) Flash Security Attribution Register                        */

        struct
        {
            __IOM uint16_t FLWTSA   : 1; /*!< [0..0] FLWT Security Attribution                                          */
            uint16_t                : 7;
            __IOM uint16_t FCKMHZSA : 1; /*!< [8..8] FCKMHZ Security Attribution                                        */
            uint16_t                : 7;
        } FSAR_b;
    };
} R_FCACHE_Type;                         /*!< Size = 322 (0x142)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_GLCDC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Graphics LCD Controller (R_GLCDC)
 */

typedef struct                         /*!< (@ 0x400E0000) R_GLCDC Structure                                          */
{
    union
    {
        __IOM uint32_t GR1_CLUT0[256]; /*!< (@ 0x00000000) Color Palette 0 Plane for Graphics 1 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR1_CLUT0_b[256];
    };

    union
    {
        __IOM uint32_t GR1_CLUT1[256]; /*!< (@ 0x00000400) Color Palette 1 Plane for Graphics 1 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR1_CLUT1_b[256];
    };

    union
    {
        __IOM uint32_t GR2_CLUT0[256]; /*!< (@ 0x00000800) Color Palette 0 Plane for Graphics 2 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR2_CLUT0_b[256];
    };

    union
    {
        __IOM uint32_t GR2_CLUT1[256]; /*!< (@ 0x00000C00) Color Palette 1 Plane for Graphics 2 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR2_CLUT1_b[256];
    };
    __IOM R_GLCDC_BG_Type     BG;      /*!< (@ 0x00001000) Background Registers                                       */
    __IM uint32_t             RESERVED[57];
    __IOM R_GLCDC_GR_Type     GR[2];   /*!< (@ 0x00001100) Layer Registers                                            */
    __IOM R_GLCDC_GAM_Type    GAM[3];  /*!< (@ 0x00001300) Gamma Settings                                             */
    __IOM R_GLCDC_OUT_Type    OUT;     /*!< (@ 0x000013C0) Output Control Registers                                   */
    __IM uint32_t             RESERVED1[6];
    __IOM R_GLCDC_TCON_Type   TCON;    /*!< (@ 0x00001400) Timing Control Registers                                   */
    __IM uint32_t             RESERVED2[5];
    __IOM R_GLCDC_SYSCNT_Type SYSCNT;  /*!< (@ 0x00001440) GLCDC System Control Registers                             */
} R_GLCDC_Type;                        /*!< Size = 5204 (0x1454)                                                      */

/* =========================================================================================================================== */
/* ================                                          R_GPT0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief General PWM Timer (R_GPT0)
 */

typedef struct                         /*!< (@ 0x40078000) R_GPT0 Structure                                           */
{
    union
    {
        __IOM uint32_t GTWP;           /*!< (@ 0x00000000) General PWM Timer Write-Protection Register                */

        struct
        {
            __IOM uint32_t WP    : 1;  /*!< [0..0] Register Write Disable                                             */
            __IOM uint32_t STRWP : 1;  /*!< [1..1] GTSTR.CSTRT Bit Write Disable                                      */
            __IOM uint32_t STPWP : 1;  /*!< [2..2] GTSTP.CSTOP Bit Write Disable                                      */
            __IOM uint32_t CLRWP : 1;  /*!< [3..3] GTCLR.CCLR Bit Write Disable                                       */
            __IOM uint32_t CMNWP : 1;  /*!< [4..4] Common Register Write Disabled                                     */
            uint32_t             : 3;
            __OM uint32_t PRKEY  : 8;  /*!< [15..8] GTWP Key Code                                                     */
            uint32_t             : 16;
        } GTWP_b;
    };

    union
    {
        __IOM uint32_t GTSTR;           /*!< (@ 0x00000004) General PWM Timer Software Start Register                  */

        struct
        {
            __IOM uint32_t CSTRT0 : 1;  /*!< [0..0] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT1 : 1;  /*!< [1..1] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT2 : 1;  /*!< [2..2] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT3 : 1;  /*!< [3..3] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT4 : 1;  /*!< [4..4] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT5 : 1;  /*!< [5..5] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT6 : 1;  /*!< [6..6] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT7 : 1;  /*!< [7..7] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT8 : 1;  /*!< [8..8] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT9 : 1;  /*!< [9..9] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT10 : 1; /*!< [10..10] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT11 : 1; /*!< [11..11] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT12 : 1; /*!< [12..12] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT13 : 1; /*!< [13..13] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            uint32_t : 18;
        } GTSTR_b;
    };

    union
    {
        __IOM uint32_t GTSTP;           /*!< (@ 0x00000008) General PWM Timer Software Stop Register                   */

        struct
        {
            __IOM uint32_t CSTOP0 : 1;  /*!< [0..0] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP1 : 1;  /*!< [1..1] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP2 : 1;  /*!< [2..2] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP3 : 1;  /*!< [3..3] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP4 : 1;  /*!< [4..4] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP5 : 1;  /*!< [5..5] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP6 : 1;  /*!< [6..6] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP7 : 1;  /*!< [7..7] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP8 : 1;  /*!< [8..8] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP9 : 1;  /*!< [9..9] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP10 : 1; /*!< [10..10] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP11 : 1; /*!< [11..11] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP12 : 1; /*!< [12..12] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP13 : 1; /*!< [13..13] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            uint32_t : 18;
        } GTSTP_b;
    };

    union
    {
        __OM uint32_t GTCLR;           /*!< (@ 0x0000000C) General PWM Timer Software Clear Register                  */

        struct
        {
            __OM uint32_t CCLR0  : 1;  /*!< [0..0] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR1  : 1;  /*!< [1..1] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR2  : 1;  /*!< [2..2] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR3  : 1;  /*!< [3..3] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR4  : 1;  /*!< [4..4] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR5  : 1;  /*!< [5..5] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR6  : 1;  /*!< [6..6] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR7  : 1;  /*!< [7..7] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR8  : 1;  /*!< [8..8] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR9  : 1;  /*!< [9..9] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR10 : 1;  /*!< [10..10] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR11 : 1;  /*!< [11..11] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR12 : 1;  /*!< [12..12] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR13 : 1;  /*!< [13..13] Channel GTCNT Count Clear                                        */
            uint32_t             : 18;
        } GTCLR_b;
    };

    union
    {
        __IOM uint32_t GTSSR;            /*!< (@ 0x00000010) General PWM Timer Start Source Select Register             */

        struct
        {
            __IOM uint32_t SSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Start Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTRT  : 1;   /*!< [31..31] Software Source Counter Start Enable                             */
        } GTSSR_b;
    };

    union
    {
        __IOM uint32_t GTPSR;            /*!< (@ 0x00000014) General PWM Timer Stop Source Select Register              */

        struct
        {
            __IOM uint32_t PSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Stop Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTOP  : 1;   /*!< [31..31] Software Source Counter Stop Enable                              */
        } GTPSR_b;
    };

    union
    {
        __IOM uint32_t GTCSR;            /*!< (@ 0x00000018) General PWM Timer Clear Source Select Register             */

        struct
        {
            __IOM uint32_t CSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Clear Enable                       */
            uint32_t              : 7;
            __IOM uint32_t CCLR   : 1;   /*!< [31..31] Software Source Counter Clear Enable                             */
        } GTCSR_b;
    };

    union
    {
        __IOM uint32_t GTUPSR;           /*!< (@ 0x0000001C) General PWM Timer Up Count Source Select Register          */

        struct
        {
            __IOM uint32_t USGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Up Enable                     */
            uint32_t              : 8;
        } GTUPSR_b;
    };

    union
    {
        __IOM uint32_t GTDNSR;           /*!< (@ 0x00000020) General PWM Timer Down Count Source Select Register        */

        struct
        {
            __IOM uint32_t DSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Down Enable                   */
            uint32_t              : 8;
        } GTDNSR_b;
    };

    union
    {
        __IOM uint32_t GTICASR;          /*!< (@ 0x00000024) General PWM Timer Input Capture Source Select
                                          *                  Register A                                                 */

        struct
        {
            __IOM uint32_t ASGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            uint32_t              : 8;
        } GTICASR_b;
    };

    union
    {
        __IOM uint32_t GTICBSR;          /*!< (@ 0x00000028) General PWM Timer Input Capture Source Select
                                          *                  Register B                                                 */

        struct
        {
            __IOM uint32_t BSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            uint32_t              : 8;
        } GTICBSR_b;
    };

    union
    {
        __IOM uint32_t GTCR;           /*!< (@ 0x0000002C) General PWM Timer Control Register                         */

        struct
        {
            __IOM uint32_t CST  : 1;   /*!< [0..0] Count Start                                                        */
            uint32_t            : 15;
            __IOM uint32_t MD   : 3;   /*!< [18..16] Mode Select                                                      */
            uint32_t            : 4;
            __IOM uint32_t TPCS : 4;   /*!< [26..23] Timer Prescaler Select                                           */
            uint32_t            : 5;
        } GTCR_b;
    };

    union
    {
        __IOM uint32_t GTUDDTYC;       /*!< (@ 0x00000030) General PWM Timer Count Direction and Duty Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t UD     : 1; /*!< [0..0] Count Direction Setting                                            */
            __IOM uint32_t UDF    : 1; /*!< [1..1] Forcible Count Direction Setting                                   */
            uint32_t              : 14;
            __IOM uint32_t OADTY  : 2; /*!< [17..16] GTIOCA Output Duty Setting                                       */
            __IOM uint32_t OADTYF : 1; /*!< [18..18] Forcible GTIOCA Output Duty Setting                              */
            __IOM uint32_t OADTYR : 1; /*!< [19..19] GTIOCA Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t              : 4;
            __IOM uint32_t OBDTY  : 2; /*!< [25..24] GTIOCB Output Duty Setting                                       */
            __IOM uint32_t OBDTYF : 1; /*!< [26..26] Forcible GTIOCB Output Duty Setting                              */
            __IOM uint32_t OBDTYR : 1; /*!< [27..27] GTIOCB Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t : 4;
        } GTUDDTYC_b;
    };

    union
    {
        __IOM uint32_t GTIOR;          /*!< (@ 0x00000034) General PWM Timer I/O Control Register                     */

        struct
        {
            __IOM uint32_t GTIOA  : 5; /*!< [4..0] GTIOCA Pin Function Select                                         */
            uint32_t              : 1;
            __IOM uint32_t OADFLT : 1; /*!< [6..6] GTIOCA Pin Output Value Setting at the Count Stop                  */
            __IOM uint32_t OAHLD  : 1; /*!< [7..7] GTIOCA Pin Output Setting at the Start/Stop Count                  */
            __IOM uint32_t OAE    : 1; /*!< [8..8] GTIOCA Pin Output Enable                                           */
            __IOM uint32_t OADF   : 2; /*!< [10..9] GTIOCA Pin Disable Value Setting                                  */
            uint32_t              : 2;
            __IOM uint32_t NFAEN  : 1; /*!< [13..13] Noise Filter A Enable                                            */
            __IOM uint32_t NFCSA  : 2; /*!< [15..14] Noise Filter A Sampling Clock Select                             */
            __IOM uint32_t GTIOB  : 5; /*!< [20..16] GTIOCB Pin Function Select                                       */
            uint32_t              : 1;
            __IOM uint32_t OBDFLT : 1; /*!< [22..22] GTIOCB Pin Output Value Setting at the Count Stop                */
            __IOM uint32_t OBHLD  : 1; /*!< [23..23] GTIOCB Pin Output Setting at the Start/Stop Count                */
            __IOM uint32_t OBE    : 1; /*!< [24..24] GTIOCB Pin Output Enable                                         */
            __IOM uint32_t OBDF   : 2; /*!< [26..25] GTIOCB Pin Disable Value Setting                                 */
            uint32_t              : 2;
            __IOM uint32_t NFBEN  : 1; /*!< [29..29] Noise Filter B Enable                                            */
            __IOM uint32_t NFCSB  : 2; /*!< [31..30] Noise Filter B Sampling Clock Select                             */
        } GTIOR_b;
    };

    union
    {
        __IOM uint32_t GTINTAD;        /*!< (@ 0x00000038) General PWM Timer Interrupt Output Setting Register        */

        struct
        {
            uint32_t               : 24;
            __IOM uint32_t GRP     : 2; /*!< [25..24] Output Disable Source Select                                     */
            uint32_t               : 2;
            __IOM uint32_t GRPDTE  : 1; /*!< [28..28] Dead Time Error Output Disable Request Enable                    */
            __IOM uint32_t GRPABH  : 1; /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IOM uint32_t GRPABL  : 1; /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t GTINTPC : 1; /*!< [31..31] Period Count Function Finish Interrupt Enable                    */
        } GTINTAD_b;
    };

    union
    {
        __IOM uint32_t GTST;            /*!< (@ 0x0000003C) General PWM Timer Status Register                          */

        struct
        {
            __IOM uint32_t TCFA  : 1;   /*!< [0..0] Input Capture/Compare Match Flag A                                 */
            __IOM uint32_t TCFB  : 1;   /*!< [1..1] Input Capture/Compare Match Flag B                                 */
            __IOM uint32_t TCFC  : 1;   /*!< [2..2] Input Compare Match Flag C                                         */
            __IOM uint32_t TCFD  : 1;   /*!< [3..3] Input Compare Match Flag D                                         */
            __IOM uint32_t TCFE  : 1;   /*!< [4..4] Input Compare Match Flag E                                         */
            __IOM uint32_t TCFF  : 1;   /*!< [5..5] Input Compare Match Flag F                                         */
            __IOM uint32_t TCFPO : 1;   /*!< [6..6] Overflow Flag                                                      */
            __IOM uint32_t TCFPU : 1;   /*!< [7..7] Underflow Flag                                                     */
            __IM uint32_t  ITCNT : 3;   /*!< [10..8] GTCIV/GTCIU Interrupt Skipping Count Counter(Counter
                                         *   for counting the number of times a timer interrupt has
                                         *   been skipped.)                                                            */
            uint32_t               : 4;
            __IM uint32_t  TUCF    : 1; /*!< [15..15] Count Direction Flag                                             */
            __IOM uint32_t ADTRAUF : 1; /*!< [16..16] GTADTRA Compare Match (Up-Counting) A/D Converter Start
                                         *   Request Interrupt Enable                                                  */
            __IOM uint32_t ADTRADF : 1; /*!< [17..17] GTADTRA Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            __IOM uint32_t ADTRBUF : 1; /*!< [18..18] GTADTRB Compare Match(Up-Counting) A/D Convertor Start
                                         *   Request Flag                                                              */
            __IOM uint32_t ADTRBDF : 1; /*!< [19..19] GTADTRB Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            uint32_t             : 4;
            __IM uint32_t ODF    : 1;   /*!< [24..24] Output Disable Flag                                              */
            uint32_t             : 3;
            __IM uint32_t  DTEF  : 1;   /*!< [28..28] Dead Time Error Flag                                             */
            __IM uint32_t  OABHF : 1;   /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IM uint32_t  OABLF : 1;   /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t PCF   : 1;   /*!< [31..31] Period Count Function Finish Flag                                */
        } GTST_b;
    };

    union
    {
        __IOM uint32_t GTBER;          /*!< (@ 0x00000040) General PWM Timer Buffer Enable Register                   */

        struct
        {
            __IOM uint32_t BD0    : 1; /*!< [0..0] BD[0]: GTCCR Buffer Operation Disable                              */
            __IOM uint32_t BD1    : 1; /*!< [1..1] BD[1]: GTPR Buffer Operation Disable                               */
            __IOM uint32_t BD2    : 1; /*!< [2..2] BD[2]: GTADTR Buffer Operation DisableBD                           */
            __IOM uint32_t BD3    : 1; /*!< [3..3] BD[3]: GTDV Buffer Operation DisableBD[2]                          */
            uint32_t              : 12;
            __IOM uint32_t CCRA   : 2; /*!< [17..16] GTCCRA Buffer Operation                                          */
            __IOM uint32_t CCRB   : 2; /*!< [19..18] GTCCRB Buffer Operation                                          */
            __IOM uint32_t PR     : 2; /*!< [21..20] GTPR Buffer Operation                                            */
            __OM uint32_t  CCRSWT : 1; /*!< [22..22] GTCCRA and GTCCRB Forcible Buffer OperationThis bit
                                        *   is read as 0.                                                             */
            uint32_t             : 1;
            __IOM uint32_t ADTTA : 2;  /*!< [25..24] GTADTRA Buffer Transfer Timing Select in the Triangle
                                        *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                        *   at an underflow (in down-counting) or overflow (in up-counting)
                                        *   is performed.                                                             */
            __IOM uint32_t ADTDA : 1;  /*!< [26..26] GTADTRA Double Buffer Operation                                  */
            uint32_t             : 1;
            __IOM uint32_t ADTTB : 2;  /*!< [29..28] GTADTRB Buffer Transfer Timing Select in the Triangle
                                        *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                        *   at an underflow (in down-counting) or overflow (in up-counting)
                                        *   is performed.                                                             */
            __IOM uint32_t ADTDB : 1;  /*!< [30..30] GTADTRB Double Buffer Operation                                  */
            uint32_t             : 1;
        } GTBER_b;
    };

    union
    {
        __IOM uint32_t GTITC;          /*!< (@ 0x00000044) General PWM Timer Interrupt and A/D Converter
                                        *                  Start Request Skipping Setting Register                    */

        struct
        {
            __IOM uint32_t ITLA  : 1;  /*!< [0..0] GTCCRA Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLB  : 1;  /*!< [1..1] GTCCRB Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLC  : 1;  /*!< [2..2] GTCCRC Compare Match Interrupt Link                                */
            __IOM uint32_t ITLD  : 1;  /*!< [3..3] GTCCRD Compare Match Interrupt Link                                */
            __IOM uint32_t ITLE  : 1;  /*!< [4..4] GTCCRE Compare Match Interrupt Link                                */
            __IOM uint32_t ITLF  : 1;  /*!< [5..5] GTCCRF Compare Match Interrupt Link                                */
            __IOM uint32_t IVTC  : 2;  /*!< [7..6] GPT_OVF/GPT_UDF Interrupt Skipping Function Select                 */
            __IOM uint32_t IVTT  : 3;  /*!< [10..8] GPT_OVF/GPT_UDF Interrupt Skipping Count Select                   */
            uint32_t             : 1;
            __IOM uint32_t ADTAL : 1;  /*!< [12..12] GTADTRA A/D Converter Start Request Link                         */
            uint32_t             : 1;
            __IOM uint32_t ADTBL : 1;  /*!< [14..14] GTADTRB A/D Converter Start Request Link                         */
            uint32_t             : 17;
        } GTITC_b;
    };

    union
    {
        __IOM uint32_t GTCNT;          /*!< (@ 0x00000048) General PWM Timer Counter                                  */

        struct
        {
            __IOM uint32_t GTCNT : 32; /*!< [31..0] Counter                                                           */
        } GTCNT_b;
    };

    union
    {
        __IOM uint32_t GTCCR[6];       /*!< (@ 0x0000004C) General PWM Timer Compare Capture Register                 */

        struct
        {
            __IOM uint32_t GTCCR : 32; /*!< [31..0] Compare Capture Register A                                        */
        } GTCCR_b[6];
    };

    union
    {
        __IOM uint32_t GTPR;           /*!< (@ 0x00000064) General PWM Timer Cycle Setting Register                   */

        struct
        {
            __IOM uint32_t GTPR : 32;  /*!< [31..0] Cycle Setting Register                                            */
        } GTPR_b;
    };

    union
    {
        __IOM uint32_t GTPBR;          /*!< (@ 0x00000068) General PWM Timer Cycle Setting Buffer Register            */

        struct
        {
            __IOM uint32_t GTPBR : 32; /*!< [31..0] Cycle Setting Buffer Register                                     */
        } GTPBR_b;
    };

    union
    {
        __IOM uint32_t GTPDBR;          /*!< (@ 0x0000006C) General PWM Timer Cycle Setting Double-Buffer
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t GTPDBR : 32; /*!< [31..0] Cycle Setting Double-Buffer Register                              */
        } GTPDBR_b;
    };

    union
    {
        __IOM uint32_t GTADTRA;          /*!< (@ 0x00000070) A/D Converter Start Request Timing Register A              */

        struct
        {
            __IOM uint32_t GTADTRA : 32; /*!< [31..0] A/D Converter Start Request Timing Register A                     */
        } GTADTRA_b;
    };

    union
    {
        __IOM uint32_t GTADTBRA;          /*!< (@ 0x00000074) A/D Converter Start Request Timing Buffer Register
                                           *                  A                                                          */

        struct
        {
            __IOM uint32_t GTADTBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register A              */
        } GTADTBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRA;          /*!< (@ 0x00000078) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register A                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   A                                                                         */
        } GTADTDBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTRB;          /*!< (@ 0x0000007C) A/D Converter Start Request Timing Register B              */

        struct
        {
            __IOM uint32_t GTADTRB : 32; /*!< [31..0] A/D Converter Start Request Timing Register B                     */
        } GTADTRB_b;
    };

    union
    {
        __IOM uint32_t GTADTBRB;          /*!< (@ 0x00000080) A/D Converter Start Request Timing Buffer Register
                                           *                  B                                                          */

        struct
        {
            __IOM uint32_t GTADTBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register B              */
        } GTADTBRB_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRB;          /*!< (@ 0x00000084) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register B                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   B                                                                         */
        } GTADTDBRB_b;
    };

    union
    {
        __IOM uint32_t GTDTCR;         /*!< (@ 0x00000088) General PWM Timer Dead Time Control Register               */

        struct
        {
            __IOM uint32_t TDE   : 1;  /*!< [0..0] Negative-Phase Waveform Setting                                    */
            uint32_t             : 3;
            __IOM uint32_t TDBUE : 1;  /*!< [4..4] GTDVU Buffer Operation Enable                                      */
            __IOM uint32_t TDBDE : 1;  /*!< [5..5] GTDVD Buffer Operation Enable                                      */
            uint32_t             : 2;
            __IOM uint32_t TDFER : 1;  /*!< [8..8] GTDVD Setting                                                      */
            uint32_t             : 23;
        } GTDTCR_b;
    };

    union
    {
        __IOM uint32_t GTDVU;          /*!< (@ 0x0000008C) General PWM Timer Dead Time Value Register U               */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Value Register U                                        */
        } GTDVU_b;
    };

    union
    {
        __IOM uint32_t GTDVD;          /*!< (@ 0x00000090) General PWM Timer Dead Time Value Register D               */

        struct
        {
            __IOM uint32_t GTDVD : 32; /*!< [31..0] Dead Time Value Register D                                        */
        } GTDVD_b;
    };

    union
    {
        __IOM uint32_t GTDBU;          /*!< (@ 0x00000094) General PWM Timer Dead Time Buffer Register U              */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Buffer Register U                                       */
        } GTDBU_b;
    };

    union
    {
        __IOM uint32_t GTDBD;          /*!< (@ 0x00000098) General PWM Timer Dead Time Buffer Register D              */

        struct
        {
            __IOM uint32_t GTDBD : 32; /*!< [31..0] Dead Time Buffer Register D                                       */
        } GTDBD_b;
    };

    union
    {
        __IM uint32_t GTSOS;           /*!< (@ 0x0000009C) General PWM Timer Output Protection Function
                                        *                  Status Register                                            */

        struct
        {
            __IM uint32_t SOS : 2;     /*!< [1..0] Output Protection Function Status                                  */
            uint32_t          : 30;
        } GTSOS_b;
    };

    union
    {
        __IOM uint32_t GTSOTR;         /*!< (@ 0x000000A0) General PWM Timer Output Protection Function
                                        *                  Temporary Release Register                                 */

        struct
        {
            __IOM uint32_t SOTR : 1;   /*!< [0..0] Output Protection Function Temporary Release                       */
            uint32_t            : 31;
        } GTSOTR_b;
    };
    __IM uint32_t RESERVED[5];

    union
    {
        __IOM uint32_t GTICLF;           /*!< (@ 0x000000B8) General PWM Timer Inter Channel Logical Operation
                                          *                  Function Setting Register                                  */

        struct
        {
            __IOM uint32_t ICLFA    : 3; /*!< [2..0] GTIOCnA Output Logical Operation Function Select                   */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELC : 6; /*!< [9..4] Inter Channel Signal C Select                                      */
            uint32_t                : 6;
            __IOM uint32_t ICLFB    : 3; /*!< [18..16] GTIOCnB Output Logical Operation Function Select                 */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELD : 6; /*!< [25..20] Inter Channel Signal D Select                                    */
            uint32_t                : 6;
        } GTICLF_b;
    };

    union
    {
        __IOM uint32_t GTPC;           /*!< (@ 0x000000BC) General PWM Timer Period Count Register                    */

        struct
        {
            __IOM uint32_t PCEN : 1;   /*!< [0..0] Period Count Function Enable                                       */
            uint32_t            : 7;
            __IOM uint32_t ASTP : 1;   /*!< [8..8] Automatic Stop Function Enable                                     */
            uint32_t            : 7;
            __IOM uint32_t PCNT : 12;  /*!< [27..16] Period Counter                                                   */
            uint32_t            : 4;
        } GTPC_b;
    };
    __IM uint32_t RESERVED1[4];

    union
    {
        __IOM uint32_t GTSECSR;         /*!< (@ 0x000000D0) General PWM Timer Operation Enable Bit Simultaneous
                                         *                  Control Channel Select Register                            */

        struct
        {
            __IOM uint32_t SECSEL0 : 1; /*!< [0..0] Channel 0 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL1 : 1; /*!< [1..1] Channel 1 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL2 : 1; /*!< [2..2] Channel 2 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL3 : 1; /*!< [3..3] Channel 3 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL4 : 1; /*!< [4..4] Channel 4 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL5 : 1; /*!< [5..5] Channel 5 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL6 : 1; /*!< [6..6] Channel 6 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL7 : 1; /*!< [7..7] Channel 7 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL8 : 1; /*!< [8..8] Channel 8 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL9 : 1; /*!< [9..9] Channel 9 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            uint32_t : 22;
        } GTSECSR_b;
    };

    union
    {
        __IOM uint32_t GTSECR;         /*!< (@ 0x000000D4) General PWM Timer Operation Enable Bit Simultaneous
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint32_t SBDCE : 1;  /*!< [0..0] GTCCR Register Buffer Operation Simultaneous Enable                */
            __IOM uint32_t SBDPE : 1;  /*!< [1..1] GTPR Register Buffer Operation Simultaneous Enable                 */
            uint32_t             : 6;
            __IOM uint32_t SBDCD : 1;  /*!< [8..8] GTCCR Register Buffer Operation Simultaneous Disable               */
            __IOM uint32_t SBDPD : 1;  /*!< [9..9] GTPR Register Buffer Operation Simultaneous Disable                */
            uint32_t             : 6;
            __IOM uint32_t SPCE  : 1;  /*!< [16..16] Period Count Function Simultaneous Enable                        */
            uint32_t             : 7;
            __IOM uint32_t SPCD  : 1;  /*!< [24..24] Period Count Function Simultaneous Disable                       */
            uint32_t             : 7;
        } GTSECR_b;
    };
} R_GPT0_Type;                         /*!< Size = 216 (0xd8)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_GPT_ODC                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief PWM Delay Generation Circuit (R_GPT_ODC)
 */

typedef struct                         /*!< (@ 0x4007B000) R_GPT_ODC Structure                                        */
{
    union
    {
        __IOM uint16_t GTDLYCR1;       /*!< (@ 0x00000000) PWM Output Delay Control Register1                         */

        struct
        {
            __IOM uint16_t DLLEN  : 1; /*!< [0..0] DLL Operation Enable                                               */
            __IOM uint16_t DLYRST : 1; /*!< [1..1] PWM Delay Generation Circuit Reset                                 */
            uint16_t              : 6;
            __IOM uint16_t DLLMOD : 1; /*!< [8..8] DLL Mode Select                                                    */
            uint16_t              : 7;
        } GTDLYCR1_b;
    };

    union
    {
        __IOM uint16_t GTDLYCR2;         /*!< (@ 0x00000002) PWM Output Delay Control Register2                         */

        struct
        {
            __IOM uint16_t DLYBS0   : 1; /*!< [0..0] PWM Delay Generation Circuit bypass                                */
            __IOM uint16_t DLYBS1   : 1; /*!< [1..1] PWM Delay Generation Circuit bypass                                */
            __IOM uint16_t DLYBS2   : 1; /*!< [2..2] PWM Delay Generation Circuit bypass                                */
            __IOM uint16_t DLYBS3   : 1; /*!< [3..3] PWM Delay Generation Circuit bypass                                */
            uint16_t                : 4;
            __IOM uint16_t DLYEN0   : 1; /*!< [8..8] PWM Delay Generation Circuit enable                                */
            uint16_t                : 3;
            __IOM uint16_t DLYDENB0 : 1; /*!< [12..12] PWM Delay Generation Circuit Disenable for GTIOCB                */
            uint16_t                : 3;
        } GTDLYCR2_b;
    };
    __IM uint16_t               RESERVED[10];
    __IOM R_GPT_ODC_GTDLYR_Type GTDLYR[4]; /*!< (@ 0x00000018) PWM DELAY RISING                                           */
    __IOM R_GPT_ODC_GTDLYR_Type GTDLYF[4]; /*!< (@ 0x00000028) PWM DELAY FALLING                                          */
} R_GPT_ODC_Type;                          /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                         R_GPT_OPS                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Output Phase Switching for GPT (R_GPT_OPS)
 */

typedef struct                         /*!< (@ 0x40078FF0) R_GPT_OPS Structure                                        */
{
    union
    {
        __IOM uint32_t OPSCR;          /*!< (@ 0x00000000) Output Phase Switching Control Register                    */

        struct
        {
            __IOM uint32_t UF : 1;     /*!< [0..0] Input Phase Soft Setting WFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t VF : 1;     /*!< [1..1] Input Phase Soft Setting VFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t WF : 1;     /*!< [2..2] Input Phase Soft Setting UFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            uint32_t        : 1;
            __IM uint32_t U : 1;       /*!< [4..4] Input U-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t V : 1;       /*!< [5..5] Input V-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t W : 1;       /*!< [6..6] Input W-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            uint32_t          : 1;
            __IOM uint32_t EN : 1;     /*!< [8..8] Enable-Phase Output Control                                        */
            uint32_t          : 7;
            __IOM uint32_t FB : 1;     /*!< [16..16] External Feedback Signal EnableThis bit selects the
                                        *   input phase from the software settings and external input.                */
            __IOM uint32_t P     : 1;  /*!< [17..17] Positive-Phase Output (P) Control                                */
            __IOM uint32_t N     : 1;  /*!< [18..18] Negative-Phase Output (N) Control                                */
            __IOM uint32_t INV   : 1;  /*!< [19..19] Invert-Phase Output Control                                      */
            __IOM uint32_t RV    : 1;  /*!< [20..20] Output phase rotation direction reversal                         */
            __IOM uint32_t ALIGN : 1;  /*!< [21..21] Input phase alignment                                            */
            uint32_t             : 2;
            __IOM uint32_t GRP   : 2;  /*!< [25..24] Output disabled source selection                                 */
            __IOM uint32_t GODF  : 1;  /*!< [26..26] Group output disable function                                    */
            uint32_t             : 2;
            __IOM uint32_t NFEN  : 1;  /*!< [29..29] External Input Noise Filter Enable                               */
            __IOM uint32_t NFCS  : 2;  /*!< [31..30] External Input Noise Filter Clock selectionNoise filter
                                        *   sampling clock setting of the external input.                             */
        } OPSCR_b;
    };
} R_GPT_OPS_Type;                      /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_GPT_POEG0                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief Port Output Enable for GPT (R_GPT_POEG0)
 */

typedef struct                         /*!< (@ 0x40042000) R_GPT_POEG0 Structure                                      */
{
    union
    {
        __IOM uint32_t POEGG;          /*!< (@ 0x00000000) POEG Group Setting Register                                */

        struct
        {
            __IOM uint32_t PIDF  : 1;  /*!< [0..0] Port Input Detection Flag                                          */
            __IOM uint32_t IOCF  : 1;  /*!< [1..1] Real Time Overcurrent Detection Flag                               */
            __IOM uint32_t OSTPF : 1;  /*!< [2..2] Oscillation Stop Detection Flag                                    */
            __IOM uint32_t SSF   : 1;  /*!< [3..3] Software Stop Flag                                                 */
            __IOM uint32_t PIDE  : 1;  /*!< [4..4] Port Input Detection EnableNote: Can be modified only
                                        *   once after a reset.                                                       */
            __IOM uint32_t IOCE : 1;   /*!< [5..5] Enable for GPT Output-Disable RequestNote: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t OSTPE : 1;  /*!< [6..6] Oscillation Stop Detection EnableNote: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t             : 1;
            __IOM uint32_t CDRE0 : 1;  /*!< [8..8] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE1 : 1;  /*!< [9..9] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE2 : 1;  /*!< [10..10] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE3 : 1;  /*!< [11..11] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE4 : 1;  /*!< [12..12] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE5 : 1;  /*!< [13..13] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t            : 2;
            __IM uint32_t ST    : 1;   /*!< [16..16] GTETRG Input Status Flag                                         */
            uint32_t            : 11;
            __IOM uint32_t INV  : 1;   /*!< [28..28] GTETRG Input Reverse                                             */
            __IOM uint32_t NFEN : 1;   /*!< [29..29] Noise Filter Enable                                              */
            __IOM uint32_t NFCS : 2;   /*!< [31..30] Noise Filter Clock Select                                        */
        } POEGG_b;
    };
} R_GPT_POEG0_Type;                    /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_ICU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Interrupt Controller Unit (R_ICU)
 */

typedef struct                         /*!< (@ 0x40006000) R_ICU Structure                                            */
{
    union
    {
        __IOM uint8_t IRQCR[16];       /*!< (@ 0x00000000) IRQ Control Register [0..15]                               */

        struct
        {
            __IOM uint8_t IRQMD   : 2; /*!< [1..0] IRQ Detection Sense Select                                         */
            uint8_t               : 2;
            __IOM uint8_t FCLKSEL : 2; /*!< [5..4] IRQ Digital Filter Sampling Clock Select                           */
            uint8_t               : 1;
            __IOM uint8_t FLTEN   : 1; /*!< [7..7] IRQ Digital Filter Enable                                          */
        } IRQCR_b[16];
    };
    __IM uint32_t RESERVED[60];

    union
    {
        __IOM uint8_t NMICR;            /*!< (@ 0x00000100) NMI Pin Interrupt Control Register                         */

        struct
        {
            __IOM uint8_t NMIMD    : 1; /*!< [0..0] NMI Detection Set                                                  */
            uint8_t                : 3;
            __IOM uint8_t NFCLKSEL : 2; /*!< [5..4] NMI Digital Filter Sampling Clock Select                           */
            uint8_t                : 1;
            __IOM uint8_t NFLTEN   : 1; /*!< [7..7] NMI Digital Filter Enable                                          */
        } NMICR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[7];

    union
    {
        __IOM uint16_t NMIER;           /*!< (@ 0x00000120) Non-Maskable Interrupt Enable Register                     */

        struct
        {
            __IOM uint16_t IWDTEN  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Interrupt Enable                      */
            __IOM uint16_t WDTEN   : 1; /*!< [1..1] WDT Underflow/Refresh Error Interrupt Enable                       */
            __IOM uint16_t LVD1EN  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Enable                              */
            __IOM uint16_t LVD2EN  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Enable                              */
            __IOM uint16_t VBATTEN : 1; /*!< [4..4] VBATT monitor Interrupt Enable                                     */
            uint16_t               : 1;
            __IOM uint16_t OSTEN   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Enable                        */
            __IOM uint16_t NMIEN   : 1; /*!< [7..7] NMI Pin Interrupt Enable                                           */
            __IOM uint16_t RPEEN   : 1; /*!< [8..8] RAM Parity Error Interrupt Enable                                  */
            __IOM uint16_t RECCEN  : 1; /*!< [9..9] RAM ECC Error Interrupt Enable                                     */
            __IOM uint16_t BUSSEN  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Enable                             */
            __IOM uint16_t BUSMEN  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Enable                            */
            __IOM uint16_t SPEEN   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Enable                       */
            __IOM uint16_t TZFEN   : 1; /*!< [13..13] TZFEN                                                            */
            uint16_t               : 1;
            __IOM uint16_t CPEEN   : 1; /*!< [15..15] CPEEN                                                            */
        } NMIER_b;
    };
    __IM uint16_t RESERVED4;
    __IM uint32_t RESERVED5[3];

    union
    {
        __IOM uint16_t NMICLR;          /*!< (@ 0x00000130) Non-Maskable Interrupt Status Clear Register               */

        struct
        {
            __OM uint16_t IWDTCLR  : 1; /*!< [0..0] IWDT Clear                                                         */
            __OM uint16_t WDTCLR   : 1; /*!< [1..1] WDT Clear                                                          */
            __OM uint16_t LVD1CLR  : 1; /*!< [2..2] LVD1 Clear                                                         */
            __OM uint16_t LVD2CLR  : 1; /*!< [3..3] LVD2 Clear                                                         */
            __OM uint16_t VBATTCLR : 1; /*!< [4..4] VBATT Clear                                                        */
            uint16_t               : 1;
            __OM uint16_t  OSTCLR  : 1; /*!< [6..6] OST Clear                                                          */
            __OM uint16_t  NMICLR  : 1; /*!< [7..7] NMI Clear                                                          */
            __OM uint16_t  RPECLR  : 1; /*!< [8..8] SRAM Parity Error Clear                                            */
            __OM uint16_t  RECCCLR : 1; /*!< [9..9] SRAM ECC Error Clear                                               */
            __OM uint16_t  BUSSCLR : 1; /*!< [10..10] Bus Slave Error Clear                                            */
            __OM uint16_t  BUSMCLR : 1; /*!< [11..11] Bus Master Error Clear                                           */
            __OM uint16_t  SPECLR  : 1; /*!< [12..12] CPU Stack Pointer Monitor Interrupt Clear                        */
            __IOM uint16_t TZFCLR  : 1; /*!< [13..13] TZFCLR                                                           */
            uint16_t               : 1;
            __IOM uint16_t CPECLR  : 1; /*!< [15..15] CPECLR                                                           */
        } NMICLR_b;
    };
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[3];

    union
    {
        __IM uint16_t NMISR;           /*!< (@ 0x00000140) Non-Maskable Interrupt Status Register                     */

        struct
        {
            __IM uint16_t IWDTST  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Status Flag                           */
            __IM uint16_t WDTST   : 1; /*!< [1..1] WDT Underflow/Refresh Error Status Flag                            */
            __IM uint16_t LVD1ST  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Status Flag                         */
            __IM uint16_t LVD2ST  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Status Flag                         */
            __IM uint16_t VBATTST : 1; /*!< [4..4] VBATT monitor Interrupt Status Flag                                */
            uint16_t              : 1;
            __IM uint16_t OSTST   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Status Flag                   */
            __IM uint16_t NMIST   : 1; /*!< [7..7] NMI Status Flag                                                    */
            __IM uint16_t RPEST   : 1; /*!< [8..8] RAM Parity Error Interrupt Status Flag                             */
            __IM uint16_t RECCST  : 1; /*!< [9..9] RAM ECC Error Interrupt Status Flag                                */
            __IM uint16_t BUSSST  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Status Flag                        */
            __IM uint16_t BUSMST  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Status Flag                       */
            __IM uint16_t SPEST   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Status Flag                  */
            __IM uint16_t TZFST   : 1; /*!< [13..13] TZFST                                                            */
            uint16_t              : 1;
            __IM uint16_t CPEST   : 1; /*!< [15..15] CPEST                                                            */
        } NMISR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[23];

    union
    {
        __IOM uint32_t WUPEN;                /*!< (@ 0x000001A0) Wake Up Interrupt Enable Register                          */

        struct
        {
            __IOM uint32_t IRQWUPEN0    : 1; /*!< [0..0] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN1    : 1; /*!< [1..1] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN2    : 1; /*!< [2..2] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN3    : 1; /*!< [3..3] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN4    : 1; /*!< [4..4] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN5    : 1; /*!< [5..5] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN6    : 1; /*!< [6..6] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN7    : 1; /*!< [7..7] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN8    : 1; /*!< [8..8] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN9    : 1; /*!< [9..9] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN10   : 1; /*!< [10..10] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN11   : 1; /*!< [11..11] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN12   : 1; /*!< [12..12] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN13   : 1; /*!< [13..13] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN14   : 1; /*!< [14..14] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN15   : 1; /*!< [15..15] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IWDTWUPEN    : 1; /*!< [16..16] IWDT interrupt S/W standby returns enable                        */
            __IOM uint32_t KEYWUPEN     : 1; /*!< [17..17] Key interrupt S/W standby returns enable                         */
            __IOM uint32_t LVD1WUPEN    : 1; /*!< [18..18] LVD1 interrupt S/W standby returns enable                        */
            __IOM uint32_t LVD2WUPEN    : 1; /*!< [19..19] LVD2 interrupt S/W standby returns enable                        */
            __IOM uint32_t VBATTWUPEN   : 1; /*!< [20..20] VBATT monitor interrupt S/W standby returns enable               */
            uint32_t                    : 1;
            __IOM uint32_t ACMPHS0WUPEN : 1; /*!< [22..22] ACMPHS0 interrupt S/W standby returns enable bit                 */
            __IOM uint32_t ACMPLP0WUPEN : 1; /*!< [23..23] ACMPLP0 interrupt S/W standby returns enable                     */
            __IOM uint32_t RTCALMWUPEN  : 1; /*!< [24..24] RTC alarm interrupt S/W standby returns enable                   */
            __IOM uint32_t RTCPRDWUPEN  : 1; /*!< [25..25] RCT period interrupt S/W standby returns enable                  */
            __IOM uint32_t USBHSWUPEN   : 1; /*!< [26..26] USBHS interrupt S/W standby returns enable bit                   */
            __IOM uint32_t USBFSWUPEN   : 1; /*!< [27..27] USBFS interrupt S/W standby returns enable                       */
            __IOM uint32_t AGT1UDWUPEN  : 1; /*!< [28..28] AGT1 underflow interrupt S/W standby returns enable              */
            __IOM uint32_t AGT1CAWUPEN  : 1; /*!< [29..29] AGT1 compare match A interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t AGT1CBWUPEN : 1;  /*!< [30..30] AGT1 compare match B interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t IIC0WUPEN : 1;    /*!< [31..31] IIC0 address match interrupt S/W standby returns enable          */
        } WUPEN_b;
    };

    union
    {
        __IOM uint32_t WUPEN1;              /*!< (@ 0x000001A4) Wake Up interrupt enable register 1                        */

        struct
        {
            __IOM uint32_t AGT3UDWUPEN : 1; /*!< [0..0] AGT3 underflow interrupt S/W standby returns enable bit            */
            __IOM uint32_t AGT3CAWUPEN : 1; /*!< [1..1] AGT3 compare match A interrupt S/W standby returns enable
                                             *   bit                                                                       */
            __IOM uint32_t AGT3CBWUPEN : 1; /*!< [2..2] AGT3 compare match B interrupt S/W standby returns enable
                                             *   bit                                                                       */
            uint32_t : 29;
        } WUPEN1_b;
    };
    __IM uint32_t RESERVED10[22];

    union
    {
        __IOM uint16_t SELSR0;         /*!< (@ 0x00000200) Snooze Event Link Setting Register                         */

        struct
        {
            __IOM uint16_t SELS : 9;   /*!< [8..0] SYS Event Link Select                                              */
            uint16_t            : 7;
        } SELSR0_b;
    };
    __IM uint16_t RESERVED11;
    __IM uint32_t RESERVED12[31];

    union
    {
        __IOM uint32_t DELSR[8];       /*!< (@ 0x00000280) DMAC Event Link Setting Register                           */

        struct
        {
            __IOM uint32_t DELS : 9;   /*!< [8..0] Event selection to DMAC Start request                              */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag for DMAC NOTE: Writing 1 to the
                                        *   IR flag is prohibited.                                                    */
            uint32_t : 15;
        } DELSR_b[8];
    };
    __IM uint32_t RESERVED13[24];

    union
    {
        __IOM uint32_t IELSR[96];      /*!< (@ 0x00000300) ICU Event Link Setting Register [0..95]                    */

        struct
        {
            __IOM uint32_t IELS : 9;   /*!< [8..0] ICU Event selection to NVICSet the number for the event
                                        *   signal to be linked .                                                     */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag                                            */
            uint32_t            : 7;
            __IOM uint32_t DTCE : 1;   /*!< [24..24] DTC Activation Enable                                            */
            uint32_t            : 7;
        } IELSR_b[96];
    };
} R_ICU_Type;                          /*!< Size = 1152 (0x480)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_IIC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I2C Bus Interface (R_IIC0)
 */

typedef struct                         /*!< (@ 0x40053000) R_IIC0 Structure                                           */
{
    union
    {
        __IOM uint8_t ICCR1;           /*!< (@ 0x00000000) I2C Bus Control Register 1                                 */

        struct
        {
            __IM uint8_t  SDAI   : 1;  /*!< [0..0] SDA Line Monitor                                                   */
            __IM uint8_t  SCLI   : 1;  /*!< [1..1] SCL Line Monitor                                                   */
            __IOM uint8_t SDAO   : 1;  /*!< [2..2] SDA Output Control/Monitor                                         */
            __IOM uint8_t SCLO   : 1;  /*!< [3..3] SCL Output Control/Monitor                                         */
            __IOM uint8_t SOWP   : 1;  /*!< [4..4] SCLO/SDAO Write Protect                                            */
            __IOM uint8_t CLO    : 1;  /*!< [5..5] Extra SCL Clock Cycle Output                                       */
            __IOM uint8_t IICRST : 1;  /*!< [6..6] I2C Bus Interface Internal ResetNote:If an internal reset
                                        *   is initiated using the IICRST bit for a bus hang-up occurred
                                        *   during communication with the master device in slave mode,
                                        *   the states may become different between the slave device
                                        *   and the master device (due to the difference in the bit
                                        *   counter information).                                                     */
            __IOM uint8_t ICE : 1;     /*!< [7..7] I2C Bus Interface Enable                                           */
        } ICCR1_b;
    };

    union
    {
        __IOM uint8_t ICCR2;           /*!< (@ 0x00000001) I2C Bus Control Register 2                                 */

        struct
        {
            uint8_t          : 1;
            __IOM uint8_t ST : 1;      /*!< [1..1] Start Condition Issuance RequestSet the ST bit to 1 (start
                                        *   condition issuance request) when the BBSY flag is set to
                                        *   0 (bus free state).                                                       */
            __IOM uint8_t RS : 1;      /*!< [2..2] Restart Condition Issuance RequestNote: Do not set the
                                        *   RS bit to 1 while issuing a stop condition.                               */
            __IOM uint8_t SP : 1;      /*!< [3..3] Stop Condition Issuance RequestNote: Writing to the SP
                                        *   bit is not possible while the setting of the BBSY flag
                                        *   is 0 (bus free state).Note: Do not set the SP bit to 1
                                        *   while a restart condition is being issued.                                */
            uint8_t            : 1;
            __IOM uint8_t TRS  : 1;    /*!< [5..5] Transmit/Receive Mode                                              */
            __IOM uint8_t MST  : 1;    /*!< [6..6] Master/Slave Mode                                                  */
            __IM uint8_t  BBSY : 1;    /*!< [7..7] Bus Busy Detection Flag                                            */
        } ICCR2_b;
    };

    union
    {
        __IOM uint8_t ICMR1;           /*!< (@ 0x00000002) I2C Bus Mode Register 1                                    */

        struct
        {
            __IOM uint8_t BC   : 3;    /*!< [2..0] Bit Counter                                                        */
            __OM uint8_t  BCWP : 1;    /*!< [3..3] BC Write Protect(This bit is read as 1.)                           */
            __IOM uint8_t CKS  : 3;    /*!< [6..4] Internal Reference Clock (fIIC) Selection ( fIIC = PCLKB
                                        *   / 2^CKS )                                                                 */
            __IOM uint8_t MTWP : 1;    /*!< [7..7] MST/TRS Write Protect                                              */
        } ICMR1_b;
    };

    union
    {
        __IOM uint8_t ICMR2;           /*!< (@ 0x00000003) I2C Bus Mode Register 2                                    */

        struct
        {
            __IOM uint8_t TMOS : 1;    /*!< [0..0] Timeout Detection Time Select                                      */
            __IOM uint8_t TMOL : 1;    /*!< [1..1] Timeout L Count Control                                            */
            __IOM uint8_t TMOH : 1;    /*!< [2..2] Timeout H Count Control                                            */
            uint8_t            : 1;
            __IOM uint8_t SDDL : 3;    /*!< [6..4] SDA Output Delay Counter                                           */
            __IOM uint8_t DLCS : 1;    /*!< [7..7] SDA Output Delay Clock Source Select                               */
        } ICMR2_b;
    };

    union
    {
        __IOM uint8_t ICMR3;           /*!< (@ 0x00000004) I2C Bus Mode Register 3                                    */

        struct
        {
            __IOM uint8_t NF    : 2;   /*!< [1..0] Noise Filter Stage Selection                                       */
            __IM uint8_t  ACKBR : 1;   /*!< [2..2] Receive Acknowledge                                                */
            __IOM uint8_t ACKBT : 1;   /*!< [3..3] Transmit Acknowledge                                               */
            __IOM uint8_t ACKWP : 1;   /*!< [4..4] ACKBT Write Protect                                                */
            __IOM uint8_t RDRFS : 1;   /*!< [5..5] RDRF Flag Set Timing Selection                                     */
            __IOM uint8_t WAIT  : 1;   /*!< [6..6] WAITNote: When the value of the WAIT bit is to be read,
                                        *   be sure to read the ICDRR beforehand.                                     */
            __IOM uint8_t SMBS : 1;    /*!< [7..7] SMBus/I2C Bus Selection                                            */
        } ICMR3_b;
    };

    union
    {
        __IOM uint8_t ICFER;           /*!< (@ 0x00000005) I2C Bus Function Enable Register                           */

        struct
        {
            __IOM uint8_t TMOE  : 1;   /*!< [0..0] Timeout Function Enable                                            */
            __IOM uint8_t MALE  : 1;   /*!< [1..1] Master Arbitration-Lost Detection Enable                           */
            __IOM uint8_t NALE  : 1;   /*!< [2..2] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint8_t SALE  : 1;   /*!< [3..3] Slave Arbitration-Lost Detection Enable                            */
            __IOM uint8_t NACKE : 1;   /*!< [4..4] NACK Reception Transfer Suspension Enable                          */
            __IOM uint8_t NFE   : 1;   /*!< [5..5] Digital Noise Filter Circuit Enable                                */
            __IOM uint8_t SCLE  : 1;   /*!< [6..6] SCL Synchronous Circuit Enable                                     */
            __IOM uint8_t FMPE  : 1;   /*!< [7..7] Fast-mode Plus Enable                                              */
        } ICFER_b;
    };

    union
    {
        __IOM uint8_t ICSER;           /*!< (@ 0x00000006) I2C Bus Status Enable Register                             */

        struct
        {
            __IOM uint8_t SAR0E : 1;   /*!< [0..0] Slave Address Register 0 Enable                                    */
            __IOM uint8_t SAR1E : 1;   /*!< [1..1] Slave Address Register 1 Enable                                    */
            __IOM uint8_t SAR2E : 1;   /*!< [2..2] Slave Address Register 2 Enable                                    */
            __IOM uint8_t GCAE  : 1;   /*!< [3..3] General Call Address Enable                                        */
            uint8_t             : 1;
            __IOM uint8_t DIDE  : 1;   /*!< [5..5] Device-ID Address Detection Enable                                 */
            uint8_t             : 1;
            __IOM uint8_t HOAE  : 1;   /*!< [7..7] Host Address Enable                                                */
        } ICSER_b;
    };

    union
    {
        __IOM uint8_t ICIER;           /*!< (@ 0x00000007) I2C Bus Interrupt Enable Register                          */

        struct
        {
            __IOM uint8_t TMOIE : 1;   /*!< [0..0] Timeout Interrupt Request Enable                                   */
            __IOM uint8_t ALIE  : 1;   /*!< [1..1] Arbitration-Lost Interrupt Request Enable                          */
            __IOM uint8_t STIE  : 1;   /*!< [2..2] Start Condition Detection Interrupt Request Enable                 */
            __IOM uint8_t SPIE  : 1;   /*!< [3..3] Stop Condition Detection Interrupt Request Enable                  */
            __IOM uint8_t NAKIE : 1;   /*!< [4..4] NACK Reception Interrupt Request Enable                            */
            __IOM uint8_t RIE   : 1;   /*!< [5..5] Receive Data Full Interrupt Request Enable                         */
            __IOM uint8_t TEIE  : 1;   /*!< [6..6] Transmit End Interrupt Request Enable                              */
            __IOM uint8_t TIE   : 1;   /*!< [7..7] Transmit Data Empty Interrupt Request Enable                       */
        } ICIER_b;
    };

    union
    {
        __IOM uint8_t ICSR1;           /*!< (@ 0x00000008) I2C Bus Status Register 1                                  */

        struct
        {
            __IOM uint8_t AAS0 : 1;    /*!< [0..0] Slave Address 0 Detection Flag                                     */
            __IOM uint8_t AAS1 : 1;    /*!< [1..1] Slave Address 1 Detection Flag                                     */
            __IOM uint8_t AAS2 : 1;    /*!< [2..2] Slave Address 2 Detection Flag                                     */
            __IOM uint8_t GCA  : 1;    /*!< [3..3] General Call Address Detection Flag                                */
            uint8_t            : 1;
            __IOM uint8_t DID  : 1;    /*!< [5..5] Device-ID Address Detection Flag                                   */
            uint8_t            : 1;
            __IOM uint8_t HOA  : 1;    /*!< [7..7] Host Address Detection Flag                                        */
        } ICSR1_b;
    };

    union
    {
        __IOM uint8_t ICSR2;           /*!< (@ 0x00000009) I2C Bus Status Register 2                                  */

        struct
        {
            __IOM uint8_t TMOF  : 1;   /*!< [0..0] Timeout Detection Flag                                             */
            __IOM uint8_t AL    : 1;   /*!< [1..1] Arbitration-Lost Flag                                              */
            __IOM uint8_t START : 1;   /*!< [2..2] Start Condition Detection Flag                                     */
            __IOM uint8_t STOP  : 1;   /*!< [3..3] Stop Condition Detection Flag                                      */
            __IOM uint8_t NACKF : 1;   /*!< [4..4] NACK Detection Flag                                                */
            __IOM uint8_t RDRF  : 1;   /*!< [5..5] Receive Data Full Flag                                             */
            __IOM uint8_t TEND  : 1;   /*!< [6..6] Transmit End Flag                                                  */
            __IM uint8_t  TDRE  : 1;   /*!< [7..7] Transmit Data Empty Flag                                           */
        } ICSR2_b;
    };
    __IOM R_IIC0_SAR_Type SAR[3];      /*!< (@ 0x0000000A) Slave Address Registers                                    */

    union
    {
        __IOM uint8_t ICBRL;           /*!< (@ 0x00000010) I2C Bus Bit Rate Low-Level Register                        */

        struct
        {
            __IOM uint8_t BRL : 5;     /*!< [4..0] Bit Rate Low-Level Period(Low-level period of SCL clock)           */
            uint8_t           : 3;
        } ICBRL_b;
    };

    union
    {
        __IOM uint8_t ICBRH;           /*!< (@ 0x00000011) I2C Bus Bit Rate High-Level Register                       */

        struct
        {
            __IOM uint8_t BRH : 5;     /*!< [4..0] Bit Rate High-Level Period(High-level period of SCL clock)         */
            uint8_t           : 3;
        } ICBRH_b;
    };

    union
    {
        __IOM uint8_t ICDRT;           /*!< (@ 0x00000012) I2C Bus Transmit Data Register                             */

        struct
        {
            __IOM uint8_t ICDRT : 8;   /*!< [7..0] 8-bit read-write register that stores transmit data.               */
        } ICDRT_b;
    };

    union
    {
        __IM uint8_t ICDRR;            /*!< (@ 0x00000013) I2C Bus Receive Data Register                              */

        struct
        {
            __IM uint8_t ICDRR : 8;    /*!< [7..0] 8-bit register that stores the received data                       */
        } ICDRR_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t ICWUR;           /*!< (@ 0x00000016) I2C Bus Wake Up Unit Register                              */

        struct
        {
            __IOM uint8_t WUAFA : 1;   /*!< [0..0] Wakeup Analog Filter Additional Selection                          */
            uint8_t             : 3;
            __IOM uint8_t WUACK : 1;   /*!< [4..4] ACK bit for Wakeup Mode                                            */
            __IOM uint8_t WUF   : 1;   /*!< [5..5] Wakeup Event Occurrence Flag                                       */
            __IOM uint8_t WUIE  : 1;   /*!< [6..6] Wakeup Interrupt Request Enable                                    */
            __IOM uint8_t WUE   : 1;   /*!< [7..7] Wakeup Function Enable                                             */
        } ICWUR_b;
    };

    union
    {
        __IOM uint8_t ICWUR2;          /*!< (@ 0x00000017) I2C Bus Wake up Unit Register 2                            */

        struct
        {
            __IM uint8_t WUSEN  : 1;   /*!< [0..0] Wake-up Function Synchronous Enable                                */
            __IM uint8_t WUASYF : 1;   /*!< [1..1] Wake-up Function Asynchronous Operation Status Flag                */
            __IM uint8_t WUSYF  : 1;   /*!< [2..2] Wake-up Function Synchronous Operation Status Flag                 */
            uint8_t             : 5;
        } ICWUR2_b;
    };
} R_IIC0_Type;                         /*!< Size = 24 (0x18)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_IRDA                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief IrDA Interface (R_IRDA)
 */

typedef struct                         /*!< (@ 0x40070F00) R_IRDA Structure                                           */
{
    union
    {
        __IOM uint8_t IRCR;            /*!< (@ 0x00000000) IrDA Control Register                                      */

        struct
        {
            uint8_t               : 2;
            __IOM uint8_t IRRXINV : 1; /*!< [2..2] IRRXD Polarity Switching                                           */
            __IOM uint8_t IRTXINV : 1; /*!< [3..3] IRTXD Polarity Switching                                           */
            uint8_t               : 3;
            __IOM uint8_t IRE     : 1; /*!< [7..7] IrDA Enable                                                        */
        } IRCR_b;
    };
} R_IRDA_Type;                         /*!< Size = 1 (0x1)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_IWDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Independent Watchdog Timer (R_IWDT)
 */

typedef struct                         /*!< (@ 0x40044400) R_IWDT Structure                                           */
{
    union
    {
        __IOM uint8_t IWDTRR;          /*!< (@ 0x00000000) IWDT Refresh Register                                      */

        struct
        {
            __IOM uint8_t IWDTRR : 8;  /*!< [7..0] The counter is refreshed by writing 0x00 and then writing
                                        *   0xFF to this register.                                                    */
        } IWDTRR_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t IWDTSR;          /*!< (@ 0x00000004) IWDT Status Register                                       */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Counter ValueValue counted by the counter                         */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } IWDTSR_b;
    };
} R_IWDT_Type;                          /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_JPEG                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief JPEG Codec (R_JPEG)
 */

typedef struct                         /*!< (@ 0x400E6000) R_JPEG Structure                                           */
{
    union
    {
        __IOM uint8_t JCMOD;           /*!< (@ 0x00000000) JPEG Code Mode Register                                    */

        struct
        {
            __IOM uint8_t REDU : 3;    /*!< [2..0] Pixel FormatNOTE: Read-only in Decompression.                      */
            __IOM uint8_t DSP  : 1;    /*!< [3..3] Compression/Decompression Set Note: When changing between
                                        *   processing for compression and for decompression, be sure
                                        *   to reset this module in advance by setting the JCUSRST
                                        *   bit in the software reset control register 2 (SWRSTCR2)
                                        *   of the power-downmodes.                                                   */
            uint8_t : 4;
        } JCMOD_b;
    };

    union
    {
        __OM uint8_t JCCMD;            /*!< (@ 0x00000001) JPEG Code Command Register                                 */

        struct
        {
            __OM uint8_t JSRT : 1;     /*!< [0..0] JPEG Core Process Start CommandTo start JPEG core processing,
                                        *   set this bit to 1. Do not write this bit to 1 again while
                                        *   this module is in operation.                                              */
            __OM uint8_t JRST : 1;     /*!< [1..1] JPEG Core Process Stop Clear CommandTo clear the process-stopped
                                        *   state caused by requests to read the image size and pixel
                                        *   format (enabled by the INT3 bit in JINTE0), set this bit
                                        *   to 1.                                                                     */
            __OM uint8_t JEND : 1;     /*!< [2..2] Interrupt Request Clear Command This bit is valid only
                                        *   for the interrupt sources corresponding to bits INS6, INS5,
                                        *   and INS3 in JINTS0. To clear an interrupt request, set
                                        *   this bit to 1                                                             */
            uint8_t           : 4;
            __OM uint8_t BRST : 1;     /*!< [7..7] Bus Reset. NOTE: When this module is in operation, the
                                        *   bus reset command should not be issued.                                   */
        } JCCMD_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t JCQTN;           /*!< (@ 0x00000003) JPEG Code Quantization Table Number Register               */

        struct
        {
            __IOM uint8_t QT1 : 2;     /*!< [1..0] Quantization table number for the first color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            __IOM uint8_t QT2 : 2;     /*!< [3..2] Quantization table number for the second color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t QT3 : 2;     /*!< [5..4] Quantization table number for the third color component
                                        *   NOTE: Read-only in Decompression.                                         */
            uint8_t : 2;
        } JCQTN_b;
    };

    union
    {
        __IOM uint8_t JCHTN;           /*!< (@ 0x00000004) JPEG Code Huffman Table Number Register                    */

        struct
        {
            __IOM uint8_t HTD1 : 1;    /*!< [0..0] Huffman table number (DC) for the first color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t HTA1 : 1;    /*!< [1..1] Huffman table number (AC) for the first color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            __IOM uint8_t HTD2 : 1;    /*!< [2..2] Huffman table number (DC) for the second color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t HTA2 : 1;    /*!< [3..3] Huffman table number (AC) for the second color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            __IOM uint8_t HTD3 : 1;    /*!< [4..4] Huffman table number (DC) for the third color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t HTA3 : 1;    /*!< [5..5] Huffman table number (AC) for the third color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            uint8_t : 2;
        } JCHTN_b;
    };

    union
    {
        __IOM uint8_t JCDRIU;          /*!< (@ 0x00000005) JPEG Code DRI Upper Register                               */

        struct
        {
            __IOM uint8_t DRIU : 8;    /*!< [7..0] Upper Bytes of MCUs Preceding RST MarkerWhen both upper
                                        *   and lower bytes are set to 00h, neither a DRI nor an RST
                                        *   marker is placed.NOTE: Read-only in Decompression.                        */
        } JCDRIU_b;
    };

    union
    {
        __IOM uint8_t JCDRID;          /*!< (@ 0x00000006) JPEG Code DRI Lower Register                               */

        struct
        {
            __IOM uint8_t DRID : 8;    /*!< [7..0] Lower Bytes of MCUs Preceding RST MarkerWhen both upper
                                        *   and lower bytes are set to 00h, neither a DRI nor an RST
                                        *   marker is placed.NOTE: Read-only in Decompression.                        */
        } JCDRID_b;
    };

    union
    {
        __IOM uint8_t JCVSZU;          /*!< (@ 0x00000007) JPEG Code Vertical Size Upper Register                     */

        struct
        {
            __IOM uint8_t VSZU : 8;    /*!< [7..0] Upper Bytes of Vertical Image SizeIn decompression process,
                                        *   a downloaded value from the JPEG coded data is set. NOTE:
                                        *   Read-only in Decompression.                                               */
        } JCVSZU_b;
    };

    union
    {
        __IOM uint8_t JCVSZD;          /*!< (@ 0x00000008) JPEG Code Vertical Size Lower Register                     */

        struct
        {
            __IOM uint8_t VSZD : 8;    /*!< [7..0] Lower Bytes of Vertical Image SizeIn decompression process,
                                        *   a downloaded value from the JPEG coded data is set. NOTE:
                                        *   Read-only in Decompression.                                               */
        } JCVSZD_b;
    };

    union
    {
        __IOM uint8_t JCHSZU;          /*!< (@ 0x00000009) JPEG Code Horizontal Size Upper Register                   */

        struct
        {
            __IOM uint8_t HSZU : 8;    /*!< [7..0] Upper Bytes of Horizontal Image SizeIn decompression
                                        *   process, a downloaded value from the JPEG coded data is
                                        *   set. NOTE: Read-only in Decompression.                                    */
        } JCHSZU_b;
    };

    union
    {
        __IOM uint8_t JCHSZD;          /*!< (@ 0x0000000A) JPEG Coded Horizontal Size Lower Register                  */

        struct
        {
            __IOM uint8_t HSZD : 8;    /*!< [7..0] Lower Bytes of Horizontal Image SizeIn decompression
                                        *   process, a downloaded value from the JPEG coded data is
                                        *   set. NOTE: Read-only in Decompression.                                    */
        } JCHSZD_b;
    };

    union
    {
        __IM uint8_t JCDTCU;           /*!< (@ 0x0000000B) JPEG Code Data Count Upper Register                        */

        struct
        {
            __IM uint8_t DCU : 8;      /*!< [7..0] Upper bytes of the counted amount of data to be compressed
                                        *   The values of this register are reset before compression
                                        *   starts.NOTE: Read-only in Decompression.                                  */
        } JCDTCU_b;
    };

    union
    {
        __IM uint8_t JCDTCM;           /*!< (@ 0x0000000C) JPEG Code Data Count Middle Register                       */

        struct
        {
            __IM uint8_t DCM : 8;      /*!< [7..0] Middle bytes of the counted amount of data to be compressedThe
                                        *   values of this register are reset before compression starts.
                                        *   NOTE: Read-only in Decompression.                                         */
        } JCDTCM_b;
    };

    union
    {
        __IM uint8_t JCDTCD;           /*!< (@ 0x0000000D) JPEG Code Data Count Lower Register                        */

        struct
        {
            __IM uint8_t DCD : 8;      /*!< [7..0] Lower bytes of the counted amount of data to be compressedThe
                                        *   values of this register are reset before compression starts.NOTE:
                                        *   Read-only in Decompression.                                               */
        } JCDTCD_b;
    };

    union
    {
        __IOM uint8_t JINTE0;          /*!< (@ 0x0000000E) JPEG Interrupt Enable Register 0                           */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t INT3 : 1;    /*!< [3..3] This bit enables an interrupt to be generated when it
                                        *   has been determined that the image size and the subsampling
                                        *   setting of the compressed data can be read through analyzing
                                        *   the data.                                                                 */
            uint8_t            : 1;
            __IOM uint8_t INT5 : 1;    /*!< [5..5] This bit enables an interrupt to be generated when the
                                        *   final number of MCU data in the Huffman-coding segment
                                        *   is not correct in decompression. When this bit is not set
                                        *   to enable interrupt generation, an error code is not returned.            */
            __IOM uint8_t INT6 : 1;    /*!< [6..6] This bit enables an interrupt to be generated when the
                                        *   total number of data in the Huffman-coding segment is not
                                        *   correct in decompression. When this bit is not set to enable
                                        *   interrupt generation, an error code is not returned.                      */
            __IOM uint8_t INT7 : 1;    /*!< [7..7] This bit enables an interrupt to be generated when the
                                        *   number of data in the restart interval of the Huffman-coding
                                        *   segment is not correct in decompression.When this bit is
                                        *   not set to enable interrupt generation, an error code is
                                        *   not returned.                                                             */
        } JINTE0_b;
    };

    union
    {
        __IOM uint8_t JINTS0;          /*!< (@ 0x0000000F) JPEG Interrupt Status Register 0                           */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t INS3 : 1;    /*!< [3..3] This bit is set to 1 when the image size and pixel format
                                        *   can be read. When an interrupt occurs, this module stops
                                        *   processing and the state is indicated by the JCRST register.
                                        *   To make this module resume processing, set the JPEG core
                                        *   process stop clear command bit (JRST) in JCCMD.                           */
            uint8_t            : 1;
            __IOM uint8_t INS5 : 1;    /*!< [5..5] This bit is set to 1 when a compressed data error occurs.          */
            __IOM uint8_t INS6 : 1;    /*!< [6..6] This bit is set to 1 when this module completes compression
                                        *   process normally.                                                         */
            uint8_t : 1;
        } JINTS0_b;
    };

    union
    {
        __IOM uint8_t JCDERR;          /*!< (@ 0x00000010) JPEG Code Decode Error Register                            */

        struct
        {
            __IOM uint8_t ERR : 4;     /*!< [3..0] Error Code (See tables )Identify the type of the error
                                        *   which has occurred in the compressed data analysis for
                                        *   decompression.                                                            */
            uint8_t : 4;
        } JCDERR_b;
    };

    union
    {
        __IM uint8_t JCRST;            /*!< (@ 0x00000011) JPEG Code Reset Register                                   */

        struct
        {
            __IM uint8_t RST : 1;      /*!< [0..0] Operating State                                                    */
            uint8_t          : 7;
        } JCRST_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[11];

    union
    {
        __IOM uint32_t JIFECNT;          /*!< (@ 0x00000040) JPEG Interface Compression Control Register                */

        struct
        {
            __IOM uint32_t DINSWAP : 3;  /*!< [2..0] Byte/Halfword Swap                                                 */
            uint32_t               : 1;
            __IOM uint32_t DINLC   : 1;  /*!< [4..4] Count Mode Setting for Stopping Input Image Data Lines             */
            __OM uint32_t  DINRCMD : 1;  /*!< [5..5] Input Image Data Lines Resume Command This bit is valid
                                          *   only when the count mode for stopping the input of image
                                          *   data lines is on. Setting this bit to 1 resumes reading
                                          *   input image data. This bit is always read as 0.                           */
            __IOM uint32_t DINRINI : 1;  /*!< [6..6] Address Initialization when Resuming Input of Image Data
                                          *   Lines This bit is only valid when the count mode for stopping
                                          *   the input of image data lines is on. Set this bit before
                                          *   writing 1 to the data-line resume command bit.                            */
            uint32_t                : 1;
            __IOM uint32_t JOUTSWAP : 3; /*!< [10..8] Byte/Halfword/Word Swap Output coded data in compression
                                          *   is swapped.                                                               */
            uint32_t : 21;
        } JIFECNT_b;
    };

    union
    {
        __IOM uint32_t JIFESA;         /*!< (@ 0x00000044) JPEG Interface Compression Source Address Register         */

        struct
        {
            __IOM uint32_t ESA : 32;   /*!< [31..0] Input Image Data Source Address (in 8-byte units) The
                                        *   lower three bits should be set to 0.                                      */
        } JIFESA_b;
    };

    union
    {
        __IOM uint32_t JIFESOFST;      /*!< (@ 0x00000048) JPEG Interface Compression Line Offset Register            */

        struct
        {
            __IOM uint32_t ESMW : 15;  /*!< [14..0] Input Image Data Lines Offset(in 8-byte units)The lower
                                        *   three bits should be set to 0.                                            */
            uint32_t : 17;
        } JIFESOFST_b;
    };

    union
    {
        __IOM uint32_t JIFEDA;         /*!< (@ 0x0000004C) JPEG Interface Compression Destination Address
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t EDA : 32;   /*!< [31..0] Input Image Data Lines Offset (in 8-byte units) The
                                        *   lower three bits should be set to 0.                                      */
        } JIFEDA_b;
    };

    union
    {
        __IOM uint32_t JIFESLC;        /*!< (@ 0x00000050) JPEG Interface Compression Source Line Count
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t LINES : 16; /*!< [15..0] Number of Input Image Data Lines to be Read (in 8-line
                                        *   units) The lower three bits should be set to 0.                           */
            uint32_t : 16;
        } JIFESLC_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t JIFDCNT;          /*!< (@ 0x00000058) JPEG Interface Decompression Control Register              */

        struct
        {
            __IOM uint32_t DOUTSWAP : 3; /*!< [2..0] Byte/Word Swap Output image data in decompression is
                                          *   swapped.                                                                  */
            uint32_t                : 1;
            __IOM uint32_t DOUTLC   : 1; /*!< [4..4] Count Mode for Stopping Output Image Data Lines                    */
            __OM uint32_t  DOUTRCMD : 1; /*!< [5..5] Output Image Data Lines Resume Command This bit is valid
                                          *   only when the count mode for stopping the output of image
                                          *   data lines is on. Setting this bit to 1 resumes writing
                                          *   image data. This bit is always read as 0.                                 */
            __IOM uint32_t DOUTRINI : 1; /*!< [6..6] Address Initialization when Resuming Output of Image
                                          *   Data Lines This bit is only valid when the count mode for
                                          *   stopping the output of image data lines is on. Set this
                                          *   bit before writing 1 to the data-line resume command bit.                 */
            uint32_t               : 1;
            __IOM uint32_t JINSWAP : 3;  /*!< [10..8] Byte/Word/Longword Swap Input coded data in decompression
                                          *   is swapped.                                                               */
            uint32_t               : 1;
            __IOM uint32_t JINC    : 1;  /*!< [12..12] Count Mode Setting for Stopping Input Coded Data                 */
            __OM uint32_t  JINRCMD : 1;  /*!< [13..13] Input Coded Data Resume CommandThis bit is valid only
                                          *   when the count mode for stopping the input of coded data
                                          *   is on. Setting this bit to 1 resumes reading input coded
                                          *   data. This bit is always read as 0.                                       */
            __IOM uint32_t JINRINI : 1;  /*!< [14..14] Address Initialization when Input Coded Data is Resumed
                                          *   This bit is only valid when the count mode for stopping
                                          *   the input of coded data is on. Set this bit before writing
                                          *   1 to the data resume command bit.                                         */
            uint32_t              : 9;
            __IOM uint32_t OPF    : 2;   /*!< [25..24] Specifies output image data pixel format.                        */
            __IOM uint32_t HINTER : 2;   /*!< [27..26] Horizontal Subsampling Subsamples horizontal output
                                          *   image data.                                                               */
            __IOM uint32_t VINTER : 2;   /*!< [29..28] Vertical SubsamplingSubsamples vertical output image
                                          *   data.                                                                     */
            uint32_t : 2;
        } JIFDCNT_b;
    };

    union
    {
        __IOM uint32_t JIFDSA;         /*!< (@ 0x0000005C) JPEG Interface Decompression Source Address Register       */

        struct
        {
            __IOM uint32_t DSA : 32;   /*!< [31..0] Input Coded Data Source AddressInput Coded Data Source
                                        *   Address (in 8-byte units) The lower three bits should be
                                        *   set to 0.                                                                 */
        } JIFDSA_b;
    };

    union
    {
        __IOM uint32_t JIFDDOFST;      /*!< (@ 0x00000060) JPEG Interface Decompression Line Offset Register          */

        struct
        {
            __IOM uint32_t DDMW : 15;  /*!< [14..0] Output Image Data Lines Offset (in 8-byte units) The
                                        *   lower three bits should be set to 0.                                      */
            uint32_t : 17;
        } JIFDDOFST_b;
    };

    union
    {
        __IOM uint32_t JIFDDA;         /*!< (@ 0x00000064) JPEG Interface Decompression Destination Address
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t DDA : 32;   /*!< [31..0] Output Image Data Destination Address (in 8-byte units)
                                        *   The lower three bits should be set to 0.                                  */
        } JIFDDA_b;
    };

    union
    {
        __IOM uint32_t JIFDSDC;         /*!< (@ 0x00000068) JPEG Interface Decompression Source Data Count
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t JDATAS : 16; /*!< [15..0] Amount of Input Coded Data to be Read (in 8-byte units)
                                         *   The lower three bits should be set to 0.                                  */
            uint32_t : 16;
        } JIFDSDC_b;
    };

    union
    {
        __IOM uint32_t JIFDDLC;        /*!< (@ 0x0000006C) JPEG Interface Decompression Destination Line
                                        *                  Count Register                                             */

        struct
        {
            __IOM uint32_t LINES : 16; /*!< [15..0] Number of Input Image Lines to Be ReadThe lower three
                                        *   bits should be set to 0. These bits are read as0.Number
                                        *   of input image data lines to be read, in 8-line units.                    */
            uint32_t : 16;
        } JIFDDLC_b;
    };

    union
    {
        __IOM uint32_t JIFDADT;        /*!< (@ 0x00000070) JPEG Interface Decompression alpha Set Register            */

        struct
        {
            __IOM uint32_t ALPHA : 8;  /*!< [7..0] Setting of the alpha value for output in ARGB8888 format.          */
            uint32_t             : 24;
        } JIFDADT_b;
    };
    __IM uint32_t RESERVED4[6];

    union
    {
        __IOM uint32_t JINTE1;          /*!< (@ 0x0000008C) JPEG Interrupt Enable Register 1                           */

        struct
        {
            __IOM uint32_t DOUTLEN : 1; /*!< [0..0] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the DOUTLF bit in JINTS1 is set to
                                         *   1                                                                         */
            __IOM uint32_t JINEN : 1;   /*!< [1..1] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the JINF bit in JINTS1 is set to 1.                   */
            __IOM uint32_t DBTEN : 1;   /*!< [2..2] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the DBTF bit in JINTS1 is set to 1.                   */
            uint32_t              : 2;
            __IOM uint32_t DINLEN : 1;  /*!< [5..5] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the DINLF bit in JINTS1 is set to 1.                  */
            __IOM uint32_t CBTEN : 1;   /*!< [6..6] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the CBTF bit in JINTS1 is set to 1.                   */
            uint32_t : 25;
        } JINTE1_b;
    };

    union
    {
        __IOM uint32_t JINTS1;         /*!< (@ 0x00000090) JPEG Interrupt Status Register 1                           */

        struct
        {
            __IOM uint32_t DOUTLF : 1; /*!< [0..0] In decompression, this bit is set to 1 when the number
                                        *   of lines of output image data indicated by JIFDDLC have
                                        *   been written. This bit is only valid when the DOUTLC bit
                                        *   in JIFDCNT is set to 1.                                                   */
            __IOM uint32_t JINF : 1;   /*!< [1..1] This bit is set to 1 when the amount of input coded data
                                        *   indicated by JIFDSDC is read in decompression. This bit
                                        *   is valid only when the JINC bit in JIFDCNT is set to 1.                   */
            __IOM uint32_t DBTF : 1;   /*!< [2..2] This bit is set to 1 when the last output image data
                                        *   is written in decompression.                                              */
            uint32_t             : 2;
            __IOM uint32_t DINLF : 1;  /*!< [5..5] This bit is set to 1 when the number of input image data
                                        *   lines indicated by JIFESLC is read in compression. This
                                        *   bit is valid only when the DINLC bit in JIFECNT is set
                                        *   to 1.                                                                     */
            __IOM uint32_t CBTF : 1;   /*!< [6..6] This bit is set to 1 when the last output coded data
                                        *   is written in compression.                                                */
            uint32_t : 25;
        } JINTS1_b;
    };
    __IM uint32_t RESERVED5[27];
    __OM uint8_t  JCQTBL0[64];         /*!< (@ 0x00000100) Quantization Table 0                                       */
    __OM uint8_t  JCQTBL1[64];         /*!< (@ 0x00000140) Quantization Table 1                                       */
    __OM uint8_t  JCQTBL2[64];         /*!< (@ 0x00000180) Quantization Table 2                                       */
    __OM uint8_t  JCQTBL3[64];         /*!< (@ 0x000001C0) Quantization Table 3                                       */
    __IOM uint8_t JCHTBD0[28];         /*!< (@ 0x00000200) DC Huffman Table 0                                         */
    __IM uint32_t RESERVED6;
    __IOM uint8_t JCHTBA0[178];        /*!< (@ 0x00000220) AC Huffman Table 0                                         */
    __IM uint16_t RESERVED7;
    __IM uint32_t RESERVED8[11];
    __IOM uint8_t JCHTBD1[28];         /*!< (@ 0x00000300) DC Huffman Table 1                                         */
    __IM uint32_t RESERVED9;
    __IOM uint8_t JCHTBA1[178];        /*!< (@ 0x00000320) DC Huffman Table 1                                         */
    __IM uint16_t RESERVED10;
} R_JPEG_Type;                         /*!< Size = 980 (0x3d4)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_KINT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Key Interrupt Function (R_KINT)
 */

typedef struct                         /*!< (@ 0x40080000) R_KINT Structure                                           */
{
    union
    {
        __IOM uint8_t KRCTL;           /*!< (@ 0x00000000) KEY Return Control Register                                */

        struct
        {
            __IOM uint8_t KREG : 1;    /*!< [0..0] Detection Edge Selection (KRF0 to KRF7)                            */
            uint8_t            : 6;
            __IOM uint8_t KRMD : 1;    /*!< [7..7] Usage of Key Interrupt Flags(KR0 to KR7)                           */
        } KRCTL_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t KRF;             /*!< (@ 0x00000004) KEY Return Flag Register                                   */

        struct
        {
            __IOM uint8_t KRF0 : 1;    /*!< [0..0] Key interrupt flag 0                                               */
            __IOM uint8_t KRF1 : 1;    /*!< [1..1] Key interrupt flag 1                                               */
            __IOM uint8_t KRF2 : 1;    /*!< [2..2] Key interrupt flag 2                                               */
            __IOM uint8_t KRF3 : 1;    /*!< [3..3] Key interrupt flag 3                                               */
            __IOM uint8_t KRF4 : 1;    /*!< [4..4] Key interrupt flag 4                                               */
            __IOM uint8_t KRF5 : 1;    /*!< [5..5] Key interrupt flag 5                                               */
            __IOM uint8_t KRF6 : 1;    /*!< [6..6] Key interrupt flag 6                                               */
            __IOM uint8_t KRF7 : 1;    /*!< [7..7] Key interrupt flag 7                                               */
        } KRF_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t KRM;             /*!< (@ 0x00000008) KEY Return Mode Register                                   */

        struct
        {
            __IOM uint8_t KRM0 : 1;    /*!< [0..0] Key interrupt mode control 0                                       */
            __IOM uint8_t KRM1 : 1;    /*!< [1..1] Key interrupt mode control 1                                       */
            __IOM uint8_t KRM2 : 1;    /*!< [2..2] Key interrupt mode control 2                                       */
            __IOM uint8_t KRM3 : 1;    /*!< [3..3] Key interrupt mode control 3                                       */
            __IOM uint8_t KRM4 : 1;    /*!< [4..4] Key interrupt mode control 4                                       */
            __IOM uint8_t KRM5 : 1;    /*!< [5..5] Key interrupt mode control 5                                       */
            __IOM uint8_t KRM6 : 1;    /*!< [6..6] Key interrupt mode control 6                                       */
            __IOM uint8_t KRM7 : 1;    /*!< [7..7] Key interrupt mode control 7                                       */
        } KRM_b;
    };
} R_KINT_Type;                         /*!< Size = 9 (0x9)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_MMF                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Memory Mirror Function (R_MMF)
 */

typedef struct                         /*!< (@ 0x40001000) R_MMF Structure                                            */
{
    union
    {
        __IOM uint32_t MMSFR;          /*!< (@ 0x00000000) MemMirror Special Function Register                        */

        struct
        {
            uint32_t                  : 7;
            __IOM uint32_t MEMMIRADDR : 16; /*!< [22..7] Specifies the memory mirror address.NOTE: A value cannot
                                             *   be set in the low-order 7 bits. These bits are fixed to
                                             *   0.                                                                        */
            uint32_t          : 1;
            __OM uint32_t KEY : 8;          /*!< [31..24] MMSFR Key Code                                                   */
        } MMSFR_b;
    };

    union
    {
        __IOM uint32_t MMEN;           /*!< (@ 0x00000004) MemMirror Enable Register                                  */

        struct
        {
            __IOM uint32_t EN : 1;     /*!< [0..0] Memory Mirror Function Enable                                      */
            uint32_t          : 23;
            __OM uint32_t KEY : 8;     /*!< [31..24] MMEN Key Code                                                    */
        } MMEN_b;
    };
} R_MMF_Type;                          /*!< Size = 8 (0x8)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_MPU_MMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Master MPU (R_MPU_MMPU)
 */

typedef struct                          /*!< (@ 0x40000000) R_MPU_MMPU Structure                                       */
{
    __IOM R_MPU_MMPU_MMPU_Type MMPU[3]; /*!< (@ 0x00000000) Bus Master MPU Registers                                   */
} R_MPU_MMPU_Type;                      /*!< Size = 3072 (0xc00)                                                       */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Slave MPU (R_MPU_SMPU)
 */

typedef struct                           /*!< (@ 0x40000C00) R_MPU_SMPU Structure                                       */
{
    union
    {
        __IOM uint16_t SMPUCTL;          /*!< (@ 0x00000000) Slave MPU Control Register                                 */

        struct
        {
            __IOM uint16_t OAD     : 1;  /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t PROTECT : 1;  /*!< [1..1] Protection of register                                             */
            uint16_t               : 6;
            __OM uint16_t KEY      : 8;  /*!< [15..8] Key Code This bit is used to enable or disable rewriting
                                          *   of the PROTECT and OAD bit.                                               */
        } SMPUCTL_b;
    };
    __IM uint16_t              RESERVED[7];
    __IOM R_MPU_SMPU_SMPU_Type SMPU[10]; /*!< (@ 0x00000010) Access Control Structure for MBIU                          */
} R_MPU_SMPU_Type;                       /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SPMON                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief CPU Stack Pointer Monitor (R_MPU_SPMON)
 */

typedef struct                         /*!< (@ 0x40000D00) R_MPU_SPMON Structure                                      */
{
    __IOM R_MPU_SPMON_SP_Type SP[2];   /*!< (@ 0x00000000) Stack Pointer Monitor                                      */
} R_MPU_SPMON_Type;                    /*!< Size = 32 (0x20)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_MSTP                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief System-Module Stop (R_MSTP)
 */

typedef struct                         /*!< (@ 0x40047000) R_MSTP Structure                                           */
{
    union
    {
        __IOM uint32_t MSTPCRB;        /*!< (@ 0x00000000) Module Stop Control Register B                             */

        struct
        {
            uint32_t               : 1;
            __IOM uint32_t MSTPB1  : 1; /*!< [1..1] RCAN1 Module Stop                                                  */
            __IOM uint32_t MSTPB2  : 1; /*!< [2..2] RCAN0 Module Stop                                                  */
            uint32_t               : 2;
            __IOM uint32_t MSTPB5  : 1; /*!< [5..5] IrDA Module Stop                                                   */
            __IOM uint32_t MSTPB6  : 1; /*!< [6..6] Queued Serial Peripheral Interface Module Stop                     */
            __IOM uint32_t MSTPB7  : 1; /*!< [7..7] I2C Bus Interface 2 Module Stop                                    */
            __IOM uint32_t MSTPB8  : 1; /*!< [8..8] I2C Bus Interface 1 Module Stop                                    */
            __IOM uint32_t MSTPB9  : 1; /*!< [9..9] I2C Bus Interface 0 Module Stop                                    */
            uint32_t               : 1;
            __IOM uint32_t MSTPB11 : 1; /*!< [11..11] Universal Serial Bus 2.0 FS Interface Module Stop                */
            __IOM uint32_t MSTPB12 : 1; /*!< [12..12] Universal Serial Bus 2.0 HS Interface Module Stop                */
            __IOM uint32_t MSTPB13 : 1; /*!< [13..13] EPTPC and PTPEDMAC Module Stop                                   */
            __IOM uint32_t MSTPB14 : 1; /*!< [14..14] ETHERC1 and EDMAC1 Module Stop                                   */
            __IOM uint32_t MSTPB15 : 1; /*!< [15..15] ETHERC0 and EDMAC0 Module Stop                                   */
            uint32_t               : 2;
            __IOM uint32_t MSTPB18 : 1; /*!< [18..18] Serial Peripheral Interface Module Stop                          */
            __IOM uint32_t MSTPB19 : 1; /*!< [19..19] Serial Peripheral Interface 0 Module Stop                        */
            uint32_t               : 2;
            __IOM uint32_t MSTPB22 : 1; /*!< [22..22] Serial Communication Interface 9 Module Stop                     */
            __IOM uint32_t MSTPB23 : 1; /*!< [23..23] Serial Communication Interface 8 Module Stop                     */
            __IOM uint32_t MSTPB24 : 1; /*!< [24..24] Serial Communication Interface 7 Module Stop                     */
            __IOM uint32_t MSTPB25 : 1; /*!< [25..25] Serial Communication Interface 6 Module Stop                     */
            __IOM uint32_t MSTPB26 : 1; /*!< [26..26] Serial Communication Interface 5 Module Stop                     */
            __IOM uint32_t MSTPB27 : 1; /*!< [27..27] Serial Communication Interface 4 Module Stop                     */
            __IOM uint32_t MSTPB28 : 1; /*!< [28..28] Serial Communication Interface 3 Module Stop                     */
            __IOM uint32_t MSTPB29 : 1; /*!< [29..29] Serial Communication Interface 2 Module Stop                     */
            __IOM uint32_t MSTPB30 : 1; /*!< [30..30] Serial Communication Interface 1 Module Stop                     */
            __IOM uint32_t MSTPB31 : 1; /*!< [31..31] Serial Communication Interface 0 Module Stop                     */
        } MSTPCRB_b;
    };

    union
    {
        __IOM uint32_t MSTPCRC;         /*!< (@ 0x00000004) Module Stop Control Register C                             */

        struct
        {
            __IOM uint32_t MSTPC0  : 1; /*!< [0..0] CAC Module Stop                                                    */
            __IOM uint32_t MSTPC1  : 1; /*!< [1..1] CRC Calculator Module Stop                                         */
            __IOM uint32_t MSTPC2  : 1; /*!< [2..2] Parallel Data Capture Module Stop                                  */
            __IOM uint32_t MSTPC3  : 1; /*!< [3..3] Capacitive Touch Sensing Unit Module Stop                          */
            __IOM uint32_t MSTPC4  : 1; /*!< [4..4] Segment LCD Controller Module Stop                                 */
            __IOM uint32_t MSTPC5  : 1; /*!< [5..5] JPEG codec engine Module Stop                                      */
            __IOM uint32_t MSTPC6  : 1; /*!< [6..6] 2DG engine Module Stop                                             */
            __IOM uint32_t MSTPC7  : 1; /*!< [7..7] Synchronous Serial Interface 1 Module Stop                         */
            __IOM uint32_t MSTPC8  : 1; /*!< [8..8] Synchronous Serial Interface 0 Module Stop                         */
            __IOM uint32_t MSTPC9  : 1; /*!< [9..9] Sampling Rate Converter Module Stop                                */
            uint32_t               : 1;
            __IOM uint32_t MSTPC11 : 1; /*!< [11..11] Secure Digital Host IF/ Multi Media Card 1 Module Stop           */
            __IOM uint32_t MSTPC12 : 1; /*!< [12..12] Secure Digital Host IF/ Multi Media Card 0 Module Stop           */
            __IOM uint32_t MSTPC13 : 1; /*!< [13..13] Data Operation Circuit Module Stop                               */
            __IOM uint32_t MSTPC14 : 1; /*!< [14..14] Event Link Controller Module Stop                                */
            uint32_t               : 13;
            __IOM uint32_t MSTPC28 : 1; /*!< [28..28] Random Number Generator Module Stop                              */
            uint32_t               : 2;
            __IOM uint32_t MSTPC31 : 1; /*!< [31..31] AES Module Stop                                                  */
        } MSTPCRC_b;
    };

    union
    {
        __IOM uint32_t MSTPCRD;         /*!< (@ 0x00000008) Module Stop Control Register D                             */

        struct
        {
            __IOM uint32_t MSTPD0 : 1;  /*!< [0..0] Low Power Asynchronous General Purpose Timer 3 Module
                                         *   Stop                                                                      */
            __IOM uint32_t MSTPD1 : 1;  /*!< [1..1] Low Power Asynchronous General Purpose Timer 2 Module
                                         *   Stop                                                                      */
            __IOM uint32_t MSTPD2 : 1;  /*!< [2..2] AGT1 Module StopNote: AGT1 is in the module stop state
                                         *   when the count source is either of PCLKB, PCLKB/2 or PCLKB/8.
                                         *   In case the count source is sub-clock or LOCO, this bit
                                         *   should be set to 1 except when accessing the registers
                                         *   of AGT1.                                                                  */
            __IOM uint32_t MSTPD3 : 1;  /*!< [3..3] AGT0 Module StopNote: AGT0 is in the module stop state
                                         *   when the count source is either of PCLKB, PCLKB/2 or PCLKB/8.
                                         *   In case the count source is sub-clock or LOCO, this bit
                                         *   should be set to 1 except when accessing the registers
                                         *   of AGT0.                                                                  */
            uint32_t               : 1;
            __IOM uint32_t MSTPD5  : 1; /*!< [5..5] GPT Lower Module Stop                                              */
            __IOM uint32_t MSTPD6  : 1; /*!< [6..6] GPT Higher Module Stop                                             */
            uint32_t               : 4;
            __IOM uint32_t MSTPD11 : 1; /*!< [11..11] Port Output Enable for GPT 3 Module Stop                         */
            __IOM uint32_t MSTPD12 : 1; /*!< [12..12] Port Output Enable for GPT 2 Module Stop                         */
            __IOM uint32_t MSTPD13 : 1; /*!< [13..13] Port Output Enable for GPT 1 Module Stop                         */
            __IOM uint32_t MSTPD14 : 1; /*!< [14..14] POEG Module Stop                                                 */
            __IOM uint32_t MSTPD15 : 1; /*!< [15..15] 12-Bit A/D Converter 1 Module Stop                               */
            __IOM uint32_t MSTPD16 : 1; /*!< [16..16] 16-Bit A/D Converter Module Stop                                 */
            __IOM uint32_t MSTPD17 : 1; /*!< [17..17] 24-bit Sigma-Delta A/DConverter Module Stop                      */
            uint32_t               : 1;
            __IOM uint32_t MSTPD19 : 1; /*!< [19..19] 8-Bit D/A Converter Module Stop                                  */
            __IOM uint32_t MSTPD20 : 1; /*!< [20..20] 12-bit D/A Converter Module Stop                                 */
            uint32_t               : 1;
            __IOM uint32_t MSTPD22 : 1; /*!< [22..22] Temperature Sensor Module Stop                                   */
            __IOM uint32_t MSTPD23 : 1; /*!< [23..23] ACMPHS5 Module Stop                                              */
            __IOM uint32_t MSTPD24 : 1; /*!< [24..24] ACMPHS4 Module Stop                                              */
            __IOM uint32_t MSTPD25 : 1; /*!< [25..25] ACMPHS3 Module Stop                                              */
            __IOM uint32_t MSTPD26 : 1; /*!< [26..26] ACMPHS2 Module Stop                                              */
            __IOM uint32_t MSTPD27 : 1; /*!< [27..27] ACMPHS1 Module Stop                                              */
            __IOM uint32_t MSTPD28 : 1; /*!< [28..28] ACMPHS0 Module Stop                                              */
            __IOM uint32_t MSTPD29 : 1; /*!< [29..29] Comparator-LP Module Stop                                        */
            uint32_t               : 1;
            __IOM uint32_t MSTPD31 : 1; /*!< [31..31] Operational Amplifier Module Stop                                */
        } MSTPCRD_b;
    };

    union
    {
        __IOM uint32_t MSTPCRE;        /*!< (@ 0x0000000C) Module Stop Control Register E                             */

        struct
        {
            uint32_t               : 14;
            __IOM uint32_t MSTPE14 : 1; /*!< [14..14] Low Power Asynchronous General Purpose Timer 5 Module
                                         *   Stop                                                                      */
            __IOM uint32_t MSTPE15 : 1; /*!< [15..15] Low Power Asynchronous General Purpose Timer 4 Module
                                         *   Stop                                                                      */
            uint32_t               : 6;
            __IOM uint32_t MSTPE22 : 1; /*!< [22..22] GPT9 Module Stop                                                 */
            __IOM uint32_t MSTPE23 : 1; /*!< [23..23] GPT8 Module Stop                                                 */
            __IOM uint32_t MSTPE24 : 1; /*!< [24..24] GPT7 Module Stop                                                 */
            __IOM uint32_t MSTPE25 : 1; /*!< [25..25] GPT6 Module Stop                                                 */
            __IOM uint32_t MSTPE26 : 1; /*!< [26..26] GPT5 Module Stop                                                 */
            __IOM uint32_t MSTPE27 : 1; /*!< [27..27] GPT4 Module Stop                                                 */
            __IOM uint32_t MSTPE28 : 1; /*!< [28..28] GPT3 Module Stop                                                 */
            __IOM uint32_t MSTPE29 : 1; /*!< [29..29] GPT2 Module Stop                                                 */
            __IOM uint32_t MSTPE30 : 1; /*!< [30..30] GPT1 Module Stop                                                 */
            __IOM uint32_t MSTPE31 : 1; /*!< [31..31] GPT0 Module Stop                                                 */
        } MSTPCRE_b;
    };
} R_MSTP_Type;                          /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_OPAMP                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Operational Amplifier (R_OPAMP)
 */

typedef struct                         /*!< (@ 0x40086000) R_OPAMP Structure                                          */
{
    __IM uint8_t RESERVED[8];

    union
    {
        __IOM uint8_t AMPMC;           /*!< (@ 0x00000008) Operational amplifier mode control register                */

        struct
        {
            __IOM uint8_t AMPPC0 : 1;  /*!< [0..0] Operational amplifier precharge control status                     */
            __IOM uint8_t AMPPC1 : 1;  /*!< [1..1] Operational amplifier precharge control status                     */
            __IOM uint8_t AMPPC2 : 1;  /*!< [2..2] Operational amplifier precharge control status                     */
            uint8_t              : 4;
            __IOM uint8_t AMPSP  : 1;  /*!< [7..7] Operation mode selection                                           */
        } AMPMC_b;
    };

    union
    {
        __IOM uint8_t AMPTRM;          /*!< (@ 0x00000009) Operational amplifier trigger mode control register        */

        struct
        {
            __IOM uint8_t AMPTRM0 : 2; /*!< [1..0] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
            __IOM uint8_t AMPTRM1 : 2; /*!< [3..2] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
            __IOM uint8_t AMPTRM2 : 2; /*!< [5..4] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
            __IOM uint8_t AMPTRM3 : 2; /*!< [7..6] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
        } AMPTRM_b;
    };

    union
    {
        __IOM uint8_t AMPTRS;          /*!< (@ 0x0000000A) Operational Amplifier Activation Trigger Select
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t AMPTRS : 2;  /*!< [1..0] ELC trigger selection Do not change the value of the
                                        *   AMPTRS register after setting the AMPTRM register.                        */
            uint8_t : 6;
        } AMPTRS_b;
    };

    union
    {
        __IOM uint8_t AMPC;            /*!< (@ 0x0000000B) Operational amplifier control register                     */

        struct
        {
            __IOM uint8_t AMPE0 : 1;   /*!< [0..0] Operation control of operational amplifier                         */
            __IOM uint8_t AMPE1 : 1;   /*!< [1..1] Operation control of operational amplifier                         */
            __IOM uint8_t AMPE2 : 1;   /*!< [2..2] Operation control of operational amplifier                         */
            __IOM uint8_t AMPE3 : 1;   /*!< [3..3] Operation control of operational amplifier                         */
            uint8_t             : 3;
            __IOM uint8_t IREFE : 1;   /*!< [7..7] Operation control of operational amplifier reference
                                        *   current circuit                                                           */
        } AMPC_b;
    };

    union
    {
        __IM uint8_t AMPMON;           /*!< (@ 0x0000000C) Operational amplifier monitor register                     */

        struct
        {
            __IM uint8_t AMPMON0 : 1;  /*!< [0..0] Operational amplifier status                                       */
            __IM uint8_t AMPMON1 : 1;  /*!< [1..1] Operational amplifier status                                       */
            __IM uint8_t AMPMON2 : 1;  /*!< [2..2] Operational amplifier status                                       */
            __IM uint8_t AMPMON3 : 1;  /*!< [3..3] Operational amplifier status                                       */
            uint8_t              : 4;
        } AMPMON_b;
    };
    __IM uint8_t           RESERVED1;
    __IOM R_OPAMP_AMP_Type AMP[4];     /*!< (@ 0x0000000E) Input and Output Selectors for Operational Amplifier
                                        *                  [0..3]                                                     */

    union
    {
        __IOM uint8_t AMPCPC;          /*!< (@ 0x0000001A) Operational amplifier switch charge pump control
                                        *                  register                                                   */

        struct
        {
            __IOM uint8_t PUMP0EN : 1; /*!< [0..0] charge pump for AMP0 enable/disable                                */
            __IOM uint8_t PUMP1EN : 1; /*!< [1..1] charge pump for AMP1 enable/disable                                */
            __IOM uint8_t PUMP2EN : 1; /*!< [2..2] charge pump for AMP2 enable/disable                                */
            uint8_t               : 5;
        } AMPCPC_b;
    };
    __IM uint8_t RESERVED2[4];

    union
    {
        __IOM uint8_t AMPUOTE;         /*!< (@ 0x0000001F) Operational Amplifier User Offset Trimming Enable
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t AMP0TE : 1;  /*!< [0..0] AMP0OT write enable                                                */
            __IOM uint8_t AMP1TE : 1;  /*!< [1..1] AMP1OT write enable                                                */
            __IOM uint8_t AMP2TE : 1;  /*!< [2..2] AMP2OT write enable                                                */
            uint8_t              : 5;
        } AMPUOTE_b;
    };
    __IOM R_OPAMP_AMPOT_Type AMPOT[3]; /*!< (@ 0x00000020) Operational Amplifier n Offset Trimming Registers          */
} R_OPAMP_Type;                        /*!< Size = 38 (0x26)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_PDC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Parallel Data Capture Unit (R_PDC)
 */

typedef struct                         /*!< (@ 0x40094000) R_PDC Structure                                            */
{
    union
    {
        __IOM uint32_t PCCR0;          /*!< (@ 0x00000000) PDC Control Register 0                                     */

        struct
        {
            __IOM uint32_t PCKE   : 1; /*!< [0..0] Channel 0 GTCNT Count Clear                                        */
            __IOM uint32_t VPS    : 1; /*!< [1..1] VSYNC Signal Polarity Select                                       */
            __IOM uint32_t HPS    : 1; /*!< [2..2] HSYNC Signal Polarity Select                                       */
            __OM uint32_t  PRST   : 1; /*!< [3..3] PDC Reset                                                          */
            __IOM uint32_t DFIE   : 1; /*!< [4..4] Receive Data Ready Interrupt Enable                                */
            __IOM uint32_t FEIE   : 1; /*!< [5..5] Frame End Interrupt Enable                                         */
            __IOM uint32_t OVIE   : 1; /*!< [6..6] Overrun Interrupt Enable                                           */
            __IOM uint32_t UDRIE  : 1; /*!< [7..7] Underrun Interrupt Enable                                          */
            __IOM uint32_t VERIE  : 1; /*!< [8..8] Vertical Line Number Setting Error Interrupt Enable                */
            __IOM uint32_t HERIE  : 1; /*!< [9..9] Horizontal Byte Number Setting Error Interrupt Enable              */
            __IOM uint32_t PCKOE  : 1; /*!< [10..10] PCKO Output Enable                                               */
            __IOM uint32_t PCKDIV : 3; /*!< [13..11] PCKO Frequency Division Ratio Select                             */
            __IOM uint32_t EDS    : 1; /*!< [14..14] Endian Select                                                    */
            uint32_t              : 17;
        } PCCR0_b;
    };

    union
    {
        __IOM uint32_t PCCR1;          /*!< (@ 0x00000004) PDC Control Register 1                                     */

        struct
        {
            __IOM uint32_t PCE : 1;    /*!< [0..0] PDC Operation Enable                                               */
            uint32_t           : 31;
        } PCCR1_b;
    };

    union
    {
        __IOM uint32_t PCSR;           /*!< (@ 0x00000008) PDC Status Register                                        */

        struct
        {
            __IM uint32_t  FBSY  : 1;  /*!< [0..0] Frame Busy Flag                                                    */
            __IM uint32_t  FEMPF : 1;  /*!< [1..1] FIFO Empty Flag                                                    */
            __IOM uint32_t FEF   : 1;  /*!< [2..2] Frame End Flag                                                     */
            __IOM uint32_t OVRF  : 1;  /*!< [3..3] Overrun Flag                                                       */
            __IOM uint32_t UDRF  : 1;  /*!< [4..4] Underrun Flag                                                      */
            __IOM uint32_t VERF  : 1;  /*!< [5..5] Vertical Line Number Setting Error Flag                            */
            __IOM uint32_t HERF  : 1;  /*!< [6..6] Horizontal Byte Number Setting Error Flag                          */
            uint32_t             : 25;
        } PCSR_b;
    };

    union
    {
        __IM uint32_t PCMONR;          /*!< (@ 0x0000000C) PDC Pin Monitor Register                                   */

        struct
        {
            __IM uint32_t VSYNC : 1;   /*!< [0..0] VSYNC Signal Status Flag                                           */
            __IM uint32_t HSYNC : 1;   /*!< [1..1] HSYNC Signal Status Flag                                           */
            uint32_t            : 30;
        } PCMONR_b;
    };

    union
    {
        __IM uint32_t PCDR;            /*!< (@ 0x00000010) PDC Receive Data Register                                  */

        struct
        {
            __IM uint32_t PCDR : 32;   /*!< [31..0] The PDC includes a 32-bit-wide, 22-stage FIFO for the
                                        *   storage of captured data. The PCDR register is a 4-byte
                                        *   space to which the FIFO is mapped, and four bytes of data
                                        *   are read from the PCDR register at a time.                                */
        } PCDR_b;
    };

    union
    {
        __IOM uint32_t VCR;            /*!< (@ 0x00000014) Vertical Capture Register                                  */

        struct
        {
            __IOM uint32_t VST : 12;   /*!< [11..0] Vertical Capture Start Line PositionNumber of the line
                                        *   where capture is to start.                                                */
            uint32_t           : 4;
            __IOM uint32_t VSZ : 12;   /*!< [27..16] Vertical Capture Size Number of lines to be captured.            */
            uint32_t           : 4;
        } VCR_b;
    };

    union
    {
        __IOM uint32_t HCR;            /*!< (@ 0x00000018) Horizontal Capture Register                                */

        struct
        {
            __IOM uint32_t HST : 12;   /*!< [11..0] Horizontal Capture Start Byte Position Horizontal position
                                        *   in bytes where capture is to start.                                       */
            uint32_t           : 4;
            __IOM uint32_t HSZ : 12;   /*!< [27..16] Horizontal Capture Size Number of bytes to capture
                                        *   horizontally.                                                             */
            uint32_t : 4;
        } HCR_b;
    };
} R_PDC_Type;                          /*!< Size = 28 (0x1c)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_PORT0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports (R_PORT0)
 */

typedef struct                         /*!< (@ 0x40040000) R_PORT0 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t PCNTR1;        /*!< (@ 0x00000000) Port Control Register 1                                    */

            struct
            {
                __IOM uint32_t PDR  : 16; /*!< [15..0] Pmn Direction                                                     */
                __IOM uint32_t PODR : 16; /*!< [31..16] Pmn Output Data                                                  */
            } PCNTR1_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t PODR;           /*!< (@ 0x00000000) Output data register                                       */

                struct
                {
                    __IOM uint16_t PODR0  : 1; /*!< [0..0] Pmn Output Data                                                    */
                    __IOM uint16_t PODR1  : 1; /*!< [1..1] Pmn Output Data                                                    */
                    __IOM uint16_t PODR2  : 1; /*!< [2..2] Pmn Output Data                                                    */
                    __IOM uint16_t PODR3  : 1; /*!< [3..3] Pmn Output Data                                                    */
                    __IOM uint16_t PODR4  : 1; /*!< [4..4] Pmn Output Data                                                    */
                    __IOM uint16_t PODR5  : 1; /*!< [5..5] Pmn Output Data                                                    */
                    __IOM uint16_t PODR6  : 1; /*!< [6..6] Pmn Output Data                                                    */
                    __IOM uint16_t PODR7  : 1; /*!< [7..7] Pmn Output Data                                                    */
                    __IOM uint16_t PODR8  : 1; /*!< [8..8] Pmn Output Data                                                    */
                    __IOM uint16_t PODR9  : 1; /*!< [9..9] Pmn Output Data                                                    */
                    __IOM uint16_t PODR10 : 1; /*!< [10..10] Pmn Output Data                                                  */
                    __IOM uint16_t PODR11 : 1; /*!< [11..11] Pmn Output Data                                                  */
                    __IOM uint16_t PODR12 : 1; /*!< [12..12] Pmn Output Data                                                  */
                    __IOM uint16_t PODR13 : 1; /*!< [13..13] Pmn Output Data                                                  */
                    __IOM uint16_t PODR14 : 1; /*!< [14..14] Pmn Output Data                                                  */
                    __IOM uint16_t PODR15 : 1; /*!< [15..15] Pmn Output Data                                                  */
                } PODR_b;
            };

            union
            {
                __IOM uint16_t PDR;           /*!< (@ 0x00000002) Data direction register                                    */

                struct
                {
                    __IOM uint16_t PDR0  : 1; /*!< [0..0] Pmn Direction                                                      */
                    __IOM uint16_t PDR1  : 1; /*!< [1..1] Pmn Direction                                                      */
                    __IOM uint16_t PDR2  : 1; /*!< [2..2] Pmn Direction                                                      */
                    __IOM uint16_t PDR3  : 1; /*!< [3..3] Pmn Direction                                                      */
                    __IOM uint16_t PDR4  : 1; /*!< [4..4] Pmn Direction                                                      */
                    __IOM uint16_t PDR5  : 1; /*!< [5..5] Pmn Direction                                                      */
                    __IOM uint16_t PDR6  : 1; /*!< [6..6] Pmn Direction                                                      */
                    __IOM uint16_t PDR7  : 1; /*!< [7..7] Pmn Direction                                                      */
                    __IOM uint16_t PDR8  : 1; /*!< [8..8] Pmn Direction                                                      */
                    __IOM uint16_t PDR9  : 1; /*!< [9..9] Pmn Direction                                                      */
                    __IOM uint16_t PDR10 : 1; /*!< [10..10] Pmn Direction                                                    */
                    __IOM uint16_t PDR11 : 1; /*!< [11..11] Pmn Direction                                                    */
                    __IOM uint16_t PDR12 : 1; /*!< [12..12] Pmn Direction                                                    */
                    __IOM uint16_t PDR13 : 1; /*!< [13..13] Pmn Direction                                                    */
                    __IOM uint16_t PDR14 : 1; /*!< [14..14] Pmn Direction                                                    */
                    __IOM uint16_t PDR15 : 1; /*!< [15..15] Pmn Direction                                                    */
                } PDR_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint32_t PCNTR2;        /*!< (@ 0x00000004) Port Control Register 2                                    */

            struct
            {
                __IM uint32_t PIDR : 16; /*!< [15..0] Pmn Input Data                                                    */
                __IM uint32_t EIDR : 16; /*!< [31..16] Pmn Event Input Data                                             */
            } PCNTR2_b;
        };

        struct
        {
            union
            {
                __IM uint16_t EIDR;           /*!< (@ 0x00000004) Event input data register                                  */

                struct
                {
                    __IM uint16_t EIDR0  : 1; /*!< [0..0] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR1  : 1; /*!< [1..1] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR2  : 1; /*!< [2..2] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR3  : 1; /*!< [3..3] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR4  : 1; /*!< [4..4] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR5  : 1; /*!< [5..5] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR6  : 1; /*!< [6..6] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR7  : 1; /*!< [7..7] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR8  : 1; /*!< [8..8] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR9  : 1; /*!< [9..9] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR10 : 1; /*!< [10..10] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR11 : 1; /*!< [11..11] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR12 : 1; /*!< [12..12] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR13 : 1; /*!< [13..13] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR14 : 1; /*!< [14..14] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR15 : 1; /*!< [15..15] Pmn Event Input Data                                             */
                } EIDR_b;
            };

            union
            {
                __IM uint16_t PIDR;           /*!< (@ 0x00000006) Input data register                                        */

                struct
                {
                    __IM uint16_t PIDR0  : 1; /*!< [0..0] Pmn Input Data                                                     */
                    __IM uint16_t PIDR1  : 1; /*!< [1..1] Pmn Input Data                                                     */
                    __IM uint16_t PIDR2  : 1; /*!< [2..2] Pmn Input Data                                                     */
                    __IM uint16_t PIDR3  : 1; /*!< [3..3] Pmn Input Data                                                     */
                    __IM uint16_t PIDR4  : 1; /*!< [4..4] Pmn Input Data                                                     */
                    __IM uint16_t PIDR5  : 1; /*!< [5..5] Pmn Input Data                                                     */
                    __IM uint16_t PIDR6  : 1; /*!< [6..6] Pmn Input Data                                                     */
                    __IM uint16_t PIDR7  : 1; /*!< [7..7] Pmn Input Data                                                     */
                    __IM uint16_t PIDR8  : 1; /*!< [8..8] Pmn Input Data                                                     */
                    __IM uint16_t PIDR9  : 1; /*!< [9..9] Pmn Input Data                                                     */
                    __IM uint16_t PIDR10 : 1; /*!< [10..10] Pmn Input Data                                                   */
                    __IM uint16_t PIDR11 : 1; /*!< [11..11] Pmn Input Data                                                   */
                    __IM uint16_t PIDR12 : 1; /*!< [12..12] Pmn Input Data                                                   */
                    __IM uint16_t PIDR13 : 1; /*!< [13..13] Pmn Input Data                                                   */
                    __IM uint16_t PIDR14 : 1; /*!< [14..14] Pmn Input Data                                                   */
                    __IM uint16_t PIDR15 : 1; /*!< [15..15] Pmn Input Data                                                   */
                } PIDR_b;
            };
        };
    };

    union
    {
        union
        {
            __OM uint32_t PCNTR3;        /*!< (@ 0x00000008) Port Control Register 3                                    */

            struct
            {
                __OM uint32_t POSR : 16; /*!< [15..0] Pmn Output Set                                                    */
                __OM uint32_t PORR : 16; /*!< [31..16] Pmn Output Reset                                                 */
            } PCNTR3_b;
        };

        struct
        {
            union
            {
                __OM uint16_t PORR;           /*!< (@ 0x00000008) Output set register                                        */

                struct
                {
                    __OM uint16_t PORR0  : 1; /*!< [0..0] Pmn Output Reset                                                   */
                    __OM uint16_t PORR1  : 1; /*!< [1..1] Pmn Output Reset                                                   */
                    __OM uint16_t PORR2  : 1; /*!< [2..2] Pmn Output Reset                                                   */
                    __OM uint16_t PORR3  : 1; /*!< [3..3] Pmn Output Reset                                                   */
                    __OM uint16_t PORR4  : 1; /*!< [4..4] Pmn Output Reset                                                   */
                    __OM uint16_t PORR5  : 1; /*!< [5..5] Pmn Output Reset                                                   */
                    __OM uint16_t PORR6  : 1; /*!< [6..6] Pmn Output Reset                                                   */
                    __OM uint16_t PORR7  : 1; /*!< [7..7] Pmn Output Reset                                                   */
                    __OM uint16_t PORR8  : 1; /*!< [8..8] Pmn Output Reset                                                   */
                    __OM uint16_t PORR9  : 1; /*!< [9..9] Pmn Output Reset                                                   */
                    __OM uint16_t PORR10 : 1; /*!< [10..10] Pmn Output Reset                                                 */
                    __OM uint16_t PORR11 : 1; /*!< [11..11] Pmn Output Reset                                                 */
                    __OM uint16_t PORR12 : 1; /*!< [12..12] Pmn Output Reset                                                 */
                    __OM uint16_t PORR13 : 1; /*!< [13..13] Pmn Output Reset                                                 */
                    __OM uint16_t PORR14 : 1; /*!< [14..14] Pmn Output Reset                                                 */
                    __OM uint16_t PORR15 : 1; /*!< [15..15] Pmn Output Reset                                                 */
                } PORR_b;
            };

            union
            {
                __OM uint16_t POSR;           /*!< (@ 0x0000000A) Output reset register                                      */

                struct
                {
                    __OM uint16_t POSR0  : 1; /*!< [0..0] Pmn Output Set                                                     */
                    __OM uint16_t POSR1  : 1; /*!< [1..1] Pmn Output Set                                                     */
                    __OM uint16_t POSR2  : 1; /*!< [2..2] Pmn Output Set                                                     */
                    __OM uint16_t POSR3  : 1; /*!< [3..3] Pmn Output Set                                                     */
                    __OM uint16_t POSR4  : 1; /*!< [4..4] Pmn Output Set                                                     */
                    __OM uint16_t POSR5  : 1; /*!< [5..5] Pmn Output Set                                                     */
                    __OM uint16_t POSR6  : 1; /*!< [6..6] Pmn Output Set                                                     */
                    __OM uint16_t POSR7  : 1; /*!< [7..7] Pmn Output Set                                                     */
                    __OM uint16_t POSR8  : 1; /*!< [8..8] Pmn Output Set                                                     */
                    __OM uint16_t POSR9  : 1; /*!< [9..9] Pmn Output Set                                                     */
                    __OM uint16_t POSR10 : 1; /*!< [10..10] Pmn Output Set                                                   */
                    __OM uint16_t POSR11 : 1; /*!< [11..11] Pmn Output Set                                                   */
                    __OM uint16_t POSR12 : 1; /*!< [12..12] Pmn Output Set                                                   */
                    __OM uint16_t POSR13 : 1; /*!< [13..13] Pmn Output Set                                                   */
                    __OM uint16_t POSR14 : 1; /*!< [14..14] Pmn Output Set                                                   */
                    __OM uint16_t POSR15 : 1; /*!< [15..15] Pmn Output Set                                                   */
                } POSR_b;
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t PCNTR4;        /*!< (@ 0x0000000C) Port Control Register 4                                    */

            struct
            {
                __IOM uint32_t EOSR : 16; /*!< [15..0] Pmn Event Output Set                                              */
                __IOM uint32_t EORR : 16; /*!< [31..16] Pmn Event Output Reset                                           */
            } PCNTR4_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t EORR;           /*!< (@ 0x0000000C) Event output set register                                  */

                struct
                {
                    __IOM uint16_t EORR0  : 1; /*!< [0..0] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR1  : 1; /*!< [1..1] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR2  : 1; /*!< [2..2] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR3  : 1; /*!< [3..3] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR4  : 1; /*!< [4..4] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR5  : 1; /*!< [5..5] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR6  : 1; /*!< [6..6] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR7  : 1; /*!< [7..7] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR8  : 1; /*!< [8..8] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR9  : 1; /*!< [9..9] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR10 : 1; /*!< [10..10] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR11 : 1; /*!< [11..11] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR12 : 1; /*!< [12..12] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR13 : 1; /*!< [13..13] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR14 : 1; /*!< [14..14] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR15 : 1; /*!< [15..15] Pmn Event Output Reset                                           */
                } EORR_b;
            };

            union
            {
                __IOM uint16_t EOSR;           /*!< (@ 0x0000000E) Event output reset register                                */

                struct
                {
                    __IOM uint16_t EOSR0  : 1; /*!< [0..0] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR1  : 1; /*!< [1..1] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR2  : 1; /*!< [2..2] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR3  : 1; /*!< [3..3] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR4  : 1; /*!< [4..4] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR5  : 1; /*!< [5..5] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR6  : 1; /*!< [6..6] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR7  : 1; /*!< [7..7] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR8  : 1; /*!< [8..8] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR9  : 1; /*!< [9..9] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR10 : 1; /*!< [10..10] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR11 : 1; /*!< [11..11] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR12 : 1; /*!< [12..12] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR13 : 1; /*!< [13..13] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR14 : 1; /*!< [14..14] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR15 : 1; /*!< [15..15] Pmn Event Output Set                                             */
                } EOSR_b;
            };
        };
    };
} R_PORT0_Type;                        /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_PFS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-PFS (R_PFS)
 */

typedef struct                         /*!< (@ 0x40040800) R_PFS Structure                                            */
{
    __IOM R_PFS_PORT_Type PORT[12];    /*!< (@ 0x00000000) Port [0..11]                                               */
} R_PFS_Type;                          /*!< Size = 768 (0x300)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PMISC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-MISC (R_PMISC)
 */

typedef struct                         /*!< (@ 0x40040D00) R_PMISC Structure                                          */
{
    union
    {
        __IOM uint8_t PFENET;          /*!< (@ 0x00000000) Ethernet Control Register                                  */

        struct
        {
            uint8_t                : 4;
            __IOM uint8_t PHYMODE0 : 1; /*!< [4..4] Ethernet Mode Setting ch0                                          */
            __IOM uint8_t PHYMODE1 : 1; /*!< [5..5] Ethernet Mode Setting ch1                                          */
            uint8_t                : 2;
        } PFENET_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t PWPR;            /*!< (@ 0x00000003) Write-Protect Register                                     */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;   /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;   /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t PWPRS;           /*!< (@ 0x00000005) Write-Protect Register for Secure                          */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;   /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;   /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPRS_b;
    };
    __IM uint16_t            RESERVED2[5];
    __IOM R_PMISC_PMSAR_Type PMSAR[9]; /*!< (@ 0x00000010) Port Security Attribution Register                         */
} R_PMISC_Type;                        /*!< Size = 34 (0x22)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_QSPI                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Quad Serial Peripheral Interface (R_QSPI)
 */

typedef struct                         /*!< (@ 0x64000000) R_QSPI Structure                                           */
{
    union
    {
        __IOM uint32_t SFMSMD;         /*!< (@ 0x00000000) Transfer Mode Control Register                             */

        struct
        {
            __IOM uint32_t SFMRM  : 3; /*!< [2..0] Serial interface read mode selection                               */
            uint32_t              : 1;
            __IOM uint32_t SFMSE  : 2; /*!< [5..4] Selection of the prefetch function                                 */
            __IOM uint32_t SFMPFE : 1; /*!< [6..6] Selection of the prefetch function                                 */
            __IOM uint32_t SFMPAE : 1; /*!< [7..7] Selection of the function for stopping prefetch at locations
                                        *   other than on byte boundaries                                             */
            __IOM uint32_t SFMMD3 : 1; /*!< [8..8] SPI mode selection. An initial value is determined by
                                        *   input to CFGMD3.                                                          */
            __IOM uint32_t SFMOEX : 1; /*!< [9..9] Extension of the I/O buffer output enable signal for
                                        *   the serial interface                                                      */
            __IOM uint32_t SFMOHW : 1; /*!< [10..10] Hold time adjustment for serial transmission                     */
            __IOM uint32_t SFMOSW : 1; /*!< [11..11] Setup time adjustment for serial transmission                    */
            uint32_t              : 3;
            __IOM uint32_t SFMCCE : 1; /*!< [15..15] Read instruction code selection.                                 */
            uint32_t              : 16;
        } SFMSMD_b;
    };

    union
    {
        __IOM uint32_t SFMSSC;         /*!< (@ 0x00000004) Chip Selection Control Register                            */

        struct
        {
            __IOM uint32_t SFMSW  : 4; /*!< [3..0] Selection of a minimum high-level width of the QSSL signal         */
            __IOM uint32_t SFMSHD : 1; /*!< [4..4] QSSL signal release timing selection                               */
            __IOM uint32_t SFMSLD : 1; /*!< [5..5] QSSL signal output timing selection                                */
            uint32_t              : 26;
        } SFMSSC_b;
    };

    union
    {
        __IOM uint32_t SFMSKC;         /*!< (@ 0x00000008) Clock Control Register                                     */

        struct
        {
            __IOM uint32_t SFMDV : 5;  /*!< [4..0] Serial interface reference cycle selection (* Pay attention
                                        *   to the irregularity.)NOTE: When PCLKA multiplied by an
                                        *   odd number is selected, the high-level width of the SCK
                                        *   signal is longer than the low-level width by 1 x PCLKA
                                        *   before duty ratio correction.                                             */
            __IOM uint32_t SFMDTY : 1; /*!< [5..5] Selection of a duty ratio correction function for the
                                        *   SCK signal                                                                */
            uint32_t : 26;
        } SFMSKC_b;
    };

    union
    {
        __IM uint32_t SFMSST;          /*!< (@ 0x0000000C) Status Register                                            */

        struct
        {
            __IM uint32_t PFCNT : 5;   /*!< [4..0] Number of bytes of prefetched dataRange: 00000 - 10010
                                        *   (No combination other than the above is available.)                       */
            uint32_t            : 1;
            __IM uint32_t PFFUL : 1;   /*!< [6..6] Prefetch buffer state                                              */
            __IM uint32_t PFOFF : 1;   /*!< [7..7] Prefetch function operation state                                  */
            uint32_t            : 24;
        } SFMSST_b;
    };

    union
    {
        __IOM uint32_t SFMCOM;         /*!< (@ 0x00000010) Communication Port Register                                */

        struct
        {
            __IOM uint32_t SFMD : 8;   /*!< [7..0] Port for direct communication with the SPI bus.Input/output
                                        *   to and from this port is converted to a SPIbus cycle. This
                                        *   port is accessible in the direct communication mode (DCOM=1)
                                        *   only.Access to this port is ignored in the ROM access mode.               */
            uint32_t : 24;
        } SFMCOM_b;
    };

    union
    {
        __IOM uint32_t SFMCMD;         /*!< (@ 0x00000014) Communication Mode Control Register                        */

        struct
        {
            __IOM uint32_t DCOM : 1;   /*!< [0..0] Selection of a mode of communication with the SPI bus              */
            uint32_t            : 31;
        } SFMCMD_b;
    };

    union
    {
        __IOM uint32_t SFMCST;         /*!< (@ 0x00000018) Communication Status Register                              */

        struct
        {
            __IM uint32_t COMBSY : 1;  /*!< [0..0] SPI bus cycle completion state in direct communication             */
            uint32_t             : 6;
            __IM uint32_t EROMR  : 1;  /*!< [7..7] Status of ROM access detection in the direct communication
                                        *   modeNOTE: Writing of 0 only is possible. Writing of 1 is
                                        *   ignored.                                                                  */
            uint32_t : 24;
        } SFMCST_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t SFMSIC;         /*!< (@ 0x00000020) Instruction Code Register                                  */

        struct
        {
            __IOM uint32_t SFMCIC : 8; /*!< [7..0] Serial ROM instruction code to substitute                          */
            uint32_t              : 24;
        } SFMSIC_b;
    };

    union
    {
        __IOM uint32_t SFMSAC;         /*!< (@ 0x00000024) Address Mode Control Register                              */

        struct
        {
            __IOM uint32_t SFMAS  : 2; /*!< [1..0] Selection the number of address bits of the serial interface       */
            uint32_t              : 2;
            __IOM uint32_t SFM4BC : 1; /*!< [4..4] Selection of a default instruction code, when Serial
                                        *   Interface address width is selected 4 bytes.                              */
            uint32_t : 27;
        } SFMSAC_b;
    };

    union
    {
        __IOM uint32_t SFMSDC;         /*!< (@ 0x00000028) Dummy Cycle Control Register                               */

        struct
        {
            __IOM uint32_t SFMDN : 4;  /*!< [3..0] Selection of the number of dummy cycles of Fast Read
                                        *   instructions                                                              */
            uint32_t              : 2;
            __IM uint32_t  SFMXST : 1; /*!< [6..6] XIP mode status                                                    */
            __IOM uint32_t SFMXEN : 1; /*!< [7..7] XIP mode permission                                                */
            __IOM uint32_t SFMXD  : 8; /*!< [15..8] Mode data for serial ROM. (Control XIP mode)                      */
            uint32_t              : 16;
        } SFMSDC_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t SFMSPC;         /*!< (@ 0x00000030) SPI Protocol Control Register                              */

        struct
        {
            __IOM uint32_t SFMSPI : 2; /*!< [1..0] Selection of SPI protocolNOTE: Serial ROM's SPI protocol
                                        *   is required to be set by software separately.                             */
            uint32_t              : 2;
            __IOM uint32_t SFMSDE : 1; /*!< [4..4] Selection of the minimum time of input output switch,
                                        *   when Dual SPI protocol or Quad SPI protocol is selected.                  */
            uint32_t : 27;
        } SFMSPC_b;
    };

    union
    {
        __IOM uint32_t SFMPMD;         /*!< (@ 0x00000034) Port Control Register                                      */

        struct
        {
            uint32_t              : 2;
            __IOM uint32_t SFMWPL : 1; /*!< [2..2] Specify level of WP pin                                            */
            uint32_t              : 29;
        } SFMPMD_b;
    };
    __IM uint32_t RESERVED2[499];

    union
    {
        __IOM uint32_t SFMCNT1;        /*!< (@ 0x00000804) External QSPI Address Register 1                           */

        struct
        {
            uint32_t                : 26;
            __IOM uint32_t QSPI_EXT : 6; /*!< [31..26] BANK Switching AddressWhen accessing from 0x6000_0000
                                          *   to 0x63FF_FFFF, Addres bus is Set QSPI_EXT[5:0] to high-order
                                          *   6bits of SHADDR[31:0]NOTE: Setting 6'h3F is prihibited.                   */
        } SFMCNT1_b;
    };
} R_QSPI_Type;                           /*!< Size = 2056 (0x808)                                                       */

/* =========================================================================================================================== */
/* ================                                           R_RTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Realtime Clock (R_RTC)
 */

typedef struct                         /*!< (@ 0x40044000) R_RTC Structure                                            */
{
    union
    {
        __IM uint8_t R64CNT;           /*!< (@ 0x00000000) 64-Hz Counter                                              */

        struct
        {
            __IM uint8_t F64HZ : 1;    /*!< [0..0] 64Hz                                                               */
            __IM uint8_t F32HZ : 1;    /*!< [1..1] 32Hz                                                               */
            __IM uint8_t F16HZ : 1;    /*!< [2..2] 16Hz                                                               */
            __IM uint8_t F8HZ  : 1;    /*!< [3..3] 8Hz                                                                */
            __IM uint8_t F4HZ  : 1;    /*!< [4..4] 4Hz                                                                */
            __IM uint8_t F2HZ  : 1;    /*!< [5..5] 2Hz                                                                */
            __IM uint8_t F1HZ  : 1;    /*!< [6..6] 1Hz                                                                */
            uint8_t            : 1;
        } R64CNT_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        union
        {
            __IOM uint8_t RSECCNT;       /*!< (@ 0x00000002) Second Counter                                             */

            struct
            {
                __IOM uint8_t SEC1 : 4;  /*!< [3..0] 1-Second Count Counts from 0 to 9 every second. When
                                          *   a carry is generated, 1 is added to the tens place.                       */
                __IOM uint8_t SEC10 : 3; /*!< [6..4] 10-Second Count Counts from 0 to 5 for 60-second counting.         */
                uint8_t             : 1;
            } RSECCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT0;         /*!< (@ 0x00000002) Binary Counter 0                                           */

            struct
            {
                __IOM uint8_t BCNT0 : 8; /*!< [7..0] The BCNT0 counter is a readable/writable 32-bit binary
                                          *   counter b7 to b0.                                                         */
            } BCNT0_b;
        };
    };
    __IM uint8_t RESERVED1;

    union
    {
        union
        {
            __IOM uint8_t RMINCNT;       /*!< (@ 0x00000004) Minute Counter                                             */

            struct
            {
                __IOM uint8_t MIN1 : 4;  /*!< [3..0] 1-Minute Count Counts from 0 to 9 every minute. When
                                          *   a carry is generated, 1 is added to the tens place.                       */
                __IOM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Count Counts from 0 to 5 for 60-minute counting.         */
                uint8_t             : 1;
            } RMINCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT1;         /*!< (@ 0x00000004) Binary Counter 1                                           */

            struct
            {
                __IOM uint8_t BCNT1 : 8; /*!< [7..0] The BCNT1 counter is a readable/writable 32-bit binary
                                          *   counter b15 to b8.                                                        */
            } BCNT1_b;
        };
    };
    __IM uint8_t RESERVED2;

    union
    {
        union
        {
            __IOM uint8_t RHRCNT;       /*!< (@ 0x00000006) Hour Counter                                               */

            struct
            {
                __IOM uint8_t HR1 : 4;  /*!< [3..0] 1-Hour Count Counts from 0 to 9 once per hour. When a
                                         *   carry is generated, 1 is added to the tens place.                         */
                __IOM uint8_t HR10 : 2; /*!< [5..4] 10-Hour Count Counts from 0 to 2 once per carry from
                                         *   the ones place.                                                           */
                __IOM uint8_t PM : 1;   /*!< [6..6] Time Counter Setting for a.m./p.m.                                 */
                uint8_t          : 1;
            } RHRCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT2;         /*!< (@ 0x00000006) Binary Counter 2                                           */

            struct
            {
                __IOM uint8_t BCNT2 : 8; /*!< [7..0] The BCNT2 counter is a readable/writable 32-bit binary
                                          *   counter b23 to b16.                                                       */
            } BCNT2_b;
        };
    };
    __IM uint8_t RESERVED3;

    union
    {
        union
        {
            __IOM uint8_t RWKCNT;       /*!< (@ 0x00000008) Day-of-Week Counter                                        */

            struct
            {
                __IOM uint8_t DAYW : 3; /*!< [2..0] Day-of-Week Counting                                               */
                uint8_t            : 5;
            } RWKCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT3;         /*!< (@ 0x00000008) Binary Counter 3                                           */

            struct
            {
                __IOM uint8_t BCNT3 : 8; /*!< [7..0] The BCNT3 counter is a readable/writable 32-bit binary
                                          *   counter b31 to b24.                                                       */
            } BCNT3_b;
        };
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint8_t RDAYCNT;         /*!< (@ 0x0000000A) Day Counter                                                */

        struct
        {
            __IOM uint8_t DATE1 : 4;   /*!< [3..0] 1-Day Count Counts from 0 to 9 once per day. When a carry
                                        *   is generated, 1 is added to the tens place.                               */
            __IOM uint8_t DATE10 : 2;  /*!< [5..4] 10-Day Count Counts from 0 to 3 once per carry from the
                                        *   ones place.                                                               */
            uint8_t : 2;
        } RDAYCNT_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IOM uint8_t RMONCNT;         /*!< (@ 0x0000000C) Month Counter                                              */

        struct
        {
            __IOM uint8_t MON1 : 4;    /*!< [3..0] 1-Month Count Counts from 0 to 9 once per month. When
                                        *   a carry is generated, 1 is added to the tens place.                       */
            __IOM uint8_t MON10 : 1;   /*!< [4..4] 10-Month Count Counts from 0 to 1 once per carry from
                                        *   the ones place.                                                           */
            uint8_t : 3;
        } RMONCNT_b;
    };
    __IM uint8_t RESERVED6;

    union
    {
        __IOM uint16_t RYRCNT;         /*!< (@ 0x0000000E) Year Counter                                               */

        struct
        {
            __IOM uint16_t YR1 : 4;    /*!< [3..0] 1-Year Count Counts from 0 to 9 once per year. When a
                                        *   carry is generated, 1 is added to the tens place.                         */
            __IOM uint16_t YR10 : 4;   /*!< [7..4] 10-Year Count Counts from 0 to 9 once per carry from
                                        *   ones place. When a carry is generated in the tens place,
                                        *   1 is added to the hundreds place.                                         */
            uint16_t : 8;
        } RYRCNT_b;
    };

    union
    {
        union
        {
            __IOM uint8_t RSECAR;        /*!< (@ 0x00000010) Second Alarm Register                                      */

            struct
            {
                __OM uint8_t  SEC1  : 4; /*!< [3..0] 1-Second Value for the ones place of seconds                       */
                __IOM uint8_t SEC10 : 3; /*!< [6..4] 10-Seconds Value for the tens place of seconds                     */
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RSECAR_b;
        };

        union
        {
            __IOM uint8_t BCNT0AR;         /*!< (@ 0x00000010) Binary Counter 0 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT0AR : 8; /*!< [7..0] he BCNT0AR counter is a readable/writable alarm register
                                            *   corresponding to 32-bit binary counter b7 to b0.                          */
            } BCNT0AR_b;
        };
    };
    __IM uint8_t RESERVED7;

    union
    {
        union
        {
            __IOM uint8_t RMINAR;        /*!< (@ 0x00000012) Minute Alarm Register                                      */

            struct
            {
                __IOM uint8_t MIN1  : 4; /*!< [3..0] 1-Minute Count Value for the ones place of minutes                 */
                __IOM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Count Value for the tens place of minutes                */
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RMINAR_b;
        };

        union
        {
            __IOM uint8_t BCNT1AR;         /*!< (@ 0x00000012) Binary Counter 1 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT1AR : 8; /*!< [7..0] he BCNT1AR counter is a readable/writable alarm register
                                            *   corresponding to 32-bit binary counter b15 to b8.                         */
            } BCNT1AR_b;
        };
    };
    __IM uint8_t RESERVED8;

    union
    {
        union
        {
            __IOM uint8_t RHRAR;        /*!< (@ 0x00000014) Hour Alarm Register                                        */

            struct
            {
                __IOM uint8_t HR1  : 4; /*!< [3..0] 1-Hour Count Value for the ones place of hours                     */
                __IOM uint8_t HR10 : 2; /*!< [5..4] 10-Hour Count Value for the tens place of hours                    */
                __IOM uint8_t PM   : 1; /*!< [6..6] Time Counter Setting for a.m./p.m.                                 */
                __IOM uint8_t ENB  : 1; /*!< [7..7] Compare enable                                                     */
            } RHRAR_b;
        };

        union
        {
            __IOM uint8_t BCNT2AR;         /*!< (@ 0x00000014) Binary Counter 2 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT2AR : 8; /*!< [7..0] The BCNT2AR counter is a readable/writable 32-bit binary
                                            *   counter b23 to b16.                                                       */
            } BCNT2AR_b;
        };
    };
    __IM uint8_t RESERVED9;

    union
    {
        union
        {
            __IOM uint8_t RWKAR;        /*!< (@ 0x00000016) Day-of-Week Alarm Register                                 */

            struct
            {
                __IOM uint8_t DAYW : 3; /*!< [2..0] Day-of-Week Counting                                               */
                uint8_t            : 4;
                __IOM uint8_t ENB  : 1; /*!< [7..7] Compare enable                                                     */
            } RWKAR_b;
        };

        union
        {
            __IOM uint8_t BCNT3AR;         /*!< (@ 0x00000016) Binary Counter 3 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT3AR : 8; /*!< [7..0] The BCNT3AR counter is a readable/writable 32-bit binary
                                            *   counter b31 to b24.                                                       */
            } BCNT3AR_b;
        };
    };
    __IM uint8_t RESERVED10;

    union
    {
        union
        {
            __IOM uint8_t RDAYAR;         /*!< (@ 0x00000018) Date Alarm Register                                        */

            struct
            {
                __IOM uint8_t DATE1  : 4; /*!< [3..0] 1 Day Value for the ones place of days                             */
                __IOM uint8_t DATE10 : 2; /*!< [5..4] 10 Days Value for the tens place of days                           */
                uint8_t              : 1;
                __IOM uint8_t ENB    : 1; /*!< [7..7] Compare enable                                                     */
            } RDAYAR_b;
        };

        union
        {
            __IOM uint8_t BCNT0AER;    /*!< (@ 0x00000018) Binary Counter 0 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT0AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b7 to b0.                                                         */
            } BCNT0AER_b;
        };
    };
    __IM uint8_t RESERVED11;

    union
    {
        union
        {
            __IOM uint8_t RMONAR;        /*!< (@ 0x0000001A) Month Alarm Register                                       */

            struct
            {
                __IOM uint8_t MON1  : 4; /*!< [3..0] 1 Month Value for the ones place of months                         */
                __IOM uint8_t MON10 : 1; /*!< [4..4] 10 Months Value for the tens place of months                       */
                uint8_t             : 2;
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RMONAR_b;
        };

        union
        {
            __IOM uint8_t BCNT1AER;    /*!< (@ 0x0000001A) Binary Counter 1 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT1AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b15 to b8.                                                        */
            } BCNT1AER_b;
        };
    };
    __IM uint8_t RESERVED12;

    union
    {
        union
        {
            __IOM uint16_t RYRAR;        /*!< (@ 0x0000001C) Year Alarm Register                                        */

            struct
            {
                __IOM uint16_t YR1  : 4; /*!< [3..0] 1 Year Value for the ones place of years                           */
                __IOM uint16_t YR10 : 4; /*!< [7..4] 10 Years Value for the tens place of years                         */
                uint16_t            : 8;
            } RYRAR_b;
        };

        union
        {
            __IOM uint16_t BCNT2AER;    /*!< (@ 0x0000001C) Binary Counter 2 Alarm Enable Register                     */

            struct
            {
                __IOM uint16_t ENB : 8; /*!< [7..0] The BCNT2AER register is a readable/writable register
                                         *   for setting the alarm enable corresponding to 32-bit binary
                                         *   counter b23 to b16.                                                       */
                uint16_t : 8;
            } BCNT2AER_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t RYRAREN;     /*!< (@ 0x0000001E) Year Alarm Enable Register                                 */

            struct
            {
                uint8_t           : 7;
                __IOM uint8_t ENB : 1; /*!< [7..7] Compare enable                                                     */
            } RYRAREN_b;
        };

        union
        {
            __IOM uint8_t BCNT3AER;    /*!< (@ 0x0000001E) Binary Counter 3 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT3AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b31 to b24.                                                       */
            } BCNT3AER_b;
        };
    };
    __IM uint8_t  RESERVED13;
    __IM uint16_t RESERVED14;

    union
    {
        __IOM uint8_t RCR1;            /*!< (@ 0x00000022) RTC Control Register 1                                     */

        struct
        {
            __IOM uint8_t AIE   : 1;   /*!< [0..0] Alarm Interrupt Enable                                             */
            __IOM uint8_t CIE   : 1;   /*!< [1..1] Carry Interrupt Enable                                             */
            __IOM uint8_t PIE   : 1;   /*!< [2..2] Periodic Interrupt Enable                                          */
            __IOM uint8_t RTCOS : 1;   /*!< [3..3] RTCOUT Output Select                                               */
            __IOM uint8_t PES   : 4;   /*!< [7..4] Periodic Interrupt Select                                          */
        } RCR1_b;
    };
    __IM uint8_t RESERVED15;

    union
    {
        __IOM uint8_t RCR2;            /*!< (@ 0x00000024) RTC Control Register 2                                     */

        struct
        {
            __IOM uint8_t START : 1;   /*!< [0..0] Start                                                              */
            __IOM uint8_t RESET : 1;   /*!< [1..1] RTC Software Reset                                                 */
            __IOM uint8_t ADJ30 : 1;   /*!< [2..2] 30-Second Adjustment                                               */
            __IOM uint8_t RTCOE : 1;   /*!< [3..3] RTCOUT Output Enable                                               */
            __IOM uint8_t AADJE : 1;   /*!< [4..4] Automatic Adjustment Enable (When the LOCO clock is selected,
                                        *   the setting of this bit is disabled.)                                     */
            __IOM uint8_t AADJP : 1;   /*!< [5..5] Automatic Adjustment Period Select (When the LOCO clock
                                        *   is selected, the setting of this bit is disabled.)                        */
            __IOM uint8_t HR24  : 1;   /*!< [6..6] Hours Mode                                                         */
            __IOM uint8_t CNTMD : 1;   /*!< [7..7] Count Mode Select                                                  */
        } RCR2_b;
    };
    __IM uint8_t  RESERVED16;
    __IM uint16_t RESERVED17;

    union
    {
        __IOM uint8_t RCR4;            /*!< (@ 0x00000028) RTC Control Register 4                                     */

        struct
        {
            __IOM uint8_t RCKSEL : 1;  /*!< [0..0] Count Source Select                                                */
            uint8_t              : 6;
            __IOM uint8_t ROPSEL : 1;  /*!< [7..7] RTC Operation Mode Select                                          */
        } RCR4_b;
    };
    __IM uint8_t RESERVED18;

    union
    {
        __IOM uint16_t RFRH;           /*!< (@ 0x0000002A) Frequency Register H                                       */

        struct
        {
            __IOM uint16_t RFC16 : 1;  /*!< [0..0] Frequency Comparison Value (b16) To generate the operating
                                        *   clock from the LOCOclock, this bit sets the comparison
                                        *   value of the 128-Hz clock cycle.                                          */
            uint16_t : 15;
        } RFRH_b;
    };

    union
    {
        __IOM uint16_t RFRL;           /*!< (@ 0x0000002C) Frequency Register L                                       */

        struct
        {
            __IOM uint16_t RFC : 16;   /*!< [15..0] Frequency Comparison Value(b15-b0) To generate the operating
                                        *   clock from the main clock, this bit sets the comparison
                                        *   value of the 128-Hz clock cycle.                                          */
        } RFRL_b;
    };

    union
    {
        __IOM uint8_t RADJ;            /*!< (@ 0x0000002E) Time Error Adjustment Register                             */

        struct
        {
            __IOM uint8_t ADJ : 6;     /*!< [5..0] Adjustment Value These bits specify the adjustment value
                                        *   from the prescaler.                                                       */
            __IOM uint8_t PMADJ : 2;   /*!< [7..6] Plus-Minus                                                         */
        } RADJ_b;
    };
    __IM uint8_t           RESERVED19;
    __IM uint16_t          RESERVED20[8];
    __IOM R_RTC_RTCCR_Type RTCCR[3];   /*!< (@ 0x00000040) Time Capture Control Register                              */
    __IM uint16_t          RESERVED21[5];
    __IOM R_RTC_CP_Type    CP[3];      /*!< (@ 0x00000050) Capture registers                                          */
} R_RTC_Type;                          /*!< Size = 128 (0x80)                                                         */

/* =========================================================================================================================== */
/* ================                                          R_SCI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Communications Interface (R_SCI0)
 */

typedef struct                         /*!< (@ 0x40070000) R_SCI0 Structure                                           */
{
    union
    {
        union
        {
            __IOM uint8_t SMR;          /*!< (@ 0x00000000) Serial Mode Register (SCMR.SMIF = 0)                       */

            struct
            {
                __IOM uint8_t CKS  : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t MP   : 1; /*!< [2..2] Multi-Processor Mode(Valid only in asynchronous mode)              */
                __IOM uint8_t STOP : 1; /*!< [3..3] Stop Bit Length(Valid only in asynchronous mode)                   */
                __IOM uint8_t PM   : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE   : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t CHR  : 1; /*!< [6..6] Character Length(Valid only in asynchronous mode)                  */
                __IOM uint8_t CM   : 1; /*!< [7..7] Communication Mode                                                 */
            } SMR_b;
        };

        union
        {
            __IOM uint8_t SMR_SMCI;    /*!< (@ 0x00000000) Serial mode register (SCMR.SMIF = 1)                       */

            struct
            {
                __IOM uint8_t CKS : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t BCP : 2; /*!< [3..2] Base Clock Pulse(Valid only in asynchronous mode)                  */
                __IOM uint8_t PM  : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE  : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t BLK : 1; /*!< [6..6] Block Transfer Mode                                                */
                __IOM uint8_t GM  : 1; /*!< [7..7] GSM Mode                                                           */
            } SMR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t BRR;             /*!< (@ 0x00000001) Bit Rate Register                                          */

        struct
        {
            __IOM uint8_t BRR : 8;     /*!< [7..0] BRR is an 8-bit register that adjusts the bit rate.                */
        } BRR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SCR;          /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF = 0)                    */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable(Valid in asynchronous
                                         *   mode when SMR.MP = 1)                                                     */
                __IOM uint8_t RE  : 1;  /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE  : 1;  /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE : 1;  /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE : 1;  /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_b;
        };

        union
        {
            __IOM uint8_t SCR_SMCI;     /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF =1)                     */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable                                   */
                __IOM uint8_t RE   : 1; /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE   : 1; /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE  : 1; /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE  : 1; /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t TDR;             /*!< (@ 0x00000003) Transmit Data Register                                     */

        struct
        {
            __IOM uint8_t TDR : 8;     /*!< [7..0] TDR is an 8-bit register that stores transmit data.                */
        } TDR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SSR;          /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=0)         */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit Transfer                                       */
                __IM uint8_t  MPB  : 1; /*!< [1..1] Multi-Processor                                                    */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_b;
        };

        union
        {
            __IOM uint8_t SSR_FIFO;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=1)         */

            struct
            {
                __IOM uint8_t DR : 1;   /*!< [0..0] Receive Data Ready flag(Valid only in asynchronous mode(including
                                         *   multi-processor) and FIFO selected)                                       */
                uint8_t            : 1;
                __IOM uint8_t TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDF  : 1; /*!< [6..6] Receive FIFO data full flag                                        */
                __IOM uint8_t TDFE : 1; /*!< [7..7] Transmit FIFO data empty flag                                      */
            } SSR_FIFO_b;
        };

        union
        {
            __IOM uint8_t SSR_SMCI;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 1)                      */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit TransferThis bit should be 0 in smart
                                         *   card interface mode.                                                      */
                __IM uint8_t MPB : 1;   /*!< [1..1] Multi-ProcessorThis bit should be 0 in smart card interface
                                         *   mode.                                                                     */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t ERS  : 1; /*!< [4..4] Error Signal Status Flag                                           */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_SMCI_b;
        };
    };

    union
    {
        __IM uint8_t RDR;              /*!< (@ 0x00000005) Receive Data Register                                      */

        struct
        {
            __IM uint8_t RDR : 8;      /*!< [7..0] RDR is an 8-bit register that stores receive data.                 */
        } RDR_b;
    };

    union
    {
        __IOM uint8_t SCMR;            /*!< (@ 0x00000006) Smart Card Mode Register                                   */

        struct
        {
            __IOM uint8_t SMIF : 1;    /*!< [0..0] Smart Card Interface Mode Select                                   */
            uint8_t            : 1;
            __IOM uint8_t SINV : 1;    /*!< [2..2] Transmitted/Received Data InvertSet this bit to 0 if
                                        *   operation is to be in simple I2C mode.                                    */
            __IOM uint8_t SDIR : 1;    /*!< [3..3] Transmitted/Received Data Transfer DirectionNOTE: The
                                        *   setting is invalid and a fixed data length of 8 bits is
                                        *   used in modes other than asynchronous mode.Set this bit
                                        *   to 1 if operation is to be in simple I2C mode.                            */
            __IOM uint8_t CHR1 : 1;    /*!< [4..4] Character Length 1(Only valid in asynchronous mode)                */
            uint8_t            : 2;
            __IOM uint8_t BCP2 : 1;    /*!< [7..7] Base Clock Pulse 2Selects the number of base clock cycles
                                        *   in combination with the SMR.BCP[1:0] bits                                 */
        } SCMR_b;
    };

    union
    {
        __IOM uint8_t SEMR;            /*!< (@ 0x00000007) Serial Extended Mode Register                              */

        struct
        {
            uint8_t             : 2;
            __IOM uint8_t BRME  : 1;   /*!< [2..2] Bit Rate Modulation Enable                                         */
            __IOM uint8_t ABCSE : 1;   /*!< [3..3] Asynchronous Mode Extended Base Clock Select 1(Valid
                                        *   only in asynchronous mode and SCR.CKE[1]=0)                               */
            __IOM uint8_t ABCS : 1;    /*!< [4..4] Asynchronous Mode Base Clock Select(Valid only in asynchronous
                                        *   mode)                                                                     */
            __IOM uint8_t NFEN : 1;    /*!< [5..5] Digital Noise Filter Function Enable(The NFEN bit should
                                        *   be 0 without simple I2C mode and asynchronous mode.)In
                                        *   asynchronous mode, for RXDn input only. In simple I2C mode,
                                        *   for RXDn/TxDn input.                                                      */
            __IOM uint8_t BGDM : 1;    /*!< [6..6] Baud Rate Generator Double-Speed Mode Select(Only valid
                                        *   the CKE[1] bit in SCR is 0 in asynchronous mode).                         */
            __IOM uint8_t RXDESEL : 1; /*!< [7..7] Asynchronous Start Bit Edge Detection Select(Valid only
                                        *   in asynchronous mode)                                                     */
        } SEMR_b;
    };

    union
    {
        __IOM uint8_t SNFR;            /*!< (@ 0x00000008) Noise Filter Setting Register                              */

        struct
        {
            __IOM uint8_t NFCS : 3;    /*!< [2..0] Noise Filter Clock Select                                          */
            uint8_t            : 5;
        } SNFR_b;
    };

    union
    {
        __IOM uint8_t SIMR1;           /*!< (@ 0x00000009) I2C Mode Register 1                                        */

        struct
        {
            __IOM uint8_t IICM  : 1;   /*!< [0..0] Simple I2C Mode Select                                             */
            uint8_t             : 2;
            __IOM uint8_t IICDL : 5;   /*!< [7..3] SDA Delay Output SelectCycles below are of the clock
                                        *   signal from the on-chip baud rate generator.                              */
        } SIMR1_b;
    };

    union
    {
        __IOM uint8_t SIMR2;           /*!< (@ 0x0000000A) I2C Mode Register 2                                        */

        struct
        {
            __IOM uint8_t IICINTM : 1; /*!< [0..0] I2C Interrupt Mode Select                                          */
            __IOM uint8_t IICCSC  : 1; /*!< [1..1] Clock Synchronization                                              */
            uint8_t               : 3;
            __IOM uint8_t IICACKT : 1; /*!< [5..5] ACK Transmission Data                                              */
            uint8_t               : 2;
        } SIMR2_b;
    };

    union
    {
        __IOM uint8_t SIMR3;              /*!< (@ 0x0000000B) I2C Mode Register 3                                        */

        struct
        {
            __IOM uint8_t IICSTAREQ  : 1; /*!< [0..0] Start Condition Generation                                         */
            __IOM uint8_t IICRSTAREQ : 1; /*!< [1..1] Restart Condition Generation                                       */
            __IOM uint8_t IICSTPREQ  : 1; /*!< [2..2] Stop Condition Generation                                          */
            __IOM uint8_t IICSTIF    : 1; /*!< [3..3] Issuing of Start, Restart, or Stop Condition Completed
                                           *   Flag(When 0 is written to IICSTIF, it is cleared to 0.)                   */
            __IOM uint8_t IICSDAS : 2;    /*!< [5..4] SDA Output Select                                                  */
            __IOM uint8_t IICSCLS : 2;    /*!< [7..6] SCL Output Select                                                  */
        } SIMR3_b;
    };

    union
    {
        __IM uint8_t SISR;             /*!< (@ 0x0000000C) I2C Status Register                                        */

        struct
        {
            __IM uint8_t IICACKR : 1;  /*!< [0..0] ACK Reception Data Flag                                            */
            uint8_t              : 7;
        } SISR_b;
    };

    union
    {
        __IOM uint8_t SPMR;            /*!< (@ 0x0000000D) SPI Mode Register                                          */

        struct
        {
            __IOM uint8_t SSE   : 1;   /*!< [0..0] SSn Pin Function Enable                                            */
            __IOM uint8_t CTSE  : 1;   /*!< [1..1] CTS Enable                                                         */
            __IOM uint8_t MSS   : 1;   /*!< [2..2] Master Slave Select                                                */
            uint8_t             : 1;
            __IOM uint8_t MFF   : 1;   /*!< [4..4] Mode Fault Flag                                                    */
            uint8_t             : 1;
            __IOM uint8_t CKPOL : 1;   /*!< [6..6] Clock Polarity Select                                              */
            __IOM uint8_t CKPH  : 1;   /*!< [7..7] Clock Phase Select                                                 */
        } SPMR_b;
    };

    union
    {
        union
        {
            __IOM uint16_t TDRHL;         /*!< (@ 0x0000000E) Transmit 9-bit Data Register                               */

            struct
            {
                __OM uint16_t TDRHL : 16; /*!< [15..0] TDRHL is a 16-bit register that stores transmit data.             */
            } TDRHL_b;
        };

        union
        {
            __OM uint16_t FTDRHL;       /*!< (@ 0x0000000E) Transmit FIFO Data Register HL                             */

            struct
            {
                __OM uint16_t TDAT : 9; /*!< [8..0] Serial transmit data (Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __OM uint16_t MPBT : 1; /*!< [9..9] Multi-processor transfer bit flag(Valid only in asynchronous
                                         *   mode and SMR.MP=1 and FIFO selected)                                      */
                uint16_t : 6;
            } FTDRHL_b;
        };

        struct
        {
            union
            {
                __OM uint8_t FTDRH;         /*!< (@ 0x0000000E) Transmit FIFO Data Register H                              */

                struct
                {
                    __OM uint8_t TDATH : 1; /*!< [0..0] Serial transmit data (b8) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                    __OM uint8_t MPBT : 1;  /*!< [1..1] Multi-processor transfer bit flag(Valid only in asynchronous
                                             *   mode and SMR.MP=1 and FIFO selected)                                      */
                    uint8_t : 6;
                } FTDRH_b;
            };

            union
            {
                __OM uint8_t FTDRL;         /*!< (@ 0x0000000F) Transmit FIFO Data Register L                              */

                struct
                {
                    __OM uint8_t TDATL : 8; /*!< [7..0] Serial transmit data(b7-b0) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                } FTDRL_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint16_t RDRHL;          /*!< (@ 0x00000010) Receive 9-bit Data Register                                */

            struct
            {
                __IM uint16_t RDRHL : 16; /*!< [15..0] RDRHL is an 16-bit register that stores receive data.             */
            } RDRHL_b;
        };

        union
        {
            __IM uint16_t FRDRHL;       /*!< (@ 0x00000010) Receive FIFO Data Register HL                              */

            struct
            {
                __IM uint16_t RDAT : 9; /*!< [8..0] Serial receive data(Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __IM uint16_t MPB : 1;  /*!< [9..9] Multi-processor bit flag(Valid only in asynchronous mode
                                         *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                         *   bit corresponded to serial receive data(RDATA[8:0])                       */
                __IM uint16_t DR   : 1; /*!< [10..10] Receive data ready flag(It is same as SSR.DR)                    */
                __IM uint16_t PER  : 1; /*!< [11..11] Parity error flag                                                */
                __IM uint16_t FER  : 1; /*!< [12..12] Framing error flag                                               */
                __IM uint16_t ORER : 1; /*!< [13..13] Overrun error flag(It is same as SSR.ORER)                       */
                __IM uint16_t RDF  : 1; /*!< [14..14] Receive FIFO data full flag(It is same as SSR.RDF)               */
                uint16_t           : 1;
            } FRDRHL_b;
        };

        struct
        {
            union
            {
                __IM uint8_t FRDRH;         /*!< (@ 0x00000010) Receive FIFO Data Register H                               */

                struct
                {
                    __IM uint8_t RDATH : 1; /*!< [0..0] Serial receive data(b8)(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                    __IM uint8_t MPB : 1;   /*!< [1..1] Multi-processor bit flag(Valid only in asynchronous mode
                                             *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                             *   bit corresponded to serial receive data(RDATA[8:0])                       */
                    __IM uint8_t DR   : 1;  /*!< [2..2] Receive data ready flag(It is same as SSR.DR)                      */
                    __IM uint8_t PER  : 1;  /*!< [3..3] Parity error flag                                                  */
                    __IM uint8_t FER  : 1;  /*!< [4..4] Framing error flag                                                 */
                    __IM uint8_t ORER : 1;  /*!< [5..5] Overrun error flag(It is same as SSR.ORER)                         */
                    __IM uint8_t RDF  : 1;  /*!< [6..6] Receive FIFO data full flag(It is same as SSR.RDF)                 */
                    uint8_t           : 1;
                } FRDRH_b;
            };

            union
            {
                __IM uint8_t FRDRL;         /*!< (@ 0x00000011) Receive FIFO Data Register L                               */

                struct
                {
                    __IM uint8_t RDATL : 8; /*!< [7..0] Serial receive data(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)NOTE:
                                             *   When reading both of FRDRH register and FRDRL register,
                                             *   please read by an order of the FRDRH register and the FRDRL
                                             *   register.                                                                 */
                } FRDRL_b;
            };
        };
    };

    union
    {
        __IOM uint8_t MDDR;            /*!< (@ 0x00000012) Modulation Duty Register                                   */

        struct
        {
            __IOM uint8_t MDDR : 8;    /*!< [7..0] MDDR corrects the bit rate adjusted by the BRR register.           */
        } MDDR_b;
    };

    union
    {
        __IOM uint8_t DCCR;            /*!< (@ 0x00000013) Data Compare Match Control Register                        */

        struct
        {
            __IOM uint8_t DCMF  : 1;   /*!< [0..0] Data Compare Match Flag                                            */
            uint8_t             : 2;
            __IOM uint8_t DPER  : 1;   /*!< [3..3] Data Compare Match Parity Error Flag                               */
            __IOM uint8_t DFER  : 1;   /*!< [4..4] Data Compare Match Framing Error Flag                              */
            uint8_t             : 1;
            __IOM uint8_t IDSEL : 1;   /*!< [6..6] ID frame select(Valid only in asynchronous mode(including
                                        *   multi-processor)                                                          */
            __IOM uint8_t DCME : 1;    /*!< [7..7] Data Compare Match Enable(Valid only in asynchronous
                                        *   mode(including multi-processor)                                           */
        } DCCR_b;
    };

    union
    {
        __IOM uint16_t FCR;            /*!< (@ 0x00000014) FIFO Control Register                                      */

        struct
        {
            __IOM uint16_t FM : 1;     /*!< [0..0] FIFO Mode Select(Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode)                               */
            __IOM uint16_t RFRST : 1;  /*!< [1..1] Receive FIFO Data Register Reset(Valid only in FCR.FM=1)           */
            __IOM uint16_t TFRST : 1;  /*!< [2..2] Transmit FIFO Data Register Reset(Valid only in FCR.FM=1)          */
            __IOM uint16_t DRES  : 1;  /*!< [3..3] Receive data ready error select bit(When detecting a
                                        *   reception data ready, the interrupt request is selected.)                 */
            __IOM uint16_t TTRG : 4;   /*!< [7..4] Transmit FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RTRG : 4;   /*!< [11..8] Receive FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RSTRG : 4;  /*!< [15..12] RTS Output Active Trigger Number Select(Valid only
                                        *   in asynchronous mode(including multi-processor) or clock
                                        *   synchronous mode)                                                         */
        } FCR_b;
    };

    union
    {
        __IM uint16_t FDR;             /*!< (@ 0x00000016) FIFO Data Count Register                                   */

        struct
        {
            __IM uint16_t R : 5;       /*!< [4..0] Receive FIFO Data CountIndicate the quantity of receive
                                        *   data stored in FRDRH and FRDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t        : 3;
            __IM uint16_t T : 5;       /*!< [12..8] Transmit FIFO Data CountIndicate the quantity of non-transmit
                                        *   data stored in FTDRH and FTDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t : 3;
        } FDR_b;
    };

    union
    {
        __IM uint16_t LSR;             /*!< (@ 0x00000018) Line Status Register                                       */

        struct
        {
            __IM uint16_t ORER : 1;    /*!< [0..0] Overrun Error Flag (Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode, and FIFO selected)            */
            uint16_t           : 1;
            __IM uint16_t FNUM : 5;    /*!< [6..2] Framing Error CountIndicates the quantity of data with
                                        *   a framing error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t           : 1;
            __IM uint16_t PNUM : 5;    /*!< [12..8] Parity Error CountIndicates the quantity of data with
                                        *   a parity error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t : 3;
        } LSR_b;
    };

    union
    {
        __IOM uint16_t CDR;            /*!< (@ 0x0000001A) Compare Match Data Register                                */

        struct
        {
            __IOM uint16_t CMPD : 9;   /*!< [8..0] Compare Match DataCompare data pattern for address match
                                        *   wake-up function                                                          */
            uint16_t : 7;
        } CDR_b;
    };

    union
    {
        __IOM uint8_t SPTR;            /*!< (@ 0x0000001C) Serial Port Register                                       */

        struct
        {
            __IM uint8_t RXDMON : 1;   /*!< [0..0] Serial input data monitor bit(The state of the RXD terminal
                                        *   is shown.)                                                                */
            __IOM uint8_t SPB2DT : 1;  /*!< [1..1] Serial port break data select bit(The output level of
                                        *   TxD terminal is selected when SCR.TE = 0.)                                */
            __IOM uint8_t SPB2IO : 1;  /*!< [2..2] Serial port break I/O bit(It's selected whether the value
                                        *   of SPB2DT is output to TxD terminal.)                                     */
            uint8_t            : 1;
            __IOM uint8_t RINV : 1;    /*!< [4..4] RXD invert bit                                                     */
            __IOM uint8_t TINV : 1;    /*!< [5..5] TXD invert bit                                                     */
            __IOM uint8_t ASEN : 1;    /*!< [6..6] Adjust receive sampling timing enable                              */
            __IOM uint8_t ATEN : 1;    /*!< [7..7] Adjust transmit timing enable                                      */
        } SPTR_b;
    };

    union
    {
        __IOM uint8_t ACTR;            /*!< (@ 0x0000001D) Adjustment Communication Timing Register                   */

        struct
        {
            __IOM uint8_t AST : 3;     /*!< [2..0] Adjustment value for receive Sampling Timing                       */
            __IOM uint8_t AJD : 1;     /*!< [3..3] Adjustment Direction for receive sampling timing                   */
            __IOM uint8_t ATT : 3;     /*!< [6..4] Adjustment value for Transmit timing                               */
            __IOM uint8_t AET : 1;     /*!< [7..7] Adjustment edge for transmit timing                                */
        } ACTR_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint8_t ESMER;           /*!< (@ 0x00000020) Extended Serial Module Enable Register                     */

        struct
        {
            __IOM uint8_t ESME : 1;    /*!< [0..0] Extended Serial Mode Enable                                        */
            uint8_t            : 7;
        } ESMER_b;
    };

    union
    {
        __IOM uint8_t CR0;             /*!< (@ 0x00000021) Control Register 0                                         */

        struct
        {
            uint8_t             : 1;
            __IM uint8_t  SFSF  : 1;   /*!< [1..1] Start Frame Status Flag                                            */
            __IM uint8_t  RXDSF : 1;   /*!< [2..2] RXDXn Input Status Flag                                            */
            __IOM uint8_t BRME  : 1;   /*!< [3..3] Bit Rate Measurement Enable                                        */
            uint8_t             : 4;
        } CR0_b;
    };

    union
    {
        __IOM uint8_t CR1;             /*!< (@ 0x00000022) Control Register 1                                         */

        struct
        {
            __IOM uint8_t BFE   : 1;   /*!< [0..0] Break Field Enable                                                 */
            __IOM uint8_t CF0RE : 1;   /*!< [1..1] Control Field 0 Reception Enable                                   */
            __IOM uint8_t CF1DS : 2;   /*!< [3..2] Control Field 1 Data Register Select                               */
            __IOM uint8_t PIBE  : 1;   /*!< [4..4] Priority Interrupt Bit Enable                                      */
            __IOM uint8_t PIBS  : 3;   /*!< [7..5] Priority Interrupt Bit Select                                      */
        } CR1_b;
    };

    union
    {
        __IOM uint8_t CR2;             /*!< (@ 0x00000023) Control Register 2                                         */

        struct
        {
            __IOM uint8_t DFCS : 3;    /*!< [2..0] RXDXn Signal Digital Filter Clock Select                           */
            uint8_t            : 1;
            __IOM uint8_t BCCS : 2;    /*!< [5..4] Bus Collision Detection Clock Select                               */
            __IOM uint8_t RTS  : 2;    /*!< [7..6] RXDXn Reception Sampling Timing Select                             */
        } CR2_b;
    };

    union
    {
        __IOM uint8_t CR3;             /*!< (@ 0x00000024) Control Register 3                                         */

        struct
        {
            __IOM uint8_t SDST : 1;    /*!< [0..0] Start Frame Detection Start                                        */
            uint8_t            : 7;
        } CR3_b;
    };

    union
    {
        __IOM uint8_t PCR;             /*!< (@ 0x00000025) Port Control Register                                      */

        struct
        {
            __IOM uint8_t TXDXPS : 1;  /*!< [0..0] TXDXn Signal Polarity Select                                       */
            __IOM uint8_t RXDXPS : 1;  /*!< [1..1] RXDXn Signal Polarity Select                                       */
            uint8_t              : 2;
            __IOM uint8_t SHARPS : 1;  /*!< [4..4] TXDXn/RXDXn Pin Multiplexing Select                                */
            uint8_t              : 3;
        } PCR_b;
    };

    union
    {
        __IOM uint8_t ICR;             /*!< (@ 0x00000026) Interrupt Control Register                                 */

        struct
        {
            __IOM uint8_t BFDIE  : 1;  /*!< [0..0] Break Field Low Width Detected Interrupt Enable                    */
            __IOM uint8_t CF0MIE : 1;  /*!< [1..1] Control Field 0 Match Detected Interrupt Enable                    */
            __IOM uint8_t CF1MIE : 1;  /*!< [2..2] Control Field 1 Match Detected Interrupt Enable                    */
            __IOM uint8_t PIBDIE : 1;  /*!< [3..3] Priority Interrupt Bit Detected Interrupt Enable                   */
            __IOM uint8_t BCDIE  : 1;  /*!< [4..4] Bus Collision Detected Interrupt Enable                            */
            __IOM uint8_t AEDIE  : 1;  /*!< [5..5] Valid Edge Detected Interrupt Enable                               */
            uint8_t              : 2;
        } ICR_b;
    };

    union
    {
        __IM uint8_t STR;              /*!< (@ 0x00000027) Status Register                                            */

        struct
        {
            __IM uint8_t BFDF  : 1;    /*!< [0..0] Break Field Low Width Detection Flag                               */
            __IM uint8_t CF0MF : 1;    /*!< [1..1] Control Field 0 Match Flag                                         */
            __IM uint8_t CF1MF : 1;    /*!< [2..2] Control Field 1 Match Flag                                         */
            __IM uint8_t PIBDF : 1;    /*!< [3..3] Priority Interrupt Bit Detection Flag                              */
            __IM uint8_t BCDF  : 1;    /*!< [4..4] Bus Collision Detected Flag                                        */
            __IM uint8_t AEDF  : 1;    /*!< [5..5] Valid Edge Detection Flag                                          */
            uint8_t            : 2;
        } STR_b;
    };

    union
    {
        __IOM uint8_t STCR;            /*!< (@ 0x00000028) Status Clear Register                                      */

        struct
        {
            __IOM uint8_t BFDCL  : 1;  /*!< [0..0] BFDF Clear                                                         */
            __IOM uint8_t CF0MCL : 1;  /*!< [1..1] CF0MF Clear                                                        */
            __IOM uint8_t CF1MCL : 1;  /*!< [2..2] CF1MF Clear                                                        */
            __IOM uint8_t PIBDCL : 1;  /*!< [3..3] PIBDF Clear                                                        */
            __IOM uint8_t BCDCL  : 1;  /*!< [4..4] BCDF Clear                                                         */
            __IOM uint8_t AEDCL  : 1;  /*!< [5..5] AEDF Clear                                                         */
            uint8_t              : 2;
        } STCR_b;
    };
    __IOM uint8_t CF0DR;               /*!< (@ 0x00000029) Control Field 0 Data Register                              */

    union
    {
        __IOM uint8_t CF0CR;           /*!< (@ 0x0000002A) Control Field 0 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF0CE0 : 1;  /*!< [0..0] Control Field 0 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE1 : 1;  /*!< [1..1] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE2 : 1;  /*!< [2..2] Control Field 2 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE3 : 1;  /*!< [3..3] Control Field 3 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE4 : 1;  /*!< [4..4] Control Field 4 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE5 : 1;  /*!< [5..5] Control Field 5 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE6 : 1;  /*!< [6..6] Control Field 6 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE7 : 1;  /*!< [7..7] Control Field 7 Bit 0 Compare Enable                               */
        } CF0CR_b;
    };
    __IOM uint8_t CF0RR;               /*!< (@ 0x0000002B) Control Field 0 Receive Data Register                      */
    __IOM uint8_t PCF1DR;              /*!< (@ 0x0000002C) Primary Control Field 1 Data Register                      */
    __IOM uint8_t SCF1DR;              /*!< (@ 0x0000002D) Secondary Control Field 1 Data Register                    */

    union
    {
        __IOM uint8_t CF1CR;           /*!< (@ 0x0000002E) Control Field 1 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF1CE0 : 1;  /*!< [0..0] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF1CE1 : 1;  /*!< [1..1] Control Field 1 Bit 1 Compare Enable                               */
            __IOM uint8_t CF1CE2 : 1;  /*!< [2..2] Control Field 1 Bit 2 Compare Enable                               */
            __IOM uint8_t CF1CE3 : 1;  /*!< [3..3] Control Field 1 Bit 3 Compare Enable                               */
            __IOM uint8_t CF1CE4 : 1;  /*!< [4..4] Control Field 1 Bit 4 Compare Enable                               */
            __IOM uint8_t CF1CE5 : 1;  /*!< [5..5] Control Field 1 Bit 5 Compare Enable                               */
            __IOM uint8_t CF1CE6 : 1;  /*!< [6..6] Control Field 1 Bit 6 Compare Enable                               */
            __IOM uint8_t CF1CE7 : 1;  /*!< [7..7] Control Field 1 Bit 7 Compare Enable                               */
        } CF1CR_b;
    };
    __IOM uint8_t CF1RR;               /*!< (@ 0x0000002F) Control Field 1 Receive Data Register                      */

    union
    {
        __IOM uint8_t TCR;             /*!< (@ 0x00000030) Timer Control Register                                     */

        struct
        {
            __IOM uint8_t TCST : 1;    /*!< [0..0] Timer Count Start                                                  */
            uint8_t            : 7;
        } TCR_b;
    };

    union
    {
        __IOM uint8_t TMR;             /*!< (@ 0x00000031) Timer Mode Register                                        */

        struct
        {
            __IOM uint8_t TOMS : 2;    /*!< [1..0] Timer Operating Mode Select                                        */
            uint8_t            : 1;
            __IOM uint8_t TWRC : 1;    /*!< [3..3] Counter Write Control                                              */
            __IOM uint8_t TCSS : 3;    /*!< [6..4] Timer Count Clock Source Select                                    */
            uint8_t            : 1;
        } TMR_b;
    };
    __IOM uint8_t TPRE;                /*!< (@ 0x00000032) Timer Prescaler Register                                   */
    __IOM uint8_t TCNT;                /*!< (@ 0x00000033) Timer Count Register                                       */
} R_SCI0_Type;                         /*!< Size = 52 (0x34)                                                          */

/* =========================================================================================================================== */
/* ================                                         R_SDADC0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief R_SDADC0 (R_SDADC0)
 */

typedef struct                          /*!< (@ 0x4009C000) R_SDADC0 Structure                                         */
{
    union
    {
        __IOM uint16_t STC1;            /*!< (@ 0x00000000) Startup Control Register 1                                 */

        struct
        {
            __IOM uint16_t CLKDIV  : 4; /*!< [3..0] SDADC24 Reference Clock Division                                   */
            uint16_t               : 3;
            __IOM uint16_t SDADLPM : 1; /*!< [7..7] A/D conversion operation model select                              */
            __IOM uint16_t VSBIAS  : 4; /*!< [11..8] Reference voltage select                                          */
            uint16_t               : 3;
            __IOM uint16_t VREFSEL : 1; /*!< [15..15] VREF mode select                                                 */
        } STC1_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint8_t STC2;            /*!< (@ 0x00000004) Startup Control Register 2                                 */

        struct
        {
            __IOM uint8_t BGRPON  : 1; /*!< [0..0] BGR part power control                                             */
            __IOM uint8_t ADCPON  : 1; /*!< [1..1] ADREG forced power-down                                            */
            __IOM uint8_t ADFPWDS : 1; /*!< [2..2] ADC reference supply part                                          */
            uint8_t               : 5;
        } STC2_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint32_t PGAC[5];        /*!< (@ 0x00000008) Input Multiplexer [0..4] Setting Register                  */

        struct
        {
            __IOM uint32_t PGAGC : 5;  /*!< [4..0] Gain selection of a programmable gain instrumentation
                                        *   amplifier ( Gset1, Gset2, Gtotal )                                        */
            __IOM uint32_t PGAOSR : 3; /*!< [7..5] Oversampling ratio select                                          */
            __IOM uint32_t PGAOFS : 5; /*!< [12..8] Offset voltage select                                             */
            uint32_t              : 1;
            __IOM uint32_t PGAPOL : 1; /*!< [14..14] Polarity select                                                  */
            __IOM uint32_t PGASEL : 1; /*!< [15..15] Analog Channel Input Mode Select                                 */
            __IOM uint32_t PGACTM : 5; /*!< [20..16] Coefficient (m) selection of the A/D conversion count
                                        *   (N) in AUTOSCAN                                                           */
            __IOM uint32_t PGACTN : 3; /*!< [23..21] Coefficient (n) selection of the A/D conversion count
                                        *   (N) in AUTOSCAN                                                           */
            __IOM uint32_t PGAAVN : 2; /*!< [25..24] Selection of the number of data to be averaged                   */
            __IOM uint32_t PGAAVE : 2; /*!< [27..26] Selection of averaging processing                                */
            __IOM uint32_t PGAREV : 1; /*!< [28..28] Single-End Input A/D Converted Data Inversion Select             */
            uint32_t              : 1;
            __IOM uint32_t PGACVE : 1; /*!< [30..30] Calibration enable                                               */
            __IOM uint32_t PGAASN : 1; /*!< [31..31] Selection of the mode for specifying the number of
                                        *   A/D conversions in ADSCAN                                                 */
        } PGAC_b[5];
    };

    union
    {
        __IOM uint32_t ADC1;            /*!< (@ 0x0000001C) Sigma-Delta A/D Converter Control Register 1               */

        struct
        {
            __IOM uint32_t SDADSCM : 1; /*!< [0..0] Selection of autoscan mode                                         */
            uint32_t               : 3;
            __IOM uint32_t SDADTMD : 1; /*!< [4..4] Selection of A/D conversion trigger signal                         */
            uint32_t               : 3;
            __IOM uint32_t SDADBMP : 5; /*!< [12..8] A/D conversion control of the signal from input multiplexer       */
            uint32_t               : 3;
            __IOM uint32_t PGADISA : 1; /*!< [16..16] Control of disconnection detection                               */
            __IOM uint32_t PGADISC : 1; /*!< [17..17] Disconnection Detection Assist Setting                           */
            uint32_t               : 2;
            __IOM uint32_t PGASLFT : 1; /*!< [20..20] PGA offset self-diagnosis enable                                 */
            uint32_t               : 11;
        } ADC1_b;
    };

    union
    {
        __IOM uint8_t ADC2;            /*!< (@ 0x00000020) Sigma-Delta A/D Converter Control Register 2               */

        struct
        {
            __IOM uint8_t SDADST : 1;  /*!< [0..0] Control of A/D conversion                                          */
            uint8_t              : 7;
        } ADC2_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint32_t ADCR;            /*!< (@ 0x00000024) Sigma-delta A/D Converter Conversion Result Register       */

        struct
        {
            __IM uint32_t SDADCRD : 24; /*!< [23..0] The 24-bit A/D conversion result                                  */
            __IM uint32_t SDADCRS : 1;  /*!< [24..24] Status of an A/D conversion result                               */
            __IM uint32_t SDADCRC : 3;  /*!< [27..25] Channel number for an A/D conversion result                      */
            uint32_t              : 4;
        } ADCR_b;
    };

    union
    {
        __IM uint32_t ADAR;             /*!< (@ 0x00000028) Sigma-delta A/D Converter Average Value Register           */

        struct
        {
            __IM uint32_t SDADMVD : 24; /*!< [23..0] The 24-bit A/D average value                                      */
            __IM uint32_t SDADMVS : 1;  /*!< [24..24] Status of an A/D conversion result                               */
            __IM uint32_t SDADMVC : 3;  /*!< [27..25] Channel number for an A/D conversion result                      */
            uint32_t              : 4;
        } ADAR_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint8_t CLBC;            /*!< (@ 0x00000030) Calibration Control Register                               */

        struct
        {
            __IOM uint8_t CLBMD : 2;   /*!< [1..0] These bits are read as 0. The write value should be 0.             */
            uint8_t             : 6;
        } CLBC_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint8_t CLBSTR;          /*!< (@ 0x00000034) Calibration Start Control Register                         */

        struct
        {
            __IOM uint8_t CLBST : 1;   /*!< [0..0] Calibration start control                                          */
            uint8_t             : 7;
        } CLBSTR_b;
    };
    __IM uint8_t  RESERVED8;
    __IM uint16_t RESERVED9;
    __IM uint32_t RESERVED10;

    union
    {
        __IM uint8_t CLBSSR;           /*!< (@ 0x0000003C) Calibration Status Register                                */

        struct
        {
            __IM uint8_t CLBSS : 1;    /*!< [0..0] Calibration status                                                 */
            uint8_t            : 7;
        } CLBSSR_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;
} R_SDADC0_Type;                       /*!< Size = 64 (0x40)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SDHI0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief SD/MMC Host Interface (R_SDHI0)
 */

typedef struct                          /*!< (@ 0x40062000) R_SDHI0 Structure                                          */
{
    union
    {
        __IOM uint32_t SD_CMD;          /*!< (@ 0x00000000) Command Type Register                                      */

        struct
        {
            __IOM uint32_t CMDIDX : 6;  /*!< [5..0] Command IndexThese bits specify Command Format[45:40]
                                         *   (command index).[Examples]CMD6: SD_CMD[7:0] = 8'b00_000110CMD18:
                                         *   SD_CMD[7:0] = 8'b00_010010ACMD13: SD_CMD[7:0] = 8'b01_001101              */
            __IOM uint32_t ACMD  : 2;   /*!< [7..6] Command Type Select                                                */
            __IOM uint32_t RSPTP : 3;   /*!< [10..8] Mode/Response TypeNOTE: As some commands cannot be used
                                         *   in normal mode, see section 1.4.10, Example of SD_CMD Register
                                         *   Setting to select mode/response type.                                     */
            __IOM uint32_t CMDTP : 1;   /*!< [11..11] Data Mode (Command Type)                                         */
            __IOM uint32_t CMDRW : 1;   /*!< [12..12] Write/Read Mode (enabled when the command with data
                                         *   is handled)                                                               */
            __IOM uint32_t TRSTP : 1;   /*!< [13..13] Single/Multiple Block Transfer (enabled when the command
                                         *   with data is handled)                                                     */
            __IOM uint32_t CMD12AT : 2; /*!< [15..14] Multiple Block Transfer Mode (enabled at multiple block
                                         *   transfer)                                                                 */
            uint32_t : 16;
        } SD_CMD_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t SD_ARG;          /*!< (@ 0x00000008) SD Command Argument Register                               */

        struct
        {
            __IOM uint32_t SD_ARG : 32; /*!< [31..0] Argument RegisterSet command format[39:8] (argument)              */
        } SD_ARG_b;
    };

    union
    {
        __IOM uint32_t SD_ARG1;          /*!< (@ 0x0000000C) SD Command Argument Register 1                             */

        struct
        {
            __IOM uint32_t SD_ARG1 : 16; /*!< [15..0] Argument Register 1Set command format[39:24] (argument)           */
            uint32_t               : 16;
        } SD_ARG1_b;
    };

    union
    {
        __IOM uint32_t SD_STOP;        /*!< (@ 0x00000010) Data Stop Register                                         */

        struct
        {
            __IOM uint32_t STP : 1;    /*!< [0..0] Stop- When STP is set to 1 during multiple block transfer,
                                        *   CMD12 is issued to halt the transfer through the SD host
                                        *   interface.However, if a command sequence is halted because
                                        *   of a communications error or timeout, CMD12 is not issued.
                                        *   Although continued buffer access is possible even after
                                        *   STP has been set to 1, the buffer access error bit (ERR5
                                        *   or ERR4) in SD_INFO2 will be set accordingly.- When STP
                                        *   has been set to 1 during transfer for single block write,
                                        *   the access end flag is set when SD_BUF becomes emp                        */
            uint32_t           : 7;
            __IOM uint32_t SEC : 1;    /*!< [8..8] Block Count EnableSet SEC to 1 at multiple block transfer.When
                                        *   SD_CMD is set as follows to start the command sequence
                                        *   while SEC is set to 1, CMD12 is automatically issued to
                                        *   stop multi-block transfer with the number of blocks which
                                        *   is set to SD_SECCNT.1. CMD18 or CMD25 in normal mode (SD_CMD[10:8]
                                        *   = 000)2. SD_CMD[15:13] = 001 in extended mode (CMD12 is
                                        *   automatically issued, multiple block transfer)When the
                                        *   command sequence is halted because of a communications
                                        *   error or timeout, CMD12 is not automatically i                            */
            uint32_t : 23;
        } SD_STOP_b;
    };

    union
    {
        __IOM uint32_t SD_SECCNT;          /*!< (@ 0x00000014) Block Count Register                                       */

        struct
        {
            __IOM uint32_t SD_SECCNT : 32; /*!< [31..0] Number of Transfer BlocksNOTE: Do not change the value
                                            *   of this bit when the CBSY bit in SD_INFO2 is set to 1.                    */
        } SD_SECCNT_b;
    };

    union
    {
        __IM uint32_t SD_RSP10;          /*!< (@ 0x00000018) SD Card Response Register 10                               */

        struct
        {
            __IM uint32_t SD_RSP10 : 32; /*!< [31..0] Store the response from the SD card/MMC                           */
        } SD_RSP10_b;
    };

    union
    {
        __IM uint32_t SD_RSP1;          /*!< (@ 0x0000001C) SD Card Response Register 1                                */

        struct
        {
            __IM uint32_t SD_RSP1 : 16; /*!< [15..0] Store the response from the SD card/MMC                           */
            uint32_t              : 16;
        } SD_RSP1_b;
    };

    union
    {
        __IM uint32_t SD_RSP32;          /*!< (@ 0x00000020) SD Card Response Register 32                               */

        struct
        {
            __IM uint32_t SD_RSP32 : 32; /*!< [31..0] Store the response from the SD card/MMC                           */
        } SD_RSP32_b;
    };

    union
    {
        __IM uint32_t SD_RSP3;          /*!< (@ 0x00000024) SD Card Response Register 3                                */

        struct
        {
            __IM uint32_t SD_RSP3 : 16; /*!< [15..0] Store the response from the SD card/MMC                           */
            uint32_t              : 16;
        } SD_RSP3_b;
    };

    union
    {
        __IM uint32_t SD_RSP54;          /*!< (@ 0x00000028) SD Card Response Register 54                               */

        struct
        {
            __IM uint32_t SD_RSP54 : 32; /*!< [31..0] Store the response from the SD card/MMC                           */
        } SD_RSP54_b;
    };

    union
    {
        __IM uint32_t SD_RSP5;          /*!< (@ 0x0000002C) SD Card Response Register 5                                */

        struct
        {
            __IM uint32_t SD_RSP5 : 16; /*!< [15..0] Store the response from the SD card/MMC                           */
            uint32_t              : 16;
        } SD_RSP5_b;
    };

    union
    {
        __IM uint32_t SD_RSP76;          /*!< (@ 0x00000030) SD Card Response Register 76                               */

        struct
        {
            __IM uint32_t SD_RSP76 : 24; /*!< [23..0] Store the response from the SD card/MMC                           */
            uint32_t               : 8;
        } SD_RSP76_b;
    };

    union
    {
        __IM uint32_t SD_RSP7;         /*!< (@ 0x00000034) SD Card Response Register 7                                */

        struct
        {
            __IM uint32_t SD_RSP7 : 8; /*!< [7..0] Store the response from the SD card/MMC                            */
            uint32_t              : 24;
        } SD_RSP7_b;
    };

    union
    {
        __IOM uint32_t SD_INFO1;        /*!< (@ 0x00000038) SD Card Interrupt Flag Register 1                          */

        struct
        {
            __IOM uint32_t RSPEND  : 1; /*!< [0..0] Response End Detection                                             */
            uint32_t               : 1;
            __IOM uint32_t ACEND   : 1; /*!< [2..2] Access End                                                         */
            __IOM uint32_t SDCDRM  : 1; /*!< [3..3] SDnCD Card Removal                                                 */
            __IOM uint32_t SDCDIN  : 1; /*!< [4..4] SDnCD Card Insertion                                               */
            __IM uint32_t  SDCDMON : 1; /*!< [5..5] Indicates the SDnCD state                                          */
            uint32_t               : 1;
            __IM uint32_t  SDWPMON : 1; /*!< [7..7] Indicates the SDnWP state                                          */
            __IOM uint32_t SDD3RM  : 1; /*!< [8..8] SDnDAT3 Card Removal                                               */
            __IOM uint32_t SDD3IN  : 1; /*!< [9..9] SDnDAT3 Card Insertion                                             */
            __IM uint32_t  SDD3MON : 1; /*!< [10..10] Inticates the SDnDAT3 State                                      */
            uint32_t               : 21;
        } SD_INFO1_b;
    };

    union
    {
        __IOM uint32_t SD_INFO2;             /*!< (@ 0x0000003C) SD Card Interrupt Flag Register 2                          */

        struct
        {
            __IOM uint32_t CMDE    : 1;      /*!< [0..0] Command Error                                                      */
            __IOM uint32_t CRCE    : 1;      /*!< [1..1] CRC Error                                                          */
            __IOM uint32_t ENDE    : 1;      /*!< [2..2] END Error                                                          */
            __IOM uint32_t DTO     : 1;      /*!< [3..3] Data Timeout                                                       */
            __IOM uint32_t ILW     : 1;      /*!< [4..4] SD_BUF Illegal Write Access                                        */
            __IOM uint32_t ILR     : 1;      /*!< [5..5] SD_BUF Illegal Read Access                                         */
            __IOM uint32_t RSPTO   : 1;      /*!< [6..6] Response Timeout                                                   */
            __IM uint32_t  SDD0MON : 1;      /*!< [7..7] SDDAT0Indicates the SDDAT0 state of the port specified
                                              *   by SD_PORTSEL.                                                            */
            __IOM uint32_t BRE          : 1; /*!< [8..8] SD_BUF Read Enable                                                 */
            __IOM uint32_t BWE          : 1; /*!< [9..9] SD_BUF Write Enable                                                */
            uint32_t                    : 3;
            __IM uint32_t SD_CLK_CTRLEN : 1; /*!< [13..13] When a command sequence is started by writing to SD_CMD,
                                              *   the CBSY bit is set to 1 and, at the same time, the SCLKDIVEN
                                              *   bit is set to 0. The SCLKDIVEN bit is set to 1 after 8
                                              *   cycles of SDCLK have elapsed after setting of the CBSY
                                              *   bit to 0 due to completion of the command sequence.                       */
            __IM uint32_t  CBSY : 1;         /*!< [14..14] Command Type Register Busy                                       */
            __IOM uint32_t ILA  : 1;         /*!< [15..15] Illegal Access Error                                             */
            uint32_t            : 16;
        } SD_INFO2_b;
    };

    union
    {
        __IOM uint32_t SD_INFO1_MASK;   /*!< (@ 0x00000040) SD_INFO1 Interrupt Mask Register                           */

        struct
        {
            __IOM uint32_t RSPENDM : 1; /*!< [0..0] Response End Interrupt Request Mask                                */
            uint32_t               : 1;
            __IOM uint32_t ACENDM  : 1; /*!< [2..2] Access End Interrupt Request Mask                                  */
            __IOM uint32_t SDCDRMM : 1; /*!< [3..3] SDnCD card Removal Interrupt Request Mask                          */
            __IOM uint32_t SDCDINM : 1; /*!< [4..4] SDnCD card Insertion Interrupt Request Mask                        */
            uint32_t               : 3;
            __IOM uint32_t SDD3RMM : 1; /*!< [8..8] SDnDAT3 Card Removal Interrupt Request Mask                        */
            __IOM uint32_t SDD3INM : 1; /*!< [9..9] SDnDAT3 Card Insertion Interrupt Request Mask                      */
            uint32_t               : 22;
        } SD_INFO1_MASK_b;
    };

    union
    {
        __IOM uint32_t SD_INFO2_MASK;  /*!< (@ 0x00000044) SD_INFO2 Interrupt Mask Register                           */

        struct
        {
            __IOM uint32_t CMDEM  : 1; /*!< [0..0] Command Error Interrupt Request Mask                               */
            __IOM uint32_t CRCEM  : 1; /*!< [1..1] CRC Error Interrupt Request Mask                                   */
            __IOM uint32_t ENDEM  : 1; /*!< [2..2] End Bit Error Interrupt Request Mask                               */
            __IOM uint32_t DTOM   : 1; /*!< [3..3] Data Timeout Interrupt Request Mask                                */
            __IOM uint32_t ILWM   : 1; /*!< [4..4] SD_BUF Register Illegal Write Interrupt Request Mask               */
            __IOM uint32_t ILRM   : 1; /*!< [5..5] SD_BUF Register Illegal Read Interrupt Request Mask                */
            __IOM uint32_t RSPTOM : 1; /*!< [6..6] Response Timeout Interrupt Request Mask                            */
            uint32_t              : 1;
            __IOM uint32_t BREM   : 1; /*!< [8..8] BRE Interrupt Request Mask                                         */
            __IOM uint32_t BWEM   : 1; /*!< [9..9] BWE Interrupt Request Mask                                         */
            uint32_t              : 5;
            __IOM uint32_t ILAM   : 1; /*!< [15..15] Illegal Access Error Interrupt Request Mask                      */
            uint32_t              : 16;
        } SD_INFO2_MASK_b;
    };

    union
    {
        __IOM uint32_t SD_CLK_CTRL;       /*!< (@ 0x00000048) SD Clock Control Register                                  */

        struct
        {
            __IOM uint32_t CLKSEL    : 8; /*!< [7..0] SDHI Clock Frequency Select                                        */
            __IOM uint32_t CLKEN     : 1; /*!< [8..8] SD/MMC Clock Output Control Enable                                 */
            __IOM uint32_t CLKCTRLEN : 1; /*!< [9..9] SD/MMC Clock Output Automatic Control Enable                       */
            uint32_t                 : 22;
        } SD_CLK_CTRL_b;
    };

    union
    {
        __IOM uint32_t SD_SIZE;        /*!< (@ 0x0000004C) Transfer Data Length Register                              */

        struct
        {
            __IOM uint32_t LEN : 10;   /*!< [9..0] Transfer Data SizeThese bits specify a size between 1
                                        *   and 512 bytes for the transfer of single blocks.In cases
                                        *   of multiple block transfer with automatic issuing of CMD12
                                        *   (CMD18 and CMD25), the only specifiable transfer data size
                                        *   is 512 bytes. Furthermore, in cases of multiple block transfer
                                        *   without automatic issuing of CMD12, as well as 512 bytes,
                                        *   32, 64, 128, and 256 bytes are specifiable. However, in
                                        *   the reading of 32, 64, 128, and 256 bytes for the transfer
                                        *   of multiple blocks, this is restricted to mult                            */
            uint32_t : 22;
        } SD_SIZE_b;
    };

    union
    {
        __IOM uint32_t SD_OPTION;        /*!< (@ 0x00000050) SD Card Access Control Option Register                     */

        struct
        {
            __IOM uint32_t CTOP     : 4; /*!< [3..0] Card Detect Time Counter                                           */
            __IOM uint32_t TOP      : 4; /*!< [7..4] Timeout Counter                                                    */
            __IOM uint32_t TOUTMASK : 1; /*!< [8..8] Timeout MASKWhen timeout occurs in case of inactivating
                                          *   timeout, software reset should be executed to terminate
                                          *   command sequence.                                                         */
            uint32_t              : 4;
            __IOM uint32_t WIDTH8 : 1;   /*!< [13..13] Bus Widthsee b15, WIDTH bit                                      */
            uint32_t              : 1;
            __IOM uint32_t WIDTH  : 1;   /*!< [15..15] Bus WidthNOTE: The initial value is applied at a reset
                                          *   and when the SOFT_RST.SDRST flag is 0.                                    */
            uint32_t : 16;
        } SD_OPTION_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IM uint32_t SD_ERR_STS1;      /*!< (@ 0x00000058) SD Error Status Register 1                                 */

        struct
        {
            __IM uint32_t CMDE0 : 1;    /*!< [0..0] Command Error 0NOTE: other than a response to a command
                                         *   issued within a command sequence                                          */
            __IM uint32_t CMDE1 : 1;    /*!< [1..1] Command Error 1NOTE: In cases where CMD12 is issued by
                                         *   setting a command index in SD_CMD, this is Indicated in
                                         *   CMDE0.                                                                    */
            __IM uint32_t RSPLENE0 : 1; /*!< [2..2] Response Length Error 0NOTE: other than a response to
                                         *   a command issued within a command sequence                                */
            __IM uint32_t RSPLENE1 : 1; /*!< [3..3] Response Length Error 1NOTE: In cases where CMD12 is
                                         *   issued by setting a command index in SD_CMD, this is indicated
                                         *   in RSPLENE0.                                                              */
            __IM uint32_t RDLENE   : 1; /*!< [4..4] Read Data Length Error                                             */
            __IM uint32_t CRCLENE  : 1; /*!< [5..5] CRC Status Token Length Error                                      */
            uint32_t               : 2;
            __IM uint32_t RSPCRCE0 : 1; /*!< [8..8] Response CRC Error 0NOTE: other than a response to a
                                         *   command issued within a command sequence                                  */
            __IM uint32_t RSPCRCE1 : 1; /*!< [9..9] Response CRC Error 1NOTE: In cases where CMD12 is issued
                                         *   by setting a command index in SD_CMD, this is indicated
                                         *   in RSPCRCE0.                                                              */
            __IM uint32_t RDCRCE : 1;   /*!< [10..10] Read Data CRC Error                                              */
            __IM uint32_t CRCTKE : 1;   /*!< [11..11] CRC Status Token Error                                           */
            __IM uint32_t CRCTK  : 3;   /*!< [14..12] CRC Status TokenStore the CRC status token value (normal
                                         *   value is 010b)                                                            */
            uint32_t : 17;
        } SD_ERR_STS1_b;
    };

    union
    {
        __IM uint32_t SD_ERR_STS2;      /*!< (@ 0x0000005C) SD Error Status Register 2                                 */

        struct
        {
            __IM uint32_t RSPTO0   : 1; /*!< [0..0] Response Timeout 0                                                 */
            __IM uint32_t RSPTO1   : 1; /*!< [1..1] Response Timeout 1                                                 */
            __IM uint32_t BSYTO0   : 1; /*!< [2..2] Busy Timeout 0                                                     */
            __IM uint32_t BSYTO1   : 1; /*!< [3..3] Busy Timeout 1                                                     */
            __IM uint32_t RDTO     : 1; /*!< [4..4] Read Data Timeout                                                  */
            __IM uint32_t CRCTO    : 1; /*!< [5..5] CRC Status Token Timeout                                           */
            __IM uint32_t CRCBSYTO : 1; /*!< [6..6] CRC Status Token Busy Timeout                                      */
            uint32_t               : 25;
        } SD_ERR_STS2_b;
    };

    union
    {
        __IOM uint32_t SD_BUF0;         /*!< (@ 0x00000060) SD Buffer Register                                         */

        struct
        {
            __IOM uint32_t SD_BUF : 32; /*!< [31..0] SD Buffer RegisterWhen writing to the SD card, the write
                                         *   data is written to this register. When reading from the
                                         *   SD card, the read data is read from this register. This
                                         *   register is internally connected to two 512-byte buffers.If
                                         *   both buffers are not empty when executing multiple block
                                         *   read, SD/MMC clock is stopped to suspend receiving data.
                                         *   When one of buffers is empty, SD/MMC clock is supplied
                                         *   to resume receiving data.                                                 */
        } SD_BUF0_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t SDIO_MODE;      /*!< (@ 0x00000068) SDIO Mode Control Register                                 */

        struct
        {
            __IOM uint32_t INTEN  : 1; /*!< [0..0] SDIO Mode                                                          */
            uint32_t              : 1;
            __IOM uint32_t RWREQ  : 1; /*!< [2..2] Read Wait Request                                                  */
            uint32_t              : 5;
            __IOM uint32_t IOABT  : 1; /*!< [8..8] SDIO AbortNOTE: See manual                                         */
            __IOM uint32_t C52PUB : 1; /*!< [9..9] SDIO None AbortNOTE: See manual                                    */
            uint32_t              : 22;
        } SDIO_MODE_b;
    };

    union
    {
        __IOM uint32_t SDIO_INFO1;      /*!< (@ 0x0000006C) SDIO Interrupt Flag Register 1                             */

        struct
        {
            __IOM uint32_t IOIRQ   : 1; /*!< [0..0] SDIO Interrupt Status                                              */
            uint32_t               : 13;
            __IOM uint32_t EXPUB52 : 1; /*!< [14..14] EXPUB52 Status FlagNOTE: See manual                              */
            __IOM uint32_t EXWT    : 1; /*!< [15..15] EXWT Status FlagNOTE: See manual                                 */
            uint32_t               : 16;
        } SDIO_INFO1_b;
    };

    union
    {
        __IOM uint32_t SDIO_INFO1_MASK;  /*!< (@ 0x00000070) SDIO_INFO1 Interrupt Mask Register                         */

        struct
        {
            __IOM uint32_t IOIRQM   : 1; /*!< [0..0] IOIRQ Interrupt Mask Control                                       */
            uint32_t                : 13;
            __IOM uint32_t EXPUB52M : 1; /*!< [14..14] EXPUB52 Interrupt Request Mask Control                           */
            __IOM uint32_t EXWTM    : 1; /*!< [15..15] EXWT Interrupt Request Mask Control                              */
            uint32_t                : 16;
        } SDIO_INFO1_MASK_b;
    };
    __IM uint32_t RESERVED3[79];

    union
    {
        __IOM uint32_t SD_DMAEN;       /*!< (@ 0x000001B0) DMA Mode Enable Register                                   */

        struct
        {
            uint32_t             : 1;
            __IOM uint32_t DMAEN : 1;  /*!< [1..1] SD_BUF Read/Write DMA Transfer                                     */
            uint32_t             : 30;
        } SD_DMAEN_b;
    };
    __IM uint32_t RESERVED4[3];

    union
    {
        __IOM uint32_t SOFT_RST;       /*!< (@ 0x000001C0) Software Reset Register                                    */

        struct
        {
            __IOM uint32_t SDRST : 1;  /*!< [0..0] Software Reset of SD I/F Unit                                      */
            uint32_t             : 31;
        } SOFT_RST_b;
    };
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint32_t SDIF_MODE;      /*!< (@ 0x000001CC) SD Interface Mode Setting Register                         */

        struct
        {
            uint32_t               : 8;
            __IOM uint32_t NOCHKCR : 1; /*!< [8..8] CRC Check Mask (for MMC test commands)                             */
            uint32_t               : 23;
        } SDIF_MODE_b;
    };
    __IM uint32_t RESERVED6[4];

    union
    {
        __IOM uint32_t EXT_SWAP;       /*!< (@ 0x000001E0) Swap Control Register                                      */

        struct
        {
            uint32_t             : 6;
            __IOM uint32_t BWSWP : 1;  /*!< [6..6] SD_BUF0 Swap Write                                                 */
            __IOM uint32_t BRSWP : 1;  /*!< [7..7] SD_BUF0 Swap Read                                                  */
            uint32_t             : 24;
        } EXT_SWAP_b;
    };
} R_SDHI0_Type;                        /*!< Size = 484 (0x1e4)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_SLCDC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Segment LCD Controller/Driver (R_SLCDC)
 */

typedef struct                         /*!< (@ 0x40082000) R_SLCDC Structure                                          */
{
    union
    {
        __IOM uint8_t LCDM0;           /*!< (@ 0x00000000) LCD Mode Register 0                                        */

        struct
        {
            __IOM uint8_t LBAS  : 2;   /*!< [1..0] LCD Display Bias Method Select                                     */
            __IOM uint8_t LDTY  : 3;   /*!< [4..2] Time Slice of LCD Display Select                                   */
            __IOM uint8_t LWAVE : 1;   /*!< [5..5] LCD display waveform selection                                     */
            __IOM uint8_t MDSET : 2;   /*!< [7..6] LCD drive voltage generator selection                              */
        } LCDM0_b;
    };

    union
    {
        __IOM uint8_t LCDM1;           /*!< (@ 0x00000001) LCD Mode Register 1                                        */

        struct
        {
            __IOM uint8_t LCDVLM : 1;  /*!< [0..0] Voltage Boosting Pin Initial Value Switching Control               */
            uint8_t              : 2;
            __IOM uint8_t LCDSEL : 1;  /*!< [3..3] Display data area control                                          */
            __IOM uint8_t BLON   : 1;  /*!< [4..4] Display data area control                                          */
            __IOM uint8_t VLCON  : 1;  /*!< [5..5] Voltage boost circuit or capacitor split circuit operation
                                        *   enable/disable                                                            */
            __IOM uint8_t SCOC  : 1;   /*!< [6..6] LCD Display Enable/Disable                                         */
            __IOM uint8_t LCDON : 1;   /*!< [7..7] LCD Display Enable/Disable                                         */
        } LCDM1_b;
    };

    union
    {
        __IOM uint8_t LCDC0;           /*!< (@ 0x00000002) LCD Clock Control Register 0                               */

        struct
        {
            __IOM uint8_t LCDC : 6;    /*!< [5..0] LCD clock (LCDCL)                                                  */
            uint8_t            : 2;
        } LCDC0_b;
    };

    union
    {
        __IOM uint8_t VLCD;            /*!< (@ 0x00000003) LCD Boost Level Control Register                           */

        struct
        {
            __IOM uint8_t VLCD : 5;    /*!< [4..0] Reference Voltage(Contrast Adjustment) Select                      */
            uint8_t            : 3;
        } VLCD_b;
    };
    __IM uint8_t RESERVED[252];

    union
    {
        __IOM uint8_t SEG[64];         /*!< (@ 0x00000100) LCD Display Data Array                                     */

        struct
        {
            __IOM uint8_t A : 4;       /*!< [3..0] A-Pattern Area                                                     */
            __IOM uint8_t B : 4;       /*!< [7..4] B-Pattern Area                                                     */
        } SEG_b[64];
    };
} R_SLCDC_Type;                        /*!< Size = 320 (0x140)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_SPI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Peripheral Interface (R_SPI0)
 */

typedef struct                         /*!< (@ 0x40072000) R_SPI0 Structure                                           */
{
    union
    {
        __IOM uint8_t SPCR;            /*!< (@ 0x00000000) SPI Control Register                                       */

        struct
        {
            __IOM uint8_t SPMS   : 1;  /*!< [0..0] SPI Mode Select                                                    */
            __IOM uint8_t TXMD   : 1;  /*!< [1..1] Communications Operating Mode Select                               */
            __IOM uint8_t MODFEN : 1;  /*!< [2..2] Mode Fault Error Detection Enable                                  */
            __IOM uint8_t MSTR   : 1;  /*!< [3..3] SPI Master/Slave Mode Select                                       */
            __IOM uint8_t SPEIE  : 1;  /*!< [4..4] SPI Error Interrupt Enable                                         */
            __IOM uint8_t SPTIE  : 1;  /*!< [5..5] Transmit Buffer Empty Interrupt Enable                             */
            __IOM uint8_t SPE    : 1;  /*!< [6..6] SPI Function Enable                                                */
            __IOM uint8_t SPRIE  : 1;  /*!< [7..7] SPI Receive Buffer Full Interrupt Enable                           */
        } SPCR_b;
    };

    union
    {
        __IOM uint8_t SSLP;            /*!< (@ 0x00000001) SPI Slave Select Polarity Register                         */

        struct
        {
            __IOM uint8_t SSL0P : 1;   /*!< [0..0] SSL0 Signal Polarity Setting                                       */
            __IOM uint8_t SSL1P : 1;   /*!< [1..1] SSL1 Signal Polarity Setting                                       */
            __IOM uint8_t SSL2P : 1;   /*!< [2..2] SSL2 Signal Polarity Setting                                       */
            __IOM uint8_t SSL3P : 1;   /*!< [3..3] SSL3 Signal Polarity Setting                                       */
            __IOM uint8_t SSL4P : 1;   /*!< [4..4] SSL4 Signal Polarity Setting                                       */
            __IOM uint8_t SSL5P : 1;   /*!< [5..5] SSL5 Signal Polarity Setting                                       */
            __IOM uint8_t SSL6P : 1;   /*!< [6..6] SSL6 Signal Polarity Setting                                       */
            __IOM uint8_t SSL7P : 1;   /*!< [7..7] SSL7 Signal Polarity Setting                                       */
        } SSLP_b;
    };

    union
    {
        __IOM uint8_t SPPCR;           /*!< (@ 0x00000002) SPI Pin Control Register                                   */

        struct
        {
            __IOM uint8_t SPLP  : 1;   /*!< [0..0] SPI Loopback                                                       */
            __IOM uint8_t SPLP2 : 1;   /*!< [1..1] SPI Loopback 2                                                     */
            uint8_t             : 2;
            __IOM uint8_t MOIFV : 1;   /*!< [4..4] MOSI Idle Fixed Value                                              */
            __IOM uint8_t MOIFE : 1;   /*!< [5..5] MOSI Idle Value Fixing Enable                                      */
            uint8_t             : 2;
        } SPPCR_b;
    };

    union
    {
        __IOM uint8_t SPSR;            /*!< (@ 0x00000003) SPI Status Register                                        */

        struct
        {
            __IOM uint8_t OVRF  : 1;   /*!< [0..0] Overrun Error Flag                                                 */
            __IM uint8_t  IDLNF : 1;   /*!< [1..1] SPI Idle Flag                                                      */
            __IOM uint8_t MODF  : 1;   /*!< [2..2] Mode Fault Error Flag                                              */
            __IOM uint8_t PERF  : 1;   /*!< [3..3] Parity Error Flag                                                  */
            __IOM uint8_t UDRF  : 1;   /*!< [4..4] Underrun Error Flag(When MODF is 0, This bit is invalid.)          */
            __IOM uint8_t SPTEF : 1;   /*!< [5..5] SPI Transmit Buffer Empty Flag                                     */
            __IOM uint8_t CENDF : 1;   /*!< [6..6] Communication End Flag                                             */
            __IOM uint8_t SPRF  : 1;   /*!< [7..7] SPI Receive Buffer Full Flag                                       */
        } SPSR_b;
    };

    union
    {
        __IOM uint32_t SPDR;           /*!< (@ 0x00000004) SPI Data Register                                          */
        __IOM uint16_t SPDR_HA;        /*!< (@ 0x00000004) SPI Data Register ( halfword access )                      */
        __IOM uint8_t  SPDR_BY;        /*!< (@ 0x00000004) SPI Data Register ( byte access )                          */
    };

    union
    {
        __IOM uint8_t SPSCR;           /*!< (@ 0x00000008) SPI Sequence Control Register                              */

        struct
        {
            __IOM uint8_t SPSLN : 3;   /*!< [2..0] RSPI Sequence Length SpecificationThe order in which
                                        *   the SPCMD0 to SPCMD07 registers are to be referenced is
                                        *   changed in accordance with the sequence length that is
                                        *   set in these bits. The relationship among the setting of
                                        *   these bits, sequence length, and SPCMD0 to SPCMD7 registers
                                        *   referenced by the RSPI is shown above. However, the RSPI
                                        *   in slave mode always references SPCMD0.                                   */
            uint8_t : 5;
        } SPSCR_b;
    };

    union
    {
        __IM uint8_t SPSSR;            /*!< (@ 0x00000009) SPI Sequence Status Register                               */

        struct
        {
            __IM uint8_t SPCP  : 3;    /*!< [2..0] RSPI Command Pointer                                               */
            uint8_t            : 1;
            __IM uint8_t SPECM : 3;    /*!< [6..4] RSPI Error Command                                                 */
            uint8_t            : 1;
        } SPSSR_b;
    };

    union
    {
        __IOM uint8_t SPBR;            /*!< (@ 0x0000000A) SPI Bit Rate Register                                      */

        struct
        {
            __IOM uint8_t SPR : 8;     /*!< [7..0] SPBR sets the bit rate in master mode.                             */
        } SPBR_b;
    };

    union
    {
        __IOM uint8_t SPDCR;           /*!< (@ 0x0000000B) SPI Data Control Register                                  */

        struct
        {
            __IOM uint8_t SPFC   : 2;  /*!< [1..0] Number of Frames Specification                                     */
            __IOM uint8_t SLSEL  : 2;  /*!< [3..2] SSL Pin Output Select                                              */
            __IOM uint8_t SPRDTD : 1;  /*!< [4..4] SPI Receive/Transmit Data Selection                                */
            __IOM uint8_t SPLW   : 1;  /*!< [5..5] SPI Word Access/Halfword Access Specification                      */
            __IOM uint8_t SPBYT  : 1;  /*!< [6..6] SPI Byte Access Specification                                      */
            uint8_t              : 1;
        } SPDCR_b;
    };

    union
    {
        __IOM uint8_t SPCKD;           /*!< (@ 0x0000000C) SPI Clock Delay Register                                   */

        struct
        {
            __IOM uint8_t SCKDL : 3;   /*!< [2..0] RSPCK Delay Setting                                                */
            uint8_t             : 5;
        } SPCKD_b;
    };

    union
    {
        __IOM uint8_t SSLND;           /*!< (@ 0x0000000D) SPI Slave Select Negation Delay Register                   */

        struct
        {
            __IOM uint8_t SLNDL : 3;   /*!< [2..0] SSL Negation Delay Setting                                         */
            uint8_t             : 5;
        } SSLND_b;
    };

    union
    {
        __IOM uint8_t SPND;            /*!< (@ 0x0000000E) SPI Next-Access Delay Register                             */

        struct
        {
            __IOM uint8_t SPNDL : 3;   /*!< [2..0] SPI Next-Access Delay Setting                                      */
            uint8_t             : 5;
        } SPND_b;
    };

    union
    {
        __IOM uint8_t SPCR2;           /*!< (@ 0x0000000F) SPI Control Register 2                                     */

        struct
        {
            __IOM uint8_t SPPE   : 1;  /*!< [0..0] Parity Enable                                                      */
            __IOM uint8_t SPOE   : 1;  /*!< [1..1] Parity Mode                                                        */
            __IOM uint8_t SPIIE  : 1;  /*!< [2..2] SPI Idle Interrupt Enable                                          */
            __IOM uint8_t PTE    : 1;  /*!< [3..3] Parity Self-Testing                                                */
            __IOM uint8_t SCKASE : 1;  /*!< [4..4] RSPCK Auto-Stop Function Enable                                    */
            __IOM uint8_t SPTDDL : 3;  /*!< [7..5] RSPI Transmit Data Delay                                           */
        } SPCR2_b;
    };

    union
    {
        __IOM uint16_t SPCMD[8];       /*!< (@ 0x00000010) SPI Command Register [0..7]                                */

        struct
        {
            __IOM uint16_t CPHA   : 1; /*!< [0..0] RSPCK Phase Setting                                                */
            __IOM uint16_t CPOL   : 1; /*!< [1..1] RSPCK Polarity Setting                                             */
            __IOM uint16_t BRDV   : 2; /*!< [3..2] Bit Rate Division Setting                                          */
            __IOM uint16_t SSLA   : 3; /*!< [6..4] SSL Signal Assertion Setting                                       */
            __IOM uint16_t SSLKP  : 1; /*!< [7..7] SSL Signal Level Keeping                                           */
            __IOM uint16_t SPB    : 4; /*!< [11..8] SPI Data Length Setting                                           */
            __IOM uint16_t LSBF   : 1; /*!< [12..12] SPI LSB First                                                    */
            __IOM uint16_t SPNDEN : 1; /*!< [13..13] SPI Next-Access Delay Enable                                     */
            __IOM uint16_t SLNDEN : 1; /*!< [14..14] SSL Negation Delay Setting Enable                                */
            __IOM uint16_t SCKDEN : 1; /*!< [15..15] RSPCK Delay Setting Enable                                       */
        } SPCMD_b[8];
    };

    union
    {
        __IOM uint8_t SPDCR2;          /*!< (@ 0x00000020) SPI Data Control Register 2                                */

        struct
        {
            __IOM uint8_t BYSW : 1;    /*!< [0..0] Byte Swap Operating Mode Select                                    */
            __IOM uint8_t SINV : 1;    /*!< [1..1] Serial data invert bit                                             */
            uint8_t            : 6;
        } SPDCR2_b;
    };

    union
    {
        __IOM uint8_t SPCR3;           /*!< (@ 0x00000021) RSPI Control Register 3                                    */

        struct
        {
            __IOM uint8_t ETXMD  : 1;  /*!< [0..0] Extended Communication Mode Select                                 */
            __IOM uint8_t BFDS   : 1;  /*!< [1..1] Between Burst Transfer Frames Delay Select                         */
            uint8_t              : 2;
            __IOM uint8_t CENDIE : 1;  /*!< [4..4] RSPI Communication End Interrupt Enable                            */
            uint8_t              : 3;
        } SPCR3_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[6];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t SPPR;           /*!< (@ 0x0000003E) RSPI Parameter Read Register                               */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t BUFWID : 1; /*!< [4..4] Buffer Width check                                                 */
            uint16_t              : 3;
            __IOM uint16_t BUFNUM : 3; /*!< [10..8] Buffer Number check                                               */
            uint16_t              : 1;
            __IOM uint16_t CMDNUM : 4; /*!< [15..12] Command Number check                                             */
        } SPPR_b;
    };
} R_SPI0_Type;                         /*!< Size = 64 (0x40)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SRAM                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief SRAM (R_SRAM)
 */

typedef struct                         /*!< (@ 0x40002000) R_SRAM Structure                                           */
{
    union
    {
        __IOM uint8_t PARIOAD;         /*!< (@ 0x00000000) SRAM Parity Error Operation After Detection Register       */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } PARIOAD_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t SRAMPRCR;         /*!< (@ 0x00000004) SRAM Protection Register                                   */

        struct
        {
            __IOM uint8_t SRAMPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW       : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t SRAMWTSC;             /*!< (@ 0x00000008) RAM Wait State Control Register                            */

        struct
        {
            __IOM uint8_t ECCRAMWRWTEN : 1; /*!< [0..0] ECCRAM Write Wait Enable                                           */
            __IOM uint8_t ECCRAMRDWTEN : 1; /*!< [1..1] ECCRAM Read wait enable                                            */
            __IOM uint8_t SRAM0WTEN    : 1; /*!< [2..2] SRAM0 Wait Enable                                                  */
            __IOM uint8_t SRAM1WTEN    : 1; /*!< [3..3] SRAM1 Wait Enable                                                  */
            __IOM uint8_t SRAMHSWTEN   : 1; /*!< [4..4] SRAMHS Wait Enable                                                 */
            uint8_t                    : 3;
        } SRAMWTSC_b;
    };
    __IM uint8_t RESERVED2[3];

    union
    {
        __IOM uint8_t SRAMPRCR2;         /*!< (@ 0x0000000C) SRAM Protection Register 2                                 */

        struct
        {
            __IOM uint8_t SRAMPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW        : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR2_b;
    };
    __IM uint8_t RESERVED3[179];

    union
    {
        __IOM uint8_t ECCMODE;         /*!< (@ 0x000000C0) ECC Operating Mode Control Register                        */

        struct
        {
            __IOM uint8_t ECCMOD : 2;  /*!< [1..0] ECC Operating Mode Select                                          */
            uint8_t              : 6;
        } ECCMODE_b;
    };

    union
    {
        __IOM uint8_t ECC2STS;         /*!< (@ 0x000000C1) ECC 2-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC2ERR : 1; /*!< [0..0] ECC 2-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC2STS_b;
    };

    union
    {
        __IOM uint8_t ECC1STSEN;       /*!< (@ 0x000000C2) ECC 1-Bit Error Information Update Enable Register         */

        struct
        {
            __IOM uint8_t E1STSEN : 1; /*!< [0..0] ECC 1-Bit Error Information Update Enable                          */
            uint8_t               : 7;
        } ECC1STSEN_b;
    };

    union
    {
        __IOM uint8_t ECC1STS;         /*!< (@ 0x000000C3) ECC 1-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC1ERR : 1; /*!< [0..0] ECC 1-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC1STS_b;
    };

    union
    {
        __IOM uint8_t ECCPRCR;         /*!< (@ 0x000000C4) ECC Protection Register                                    */

        struct
        {
            __IOM uint8_t ECCPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR_b;
    };
    __IM uint8_t RESERVED4[11];

    union
    {
        __IOM uint8_t ECCPRCR2;         /*!< (@ 0x000000D0) ECC Protection Register 2                                  */

        struct
        {
            __IOM uint8_t ECCPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW2      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR2_b;
    };
    __IM uint8_t RESERVED5[3];

    union
    {
        __IOM uint8_t ECCETST;         /*!< (@ 0x000000D4) ECC Test Control Register                                  */

        struct
        {
            __IOM uint8_t TSTBYP : 1;  /*!< [0..0] ECC Bypass Select                                                  */
            uint8_t              : 7;
        } ECCETST_b;
    };
    __IM uint8_t RESERVED6[3];

    union
    {
        __IOM uint8_t ECCOAD;          /*!< (@ 0x000000D8) SRAM ECC Error Operation After Detection Register          */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } ECCOAD_b;
    };
} R_SRAM_Type;                         /*!< Size = 217 (0xd9)                                                         */

/* =========================================================================================================================== */
/* ================                                           R_SRC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Sampling Rate Converter (R_SRC)
 */

typedef struct                           /*!< (@ 0x40048000) R_SRC Structure                                            */
{
    union
    {
        __IOM uint32_t SRCFCTR[5552];    /*!< (@ 0x00000000) Filter Coefficient Table [0..5551]                         */

        struct
        {
            __IOM uint32_t SRCFCOE : 22; /*!< [21..0] Stores a filter coefficient value.                                */
            uint32_t               : 10;
        } SRCFCTR_b[5552];
    };
    __IM uint32_t RESERVED[588];

    union
    {
        __OM uint32_t SRCID;           /*!< (@ 0x00005FF0) Input Data Register                                        */

        struct
        {
            __OM uint32_t SRCID : 32;  /*!< [31..0] SRCID is a 32-bit writ-only register that is used to
                                        *   input the data before sampling rate conversion. All the
                                        *   bits are read as 0.                                                       */
        } SRCID_b;
    };

    union
    {
        __IM uint32_t SRCOD;           /*!< (@ 0x00005FF4) Output Data Register                                       */

        struct
        {
            __IM uint32_t SRCOD : 32;  /*!< [31..0] SRCOD is a 32-bit read-only register used to output
                                        *   the data after sampling rate conversion. The data in the
                                        *   16-stage output data FIFO is read through SRCOD. When the
                                        *   number of data in the output data FIFO is zero after the
                                        *   start of conversion, the value previously read is read
                                        *   again.                                                                    */
        } SRCOD_b;
    };

    union
    {
        __IOM uint16_t SRCIDCTRL;      /*!< (@ 0x00005FF8) Input Data Control Register                                */

        struct
        {
            __IOM uint16_t IFTRG : 2;  /*!< [1..0] Input FIFO Data Triggering Number                                  */
            uint16_t             : 6;
            __IOM uint16_t IEN   : 1;  /*!< [8..8] Input FIFO Empty Interrupt Enable                                  */
            __IOM uint16_t IED   : 1;  /*!< [9..9] Input Data Endian                                                  */
            uint16_t             : 6;
        } SRCIDCTRL_b;
    };

    union
    {
        __IOM uint16_t SRCODCTRL;      /*!< (@ 0x00005FFA) Output Data Control Register                               */

        struct
        {
            __IOM uint16_t OFTRG : 2;  /*!< [1..0] Output FIFO Data Trigger Number                                    */
            uint16_t             : 6;
            __IOM uint16_t OEN   : 1;  /*!< [8..8] Output Data FIFO Full Interrupt Enable                             */
            __IOM uint16_t OED   : 1;  /*!< [9..9] Output Data Endian                                                 */
            __IOM uint16_t OCH   : 1;  /*!< [10..10] Output Data Channel Exchange                                     */
            uint16_t             : 5;
        } SRCODCTRL_b;
    };

    union
    {
        __IOM uint16_t SRCCTRL;        /*!< (@ 0x00005FFC) Control Register                                           */

        struct
        {
            __IOM uint16_t OFS    : 3; /*!< [2..0] Output Sampling Rate                                               */
            uint16_t              : 1;
            __IOM uint16_t IFS    : 4; /*!< [7..4] Input Sampling Rate                                                */
            __IOM uint16_t CL     : 1; /*!< [8..8] Internal Work Memory Clear                                         */
            __IOM uint16_t FL     : 1; /*!< [9..9] Internal Work Memory Flush                                         */
            __IOM uint16_t OVEN   : 1; /*!< [10..10] Output Data FIFO Overwrite Interrupt Enable                      */
            __IOM uint16_t UDEN   : 1; /*!< [11..11] Output Data FIFO Underflow Interrupt Enable                      */
            __IOM uint16_t SRCEN  : 1; /*!< [12..12] Module Enable                                                    */
            __IOM uint16_t CEEN   : 1; /*!< [13..13] Conversion End Interrupt Enable                                  */
            uint16_t              : 1;
            __IOM uint16_t FICRAE : 1; /*!< [15..15] Filter Coefficient Table Access Enable                           */
        } SRCCTRL_b;
    };

    union
    {
        __IOM uint16_t SRCSTAT;        /*!< (@ 0x00005FFE) Status Register                                            */

        struct
        {
            __IOM uint16_t OINT : 1;   /*!< [0..0] Output Data FIFO Full Interrupt Request Flag                       */
            __IOM uint16_t IINT : 1;   /*!< [1..1] Input Data FIFO Empty Interrupt Request Flag                       */
            __IOM uint16_t OVF  : 1;   /*!< [2..2] Output Data FIFO Overwrite Interrupt Request Flag                  */
            __IOM uint16_t UDF  : 1;   /*!< [3..3] Output FIFO Underflow Interrupt Request Flag                       */
            __IM uint16_t  FLF  : 1;   /*!< [4..4] Flush Processing Status Flag                                       */
            __IOM uint16_t CEF  : 1;   /*!< [5..5] Conversion End Flag                                                */
            uint16_t            : 1;
            __IOM uint16_t IFDN : 4;   /*!< [10..7] Input FIFO Data CountIndicates the number of data units
                                        *   in the input FIFO.                                                        */
            __IOM uint16_t OFDN : 5;   /*!< [15..11] Output FIFO Data CountIndicates the number of data
                                        *   units in the output FIFO.                                                 */
        } SRCSTAT_b;
    };
} R_SRC_Type;                          /*!< Size = 24576 (0x6000)                                                     */

/* =========================================================================================================================== */
/* ================                                          R_SSI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Sound Interface Enhanced (SSIE) (R_SSI0)
 */

typedef struct                         /*!< (@ 0x4004E000) R_SSI0 Structure                                           */
{
    union
    {
        __IOM uint32_t SSICR;          /*!< (@ 0x00000000) Control Register                                           */

        struct
        {
            __IOM uint32_t REN  : 1;   /*!< [0..0] Receive Enable                                                     */
            __IOM uint32_t TEN  : 1;   /*!< [1..1] Transmit Enable                                                    */
            uint32_t            : 1;
            __IOM uint32_t MUEN : 1;   /*!< [3..3] Mute EnableNOTE: When this module is muted, the value
                                        *   of outputting serial data is rewritten to 0 but data transmission
                                        *   is not stopped. Write dummy data to the SSIFTDR not to
                                        *   generate a transmit underflow because the number of data
                                        *   in the transmit FIFO is decreasing.                                       */
            __IOM uint32_t CKDV  : 4;  /*!< [7..4] Serial Oversampling Clock Division Ratio                           */
            __IOM uint32_t DEL   : 1;  /*!< [8..8] Serial Data Delay                                                  */
            __IOM uint32_t PDTA  : 1;  /*!< [9..9] Parallel Data Alignment                                            */
            __IOM uint32_t SDTA  : 1;  /*!< [10..10] Serial Data Alignment                                            */
            __IOM uint32_t SPDP  : 1;  /*!< [11..11] Serial Padding Polarity                                          */
            __IOM uint32_t LRCKP : 1;  /*!< [12..12] Serial WS Polarity                                               */
            __IOM uint32_t BCKP  : 1;  /*!< [13..13] Serial Bit Clock Polarity                                        */
            __IOM uint32_t MST   : 1;  /*!< [14..14] Serial WS Direction NOTE: Only the following settings
                                        *   are allowed: (SCKD, SWSD) = (0, 0) and (1, 1). Other settings
                                        *   are prohibited.                                                           */
            uint32_t           : 1;
            __IOM uint32_t SWL : 3;    /*!< [18..16] System Word LengthSet the system word length to the
                                        *   bit clock frequency/2 fs.                                                 */
            __IOM uint32_t DWL   : 3;  /*!< [21..19] Data Word Length                                                 */
            __IOM uint32_t FRM   : 2;  /*!< [23..22] Channels                                                         */
            uint32_t             : 1;
            __IOM uint32_t IIEN  : 1;  /*!< [25..25] Idle Mode Interrupt Enable                                       */
            __IOM uint32_t ROIEN : 1;  /*!< [26..26] Receive Overflow Interrupt Enable                                */
            __IOM uint32_t RUIEN : 1;  /*!< [27..27] Receive Underflow Interrupt Enable                               */
            __IOM uint32_t TOIEN : 1;  /*!< [28..28] Transmit Overflow Interrupt Enable                               */
            __IOM uint32_t TUIEN : 1;  /*!< [29..29] Transmit Underflow Interrupt Enable                              */
            __IOM uint32_t CKS   : 1;  /*!< [30..30] Oversampling Clock Select                                        */
            uint32_t             : 1;
        } SSICR_b;
    };

    union
    {
        __IOM uint32_t SSISR;          /*!< (@ 0x00000004) Status Register                                            */

        struct
        {
            __IM uint32_t IDST   : 1;  /*!< [0..0] Idle Mode Status Flag                                              */
            __IM uint32_t RSWNO  : 1;  /*!< [1..1] Receive Serial Word Number                                         */
            __IM uint32_t RCHNO  : 2;  /*!< [3..2] Receive Channel Number.These bits are read as 00b.                 */
            __IM uint32_t TSWNO  : 1;  /*!< [4..4] Transmit Serial Word Number                                        */
            __IM uint32_t TCHNO  : 2;  /*!< [6..5] Transmit Channel Number                                            */
            uint32_t             : 18;
            __IM uint32_t  IIRQ  : 1;  /*!< [25..25] Idle Mode Interrupt Status Flag                                  */
            __IOM uint32_t ROIRQ : 1;  /*!< [26..26] Receive Overflow Error Interrupt Status Flag NOTE:
                                        *   Writable only to clear the flag. Confirm the value is 1
                                        *   and then write 0.                                                         */
            __IOM uint32_t RUIRQ : 1;  /*!< [27..27] Receive Underflow Error Interrupt Status Flag NOTE:
                                        *   Writable only to clear the flag. Confirm the value is 1
                                        *   and then write 0.                                                         */
            __IOM uint32_t TOIRQ : 1;  /*!< [28..28] Transmit Overflow Error Interrupt Status Flag NOTE:
                                        *   Writable only to clear the flag. Confirm the value is 1
                                        *   and then write 0.                                                         */
            __IOM uint32_t TUIRQ : 1;  /*!< [29..29] Transmit Underflow Error Interrupt Status Flag NOTE:
                                        *   Writable only to clear the flag. Confirm the value is 1
                                        *   and then write 0.                                                         */
            uint32_t : 2;
        } SSISR_b;
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __IOM uint32_t SSIFCR;         /*!< (@ 0x00000010) FIFO Control Register                                      */

        struct
        {
            __IOM uint32_t RFRST : 1;  /*!< [0..0] Receive FIFO Data Register Reset                                   */
            __IOM uint32_t TFRST : 1;  /*!< [1..1] Transmit FIFO Data Register Reset                                  */
            __IOM uint32_t RIE   : 1;  /*!< [2..2] Receive Interrupt Enable NOTE: RXI can be cleared by
                                        *   clearing either the RDF flag (see the description of the
                                        *   RDF bit for details) or RIE bit.                                          */
            __IOM uint32_t TIE : 1;    /*!< [3..3] Transmit Interrupt Enable NOTE: TXI can be cleared by
                                        *   clearing either the TDE flag (see the description of the
                                        *   TDE bit for details) or TIE bit.                                          */
            __IOM uint32_t RTRG : 2;   /*!< [5..4] Receive Data Trigger Number                                        */
            __IOM uint32_t TTRG : 2;   /*!< [7..6] Transmit Data Trigger Number NOTE: The values in parenthesis
                                        *   are the number of empty stages in SSIFTDR at which the
                                        *   TDE flag is set.                                                          */
            uint32_t              : 3;
            __IOM uint32_t BSW    : 1; /*!< [11..11] Byte Swap Enable                                                 */
            uint32_t              : 4;
            __IOM uint32_t SSIRST : 1; /*!< [16..16] SSI soft ware reset                                              */
            uint32_t              : 14;
            __IOM uint32_t AUCKE  : 1; /*!< [31..31] Oversampling Clock Enable                                        */
        } SSIFCR_b;
    };

    union
    {
        __IOM uint32_t SSIFSR;         /*!< (@ 0x00000014) FIFO Status Register                                       */

        struct
        {
            __IOM uint32_t RDF : 1;    /*!< [0..0] Receive Data Full Flag NOTE: Since the SSIFRDR register
                                        *   is a 32-byte FIFO register, the maximum number of data
                                        *   bytes that can be read from it while the RDF flag is 1
                                        *   is indicated in the RDC[3:0] flags. If reading data from
                                        *   the SSIFRDR register is continued after all the data is
                                        *   read, undefined values will be read.                                      */
            uint32_t          : 7;
            __IM uint32_t RDC : 6;     /*!< [13..8] Receive Data Indicate Flag(Indicates the number of data
                                        *   units stored in SSIFRDR)                                                  */
            uint32_t           : 2;
            __IOM uint32_t TDE : 1;    /*!< [16..16] Transmit Data Empty Flag NOTE: Since the SSIFTDR register
                                        *   is a 32-byte FIFO register, the maximum number of bytes
                                        *   that can be written to it while the TDE flag is 1 is 8
                                        *   - TDC[3:0]. If writing data to the SSIFTDR register is
                                        *   continued after all the data is written, writing will be
                                        *   invalid and an overflow occurs.                                           */
            uint32_t          : 7;
            __IM uint32_t TDC : 6;     /*!< [29..24] Transmit Data Indicate Flag(Indicates the number of
                                        *   data units stored in SSIFTDR)                                             */
            uint32_t : 2;
        } SSIFSR_b;
    };

    union
    {
        union
        {
            __OM uint32_t SSIFTDR;          /*!< (@ 0x00000018) Transmit FIFO Data Register                                */

            struct
            {
                __OM uint32_t SSIFTDR : 32; /*!< [31..0] SSIFTDR is a write-only FIFO register consisting of
                                             *   eight stages of 32-bit registers for storing data to be
                                             *   serially transmitted. NOTE: that when the SSIFTDR register
                                             *   is full of data (32 bytes), the next data cannot be written
                                             *   to it. If writing is attempted, it will be ignored and
                                             *   an overflow occurs.                                                       */
            } SSIFTDR_b;
        };
        __OM uint16_t SSIFTDR16;            /*!< (@ 0x00000018) Transmit FIFO Data Register                                */
        __OM uint8_t  SSIFTDR8;             /*!< (@ 0x00000018) Transmit FIFO Data Register                                */
    };

    union
    {
        union
        {
            __IM uint32_t SSIFRDR;          /*!< (@ 0x0000001C) Receive FIFO Data Register                                 */

            struct
            {
                __IM uint32_t SSIFRDR : 32; /*!< [31..0] SSIFRDR is a read-only FIFO register consisting of eight
                                             *   stages of 32-bit registers for storing serially received
                                             *   data.                                                                     */
            } SSIFRDR_b;
        };
        __IM uint16_t SSIFRDR16;            /*!< (@ 0x0000001C) Receive FIFO Data Register                                 */
        __IM uint8_t  SSIFRDR8;             /*!< (@ 0x0000001C) Receive FIFO Data Register                                 */
    };

    union
    {
        __IOM uint32_t SSIOFR;          /*!< (@ 0x00000020) Audio Format Register                                      */

        struct
        {
            __IOM uint32_t OMOD    : 2; /*!< [1..0] Audio Format Select                                                */
            uint32_t               : 6;
            __IOM uint32_t LRCONT  : 1; /*!< [8..8] Whether to Enable LRCK/FS Continuation                             */
            __IOM uint32_t BCKASTP : 1; /*!< [9..9] Whether to Enable Stopping BCK Output When SSIE is in
                                         *   Idle Status                                                               */
            uint32_t : 22;
        } SSIOFR_b;
    };

    union
    {
        __IOM uint32_t SSISCR;         /*!< (@ 0x00000024) Status Control Register                                    */

        struct
        {
            __IOM uint32_t RDFS : 5;   /*!< [4..0] RDF Setting Condition Select                                       */
            uint32_t            : 3;
            __IOM uint32_t TDES : 5;   /*!< [12..8] TDE Setting Condition Select                                      */
            uint32_t            : 19;
        } SSISCR_b;
    };
} R_SSI0_Type;                         /*!< Size = 40 (0x28)                                                          */

/* =========================================================================================================================== */
/* ================                                         R_SYSTEM                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief System Pins (R_SYSTEM)
 */

typedef struct                         /*!< (@ 0x4001E000) R_SYSTEM Structure                                         */
{
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint16_t SBYCR;          /*!< (@ 0x0000000C) Standby Control Register                                   */

        struct
        {
            uint16_t            : 14;
            __IOM uint16_t OPE  : 1;   /*!< [14..14] Output Port Enable                                               */
            __IOM uint16_t SSBY : 1;   /*!< [15..15] Software Standby                                                 */
        } SBYCR_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[3];

    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x0000001C) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] RAM0 Module Stop                                                   */
            __IOM uint32_t MSTPA1  : 1; /*!< [1..1] RAM1 Module Stop                                                   */
            uint32_t               : 3;
            __IOM uint32_t MSTPA5  : 1; /*!< [5..5] High-Speed RAM Module Stop                                         */
            __IOM uint32_t MSTPA6  : 1; /*!< [6..6] ECCRAM Module Stop                                                 */
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Standby RAM Module Stop                                            */
            uint32_t               : 14;
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] DMA Controller/Data Transfer Controller Module Stop              */
            uint32_t               : 9;
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t SCKDIVCR;       /*!< (@ 0x00000020) System Clock Division Control Register                     */

        struct
        {
            __IOM uint32_t PCKD : 3;   /*!< [2..0] Peripheral Module Clock D (PCLKD) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKC : 3;   /*!< [6..4] Peripheral Module Clock C (PCLKC) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKB : 3;   /*!< [10..8] Peripheral Module Clock B (PCLKB) Select                          */
            uint32_t            : 1;
            __IOM uint32_t PCKA : 3;   /*!< [14..12] Peripheral Module Clock A (PCLKA) Select                         */
            uint32_t            : 1;
            __IOM uint32_t BCK  : 3;   /*!< [18..16] External Bus Clock (BCLK) Select                                 */
            uint32_t            : 5;
            __IOM uint32_t ICK  : 3;   /*!< [26..24] System Clock (ICLK) Select                                       */
            uint32_t            : 1;
            __IOM uint32_t FCK  : 3;   /*!< [30..28] Flash IF Clock (FCLK) Select                                     */
            uint32_t            : 1;
        } SCKDIVCR_b;
    };

    union
    {
        __IOM uint8_t SCKDIVCR2;       /*!< (@ 0x00000024) System Clock Division Control Register 2                   */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t UCK : 3;     /*!< [6..4] USB Clock (UCLK) Select                                            */
            uint8_t           : 1;
        } SCKDIVCR2_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IOM uint8_t SCKSCR;          /*!< (@ 0x00000026) System Clock Source Control Register                       */

        struct
        {
            __IOM uint8_t CKSEL : 3;   /*!< [2..0] Clock Source Select                                                */
            uint8_t             : 5;
        } SCKSCR_b;
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint16_t PLLCCR;           /*!< (@ 0x00000028) PLL Clock Control Register                                 */

        struct
        {
            __IOM uint16_t PLIDIV   : 2; /*!< [1..0] PLL Input Frequency Division Ratio Select                          */
            uint16_t                : 2;
            __IOM uint16_t PLSRCSEL : 1; /*!< [4..4] PLL Clock Source Select                                            */
            uint16_t                : 3;
            __IOM uint16_t PLLMUL   : 6; /*!< [13..8] PLL Frequency Multiplication Factor Select [PLL Frequency
                                          *   Multiplication Factor] = (PLLUMUL+1) / 2 Range: 0x23 -
                                          *   0x3B for example 010011: x10.0 010100: x10.5 010101: x11.0
                                          *   : 011100: x14.5 011101: x15.0 011110: x15.5 : 111010: x29.5
                                          *   111011: x30.0                                                             */
            uint16_t : 2;
        } PLLCCR_b;
    };

    union
    {
        __IOM uint8_t PLLCR;           /*!< (@ 0x0000002A) PLL Control Register                                       */

        struct
        {
            __IOM uint8_t PLLSTP : 1;  /*!< [0..0] PLL Stop Control                                                   */
            uint8_t              : 7;
        } PLLCR_b;
    };

    union
    {
        __IOM uint8_t PLLCCR2;         /*!< (@ 0x0000002B) PLL Clock Control Register2                                */

        struct
        {
            __IOM uint8_t PLLMUL : 5;  /*!< [4..0] PLL Frequency Multiplication Factor Select                         */
            uint8_t              : 1;
            __IOM uint8_t PLODIV : 2;  /*!< [7..6] PLL Output Frequency Division Ratio Select                         */
        } PLLCCR2_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint8_t BCKCR;           /*!< (@ 0x00000030) External Bus Clock Control Register                        */

        struct
        {
            __IOM uint8_t BCLKDIV : 1; /*!< [0..0] BCLK Pin Output Select                                             */
            uint8_t               : 7;
        } BCKCR_b;
    };

    union
    {
        __IOM uint8_t MEMWAIT;         /*!< (@ 0x00000031) Memory Wait Cycle Control Register                         */

        struct
        {
            __IOM uint8_t MEMWAIT : 1; /*!< [0..0] Memory Wait Cycle SelectNote: Writing 0 to the MEMWAIT
                                        *   is prohibited when SCKDIVCR.ICK selects division by 1 and
                                        *   SCKSCR.CKSEL[2:0] bits select thesystem clock source that
                                        *   is faster than 32 MHz (ICLK > 32 MHz).                                    */
            uint8_t : 7;
        } MEMWAIT_b;
    };

    union
    {
        __IOM uint8_t MOSCCR;          /*!< (@ 0x00000032) Main Clock Oscillator Control Register                     */

        struct
        {
            __IOM uint8_t MOSTP : 1;   /*!< [0..0] Main Clock Oscillator Stop                                         */
            uint8_t             : 7;
        } MOSCCR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint8_t HOCOCR;          /*!< (@ 0x00000036) High-Speed On-Chip Oscillator Control Register             */

        struct
        {
            __IOM uint8_t HCSTP : 1;   /*!< [0..0] HOCO Stop                                                          */
            uint8_t             : 7;
        } HOCOCR_b;
    };
    __IM uint8_t RESERVED8;

    union
    {
        __IOM uint8_t MOCOCR;          /*!< (@ 0x00000038) Middle-Speed On-Chip Oscillator Control Register           */

        struct
        {
            __IOM uint8_t MCSTP : 1;   /*!< [0..0] MOCO Stop                                                          */
            uint8_t             : 7;
        } MOCOCR_b;
    };

    union
    {
        __IOM uint8_t FLLCR1;          /*!< (@ 0x00000039) FLL Control Register 1                                     */

        struct
        {
            __IOM uint8_t FLLEN : 1;   /*!< [0..0] FLL Enable                                                         */
            uint8_t             : 7;
        } FLLCR1_b;
    };

    union
    {
        __IOM uint16_t FLLCR2;           /*!< (@ 0x0000003A) FLL Control Register 2                                     */

        struct
        {
            __IOM uint16_t FLLCNTL : 11; /*!< [10..0] FLL Multiplication ControlMultiplication ratio of the
                                          *   FLL reference clock select                                                */
            uint16_t : 5;
        } FLLCR2_b;
    };

    union
    {
        __IM uint8_t OSCSF;            /*!< (@ 0x0000003C) Oscillation Stabilization Flag Register                    */

        struct
        {
            __IM uint8_t HOCOSF : 1;   /*!< [0..0] HOCO Clock Oscillation Stabilization FlagNOTE: The HOCOSF
                                        *   bit value after a reset is 1 when the OFS1.HOCOEN bit is
                                        *   0. It is 0 when the OFS1.HOCOEN bit is 1.                                 */
            uint8_t             : 2;
            __IM uint8_t MOSCSF : 1;   /*!< [3..3] Main Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
            __IM uint8_t PLLSF  : 1;   /*!< [5..5] PLL Clock Oscillation Stabilization Flag                           */
            __IM uint8_t PLL2SF : 1;   /*!< [6..6] PLL2 Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
        } OSCSF_b;
    };
    __IM uint8_t RESERVED9;

    union
    {
        __IOM uint8_t CKOCR;           /*!< (@ 0x0000003E) Clock Out Control Register                                 */

        struct
        {
            __IOM uint8_t CKOSEL : 3;  /*!< [2..0] Clock out source select                                            */
            uint8_t              : 1;
            __IOM uint8_t CKODIV : 3;  /*!< [6..4] Clock out input frequency Division Select                          */
            __IOM uint8_t CKOEN  : 1;  /*!< [7..7] Clock out enable                                                   */
        } CKOCR_b;
    };

    union
    {
        __IOM uint8_t TRCKCR;          /*!< (@ 0x0000003F) Trace Clock Control Register                               */

        struct
        {
            __IOM uint8_t TRCK   : 4;  /*!< [3..0] Trace Clock operating frequency select                             */
            uint8_t              : 3;
            __IOM uint8_t TRCKEN : 1;  /*!< [7..7] Trace Clock operating Enable                                       */
        } TRCKCR_b;
    };

    union
    {
        __IOM uint8_t OSTDCR;          /*!< (@ 0x00000040) Oscillation Stop Detection Control Register                */

        struct
        {
            __IOM uint8_t OSTDIE : 1;  /*!< [0..0] Oscillation Stop Detection Interrupt Enable                        */
            uint8_t              : 6;
            __IOM uint8_t OSTDE  : 1;  /*!< [7..7] Oscillation Stop Detection Function Enable                         */
        } OSTDCR_b;
    };

    union
    {
        __IOM uint8_t OSTDSR;          /*!< (@ 0x00000041) Oscillation Stop Detection Status Register                 */

        struct
        {
            __IOM uint8_t OSTDF : 1;   /*!< [0..0] Oscillation Stop Detection Flag                                    */
            uint8_t             : 7;
        } OSTDSR_b;
    };
    __IM uint16_t RESERVED10;
    __IM uint32_t RESERVED11;

    union
    {
        __IOM uint16_t PLL2CCR;           /*!< (@ 0x00000048) PLL2 Clock Control Register                                */

        struct
        {
            __IOM uint16_t PL2IDIV   : 2; /*!< [1..0] PLL2 Input Frequency Division Ratio Select                         */
            uint16_t                 : 2;
            __IOM uint16_t PL2SRCSEL : 1; /*!< [4..4] PLL2 Clock Source Select                                           */
            uint16_t                 : 3;
            __IOM uint16_t PLL2MUL   : 6; /*!< [13..8] PLL2 Frequency Multiplication Factor Select                       */
            uint16_t                 : 2;
        } PLL2CCR_b;
    };

    union
    {
        __IOM uint8_t PLL2CR;          /*!< (@ 0x0000004A) PLL2 Control Register                                      */

        struct
        {
            __IOM uint8_t PLL2STP : 1; /*!< [0..0] PLL2 Stop Control                                                  */
            uint8_t               : 7;
        } PLL2CR_b;
    };
    __IM uint8_t  RESERVED12;
    __IM uint32_t RESERVED13;

    union
    {
        __IOM uint8_t SLCDSCKCR;         /*!< (@ 0x00000050) Segment LCD Source Clock Control Register                  */

        struct
        {
            __IOM uint8_t LCDSCKSEL : 3; /*!< [2..0] LCD Source Clock (LCDSRCCLK) Select                                */
            uint8_t                 : 4;
            __IOM uint8_t LCDSCKEN  : 1; /*!< [7..7] LCD Source Clock Out Enable                                        */
        } SLCDSCKCR_b;
    };
    __IM uint8_t RESERVED14;

    union
    {
        __IOM uint8_t EBCKOCR;         /*!< (@ 0x00000052) External Bus Clock Output Control Register                 */

        struct
        {
            __IOM uint8_t EBCKOEN : 1; /*!< [0..0] BCLK Pin Output Control                                            */
            uint8_t               : 7;
        } EBCKOCR_b;
    };

    union
    {
        __IOM uint8_t SDCKOCR;         /*!< (@ 0x00000053) SDRAM Clock Output Control Register                        */

        struct
        {
            __IOM uint8_t SDCKOEN : 1; /*!< [0..0] SDCLK Pin Output Control                                           */
            uint8_t               : 7;
        } SDCKOCR_b;
    };
    __IM uint32_t RESERVED15[3];
    __IM uint8_t  RESERVED16;

    union
    {
        __IOM uint8_t MOCOUTCR;         /*!< (@ 0x00000061) MOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t MOCOUTRM : 8; /*!< [7..0] MOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original MOCO
                                         *   trimming bits                                                             */
        } MOCOUTCR_b;
    };

    union
    {
        __IOM uint8_t HOCOUTCR;         /*!< (@ 0x00000062) HOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t HOCOUTRM : 8; /*!< [7..0] HOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original HOCO
                                         *   trimming bits                                                             */
        } HOCOUTCR_b;
    };
    __IM uint8_t  RESERVED17;
    __IM uint32_t RESERVED18[2];

    union
    {
        __IOM uint8_t USBCKDIVCR;       /*!< (@ 0x0000006C) USB Clock Division Control Register                        */

        struct
        {
            __IOM uint8_t USBCKDIV : 3; /*!< [2..0] USB Clock (USBCLK) Division Select                                 */
            uint8_t                : 5;
        } USBCKDIVCR_b;
    };

    union
    {
        __IOM uint8_t OCTACKDIVCR;       /*!< (@ 0x0000006D) Octal-SPI Clock Division Control Register                  */

        struct
        {
            __IOM uint8_t OCTACKDIV : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Division Select                          */
            uint8_t                 : 5;
        } OCTACKDIVCR_b;
    };
    __IM uint16_t RESERVED19;
    __IM uint32_t RESERVED20;

    union
    {
        __IOM uint8_t USBCKCR;           /*!< (@ 0x00000074) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCKSEL  : 3; /*!< [2..0] USB Clock (USBCLK) Source Select                                   */
            uint8_t                 : 3;
            __IOM uint8_t USBCKSREQ : 1; /*!< [6..6] USB Clock (USBCLK) Switching Request                               */
            __IM uint8_t  USBCKSRDY : 1; /*!< [7..7] USB Clock (USBCLK) Switching Ready state flag                      */
        } USBCKCR_b;
    };

    union
    {
        __IOM uint8_t OCTACKCR;           /*!< (@ 0x00000075) Octal-SPI Clock Control Register                           */

        struct
        {
            __IOM uint8_t OCTACKSEL  : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Source Select                            */
            uint8_t                  : 3;
            __IOM uint8_t OCTACKSREQ : 1; /*!< [6..6] Octal-SPI Clock (OCTACLK) Switching Request                        */
            __IM uint8_t  OCTACKSRDY : 1; /*!< [7..7] Octal-SPI Clock (OCTACLK) Switching Ready state flag               */
        } OCTACKCR_b;
    };
    __IM uint16_t RESERVED21;
    __IM uint32_t RESERVED22[4];

    union
    {
        __IOM uint32_t SNZREQCR1;         /*!< (@ 0x00000088) Snooze Request Control Register 1                          */

        struct
        {
            __IOM uint32_t SNZREQEN0 : 1; /*!< [0..0] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN1 : 1; /*!< [1..1] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN2 : 1; /*!< [2..2] Enable AGT3 underflow snooze request                               */
            uint32_t                 : 29;
        } SNZREQCR1_b;
    };
    __IM uint32_t RESERVED23;
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint8_t SNZCR;            /*!< (@ 0x00000092) Snooze Control Register                                    */

        struct
        {
            __IOM uint8_t RXDREQEN : 1; /*!< [0..0] RXD0 Snooze Request Enable NOTE: Do not set to 1 other
                                         *   than in asynchronous mode.                                                */
            __IOM uint8_t SNZDTCEN : 1; /*!< [1..1] DTC Enable in Snooze Mode                                          */
            uint8_t                : 5;
            __IOM uint8_t SNZE     : 1; /*!< [7..7] Snooze Mode Enable                                                 */
        } SNZCR_b;
    };
    __IM uint8_t RESERVED25;

    union
    {
        __IOM uint8_t SNZEDCR;           /*!< (@ 0x00000094) Snooze End Control Register                                */

        struct
        {
            __IOM uint8_t AGT1UNFED : 1; /*!< [0..0] AGT1 underflow Snooze End Enable                                   */
            __IOM uint8_t DTCZRED   : 1; /*!< [1..1] Last DTC transmission completion Snooze End Enable                 */
            __IOM uint8_t DTCNZRED  : 1; /*!< [2..2] Not Last DTC transmission completion Snooze End Enable             */
            __IOM uint8_t AD0MATED  : 1; /*!< [3..3] AD compare match 0 Snooze End Enable                               */
            __IOM uint8_t AD0UMTED  : 1; /*!< [4..4] AD compare mismatch 0 Snooze End Enable                            */
            __IOM uint8_t AD1MATED  : 1; /*!< [5..5] AD compare match 1 Snooze End Enable                               */
            __IOM uint8_t AD1UMTED  : 1; /*!< [6..6] AD compare mismatch 1 Snooze End Enable                            */
            __IOM uint8_t SCI0UMTED : 1; /*!< [7..7] SCI0 address unmatch Snooze End EnableNote: Do not set
                                          *   to 1 other than in asynchronous mode.                                     */
        } SNZEDCR_b;
    };

    union
    {
        __IOM uint8_t SNZEDCR1;          /*!< (@ 0x00000095) Snooze End Control Register 1                              */

        struct
        {
            __IOM uint8_t AGT3UNFED : 1; /*!< [0..0] AGT3 underflow Snooze End Enable                                   */
            uint8_t                 : 7;
        } SNZEDCR1_b;
    };
    __IM uint16_t RESERVED26;

    union
    {
        __IOM uint32_t SNZREQCR;           /*!< (@ 0x00000098) Snooze Request Control Register                            */

        struct
        {
            __IOM uint32_t SNZREQEN0  : 1; /*!< [0..0] Snooze Request Enable 0Enable IRQ 0 pin snooze request             */
            __IOM uint32_t SNZREQEN1  : 1; /*!< [1..1] Snooze Request Enable 0Enable IRQ 1 pin snooze request             */
            __IOM uint32_t SNZREQEN2  : 1; /*!< [2..2] Snooze Request Enable 0Enable IRQ 2 pin snooze request             */
            __IOM uint32_t SNZREQEN3  : 1; /*!< [3..3] Snooze Request Enable 0Enable IRQ 3 pin snooze request             */
            __IOM uint32_t SNZREQEN4  : 1; /*!< [4..4] Snooze Request Enable 0Enable IRQ 4 pin snooze request             */
            __IOM uint32_t SNZREQEN5  : 1; /*!< [5..5] Snooze Request Enable 0Enable IRQ 5 pin snooze request             */
            __IOM uint32_t SNZREQEN6  : 1; /*!< [6..6] Snooze Request Enable 0Enable IRQ 6 pin snooze request             */
            __IOM uint32_t SNZREQEN7  : 1; /*!< [7..7] Snooze Request Enable 0Enable IRQ 7 pin snooze request             */
            __IOM uint32_t SNZREQEN8  : 1; /*!< [8..8] Snooze Request Enable 0Enable IRQ 8 pin snooze request             */
            __IOM uint32_t SNZREQEN9  : 1; /*!< [9..9] Snooze Request Enable 0Enable IRQ 9 pin snooze request             */
            __IOM uint32_t SNZREQEN10 : 1; /*!< [10..10] Snooze Request Enable 0Enable IRQ 10 pin snooze request          */
            __IOM uint32_t SNZREQEN11 : 1; /*!< [11..11] Snooze Request Enable 0Enable IRQ 11 pin snooze request          */
            __IOM uint32_t SNZREQEN12 : 1; /*!< [12..12] Snooze Request Enable 0Enable IRQ 12 pin snooze request          */
            __IOM uint32_t SNZREQEN13 : 1; /*!< [13..13] Snooze Request Enable 0Enable IRQ 13 pin snooze request          */
            __IOM uint32_t SNZREQEN14 : 1; /*!< [14..14] Snooze Request Enable 0Enable IRQ 14 pin snooze request          */
            __IOM uint32_t SNZREQEN15 : 1; /*!< [15..15] Snooze Request Enable 0Enable IRQ 15 pin snooze request          */
            uint32_t                  : 1;
            __IOM uint32_t SNZREQEN17 : 1; /*!< [17..17] Snooze Request Enable 17Enable KR snooze request                 */
            uint32_t                  : 4;
            __IOM uint32_t SNZREQEN22 : 1; /*!< [22..22] Snooze Request Enable 22Enable Comparator-HS0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN23 : 1; /*!< [23..23] Snooze Request Enable 23Enable Comparator-LP0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN24 : 1; /*!< [24..24] Snooze Request Enable 24Enable RTC alarm snooze request          */
            __IOM uint32_t SNZREQEN25 : 1; /*!< [25..25] Snooze Request Enable 25Enable RTC period snooze request         */
            uint32_t                  : 2;
            __IOM uint32_t SNZREQEN28 : 1; /*!< [28..28] Snooze Request Enable 28Enable AGT1 underflow snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN29 : 1; /*!< [29..29] Snooze Request Enable 29Enable AGT1 compare match A
                                            *   snooze request                                                            */
            __IOM uint32_t SNZREQEN30 : 1; /*!< [30..30] Snooze Request Enable 30Enable AGT1 compare match B
                                            *   snooze request                                                            */
            uint32_t : 1;
        } SNZREQCR_b;
    };
    __IM uint16_t RESERVED27;

    union
    {
        __IOM uint8_t FLSTOP;          /*!< (@ 0x0000009E) Flash Operation Control Register                           */

        struct
        {
            __IOM uint8_t FLSTOP : 1;  /*!< [0..0] Selecting ON/OFF of the Flash Memory Operation                     */
            uint8_t              : 3;
            __IOM uint8_t FLSTPF : 1;  /*!< [4..4] Flash Memory Operation Status Flag                                 */
            uint8_t              : 3;
        } FLSTOP_b;
    };

    union
    {
        __IOM uint8_t PSMCR;           /*!< (@ 0x0000009F) Power Save Memory Control Register                         */

        struct
        {
            __IOM uint8_t PSMC : 2;    /*!< [1..0] Power save memory control.                                         */
            uint8_t            : 6;
        } PSMCR_b;
    };

    union
    {
        __IOM uint8_t OPCCR;           /*!< (@ 0x000000A0) Operating Power Control Register                           */

        struct
        {
            __IOM uint8_t OPCM   : 2;  /*!< [1..0] Operating Power Control Mode Select                                */
            uint8_t              : 2;
            __IM uint8_t OPCMTSF : 1;  /*!< [4..4] Operating Power Control Mode Transition Status Flag                */
            uint8_t              : 3;
        } OPCCR_b;
    };
    __IM uint8_t RESERVED28;

    union
    {
        __IOM uint8_t MOSCWTCR;        /*!< (@ 0x000000A2) Main Clock Oscillator Wait Control Register                */

        struct
        {
            __IOM uint8_t MSTS : 4;    /*!< [3..0] Main clock oscillator wait time setting                            */
            uint8_t            : 4;
        } MOSCWTCR_b;
    };
    __IM uint8_t RESERVED29[2];

    union
    {
        __IOM uint8_t HOCOWTCR;        /*!< (@ 0x000000A5) High-speed on-chip oscillator wait control register        */

        struct
        {
            __IOM uint8_t HSTS : 3;    /*!< [2..0] HOCO wait time settingWaiting time (sec) = setting of
                                        *   the HSTS[2:0] bits/fLOCO(Trimmed) + 3/fLOC(Untrimmed)                     */
            uint8_t : 5;
        } HOCOWTCR_b;
    };
    __IM uint16_t RESERVED30[2];

    union
    {
        __IOM uint8_t SOPCCR;          /*!< (@ 0x000000AA) Sub Operating Power Control Register                       */

        struct
        {
            __IOM uint8_t SOPCM   : 1; /*!< [0..0] Sub Operating Power Control Mode Select                            */
            uint8_t               : 3;
            __IM uint8_t SOPCMTSF : 1; /*!< [4..4] Sub Operating Power Control Mode Transition Status Flag            */
            uint8_t               : 3;
        } SOPCCR_b;
    };
    __IM uint8_t  RESERVED31;
    __IM uint32_t RESERVED32[5];

    union
    {
        __IOM uint16_t RSTSR1;         /*!< (@ 0x000000C0) Reset Status Register 1                                    */

        struct
        {
            __IOM uint16_t IWDTRF : 1; /*!< [0..0] Independent Watchdog Timer Reset Detect FlagNOTE: Writable
                                        *   only to clear the flag. Confirm the value is 1 and then
                                        *   write 0.                                                                  */
            __IOM uint16_t WDTRF : 1;  /*!< [1..1] Watchdog Timer Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t SWRF : 1;   /*!< [2..2] Software Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            uint16_t             : 5;
            __IOM uint16_t RPERF : 1;  /*!< [8..8] RAM Parity Error Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t REERF : 1;  /*!< [9..9] RAM ECC Error Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t BUSSRF : 1; /*!< [10..10] Bus Slave MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t BUSMRF : 1; /*!< [11..11] Bus Master MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t SPERF : 1;  /*!< [12..12] SP Error Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint16_t TZERF : 1;  /*!< [13..13] Trust Zone Error Reset Detect Flag                               */
            uint16_t             : 1;
            __IOM uint16_t CPERF : 1;  /*!< [15..15] Cache Parity Error Reset Detect Flag                             */
        } RSTSR1_b;
    };
    __IM uint16_t RESERVED33;
    __IM uint32_t RESERVED34[3];

    union
    {
        __IOM uint8_t USBCKCR_ALT;       /*!< (@ 0x000000D0) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCLKSEL : 1; /*!< [0..0] The USBCLKSEL bit selects the source of the USB clock
                                          *   (UCLK).                                                                   */
            uint8_t : 7;
        } USBCKCR_ALT_b;
    };

    union
    {
        __IOM uint8_t SDADCCKCR;          /*!< (@ 0x000000D1) 24-bit Sigma-Delta A/D Converter Clock Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t SDADCCKSEL : 1; /*!< [0..0] 24-bit Sigma-Delta A/D Converter Clock Select                      */
            uint8_t                  : 6;
            __IOM uint8_t SDADCCKEN  : 1; /*!< [7..7] 24-bit Sigma-Delta A/D Converter Clock Enable                      */
        } SDADCCKCR_b;
    };
    __IM uint16_t RESERVED35;
    __IM uint32_t RESERVED36[3];

    union
    {
        __IOM uint8_t LVD1CR1;         /*!< (@ 0x000000E0) Voltage Monitor 1 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD1CR1_b;
    };

    union
    {
        __IOM uint8_t LVD1SR;          /*!< (@ 0x000000E1) Voltage Monitor 1 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD1SR_b;
    };

    union
    {
        __IOM uint8_t LVD2CR1;         /*!< (@ 0x000000E2) Voltage Monitor 2 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD2CR1_b;
    };

    union
    {
        __IOM uint8_t LVD2SR;          /*!< (@ 0x000000E3) Voltage Monitor 2 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD2SR_b;
    };
    __IM uint32_t RESERVED37[183];

    union
    {
        __IOM uint32_t CGFSAR;           /*!< (@ 0x000003C0) Clock Generation Function Security Attribute
                                          *                  Register                                                   */

        struct
        {
            __IOM uint32_t NONSEC00 : 1; /*!< [0..0] Non Secure Attribute bit 00                                        */
            uint32_t                : 1;
            __IOM uint32_t NONSEC02 : 1; /*!< [2..2] Non Secure Attribute bit 02                                        */
            __IOM uint32_t NONSEC03 : 1; /*!< [3..3] Non Secure Attribute bit 03                                        */
            __IOM uint32_t NONSEC04 : 1; /*!< [4..4] Non Secure Attribute bit 04                                        */
            __IOM uint32_t NONSEC05 : 1; /*!< [5..5] Non Secure Attribute bit 05                                        */
            __IOM uint32_t NONSEC06 : 1; /*!< [6..6] Non Secure Attribute bit 06                                        */
            __IOM uint32_t NONSEC07 : 1; /*!< [7..7] Non Secure Attribute bit 07                                        */
            __IOM uint32_t NONSEC08 : 1; /*!< [8..8] Non Secure Attribute bit 08                                        */
            __IOM uint32_t NONSEC09 : 1; /*!< [9..9] Non Secure Attribute bit 09                                        */
            uint32_t                : 1;
            __IOM uint32_t NONSEC11 : 1; /*!< [11..11] Non Secure Attribute bit 11                                      */
            __IOM uint32_t NONSEC12 : 1; /*!< [12..12] Non Secure Attribute bit 12                                      */
            uint32_t                : 3;
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            uint32_t                : 14;
        } CGFSAR_b;
    };
    __IM uint32_t RESERVED38;

    union
    {
        __IOM uint32_t LPMSAR;          /*!< (@ 0x000003C8) Low Power Mode Security Attribution Register               */

        struct
        {
            __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC4 : 1; /*!< [4..4] Non Secure Attribute bit 4                                         */
            uint32_t               : 3;
            __IOM uint32_t NONSEC8 : 1; /*!< [8..8] Non Secure Attribute bit 8                                         */
            __IOM uint32_t NONSEC9 : 1; /*!< [9..9] Non Secure Attribute bit 9                                         */
            uint32_t               : 22;
        } LPMSAR_b;
    };

    union
    {
        union
        {
            __IOM uint32_t LVDSAR;          /*!< (@ 0x000003CC) Low Voltage Detection Security Attribution Register        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                uint32_t               : 30;
            } LVDSAR_b;
        };

        union
        {
            __IOM uint32_t RSTSAR;          /*!< (@ 0x000003CC) Reset Security Attribution Register                        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
                uint32_t               : 29;
            } RSTSAR_b;
        };
    };

    union
    {
        __IOM uint32_t BBFSAR;           /*!< (@ 0x000003D0) Battery Backup Function Security Attribute Register        */

        struct
        {
            __IOM uint32_t NONSEC0  : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            __IOM uint32_t NONSEC1  : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
            __IOM uint32_t NONSEC2  : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t                : 13;
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            __IOM uint32_t NONSEC18 : 1; /*!< [18..18] Non Secure Attribute bit 18                                      */
            __IOM uint32_t NONSEC19 : 1; /*!< [19..19] Non Secure Attribute bit 19                                      */
            __IOM uint32_t NONSEC20 : 1; /*!< [20..20] Non Secure Attribute bit 20                                      */
            __IOM uint32_t NONSEC21 : 1; /*!< [21..21] Non Secure Attribute bit 21                                      */
            __IOM uint32_t NONSEC22 : 1; /*!< [22..22] Non Secure Attribute bit 22                                      */
            __IOM uint32_t NONSEC23 : 1; /*!< [23..23] Non Secure Attribute bit 23                                      */
            uint32_t                : 8;
        } BBFSAR_b;
    };
    __IM uint32_t RESERVED39[3];

    union
    {
        __IOM uint32_t DPFSAR;          /*!< (@ 0x000003E0) Deep Standby Interrupt Factor Security Attribution
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t DPFSA0 : 1;  /*!< [0..0] Deep Standby Interrupt Factor Security Attribute bit
                                         *   0                                                                         */
            __IOM uint32_t DPFSA1 : 1;  /*!< [1..1] Deep Standby Interrupt Factor Security Attribute bit
                                         *   1                                                                         */
            __IOM uint32_t DPFSA2 : 1;  /*!< [2..2] Deep Standby Interrupt Factor Security Attribute bit
                                         *   2                                                                         */
            __IOM uint32_t DPFSA3 : 1;  /*!< [3..3] Deep Standby Interrupt Factor Security Attribute bit
                                         *   3                                                                         */
            __IOM uint32_t DPFSA4 : 1;  /*!< [4..4] Deep Standby Interrupt Factor Security Attribute bit
                                         *   4                                                                         */
            __IOM uint32_t DPFSA5 : 1;  /*!< [5..5] Deep Standby Interrupt Factor Security Attribute bit
                                         *   5                                                                         */
            __IOM uint32_t DPFSA6 : 1;  /*!< [6..6] Deep Standby Interrupt Factor Security Attribute bit
                                         *   6                                                                         */
            __IOM uint32_t DPFSA7 : 1;  /*!< [7..7] Deep Standby Interrupt Factor Security Attribute bit
                                         *   7                                                                         */
            __IOM uint32_t DPFSA8 : 1;  /*!< [8..8] Deep Standby Interrupt Factor Security Attribute bit
                                         *   8                                                                         */
            __IOM uint32_t DPFSA9 : 1;  /*!< [9..9] Deep Standby Interrupt Factor Security Attribute bit
                                         *   9                                                                         */
            __IOM uint32_t DPFSA10 : 1; /*!< [10..10] Deep Standby Interrupt Factor Security Attribute bit
                                         *   10                                                                        */
            __IOM uint32_t DPFSA11 : 1; /*!< [11..11] Deep Standby Interrupt Factor Security Attribute bit
                                         *   11                                                                        */
            __IOM uint32_t DPFSA12 : 1; /*!< [12..12] Deep Standby Interrupt Factor Security Attribute bit
                                         *   12                                                                        */
            __IOM uint32_t DPFSA13 : 1; /*!< [13..13] Deep Standby Interrupt Factor Security Attribute bit
                                         *   13                                                                        */
            __IOM uint32_t DPFSA14 : 1; /*!< [14..14] Deep Standby Interrupt Factor Security Attribute bit
                                         *   14                                                                        */
            __IOM uint32_t DPFSA15 : 1; /*!< [15..15] Deep Standby Interrupt Factor Security Attribute bit
                                         *   15                                                                        */
            __IOM uint32_t DPFSA16 : 1; /*!< [16..16] Deep Standby Interrupt Factor Security Attribute bit
                                         *   16                                                                        */
            __IOM uint32_t DPFSA17 : 1; /*!< [17..17] Deep Standby Interrupt Factor Security Attribute bit
                                         *   17                                                                        */
            __IOM uint32_t DPFSA18 : 1; /*!< [18..18] Deep Standby Interrupt Factor Security Attribute bit
                                         *   18                                                                        */
            __IOM uint32_t DPFSA19 : 1; /*!< [19..19] Deep Standby Interrupt Factor Security Attribute bit
                                         *   19                                                                        */
            __IOM uint32_t DPFSA20 : 1; /*!< [20..20] Deep Standby Interrupt Factor Security Attribute bit
                                         *   20                                                                        */
            uint32_t               : 3;
            __IOM uint32_t DPFSA24 : 1; /*!< [24..24] Deep Standby Interrupt Factor Security Attribute bit
                                         *   24                                                                        */
            uint32_t               : 1;
            __IOM uint32_t DPFSA26 : 1; /*!< [26..26] Deep Standby Interrupt Factor Security Attribute bit
                                         *   26                                                                        */
            __IOM uint32_t DPFSA27 : 1; /*!< [27..27] Deep Standby Interrupt Factor Security Attribute bit
                                         *   27                                                                        */
            uint32_t : 4;
        } DPFSAR_b;
    };
    __IM uint32_t RESERVED40[6];
    __IM uint16_t RESERVED41;

    union
    {
        __IOM uint16_t PRCR;           /*!< (@ 0x000003FE) Protect Register                                           */

        struct
        {
            __IOM uint16_t PRC0 : 1;   /*!< [0..0] Enables writing to the registers related to the clock
                                        *   generation circuit.                                                       */
            __IOM uint16_t PRC1 : 1;   /*!< [1..1] Enables writing to the registers related to the operating
                                        *   modes, the low power consumption modes and the battery
                                        *   backup function.                                                          */
            uint16_t            : 1;
            __IOM uint16_t PRC3 : 1;   /*!< [3..3] Enables writing to the registers related to the LVD.               */
            __IOM uint16_t PRC4 : 1;   /*!< [4..4] PRC4                                                               */
            uint16_t            : 3;
            __OM uint16_t PRKEY : 8;   /*!< [15..8] PRKEY Key Code                                                    */
        } PRCR_b;
    };

    union
    {
        __IOM uint8_t DPSBYCR;         /*!< (@ 0x00000400) Deep Standby Control Register                              */

        struct
        {
            __IOM uint8_t DEEPCUT : 2; /*!< [1..0] Power-Supply Control                                               */
            uint8_t               : 4;
            __IOM uint8_t IOKEEP  : 1; /*!< [6..6] I/O Port Retention                                                 */
            __IOM uint8_t DPSBY   : 1; /*!< [7..7] Deep Software Standby                                              */
        } DPSBYCR_b;
    };

    union
    {
        __IOM uint8_t DPSWCR;          /*!< (@ 0x00000401) Deep Standby Wait Control Register                         */

        struct
        {
            __IOM uint8_t WTSTS : 6;   /*!< [5..0] Deep Software Wait Standby Time Setting Bit                        */
            uint8_t             : 2;
        } DPSWCR_b;
    };

    union
    {
        __IOM uint8_t DPSIER0;         /*!< (@ 0x00000402) Deep Standby Interrupt Enable Register 0                   */

        struct
        {
            __IOM uint8_t DIRQ0E : 1;  /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ1E : 1;  /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ2E : 1;  /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ3E : 1;  /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ4E : 1;  /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ5E : 1;  /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ6E : 1;  /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ7E : 1;  /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER0_b;
    };

    union
    {
        __IOM uint8_t DPSIER1;         /*!< (@ 0x00000403) Deep Standby Interrupt Enable Register 1                   */

        struct
        {
            __IOM uint8_t DIRQ8E  : 1; /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ9E  : 1; /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ10E : 1; /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ11E : 1; /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ12E : 1; /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ13E : 1; /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ14E : 1; /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ15E : 1; /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER1_b;
    };

    union
    {
        __IOM uint8_t DPSIER2;          /*!< (@ 0x00000404) Deep Standby Interrupt Enable Register 2                   */

        struct
        {
            __IOM uint8_t DLVD1IE  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DLVD2IE  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DTRTCIIE : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Signal Enable           */
            __IOM uint8_t DRTCAIE  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Signal Enable              */
            __IOM uint8_t DNMIE    : 1; /*!< [4..4] NMI Pin Enable                                                     */
            uint8_t                : 3;
        } DPSIER2_b;
    };

    union
    {
        __IOM uint8_t DPSIER3;          /*!< (@ 0x00000405) Deep Standby Interrupt Enable Register 3                   */

        struct
        {
            __IOM uint8_t DUSBFSIE : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DUSBHSIE : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DAGT1IE  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Signal Enable                   */
            __IOM uint8_t DAGT3IE  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Signal Enable                   */
            uint8_t                : 4;
        } DPSIER3_b;
    };

    union
    {
        __IOM uint8_t DPSIFR0;         /*!< (@ 0x00000406) Deep Standby Interrupt Flag Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0F : 1;  /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ1F : 1;  /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ2F : 1;  /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ3F : 1;  /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ4F : 1;  /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ5F : 1;  /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ6F : 1;  /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ7F : 1;  /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR0_b;
    };

    union
    {
        __IOM uint8_t DPSIFR1;         /*!< (@ 0x00000407) Deep Standby Interrupt Flag Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ8F  : 1; /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ9F  : 1; /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ10F : 1; /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ11F : 1; /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ12F : 1; /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ13F : 1; /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ14F : 1; /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ15F : 1; /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR1_b;
    };

    union
    {
        __IOM uint8_t DPSIFR2;          /*!< (@ 0x00000408) Deep Standby Interrupt Flag Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IF  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DLVD2IF  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DTRTCIIF : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Flag                    */
            __IOM uint8_t DRTCAIF  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Flag                       */
            __IOM uint8_t DNMIF    : 1; /*!< [4..4] NMI Pin Deep Standby Cancel Flag                                   */
            uint8_t                : 3;
        } DPSIFR2_b;
    };

    union
    {
        __IOM uint8_t DPSIFR3;          /*!< (@ 0x00000409) Deep Standby Interrupt Flag Register 3                     */

        struct
        {
            __IOM uint8_t DUSBFSIF : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DUSBHSIF : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DAGT1IF  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Flag                            */
            __IOM uint8_t DAGT3IF  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Flag                            */
            uint8_t                : 4;
        } DPSIFR3_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR0;        /*!< (@ 0x0000040A) Deep Standby Interrupt Edge Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR0_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR1;        /*!< (@ 0x0000040B) Deep Standby Interrupt Edge Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR1_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR2;         /*!< (@ 0x0000040C) Deep Standby Interrupt Edge Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IEG : 1; /*!< [0..0] LVD1 Edge Select                                                   */
            __IOM uint8_t DLVD2IEG : 1; /*!< [1..1] LVD2 Edge Select                                                   */
            uint8_t                : 2;
            __IOM uint8_t DNMIEG   : 1; /*!< [4..4] NMI Pin Edge Select                                                */
            uint8_t                : 3;
        } DPSIEGR2_b;
    };
    __IM uint8_t RESERVED42;

    union
    {
        __IOM uint8_t SYOCDCR;         /*!< (@ 0x0000040E) System Control OCD Control Register                        */

        struct
        {
            __IOM uint8_t DOCDF : 1;   /*!< [0..0] Deep Standby OCD flag                                              */
            uint8_t             : 6;
            __IOM uint8_t DBGEN : 1;   /*!< [7..7] Debugger Enable bit                                                */
        } SYOCDCR_b;
    };

    union
    {
        __IOM uint8_t STCONR;          /*!< (@ 0x0000040F) Standby Condition Register                                 */

        struct
        {
            __IOM uint8_t STCON : 2;   /*!< [1..0] SSTBY condition bit                                                */
            uint8_t             : 6;
        } STCONR_b;
    };

    union
    {
        __IOM uint8_t RSTSR0;          /*!< (@ 0x00000410) Reset Status Register 0                                    */

        struct
        {
            __IOM uint8_t PORF : 1;    /*!< [0..0] Power-On Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint8_t LVD0RF : 1;  /*!< [1..1] Voltage Monitor 0 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD1RF : 1;  /*!< [2..2] Voltage Monitor 1 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD2RF : 1;  /*!< [3..3] Voltage Monitor 2 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            uint8_t               : 3;
            __IOM uint8_t DPSRSTF : 1; /*!< [7..7] Deep Software Standby Reset FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
        } RSTSR0_b;
    };

    union
    {
        __IOM uint8_t RSTSR2;          /*!< (@ 0x00000411) Reset Status Register 2                                    */

        struct
        {
            __IOM uint8_t CWSF : 1;    /*!< [0..0] Cold/Warm Start Determination Flag                                 */
            uint8_t            : 7;
        } RSTSR2_b;
    };
    __IM uint8_t RESERVED43;

    union
    {
        __IOM uint8_t MOMCR;           /*!< (@ 0x00000413) Main Clock Oscillator Mode Oscillation Control
                                        *                  Register                                                   */

        struct
        {
            uint8_t                 : 3;
            __IOM uint8_t MODRV1    : 1; /*!< [3..3] Main Clock Oscillator Drive Capability 1 Switching                 */
            __IOM uint8_t MODRV0    : 2; /*!< [5..4] Main Clock Oscillator Drive Capability 0 Switching                 */
            __IOM uint8_t MOSEL     : 1; /*!< [6..6] Main Clock Oscillator Switching                                    */
            __IOM uint8_t AUTODRVEN : 1; /*!< [7..7] Main Clock Oscillator Drive Capability Auto Switching
                                          *   Enable                                                                    */
        } MOMCR_b;
    };
    __IM uint16_t RESERVED44;

    union
    {
        __IOM uint8_t FWEPROR;         /*!< (@ 0x00000416) Flash P/E Protect Register                                 */

        struct
        {
            __IOM uint8_t FLWE : 2;    /*!< [1..0] Flash Programming and Erasure                                      */
            uint8_t            : 6;
        } FWEPROR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t LVCMPCR;     /*!< (@ 0x00000417) Voltage Monitor Circuit Control Register                   */

            struct
            {
                uint8_t             : 5;
                __IOM uint8_t LVD1E : 1; /*!< [5..5] Voltage Detection 1 Enable                                         */
                __IOM uint8_t LVD2E : 1; /*!< [6..6] Voltage Detection 2 Enable                                         */
                uint8_t             : 1;
            } LVCMPCR_b;
        };

        union
        {
            __IOM uint8_t LVD1CMPCR;       /*!< (@ 0x00000417) Voltage Monitoring 1 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 2;
                __IOM uint8_t LVD1E : 1;   /*!< [7..7] Voltage Detection 1 Enable                                         */
            } LVD1CMPCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t LVDLVLR;         /*!< (@ 0x00000418) Voltage Detection Level Select Register                    */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
                __IOM uint8_t LVD2LVL : 3; /*!< [7..5] Voltage Detection 2 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
            } LVDLVLR_b;
        };

        union
        {
            __IOM uint8_t LVD2CMPCR;       /*!< (@ 0x00000418) Voltage Monitoring 2 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD2LVL : 3; /*!< [2..0] Voltage Detection 2 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 4;
                __IOM uint8_t LVD2E : 1;   /*!< [7..7] Voltage Detection 2 Enable                                         */
            } LVD2CMPCR_b;
        };
    };
    __IM uint8_t RESERVED45;

    union
    {
        __IOM uint8_t LVD1CR0;         /*!< (@ 0x0000041A) Voltage Monitor 1 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD1CR0_b;
    };

    union
    {
        __IOM uint8_t LVD2CR0;         /*!< (@ 0x0000041B) Voltage Monitor 2 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD2CR0_b;
    };
    __IM uint8_t RESERVED46;

    union
    {
        __IOM uint8_t VBATTMNSELR;        /*!< (@ 0x0000041D) Battery Backup Voltage Monitor Function Select
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBATTMNSEL : 1; /*!< [0..0] VBATT Low Voltage Detect Function Select Bit                       */
            uint8_t                  : 7;
        } VBATTMNSELR_b;
    };

    union
    {
        __IM uint8_t VBATTMONR;        /*!< (@ 0x0000041E) Battery Backup Voltage Monitor Register                    */

        struct
        {
            __IM uint8_t VBATTMON : 1; /*!< [0..0] VBATT Voltage Monitor Bit                                          */
            uint8_t               : 7;
        } VBATTMONR_b;
    };

    union
    {
        __IOM uint8_t VBTCR1;           /*!< (@ 0x0000041F) VBATT Control Register1                                    */

        struct
        {
            __IOM uint8_t BPWSWSTP : 1; /*!< [0..0] Battery Power supply Switch Stop                                   */
            uint8_t                : 7;
        } VBTCR1_b;
    };
    __IM uint32_t RESERVED47[8];

    union
    {
        __IOM uint8_t DCDCCTL;         /*!< (@ 0x00000440) DCDC/LDO Control Register                                  */

        struct
        {
            __IOM uint8_t DCDCON  : 1; /*!< [0..0] LDO/DCDC on/off Control bit                                        */
            __IOM uint8_t OCPEN   : 1; /*!< [1..1] DCDC OCP Function Enable bit                                       */
            uint8_t               : 2;
            __IOM uint8_t STOPZA  : 1; /*!< [4..4] DCDC IO Buffer Power Control bit                                   */
            __IOM uint8_t LCBOOST : 1; /*!< [5..5] LDO LCBOOST Mode Control bit                                       */
            __IOM uint8_t FST     : 1; /*!< [6..6] DCDC Fast Startup                                                  */
            __IOM uint8_t PD      : 1; /*!< [7..7] DCDC VREF Generate Disable bit                                     */
        } DCDCCTL_b;
    };

    union
    {
        __IOM uint8_t VCCSEL;          /*!< (@ 0x00000441) Voltage Level Selection Control Register                   */

        struct
        {
            __IOM uint8_t VCCSEL : 2;  /*!< [1..0] DCDC Working Voltage Level Selection                               */
            uint8_t              : 6;
        } VCCSEL_b;
    };
    __IM uint16_t RESERVED48;
    __IM uint32_t RESERVED49[15];

    union
    {
        __IOM uint8_t SOSCCR;          /*!< (@ 0x00000480) Sub-Clock Oscillator Control Register                      */

        struct
        {
            __IOM uint8_t SOSTP : 1;   /*!< [0..0] Sub-Clock Oscillator Stop                                          */
            uint8_t             : 7;
        } SOSCCR_b;
    };

    union
    {
        __IOM uint8_t SOMCR;           /*!< (@ 0x00000481) Sub Clock Oscillator Mode Control Register                 */

        struct
        {
            __IOM uint8_t SODRV : 2;   /*!< [1..0] Sub-Clock Oscillator Drive Capability Switching                    */
            uint8_t             : 6;
        } SOMCR_b;
    };
    __IM uint16_t RESERVED50;
    __IM uint32_t RESERVED51[3];

    union
    {
        __IOM uint8_t LOCOCR;          /*!< (@ 0x00000490) Low-Speed On-Chip Oscillator Control Register              */

        struct
        {
            __IOM uint8_t LCSTP : 1;   /*!< [0..0] LOCO Stop                                                          */
            uint8_t             : 7;
        } LOCOCR_b;
    };
    __IM uint8_t RESERVED52;

    union
    {
        __IOM uint8_t LOCOUTCR;         /*!< (@ 0x00000492) LOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t LOCOUTRM : 8; /*!< [7..0] LOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original LOCO
                                         *   trimming bits                                                             */
        } LOCOUTCR_b;
    };
    __IM uint8_t  RESERVED53;
    __IM uint32_t RESERVED54[7];

    union
    {
        __IOM uint8_t VBTCR2;          /*!< (@ 0x000004B0) VBATT Control Register2                                    */

        struct
        {
            uint8_t                 : 4;
            __IOM uint8_t VBTLVDEN  : 1; /*!< [4..4] VBATT Pin Low Voltage Detect Enable Bit                            */
            uint8_t                 : 1;
            __IOM uint8_t VBTLVDLVL : 2; /*!< [7..6] VBATT Pin Voltage Low Voltage Detect Level Select Bit              */
        } VBTCR2_b;
    };

    union
    {
        __IOM uint8_t VBTSR;           /*!< (@ 0x000004B1) VBATT Status Register                                      */

        struct
        {
            __IOM uint8_t VBTRDF  : 1; /*!< [0..0] VBAT_R Reset Detect Flag                                           */
            __IOM uint8_t VBTBLDF : 1; /*!< [1..1] VBATT Battery Low voltage Detect Flag                              */
            uint8_t               : 2;
            __IM uint8_t VBTRVLD  : 1; /*!< [4..4] VBATT_R Valid                                                      */
            uint8_t               : 3;
        } VBTSR_b;
    };

    union
    {
        __IOM uint8_t VBTCMPCR;        /*!< (@ 0x000004B2) VBATT Comparator Control Register                          */

        struct
        {
            __IOM uint8_t VBTCMPE : 1; /*!< [0..0] VBATT pin low voltage detect circuit output enable                 */
            uint8_t               : 7;
        } VBTCMPCR_b;
    };
    __IM uint8_t RESERVED55;

    union
    {
        __IOM uint8_t VBTLVDICR;          /*!< (@ 0x000004B4) VBATT Pin Low Voltage Detect Interrupt Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBTLVDIE   : 1; /*!< [0..0] VBATT Pin Low Voltage Detect Interrupt Enable bit                  */
            __IOM uint8_t VBTLVDISEL : 1; /*!< [1..1] Pin Low Voltage Detect Interrupt Select bit                        */
            uint8_t                  : 6;
        } VBTLVDICR_b;
    };
    __IM uint8_t RESERVED56;

    union
    {
        __IOM uint8_t VBTWCTLR;        /*!< (@ 0x000004B6) VBATT Wakeup function Control Register                     */

        struct
        {
            __IOM uint8_t VWEN : 1;    /*!< [0..0] VBATT wakeup enable                                                */
            uint8_t            : 7;
        } VBTWCTLR_b;
    };
    __IM uint8_t RESERVED57;

    union
    {
        __IOM uint8_t VBTWCH0OTSR;     /*!< (@ 0x000004B8) VBATT Wakeup I/O 0 Output Trigger Select Register          */

        struct
        {
            uint8_t                  : 1;
            __IOM uint8_t CH0VCH1TE  : 1; /*!< [1..1] VBATWIO0 Output VBATWIO1 Trigger Enable                            */
            __IOM uint8_t CH0VCH2TE  : 1; /*!< [2..2] VBATWIO0 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH0VRTCTE  : 1; /*!< [3..3] VBATWIO0 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH0VRTCATE : 1; /*!< [4..4] VBATWIO0 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH0VAGTUTE : 1; /*!< [5..5] CH0 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH0OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH1OTSR;        /*!< (@ 0x000004B9) VBATT Wakeup I/O 1 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH1VCH0TE  : 1; /*!< [0..0] VBATWIO1 Output VBATWIO0 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH1VCH2TE  : 1; /*!< [2..2] VBATWIO1 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH1VRTCTE  : 1; /*!< [3..3] VBATWIO1 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH1VRTCATE : 1; /*!< [4..4] VBATWIO1 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH1VAGTUTE : 1; /*!< [5..5] CH1 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH1OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH2OTSR;        /*!< (@ 0x000004BA) VBATT Wakeup I/O 2 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH2VCH0TE  : 1; /*!< [0..0] VBATWIO2 Output VBATWIO0 Trigger Enable                            */
            __IOM uint8_t CH2VCH1TE  : 1; /*!< [1..1] VBATWIO2 Output VBATWIO1 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH2VRTCTE  : 1; /*!< [3..3] VBATWIO2 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH2VRTCATE : 1; /*!< [4..4] VBATWIO2 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH2VAGTUTE : 1; /*!< [5..5] CH2 Output AGT(CH2) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH2OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTICTLR;         /*!< (@ 0x000004BB) VBATT Input Control Register                               */

        struct
        {
            __IOM uint8_t VCH0INEN : 1; /*!< [0..0] RTCIC0 Input Enable                                                */
            __IOM uint8_t VCH1INEN : 1; /*!< [1..1] RTCIC1 Input Enable                                                */
            __IOM uint8_t VCH2INEN : 1; /*!< [2..2] RTCIC2 Input Enable                                                */
            uint8_t                : 5;
        } VBTICTLR_b;
    };

    union
    {
        __IOM uint8_t VBTOCTLR;          /*!< (@ 0x000004BC) VBATT Output Control Register                              */

        struct
        {
            __IOM uint8_t VCH0OEN   : 1; /*!< [0..0] VBATT Wakeup I/O 0 Output Enable                                   */
            __IOM uint8_t VCH1OEN   : 1; /*!< [1..1] VBATT Wakeup I/O 1 Output Enable                                   */
            __IOM uint8_t VCH2OEN   : 1; /*!< [2..2] VBATT Wakeup I/O 2 Output Enable                                   */
            __IOM uint8_t VOUT0LSEL : 1; /*!< [3..3] VBATT Wakeup I/O 0 Output Level Selection                          */
            __IOM uint8_t VCOU1LSEL : 1; /*!< [4..4] VBATT Wakeup I/O 1 Output Level Selection                          */
            __IOM uint8_t VOUT2LSEL : 1; /*!< [5..5] VBATT Wakeup I/O 2 Output Level Selection                          */
            uint8_t                 : 2;
        } VBTOCTLR_b;
    };

    union
    {
        __IOM uint8_t VBTWTER;         /*!< (@ 0x000004BD) VBATT Wakeup Trigger source Enable Register                */

        struct
        {
            __IOM uint8_t VCH0E  : 1;  /*!< [0..0] VBATWIO0 Pin Enable                                                */
            __IOM uint8_t VCH1E  : 1;  /*!< [1..1] VBATWIO1 Pin Enable                                                */
            __IOM uint8_t VCH2E  : 1;  /*!< [2..2] VBATWIO2 Pin Enable                                                */
            __IOM uint8_t VRTCIE : 1;  /*!< [3..3] RTC Periodic Signal Enable                                         */
            __IOM uint8_t VRTCAE : 1;  /*!< [4..4] RTC Alarm Signal Enable                                            */
            __IOM uint8_t VAGTUE : 1;  /*!< [5..5] AGT(ch1) underflow Signal Enable                                   */
            uint8_t              : 2;
        } VBTWTER_b;
    };

    union
    {
        __IOM uint8_t VBTWEGR;         /*!< (@ 0x000004BE) VBATT Wakeup Trigger source Edge Register                  */

        struct
        {
            __IOM uint8_t VCH0EG : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH1EG : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH2EG : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Source Edge Select                         */
            uint8_t              : 5;
        } VBTWEGR_b;
    };

    union
    {
        __IOM uint8_t VBTWFR;          /*!< (@ 0x000004BF) VBATT Wakeup trigger source Flag Register                  */

        struct
        {
            __IOM uint8_t VCH0F  : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH1F  : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH2F  : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Flag                                       */
            __IOM uint8_t VRTCIF : 1;  /*!< [3..3] VBATT RTC-Interval Wakeup Trigger Flag                             */
            __IOM uint8_t VRTCAF : 1;  /*!< [4..4] VBATT RTC-Alarm Wakeup Trigger Flag                                */
            __IOM uint8_t VAGTUF : 1;  /*!< [5..5] AGT(ch1) underflow VBATT Wakeup Trigger Flag                       */
            uint8_t              : 2;
        } VBTWFR_b;
    };

    union
    {
        __IOM uint8_t VBTBER;          /*!< (@ 0x000004C0) VBATT Backup Enable Register                               */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t VBAE : 1;    /*!< [3..3] VBATT backup register access enable bit                            */
            uint8_t            : 4;
        } VBTBER_b;
    };
    __IM uint8_t  RESERVED58;
    __IM uint16_t RESERVED59;
    __IM uint32_t RESERVED60[15];

    union
    {
        __IOM uint8_t VBTBKR[512];     /*!< (@ 0x00000500) VBATT Backup Register [0..511]                             */

        struct
        {
            __IOM uint8_t VBTBKR : 8;  /*!< [7..0] VBTBKR is a 512-byte readable/writable register to store
                                        *   data powered by VBATT.The value of this register is retained
                                        *   even when VCC is not powered but VBATT is powered.VBTBKR
                                        *   is initialized by VBATT selected voltage power-on-reset.                  */
        } VBTBKR_b[512];
    };
} R_SYSTEM_Type;                       /*!< Size = 1792 (0x700)                                                       */

/* =========================================================================================================================== */
/* ================                                           R_TSN                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Temperature Sensor (R_TSN)
 */

typedef struct                         /*!< (@ 0x407EC000) R_TSN Structure                                            */
{
    __IM uint8_t RESERVED[552];

    union
    {
        __IM uint8_t TSCDRL;           /*!< (@ 0x00000228) Temperature Sensor Calibration Data Register
                                        *                  L                                                          */

        struct
        {
            __IM uint8_t TSCDRL : 8;   /*!< [7..0] The calibration data stores the lower 8 bits of the convertedvalue. */
        } TSCDRL_b;
    };

    union
    {
        __IM uint8_t TSCDRH;           /*!< (@ 0x00000229) Temperature Sensor Calibration Data Register
                                        *                  H                                                          */

        struct
        {
            __IM uint8_t TSCDRH : 8;   /*!< [7..0] The calibration data stores the higher 8 bits of the
                                        *   convertedvalue.                                                           */
        } TSCDRH_b;
    };
} R_TSN_Type;                          /*!< Size = 554 (0x22a)                                                        */

/* =========================================================================================================================== */
/* ================                                         R_TSN_CAL                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Temperature Sensor (R_TSN_CAL)
 */

typedef struct                         /*!< (@ 0x407FB17C) R_TSN_CAL Structure                                        */
{
    union
    {
        __IM uint32_t TSCDR;           /*!< (@ 0x00000000) Temperature Sensor 32 bit Calibration Data Register        */

        struct
        {
            __IM uint32_t TSCDR : 32;  /*!< [31..0] The 32 bit TSCDR register stores temperature sensor
                                        *   calibration converted value.                                              */
        } TSCDR_b;
    };
} R_TSN_CAL_Type;                      /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_TSN_CTRL                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Temperature Sensor (R_TSN_CTRL)
 */

typedef struct                         /*!< (@ 0x4005D000) R_TSN_CTRL Structure                                       */
{
    union
    {
        __IOM uint8_t TSCR;            /*!< (@ 0x00000000) Temperature Sensor Control Register                        */

        struct
        {
            uint8_t            : 4;
            __IOM uint8_t TSOE : 1;    /*!< [4..4] Temperature Sensor Enable                                          */
            uint8_t            : 2;
            __IOM uint8_t TSEN : 1;    /*!< [7..7] Temperature Sensor Output Enable                                   */
        } TSCR_b;
    };
} R_TSN_CTRL_Type;                     /*!< Size = 1 (0x1)                                                            */

/* =========================================================================================================================== */
/* ================                                         R_USB_FS0                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief USB 2.0 Module (R_USB_FS0)
 */

typedef struct                         /*!< (@ 0x40090000) R_USB_FS0 Structure                                        */
{
    union
    {
        __IOM uint16_t SYSCFG;         /*!< (@ 0x00000000) System Configuration Control Register                      */

        struct
        {
            __IOM uint16_t USBE  : 1;  /*!< [0..0] USB Operation Enable                                               */
            uint16_t             : 2;
            __IOM uint16_t DMRPU : 1;  /*!< [3..3] D- Line Resistor Control                                           */
            __IOM uint16_t DPRPU : 1;  /*!< [4..4] D+ Line Resistor Control                                           */
            __IOM uint16_t DRPD  : 1;  /*!< [5..5] D+/D- Line Resistor Control                                        */
            __IOM uint16_t DCFM  : 1;  /*!< [6..6] Controller Function Select                                         */
            uint16_t             : 1;
            __IOM uint16_t CNEN  : 1;  /*!< [8..8] CNEN Single End Receiver Enable                                    */
            uint16_t             : 1;
            __IOM uint16_t SCKE  : 1;  /*!< [10..10] USB Clock Enable                                                 */
            uint16_t             : 5;
        } SYSCFG_b;
    };

    union
    {
        __IOM uint16_t BUSWAIT;        /*!< (@ 0x00000002) CPU Bus Wait Register                                      */

        struct
        {
            __IOM uint16_t BWAIT : 4;  /*!< [3..0] CPU Bus Access Wait Specification BWAIT waits (BWAIT+2
                                        *   access cycles)                                                            */
            uint16_t : 12;
        } BUSWAIT_b;
    };

    union
    {
        __IM uint16_t SYSSTS0;         /*!< (@ 0x00000004) System Configuration Status Register 0                     */

        struct
        {
            __IM uint16_t LNST  : 2;   /*!< [1..0] USB Data Line Status Monitor                                       */
            __IM uint16_t IDMON : 1;   /*!< [2..2] External ID0 Input Pin Monitor                                     */
            uint16_t            : 2;
            __IM uint16_t SOFEA : 1;   /*!< [5..5] SOF Active Monitor While Host Controller Function is
                                        *   Selected.                                                                 */
            __IM uint16_t HTACT  : 1;  /*!< [6..6] USB Host Sequencer Status Monitor                                  */
            uint16_t             : 7;
            __IM uint16_t OVCMON : 2;  /*!< [15..14] External USB0_OVRCURA/ USB0_OVRCURB Input Pin MonitorThe
                                        *   OCVMON[1] bit indicates the status of the USBHS_OVRCURA
                                        *   pin. The OCVMON[0] bit indicates the status of the USBHS_OVRCURB
                                        *   pin.                                                                      */
        } SYSSTS0_b;
    };

    union
    {
        __IM uint16_t PLLSTA;          /*!< (@ 0x00000006) PLL Status Register                                        */

        struct
        {
            __IM uint16_t PLLLOCK : 1; /*!< [0..0] PLL Lock Flag                                                      */
            uint16_t              : 15;
        } PLLSTA_b;
    };

    union
    {
        __IOM uint16_t DVSTCTR0;        /*!< (@ 0x00000008) Device State Control Register 0                            */

        struct
        {
            __IM uint16_t RHST     : 3; /*!< [2..0] USB Bus Reset Status                                               */
            uint16_t               : 1;
            __IOM uint16_t UACT    : 1; /*!< [4..4] USB Bus Enable                                                     */
            __IOM uint16_t RESUME  : 1; /*!< [5..5] Resume Output                                                      */
            __IOM uint16_t USBRST  : 1; /*!< [6..6] USB Bus Reset Output                                               */
            __IOM uint16_t RWUPE   : 1; /*!< [7..7] Wakeup Detection Enable                                            */
            __IOM uint16_t WKUP    : 1; /*!< [8..8] Wakeup Output                                                      */
            __IOM uint16_t VBUSEN  : 1; /*!< [9..9] USB_VBUSEN Output Pin Control                                      */
            __IOM uint16_t EXICEN  : 1; /*!< [10..10] USB_EXICEN Output Pin Control                                    */
            __IOM uint16_t HNPBTOA : 1; /*!< [11..11] Host Negotiation Protocol (HNP) Control This bit is
                                         *   used when switching from device B to device A while in
                                         *   OTG mode. If the HNPBTOA bit is 1, the internal function
                                         *   control keeps the suspended state until the HNP processing
                                         *   ends even though SYSCFG.DPRPU = 0 or SYSCFG.DCFM = 1 is
                                         *   set.                                                                      */
            uint16_t : 4;
        } DVSTCTR0_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t TESTMODE;       /*!< (@ 0x0000000C) USB Test Mode Register                                     */

        struct
        {
            __IOM uint16_t UTST : 4;   /*!< [3..0] Test Mode                                                          */
            uint16_t            : 12;
        } TESTMODE_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t CFIFO;          /*!< (@ 0x00000014) CFIFO Port Register                                        */

        struct
        {
            union
            {
                __IOM uint16_t CFIFOL;  /*!< (@ 0x00000014) CFIFO Port Register L                                      */
                __IOM uint8_t  CFIFOLL; /*!< (@ 0x00000014) CFIFO Port Register LL                                     */
            };

            union
            {
                __IOM uint16_t CFIFOH; /*!< (@ 0x00000016) CFIFO Port Register H                                      */

                struct
                {
                    __IM uint8_t  RESERVED3;
                    __IOM uint8_t CFIFOHH; /*!< (@ 0x00000017) CFIFO Port Register HH                                     */
                };
            };
        };
    };

    union
    {
        __IOM uint32_t D0FIFO;         /*!< (@ 0x00000018) D0FIFO Port Register                                       */

        struct
        {
            union
            {
                __IOM uint16_t D0FIFOL;  /*!< (@ 0x00000018) D0FIFO Port Register L                                     */
                __IOM uint8_t  D0FIFOLL; /*!< (@ 0x00000018) D0FIFO Port Register LL                                    */
            };

            union
            {
                __IOM uint16_t D0FIFOH; /*!< (@ 0x0000001A) D0FIFO Port Register H                                     */

                struct
                {
                    __IM uint8_t  RESERVED4;
                    __IOM uint8_t D0FIFOHH; /*!< (@ 0x0000001B) D0FIFO Port Register HH                                    */
                };
            };
        };
    };

    union
    {
        __IOM uint32_t D1FIFO;         /*!< (@ 0x0000001C) D1FIFO Port Register                                       */

        struct
        {
            union
            {
                __IOM uint16_t D1FIFOL;  /*!< (@ 0x0000001C) D1FIFO Port Register L                                     */
                __IOM uint8_t  D1FIFOLL; /*!< (@ 0x0000001C) D1FIFO Port Register LL                                    */
            };

            union
            {
                __IOM uint16_t D1FIFOH; /*!< (@ 0x0000001E) D1FIFO Port Register H                                     */

                struct
                {
                    __IM uint8_t  RESERVED5;
                    __IOM uint8_t D1FIFOHH; /*!< (@ 0x0000001F) D1FIFO Port Register HH                                    */
                };
            };
        };
    };

    union
    {
        __IOM uint16_t CFIFOSEL;        /*!< (@ 0x00000020) CFIFO Port Select Register                                 */

        struct
        {
            __IOM uint16_t CURPIPE : 4; /*!< [3..0] CFIFO Port Access Pipe Specification                               */
            uint16_t               : 1;
            __IOM uint16_t ISEL    : 1; /*!< [5..5] CFIFO Port Access Direction When DCP is Selected                   */
            uint16_t               : 2;
            __IOM uint16_t BIGEND  : 1; /*!< [8..8] CFIFO Port Endian Control                                          */
            uint16_t               : 1;
            __IOM uint16_t MBW     : 2; /*!< [11..10] CFIFO Port Access Bit Width                                      */
            uint16_t               : 2;
            __IOM uint16_t REW     : 1; /*!< [14..14] Buffer Pointer Rewind                                            */
            __IOM uint16_t RCNT    : 1; /*!< [15..15] Read Count Mode                                                  */
        } CFIFOSEL_b;
    };

    union
    {
        __IOM uint16_t CFIFOCTR;       /*!< (@ 0x00000022) CFIFO Port Control Register                                */

        struct
        {
            __IM uint16_t DTLN : 12;   /*!< [11..0] Receive Data LengthIndicates the length of the receive
                                        *   data.                                                                     */
            uint16_t            : 1;
            __IM uint16_t  FRDY : 1;   /*!< [13..13] FIFO Port Ready                                                  */
            __IOM uint16_t BCLR : 1;   /*!< [14..14] CPU Buffer ClearNote: Only 0 can be read.                        */
            __IOM uint16_t BVAL : 1;   /*!< [15..15] Buffer Memory Valid Flag                                         */
        } CFIFOCTR_b;
    };
    __IM uint32_t RESERVED6;

    union
    {
        __IOM uint16_t D0FIFOSEL;       /*!< (@ 0x00000028) D0FIFO Port Select Register                                */

        struct
        {
            __IOM uint16_t CURPIPE : 4; /*!< [3..0] FIFO Port Access Pipe Specification                                */
            uint16_t               : 4;
            __IOM uint16_t BIGEND  : 1; /*!< [8..8] FIFO Port Endian Control                                           */
            uint16_t               : 1;
            __IOM uint16_t MBW     : 2; /*!< [11..10] FIFO Port Access Bit Width                                       */
            __IOM uint16_t DREQE   : 1; /*!< [12..12] DMA/DTC Transfer Request Enable                                  */
            __IOM uint16_t DCLRM   : 1; /*!< [13..13] Auto Buffer Memory Clear Mode Accessed after Specified
                                         *   Pipe Data is Read                                                         */
            __IOM uint16_t REW  : 1;    /*!< [14..14] Buffer Pointer RewindNote: Only 0 can be read.                   */
            __IOM uint16_t RCNT : 1;    /*!< [15..15] Read Count Mode                                                  */
        } D0FIFOSEL_b;
    };

    union
    {
        __IOM uint16_t D0FIFOCTR;      /*!< (@ 0x0000002A) D0FIFO Port Control Register                               */

        struct
        {
            __IM uint16_t DTLN : 12;   /*!< [11..0] Receive Data LengthIndicates the length of the receive
                                        *   data.                                                                     */
            uint16_t            : 1;
            __IM uint16_t  FRDY : 1;   /*!< [13..13] FIFO Port Ready                                                  */
            __IOM uint16_t BCLR : 1;   /*!< [14..14] CPU Buffer ClearNote: Only 0 can be read.                        */
            __IOM uint16_t BVAL : 1;   /*!< [15..15] Buffer Memory Valid Flag                                         */
        } D0FIFOCTR_b;
    };

    union
    {
        __IOM uint16_t D1FIFOSEL;       /*!< (@ 0x0000002C) D1FIFO Port Select Register                                */

        struct
        {
            __IOM uint16_t CURPIPE : 4; /*!< [3..0] FIFO Port Access Pipe Specification                                */
            uint16_t               : 4;
            __IOM uint16_t BIGEND  : 1; /*!< [8..8] FIFO Port Endian Control                                           */
            uint16_t               : 1;
            __IOM uint16_t MBW     : 2; /*!< [11..10] FIFO Port Access Bit Width                                       */
            __IOM uint16_t DREQE   : 1; /*!< [12..12] DMA/DTC Transfer Request Enable                                  */
            __IOM uint16_t DCLRM   : 1; /*!< [13..13] Auto Buffer Memory Clear Mode Accessed after Specified
                                         *   Pipe Data is Read                                                         */
            __IOM uint16_t REW  : 1;    /*!< [14..14] Buffer Pointer Rewind                                            */
            __IOM uint16_t RCNT : 1;    /*!< [15..15] Read Count Mode                                                  */
        } D1FIFOSEL_b;
    };

    union
    {
        __IOM uint16_t D1FIFOCTR;      /*!< (@ 0x0000002E) D1FIFO Port Control Register                               */

        struct
        {
            __IM uint16_t DTLN : 12;   /*!< [11..0] Receive Data LengthIndicates the length of the receive
                                        *   data.                                                                     */
            uint16_t            : 1;
            __IM uint16_t  FRDY : 1;   /*!< [13..13] FIFO Port Ready                                                  */
            __IOM uint16_t BCLR : 1;   /*!< [14..14] CPU Buffer ClearNote: Only 0 can be read.                        */
            __IOM uint16_t BVAL : 1;   /*!< [15..15] Buffer Memory Valid Flag                                         */
        } D1FIFOCTR_b;
    };

    union
    {
        __IOM uint16_t INTENB0;        /*!< (@ 0x00000030) Interrupt Enable Register 0                                */

        struct
        {
            uint16_t             : 8;
            __IOM uint16_t BRDYE : 1;  /*!< [8..8] Buffer Ready Interrupt Enable                                      */
            __IOM uint16_t NRDYE : 1;  /*!< [9..9] Buffer Not Ready Response Interrupt Enable                         */
            __IOM uint16_t BEMPE : 1;  /*!< [10..10] Buffer Empty Interrupt Enable                                    */
            __IOM uint16_t CTRE  : 1;  /*!< [11..11] Control Transfer Stage Transition Interrupt Enable               */
            __IOM uint16_t DVSE  : 1;  /*!< [12..12] Device State Transition Interrupt Enable                         */
            __IOM uint16_t SOFE  : 1;  /*!< [13..13] Frame Number Update Interrupt Enable                             */
            __IOM uint16_t RSME  : 1;  /*!< [14..14] Resume Interrupt Enable                                          */
            __IOM uint16_t VBSE  : 1;  /*!< [15..15] VBUS Interrupt Enable                                            */
        } INTENB0_b;
    };

    union
    {
        __IOM uint16_t INTENB1;            /*!< (@ 0x00000032) Interrupt Enable Register 1                                */

        struct
        {
            __IOM uint16_t PDDETINTE0 : 1; /*!< [0..0] PDDETINT0 Detection Interrupt Enable                               */
            uint16_t                  : 3;
            __IOM uint16_t SACKE      : 1; /*!< [4..4] Setup Transaction Normal Response Interrupt Enable                 */
            __IOM uint16_t SIGNE      : 1; /*!< [5..5] Setup Transaction Error Interrupt Enable                           */
            __IOM uint16_t EOFERRE    : 1; /*!< [6..6] EOF Error Detection Interrupt Enable                               */
            uint16_t                  : 4;
            __IOM uint16_t ATTCHE     : 1; /*!< [11..11] Connection Detection Interrupt Enable                            */
            __IOM uint16_t DTCHE      : 1; /*!< [12..12] Disconnection Detection Interrupt Enable                         */
            uint16_t                  : 1;
            __IOM uint16_t BCHGE      : 1; /*!< [14..14] USB Bus Change Interrupt Enable                                  */
            __IOM uint16_t OVRCRE     : 1; /*!< [15..15] Overcurrent Input Change Interrupt Enable                        */
        } INTENB1_b;
    };
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t BRDYENB;            /*!< (@ 0x00000036) BRDY Interrupt Enable Register                             */

        struct
        {
            __IOM uint16_t PIPE0BRDYE : 1; /*!< [0..0] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE1BRDYE : 1; /*!< [1..1] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE2BRDYE : 1; /*!< [2..2] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE3BRDYE : 1; /*!< [3..3] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE4BRDYE : 1; /*!< [4..4] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE5BRDYE : 1; /*!< [5..5] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE6BRDYE : 1; /*!< [6..6] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE7BRDYE : 1; /*!< [7..7] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE8BRDYE : 1; /*!< [8..8] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE9BRDYE : 1; /*!< [9..9] BRDY Interrupt Enable for PIPE                                     */
            uint16_t                  : 6;
        } BRDYENB_b;
    };

    union
    {
        __IOM uint16_t NRDYENB;            /*!< (@ 0x00000038) NRDY Interrupt Enable Register                             */

        struct
        {
            __IOM uint16_t PIPE0NRDYE : 1; /*!< [0..0] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE1NRDYE : 1; /*!< [1..1] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE2NRDYE : 1; /*!< [2..2] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE3NRDYE : 1; /*!< [3..3] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE4NRDYE : 1; /*!< [4..4] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE5NRDYE : 1; /*!< [5..5] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE6NRDYE : 1; /*!< [6..6] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE7NRDYE : 1; /*!< [7..7] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE8NRDYE : 1; /*!< [8..8] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE9NRDYE : 1; /*!< [9..9] NRDY Interrupt Enable for PIPE                                     */
            uint16_t                  : 6;
        } NRDYENB_b;
    };

    union
    {
        __IOM uint16_t BEMPENB;            /*!< (@ 0x0000003A) BEMP Interrupt Enable Register                             */

        struct
        {
            __IOM uint16_t PIPE0BEMPE : 1; /*!< [0..0] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE1BEMPE : 1; /*!< [1..1] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE2BEMPE : 1; /*!< [2..2] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE3BEMPE : 1; /*!< [3..3] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE4BEMPE : 1; /*!< [4..4] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE5BEMPE : 1; /*!< [5..5] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE6BEMPE : 1; /*!< [6..6] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE7BEMPE : 1; /*!< [7..7] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE8BEMPE : 1; /*!< [8..8] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE9BEMPE : 1; /*!< [9..9] BEMP Interrupt Enable for PIPE                                     */
            uint16_t                  : 6;
        } BEMPENB_b;
    };

    union
    {
        __IOM uint16_t SOFCFG;         /*!< (@ 0x0000003C) SOF Output Configuration Register                          */

        struct
        {
            uint16_t                : 4;
            __IM uint16_t  EDGESTS  : 1; /*!< [4..4] Edge Interrupt Output Status Monitor                               */
            __IOM uint16_t INTL     : 1; /*!< [5..5] Interrupt Output Sense Select                                      */
            __IOM uint16_t BRDYM    : 1; /*!< [6..6] BRDY Interrupt Status Clear Timing                                 */
            uint16_t                : 1;
            __IOM uint16_t TRNENSEL : 1; /*!< [8..8] Transaction-Enabled Time Select                                    */
            uint16_t                : 7;
        } SOFCFG_b;
    };

    union
