/*
 * Copyright (C) 2017 BlueKitchen GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 4. Any redistribution, use, or modification is done solely for
 *    personal benefit and not for any commercial purpose or for
 *    monetary gain.
 *
 * THIS SOFTWARE IS PROVIDED BY BLUEKITCHEN GMBH AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS
 * RINGWALD OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Please inquire about commercial licensing options at 
 * contact@bluekitchen-gmbh.com
 *
 */

/*
 * btstack_run_loop_freertos.h
 *
 * Functions relevant for BTstack WICED port 
 */

#ifndef BTSTACK_RUN_LOOP_FREERTOS_H
#define BTSTACK_RUN_LOOP_FREERTOS_H

#include "btstack_config.h"
#include "btstack_run_loop.h"

#if defined __cplusplus
extern "C" {
#endif

/**
 * @brief Provide btstack_run_loop_freertos instance for use with btstack_run_loop_init
 */
const btstack_run_loop_t * btstack_run_loop_freertos_get_instance(void);

/*
 * @brief Execute code on BTstack run loop. Can be used to control BTstack from a different thread
 */
void btstack_run_loop_freertos_execute_code_on_main_thread(void (*fn)(void *arg), void * arg);

/*
 * @brief Execute code on BTstack run loop. Can be used to control BTstack from an ISR
 */
void btstack_run_loop_freertos_execute_code_on_main_thread_from_isr(void (*fn)(void *arg), void * arg);

/**
 * @brief Triggers processing of data sources from thread context. 
 * Has to be called after enabling a poll data source to wake-pup run loop.
 */
void btstack_run_loop_freertos_trigger(void);    

/**
 * @brief Triggers processing of data sources from an ISR.
 * Has to be called after enabling a poll data source to wake-pup run loop.
 */
void btstack_run_loop_freertos_trigger_from_isr(void);    

/* API_END */

#if defined __cplusplus
}
#endif

#endif // btstack_run_loop_WICED_H
