/*      systester.h
//
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//
*/


#if !defined(SYSTESTER_H)
#define SYSTESTER_H 1

#define SYSTESTER_MAJOR 	1
#define SYSTESTER_MINOR		5
#define SYSTESTER_PATCH		1

#if defined (_MSC_VER) /* Visual Studio */
#define _CRT_SECURE_NO_WARNINGS
#include <io.h> /* Mingw */
#elif defined (__MINGW32__)
#include <windows.h>
#include <io.h>
#else /* Unix */
#include <unistd.h>
#endif /*_MSC_VER */

#include <stdio.h>
#include <stdlib.h>
#include <sys/timeb.h>
#include <math.h>
#include <string.h>
#include <gmp.h>

#include "qcborwein.h"
#include "gausslegendre.h"

#if !defined (_CLI) /* GUI */
#include <QDesktopServices>
#include <QDir>
#include "SplashForm.h"
#include "MainForm.h"
extern QFont globalfont, termfont;
extern QTextEdit *Terminal;
#define SCROLL             VSBar->setSliderPosition(VSBar->maximum());VSBar->update();
#define PROCESS_EVENTS Terminal->setText (termstr);SCROLL;qApp->processEvents (QEventLoop::AllEvents, 1000)
#define PRINT(fmt,str) {sprintf(tempstr, fmt, str);strcat (termstr, tempstr);}
#define CPUPI_FILE_PATH QString (QDesktopServices::storageLocation(QDesktopServices::HomeLocation) + QDir::separator() + "CPUPI.DAT").toLocal8Bit().data()
#define LOG_FILE_PATH QString (QDesktopServices::storageLocation(QDesktopServices::HomeLocation) + QDir::separator() + "systester.log").toLocal8Bit().data()
#else /* CLI */
#define CPUPI_FILE_PATH "CPUPI.DAT"
#define LOG_FILE_PATH   "systester.log"
#define PROCESS_EVENTS
#define PRINT(fmt, str) printf(fmt,str)
#endif /* _CLI */

extern unsigned long long xdigits;
extern int pflag;
extern int lflag;
extern int pass;
extern int errors;
extern int start;
extern int stop;
extern int first_error;
extern int chksum_err;
extern int mode;
extern int pth_stacksize;
extern char termstr[20000];
extern char tempstr[256];

unsigned long long cpufreq (void);
int CPUID (char *ChipID, char *VendorID);
int ncpus (void);
void osid (char *str);
int validate_checksum (int prec, char *pistr);
double totalmem ();
double freemem ();
unsigned pitimer ();
void outtime (unsigned long long start, unsigned long long stop, char *str);
void outxdigits (unsigned long long xdigits, char *str);
void master (unsigned long long iter, int threads, int algo);

#endif /* SYSTESTER_H */
