/*      compthreads.h
//
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//
*/


#if !defined(COMPTHREADS_H)
#define COMPTHREADS_H 1

#if defined (_MSC_VER) || defined (__MINGW32__) /* windows threads */
#if defined (_WIN64)
#if !defined (_AMD64_)
#define _AMD64_
#endif
#endif

#include <windows.h>
#include <stdarg.h>
#include <windef.h>
#include <winbase.h>

typedef DWORD st_thread_t;
typedef DWORD st_threadfunc_t;
typedef LPVOID st_threadfuncarg_t;
typedef HANDLE st_threadret_t;

#elif defined(_SCO_DS) /* GNU pth for SCO Openserver */
#include <pth.h>
typedef pth_t st_thread_t;
typedef void *st_threadfunc_t;
typedef void *st_threadfuncarg_t;
typedef int st_threadret_t;

#else /* posix threads */
#include <pthread.h>
typedef pthread_t st_thread_t;
typedef void *st_threadfunc_t;
typedef void *st_threadfuncarg_t;
typedef int st_threadret_t;

#endif /* _MSC_VER */

st_threadret_t st_thread_create (st_thread_t * th,
				 st_threadfunc_t (*start_routine)
				 (st_threadfuncarg_t),
				 st_threadfuncarg_t arg);

void st_thread_join (int nthreads, st_thread_t * threads,
		     st_threadret_t * rthreads);

#endif
