#!/bin/perl
#
# Extract supported divecomputers from libdivecomputer source
#
# Usage:
#
# parse-descriptor.pl <outfile>
#
# depending on suffix of the outfile it creates the right content for
# either a text file or and html file
use Carp;

#set command line arguments
my $outfi = $ARGV[0];
my ($type) = $outfi =~ /\.([^.]+)$/;

my $infi = "libdivecomputer/src/descriptor.c";

open(my $fh, "<", $infi) || croak "can't open $infi: $!";
open(STDOUT, ">", $outfi) || croak "can't open $outfi: $!";

my $commentStart = "# ";
my $commentEnd = "";
if ($type eq "html") {
	$commentStart = "<!-- ";
	$commentEnd = " -->";
}
printf("%s This file is automatically generated, please edit scripts/parse-descriptor.pl%s\n", $commentStart, $commentEnd);

my $lastVend = "";
my $lastMod = "";
my @descriptors = ();
while (<$fh>) {
	if (/^\s*{\s*"([^\,]*)"\s*,\s*"([^\,]*)"\s*,\s*([^\,]*).*}/) {
		push(@descriptors, "$1,$2");
	}
}
my @sortedDescriptors = sort @descriptors;
foreach (@sortedDescriptors) {
	($vend, $mod) = split(',', $_);
	next if ($vend eq $lastVend && $mod eq $lastMod);
	if ($type eq "html") {
		if ($vend eq $lastVend) {
			printf(", %s", $mod);
		} else {
			if ($lastVend lt "Seabaer" && $vend gt "Seabaer") {
				printf("</li></ul>\n    </dd>\n    <dt>Seabaer</dt><dd><ul>\n\t    <li>T1, H3, HUDC");
			}
			if ($lastVend lt "Uemis" && $vend gt "Uemis") {
				printf("</li></ul>\n    </dd>\n    <dt>Uemis</dt><dd><ul>\n\t    <li>Zürich SDA");
			}
			if ($lastVend eq "") {
				printf("<dl><dt>%s</dt><dd><ul>\n\t    <li>%s", $vend, $mod);
			} else {
				printf("</li></ul>\n    </dd>\n    <dt>%s</dt><dd><ul>\n\t    <li>%s", $vend, $mod);
			}
		}
	} else {
		if ($vend eq $lastVend) {
			printf(", %s", $mod);
		} else {
			if ($lastVend lt "Seabaer" && $vend gt "Seabaer") {
				printf("\nSeabaer: T1, H3, HUDC");
			}
			if ($lastVend lt "Uemis" && $vend gt "Uemis") {
				printf("\nUemis: Zürich SDA");
			}
			if ($lastVend eq "") {
				printf("%s: %s", $vend, $mod);
			} else {
				printf("\n%s: %s", $vend, $mod);
			}
		}
	}
	$lastVend = $vend;
	$lastMod = $mod;
}
if ($type eq "html") {
    print("</li>\n\t</ul>\n    </dd>\n</dl>");
}
close $fh;
