#ifndef SEQ64_USERFILE_HPP
#define SEQ64_USERFILE_HPP

/*
 *  This file is part of seq24/sequencer64.
 *
 *  seq24 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  seq24 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with seq24; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * \file          userfile.hpp
 *
 *  This module declares/defines the base class for
 *  managing the user's <code> ~/.config/sequencer64/sequencer64.usr </code>
 *  or <code> ~/.seq24usr </code> configuration file.
 *
 * \library       sequencer64 application
 * \author        Seq24 team; modifications by Chris Ahlstrom
 * \date          2015-07-24
 * \updates       2018-08-28
 * \license       GNU GPLv2 or above
 *
 */

#include <string>

#include "configfile.hpp"

/*
 *  Do not document a namespace; it breaks Doxygen.
 */

namespace seq64
{

    class perform;

/**
 *    Supports the user's <code> ~/.config/sequencer64/sequencer64.usr </code> and
 *    <code> ~/.seq24usr </code> configuration file.
 */

class userfile : public configfile
{

public:

    userfile (const std::string & name);
    virtual ~userfile ();

    virtual bool parse (perform & perf);
    virtual bool write (const perform & perf);

private:

    void dump_setting_summary ();

};

}           // namespace seq64

#endif      // SEQ64_USERFILE_HPP

/*
 * userfile.hpp
 *
 * vim: sw=4 ts=4 wm=4 et ft=cpp
 */

