// run-rustfix

// The output for humans should just highlight the whole span without showing
// the suggested replacement, but we also want to test that suggested
// replacement only removes one set of parentheses, rather than naïvely
// stripping away any starting or ending parenthesis characters—hence this
// test of the JSON error format.

#![feature(custom_inner_attributes)]
#![rustfmt::skip]

#![deny(clippy::unused_unit)]

struct Unitter;
impl Unitter {
    // try to disorient the lint with multiple unit returns and newlines
    #[allow(clippy::no_effect)]
    pub fn get_unit<F: Fn() -> (), G>(&self, f: F, _g: G) ->
        ()
    where G: Fn() -> () {
        let _y: &dyn Fn() -> () = &f;
        (); // this should not lint, as it's not in return type position
    }
}

impl Into<()> for Unitter {
    #[rustfmt::skip]
    fn into(self) -> () {
        ()
    }
}

fn return_unit() -> () { () }

#[allow(clippy::needless_return)]
#[allow(clippy::never_loop)]
fn main() {
    let u = Unitter;
    assert_eq!(u.get_unit(|| {}, return_unit), u.into());
    return_unit();
    loop {
        break();
    }
    return();
}
