/*
 * Copyright (C) 2006-2020 Apple Inc. All rights reserved.
 * Copyright (C) 2007-2009 Torch Mobile, Inc.
 * Copyright (C) 2010, 2011 Research In Motion Limited. All rights reserved.
 * Copyright (C) 2013 Samsung Electronics. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#ifndef WTF_PLATFORM_GUARD_AGAINST_INDIRECT_INCLUSION
#error "Please #include <wtf/Platform.h> instead of this file directly."
#endif

#if !PLATFORM(COCOA)
#error "This file should only be included when building for one of Apple's Cocoa platforms."
#endif


/* --------- Apple Cocoa platforms --------- */

#if !defined(ENABLE_AIRPLAY_PICKER) && (PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST))
#define ENABLE_AIRPLAY_PICKER 1
#endif

#if !defined(ENABLE_APPLE_PAY_REMOTE_UI) && (PLATFORM(IOS_FAMILY) && !PLATFORM(APPLETV) && !PLATFORM(MACCATALYST) && !PLATFORM(WATCHOS))
#define ENABLE_APPLE_PAY_REMOTE_UI 1
#endif

#if !defined(ENABLE_CONTENT_EXTENSIONS)
#define ENABLE_CONTENT_EXTENSIONS 1
#endif

#if !defined(ENABLE_CONTEXT_MENUS) && PLATFORM(IOS_FAMILY)
#define ENABLE_CONTEXT_MENUS 0
#endif

#if !defined(ENABLE_CONTEXT_MENU_EVENT) && (PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST))
#define ENABLE_CONTEXT_MENU_EVENT 0
#endif

#if !defined(ENABLE_CUSTOM_CURSOR_SUPPORT) && PLATFORM(IOS_FAMILY)
#define ENABLE_CUSTOM_CURSOR_SUPPORT 0
#endif

#if !defined(ENABLE_DRAG_SUPPORT) && PLATFORM(IOS_FAMILY)
#define ENABLE_DRAG_SUPPORT 0
#endif

#if !defined(ENABLE_GEOLOCATION) && PLATFORM(IOS_FAMILY)
#define ENABLE_GEOLOCATION 1
#endif

#if !defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS)
#define ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS 1
#endif

#if !defined(ENABLE_INSPECTOR_TELEMETRY) && PLATFORM(MAC)
#define ENABLE_INSPECTOR_TELEMETRY 1
#endif

#if !defined(ENABLE_LETTERPRESS) && PLATFORM(IOS_FAMILY)
#define ENABLE_LETTERPRESS 1
#endif

#if !defined(ENABLE_AUTOCORRECT) && PLATFORM(IOS_FAMILY)
#define ENABLE_AUTOCORRECT 1
#endif

#if !defined(ENABLE_AUTOCAPITALIZE) && PLATFORM(IOS_FAMILY)
#define ENABLE_AUTOCAPITALIZE 1
#endif

#if !defined(ENABLE_IOS_GESTURE_EVENTS) && (PLATFORM(IOS_FAMILY) && USE(APPLE_INTERNAL_SDK))
#define ENABLE_IOS_GESTURE_EVENTS 1
#endif

#if !defined(ENABLE_IOS_TOUCH_EVENTS) && (PLATFORM(IOS_FAMILY) && USE(APPLE_INTERNAL_SDK))
#define ENABLE_IOS_TOUCH_EVENTS 1
#endif

#if !defined(ENABLE_TEXT_AUTOSIZING) && PLATFORM(IOS_FAMILY)
#define ENABLE_TEXT_AUTOSIZING 1
#endif

#if !defined(ENABLE_METER_ELEMENT) && PLATFORM(IOS_FAMILY)
#define ENABLE_METER_ELEMENT 0
#endif

#if !defined(ENABLE_NETSCAPE_PLUGIN_API) && PLATFORM(IOS_FAMILY)
#define ENABLE_NETSCAPE_PLUGIN_API 0
#endif

#if !defined(ENABLE_ORIENTATION_EVENTS) && PLATFORM(IOS_FAMILY)
#define ENABLE_ORIENTATION_EVENTS 1
#endif

#if !defined(ENABLE_POINTER_LOCK) && PLATFORM(IOS_FAMILY)
#define ENABLE_POINTER_LOCK 0
#endif

#if !defined(ENABLE_REMOTE_INSPECTOR)
#define ENABLE_REMOTE_INSPECTOR 1
#endif

#if !defined(ENABLE_TEXT_CARET) && PLATFORM(IOS_FAMILY)
#define ENABLE_TEXT_CARET 0
#endif

#if !defined(ENABLE_TEXT_SELECTION) && PLATFORM(IOS_FAMILY)
#define ENABLE_TEXT_SELECTION 0
#endif

#if !defined(ENABLE_TOUCH_EVENTS) && (PLATFORM(IOS_FAMILY) && USE(APPLE_INTERNAL_SDK))
#define ENABLE_TOUCH_EVENTS 1
#endif

#if !defined(ENABLE_WEB_ARCHIVE)
#define ENABLE_WEB_ARCHIVE 1
#endif

#if !defined(ENABLE_WEBGL) && PLATFORM(IOS_FAMILY)
#define ENABLE_WEBGL 1
#endif

#if !defined(ENABLE_PRIMARY_SNAPSHOTTED_PLUGIN_HEURISTIC)
#define ENABLE_PRIMARY_SNAPSHOTTED_PLUGIN_HEURISTIC 1
#endif

#if !defined(ENABLE_WKPDFVIEW) && PLATFORM(IOS)
#define ENABLE_WKPDFVIEW 1
#endif

#if !defined(ENABLE_MEDIA_SOURCE) && PLATFORM(MAC)
#define ENABLE_MEDIA_SOURCE 1
#endif

#if !defined(ENABLE_PREVIEW_CONVERTER) && PLATFORM(IOS)
#define ENABLE_PREVIEW_CONVERTER 1
#endif

#if !defined(ENABLE_META_VIEWPORT) && PLATFORM(IOS_FAMILY)
#define ENABLE_META_VIEWPORT 1
#endif

#if !defined(ENABLE_FULLSCREEN_API) && PLATFORM(MAC)
#define ENABLE_FULLSCREEN_API 1
#endif

#if !defined(ENABLE_SMOOTH_SCROLLING) && PLATFORM(MAC)
#define ENABLE_SMOOTH_SCROLLING 1
#endif

#if !defined(ENABLE_VIDEO_TRACK) && PLATFORM(MAC) && ENABLE(VIDEO)
#define ENABLE_VIDEO_TRACK 1
#endif

#if !defined(ENABLE_WEB_AUDIO) && PLATFORM(MAC)
#define ENABLE_WEB_AUDIO 1
#endif

#if !defined(ENABLE_CURSOR_VISIBILITY) && PLATFORM(MAC)
#define ENABLE_CURSOR_VISIBILITY 1
#endif

#if !defined(ENABLE_MAC_GESTURE_EVENTS) && (PLATFORM(MAC) && USE(APPLE_INTERNAL_SDK))
#define ENABLE_MAC_GESTURE_EVENTS 1
#endif

#if !defined(ENABLE_WEBPROCESS_NSRUNLOOP) && (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 101400)
#define ENABLE_WEBPROCESS_NSRUNLOOP 1
#endif

#if !defined(ENABLE_WEBPROCESS_WINDOWSERVER_BLOCKING) && (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 101400)
#define ENABLE_WEBPROCESS_WINDOWSERVER_BLOCKING 1
#endif

#if !defined(ENABLE_LEGACY_ENCRYPTED_MEDIA) && !PLATFORM(MACCATALYST)
#define ENABLE_LEGACY_ENCRYPTED_MEDIA 1
#endif

#if !defined(ENABLE_FILE_REPLACEMENT)
#define ENABLE_FILE_REPLACEMENT 1
#endif

#if !defined(ENABLE_PAYMENT_REQUEST)
#define ENABLE_PAYMENT_REQUEST 1
#endif

#if !defined(ENABLE_ASYNC_SCROLLING)
#define ENABLE_ASYNC_SCROLLING 1
#endif

#if !defined(ENABLE_UI_SIDE_COMPOSITING)
#define ENABLE_UI_SIDE_COMPOSITING 1
#endif

#if !defined(ENABLE_FULL_KEYBOARD_ACCESS) && PLATFORM(MAC)
#define ENABLE_FULL_KEYBOARD_ACCESS 1
#endif

#if !defined(ENABLE_MONOSPACE_FONT_EXCEPTION) && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED < 101500) || PLATFORM(WATCHOS) || PLATFORM(APPLETV))
#define ENABLE_MONOSPACE_FONT_EXCEPTION 1
#endif

#if !defined(ENABLE_PLATFORM_DRIVEN_TEXT_CHECKING) && PLATFORM(MACCATALYST)
#define ENABLE_PLATFORM_DRIVEN_TEXT_CHECKING 1
#endif

#if !defined(ENABLE_WEB_PLAYBACK_CONTROLS_MANAGER) && PLATFORM(MAC)
#define ENABLE_WEB_PLAYBACK_CONTROLS_MANAGER 1
#endif

#if !defined(ENABLE_RESOURCE_USAGE)
#define ENABLE_RESOURCE_USAGE 1
#endif

#if !defined(ENABLE_SEC_ITEM_SHIM)
#define ENABLE_SEC_ITEM_SHIM 1
#endif

#if !defined(ENABLE_DATA_DETECTION) && (!PLATFORM(WATCHOS) && !PLATFORM(APPLETV) && !PLATFORM(MACCATALYST))
#define ENABLE_DATA_DETECTION 1
#endif
