---
name: Bug report
about: Create a report to help improve OctoPrint

---

<!--
READ THE FOLLOWING FIRST:

If not already done, please read the the Contribution Guidelines that
are linked to the right under "Helpful resources" > "Contributing".

Also read the FAQ: https://faq.octoprint.org

This is a bug and feature tracker, please only use it to report bugs
or request features within OctoPrint (not OctoPi, not any OctoPrint
plugins and not unofficial OctoPrint versions).

Do not seek support here ("I need help with ...", "I have a
question ..."), that belongs on the community forum at 
community.octoprint.org, NOT here.

Mark requests with a "[Request]" prefix in the title please. For bug
reports fully fill out the bug reporting template (if you don't know
where to find some information - it's all described in the Contribution
Guidelines linked up there in the big yellow box).

When reporting a bug do NOT delete ANY lines from the template.

Make sure any bug you want to report is still present with the CURRENT
OctoPrint version and that it does not vanish when you start OctoPrint
in safe mode - how to do that is also explained in the Contribution
Guidelines linked up there in the big yellow box.

Thank you!
-->

#### What were you doing?

<!-- 
Please be as specific as possible here. The maintainers will need to
reproduce your issue in order to fix it and that is not possible if they
don't know what you did to get it to happen in the first place.

Ideally provide exact steps to follow in order to reproduce your problem:
-->

1. Go to '...'
2. Click on '....'
3. Scroll down to '....'
4. See error

<!--
If you encountered a problem with specific files of any sorts, make sure
to also include a link to a file with which to reproduce the problem.
-->

#### What did you expect to happen?

#### What happened instead?

#### Did the same happen when running OctoPrint in safe mode?

<!-- 
Test if you can reproduce your problem in safe mode. You can find information
on how to enable safe mode in the Contribution Guidelines.

If you can't reproduce in safe mode, this is a bug with one of your
installed third party plugins. Don't open a ticket here!

If you can't test this in safe mode, state why.
-->

#### Version of OctoPrint

<!--
Can be found in the lower left corner of the web interface. ALWAYS INCLUDE.
-->

#### Operating System running OctoPrint

<!--
OctoPi, Linux, Windows, MacOS, something else? With version please.
OctoPi's version can be found in /etc/octopi_version or in the lower left
corner of the web interface.
-->

#### Printer model & used firmware incl. version

<!--
If applicable, always include if unsure.
-->

#### Browser and version of browser, operating system running browser

<!--
If applicable, always include if unsure.
-->

#### Link to octoprint.log

<!--
On gist.github.com or pastebin.com. ALWAYS INCLUDE and never truncate.

The Contribution Guidelines tell you where to find that.
-->

#### Link to contents of terminal tab or serial.log

<!--
On gist.github.com or pastebin.com. If applicable, always include if unsure or
reporting communication issues. Never truncate.

serial.log is usually not written due to performance reasons and must be
enabled explicitly. Provide at the very least the FULL contents of your
terminal tab at the time of the bug occurrence, even if you do not have
a serial.log (which the Contribution Guidelines tell you where to find).
-->

#### Link to contents of Javascript console in the browser

<!--
On gist.github.com or pastebin.com or alternatively a screenshot. If applicable -
always include if unsure or reporting UI issues.

The Contribution Guidelines tell you where to find that.
-->

#### Screenshot(s)/video(s) showing the problem:

<!--
If applicable. Always include if unsure or reporting UI issues.
-->

I have read the FAQ.
