/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

static gint ValaInitializerList_private_offset;
static gpointer vala_initializer_list_parent_class = NULL;

static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);

static inline gpointer
vala_initializer_list_get_instance_private (ValaInitializerList* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInitializerList_private_offset);
}

/**
 * Appends the specified expression to this initializer
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the expression
 *
 * @return expression list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Creates a new initializer
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}

static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_constant (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_pure (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* result = NULL;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _initializer_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_initializer_list = _tmp2_;
		_tmp3_ = _initializer_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_initializer_size = _tmp5_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			if (first) {
				GString* _tmp8_;
				ValaExpression* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = builder;
				_tmp9_ = initializer;
				_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
				_tmp11_ = _tmp10_;
				g_string_append (_tmp8_, _tmp11_);
				_g_free0 (_tmp11_);
				first = FALSE;
			} else {
				GString* _tmp12_;
				ValaExpression* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = builder;
				_tmp13_ = initializer;
				_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append_printf (_tmp12_, ", %s", _tmp15_);
				_g_free0 (_tmp15_);
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp16_ = builder;
	g_string_append_c (_tmp16_, '}');
	_tmp17_ = builder;
	_tmp18_ = _tmp17_->str;
	_tmp19_ = g_strdup (_tmp18_);
	result = _tmp19_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializers;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializers;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializers;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _error_ = FALSE;
	ValaDataType* _tmp248_;
	ValaDataType* _tmp249_;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		if (VALA_IS_ARRAY_TYPE (_tmp9_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			ValaArrayType* _tmp12_;
			gboolean requires_constants_only = FALSE;
			ValaCodeNode* node = NULL;
			ValaCodeNode* _tmp13_;
			ValaCodeNode* _tmp14_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			ValaCodeNode* _tmp22_;
			ValaCodeNode* _tmp23_;
			ValaDataType* inner_target_type = NULL;
			ValaArrayType* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp12_;
			requires_constants_only = FALSE;
			_tmp13_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp14_ = _tmp13_;
			node = _tmp14_;
			while (TRUE) {
				ValaCodeNode* _tmp15_;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				ValaCodeNode* _tmp19_;
				_tmp15_ = node;
				if (!(_tmp15_ != NULL)) {
					break;
				}
				_tmp16_ = node;
				if (VALA_IS_CONSTANT (_tmp16_)) {
					requires_constants_only = TRUE;
					break;
				}
				_tmp17_ = node;
				_tmp18_ = vala_code_node_get_parent_node (_tmp17_);
				_tmp19_ = _tmp18_;
				node = _tmp19_;
			}
			_tmp22_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp23_)) {
				_tmp21_ = !requires_constants_only;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gboolean _tmp24_ = FALSE;
				ValaCodeNode* _tmp25_;
				ValaCodeNode* _tmp26_;
				_tmp25_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				if (!VALA_IS_INITIALIZER_LIST (_tmp26_)) {
					_tmp24_ = TRUE;
				} else {
					ValaCodeNode* _tmp27_;
					ValaCodeNode* _tmp28_;
					ValaDataType* _tmp29_;
					ValaDataType* _tmp30_;
					ValaTypeSymbol* _tmp31_;
					ValaTypeSymbol* _tmp32_;
					_tmp27_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
					_tmp30_ = _tmp29_;
					_tmp31_ = vala_data_type_get_data_type (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp24_ = VALA_IS_STRUCT (_tmp32_);
				}
				_tmp20_ = _tmp24_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp33_;
				ValaCodeNode* _tmp34_;
				ValaCodeNode* _tmp35_;
				ValaArrayCreationExpression* array_creation = NULL;
				ValaArrayType* _tmp36_;
				ValaDataType* _tmp37_;
				ValaDataType* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaArrayType* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaArrayCreationExpression* _tmp46_;
				ValaArrayCreationExpression* _tmp47_;
				ValaArrayCreationExpression* _tmp48_;
				ValaArrayType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaDataType* _tmp51_;
				ValaDataType* _tmp52_;
				ValaDataType* _tmp53_;
				ValaArrayCreationExpression* _tmp54_;
				ValaDataType* _tmp55_;
				ValaDataType* _tmp56_;
				ValaArrayCreationExpression* _tmp57_;
				ValaDataType* _tmp58_;
				ValaDataType* _tmp59_;
				ValaCodeNode* _tmp60_;
				ValaArrayCreationExpression* _tmp61_;
				ValaArrayCreationExpression* _tmp62_;
				_tmp33_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = _vala_code_node_ref0 (_tmp34_);
				old_parent_node = _tmp35_;
				_tmp36_ = array_type;
				_tmp37_ = vala_array_type_get_element_type (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_data_type_copy (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = array_type;
				_tmp42_ = vala_array_type_get_rank (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_array_creation_expression_new (_tmp40_, _tmp43_, self, _tmp45_);
				_tmp47_ = _tmp46_;
				_vala_code_node_unref0 (_tmp40_);
				array_creation = _tmp47_;
				_tmp48_ = array_creation;
				_tmp49_ = array_type;
				_tmp50_ = vala_array_type_get_length_type (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_data_type_copy (_tmp51_);
				_tmp53_ = _tmp52_;
				vala_array_creation_expression_set_length_type (_tmp48_, _tmp53_);
				_vala_code_node_unref0 (_tmp53_);
				_tmp54_ = array_creation;
				_tmp55_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp56_ = _tmp55_;
				vala_expression_set_target_type ((ValaExpression*) _tmp54_, _tmp56_);
				_tmp57_ = array_creation;
				_tmp58_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp59_ = _tmp58_;
				vala_expression_set_formal_target_type ((ValaExpression*) _tmp57_, _tmp59_);
				_tmp60_ = old_parent_node;
				_tmp61_ = array_creation;
				vala_code_node_replace_expression (_tmp60_, (ValaExpression*) self, (ValaExpression*) _tmp61_);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp62_ = array_creation;
				result = vala_code_node_check ((ValaCodeNode*) _tmp62_, context);
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp63_ = array_type;
			_tmp64_ = vala_array_type_get_rank (_tmp63_);
			_tmp65_ = _tmp64_;
			if (_tmp65_ > 1) {
				ValaArrayType* inner_array_type = NULL;
				ValaArrayType* _tmp66_;
				ValaDataType* _tmp67_;
				ValaArrayType* _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				ValaArrayType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp66_ = array_type;
				_tmp67_ = vala_data_type_copy ((ValaDataType*) _tmp66_);
				inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp68_ = inner_array_type;
				_tmp69_ = vala_array_type_get_rank (_tmp68_);
				_tmp70_ = _tmp69_;
				vala_array_type_set_rank (_tmp68_, _tmp70_ - 1);
				_tmp71_ = inner_array_type;
				_tmp72_ = _vala_code_node_ref0 ((ValaDataType*) _tmp71_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp72_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaArrayType* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				_tmp73_ = array_type;
				_tmp74_ = vala_array_type_get_element_type (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_data_type_copy (_tmp75_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp76_;
			}
			{
				ValaList* _e_list = NULL;
				ValaList* _tmp77_;
				gint _e_size = 0;
				ValaList* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				gint _e_index = 0;
				_tmp77_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp77_;
				_tmp78_ = _e_list;
				_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
				_tmp80_ = _tmp79_;
				_e_size = _tmp80_;
				_e_index = -1;
				while (TRUE) {
					ValaExpression* e = NULL;
					ValaList* _tmp81_;
					gpointer _tmp82_;
					ValaExpression* _tmp83_;
					ValaDataType* _tmp84_;
					_e_index = _e_index + 1;
					if (!(_e_index < _e_size)) {
						break;
					}
					_tmp81_ = _e_list;
					_tmp82_ = vala_list_get (_tmp81_, _e_index);
					e = (ValaExpression*) _tmp82_;
					_tmp83_ = e;
					_tmp84_ = inner_target_type;
					vala_expression_set_target_type (_tmp83_, _tmp84_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp85_;
			ValaDataType* _tmp86_;
			ValaTypeSymbol* _tmp87_;
			ValaTypeSymbol* _tmp88_;
			_tmp85_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp86_ = _tmp85_;
			_tmp87_ = vala_data_type_get_data_type (_tmp86_);
			_tmp88_ = _tmp87_;
			if (VALA_IS_STRUCT (_tmp88_)) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaTypeSymbol* _tmp91_;
				ValaTypeSymbol* _tmp92_;
				ValaStruct* _tmp93_;
				gboolean _tmp101_ = FALSE;
				ValaCodeNode* _tmp102_;
				ValaCodeNode* _tmp103_;
				gboolean in_array_creation_initializer = FALSE;
				ValaObjectCreationExpression* struct_creation = NULL;
				ValaIterator* field_it = NULL;
				ValaStruct* _tmp127_;
				ValaList* _tmp128_;
				ValaList* _tmp129_;
				ValaIterator* _tmp130_;
				ValaIterator* _tmp131_;
				_tmp89_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_data_type_get_data_type (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, VALA_TYPE_STRUCT, ValaStruct));
				st = _tmp93_;
				while (TRUE) {
					ValaStruct* _tmp94_;
					ValaStruct* _tmp95_;
					ValaStruct* _tmp96_;
					ValaStruct* _tmp97_;
					ValaStruct* _tmp98_;
					ValaStruct* _tmp99_;
					ValaStruct* _tmp100_;
					_tmp94_ = st;
					_tmp95_ = vala_struct_get_base_struct (_tmp94_);
					_tmp96_ = _tmp95_;
					if (!(_tmp96_ != NULL)) {
						break;
					}
					_tmp97_ = st;
					_tmp98_ = vala_struct_get_base_struct (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = _vala_code_node_ref0 (_tmp99_);
					_vala_code_node_unref0 (st);
					st = _tmp100_;
				}
				_tmp102_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp103_ = _tmp102_;
				if (VALA_IS_INITIALIZER_LIST (_tmp103_)) {
					ValaCodeNode* _tmp104_;
					ValaCodeNode* _tmp105_;
					ValaCodeNode* _tmp106_;
					ValaCodeNode* _tmp107_;
					_tmp104_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_code_node_get_parent_node (_tmp105_);
					_tmp107_ = _tmp106_;
					_tmp101_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp107_);
				} else {
					_tmp101_ = FALSE;
				}
				in_array_creation_initializer = _tmp101_;
				struct_creation = NULL;
				if (in_array_creation_initializer) {
					ValaMemberAccess* ma = NULL;
					ValaStruct* _tmp108_;
					const gchar* _tmp109_;
					const gchar* _tmp110_;
					ValaSourceReference* _tmp111_;
					ValaSourceReference* _tmp112_;
					ValaMemberAccess* _tmp113_;
					ValaMemberAccess* _tmp114_;
					ValaMemberAccess* _tmp115_;
					ValaStruct* _tmp116_;
					ValaMemberAccess* _tmp117_;
					ValaSourceReference* _tmp118_;
					ValaSourceReference* _tmp119_;
					ValaObjectCreationExpression* _tmp120_;
					ValaObjectCreationExpression* _tmp121_;
					ValaDataType* _tmp122_;
					ValaDataType* _tmp123_;
					ValaDataType* _tmp124_;
					ValaDataType* _tmp125_;
					ValaObjectCreationExpression* _tmp126_;
					_tmp108_ = st;
					_tmp109_ = vala_symbol_get_name ((ValaSymbol*) _tmp108_);
					_tmp110_ = _tmp109_;
					_tmp111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp112_ = _tmp111_;
					_tmp113_ = vala_member_access_new_simple (_tmp110_, _tmp112_);
					ma = _tmp113_;
					_tmp114_ = ma;
					vala_member_access_set_creation_member (_tmp114_, TRUE);
					_tmp115_ = ma;
					_tmp116_ = st;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp115_, (ValaSymbol*) _tmp116_);
					_tmp117_ = ma;
					_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp119_ = _tmp118_;
					_tmp120_ = vala_object_creation_expression_new (_tmp117_, _tmp119_);
					_vala_code_node_unref0 (struct_creation);
					struct_creation = _tmp120_;
					_tmp121_ = struct_creation;
					_tmp122_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_data_type_copy (_tmp123_);
					_tmp125_ = _tmp124_;
					vala_expression_set_target_type ((ValaExpression*) _tmp121_, _tmp125_);
					_vala_code_node_unref0 (_tmp125_);
					_tmp126_ = struct_creation;
					vala_object_creation_expression_set_struct_creation (_tmp126_, TRUE);
					_vala_code_node_unref0 (ma);
				}
				_tmp127_ = st;
				_tmp128_ = vala_struct_get_fields (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_iterable_iterator ((ValaIterable*) _tmp129_);
				_tmp131_ = _tmp130_;
				_vala_iterable_unref0 (_tmp129_);
				field_it = _tmp131_;
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp132_;
					gint _e_size = 0;
					ValaList* _tmp133_;
					gint _tmp134_;
					gint _tmp135_;
					gint _e_index = 0;
					_tmp132_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp132_;
					_tmp133_ = _e_list;
					_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
					_tmp135_ = _tmp134_;
					_e_size = _tmp135_;
					_e_index = -1;
					while (TRUE) {
						ValaExpression* e = NULL;
						ValaList* _tmp136_;
						gpointer _tmp137_;
						ValaField* field = NULL;
						_e_index = _e_index + 1;
						if (!(_e_index < _e_size)) {
							break;
						}
						_tmp136_ = _e_list;
						_tmp137_ = vala_list_get (_tmp136_, _e_index);
						e = (ValaExpression*) _tmp137_;
						field = NULL;
						while (TRUE) {
							ValaField* _tmp138_;
							ValaIterator* _tmp139_;
							ValaIterator* _tmp149_;
							gpointer _tmp150_;
							ValaField* _tmp151_;
							ValaMemberBinding _tmp152_;
							ValaMemberBinding _tmp153_;
							_tmp138_ = field;
							if (!(_tmp138_ == NULL)) {
								break;
							}
							_tmp139_ = field_it;
							if (!vala_iterator_next (_tmp139_)) {
								ValaExpression* _tmp140_;
								ValaSourceReference* _tmp141_;
								ValaSourceReference* _tmp142_;
								ValaDataType* _tmp143_;
								ValaDataType* _tmp144_;
								gchar* _tmp145_;
								gchar* _tmp146_;
								gchar* _tmp147_;
								gchar* _tmp148_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp140_ = e;
								_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp140_);
								_tmp142_ = _tmp141_;
								_tmp143_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp144_ = _tmp143_;
								_tmp145_ = vala_code_node_to_string ((ValaCodeNode*) _tmp144_);
								_tmp146_ = _tmp145_;
								_tmp147_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp146_);
								_tmp148_ = _tmp147_;
								vala_report_error (_tmp142_, _tmp148_);
								_g_free0 (_tmp148_);
								_g_free0 (_tmp146_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (struct_creation);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp149_ = field_it;
							_tmp150_ = vala_iterator_get (_tmp149_);
							_vala_code_node_unref0 (field);
							field = (ValaField*) _tmp150_;
							_tmp151_ = field;
							_tmp152_ = vala_field_get_binding (_tmp151_);
							_tmp153_ = _tmp152_;
							if (_tmp153_ != VALA_MEMBER_BINDING_INSTANCE) {
								_vala_code_node_unref0 (field);
								field = NULL;
							}
						}
						if (in_array_creation_initializer) {
							ValaMemberInitializer* member_init = NULL;
							ValaField* _tmp154_;
							const gchar* _tmp155_;
							const gchar* _tmp156_;
							ValaExpression* _tmp157_;
							ValaExpression* _tmp158_;
							ValaSourceReference* _tmp159_;
							ValaSourceReference* _tmp160_;
							ValaMemberInitializer* _tmp161_;
							ValaObjectCreationExpression* _tmp162_;
							ValaMemberInitializer* _tmp163_;
							_tmp154_ = field;
							_tmp155_ = vala_symbol_get_name ((ValaSymbol*) _tmp154_);
							_tmp156_ = _tmp155_;
							_tmp157_ = e;
							_tmp158_ = e;
							_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp158_);
							_tmp160_ = _tmp159_;
							_tmp161_ = vala_member_initializer_new (_tmp156_, _tmp157_, _tmp160_);
							member_init = _tmp161_;
							_tmp162_ = struct_creation;
							_tmp163_ = member_init;
							vala_object_creation_expression_add_member_initializer (_tmp162_, _tmp163_);
							_vala_code_node_unref0 (member_init);
						} else {
							ValaExpression* _tmp164_;
							ValaField* _tmp165_;
							ValaDataType* _tmp166_;
							ValaDataType* _tmp167_;
							ValaDataType* _tmp168_;
							ValaDataType* _tmp169_;
							ValaDataType* _tmp170_;
							ValaDataType* _tmp171_;
							gboolean _tmp172_;
							gboolean _tmp173_;
							_tmp164_ = e;
							_tmp165_ = field;
							_tmp166_ = vala_variable_get_variable_type ((ValaVariable*) _tmp165_);
							_tmp167_ = _tmp166_;
							_tmp168_ = vala_data_type_copy (_tmp167_);
							_tmp169_ = _tmp168_;
							vala_expression_set_target_type (_tmp164_, _tmp169_);
							_vala_code_node_unref0 (_tmp169_);
							_tmp170_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp171_ = _tmp170_;
							_tmp172_ = vala_data_type_get_value_owned (_tmp171_);
							_tmp173_ = _tmp172_;
							if (!_tmp173_) {
								ValaExpression* _tmp174_;
								ValaDataType* _tmp175_;
								ValaDataType* _tmp176_;
								_tmp174_ = e;
								_tmp175_ = vala_expression_get_target_type (_tmp174_);
								_tmp176_ = _tmp175_;
								vala_data_type_set_value_owned (_tmp176_, FALSE);
							}
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				if (in_array_creation_initializer) {
					ValaCodeNode* _tmp177_;
					ValaCodeNode* _tmp178_;
					ValaObjectCreationExpression* _tmp179_;
					ValaObjectCreationExpression* _tmp180_;
					_tmp177_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp178_ = _tmp177_;
					_tmp179_ = struct_creation;
					vala_code_node_replace_expression (_tmp178_, (ValaExpression*) self, (ValaExpression*) _tmp179_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					_tmp180_ = struct_creation;
					result = vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
					_vala_iterator_unref0 (field_it);
					_vala_code_node_unref0 (struct_creation);
					_vala_code_node_unref0 (st);
					return result;
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (struct_creation);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp181_;
				ValaSourceReference* _tmp182_;
				ValaDataType* _tmp183_;
				ValaDataType* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				gchar* _tmp188_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_code_node_to_string ((ValaCodeNode*) _tmp184_);
				_tmp186_ = _tmp185_;
				_tmp187_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp186_);
				_tmp188_ = _tmp187_;
				vala_report_error (_tmp182_, _tmp188_);
				_g_free0 (_tmp188_);
				_g_free0 (_tmp186_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp189_;
		ValaList* _tmp190_;
		gint _expr_size = 0;
		ValaList* _tmp191_;
		gint _tmp192_;
		gint _tmp193_;
		gint _expr_index = 0;
		_tmp189_ = self->priv->initializers;
		_tmp190_ = _vala_iterable_ref0 (_tmp189_);
		_expr_list = _tmp190_;
		_tmp191_ = _expr_list;
		_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
		_tmp193_ = _tmp192_;
		_expr_size = _tmp193_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp194_;
			gpointer _tmp195_;
			ValaExpression* _tmp196_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp194_ = _expr_list;
			_tmp195_ = vala_list_get (_tmp194_, _expr_index);
			expr = (ValaExpression*) _tmp195_;
			_tmp196_ = expr;
			vala_code_node_check ((ValaCodeNode*) _tmp196_, context);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp197_;
		gint _e_size = 0;
		ValaList* _tmp198_;
		gint _tmp199_;
		gint _tmp200_;
		gint _e_index = 0;
		_tmp197_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp197_;
		_tmp198_ = _e_list;
		_tmp199_ = vala_collection_get_size ((ValaCollection*) _tmp198_);
		_tmp200_ = _tmp199_;
		_e_size = _tmp200_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp201_;
			gpointer _tmp202_;
			ValaExpression* _tmp203_;
			ValaDataType* _tmp204_;
			ValaDataType* _tmp205_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp209_;
			ValaUnaryExpression* _tmp210_;
			gboolean _tmp211_ = FALSE;
			ValaUnaryExpression* _tmp212_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp201_ = _e_list;
			_tmp202_ = vala_list_get (_tmp201_, _e_index);
			e = (ValaExpression*) _tmp202_;
			_tmp203_ = e;
			_tmp204_ = vala_expression_get_value_type (_tmp203_);
			_tmp205_ = _tmp204_;
			if (_tmp205_ == NULL) {
				ValaExpression* _tmp206_;
				ValaSourceReference* _tmp207_;
				ValaSourceReference* _tmp208_;
				_error_ = TRUE;
				_tmp206_ = e;
				_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp206_);
				_tmp208_ = _tmp207_;
				vala_report_error (_tmp208_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp209_ = e;
			_tmp210_ = _vala_code_node_ref0 (VALA_IS_UNARY_EXPRESSION (_tmp209_) ? ((ValaUnaryExpression*) _tmp209_) : NULL);
			unary = _tmp210_;
			_tmp212_ = unary;
			if (_tmp212_ != NULL) {
				gboolean _tmp213_ = FALSE;
				ValaUnaryExpression* _tmp214_;
				ValaUnaryOperator _tmp215_;
				ValaUnaryOperator _tmp216_;
				_tmp214_ = unary;
				_tmp215_ = vala_unary_expression_get_operator (_tmp214_);
				_tmp216_ = _tmp215_;
				if (_tmp216_ == VALA_UNARY_OPERATOR_REF) {
					_tmp213_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp217_;
					ValaUnaryOperator _tmp218_;
					ValaUnaryOperator _tmp219_;
					_tmp217_ = unary;
					_tmp218_ = vala_unary_expression_get_operator (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp213_ = _tmp219_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp211_ = _tmp213_;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
			} else {
				ValaExpression* _tmp220_;
				ValaDataType* _tmp221_;
				ValaDataType* _tmp222_;
				ValaExpression* _tmp223_;
				ValaDataType* _tmp224_;
				ValaDataType* _tmp225_;
				_tmp220_ = e;
				_tmp221_ = vala_expression_get_value_type (_tmp220_);
				_tmp222_ = _tmp221_;
				_tmp223_ = e;
				_tmp224_ = vala_expression_get_target_type (_tmp223_);
				_tmp225_ = _tmp224_;
				if (!vala_data_type_compatible (_tmp222_, _tmp225_)) {
					ValaExpression* _tmp226_;
					ValaExpression* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaSourceReference* _tmp229_;
					ValaExpression* _tmp230_;
					ValaDataType* _tmp231_;
					ValaDataType* _tmp232_;
					gchar* _tmp233_;
					gchar* _tmp234_;
					ValaExpression* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					gchar* _tmp238_;
					gchar* _tmp239_;
					gchar* _tmp240_;
					gchar* _tmp241_;
					_error_ = TRUE;
					_tmp226_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp226_, TRUE);
					_tmp227_ = e;
					_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp227_);
					_tmp229_ = _tmp228_;
					_tmp230_ = e;
					_tmp231_ = vala_expression_get_target_type (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_code_node_to_string ((ValaCodeNode*) _tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = e;
					_tmp236_ = vala_expression_get_value_type (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = vala_code_node_to_string ((ValaCodeNode*) _tmp237_);
					_tmp239_ = _tmp238_;
					_tmp240_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp234_, _tmp239_);
					_tmp241_ = _tmp240_;
					vala_report_error (_tmp229_, _tmp241_);
					_g_free0 (_tmp241_);
					_g_free0 (_tmp239_);
					_g_free0 (_tmp234_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	if (!_error_) {
		ValaDataType* _tmp242_;
		ValaDataType* _tmp243_;
		ValaDataType* _tmp244_;
		ValaDataType* _tmp245_;
		ValaDataType* _tmp246_;
		ValaDataType* _tmp247_;
		_tmp242_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_data_type_copy (_tmp243_);
		_tmp245_ = _tmp244_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp245_);
		_vala_code_node_unref0 (_tmp245_);
		_tmp246_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp247_ = _tmp246_;
		vala_data_type_set_nullable (_tmp247_, FALSE);
	}
	_tmp248_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp249_ = _tmp248_;
	if (_tmp249_ != NULL) {
		ValaDataType* _tmp250_;
		ValaDataType* _tmp251_;
		_tmp250_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp251_ = _tmp250_;
		vala_code_node_check ((ValaCodeNode*) _tmp251_, context);
	}
	result = !_error_;
	return result;
}

static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
vala_initializer_list_class_init (ValaInitializerListClass * klass,
                                  gpointer klass_data)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInitializerList_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}

static void
vala_initializer_list_instance_init (ValaInitializerList * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_initializer_list_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}

static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}

/**
 * Represents an array or struct initializer list in the source code.
 */
GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		ValaInitializerList_private_offset = g_type_add_instance_private (vala_initializer_list_type_id, sizeof (ValaInitializerListPrivate));
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}

