// RUN: llvm-mc -triple i386-unknown-unknown %s | FileCheck %s

# Immediates
# CHECK: addl $1, %eax
        addl $1, %eax
# CHECK: addl $3, %eax
        addl $(1+2), %eax
# CHECK: addl $a, %eax
        addl $a, %eax
# CHECK: addl $3, %eax
        addl $1 + 2, %eax

# Disambiguation

# CHECK: addl $1, 8
        addl $1, 4+4
# CHECK: addl $1, 8
        addl $1, (4+4)
# CHECK: addl $1, 8(%eax)
        addl $1, 4+4(%eax)
# CHECK: addl $1, 8(%eax)
        addl $1, (4+4)(%eax)
# CHECK: addl $1, 8(%eax)
        addl $1, 8(%eax)
# CHECK: addl $1, (%eax)
        addl $1, (%eax)
# CHECK: addl $1, 8(,%eax)
        addl $1, (4+4)(,%eax)

# Indirect Memory Operands
# CHECK: addl $1, 1(%eax)
        addl $1, 1(%eax)
# CHECK: addl $1, 1(%eax,%ebx)
        addl $1, 1(%eax,%ebx)
# CHECK: addl $1, 1(%eax,%ebx)
        addl $1, 1(%eax,%ebx,)
# CHECK: addl $1, 1(%eax,%ebx,4)
        addl $1, 1(%eax,%ebx,4)
# CHECK: addl $1, 1(,%ebx)
        addl $1, 1(,%ebx)
# CHECK: addl $1, 1(,%ebx)
        addl $1, 1(,%ebx,)
# CHECK: addl $1, 1(,%ebx,4)
        addl $1, 1(,%ebx,4)
# CHECK: addl $1, 1(,%ebx,4)
        addl $1, 1(,%ebx,(2+2))

# '*'
# CHECK: calll a
        call a
# CHECK: calll *%eax
        call *%eax
# CHECK: calll *4(%eax)
        call *4(%eax)
foo:
	calll foo()
# CHECK: calll foo{{$}}
	calll foo(,)
# CHECK: calll foo{{$}}

# CHECK: movl	%gs:8, %eax
movl %gs:8, %eax

# Make sure we handle parsing uses of variables assigned
# to registers in operands.

v_ecx = %ecx
v_eax = %eax
v_gs  = %gs
v_imm = 4

#CHECK:	movl %eax, %ecx
	movl %eax, v_ecx

#CHECK: movl $1, %gs:0
	movl $1, v_gs:(,)
#CHECK: movl $1, %gs:(,%eax)
	movl $1, v_gs:(,%eax)
#CHECK: movl $1, %gs:(,%eax,2)
	movl $1, v_gs:(,%eax,2)
#CHECK: movl $1, %gs:(,%eax,4)
	movl $1, v_gs:(,%eax,v_imm)
#CHECK: movl $1, %gs:(,%eax)
	movl $1, v_gs:(,v_eax)
#CHECK: movl $1, %gs:(,%eax,2)
	movl $1, v_gs:(,v_eax,2)
#CHECK: movl $1, %gs:(,%eax,4)
	movl $1, v_gs:(,v_eax,v_imm)
#CHECK: movl $1, %gs:(%ecx)
	movl $1, v_gs:(%ecx)
#CHECK: movl $1, %gs:(%ecx)
	movl $1, v_gs:(%ecx,)
#CHECK: movl $1, %gs:(%ecx,%eax)
	movl $1, v_gs:(%ecx,%eax)
#CHECK: movl $1, %gs:(%ecx,%eax,2)
	movl $1, v_gs:(%ecx,%eax,2)
#CHECK: movl $1, %gs:(%ecx,%eax,4)
	movl $1, v_gs:(%ecx,%eax,v_imm)
#CHECK: movl $1, %gs:(%ecx,%eax)
	movl $1, v_gs:(%ecx,v_eax)
#CHECK: movl $1, %gs:(%ecx,%eax,2)
	movl $1, v_gs:(%ecx,v_eax,2)
#CHECK: movl $1, %gs:(%ecx,%eax,4)
	movl $1, v_gs:(%ecx,v_eax,v_imm)
#CHECK: movl $1, %gs:(%ecx)
	movl $1, v_gs:(v_ecx)
#CHECK: movl $1, %gs:(%ecx)
	movl $1, v_gs:(v_ecx,)
#CHECK: movl $1, %gs:(%ecx,%eax)
	movl $1, v_gs:(v_ecx,%eax)
#CHECK: movl $1, %gs:(%ecx,%eax,2)
	movl $1, v_gs:(v_ecx,%eax,2)
#CHECK: movl $1, %gs:(%ecx,%eax,4)
	movl $1, v_gs:(v_ecx,%eax,v_imm)
#CHECK: movl $1, %gs:(%ecx,%eax)
	movl $1, v_gs:(v_ecx,v_eax)
#CHECK: movl $1, %gs:(%ecx,%eax,2)
	movl $1, v_gs:(v_ecx,v_eax,2)
#CHECK: movl $1, %gs:(%ecx,%eax,4)
	movl $1, v_gs:(v_ecx,v_eax,v_imm)
#CHECK: movl $1, %gs:4
	movl $1, v_gs:4
#CHECK: movl $1, %gs:4
	movl $1, v_gs:4()
#CHECK: movl $1, %gs:4
	movl $1, v_gs:4(,)
#CHECK: movl $1, %gs:4(,%eax)
	movl $1, v_gs:4(,%eax)
#CHECK: movl $1, %gs:4(,%eax,2)
	movl $1, v_gs:4(,%eax,2)
#CHECK: movl $1, %gs:4(,%eax,4)
	movl $1, v_gs:4(,%eax,v_imm)
#CHECK: movl $1, %gs:4(,%eax)
	movl $1, v_gs:4(,v_eax)
#CHECK: movl $1, %gs:4(,%eax,2)
	movl $1, v_gs:4(,v_eax,2)
#CHECK: movl $1, %gs:4(,%eax,4)
	movl $1, v_gs:4(,v_eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:4(%ecx)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:4(%ecx,)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:4(%ecx,%eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:4(%ecx,%eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:4(%ecx,%eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:4(%ecx,v_eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:4(%ecx,v_eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:4(%ecx,v_eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:4(v_ecx)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:4(v_ecx,)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:4(v_ecx,%eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:4(v_ecx,%eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:4(v_ecx,%eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:4(v_ecx,v_eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:4(v_ecx,v_eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:4(v_ecx,v_eax,v_imm)
#CHECK: movl $1, %gs:4
	movl $1, v_gs:v_imm
#CHECK: movl $1, %gs:4
	movl $1, v_gs:v_imm()
#CHECK: movl $1, %gs:4
	movl $1, v_gs:v_imm(,)
#CHECK: movl $1, %gs:4(,%eax)
	movl $1, v_gs:v_imm(,%eax)
#CHECK: movl $1, %gs:4(,%eax,2)
	movl $1, v_gs:v_imm(,%eax,2)
#CHECK: movl $1, %gs:4(,%eax,4)
	movl $1, v_gs:v_imm(,%eax,v_imm)
#CHECK: movl $1, %gs:4(,%eax)
	movl $1, v_gs:v_imm(,v_eax)
#CHECK: movl $1, %gs:4(,%eax,2)
	movl $1, v_gs:v_imm(,v_eax,2)
#CHECK: movl $1, %gs:4(,%eax,4)
	movl $1, v_gs:v_imm(,v_eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:v_imm(%ecx)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:v_imm(%ecx,)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:v_imm(%ecx,%eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:v_imm(%ecx,%eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:v_imm(%ecx,%eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:v_imm(%ecx,v_eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:v_imm(%ecx,v_eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:v_imm(%ecx,v_eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:v_imm(v_ecx)
#CHECK: movl $1, %gs:4(%ecx)
	movl $1, v_gs:v_imm(v_ecx,)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:v_imm(v_ecx,%eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:v_imm(v_ecx,%eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:v_imm(v_ecx,%eax,v_imm)
#CHECK: movl $1, %gs:4(%ecx,%eax)
	movl $1, v_gs:v_imm(v_ecx,v_eax)
#CHECK: movl $1, %gs:4(%ecx,%eax,2)
	movl $1, v_gs:v_imm(v_ecx,v_eax,2)
#CHECK: movl $1, %gs:4(%ecx,%eax,4)
	movl $1, v_gs:v_imm(v_ecx,v_eax,v_imm)
#CHECK: movl $1, %gs:8
	movl $1, v_gs:(v_imm+4)
#CHECK: movl $1, %gs:8
	movl $1, v_gs:(v_imm+4)()
#CHECK: movl $1, %gs:8
	movl $1, v_gs:(v_imm+4)(,)
#CHECK: movl $1, %gs:8(,%eax)
	movl $1, v_gs:(v_imm+4)(,%eax)
#CHECK: movl $1, %gs:8(,%eax,2)
	movl $1, v_gs:(v_imm+4)(,%eax,2)
#CHECK: movl $1, %gs:8(,%eax,4)
	movl $1, v_gs:(v_imm+4)(,%eax,v_imm)
#CHECK: movl $1, %gs:8(,%eax)
	movl $1, v_gs:(v_imm+4)(,v_eax)
#CHECK: movl $1, %gs:8(,%eax,2)
	movl $1, v_gs:(v_imm+4)(,v_eax,2)
#CHECK: movl $1, %gs:8(,%eax,4)
	movl $1, v_gs:(v_imm+4)(,v_eax,v_imm)
#CHECK: movl $1, %gs:8(%ecx)
	movl $1, v_gs:(v_imm+4)(%ecx)
#CHECK: movl $1, %gs:8(%ecx)
	movl $1, v_gs:(v_imm+4)(%ecx,)
#CHECK: movl $1, %gs:8(%ecx,%eax)
	movl $1, v_gs:(v_imm+4)(%ecx,%eax)
#CHECK: movl $1, %gs:8(%ecx,%eax,2)
	movl $1, v_gs:(v_imm+4)(%ecx,%eax,2)
#CHECK: movl $1, %gs:8(%ecx,%eax,4)
	movl $1, v_gs:(v_imm+4)(%ecx,%eax,v_imm)
#CHECK: movl $1, %gs:8(%ecx,%eax)
	movl $1, v_gs:(v_imm+4)(%ecx,v_eax)
#CHECK: movl $1, %gs:8(%ecx,%eax,2)
	movl $1, v_gs:(v_imm+4)(%ecx,v_eax,2)
#CHECK: movl $1, %gs:8(%ecx,%eax,4)
	movl $1, v_gs:(v_imm+4)(%ecx,v_eax,v_imm)
#CHECK: movl $1, %gs:8(%ecx)
	movl $1, v_gs:(v_imm+4)(v_ecx)
#CHECK: movl $1, %gs:8(%ecx)
	movl $1, v_gs:(v_imm+4)(v_ecx,)
#CHECK: movl $1, %gs:8(%ecx,%eax)
	movl $1, v_gs:(v_imm+4)(v_ecx,%eax)
#CHECK: movl $1, %gs:8(%ecx,%eax,2)
	movl $1, v_gs:(v_imm+4)(v_ecx,%eax,2)
#CHECK: movl $1, %gs:8(%ecx,%eax,4)
	movl $1, v_gs:(v_imm+4)(v_ecx,%eax,v_imm)
#CHECK: movl $1, %gs:8(%ecx,%eax)
	movl $1, v_gs:(v_imm+4)(v_ecx,v_eax)
#CHECK: movl $1, %gs:8(%ecx,%eax,2)
	movl $1, v_gs:(v_imm+4)(v_ecx,v_eax,2)
#CHECK: movl $1, %gs:8(%ecx,%eax,4)
	movl $1, v_gs:(v_imm+4)(v_ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:0
	movl $1, %fs:(,)
#CHECK: movl $1, %fs:(,%eax)
	movl $1, %fs:(,%eax)
#CHECK: movl $1, %fs:(,%eax,2)
	movl $1, %fs:(,%eax,2)
#CHECK: movl $1, %fs:(,%eax,4)
	movl $1, %fs:(,%eax,v_imm)
#CHECK: movl $1, %fs:(,%eax)
	movl $1, %fs:(,v_eax)
#CHECK: movl $1, %fs:(,%eax,2)
	movl $1, %fs:(,v_eax,2)
#CHECK: movl $1, %fs:(,%eax,4)
	movl $1, %fs:(,v_eax,v_imm)
#CHECK: movl $1, %fs:(%ecx)
	movl $1, %fs:(%ecx)
#CHECK: movl $1, %fs:(%ecx)
	movl $1, %fs:(%ecx,)
#CHECK: movl $1, %fs:(%ecx,%eax)
	movl $1, %fs:(%ecx,%eax)
#CHECK: movl $1, %fs:(%ecx,%eax,2)
	movl $1, %fs:(%ecx,%eax,2)
#CHECK: movl $1, %fs:(%ecx,%eax,4)
	movl $1, %fs:(%ecx,%eax,v_imm)
#CHECK: movl $1, %fs:(%ecx,%eax)
	movl $1, %fs:(%ecx,v_eax)
#CHECK: movl $1, %fs:(%ecx,%eax,2)
	movl $1, %fs:(%ecx,v_eax,2)
#CHECK: movl $1, %fs:(%ecx,%eax,4)
	movl $1, %fs:(%ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:(%ecx)
	movl $1, %fs:(v_ecx)
#CHECK: movl $1, %fs:(%ecx)
	movl $1, %fs:(v_ecx,)
#CHECK: movl $1, %fs:(%ecx,%eax)
	movl $1, %fs:(v_ecx,%eax)
#CHECK: movl $1, %fs:(%ecx,%eax,2)
	movl $1, %fs:(v_ecx,%eax,2)
#CHECK: movl $1, %fs:(%ecx,%eax,4)
	movl $1, %fs:(v_ecx,%eax,v_imm)
#CHECK: movl $1, %fs:(%ecx,%eax)
	movl $1, %fs:(v_ecx,v_eax)
#CHECK: movl $1, %fs:(%ecx,%eax,2)
	movl $1, %fs:(v_ecx,v_eax,2)
#CHECK: movl $1, %fs:(%ecx,%eax,4)
	movl $1, %fs:(v_ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:4
	movl $1, %fs:4
#CHECK: movl $1, %fs:4
	movl $1, %fs:4()
#CHECK: movl $1, %fs:4
	movl $1, %fs:4(,)
#CHECK: movl $1, %fs:4(,%eax)
	movl $1, %fs:4(,%eax)
#CHECK: movl $1, %fs:4(,%eax,2)
	movl $1, %fs:4(,%eax,2)
#CHECK: movl $1, %fs:4(,%eax,4)
	movl $1, %fs:4(,%eax,v_imm)
#CHECK: movl $1, %fs:4(,%eax)
	movl $1, %fs:4(,v_eax)
#CHECK: movl $1, %fs:4(,%eax,2)
	movl $1, %fs:4(,v_eax,2)
#CHECK: movl $1, %fs:4(,%eax,4)
	movl $1, %fs:4(,v_eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:4(%ecx)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:4(%ecx,)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:4(%ecx,%eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:4(%ecx,%eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:4(%ecx,%eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:4(%ecx,v_eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:4(%ecx,v_eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:4(%ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:4(v_ecx)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:4(v_ecx,)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:4(v_ecx,%eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:4(v_ecx,%eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:4(v_ecx,%eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:4(v_ecx,v_eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:4(v_ecx,v_eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:4(v_ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:4
	movl $1, %fs:v_imm
#CHECK: movl $1, %fs:4
	movl $1, %fs:v_imm()
#CHECK: movl $1, %fs:4
	movl $1, %fs:v_imm(,)
#CHECK: movl $1, %fs:4(,%eax)
	movl $1, %fs:v_imm(,%eax)
#CHECK: movl $1, %fs:4(,%eax,2)
	movl $1, %fs:v_imm(,%eax,2)
#CHECK: movl $1, %fs:4(,%eax,4)
	movl $1, %fs:v_imm(,%eax,v_imm)
#CHECK: movl $1, %fs:4(,%eax)
	movl $1, %fs:v_imm(,v_eax)
#CHECK: movl $1, %fs:4(,%eax,2)
	movl $1, %fs:v_imm(,v_eax,2)
#CHECK: movl $1, %fs:4(,%eax,4)
	movl $1, %fs:v_imm(,v_eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:v_imm(%ecx)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:v_imm(%ecx,)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:v_imm(%ecx,%eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:v_imm(%ecx,%eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:v_imm(%ecx,%eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:v_imm(%ecx,v_eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:v_imm(%ecx,v_eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:v_imm(%ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:v_imm(v_ecx)
#CHECK: movl $1, %fs:4(%ecx)
	movl $1, %fs:v_imm(v_ecx,)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:v_imm(v_ecx,%eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:v_imm(v_ecx,%eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:v_imm(v_ecx,%eax,v_imm)
#CHECK: movl $1, %fs:4(%ecx,%eax)
	movl $1, %fs:v_imm(v_ecx,v_eax)
#CHECK: movl $1, %fs:4(%ecx,%eax,2)
	movl $1, %fs:v_imm(v_ecx,v_eax,2)
#CHECK: movl $1, %fs:4(%ecx,%eax,4)
	movl $1, %fs:v_imm(v_ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:8
	movl $1, %fs:(v_imm+4)
#CHECK: movl $1, %fs:8
	movl $1, %fs:(v_imm+4)()
#CHECK: movl $1, %fs:8
	movl $1, %fs:(v_imm+4)(,)
#CHECK: movl $1, %fs:8(,%eax)
	movl $1, %fs:(v_imm+4)(,%eax)
#CHECK: movl $1, %fs:8(,%eax,2)
	movl $1, %fs:(v_imm+4)(,%eax,2)
#CHECK: movl $1, %fs:8(,%eax,4)
	movl $1, %fs:(v_imm+4)(,%eax,v_imm)
#CHECK: movl $1, %fs:8(,%eax)
	movl $1, %fs:(v_imm+4)(,v_eax)
#CHECK: movl $1, %fs:8(,%eax,2)
	movl $1, %fs:(v_imm+4)(,v_eax,2)
#CHECK: movl $1, %fs:8(,%eax,4)
	movl $1, %fs:(v_imm+4)(,v_eax,v_imm)
#CHECK: movl $1, %fs:8(%ecx)
	movl $1, %fs:(v_imm+4)(%ecx)
#CHECK: movl $1, %fs:8(%ecx)
	movl $1, %fs:(v_imm+4)(%ecx,)
#CHECK: movl $1, %fs:8(%ecx,%eax)
	movl $1, %fs:(v_imm+4)(%ecx,%eax)
#CHECK: movl $1, %fs:8(%ecx,%eax,2)
	movl $1, %fs:(v_imm+4)(%ecx,%eax,2)
#CHECK: movl $1, %fs:8(%ecx,%eax,4)
	movl $1, %fs:(v_imm+4)(%ecx,%eax,v_imm)
#CHECK: movl $1, %fs:8(%ecx,%eax)
	movl $1, %fs:(v_imm+4)(%ecx,v_eax)
#CHECK: movl $1, %fs:8(%ecx,%eax,2)
	movl $1, %fs:(v_imm+4)(%ecx,v_eax,2)
#CHECK: movl $1, %fs:8(%ecx,%eax,4)
	movl $1, %fs:(v_imm+4)(%ecx,v_eax,v_imm)
#CHECK: movl $1, %fs:8(%ecx)
	movl $1, %fs:(v_imm+4)(v_ecx)
#CHECK: movl $1, %fs:8(%ecx)
	movl $1, %fs:(v_imm+4)(v_ecx,)
#CHECK: movl $1, %fs:8(%ecx,%eax)
	movl $1, %fs:(v_imm+4)(v_ecx,%eax)
#CHECK: movl $1, %fs:8(%ecx,%eax,2)
	movl $1, %fs:(v_imm+4)(v_ecx,%eax,2)
#CHECK: movl $1, %fs:8(%ecx,%eax,4)
	movl $1, %fs:(v_imm+4)(v_ecx,%eax,v_imm)
#CHECK: movl $1, %fs:8(%ecx,%eax)
	movl $1, %fs:(v_imm+4)(v_ecx,v_eax)
#CHECK: movl $1, %fs:8(%ecx,%eax,2)
	movl $1, %fs:(v_imm+4)(v_ecx,v_eax,2)
#CHECK: movl $1, %fs:8(%ecx,%eax,4)
	movl $1, %fs:(v_imm+4)(v_ecx,v_eax,v_imm)
