// license:BSD-3-Clause
// copyright-holders:Miodrag Milanovic
/*
    Stern Whitestar (modified)
*/


#include "emu.h"
#include "cpu/m6809/m6809.h"

class whitestar_mod_state : public driver_device
{
public:
	whitestar_mod_state(const machine_config &mconfig, device_type type, const char *tag)
		: driver_device(mconfig, type, tag),
			m_maincpu(*this, "maincpu")
	{ }

	void whitestar_mod(machine_config &config);

	void init_whitestar_mod();

private:
	void whitestar_mod_map(address_map &map);

	// devices
	required_device<cpu_device> m_maincpu;

	// driver_device overrides
	virtual void machine_reset() override;
};


void whitestar_mod_state::whitestar_mod_map(address_map &map)
{
	map(0x0000, 0xffff).noprw();
}

static INPUT_PORTS_START( whitestar_mod )
INPUT_PORTS_END

void whitestar_mod_state::machine_reset()
{
}

void whitestar_mod_state::init_whitestar_mod()
{
}

void whitestar_mod_state::whitestar_mod(machine_config &config)
{
	/* basic machine hardware */
	MC6809E(config, m_maincpu, 2000000);
	m_maincpu->set_addrmap(AS_PROGRAM, &whitestar_mod_state::whitestar_mod_map);
}

/*-------------------------------------------------------------------
/ Elvis
/-------------------------------------------------------------------*/
ROM_START(elvisp)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("elvscpua.500", 0x00000, 0x20000, CRC(aae9d65d) SHA1(d6e789f7257448e97697c406561c14a0abc45187))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("elvsdspa.500", 0x00000, 0x80000, CRC(76a672cb) SHA1(8a9d4ac9538f0f91f2e95800147478cbaeb152a5))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvis.u7",0x0000,0x10000,CRC(1df6c1b5) SHA1(7a9ebfc555e54ce92ad140ac6fcb82d9848ad8a6))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvis.u17", 0x000000, 0x100000, CRC(ff032897) SHA1(bf347c26a450bc07cdc94fc582dedf3a0cdc2a1b))
	ROM_LOAD("elvis.u21", 0x100000, 0x100000, CRC(c3c19a40) SHA1(97f7f36eed62ca389c770bf5d746721724e17250))
	ROM_LOAD("elvis.u36", 0x200000, 0x100000, CRC(e98f0dc9) SHA1(6dbab09435e993fef97d6a80a73675723bea7c1d))
	ROM_LOAD("elvis.u37", 0x300000, 0x100000, CRC(88ba0966) SHA1(43ea198c9fcdc1c396d4180308042c6c08311829))
ROM_END

ROM_START(elvisp4)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpua.400",  0x0000, 0x20000, CRC(385be9ed) SHA1(c25b54a9b52bece17de9c394c019a4d2649bcf47))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspa.401",  0x0000, 0x80000, CRC(fb08d5c3) SHA1(03f9886381d32bfd012a2663d2b7331a76c8c1c0))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvis.u7",0x0000,0x10000,CRC(1df6c1b5) SHA1(7a9ebfc555e54ce92ad140ac6fcb82d9848ad8a6))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvis.u17", 0x000000, 0x100000, CRC(ff032897) SHA1(bf347c26a450bc07cdc94fc582dedf3a0cdc2a1b))
	ROM_LOAD("elvis.u21", 0x100000, 0x100000, CRC(c3c19a40) SHA1(97f7f36eed62ca389c770bf5d746721724e17250))
	ROM_LOAD("elvis.u36", 0x200000, 0x100000, CRC(e98f0dc9) SHA1(6dbab09435e993fef97d6a80a73675723bea7c1d))
	ROM_LOAD("elvis.u37", 0x300000, 0x100000, CRC(88ba0966) SHA1(43ea198c9fcdc1c396d4180308042c6c08311829))
ROM_END

ROM_START(elvisp303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpua.303",  0x0000, 0x20000, CRC(a0dd77d8) SHA1(2882eed805c2eb3cabadcfe51997a534ddac9050))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspa.302",  0x0000, 0x80000, CRC(892da6d2) SHA1(66a2f9faab9c7b925a90455ce7e1d31e19fce99e))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvis.u7",0x0000,0x10000,CRC(1df6c1b5) SHA1(7a9ebfc555e54ce92ad140ac6fcb82d9848ad8a6))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvis.u17", 0x000000, 0x100000, CRC(ff032897) SHA1(bf347c26a450bc07cdc94fc582dedf3a0cdc2a1b))
	ROM_LOAD("elvis.u21", 0x100000, 0x100000, CRC(c3c19a40) SHA1(97f7f36eed62ca389c770bf5d746721724e17250))
	ROM_LOAD("elvis.u36", 0x200000, 0x100000, CRC(e98f0dc9) SHA1(6dbab09435e993fef97d6a80a73675723bea7c1d))
	ROM_LOAD("elvis.u37", 0x300000, 0x100000, CRC(88ba0966) SHA1(43ea198c9fcdc1c396d4180308042c6c08311829))
ROM_END

ROM_START(elvisp302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpua.302",  0x0000, 0x20000, CRC(52fd7068) SHA1(548568aeb30a17541b07489dfecde9d4d63bf82b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspa.302",  0x0000, 0x80000, CRC(892da6d2) SHA1(66a2f9faab9c7b925a90455ce7e1d31e19fce99e))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvis.u7",0x0000,0x10000,CRC(1df6c1b5) SHA1(7a9ebfc555e54ce92ad140ac6fcb82d9848ad8a6))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvis.u17", 0x000000, 0x100000, CRC(ff032897) SHA1(bf347c26a450bc07cdc94fc582dedf3a0cdc2a1b))
	ROM_LOAD("elvis.u21", 0x100000, 0x100000, CRC(c3c19a40) SHA1(97f7f36eed62ca389c770bf5d746721724e17250))
	ROM_LOAD("elvis.u36", 0x200000, 0x100000, CRC(e98f0dc9) SHA1(6dbab09435e993fef97d6a80a73675723bea7c1d))
	ROM_LOAD("elvis.u37", 0x300000, 0x100000, CRC(88ba0966) SHA1(43ea198c9fcdc1c396d4180308042c6c08311829))
ROM_END

ROM_START(elvisl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("elvscpul.500", 0x00000, 0x20000, CRC(d6813d67) SHA1(863a1b5bc62eca218f64d9bae24b205e1a8e2b6c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("elvsdspl.500", 0x00000, 0x80000, CRC(68946b3b) SHA1(5764a5f6779097acfcf82eb176f6d966f6bb6988))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisl.u7",0x0000,0x10000,CRC(f0d70ee6) SHA1(9fa2c9d7b3690ec0c17645be066496d6833da5d1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisl.u17", 0x000000, 0x100000, CRC(2f86bcda) SHA1(73972fd30e84a2f97478f076cc8771c501440be5))
	ROM_LOAD("elvisl.u21", 0x100000, 0x100000, CRC(400c7174) SHA1(a4fa0d51b7c11e70f6b93068a6bf859cdf3359c3))
	ROM_LOAD("elvisl.u36", 0x200000, 0x100000, CRC(01ebbdbe) SHA1(286fa471b20b6ffcb0114d66239ab6aebe9bca9d))
	ROM_LOAD("elvisl.u37", 0x300000, 0x100000, CRC(bed26746) SHA1(385cb77ec7599b12a4b021c53b42b8e9b9fb08a8))
ROM_END

ROM_START(elvisl4)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpul.400",  0x0000, 0x20000, CRC(536d4e3c) SHA1(3470ffdc32dbce9142dab82c25915d617e1429e6))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspl.401",  0x0000, 0x80000, CRC(57fc6ed2) SHA1(3349a56ce38ab4ffdf1469bac8dbc9d08c077f6e))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisl.u7",0x0000,0x10000,CRC(f0d70ee6) SHA1(9fa2c9d7b3690ec0c17645be066496d6833da5d1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisl.u17", 0x000000, 0x100000, CRC(2f86bcda) SHA1(73972fd30e84a2f97478f076cc8771c501440be5))
	ROM_LOAD("elvisl.u21", 0x100000, 0x100000, CRC(400c7174) SHA1(a4fa0d51b7c11e70f6b93068a6bf859cdf3359c3))
	ROM_LOAD("elvisl.u36", 0x200000, 0x100000, CRC(01ebbdbe) SHA1(286fa471b20b6ffcb0114d66239ab6aebe9bca9d))
	ROM_LOAD("elvisl.u37", 0x300000, 0x100000, CRC(bed26746) SHA1(385cb77ec7599b12a4b021c53b42b8e9b9fb08a8))
ROM_END

ROM_START(elvisl303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpul.303",  0x0000, 0x20000, CRC(691b9882) SHA1(fd8ceef9dbae6c788964d417ad1c61a4bb8e0d9b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspl.302",  0x0000, 0x80000, CRC(f75ea4cb) SHA1(aa351bb0912fd9dc93e9c95f96af2d31aaf03777))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisl.u7",0x0000,0x10000,CRC(f0d70ee6) SHA1(9fa2c9d7b3690ec0c17645be066496d6833da5d1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisl.u17", 0x000000, 0x100000, CRC(2f86bcda) SHA1(73972fd30e84a2f97478f076cc8771c501440be5))
	ROM_LOAD("elvisl.u21", 0x100000, 0x100000, CRC(400c7174) SHA1(a4fa0d51b7c11e70f6b93068a6bf859cdf3359c3))
	ROM_LOAD("elvisl.u36", 0x200000, 0x100000, CRC(01ebbdbe) SHA1(286fa471b20b6ffcb0114d66239ab6aebe9bca9d))
	ROM_LOAD("elvisl.u37", 0x300000, 0x100000, CRC(bed26746) SHA1(385cb77ec7599b12a4b021c53b42b8e9b9fb08a8))
ROM_END

ROM_START(elvisl302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpul.302",  0x0000, 0x20000, CRC(0c6f1897) SHA1(ac71f833d4227c2d2d665a169eb0d12c73aeab04))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspl.302",  0x0000, 0x80000, CRC(f75ea4cb) SHA1(aa351bb0912fd9dc93e9c95f96af2d31aaf03777))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisl.u7",0x0000,0x10000,CRC(f0d70ee6) SHA1(9fa2c9d7b3690ec0c17645be066496d6833da5d1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisl.u17", 0x000000, 0x100000, CRC(2f86bcda) SHA1(73972fd30e84a2f97478f076cc8771c501440be5))
	ROM_LOAD("elvisl.u21", 0x100000, 0x100000, CRC(400c7174) SHA1(a4fa0d51b7c11e70f6b93068a6bf859cdf3359c3))
	ROM_LOAD("elvisl.u36", 0x200000, 0x100000, CRC(01ebbdbe) SHA1(286fa471b20b6ffcb0114d66239ab6aebe9bca9d))
	ROM_LOAD("elvisl.u37", 0x300000, 0x100000, CRC(bed26746) SHA1(385cb77ec7599b12a4b021c53b42b8e9b9fb08a8))
ROM_END

ROM_START(elvisg)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("elvscpug.500", 0x00000, 0x20000, CRC(1582dd3a) SHA1(9a5d044dbad03e3ec2358ef16d983195761cb17b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("elvsdspg.500", 0x00000, 0x80000, CRC(4b6e7d37) SHA1(259a5d0d11392f05504d4477cf03f2a270db670c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisg.u7",0x0000,0x10000,CRC(1085bd7c) SHA1(2c34ee7d7c44906b0894c0c01b0fad74cb0d2a32))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisg.u17", 0x000000, 0x100000, CRC(8b888d75) SHA1(b8c654d0fb558c205c338be2b458cbf931b23bac))
	ROM_LOAD("elvisg.u21", 0x100000, 0x100000, CRC(79955b60) SHA1(36ad9e487408c9fd26641d484490b1b3bc8e1194))
	ROM_LOAD("elvisg.u36", 0x200000, 0x100000, CRC(25ba1ad4) SHA1(1e1a846af4ff43bb47f081b0cc179cd732c0bbea))
	ROM_LOAD("elvisg.u37", 0x300000, 0x100000, CRC(f6d7a2a0) SHA1(54c160a298c7ead1fe0404bce51bc16211da82cf))
ROM_END

ROM_START(elvisg4)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpug.400",  0x0000, 0x20000, CRC(c5992b96) SHA1(0e8c285b76374daad17017994cd9d8e68a98ba42))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspg.401",  0x0000, 0x80000, CRC(a694f642) SHA1(a44febcc08445f53aa96b0c791a636d541cebb97))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisg.u7",0x0000,0x10000,CRC(1085bd7c) SHA1(2c34ee7d7c44906b0894c0c01b0fad74cb0d2a32))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisg.u17", 0x000000, 0x100000, CRC(8b888d75) SHA1(b8c654d0fb558c205c338be2b458cbf931b23bac))
	ROM_LOAD("elvisg.u21", 0x100000, 0x100000, CRC(79955b60) SHA1(36ad9e487408c9fd26641d484490b1b3bc8e1194))
	ROM_LOAD("elvisg.u36", 0x200000, 0x100000, CRC(25ba1ad4) SHA1(1e1a846af4ff43bb47f081b0cc179cd732c0bbea))
	ROM_LOAD("elvisg.u37", 0x300000, 0x100000, CRC(f6d7a2a0) SHA1(54c160a298c7ead1fe0404bce51bc16211da82cf))
ROM_END

ROM_START(elvisg303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpug.303",  0x0000, 0x20000, CRC(66b50538) SHA1(2612c0618c1d438632ff56b3b779214cf6534ff8))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspg.302",  0x0000, 0x80000, CRC(6340bb11) SHA1(d510f1a913cd3fb9593ef88c5652e03a5d3c3ebb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisg.u7",0x0000,0x10000,CRC(1085bd7c) SHA1(2c34ee7d7c44906b0894c0c01b0fad74cb0d2a32))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisg.u17", 0x000000, 0x100000, CRC(8b888d75) SHA1(b8c654d0fb558c205c338be2b458cbf931b23bac))
	ROM_LOAD("elvisg.u21", 0x100000, 0x100000, CRC(79955b60) SHA1(36ad9e487408c9fd26641d484490b1b3bc8e1194))
	ROM_LOAD("elvisg.u36", 0x200000, 0x100000, CRC(25ba1ad4) SHA1(1e1a846af4ff43bb47f081b0cc179cd732c0bbea))
	ROM_LOAD("elvisg.u37", 0x300000, 0x100000, CRC(f6d7a2a0) SHA1(54c160a298c7ead1fe0404bce51bc16211da82cf))
ROM_END

ROM_START(elvisg302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpug.302",  0x0000, 0x20000, CRC(9d907782) SHA1(3bad8d0429029b0055d09e50af16bca4da724e0f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspg.302",  0x0000, 0x80000, CRC(6340bb11) SHA1(d510f1a913cd3fb9593ef88c5652e03a5d3c3ebb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisg.u7",0x0000,0x10000,CRC(1085bd7c) SHA1(2c34ee7d7c44906b0894c0c01b0fad74cb0d2a32))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisg.u17", 0x000000, 0x100000, CRC(8b888d75) SHA1(b8c654d0fb558c205c338be2b458cbf931b23bac))
	ROM_LOAD("elvisg.u21", 0x100000, 0x100000, CRC(79955b60) SHA1(36ad9e487408c9fd26641d484490b1b3bc8e1194))
	ROM_LOAD("elvisg.u36", 0x200000, 0x100000, CRC(25ba1ad4) SHA1(1e1a846af4ff43bb47f081b0cc179cd732c0bbea))
	ROM_LOAD("elvisg.u37", 0x300000, 0x100000, CRC(f6d7a2a0) SHA1(54c160a298c7ead1fe0404bce51bc16211da82cf))
ROM_END

ROM_START(elvisf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("elvscpuf.500", 0x00000, 0x20000, CRC(e977fdb0) SHA1(aa24b4e6c461188b330bbc01204af8bfb03a9abf))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("elvsdspf.500", 0x00000, 0x80000, CRC(e4ce2da7) SHA1(030d9200844fc47d5ea6c4afeab0851de5b42b23))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisf.u7",0x0000,0x10000,CRC(84a057cd) SHA1(70e626f13a164df184dc5b0c79e8d320eeafb13b))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisf.u17", 0x000000, 0x100000, CRC(9b13e40d) SHA1(7e7eac1be5cbc7bde4296d168a1cc0716bcb293a))
	ROM_LOAD("elvisf.u21", 0x100000, 0x100000, CRC(5b668b6d) SHA1(9b104af5df5cc21c2504760b119f3e6584a1871b))
	ROM_LOAD("elvisf.u36", 0x200000, 0x100000, CRC(03ee0c04) SHA1(45a994589e3d9e6fe971db8722848b5f7432b675))
	ROM_LOAD("elvisf.u37", 0x300000, 0x100000, CRC(aa265440) SHA1(36b13ef0be4203936d9816e521098e72d6b4e4c1))
ROM_END

ROM_START(elvisf4)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpuf.400",  0x0000, 0x20000, CRC(9ae4f3c4) SHA1(5ec1590ca54f36565953467226a85491a96d2d3c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspf.401",  0x0000, 0x80000, CRC(1ddd1823) SHA1(86c2bacb596265a28a4b6dce3cd47ed5a2cf74d7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisf.u7",0x0000,0x10000,CRC(84a057cd) SHA1(70e626f13a164df184dc5b0c79e8d320eeafb13b))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisf.u17", 0x000000, 0x100000, CRC(9b13e40d) SHA1(7e7eac1be5cbc7bde4296d168a1cc0716bcb293a))
	ROM_LOAD("elvisf.u21", 0x100000, 0x100000, CRC(5b668b6d) SHA1(9b104af5df5cc21c2504760b119f3e6584a1871b))
	ROM_LOAD("elvisf.u36", 0x200000, 0x100000, CRC(03ee0c04) SHA1(45a994589e3d9e6fe971db8722848b5f7432b675))
	ROM_LOAD("elvisf.u37", 0x300000, 0x100000, CRC(aa265440) SHA1(36b13ef0be4203936d9816e521098e72d6b4e4c1))
ROM_END

ROM_START(elvisf303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpuf.303",  0x0000, 0x20000, CRC(bc5cc2b9) SHA1(f434164384153a3cca358af55ed82c7757e74fd9))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspf.302",  0x0000, 0x80000, CRC(410b6ae5) SHA1(ea29e1c81695df25ad61deedd84e6c3159976797))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisf.u7",0x0000,0x10000,CRC(84a057cd) SHA1(70e626f13a164df184dc5b0c79e8d320eeafb13b))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisf.u17", 0x000000, 0x100000, CRC(9b13e40d) SHA1(7e7eac1be5cbc7bde4296d168a1cc0716bcb293a))
	ROM_LOAD("elvisf.u21", 0x100000, 0x100000, CRC(5b668b6d) SHA1(9b104af5df5cc21c2504760b119f3e6584a1871b))
	ROM_LOAD("elvisf.u36", 0x200000, 0x100000, CRC(03ee0c04) SHA1(45a994589e3d9e6fe971db8722848b5f7432b675))
	ROM_LOAD("elvisf.u37", 0x300000, 0x100000, CRC(aa265440) SHA1(36b13ef0be4203936d9816e521098e72d6b4e4c1))
ROM_END

ROM_START(elvisf302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpuf.302",  0x0000, 0x20000, CRC(893a5ac6) SHA1(4be45cf036cdd643f10ecbb4d0b1778d25cf778a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspf.302",  0x0000, 0x80000, CRC(410b6ae5) SHA1(ea29e1c81695df25ad61deedd84e6c3159976797))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisf.u7",0x0000,0x10000,CRC(84a057cd) SHA1(70e626f13a164df184dc5b0c79e8d320eeafb13b))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisf.u17", 0x000000, 0x100000, CRC(9b13e40d) SHA1(7e7eac1be5cbc7bde4296d168a1cc0716bcb293a))
	ROM_LOAD("elvisf.u21", 0x100000, 0x100000, CRC(5b668b6d) SHA1(9b104af5df5cc21c2504760b119f3e6584a1871b))
	ROM_LOAD("elvisf.u36", 0x200000, 0x100000, CRC(03ee0c04) SHA1(45a994589e3d9e6fe971db8722848b5f7432b675))
	ROM_LOAD("elvisf.u37", 0x300000, 0x100000, CRC(aa265440) SHA1(36b13ef0be4203936d9816e521098e72d6b4e4c1))
ROM_END

ROM_START(elvisi)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("elvscpui.500", 0x00000, 0x20000, CRC(11bafdbb) SHA1(51036cdf4beda20f2680fff7cd8cae25219406bd))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("elvsdspi.500", 0x00000, 0x80000, CRC(3ecbadb2) SHA1(589cf6de348359944585b718b2289dd70676807a))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisi.u7",0x0000,0x10000,CRC(8c270da4) SHA1(6a21332fdd1f2714aa78a1730e0f90159022ad1c))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisi.u17", 0x000000, 0x100000, CRC(bd2e6580) SHA1(dc8c974860498d5766dbb0881cc9d6866c9a98a1))
	ROM_LOAD("elvisi.u21", 0x100000, 0x100000, CRC(1932a22b) SHA1(864d6bc2c60e763431fd19511dc1a946cf131d63))
	ROM_LOAD("elvisi.u36", 0x200000, 0x100000, CRC(df6772d7) SHA1(96e98ff4e93fc0c6fb2d9924da99b97f0c436c44))
	ROM_LOAD("elvisi.u37", 0x300000, 0x100000, CRC(990fd624) SHA1(d5e104485dc8dd7386d8f3e7d99dc6cf7bf91568))
ROM_END

ROM_START(elvisi4)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpui.400",  0x0000, 0x20000, CRC(dd2876fc) SHA1(3b860ad176e3fda58be1f165fc2f9965f36259ef))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspi.401",  0x0000, 0x80000, CRC(51f92cec) SHA1(a678dcb29f867b07641f39f5e0a9bf0e5daf9dc3))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisi.u7",0x0000,0x10000,CRC(8c270da4) SHA1(6a21332fdd1f2714aa78a1730e0f90159022ad1c))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisi.u17", 0x000000, 0x100000, CRC(bd2e6580) SHA1(dc8c974860498d5766dbb0881cc9d6866c9a98a1))
	ROM_LOAD("elvisi.u21", 0x100000, 0x100000, CRC(1932a22b) SHA1(864d6bc2c60e763431fd19511dc1a946cf131d63))
	ROM_LOAD("elvisi.u36", 0x200000, 0x100000, CRC(df6772d7) SHA1(96e98ff4e93fc0c6fb2d9924da99b97f0c436c44))
	ROM_LOAD("elvisi.u37", 0x300000, 0x100000, CRC(990fd624) SHA1(d5e104485dc8dd7386d8f3e7d99dc6cf7bf91568))
ROM_END

ROM_START(elvisi303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpui.303",  0x0000, 0x20000, CRC(11f47b7a) SHA1(4fbe64ed49719408b77ebf6871bb2211e03de394))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspi.302",  0x0000, 0x80000, CRC(217c7d17) SHA1(bfd67e876ea85847212c936f9f8477aba8a7b573))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisi.u7",0x0000,0x10000,CRC(8c270da4) SHA1(6a21332fdd1f2714aa78a1730e0f90159022ad1c))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisi.u17", 0x000000, 0x100000, CRC(bd2e6580) SHA1(dc8c974860498d5766dbb0881cc9d6866c9a98a1))
	ROM_LOAD("elvisi.u21", 0x100000, 0x100000, CRC(1932a22b) SHA1(864d6bc2c60e763431fd19511dc1a946cf131d63))
	ROM_LOAD("elvisi.u36", 0x200000, 0x100000, CRC(df6772d7) SHA1(96e98ff4e93fc0c6fb2d9924da99b97f0c436c44))
	ROM_LOAD("elvisi.u37", 0x300000, 0x100000, CRC(990fd624) SHA1(d5e104485dc8dd7386d8f3e7d99dc6cf7bf91568))
ROM_END

ROM_START(elvisi302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "elvscpui.302",  0x0000, 0x20000, CRC(a2c15460) SHA1(dcd4d4b61745ab2ccba662f9d72f56774a830ea0))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "elvsdspi.302",  0x0000, 0x80000, CRC(217c7d17) SHA1(bfd67e876ea85847212c936f9f8477aba8a7b573))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios1a.u8", 0x400000, 0x20000, CRC(e2e3fc18) SHA1(5ce564828c1d814b680788f20ba8b134249ccfb9))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("elvisi.u7",0x0000,0x10000,CRC(8c270da4) SHA1(6a21332fdd1f2714aa78a1730e0f90159022ad1c))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("elvisi.u17", 0x000000, 0x100000, CRC(bd2e6580) SHA1(dc8c974860498d5766dbb0881cc9d6866c9a98a1))
	ROM_LOAD("elvisi.u21", 0x100000, 0x100000, CRC(1932a22b) SHA1(864d6bc2c60e763431fd19511dc1a946cf131d63))
	ROM_LOAD("elvisi.u36", 0x200000, 0x100000, CRC(df6772d7) SHA1(96e98ff4e93fc0c6fb2d9924da99b97f0c436c44))
	ROM_LOAD("elvisi.u37", 0x300000, 0x100000, CRC(990fd624) SHA1(d5e104485dc8dd7386d8f3e7d99dc6cf7bf91568))
ROM_END

/*-------------------------------------------------------------------
/ Grand Prix
/-------------------------------------------------------------------*/
ROM_START(gprix)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("gpcpua.450", 0x00000, 0x20000, CRC(3e5ae527) SHA1(27d50a0460b1733c6c857968b85da492fa2ad544))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspa.400", 0x00000, 0x80000, CRC(ce431306) SHA1(2573049b52b928052f196371dbc3a5236ce8cfc3))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsnda.u7",0x0000,0x10000,CRC(f784634f) SHA1(40847986003b01c9de5d9af4c66a0f1f9fb0cac8))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsnda.u17", 0x000000, 0x100000, CRC(43dca7e2) SHA1(30726897950b168ffa5e0e8a4ff12856fd50f132))
	ROM_LOAD("gpsnda.u21", 0x100000, 0x100000, CRC(77717142) SHA1(055f975c3d1cf6560908f5d8553f7e64580a2bba))
	ROM_LOAD("gpsnda.u36", 0x200000, 0x100000, CRC(6e414e19) SHA1(5b7c9da9c340ec3b55163f5674d72ab30ffbb866))
	ROM_LOAD("gpsnda.u37", 0x300000, 0x100000, CRC(caf4c3f3) SHA1(ebdbaccf951ef6525f0fafa7e23d8140ef6b84e5))
ROM_END

ROM_START(gprix_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpua.400",    0x0000, 0x20000, CRC(c6042517) SHA1(19729a86a3afafb516f000489c38d00379e4f85c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspa.400", 0x00000, 0x80000, CRC(ce431306) SHA1(2573049b52b928052f196371dbc3a5236ce8cfc3))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsnda.u7",0x0000,0x10000,CRC(f784634f) SHA1(40847986003b01c9de5d9af4c66a0f1f9fb0cac8))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsnda.u17", 0x000000, 0x100000, CRC(43dca7e2) SHA1(30726897950b168ffa5e0e8a4ff12856fd50f132))
	ROM_LOAD("gpsnda.u21", 0x100000, 0x100000, CRC(77717142) SHA1(055f975c3d1cf6560908f5d8553f7e64580a2bba))
	ROM_LOAD("gpsnda.u36", 0x200000, 0x100000, CRC(6e414e19) SHA1(5b7c9da9c340ec3b55163f5674d72ab30ffbb866))
	ROM_LOAD("gpsnda.u37", 0x300000, 0x100000, CRC(caf4c3f3) SHA1(ebdbaccf951ef6525f0fafa7e23d8140ef6b84e5))
ROM_END

ROM_START(gprix_352)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpua.352", 0x0000, 0x20000, CRC(da46b437) SHA1(07cf288d47e1447c015e5bb1fd85df654bde71ef))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspa.303",    0x0000, 0x80000, CRC(814f6a50) SHA1(727eac96c4beaafc3ddd9ccd9ef098bd557cbc74))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsnda.u7",0x0000,0x10000,CRC(f784634f) SHA1(40847986003b01c9de5d9af4c66a0f1f9fb0cac8))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsnda.u17", 0x000000, 0x100000, CRC(43dca7e2) SHA1(30726897950b168ffa5e0e8a4ff12856fd50f132))
	ROM_LOAD("gpsnda.u21", 0x100000, 0x100000, CRC(77717142) SHA1(055f975c3d1cf6560908f5d8553f7e64580a2bba))
	ROM_LOAD("gpsnda.u36", 0x200000, 0x100000, CRC(6e414e19) SHA1(5b7c9da9c340ec3b55163f5674d72ab30ffbb866))
	ROM_LOAD("gpsnda.u37", 0x300000, 0x100000, CRC(caf4c3f3) SHA1(ebdbaccf951ef6525f0fafa7e23d8140ef6b84e5))
ROM_END

ROM_START(gprix_350)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpua.350", 0x0000, 0x20000, CRC(bd47be96) SHA1(31b7adc5cec10d18dd551fdba94fbdb8c6eac01b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspa.303",    0x0000, 0x80000, CRC(814f6a50) SHA1(727eac96c4beaafc3ddd9ccd9ef098bd557cbc74))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsnda.u7",0x0000,0x10000,CRC(f784634f) SHA1(40847986003b01c9de5d9af4c66a0f1f9fb0cac8))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsnda.u17", 0x000000, 0x100000, CRC(43dca7e2) SHA1(30726897950b168ffa5e0e8a4ff12856fd50f132))
	ROM_LOAD("gpsnda.u21", 0x100000, 0x100000, CRC(77717142) SHA1(055f975c3d1cf6560908f5d8553f7e64580a2bba))
	ROM_LOAD("gpsnda.u36", 0x200000, 0x100000, CRC(6e414e19) SHA1(5b7c9da9c340ec3b55163f5674d72ab30ffbb866))
	ROM_LOAD("gpsnda.u37", 0x300000, 0x100000, CRC(caf4c3f3) SHA1(ebdbaccf951ef6525f0fafa7e23d8140ef6b84e5))
ROM_END

ROM_START(gprix_340)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpua.340",    0x0000, 0x20000, CRC(798f2ab3) SHA1(046cbbd0115511b2cbd7f132b0755d03edce1e7b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspa.303",    0x0000, 0x80000, CRC(814f6a50) SHA1(727eac96c4beaafc3ddd9ccd9ef098bd557cbc74))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsnda.u7",0x0000,0x10000,CRC(f784634f) SHA1(40847986003b01c9de5d9af4c66a0f1f9fb0cac8))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsnda.u17", 0x000000, 0x100000, CRC(43dca7e2) SHA1(30726897950b168ffa5e0e8a4ff12856fd50f132))
	ROM_LOAD("gpsnda.u21", 0x100000, 0x100000, CRC(77717142) SHA1(055f975c3d1cf6560908f5d8553f7e64580a2bba))
	ROM_LOAD("gpsnda.u36", 0x200000, 0x100000, CRC(6e414e19) SHA1(5b7c9da9c340ec3b55163f5674d72ab30ffbb866))
	ROM_LOAD("gpsnda.u37", 0x300000, 0x100000, CRC(caf4c3f3) SHA1(ebdbaccf951ef6525f0fafa7e23d8140ef6b84e5))
ROM_END

ROM_START(gprix_301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpua.301",    0x0000, 0x20000, CRC(07cdb3eb) SHA1(2246d253dca93ce8c5f6775352611a3145ab8776))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspa.301",    0x0000, 0x80000, CRC(b11d752d) SHA1(c0e6f5544a3061027bf9addef4363c744aaaf736))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsnda.u7",0x0000,0x10000,CRC(f784634f) SHA1(40847986003b01c9de5d9af4c66a0f1f9fb0cac8))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsnda.u17", 0x000000, 0x100000, CRC(43dca7e2) SHA1(30726897950b168ffa5e0e8a4ff12856fd50f132))
	ROM_LOAD("gpsnda.u21", 0x100000, 0x100000, CRC(77717142) SHA1(055f975c3d1cf6560908f5d8553f7e64580a2bba))
	ROM_LOAD("gpsnda.u36", 0x200000, 0x100000, CRC(6e414e19) SHA1(5b7c9da9c340ec3b55163f5674d72ab30ffbb866))
	ROM_LOAD("gpsnda.u37", 0x300000, 0x100000, CRC(caf4c3f3) SHA1(ebdbaccf951ef6525f0fafa7e23d8140ef6b84e5))
ROM_END

ROM_START(gprixg)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("gpcpug.450", 0x00000, 0x20000, CRC(d803128b) SHA1(f914f75f4ec38dcbd2e40818fe8cb0ad446c59bf))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspg.400", 0x00000, 0x80000, CRC(b3f64332) SHA1(84e1b094c74b2dfae8e3cd3ce3f1cd20dc400fd7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndg.u7",0x0000,0x10000,CRC(95129e03) SHA1(5fddd9d8213f9f1f68fe9e96c9e78dc6771fab21))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndg.u17", 0x000000, 0x100000, CRC(27ef97ea) SHA1(8ba941d5d4f929b8ec3222f1c91452395e2f690f))
	ROM_LOAD("gpsndg.u21", 0x100000, 0x100000, CRC(71391d71) SHA1(690b280710c79d94fc271541066ae90e462bbce2))
	ROM_LOAD("gpsndg.u36", 0x200000, 0x100000, CRC(415baa1b) SHA1(cca21e0e5ef0cbe34c9514d72a06fc129990787a))
	ROM_LOAD("gpsndg.u37", 0x300000, 0x100000, CRC(e4a6ae7f) SHA1(4a4cd973f90c13ced07459c8f457314c8280dd6a))
ROM_END

ROM_START(gprixg_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpug.400",    0x0000, 0x20000, CRC(98d69588) SHA1(9d248b00a1aa966e69816cd7aaf869737e7a1ca7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspg.400", 0x00000, 0x80000, CRC(b3f64332) SHA1(84e1b094c74b2dfae8e3cd3ce3f1cd20dc400fd7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndg.u7",0x0000,0x10000,CRC(95129e03) SHA1(5fddd9d8213f9f1f68fe9e96c9e78dc6771fab21))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndg.u17", 0x000000, 0x100000, CRC(27ef97ea) SHA1(8ba941d5d4f929b8ec3222f1c91452395e2f690f))
	ROM_LOAD("gpsndg.u21", 0x100000, 0x100000, CRC(71391d71) SHA1(690b280710c79d94fc271541066ae90e462bbce2))
	ROM_LOAD("gpsndg.u36", 0x200000, 0x100000, CRC(415baa1b) SHA1(cca21e0e5ef0cbe34c9514d72a06fc129990787a))
	ROM_LOAD("gpsndg.u37", 0x300000, 0x100000, CRC(e4a6ae7f) SHA1(4a4cd973f90c13ced07459c8f457314c8280dd6a))
ROM_END

ROM_START(gprixg_352)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpug.352", 0x0000, 0x20000, CRC(b6c15f62) SHA1(b8757e7ef7064d200c7965902b624c8ef947f23d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspg.303",    0x0000, 0x80000, CRC(0be9eb1d) SHA1(78c402efcc818e4960ef5ca17e7fa43a028b5c9b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndg.u7",0x0000,0x10000,CRC(95129e03) SHA1(5fddd9d8213f9f1f68fe9e96c9e78dc6771fab21))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndg.u17", 0x000000, 0x100000, CRC(27ef97ea) SHA1(8ba941d5d4f929b8ec3222f1c91452395e2f690f))
	ROM_LOAD("gpsndg.u21", 0x100000, 0x100000, CRC(71391d71) SHA1(690b280710c79d94fc271541066ae90e462bbce2))
	ROM_LOAD("gpsndg.u36", 0x200000, 0x100000, CRC(415baa1b) SHA1(cca21e0e5ef0cbe34c9514d72a06fc129990787a))
	ROM_LOAD("gpsndg.u37", 0x300000, 0x100000, CRC(e4a6ae7f) SHA1(4a4cd973f90c13ced07459c8f457314c8280dd6a))
ROM_END

ROM_START(gprixg_350)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpug.350", 0x0000, 0x20000, CRC(8e77c953) SHA1(07d23ce2f0b0a2dc6284b71d1a4a8d1bb5dab6d0))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspg.303",    0x0000, 0x80000, CRC(0be9eb1d) SHA1(78c402efcc818e4960ef5ca17e7fa43a028b5c9b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndg.u7",0x0000,0x10000,CRC(95129e03) SHA1(5fddd9d8213f9f1f68fe9e96c9e78dc6771fab21))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndg.u17", 0x000000, 0x100000, CRC(27ef97ea) SHA1(8ba941d5d4f929b8ec3222f1c91452395e2f690f))
	ROM_LOAD("gpsndg.u21", 0x100000, 0x100000, CRC(71391d71) SHA1(690b280710c79d94fc271541066ae90e462bbce2))
	ROM_LOAD("gpsndg.u36", 0x200000, 0x100000, CRC(415baa1b) SHA1(cca21e0e5ef0cbe34c9514d72a06fc129990787a))
	ROM_LOAD("gpsndg.u37", 0x300000, 0x100000, CRC(e4a6ae7f) SHA1(4a4cd973f90c13ced07459c8f457314c8280dd6a))
ROM_END

ROM_START(gprixg_340)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpug.340",    0x0000, 0x20000, CRC(34afe4e4) SHA1(0655be39f309f32dffca22d7ab780263da5e8cb2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspg.303",    0x0000, 0x80000, CRC(0be9eb1d) SHA1(78c402efcc818e4960ef5ca17e7fa43a028b5c9b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndg.u7",0x0000,0x10000,CRC(95129e03) SHA1(5fddd9d8213f9f1f68fe9e96c9e78dc6771fab21))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndg.u17", 0x000000, 0x100000, CRC(27ef97ea) SHA1(8ba941d5d4f929b8ec3222f1c91452395e2f690f))
	ROM_LOAD("gpsndg.u21", 0x100000, 0x100000, CRC(71391d71) SHA1(690b280710c79d94fc271541066ae90e462bbce2))
	ROM_LOAD("gpsndg.u36", 0x200000, 0x100000, CRC(415baa1b) SHA1(cca21e0e5ef0cbe34c9514d72a06fc129990787a))
	ROM_LOAD("gpsndg.u37", 0x300000, 0x100000, CRC(e4a6ae7f) SHA1(4a4cd973f90c13ced07459c8f457314c8280dd6a))
ROM_END

ROM_START(gprixg_301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpug.301",    0x0000, 0x20000, CRC(23ac882e) SHA1(5194c3ea18a08f844f4ee293c9de44b62a956ee6))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspg.301",    0x0000, 0x80000, CRC(0d214a2a) SHA1(c7f9bbd56d7038931c8658bc586d29ad2b9ecac2))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndg.u7",0x0000,0x10000,CRC(95129e03) SHA1(5fddd9d8213f9f1f68fe9e96c9e78dc6771fab21))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndg.u17", 0x000000, 0x100000, CRC(27ef97ea) SHA1(8ba941d5d4f929b8ec3222f1c91452395e2f690f))
	ROM_LOAD("gpsndg.u21", 0x100000, 0x100000, CRC(71391d71) SHA1(690b280710c79d94fc271541066ae90e462bbce2))
	ROM_LOAD("gpsndg.u36", 0x200000, 0x100000, CRC(415baa1b) SHA1(cca21e0e5ef0cbe34c9514d72a06fc129990787a))
	ROM_LOAD("gpsndg.u37", 0x300000, 0x100000, CRC(e4a6ae7f) SHA1(4a4cd973f90c13ced07459c8f457314c8280dd6a))
ROM_END

ROM_START(gprixl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("gpcpul.450", 0x00000, 0x20000, CRC(816bf4a4) SHA1(d5cca282e58d493be36400a7cd7dc4321d98f2f8))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspl.400", 0x00000, 0x80000, CRC(74d9aa40) SHA1(802c6fbe4248a516f18e4b69997254b3dcf27706))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndl.u7",0x0000,0x10000,CRC(0640fe8f) SHA1(aa45bf89c4cae5b4c2143656cfe19fe8f1ec30a3))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndl.u17", 0x000000, 0x100000, CRC(2581ef04) SHA1(2d85040e355ed410c7d8348ef64fc2c8e76ec0f0))
	ROM_LOAD("gpsndl.u21", 0x100000, 0x100000, CRC(f4c97c9e) SHA1(ae04f416a7582efee20469ec686d02727558d850))
	ROM_LOAD("gpsndl.u36", 0x200000, 0x100000, CRC(863de01a) SHA1(3f1fd157c2abacdab072146499b64b9e0853fb3e))
	ROM_LOAD("gpsndl.u37", 0x300000, 0x100000, CRC(db16b68a) SHA1(815fdcd4ae01c6264133389ce3194da572e1c232))
ROM_END

ROM_START(gprixl_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpul.400",    0x0000, 0x20000, CRC(90f506f0) SHA1(4642fa8bf15955a32b6ae8c6b859d94dcd40c542))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspl.400", 0x00000, 0x80000, CRC(74d9aa40) SHA1(802c6fbe4248a516f18e4b69997254b3dcf27706))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndl.u7",0x0000,0x10000,CRC(0640fe8f) SHA1(aa45bf89c4cae5b4c2143656cfe19fe8f1ec30a3))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndl.u17", 0x000000, 0x100000, CRC(2581ef04) SHA1(2d85040e355ed410c7d8348ef64fc2c8e76ec0f0))
	ROM_LOAD("gpsndl.u21", 0x100000, 0x100000, CRC(f4c97c9e) SHA1(ae04f416a7582efee20469ec686d02727558d850))
	ROM_LOAD("gpsndl.u36", 0x200000, 0x100000, CRC(863de01a) SHA1(3f1fd157c2abacdab072146499b64b9e0853fb3e))
	ROM_LOAD("gpsndl.u37", 0x300000, 0x100000, CRC(db16b68a) SHA1(815fdcd4ae01c6264133389ce3194da572e1c232))
ROM_END

ROM_START(gprixl_352)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpul.352", 0x0000, 0x20000, CRC(cd296661) SHA1(e706525b07e1e1278ab65a896616e63be52e8e73))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspl.303",    0x0000, 0x80000, CRC(82f30b13) SHA1(2f15228dbd6f3957f657772725f3280adf778d72))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndl.u7",0x0000,0x10000,CRC(0640fe8f) SHA1(aa45bf89c4cae5b4c2143656cfe19fe8f1ec30a3))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndl.u17", 0x000000, 0x100000, CRC(2581ef04) SHA1(2d85040e355ed410c7d8348ef64fc2c8e76ec0f0))
	ROM_LOAD("gpsndl.u21", 0x100000, 0x100000, CRC(f4c97c9e) SHA1(ae04f416a7582efee20469ec686d02727558d850))
	ROM_LOAD("gpsndl.u36", 0x200000, 0x100000, CRC(863de01a) SHA1(3f1fd157c2abacdab072146499b64b9e0853fb3e))
	ROM_LOAD("gpsndl.u37", 0x300000, 0x100000, CRC(db16b68a) SHA1(815fdcd4ae01c6264133389ce3194da572e1c232))
ROM_END

ROM_START(gprixl_350)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpul.350", 0x0000, 0x20000, CRC(714f0641) SHA1(c09aa248fe04fc3c569c6786c0db8d396cbd2403))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspl.303",    0x0000, 0x80000, CRC(82f30b13) SHA1(2f15228dbd6f3957f657772725f3280adf778d72))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndl.u7",0x0000,0x10000,CRC(0640fe8f) SHA1(aa45bf89c4cae5b4c2143656cfe19fe8f1ec30a3))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndl.u17", 0x000000, 0x100000, CRC(2581ef04) SHA1(2d85040e355ed410c7d8348ef64fc2c8e76ec0f0))
	ROM_LOAD("gpsndl.u21", 0x100000, 0x100000, CRC(f4c97c9e) SHA1(ae04f416a7582efee20469ec686d02727558d850))
	ROM_LOAD("gpsndl.u36", 0x200000, 0x100000, CRC(863de01a) SHA1(3f1fd157c2abacdab072146499b64b9e0853fb3e))
	ROM_LOAD("gpsndl.u37", 0x300000, 0x100000, CRC(db16b68a) SHA1(815fdcd4ae01c6264133389ce3194da572e1c232))
ROM_END

ROM_START(gprixl_340)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpul.340",    0x0000, 0x20000, CRC(2cd2f25f) SHA1(ee21a680cf56b6b415b2b9f5d89125062b24f8ae))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspl.303",    0x0000, 0x80000, CRC(82f30b13) SHA1(2f15228dbd6f3957f657772725f3280adf778d72))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndl.u7",0x0000,0x10000,CRC(0640fe8f) SHA1(aa45bf89c4cae5b4c2143656cfe19fe8f1ec30a3))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndl.u17", 0x000000, 0x100000, CRC(2581ef04) SHA1(2d85040e355ed410c7d8348ef64fc2c8e76ec0f0))
	ROM_LOAD("gpsndl.u21", 0x100000, 0x100000, CRC(f4c97c9e) SHA1(ae04f416a7582efee20469ec686d02727558d850))
	ROM_LOAD("gpsndl.u36", 0x200000, 0x100000, CRC(863de01a) SHA1(3f1fd157c2abacdab072146499b64b9e0853fb3e))
	ROM_LOAD("gpsndl.u37", 0x300000, 0x100000, CRC(db16b68a) SHA1(815fdcd4ae01c6264133389ce3194da572e1c232))
ROM_END

ROM_START(gprixl_301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpul.301",    0x0000, 0x20000, CRC(ad739825) SHA1(c2fbc25985b83bacd4285b6608366de485f16982))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspl.301",    0x0000, 0x80000, CRC(2f483f0a) SHA1(42550741bee6af022bccd130626913edff6180a0))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndl.u7",0x0000,0x10000,CRC(0640fe8f) SHA1(aa45bf89c4cae5b4c2143656cfe19fe8f1ec30a3))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndl.u17", 0x000000, 0x100000, CRC(2581ef04) SHA1(2d85040e355ed410c7d8348ef64fc2c8e76ec0f0))
	ROM_LOAD("gpsndl.u21", 0x100000, 0x100000, CRC(f4c97c9e) SHA1(ae04f416a7582efee20469ec686d02727558d850))
	ROM_LOAD("gpsndl.u36", 0x200000, 0x100000, CRC(863de01a) SHA1(3f1fd157c2abacdab072146499b64b9e0853fb3e))
	ROM_LOAD("gpsndl.u37", 0x300000, 0x100000, CRC(db16b68a) SHA1(815fdcd4ae01c6264133389ce3194da572e1c232))
ROM_END

ROM_START(gprixf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("gpcpuf.450", 0x00000, 0x20000, CRC(b14f7d20) SHA1(b91097490ee568e00be58f5dac184c8d47196adc))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspf.400", 0x00000, 0x80000, CRC(f9b1ef9a) SHA1(a7e3c0fc1526cf3632e6b1f22caf7f73749e77a6))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndf.u7",0x0000,0x10000,CRC(9b34e55a) SHA1(670fe4e4b62c46266667f37c0341bb4266e55067))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndf.u17", 0x000000, 0x100000, CRC(18beb699) SHA1(a3bbd7c9fc1165da5e502e09f68321bd56992e76))
	ROM_LOAD("gpsndf.u21", 0x100000, 0x100000, CRC(b64702dd) SHA1(8762fb00d5549649444f7f85c3f6d72f27c6ba41))
	ROM_LOAD("gpsndf.u36", 0x200000, 0x100000, CRC(4e41f0bb) SHA1(4a25b472a9435c77712559d7ded1649dffbc885c))
	ROM_LOAD("gpsndf.u37", 0x300000, 0x100000, CRC(e6d96767) SHA1(a471d51796edad71eb21aadc4a26bb1529a0b9cc))
ROM_END

ROM_START(gprixf_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpuf.400",    0x0000, 0x20000, CRC(0e7f8776) SHA1(0731c3a5350445f70dd8bdac68b2554942f12c8d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspf.400", 0x00000, 0x80000, CRC(f9b1ef9a) SHA1(a7e3c0fc1526cf3632e6b1f22caf7f73749e77a6))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndf.u7",0x0000,0x10000,CRC(9b34e55a) SHA1(670fe4e4b62c46266667f37c0341bb4266e55067))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndf.u17", 0x000000, 0x100000, CRC(18beb699) SHA1(a3bbd7c9fc1165da5e502e09f68321bd56992e76))
	ROM_LOAD("gpsndf.u21", 0x100000, 0x100000, CRC(b64702dd) SHA1(8762fb00d5549649444f7f85c3f6d72f27c6ba41))
	ROM_LOAD("gpsndf.u36", 0x200000, 0x100000, CRC(4e41f0bb) SHA1(4a25b472a9435c77712559d7ded1649dffbc885c))
	ROM_LOAD("gpsndf.u37", 0x300000, 0x100000, CRC(e6d96767) SHA1(a471d51796edad71eb21aadc4a26bb1529a0b9cc))
ROM_END

ROM_START(gprixf_352)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpuf.352", 0x0000, 0x20000, CRC(78140cd3) SHA1(9c7257dede5c3bf78d9a9bbdf89bd01f12180c4f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspf.303",    0x0000, 0x80000, CRC(f48f3a4b) SHA1(74c7d1670d6f1ed68d5aed5a755f27ffdb566cbd))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndf.u7",0x0000,0x10000,CRC(9b34e55a) SHA1(670fe4e4b62c46266667f37c0341bb4266e55067))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndf.u17", 0x000000, 0x100000, CRC(18beb699) SHA1(a3bbd7c9fc1165da5e502e09f68321bd56992e76))
	ROM_LOAD("gpsndf.u21", 0x100000, 0x100000, CRC(b64702dd) SHA1(8762fb00d5549649444f7f85c3f6d72f27c6ba41))
	ROM_LOAD("gpsndf.u36", 0x200000, 0x100000, CRC(4e41f0bb) SHA1(4a25b472a9435c77712559d7ded1649dffbc885c))
	ROM_LOAD("gpsndf.u37", 0x300000, 0x100000, CRC(e6d96767) SHA1(a471d51796edad71eb21aadc4a26bb1529a0b9cc))
ROM_END

ROM_START(gprixf_350)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpuf.350", 0x0000, 0x20000, CRC(ad4224e9) SHA1(781a76ef14e7abb2b57ae49cd8712ddace8a4fca))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspf.303",    0x0000, 0x80000, CRC(f48f3a4b) SHA1(74c7d1670d6f1ed68d5aed5a755f27ffdb566cbd))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndf.u7",0x0000,0x10000,CRC(9b34e55a) SHA1(670fe4e4b62c46266667f37c0341bb4266e55067))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndf.u17", 0x000000, 0x100000, CRC(18beb699) SHA1(a3bbd7c9fc1165da5e502e09f68321bd56992e76))
	ROM_LOAD("gpsndf.u21", 0x100000, 0x100000, CRC(b64702dd) SHA1(8762fb00d5549649444f7f85c3f6d72f27c6ba41))
	ROM_LOAD("gpsndf.u36", 0x200000, 0x100000, CRC(4e41f0bb) SHA1(4a25b472a9435c77712559d7ded1649dffbc885c))
	ROM_LOAD("gpsndf.u37", 0x300000, 0x100000, CRC(e6d96767) SHA1(a471d51796edad71eb21aadc4a26bb1529a0b9cc))
ROM_END

ROM_START(gprixf_340)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpuf.340",    0x0000, 0x20000, CRC(cefc30e4) SHA1(2ffdfd09ed8ba00a36a6bf12b79200c562b7dc0d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspf.303",    0x0000, 0x80000, CRC(f48f3a4b) SHA1(74c7d1670d6f1ed68d5aed5a755f27ffdb566cbd))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndf.u7",0x0000,0x10000,CRC(9b34e55a) SHA1(670fe4e4b62c46266667f37c0341bb4266e55067))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndf.u17", 0x000000, 0x100000, CRC(18beb699) SHA1(a3bbd7c9fc1165da5e502e09f68321bd56992e76))
	ROM_LOAD("gpsndf.u21", 0x100000, 0x100000, CRC(b64702dd) SHA1(8762fb00d5549649444f7f85c3f6d72f27c6ba41))
	ROM_LOAD("gpsndf.u36", 0x200000, 0x100000, CRC(4e41f0bb) SHA1(4a25b472a9435c77712559d7ded1649dffbc885c))
	ROM_LOAD("gpsndf.u37", 0x300000, 0x100000, CRC(e6d96767) SHA1(a471d51796edad71eb21aadc4a26bb1529a0b9cc))
ROM_END

ROM_START(gprixf_301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpuf.301",    0x0000, 0x20000, CRC(6f9d34ee) SHA1(a8b60300cc1e07d3beb8d607e24285dbbd871e83))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspf.301",    0x0000, 0x80000, CRC(b19729cd) SHA1(491fdf356f5a24b9895d2feccfe29d0bf45f4e27))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndf.u7",0x0000,0x10000,CRC(9b34e55a) SHA1(670fe4e4b62c46266667f37c0341bb4266e55067))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndf.u17", 0x000000, 0x100000, CRC(18beb699) SHA1(a3bbd7c9fc1165da5e502e09f68321bd56992e76))
	ROM_LOAD("gpsndf.u21", 0x100000, 0x100000, CRC(b64702dd) SHA1(8762fb00d5549649444f7f85c3f6d72f27c6ba41))
	ROM_LOAD("gpsndf.u36", 0x200000, 0x100000, CRC(4e41f0bb) SHA1(4a25b472a9435c77712559d7ded1649dffbc885c))
	ROM_LOAD("gpsndf.u37", 0x300000, 0x100000, CRC(e6d96767) SHA1(a471d51796edad71eb21aadc4a26bb1529a0b9cc))
ROM_END

ROM_START(gprixi)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("gpcpui.450", 0x00000, 0x20000, CRC(f18d8375) SHA1(b7e4e311623babc7b3c5d744122c88d45d77a33b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspi.400", 0x00000, 0x80000, CRC(88675cdf) SHA1(b305a683350d38b43f2e3c9277af14d5503b3219))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndi.u7",0x0000,0x10000,CRC(37d66e66) SHA1(219fd734d3a19407d9d47de198429c770d7d8856))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndi.u17", 0x000000, 0x100000, CRC(868b225d) SHA1(bc169cf5882002a1b58973a22a78d8dd4467bc51))
	ROM_LOAD("gpsndi.u21", 0x100000, 0x100000, CRC(b6692c39) SHA1(ac36ffb37ad945a857d5098547479c8cd62b6356))
	ROM_LOAD("gpsndi.u36", 0x200000, 0x100000, CRC(f8558b24) SHA1(ceb3880b026fb7fcc69eb8d94e33e30c56c24de8))
	ROM_LOAD("gpsndi.u37", 0x300000, 0x100000, CRC(a76c6682) SHA1(6d319a8f07c10fe392fc0b8e177cc6abbce0b536))
ROM_END

ROM_START(gprixi_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpui.400",    0x0000, 0x20000, CRC(49e161b7) SHA1(855e35ddedf35055de384bade4b237810bc5ffec))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("gpdspi.400", 0x00000, 0x80000, CRC(88675cdf) SHA1(b305a683350d38b43f2e3c9277af14d5503b3219))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndi.u7",0x0000,0x10000,CRC(37d66e66) SHA1(219fd734d3a19407d9d47de198429c770d7d8856))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndi.u17", 0x000000, 0x100000, CRC(868b225d) SHA1(bc169cf5882002a1b58973a22a78d8dd4467bc51))
	ROM_LOAD("gpsndi.u21", 0x100000, 0x100000, CRC(b6692c39) SHA1(ac36ffb37ad945a857d5098547479c8cd62b6356))
	ROM_LOAD("gpsndi.u36", 0x200000, 0x100000, CRC(f8558b24) SHA1(ceb3880b026fb7fcc69eb8d94e33e30c56c24de8))
	ROM_LOAD("gpsndi.u37", 0x300000, 0x100000, CRC(a76c6682) SHA1(6d319a8f07c10fe392fc0b8e177cc6abbce0b536))
ROM_END

ROM_START(gprixi_352)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpui.352", 0x0000, 0x20000, CRC(941bd2a9) SHA1(11402004c5b57de5ec28ea2f4128b1852c205dac))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspi.303",    0x0000, 0x80000, CRC(36418722) SHA1(66f04e3069c51004cb82961a7d82ac0a5f6a84dd))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndi.u7",0x0000,0x10000,CRC(37d66e66) SHA1(219fd734d3a19407d9d47de198429c770d7d8856))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndi.u17", 0x000000, 0x100000, CRC(868b225d) SHA1(bc169cf5882002a1b58973a22a78d8dd4467bc51))
	ROM_LOAD("gpsndi.u21", 0x100000, 0x100000, CRC(b6692c39) SHA1(ac36ffb37ad945a857d5098547479c8cd62b6356))
	ROM_LOAD("gpsndi.u36", 0x200000, 0x100000, CRC(f8558b24) SHA1(ceb3880b026fb7fcc69eb8d94e33e30c56c24de8))
	ROM_LOAD("gpsndi.u37", 0x300000, 0x100000, CRC(a76c6682) SHA1(6d319a8f07c10fe392fc0b8e177cc6abbce0b536))
ROM_END

ROM_START(gprixi_350)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpui.350", 0x0000, 0x20000, CRC(64bc5f6b) SHA1(fb079323d3548f1915de93d724d3fb76b2e02f27))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspi.303",    0x0000, 0x80000, CRC(36418722) SHA1(66f04e3069c51004cb82961a7d82ac0a5f6a84dd))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndi.u7",0x0000,0x10000,CRC(37d66e66) SHA1(219fd734d3a19407d9d47de198429c770d7d8856))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndi.u17", 0x000000, 0x100000, CRC(868b225d) SHA1(bc169cf5882002a1b58973a22a78d8dd4467bc51))
	ROM_LOAD("gpsndi.u21", 0x100000, 0x100000, CRC(b6692c39) SHA1(ac36ffb37ad945a857d5098547479c8cd62b6356))
	ROM_LOAD("gpsndi.u36", 0x200000, 0x100000, CRC(f8558b24) SHA1(ceb3880b026fb7fcc69eb8d94e33e30c56c24de8))
	ROM_LOAD("gpsndi.u37", 0x300000, 0x100000, CRC(a76c6682) SHA1(6d319a8f07c10fe392fc0b8e177cc6abbce0b536))
ROM_END

ROM_START(gprixi_340)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpui.340",    0x0000, 0x20000, CRC(35f4a870) SHA1(24293fafcec6180ab62ef3298e4b53910e05a937))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspi.303",    0x0000, 0x80000, CRC(36418722) SHA1(66f04e3069c51004cb82961a7d82ac0a5f6a84dd))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndi.u7",0x0000,0x10000,CRC(37d66e66) SHA1(219fd734d3a19407d9d47de198429c770d7d8856))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndi.u17", 0x000000, 0x100000, CRC(868b225d) SHA1(bc169cf5882002a1b58973a22a78d8dd4467bc51))
	ROM_LOAD("gpsndi.u21", 0x100000, 0x100000, CRC(b6692c39) SHA1(ac36ffb37ad945a857d5098547479c8cd62b6356))
	ROM_LOAD("gpsndi.u36", 0x200000, 0x100000, CRC(f8558b24) SHA1(ceb3880b026fb7fcc69eb8d94e33e30c56c24de8))
	ROM_LOAD("gpsndi.u37", 0x300000, 0x100000, CRC(a76c6682) SHA1(6d319a8f07c10fe392fc0b8e177cc6abbce0b536))
ROM_END

ROM_START(gprixi_301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "gpcpui.301",    0x0000, 0x20000, CRC(d9be9fd7) SHA1(3dfc997d8d17d153ee42df0adb7993293bfff7e8))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "gpdspi.301",    0x0000, 0x80000, CRC(1fc478da) SHA1(5307e9b302a7e49eb3460e8ba1e4c22525a1dcfe))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("gpsndi.u7",0x0000,0x10000,CRC(37d66e66) SHA1(219fd734d3a19407d9d47de198429c770d7d8856))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("gpsndi.u17", 0x000000, 0x100000, CRC(868b225d) SHA1(bc169cf5882002a1b58973a22a78d8dd4467bc51))
	ROM_LOAD("gpsndi.u21", 0x100000, 0x100000, CRC(b6692c39) SHA1(ac36ffb37ad945a857d5098547479c8cd62b6356))
	ROM_LOAD("gpsndi.u36", 0x200000, 0x100000, CRC(f8558b24) SHA1(ceb3880b026fb7fcc69eb8d94e33e30c56c24de8))
	ROM_LOAD("gpsndi.u37", 0x300000, 0x100000, CRC(a76c6682) SHA1(6d319a8f07c10fe392fc0b8e177cc6abbce0b536))
ROM_END

/*-------------------------------------------------------------------
/ Nascar
/-------------------------------------------------------------------*/
ROM_START(nascar)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("nascpua.450", 0x00000, 0x20000, CRC(da902e01) SHA1(afc6ace2b31c8682fb4d05e1b472c2ec30e7559b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("nasdspa.400", 0x00000, 0x80000, CRC(364878bf) SHA1(a1fb477a37459a3583d3767386f87aa620e31e34))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nassnd.u7",0x0000,0x10000,CRC(3a3c8203) SHA1(c64c424c01ec91e2578fd6ddc5d3596b8a485c22))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassnd.u17", 0x000000, 0x100000, CRC(4dcf65fa) SHA1(bc745e16f1f4b92b97fd0536bea789909b9c0c67))
	ROM_LOAD("nassnd.u21", 0x100000, 0x100000, CRC(82ac1e4f) SHA1(8a6518885d89651df31afc8119d87a46fd802e16))
	ROM_LOAD("nassnd.u36", 0x200000, 0x100000, CRC(2385ada2) SHA1(d3b59beffe6817cc3ea1140698095886ec2f2324))
	ROM_LOAD("nassnd.u37", 0x300000, 0x100000, CRC(458ba148) SHA1(594fd9b48aa48ab7b3df921e689b1acba2b09d79))
ROM_END

ROM_START(nascar_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpua.400",   0x0000, 0x20000, CRC(24a72071) SHA1(5bfe473e85e12b30963b15dfc8732f2ef9c299c3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("nasdspa.400", 0x00000, 0x80000, CRC(364878bf) SHA1(a1fb477a37459a3583d3767386f87aa620e31e34))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nassnd.u7",0x0000,0x10000,CRC(3a3c8203) SHA1(c64c424c01ec91e2578fd6ddc5d3596b8a485c22))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassnd.u17", 0x000000, 0x100000, CRC(4dcf65fa) SHA1(bc745e16f1f4b92b97fd0536bea789909b9c0c67))
	ROM_LOAD("nassnd.u21", 0x100000, 0x100000, CRC(82ac1e4f) SHA1(8a6518885d89651df31afc8119d87a46fd802e16))
	ROM_LOAD("nassnd.u36", 0x200000, 0x100000, CRC(2385ada2) SHA1(d3b59beffe6817cc3ea1140698095886ec2f2324))
	ROM_LOAD("nassnd.u37", 0x300000, 0x100000, CRC(458ba148) SHA1(594fd9b48aa48ab7b3df921e689b1acba2b09d79))
ROM_END

ROM_START(nascar_352)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpua.352", 0x0000, 0x20000, CRC(65b8132e) SHA1(b42dca3e68d3eff158bae830f6c8cca00e0ed3e2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspa.303",   0x0000, 0x80000, CRC(86e20410) SHA1(c499682713facc6b2923fdd0eff47b98f6a36d14))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nassnd.u7",0x0000,0x10000,CRC(3a3c8203) SHA1(c64c424c01ec91e2578fd6ddc5d3596b8a485c22))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassnd.u17", 0x000000, 0x100000, CRC(4dcf65fa) SHA1(bc745e16f1f4b92b97fd0536bea789909b9c0c67))
	ROM_LOAD("nassnd.u21", 0x100000, 0x100000, CRC(82ac1e4f) SHA1(8a6518885d89651df31afc8119d87a46fd802e16))
	ROM_LOAD("nassnd.u36", 0x200000, 0x100000, CRC(2385ada2) SHA1(d3b59beffe6817cc3ea1140698095886ec2f2324))
	ROM_LOAD("nassnd.u37", 0x300000, 0x100000, CRC(458ba148) SHA1(594fd9b48aa48ab7b3df921e689b1acba2b09d79))
ROM_END

ROM_START(nascar_350)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpua.350",   0x0000, 0x20000, CRC(e5b4ed49) SHA1(0d38c0e08862a0a5a200225634c5bf0d0afe5afe))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspa.303",   0x0000, 0x80000, CRC(86e20410) SHA1(c499682713facc6b2923fdd0eff47b98f6a36d14))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nassnd.u7",0x0000,0x10000,CRC(3a3c8203) SHA1(c64c424c01ec91e2578fd6ddc5d3596b8a485c22))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassnd.u17", 0x000000, 0x100000, CRC(4dcf65fa) SHA1(bc745e16f1f4b92b97fd0536bea789909b9c0c67))
	ROM_LOAD("nassnd.u21", 0x100000, 0x100000, CRC(82ac1e4f) SHA1(8a6518885d89651df31afc8119d87a46fd802e16))
	ROM_LOAD("nassnd.u36", 0x200000, 0x100000, CRC(2385ada2) SHA1(d3b59beffe6817cc3ea1140698095886ec2f2324))
	ROM_LOAD("nassnd.u37", 0x300000, 0x100000, CRC(458ba148) SHA1(594fd9b48aa48ab7b3df921e689b1acba2b09d79))
ROM_END

ROM_START(nascar_340)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpua.340",   0x0000, 0x20000, CRC(120dc65a) SHA1(151c1604dacb1c1cf74449291d81629a05fb1b09))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspa.303",   0x0000, 0x80000, CRC(86e20410) SHA1(c499682713facc6b2923fdd0eff47b98f6a36d14))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nassnd.u7",0x0000,0x10000,CRC(3a3c8203) SHA1(c64c424c01ec91e2578fd6ddc5d3596b8a485c22))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassnd.u17", 0x000000, 0x100000, CRC(4dcf65fa) SHA1(bc745e16f1f4b92b97fd0536bea789909b9c0c67))
	ROM_LOAD("nassnd.u21", 0x100000, 0x100000, CRC(82ac1e4f) SHA1(8a6518885d89651df31afc8119d87a46fd802e16))
	ROM_LOAD("nassnd.u36", 0x200000, 0x100000, CRC(2385ada2) SHA1(d3b59beffe6817cc3ea1140698095886ec2f2324))
	ROM_LOAD("nassnd.u37", 0x300000, 0x100000, CRC(458ba148) SHA1(594fd9b48aa48ab7b3df921e689b1acba2b09d79))
ROM_END

ROM_START(nascar_301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpua.301",   0x0000, 0x20000, CRC(8ede60c2) SHA1(aa49da40f2ed858c5fa260ce5e7dd096b4217544))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspa.301",   0x0000, 0x80000, CRC(4de3c8d5) SHA1(c2c08ddd0ecc511cf34ba6a6cae9968e903b88ad))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nassnd.u7",0x0000,0x10000,CRC(3a3c8203) SHA1(c64c424c01ec91e2578fd6ddc5d3596b8a485c22))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassnd.u17", 0x000000, 0x100000, CRC(4dcf65fa) SHA1(bc745e16f1f4b92b97fd0536bea789909b9c0c67))
	ROM_LOAD("nassnd.u21", 0x100000, 0x100000, CRC(82ac1e4f) SHA1(8a6518885d89651df31afc8119d87a46fd802e16))
	ROM_LOAD("nassnd.u36", 0x200000, 0x100000, CRC(2385ada2) SHA1(d3b59beffe6817cc3ea1140698095886ec2f2324))
	ROM_LOAD("nassnd.u37", 0x300000, 0x100000, CRC(458ba148) SHA1(594fd9b48aa48ab7b3df921e689b1acba2b09d79))
ROM_END

ROM_START(dalejr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "dalecpu.500",   0x0000, 0x20000, CRC(b723b7db) SHA1(ee5f96599f8ccb0fda0695e5e8af438c3f559df3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "daledisp.500",   0x0000, 0x80000, CRC(5dad91cd) SHA1(ef9ce5573f580abc720a184625c96672b5337191))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nassnd.u7",0x0000,0x10000,CRC(3a3c8203) SHA1(c64c424c01ec91e2578fd6ddc5d3596b8a485c22))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassnd.u17", 0x000000, 0x100000, CRC(4dcf65fa) SHA1(bc745e16f1f4b92b97fd0536bea789909b9c0c67))
	ROM_LOAD("nassnd.u21", 0x100000, 0x100000, CRC(82ac1e4f) SHA1(8a6518885d89651df31afc8119d87a46fd802e16))
	ROM_LOAD("nassnd.u36", 0x200000, 0x100000, CRC(2385ada2) SHA1(d3b59beffe6817cc3ea1140698095886ec2f2324))
	ROM_LOAD("nassnd.u37", 0x300000, 0x100000, CRC(458ba148) SHA1(594fd9b48aa48ab7b3df921e689b1acba2b09d79))
ROM_END

ROM_START(nascarl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("nascpul.450", 0x00000, 0x20000, CRC(3eebae3f) SHA1(654f0e44ce009450e66250423fcf0ff4727e5ee1))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("nasdspl.400", 0x00000, 0x80000, CRC(a4de490f) SHA1(bc1aa9fc0182045f5d10044b3e4fa083572be4ac))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nascsp.u7",0x0000,0x10000,CRC(03a34394) SHA1(d1e3a1a8e14525c40e9f8a5441a106df662608f1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassndl.u17", 0x000000, 0x100000, CRC(058c67ad) SHA1(70e22d8a1842108309f6c03dcc6ac23a822da3c3))
	ROM_LOAD("nassndl.u21", 0x100000, 0x100000, CRC(e34d3b6f) SHA1(63ef27ed5965d719215d0a469886d3852b6bffb6))
	ROM_LOAD("nassndl.u36", 0x200000, 0x100000, CRC(9e2658b1) SHA1(0d93a381a65f11022a1a6da5e5b0e4a0e779f336))
	ROM_LOAD("nassndl.u37", 0x300000, 0x100000, CRC(63f084ab) SHA1(519807bf6e868df6f756ad30af2f6636804f167c))
ROM_END

ROM_START(nascarl_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpul.400",   0x0000, 0x20000, CRC(23ca7b4a) SHA1(9ea7afb283157a8e65106dc027cfd45eecc3f86a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("nasdspl.400", 0x00000, 0x80000, CRC(a4de490f) SHA1(bc1aa9fc0182045f5d10044b3e4fa083572be4ac))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nascsp.u7",0x0000,0x10000,CRC(03a34394) SHA1(d1e3a1a8e14525c40e9f8a5441a106df662608f1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassndl.u17", 0x000000, 0x100000, CRC(058c67ad) SHA1(70e22d8a1842108309f6c03dcc6ac23a822da3c3))
	ROM_LOAD("nassndl.u21", 0x100000, 0x100000, CRC(e34d3b6f) SHA1(63ef27ed5965d719215d0a469886d3852b6bffb6))
	ROM_LOAD("nassndl.u36", 0x200000, 0x100000, CRC(9e2658b1) SHA1(0d93a381a65f11022a1a6da5e5b0e4a0e779f336))
	ROM_LOAD("nassndl.u37", 0x300000, 0x100000, CRC(63f084ab) SHA1(519807bf6e868df6f756ad30af2f6636804f167c))
ROM_END

ROM_START(nascarl_352)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpul.352", 0x0000, 0x20000, CRC(c78549d8) SHA1(9796c0d413fd2ea7f616ad238b67311c8c29286d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspl.303",   0x0000, 0x80000, CRC(868277f0) SHA1(9c058054e6dc3b838bfc3a91d37438afcd59aa4b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nascsp.u7",0x0000,0x10000,CRC(03a34394) SHA1(d1e3a1a8e14525c40e9f8a5441a106df662608f1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassndl.u17", 0x000000, 0x100000, CRC(058c67ad) SHA1(70e22d8a1842108309f6c03dcc6ac23a822da3c3))
	ROM_LOAD("nassndl.u21", 0x100000, 0x100000, CRC(e34d3b6f) SHA1(63ef27ed5965d719215d0a469886d3852b6bffb6))
	ROM_LOAD("nassndl.u36", 0x200000, 0x100000, CRC(9e2658b1) SHA1(0d93a381a65f11022a1a6da5e5b0e4a0e779f336))
	ROM_LOAD("nassndl.u37", 0x300000, 0x100000, CRC(63f084ab) SHA1(519807bf6e868df6f756ad30af2f6636804f167c))
ROM_END

ROM_START(nascarl_350)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpul.350", 0x0000, 0x20000, CRC(ab749309) SHA1(95d35126bda75c68037010f001c28a860b6a6e0c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspl.303",   0x0000, 0x80000, CRC(868277f0) SHA1(9c058054e6dc3b838bfc3a91d37438afcd59aa4b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nascsp.u7",0x0000,0x10000,CRC(03a34394) SHA1(d1e3a1a8e14525c40e9f8a5441a106df662608f1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassndl.u17", 0x000000, 0x100000, CRC(058c67ad) SHA1(70e22d8a1842108309f6c03dcc6ac23a822da3c3))
	ROM_LOAD("nassndl.u21", 0x100000, 0x100000, CRC(e34d3b6f) SHA1(63ef27ed5965d719215d0a469886d3852b6bffb6))
	ROM_LOAD("nassndl.u36", 0x200000, 0x100000, CRC(9e2658b1) SHA1(0d93a381a65f11022a1a6da5e5b0e4a0e779f336))
	ROM_LOAD("nassndl.u37", 0x300000, 0x100000, CRC(63f084ab) SHA1(519807bf6e868df6f756ad30af2f6636804f167c))
ROM_END

ROM_START(nascarl_340)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpul.340",   0x0000, 0x20000, CRC(d5827082) SHA1(660216472a1faa445701eb3735771568cdba7b24))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspl.303",   0x0000, 0x80000, CRC(868277f0) SHA1(9c058054e6dc3b838bfc3a91d37438afcd59aa4b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nascsp.u7",0x0000,0x10000,CRC(03a34394) SHA1(d1e3a1a8e14525c40e9f8a5441a106df662608f1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassndl.u17", 0x000000, 0x100000, CRC(058c67ad) SHA1(70e22d8a1842108309f6c03dcc6ac23a822da3c3))
	ROM_LOAD("nassndl.u21", 0x100000, 0x100000, CRC(e34d3b6f) SHA1(63ef27ed5965d719215d0a469886d3852b6bffb6))
	ROM_LOAD("nassndl.u36", 0x200000, 0x100000, CRC(9e2658b1) SHA1(0d93a381a65f11022a1a6da5e5b0e4a0e779f336))
	ROM_LOAD("nassndl.u37", 0x300000, 0x100000, CRC(63f084ab) SHA1(519807bf6e868df6f756ad30af2f6636804f167c))
ROM_END

ROM_START(nascarl_301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "nascpul.301",   0x0000, 0x20000, CRC(6c8fc295) SHA1(2852afb38807a96907bc7357c08235de643dfb29))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "nasdspl.301",   0x0000, 0x80000, CRC(a6d4a9e7) SHA1(c87286bd173a50e17994474f98574c30cd6d8d39))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("nascsp.u7",0x0000,0x10000,CRC(03a34394) SHA1(d1e3a1a8e14525c40e9f8a5441a106df662608f1))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("nassndl.u17", 0x000000, 0x100000, CRC(058c67ad) SHA1(70e22d8a1842108309f6c03dcc6ac23a822da3c3))
	ROM_LOAD("nassndl.u21", 0x100000, 0x100000, CRC(e34d3b6f) SHA1(63ef27ed5965d719215d0a469886d3852b6bffb6))
	ROM_LOAD("nassndl.u36", 0x200000, 0x100000, CRC(9e2658b1) SHA1(0d93a381a65f11022a1a6da5e5b0e4a0e779f336))
	ROM_LOAD("nassndl.u37", 0x300000, 0x100000, CRC(63f084ab) SHA1(519807bf6e868df6f756ad30af2f6636804f167c))
ROM_END

/*-------------------------------------------------------------------
/ Ripley's Believe It or Not!
/-------------------------------------------------------------------*/
ROM_START(ripleys)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("ripcpu.320", 0x00000, 0x20000, CRC(aa997826) SHA1(2f9701370e64dd55a9bafe0c65e7eb4b9c5dbdd2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispa.300", 0x00000, 0x80000, CRC(016907c9) SHA1(d37f1ca5ebe089fca879339cdaffc3fabf09c15c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsnd.u7",0x0000,0x10000,CRC(4573a759) SHA1(189c1a2eaf9d92c40a1bc145f59ac428c74a7318))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsnd.u17", 0x000000, 0x100000, CRC(d518f2da) SHA1(e7d75c6b7b45571ae6d39ed7405b1457e475b52a))
	ROM_LOAD("ripsnd.u21", 0x100000, 0x100000, CRC(3d8680d7) SHA1(1368965106094d78be6540eb87a478f853ba774f))
	ROM_LOAD("ripsnd.u36", 0x200000, 0x100000, CRC(b697b5cb) SHA1(b5cb426201287a6d1c40db8c81a58e2c656d1d81))
	ROM_LOAD("ripsnd.u37", 0x300000, 0x100000, CRC(01b9f20e) SHA1(cffb6a0136d7d17ab4450b3bfd97632d8b669d39))
ROM_END

ROM_START(rip310)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.310",    0x0000, 0x20000, CRC(669f87cc) SHA1(0e07bbcf337bf7c289a9093d3db805da617cbfef))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispa.300", 0x00000, 0x80000, CRC(016907c9) SHA1(d37f1ca5ebe089fca879339cdaffc3fabf09c15c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsnd.u7",0x0000,0x10000,CRC(4573a759) SHA1(189c1a2eaf9d92c40a1bc145f59ac428c74a7318))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsnd.u17", 0x000000, 0x100000, CRC(d518f2da) SHA1(e7d75c6b7b45571ae6d39ed7405b1457e475b52a))
	ROM_LOAD("ripsnd.u21", 0x100000, 0x100000, CRC(3d8680d7) SHA1(1368965106094d78be6540eb87a478f853ba774f))
	ROM_LOAD("ripsnd.u36", 0x200000, 0x100000, CRC(b697b5cb) SHA1(b5cb426201287a6d1c40db8c81a58e2c656d1d81))
	ROM_LOAD("ripsnd.u37", 0x300000, 0x100000, CRC(01b9f20e) SHA1(cffb6a0136d7d17ab4450b3bfd97632d8b669d39))
ROM_END

ROM_START(rip302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.302",    0x0000, 0x20000, CRC(ee79d9eb) SHA1(79b45ceac00ebd414a9fb1d97c05252d9f953872))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispa.300", 0x00000, 0x80000, CRC(016907c9) SHA1(d37f1ca5ebe089fca879339cdaffc3fabf09c15c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsnd.u7",0x0000,0x10000,CRC(4573a759) SHA1(189c1a2eaf9d92c40a1bc145f59ac428c74a7318))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsnd.u17", 0x000000, 0x100000, CRC(d518f2da) SHA1(e7d75c6b7b45571ae6d39ed7405b1457e475b52a))
	ROM_LOAD("ripsnd.u21", 0x100000, 0x100000, CRC(3d8680d7) SHA1(1368965106094d78be6540eb87a478f853ba774f))
	ROM_LOAD("ripsnd.u36", 0x200000, 0x100000, CRC(b697b5cb) SHA1(b5cb426201287a6d1c40db8c81a58e2c656d1d81))
	ROM_LOAD("ripsnd.u37", 0x300000, 0x100000, CRC(01b9f20e) SHA1(cffb6a0136d7d17ab4450b3bfd97632d8b669d39))
ROM_END

ROM_START(rip301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.301", 0x0000, 0x20000, CRC(a867d1b4) SHA1(dca4ba5c981397d26cac016d8438704f7adea0f3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispa.300", 0x00000, 0x80000, CRC(016907c9) SHA1(d37f1ca5ebe089fca879339cdaffc3fabf09c15c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsnd.u7",0x0000,0x10000,CRC(4573a759) SHA1(189c1a2eaf9d92c40a1bc145f59ac428c74a7318))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsnd.u17", 0x000000, 0x100000, CRC(d518f2da) SHA1(e7d75c6b7b45571ae6d39ed7405b1457e475b52a))
	ROM_LOAD("ripsnd.u21", 0x100000, 0x100000, CRC(3d8680d7) SHA1(1368965106094d78be6540eb87a478f853ba774f))
	ROM_LOAD("ripsnd.u36", 0x200000, 0x100000, CRC(b697b5cb) SHA1(b5cb426201287a6d1c40db8c81a58e2c656d1d81))
	ROM_LOAD("ripsnd.u37", 0x300000, 0x100000, CRC(01b9f20e) SHA1(cffb6a0136d7d17ab4450b3bfd97632d8b669d39))
ROM_END

ROM_START(rip300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.300",    0x0000, 0x20000, CRC(8c4bf2a9) SHA1(260dd5a99a36de541b5f852047ae4166afc621cc))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispa.300", 0x00000, 0x80000, CRC(016907c9) SHA1(d37f1ca5ebe089fca879339cdaffc3fabf09c15c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsnd.u7",0x0000,0x10000,CRC(4573a759) SHA1(189c1a2eaf9d92c40a1bc145f59ac428c74a7318))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsnd.u17", 0x000000, 0x100000, CRC(d518f2da) SHA1(e7d75c6b7b45571ae6d39ed7405b1457e475b52a))
	ROM_LOAD("ripsnd.u21", 0x100000, 0x100000, CRC(3d8680d7) SHA1(1368965106094d78be6540eb87a478f853ba774f))
	ROM_LOAD("ripsnd.u36", 0x200000, 0x100000, CRC(b697b5cb) SHA1(b5cb426201287a6d1c40db8c81a58e2c656d1d81))
	ROM_LOAD("ripsnd.u37", 0x300000, 0x100000, CRC(01b9f20e) SHA1(cffb6a0136d7d17ab4450b3bfd97632d8b669d39))
ROM_END

ROM_START(ripleysf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("ripcpu.320", 0x00000, 0x20000, CRC(aa997826) SHA1(2f9701370e64dd55a9bafe0c65e7eb4b9c5dbdd2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispf.301", 0x00000, 0x80000, CRC(e5ae9d99) SHA1(74929b324b457d08a925c641430e6a7036c7039d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndf.u7",0x0000,0x10000,CRC(5808e3fc) SHA1(0c83399e8dc846607c469b7dd95878f3c2b9cb82))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndf.u17", 0x000000, 0x100000, CRC(a6793b85) SHA1(96058777346be6e9ea7b1340d9aaf945ac3c853a))
	ROM_LOAD("ripsndf.u21", 0x100000, 0x100000, CRC(60c02170) SHA1(900d9de3ccb541019e5f1528e01c57ad96dac262))
	ROM_LOAD("ripsndf.u36", 0x200000, 0x100000, CRC(0a57f2fd) SHA1(9dd057888294ee8abeb582e8f6650fd6e32cc9ff))
	ROM_LOAD("ripsndf.u37", 0x300000, 0x100000, CRC(5c858958) SHA1(f4a9833b8aee033ed381e3bdf9f801b935d6186a))
ROM_END

ROM_START(ripf310)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.310",    0x0000, 0x20000, CRC(669f87cc) SHA1(0e07bbcf337bf7c289a9093d3db805da617cbfef))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispf.301", 0x00000, 0x80000, CRC(e5ae9d99) SHA1(74929b324b457d08a925c641430e6a7036c7039d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndf.u7",0x0000,0x10000,CRC(5808e3fc) SHA1(0c83399e8dc846607c469b7dd95878f3c2b9cb82))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndf.u17", 0x000000, 0x100000, CRC(a6793b85) SHA1(96058777346be6e9ea7b1340d9aaf945ac3c853a))
	ROM_LOAD("ripsndf.u21", 0x100000, 0x100000, CRC(60c02170) SHA1(900d9de3ccb541019e5f1528e01c57ad96dac262))
	ROM_LOAD("ripsndf.u36", 0x200000, 0x100000, CRC(0a57f2fd) SHA1(9dd057888294ee8abeb582e8f6650fd6e32cc9ff))
	ROM_LOAD("ripsndf.u37", 0x300000, 0x100000, CRC(5c858958) SHA1(f4a9833b8aee033ed381e3bdf9f801b935d6186a))
ROM_END

ROM_START(ripf302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.302",    0x0000, 0x20000, CRC(ee79d9eb) SHA1(79b45ceac00ebd414a9fb1d97c05252d9f953872))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispf.301", 0x00000, 0x80000, CRC(e5ae9d99) SHA1(74929b324b457d08a925c641430e6a7036c7039d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndf.u7",0x0000,0x10000,CRC(5808e3fc) SHA1(0c83399e8dc846607c469b7dd95878f3c2b9cb82))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndf.u17", 0x000000, 0x100000, CRC(a6793b85) SHA1(96058777346be6e9ea7b1340d9aaf945ac3c853a))
	ROM_LOAD("ripsndf.u21", 0x100000, 0x100000, CRC(60c02170) SHA1(900d9de3ccb541019e5f1528e01c57ad96dac262))
	ROM_LOAD("ripsndf.u36", 0x200000, 0x100000, CRC(0a57f2fd) SHA1(9dd057888294ee8abeb582e8f6650fd6e32cc9ff))
	ROM_LOAD("ripsndf.u37", 0x300000, 0x100000, CRC(5c858958) SHA1(f4a9833b8aee033ed381e3bdf9f801b935d6186a))
ROM_END

ROM_START(ripf301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.301", 0x0000, 0x20000, CRC(a867d1b4) SHA1(dca4ba5c981397d26cac016d8438704f7adea0f3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispf.301", 0x00000, 0x80000, CRC(e5ae9d99) SHA1(74929b324b457d08a925c641430e6a7036c7039d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndf.u7",0x0000,0x10000,CRC(5808e3fc) SHA1(0c83399e8dc846607c469b7dd95878f3c2b9cb82))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndf.u17", 0x000000, 0x100000, CRC(a6793b85) SHA1(96058777346be6e9ea7b1340d9aaf945ac3c853a))
	ROM_LOAD("ripsndf.u21", 0x100000, 0x100000, CRC(60c02170) SHA1(900d9de3ccb541019e5f1528e01c57ad96dac262))
	ROM_LOAD("ripsndf.u36", 0x200000, 0x100000, CRC(0a57f2fd) SHA1(9dd057888294ee8abeb582e8f6650fd6e32cc9ff))
	ROM_LOAD("ripsndf.u37", 0x300000, 0x100000, CRC(5c858958) SHA1(f4a9833b8aee033ed381e3bdf9f801b935d6186a))
ROM_END

ROM_START(ripf300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.300",    0x0000, 0x20000, CRC(8c4bf2a9) SHA1(260dd5a99a36de541b5f852047ae4166afc621cc))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "ripdispf.300",  0x0000, 0x80000, CRC(b9901941) SHA1(653997ff5d63e7ee0270db08cad952ac8293a8cd))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndf.u7",0x0000,0x10000,CRC(5808e3fc) SHA1(0c83399e8dc846607c469b7dd95878f3c2b9cb82))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndf.u17", 0x000000, 0x100000, CRC(a6793b85) SHA1(96058777346be6e9ea7b1340d9aaf945ac3c853a))
	ROM_LOAD("ripsndf.u21", 0x100000, 0x100000, CRC(60c02170) SHA1(900d9de3ccb541019e5f1528e01c57ad96dac262))
	ROM_LOAD("ripsndf.u36", 0x200000, 0x100000, CRC(0a57f2fd) SHA1(9dd057888294ee8abeb582e8f6650fd6e32cc9ff))
	ROM_LOAD("ripsndf.u37", 0x300000, 0x100000, CRC(5c858958) SHA1(f4a9833b8aee033ed381e3bdf9f801b935d6186a))
ROM_END

ROM_START(ripleysg)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("ripcpu.320", 0x00000, 0x20000, CRC(aa997826) SHA1(2f9701370e64dd55a9bafe0c65e7eb4b9c5dbdd2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispg.300", 0x00000, 0x80000, CRC(1a75883b) SHA1(0ef2f4af72e435e5be9d3d8a6b69c66ae18271a1))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndg.u7",0x0000,0x10000,CRC(400b8a45) SHA1(62101995e632264df3c014b746cc4b2ae72676d4))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndg.u17", 0x000000, 0x100000, CRC(c387dcf0) SHA1(d4ef65d3f33ab82b63bf2782f335858ab4ad210a))
	ROM_LOAD("ripsndg.u21", 0x100000, 0x100000, CRC(6388ae8d) SHA1(a39c7977194daabf3f5b10d0269dcd4118a939bc))
	ROM_LOAD("ripsndg.u36", 0x200000, 0x100000, CRC(3143f9d3) SHA1(bd4ce64b245b5fcb9b9694bd8f71a9cd98303cae))
	ROM_LOAD("ripsndg.u37", 0x300000, 0x100000, CRC(2167617b) SHA1(62b55a39e2677eec9d56b10e8cc3e5d7c0d3bea5))
ROM_END

ROM_START(ripg310)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.310",    0x0000, 0x20000, CRC(669f87cc) SHA1(0e07bbcf337bf7c289a9093d3db805da617cbfef))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispg.300", 0x00000, 0x80000, CRC(1a75883b) SHA1(0ef2f4af72e435e5be9d3d8a6b69c66ae18271a1))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndg.u7",0x0000,0x10000,CRC(400b8a45) SHA1(62101995e632264df3c014b746cc4b2ae72676d4))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndg.u17", 0x000000, 0x100000, CRC(c387dcf0) SHA1(d4ef65d3f33ab82b63bf2782f335858ab4ad210a))
	ROM_LOAD("ripsndg.u21", 0x100000, 0x100000, CRC(6388ae8d) SHA1(a39c7977194daabf3f5b10d0269dcd4118a939bc))
	ROM_LOAD("ripsndg.u36", 0x200000, 0x100000, CRC(3143f9d3) SHA1(bd4ce64b245b5fcb9b9694bd8f71a9cd98303cae))
	ROM_LOAD("ripsndg.u37", 0x300000, 0x100000, CRC(2167617b) SHA1(62b55a39e2677eec9d56b10e8cc3e5d7c0d3bea5))
ROM_END

ROM_START(ripg302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.302",    0x0000, 0x20000, CRC(ee79d9eb) SHA1(79b45ceac00ebd414a9fb1d97c05252d9f953872))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispg.300", 0x00000, 0x80000, CRC(1a75883b) SHA1(0ef2f4af72e435e5be9d3d8a6b69c66ae18271a1))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndg.u7",0x0000,0x10000,CRC(400b8a45) SHA1(62101995e632264df3c014b746cc4b2ae72676d4))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndg.u17", 0x000000, 0x100000, CRC(c387dcf0) SHA1(d4ef65d3f33ab82b63bf2782f335858ab4ad210a))
	ROM_LOAD("ripsndg.u21", 0x100000, 0x100000, CRC(6388ae8d) SHA1(a39c7977194daabf3f5b10d0269dcd4118a939bc))
	ROM_LOAD("ripsndg.u36", 0x200000, 0x100000, CRC(3143f9d3) SHA1(bd4ce64b245b5fcb9b9694bd8f71a9cd98303cae))
	ROM_LOAD("ripsndg.u37", 0x300000, 0x100000, CRC(2167617b) SHA1(62b55a39e2677eec9d56b10e8cc3e5d7c0d3bea5))
ROM_END

ROM_START(ripg301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.301", 0x0000, 0x20000, CRC(a867d1b4) SHA1(dca4ba5c981397d26cac016d8438704f7adea0f3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispg.300", 0x00000, 0x80000, CRC(1a75883b) SHA1(0ef2f4af72e435e5be9d3d8a6b69c66ae18271a1))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndg.u7",0x0000,0x10000,CRC(400b8a45) SHA1(62101995e632264df3c014b746cc4b2ae72676d4))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndg.u17", 0x000000, 0x100000, CRC(c387dcf0) SHA1(d4ef65d3f33ab82b63bf2782f335858ab4ad210a))
	ROM_LOAD("ripsndg.u21", 0x100000, 0x100000, CRC(6388ae8d) SHA1(a39c7977194daabf3f5b10d0269dcd4118a939bc))
	ROM_LOAD("ripsndg.u36", 0x200000, 0x100000, CRC(3143f9d3) SHA1(bd4ce64b245b5fcb9b9694bd8f71a9cd98303cae))
	ROM_LOAD("ripsndg.u37", 0x300000, 0x100000, CRC(2167617b) SHA1(62b55a39e2677eec9d56b10e8cc3e5d7c0d3bea5))
ROM_END

ROM_START(ripg300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.300",    0x0000, 0x20000, CRC(8c4bf2a9) SHA1(260dd5a99a36de541b5f852047ae4166afc621cc))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispg.300", 0x00000, 0x80000, CRC(1a75883b) SHA1(0ef2f4af72e435e5be9d3d8a6b69c66ae18271a1))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndg.u7",0x0000,0x10000,CRC(400b8a45) SHA1(62101995e632264df3c014b746cc4b2ae72676d4))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndg.u17", 0x000000, 0x100000, CRC(c387dcf0) SHA1(d4ef65d3f33ab82b63bf2782f335858ab4ad210a))
	ROM_LOAD("ripsndg.u21", 0x100000, 0x100000, CRC(6388ae8d) SHA1(a39c7977194daabf3f5b10d0269dcd4118a939bc))
	ROM_LOAD("ripsndg.u36", 0x200000, 0x100000, CRC(3143f9d3) SHA1(bd4ce64b245b5fcb9b9694bd8f71a9cd98303cae))
	ROM_LOAD("ripsndg.u37", 0x300000, 0x100000, CRC(2167617b) SHA1(62b55a39e2677eec9d56b10e8cc3e5d7c0d3bea5))
ROM_END

ROM_START(ripleysi)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("ripcpu.320", 0x00000, 0x20000, CRC(aa997826) SHA1(2f9701370e64dd55a9bafe0c65e7eb4b9c5dbdd2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispi.300", 0x00000, 0x80000, CRC(c3541c04) SHA1(26256e8dee77bcfa96326d2e3f67b6fd3696c0c7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndi.u7",0x0000,0x10000,CRC(86b1b2b2) SHA1(9e2cf7368b31531998d546a1be2af274a9cbbd2f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndi.u17", 0x000000, 0x100000, CRC(a2911df4) SHA1(acb7956a6a30142c8da905b04778a074cb335807))
	ROM_LOAD("ripsndi.u21", 0x100000, 0x100000, CRC(1467eaff) SHA1(c6c4ea2abdad4334efbe3a084693e9e4d0dd0fd2))
	ROM_LOAD("ripsndi.u36", 0x200000, 0x100000, CRC(6a124fa6) SHA1(752c3d227b9a98dd859e4778ddd527edaa3cf512))
	ROM_LOAD("ripsndi.u37", 0x300000, 0x100000, CRC(7933c102) SHA1(f736ee86d7c67dab82c634d125d73a2453249706))
ROM_END

ROM_START(ripi310)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.310",    0x0000, 0x20000, CRC(669f87cc) SHA1(0e07bbcf337bf7c289a9093d3db805da617cbfef))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispi.300", 0x00000, 0x80000, CRC(c3541c04) SHA1(26256e8dee77bcfa96326d2e3f67b6fd3696c0c7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndi.u7",0x0000,0x10000,CRC(86b1b2b2) SHA1(9e2cf7368b31531998d546a1be2af274a9cbbd2f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndi.u17", 0x000000, 0x100000, CRC(a2911df4) SHA1(acb7956a6a30142c8da905b04778a074cb335807))
	ROM_LOAD("ripsndi.u21", 0x100000, 0x100000, CRC(1467eaff) SHA1(c6c4ea2abdad4334efbe3a084693e9e4d0dd0fd2))
	ROM_LOAD("ripsndi.u36", 0x200000, 0x100000, CRC(6a124fa6) SHA1(752c3d227b9a98dd859e4778ddd527edaa3cf512))
	ROM_LOAD("ripsndi.u37", 0x300000, 0x100000, CRC(7933c102) SHA1(f736ee86d7c67dab82c634d125d73a2453249706))
ROM_END

ROM_START(ripi302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.302",    0x0000, 0x20000, CRC(ee79d9eb) SHA1(79b45ceac00ebd414a9fb1d97c05252d9f953872))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispi.300", 0x00000, 0x80000, CRC(c3541c04) SHA1(26256e8dee77bcfa96326d2e3f67b6fd3696c0c7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndi.u7",0x0000,0x10000,CRC(86b1b2b2) SHA1(9e2cf7368b31531998d546a1be2af274a9cbbd2f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndi.u17", 0x000000, 0x100000, CRC(a2911df4) SHA1(acb7956a6a30142c8da905b04778a074cb335807))
	ROM_LOAD("ripsndi.u21", 0x100000, 0x100000, CRC(1467eaff) SHA1(c6c4ea2abdad4334efbe3a084693e9e4d0dd0fd2))
	ROM_LOAD("ripsndi.u36", 0x200000, 0x100000, CRC(6a124fa6) SHA1(752c3d227b9a98dd859e4778ddd527edaa3cf512))
	ROM_LOAD("ripsndi.u37", 0x300000, 0x100000, CRC(7933c102) SHA1(f736ee86d7c67dab82c634d125d73a2453249706))
ROM_END

ROM_START(ripi301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.301", 0x0000, 0x20000, CRC(a867d1b4) SHA1(dca4ba5c981397d26cac016d8438704f7adea0f3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispi.300", 0x00000, 0x80000, CRC(c3541c04) SHA1(26256e8dee77bcfa96326d2e3f67b6fd3696c0c7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndi.u7",0x0000,0x10000,CRC(86b1b2b2) SHA1(9e2cf7368b31531998d546a1be2af274a9cbbd2f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndi.u17", 0x000000, 0x100000, CRC(a2911df4) SHA1(acb7956a6a30142c8da905b04778a074cb335807))
	ROM_LOAD("ripsndi.u21", 0x100000, 0x100000, CRC(1467eaff) SHA1(c6c4ea2abdad4334efbe3a084693e9e4d0dd0fd2))
	ROM_LOAD("ripsndi.u36", 0x200000, 0x100000, CRC(6a124fa6) SHA1(752c3d227b9a98dd859e4778ddd527edaa3cf512))
	ROM_LOAD("ripsndi.u37", 0x300000, 0x100000, CRC(7933c102) SHA1(f736ee86d7c67dab82c634d125d73a2453249706))
ROM_END

ROM_START(ripi300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.300",    0x0000, 0x20000, CRC(8c4bf2a9) SHA1(260dd5a99a36de541b5f852047ae4166afc621cc))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispi.300", 0x00000, 0x80000, CRC(c3541c04) SHA1(26256e8dee77bcfa96326d2e3f67b6fd3696c0c7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndi.u7",0x0000,0x10000,CRC(86b1b2b2) SHA1(9e2cf7368b31531998d546a1be2af274a9cbbd2f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndi.u17", 0x000000, 0x100000, CRC(a2911df4) SHA1(acb7956a6a30142c8da905b04778a074cb335807))
	ROM_LOAD("ripsndi.u21", 0x100000, 0x100000, CRC(1467eaff) SHA1(c6c4ea2abdad4334efbe3a084693e9e4d0dd0fd2))
	ROM_LOAD("ripsndi.u36", 0x200000, 0x100000, CRC(6a124fa6) SHA1(752c3d227b9a98dd859e4778ddd527edaa3cf512))
	ROM_LOAD("ripsndi.u37", 0x300000, 0x100000, CRC(7933c102) SHA1(f736ee86d7c67dab82c634d125d73a2453249706))
ROM_END

ROM_START(ripleysl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("ripcpu.320", 0x00000, 0x20000, CRC(aa997826) SHA1(2f9701370e64dd55a9bafe0c65e7eb4b9c5dbdd2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispl.301", 0x00000, 0x80000, CRC(47c87ad4) SHA1(eb372b9f17b28d0781c49a28cb850916ccec323d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndl.u7",0x0000,0x10000,CRC(25fb729a) SHA1(46b9ca8fd5fb5a692adbdb7495af34a1db89dc37))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndl.u17", 0x000000, 0x100000, CRC(a98f4514) SHA1(e87ee8f5a87a8ae9ec996473bf9bc745105ea334))
	ROM_LOAD("ripsndl.u21", 0x100000, 0x100000, CRC(141f2b77) SHA1(15bab623beda8ae7ed9908f492ff2baab0a7954e))
	ROM_LOAD("ripsndl.u36", 0x200000, 0x100000, CRC(c5461b63) SHA1(fc574d44ad88ce1db590ea371225092c03fc6f80))
	ROM_LOAD("ripsndl.u37", 0x300000, 0x100000, CRC(2a58f491) SHA1(1c33f419420b3165ef18598560007ef612b24814))
ROM_END

ROM_START(ripl310)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.310",    0x0000, 0x20000, CRC(669f87cc) SHA1(0e07bbcf337bf7c289a9093d3db805da617cbfef))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispl.301", 0x00000, 0x80000, CRC(47c87ad4) SHA1(eb372b9f17b28d0781c49a28cb850916ccec323d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndl.u7",0x0000,0x10000,CRC(25fb729a) SHA1(46b9ca8fd5fb5a692adbdb7495af34a1db89dc37))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndl.u17", 0x000000, 0x100000, CRC(a98f4514) SHA1(e87ee8f5a87a8ae9ec996473bf9bc745105ea334))
	ROM_LOAD("ripsndl.u21", 0x100000, 0x100000, CRC(141f2b77) SHA1(15bab623beda8ae7ed9908f492ff2baab0a7954e))
	ROM_LOAD("ripsndl.u36", 0x200000, 0x100000, CRC(c5461b63) SHA1(fc574d44ad88ce1db590ea371225092c03fc6f80))
	ROM_LOAD("ripsndl.u37", 0x300000, 0x100000, CRC(2a58f491) SHA1(1c33f419420b3165ef18598560007ef612b24814))
ROM_END

ROM_START(ripl302)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.302",    0x0000, 0x20000, CRC(ee79d9eb) SHA1(79b45ceac00ebd414a9fb1d97c05252d9f953872))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispl.301", 0x00000, 0x80000, CRC(47c87ad4) SHA1(eb372b9f17b28d0781c49a28cb850916ccec323d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndl.u7",0x0000,0x10000,CRC(25fb729a) SHA1(46b9ca8fd5fb5a692adbdb7495af34a1db89dc37))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndl.u17", 0x000000, 0x100000, CRC(a98f4514) SHA1(e87ee8f5a87a8ae9ec996473bf9bc745105ea334))
	ROM_LOAD("ripsndl.u21", 0x100000, 0x100000, CRC(141f2b77) SHA1(15bab623beda8ae7ed9908f492ff2baab0a7954e))
	ROM_LOAD("ripsndl.u36", 0x200000, 0x100000, CRC(c5461b63) SHA1(fc574d44ad88ce1db590ea371225092c03fc6f80))
	ROM_LOAD("ripsndl.u37", 0x300000, 0x100000, CRC(2a58f491) SHA1(1c33f419420b3165ef18598560007ef612b24814))
ROM_END

ROM_START(ripl301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.301", 0x0000, 0x20000, CRC(a867d1b4) SHA1(dca4ba5c981397d26cac016d8438704f7adea0f3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("ripdispl.301", 0x00000, 0x80000, CRC(47c87ad4) SHA1(eb372b9f17b28d0781c49a28cb850916ccec323d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndl.u7",0x0000,0x10000,CRC(25fb729a) SHA1(46b9ca8fd5fb5a692adbdb7495af34a1db89dc37))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndl.u17", 0x000000, 0x100000, CRC(a98f4514) SHA1(e87ee8f5a87a8ae9ec996473bf9bc745105ea334))
	ROM_LOAD("ripsndl.u21", 0x100000, 0x100000, CRC(141f2b77) SHA1(15bab623beda8ae7ed9908f492ff2baab0a7954e))
	ROM_LOAD("ripsndl.u36", 0x200000, 0x100000, CRC(c5461b63) SHA1(fc574d44ad88ce1db590ea371225092c03fc6f80))
	ROM_LOAD("ripsndl.u37", 0x300000, 0x100000, CRC(2a58f491) SHA1(1c33f419420b3165ef18598560007ef612b24814))
ROM_END

ROM_START(ripl300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "ripcpu.300",    0x0000, 0x20000, CRC(8c4bf2a9) SHA1(260dd5a99a36de541b5f852047ae4166afc621cc))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "ripdispl.300",  0x0000, 0x80000, CRC(d2f496bb) SHA1(48622e25171030b83d8d1736735e97a13c5f47c6))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("ripsndl.u7",0x0000,0x10000,CRC(25fb729a) SHA1(46b9ca8fd5fb5a692adbdb7495af34a1db89dc37))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("ripsndl.u17", 0x000000, 0x100000, CRC(a98f4514) SHA1(e87ee8f5a87a8ae9ec996473bf9bc745105ea334))
	ROM_LOAD("ripsndl.u21", 0x100000, 0x100000, CRC(141f2b77) SHA1(15bab623beda8ae7ed9908f492ff2baab0a7954e))
	ROM_LOAD("ripsndl.u36", 0x200000, 0x100000, CRC(c5461b63) SHA1(fc574d44ad88ce1db590ea371225092c03fc6f80))
	ROM_LOAD("ripsndl.u37", 0x300000, 0x100000, CRC(2a58f491) SHA1(1c33f419420b3165ef18598560007ef612b24814))
ROM_END


/*-------------------------------------------------------------------
/ The Lord Of The Rings
/-------------------------------------------------------------------*/
ROM_START(lotr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpua.a00", 0x00000, 0x20000, CRC(00e43b70) SHA1(7100da644a1b166051915870d01cfa6baaf87293))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("lotrdspa.a00", 0x00000, 0x80000, CRC(99634603) SHA1(c40d1480e5df10a491bcd471c6a3a118a9120bcb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr9)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.900",   0x0000, 0x20000, CRC(eff1ab83) SHA1(cd9cfa3fa150224e44078602db7d8bbfe223b926))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.900",  0x0000, 0x80000, CRC(2b1debd3) SHA1(eab1ffa7b5111bf224c47688bb6c0f40ee6e12fb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr8)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.800",   0x0000, 0x20000, CRC(655e5b3c) SHA1(bd6fd25e17cee40d6bb842367b1ce922bbd46003))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.800",  0x0000, 0x80000, CRC(2aa1f00d) SHA1(e9df5b61b467c307aacdb5a6980a78af26492e6a))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr7)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.700",   0x0000, 0x20000, CRC(208a4653) SHA1(570f3070c6b0f128d451f3dea01e41a9944081f2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.700",  0x0000, 0x80000, CRC(233ef0ad) SHA1(1564ae806639dac49add0c464f4499f46b5589ab)) // ver 7.00
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr6)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.600", 0x0000, 0x20000, CRC(02786892) SHA1(6810d5a5eb80f520e611a46921dbd2906fbebf2f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.600", 0x0000, 0x80000, CRC(d2098cec) SHA1(06c5c0b29e1442f503b4b374537b9d233721b4b6))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr501)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.501", 0x0000, 0x20000, CRC(df9fd692) SHA1(2d06c1a763330b1b9429961f3e13574e0eefe7a7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.501", 0x0000, 0x80000, CRC(2d555b9f) SHA1(d2d23182dea810624cab010890971d8997f8570c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr5)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.500", 0x0000, 0x20000, CRC(4b45a543) SHA1(e0be3a4244025abc2c109f58b0d637262711b9db))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.500", 0x0000, 0x80000, CRC(19bda8d2) SHA1(a3d9e60f964d100594f82ed361f86e74c8d69748))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr410)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.410", 0x0000, 0x20000, CRC(458af09a) SHA1(2680f16d7f33ffc70b64bfb7d35cccf6989c70e2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.404", 0x0000, 0x80000, CRC(1aefcbe7) SHA1(b17fc82425dd5a6ea5a17205d4000294324bb5cc))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.401",   0x0000, 0x20000, CRC(b69cdecc) SHA1(40f7c2d25a1028255be8fe25e3aa6d11976edd25))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspa.403",  0x0000, 0x80000, CRC(2630cef1) SHA1(1dfd929e7eb57983f2fd9184d471f2e919359de0))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_sp)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpul.a00", 0x00000, 0x20000, CRC(c62aba47) SHA1(2fef599313e5cd9bded3ab00b933631586e2a1e7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("lotrdspl.a00", 0x00000, 0x80000, CRC(2494a5ee) SHA1(5b95711858d88eeb445503cac8b9b754cf8e9960))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END

ROM_START(lotr_sp9)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpul.900",  0x0000, 0x20000, CRC(155b5d5b) SHA1(c032e3828ed256240a5155ec4c7820d615a2cbe1))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspl.900",  0x0000, 0x80000, CRC(00f98242) SHA1(9a0e7e572e209b20691392a694a524192daa0d2a))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END

ROM_START(lotr_sp8)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpul.800",  0x0000, 0x20000, CRC(38e83068) SHA1(603b1236bf195c72d32e5a1088a2806e77176436))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspl.800",  0x0000, 0x80000, CRC(137c1255) SHA1(43d9ffec18ab2aa80f30b195ca5270d4574d7b8d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END

ROM_START(lotr_sp7)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpul.700",  0x0000, 0x20000, CRC(58d8611b) SHA1(ff1e1668993c7c31f04efc22f04ae53112219a1d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspl.700",  0x0000, 0x80000, CRC(3be0283d) SHA1(e019c69cd452b67d6427ddda12b5c3f341afb414))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END

ROM_START(lotr_sp6)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpul.600", 0x0000, 0x20000, CRC(af06c560) SHA1(0dec564e8e50ca8e05c462517db38ae48e512e79))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspl.600", 0x0000, 0x80000, CRC(d664d989) SHA1(575f9dcc7cb8aac4bfdb25575b7b9c00cf6459b9))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END

ROM_START(lotr_sp501)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpul.501", 0x0000, 0x20000, CRC(4c0c7360) SHA1(f057931eb719a7a6691187fa7ca86cd6e4541d90))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspl.501", 0x0000, 0x80000, CRC(7e96c0f8) SHA1(2ef63b1b30fb2680b97a9080f7b9d76b4d2a76d4))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END

ROM_START(lotr_sp5)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpul.500", 0x0000, 0x20000, CRC(298d10bd) SHA1(133990aed459d5fcd191a08462a231bbd3449387))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspl.500", 0x0000, 0x80000, CRC(ab538b24) SHA1(039aa8f4286694971cd9a78805bb9f3acabcd692))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END

ROM_START(lotr_sp401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpul.401",  0x0000, 0x20000, CRC(a9571728) SHA1(f21dd77003f42fafd9293fab3a077c5abf6d572a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspl.403",  0x0000, 0x80000, CRC(6d4075c9) SHA1(7944ba597cb476c33060cead4feaf6dcad4f4b16))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotrlu7.100",0x0000,0x10000,CRC(980d970a) SHA1(cf70deddcc146ef9eaa64baec74ae800bebf8715))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotrlu17.100", 0x000000, 0x100000, CRC(c16d3e20) SHA1(43d9f186db361abb3aa119a7252f1bb13bbbbe39))
	ROM_LOAD("lotrlu21.100", 0x100000, 0x100000, CRC(f956a1be) SHA1(2980e85463704a154ed81d3241f866442d1ea2e6))
	ROM_LOAD("lotrlu36.100", 0x200000, 0x100000, CRC(502c3d93) SHA1(4ee42d70bccb9253fe1f8f441de6b5018257f107))
	ROM_LOAD("lotrlu37.100", 0x300000, 0x100000, CRC(61f21c6d) SHA1(3e9781b4981bd18cdb8c59c55b9942de6ae286db))
ROM_END


ROM_START(lotr_gr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpua.a00", 0x00000, 0x20000, CRC(00e43b70) SHA1(7100da644a1b166051915870d01cfa6baaf87293))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("lotrdspg.a00", 0x00000, 0x80000, CRC(6743a910) SHA1(977773515f00af3937aa59426917e8111ec855ab))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr9)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.900",   0x0000, 0x20000, CRC(eff1ab83) SHA1(cd9cfa3fa150224e44078602db7d8bbfe223b926))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.900",  0x0000, 0x80000, CRC(f5fdd2c2) SHA1(0c5f1b1efe3d38063e2327e2ccfe40936f3988b8))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr8)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.800",   0x0000, 0x20000, CRC(655e5b3c) SHA1(bd6fd25e17cee40d6bb842367b1ce922bbd46003))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.800",  0x0000, 0x80000, CRC(55765c23) SHA1(690a72e8cb1099a6873eb3214e72bb0fea54fa22))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr7)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.700",   0x0000, 0x20000, CRC(208a4653) SHA1(570f3070c6b0f128d451f3dea01e41a9944081f2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.700",  0x0000, 0x80000, CRC(137f223c) SHA1(bb06a6f587bf86555aea85bc1c0402e2137e1c76))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr6)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.600", 0x0000, 0x20000, CRC(02786892) SHA1(6810d5a5eb80f520e611a46921dbd2906fbebf2f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.600", 0x0000, 0x80000, CRC(b0de0827) SHA1(1a0aa25a3b881148aafa5e2fabb7a3c501343524))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr501)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.501", 0x0000, 0x20000, CRC(df9fd692) SHA1(2d06c1a763330b1b9429961f3e13574e0eefe7a7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.501", 0x0000, 0x80000, CRC(16984eaa) SHA1(999254d12402b0866e4a6f5bb2c03dc5c1c59c5f))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr5)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.500", 0x0000, 0x20000, CRC(4b45a543) SHA1(e0be3a4244025abc2c109f58b0d637262711b9db))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.500", 0x0000, 0x80000, CRC(39177315) SHA1(13bcf2833ff89fe056517d3ea7b58fb31963cbfc))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr410)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.410", 0x0000, 0x20000, CRC(458af09a) SHA1(2680f16d7f33ffc70b64bfb7d35cccf6989c70e2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.404", 0x0000, 0x80000, CRC(b78975e5) SHA1(33d9f4d29a83ce0f68e654c15973dfdeee4d224d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_gr401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.401",   0x0000, 0x20000, CRC(b69cdecc) SHA1(40f7c2d25a1028255be8fe25e3aa6d11976edd25))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspg.403",  0x0000, 0x80000, CRC(74e925cb) SHA1(2edc8666d53f212a053b7a356d2bf6e3180d7bfb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpua.a00", 0x00000, 0x20000, CRC(00e43b70) SHA1(7100da644a1b166051915870d01cfa6baaf87293))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("lotrdspf.a00", 0x00000, 0x80000, CRC(15c26c2d) SHA1(c8e4b442d717aa5881f3d92f044c44d29a14126c))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr9)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.900",   0x0000, 0x20000, CRC(eff1ab83) SHA1(cd9cfa3fa150224e44078602db7d8bbfe223b926))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.900",  0x0000, 0x80000, CRC(f2d8296e) SHA1(3eb6e1e6ba299b720816bf165b1e20e02f6c0c1e))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr8)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.800",   0x0000, 0x20000, CRC(655e5b3c) SHA1(bd6fd25e17cee40d6bb842367b1ce922bbd46003))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.800",  0x0000, 0x80000, CRC(e1ccc04b) SHA1(1d5c7ea06f0cb2e1965c968ed01330867aae8e2b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr7)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.700",   0x0000, 0x20000, CRC(208a4653) SHA1(570f3070c6b0f128d451f3dea01e41a9944081f2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.700",  0x0000, 0x80000, CRC(c98aeb30) SHA1(16b0ae41db8b4083121cc5ebf2706320d554dd08))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr6)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.600", 0x0000, 0x20000, CRC(02786892) SHA1(6810d5a5eb80f520e611a46921dbd2906fbebf2f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.600", 0x0000, 0x80000, CRC(5cf6c0b6) SHA1(d7fde5dda4c48da15b682ed9f52d20d8ea2accc9))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr501)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.501", 0x0000, 0x20000, CRC(df9fd692) SHA1(2d06c1a763330b1b9429961f3e13574e0eefe7a7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.501", 0x0000, 0x80000, CRC(a07596ac) SHA1(99db750971eafc3dba5f5d3e15728de306984ba4))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr5)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.500", 0x0000, 0x20000, CRC(4b45a543) SHA1(e0be3a4244025abc2c109f58b0d637262711b9db))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.500", 0x0000, 0x80000, CRC(ee5768a1) SHA1(05e696bfc4a7630b483f2f9acd39e53fefe937ef))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr410)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.410", 0x0000, 0x20000, CRC(458af09a) SHA1(2680f16d7f33ffc70b64bfb7d35cccf6989c70e2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.404", 0x0000, 0x80000, CRC(ebf4bb43) SHA1(5e392c3363db3d56b2ec66fcc43a59b5e8cdf944))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_fr401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.401",   0x0000, 0x20000, CRC(b69cdecc) SHA1(40f7c2d25a1028255be8fe25e3aa6d11976edd25))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspf.403",  0x0000, 0x80000, CRC(d02a77cf) SHA1(8cf4312a04ad486714de5c0041cacb1eb475478f))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpua.a00", 0x00000, 0x20000, CRC(00e43b70) SHA1(7100da644a1b166051915870d01cfa6baaf87293))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("lotrdspi.a00", 0x00000, 0x80000, CRC(6c88f395) SHA1(365d5c6908f5861816b73f287194c85d2300635d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it9)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.900",   0x0000, 0x20000, CRC(eff1ab83) SHA1(cd9cfa3fa150224e44078602db7d8bbfe223b926))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.900",  0x0000, 0x80000, CRC(a09407d7) SHA1(2cdb70ee0bae7f67f4bf12b0dd3e6cf574087e3d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it8)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.800",   0x0000, 0x20000, CRC(655e5b3c) SHA1(bd6fd25e17cee40d6bb842367b1ce922bbd46003))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.800",  0x0000, 0x80000, CRC(b80730d7) SHA1(552c0bfac1c7a6b246829378a30d58769e695f7e))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it7)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.700",   0x0000, 0x20000, CRC(208a4653) SHA1(570f3070c6b0f128d451f3dea01e41a9944081f2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.700",  0x0000, 0x80000, CRC(6a0d2a6d) SHA1(2b3ca8b26d79919b7102c60515972ab142d1cbf1))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it6)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.600", 0x0000, 0x20000, CRC(02786892) SHA1(6810d5a5eb80f520e611a46921dbd2906fbebf2f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.600", 0x0000, 0x80000, CRC(9d0b9b3d) SHA1(21363ddbb2c2510fcc9386020f2fd3f49e9c49c3))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it501)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.501", 0x0000, 0x20000, CRC(df9fd692) SHA1(2d06c1a763330b1b9429961f3e13574e0eefe7a7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.501", 0x0000, 0x80000, CRC(440bbba1) SHA1(e85eca9a1b04ba8bc2784414f7003674bcafba9d))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it5)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.500", 0x0000, 0x20000, CRC(4b45a543) SHA1(e0be3a4244025abc2c109f58b0d637262711b9db))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.500", 0x0000, 0x80000, CRC(ea8d4ac6) SHA1(f46e8c3f344babc67e72f7077880c21df0c42030))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it410)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "lotrcpu.410", 0x0000, 0x20000, CRC(458af09a) SHA1(2680f16d7f33ffc70b64bfb7d35cccf6989c70e2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.404", 0x0000, 0x80000, CRC(05db2615) SHA1(0146abd3681d351ef6c1160b85be8bed2886fb27))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END

ROM_START(lotr_it401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpu.401",   0x0000, 0x20000, CRC(b69cdecc) SHA1(40f7c2d25a1028255be8fe25e3aa6d11976edd25))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "lotrdspi.403",  0x0000, 0x80000, CRC(5922ce10) SHA1(c57f2de4e3344f16056405d71510c0c0b60ef86d)) // ver 4.03
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END


ROM_START(lotr_le)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("lotrcpua.a02", 0x00000, 0x20000, CRC(f732aeb1) SHA1(8c28e91d37525b3e356bddf2cf1be42ea44f3629))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("lotrdspa.a00", 0x00000, 0x80000, CRC(99634603) SHA1(c40d1480e5df10a491bcd471c6a3a118a9120bcb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("lotr-u7.101",0x0000,0x10000,CRC(ba018c5c) SHA1(67e4b9729f086de5e8d56a6ac29fce1c7082e470))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("lotr-u17.100", 0x000000, 0x100000, CRC(d503969d) SHA1(65a4313ca1b93391260c65fef6f878d264f9c8ab))
	ROM_LOAD("lotr-u21.100", 0x100000, 0x100000, CRC(8b3f41af) SHA1(9b2d04144edeb499b4ae68a97c65ccb8ef4d26c0))
	ROM_LOAD("lotr-u36.100", 0x200000, 0x100000, CRC(9575981e) SHA1(38083fd923c4a168a94d998ec3c4db42c1e2a2da))
	ROM_LOAD("lotr-u37.100", 0x300000, 0x100000, CRC(8e637a6f) SHA1(8087744ce36fc143381d49a312c98cf38b2f9854))
ROM_END
/*-------------------------------------------------------------------
/ The Sopranos
/-------------------------------------------------------------------*/
ROM_START(sopranos)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sopcpua.500", 0x00000, 0x20000, CRC(e3430f28) SHA1(3b942922087cca41701ef70fbc84baaffe8da90d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspa.500", 0x00000, 0x80000, CRC(170bd8d1) SHA1(df8d240425ac2c1aa4bea560ecdd3d64120faeb7))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsnda.u7",0x0000,0x10000,CRC(47817240) SHA1(da2ff205fb5fe732514e7aa312ff552ecd4b31b7))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsnda.u17", 0x000000, 0x100000, CRC(21e0cfd2) SHA1(d2ff1242f1f4a206e0b2884c079ef2be5df143ac))
	ROM_LOAD("sopsnda.u21", 0x100000, 0x100000, CRC(10669399) SHA1(6ad31c91ba3c772f7a79e4408a4422332243c7d1))
	ROM_LOAD("sopsnda.u36", 0x200000, 0x100000, CRC(f3535025) SHA1(3fc22af5db0a8b744c0513e24a6331c9cf82e3ed))
	ROM_LOAD("sopsnda.u37", 0x300000, 0x100000, CRC(4b67fe8a) SHA1(b980b9705b4a41a0524b3b0095d6398bdbed609f))
ROM_END

ROM_START(sopranos_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sopcpua.400", 0x00000, 0x20000, CRC(68efcf24) SHA1(9ef30808260f96fb19067ee473add0c43dd6180e))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspa.400", 0x00000, 0x80000, CRC(60d6b9d3) SHA1(925d2c84e486e4a71bd05b542429a0e22a99072f))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsnd3.u7", 0x0000,0x10000,CRC(b22ba5aa) SHA1(8f69932e3b115ae7a6bcb9a15a8b5bf6579e94e0)) // sldh
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsnda.u17", 0x000000, 0x100000, CRC(21e0cfd2) SHA1(d2ff1242f1f4a206e0b2884c079ef2be5df143ac))
	ROM_LOAD("sopsnda.u21", 0x100000, 0x100000, CRC(257ab09d) SHA1(1d18e279139b1658ce02160d9a37b4bf043393f0)) // sldh
	ROM_LOAD("sopsnda.u36", 0x200000, 0x100000, CRC(db33b45c) SHA1(d3285008a3c770371389be470c1ec5ca49c1e568)) // sldh
	ROM_LOAD("sopsnda.u37", 0x300000, 0x100000, CRC(06a2a6e1) SHA1(fdbe622223724ac2b4c5183c43d3e635654864bf)) // sldh
ROM_END

ROM_START(sopranos_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sopcpua.300", 0x00000, 0x20000, CRC(cca0e551) SHA1(ef109b871605879b55abb966d6736d7deeca404f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspa.300", 0x00000, 0x80000, CRC(aa6306ac) SHA1(80737bd2b93bfc64490d07d2cd482350ed3303b3))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsnd3.u7", 0x0000,0x10000,CRC(b22ba5aa) SHA1(8f69932e3b115ae7a6bcb9a15a8b5bf6579e94e0)) // sldh
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsnda.u17", 0x000000, 0x100000, CRC(21e0cfd2) SHA1(d2ff1242f1f4a206e0b2884c079ef2be5df143ac))
	ROM_LOAD("sopsnda.u21", 0x100000, 0x100000, CRC(257ab09d) SHA1(1d18e279139b1658ce02160d9a37b4bf043393f0)) // sldh
	ROM_LOAD("sopsnda.u36", 0x200000, 0x100000, CRC(db33b45c) SHA1(d3285008a3c770371389be470c1ec5ca49c1e568)) // sldh
	ROM_LOAD("sopsnda.u37", 0x300000, 0x100000, CRC(06a2a6e1) SHA1(fdbe622223724ac2b4c5183c43d3e635654864bf)) // sldh
ROM_END

ROM_START(sopranos_204)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpua.204",   0x0000, 0x20000, CRC(95251d1e) SHA1(c22754647afd07f42bb6b2d0944f696922e68feb))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspa.200",   0x0000, 0x80000, CRC(e5de9a5d) SHA1(6e18d4bdf2d35c9c0743fa6f91f540686d0a706b))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsnd3.u7", 0x0000,0x10000,CRC(4f6748b5) SHA1(63e953a1455dee2a44484fef951fa34cb2e55d7b)) // sldh
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsnd1.u17", 0x000000, 0x100000, CRC(1ecc5ecc) SHA1(42897387b90df8da8ae556ccc46e281ca461c063))
	ROM_LOAD("sopsnd1.u21", 0x100000, 0x100000, CRC(257ab09d) SHA1(1d18e279139b1658ce02160d9a37b4bf043393f0))
	ROM_LOAD("sopsnd1.u36", 0x200000, 0x100000, CRC(db33b45c) SHA1(d3285008a3c770371389be470c1ec5ca49c1e568))
	ROM_LOAD("sopsnd1.u37", 0x300000, 0x100000, CRC(06a2a6e1) SHA1(fdbe622223724ac2b4c5183c43d3e635654864bf))
ROM_END

ROM_START(sopranog)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sopcpug.500", 0x00000, 0x20000, CRC(e6317603) SHA1(2e7f49cd77f65d0af08ab503fc82ec56c8890926))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspg.500", 0x00000, 0x80000, CRC(d8f365e9) SHA1(395209169e023913bf0bf3c3837e9a1b6b636e75))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndg.u7",0x0000,0x10000,CRC(bb615e03) SHA1(ce5ef766376c060fc071d54aa878d69b3aa30294))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndg.u17", 0x000000, 0x100000, CRC(cfa7fca1) SHA1(2efbc8c3e8ad6dc39973908e37ecdc7b02be720a))
	ROM_LOAD("sopsndg.u21", 0x100000, 0x100000, CRC(7669769b) SHA1(adf0c0dbfbaa981fa90db4e54702a4dbaf474e82))
	ROM_LOAD("sopsndg.u36", 0x200000, 0x100000, CRC(08d715b5) SHA1(ddccd311ba2b608ab0845afb3ef63b8d3425d530))
	ROM_LOAD("sopsndg.u37", 0x300000, 0x100000, CRC(2405df73) SHA1(b8074610d9d87d3f1c0244ef0f450c766aac8a20))
ROM_END

ROM_START(sopranog_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpug.400", 0x0000, 0x20000, CRC(44bd5b83) SHA1(edd11ee10a3bba9055363919f317421dee84cd85))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspg.400", 0x0000, 0x80000, CRC(2672ef2c) SHA1(8e042b6a98edd8d7b7682d01914d8d021f526b35))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndg.u7",0x0000,0x10000,CRC(bb615e03) SHA1(ce5ef766376c060fc071d54aa878d69b3aa30294))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndg.u17", 0x000000, 0x100000, CRC(cfa7fca1) SHA1(2efbc8c3e8ad6dc39973908e37ecdc7b02be720a))
	ROM_LOAD("sopsndg.u21", 0x100000, 0x100000, CRC(7669769b) SHA1(adf0c0dbfbaa981fa90db4e54702a4dbaf474e82))
	ROM_LOAD("sopsndg.u36", 0x200000, 0x100000, CRC(08d715b5) SHA1(ddccd311ba2b608ab0845afb3ef63b8d3425d530))
	ROM_LOAD("sopsndg.u37", 0x300000, 0x100000, CRC(2405df73) SHA1(b8074610d9d87d3f1c0244ef0f450c766aac8a20))
ROM_END

ROM_START(sopranog_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpug.300",   0x0000, 0x20000, CRC(acfa9c83) SHA1(8a31b1008097ff86930b2c946c2777511efc8f9a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspg.300",   0x0000, 0x80000, CRC(9fa4f9d6) SHA1(86af57435d3d33f8686a56ac59e411f2cb69f565))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndg.u7",0x0000,0x10000,CRC(bb615e03) SHA1(ce5ef766376c060fc071d54aa878d69b3aa30294))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndg.u17", 0x000000, 0x100000, CRC(cfa7fca1) SHA1(2efbc8c3e8ad6dc39973908e37ecdc7b02be720a))
	ROM_LOAD("sopsndg.u21", 0x100000, 0x100000, CRC(7669769b) SHA1(adf0c0dbfbaa981fa90db4e54702a4dbaf474e82))
	ROM_LOAD("sopsndg.u36", 0x200000, 0x100000, CRC(08d715b5) SHA1(ddccd311ba2b608ab0845afb3ef63b8d3425d530))
	ROM_LOAD("sopsndg.u37", 0x300000, 0x100000, CRC(2405df73) SHA1(b8074610d9d87d3f1c0244ef0f450c766aac8a20))
ROM_END

ROM_START(sopranog_107)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpug.107",   0x0000, 0x20000, CRC(e9c83725) SHA1(958155919cbb347b72784c7da112b188e06c908f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspg.100",   0x0000, 0x80000, CRC(38625560) SHA1(c41a6808fe05cafe44ea5026689b2ea6eb195e41))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndg.u7",0x0000,0x10000,CRC(bb615e03) SHA1(ce5ef766376c060fc071d54aa878d69b3aa30294))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndg.u17", 0x000000, 0x100000, CRC(cfa7fca1) SHA1(2efbc8c3e8ad6dc39973908e37ecdc7b02be720a))
	ROM_LOAD("sopsndg1.u21", 0x100000, 0x100000, CRC(caae114a) SHA1(84703649d7ba05d011348f84e4cac31a023146c0))
	ROM_LOAD("sopsndg.u36", 0x200000, 0x100000, CRC(08d715b5) SHA1(ddccd311ba2b608ab0845afb3ef63b8d3425d530))
	ROM_LOAD("sopsndg.u37", 0x300000, 0x100000, CRC(2405df73) SHA1(b8074610d9d87d3f1c0244ef0f450c766aac8a20))
ROM_END


ROM_START(sopranof)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sopcpuf.500", 0x00000, 0x20000, CRC(d047d4bd) SHA1(588ba8f6c7af32f6aa94f29e59ad2bcd2bc64968))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspf.500", 0x00000, 0x80000, CRC(e4252fb5) SHA1(be54181af8f3650023f20cf1bf3b8b0310adb1bb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndf.u7",0x0000,0x10000,CRC(57426738) SHA1(393e1d654ef09172580ad9a2722f696b6e44ec0f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndf.u17", 0x000000, 0x100000, CRC(0e34f843) SHA1(2a026bda4c44803239a93e6603a4dfb25e3103b5))
	ROM_LOAD("sopsndf.u21", 0x100000, 0x100000, CRC(28726d20) SHA1(63c6bea953cc34b6a3c2c9688ab86641f94cd227))
	ROM_LOAD("sopsndf.u36", 0x200000, 0x100000, CRC(99549d4a) SHA1(15e3d35b9cefbc8825a7dee5309adc2526de3dec))
	ROM_LOAD("sopsndf.u37", 0x300000, 0x100000, CRC(2b4a9130) SHA1(eed9c84c932bb86954226b0d51461c5094ebe02e))
ROM_END

ROM_START(sopranof_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpuf.400", 0x0000, 0x20000, CRC(d6f770cd) SHA1(35f35bb91c1444ba42e29542213745b7e90c9b27))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspf.400", 0x0000, 0x80000, CRC(df451810) SHA1(3c396cac89c57dbacde9b82681dd5600616d6d93))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndf.u7",0x0000,0x10000,CRC(57426738) SHA1(393e1d654ef09172580ad9a2722f696b6e44ec0f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndf.u17", 0x000000, 0x100000, CRC(0e34f843) SHA1(2a026bda4c44803239a93e6603a4dfb25e3103b5))
	ROM_LOAD("sopsndf.u21", 0x100000, 0x100000, CRC(28726d20) SHA1(63c6bea953cc34b6a3c2c9688ab86641f94cd227))
	ROM_LOAD("sopsndf.u36", 0x200000, 0x100000, CRC(99549d4a) SHA1(15e3d35b9cefbc8825a7dee5309adc2526de3dec))
	ROM_LOAD("sopsndf.u37", 0x300000, 0x100000, CRC(2b4a9130) SHA1(eed9c84c932bb86954226b0d51461c5094ebe02e))
ROM_END

ROM_START(sopranof_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpuf.300",   0x0000, 0x20000, CRC(0bd0f8c4) SHA1(df32dcf1db996203fc8b50c78e973b784ae58dbd))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspf.300",   0x0000, 0x80000, CRC(693bd940) SHA1(dd277da4e8239ae5ede3ded37efc8377ba85919a))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndf.u7",0x0000,0x10000,CRC(57426738) SHA1(393e1d654ef09172580ad9a2722f696b6e44ec0f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndf.u17", 0x000000, 0x100000, CRC(0e34f843) SHA1(2a026bda4c44803239a93e6603a4dfb25e3103b5))
	ROM_LOAD("sopsndf.u21", 0x100000, 0x100000, CRC(28726d20) SHA1(63c6bea953cc34b6a3c2c9688ab86641f94cd227))
	ROM_LOAD("sopsndf.u36", 0x200000, 0x100000, CRC(99549d4a) SHA1(15e3d35b9cefbc8825a7dee5309adc2526de3dec))
	ROM_LOAD("sopsndf.u37", 0x300000, 0x100000, CRC(2b4a9130) SHA1(eed9c84c932bb86954226b0d51461c5094ebe02e))
ROM_END

ROM_START(sopranof_107)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpuf.107",   0x0000, 0x20000, CRC(1cc86040) SHA1(0b4322eca8a5be7ea92356adf65b6c6c6f4205ca))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspf.100", 0x00000, 0x80000, CRC(18c36c19) SHA1(2b2e5cb00b92d7c8875de2d2d19b82305d9fb27f))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndf.u7",0x0000,0x10000,CRC(57426738) SHA1(393e1d654ef09172580ad9a2722f696b6e44ec0f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndf1.u17",0x000000, 0x100000, CRC(9e0dd4a8) SHA1(82b772eb7081f22f1203ed113ec7b05f2e26258c))
	ROM_LOAD("sopsndf.u21", 0x100000, 0x100000, CRC(28726d20) SHA1(63c6bea953cc34b6a3c2c9688ab86641f94cd227))
	ROM_LOAD("sopsndf.u36", 0x200000, 0x100000, CRC(99549d4a) SHA1(15e3d35b9cefbc8825a7dee5309adc2526de3dec))
	ROM_LOAD("sopsndf.u37", 0x300000, 0x100000, CRC(2b4a9130) SHA1(eed9c84c932bb86954226b0d51461c5094ebe02e))
ROM_END

ROM_START(sopranol)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sopcpul.500", 0x00000, 0x20000, CRC(ba978d00) SHA1(afe561cc439d9e51dee0697f423fce103448504c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspl.500", 0x00000, 0x80000, CRC(a4100c9e) SHA1(08ea2424ff315f6174d56301c7a8164a32629367))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndl.u7",0x0000,0x10000,CRC(137110f2) SHA1(9bd911fc74b91e811ada4c66bec214d22506a646))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndl.u17", 0x000000, 0x100000, CRC(3d5189e6) SHA1(7d846d0b18678ff7aa44029643571e237bc48d58))
	ROM_LOAD("sopsndl.u21", 0x100000, 0x100000, CRC(0ac4f407) SHA1(9473ab42c0f758901644256d7cd1cb47c8396433))
	ROM_LOAD("sopsndl.u36", 0x200000, 0x100000, CRC(147c4216) SHA1(ded2917188bea51cb03db72fe53fcd76a3e66ab9))
	ROM_LOAD("sopsndl.u37", 0x300000, 0x100000, CRC(cfe814fb) SHA1(51b6b10dda4640f8569e610b41c77e3657eabff2))
ROM_END

ROM_START(sopranol_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpul.400", 0x0000, 0x20000, CRC(7fe54359) SHA1(cb00318484ad1e30ab86c3a239fd2ea322aa945e))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspl.400", 0x0000, 0x80000, CRC(4fbef543) SHA1(3ffb48031451d3b318f88bfab4d92d2903993492))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndl.u7",0x0000,0x10000,CRC(137110f2) SHA1(9bd911fc74b91e811ada4c66bec214d22506a646))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndl.u17", 0x000000, 0x100000, CRC(3d5189e6) SHA1(7d846d0b18678ff7aa44029643571e237bc48d58))
	ROM_LOAD("sopsndl.u21", 0x100000, 0x100000, CRC(0ac4f407) SHA1(9473ab42c0f758901644256d7cd1cb47c8396433))
	ROM_LOAD("sopsndl.u36", 0x200000, 0x100000, CRC(147c4216) SHA1(ded2917188bea51cb03db72fe53fcd76a3e66ab9))
	ROM_LOAD("sopsndl.u37", 0x300000, 0x100000, CRC(cfe814fb) SHA1(51b6b10dda4640f8569e610b41c77e3657eabff2))
ROM_END

ROM_START(sopranol_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpul.300",   0x0000, 0x20000, CRC(2efd7a45) SHA1(d179605c385c3e3b269bb81295f79a52e0f3f627))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspl.300",   0x0000, 0x80000, CRC(d6f7a723) SHA1(462c8c82ffb6e386adfc411d3e70c4b25553dc7a))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndl.u7",0x0000,0x10000,CRC(137110f2) SHA1(9bd911fc74b91e811ada4c66bec214d22506a646))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndl.u17", 0x000000, 0x100000, CRC(3d5189e6) SHA1(7d846d0b18678ff7aa44029643571e237bc48d58))
	ROM_LOAD("sopsndl.u21", 0x100000, 0x100000, CRC(0ac4f407) SHA1(9473ab42c0f758901644256d7cd1cb47c8396433))
	ROM_LOAD("sopsndl.u36", 0x200000, 0x100000, CRC(147c4216) SHA1(ded2917188bea51cb03db72fe53fcd76a3e66ab9))
	ROM_LOAD("sopsndl.u37", 0x300000, 0x100000, CRC(cfe814fb) SHA1(51b6b10dda4640f8569e610b41c77e3657eabff2))
ROM_END

ROM_START(sopranol_107)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpul.107",   0x0000, 0x20000, CRC(a08311fe) SHA1(93e3ecc3e2c69f30d0fbb72c7426f3c2ba4b27b4))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspl.100",   0x0000, 0x80000, CRC(1f52723e) SHA1(c972252a139c871e4bbbf20382ceb738b84f9a18))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndl.u7",0x0000,0x10000,CRC(137110f2) SHA1(9bd911fc74b91e811ada4c66bec214d22506a646))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndl.u17", 0x000000, 0x100000, CRC(3d5189e6) SHA1(7d846d0b18678ff7aa44029643571e237bc48d58))
	ROM_LOAD("sopsndl1.u21", 0x100000, 0x100000, CRC(66cdb90d) SHA1(d96e1b92e54a94b5e0ed9d62cff9220b9e215e85))
	ROM_LOAD("sopsndl.u36", 0x200000, 0x100000, CRC(147c4216) SHA1(ded2917188bea51cb03db72fe53fcd76a3e66ab9))
	ROM_LOAD("sopsndl.u37", 0x300000, 0x100000, CRC(cfe814fb) SHA1(51b6b10dda4640f8569e610b41c77e3657eabff2))
ROM_END


ROM_START(sopranoi)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sopcpui.500", 0x00000, 0x20000, CRC(c6b29efb) SHA1(1d7045c06bd8c6fc2304fba150c201e920ae92b4))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD("sopdspi.500", 0x00000, 0x80000, CRC(5a3f479b) SHA1(43f36e27549259df172ed4340ae891eca634a594))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndi.u7",0x0000,0x10000,CRC(afb9c474) SHA1(fd184e8cd6afff61fd2874b08f0e841934916ccb))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndi.u17", 0x000000, 0x100000, CRC(ec8e4e36) SHA1(312f1d86bf6703b8ff6b807a3a2abea9fe0c20b8))
	ROM_LOAD("sopsndi.u21", 0x100000, 0x100000, CRC(37727b76) SHA1(8801091870a30222d5a99535bbe15ac97334e368))
	ROM_LOAD("sopsndi.u36", 0x200000, 0x100000, CRC(71568348) SHA1(516d5ea35f8323e247c25000cb223f3539796ea1))
	ROM_LOAD("sopsndi.u37", 0x300000, 0x100000, CRC(b34c0a5f) SHA1(b84979d6eef7d23e6dd5410993d83fba2121bc6a))
ROM_END

ROM_START(sopranoi_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpui.400", 0x0000, 0x20000, CRC(9bd48a86) SHA1(16aa55892a295a1486ede60df104520362005155))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspi.400", 0x0000, 0x80000, CRC(7e58e364) SHA1(1fcf282ae68e3e725e16e43b85f57d1a18b43508))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndi.u7",0x0000,0x10000,CRC(afb9c474) SHA1(fd184e8cd6afff61fd2874b08f0e841934916ccb))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndi.u17", 0x000000, 0x100000, CRC(ec8e4e36) SHA1(312f1d86bf6703b8ff6b807a3a2abea9fe0c20b8))
	ROM_LOAD("sopsndi.u21", 0x100000, 0x100000, CRC(37727b76) SHA1(8801091870a30222d5a99535bbe15ac97334e368))
	ROM_LOAD("sopsndi.u36", 0x200000, 0x100000, CRC(71568348) SHA1(516d5ea35f8323e247c25000cb223f3539796ea1))
	ROM_LOAD("sopsndi.u37", 0x300000, 0x100000, CRC(b34c0a5f) SHA1(b84979d6eef7d23e6dd5410993d83fba2121bc6a))
ROM_END

ROM_START(sopranoi_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpui.300",   0x0000, 0x20000, CRC(1a2846e6) SHA1(10dd57d5f65f397d67105f7e1d0e8d920753893c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspi.300",   0x0000, 0x80000, CRC(d7903ed2) SHA1(ae54952cd3e6f7fb0075e71d484701def764f0d6))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndi.u7",0x0000,0x10000,CRC(afb9c474) SHA1(fd184e8cd6afff61fd2874b08f0e841934916ccb))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndi.u17", 0x000000, 0x100000, CRC(ec8e4e36) SHA1(312f1d86bf6703b8ff6b807a3a2abea9fe0c20b8))
	ROM_LOAD("sopsndi.u21", 0x100000, 0x100000, CRC(37727b76) SHA1(8801091870a30222d5a99535bbe15ac97334e368))
	ROM_LOAD("sopsndi.u36", 0x200000, 0x100000, CRC(71568348) SHA1(516d5ea35f8323e247c25000cb223f3539796ea1))
	ROM_LOAD("sopsndi.u37", 0x300000, 0x100000, CRC(b34c0a5f) SHA1(b84979d6eef7d23e6dd5410993d83fba2121bc6a))
ROM_END

ROM_START(sopranoi_107)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "sopcpui.107",   0x0000, 0x20000, CRC(d5cd6b07) SHA1(830de4af7f54c85feeae6fb7f630f84e48fdb98b))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x10000, "maincpu", 0)
	ROM_COPY( "user1", 0x18000, 0x8000, 0x8000)
	ROM_REGION(0x10000, "cpu3", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "gfx3", 0)
	ROM_LOAD( "sopdspi.100",   0x0000, 0x80000, CRC(2a6320c1) SHA1(8cd25c53abb353cbbb88af3e7384c7275d836dbb))
	ROM_REGION32_LE(0x600000, "cpu2", 0)
	ROM_LOAD("biosv8.u8", 0x400000, 0x20000, CRC(c81b5532) SHA1(7bd630179910423a01394f82ad7ff2008c02f7ff))
	ROM_RELOAD(0x0,0x20000)
	ROM_REGION(0x10000, "sound1", 0)
	ROM_LOAD("sopsndi.u7",0x0000,0x10000,CRC(afb9c474) SHA1(fd184e8cd6afff61fd2874b08f0e841934916ccb))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sopsndi1.u17", 0x000000, 0x100000, CRC(7cb762dd) SHA1(84ec54d6495ccb02052c8d5b6b66c018a702bb4e))
	ROM_LOAD("sopsndi.u21", 0x100000, 0x100000, CRC(37727b76) SHA1(8801091870a30222d5a99535bbe15ac97334e368))
	ROM_LOAD("sopsndi.u36", 0x200000, 0x100000, CRC(71568348) SHA1(516d5ea35f8323e247c25000cb223f3539796ea1))
	ROM_LOAD("sopsndi.u37", 0x300000, 0x100000, CRC(b34c0a5f) SHA1(b84979d6eef7d23e6dd5410993d83fba2121bc6a))
ROM_END

GAME(2004,  elvisp,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (5.00)",                                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisp4,      elvisp,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (4.00)",                                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisp303,    elvisp,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.03)",                                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisp302,    elvisp,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.02)",                                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisl,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (5.00 Spain)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisl4,      elvisl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (4.00 Spain)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisl303,    elvisl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.03 Spain)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisl302,    elvisl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.02 Spain)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisg,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (5.00 Germany)",                          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisg4,      elvisg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (4.00 Germany)",                          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisg303,    elvisg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.03 Germany)",                          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisg302,    elvisg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.02 Germany)",                          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisf,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (5.00 France)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisf4,      elvisf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (4.00 France)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisf303,    elvisf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.03 France)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisf302,    elvisf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.02 France)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisi,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (5.00 Italy)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisi4,      elvisi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (4.00 Italy)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisi303,    elvisi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.03 Italy)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  elvisi302,    elvisi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Elvis (3.02 Italy)",                            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprix,        0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.50)",                             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprix_400,    gprix,     whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.00)",                             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprix_352,    gprix,     whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.52)",                             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprix_350,    gprix,     whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.50)",                             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprix_340,    gprix,     whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.40)",                             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprix_301,    gprix,     whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.01)",                             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixg,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.50 Germany)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixg_400,   gprixg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.00 Germany)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixg_352,   gprixg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.52 Germany)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixg_350,   gprixg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.50 Germany)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixg_340,   gprixg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.40 Germany)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixg_301,   gprixg,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.01 Germany)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixl,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.50 Spain)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixl_400,   gprixl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.00 Spain)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixl_352,   gprixl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.52 Spain)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixl_350,   gprixl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.50 Spain)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixl_340,   gprixl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.40 Spain)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixl_301,   gprixl,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.01 Spain)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixf,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.50 France)",                      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixf_400,   gprixf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.00 France)",                      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixf_352,   gprixf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.52 France)",                      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixf_350,   gprixf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.50 France)",                      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixf_340,   gprixf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.40 France)",                      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixf_301,   gprixf,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.01 France)",                      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixi,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.50 Italy)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixi_400,   gprixi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (4.00 Italy)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixi_352,   gprixi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.52 Italy)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixi_350,   gprixi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.50 Italy)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixi_340,   gprixi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.40 Italy)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  gprixi_301,   gprixi,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Grand Prix (3.01 Italy)",                       MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascar,       0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (4.50)",                                 MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascar_400,   nascar,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (4.00)",                                 MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascar_352,   nascar,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.52)",                                 MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascar_350,   nascar,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.50)",                                 MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascar_340,   nascar,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.40)",                                 MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascar_301,   nascar,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.01)",                                 MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  dalejr,       nascar,    whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Dale Jr. (5.00)",                               MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascarl,      0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (4.50 Spain)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascarl_400,  nascarl,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (4.00 Spain)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascarl_352,  nascarl,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.52 Spain)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascarl_350,  nascarl,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.50 Spain)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascarl_340,  nascarl,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.40 Spain)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  nascarl_301,  nascarl,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Nascar (3.01 Spain)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripleys,      0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.20)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  rip310,       ripleys,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.10)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  rip302,       ripleys,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.02)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  rip301,       ripleys,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.01)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  rip300,       ripleys,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.00)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripleysf,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.20 France)",     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripf310,      ripleysf,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.10 France)",     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripf302,      ripleysf,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.02 France)",     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripf301,      ripleysf,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.01 France)",     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripf300,      ripleysf,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.00 France)",     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripleysg,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.20 Germany)",    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripg310,      ripleysg,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.10 Germany)",    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripg302,      ripleysg,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.02 Germany)",    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripg301,      ripleysg,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.01 Germany)",    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripg300,      ripleysg,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.00 Germany)",    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripleysi,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.20 Italy)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripi310,      ripleysi,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.10 Italy)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripi302,      ripleysi,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.02 Italy)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripi301,      ripleysi,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.01 Italy)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripi300,      ripleysi,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.00 Italy)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripleysl,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.20 Spain)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripl310,      ripleysl,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.10 Spain)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripl302,      ripleysl,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.02 Spain)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripl301,      ripleysl,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.01 Spain)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2004,  ripl300,      ripleysl,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "Ripley's Believe It or Not! (3.00 Spain)",      MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr,         0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (10.00)",                 MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_le,      lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (10.02 Limited Edition)", MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr9,        lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (9.00)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr8,        lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (8.00)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr7,        lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (7.00)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr6,        lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (6.00)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr501,      lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.01)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr5,        lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.00)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr410,      lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.10)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr401,      lotr,      whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.01)",                  MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp,      0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (10.00 Spain)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp9,     lotr_sp,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (9.0 Spain)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp8,     lotr_sp,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (8.0 Spain)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp7,     lotr_sp,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (7.0 Spain)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp6,     lotr_sp,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (6.0 Spain)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp501,   lotr_sp,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.01 Spain)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp5,     lotr_sp,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.0 Spain)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_sp401,   lotr_sp,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.01 Spain)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr,      0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (10.00 Germany)",         MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr9,     lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (9.0 Germany)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr8,     lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (8.0 Germany)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr7,     lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (7.0 Germany)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr6,     lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (6.0 Germany)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr501,   lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.01 Germany)",          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr5,     lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.0 Germany)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr410,   lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.10 Germany)",          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_gr401,   lotr_gr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.01 Germany)",          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr,      0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (10.00 France)",          MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr9,     lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (9.0 France)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr8,     lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (8.0 France)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr7,     lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (7.0 France)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr6,     lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (6.0 France)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr501,   lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.01 France)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr5,     lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.0 France)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr410,   lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.10 France)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_fr401,   lotr_fr,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.01 France)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it,      0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (10.00 Italy)",           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it9,     lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (9.0 Italy)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it8,     lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (8.0 Italy)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it7,     lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (7.0 Italy)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it6,     lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (6.0 Italy)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it501,   lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.01 Italy)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it5,     lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (5.0 Italy)",             MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it410,   lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.10 Italy)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2003,  lotr_it401,   lotr_it,   whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Lord Of The Rings (4.01 Italy)",            MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranos,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (5.00)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranos_400, sopranos,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (4.00)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranos_300, sopranos,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (3.00)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranos_204, sopranos,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (2.04)",                           MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranog,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (5.00 Germany)",                   MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranog_400, sopranog,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (4.00 Germany)",                   MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranog_300, sopranog,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (3.00 Germany)",                   MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranog_107, sopranog,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (1.07 Germany)",                   MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranof,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (5.00 France)",                    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranof_400, sopranof,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (4.00 France)",                    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranof_300, sopranof,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (3.00 France)",                    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranof_107, sopranof,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (1.07 France)",                    MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranol,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (5.00 Spain)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranol_400, sopranol,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (4.00 Spain)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranol_300, sopranol,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (3.00 Spain)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranol_107, sopranol,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (1.07 Spain)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranoi,     0,         whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (5.00 Italy)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranoi_400, sopranoi,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (4.00 Italy)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranoi_300, sopranoi,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (3.00 Italy)",                     MACHINE_IS_SKELETON_MECHANICAL)
GAME(2005,  sopranoi_107, sopranoi,  whitestar_mod,  whitestar_mod, whitestar_mod_state, init_whitestar_mod,  ROT0,   "Stern",    "The Sopranos (1.07 Italy)",                     MACHINE_IS_SKELETON_MECHANICAL)
