# include "fbcunit.bi"

'' commonly used in C-headers
#define PP_FALSE   0
#define PP_TRUE    1

'' used by FBC sources
#define FBC_FALSE 0
#define FBC_TRUE (-1)

'' used by boolean type
#define CBOOL_FALSE  cbool(0)
#define CBOOL_TRUE   cbool(-1)

'' common basic definition
const CONST_FALSE = 0
const CONST_TRUE = not CONST_FALSE

'' common basic definition
const INT_FALSE as integer = 0
const INT_TRUE as integer = not INT_FALSE

'' the fbc definition of false and true intrinsic symbols
const BOOLEAN_FALSE as boolean = 0
const BOOLEAN_TRUE as boolean = not BOOLEAN_FALSE

'' common definition
enum ENUM_BOOLEAN
	ENUM_FALSE
	ENUM_TRUE
end enum

SUITE( fbc_tests.boolean_.boolean_false_true )

	''
	TEST( intrinsic )
	
		CU_ASSERT( false = cbool(0) )
		CU_ASSERT( cint(false) = cint(0) )
		CU_ASSERT( true = cbool(-1) )
		CU_ASSERT( cint(true) = -1 )
		
		CU_ASSERT( len( boolean ) = 1 )
		CU_ASSERT( len( false ) = 1 )
		CU_ASSERT( len( true ) = 1 )

		CU_ASSERT( sizeof( boolean ) = 1 )
		CU_ASSERT( sizeof( false ) = 1 )
		CU_ASSERT( sizeof( true ) = 1 )

	END_TEST

	TEST( definitions )

		'' some of these tests are slightly cooked:
		'' obviously assert( -1 = 1 ) will *never* succeed.  
		'' But to test some combos, we will do (-1?=(1<>0)) 
		'' instead, and leave all the combos here.

		CU_ASSERT_NOT_EQUAL( FALSE, TRUE )
		CU_ASSERT_NOT_EQUAL( PP_FALSE, PP_TRUE )
		CU_ASSERT_NOT_EQUAL( FBC_FALSE, FBC_TRUE )
		CU_ASSERT_NOT_EQUAL( CBOOL_FALSE, CBOOL_TRUE )
		CU_ASSERT_NOT_EQUAL( CONST_FALSE, CONST_TRUE )
		CU_ASSERT_NOT_EQUAL( INT_FALSE, INT_TRUE )
		CU_ASSERT_NOT_EQUAL( BOOLEAN_FALSE, BOOLEAN_TRUE )
		CU_ASSERT_NOT_EQUAL( ENUM_FALSE, ENUM_TRUE )

		CU_ASSERT_NOT_EQUAL( PP_FALSE, PP_TRUE )
		CU_ASSERT_NOT_EQUAL( PP_TRUE, PP_FALSE )
		CU_ASSERT_NOT_EQUAL( FBC_TRUE, FBC_FALSE )
		CU_ASSERT_NOT_EQUAL( CBOOL_TRUE, CBOOL_FALSE )
		CU_ASSERT_NOT_EQUAL( CONST_TRUE, CONST_FALSE )
		CU_ASSERT_NOT_EQUAL( INT_TRUE, INT_FALSE )
		CU_ASSERT_NOT_EQUAL( BOOLEAN_TRUE, BOOLEAN_FALSE )
		CU_ASSERT_NOT_EQUAL( ENUM_TRUE, ENUM_FALSE )

		CU_ASSERT_EQUAL( FALSE, FALSE )
		CU_ASSERT_EQUAL( FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( PP_FALSE, FALSE )
		CU_ASSERT_EQUAL( PP_FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( PP_FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( PP_FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( PP_FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( PP_FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( PP_FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( PP_FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( FBC_FALSE, FALSE )
		CU_ASSERT_EQUAL( FBC_FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( FBC_FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( FBC_FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( FBC_FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( FBC_FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( FBC_FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( FBC_FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( CBOOL_FALSE, FALSE )
		CU_ASSERT_EQUAL( CBOOL_FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( CBOOL_FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( CBOOL_FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( CBOOL_FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( CBOOL_FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( CBOOL_FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( CBOOL_FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( CONST_FALSE, FALSE )
		CU_ASSERT_EQUAL( CONST_FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( CONST_FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( CONST_FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( CONST_FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( CONST_FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( CONST_FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( CONST_FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( INT_FALSE, FALSE )
		CU_ASSERT_EQUAL( INT_FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( INT_FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( INT_FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( INT_FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( INT_FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( INT_FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( INT_FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( BOOLEAN_FALSE, FALSE )
		CU_ASSERT_EQUAL( BOOLEAN_FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( BOOLEAN_FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( BOOLEAN_FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( BOOLEAN_FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( BOOLEAN_FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( BOOLEAN_FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( BOOLEAN_FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( ENUM_FALSE, FALSE )
		CU_ASSERT_EQUAL( ENUM_FALSE, PP_FALSE )
		CU_ASSERT_EQUAL( ENUM_FALSE, FBC_FALSE )
		CU_ASSERT_EQUAL( ENUM_FALSE, CBOOL_FALSE )
		CU_ASSERT_EQUAL( ENUM_FALSE, CONST_FALSE )
		CU_ASSERT_EQUAL( ENUM_FALSE, INT_FALSE )
		CU_ASSERT_EQUAL( ENUM_FALSE, BOOLEAN_FALSE )
		CU_ASSERT_EQUAL( ENUM_FALSE, ENUM_FALSE )

		CU_ASSERT_EQUAL( TRUE, TRUE )
		CU_ASSERT_EQUAL( TRUE, PP_TRUE<>0 )
		CU_ASSERT_EQUAL( TRUE, FBC_TRUE )
		CU_ASSERT_EQUAL( TRUE, CBOOL_TRUE )
		CU_ASSERT_EQUAL( TRUE, CONST_TRUE )
		CU_ASSERT_EQUAL( TRUE, INT_TRUE )
		CU_ASSERT_EQUAL( TRUE, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( TRUE, ENUM_TRUE<>0 )

		CU_ASSERT_EQUAL( PP_TRUE<>0, TRUE )
		CU_ASSERT_EQUAL( PP_TRUE, PP_TRUE )
		CU_ASSERT_EQUAL( PP_TRUE<>0, FBC_TRUE )
		CU_ASSERT_EQUAL( PP_TRUE<>0, CBOOL_TRUE )
		CU_ASSERT_EQUAL( PP_TRUE<>0, CONST_TRUE )
		CU_ASSERT_EQUAL( PP_TRUE<>0, INT_TRUE )
		CU_ASSERT_EQUAL( PP_TRUE<>0, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( PP_TRUE, ENUM_TRUE )

		CU_ASSERT_EQUAL( FBC_TRUE, TRUE )
		CU_ASSERT_EQUAL( FBC_TRUE, PP_TRUE<>0 )
		CU_ASSERT_EQUAL( FBC_TRUE, FBC_TRUE )
		CU_ASSERT_EQUAL( FBC_TRUE, CBOOL_TRUE )
		CU_ASSERT_EQUAL( FBC_TRUE, CONST_TRUE )
		CU_ASSERT_EQUAL( FBC_TRUE, INT_TRUE )
		CU_ASSERT_EQUAL( FBC_TRUE, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( FBC_TRUE, ENUM_TRUE<>0 )

		CU_ASSERT_EQUAL( CBOOL_TRUE, TRUE )
		CU_ASSERT_EQUAL( CBOOL_TRUE, PP_TRUE<>0 )
		CU_ASSERT_EQUAL( CBOOL_TRUE, FBC_TRUE )
		CU_ASSERT_EQUAL( CBOOL_TRUE, CBOOL_TRUE )
		CU_ASSERT_EQUAL( CBOOL_TRUE, CONST_TRUE )
		CU_ASSERT_EQUAL( CBOOL_TRUE, INT_TRUE )
		CU_ASSERT_EQUAL( CBOOL_TRUE, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( CBOOL_TRUE, ENUM_TRUE<>0 )

		CU_ASSERT_EQUAL( CONST_TRUE, TRUE )
		CU_ASSERT_EQUAL( CONST_TRUE, PP_TRUE<>0 )
		CU_ASSERT_EQUAL( CONST_TRUE, FBC_TRUE )
		CU_ASSERT_EQUAL( CONST_TRUE, CBOOL_TRUE )
		CU_ASSERT_EQUAL( CONST_TRUE, CONST_TRUE )
		CU_ASSERT_EQUAL( CONST_TRUE, INT_TRUE )
		CU_ASSERT_EQUAL( CONST_TRUE, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( CONST_TRUE, ENUM_TRUE<>0 )

		CU_ASSERT_EQUAL( INT_TRUE, TRUE )
		CU_ASSERT_EQUAL( INT_TRUE, PP_TRUE<>0 )
		CU_ASSERT_EQUAL( INT_TRUE, FBC_TRUE )
		CU_ASSERT_EQUAL( INT_TRUE, CBOOL_TRUE )
		CU_ASSERT_EQUAL( INT_TRUE, CONST_TRUE )
		CU_ASSERT_EQUAL( INT_TRUE, INT_TRUE )
		CU_ASSERT_EQUAL( INT_TRUE, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( INT_TRUE, ENUM_TRUE<>0 )

		CU_ASSERT_EQUAL( BOOLEAN_TRUE, TRUE )
		CU_ASSERT_EQUAL( BOOLEAN_TRUE, PP_TRUE<>0 )
		CU_ASSERT_EQUAL( BOOLEAN_TRUE, FBC_TRUE )
		CU_ASSERT_EQUAL( BOOLEAN_TRUE, CBOOL_TRUE )
		CU_ASSERT_EQUAL( BOOLEAN_TRUE, CONST_TRUE )
		CU_ASSERT_EQUAL( BOOLEAN_TRUE, INT_TRUE )
		CU_ASSERT_EQUAL( BOOLEAN_TRUE, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( BOOLEAN_TRUE, ENUM_TRUE<>0 )

		CU_ASSERT_EQUAL( ENUM_TRUE<>0, TRUE )
		CU_ASSERT_EQUAL( ENUM_TRUE, PP_TRUE )
		CU_ASSERT_EQUAL( ENUM_TRUE<>0, FBC_TRUE )
		CU_ASSERT_EQUAL( ENUM_TRUE<>0, CBOOL_TRUE )
		CU_ASSERT_EQUAL( ENUM_TRUE<>0, CONST_TRUE )
		CU_ASSERT_EQUAL( ENUM_TRUE<>0, INT_TRUE )
		CU_ASSERT_EQUAL( ENUM_TRUE<>0, BOOLEAN_TRUE )
		CU_ASSERT_EQUAL( ENUM_TRUE, ENUM_TRUE )

	END_TEST

END_SUITE
