#!/bin/sh
# This script scans the /usr/local/lib/imlib2/loaders
# directory. It prints which loaders are available and
# whether they can load or save their respective formats.

# Passing an argument results in a help message.
if [ $1 ]
then
	echo
	head -n4 $0 | grep -v "bin/sh" | cut -c 2-
	echo -e "\nUsage\n\t$0\n"
	exit 1
fi

# Search for an elf reader.
RdElf="`which readelf`"
[ -z "$RdElf" ] && RdElf="`which eu-readelf`"

# Exit if no elf readers are found.
if [ -z "$RdElf" ]
then
	echo -e "\nThis script requires either binutils.tcz"
	echo -e "or elfutils.tcz to run.\n"
	exit 1
fi

Loaders="/usr/local/lib/imlib2/loaders"
# Older versions of Tinycore included imlib2 as part of the base under /usr/lib/.
[ ! -d "$Loaders" ] && Loaders="/usr/lib/imlib2/loaders"
if [ ! -d "$Loaders" ]
then
	echo -ne "\nDirectory  lib/imlib2/loaders  not found.\n"
	echo -ne "Imlib2 may not be installed.\n\n"
	exit 1
fi

# Find all the .so files.
for F in `ls "$Loaders"/*.so`
do
	#Echo filename.so minus path or newline but add a tab character.
	echo -ne "`basename $F`\t"
	# List symbols; Print load and/or save if found; Sort load/save; Replace newlines with tabs.
	"$RdElf" -s $F | busybox grep -oE "load|save" | sort | tr '\n' '\t'
	# Add a newline.
	echo
done
