/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.AbstractInput;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.RefreshException;
import com.sleepycat.client.persist.impl.SimpleCatalog;
import com.sleepycat.client.persist.raw.RawObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;

abstract class RawAbstractInput
extends AbstractInput {
    private IdentityHashMap converted;

    RawAbstractInput(Catalog catalog, boolean bl, IdentityHashMap identityHashMap) {
        super(catalog, bl);
        this.converted = identityHashMap;
    }

    @Override
    public Object readObject() throws RefreshException {
        return this.readNext();
    }

    @Override
    public Object readKeyObject(Format format) throws RefreshException {
        return this.readNext();
    }

    @Override
    public Object readStringObject() throws RefreshException {
        return this.readNext();
    }

    @Override
    public void registerPriKeyObject(Object object) {
    }

    @Override
    public void registerPriStringKeyObject(Object object) {
    }

    @Override
    public int readArrayLength() {
        throw DbCompat.unexpectedState();
    }

    @Override
    public int readEnumConstant(String[] stringArray) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public void skipField(Format format) {
    }

    abstract Object readNext() throws RefreshException;

    Object checkAndConvert(Object object, Format format) throws RefreshException {
        if (object == null) {
            if (format.isPrimitive()) {
                throw new IllegalArgumentException("A primitive type may not be null or missing: " + format.getClassName());
            }
        } else if (format.isSimple()) {
            if (format.isPrimitive()) {
                if (object.getClass() != format.getWrapperFormat().getType()) {
                    throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " must be the wrapper class for a primitive type: " + format.getClassName());
                }
            } else if (object.getClass() != format.getType()) {
                throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " must be the declared class for a simple type: " + format.getClassName());
            }
        } else {
            if (object instanceof RawObject) {
                Object var3_3 = null;
                if (!this.rawAccess) {
                    if (this.converted != null) {
                        var3_3 = this.converted.get(object);
                    } else {
                        this.converted = new IdentityHashMap();
                    }
                }
                if (var3_3 != null) {
                    object = var3_3;
                } else if (!this.rawAccess) {
                    object = this.catalog.convertRawObject((RawObject)object, this.converted);
                }
            } else if (!SimpleCatalog.isSimpleType(object.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " must be RawObject a simple type");
            }
            if (this.rawAccess) {
                RawAbstractInput.checkRawType(this.catalog, object, format);
            } else if (!format.getType().isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " is not assignable to type: " + format.getClassName());
            }
        }
        return object;
    }

    static Format checkRawType(Catalog catalog, Object object, Format format) throws RefreshException {
        Format format2;
        assert (format != null);
        if (object instanceof RawObject) {
            format2 = (Format)((RawObject)object).getType();
            format2 = catalog.getFormat(format2.getId(), false);
        } else {
            format2 = catalog.getFormat(object.getClass(), false);
            if (!format2.isSimple() || format2.isEnum()) {
                throw new IllegalArgumentException("Not a RawObject or a non-enum simple type: " + format2.getClassName());
            }
        }
        if (!format2.isAssignableTo(format)) {
            throw new IllegalArgumentException("Not a subtype of the field's declared class " + format.getClassName() + ": " + format2.getClassName());
        }
        if (!format2.isCurrentVersion()) {
            throw new IllegalArgumentException("Raw type version is not current.  Class: " + format2.getClassName() + " Version: " + format2.getVersion());
        }
        Format format3 = format2.getProxiedFormat();
        if (format3 != null) {
            format2 = format3;
        }
        return format2;
    }

    @Override
    public String readString() throws RefreshException {
        return (String)this.readNext();
    }

    @Override
    public char readChar() throws RefreshException {
        return ((Character)this.readNext()).charValue();
    }

    @Override
    public boolean readBoolean() throws RefreshException {
        return (Boolean)this.readNext();
    }

    @Override
    public byte readByte() throws RefreshException {
        return (Byte)this.readNext();
    }

    @Override
    public short readShort() throws RefreshException {
        return (Short)this.readNext();
    }

    @Override
    public int readInt() throws RefreshException {
        return (Integer)this.readNext();
    }

    @Override
    public long readLong() throws RefreshException {
        return (Long)this.readNext();
    }

    @Override
    public float readSortedFloat() throws RefreshException {
        return ((Float)this.readNext()).floatValue();
    }

    @Override
    public double readSortedDouble() throws RefreshException {
        return (Double)this.readNext();
    }

    @Override
    public BigDecimal readSortedBigDecimal() throws RefreshException {
        return (BigDecimal)this.readNext();
    }

    @Override
    public BigInteger readBigInteger() throws RefreshException {
        return (BigInteger)this.readNext();
    }
}

