/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.bind.RecordNumberBinding;
import com.sleepycat.client.collections.BaseIterator;
import com.sleepycat.client.collections.BlockIterator;
import com.sleepycat.client.collections.DataCursor;
import com.sleepycat.client.collections.DataView;
import com.sleepycat.client.collections.PrimaryKeyAssigner;
import com.sleepycat.client.collections.StoredCollection;
import com.sleepycat.client.collections.StoredContainer;
import com.sleepycat.client.collections.StoredIterator;
import com.sleepycat.client.util.keyrange.KeyRangeException;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StoredList<E>
extends StoredCollection<E>
implements List<E> {
    private int baseIndex = 1;
    private boolean isSubList;

    private static EntryBinding defaultKeyBinding(SDatabase sDatabase) {
        return new IndexKeyBinding(1, sDatabase.getServerByteOrder());
    }

    public StoredList(SDatabase sDatabase, EntryBinding<E> entryBinding, boolean bl) {
        super(new DataView(sDatabase, StoredList.defaultKeyBinding(sDatabase), entryBinding, null, bl, null));
    }

    public StoredList(SDatabase sDatabase, EntityBinding<E> entityBinding, boolean bl) {
        super(new DataView(sDatabase, StoredList.defaultKeyBinding(sDatabase), null, entityBinding, bl, null));
    }

    public StoredList(SDatabase sDatabase, EntryBinding<E> entryBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(sDatabase, StoredList.defaultKeyBinding(sDatabase), entryBinding, null, true, primaryKeyAssigner));
    }

    public StoredList(SDatabase sDatabase, EntityBinding<E> entityBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(sDatabase, StoredList.defaultKeyBinding(sDatabase), null, entityBinding, true, primaryKeyAssigner));
    }

    private StoredList(DataView dataView, int n) {
        super(dataView);
        this.baseIndex = n;
        this.isSubList = true;
    }

    @Override
    public void add(int n, E e) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            SOperationStatus sOperationStatus = dataCursor.getSearchKey(n, null, false);
            if (sOperationStatus == SOperationStatus.SUCCESS) {
                dataCursor.putBefore(e);
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                this.view.append(e, null, null);
            }
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean add(E e) {
        this.checkIterAddAllowed();
        boolean bl = this.beginAutoCommit();
        try {
            this.view.append(e, null, null);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public int append(E e) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(e, objectArray, null);
            this.commitAutoCommit(bl);
            return ((Number)objectArray[0]).intValue();
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    @Override
    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("Cannot add to subList");
        }
        if (!this.view.keysRenumbered) {
            throw new UnsupportedOperationException("Requires renumbered keys");
        }
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = this.storedOrExternalIterator(collection);
            if (!iterator.hasNext()) {
                return false;
            }
            dataCursor = new DataCursor(this.view, true);
            SOperationStatus sOperationStatus = dataCursor.getSearchKey(n, null, false);
            if (sOperationStatus == SOperationStatus.SUCCESS) {
                while (iterator.hasNext()) {
                    dataCursor.putBefore(iterator.next());
                }
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                while (iterator.hasNext()) {
                    this.view.append(iterator.next(), null, null);
                }
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public E get(int n) {
        return (E)this.getValue(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, true);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object, false);
    }

    private int indexOf(Object object, boolean bl) {
        int n;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            SOperationStatus sOperationStatus = dataCursor.findValue(object, bl);
            n = sOperationStatus == SOperationStatus.SUCCESS ? dataCursor.getCurrentRecordNumber() - this.baseIndex : -1;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return n;
    }

    @Override
    int getIndexOffset() {
        return this.baseIndex;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.blockIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        BlockIterator blockIterator = this.blockIterator();
        if (blockIterator.moveToIndex(n)) {
            return blockIterator;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public E remove(int n) {
        try {
            Object[] objectArray = new Object[1];
            this.removeKey(n, objectArray);
            return (E)objectArray[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    @Override
    public E set(int n, E e) {
        try {
            return (E)this.putKeyValue(n, e);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        try {
            int n3 = this.baseIndex + n;
            return new StoredList<E>(this.view.subView(n, true, n2, false, new IndexKeyBinding(n3, this.view.getServerByteOrder())), n3);
        }
        catch (KeyRangeException keyRangeException) {
            throw new IndexOutOfBoundsException(keyRangeException.getMessage());
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        StoredIterator storedIterator = null;
        ListIterator listIterator = null;
        try {
            storedIterator = this.storedIterator();
            listIterator = this.storedOrExternalListIterator(list);
            while (storedIterator.hasNext()) {
                if (!listIterator.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                if (storedIterator.nextIndex() != listIterator.nextIndex()) {
                    boolean bl = false;
                    return bl;
                }
                Object e = storedIterator.next();
                Object e2 = listIterator.next();
                if (e == null) {
                    if (e2 == null) continue;
                    boolean bl = false;
                    return bl;
                }
                if (e.equals(e2)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !listIterator.hasNext();
            return bl;
        }
        finally {
            StoredIterator.close(storedIterator);
            StoredIterator.close(listIterator);
        }
    }

    final ListIterator storedOrExternalListIterator(List list) {
        if (list instanceof StoredCollection) {
            return ((StoredCollection)((Object)list)).storedIterator();
        }
        return list.listIterator();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    E makeIteratorData(BaseIterator baseIterator, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        return (E)this.view.makeValue(sDatabaseEntry2, sDatabaseEntry3);
    }

    @Override
    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    extends RecordNumberBinding {
        private int baseIndex;

        private IndexKeyBinding(int n, ByteOrder byteOrder) {
            super(byteOrder);
            this.baseIndex = n;
        }

        @Override
        public Long entryToObject(SDatabaseEntry sDatabaseEntry) {
            return super.entryToObject(sDatabaseEntry) - (long)this.baseIndex;
        }

        @Override
        public void objectToEntry(Object object, SDatabaseEntry sDatabaseEntry) {
            super.objectToEntry((Object)(((Number)object).intValue() + this.baseIndex), sDatabaseEntry);
        }
    }
}

