/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.collections.BaseIterator;
import com.sleepycat.client.collections.DataCursor;
import com.sleepycat.client.collections.StoredCollection;
import com.sleepycat.client.collections.StoredContainer;
import com.sleepycat.client.compat.DbCompat;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class StoredIterator<E>
extends BaseIterator<E>
implements ListIterator<E>,
Cloneable {
    private static final int MOVE_NEXT = 1;
    private static final int MOVE_PREV = 2;
    private static final int MOVE_FIRST = 3;
    private boolean lockForWrite;
    private StoredCollection<E> coll;
    private DataCursor cursor;
    private int toNext;
    private int toPrevious;
    private int toCurrent;
    private boolean writeAllowed;
    private boolean setAndRemoveAllowed;
    private E currentData;

    public static void close(Iterator<?> iterator) {
        if (iterator instanceof StoredIterator) {
            ((StoredIterator)iterator).close();
        }
    }

    StoredIterator(StoredCollection<E> storedCollection, boolean bl, DataCursor dataCursor) {
        try {
            this.coll = storedCollection;
            this.writeAllowed = bl;
            this.cursor = dataCursor == null ? new DataCursor(storedCollection.view, bl) : dataCursor;
            this.reset();
        }
        catch (Exception exception) {
            try {
                this.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw StoredContainer.convertException(exception);
        }
    }

    public final boolean isReadModifyWrite() {
        return this.lockForWrite;
    }

    public void setReadModifyWrite(boolean bl) {
        this.lockForWrite = bl;
    }

    @Override
    public boolean hasNext() {
        if (this.cursor == null) {
            return false;
        }
        try {
            SOperationStatus sOperationStatus;
            if (this.toNext != 0 && (sOperationStatus = this.move(this.toNext)) == SOperationStatus.SUCCESS) {
                this.toNext = 0;
                this.toPrevious = 2;
                this.toCurrent = 2;
            }
            return this.toNext == 0;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    @Override
    public boolean hasPrevious() {
        if (this.cursor == null) {
            return false;
        }
        try {
            SOperationStatus sOperationStatus;
            if (this.toPrevious != 0 && (sOperationStatus = this.move(this.toPrevious)) == SOperationStatus.SUCCESS) {
                this.toPrevious = 0;
                this.toNext = 1;
                this.toCurrent = 1;
            }
            return this.toPrevious == 0;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    @Override
    public E next() {
        try {
            SOperationStatus sOperationStatus;
            if (this.toNext != 0 && (sOperationStatus = this.move(this.toNext)) == SOperationStatus.SUCCESS) {
                this.toNext = 0;
            }
            if (this.toNext == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toNext = 1;
                this.toPrevious = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        throw new NoSuchElementException();
    }

    @Override
    public E previous() {
        try {
            SOperationStatus sOperationStatus;
            if (this.toPrevious != 0 && (sOperationStatus = this.move(this.toPrevious)) == SOperationStatus.SUCCESS) {
                this.toPrevious = 0;
            }
            if (this.toPrevious == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toPrevious = 2;
                this.toNext = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasNext() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : Integer.MAX_VALUE;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    @Override
    public int previousIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasPrevious() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : -1;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    @Override
    public void set(E e) {
        if (!this.coll.hasValues()) {
            throw new UnsupportedOperationException();
        }
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.putCurrent(e);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    @Override
    public void remove() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.delete();
            this.setAndRemoveAllowed = false;
            this.toNext = 1;
            this.toPrevious = 2;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(E e) {
        this.coll.checkIterAddAllowed();
        try {
            SOperationStatus sOperationStatus = SOperationStatus.SUCCESS;
            if (this.toNext != 0 && this.toPrevious != 0) {
                if (!this.coll.view.keysRenumbered) throw new IllegalStateException("Collection is empty, cannot add() duplicate");
                this.close();
                sOperationStatus = this.coll.view.append(e, null, null);
                this.cursor = new DataCursor(this.coll.view, this.writeAllowed);
                this.reset();
                this.next();
            } else {
                boolean bl = false;
                if (this.coll.view.keysRenumbered) {
                    this.moveToCurrent();
                    if (this.hasNext()) {
                        sOperationStatus = this.cursor.putBefore(e);
                        bl = true;
                    } else {
                        sOperationStatus = this.cursor.putAfter(e);
                    }
                } else if (this.coll.areDuplicatesOrdered()) {
                    sOperationStatus = this.cursor.putNoDupData(null, e, null, true);
                } else if (this.toNext == 0) {
                    sOperationStatus = this.cursor.putBefore(e);
                    bl = true;
                } else {
                    sOperationStatus = this.cursor.putAfter(e);
                }
                if (bl) {
                    this.toPrevious = 0;
                    this.toNext = 1;
                }
            }
            if (sOperationStatus == SOperationStatus.KEYEXIST) {
                throw new IllegalArgumentException("Duplicate value");
            }
            if (sOperationStatus != SOperationStatus.SUCCESS) {
                throw DbCompat.unexpectedState("Could not insert: " + (Object)((Object)sOperationStatus));
            }
            this.setAndRemoveAllowed = false;
            return;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    private void reset() {
        this.toNext = 3;
        this.toPrevious = 2;
        this.toCurrent = 0;
        this.currentData = null;
        this.hasNext();
    }

    public int count() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            return this.cursor.count();
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public void close() {
        if (this.cursor != null) {
            this.coll.closeCursor(this.cursor);
            this.cursor = null;
        }
    }

    public final StoredCollection<E> getCollection() {
        return this.coll;
    }

    @Override
    final ListIterator<E> dup() {
        try {
            StoredIterator storedIterator = (StoredIterator)super.clone();
            storedIterator.cursor = this.cursor.cloneCursor();
            return storedIterator;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    @Override
    final boolean isCurrentData(Object object) {
        return this.currentData == object;
    }

    @Override
    final boolean moveToIndex(int n) {
        try {
            SOperationStatus sOperationStatus = this.cursor.getSearchKey(n, null, this.lockForWrite);
            this.setAndRemoveAllowed = sOperationStatus == SOperationStatus.SUCCESS;
            return this.setAndRemoveAllowed;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    private void moveToCurrent() throws SDatabaseException {
        if (this.toCurrent != 0) {
            this.move(this.toCurrent);
            this.toCurrent = 0;
        }
    }

    private SOperationStatus move(int n) throws SDatabaseException {
        switch (n) {
            case 1: {
                if (this.coll.iterateDuplicates()) {
                    return this.cursor.getNext(this.lockForWrite);
                }
                return this.cursor.getNextNoDup(this.lockForWrite);
            }
            case 2: {
                if (this.coll.iterateDuplicates()) {
                    return this.cursor.getPrev(this.lockForWrite);
                }
                return this.cursor.getPrevNoDup(this.lockForWrite);
            }
            case 3: {
                return this.cursor.getFirst(this.lockForWrite);
            }
        }
        throw DbCompat.unexpectedState(String.valueOf(n));
    }
}

