/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class ByteBinding
extends TupleBinding<Byte> {
    private static final int BYTE_SIZE = 1;

    @Override
    public Byte entryToObject(TupleInput tupleInput) {
        return tupleInput.readByte();
    }

    @Override
    public void objectToEntry(Byte by, TupleOutput tupleOutput) {
        tupleOutput.writeByte(by.byteValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Byte by) {
        return ByteBinding.sizedOutput();
    }

    public static byte entryToByte(SDatabaseEntry sDatabaseEntry) {
        return ByteBinding.entryToInput(sDatabaseEntry).readByte();
    }

    public static void byteToEntry(byte by, SDatabaseEntry sDatabaseEntry) {
        ByteBinding.outputToEntry(ByteBinding.sizedOutput().writeByte(by), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[1]);
    }
}

