/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SForeignMultiKeyNullifier;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.SSecondaryKeyCreator;
import com.sleepycat.client.SSecondaryMultiKeyCreator;
import com.sleepycat.client.bind.tuple.TupleBase;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.KeyLocation;
import com.sleepycat.client.persist.impl.PersistCatalog;
import com.sleepycat.client.persist.impl.PersistEntityBinding;
import com.sleepycat.client.persist.impl.PersistKeyBinding;
import com.sleepycat.client.persist.impl.RecordInput;
import com.sleepycat.client.persist.impl.RecordOutput;
import com.sleepycat.client.persist.impl.RefreshException;
import com.sleepycat.client.persist.model.EntityMetadata;
import com.sleepycat.client.persist.model.Relationship;
import com.sleepycat.client.persist.model.SecondaryKeyMetadata;
import com.sleepycat.client.persist.raw.RawObject;
import java.util.Collection;
import java.util.Set;

public class PersistKeyCreator
implements SSecondaryKeyCreator,
SSecondaryMultiKeyCreator,
SForeignMultiKeyNullifier {
    private volatile Catalog catalog;
    private volatile Format priKeyFormat;
    private final String keyName;
    private volatile Format keyFormat;
    private final boolean toMany;

    static boolean isManyType(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    public PersistKeyCreator(Catalog catalog, EntityMetadata entityMetadata, String string, SecondaryKeyMetadata secondaryKeyMetadata, boolean bl) {
        this.catalog = catalog;
        try {
            this.getFormats(entityMetadata, string, secondaryKeyMetadata, bl);
        }
        catch (RefreshException refreshException) {
            this.catalog = refreshException.refresh();
            try {
                this.getFormats(entityMetadata, string, secondaryKeyMetadata, bl);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
        this.keyName = secondaryKeyMetadata.getKeyName();
        Relationship relationship = secondaryKeyMetadata.getRelationship();
        this.toMany = relationship == Relationship.ONE_TO_MANY || relationship == Relationship.MANY_TO_MANY;
    }

    private void getFormats(EntityMetadata entityMetadata, String string, SecondaryKeyMetadata secondaryKeyMetadata, boolean bl) throws RefreshException {
        this.priKeyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, entityMetadata.getPrimaryKey().getClassName(), bl);
        this.keyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, string, bl);
        if (this.keyFormat == null) {
            throw new IllegalArgumentException("Not a key class: " + string);
        }
        if (this.keyFormat.isPrimitive()) {
            throw new IllegalArgumentException("Use a primitive wrapper class instead of class: " + this.keyFormat.getClassName());
        }
    }

    @Override
    public boolean createSecondaryKey(SSecondaryDatabase sSecondaryDatabase, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        try {
            return this.createSecondaryKeyInternal(sSecondaryDatabase, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.createSecondaryKeyInternal(sSecondaryDatabase, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private boolean createSecondaryKeyInternal(SSecondaryDatabase sSecondaryDatabase, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) throws RefreshException {
        if (this.toMany) {
            throw DbCompat.unexpectedState();
        }
        KeyLocation keyLocation = this.moveToKey(sDatabaseEntry, sDatabaseEntry2);
        if (keyLocation != null) {
            RecordOutput recordOutput = new RecordOutput(this.catalog, true);
            keyLocation.format.copySecKey(keyLocation.input, recordOutput);
            TupleBase.outputToEntry(recordOutput, sDatabaseEntry3);
            return true;
        }
        return false;
    }

    public void createSecondaryKeys(SSecondaryDatabase sSecondaryDatabase, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, Set set) {
        try {
            this.createSecondaryKeysInternal(sSecondaryDatabase, sDatabaseEntry, sDatabaseEntry2, set);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                this.createSecondaryKeysInternal(sSecondaryDatabase, sDatabaseEntry, sDatabaseEntry2, set);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private void createSecondaryKeysInternal(SSecondaryDatabase sSecondaryDatabase, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, Set set) throws RefreshException {
        if (!this.toMany) {
            throw DbCompat.unexpectedState();
        }
        KeyLocation keyLocation = this.moveToKey(sDatabaseEntry, sDatabaseEntry2);
        if (keyLocation != null) {
            keyLocation.format.copySecMultiKey(keyLocation.input, this.keyFormat, set);
        }
    }

    @Override
    public boolean nullifyForeignKey(SSecondaryDatabase sSecondaryDatabase, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        try {
            return this.nullifyForeignKeyInternal(sSecondaryDatabase, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        catch (RefreshException refreshException) {
            refreshException.refresh();
            try {
                return this.nullifyForeignKeyInternal(sSecondaryDatabase, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
            catch (RefreshException refreshException2) {
                throw DbCompat.unexpectedException(refreshException2);
            }
        }
    }

    private boolean nullifyForeignKeyInternal(SSecondaryDatabase sSecondaryDatabase, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) throws RefreshException {
        RawObject rawObject = (RawObject)PersistEntityBinding.readEntity(this.catalog, sDatabaseEntry, null, sDatabaseEntry2, true);
        Format format = (Format)rawObject.getType();
        Object object = null;
        if (this.toMany) {
            object = PersistKeyBinding.readKey(this.keyFormat, this.catalog, sDatabaseEntry3.getData(), sDatabaseEntry3.getOffset(), sDatabaseEntry3.getSize(), true);
        }
        if (format.nullifySecKey(this.catalog, rawObject, this.keyName, object)) {
            PersistEntityBinding.writeEntity(format, this.catalog, rawObject, sDatabaseEntry2, true);
            return true;
        }
        return false;
    }

    private KeyLocation moveToKey(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws RefreshException {
        RecordInput recordInput = new RecordInput(this.catalog, true, sDatabaseEntry, this.priKeyFormat.getId(), sDatabaseEntry2.getData(), sDatabaseEntry2.getOffset(), sDatabaseEntry2.getSize());
        int n = recordInput.readPackedInt();
        Format format = this.catalog.getFormat(n, true);
        recordInput.registerEntityFormat(format);
        Format format2 = format.skipToSecKey(recordInput, this.keyName);
        if (format2 != null) {
            return recordInput.getKeyLocation(format2);
        }
        return null;
    }

    void refresh(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
        this.keyFormat = this.catalog.getFormat(this.keyFormat.getClassName());
        this.priKeyFormat = this.catalog.getFormat(this.priKeyFormat.getClassName());
    }
}

