/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.STransactionConfig;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.collections.StoredSortedMap;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.BasicIndex;
import com.sleepycat.client.persist.EntityValueAdapter;
import com.sleepycat.client.persist.impl.PersistEntityBinding;
import com.sleepycat.client.persist.impl.PersistKeyAssigner;
import java.util.Map;
import java.util.SortedMap;

public class PrimaryIndex<PK, E>
extends BasicIndex<PK, E> {
    private Class<E> entityClass;
    private EntityBinding<E> entityBinding;
    private SortedMap<PK, E> map;
    private PersistKeyAssigner keyAssigner;

    public PrimaryIndex(SDatabase sDatabase, Class<PK> clazz, EntryBinding<PK> entryBinding, Class<E> clazz2, EntityBinding<E> entityBinding) throws SDatabaseException {
        super(sDatabase, clazz, entryBinding, new EntityValueAdapter<E>(clazz2, entityBinding, false));
        this.entityClass = clazz2;
        this.entityBinding = entityBinding;
        if (entityBinding instanceof PersistEntityBinding) {
            this.keyAssigner = ((PersistEntityBinding)entityBinding).getKeyAssigner();
        }
    }

    public Class<PK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding<PK> getKeyBinding() {
        return this.keyBinding;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public EntityBinding<E> getEntityBinding() {
        return this.entityBinding;
    }

    public E put(E e) throws SDatabaseException {
        return this.put(null, e);
    }

    public E put(STransaction sTransaction, E e) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        this.assignKey(e, sDatabaseEntry);
        boolean bl = false;
        SEnvironment sEnvironment = this.db.getEnvironment();
        if (this.transactional && sTransaction == null && DbCompat.getThreadTransaction(sEnvironment) == null) {
            sTransaction = sEnvironment.beginTransaction(null, this.getAutoCommitTransactionConfig());
            bl = true;
        }
        SCursorConfig sCursorConfig = null;
        if (this.concurrentDB) {
            sCursorConfig = new SCursorConfig();
            DbCompat.setWriteCursor(sCursorConfig, true);
        }
        boolean bl2 = true;
        SCursor sCursor = this.db.openCursor(sTransaction, sCursorConfig);
        SLockMode sLockMode = this.locking ? SLockMode.RMW : null;
        try {
            while (true) {
                SOperationStatus sOperationStatus;
                if ((sOperationStatus = sCursor.getSearchKey(sDatabaseEntry, sDatabaseEntry2, sLockMode)) == SOperationStatus.SUCCESS) {
                    E e2 = this.entityBinding.entryToObject(sDatabaseEntry, sDatabaseEntry2);
                    this.entityBinding.objectToData(e, sDatabaseEntry2);
                    sCursor.put(sDatabaseEntry, sDatabaseEntry2);
                    bl2 = false;
                    E e3 = e2;
                    return e3;
                }
                this.entityBinding.objectToData(e, sDatabaseEntry2);
                sOperationStatus = sCursor.putNoOverwrite(sDatabaseEntry, sDatabaseEntry2);
                if (sOperationStatus == SOperationStatus.KEYEXIST) continue;
                bl2 = false;
                E e4 = null;
                return e4;
            }
        }
        finally {
            sCursor.close();
            if (bl) {
                if (bl2) {
                    sTransaction.abort();
                } else {
                    sTransaction.commit();
                }
            }
        }
    }

    public void putNoReturn(E e) throws SDatabaseException {
        this.putNoReturn(null, e);
    }

    public void putNoReturn(STransaction sTransaction, E e) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        this.assignKey(e, sDatabaseEntry);
        this.entityBinding.objectToData(e, sDatabaseEntry2);
        this.db.put(sTransaction, sDatabaseEntry, sDatabaseEntry2);
    }

    public boolean putNoOverwrite(E e) throws SDatabaseException {
        return this.putNoOverwrite(null, e);
    }

    public boolean putNoOverwrite(STransaction sTransaction, E e) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        this.assignKey(e, sDatabaseEntry);
        this.entityBinding.objectToData(e, sDatabaseEntry2);
        SOperationStatus sOperationStatus = this.db.putNoOverwrite(sTransaction, sDatabaseEntry, sDatabaseEntry2);
        return sOperationStatus == SOperationStatus.SUCCESS;
    }

    private void assignKey(E e, SDatabaseEntry sDatabaseEntry) throws SDatabaseException {
        if (this.keyAssigner != null) {
            if (!this.keyAssigner.assignPrimaryKey(e, sDatabaseEntry)) {
                this.entityBinding.objectToKey(e, sDatabaseEntry);
            }
        } else {
            this.entityBinding.objectToKey(e, sDatabaseEntry);
        }
    }

    @Override
    public E get(PK PK) throws SDatabaseException {
        return this.get((STransaction)null, PK, (SLockMode)null);
    }

    @Override
    public E get(STransaction sTransaction, PK PK, SLockMode sLockMode) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        this.keyBinding.objectToEntry(PK, sDatabaseEntry);
        SOperationStatus sOperationStatus = this.db.get(sTransaction, sDatabaseEntry, sDatabaseEntry2, sLockMode);
        if (sOperationStatus == SOperationStatus.SUCCESS) {
            return this.makeEntity(PK, sDatabaseEntry, sDatabaseEntry2);
        }
        return null;
    }

    private E makeEntity(PK PK, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        return (E)(this.entityBinding instanceof PersistEntityBinding ? ((PersistEntityBinding)this.entityBinding).entryToObjectWithPriKey(PK, sDatabaseEntry2) : this.entityBinding.entryToObject(sDatabaseEntry, sDatabaseEntry2));
    }

    @Override
    public Map<PK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<PK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<PK, E>(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    STransactionConfig getAutoCommitTransactionConfig() {
        return null;
    }

    @Override
    boolean isUpdateAllowed() {
        return true;
    }
}

