/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SDeadlockException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.STransactionConfig;
import com.sleepycat.client.collections.CurrentTransaction;
import com.sleepycat.client.collections.TransactionWorker;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.ExceptionUnwrapper;

public class TransactionRunner {
    public static final int DEFAULT_MAX_RETRIES = 10;
    private CurrentTransaction currentTxn;
    private int maxRetries;
    private STransactionConfig config;
    private boolean allowNestedTxn;

    public TransactionRunner(SEnvironment sEnvironment) {
        this(sEnvironment, 10, null);
    }

    public TransactionRunner(SEnvironment sEnvironment, int n, STransactionConfig sTransactionConfig) {
        this.currentTxn = CurrentTransaction.getInstance(sEnvironment);
        this.maxRetries = n;
        this.config = sTransactionConfig;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public boolean getAllowNestedTransactions() {
        return this.allowNestedTxn;
    }

    public void setAllowNestedTransactions(boolean bl) {
        if (bl) {
            // empty if block
        }
        this.allowNestedTxn = bl;
    }

    public STransactionConfig getTransactionConfig() {
        return this.config;
    }

    public void setTransactionConfig(STransactionConfig sTransactionConfig) {
        this.config = sTransactionConfig;
    }

    public void run(TransactionWorker transactionWorker) throws SDatabaseException, Exception {
        if (this.currentTxn != null && (this.allowNestedTxn || this.currentTxn.getTransaction() == null)) {
            int n = this.maxRetries;
            int n2 = 0;
            while (true) {
                STransaction sTransaction = null;
                try {
                    sTransaction = this.currentTxn.beginTransaction(this.config);
                    transactionWorker.doWork();
                    if (sTransaction != null && sTransaction == this.currentTxn.getTransaction()) {
                        this.currentTxn.commitTransaction();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = ExceptionUnwrapper.unwrapAny(throwable);
                    if (sTransaction != null && sTransaction == this.currentTxn.getTransaction()) {
                        try {
                            this.currentTxn.abortTransaction();
                        }
                        catch (Throwable throwable3) {
                            if (DbCompat.TRANSACTION_RUNNER_PRINT_STACK_TRACES) {
                                throwable3.printStackTrace();
                            }
                            n2 = n;
                        }
                    }
                    if (throwable2 instanceof Error) {
                        throw (Error)throwable2;
                    }
                    Exception exception = (Exception)throwable2;
                    if (n2 >= (n = this.handleException(exception, n2, n))) {
                        throw exception;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        try {
            transactionWorker.doWork();
        }
        catch (Exception exception) {
            throw ExceptionUnwrapper.unwrap(exception);
        }
    }

    public int handleException(Exception exception, int n, int n2) throws Exception {
        if (exception instanceof SDeadlockException) {
            return n2;
        }
        throw exception;
    }
}

