/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.collections.CurrentTransaction;
import com.sleepycat.client.collections.DataCursor;
import com.sleepycat.client.collections.DataView;
import com.sleepycat.client.collections.StoredCollection;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import java.util.Collection;
import java.util.Iterator;

public abstract class StoredContainer
implements Cloneable {
    DataView view;

    StoredContainer(DataView dataView) {
        this.view = dataView;
    }

    public final boolean isWriteAllowed() {
        return this.view.writeAllowed;
    }

    public final SCursorConfig getCursorConfig() {
        return DbCompat.cloneCursorConfig(this.view.cursorConfig);
    }

    public final boolean isTransactional() {
        return this.view.transactional;
    }

    final StoredContainer configuredClone(SCursorConfig sCursorConfig) {
        try {
            StoredContainer storedContainer = (StoredContainer)this.clone();
            storedContainer.view = storedContainer.view.configuredView(sCursorConfig);
            storedContainer.initAfterClone();
            return storedContainer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void initAfterClone() {
    }

    public final boolean areDuplicatesAllowed() {
        return this.view.dupsAllowed;
    }

    public final boolean areDuplicatesOrdered() {
        return this.view.dupsOrdered;
    }

    public final boolean areKeysRenumbered() {
        return this.view.keysRenumbered;
    }

    public final boolean isOrdered() {
        return this.view.ordered;
    }

    public final boolean areKeyRangesAllowed() {
        return this.view.keyRangesAllowed;
    }

    public final boolean isSecondary() {
        return this.view.isSecondary();
    }

    public abstract int size();

    public boolean isEmpty() {
        try {
            return this.view.isEmpty();
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public void clear() {
        boolean bl = this.beginAutoCommit();
        try {
            this.view.clear();
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    Object getValue(Object object) {
        DataCursor dataCursor;
        block5: {
            dataCursor = null;
            dataCursor = new DataCursor(this.view, false);
            if (SOperationStatus.SUCCESS != dataCursor.getSearchKey(object, null, false)) break block5;
            Object object2 = dataCursor.getCurrentValue();
            this.closeCursor(dataCursor);
            return object2;
        }
        try {
            Object var3_4 = null;
            this.closeCursor(dataCursor);
            return var3_4;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    Object putKeyValue(Object object, Object object2) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            Object[] objectArray = new Object[1];
            dataCursor.put(object, object2, objectArray, false);
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return objectArray[0];
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    final boolean removeKey(Object object, Object[] objectArray) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            boolean bl2 = false;
            SOperationStatus sOperationStatus = dataCursor.getSearchKey(object, null, true);
            while (sOperationStatus == SOperationStatus.SUCCESS) {
                dataCursor.delete();
                bl2 = true;
                if (objectArray != null && objectArray[0] == null) {
                    objectArray[0] = dataCursor.getCurrentValue();
                }
                sOperationStatus = this.areDuplicatesAllowed() ? dataCursor.getNextDup(true) : SOperationStatus.NOTFOUND;
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    boolean containsKey(Object object) {
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            boolean bl = SOperationStatus.SUCCESS == dataCursor.getSearchKey(object, null, false);
            this.closeCursor(dataCursor);
            return bl;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    final boolean removeValue(Object object) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            SOperationStatus sOperationStatus = dataCursor.findValue(object, true);
            if (sOperationStatus == SOperationStatus.SUCCESS) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return sOperationStatus == SOperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    boolean containsValue(Object object) {
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            SOperationStatus sOperationStatus = dataCursor.findValue(object, true);
            boolean bl = sOperationStatus == SOperationStatus.SUCCESS;
            this.closeCursor(dataCursor);
            return bl;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
    }

    final Iterator storedOrExternalIterator(Collection collection) {
        if (collection instanceof StoredCollection) {
            return ((StoredCollection)collection).storedIterator();
        }
        return collection.iterator();
    }

    final void closeCursor(DataCursor dataCursor) {
        if (dataCursor != null) {
            try {
                dataCursor.close();
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
    }

    final boolean beginAutoCommit() {
        if (this.view.transactional) {
            CurrentTransaction currentTransaction = this.view.getCurrentTxn();
            try {
                if (currentTransaction.isAutoCommitAllowed()) {
                    currentTransaction.beginTransaction(null);
                    return true;
                }
            }
            catch (SDatabaseException sDatabaseException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
            }
        }
        return false;
    }

    final void commitAutoCommit(boolean bl) throws SDatabaseException {
        if (bl) {
            this.view.getCurrentTxn().commitTransaction();
        }
    }

    final RuntimeException handleException(Exception exception, boolean bl) {
        if (bl) {
            try {
                this.view.getCurrentTxn().abortTransaction();
            }
            catch (SDatabaseException sDatabaseException) {
                // empty catch block
            }
        }
        return StoredContainer.convertException(exception);
    }

    static RuntimeException convertException(Exception exception) {
        return RuntimeExceptionWrapper.wrapIfNeeded(exception);
    }
}

