/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class ShortBinding
extends TupleBinding<Short> {
    private static final int SHORT_SIZE = 2;

    @Override
    public Short entryToObject(TupleInput tupleInput) {
        return tupleInput.readShort();
    }

    @Override
    public void objectToEntry(Short s, TupleOutput tupleOutput) {
        tupleOutput.writeShort(s.shortValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Short s) {
        return ShortBinding.sizedOutput();
    }

    public static short entryToShort(SDatabaseEntry sDatabaseEntry) {
        return ShortBinding.entryToInput(sDatabaseEntry).readShort();
    }

    public static void shortToEntry(short s, SDatabaseEntry sDatabaseEntry) {
        ShortBinding.outputToEntry(ShortBinding.sizedOutput().writeShort(s), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

