/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.EntryBinding;

public class ByteArrayBinding
implements EntryBinding<byte[]> {
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    @Override
    public byte[] entryToObject(SDatabaseEntry sDatabaseEntry) {
        int n = sDatabaseEntry.getSize();
        if (n == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public void objectToEntry(byte[] byArray, SDatabaseEntry sDatabaseEntry) {
        sDatabaseEntry.setData(byArray, 0, byArray.length);
    }
}

