/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TDurabilityPolicy;
import com.sleepycat.thrift.TTransaction;
import java.util.Objects;

public class STransaction
implements RemoteCallHelper {
    private final TTransaction tTransaction;
    private final BdbService.Client client;

    STransaction(TTransaction tTransaction, BdbService.Client client) {
        this.tTransaction = Objects.requireNonNull(tTransaction);
        this.client = Objects.requireNonNull(client);
    }

    static TTransaction nullSafeGet(STransaction sTransaction) {
        return sTransaction == null ? null : sTransaction.tTransaction;
    }

    public void abort() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.txnAbort(this.tTransaction);
            return null;
        });
    }

    public void commit() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.txnCommit(this.tTransaction, null);
            return null;
        });
    }

    public void commitNoSync() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.txnCommit(this.tTransaction, TDurabilityPolicy.NO_SYNC);
            return null;
        });
    }

    public void commitSync() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.txnCommit(this.tTransaction, TDurabilityPolicy.SYNC);
            return null;
        });
    }

    public void commitWriteNoSync() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.txnCommit(this.tTransaction, TDurabilityPolicy.WRITE_NO_SYNC);
            return null;
        });
    }

    public int getPriority() throws SDatabaseException {
        return this.remoteCall(() -> this.client.txnGetPriority(this.tTransaction));
    }

    public void setPriority(int n) throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.txnSetPriority(this.tTransaction, n);
            return null;
        });
    }
}

