/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseEntryBase;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TKeyData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public abstract class SMultiplePairs
implements SDatabaseEntryBase {
    private int batchSize;
    private final List<Pair> entries = new LinkedList<Pair>();
    private Iterator<Pair> iterator;

    protected SMultiplePairs() {
    }

    void setEntriesFromKeyDatas(List<TKeyData> list) {
        this.entries.clear();
        list.forEach(tKeyData -> this.append(new SDatabaseEntry(tKeyData.key), new SDatabaseEntry(tKeyData.data)));
        this.iterator = this.entries.iterator();
    }

    <T> List<T> map(BiFunction<SDatabaseEntry, SDatabaseEntry, T> biFunction) {
        return this.entries.stream().map((? super T pair) -> biFunction.apply(pair.key, pair.data)).collect(Collectors.toList());
    }

    protected void append(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        this.entries.add(new Pair(sDatabaseEntry, sDatabaseEntry2));
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public boolean next(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        if (this.iterator.hasNext()) {
            Pair pair = this.iterator.next();
            sDatabaseEntry.setDataFromTDbt((TDbt)pair.key.getThriftObj());
            sDatabaseEntry2.setDataFromTDbt((TDbt)pair.data.getThriftObj());
            return true;
        }
        return false;
    }

    private static class Pair {
        final SDatabaseEntry key;
        final SDatabaseEntry data;

        Pair(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
            this.key = sDatabaseEntry;
            this.data = sDatabaseEntry2;
        }
    }
}

