/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.BdbServerConnection;
import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SCacheFileStats;
import com.sleepycat.client.SCacheStats;
import com.sleepycat.client.SCheckpointConfig;
import com.sleepycat.client.SCursor;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironmentConfig;
import com.sleepycat.client.SLockStats;
import com.sleepycat.client.SLogStats;
import com.sleepycat.client.SMultiStats;
import com.sleepycat.client.SMultiStatsConfig;
import com.sleepycat.client.SMultipleKeyDataEntry;
import com.sleepycat.client.SMutexStats;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryConfig;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.SStatsConfig;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.STransactionConfig;
import com.sleepycat.client.STransactionStats;
import com.sleepycat.client.ThriftWrapper;
import com.sleepycat.client.TxnHelper;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TDatabase;
import com.sleepycat.thrift.TEnvStatConfig;
import com.sleepycat.thrift.TEnvironment;
import com.sleepycat.thrift.TTransaction;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Objects;

public class SEnvironment
implements RemoteCallHelper,
TxnHelper,
AutoCloseable {
    private final TEnvironment tEnv;
    private final String home;
    private BdbServerConnection connection;
    private final BdbService.Client client;

    SEnvironment(TEnvironment tEnvironment, String string, BdbServerConnection bdbServerConnection, BdbService.Client client) {
        this.tEnv = Objects.requireNonNull(tEnvironment);
        this.home = Objects.requireNonNull(string);
        this.connection = Objects.requireNonNull(bdbServerConnection);
        this.client = Objects.requireNonNull(client);
    }

    protected SEnvironment(SEnvironment sEnvironment) {
        this.tEnv = sEnvironment.tEnv;
        this.home = sEnvironment.home;
        this.client = sEnvironment.client;
    }

    @Override
    public void close() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.closeEnvironmentHandle(this.tEnv);
            return null;
        });
    }

    @Override
    public SEnvironment getEnvironment() {
        return this;
    }

    public ByteOrder getServerByteOrder() {
        return this.connection.getServerByteOrder();
    }

    public SEnvironmentConfig getConfig() throws SDatabaseException {
        return this.remoteCall(() -> new SEnvironmentConfig(this.client.getEnvironmentConfig(this.tEnv)));
    }

    public void setConfig(SEnvironmentConfig sEnvironmentConfig) throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.setEnvironmentConfig(this.tEnv, ThriftWrapper.nullSafeGet(sEnvironmentConfig));
            return null;
        });
    }

    public String getHome() {
        return this.home;
    }

    public SDatabase openDatabase(STransaction sTransaction, String string, String string2, SDatabaseConfig sDatabaseConfig) throws IOException, SDatabaseException {
        return this.remoteCallWithIOException(() -> {
            TDatabase tDatabase = this.client.openDatabase(this.tEnv, STransaction.nullSafeGet(sTransaction), string, string2, ThriftWrapper.nullSafeGet(sDatabaseConfig));
            return new SDatabase(tDatabase, string, string2, this.client, this);
        });
    }

    public SSecondaryDatabase openSecondaryDatabase(STransaction sTransaction2, String string, String string2, SDatabase sDatabase, SSecondaryConfig sSecondaryConfig) throws IOException, SDatabaseException {
        return this.runInSingleTxnWithIOException(sTransaction2, sTransaction -> {
            SSecondaryDatabase sSecondaryDatabase = this.remoteOpenSecondary(sTransaction, string, string2, sDatabase, sSecondaryConfig);
            if (sSecondaryConfig.getAllowPopulate() && sSecondaryDatabase.isEmpty(sTransaction)) {
                this.populateSecondaryDatabase(sTransaction, sDatabase);
            }
            return sSecondaryDatabase;
        });
    }

    private SSecondaryDatabase remoteOpenSecondary(STransaction sTransaction, String string, String string2, SDatabase sDatabase, SSecondaryConfig sSecondaryConfig) throws IOException, SDatabaseException {
        return this.remoteCallWithIOException(() -> {
            TDatabase tDatabase = this.client.openSecondaryDatabase(this.tEnv, STransaction.nullSafeGet(sTransaction), string, string2, sDatabase.getThriftObj(), SSecondaryConfig.nullSafeGet(sSecondaryConfig));
            return new SSecondaryDatabase(tDatabase, string, string2, this.client, this, sDatabase, new SSecondaryConfig(sSecondaryConfig));
        });
    }

    private void populateSecondaryDatabase(STransaction sTransaction, SDatabase sDatabase) throws SDatabaseException {
        try (SCursor sCursor = sDatabase.openCursor(sTransaction, null);){
            SMultipleKeyDataEntry sMultipleKeyDataEntry = new SMultipleKeyDataEntry();
            sMultipleKeyDataEntry.setBatchSize(1024);
            while (sCursor.getNext(null, sMultipleKeyDataEntry, null) != SOperationStatus.NOTFOUND) {
                sDatabase.putMultipleKey(sTransaction, sMultipleKeyDataEntry, true);
            }
        }
    }

    public void removeDatabase(STransaction sTransaction, String string, String string2, boolean bl) throws IOException, SDatabaseException {
        this.remoteCallWithIOException(() -> {
            this.client.removeDatabase(this.tEnv, STransaction.nullSafeGet(sTransaction), string, string2, bl);
            return null;
        });
    }

    public void renameDatabase(STransaction sTransaction, String string, String string2, String string3, boolean bl) throws IOException, SDatabaseException {
        this.remoteCallWithIOException(() -> {
            this.client.renameDatabase(this.tEnv, STransaction.nullSafeGet(sTransaction), string, string2, string3, bl);
            return null;
        });
    }

    public STransaction beginTransaction(STransaction sTransaction, STransactionConfig sTransactionConfig) throws SDatabaseException {
        return this.remoteCall(() -> {
            TTransaction tTransaction = this.client.beginTransaction(this.tEnv, STransaction.nullSafeGet(sTransaction), ThriftWrapper.nullSafeGet(sTransactionConfig));
            return new STransaction(tTransaction, this.client);
        });
    }

    public void checkpoint(SCheckpointConfig sCheckpointConfig) throws SDatabaseException {
        SCheckpointConfig sCheckpointConfig2 = sCheckpointConfig == null ? new SCheckpointConfig() : sCheckpointConfig;
        this.remoteCall(() -> {
            this.client.checkpoint(this.tEnv, sCheckpointConfig2.getKBytes(), sCheckpointConfig2.getMinutes(), sCheckpointConfig2.getForce());
            return null;
        });
    }

    public SCacheFileStats[] getCacheFileStats(SStatsConfig sStatsConfig) throws SDatabaseException {
        return this.getMultipleStats(new SMultiStatsConfig().setCacheFileConfig(true, sStatsConfig)).getCacheFileStats();
    }

    public SCacheStats getCacheStats(SStatsConfig sStatsConfig) throws SDatabaseException {
        return this.getMultipleStats(new SMultiStatsConfig().setCacheConfig(true, sStatsConfig)).getCacheStats();
    }

    public SLockStats getLockStats(SStatsConfig sStatsConfig) throws SDatabaseException {
        return this.getMultipleStats(new SMultiStatsConfig().setLockConfig(true, sStatsConfig)).getLockStats();
    }

    public SLogStats getLogStats(SStatsConfig sStatsConfig) throws SDatabaseException {
        return this.getMultipleStats(new SMultiStatsConfig().setLogConfig(true, sStatsConfig)).getLogStats();
    }

    public SMutexStats getMutexStats(SStatsConfig sStatsConfig) throws SDatabaseException {
        return this.getMultipleStats(new SMultiStatsConfig().setMutexConfig(true, sStatsConfig)).getMutexStats();
    }

    public STransactionStats getTransactionStats(SStatsConfig sStatsConfig) throws SDatabaseException {
        return this.getMultipleStats(new SMultiStatsConfig().setTransactionConfig(true, sStatsConfig)).getTransactionStats();
    }

    public SMultiStats getMultipleStats(SMultiStatsConfig sMultiStatsConfig) throws SDatabaseException {
        return this.remoteCall(() -> new SMultiStats(this.client.getEnvStatistics(this.tEnv, (TEnvStatConfig)sMultiStatsConfig.getThriftObj())));
    }
}

