/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.thrift.BdbService;
import java.io.IOException;
import java.util.Objects;

public class BdbServerAdmin
implements RemoteCallHelper {
    private final BdbService.Client client;

    BdbServerAdmin(BdbService.Client client) {
        this.client = Objects.requireNonNull(client);
    }

    public void ping() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.ping();
            return null;
        });
    }

    public String getServerBdbVersion() throws SDatabaseException {
        return this.remoteCall(() -> ((BdbService.Client)this.client).getBdbVersion());
    }

    public void shutdownServer() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.shutdown();
            return null;
        });
    }

    public void closeEnvironmentHandles(String string, long l) throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.closeEnvironmentHandles(string, l);
            return null;
        });
    }

    public void deleteEnvironmentAndDatabases(String string, boolean bl) throws IOException, SDatabaseException {
        this.remoteCallWithIOException(() -> {
            this.client.deleteEnvironmentAndDatabases(string, bl);
            return null;
        });
    }

    public void closeDatabaseHandles(String string, String string2, String string3, long l) throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.closeDatabaseHandles(string, string2, string3, l);
            return null;
        });
    }
}

