/*
 * cxd2880_dtv.h
 * Sony CXD2880 DVB-T2/T tuner + demodulator driver
 * DTV related definitions
 *
 * Copyright (C) 2016, 2017 Sony Semiconductor Solutions Corporation
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; version 2 of the License.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CXD2880_DTV_H
#define CXD2880_DTV_H

enum cxd2880_dtv_sys {
	CXD2880_DTV_SYS_UNKNOWN,
	CXD2880_DTV_SYS_DVBT,
	CXD2880_DTV_SYS_DVBT2,
	CXD2880_DTV_SYS_ISDBT,
	CXD2880_DTV_SYS_ISDBTSB,
	CXD2880_DTV_SYS_ISDBTMM_A,
	CXD2880_DTV_SYS_ISDBTMM_B,
	CXD2880_DTV_SYS_ANY
};

enum cxd2880_dtv_bandwidth {
	CXD2880_DTV_BW_UNKNOWN = 0,
	CXD2880_DTV_BW_1_7_MHZ = 1,
	CXD2880_DTV_BW_5_MHZ = 5,
	CXD2880_DTV_BW_6_MHZ = 6,
	CXD2880_DTV_BW_7_MHZ = 7,
	CXD2880_DTV_BW_8_MHZ = 8
};

#endif
