(defvar xmlunicode-character-list
  '(
    ;Codept   Unicode name                            ISO Name
    (#x000000 "NULL"                                   nil     )
    (#x000001 "START OF HEADING"                       nil     )
    (#x000002 "START OF TEXT"                          nil     )
    (#x000003 "END OF TEXT"                            nil     )
    (#x000004 "END OF TRANSMISSION"                    nil     )
    (#x000005 "ENQUIRY"                                nil     )
    (#x000006 "ACKNOWLEDGE"                            nil     )
    (#x000007 "BELL"                                   nil     )
    (#x000008 "BACKSPACE"                              nil     )
    (#x000009 "CHARACTER TABULATION"                   nil     )
    (#x00000a "LINE FEED (LF)"                         nil     )
    (#x00000b "LINE TABULATION"                        nil     )
    (#x00000c "FORM FEED (FF)"                         nil     )
    (#x00000d "CARRIAGE RETURN (CR)"                   nil     )
    (#x00000e "SHIFT OUT"                              nil     )
    (#x00000f "SHIFT IN"                               nil     )
    (#x000010 "DATA LINK ESCAPE"                       nil     )
    (#x000011 "DEVICE CONTROL ONE"                     nil     )
    (#x000012 "DEVICE CONTROL TWO"                     nil     )
    (#x000013 "DEVICE CONTROL THREE"                   nil     )
    (#x000014 "DEVICE CONTROL FOUR"                    nil     )
    (#x000015 "NEGATIVE ACKNOWLEDGE"                   nil     )
    (#x000016 "SYNCHRONOUS IDLE"                       nil     )
    (#x000017 "END OF TRANSMISSION BLOCK"              nil     )
    (#x000018 "CANCEL"                                 nil     )
    (#x000019 "END OF MEDIUM"                          nil     )
    (#x00001a "SUBSTITUTE"                             nil     )
    (#x00001b "ESCAPE"                                 nil     )
    (#x00001c "INFORMATION SEPARATOR FOUR"             nil     )
    (#x00001d "INFORMATION SEPARATOR THREE"            nil     )
    (#x00001e "INFORMATION SEPARATOR TWO"              nil     )
    (#x00001f "INFORMATION SEPARATOR ONE"              nil     )
    (#x000020 "SPACE"                                  nil     )
    (#x000021 "EXCLAMATION MARK"                       "excl"  )
    (#x000022 "QUOTATION MARK"                         "quot"  )
    (#x000023 "NUMBER SIGN"                            "num"   )
    (#x000024 "DOLLAR SIGN"                            "dollar")
    (#x000025 "PERCENT SIGN"                           "percnt")
    (#x000026 "AMPERSAND"                              "amp"   )
    (#x000027 "APOSTROPHE"                             "apos"  )
    (#x000028 "LEFT PARENTHESIS"                       "lpar"  )
    (#x000029 "RIGHT PARENTHESIS"                      "rpar"  )
    (#x00002a "ASTERISK"                               "ast"   )
    (#x00002b "PLUS SIGN"                              "plus"  )
    (#x00002c "COMMA"                                  "comma" )
    (#x00002d "HYPHEN-MINUS"                           nil     )
    (#x00002e "FULL STOP"                              "period")
    (#x00002f "SOLIDUS"                                "sol"   )
    (#x000030 "DIGIT ZERO"                             nil     )
    (#x000031 "DIGIT ONE"                              nil     )
    (#x000032 "DIGIT TWO"                              nil     )
    (#x000033 "DIGIT THREE"                            nil     )
    (#x000034 "DIGIT FOUR"                             nil     )
    (#x000035 "DIGIT FIVE"                             nil     )
    (#x000036 "DIGIT SIX"                              nil     )
    (#x000037 "DIGIT SEVEN"                            nil     )
    (#x000038 "DIGIT EIGHT"                            nil     )
    (#x000039 "DIGIT NINE"                             nil     )
    (#x00003a "COLON"                                  "colon" )
    (#x00003b "SEMICOLON"                              "semi"  )
    (#x00003c "LESS-THAN SIGN"                         "lt"    )
    (#x00003d "EQUALS SIGN"                            "equals")
    (#x00003e "GREATER-THAN SIGN"                      "gt"    )
    (#x00003f "QUESTION MARK"                          "quest" )
    (#x000040 "COMMERCIAL AT"                          "commat")
    (#x000041 "LATIN CAPITAL LETTER A"                 nil     )
    (#x000042 "LATIN CAPITAL LETTER B"                 nil     )
    (#x000043 "LATIN CAPITAL LETTER C"                 nil     )
    (#x000044 "LATIN CAPITAL LETTER D"                 nil     )
    (#x000045 "LATIN CAPITAL LETTER E"                 nil     )
    (#x000046 "LATIN CAPITAL LETTER F"                 nil     )
    (#x000047 "LATIN CAPITAL LETTER G"                 nil     )
    (#x000048 "LATIN CAPITAL LETTER H"                 nil     )
    (#x000049 "LATIN CAPITAL LETTER I"                 nil     )
    (#x00004a "LATIN CAPITAL LETTER J"                 nil     )
    (#x00004b "LATIN CAPITAL LETTER K"                 nil     )
    (#x00004c "LATIN CAPITAL LETTER L"                 nil     )
    (#x00004d "LATIN CAPITAL LETTER M"                 nil     )
    (#x00004e "LATIN CAPITAL LETTER N"                 nil     )
    (#x00004f "LATIN CAPITAL LETTER O"                 nil     )
    (#x000050 "LATIN CAPITAL LETTER P"                 nil     )
    (#x000051 "LATIN CAPITAL LETTER Q"                 nil     )
    (#x000052 "LATIN CAPITAL LETTER R"                 nil     )
    (#x000053 "LATIN CAPITAL LETTER S"                 nil     )
    (#x000054 "LATIN CAPITAL LETTER T"                 nil     )
    (#x000055 "LATIN CAPITAL LETTER U"                 nil     )
    (#x000056 "LATIN CAPITAL LETTER V"                 nil     )
    (#x000057 "LATIN CAPITAL LETTER W"                 nil     )
    (#x000058 "LATIN CAPITAL LETTER X"                 nil     )
    (#x000059 "LATIN CAPITAL LETTER Y"                 nil     )
    (#x00005a "LATIN CAPITAL LETTER Z"                 nil     )
    (#x00005b "LEFT SQUARE BRACKET"                    "lsqb"  )
    (#x00005c "REVERSE SOLIDUS"                        "bsol"  )
    (#x00005d "RIGHT SQUARE BRACKET"                   "rsqb"  )
    (#x00005e "CIRCUMFLEX ACCENT"                      nil     )
    (#x00005f "LOW LINE"                               "lowbar")
    (#x000060 "GRAVE ACCENT"                           "grave" )
    (#x000061 "LATIN SMALL LETTER A"                   nil     )
    (#x000062 "LATIN SMALL LETTER B"                   nil     )
    (#x000063 "LATIN SMALL LETTER C"                   nil     )
    (#x000064 "LATIN SMALL LETTER D"                   nil     )
    (#x000065 "LATIN SMALL LETTER E"                   nil     )
    (#x000066 "LATIN SMALL LETTER F"                   nil     )
    (#x000067 "LATIN SMALL LETTER G"                   nil     )
    (#x000068 "LATIN SMALL LETTER H"                   nil     )
    (#x000069 "LATIN SMALL LETTER I"                   nil     )
    (#x00006a "LATIN SMALL LETTER J"                   "jnodot")
    (#x00006b "LATIN SMALL LETTER K"                   nil     )
    (#x00006c "LATIN SMALL LETTER L"                   nil     )
    (#x00006d "LATIN SMALL LETTER M"                   nil     )
    (#x00006e "LATIN SMALL LETTER N"                   nil     )
    (#x00006f "LATIN SMALL LETTER O"                   nil     )
    (#x000070 "LATIN SMALL LETTER P"                   nil     )
    (#x000071 "LATIN SMALL LETTER Q"                   nil     )
    (#x000072 "LATIN SMALL LETTER R"                   nil     )
    (#x000073 "LATIN SMALL LETTER S"                   nil     )
    (#x000074 "LATIN SMALL LETTER T"                   nil     )
    (#x000075 "LATIN SMALL LETTER U"                   nil     )
    (#x000076 "LATIN SMALL LETTER V"                   nil     )
    (#x000077 "LATIN SMALL LETTER W"                   nil     )
    (#x000078 "LATIN SMALL LETTER X"                   nil     )
    (#x000079 "LATIN SMALL LETTER Y"                   nil     )
    (#x00007a "LATIN SMALL LETTER Z"                   nil     )
    (#x00007b "LEFT CURLY BRACKET"                     "lcub"  )
    (#x00007c "VERTICAL LINE"                          "verbar")
    (#x00007d "RIGHT CURLY BRACKET"                    "rcub"  )
    (#x00007e "TILDE"                                  nil     )
    (#x00007f "DELETE"                                 nil     )
    (#x000082 "BREAK PERMITTED HERE"                   nil     )
    (#x000083 "NO BREAK HERE"                          nil     )
    (#x000085 "NEXT LINE (NEL)"                        nil     )
    (#x000086 "START OF SELECTED AREA"                 nil     )
    (#x000087 "END OF SELECTED AREA"                   nil     )
    (#x000088 "CHARACTER TABULATION SET"               nil     )
    (#x000089 "CHARACTER TABULATION WITH JUSTIFICATION" nil     )
    (#x00008a "LINE TABULATION SET"                    nil     )
    (#x00008b "PARTIAL LINE FORWARD"                   nil     )
    (#x00008c "PARTIAL LINE BACKWARD"                  nil     )
    (#x00008d "REVERSE LINE FEED"                      nil     )
    (#x00008e "SINGLE SHIFT TWO"                       nil     )
    (#x00008f "SINGLE SHIFT THREE"                     nil     )
    (#x000090 "DEVICE CONTROL STRING"                  nil     )
    (#x000091 "PRIVATE USE ONE"                        nil     )
    (#x000092 "PRIVATE USE TWO"                        nil     )
    (#x000093 "SET TRANSMIT STATE"                     nil     )
    (#x000094 "CANCEL CHARACTER"                       nil     )
    (#x000095 "MESSAGE WAITING"                        nil     )
    (#x000096 "START OF GUARDED AREA"                  nil     )
    (#x000097 "END OF GUARDED AREA"                    nil     )
    (#x000098 "START OF STRING"                        nil     )
    (#x00009a "SINGLE CHARACTER INTRODUCER"            nil     )
    (#x00009b "CONTROL SEQUENCE INTRODUCER"            nil     )
    (#x00009c "STRING TERMINATOR"                      nil     )
    (#x00009d "OPERATING SYSTEM COMMAND"               nil     )
    (#x00009e "PRIVACY MESSAGE"                        nil     )
    (#x00009f "APPLICATION PROGRAM COMMAND"            nil     )
    (#x0000a0 "NO-BREAK SPACE"                         "nbsp"  )
    (#x0000a1 "INVERTED EXCLAMATION MARK"              "iexcl" )
    (#x0000a2 "CENT SIGN"                              "cent"  )
    (#x0000a3 "POUND SIGN"                             "pound" )
    (#x0000a4 "CURRENCY SIGN"                          "curren")
    (#x0000a5 "YEN SIGN"                               "yen"   )
    (#x0000a6 "BROKEN BAR"                             "brvbar")
    (#x0000a7 "SECTION SIGN"                           "sect"  )
    (#x0000a8 "DIAERESIS"                              "Dot"   )
    (#x0000a9 "COPYRIGHT SIGN"                         "copy"  )
    (#x0000aa "FEMININE ORDINAL INDICATOR"             "ordf"  )
    (#x0000ab "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK" "laquo" )
    (#x0000ac "NOT SIGN"                               "not"   )
    (#x0000ad "SOFT HYPHEN"                            "shy"   )
    (#x0000ae "REGISTERED SIGN"                        "reg"   )
    (#x0000af "MACRON"                                 "macr"  )
    (#x0000b0 "DEGREE SIGN"                            "deg"   )
    (#x0000b1 "PLUS-MINUS SIGN"                        "plusmn")
    (#x0000b2 "SUPERSCRIPT TWO"                        "sup2"  )
    (#x0000b3 "SUPERSCRIPT THREE"                      "sup3"  )
    (#x0000b4 "ACUTE ACCENT"                           "acute" )
    (#x0000b5 "MICRO SIGN"                             "micro" )
    (#x0000b6 "PILCROW SIGN"                           "para"  )
    (#x0000b7 "MIDDLE DOT"                             "middot")
    (#x0000b8 "CEDILLA"                                "cedil" )
    (#x0000b9 "SUPERSCRIPT ONE"                        "sup1"  )
    (#x0000ba "MASCULINE ORDINAL INDICATOR"            "ordm"  )
    (#x0000bb "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK" "raquo" )
    (#x0000bc "VULGAR FRACTION ONE QUARTER"            "frac14")
    (#x0000bd "VULGAR FRACTION ONE HALF"               "frac12")
    (#x0000be "VULGAR FRACTION THREE QUARTERS"         "frac34")
    (#x0000bf "INVERTED QUESTION MARK"                 "iquest")
    (#x0000c0 "LATIN CAPITAL LETTER A WITH GRAVE"      "Agrave")
    (#x0000c1 "LATIN CAPITAL LETTER A WITH ACUTE"      "Aacute")
    (#x0000c2 "LATIN CAPITAL LETTER A WITH CIRCUMFLEX" "Acirc" )
    (#x0000c3 "LATIN CAPITAL LETTER A WITH TILDE"      "Atilde")
    (#x0000c4 "LATIN CAPITAL LETTER A WITH DIAERESIS"  "Auml"  )
    (#x0000c5 "LATIN CAPITAL LETTER A WITH RING ABOVE" "Aring" )
    (#x0000c6 "LATIN CAPITAL LETTER AE"                "AElig" )
    (#x0000c7 "LATIN CAPITAL LETTER C WITH CEDILLA"    "Ccedil")
    (#x0000c8 "LATIN CAPITAL LETTER E WITH GRAVE"      "Egrave")
    (#x0000c9 "LATIN CAPITAL LETTER E WITH ACUTE"      "Eacute")
    (#x0000ca "LATIN CAPITAL LETTER E WITH CIRCUMFLEX" "Ecirc" )
    (#x0000cb "LATIN CAPITAL LETTER E WITH DIAERESIS"  "Euml"  )
    (#x0000cc "LATIN CAPITAL LETTER I WITH GRAVE"      "Igrave")
    (#x0000cd "LATIN CAPITAL LETTER I WITH ACUTE"      "Iacute")
    (#x0000ce "LATIN CAPITAL LETTER I WITH CIRCUMFLEX" "Icirc" )
    (#x0000cf "LATIN CAPITAL LETTER I WITH DIAERESIS"  "Iuml"  )
    (#x0000d0 "LATIN CAPITAL LETTER ETH"               "ETH"   )
    (#x0000d1 "LATIN CAPITAL LETTER N WITH TILDE"      "Ntilde")
    (#x0000d2 "LATIN CAPITAL LETTER O WITH GRAVE"      "Ograve")
    (#x0000d3 "LATIN CAPITAL LETTER O WITH ACUTE"      "Oacute")
    (#x0000d4 "LATIN CAPITAL LETTER O WITH CIRCUMFLEX" "Ocirc" )
    (#x0000d5 "LATIN CAPITAL LETTER O WITH TILDE"      "Otilde")
    (#x0000d6 "LATIN CAPITAL LETTER O WITH DIAERESIS"  "Ouml"  )
    (#x0000d7 "MULTIPLICATION SIGN"                    "times" )
    (#x0000d8 "LATIN CAPITAL LETTER O WITH STROKE"     "Oslash")
    (#x0000d9 "LATIN CAPITAL LETTER U WITH GRAVE"      "Ugrave")
    (#x0000da "LATIN CAPITAL LETTER U WITH ACUTE"      "Uacute")
    (#x0000db "LATIN CAPITAL LETTER U WITH CIRCUMFLEX" "Ucirc" )
    (#x0000dc "LATIN CAPITAL LETTER U WITH DIAERESIS"  "Uuml"  )
    (#x0000dd "LATIN CAPITAL LETTER Y WITH ACUTE"      "Yacute")
    (#x0000de "LATIN CAPITAL LETTER THORN"             "THORN" )
    (#x0000df "LATIN SMALL LETTER SHARP S"             "szlig" )
    (#x0000e0 "LATIN SMALL LETTER A WITH GRAVE"        "agrave")
    (#x0000e1 "LATIN SMALL LETTER A WITH ACUTE"        "aacute")
    (#x0000e2 "LATIN SMALL LETTER A WITH CIRCUMFLEX"   "acirc" )
    (#x0000e3 "LATIN SMALL LETTER A WITH TILDE"        "atilde")
    (#x0000e4 "LATIN SMALL LETTER A WITH DIAERESIS"    "auml"  )
    (#x0000e5 "LATIN SMALL LETTER A WITH RING ABOVE"   "aring" )
    (#x0000e6 "LATIN SMALL LETTER AE"                  "aelig" )
    (#x0000e7 "LATIN SMALL LETTER C WITH CEDILLA"      "ccedil")
    (#x0000e8 "LATIN SMALL LETTER E WITH GRAVE"        "egrave")
    (#x0000e9 "LATIN SMALL LETTER E WITH ACUTE"        "eacute")
    (#x0000ea "LATIN SMALL LETTER E WITH CIRCUMFLEX"   "ecirc" )
    (#x0000eb "LATIN SMALL LETTER E WITH DIAERESIS"    "euml"  )
    (#x0000ec "LATIN SMALL LETTER I WITH GRAVE"        "igrave")
    (#x0000ed "LATIN SMALL LETTER I WITH ACUTE"        "iacute")
    (#x0000ee "LATIN SMALL LETTER I WITH CIRCUMFLEX"   "icirc" )
    (#x0000ef "LATIN SMALL LETTER I WITH DIAERESIS"    "iuml"  )
    (#x0000f0 "LATIN SMALL LETTER ETH"                 "eth"   )
    (#x0000f1 "LATIN SMALL LETTER N WITH TILDE"        "ntilde")
    (#x0000f2 "LATIN SMALL LETTER O WITH GRAVE"        "ograve")
    (#x0000f3 "LATIN SMALL LETTER O WITH ACUTE"        "oacute")
    (#x0000f4 "LATIN SMALL LETTER O WITH CIRCUMFLEX"   "ocirc" )
    (#x0000f5 "LATIN SMALL LETTER O WITH TILDE"        "otilde")
    (#x0000f6 "LATIN SMALL LETTER O WITH DIAERESIS"    "ouml"  )
    (#x0000f7 "DIVISION SIGN"                          "divide")
    (#x0000f8 "LATIN SMALL LETTER O WITH STROKE"       "oslash")
    (#x0000f9 "LATIN SMALL LETTER U WITH GRAVE"        "ugrave")
    (#x0000fa "LATIN SMALL LETTER U WITH ACUTE"        "uacute")
    (#x0000fb "LATIN SMALL LETTER U WITH CIRCUMFLEX"   "ucirc" )
    (#x0000fc "LATIN SMALL LETTER U WITH DIAERESIS"    "uuml"  )
    (#x0000fd "LATIN SMALL LETTER Y WITH ACUTE"        "yacute")
    (#x0000fe "LATIN SMALL LETTER THORN"               "thorn" )
    (#x0000ff "LATIN SMALL LETTER Y WITH DIAERESIS"    "yuml"  )
    (#x000100 "LATIN CAPITAL LETTER A WITH MACRON"     "Amacr" )
    (#x000101 "LATIN SMALL LETTER A WITH MACRON"       "amacr" )
    (#x000102 "LATIN CAPITAL LETTER A WITH BREVE"      "Abreve")
    (#x000103 "LATIN SMALL LETTER A WITH BREVE"        "abreve")
    (#x000104 "LATIN CAPITAL LETTER A WITH OGONEK"     "Aogon" )
    (#x000105 "LATIN SMALL LETTER A WITH OGONEK"       "aogon" )
    (#x000106 "LATIN CAPITAL LETTER C WITH ACUTE"      "Cacute")
    (#x000107 "LATIN SMALL LETTER C WITH ACUTE"        "cacute")
    (#x000108 "LATIN CAPITAL LETTER C WITH CIRCUMFLEX" "Ccirc" )
    (#x000109 "LATIN SMALL LETTER C WITH CIRCUMFLEX"   "ccirc" )
    (#x00010a "LATIN CAPITAL LETTER C WITH DOT ABOVE"  "Cdot"  )
    (#x00010b "LATIN SMALL LETTER C WITH DOT ABOVE"    "cdot"  )
    (#x00010c "LATIN CAPITAL LETTER C WITH CARON"      "Ccaron")
    (#x00010d "LATIN SMALL LETTER C WITH CARON"        "ccaron")
    (#x00010e "LATIN CAPITAL LETTER D WITH CARON"      "Dcaron")
    (#x00010f "LATIN SMALL LETTER D WITH CARON"        "dcaron")
    (#x000110 "LATIN CAPITAL LETTER D WITH STROKE"     "Dstrok")
    (#x000111 "LATIN SMALL LETTER D WITH STROKE"       "dstrok")
    (#x000112 "LATIN CAPITAL LETTER E WITH MACRON"     "Emacr" )
    (#x000113 "LATIN SMALL LETTER E WITH MACRON"       "emacr" )
    (#x000114 "LATIN CAPITAL LETTER E WITH BREVE"      nil     )
    (#x000115 "LATIN SMALL LETTER E WITH BREVE"        nil     )
    (#x000116 "LATIN CAPITAL LETTER E WITH DOT ABOVE"  "Edot"  )
    (#x000117 "LATIN SMALL LETTER E WITH DOT ABOVE"    "edot"  )
    (#x000118 "LATIN CAPITAL LETTER E WITH OGONEK"     "Eogon" )
    (#x000119 "LATIN SMALL LETTER E WITH OGONEK"       "eogon" )
    (#x00011a "LATIN CAPITAL LETTER E WITH CARON"      "Ecaron")
    (#x00011b "LATIN SMALL LETTER E WITH CARON"        "ecaron")
    (#x00011c "LATIN CAPITAL LETTER G WITH CIRCUMFLEX" "Gcirc" )
    (#x00011d "LATIN SMALL LETTER G WITH CIRCUMFLEX"   "gcirc" )
    (#x00011e "LATIN CAPITAL LETTER G WITH BREVE"      "Gbreve")
    (#x00011f "LATIN SMALL LETTER G WITH BREVE"        "gbreve")
    (#x000120 "LATIN CAPITAL LETTER G WITH DOT ABOVE"  "Gdot"  )
    (#x000121 "LATIN SMALL LETTER G WITH DOT ABOVE"    "gdot"  )
    (#x000122 "LATIN CAPITAL LETTER G WITH CEDILLA"    "Gcedil")
    (#x000123 "LATIN SMALL LETTER G WITH CEDILLA"      nil     )
    (#x000124 "LATIN CAPITAL LETTER H WITH CIRCUMFLEX" "Hcirc" )
    (#x000125 "LATIN SMALL LETTER H WITH CIRCUMFLEX"   "hcirc" )
    (#x000126 "LATIN CAPITAL LETTER H WITH STROKE"     "Hstrok")
    (#x000127 "LATIN SMALL LETTER H WITH STROKE"       "hstrok")
    (#x000128 "LATIN CAPITAL LETTER I WITH TILDE"      "Itilde")
    (#x000129 "LATIN SMALL LETTER I WITH TILDE"        "itilde")
    (#x00012a "LATIN CAPITAL LETTER I WITH MACRON"     "Imacr" )
    (#x00012b "LATIN SMALL LETTER I WITH MACRON"       "imacr" )
    (#x00012c "LATIN CAPITAL LETTER I WITH BREVE"      nil     )
    (#x00012d "LATIN SMALL LETTER I WITH BREVE"        nil     )
    (#x00012e "LATIN CAPITAL LETTER I WITH OGONEK"     "Iogon" )
    (#x00012f "LATIN SMALL LETTER I WITH OGONEK"       "iogon" )
    (#x000130 "LATIN CAPITAL LETTER I WITH DOT ABOVE"  "Idot"  )
    (#x000131 "LATIN SMALL LETTER DOTLESS I"           "inodot")
    (#x000132 "LATIN CAPITAL LIGATURE IJ"              "IJlig" )
    (#x000133 "LATIN SMALL LIGATURE IJ"                "ijlig" )
    (#x000134 "LATIN CAPITAL LETTER J WITH CIRCUMFLEX" "Jcirc" )
    (#x000135 "LATIN SMALL LETTER J WITH CIRCUMFLEX"   "jcirc" )
    (#x000136 "LATIN CAPITAL LETTER K WITH CEDILLA"    "Kcedil")
    (#x000137 "LATIN SMALL LETTER K WITH CEDILLA"      "kcedil")
    (#x000138 "LATIN SMALL LETTER KRA"                 "kgreen")
    (#x000139 "LATIN CAPITAL LETTER L WITH ACUTE"      "Lacute")
    (#x00013a "LATIN SMALL LETTER L WITH ACUTE"        "lacute")
    (#x00013b "LATIN CAPITAL LETTER L WITH CEDILLA"    "Lcedil")
    (#x00013c "LATIN SMALL LETTER L WITH CEDILLA"      "lcedil")
    (#x00013d "LATIN CAPITAL LETTER L WITH CARON"      "Lcaron")
    (#x00013e "LATIN SMALL LETTER L WITH CARON"        "lcaron")
    (#x00013f "LATIN CAPITAL LETTER L WITH MIDDLE DOT" "Lmidot")
    (#x000140 "LATIN SMALL LETTER L WITH MIDDLE DOT"   "lmidot")
    (#x000141 "LATIN CAPITAL LETTER L WITH STROKE"     "Lstrok")
    (#x000142 "LATIN SMALL LETTER L WITH STROKE"       "lstrok")
    (#x000143 "LATIN CAPITAL LETTER N WITH ACUTE"      "Nacute")
    (#x000144 "LATIN SMALL LETTER N WITH ACUTE"        "nacute")
    (#x000145 "LATIN CAPITAL LETTER N WITH CEDILLA"    "Ncedil")
    (#x000146 "LATIN SMALL LETTER N WITH CEDILLA"      "ncedil")
    (#x000147 "LATIN CAPITAL LETTER N WITH CARON"      "Ncaron")
    (#x000148 "LATIN SMALL LETTER N WITH CARON"        "ncaron")
    (#x000149 "LATIN SMALL LETTER N PRECEDED BY APOSTROPHE" "napos" )
    (#x00014a "LATIN CAPITAL LETTER ENG"               "ENG"   )
    (#x00014b "LATIN SMALL LETTER ENG"                 "eng"   )
    (#x00014c "LATIN CAPITAL LETTER O WITH MACRON"     "Omacr" )
    (#x00014d "LATIN SMALL LETTER O WITH MACRON"       "omacr" )
    (#x00014e "LATIN CAPITAL LETTER O WITH BREVE"      nil     )
    (#x00014f "LATIN SMALL LETTER O WITH BREVE"        nil     )
    (#x000150 "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE" "Odblac")
    (#x000151 "LATIN SMALL LETTER O WITH DOUBLE ACUTE" "odblac")
    (#x000152 "LATIN CAPITAL LIGATURE OE"              "OElig" )
    (#x000153 "LATIN SMALL LIGATURE OE"                "oelig" )
    (#x000154 "LATIN CAPITAL LETTER R WITH ACUTE"      "Racute")
    (#x000155 "LATIN SMALL LETTER R WITH ACUTE"        "racute")
    (#x000156 "LATIN CAPITAL LETTER R WITH CEDILLA"    "Rcedil")
    (#x000157 "LATIN SMALL LETTER R WITH CEDILLA"      "rcedil")
    (#x000158 "LATIN CAPITAL LETTER R WITH CARON"      "Rcaron")
    (#x000159 "LATIN SMALL LETTER R WITH CARON"        "rcaron")
    (#x00015a "LATIN CAPITAL LETTER S WITH ACUTE"      "Sacute")
    (#x00015b "LATIN SMALL LETTER S WITH ACUTE"        "sacute")
    (#x00015c "LATIN CAPITAL LETTER S WITH CIRCUMFLEX" "Scirc" )
    (#x00015d "LATIN SMALL LETTER S WITH CIRCUMFLEX"   "scirc" )
    (#x00015e "LATIN CAPITAL LETTER S WITH CEDILLA"    "Scedil")
    (#x00015f "LATIN SMALL LETTER S WITH CEDILLA"      "scedil")
    (#x000160 "LATIN CAPITAL LETTER S WITH CARON"      "Scaron")
    (#x000161 "LATIN SMALL LETTER S WITH CARON"        "scaron")
    (#x000162 "LATIN CAPITAL LETTER T WITH CEDILLA"    "Tcedil")
    (#x000163 "LATIN SMALL LETTER T WITH CEDILLA"      "tcedil")
    (#x000164 "LATIN CAPITAL LETTER T WITH CARON"      "Tcaron")
    (#x000165 "LATIN SMALL LETTER T WITH CARON"        "tcaron")
    (#x000166 "LATIN CAPITAL LETTER T WITH STROKE"     "Tstrok")
    (#x000167 "LATIN SMALL LETTER T WITH STROKE"       "tstrok")
    (#x000168 "LATIN CAPITAL LETTER U WITH TILDE"      "Utilde")
    (#x000169 "LATIN SMALL LETTER U WITH TILDE"        "utilde")
    (#x00016a "LATIN CAPITAL LETTER U WITH MACRON"     "Umacr" )
    (#x00016b "LATIN SMALL LETTER U WITH MACRON"       "umacr" )
    (#x00016c "LATIN CAPITAL LETTER U WITH BREVE"      "Ubreve")
    (#x00016d "LATIN SMALL LETTER U WITH BREVE"        "ubreve")
    (#x00016e "LATIN CAPITAL LETTER U WITH RING ABOVE" "Uring" )
    (#x00016f "LATIN SMALL LETTER U WITH RING ABOVE"   "uring" )
    (#x000170 "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE" "Udblac")
    (#x000171 "LATIN SMALL LETTER U WITH DOUBLE ACUTE" "udblac")
    (#x000172 "LATIN CAPITAL LETTER U WITH OGONEK"     "Uogon" )
    (#x000173 "LATIN SMALL LETTER U WITH OGONEK"       "uogon" )
    (#x000174 "LATIN CAPITAL LETTER W WITH CIRCUMFLEX" "Wcirc" )
    (#x000175 "LATIN SMALL LETTER W WITH CIRCUMFLEX"   "wcirc" )
    (#x000176 "LATIN CAPITAL LETTER Y WITH CIRCUMFLEX" "Ycirc" )
    (#x000177 "LATIN SMALL LETTER Y WITH CIRCUMFLEX"   "ycirc" )
    (#x000178 "LATIN CAPITAL LETTER Y WITH DIAERESIS"  "Yuml"  )
    (#x000179 "LATIN CAPITAL LETTER Z WITH ACUTE"      "Zacute")
    (#x00017a "LATIN SMALL LETTER Z WITH ACUTE"        "zacute")
    (#x00017b "LATIN CAPITAL LETTER Z WITH DOT ABOVE"  "Zdot"  )
    (#x00017c "LATIN SMALL LETTER Z WITH DOT ABOVE"    "zdot"  )
    (#x00017d "LATIN CAPITAL LETTER Z WITH CARON"      "Zcaron")
    (#x00017e "LATIN SMALL LETTER Z WITH CARON"        "zcaron")
    (#x00017f "LATIN SMALL LETTER LONG S"              nil     )
    (#x000180 "LATIN SMALL LETTER B WITH STROKE"       nil     )
    (#x000181 "LATIN CAPITAL LETTER B WITH HOOK"       nil     )
    (#x000182 "LATIN CAPITAL LETTER B WITH TOPBAR"     nil     )
    (#x000183 "LATIN SMALL LETTER B WITH TOPBAR"       nil     )
    (#x000184 "LATIN CAPITAL LETTER TONE SIX"          nil     )
    (#x000185 "LATIN SMALL LETTER TONE SIX"            nil     )
    (#x000186 "LATIN CAPITAL LETTER OPEN O"            nil     )
    (#x000187 "LATIN CAPITAL LETTER C WITH HOOK"       nil     )
    (#x000188 "LATIN SMALL LETTER C WITH HOOK"         nil     )
    (#x000189 "LATIN CAPITAL LETTER AFRICAN D"         nil     )
    (#x00018a "LATIN CAPITAL LETTER D WITH HOOK"       nil     )
    (#x00018b "LATIN CAPITAL LETTER D WITH TOPBAR"     nil     )
    (#x00018c "LATIN SMALL LETTER D WITH TOPBAR"       nil     )
    (#x00018d "LATIN SMALL LETTER TURNED DELTA"        nil     )
    (#x00018e "LATIN CAPITAL LETTER REVERSED E"        nil     )
    (#x00018f "LATIN CAPITAL LETTER SCHWA"             nil     )
    (#x000190 "LATIN CAPITAL LETTER OPEN E"            nil     )
    (#x000191 "LATIN CAPITAL LETTER F WITH HOOK"       nil     )
    (#x000192 "LATIN SMALL LETTER F WITH HOOK"         "fnof"  )
    (#x000193 "LATIN CAPITAL LETTER G WITH HOOK"       nil     )
    (#x000194 "LATIN CAPITAL LETTER GAMMA"             nil     )
    (#x000195 "LATIN SMALL LETTER HV"                  nil     )
    (#x000196 "LATIN CAPITAL LETTER IOTA"              nil     )
    (#x000197 "LATIN CAPITAL LETTER I WITH STROKE"     nil     )
    (#x000198 "LATIN CAPITAL LETTER K WITH HOOK"       nil     )
    (#x000199 "LATIN SMALL LETTER K WITH HOOK"         nil     )
    (#x00019a "LATIN SMALL LETTER L WITH BAR"          nil     )
    (#x00019b "LATIN SMALL LETTER LAMBDA WITH STROKE"  nil     )
    (#x00019c "LATIN CAPITAL LETTER TURNED M"          nil     )
    (#x00019d "LATIN CAPITAL LETTER N WITH LEFT HOOK"  nil     )
    (#x00019e "LATIN SMALL LETTER N WITH LONG RIGHT LEG" nil     )
    (#x00019f "LATIN CAPITAL LETTER O WITH MIDDLE TILDE" nil     )
    (#x0001a0 "LATIN CAPITAL LETTER O WITH HORN"       nil     )
    (#x0001a1 "LATIN SMALL LETTER O WITH HORN"         nil     )
    (#x0001a2 "LATIN CAPITAL LETTER OI"                nil     )
    (#x0001a3 "LATIN SMALL LETTER OI"                  nil     )
    (#x0001a4 "LATIN CAPITAL LETTER P WITH HOOK"       nil     )
    (#x0001a5 "LATIN SMALL LETTER P WITH HOOK"         nil     )
    (#x0001a6 "LATIN LETTER YR"                        nil     )
    (#x0001a7 "LATIN CAPITAL LETTER TONE TWO"          nil     )
    (#x0001a8 "LATIN SMALL LETTER TONE TWO"            nil     )
    (#x0001a9 "LATIN CAPITAL LETTER ESH"               nil     )
    (#x0001aa "LATIN LETTER REVERSED ESH LOOP"         nil     )
    (#x0001ab "LATIN SMALL LETTER T WITH PALATAL HOOK" nil     )
    (#x0001ac "LATIN CAPITAL LETTER T WITH HOOK"       nil     )
    (#x0001ad "LATIN SMALL LETTER T WITH HOOK"         nil     )
    (#x0001ae "LATIN CAPITAL LETTER T WITH RETROFLEX HOOK" nil     )
    (#x0001af "LATIN CAPITAL LETTER U WITH HORN"       nil     )
    (#x0001b0 "LATIN SMALL LETTER U WITH HORN"         nil     )
    (#x0001b1 "LATIN CAPITAL LETTER UPSILON"           nil     )
    (#x0001b2 "LATIN CAPITAL LETTER V WITH HOOK"       nil     )
    (#x0001b3 "LATIN CAPITAL LETTER Y WITH HOOK"       nil     )
    (#x0001b4 "LATIN SMALL LETTER Y WITH HOOK"         nil     )
    (#x0001b5 "LATIN CAPITAL LETTER Z WITH STROKE"     nil     )
    (#x0001b6 "LATIN SMALL LETTER Z WITH STROKE"       nil     )
    (#x0001b7 "LATIN CAPITAL LETTER EZH"               nil     )
    (#x0001b8 "LATIN CAPITAL LETTER EZH REVERSED"      nil     )
    (#x0001b9 "LATIN SMALL LETTER EZH REVERSED"        nil     )
    (#x0001ba "LATIN SMALL LETTER EZH WITH TAIL"       nil     )
    (#x0001bb "LATIN LETTER TWO WITH STROKE"           nil     )
    (#x0001bc "LATIN CAPITAL LETTER TONE FIVE"         nil     )
    (#x0001bd "LATIN SMALL LETTER TONE FIVE"           nil     )
    (#x0001be "LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE" nil     )
    (#x0001bf "LATIN LETTER WYNN"                      nil     )
    (#x0001c0 "LATIN LETTER DENTAL CLICK"              nil     )
    (#x0001c1 "LATIN LETTER LATERAL CLICK"             nil     )
    (#x0001c2 "LATIN LETTER ALVEOLAR CLICK"            nil     )
    (#x0001c3 "LATIN LETTER RETROFLEX CLICK"           nil     )
    (#x0001c4 "LATIN CAPITAL LETTER DZ WITH CARON"     nil     )
    (#x0001c5 "LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON" nil     )
    (#x0001c6 "LATIN SMALL LETTER DZ WITH CARON"       nil     )
    (#x0001c7 "LATIN CAPITAL LETTER LJ"                nil     )
    (#x0001c8 "LATIN CAPITAL LETTER L WITH SMALL LETTER J" nil     )
    (#x0001c9 "LATIN SMALL LETTER LJ"                  nil     )
    (#x0001ca "LATIN CAPITAL LETTER NJ"                nil     )
    (#x0001cb "LATIN CAPITAL LETTER N WITH SMALL LETTER J" nil     )
    (#x0001cc "LATIN SMALL LETTER NJ"                  nil     )
    (#x0001cd "LATIN CAPITAL LETTER A WITH CARON"      nil     )
    (#x0001ce "LATIN SMALL LETTER A WITH CARON"        nil     )
    (#x0001cf "LATIN CAPITAL LETTER I WITH CARON"      nil     )
    (#x0001d0 "LATIN SMALL LETTER I WITH CARON"        nil     )
    (#x0001d1 "LATIN CAPITAL LETTER O WITH CARON"      nil     )
    (#x0001d2 "LATIN SMALL LETTER O WITH CARON"        nil     )
    (#x0001d3 "LATIN CAPITAL LETTER U WITH CARON"      nil     )
    (#x0001d4 "LATIN SMALL LETTER U WITH CARON"        nil     )
    (#x0001d5 "LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON" nil     )
    (#x0001d6 "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON" nil     )
    (#x0001d7 "LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE" nil     )
    (#x0001d8 "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE" nil     )
    (#x0001d9 "LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON" nil     )
    (#x0001da "LATIN SMALL LETTER U WITH DIAERESIS AND CARON" nil     )
    (#x0001db "LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE" nil     )
    (#x0001dc "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE" nil     )
    (#x0001dd "LATIN SMALL LETTER TURNED E"            nil     )
    (#x0001de "LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON" nil     )
    (#x0001df "LATIN SMALL LETTER A WITH DIAERESIS AND MACRON" nil     )
    (#x0001e0 "LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON" nil     )
    (#x0001e1 "LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON" nil     )
    (#x0001e2 "LATIN CAPITAL LETTER AE WITH MACRON"    nil     )
    (#x0001e3 "LATIN SMALL LETTER AE WITH MACRON"      nil     )
    (#x0001e4 "LATIN CAPITAL LETTER G WITH STROKE"     nil     )
    (#x0001e5 "LATIN SMALL LETTER G WITH STROKE"       nil     )
    (#x0001e6 "LATIN CAPITAL LETTER G WITH CARON"      nil     )
    (#x0001e7 "LATIN SMALL LETTER G WITH CARON"        nil     )
    (#x0001e8 "LATIN CAPITAL LETTER K WITH CARON"      nil     )
    (#x0001e9 "LATIN SMALL LETTER K WITH CARON"        nil     )
    (#x0001ea "LATIN CAPITAL LETTER O WITH OGONEK"     nil     )
    (#x0001eb "LATIN SMALL LETTER O WITH OGONEK"       nil     )
    (#x0001ec "LATIN CAPITAL LETTER O WITH OGONEK AND MACRON" nil     )
    (#x0001ed "LATIN SMALL LETTER O WITH OGONEK AND MACRON" nil     )
    (#x0001ee "LATIN CAPITAL LETTER EZH WITH CARON"    nil     )
    (#x0001ef "LATIN SMALL LETTER EZH WITH CARON"      nil     )
    (#x0001f0 "LATIN SMALL LETTER J WITH CARON"        nil     )
    (#x0001f1 "LATIN CAPITAL LETTER DZ"                nil     )
    (#x0001f2 "LATIN CAPITAL LETTER D WITH SMALL LETTER Z" nil     )
    (#x0001f3 "LATIN SMALL LETTER DZ"                  nil     )
    (#x0001f4 "LATIN CAPITAL LETTER G WITH ACUTE"      nil     )
    (#x0001f5 "LATIN SMALL LETTER G WITH ACUTE"        "gacute")
    (#x0001f6 "LATIN CAPITAL LETTER HWAIR"             nil     )
    (#x0001f7 "LATIN CAPITAL LETTER WYNN"              nil     )
    (#x0001f8 "LATIN CAPITAL LETTER N WITH GRAVE"      nil     )
    (#x0001f9 "LATIN SMALL LETTER N WITH GRAVE"        nil     )
    (#x0001fa "LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE" nil     )
    (#x0001fb "LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE" nil     )
    (#x0001fc "LATIN CAPITAL LETTER AE WITH ACUTE"     nil     )
    (#x0001fd "LATIN SMALL LETTER AE WITH ACUTE"       nil     )
    (#x0001fe "LATIN CAPITAL LETTER O WITH STROKE AND ACUTE" nil     )
    (#x0001ff "LATIN SMALL LETTER O WITH STROKE AND ACUTE" nil     )
    (#x000200 "LATIN CAPITAL LETTER A WITH DOUBLE GRAVE" nil     )
    (#x000201 "LATIN SMALL LETTER A WITH DOUBLE GRAVE" nil     )
    (#x000202 "LATIN CAPITAL LETTER A WITH INVERTED BREVE" nil     )
    (#x000203 "LATIN SMALL LETTER A WITH INVERTED BREVE" nil     )
    (#x000204 "LATIN CAPITAL LETTER E WITH DOUBLE GRAVE" nil     )
    (#x000205 "LATIN SMALL LETTER E WITH DOUBLE GRAVE" nil     )
    (#x000206 "LATIN CAPITAL LETTER E WITH INVERTED BREVE" nil     )
    (#x000207 "LATIN SMALL LETTER E WITH INVERTED BREVE" nil     )
    (#x000208 "LATIN CAPITAL LETTER I WITH DOUBLE GRAVE" nil     )
    (#x000209 "LATIN SMALL LETTER I WITH DOUBLE GRAVE" nil     )
    (#x00020a "LATIN CAPITAL LETTER I WITH INVERTED BREVE" nil     )
    (#x00020b "LATIN SMALL LETTER I WITH INVERTED BREVE" nil     )
    (#x00020c "LATIN CAPITAL LETTER O WITH DOUBLE GRAVE" nil     )
    (#x00020d "LATIN SMALL LETTER O WITH DOUBLE GRAVE" nil     )
    (#x00020e "LATIN CAPITAL LETTER O WITH INVERTED BREVE" nil     )
    (#x00020f "LATIN SMALL LETTER O WITH INVERTED BREVE" nil     )
    (#x000210 "LATIN CAPITAL LETTER R WITH DOUBLE GRAVE" nil     )
    (#x000211 "LATIN SMALL LETTER R WITH DOUBLE GRAVE" nil     )
    (#x000212 "LATIN CAPITAL LETTER R WITH INVERTED BREVE" nil     )
    (#x000213 "LATIN SMALL LETTER R WITH INVERTED BREVE" nil     )
    (#x000214 "LATIN CAPITAL LETTER U WITH DOUBLE GRAVE" nil     )
    (#x000215 "LATIN SMALL LETTER U WITH DOUBLE GRAVE" nil     )
    (#x000216 "LATIN CAPITAL LETTER U WITH INVERTED BREVE" nil     )
    (#x000217 "LATIN SMALL LETTER U WITH INVERTED BREVE" nil     )
    (#x000218 "LATIN CAPITAL LETTER S WITH COMMA BELOW" nil     )
    (#x000219 "LATIN SMALL LETTER S WITH COMMA BELOW"  nil     )
    (#x00021a "LATIN CAPITAL LETTER T WITH COMMA BELOW" nil     )
    (#x00021b "LATIN SMALL LETTER T WITH COMMA BELOW"  nil     )
    (#x00021c "LATIN CAPITAL LETTER YOGH"              nil     )
    (#x00021d "LATIN SMALL LETTER YOGH"                nil     )
    (#x00021e "LATIN CAPITAL LETTER H WITH CARON"      nil     )
    (#x00021f "LATIN SMALL LETTER H WITH CARON"        nil     )
    (#x000220 "LATIN CAPITAL LETTER N WITH LONG RIGHT LEG" nil     )
    (#x000221 "LATIN SMALL LETTER D WITH CURL"         nil     )
    (#x000222 "LATIN CAPITAL LETTER OU"                nil     )
    (#x000223 "LATIN SMALL LETTER OU"                  nil     )
    (#x000224 "LATIN CAPITAL LETTER Z WITH HOOK"       nil     )
    (#x000225 "LATIN SMALL LETTER Z WITH HOOK"         nil     )
    (#x000226 "LATIN CAPITAL LETTER A WITH DOT ABOVE"  nil     )
    (#x000227 "LATIN SMALL LETTER A WITH DOT ABOVE"    nil     )
    (#x000228 "LATIN CAPITAL LETTER E WITH CEDILLA"    nil     )
    (#x000229 "LATIN SMALL LETTER E WITH CEDILLA"      nil     )
    (#x00022a "LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON" nil     )
    (#x00022b "LATIN SMALL LETTER O WITH DIAERESIS AND MACRON" nil     )
    (#x00022c "LATIN CAPITAL LETTER O WITH TILDE AND MACRON" nil     )
    (#x00022d "LATIN SMALL LETTER O WITH TILDE AND MACRON" nil     )
    (#x00022e "LATIN CAPITAL LETTER O WITH DOT ABOVE"  nil     )
    (#x00022f "LATIN SMALL LETTER O WITH DOT ABOVE"    nil     )
    (#x000230 "LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON" nil     )
    (#x000231 "LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON" nil     )
    (#x000232 "LATIN CAPITAL LETTER Y WITH MACRON"     nil     )
    (#x000233 "LATIN SMALL LETTER Y WITH MACRON"       nil     )
    (#x000234 "LATIN SMALL LETTER L WITH CURL"         nil     )
    (#x000235 "LATIN SMALL LETTER N WITH CURL"         nil     )
    (#x000236 "LATIN SMALL LETTER T WITH CURL"         nil     )
    (#x000237 "LATIN SMALL LETTER DOTLESS J"           nil     )
    (#x000238 "LATIN SMALL LETTER DB DIGRAPH"          nil     )
    (#x000239 "LATIN SMALL LETTER QP DIGRAPH"          nil     )
    (#x00023a "LATIN CAPITAL LETTER A WITH STROKE"     nil     )
    (#x00023b "LATIN CAPITAL LETTER C WITH STROKE"     nil     )
    (#x00023c "LATIN SMALL LETTER C WITH STROKE"       nil     )
    (#x00023d "LATIN CAPITAL LETTER L WITH BAR"        nil     )
    (#x00023e "LATIN CAPITAL LETTER T WITH DIAGONAL STROKE" nil     )
    (#x00023f "LATIN SMALL LETTER S WITH SWASH TAIL"   nil     )
    (#x000240 "LATIN SMALL LETTER Z WITH SWASH TAIL"   nil     )
    (#x000241 "LATIN CAPITAL LETTER GLOTTAL STOP"      nil     )
    (#x000242 "LATIN SMALL LETTER GLOTTAL STOP"        nil     )
    (#x000243 "LATIN CAPITAL LETTER B WITH STROKE"     nil     )
    (#x000244 "LATIN CAPITAL LETTER U BAR"             nil     )
    (#x000245 "LATIN CAPITAL LETTER TURNED V"          nil     )
    (#x000246 "LATIN CAPITAL LETTER E WITH STROKE"     nil     )
    (#x000247 "LATIN SMALL LETTER E WITH STROKE"       nil     )
    (#x000248 "LATIN CAPITAL LETTER J WITH STROKE"     nil     )
    (#x000249 "LATIN SMALL LETTER J WITH STROKE"       nil     )
    (#x00024a "LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL" nil     )
    (#x00024b "LATIN SMALL LETTER Q WITH HOOK TAIL"    nil     )
    (#x00024c "LATIN CAPITAL LETTER R WITH STROKE"     nil     )
    (#x00024d "LATIN SMALL LETTER R WITH STROKE"       nil     )
    (#x00024e "LATIN CAPITAL LETTER Y WITH STROKE"     nil     )
    (#x00024f "LATIN SMALL LETTER Y WITH STROKE"       nil     )
    (#x000250 "LATIN SMALL LETTER TURNED A"            nil     )
    (#x000251 "LATIN SMALL LETTER ALPHA"               nil     )
    (#x000252 "LATIN SMALL LETTER TURNED ALPHA"        nil     )
    (#x000253 "LATIN SMALL LETTER B WITH HOOK"         nil     )
    (#x000254 "LATIN SMALL LETTER OPEN O"              nil     )
    (#x000255 "LATIN SMALL LETTER C WITH CURL"         nil     )
    (#x000256 "LATIN SMALL LETTER D WITH TAIL"         nil     )
    (#x000257 "LATIN SMALL LETTER D WITH HOOK"         nil     )
    (#x000258 "LATIN SMALL LETTER REVERSED E"          nil     )
    (#x000259 "LATIN SMALL LETTER SCHWA"               nil     )
    (#x00025a "LATIN SMALL LETTER SCHWA WITH HOOK"     nil     )
    (#x00025b "LATIN SMALL LETTER OPEN E"              "epsiv" )
    (#x00025c "LATIN SMALL LETTER REVERSED OPEN E"     nil     )
    (#x00025d "LATIN SMALL LETTER REVERSED OPEN E WITH HOOK" nil     )
    (#x00025e "LATIN SMALL LETTER CLOSED REVERSED OPEN E" nil     )
    (#x00025f "LATIN SMALL LETTER DOTLESS J WITH STROKE" nil     )
    (#x000260 "LATIN SMALL LETTER G WITH HOOK"         nil     )
    (#x000261 "LATIN SMALL LETTER SCRIPT G"            nil     )
    (#x000262 "LATIN LETTER SMALL CAPITAL G"           nil     )
    (#x000263 "LATIN SMALL LETTER GAMMA"               nil     )
    (#x000264 "LATIN SMALL LETTER RAMS HORN"           nil     )
    (#x000265 "LATIN SMALL LETTER TURNED H"            nil     )
    (#x000266 "LATIN SMALL LETTER H WITH HOOK"         nil     )
    (#x000267 "LATIN SMALL LETTER HENG WITH HOOK"      nil     )
    (#x000268 "LATIN SMALL LETTER I WITH STROKE"       nil     )
    (#x000269 "LATIN SMALL LETTER IOTA"                nil     )
    (#x00026a "LATIN LETTER SMALL CAPITAL I"           nil     )
    (#x00026b "LATIN SMALL LETTER L WITH MIDDLE TILDE" nil     )
    (#x00026c "LATIN SMALL LETTER L WITH BELT"         nil     )
    (#x00026d "LATIN SMALL LETTER L WITH RETROFLEX HOOK" nil     )
    (#x00026e "LATIN SMALL LETTER LEZH"                nil     )
    (#x00026f "LATIN SMALL LETTER TURNED M"            nil     )
    (#x000270 "LATIN SMALL LETTER TURNED M WITH LONG LEG" nil     )
    (#x000271 "LATIN SMALL LETTER M WITH HOOK"         nil     )
    (#x000272 "LATIN SMALL LETTER N WITH LEFT HOOK"    nil     )
    (#x000273 "LATIN SMALL LETTER N WITH RETROFLEX HOOK" nil     )
    (#x000274 "LATIN LETTER SMALL CAPITAL N"           nil     )
    (#x000275 "LATIN SMALL LETTER BARRED O"            nil     )
    (#x000276 "LATIN LETTER SMALL CAPITAL OE"          nil     )
    (#x000277 "LATIN SMALL LETTER CLOSED OMEGA"        nil     )
    (#x000278 "LATIN SMALL LETTER PHI"                 nil     )
    (#x000279 "LATIN SMALL LETTER TURNED R"            nil     )
    (#x00027a "LATIN SMALL LETTER TURNED R WITH LONG LEG" nil     )
    (#x00027b "LATIN SMALL LETTER TURNED R WITH HOOK"  nil     )
    (#x00027c "LATIN SMALL LETTER R WITH LONG LEG"     nil     )
    (#x00027d "LATIN SMALL LETTER R WITH TAIL"         nil     )
    (#x00027e "LATIN SMALL LETTER R WITH FISHHOOK"     nil     )
    (#x00027f "LATIN SMALL LETTER REVERSED R WITH FISHHOOK" nil     )
    (#x000280 "LATIN LETTER SMALL CAPITAL R"           nil     )
    (#x000281 "LATIN LETTER SMALL CAPITAL INVERTED R"  nil     )
    (#x000282 "LATIN SMALL LETTER S WITH HOOK"         nil     )
    (#x000283 "LATIN SMALL LETTER ESH"                 nil     )
    (#x000284 "LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK" nil     )
    (#x000285 "LATIN SMALL LETTER SQUAT REVERSED ESH"  nil     )
    (#x000286 "LATIN SMALL LETTER ESH WITH CURL"       nil     )
    (#x000287 "LATIN SMALL LETTER TURNED T"            nil     )
    (#x000288 "LATIN SMALL LETTER T WITH RETROFLEX HOOK" nil     )
    (#x000289 "LATIN SMALL LETTER U BAR"               nil     )
    (#x00028a "LATIN SMALL LETTER UPSILON"             nil     )
    (#x00028b "LATIN SMALL LETTER V WITH HOOK"         nil     )
    (#x00028c "LATIN SMALL LETTER TURNED V"            nil     )
    (#x00028d "LATIN SMALL LETTER TURNED W"            nil     )
    (#x00028e "LATIN SMALL LETTER TURNED Y"            nil     )
    (#x00028f "LATIN LETTER SMALL CAPITAL Y"           nil     )
    (#x000290 "LATIN SMALL LETTER Z WITH RETROFLEX HOOK" nil     )
    (#x000291 "LATIN SMALL LETTER Z WITH CURL"         nil     )
    (#x000292 "LATIN SMALL LETTER EZH"                 nil     )
    (#x000293 "LATIN SMALL LETTER EZH WITH CURL"       nil     )
    (#x000294 "LATIN LETTER GLOTTAL STOP"              nil     )
    (#x000295 "LATIN LETTER PHARYNGEAL VOICED FRICATIVE" nil     )
    (#x000296 "LATIN LETTER INVERTED GLOTTAL STOP"     nil     )
    (#x000297 "LATIN LETTER STRETCHED C"               nil     )
    (#x000298 "LATIN LETTER BILABIAL CLICK"            nil     )
    (#x000299 "LATIN LETTER SMALL CAPITAL B"           nil     )
    (#x00029a "LATIN SMALL LETTER CLOSED OPEN E"       nil     )
    (#x00029b "LATIN LETTER SMALL CAPITAL G WITH HOOK" nil     )
    (#x00029c "LATIN LETTER SMALL CAPITAL H"           nil     )
    (#x00029d "LATIN SMALL LETTER J WITH CROSSED-TAIL" nil     )
    (#x00029e "LATIN SMALL LETTER TURNED K"            nil     )
    (#x00029f "LATIN LETTER SMALL CAPITAL L"           nil     )
    (#x0002a0 "LATIN SMALL LETTER Q WITH HOOK"         nil     )
    (#x0002a1 "LATIN LETTER GLOTTAL STOP WITH STROKE"  nil     )
    (#x0002a2 "LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE" nil     )
    (#x0002a3 "LATIN SMALL LETTER DZ DIGRAPH"          nil     )
    (#x0002a4 "LATIN SMALL LETTER DEZH DIGRAPH"        nil     )
    (#x0002a5 "LATIN SMALL LETTER DZ DIGRAPH WITH CURL" nil     )
    (#x0002a6 "LATIN SMALL LETTER TS DIGRAPH"          nil     )
    (#x0002a7 "LATIN SMALL LETTER TESH DIGRAPH"        nil     )
    (#x0002a8 "LATIN SMALL LETTER TC DIGRAPH WITH CURL" nil     )
    (#x0002a9 "LATIN SMALL LETTER FENG DIGRAPH"        nil     )
    (#x0002aa "LATIN SMALL LETTER LS DIGRAPH"          nil     )
    (#x0002ab "LATIN SMALL LETTER LZ DIGRAPH"          nil     )
    (#x0002ac "LATIN LETTER BILABIAL PERCUSSIVE"       nil     )
    (#x0002ad "LATIN LETTER BIDENTAL PERCUSSIVE"       nil     )
    (#x0002ae "LATIN SMALL LETTER TURNED H WITH FISHHOOK" nil     )
    (#x0002af "LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL" nil     )
    (#x0002b0 "MODIFIER LETTER SMALL H"                nil     )
    (#x0002b1 "MODIFIER LETTER SMALL H WITH HOOK"      nil     )
    (#x0002b2 "MODIFIER LETTER SMALL J"                nil     )
    (#x0002b3 "MODIFIER LETTER SMALL R"                nil     )
    (#x0002b4 "MODIFIER LETTER SMALL TURNED R"         nil     )
    (#x0002b5 "MODIFIER LETTER SMALL TURNED R WITH HOOK" nil     )
    (#x0002b6 "MODIFIER LETTER SMALL CAPITAL INVERTED R" nil     )
    (#x0002b7 "MODIFIER LETTER SMALL W"                nil     )
    (#x0002b8 "MODIFIER LETTER SMALL Y"                nil     )
    (#x0002b9 "MODIFIER LETTER PRIME"                  nil     )
    (#x0002ba "MODIFIER LETTER DOUBLE PRIME"           nil     )
    (#x0002bb "MODIFIER LETTER TURNED COMMA"           nil     )
    (#x0002bc "MODIFIER LETTER APOSTROPHE"             nil     )
    (#x0002bd "MODIFIER LETTER REVERSED COMMA"         nil     )
    (#x0002be "MODIFIER LETTER RIGHT HALF RING"        nil     )
    (#x0002bf "MODIFIER LETTER LEFT HALF RING"         nil     )
    (#x0002c0 "MODIFIER LETTER GLOTTAL STOP"           nil     )
    (#x0002c1 "MODIFIER LETTER REVERSED GLOTTAL STOP"  nil     )
    (#x0002c2 "MODIFIER LETTER LEFT ARROWHEAD"         nil     )
    (#x0002c3 "MODIFIER LETTER RIGHT ARROWHEAD"        nil     )
    (#x0002c4 "MODIFIER LETTER UP ARROWHEAD"           nil     )
    (#x0002c5 "MODIFIER LETTER DOWN ARROWHEAD"         nil     )
    (#x0002c6 "MODIFIER LETTER CIRCUMFLEX ACCENT"      "circ"  )
    (#x0002c7 "CARON"                                  "caron" )
    (#x0002c8 "MODIFIER LETTER VERTICAL LINE"          nil     )
    (#x0002c9 "MODIFIER LETTER MACRON"                 nil     )
    (#x0002ca "MODIFIER LETTER ACUTE ACCENT"           nil     )
    (#x0002cb "MODIFIER LETTER GRAVE ACCENT"           nil     )
    (#x0002cc "MODIFIER LETTER LOW VERTICAL LINE"      nil     )
    (#x0002cd "MODIFIER LETTER LOW MACRON"             nil     )
    (#x0002ce "MODIFIER LETTER LOW GRAVE ACCENT"       nil     )
    (#x0002cf "MODIFIER LETTER LOW ACUTE ACCENT"       nil     )
    (#x0002d0 "MODIFIER LETTER TRIANGULAR COLON"       nil     )
    (#x0002d1 "MODIFIER LETTER HALF TRIANGULAR COLON"  nil     )
    (#x0002d2 "MODIFIER LETTER CENTRED RIGHT HALF RING" nil     )
    (#x0002d3 "MODIFIER LETTER CENTRED LEFT HALF RING" nil     )
    (#x0002d4 "MODIFIER LETTER UP TACK"                nil     )
    (#x0002d5 "MODIFIER LETTER DOWN TACK"              nil     )
    (#x0002d6 "MODIFIER LETTER PLUS SIGN"              nil     )
    (#x0002d7 "MODIFIER LETTER MINUS SIGN"             nil     )
    (#x0002d8 "BREVE"                                  "breve" )
    (#x0002d9 "DOT ABOVE"                              "dot"   )
    (#x0002da "RING ABOVE"                             "ring"  )
    (#x0002db "OGONEK"                                 "ogon"  )
    (#x0002dc "SMALL TILDE"                            "tilde" )
    (#x0002dd "DOUBLE ACUTE ACCENT"                    "dblac" )
    (#x0002de "MODIFIER LETTER RHOTIC HOOK"            nil     )
    (#x0002df "MODIFIER LETTER CROSS ACCENT"           nil     )
    (#x0002e0 "MODIFIER LETTER SMALL GAMMA"            nil     )
    (#x0002e1 "MODIFIER LETTER SMALL L"                nil     )
    (#x0002e2 "MODIFIER LETTER SMALL S"                nil     )
    (#x0002e3 "MODIFIER LETTER SMALL X"                nil     )
    (#x0002e4 "MODIFIER LETTER SMALL REVERSED GLOTTAL STOP" nil     )
    (#x0002e5 "MODIFIER LETTER EXTRA-HIGH TONE BAR"    nil     )
    (#x0002e6 "MODIFIER LETTER HIGH TONE BAR"          nil     )
    (#x0002e7 "MODIFIER LETTER MID TONE BAR"           nil     )
    (#x0002e8 "MODIFIER LETTER LOW TONE BAR"           nil     )
    (#x0002e9 "MODIFIER LETTER EXTRA-LOW TONE BAR"     nil     )
    (#x0002ea "MODIFIER LETTER YIN DEPARTING TONE MARK" nil     )
    (#x0002eb "MODIFIER LETTER YANG DEPARTING TONE MARK" nil     )
    (#x0002ec "MODIFIER LETTER VOICING"                nil     )
    (#x0002ed "MODIFIER LETTER UNASPIRATED"            nil     )
    (#x0002ee "MODIFIER LETTER DOUBLE APOSTROPHE"      nil     )
    (#x0002ef "MODIFIER LETTER LOW DOWN ARROWHEAD"     nil     )
    (#x0002f0 "MODIFIER LETTER LOW UP ARROWHEAD"       nil     )
    (#x0002f1 "MODIFIER LETTER LOW LEFT ARROWHEAD"     nil     )
    (#x0002f2 "MODIFIER LETTER LOW RIGHT ARROWHEAD"    nil     )
    (#x0002f3 "MODIFIER LETTER LOW RING"               nil     )
    (#x0002f4 "MODIFIER LETTER MIDDLE GRAVE ACCENT"    nil     )
    (#x0002f5 "MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT" nil     )
    (#x0002f6 "MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT" nil     )
    (#x0002f7 "MODIFIER LETTER LOW TILDE"              nil     )
    (#x0002f8 "MODIFIER LETTER RAISED COLON"           nil     )
    (#x0002f9 "MODIFIER LETTER BEGIN HIGH TONE"        nil     )
    (#x0002fa "MODIFIER LETTER END HIGH TONE"          nil     )
    (#x0002fb "MODIFIER LETTER BEGIN LOW TONE"         nil     )
    (#x0002fc "MODIFIER LETTER END LOW TONE"           nil     )
    (#x0002fd "MODIFIER LETTER SHELF"                  nil     )
    (#x0002fe "MODIFIER LETTER OPEN SHELF"             nil     )
    (#x0002ff "MODIFIER LETTER LOW LEFT ARROW"         nil     )
    (#x000300 "COMBINING GRAVE ACCENT"                 nil     )
    (#x000301 "COMBINING ACUTE ACCENT"                 nil     )
    (#x000302 "COMBINING CIRCUMFLEX ACCENT"            nil     )
    (#x000303 "COMBINING TILDE"                        nil     )
    (#x000304 "COMBINING MACRON"                       nil     )
    (#x000305 "COMBINING OVERLINE"                     nil     )
    (#x000306 "COMBINING BREVE"                        nil     )
    (#x000307 "COMBINING DOT ABOVE"                    nil     )
    (#x000308 "COMBINING DIAERESIS"                    nil     )
    (#x000309 "COMBINING HOOK ABOVE"                   nil     )
    (#x00030a "COMBINING RING ABOVE"                   nil     )
    (#x00030b "COMBINING DOUBLE ACUTE ACCENT"          nil     )
    (#x00030c "COMBINING CARON"                        nil     )
    (#x00030d "COMBINING VERTICAL LINE ABOVE"          nil     )
    (#x00030e "COMBINING DOUBLE VERTICAL LINE ABOVE"   nil     )
    (#x00030f "COMBINING DOUBLE GRAVE ACCENT"          nil     )
    (#x000310 "COMBINING CANDRABINDU"                  nil     )
    (#x000311 "COMBINING INVERTED BREVE"               nil     )
    (#x000312 "COMBINING TURNED COMMA ABOVE"           nil     )
    (#x000313 "COMBINING COMMA ABOVE"                  nil     )
    (#x000314 "COMBINING REVERSED COMMA ABOVE"         nil     )
    (#x000315 "COMBINING COMMA ABOVE RIGHT"            nil     )
    (#x000316 "COMBINING GRAVE ACCENT BELOW"           nil     )
    (#x000317 "COMBINING ACUTE ACCENT BELOW"           nil     )
    (#x000318 "COMBINING LEFT TACK BELOW"              nil     )
    (#x000319 "COMBINING RIGHT TACK BELOW"             nil     )
    (#x00031a "COMBINING LEFT ANGLE ABOVE"             nil     )
    (#x00031b "COMBINING HORN"                         nil     )
    (#x00031c "COMBINING LEFT HALF RING BELOW"         nil     )
    (#x00031d "COMBINING UP TACK BELOW"                nil     )
    (#x00031e "COMBINING DOWN TACK BELOW"              nil     )
    (#x00031f "COMBINING PLUS SIGN BELOW"              nil     )
    (#x000320 "COMBINING MINUS SIGN BELOW"             nil     )
    (#x000321 "COMBINING PALATALIZED HOOK BELOW"       nil     )
    (#x000322 "COMBINING RETROFLEX HOOK BELOW"         nil     )
    (#x000323 "COMBINING DOT BELOW"                    nil     )
    (#x000324 "COMBINING DIAERESIS BELOW"              nil     )
    (#x000325 "COMBINING RING BELOW"                   nil     )
    (#x000326 "COMBINING COMMA BELOW"                  nil     )
    (#x000327 "COMBINING CEDILLA"                      nil     )
    (#x000328 "COMBINING OGONEK"                       nil     )
    (#x000329 "COMBINING VERTICAL LINE BELOW"          nil     )
    (#x00032a "COMBINING BRIDGE BELOW"                 nil     )
    (#x00032b "COMBINING INVERTED DOUBLE ARCH BELOW"   nil     )
    (#x00032c "COMBINING CARON BELOW"                  nil     )
    (#x00032d "COMBINING CIRCUMFLEX ACCENT BELOW"      nil     )
    (#x00032e "COMBINING BREVE BELOW"                  nil     )
    (#x00032f "COMBINING INVERTED BREVE BELOW"         nil     )
    (#x000330 "COMBINING TILDE BELOW"                  nil     )
    (#x000331 "COMBINING MACRON BELOW"                 nil     )
    (#x000332 "COMBINING LOW LINE"                     nil     )
    (#x000333 "COMBINING DOUBLE LOW LINE"              nil     )
    (#x000334 "COMBINING TILDE OVERLAY"                nil     )
    (#x000335 "COMBINING SHORT STROKE OVERLAY"         nil     )
    (#x000336 "COMBINING LONG STROKE OVERLAY"          nil     )
    (#x000337 "COMBINING SHORT SOLIDUS OVERLAY"        nil     )
    (#x000338 "COMBINING LONG SOLIDUS OVERLAY"         nil     )
    (#x000339 "COMBINING RIGHT HALF RING BELOW"        nil     )
    (#x00033a "COMBINING INVERTED BRIDGE BELOW"        nil     )
    (#x00033b "COMBINING SQUARE BELOW"                 nil     )
    (#x00033c "COMBINING SEAGULL BELOW"                nil     )
    (#x00033d "COMBINING X ABOVE"                      nil     )
    (#x00033e "COMBINING VERTICAL TILDE"               nil     )
    (#x00033f "COMBINING DOUBLE OVERLINE"              nil     )
    (#x000340 "COMBINING GRAVE TONE MARK"              nil     )
    (#x000341 "COMBINING ACUTE TONE MARK"              nil     )
    (#x000342 "COMBINING GREEK PERISPOMENI"            nil     )
    (#x000343 "COMBINING GREEK KORONIS"                nil     )
    (#x000344 "COMBINING GREEK DIALYTIKA TONOS"        nil     )
    (#x000345 "COMBINING GREEK YPOGEGRAMMENI"          nil     )
    (#x000346 "COMBINING BRIDGE ABOVE"                 nil     )
    (#x000347 "COMBINING EQUALS SIGN BELOW"            nil     )
    (#x000348 "COMBINING DOUBLE VERTICAL LINE BELOW"   nil     )
    (#x000349 "COMBINING LEFT ANGLE BELOW"             nil     )
    (#x00034a "COMBINING NOT TILDE ABOVE"              nil     )
    (#x00034b "COMBINING HOMOTHETIC ABOVE"             nil     )
    (#x00034c "COMBINING ALMOST EQUAL TO ABOVE"        nil     )
    (#x00034d "COMBINING LEFT RIGHT ARROW BELOW"       nil     )
    (#x00034e "COMBINING UPWARDS ARROW BELOW"          nil     )
    (#x00034f "COMBINING GRAPHEME JOINER"              nil     )
    (#x000350 "COMBINING RIGHT ARROWHEAD ABOVE"        nil     )
    (#x000351 "COMBINING LEFT HALF RING ABOVE"         nil     )
    (#x000352 "COMBINING FERMATA"                      nil     )
    (#x000353 "COMBINING X BELOW"                      nil     )
    (#x000354 "COMBINING LEFT ARROWHEAD BELOW"         nil     )
    (#x000355 "COMBINING RIGHT ARROWHEAD BELOW"        nil     )
    (#x000356 "COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW" nil     )
    (#x000357 "COMBINING RIGHT HALF RING ABOVE"        nil     )
    (#x000358 "COMBINING DOT ABOVE RIGHT"              nil     )
    (#x000359 "COMBINING ASTERISK BELOW"               nil     )
    (#x00035a "COMBINING DOUBLE RING BELOW"            nil     )
    (#x00035b "COMBINING ZIGZAG ABOVE"                 nil     )
    (#x00035c "COMBINING DOUBLE BREVE BELOW"           nil     )
    (#x00035d "COMBINING DOUBLE BREVE"                 nil     )
    (#x00035e "COMBINING DOUBLE MACRON"                nil     )
    (#x00035f "COMBINING DOUBLE MACRON BELOW"          nil     )
    (#x000360 "COMBINING DOUBLE TILDE"                 nil     )
    (#x000361 "COMBINING DOUBLE INVERTED BREVE"        nil     )
    (#x000362 "COMBINING DOUBLE RIGHTWARDS ARROW BELOW" nil     )
    (#x000363 "COMBINING LATIN SMALL LETTER A"         nil     )
    (#x000364 "COMBINING LATIN SMALL LETTER E"         nil     )
    (#x000365 "COMBINING LATIN SMALL LETTER I"         nil     )
    (#x000366 "COMBINING LATIN SMALL LETTER O"         nil     )
    (#x000367 "COMBINING LATIN SMALL LETTER U"         nil     )
    (#x000368 "COMBINING LATIN SMALL LETTER C"         nil     )
    (#x000369 "COMBINING LATIN SMALL LETTER D"         nil     )
    (#x00036a "COMBINING LATIN SMALL LETTER H"         nil     )
    (#x00036b "COMBINING LATIN SMALL LETTER M"         nil     )
    (#x00036c "COMBINING LATIN SMALL LETTER R"         nil     )
    (#x00036d "COMBINING LATIN SMALL LETTER T"         nil     )
    (#x00036e "COMBINING LATIN SMALL LETTER V"         nil     )
    (#x00036f "COMBINING LATIN SMALL LETTER X"         nil     )
    (#x000370 "GREEK CAPITAL LETTER HETA"              nil     )
    (#x000371 "GREEK SMALL LETTER HETA"                nil     )
    (#x000372 "GREEK CAPITAL LETTER ARCHAIC SAMPI"     nil     )
    (#x000373 "GREEK SMALL LETTER ARCHAIC SAMPI"       nil     )
    (#x000374 "GREEK NUMERAL SIGN"                     nil     )
    (#x000375 "GREEK LOWER NUMERAL SIGN"               nil     )
    (#x000376 "GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA" nil     )
    (#x000377 "GREEK SMALL LETTER PAMPHYLIAN DIGAMMA"  nil     )
    (#x00037a "GREEK YPOGEGRAMMENI"                    nil     )
    (#x00037b "GREEK SMALL REVERSED LUNATE SIGMA SYMBOL" nil     )
    (#x00037c "GREEK SMALL DOTTED LUNATE SIGMA SYMBOL" nil     )
    (#x00037d "GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL" nil     )
    (#x00037e "GREEK QUESTION MARK"                    nil     )
    (#x00037f "GREEK CAPITAL LETTER YOT"               nil     )
    (#x000384 "GREEK TONOS"                            nil     )
    (#x000385 "GREEK DIALYTIKA TONOS"                  nil     )
    (#x000386 "GREEK CAPITAL LETTER ALPHA WITH TONOS"  "Aacgr" )
    (#x000387 "GREEK ANO TELEIA"                       nil     )
    (#x000388 "GREEK CAPITAL LETTER EPSILON WITH TONOS" "Eacgr" )
    (#x000389 "GREEK CAPITAL LETTER ETA WITH TONOS"    "EEacgr")
    (#x00038a "GREEK CAPITAL LETTER IOTA WITH TONOS"   "Iacgr" )
    (#x00038c "GREEK CAPITAL LETTER OMICRON WITH TONOS" "Oacgr" )
    (#x00038e "GREEK CAPITAL LETTER UPSILON WITH TONOS" "Uacgr" )
    (#x00038f "GREEK CAPITAL LETTER OMEGA WITH TONOS"  "OHacgr")
    (#x000390 "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" "idiagr")
    (#x000391 "GREEK CAPITAL LETTER ALPHA"             "Agr"   )
    (#x000392 "GREEK CAPITAL LETTER BETA"              "Bgr"   )
    (#x000393 "GREEK CAPITAL LETTER GAMMA"             "Gamma" )
    (#x000394 "GREEK CAPITAL LETTER DELTA"             "Delta" )
    (#x000395 "GREEK CAPITAL LETTER EPSILON"           "Egr"   )
    (#x000396 "GREEK CAPITAL LETTER ZETA"              "Zgr"   )
    (#x000397 "GREEK CAPITAL LETTER ETA"               "EEgr"  )
    (#x000398 "GREEK CAPITAL LETTER THETA"             "THgr"  )
    (#x000399 "GREEK CAPITAL LETTER IOTA"              "Igr"   )
    (#x00039a "GREEK CAPITAL LETTER KAPPA"             "Kgr"   )
    (#x00039b "GREEK CAPITAL LETTER LAMDA"             "Lambda")
    (#x00039c "GREEK CAPITAL LETTER MU"                "Mgr"   )
    (#x00039d "GREEK CAPITAL LETTER NU"                "Ngr"   )
    (#x00039e "GREEK CAPITAL LETTER XI"                "Xgr"   )
    (#x00039f "GREEK CAPITAL LETTER OMICRON"           "Ogr"   )
    (#x0003a0 "GREEK CAPITAL LETTER PI"                "Pgr"   )
    (#x0003a1 "GREEK CAPITAL LETTER RHO"               "Rgr"   )
    (#x0003a3 "GREEK CAPITAL LETTER SIGMA"             "Sgr"   )
    (#x0003a4 "GREEK CAPITAL LETTER TAU"               "Tgr"   )
    (#x0003a5 "GREEK CAPITAL LETTER UPSILON"           "Ugr"   )
    (#x0003a6 "GREEK CAPITAL LETTER PHI"               "PHgr"  )
    (#x0003a7 "GREEK CAPITAL LETTER CHI"               "KHgr"  )
    (#x0003a8 "GREEK CAPITAL LETTER PSI"               "PSgr"  )
    (#x0003a9 "GREEK CAPITAL LETTER OMEGA"             "OHgr"  )
    (#x0003aa "GREEK CAPITAL LETTER IOTA WITH DIALYTIKA" "Idigr" )
    (#x0003ab "GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA" "Udigr" )
    (#x0003ac "GREEK SMALL LETTER ALPHA WITH TONOS"    "aacgr" )
    (#x0003ad "GREEK SMALL LETTER EPSILON WITH TONOS"  "eacgr" )
    (#x0003ae "GREEK SMALL LETTER ETA WITH TONOS"      "eeacgr")
    (#x0003af "GREEK SMALL LETTER IOTA WITH TONOS"     "iacgr" )
    (#x0003b0 "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS" "udiagr")
    (#x0003b1 "GREEK SMALL LETTER ALPHA"               "agr"   )
    (#x0003b2 "GREEK SMALL LETTER BETA"                "beta"  )
    (#x0003b3 "GREEK SMALL LETTER GAMMA"               "gamma" )
    (#x0003b4 "GREEK SMALL LETTER DELTA"               "delta" )
    (#x0003b5 "GREEK SMALL LETTER EPSILON"             "epsi"  )
    (#x0003b6 "GREEK SMALL LETTER ZETA"                "zeta"  )
    (#x0003b7 "GREEK SMALL LETTER ETA"                 "eegr"  )
    (#x0003b8 "GREEK SMALL LETTER THETA"               "thetas")
    (#x0003b9 "GREEK SMALL LETTER IOTA"                "igr"   )
    (#x0003ba "GREEK SMALL LETTER KAPPA"               "kappa" )
    (#x0003bb "GREEK SMALL LETTER LAMDA"               "lambda")
    (#x0003bc "GREEK SMALL LETTER MU"                  "mgr"   )
    (#x0003bd "GREEK SMALL LETTER NU"                  "ngr"   )
    (#x0003be "GREEK SMALL LETTER XI"                  "xgr"   )
    (#x0003bf "GREEK SMALL LETTER OMICRON"             "ogr"   )
    (#x0003c0 "GREEK SMALL LETTER PI"                  "pgr"   )
    (#x0003c1 "GREEK SMALL LETTER RHO"                 "rgr"   )
    (#x0003c2 "GREEK SMALL LETTER FINAL SIGMA"         "sfgr"  )
    (#x0003c3 "GREEK SMALL LETTER SIGMA"               "sgr"   )
    (#x0003c4 "GREEK SMALL LETTER TAU"                 "tau"   )
    (#x0003c5 "GREEK SMALL LETTER UPSILON"             "ugr"   )
    (#x0003c6 "GREEK SMALL LETTER PHI"                 "phgr"  )
    (#x0003c7 "GREEK SMALL LETTER CHI"                 "chi"   )
    (#x0003c8 "GREEK SMALL LETTER PSI"                 "psgr"  )
    (#x0003c9 "GREEK SMALL LETTER OMEGA"               "ohgr"  )
    (#x0003ca "GREEK SMALL LETTER IOTA WITH DIALYTIKA" "idigr" )
    (#x0003cb "GREEK SMALL LETTER UPSILON WITH DIALYTIKA" "udigr" )
    (#x0003cc "GREEK SMALL LETTER OMICRON WITH TONOS"  "oacgr" )
    (#x0003cd "GREEK SMALL LETTER UPSILON WITH TONOS"  "uacgr" )
    (#x0003ce "GREEK SMALL LETTER OMEGA WITH TONOS"    "ohacgr")
    (#x0003cf "GREEK CAPITAL KAI SYMBOL"               nil     )
    (#x0003d0 "GREEK BETA SYMBOL"                      nil     )
    (#x0003d1 "GREEK THETA SYMBOL"                     "thetav")
    (#x0003d2 "GREEK UPSILON WITH HOOK SYMBOL"         "Upsi"  )
    (#x0003d3 "GREEK UPSILON WITH ACUTE AND HOOK SYMBOL" nil     )
    (#x0003d4 "GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL" nil     )
    (#x0003d5 "GREEK PHI SYMBOL"                       "phis"  )
    (#x0003d6 "GREEK PI SYMBOL"                        "piv"   )
    (#x0003d7 "GREEK KAI SYMBOL"                       nil     )
    (#x0003d8 "GREEK LETTER ARCHAIC KOPPA"             nil     )
    (#x0003d9 "GREEK SMALL LETTER ARCHAIC KOPPA"       nil     )
    (#x0003da "GREEK LETTER STIGMA"                    nil     )
    (#x0003db "GREEK SMALL LETTER STIGMA"              nil     )
    (#x0003dc "GREEK LETTER DIGAMMA"                   "b.Gammad")
    (#x0003dd "GREEK SMALL LETTER DIGAMMA"             "gammad")
    (#x0003de "GREEK LETTER KOPPA"                     nil     )
    (#x0003df "GREEK SMALL LETTER KOPPA"               nil     )
    (#x0003e0 "GREEK LETTER SAMPI"                     nil     )
    (#x0003e1 "GREEK SMALL LETTER SAMPI"               nil     )
    (#x0003e2 "COPTIC CAPITAL LETTER SHEI"             nil     )
    (#x0003e3 "COPTIC SMALL LETTER SHEI"               nil     )
    (#x0003e4 "COPTIC CAPITAL LETTER FEI"              nil     )
    (#x0003e5 "COPTIC SMALL LETTER FEI"                nil     )
    (#x0003e6 "COPTIC CAPITAL LETTER KHEI"             nil     )
    (#x0003e7 "COPTIC SMALL LETTER KHEI"               nil     )
    (#x0003e8 "COPTIC CAPITAL LETTER HORI"             nil     )
    (#x0003e9 "COPTIC SMALL LETTER HORI"               nil     )
    (#x0003ea "COPTIC CAPITAL LETTER GANGIA"           nil     )
    (#x0003eb "COPTIC SMALL LETTER GANGIA"             nil     )
    (#x0003ec "COPTIC CAPITAL LETTER SHIMA"            nil     )
    (#x0003ed "COPTIC SMALL LETTER SHIMA"              nil     )
    (#x0003ee "COPTIC CAPITAL LETTER DEI"              nil     )
    (#x0003ef "COPTIC SMALL LETTER DEI"                nil     )
    (#x0003f0 "GREEK KAPPA SYMBOL"                     "kappav")
    (#x0003f1 "GREEK RHO SYMBOL"                       "rhov"  )
    (#x0003f2 "GREEK LUNATE SIGMA SYMBOL"              nil     )
    (#x0003f3 "GREEK LETTER YOT"                       nil     )
    (#x0003f4 "GREEK CAPITAL THETA SYMBOL"             nil     )
    (#x0003f5 "GREEK LUNATE EPSILON SYMBOL"            nil     )
    (#x0003f6 "GREEK REVERSED LUNATE EPSILON SYMBOL"   "bepsi" )
    (#x0003f7 "GREEK CAPITAL LETTER SHO"               nil     )
    (#x0003f8 "GREEK SMALL LETTER SHO"                 nil     )
    (#x0003f9 "GREEK CAPITAL LUNATE SIGMA SYMBOL"      nil     )
    (#x0003fa "GREEK CAPITAL LETTER SAN"               nil     )
    (#x0003fb "GREEK SMALL LETTER SAN"                 nil     )
    (#x0003fc "GREEK RHO WITH STROKE SYMBOL"           nil     )
    (#x0003fd "GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL" nil     )
    (#x0003fe "GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL" nil     )
    (#x0003ff "GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL" nil     )
    (#x000400 "CYRILLIC CAPITAL LETTER IE WITH GRAVE"  nil     )
    (#x000401 "CYRILLIC CAPITAL LETTER IO"             "IOcy"  )
    (#x000402 "CYRILLIC CAPITAL LETTER DJE"            "DJcy"  )
    (#x000403 "CYRILLIC CAPITAL LETTER GJE"            "GJcy"  )
    (#x000404 "CYRILLIC CAPITAL LETTER UKRAINIAN IE"   "Jukcy" )
    (#x000405 "CYRILLIC CAPITAL LETTER DZE"            "DScy"  )
    (#x000406 "CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I" "Iukcy" )
    (#x000407 "CYRILLIC CAPITAL LETTER YI"             "YIcy"  )
    (#x000408 "CYRILLIC CAPITAL LETTER JE"             "Jsercy")
    (#x000409 "CYRILLIC CAPITAL LETTER LJE"            "LJcy"  )
    (#x00040a "CYRILLIC CAPITAL LETTER NJE"            "NJcy"  )
    (#x00040b "CYRILLIC CAPITAL LETTER TSHE"           "TSHcy" )
    (#x00040c "CYRILLIC CAPITAL LETTER KJE"            "KJcy"  )
    (#x00040d "CYRILLIC CAPITAL LETTER I WITH GRAVE"   nil     )
    (#x00040e "CYRILLIC CAPITAL LETTER SHORT U"        "Ubrcy" )
    (#x00040f "CYRILLIC CAPITAL LETTER DZHE"           "DZcy"  )
    (#x000410 "CYRILLIC CAPITAL LETTER A"              "Acy"   )
    (#x000411 "CYRILLIC CAPITAL LETTER BE"             "Bcy"   )
    (#x000412 "CYRILLIC CAPITAL LETTER VE"             "Vcy"   )
    (#x000413 "CYRILLIC CAPITAL LETTER GHE"            "Gcy"   )
    (#x000414 "CYRILLIC CAPITAL LETTER DE"             "Dcy"   )
    (#x000415 "CYRILLIC CAPITAL LETTER IE"             "IEcy"  )
    (#x000416 "CYRILLIC CAPITAL LETTER ZHE"            "ZHcy"  )
    (#x000417 "CYRILLIC CAPITAL LETTER ZE"             "Zcy"   )
    (#x000418 "CYRILLIC CAPITAL LETTER I"              "Icy"   )
    (#x000419 "CYRILLIC CAPITAL LETTER SHORT I"        "Jcy"   )
    (#x00041a "CYRILLIC CAPITAL LETTER KA"             "Kcy"   )
    (#x00041b "CYRILLIC CAPITAL LETTER EL"             "Lcy"   )
    (#x00041c "CYRILLIC CAPITAL LETTER EM"             "Mcy"   )
    (#x00041d "CYRILLIC CAPITAL LETTER EN"             "Ncy"   )
    (#x00041e "CYRILLIC CAPITAL LETTER O"              "Ocy"   )
    (#x00041f "CYRILLIC CAPITAL LETTER PE"             "Pcy"   )
    (#x000420 "CYRILLIC CAPITAL LETTER ER"             "Rcy"   )
    (#x000421 "CYRILLIC CAPITAL LETTER ES"             "Scy"   )
    (#x000422 "CYRILLIC CAPITAL LETTER TE"             "Tcy"   )
    (#x000423 "CYRILLIC CAPITAL LETTER U"              "Ucy"   )
    (#x000424 "CYRILLIC CAPITAL LETTER EF"             "Fcy"   )
    (#x000425 "CYRILLIC CAPITAL LETTER HA"             "KHcy"  )
    (#x000426 "CYRILLIC CAPITAL LETTER TSE"            "TScy"  )
    (#x000427 "CYRILLIC CAPITAL LETTER CHE"            "CHcy"  )
    (#x000428 "CYRILLIC CAPITAL LETTER SHA"            "SHcy"  )
    (#x000429 "CYRILLIC CAPITAL LETTER SHCHA"          "SHCHcy")
    (#x00042a "CYRILLIC CAPITAL LETTER HARD SIGN"      "HARDcy")
    (#x00042b "CYRILLIC CAPITAL LETTER YERU"           "Ycy"   )
    (#x00042c "CYRILLIC CAPITAL LETTER SOFT SIGN"      "SOFTcy")
    (#x00042d "CYRILLIC CAPITAL LETTER E"              "Ecy"   )
    (#x00042e "CYRILLIC CAPITAL LETTER YU"             "YUcy"  )
    (#x00042f "CYRILLIC CAPITAL LETTER YA"             "YAcy"  )
    (#x000430 "CYRILLIC SMALL LETTER A"                "acy"   )
    (#x000431 "CYRILLIC SMALL LETTER BE"               "bcy"   )
    (#x000432 "CYRILLIC SMALL LETTER VE"               "vcy"   )
    (#x000433 "CYRILLIC SMALL LETTER GHE"              "gcy"   )
    (#x000434 "CYRILLIC SMALL LETTER DE"               "dcy"   )
    (#x000435 "CYRILLIC SMALL LETTER IE"               "iecy"  )
    (#x000436 "CYRILLIC SMALL LETTER ZHE"              "zhcy"  )
    (#x000437 "CYRILLIC SMALL LETTER ZE"               "zcy"   )
    (#x000438 "CYRILLIC SMALL LETTER I"                "icy"   )
    (#x000439 "CYRILLIC SMALL LETTER SHORT I"          "jcy"   )
    (#x00043a "CYRILLIC SMALL LETTER KA"               "kcy"   )
    (#x00043b "CYRILLIC SMALL LETTER EL"               "lcy"   )
    (#x00043c "CYRILLIC SMALL LETTER EM"               "mcy"   )
    (#x00043d "CYRILLIC SMALL LETTER EN"               "ncy"   )
    (#x00043e "CYRILLIC SMALL LETTER O"                "ocy"   )
    (#x00043f "CYRILLIC SMALL LETTER PE"               "pcy"   )
    (#x000440 "CYRILLIC SMALL LETTER ER"               "rcy"   )
    (#x000441 "CYRILLIC SMALL LETTER ES"               "scy"   )
    (#x000442 "CYRILLIC SMALL LETTER TE"               "tcy"   )
    (#x000443 "CYRILLIC SMALL LETTER U"                "ucy"   )
    (#x000444 "CYRILLIC SMALL LETTER EF"               "fcy"   )
    (#x000445 "CYRILLIC SMALL LETTER HA"               "khcy"  )
    (#x000446 "CYRILLIC SMALL LETTER TSE"              "tscy"  )
    (#x000447 "CYRILLIC SMALL LETTER CHE"              "chcy"  )
    (#x000448 "CYRILLIC SMALL LETTER SHA"              "shcy"  )
    (#x000449 "CYRILLIC SMALL LETTER SHCHA"            "shchcy")
    (#x00044a "CYRILLIC SMALL LETTER HARD SIGN"        "hardcy")
    (#x00044b "CYRILLIC SMALL LETTER YERU"             "ycy"   )
    (#x00044c "CYRILLIC SMALL LETTER SOFT SIGN"        "softcy")
    (#x00044d "CYRILLIC SMALL LETTER E"                "ecy"   )
    (#x00044e "CYRILLIC SMALL LETTER YU"               "yucy"  )
    (#x00044f "CYRILLIC SMALL LETTER YA"               "yacy"  )
    (#x000450 "CYRILLIC SMALL LETTER IE WITH GRAVE"    nil     )
    (#x000451 "CYRILLIC SMALL LETTER IO"               "iocy"  )
    (#x000452 "CYRILLIC SMALL LETTER DJE"              "djcy"  )
    (#x000453 "CYRILLIC SMALL LETTER GJE"              "gjcy"  )
    (#x000454 "CYRILLIC SMALL LETTER UKRAINIAN IE"     "jukcy" )
    (#x000455 "CYRILLIC SMALL LETTER DZE"              "dscy"  )
    (#x000456 "CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I" "iukcy" )
    (#x000457 "CYRILLIC SMALL LETTER YI"               "yicy"  )
    (#x000458 "CYRILLIC SMALL LETTER JE"               "jsercy")
    (#x000459 "CYRILLIC SMALL LETTER LJE"              "ljcy"  )
    (#x00045a "CYRILLIC SMALL LETTER NJE"              "njcy"  )
    (#x00045b "CYRILLIC SMALL LETTER TSHE"             "tshcy" )
    (#x00045c "CYRILLIC SMALL LETTER KJE"              "kjcy"  )
    (#x00045d "CYRILLIC SMALL LETTER I WITH GRAVE"     nil     )
    (#x00045e "CYRILLIC SMALL LETTER SHORT U"          "ubrcy" )
    (#x00045f "CYRILLIC SMALL LETTER DZHE"             "dzcy"  )
    (#x000460 "CYRILLIC CAPITAL LETTER OMEGA"          nil     )
    (#x000461 "CYRILLIC SMALL LETTER OMEGA"            nil     )
    (#x000462 "CYRILLIC CAPITAL LETTER YAT"            nil     )
    (#x000463 "CYRILLIC SMALL LETTER YAT"              nil     )
    (#x000464 "CYRILLIC CAPITAL LETTER IOTIFIED E"     nil     )
    (#x000465 "CYRILLIC SMALL LETTER IOTIFIED E"       nil     )
    (#x000466 "CYRILLIC CAPITAL LETTER LITTLE YUS"     nil     )
    (#x000467 "CYRILLIC SMALL LETTER LITTLE YUS"       nil     )
    (#x000468 "CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS" nil     )
    (#x000469 "CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS" nil     )
    (#x00046a "CYRILLIC CAPITAL LETTER BIG YUS"        nil     )
    (#x00046b "CYRILLIC SMALL LETTER BIG YUS"          nil     )
    (#x00046c "CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS" nil     )
    (#x00046d "CYRILLIC SMALL LETTER IOTIFIED BIG YUS" nil     )
    (#x00046e "CYRILLIC CAPITAL LETTER KSI"            nil     )
    (#x00046f "CYRILLIC SMALL LETTER KSI"              nil     )
    (#x000470 "CYRILLIC CAPITAL LETTER PSI"            nil     )
    (#x000471 "CYRILLIC SMALL LETTER PSI"              nil     )
    (#x000472 "CYRILLIC CAPITAL LETTER FITA"           nil     )
    (#x000473 "CYRILLIC SMALL LETTER FITA"             nil     )
    (#x000474 "CYRILLIC CAPITAL LETTER IZHITSA"        nil     )
    (#x000475 "CYRILLIC SMALL LETTER IZHITSA"          nil     )
    (#x000476 "CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" nil     )
    (#x000477 "CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" nil     )
    (#x000478 "CYRILLIC CAPITAL LETTER UK"             nil     )
    (#x000479 "CYRILLIC SMALL LETTER UK"               nil     )
    (#x00047a "CYRILLIC CAPITAL LETTER ROUND OMEGA"    nil     )
    (#x00047b "CYRILLIC SMALL LETTER ROUND OMEGA"      nil     )
    (#x00047c "CYRILLIC CAPITAL LETTER OMEGA WITH TITLO" nil     )
    (#x00047d "CYRILLIC SMALL LETTER OMEGA WITH TITLO" nil     )
    (#x00047e "CYRILLIC CAPITAL LETTER OT"             nil     )
    (#x00047f "CYRILLIC SMALL LETTER OT"               nil     )
    (#x000480 "CYRILLIC CAPITAL LETTER KOPPA"          nil     )
    (#x000481 "CYRILLIC SMALL LETTER KOPPA"            nil     )
    (#x000482 "CYRILLIC THOUSANDS SIGN"                nil     )
    (#x000483 "COMBINING CYRILLIC TITLO"               nil     )
    (#x000484 "COMBINING CYRILLIC PALATALIZATION"      nil     )
    (#x000485 "COMBINING CYRILLIC DASIA PNEUMATA"      nil     )
    (#x000486 "COMBINING CYRILLIC PSILI PNEUMATA"      nil     )
    (#x000487 "COMBINING CYRILLIC POKRYTIE"            nil     )
    (#x000488 "COMBINING CYRILLIC HUNDRED THOUSANDS SIGN" nil     )
    (#x000489 "COMBINING CYRILLIC MILLIONS SIGN"       nil     )
    (#x00048a "CYRILLIC CAPITAL LETTER SHORT I WITH TAIL" nil     )
    (#x00048b "CYRILLIC SMALL LETTER SHORT I WITH TAIL" nil     )
    (#x00048c "CYRILLIC CAPITAL LETTER SEMISOFT SIGN"  nil     )
    (#x00048d "CYRILLIC SMALL LETTER SEMISOFT SIGN"    nil     )
    (#x00048e "CYRILLIC CAPITAL LETTER ER WITH TICK"   nil     )
    (#x00048f "CYRILLIC SMALL LETTER ER WITH TICK"     nil     )
    (#x000490 "CYRILLIC CAPITAL LETTER GHE WITH UPTURN" nil     )
    (#x000491 "CYRILLIC SMALL LETTER GHE WITH UPTURN"  nil     )
    (#x000492 "CYRILLIC CAPITAL LETTER GHE WITH STROKE" nil     )
    (#x000493 "CYRILLIC SMALL LETTER GHE WITH STROKE"  nil     )
    (#x000494 "CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK" nil     )
    (#x000495 "CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK" nil     )
    (#x000496 "CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER" nil     )
    (#x000497 "CYRILLIC SMALL LETTER ZHE WITH DESCENDER" nil     )
    (#x000498 "CYRILLIC CAPITAL LETTER ZE WITH DESCENDER" nil     )
    (#x000499 "CYRILLIC SMALL LETTER ZE WITH DESCENDER" nil     )
    (#x00049a "CYRILLIC CAPITAL LETTER KA WITH DESCENDER" nil     )
    (#x00049b "CYRILLIC SMALL LETTER KA WITH DESCENDER" nil     )
    (#x00049c "CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE" nil     )
    (#x00049d "CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE" nil     )
    (#x00049e "CYRILLIC CAPITAL LETTER KA WITH STROKE" nil     )
    (#x00049f "CYRILLIC SMALL LETTER KA WITH STROKE"   nil     )
    (#x0004a0 "CYRILLIC CAPITAL LETTER BASHKIR KA"     nil     )
    (#x0004a1 "CYRILLIC SMALL LETTER BASHKIR KA"       nil     )
    (#x0004a2 "CYRILLIC CAPITAL LETTER EN WITH DESCENDER" nil     )
    (#x0004a3 "CYRILLIC SMALL LETTER EN WITH DESCENDER" nil     )
    (#x0004a4 "CYRILLIC CAPITAL LIGATURE EN GHE"       nil     )
    (#x0004a5 "CYRILLIC SMALL LIGATURE EN GHE"         nil     )
    (#x0004a6 "CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK" nil     )
    (#x0004a7 "CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK" nil     )
    (#x0004a8 "CYRILLIC CAPITAL LETTER ABKHASIAN HA"   nil     )
    (#x0004a9 "CYRILLIC SMALL LETTER ABKHASIAN HA"     nil     )
    (#x0004aa "CYRILLIC CAPITAL LETTER ES WITH DESCENDER" nil     )
    (#x0004ab "CYRILLIC SMALL LETTER ES WITH DESCENDER" nil     )
    (#x0004ac "CYRILLIC CAPITAL LETTER TE WITH DESCENDER" nil     )
    (#x0004ad "CYRILLIC SMALL LETTER TE WITH DESCENDER" nil     )
    (#x0004ae "CYRILLIC CAPITAL LETTER STRAIGHT U"     nil     )
    (#x0004af "CYRILLIC SMALL LETTER STRAIGHT U"       nil     )
    (#x0004b0 "CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE" nil     )
    (#x0004b1 "CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE" nil     )
    (#x0004b2 "CYRILLIC CAPITAL LETTER HA WITH DESCENDER" nil     )
    (#x0004b3 "CYRILLIC SMALL LETTER HA WITH DESCENDER" nil     )
    (#x0004b4 "CYRILLIC CAPITAL LIGATURE TE TSE"       nil     )
    (#x0004b5 "CYRILLIC SMALL LIGATURE TE TSE"         nil     )
    (#x0004b6 "CYRILLIC CAPITAL LETTER CHE WITH DESCENDER" nil     )
    (#x0004b7 "CYRILLIC SMALL LETTER CHE WITH DESCENDER" nil     )
    (#x0004b8 "CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE" nil     )
    (#x0004b9 "CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE" nil     )
    (#x0004ba "CYRILLIC CAPITAL LETTER SHHA"           nil     )
    (#x0004bb "CYRILLIC SMALL LETTER SHHA"             nil     )
    (#x0004bc "CYRILLIC CAPITAL LETTER ABKHASIAN CHE"  nil     )
    (#x0004bd "CYRILLIC SMALL LETTER ABKHASIAN CHE"    nil     )
    (#x0004be "CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER" nil     )
    (#x0004bf "CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER" nil     )
    (#x0004c0 "CYRILLIC LETTER PALOCHKA"               nil     )
    (#x0004c1 "CYRILLIC CAPITAL LETTER ZHE WITH BREVE" nil     )
    (#x0004c2 "CYRILLIC SMALL LETTER ZHE WITH BREVE"   nil     )
    (#x0004c3 "CYRILLIC CAPITAL LETTER KA WITH HOOK"   nil     )
    (#x0004c4 "CYRILLIC SMALL LETTER KA WITH HOOK"     nil     )
    (#x0004c5 "CYRILLIC CAPITAL LETTER EL WITH TAIL"   nil     )
    (#x0004c6 "CYRILLIC SMALL LETTER EL WITH TAIL"     nil     )
    (#x0004c7 "CYRILLIC CAPITAL LETTER EN WITH HOOK"   nil     )
    (#x0004c8 "CYRILLIC SMALL LETTER EN WITH HOOK"     nil     )
    (#x0004c9 "CYRILLIC CAPITAL LETTER EN WITH TAIL"   nil     )
    (#x0004ca "CYRILLIC SMALL LETTER EN WITH TAIL"     nil     )
    (#x0004cb "CYRILLIC CAPITAL LETTER KHAKASSIAN CHE" nil     )
    (#x0004cc "CYRILLIC SMALL LETTER KHAKASSIAN CHE"   nil     )
    (#x0004cd "CYRILLIC CAPITAL LETTER EM WITH TAIL"   nil     )
    (#x0004ce "CYRILLIC SMALL LETTER EM WITH TAIL"     nil     )
    (#x0004cf "CYRILLIC SMALL LETTER PALOCHKA"         nil     )
    (#x0004d0 "CYRILLIC CAPITAL LETTER A WITH BREVE"   nil     )
    (#x0004d1 "CYRILLIC SMALL LETTER A WITH BREVE"     nil     )
    (#x0004d2 "CYRILLIC CAPITAL LETTER A WITH DIAERESIS" nil     )
    (#x0004d3 "CYRILLIC SMALL LETTER A WITH DIAERESIS" nil     )
    (#x0004d4 "CYRILLIC CAPITAL LIGATURE A IE"         nil     )
    (#x0004d5 "CYRILLIC SMALL LIGATURE A IE"           nil     )
    (#x0004d6 "CYRILLIC CAPITAL LETTER IE WITH BREVE"  nil     )
    (#x0004d7 "CYRILLIC SMALL LETTER IE WITH BREVE"    nil     )
    (#x0004d8 "CYRILLIC CAPITAL LETTER SCHWA"          nil     )
    (#x0004d9 "CYRILLIC SMALL LETTER SCHWA"            nil     )
    (#x0004da "CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS" nil     )
    (#x0004db "CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS" nil     )
    (#x0004dc "CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS" nil     )
    (#x0004dd "CYRILLIC SMALL LETTER ZHE WITH DIAERESIS" nil     )
    (#x0004de "CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS" nil     )
    (#x0004df "CYRILLIC SMALL LETTER ZE WITH DIAERESIS" nil     )
    (#x0004e0 "CYRILLIC CAPITAL LETTER ABKHASIAN DZE"  nil     )
    (#x0004e1 "CYRILLIC SMALL LETTER ABKHASIAN DZE"    nil     )
    (#x0004e2 "CYRILLIC CAPITAL LETTER I WITH MACRON"  nil     )
    (#x0004e3 "CYRILLIC SMALL LETTER I WITH MACRON"    nil     )
    (#x0004e4 "CYRILLIC CAPITAL LETTER I WITH DIAERESIS" nil     )
    (#x0004e5 "CYRILLIC SMALL LETTER I WITH DIAERESIS" nil     )
    (#x0004e6 "CYRILLIC CAPITAL LETTER O WITH DIAERESIS" nil     )
    (#x0004e7 "CYRILLIC SMALL LETTER O WITH DIAERESIS" nil     )
    (#x0004e8 "CYRILLIC CAPITAL LETTER BARRED O"       nil     )
    (#x0004e9 "CYRILLIC SMALL LETTER BARRED O"         nil     )
    (#x0004ea "CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS" nil     )
    (#x0004eb "CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS" nil     )
    (#x0004ec "CYRILLIC CAPITAL LETTER E WITH DIAERESIS" nil     )
    (#x0004ed "CYRILLIC SMALL LETTER E WITH DIAERESIS" nil     )
    (#x0004ee "CYRILLIC CAPITAL LETTER U WITH MACRON"  nil     )
    (#x0004ef "CYRILLIC SMALL LETTER U WITH MACRON"    nil     )
    (#x0004f0 "CYRILLIC CAPITAL LETTER U WITH DIAERESIS" nil     )
    (#x0004f1 "CYRILLIC SMALL LETTER U WITH DIAERESIS" nil     )
    (#x0004f2 "CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE" nil     )
    (#x0004f3 "CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE" nil     )
    (#x0004f4 "CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS" nil     )
    (#x0004f5 "CYRILLIC SMALL LETTER CHE WITH DIAERESIS" nil     )
    (#x0004f6 "CYRILLIC CAPITAL LETTER GHE WITH DESCENDER" nil     )
    (#x0004f7 "CYRILLIC SMALL LETTER GHE WITH DESCENDER" nil     )
    (#x0004f8 "CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS" nil     )
    (#x0004f9 "CYRILLIC SMALL LETTER YERU WITH DIAERESIS" nil     )
    (#x0004fa "CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK" nil     )
    (#x0004fb "CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK" nil     )
    (#x0004fc "CYRILLIC CAPITAL LETTER HA WITH HOOK"   nil     )
    (#x0004fd "CYRILLIC SMALL LETTER HA WITH HOOK"     nil     )
    (#x0004fe "CYRILLIC CAPITAL LETTER HA WITH STROKE" nil     )
    (#x0004ff "CYRILLIC SMALL LETTER HA WITH STROKE"   nil     )
    (#x000500 "CYRILLIC CAPITAL LETTER KOMI DE"        nil     )
    (#x000501 "CYRILLIC SMALL LETTER KOMI DE"          nil     )
    (#x000502 "CYRILLIC CAPITAL LETTER KOMI DJE"       nil     )
    (#x000503 "CYRILLIC SMALL LETTER KOMI DJE"         nil     )
    (#x000504 "CYRILLIC CAPITAL LETTER KOMI ZJE"       nil     )
    (#x000505 "CYRILLIC SMALL LETTER KOMI ZJE"         nil     )
    (#x000506 "CYRILLIC CAPITAL LETTER KOMI DZJE"      nil     )
    (#x000507 "CYRILLIC SMALL LETTER KOMI DZJE"        nil     )
    (#x000508 "CYRILLIC CAPITAL LETTER KOMI LJE"       nil     )
    (#x000509 "CYRILLIC SMALL LETTER KOMI LJE"         nil     )
    (#x00050a "CYRILLIC CAPITAL LETTER KOMI NJE"       nil     )
    (#x00050b "CYRILLIC SMALL LETTER KOMI NJE"         nil     )
    (#x00050c "CYRILLIC CAPITAL LETTER KOMI SJE"       nil     )
    (#x00050d "CYRILLIC SMALL LETTER KOMI SJE"         nil     )
    (#x00050e "CYRILLIC CAPITAL LETTER KOMI TJE"       nil     )
    (#x00050f "CYRILLIC SMALL LETTER KOMI TJE"         nil     )
    (#x000510 "CYRILLIC CAPITAL LETTER REVERSED ZE"    nil     )
    (#x000511 "CYRILLIC SMALL LETTER REVERSED ZE"      nil     )
    (#x000512 "CYRILLIC CAPITAL LETTER EL WITH HOOK"   nil     )
    (#x000513 "CYRILLIC SMALL LETTER EL WITH HOOK"     nil     )
    (#x000514 "CYRILLIC CAPITAL LETTER LHA"            nil     )
    (#x000515 "CYRILLIC SMALL LETTER LHA"              nil     )
    (#x000516 "CYRILLIC CAPITAL LETTER RHA"            nil     )
    (#x000517 "CYRILLIC SMALL LETTER RHA"              nil     )
    (#x000518 "CYRILLIC CAPITAL LETTER YAE"            nil     )
    (#x000519 "CYRILLIC SMALL LETTER YAE"              nil     )
    (#x00051a "CYRILLIC CAPITAL LETTER QA"             nil     )
    (#x00051b "CYRILLIC SMALL LETTER QA"               nil     )
    (#x00051c "CYRILLIC CAPITAL LETTER WE"             nil     )
    (#x00051d "CYRILLIC SMALL LETTER WE"               nil     )
    (#x00051e "CYRILLIC CAPITAL LETTER ALEUT KA"       nil     )
    (#x00051f "CYRILLIC SMALL LETTER ALEUT KA"         nil     )
    (#x000520 "CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK" nil     )
    (#x000521 "CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK" nil     )
    (#x000522 "CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK" nil     )
    (#x000523 "CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK" nil     )
    (#x000524 "CYRILLIC CAPITAL LETTER PE WITH DESCENDER" nil     )
    (#x000525 "CYRILLIC SMALL LETTER PE WITH DESCENDER" nil     )
    (#x000526 "CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER" nil     )
    (#x000527 "CYRILLIC SMALL LETTER SHHA WITH DESCENDER" nil     )
    (#x000528 "CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK" nil     )
    (#x000529 "CYRILLIC SMALL LETTER EN WITH LEFT HOOK" nil     )
    (#x00052a "CYRILLIC CAPITAL LETTER DZZHE"          nil     )
    (#x00052b "CYRILLIC SMALL LETTER DZZHE"            nil     )
    (#x00052c "CYRILLIC CAPITAL LETTER DCHE"           nil     )
    (#x00052d "CYRILLIC SMALL LETTER DCHE"             nil     )
    (#x00052e "CYRILLIC CAPITAL LETTER EL WITH DESCENDER" nil     )
    (#x00052f "CYRILLIC SMALL LETTER EL WITH DESCENDER" nil     )
    (#x000531 "ARMENIAN CAPITAL LETTER AYB"            nil     )
    (#x000532 "ARMENIAN CAPITAL LETTER BEN"            nil     )
    (#x000533 "ARMENIAN CAPITAL LETTER GIM"            nil     )
    (#x000534 "ARMENIAN CAPITAL LETTER DA"             nil     )
    (#x000535 "ARMENIAN CAPITAL LETTER ECH"            nil     )
    (#x000536 "ARMENIAN CAPITAL LETTER ZA"             nil     )
    (#x000537 "ARMENIAN CAPITAL LETTER EH"             nil     )
    (#x000538 "ARMENIAN CAPITAL LETTER ET"             nil     )
    (#x000539 "ARMENIAN CAPITAL LETTER TO"             nil     )
    (#x00053a "ARMENIAN CAPITAL LETTER ZHE"            nil     )
    (#x00053b "ARMENIAN CAPITAL LETTER INI"            nil     )
    (#x00053c "ARMENIAN CAPITAL LETTER LIWN"           nil     )
    (#x00053d "ARMENIAN CAPITAL LETTER XEH"            nil     )
    (#x00053e "ARMENIAN CAPITAL LETTER CA"             nil     )
    (#x00053f "ARMENIAN CAPITAL LETTER KEN"            nil     )
    (#x000540 "ARMENIAN CAPITAL LETTER HO"             nil     )
    (#x000541 "ARMENIAN CAPITAL LETTER JA"             nil     )
    (#x000542 "ARMENIAN CAPITAL LETTER GHAD"           nil     )
    (#x000543 "ARMENIAN CAPITAL LETTER CHEH"           nil     )
    (#x000544 "ARMENIAN CAPITAL LETTER MEN"            nil     )
    (#x000545 "ARMENIAN CAPITAL LETTER YI"             nil     )
    (#x000546 "ARMENIAN CAPITAL LETTER NOW"            nil     )
    (#x000547 "ARMENIAN CAPITAL LETTER SHA"            nil     )
    (#x000548 "ARMENIAN CAPITAL LETTER VO"             nil     )
    (#x000549 "ARMENIAN CAPITAL LETTER CHA"            nil     )
    (#x00054a "ARMENIAN CAPITAL LETTER PEH"            nil     )
    (#x00054b "ARMENIAN CAPITAL LETTER JHEH"           nil     )
    (#x00054c "ARMENIAN CAPITAL LETTER RA"             nil     )
    (#x00054d "ARMENIAN CAPITAL LETTER SEH"            nil     )
    (#x00054e "ARMENIAN CAPITAL LETTER VEW"            nil     )
    (#x00054f "ARMENIAN CAPITAL LETTER TIWN"           nil     )
    (#x000550 "ARMENIAN CAPITAL LETTER REH"            nil     )
    (#x000551 "ARMENIAN CAPITAL LETTER CO"             nil     )
    (#x000552 "ARMENIAN CAPITAL LETTER YIWN"           nil     )
    (#x000553 "ARMENIAN CAPITAL LETTER PIWR"           nil     )
    (#x000554 "ARMENIAN CAPITAL LETTER KEH"            nil     )
    (#x000555 "ARMENIAN CAPITAL LETTER OH"             nil     )
    (#x000556 "ARMENIAN CAPITAL LETTER FEH"            nil     )
    (#x000559 "ARMENIAN MODIFIER LETTER LEFT HALF RING" nil     )
    (#x00055a "ARMENIAN APOSTROPHE"                    nil     )
    (#x00055b "ARMENIAN EMPHASIS MARK"                 nil     )
    (#x00055c "ARMENIAN EXCLAMATION MARK"              nil     )
    (#x00055d "ARMENIAN COMMA"                         nil     )
    (#x00055e "ARMENIAN QUESTION MARK"                 nil     )
    (#x00055f "ARMENIAN ABBREVIATION MARK"             nil     )
    (#x000560 "ARMENIAN SMALL LETTER TURNED AYB"       nil     )
    (#x000561 "ARMENIAN SMALL LETTER AYB"              nil     )
    (#x000562 "ARMENIAN SMALL LETTER BEN"              nil     )
    (#x000563 "ARMENIAN SMALL LETTER GIM"              nil     )
    (#x000564 "ARMENIAN SMALL LETTER DA"               nil     )
    (#x000565 "ARMENIAN SMALL LETTER ECH"              nil     )
    (#x000566 "ARMENIAN SMALL LETTER ZA"               nil     )
    (#x000567 "ARMENIAN SMALL LETTER EH"               nil     )
    (#x000568 "ARMENIAN SMALL LETTER ET"               nil     )
    (#x000569 "ARMENIAN SMALL LETTER TO"               nil     )
    (#x00056a "ARMENIAN SMALL LETTER ZHE"              nil     )
    (#x00056b "ARMENIAN SMALL LETTER INI"              nil     )
    (#x00056c "ARMENIAN SMALL LETTER LIWN"             nil     )
    (#x00056d "ARMENIAN SMALL LETTER XEH"              nil     )
    (#x00056e "ARMENIAN SMALL LETTER CA"               nil     )
    (#x00056f "ARMENIAN SMALL LETTER KEN"              nil     )
    (#x000570 "ARMENIAN SMALL LETTER HO"               nil     )
    (#x000571 "ARMENIAN SMALL LETTER JA"               nil     )
    (#x000572 "ARMENIAN SMALL LETTER GHAD"             nil     )
    (#x000573 "ARMENIAN SMALL LETTER CHEH"             nil     )
    (#x000574 "ARMENIAN SMALL LETTER MEN"              nil     )
    (#x000575 "ARMENIAN SMALL LETTER YI"               nil     )
    (#x000576 "ARMENIAN SMALL LETTER NOW"              nil     )
    (#x000577 "ARMENIAN SMALL LETTER SHA"              nil     )
    (#x000578 "ARMENIAN SMALL LETTER VO"               nil     )
    (#x000579 "ARMENIAN SMALL LETTER CHA"              nil     )
    (#x00057a "ARMENIAN SMALL LETTER PEH"              nil     )
    (#x00057b "ARMENIAN SMALL LETTER JHEH"             nil     )
    (#x00057c "ARMENIAN SMALL LETTER RA"               nil     )
    (#x00057d "ARMENIAN SMALL LETTER SEH"              nil     )
    (#x00057e "ARMENIAN SMALL LETTER VEW"              nil     )
    (#x00057f "ARMENIAN SMALL LETTER TIWN"             nil     )
    (#x000580 "ARMENIAN SMALL LETTER REH"              nil     )
    (#x000581 "ARMENIAN SMALL LETTER CO"               nil     )
    (#x000582 "ARMENIAN SMALL LETTER YIWN"             nil     )
    (#x000583 "ARMENIAN SMALL LETTER PIWR"             nil     )
    (#x000584 "ARMENIAN SMALL LETTER KEH"              nil     )
    (#x000585 "ARMENIAN SMALL LETTER OH"               nil     )
    (#x000586 "ARMENIAN SMALL LETTER FEH"              nil     )
    (#x000587 "ARMENIAN SMALL LIGATURE ECH YIWN"       nil     )
    (#x000588 "ARMENIAN SMALL LETTER YI WITH STROKE"   nil     )
    (#x000589 "ARMENIAN FULL STOP"                     nil     )
    (#x00058a "ARMENIAN HYPHEN"                        nil     )
    (#x00058d "RIGHT-FACING ARMENIAN ETERNITY SIGN"    nil     )
    (#x00058e "LEFT-FACING ARMENIAN ETERNITY SIGN"     nil     )
    (#x00058f "ARMENIAN DRAM SIGN"                     nil     )
    (#x000591 "HEBREW ACCENT ETNAHTA"                  nil     )
    (#x000592 "HEBREW ACCENT SEGOL"                    nil     )
    (#x000593 "HEBREW ACCENT SHALSHELET"               nil     )
    (#x000594 "HEBREW ACCENT ZAQEF QATAN"              nil     )
    (#x000595 "HEBREW ACCENT ZAQEF GADOL"              nil     )
    (#x000596 "HEBREW ACCENT TIPEHA"                   nil     )
    (#x000597 "HEBREW ACCENT REVIA"                    nil     )
    (#x000598 "HEBREW ACCENT ZARQA"                    nil     )
    (#x000599 "HEBREW ACCENT PASHTA"                   nil     )
    (#x00059a "HEBREW ACCENT YETIV"                    nil     )
    (#x00059b "HEBREW ACCENT TEVIR"                    nil     )
    (#x00059c "HEBREW ACCENT GERESH"                   nil     )
    (#x00059d "HEBREW ACCENT GERESH MUQDAM"            nil     )
    (#x00059e "HEBREW ACCENT GERSHAYIM"                nil     )
    (#x00059f "HEBREW ACCENT QARNEY PARA"              nil     )
    (#x0005a0 "HEBREW ACCENT TELISHA GEDOLA"           nil     )
    (#x0005a1 "HEBREW ACCENT PAZER"                    nil     )
    (#x0005a2 "HEBREW ACCENT ATNAH HAFUKH"             nil     )
    (#x0005a3 "HEBREW ACCENT MUNAH"                    nil     )
    (#x0005a4 "HEBREW ACCENT MAHAPAKH"                 nil     )
    (#x0005a5 "HEBREW ACCENT MERKHA"                   nil     )
    (#x0005a6 "HEBREW ACCENT MERKHA KEFULA"            nil     )
    (#x0005a7 "HEBREW ACCENT DARGA"                    nil     )
    (#x0005a8 "HEBREW ACCENT QADMA"                    nil     )
    (#x0005a9 "HEBREW ACCENT TELISHA QETANA"           nil     )
    (#x0005aa "HEBREW ACCENT YERAH BEN YOMO"           nil     )
    (#x0005ab "HEBREW ACCENT OLE"                      nil     )
    (#x0005ac "HEBREW ACCENT ILUY"                     nil     )
    (#x0005ad "HEBREW ACCENT DEHI"                     nil     )
    (#x0005ae "HEBREW ACCENT ZINOR"                    nil     )
    (#x0005af "HEBREW MARK MASORA CIRCLE"              nil     )
    (#x0005b0 "HEBREW POINT SHEVA"                     nil     )
    (#x0005b1 "HEBREW POINT HATAF SEGOL"               nil     )
    (#x0005b2 "HEBREW POINT HATAF PATAH"               nil     )
    (#x0005b3 "HEBREW POINT HATAF QAMATS"              nil     )
    (#x0005b4 "HEBREW POINT HIRIQ"                     nil     )
    (#x0005b5 "HEBREW POINT TSERE"                     nil     )
    (#x0005b6 "HEBREW POINT SEGOL"                     nil     )
    (#x0005b7 "HEBREW POINT PATAH"                     nil     )
    (#x0005b8 "HEBREW POINT QAMATS"                    nil     )
    (#x0005b9 "HEBREW POINT HOLAM"                     nil     )
    (#x0005ba "HEBREW POINT HOLAM HASER FOR VAV"       nil     )
    (#x0005bb "HEBREW POINT QUBUTS"                    nil     )
    (#x0005bc "HEBREW POINT DAGESH OR MAPIQ"           nil     )
    (#x0005bd "HEBREW POINT METEG"                     nil     )
    (#x0005be "HEBREW PUNCTUATION MAQAF"               nil     )
    (#x0005bf "HEBREW POINT RAFE"                      nil     )
    (#x0005c0 "HEBREW PUNCTUATION PASEQ"               nil     )
    (#x0005c1 "HEBREW POINT SHIN DOT"                  nil     )
    (#x0005c2 "HEBREW POINT SIN DOT"                   nil     )
    (#x0005c3 "HEBREW PUNCTUATION SOF PASUQ"           nil     )
    (#x0005c4 "HEBREW MARK UPPER DOT"                  nil     )
    (#x0005c5 "HEBREW MARK LOWER DOT"                  nil     )
    (#x0005c6 "HEBREW PUNCTUATION NUN HAFUKHA"         nil     )
    (#x0005c7 "HEBREW POINT QAMATS QATAN"              nil     )
    (#x0005d0 "HEBREW LETTER ALEF"                     nil     )
    (#x0005d1 "HEBREW LETTER BET"                      nil     )
    (#x0005d2 "HEBREW LETTER GIMEL"                    nil     )
    (#x0005d3 "HEBREW LETTER DALET"                    nil     )
    (#x0005d4 "HEBREW LETTER HE"                       nil     )
    (#x0005d5 "HEBREW LETTER VAV"                      nil     )
    (#x0005d6 "HEBREW LETTER ZAYIN"                    nil     )
    (#x0005d7 "HEBREW LETTER HET"                      nil     )
    (#x0005d8 "HEBREW LETTER TET"                      nil     )
    (#x0005d9 "HEBREW LETTER YOD"                      nil     )
    (#x0005da "HEBREW LETTER FINAL KAF"                nil     )
    (#x0005db "HEBREW LETTER KAF"                      nil     )
    (#x0005dc "HEBREW LETTER LAMED"                    nil     )
    (#x0005dd "HEBREW LETTER FINAL MEM"                nil     )
    (#x0005de "HEBREW LETTER MEM"                      nil     )
    (#x0005df "HEBREW LETTER FINAL NUN"                nil     )
    (#x0005e0 "HEBREW LETTER NUN"                      nil     )
    (#x0005e1 "HEBREW LETTER SAMEKH"                   nil     )
    (#x0005e2 "HEBREW LETTER AYIN"                     nil     )
    (#x0005e3 "HEBREW LETTER FINAL PE"                 nil     )
    (#x0005e4 "HEBREW LETTER PE"                       nil     )
    (#x0005e5 "HEBREW LETTER FINAL TSADI"              nil     )
    (#x0005e6 "HEBREW LETTER TSADI"                    nil     )
    (#x0005e7 "HEBREW LETTER QOF"                      nil     )
    (#x0005e8 "HEBREW LETTER RESH"                     nil     )
    (#x0005e9 "HEBREW LETTER SHIN"                     nil     )
    (#x0005ea "HEBREW LETTER TAV"                      nil     )
    (#x0005ef "HEBREW YOD TRIANGLE"                    nil     )
    (#x0005f0 "HEBREW LIGATURE YIDDISH DOUBLE VAV"     nil     )
    (#x0005f1 "HEBREW LIGATURE YIDDISH VAV YOD"        nil     )
    (#x0005f2 "HEBREW LIGATURE YIDDISH DOUBLE YOD"     nil     )
    (#x0005f3 "HEBREW PUNCTUATION GERESH"              nil     )
    (#x0005f4 "HEBREW PUNCTUATION GERSHAYIM"           nil     )
    (#x000600 "ARABIC NUMBER SIGN"                     nil     )
    (#x000601 "ARABIC SIGN SANAH"                      nil     )
    (#x000602 "ARABIC FOOTNOTE MARKER"                 nil     )
    (#x000603 "ARABIC SIGN SAFHA"                      nil     )
    (#x000604 "ARABIC SIGN SAMVAT"                     nil     )
    (#x000605 "ARABIC NUMBER MARK ABOVE"               nil     )
    (#x000606 "ARABIC-INDIC CUBE ROOT"                 nil     )
    (#x000607 "ARABIC-INDIC FOURTH ROOT"               nil     )
    (#x000608 "ARABIC RAY"                             nil     )
    (#x000609 "ARABIC-INDIC PER MILLE SIGN"            nil     )
    (#x00060a "ARABIC-INDIC PER TEN THOUSAND SIGN"     nil     )
    (#x00060b "AFGHANI SIGN"                           nil     )
    (#x00060c "ARABIC COMMA"                           nil     )
    (#x00060d "ARABIC DATE SEPARATOR"                  nil     )
    (#x00060e "ARABIC POETIC VERSE SIGN"               nil     )
    (#x00060f "ARABIC SIGN MISRA"                      nil     )
    (#x000610 "ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM" nil     )
    (#x000611 "ARABIC SIGN ALAYHE ASSALLAM"            nil     )
    (#x000612 "ARABIC SIGN RAHMATULLAH ALAYHE"         nil     )
    (#x000613 "ARABIC SIGN RADI ALLAHOU ANHU"          nil     )
    (#x000614 "ARABIC SIGN TAKHALLUS"                  nil     )
    (#x000615 "ARABIC SMALL HIGH TAH"                  nil     )
    (#x000616 "ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH" nil     )
    (#x000617 "ARABIC SMALL HIGH ZAIN"                 nil     )
    (#x000618 "ARABIC SMALL FATHA"                     nil     )
    (#x000619 "ARABIC SMALL DAMMA"                     nil     )
    (#x00061a "ARABIC SMALL KASRA"                     nil     )
    (#x00061b "ARABIC SEMICOLON"                       nil     )
    (#x00061c "ARABIC LETTER MARK"                     nil     )
    (#x00061d "ARABIC END OF TEXT MARK"                nil     )
    (#x00061e "ARABIC TRIPLE DOT PUNCTUATION MARK"     nil     )
    (#x00061f "ARABIC QUESTION MARK"                   nil     )
    (#x000620 "ARABIC LETTER KASHMIRI YEH"             nil     )
    (#x000621 "ARABIC LETTER HAMZA"                    nil     )
    (#x000622 "ARABIC LETTER ALEF WITH MADDA ABOVE"    nil     )
    (#x000623 "ARABIC LETTER ALEF WITH HAMZA ABOVE"    nil     )
    (#x000624 "ARABIC LETTER WAW WITH HAMZA ABOVE"     nil     )
    (#x000625 "ARABIC LETTER ALEF WITH HAMZA BELOW"    nil     )
    (#x000626 "ARABIC LETTER YEH WITH HAMZA ABOVE"     nil     )
    (#x000627 "ARABIC LETTER ALEF"                     nil     )
    (#x000628 "ARABIC LETTER BEH"                      nil     )
    (#x000629 "ARABIC LETTER TEH MARBUTA"              nil     )
    (#x00062a "ARABIC LETTER TEH"                      nil     )
    (#x00062b "ARABIC LETTER THEH"                     nil     )
    (#x00062c "ARABIC LETTER JEEM"                     nil     )
    (#x00062d "ARABIC LETTER HAH"                      nil     )
    (#x00062e "ARABIC LETTER KHAH"                     nil     )
    (#x00062f "ARABIC LETTER DAL"                      nil     )
    (#x000630 "ARABIC LETTER THAL"                     nil     )
    (#x000631 "ARABIC LETTER REH"                      nil     )
    (#x000632 "ARABIC LETTER ZAIN"                     nil     )
    (#x000633 "ARABIC LETTER SEEN"                     nil     )
    (#x000634 "ARABIC LETTER SHEEN"                    nil     )
    (#x000635 "ARABIC LETTER SAD"                      nil     )
    (#x000636 "ARABIC LETTER DAD"                      nil     )
    (#x000637 "ARABIC LETTER TAH"                      nil     )
    (#x000638 "ARABIC LETTER ZAH"                      nil     )
    (#x000639 "ARABIC LETTER AIN"                      nil     )
    (#x00063a "ARABIC LETTER GHAIN"                    nil     )
    (#x00063b "ARABIC LETTER KEHEH WITH TWO DOTS ABOVE" nil     )
    (#x00063c "ARABIC LETTER KEHEH WITH THREE DOTS BELOW" nil     )
    (#x00063d "ARABIC LETTER FARSI YEH WITH INVERTED V" nil     )
    (#x00063e "ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE" nil     )
    (#x00063f "ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE" nil     )
    (#x000640 "ARABIC TATWEEL"                         nil     )
    (#x000641 "ARABIC LETTER FEH"                      nil     )
    (#x000642 "ARABIC LETTER QAF"                      nil     )
    (#x000643 "ARABIC LETTER KAF"                      nil     )
    (#x000644 "ARABIC LETTER LAM"                      nil     )
    (#x000645 "ARABIC LETTER MEEM"                     nil     )
    (#x000646 "ARABIC LETTER NOON"                     nil     )
    (#x000647 "ARABIC LETTER HEH"                      nil     )
    (#x000648 "ARABIC LETTER WAW"                      nil     )
    (#x000649 "ARABIC LETTER ALEF MAKSURA"             nil     )
    (#x00064a "ARABIC LETTER YEH"                      nil     )
    (#x00064b "ARABIC FATHATAN"                        nil     )
    (#x00064c "ARABIC DAMMATAN"                        nil     )
    (#x00064d "ARABIC KASRATAN"                        nil     )
    (#x00064e "ARABIC FATHA"                           nil     )
    (#x00064f "ARABIC DAMMA"                           nil     )
    (#x000650 "ARABIC KASRA"                           nil     )
    (#x000651 "ARABIC SHADDA"                          nil     )
    (#x000652 "ARABIC SUKUN"                           nil     )
    (#x000653 "ARABIC MADDAH ABOVE"                    nil     )
    (#x000654 "ARABIC HAMZA ABOVE"                     nil     )
    (#x000655 "ARABIC HAMZA BELOW"                     nil     )
    (#x000656 "ARABIC SUBSCRIPT ALEF"                  nil     )
    (#x000657 "ARABIC INVERTED DAMMA"                  nil     )
    (#x000658 "ARABIC MARK NOON GHUNNA"                nil     )
    (#x000659 "ARABIC ZWARAKAY"                        nil     )
    (#x00065a "ARABIC VOWEL SIGN SMALL V ABOVE"        nil     )
    (#x00065b "ARABIC VOWEL SIGN INVERTED SMALL V ABOVE" nil     )
    (#x00065c "ARABIC VOWEL SIGN DOT BELOW"            nil     )
    (#x00065d "ARABIC REVERSED DAMMA"                  nil     )
    (#x00065e "ARABIC FATHA WITH TWO DOTS"             nil     )
    (#x00065f "ARABIC WAVY HAMZA BELOW"                nil     )
    (#x000660 "ARABIC-INDIC DIGIT ZERO"                nil     )
    (#x000661 "ARABIC-INDIC DIGIT ONE"                 nil     )
    (#x000662 "ARABIC-INDIC DIGIT TWO"                 nil     )
    (#x000663 "ARABIC-INDIC DIGIT THREE"               nil     )
    (#x000664 "ARABIC-INDIC DIGIT FOUR"                nil     )
    (#x000665 "ARABIC-INDIC DIGIT FIVE"                nil     )
    (#x000666 "ARABIC-INDIC DIGIT SIX"                 nil     )
    (#x000667 "ARABIC-INDIC DIGIT SEVEN"               nil     )
    (#x000668 "ARABIC-INDIC DIGIT EIGHT"               nil     )
    (#x000669 "ARABIC-INDIC DIGIT NINE"                nil     )
    (#x00066a "ARABIC PERCENT SIGN"                    nil     )
    (#x00066b "ARABIC DECIMAL SEPARATOR"               nil     )
    (#x00066c "ARABIC THOUSANDS SEPARATOR"             nil     )
    (#x00066d "ARABIC FIVE POINTED STAR"               nil     )
    (#x00066e "ARABIC LETTER DOTLESS BEH"              nil     )
    (#x00066f "ARABIC LETTER DOTLESS QAF"              nil     )
    (#x000670 "ARABIC LETTER SUPERSCRIPT ALEF"         nil     )
    (#x000671 "ARABIC LETTER ALEF WASLA"               nil     )
    (#x000672 "ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE" nil     )
    (#x000673 "ARABIC LETTER ALEF WITH WAVY HAMZA BELOW" nil     )
    (#x000674 "ARABIC LETTER HIGH HAMZA"               nil     )
    (#x000675 "ARABIC LETTER HIGH HAMZA ALEF"          nil     )
    (#x000676 "ARABIC LETTER HIGH HAMZA WAW"           nil     )
    (#x000677 "ARABIC LETTER U WITH HAMZA ABOVE"       nil     )
    (#x000678 "ARABIC LETTER HIGH HAMZA YEH"           nil     )
    (#x000679 "ARABIC LETTER TTEH"                     nil     )
    (#x00067a "ARABIC LETTER TTEHEH"                   nil     )
    (#x00067b "ARABIC LETTER BEEH"                     nil     )
    (#x00067c "ARABIC LETTER TEH WITH RING"            nil     )
    (#x00067d "ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS" nil     )
    (#x00067e "ARABIC LETTER PEH"                      nil     )
    (#x00067f "ARABIC LETTER TEHEH"                    nil     )
    (#x000680 "ARABIC LETTER BEHEH"                    nil     )
    (#x000681 "ARABIC LETTER HAH WITH HAMZA ABOVE"     nil     )
    (#x000682 "ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE" nil     )
    (#x000683 "ARABIC LETTER NYEH"                     nil     )
    (#x000684 "ARABIC LETTER DYEH"                     nil     )
    (#x000685 "ARABIC LETTER HAH WITH THREE DOTS ABOVE" nil     )
    (#x000686 "ARABIC LETTER TCHEH"                    nil     )
    (#x000687 "ARABIC LETTER TCHEHEH"                  nil     )
    (#x000688 "ARABIC LETTER DDAL"                     nil     )
    (#x000689 "ARABIC LETTER DAL WITH RING"            nil     )
    (#x00068a "ARABIC LETTER DAL WITH DOT BELOW"       nil     )
    (#x00068b "ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH" nil     )
    (#x00068c "ARABIC LETTER DAHAL"                    nil     )
    (#x00068d "ARABIC LETTER DDAHAL"                   nil     )
    (#x00068e "ARABIC LETTER DUL"                      nil     )
    (#x00068f "ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS" nil     )
    (#x000690 "ARABIC LETTER DAL WITH FOUR DOTS ABOVE" nil     )
    (#x000691 "ARABIC LETTER RREH"                     nil     )
    (#x000692 "ARABIC LETTER REH WITH SMALL V"         nil     )
    (#x000693 "ARABIC LETTER REH WITH RING"            nil     )
    (#x000694 "ARABIC LETTER REH WITH DOT BELOW"       nil     )
    (#x000695 "ARABIC LETTER REH WITH SMALL V BELOW"   nil     )
    (#x000696 "ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE" nil     )
    (#x000697 "ARABIC LETTER REH WITH TWO DOTS ABOVE"  nil     )
    (#x000698 "ARABIC LETTER JEH"                      nil     )
    (#x000699 "ARABIC LETTER REH WITH FOUR DOTS ABOVE" nil     )
    (#x00069a "ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE" nil     )
    (#x00069b "ARABIC LETTER SEEN WITH THREE DOTS BELOW" nil     )
    (#x00069c "ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE" nil     )
    (#x00069d "ARABIC LETTER SAD WITH TWO DOTS BELOW"  nil     )
    (#x00069e "ARABIC LETTER SAD WITH THREE DOTS ABOVE" nil     )
    (#x00069f "ARABIC LETTER TAH WITH THREE DOTS ABOVE" nil     )
    (#x0006a0 "ARABIC LETTER AIN WITH THREE DOTS ABOVE" nil     )
    (#x0006a1 "ARABIC LETTER DOTLESS FEH"              nil     )
    (#x0006a2 "ARABIC LETTER FEH WITH DOT MOVED BELOW" nil     )
    (#x0006a3 "ARABIC LETTER FEH WITH DOT BELOW"       nil     )
    (#x0006a4 "ARABIC LETTER VEH"                      nil     )
    (#x0006a5 "ARABIC LETTER FEH WITH THREE DOTS BELOW" nil     )
    (#x0006a6 "ARABIC LETTER PEHEH"                    nil     )
    (#x0006a7 "ARABIC LETTER QAF WITH DOT ABOVE"       nil     )
    (#x0006a8 "ARABIC LETTER QAF WITH THREE DOTS ABOVE" nil     )
    (#x0006a9 "ARABIC LETTER KEHEH"                    nil     )
    (#x0006aa "ARABIC LETTER SWASH KAF"                nil     )
    (#x0006ab "ARABIC LETTER KAF WITH RING"            nil     )
    (#x0006ac "ARABIC LETTER KAF WITH DOT ABOVE"       nil     )
    (#x0006ad "ARABIC LETTER NG"                       nil     )
    (#x0006ae "ARABIC LETTER KAF WITH THREE DOTS BELOW" nil     )
    (#x0006af "ARABIC LETTER GAF"                      nil     )
    (#x0006b0 "ARABIC LETTER GAF WITH RING"            nil     )
    (#x0006b1 "ARABIC LETTER NGOEH"                    nil     )
    (#x0006b2 "ARABIC LETTER GAF WITH TWO DOTS BELOW"  nil     )
    (#x0006b3 "ARABIC LETTER GUEH"                     nil     )
    (#x0006b4 "ARABIC LETTER GAF WITH THREE DOTS ABOVE" nil     )
    (#x0006b5 "ARABIC LETTER LAM WITH SMALL V"         nil     )
    (#x0006b6 "ARABIC LETTER LAM WITH DOT ABOVE"       nil     )
    (#x0006b7 "ARABIC LETTER LAM WITH THREE DOTS ABOVE" nil     )
    (#x0006b8 "ARABIC LETTER LAM WITH THREE DOTS BELOW" nil     )
    (#x0006b9 "ARABIC LETTER NOON WITH DOT BELOW"      nil     )
    (#x0006ba "ARABIC LETTER NOON GHUNNA"              nil     )
    (#x0006bb "ARABIC LETTER RNOON"                    nil     )
    (#x0006bc "ARABIC LETTER NOON WITH RING"           nil     )
    (#x0006bd "ARABIC LETTER NOON WITH THREE DOTS ABOVE" nil     )
    (#x0006be "ARABIC LETTER HEH DOACHASHMEE"          nil     )
    (#x0006bf "ARABIC LETTER TCHEH WITH DOT ABOVE"     nil     )
    (#x0006c0 "ARABIC LETTER HEH WITH YEH ABOVE"       nil     )
    (#x0006c1 "ARABIC LETTER HEH GOAL"                 nil     )
    (#x0006c2 "ARABIC LETTER HEH GOAL WITH HAMZA ABOVE" nil     )
    (#x0006c3 "ARABIC LETTER TEH MARBUTA GOAL"         nil     )
    (#x0006c4 "ARABIC LETTER WAW WITH RING"            nil     )
    (#x0006c5 "ARABIC LETTER KIRGHIZ OE"               nil     )
    (#x0006c6 "ARABIC LETTER OE"                       nil     )
    (#x0006c7 "ARABIC LETTER U"                        nil     )
    (#x0006c8 "ARABIC LETTER YU"                       nil     )
    (#x0006c9 "ARABIC LETTER KIRGHIZ YU"               nil     )
    (#x0006ca "ARABIC LETTER WAW WITH TWO DOTS ABOVE"  nil     )
    (#x0006cb "ARABIC LETTER VE"                       nil     )
    (#x0006cc "ARABIC LETTER FARSI YEH"                nil     )
    (#x0006cd "ARABIC LETTER YEH WITH TAIL"            nil     )
    (#x0006ce "ARABIC LETTER YEH WITH SMALL V"         nil     )
    (#x0006cf "ARABIC LETTER WAW WITH DOT ABOVE"       nil     )
    (#x0006d0 "ARABIC LETTER E"                        nil     )
    (#x0006d1 "ARABIC LETTER YEH WITH THREE DOTS BELOW" nil     )
    (#x0006d2 "ARABIC LETTER YEH BARREE"               nil     )
    (#x0006d3 "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE" nil     )
    (#x0006d4 "ARABIC FULL STOP"                       nil     )
    (#x0006d5 "ARABIC LETTER AE"                       nil     )
    (#x0006d6 "ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA" nil     )
    (#x0006d7 "ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA" nil     )
    (#x0006d8 "ARABIC SMALL HIGH MEEM INITIAL FORM"    nil     )
    (#x0006d9 "ARABIC SMALL HIGH LAM ALEF"             nil     )
    (#x0006da "ARABIC SMALL HIGH JEEM"                 nil     )
    (#x0006db "ARABIC SMALL HIGH THREE DOTS"           nil     )
    (#x0006dc "ARABIC SMALL HIGH SEEN"                 nil     )
    (#x0006dd "ARABIC END OF AYAH"                     nil     )
    (#x0006de "ARABIC START OF RUB EL HIZB"            nil     )
    (#x0006df "ARABIC SMALL HIGH ROUNDED ZERO"         nil     )
    (#x0006e0 "ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO" nil     )
    (#x0006e1 "ARABIC SMALL HIGH DOTLESS HEAD OF KHAH" nil     )
    (#x0006e2 "ARABIC SMALL HIGH MEEM ISOLATED FORM"   nil     )
    (#x0006e3 "ARABIC SMALL LOW SEEN"                  nil     )
    (#x0006e4 "ARABIC SMALL HIGH MADDA"                nil     )
    (#x0006e5 "ARABIC SMALL WAW"                       nil     )
    (#x0006e6 "ARABIC SMALL YEH"                       nil     )
    (#x0006e7 "ARABIC SMALL HIGH YEH"                  nil     )
    (#x0006e8 "ARABIC SMALL HIGH NOON"                 nil     )
    (#x0006e9 "ARABIC PLACE OF SAJDAH"                 nil     )
    (#x0006ea "ARABIC EMPTY CENTRE LOW STOP"           nil     )
    (#x0006eb "ARABIC EMPTY CENTRE HIGH STOP"          nil     )
    (#x0006ec "ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE" nil     )
    (#x0006ed "ARABIC SMALL LOW MEEM"                  nil     )
    (#x0006ee "ARABIC LETTER DAL WITH INVERTED V"      nil     )
    (#x0006ef "ARABIC LETTER REH WITH INVERTED V"      nil     )
    (#x0006f0 "EXTENDED ARABIC-INDIC DIGIT ZERO"       nil     )
    (#x0006f1 "EXTENDED ARABIC-INDIC DIGIT ONE"        nil     )
    (#x0006f2 "EXTENDED ARABIC-INDIC DIGIT TWO"        nil     )
    (#x0006f3 "EXTENDED ARABIC-INDIC DIGIT THREE"      nil     )
    (#x0006f4 "EXTENDED ARABIC-INDIC DIGIT FOUR"       nil     )
    (#x0006f5 "EXTENDED ARABIC-INDIC DIGIT FIVE"       nil     )
    (#x0006f6 "EXTENDED ARABIC-INDIC DIGIT SIX"        nil     )
    (#x0006f7 "EXTENDED ARABIC-INDIC DIGIT SEVEN"      nil     )
    (#x0006f8 "EXTENDED ARABIC-INDIC DIGIT EIGHT"      nil     )
    (#x0006f9 "EXTENDED ARABIC-INDIC DIGIT NINE"       nil     )
    (#x0006fa "ARABIC LETTER SHEEN WITH DOT BELOW"     nil     )
    (#x0006fb "ARABIC LETTER DAD WITH DOT BELOW"       nil     )
    (#x0006fc "ARABIC LETTER GHAIN WITH DOT BELOW"     nil     )
    (#x0006fd "ARABIC SIGN SINDHI AMPERSAND"           nil     )
    (#x0006fe "ARABIC SIGN SINDHI POSTPOSITION MEN"    nil     )
    (#x0006ff "ARABIC LETTER HEH WITH INVERTED V"      nil     )
    (#x000700 "SYRIAC END OF PARAGRAPH"                nil     )
    (#x000701 "SYRIAC SUPRALINEAR FULL STOP"           nil     )
    (#x000702 "SYRIAC SUBLINEAR FULL STOP"             nil     )
    (#x000703 "SYRIAC SUPRALINEAR COLON"               nil     )
    (#x000704 "SYRIAC SUBLINEAR COLON"                 nil     )
    (#x000705 "SYRIAC HORIZONTAL COLON"                nil     )
    (#x000706 "SYRIAC COLON SKEWED LEFT"               nil     )
    (#x000707 "SYRIAC COLON SKEWED RIGHT"              nil     )
    (#x000708 "SYRIAC SUPRALINEAR COLON SKEWED LEFT"   nil     )
    (#x000709 "SYRIAC SUBLINEAR COLON SKEWED RIGHT"    nil     )
    (#x00070a "SYRIAC CONTRACTION"                     nil     )
    (#x00070b "SYRIAC HARKLEAN OBELUS"                 nil     )
    (#x00070c "SYRIAC HARKLEAN METOBELUS"              nil     )
    (#x00070d "SYRIAC HARKLEAN ASTERISCUS"             nil     )
    (#x00070f "SYRIAC ABBREVIATION MARK"               nil     )
    (#x000710 "SYRIAC LETTER ALAPH"                    nil     )
    (#x000711 "SYRIAC LETTER SUPERSCRIPT ALAPH"        nil     )
    (#x000712 "SYRIAC LETTER BETH"                     nil     )
    (#x000713 "SYRIAC LETTER GAMAL"                    nil     )
    (#x000714 "SYRIAC LETTER GAMAL GARSHUNI"           nil     )
    (#x000715 "SYRIAC LETTER DALATH"                   nil     )
    (#x000716 "SYRIAC LETTER DOTLESS DALATH RISH"      nil     )
    (#x000717 "SYRIAC LETTER HE"                       nil     )
    (#x000718 "SYRIAC LETTER WAW"                      nil     )
    (#x000719 "SYRIAC LETTER ZAIN"                     nil     )
    (#x00071a "SYRIAC LETTER HETH"                     nil     )
    (#x00071b "SYRIAC LETTER TETH"                     nil     )
    (#x00071c "SYRIAC LETTER TETH GARSHUNI"            nil     )
    (#x00071d "SYRIAC LETTER YUDH"                     nil     )
    (#x00071e "SYRIAC LETTER YUDH HE"                  nil     )
    (#x00071f "SYRIAC LETTER KAPH"                     nil     )
    (#x000720 "SYRIAC LETTER LAMADH"                   nil     )
    (#x000721 "SYRIAC LETTER MIM"                      nil     )
    (#x000722 "SYRIAC LETTER NUN"                      nil     )
    (#x000723 "SYRIAC LETTER SEMKATH"                  nil     )
    (#x000724 "SYRIAC LETTER FINAL SEMKATH"            nil     )
    (#x000725 "SYRIAC LETTER E"                        nil     )
    (#x000726 "SYRIAC LETTER PE"                       nil     )
    (#x000727 "SYRIAC LETTER REVERSED PE"              nil     )
    (#x000728 "SYRIAC LETTER SADHE"                    nil     )
    (#x000729 "SYRIAC LETTER QAPH"                     nil     )
    (#x00072a "SYRIAC LETTER RISH"                     nil     )
    (#x00072b "SYRIAC LETTER SHIN"                     nil     )
    (#x00072c "SYRIAC LETTER TAW"                      nil     )
    (#x00072d "SYRIAC LETTER PERSIAN BHETH"            nil     )
    (#x00072e "SYRIAC LETTER PERSIAN GHAMAL"           nil     )
    (#x00072f "SYRIAC LETTER PERSIAN DHALATH"          nil     )
    (#x000730 "SYRIAC PTHAHA ABOVE"                    nil     )
    (#x000731 "SYRIAC PTHAHA BELOW"                    nil     )
    (#x000732 "SYRIAC PTHAHA DOTTED"                   nil     )
    (#x000733 "SYRIAC ZQAPHA ABOVE"                    nil     )
    (#x000734 "SYRIAC ZQAPHA BELOW"                    nil     )
    (#x000735 "SYRIAC ZQAPHA DOTTED"                   nil     )
    (#x000736 "SYRIAC RBASA ABOVE"                     nil     )
    (#x000737 "SYRIAC RBASA BELOW"                     nil     )
    (#x000738 "SYRIAC DOTTED ZLAMA HORIZONTAL"         nil     )
    (#x000739 "SYRIAC DOTTED ZLAMA ANGULAR"            nil     )
    (#x00073a "SYRIAC HBASA ABOVE"                     nil     )
    (#x00073b "SYRIAC HBASA BELOW"                     nil     )
    (#x00073c "SYRIAC HBASA-ESASA DOTTED"              nil     )
    (#x00073d "SYRIAC ESASA ABOVE"                     nil     )
    (#x00073e "SYRIAC ESASA BELOW"                     nil     )
    (#x00073f "SYRIAC RWAHA"                           nil     )
    (#x000740 "SYRIAC FEMININE DOT"                    nil     )
    (#x000741 "SYRIAC QUSHSHAYA"                       nil     )
    (#x000742 "SYRIAC RUKKAKHA"                        nil     )
    (#x000743 "SYRIAC TWO VERTICAL DOTS ABOVE"         nil     )
    (#x000744 "SYRIAC TWO VERTICAL DOTS BELOW"         nil     )
    (#x000745 "SYRIAC THREE DOTS ABOVE"                nil     )
    (#x000746 "SYRIAC THREE DOTS BELOW"                nil     )
    (#x000747 "SYRIAC OBLIQUE LINE ABOVE"              nil     )
    (#x000748 "SYRIAC OBLIQUE LINE BELOW"              nil     )
    (#x000749 "SYRIAC MUSIC"                           nil     )
    (#x00074a "SYRIAC BARREKH"                         nil     )
    (#x00074d "SYRIAC LETTER SOGDIAN ZHAIN"            nil     )
    (#x00074e "SYRIAC LETTER SOGDIAN KHAPH"            nil     )
    (#x00074f "SYRIAC LETTER SOGDIAN FE"               nil     )
    (#x000750 "ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW" nil     )
    (#x000751 "ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE" nil     )
    (#x000752 "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW" nil     )
    (#x000753 "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE" nil     )
    (#x000754 "ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE" nil     )
    (#x000755 "ARABIC LETTER BEH WITH INVERTED SMALL V BELOW" nil     )
    (#x000756 "ARABIC LETTER BEH WITH SMALL V"         nil     )
    (#x000757 "ARABIC LETTER HAH WITH TWO DOTS ABOVE"  nil     )
    (#x000758 "ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW" nil     )
    (#x000759 "ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH" nil     )
    (#x00075a "ARABIC LETTER DAL WITH INVERTED SMALL V BELOW" nil     )
    (#x00075b "ARABIC LETTER REH WITH STROKE"          nil     )
    (#x00075c "ARABIC LETTER SEEN WITH FOUR DOTS ABOVE" nil     )
    (#x00075d "ARABIC LETTER AIN WITH TWO DOTS ABOVE"  nil     )
    (#x00075e "ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE" nil     )
    (#x00075f "ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE" nil     )
    (#x000760 "ARABIC LETTER FEH WITH TWO DOTS BELOW"  nil     )
    (#x000761 "ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW" nil     )
    (#x000762 "ARABIC LETTER KEHEH WITH DOT ABOVE"     nil     )
    (#x000763 "ARABIC LETTER KEHEH WITH THREE DOTS ABOVE" nil     )
    (#x000764 "ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW" nil     )
    (#x000765 "ARABIC LETTER MEEM WITH DOT ABOVE"      nil     )
    (#x000766 "ARABIC LETTER MEEM WITH DOT BELOW"      nil     )
    (#x000767 "ARABIC LETTER NOON WITH TWO DOTS BELOW" nil     )
    (#x000768 "ARABIC LETTER NOON WITH SMALL TAH"      nil     )
    (#x000769 "ARABIC LETTER NOON WITH SMALL V"        nil     )
    (#x00076a "ARABIC LETTER LAM WITH BAR"             nil     )
    (#x00076b "ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE" nil     )
    (#x00076c "ARABIC LETTER REH WITH HAMZA ABOVE"     nil     )
    (#x00076d "ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE" nil     )
    (#x00076e "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW" nil     )
    (#x00076f "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS" nil     )
    (#x000770 "ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS" nil     )
    (#x000771 "ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS" nil     )
    (#x000772 "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE" nil     )
    (#x000773 "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE" nil     )
    (#x000774 "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE" nil     )
    (#x000775 "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE" nil     )
    (#x000776 "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE" nil     )
    (#x000777 "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW" nil     )
    (#x000778 "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE" nil     )
    (#x000779 "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE" nil     )
    (#x00077a "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE" nil     )
    (#x00077b "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE" nil     )
    (#x00077c "ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW" nil     )
    (#x00077d "ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE" nil     )
    (#x00077e "ARABIC LETTER SEEN WITH INVERTED V"     nil     )
    (#x00077f "ARABIC LETTER KAF WITH TWO DOTS ABOVE"  nil     )
    (#x000780 "THAANA LETTER HAA"                      nil     )
    (#x000781 "THAANA LETTER SHAVIYANI"                nil     )
    (#x000782 "THAANA LETTER NOONU"                    nil     )
    (#x000783 "THAANA LETTER RAA"                      nil     )
    (#x000784 "THAANA LETTER BAA"                      nil     )
    (#x000785 "THAANA LETTER LHAVIYANI"                nil     )
    (#x000786 "THAANA LETTER KAAFU"                    nil     )
    (#x000787 "THAANA LETTER ALIFU"                    nil     )
    (#x000788 "THAANA LETTER VAAVU"                    nil     )
    (#x000789 "THAANA LETTER MEEMU"                    nil     )
    (#x00078a "THAANA LETTER FAAFU"                    nil     )
    (#x00078b "THAANA LETTER DHAALU"                   nil     )
    (#x00078c "THAANA LETTER THAA"                     nil     )
    (#x00078d "THAANA LETTER LAAMU"                    nil     )
    (#x00078e "THAANA LETTER GAAFU"                    nil     )
    (#x00078f "THAANA LETTER GNAVIYANI"                nil     )
    (#x000790 "THAANA LETTER SEENU"                    nil     )
    (#x000791 "THAANA LETTER DAVIYANI"                 nil     )
    (#x000792 "THAANA LETTER ZAVIYANI"                 nil     )
    (#x000793 "THAANA LETTER TAVIYANI"                 nil     )
    (#x000794 "THAANA LETTER YAA"                      nil     )
    (#x000795 "THAANA LETTER PAVIYANI"                 nil     )
    (#x000796 "THAANA LETTER JAVIYANI"                 nil     )
    (#x000797 "THAANA LETTER CHAVIYANI"                nil     )
    (#x000798 "THAANA LETTER TTAA"                     nil     )
    (#x000799 "THAANA LETTER HHAA"                     nil     )
    (#x00079a "THAANA LETTER KHAA"                     nil     )
    (#x00079b "THAANA LETTER THAALU"                   nil     )
    (#x00079c "THAANA LETTER ZAA"                      nil     )
    (#x00079d "THAANA LETTER SHEENU"                   nil     )
    (#x00079e "THAANA LETTER SAADHU"                   nil     )
    (#x00079f "THAANA LETTER DAADHU"                   nil     )
    (#x0007a0 "THAANA LETTER TO"                       nil     )
    (#x0007a1 "THAANA LETTER ZO"                       nil     )
    (#x0007a2 "THAANA LETTER AINU"                     nil     )
    (#x0007a3 "THAANA LETTER GHAINU"                   nil     )
    (#x0007a4 "THAANA LETTER QAAFU"                    nil     )
    (#x0007a5 "THAANA LETTER WAAVU"                    nil     )
    (#x0007a6 "THAANA ABAFILI"                         nil     )
    (#x0007a7 "THAANA AABAAFILI"                       nil     )
    (#x0007a8 "THAANA IBIFILI"                         nil     )
    (#x0007a9 "THAANA EEBEEFILI"                       nil     )
    (#x0007aa "THAANA UBUFILI"                         nil     )
    (#x0007ab "THAANA OOBOOFILI"                       nil     )
    (#x0007ac "THAANA EBEFILI"                         nil     )
    (#x0007ad "THAANA EYBEYFILI"                       nil     )
    (#x0007ae "THAANA OBOFILI"                         nil     )
    (#x0007af "THAANA OABOAFILI"                       nil     )
    (#x0007b0 "THAANA SUKUN"                           nil     )
    (#x0007b1 "THAANA LETTER NAA"                      nil     )
    (#x0007c0 "NKO DIGIT ZERO"                         nil     )
    (#x0007c1 "NKO DIGIT ONE"                          nil     )
    (#x0007c2 "NKO DIGIT TWO"                          nil     )
    (#x0007c3 "NKO DIGIT THREE"                        nil     )
    (#x0007c4 "NKO DIGIT FOUR"                         nil     )
    (#x0007c5 "NKO DIGIT FIVE"                         nil     )
    (#x0007c6 "NKO DIGIT SIX"                          nil     )
    (#x0007c7 "NKO DIGIT SEVEN"                        nil     )
    (#x0007c8 "NKO DIGIT EIGHT"                        nil     )
    (#x0007c9 "NKO DIGIT NINE"                         nil     )
    (#x0007ca "NKO LETTER A"                           nil     )
    (#x0007cb "NKO LETTER EE"                          nil     )
    (#x0007cc "NKO LETTER I"                           nil     )
    (#x0007cd "NKO LETTER E"                           nil     )
    (#x0007ce "NKO LETTER U"                           nil     )
    (#x0007cf "NKO LETTER OO"                          nil     )
    (#x0007d0 "NKO LETTER O"                           nil     )
    (#x0007d1 "NKO LETTER DAGBASINNA"                  nil     )
    (#x0007d2 "NKO LETTER N"                           nil     )
    (#x0007d3 "NKO LETTER BA"                          nil     )
    (#x0007d4 "NKO LETTER PA"                          nil     )
    (#x0007d5 "NKO LETTER TA"                          nil     )
    (#x0007d6 "NKO LETTER JA"                          nil     )
    (#x0007d7 "NKO LETTER CHA"                         nil     )
    (#x0007d8 "NKO LETTER DA"                          nil     )
    (#x0007d9 "NKO LETTER RA"                          nil     )
    (#x0007da "NKO LETTER RRA"                         nil     )
    (#x0007db "NKO LETTER SA"                          nil     )
    (#x0007dc "NKO LETTER GBA"                         nil     )
    (#x0007dd "NKO LETTER FA"                          nil     )
    (#x0007de "NKO LETTER KA"                          nil     )
    (#x0007df "NKO LETTER LA"                          nil     )
    (#x0007e0 "NKO LETTER NA WOLOSO"                   nil     )
    (#x0007e1 "NKO LETTER MA"                          nil     )
    (#x0007e2 "NKO LETTER NYA"                         nil     )
    (#x0007e3 "NKO LETTER NA"                          nil     )
    (#x0007e4 "NKO LETTER HA"                          nil     )
    (#x0007e5 "NKO LETTER WA"                          nil     )
    (#x0007e6 "NKO LETTER YA"                          nil     )
    (#x0007e7 "NKO LETTER NYA WOLOSO"                  nil     )
    (#x0007e8 "NKO LETTER JONA JA"                     nil     )
    (#x0007e9 "NKO LETTER JONA CHA"                    nil     )
    (#x0007ea "NKO LETTER JONA RA"                     nil     )
    (#x0007eb "NKO COMBINING SHORT HIGH TONE"          nil     )
    (#x0007ec "NKO COMBINING SHORT LOW TONE"           nil     )
    (#x0007ed "NKO COMBINING SHORT RISING TONE"        nil     )
    (#x0007ee "NKO COMBINING LONG DESCENDING TONE"     nil     )
    (#x0007ef "NKO COMBINING LONG HIGH TONE"           nil     )
    (#x0007f0 "NKO COMBINING LONG LOW TONE"            nil     )
    (#x0007f1 "NKO COMBINING LONG RISING TONE"         nil     )
    (#x0007f2 "NKO COMBINING NASALIZATION MARK"        nil     )
    (#x0007f3 "NKO COMBINING DOUBLE DOT ABOVE"         nil     )
    (#x0007f4 "NKO HIGH TONE APOSTROPHE"               nil     )
    (#x0007f5 "NKO LOW TONE APOSTROPHE"                nil     )
    (#x0007f6 "NKO SYMBOL OO DENNEN"                   nil     )
    (#x0007f7 "NKO SYMBOL GBAKURUNEN"                  nil     )
    (#x0007f8 "NKO COMMA"                              nil     )
    (#x0007f9 "NKO EXCLAMATION MARK"                   nil     )
    (#x0007fa "NKO LAJANYALAN"                         nil     )
    (#x0007fd "NKO DANTAYALAN"                         nil     )
    (#x0007fe "NKO DOROME SIGN"                        nil     )
    (#x0007ff "NKO TAMAN SIGN"                         nil     )
    (#x000800 "SAMARITAN LETTER ALAF"                  nil     )
    (#x000801 "SAMARITAN LETTER BIT"                   nil     )
    (#x000802 "SAMARITAN LETTER GAMAN"                 nil     )
    (#x000803 "SAMARITAN LETTER DALAT"                 nil     )
    (#x000804 "SAMARITAN LETTER IY"                    nil     )
    (#x000805 "SAMARITAN LETTER BAA"                   nil     )
    (#x000806 "SAMARITAN LETTER ZEN"                   nil     )
    (#x000807 "SAMARITAN LETTER IT"                    nil     )
    (#x000808 "SAMARITAN LETTER TIT"                   nil     )
    (#x000809 "SAMARITAN LETTER YUT"                   nil     )
    (#x00080a "SAMARITAN LETTER KAAF"                  nil     )
    (#x00080b "SAMARITAN LETTER LABAT"                 nil     )
    (#x00080c "SAMARITAN LETTER MIM"                   nil     )
    (#x00080d "SAMARITAN LETTER NUN"                   nil     )
    (#x00080e "SAMARITAN LETTER SINGAAT"               nil     )
    (#x00080f "SAMARITAN LETTER IN"                    nil     )
    (#x000810 "SAMARITAN LETTER FI"                    nil     )
    (#x000811 "SAMARITAN LETTER TSAADIY"               nil     )
    (#x000812 "SAMARITAN LETTER QUF"                   nil     )
    (#x000813 "SAMARITAN LETTER RISH"                  nil     )
    (#x000814 "SAMARITAN LETTER SHAN"                  nil     )
    (#x000815 "SAMARITAN LETTER TAAF"                  nil     )
    (#x000816 "SAMARITAN MARK IN"                      nil     )
    (#x000817 "SAMARITAN MARK IN-ALAF"                 nil     )
    (#x000818 "SAMARITAN MARK OCCLUSION"               nil     )
    (#x000819 "SAMARITAN MARK DAGESH"                  nil     )
    (#x00081a "SAMARITAN MODIFIER LETTER EPENTHETIC YUT" nil     )
    (#x00081b "SAMARITAN MARK EPENTHETIC YUT"          nil     )
    (#x00081c "SAMARITAN VOWEL SIGN LONG E"            nil     )
    (#x00081d "SAMARITAN VOWEL SIGN E"                 nil     )
    (#x00081e "SAMARITAN VOWEL SIGN OVERLONG AA"       nil     )
    (#x00081f "SAMARITAN VOWEL SIGN LONG AA"           nil     )
    (#x000820 "SAMARITAN VOWEL SIGN AA"                nil     )
    (#x000821 "SAMARITAN VOWEL SIGN OVERLONG A"        nil     )
    (#x000822 "SAMARITAN VOWEL SIGN LONG A"            nil     )
    (#x000823 "SAMARITAN VOWEL SIGN A"                 nil     )
    (#x000824 "SAMARITAN MODIFIER LETTER SHORT A"      nil     )
    (#x000825 "SAMARITAN VOWEL SIGN SHORT A"           nil     )
    (#x000826 "SAMARITAN VOWEL SIGN LONG U"            nil     )
    (#x000827 "SAMARITAN VOWEL SIGN U"                 nil     )
    (#x000828 "SAMARITAN MODIFIER LETTER I"            nil     )
    (#x000829 "SAMARITAN VOWEL SIGN LONG I"            nil     )
    (#x00082a "SAMARITAN VOWEL SIGN I"                 nil     )
    (#x00082b "SAMARITAN VOWEL SIGN O"                 nil     )
    (#x00082c "SAMARITAN VOWEL SIGN SUKUN"             nil     )
    (#x00082d "SAMARITAN MARK NEQUDAA"                 nil     )
    (#x000830 "SAMARITAN PUNCTUATION NEQUDAA"          nil     )
    (#x000831 "SAMARITAN PUNCTUATION AFSAAQ"           nil     )
    (#x000832 "SAMARITAN PUNCTUATION ANGED"            nil     )
    (#x000833 "SAMARITAN PUNCTUATION BAU"              nil     )
    (#x000834 "SAMARITAN PUNCTUATION ATMAAU"           nil     )
    (#x000835 "SAMARITAN PUNCTUATION SHIYYAALAA"       nil     )
    (#x000836 "SAMARITAN ABBREVIATION MARK"            nil     )
    (#x000837 "SAMARITAN PUNCTUATION MELODIC QITSA"    nil     )
    (#x000838 "SAMARITAN PUNCTUATION ZIQAA"            nil     )
    (#x000839 "SAMARITAN PUNCTUATION QITSA"            nil     )
    (#x00083a "SAMARITAN PUNCTUATION ZAEF"             nil     )
    (#x00083b "SAMARITAN PUNCTUATION TURU"             nil     )
    (#x00083c "SAMARITAN PUNCTUATION ARKAANU"          nil     )
    (#x00083d "SAMARITAN PUNCTUATION SOF MASHFAAT"     nil     )
    (#x00083e "SAMARITAN PUNCTUATION ANNAAU"           nil     )
    (#x000840 "MANDAIC LETTER HALQA"                   nil     )
    (#x000841 "MANDAIC LETTER AB"                      nil     )
    (#x000842 "MANDAIC LETTER AG"                      nil     )
    (#x000843 "MANDAIC LETTER AD"                      nil     )
    (#x000844 "MANDAIC LETTER AH"                      nil     )
    (#x000845 "MANDAIC LETTER USHENNA"                 nil     )
    (#x000846 "MANDAIC LETTER AZ"                      nil     )
    (#x000847 "MANDAIC LETTER IT"                      nil     )
    (#x000848 "MANDAIC LETTER ATT"                     nil     )
    (#x000849 "MANDAIC LETTER AKSA"                    nil     )
    (#x00084a "MANDAIC LETTER AK"                      nil     )
    (#x00084b "MANDAIC LETTER AL"                      nil     )
    (#x00084c "MANDAIC LETTER AM"                      nil     )
    (#x00084d "MANDAIC LETTER AN"                      nil     )
    (#x00084e "MANDAIC LETTER AS"                      nil     )
    (#x00084f "MANDAIC LETTER IN"                      nil     )
    (#x000850 "MANDAIC LETTER AP"                      nil     )
    (#x000851 "MANDAIC LETTER ASZ"                     nil     )
    (#x000852 "MANDAIC LETTER AQ"                      nil     )
    (#x000853 "MANDAIC LETTER AR"                      nil     )
    (#x000854 "MANDAIC LETTER ASH"                     nil     )
    (#x000855 "MANDAIC LETTER AT"                      nil     )
    (#x000856 "MANDAIC LETTER DUSHENNA"                nil     )
    (#x000857 "MANDAIC LETTER KAD"                     nil     )
    (#x000858 "MANDAIC LETTER AIN"                     nil     )
    (#x000859 "MANDAIC AFFRICATION MARK"               nil     )
    (#x00085a "MANDAIC VOCALIZATION MARK"              nil     )
    (#x00085b "MANDAIC GEMINATION MARK"                nil     )
    (#x00085e "MANDAIC PUNCTUATION"                    nil     )
    (#x000860 "SYRIAC LETTER MALAYALAM NGA"            nil     )
    (#x000861 "SYRIAC LETTER MALAYALAM JA"             nil     )
    (#x000862 "SYRIAC LETTER MALAYALAM NYA"            nil     )
    (#x000863 "SYRIAC LETTER MALAYALAM TTA"            nil     )
    (#x000864 "SYRIAC LETTER MALAYALAM NNA"            nil     )
    (#x000865 "SYRIAC LETTER MALAYALAM NNNA"           nil     )
    (#x000866 "SYRIAC LETTER MALAYALAM BHA"            nil     )
    (#x000867 "SYRIAC LETTER MALAYALAM RA"             nil     )
    (#x000868 "SYRIAC LETTER MALAYALAM LLA"            nil     )
    (#x000869 "SYRIAC LETTER MALAYALAM LLLA"           nil     )
    (#x00086a "SYRIAC LETTER MALAYALAM SSA"            nil     )
    (#x000870 "ARABIC LETTER ALEF WITH ATTACHED FATHA" nil     )
    (#x000871 "ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA" nil     )
    (#x000872 "ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE" nil     )
    (#x000873 "ARABIC LETTER ALEF WITH LEFT MIDDLE STROKE" nil     )
    (#x000874 "ARABIC LETTER ALEF WITH ATTACHED KASRA" nil     )
    (#x000875 "ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA" nil     )
    (#x000876 "ARABIC LETTER ALEF WITH ATTACHED ROUND DOT ABOVE" nil     )
    (#x000877 "ARABIC LETTER ALEF WITH ATTACHED RIGHT ROUND DOT" nil     )
    (#x000878 "ARABIC LETTER ALEF WITH ATTACHED LEFT ROUND DOT" nil     )
    (#x000879 "ARABIC LETTER ALEF WITH ATTACHED ROUND DOT BELOW" nil     )
    (#x00087a "ARABIC LETTER ALEF WITH DOT ABOVE"      nil     )
    (#x00087b "ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA AND DOT ABOVE" nil     )
    (#x00087c "ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND DOT ABOVE" nil     )
    (#x00087d "ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND DOT ABOVE" nil     )
    (#x00087e "ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA AND LEFT RING" nil     )
    (#x00087f "ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND LEFT RING" nil     )
    (#x000880 "ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND LEFT RING" nil     )
    (#x000881 "ARABIC LETTER ALEF WITH ATTACHED RIGHT HAMZA" nil     )
    (#x000882 "ARABIC LETTER ALEF WITH ATTACHED LEFT HAMZA" nil     )
    (#x000883 "ARABIC TATWEEL WITH OVERSTRUCK HAMZA"   nil     )
    (#x000884 "ARABIC TATWEEL WITH OVERSTRUCK WAW"     nil     )
    (#x000885 "ARABIC TATWEEL WITH TWO DOTS BELOW"     nil     )
    (#x000886 "ARABIC LETTER THIN YEH"                 nil     )
    (#x000887 "ARABIC BASELINE ROUND DOT"              nil     )
    (#x000888 "ARABIC RAISED ROUND DOT"                nil     )
    (#x000889 "ARABIC LETTER NOON WITH INVERTED SMALL V" nil     )
    (#x00088a "ARABIC LETTER HAH WITH INVERTED SMALL V BELOW" nil     )
    (#x00088b "ARABIC LETTER TAH WITH DOT BELOW"       nil     )
    (#x00088c "ARABIC LETTER TAH WITH THREE DOTS BELOW" nil     )
    (#x00088d "ARABIC LETTER KEHEH WITH TWO DOTS VERTICALLY BELOW" nil     )
    (#x00088e "ARABIC VERTICAL TAIL"                   nil     )
    (#x000890 "ARABIC POUND MARK ABOVE"                nil     )
    (#x000891 "ARABIC PIASTRE MARK ABOVE"              nil     )
    (#x000898 "ARABIC SMALL HIGH WORD AL-JUZ"          nil     )
    (#x000899 "ARABIC SMALL LOW WORD ISHMAAM"          nil     )
    (#x00089a "ARABIC SMALL LOW WORD IMAALA"           nil     )
    (#x00089b "ARABIC SMALL LOW WORD TASHEEL"          nil     )
    (#x00089c "ARABIC MADDA WAAJIB"                    nil     )
    (#x00089d "ARABIC SUPERSCRIPT ALEF MOKHASSAS"      nil     )
    (#x00089e "ARABIC DOUBLED MADDA"                   nil     )
    (#x00089f "ARABIC HALF MADDA OVER MADDA"           nil     )
    (#x0008a0 "ARABIC LETTER BEH WITH SMALL V BELOW"   nil     )
    (#x0008a1 "ARABIC LETTER BEH WITH HAMZA ABOVE"     nil     )
    (#x0008a2 "ARABIC LETTER JEEM WITH TWO DOTS ABOVE" nil     )
    (#x0008a3 "ARABIC LETTER TAH WITH TWO DOTS ABOVE"  nil     )
    (#x0008a4 "ARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVE" nil     )
    (#x0008a5 "ARABIC LETTER QAF WITH DOT BELOW"       nil     )
    (#x0008a6 "ARABIC LETTER LAM WITH DOUBLE BAR"      nil     )
    (#x0008a7 "ARABIC LETTER MEEM WITH THREE DOTS ABOVE" nil     )
    (#x0008a8 "ARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVE" nil     )
    (#x0008a9 "ARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVE" nil     )
    (#x0008aa "ARABIC LETTER REH WITH LOOP"            nil     )
    (#x0008ab "ARABIC LETTER WAW WITH DOT WITHIN"      nil     )
    (#x0008ac "ARABIC LETTER ROHINGYA YEH"             nil     )
    (#x0008ad "ARABIC LETTER LOW ALEF"                 nil     )
    (#x0008ae "ARABIC LETTER DAL WITH THREE DOTS BELOW" nil     )
    (#x0008af "ARABIC LETTER SAD WITH THREE DOTS BELOW" nil     )
    (#x0008b0 "ARABIC LETTER GAF WITH INVERTED STROKE" nil     )
    (#x0008b1 "ARABIC LETTER STRAIGHT WAW"             nil     )
    (#x0008b2 "ARABIC LETTER ZAIN WITH INVERTED V ABOVE" nil     )
    (#x0008b3 "ARABIC LETTER AIN WITH THREE DOTS BELOW" nil     )
    (#x0008b4 "ARABIC LETTER KAF WITH DOT BELOW"       nil     )
    (#x0008b5 "ARABIC LETTER QAF WITH DOT BELOW AND NO DOTS ABOVE" nil     )
    (#x0008b6 "ARABIC LETTER BEH WITH SMALL MEEM ABOVE" nil     )
    (#x0008b7 "ARABIC LETTER PEH WITH SMALL MEEM ABOVE" nil     )
    (#x0008b8 "ARABIC LETTER TEH WITH SMALL TEH ABOVE" nil     )
    (#x0008b9 "ARABIC LETTER REH WITH SMALL NOON ABOVE" nil     )
    (#x0008ba "ARABIC LETTER YEH WITH TWO DOTS BELOW AND SMALL NOON ABOVE" nil     )
    (#x0008bb "ARABIC LETTER AFRICAN FEH"              nil     )
    (#x0008bc "ARABIC LETTER AFRICAN QAF"              nil     )
    (#x0008bd "ARABIC LETTER AFRICAN NOON"             nil     )
    (#x0008be "ARABIC LETTER PEH WITH SMALL V"         nil     )
    (#x0008bf "ARABIC LETTER TEH WITH SMALL V"         nil     )
    (#x0008c0 "ARABIC LETTER TTEH WITH SMALL V"        nil     )
    (#x0008c1 "ARABIC LETTER TCHEH WITH SMALL V"       nil     )
    (#x0008c2 "ARABIC LETTER KEHEH WITH SMALL V"       nil     )
    (#x0008c3 "ARABIC LETTER GHAIN WITH THREE DOTS ABOVE" nil     )
    (#x0008c4 "ARABIC LETTER AFRICAN QAF WITH THREE DOTS ABOVE" nil     )
    (#x0008c5 "ARABIC LETTER JEEM WITH THREE DOTS ABOVE" nil     )
    (#x0008c6 "ARABIC LETTER JEEM WITH THREE DOTS BELOW" nil     )
    (#x0008c7 "ARABIC LETTER LAM WITH SMALL ARABIC LETTER TAH ABOVE" nil     )
    (#x0008c8 "ARABIC LETTER GRAF"                     nil     )
    (#x0008c9 "ARABIC SMALL FARSI YEH"                 nil     )
    (#x0008ca "ARABIC SMALL HIGH FARSI YEH"            nil     )
    (#x0008cb "ARABIC SMALL HIGH YEH BARREE WITH TWO DOTS BELOW" nil     )
    (#x0008cc "ARABIC SMALL HIGH WORD SAH"             nil     )
    (#x0008cd "ARABIC SMALL HIGH ZAH"                  nil     )
    (#x0008ce "ARABIC LARGE ROUND DOT ABOVE"           nil     )
    (#x0008cf "ARABIC LARGE ROUND DOT BELOW"           nil     )
    (#x0008d0 "ARABIC SUKUN BELOW"                     nil     )
    (#x0008d1 "ARABIC LARGE CIRCLE BELOW"              nil     )
    (#x0008d2 "ARABIC LARGE ROUND DOT INSIDE CIRCLE BELOW" nil     )
    (#x0008d3 "ARABIC SMALL LOW WAW"                   nil     )
    (#x0008d4 "ARABIC SMALL HIGH WORD AR-RUB"          nil     )
    (#x0008d5 "ARABIC SMALL HIGH SAD"                  nil     )
    (#x0008d6 "ARABIC SMALL HIGH AIN"                  nil     )
    (#x0008d7 "ARABIC SMALL HIGH QAF"                  nil     )
    (#x0008d8 "ARABIC SMALL HIGH NOON WITH KASRA"      nil     )
    (#x0008d9 "ARABIC SMALL LOW NOON WITH KASRA"       nil     )
    (#x0008da "ARABIC SMALL HIGH WORD ATH-THALATHA"    nil     )
    (#x0008db "ARABIC SMALL HIGH WORD AS-SAJDA"        nil     )
    (#x0008dc "ARABIC SMALL HIGH WORD AN-NISF"         nil     )
    (#x0008dd "ARABIC SMALL HIGH WORD SAKTA"           nil     )
    (#x0008de "ARABIC SMALL HIGH WORD QIF"             nil     )
    (#x0008df "ARABIC SMALL HIGH WORD WAQFA"           nil     )
    (#x0008e0 "ARABIC SMALL HIGH FOOTNOTE MARKER"      nil     )
    (#x0008e1 "ARABIC SMALL HIGH SIGN SAFHA"           nil     )
    (#x0008e2 "ARABIC DISPUTED END OF AYAH"            nil     )
    (#x0008e3 "ARABIC TURNED DAMMA BELOW"              nil     )
    (#x0008e4 "ARABIC CURLY FATHA"                     nil     )
    (#x0008e5 "ARABIC CURLY DAMMA"                     nil     )
    (#x0008e6 "ARABIC CURLY KASRA"                     nil     )
    (#x0008e7 "ARABIC CURLY FATHATAN"                  nil     )
    (#x0008e8 "ARABIC CURLY DAMMATAN"                  nil     )
    (#x0008e9 "ARABIC CURLY KASRATAN"                  nil     )
    (#x0008ea "ARABIC TONE ONE DOT ABOVE"              nil     )
    (#x0008eb "ARABIC TONE TWO DOTS ABOVE"             nil     )
    (#x0008ec "ARABIC TONE LOOP ABOVE"                 nil     )
    (#x0008ed "ARABIC TONE ONE DOT BELOW"              nil     )
    (#x0008ee "ARABIC TONE TWO DOTS BELOW"             nil     )
    (#x0008ef "ARABIC TONE LOOP BELOW"                 nil     )
    (#x0008f0 "ARABIC OPEN FATHATAN"                   nil     )
    (#x0008f1 "ARABIC OPEN DAMMATAN"                   nil     )
    (#x0008f2 "ARABIC OPEN KASRATAN"                   nil     )
    (#x0008f3 "ARABIC SMALL HIGH WAW"                  nil     )
    (#x0008f4 "ARABIC FATHA WITH RING"                 nil     )
    (#x0008f5 "ARABIC FATHA WITH DOT ABOVE"            nil     )
    (#x0008f6 "ARABIC KASRA WITH DOT BELOW"            nil     )
    (#x0008f7 "ARABIC LEFT ARROWHEAD ABOVE"            nil     )
    (#x0008f8 "ARABIC RIGHT ARROWHEAD ABOVE"           nil     )
    (#x0008f9 "ARABIC LEFT ARROWHEAD BELOW"            nil     )
    (#x0008fa "ARABIC RIGHT ARROWHEAD BELOW"           nil     )
    (#x0008fb "ARABIC DOUBLE RIGHT ARROWHEAD ABOVE"    nil     )
    (#x0008fc "ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT" nil     )
    (#x0008fd "ARABIC RIGHT ARROWHEAD ABOVE WITH DOT"  nil     )
    (#x0008fe "ARABIC DAMMA WITH DOT"                  nil     )
    (#x0008ff "ARABIC MARK SIDEWAYS NOON GHUNNA"       nil     )
    (#x000900 "DEVANAGARI SIGN INVERTED CANDRABINDU"   nil     )
    (#x000901 "DEVANAGARI SIGN CANDRABINDU"            nil     )
    (#x000902 "DEVANAGARI SIGN ANUSVARA"               nil     )
    (#x000903 "DEVANAGARI SIGN VISARGA"                nil     )
    (#x000904 "DEVANAGARI LETTER SHORT A"              nil     )
    (#x000905 "DEVANAGARI LETTER A"                    nil     )
    (#x000906 "DEVANAGARI LETTER AA"                   nil     )
    (#x000907 "DEVANAGARI LETTER I"                    nil     )
    (#x000908 "DEVANAGARI LETTER II"                   nil     )
    (#x000909 "DEVANAGARI LETTER U"                    nil     )
    (#x00090a "DEVANAGARI LETTER UU"                   nil     )
    (#x00090b "DEVANAGARI LETTER VOCALIC R"            nil     )
    (#x00090c "DEVANAGARI LETTER VOCALIC L"            nil     )
    (#x00090d "DEVANAGARI LETTER CANDRA E"             nil     )
    (#x00090e "DEVANAGARI LETTER SHORT E"              nil     )
    (#x00090f "DEVANAGARI LETTER E"                    nil     )
    (#x000910 "DEVANAGARI LETTER AI"                   nil     )
    (#x000911 "DEVANAGARI LETTER CANDRA O"             nil     )
    (#x000912 "DEVANAGARI LETTER SHORT O"              nil     )
    (#x000913 "DEVANAGARI LETTER O"                    nil     )
    (#x000914 "DEVANAGARI LETTER AU"                   nil     )
    (#x000915 "DEVANAGARI LETTER KA"                   nil     )
    (#x000916 "DEVANAGARI LETTER KHA"                  nil     )
    (#x000917 "DEVANAGARI LETTER GA"                   nil     )
    (#x000918 "DEVANAGARI LETTER GHA"                  nil     )
    (#x000919 "DEVANAGARI LETTER NGA"                  nil     )
    (#x00091a "DEVANAGARI LETTER CA"                   nil     )
    (#x00091b "DEVANAGARI LETTER CHA"                  nil     )
    (#x00091c "DEVANAGARI LETTER JA"                   nil     )
    (#x00091d "DEVANAGARI LETTER JHA"                  nil     )
    (#x00091e "DEVANAGARI LETTER NYA"                  nil     )
    (#x00091f "DEVANAGARI LETTER TTA"                  nil     )
    (#x000920 "DEVANAGARI LETTER TTHA"                 nil     )
    (#x000921 "DEVANAGARI LETTER DDA"                  nil     )
    (#x000922 "DEVANAGARI LETTER DDHA"                 nil     )
    (#x000923 "DEVANAGARI LETTER NNA"                  nil     )
    (#x000924 "DEVANAGARI LETTER TA"                   nil     )
    (#x000925 "DEVANAGARI LETTER THA"                  nil     )
    (#x000926 "DEVANAGARI LETTER DA"                   nil     )
    (#x000927 "DEVANAGARI LETTER DHA"                  nil     )
    (#x000928 "DEVANAGARI LETTER NA"                   nil     )
    (#x000929 "DEVANAGARI LETTER NNNA"                 nil     )
    (#x00092a "DEVANAGARI LETTER PA"                   nil     )
    (#x00092b "DEVANAGARI LETTER PHA"                  nil     )
    (#x00092c "DEVANAGARI LETTER BA"                   nil     )
    (#x00092d "DEVANAGARI LETTER BHA"                  nil     )
    (#x00092e "DEVANAGARI LETTER MA"                   nil     )
    (#x00092f "DEVANAGARI LETTER YA"                   nil     )
    (#x000930 "DEVANAGARI LETTER RA"                   nil     )
    (#x000931 "DEVANAGARI LETTER RRA"                  nil     )
    (#x000932 "DEVANAGARI LETTER LA"                   nil     )
    (#x000933 "DEVANAGARI LETTER LLA"                  nil     )
    (#x000934 "DEVANAGARI LETTER LLLA"                 nil     )
    (#x000935 "DEVANAGARI LETTER VA"                   nil     )
    (#x000936 "DEVANAGARI LETTER SHA"                  nil     )
    (#x000937 "DEVANAGARI LETTER SSA"                  nil     )
    (#x000938 "DEVANAGARI LETTER SA"                   nil     )
    (#x000939 "DEVANAGARI LETTER HA"                   nil     )
    (#x00093a "DEVANAGARI VOWEL SIGN OE"               nil     )
    (#x00093b "DEVANAGARI VOWEL SIGN OOE"              nil     )
    (#x00093c "DEVANAGARI SIGN NUKTA"                  nil     )
    (#x00093d "DEVANAGARI SIGN AVAGRAHA"               nil     )
    (#x00093e "DEVANAGARI VOWEL SIGN AA"               nil     )
    (#x00093f "DEVANAGARI VOWEL SIGN I"                nil     )
    (#x000940 "DEVANAGARI VOWEL SIGN II"               nil     )
    (#x000941 "DEVANAGARI VOWEL SIGN U"                nil     )
    (#x000942 "DEVANAGARI VOWEL SIGN UU"               nil     )
    (#x000943 "DEVANAGARI VOWEL SIGN VOCALIC R"        nil     )
    (#x000944 "DEVANAGARI VOWEL SIGN VOCALIC RR"       nil     )
    (#x000945 "DEVANAGARI VOWEL SIGN CANDRA E"         nil     )
    (#x000946 "DEVANAGARI VOWEL SIGN SHORT E"          nil     )
    (#x000947 "DEVANAGARI VOWEL SIGN E"                nil     )
    (#x000948 "DEVANAGARI VOWEL SIGN AI"               nil     )
    (#x000949 "DEVANAGARI VOWEL SIGN CANDRA O"         nil     )
    (#x00094a "DEVANAGARI VOWEL SIGN SHORT O"          nil     )
    (#x00094b "DEVANAGARI VOWEL SIGN O"                nil     )
    (#x00094c "DEVANAGARI VOWEL SIGN AU"               nil     )
    (#x00094d "DEVANAGARI SIGN VIRAMA"                 nil     )
    (#x00094e "DEVANAGARI VOWEL SIGN PRISHTHAMATRA E"  nil     )
    (#x00094f "DEVANAGARI VOWEL SIGN AW"               nil     )
    (#x000950 "DEVANAGARI OM"                          nil     )
    (#x000951 "DEVANAGARI STRESS SIGN UDATTA"          nil     )
    (#x000952 "DEVANAGARI STRESS SIGN ANUDATTA"        nil     )
    (#x000953 "DEVANAGARI GRAVE ACCENT"                nil     )
    (#x000954 "DEVANAGARI ACUTE ACCENT"                nil     )
    (#x000955 "DEVANAGARI VOWEL SIGN CANDRA LONG E"    nil     )
    (#x000956 "DEVANAGARI VOWEL SIGN UE"               nil     )
    (#x000957 "DEVANAGARI VOWEL SIGN UUE"              nil     )
    (#x000958 "DEVANAGARI LETTER QA"                   nil     )
    (#x000959 "DEVANAGARI LETTER KHHA"                 nil     )
    (#x00095a "DEVANAGARI LETTER GHHA"                 nil     )
    (#x00095b "DEVANAGARI LETTER ZA"                   nil     )
    (#x00095c "DEVANAGARI LETTER DDDHA"                nil     )
    (#x00095d "DEVANAGARI LETTER RHA"                  nil     )
    (#x00095e "DEVANAGARI LETTER FA"                   nil     )
    (#x00095f "DEVANAGARI LETTER YYA"                  nil     )
    (#x000960 "DEVANAGARI LETTER VOCALIC RR"           nil     )
    (#x000961 "DEVANAGARI LETTER VOCALIC LL"           nil     )
    (#x000962 "DEVANAGARI VOWEL SIGN VOCALIC L"        nil     )
    (#x000963 "DEVANAGARI VOWEL SIGN VOCALIC LL"       nil     )
    (#x000964 "DEVANAGARI DANDA"                       nil     )
    (#x000965 "DEVANAGARI DOUBLE DANDA"                nil     )
    (#x000966 "DEVANAGARI DIGIT ZERO"                  nil     )
    (#x000967 "DEVANAGARI DIGIT ONE"                   nil     )
    (#x000968 "DEVANAGARI DIGIT TWO"                   nil     )
    (#x000969 "DEVANAGARI DIGIT THREE"                 nil     )
    (#x00096a "DEVANAGARI DIGIT FOUR"                  nil     )
    (#x00096b "DEVANAGARI DIGIT FIVE"                  nil     )
    (#x00096c "DEVANAGARI DIGIT SIX"                   nil     )
    (#x00096d "DEVANAGARI DIGIT SEVEN"                 nil     )
    (#x00096e "DEVANAGARI DIGIT EIGHT"                 nil     )
    (#x00096f "DEVANAGARI DIGIT NINE"                  nil     )
    (#x000970 "DEVANAGARI ABBREVIATION SIGN"           nil     )
    (#x000971 "DEVANAGARI SIGN HIGH SPACING DOT"       nil     )
    (#x000972 "DEVANAGARI LETTER CANDRA A"             nil     )
    (#x000973 "DEVANAGARI LETTER OE"                   nil     )
    (#x000974 "DEVANAGARI LETTER OOE"                  nil     )
    (#x000975 "DEVANAGARI LETTER AW"                   nil     )
    (#x000976 "DEVANAGARI LETTER UE"                   nil     )
    (#x000977 "DEVANAGARI LETTER UUE"                  nil     )
    (#x000978 "DEVANAGARI LETTER MARWARI DDA"          nil     )
    (#x000979 "DEVANAGARI LETTER ZHA"                  nil     )
    (#x00097a "DEVANAGARI LETTER HEAVY YA"             nil     )
    (#x00097b "DEVANAGARI LETTER GGA"                  nil     )
    (#x00097c "DEVANAGARI LETTER JJA"                  nil     )
    (#x00097d "DEVANAGARI LETTER GLOTTAL STOP"         nil     )
    (#x00097e "DEVANAGARI LETTER DDDA"                 nil     )
    (#x00097f "DEVANAGARI LETTER BBA"                  nil     )
    (#x000980 "BENGALI ANJI"                           nil     )
    (#x000981 "BENGALI SIGN CANDRABINDU"               nil     )
    (#x000982 "BENGALI SIGN ANUSVARA"                  nil     )
    (#x000983 "BENGALI SIGN VISARGA"                   nil     )
    (#x000985 "BENGALI LETTER A"                       nil     )
    (#x000986 "BENGALI LETTER AA"                      nil     )
    (#x000987 "BENGALI LETTER I"                       nil     )
    (#x000988 "BENGALI LETTER II"                      nil     )
    (#x000989 "BENGALI LETTER U"                       nil     )
    (#x00098a "BENGALI LETTER UU"                      nil     )
    (#x00098b "BENGALI LETTER VOCALIC R"               nil     )
    (#x00098c "BENGALI LETTER VOCALIC L"               nil     )
    (#x00098f "BENGALI LETTER E"                       nil     )
    (#x000990 "BENGALI LETTER AI"                      nil     )
    (#x000993 "BENGALI LETTER O"                       nil     )
    (#x000994 "BENGALI LETTER AU"                      nil     )
    (#x000995 "BENGALI LETTER KA"                      nil     )
    (#x000996 "BENGALI LETTER KHA"                     nil     )
    (#x000997 "BENGALI LETTER GA"                      nil     )
    (#x000998 "BENGALI LETTER GHA"                     nil     )
    (#x000999 "BENGALI LETTER NGA"                     nil     )
    (#x00099a "BENGALI LETTER CA"                      nil     )
    (#x00099b "BENGALI LETTER CHA"                     nil     )
    (#x00099c "BENGALI LETTER JA"                      nil     )
    (#x00099d "BENGALI LETTER JHA"                     nil     )
    (#x00099e "BENGALI LETTER NYA"                     nil     )
    (#x00099f "BENGALI LETTER TTA"                     nil     )
    (#x0009a0 "BENGALI LETTER TTHA"                    nil     )
    (#x0009a1 "BENGALI LETTER DDA"                     nil     )
    (#x0009a2 "BENGALI LETTER DDHA"                    nil     )
    (#x0009a3 "BENGALI LETTER NNA"                     nil     )
    (#x0009a4 "BENGALI LETTER TA"                      nil     )
    (#x0009a5 "BENGALI LETTER THA"                     nil     )
    (#x0009a6 "BENGALI LETTER DA"                      nil     )
    (#x0009a7 "BENGALI LETTER DHA"                     nil     )
    (#x0009a8 "BENGALI LETTER NA"                      nil     )
    (#x0009aa "BENGALI LETTER PA"                      nil     )
    (#x0009ab "BENGALI LETTER PHA"                     nil     )
    (#x0009ac "BENGALI LETTER BA"                      nil     )
    (#x0009ad "BENGALI LETTER BHA"                     nil     )
    (#x0009ae "BENGALI LETTER MA"                      nil     )
    (#x0009af "BENGALI LETTER YA"                      nil     )
    (#x0009b0 "BENGALI LETTER RA"                      nil     )
    (#x0009b2 "BENGALI LETTER LA"                      nil     )
    (#x0009b6 "BENGALI LETTER SHA"                     nil     )
    (#x0009b7 "BENGALI LETTER SSA"                     nil     )
    (#x0009b8 "BENGALI LETTER SA"                      nil     )
    (#x0009b9 "BENGALI LETTER HA"                      nil     )
    (#x0009bc "BENGALI SIGN NUKTA"                     nil     )
    (#x0009bd "BENGALI SIGN AVAGRAHA"                  nil     )
    (#x0009be "BENGALI VOWEL SIGN AA"                  nil     )
    (#x0009bf "BENGALI VOWEL SIGN I"                   nil     )
    (#x0009c0 "BENGALI VOWEL SIGN II"                  nil     )
    (#x0009c1 "BENGALI VOWEL SIGN U"                   nil     )
    (#x0009c2 "BENGALI VOWEL SIGN UU"                  nil     )
    (#x0009c3 "BENGALI VOWEL SIGN VOCALIC R"           nil     )
    (#x0009c4 "BENGALI VOWEL SIGN VOCALIC RR"          nil     )
    (#x0009c7 "BENGALI VOWEL SIGN E"                   nil     )
    (#x0009c8 "BENGALI VOWEL SIGN AI"                  nil     )
    (#x0009cb "BENGALI VOWEL SIGN O"                   nil     )
    (#x0009cc "BENGALI VOWEL SIGN AU"                  nil     )
    (#x0009cd "BENGALI SIGN VIRAMA"                    nil     )
    (#x0009ce "BENGALI LETTER KHANDA TA"               nil     )
    (#x0009d7 "BENGALI AU LENGTH MARK"                 nil     )
    (#x0009dc "BENGALI LETTER RRA"                     nil     )
    (#x0009dd "BENGALI LETTER RHA"                     nil     )
    (#x0009df "BENGALI LETTER YYA"                     nil     )
    (#x0009e0 "BENGALI LETTER VOCALIC RR"              nil     )
    (#x0009e1 "BENGALI LETTER VOCALIC LL"              nil     )
    (#x0009e2 "BENGALI VOWEL SIGN VOCALIC L"           nil     )
    (#x0009e3 "BENGALI VOWEL SIGN VOCALIC LL"          nil     )
    (#x0009e6 "BENGALI DIGIT ZERO"                     nil     )
    (#x0009e7 "BENGALI DIGIT ONE"                      nil     )
    (#x0009e8 "BENGALI DIGIT TWO"                      nil     )
    (#x0009e9 "BENGALI DIGIT THREE"                    nil     )
    (#x0009ea "BENGALI DIGIT FOUR"                     nil     )
    (#x0009eb "BENGALI DIGIT FIVE"                     nil     )
    (#x0009ec "BENGALI DIGIT SIX"                      nil     )
    (#x0009ed "BENGALI DIGIT SEVEN"                    nil     )
    (#x0009ee "BENGALI DIGIT EIGHT"                    nil     )
    (#x0009ef "BENGALI DIGIT NINE"                     nil     )
    (#x0009f0 "BENGALI LETTER RA WITH MIDDLE DIAGONAL" nil     )
    (#x0009f1 "BENGALI LETTER RA WITH LOWER DIAGONAL"  nil     )
    (#x0009f2 "BENGALI RUPEE MARK"                     nil     )
    (#x0009f3 "BENGALI RUPEE SIGN"                     nil     )
    (#x0009f4 "BENGALI CURRENCY NUMERATOR ONE"         nil     )
    (#x0009f5 "BENGALI CURRENCY NUMERATOR TWO"         nil     )
    (#x0009f6 "BENGALI CURRENCY NUMERATOR THREE"       nil     )
    (#x0009f7 "BENGALI CURRENCY NUMERATOR FOUR"        nil     )
    (#x0009f8 "BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR" nil     )
    (#x0009f9 "BENGALI CURRENCY DENOMINATOR SIXTEEN"   nil     )
    (#x0009fa "BENGALI ISSHAR"                         nil     )
    (#x0009fb "BENGALI GANDA MARK"                     nil     )
    (#x0009fc "BENGALI LETTER VEDIC ANUSVARA"          nil     )
    (#x0009fd "BENGALI ABBREVIATION SIGN"              nil     )
    (#x0009fe "BENGALI SANDHI MARK"                    nil     )
    (#x000a01 "GURMUKHI SIGN ADAK BINDI"               nil     )
    (#x000a02 "GURMUKHI SIGN BINDI"                    nil     )
    (#x000a03 "GURMUKHI SIGN VISARGA"                  nil     )
    (#x000a05 "GURMUKHI LETTER A"                      nil     )
    (#x000a06 "GURMUKHI LETTER AA"                     nil     )
    (#x000a07 "GURMUKHI LETTER I"                      nil     )
    (#x000a08 "GURMUKHI LETTER II"                     nil     )
    (#x000a09 "GURMUKHI LETTER U"                      nil     )
    (#x000a0a "GURMUKHI LETTER UU"                     nil     )
    (#x000a0f "GURMUKHI LETTER EE"                     nil     )
    (#x000a10 "GURMUKHI LETTER AI"                     nil     )
    (#x000a13 "GURMUKHI LETTER OO"                     nil     )
    (#x000a14 "GURMUKHI LETTER AU"                     nil     )
    (#x000a15 "GURMUKHI LETTER KA"                     nil     )
    (#x000a16 "GURMUKHI LETTER KHA"                    nil     )
    (#x000a17 "GURMUKHI LETTER GA"                     nil     )
    (#x000a18 "GURMUKHI LETTER GHA"                    nil     )
    (#x000a19 "GURMUKHI LETTER NGA"                    nil     )
    (#x000a1a "GURMUKHI LETTER CA"                     nil     )
    (#x000a1b "GURMUKHI LETTER CHA"                    nil     )
    (#x000a1c "GURMUKHI LETTER JA"                     nil     )
    (#x000a1d "GURMUKHI LETTER JHA"                    nil     )
    (#x000a1e "GURMUKHI LETTER NYA"                    nil     )
    (#x000a1f "GURMUKHI LETTER TTA"                    nil     )
    (#x000a20 "GURMUKHI LETTER TTHA"                   nil     )
    (#x000a21 "GURMUKHI LETTER DDA"                    nil     )
    (#x000a22 "GURMUKHI LETTER DDHA"                   nil     )
    (#x000a23 "GURMUKHI LETTER NNA"                    nil     )
    (#x000a24 "GURMUKHI LETTER TA"                     nil     )
    (#x000a25 "GURMUKHI LETTER THA"                    nil     )
    (#x000a26 "GURMUKHI LETTER DA"                     nil     )
    (#x000a27 "GURMUKHI LETTER DHA"                    nil     )
    (#x000a28 "GURMUKHI LETTER NA"                     nil     )
    (#x000a2a "GURMUKHI LETTER PA"                     nil     )
    (#x000a2b "GURMUKHI LETTER PHA"                    nil     )
    (#x000a2c "GURMUKHI LETTER BA"                     nil     )
    (#x000a2d "GURMUKHI LETTER BHA"                    nil     )
    (#x000a2e "GURMUKHI LETTER MA"                     nil     )
    (#x000a2f "GURMUKHI LETTER YA"                     nil     )
    (#x000a30 "GURMUKHI LETTER RA"                     nil     )
    (#x000a32 "GURMUKHI LETTER LA"                     nil     )
    (#x000a33 "GURMUKHI LETTER LLA"                    nil     )
    (#x000a35 "GURMUKHI LETTER VA"                     nil     )
    (#x000a36 "GURMUKHI LETTER SHA"                    nil     )
    (#x000a38 "GURMUKHI LETTER SA"                     nil     )
    (#x000a39 "GURMUKHI LETTER HA"                     nil     )
    (#x000a3c "GURMUKHI SIGN NUKTA"                    nil     )
    (#x000a3e "GURMUKHI VOWEL SIGN AA"                 nil     )
    (#x000a3f "GURMUKHI VOWEL SIGN I"                  nil     )
    (#x000a40 "GURMUKHI VOWEL SIGN II"                 nil     )
    (#x000a41 "GURMUKHI VOWEL SIGN U"                  nil     )
    (#x000a42 "GURMUKHI VOWEL SIGN UU"                 nil     )
    (#x000a47 "GURMUKHI VOWEL SIGN EE"                 nil     )
    (#x000a48 "GURMUKHI VOWEL SIGN AI"                 nil     )
    (#x000a4b "GURMUKHI VOWEL SIGN OO"                 nil     )
    (#x000a4c "GURMUKHI VOWEL SIGN AU"                 nil     )
    (#x000a4d "GURMUKHI SIGN VIRAMA"                   nil     )
    (#x000a51 "GURMUKHI SIGN UDAAT"                    nil     )
    (#x000a59 "GURMUKHI LETTER KHHA"                   nil     )
    (#x000a5a "GURMUKHI LETTER GHHA"                   nil     )
    (#x000a5b "GURMUKHI LETTER ZA"                     nil     )
    (#x000a5c "GURMUKHI LETTER RRA"                    nil     )
    (#x000a5e "GURMUKHI LETTER FA"                     nil     )
    (#x000a66 "GURMUKHI DIGIT ZERO"                    nil     )
    (#x000a67 "GURMUKHI DIGIT ONE"                     nil     )
    (#x000a68 "GURMUKHI DIGIT TWO"                     nil     )
    (#x000a69 "GURMUKHI DIGIT THREE"                   nil     )
    (#x000a6a "GURMUKHI DIGIT FOUR"                    nil     )
    (#x000a6b "GURMUKHI DIGIT FIVE"                    nil     )
    (#x000a6c "GURMUKHI DIGIT SIX"                     nil     )
    (#x000a6d "GURMUKHI DIGIT SEVEN"                   nil     )
    (#x000a6e "GURMUKHI DIGIT EIGHT"                   nil     )
    (#x000a6f "GURMUKHI DIGIT NINE"                    nil     )
    (#x000a70 "GURMUKHI TIPPI"                         nil     )
    (#x000a71 "GURMUKHI ADDAK"                         nil     )
    (#x000a72 "GURMUKHI IRI"                           nil     )
    (#x000a73 "GURMUKHI URA"                           nil     )
    (#x000a74 "GURMUKHI EK ONKAR"                      nil     )
    (#x000a75 "GURMUKHI SIGN YAKASH"                   nil     )
    (#x000a76 "GURMUKHI ABBREVIATION SIGN"             nil     )
    (#x000a81 "GUJARATI SIGN CANDRABINDU"              nil     )
    (#x000a82 "GUJARATI SIGN ANUSVARA"                 nil     )
    (#x000a83 "GUJARATI SIGN VISARGA"                  nil     )
    (#x000a85 "GUJARATI LETTER A"                      nil     )
    (#x000a86 "GUJARATI LETTER AA"                     nil     )
    (#x000a87 "GUJARATI LETTER I"                      nil     )
    (#x000a88 "GUJARATI LETTER II"                     nil     )
    (#x000a89 "GUJARATI LETTER U"                      nil     )
    (#x000a8a "GUJARATI LETTER UU"                     nil     )
    (#x000a8b "GUJARATI LETTER VOCALIC R"              nil     )
    (#x000a8c "GUJARATI LETTER VOCALIC L"              nil     )
    (#x000a8d "GUJARATI VOWEL CANDRA E"                nil     )
    (#x000a8f "GUJARATI LETTER E"                      nil     )
    (#x000a90 "GUJARATI LETTER AI"                     nil     )
    (#x000a91 "GUJARATI VOWEL CANDRA O"                nil     )
    (#x000a93 "GUJARATI LETTER O"                      nil     )
    (#x000a94 "GUJARATI LETTER AU"                     nil     )
    (#x000a95 "GUJARATI LETTER KA"                     nil     )
    (#x000a96 "GUJARATI LETTER KHA"                    nil     )
    (#x000a97 "GUJARATI LETTER GA"                     nil     )
    (#x000a98 "GUJARATI LETTER GHA"                    nil     )
    (#x000a99 "GUJARATI LETTER NGA"                    nil     )
    (#x000a9a "GUJARATI LETTER CA"                     nil     )
    (#x000a9b "GUJARATI LETTER CHA"                    nil     )
    (#x000a9c "GUJARATI LETTER JA"                     nil     )
    (#x000a9d "GUJARATI LETTER JHA"                    nil     )
    (#x000a9e "GUJARATI LETTER NYA"                    nil     )
    (#x000a9f "GUJARATI LETTER TTA"                    nil     )
    (#x000aa0 "GUJARATI LETTER TTHA"                   nil     )
    (#x000aa1 "GUJARATI LETTER DDA"                    nil     )
    (#x000aa2 "GUJARATI LETTER DDHA"                   nil     )
    (#x000aa3 "GUJARATI LETTER NNA"                    nil     )
    (#x000aa4 "GUJARATI LETTER TA"                     nil     )
    (#x000aa5 "GUJARATI LETTER THA"                    nil     )
    (#x000aa6 "GUJARATI LETTER DA"                     nil     )
    (#x000aa7 "GUJARATI LETTER DHA"                    nil     )
    (#x000aa8 "GUJARATI LETTER NA"                     nil     )
    (#x000aaa "GUJARATI LETTER PA"                     nil     )
    (#x000aab "GUJARATI LETTER PHA"                    nil     )
    (#x000aac "GUJARATI LETTER BA"                     nil     )
    (#x000aad "GUJARATI LETTER BHA"                    nil     )
    (#x000aae "GUJARATI LETTER MA"                     nil     )
    (#x000aaf "GUJARATI LETTER YA"                     nil     )
    (#x000ab0 "GUJARATI LETTER RA"                     nil     )
    (#x000ab2 "GUJARATI LETTER LA"                     nil     )
    (#x000ab3 "GUJARATI LETTER LLA"                    nil     )
    (#x000ab5 "GUJARATI LETTER VA"                     nil     )
    (#x000ab6 "GUJARATI LETTER SHA"                    nil     )
    (#x000ab7 "GUJARATI LETTER SSA"                    nil     )
    (#x000ab8 "GUJARATI LETTER SA"                     nil     )
    (#x000ab9 "GUJARATI LETTER HA"                     nil     )
    (#x000abc "GUJARATI SIGN NUKTA"                    nil     )
    (#x000abd "GUJARATI SIGN AVAGRAHA"                 nil     )
    (#x000abe "GUJARATI VOWEL SIGN AA"                 nil     )
    (#x000abf "GUJARATI VOWEL SIGN I"                  nil     )
    (#x000ac0 "GUJARATI VOWEL SIGN II"                 nil     )
    (#x000ac1 "GUJARATI VOWEL SIGN U"                  nil     )
    (#x000ac2 "GUJARATI VOWEL SIGN UU"                 nil     )
    (#x000ac3 "GUJARATI VOWEL SIGN VOCALIC R"          nil     )
    (#x000ac4 "GUJARATI VOWEL SIGN VOCALIC RR"         nil     )
    (#x000ac5 "GUJARATI VOWEL SIGN CANDRA E"           nil     )
    (#x000ac7 "GUJARATI VOWEL SIGN E"                  nil     )
    (#x000ac8 "GUJARATI VOWEL SIGN AI"                 nil     )
    (#x000ac9 "GUJARATI VOWEL SIGN CANDRA O"           nil     )
    (#x000acb "GUJARATI VOWEL SIGN O"                  nil     )
    (#x000acc "GUJARATI VOWEL SIGN AU"                 nil     )
    (#x000acd "GUJARATI SIGN VIRAMA"                   nil     )
    (#x000ad0 "GUJARATI OM"                            nil     )
    (#x000ae0 "GUJARATI LETTER VOCALIC RR"             nil     )
    (#x000ae1 "GUJARATI LETTER VOCALIC LL"             nil     )
    (#x000ae2 "GUJARATI VOWEL SIGN VOCALIC L"          nil     )
    (#x000ae3 "GUJARATI VOWEL SIGN VOCALIC LL"         nil     )
    (#x000ae6 "GUJARATI DIGIT ZERO"                    nil     )
    (#x000ae7 "GUJARATI DIGIT ONE"                     nil     )
    (#x000ae8 "GUJARATI DIGIT TWO"                     nil     )
    (#x000ae9 "GUJARATI DIGIT THREE"                   nil     )
    (#x000aea "GUJARATI DIGIT FOUR"                    nil     )
    (#x000aeb "GUJARATI DIGIT FIVE"                    nil     )
    (#x000aec "GUJARATI DIGIT SIX"                     nil     )
    (#x000aed "GUJARATI DIGIT SEVEN"                   nil     )
    (#x000aee "GUJARATI DIGIT EIGHT"                   nil     )
    (#x000aef "GUJARATI DIGIT NINE"                    nil     )
    (#x000af0 "GUJARATI ABBREVIATION SIGN"             nil     )
    (#x000af1 "GUJARATI RUPEE SIGN"                    nil     )
    (#x000af9 "GUJARATI LETTER ZHA"                    nil     )
    (#x000afa "GUJARATI SIGN SUKUN"                    nil     )
    (#x000afb "GUJARATI SIGN SHADDA"                   nil     )
    (#x000afc "GUJARATI SIGN MADDAH"                   nil     )
    (#x000afd "GUJARATI SIGN THREE-DOT NUKTA ABOVE"    nil     )
    (#x000afe "GUJARATI SIGN CIRCLE NUKTA ABOVE"       nil     )
    (#x000aff "GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE"   nil     )
    (#x000b01 "ORIYA SIGN CANDRABINDU"                 nil     )
    (#x000b02 "ORIYA SIGN ANUSVARA"                    nil     )
    (#x000b03 "ORIYA SIGN VISARGA"                     nil     )
    (#x000b05 "ORIYA LETTER A"                         nil     )
    (#x000b06 "ORIYA LETTER AA"                        nil     )
    (#x000b07 "ORIYA LETTER I"                         nil     )
    (#x000b08 "ORIYA LETTER II"                        nil     )
    (#x000b09 "ORIYA LETTER U"                         nil     )
    (#x000b0a "ORIYA LETTER UU"                        nil     )
    (#x000b0b "ORIYA LETTER VOCALIC R"                 nil     )
    (#x000b0c "ORIYA LETTER VOCALIC L"                 nil     )
    (#x000b0f "ORIYA LETTER E"                         nil     )
    (#x000b10 "ORIYA LETTER AI"                        nil     )
    (#x000b13 "ORIYA LETTER O"                         nil     )
    (#x000b14 "ORIYA LETTER AU"                        nil     )
    (#x000b15 "ORIYA LETTER KA"                        nil     )
    (#x000b16 "ORIYA LETTER KHA"                       nil     )
    (#x000b17 "ORIYA LETTER GA"                        nil     )
    (#x000b18 "ORIYA LETTER GHA"                       nil     )
    (#x000b19 "ORIYA LETTER NGA"                       nil     )
    (#x000b1a "ORIYA LETTER CA"                        nil     )
    (#x000b1b "ORIYA LETTER CHA"                       nil     )
    (#x000b1c "ORIYA LETTER JA"                        nil     )
    (#x000b1d "ORIYA LETTER JHA"                       nil     )
    (#x000b1e "ORIYA LETTER NYA"                       nil     )
    (#x000b1f "ORIYA LETTER TTA"                       nil     )
    (#x000b20 "ORIYA LETTER TTHA"                      nil     )
    (#x000b21 "ORIYA LETTER DDA"                       nil     )
    (#x000b22 "ORIYA LETTER DDHA"                      nil     )
    (#x000b23 "ORIYA LETTER NNA"                       nil     )
    (#x000b24 "ORIYA LETTER TA"                        nil     )
    (#x000b25 "ORIYA LETTER THA"                       nil     )
    (#x000b26 "ORIYA LETTER DA"                        nil     )
    (#x000b27 "ORIYA LETTER DHA"                       nil     )
    (#x000b28 "ORIYA LETTER NA"                        nil     )
    (#x000b2a "ORIYA LETTER PA"                        nil     )
    (#x000b2b "ORIYA LETTER PHA"                       nil     )
    (#x000b2c "ORIYA LETTER BA"                        nil     )
    (#x000b2d "ORIYA LETTER BHA"                       nil     )
    (#x000b2e "ORIYA LETTER MA"                        nil     )
    (#x000b2f "ORIYA LETTER YA"                        nil     )
    (#x000b30 "ORIYA LETTER RA"                        nil     )
    (#x000b32 "ORIYA LETTER LA"                        nil     )
    (#x000b33 "ORIYA LETTER LLA"                       nil     )
    (#x000b35 "ORIYA LETTER VA"                        nil     )
    (#x000b36 "ORIYA LETTER SHA"                       nil     )
    (#x000b37 "ORIYA LETTER SSA"                       nil     )
    (#x000b38 "ORIYA LETTER SA"                        nil     )
    (#x000b39 "ORIYA LETTER HA"                        nil     )
    (#x000b3c "ORIYA SIGN NUKTA"                       nil     )
    (#x000b3d "ORIYA SIGN AVAGRAHA"                    nil     )
    (#x000b3e "ORIYA VOWEL SIGN AA"                    nil     )
    (#x000b3f "ORIYA VOWEL SIGN I"                     nil     )
    (#x000b40 "ORIYA VOWEL SIGN II"                    nil     )
    (#x000b41 "ORIYA VOWEL SIGN U"                     nil     )
    (#x000b42 "ORIYA VOWEL SIGN UU"                    nil     )
    (#x000b43 "ORIYA VOWEL SIGN VOCALIC R"             nil     )
    (#x000b44 "ORIYA VOWEL SIGN VOCALIC RR"            nil     )
    (#x000b47 "ORIYA VOWEL SIGN E"                     nil     )
    (#x000b48 "ORIYA VOWEL SIGN AI"                    nil     )
    (#x000b4b "ORIYA VOWEL SIGN O"                     nil     )
    (#x000b4c "ORIYA VOWEL SIGN AU"                    nil     )
    (#x000b4d "ORIYA SIGN VIRAMA"                      nil     )
    (#x000b55 "ORIYA SIGN OVERLINE"                    nil     )
    (#x000b56 "ORIYA AI LENGTH MARK"                   nil     )
    (#x000b57 "ORIYA AU LENGTH MARK"                   nil     )
    (#x000b5c "ORIYA LETTER RRA"                       nil     )
    (#x000b5d "ORIYA LETTER RHA"                       nil     )
    (#x000b5f "ORIYA LETTER YYA"                       nil     )
    (#x000b60 "ORIYA LETTER VOCALIC RR"                nil     )
    (#x000b61 "ORIYA LETTER VOCALIC LL"                nil     )
    (#x000b62 "ORIYA VOWEL SIGN VOCALIC L"             nil     )
    (#x000b63 "ORIYA VOWEL SIGN VOCALIC LL"            nil     )
    (#x000b66 "ORIYA DIGIT ZERO"                       nil     )
    (#x000b67 "ORIYA DIGIT ONE"                        nil     )
    (#x000b68 "ORIYA DIGIT TWO"                        nil     )
    (#x000b69 "ORIYA DIGIT THREE"                      nil     )
    (#x000b6a "ORIYA DIGIT FOUR"                       nil     )
    (#x000b6b "ORIYA DIGIT FIVE"                       nil     )
    (#x000b6c "ORIYA DIGIT SIX"                        nil     )
    (#x000b6d "ORIYA DIGIT SEVEN"                      nil     )
    (#x000b6e "ORIYA DIGIT EIGHT"                      nil     )
    (#x000b6f "ORIYA DIGIT NINE"                       nil     )
    (#x000b70 "ORIYA ISSHAR"                           nil     )
    (#x000b71 "ORIYA LETTER WA"                        nil     )
    (#x000b72 "ORIYA FRACTION ONE QUARTER"             nil     )
    (#x000b73 "ORIYA FRACTION ONE HALF"                nil     )
    (#x000b74 "ORIYA FRACTION THREE QUARTERS"          nil     )
    (#x000b75 "ORIYA FRACTION ONE SIXTEENTH"           nil     )
    (#x000b76 "ORIYA FRACTION ONE EIGHTH"              nil     )
    (#x000b77 "ORIYA FRACTION THREE SIXTEENTHS"        nil     )
    (#x000b82 "TAMIL SIGN ANUSVARA"                    nil     )
    (#x000b83 "TAMIL SIGN VISARGA"                     nil     )
    (#x000b85 "TAMIL LETTER A"                         nil     )
    (#x000b86 "TAMIL LETTER AA"                        nil     )
    (#x000b87 "TAMIL LETTER I"                         nil     )
    (#x000b88 "TAMIL LETTER II"                        nil     )
    (#x000b89 "TAMIL LETTER U"                         nil     )
    (#x000b8a "TAMIL LETTER UU"                        nil     )
    (#x000b8e "TAMIL LETTER E"                         nil     )
    (#x000b8f "TAMIL LETTER EE"                        nil     )
    (#x000b90 "TAMIL LETTER AI"                        nil     )
    (#x000b92 "TAMIL LETTER O"                         nil     )
    (#x000b93 "TAMIL LETTER OO"                        nil     )
    (#x000b94 "TAMIL LETTER AU"                        nil     )
    (#x000b95 "TAMIL LETTER KA"                        nil     )
    (#x000b99 "TAMIL LETTER NGA"                       nil     )
    (#x000b9a "TAMIL LETTER CA"                        nil     )
    (#x000b9c "TAMIL LETTER JA"                        nil     )
    (#x000b9e "TAMIL LETTER NYA"                       nil     )
    (#x000b9f "TAMIL LETTER TTA"                       nil     )
    (#x000ba3 "TAMIL LETTER NNA"                       nil     )
    (#x000ba4 "TAMIL LETTER TA"                        nil     )
    (#x000ba8 "TAMIL LETTER NA"                        nil     )
    (#x000ba9 "TAMIL LETTER NNNA"                      nil     )
    (#x000baa "TAMIL LETTER PA"                        nil     )
    (#x000bae "TAMIL LETTER MA"                        nil     )
    (#x000baf "TAMIL LETTER YA"                        nil     )
    (#x000bb0 "TAMIL LETTER RA"                        nil     )
    (#x000bb1 "TAMIL LETTER RRA"                       nil     )
    (#x000bb2 "TAMIL LETTER LA"                        nil     )
    (#x000bb3 "TAMIL LETTER LLA"                       nil     )
    (#x000bb4 "TAMIL LETTER LLLA"                      nil     )
    (#x000bb5 "TAMIL LETTER VA"                        nil     )
    (#x000bb6 "TAMIL LETTER SHA"                       nil     )
    (#x000bb7 "TAMIL LETTER SSA"                       nil     )
    (#x000bb8 "TAMIL LETTER SA"                        nil     )
    (#x000bb9 "TAMIL LETTER HA"                        nil     )
    (#x000bbe "TAMIL VOWEL SIGN AA"                    nil     )
    (#x000bbf "TAMIL VOWEL SIGN I"                     nil     )
    (#x000bc0 "TAMIL VOWEL SIGN II"                    nil     )
    (#x000bc1 "TAMIL VOWEL SIGN U"                     nil     )
    (#x000bc2 "TAMIL VOWEL SIGN UU"                    nil     )
    (#x000bc6 "TAMIL VOWEL SIGN E"                     nil     )
    (#x000bc7 "TAMIL VOWEL SIGN EE"                    nil     )
    (#x000bc8 "TAMIL VOWEL SIGN AI"                    nil     )
    (#x000bca "TAMIL VOWEL SIGN O"                     nil     )
    (#x000bcb "TAMIL VOWEL SIGN OO"                    nil     )
    (#x000bcc "TAMIL VOWEL SIGN AU"                    nil     )
    (#x000bcd "TAMIL SIGN VIRAMA"                      nil     )
    (#x000bd0 "TAMIL OM"                               nil     )
    (#x000bd7 "TAMIL AU LENGTH MARK"                   nil     )
    (#x000be6 "TAMIL DIGIT ZERO"                       nil     )
    (#x000be7 "TAMIL DIGIT ONE"                        nil     )
    (#x000be8 "TAMIL DIGIT TWO"                        nil     )
    (#x000be9 "TAMIL DIGIT THREE"                      nil     )
    (#x000bea "TAMIL DIGIT FOUR"                       nil     )
    (#x000beb "TAMIL DIGIT FIVE"                       nil     )
    (#x000bec "TAMIL DIGIT SIX"                        nil     )
    (#x000bed "TAMIL DIGIT SEVEN"                      nil     )
    (#x000bee "TAMIL DIGIT EIGHT"                      nil     )
    (#x000bef "TAMIL DIGIT NINE"                       nil     )
    (#x000bf0 "TAMIL NUMBER TEN"                       nil     )
    (#x000bf1 "TAMIL NUMBER ONE HUNDRED"               nil     )
    (#x000bf2 "TAMIL NUMBER ONE THOUSAND"              nil     )
    (#x000bf3 "TAMIL DAY SIGN"                         nil     )
    (#x000bf4 "TAMIL MONTH SIGN"                       nil     )
    (#x000bf5 "TAMIL YEAR SIGN"                        nil     )
    (#x000bf6 "TAMIL DEBIT SIGN"                       nil     )
    (#x000bf7 "TAMIL CREDIT SIGN"                      nil     )
    (#x000bf8 "TAMIL AS ABOVE SIGN"                    nil     )
    (#x000bf9 "TAMIL RUPEE SIGN"                       nil     )
    (#x000bfa "TAMIL NUMBER SIGN"                      nil     )
    (#x000c00 "TELUGU SIGN COMBINING CANDRABINDU ABOVE" nil     )
    (#x000c01 "TELUGU SIGN CANDRABINDU"                nil     )
    (#x000c02 "TELUGU SIGN ANUSVARA"                   nil     )
    (#x000c03 "TELUGU SIGN VISARGA"                    nil     )
    (#x000c04 "TELUGU SIGN COMBINING ANUSVARA ABOVE"   nil     )
    (#x000c05 "TELUGU LETTER A"                        nil     )
    (#x000c06 "TELUGU LETTER AA"                       nil     )
    (#x000c07 "TELUGU LETTER I"                        nil     )
    (#x000c08 "TELUGU LETTER II"                       nil     )
    (#x000c09 "TELUGU LETTER U"                        nil     )
    (#x000c0a "TELUGU LETTER UU"                       nil     )
    (#x000c0b "TELUGU LETTER VOCALIC R"                nil     )
    (#x000c0c "TELUGU LETTER VOCALIC L"                nil     )
    (#x000c0e "TELUGU LETTER E"                        nil     )
    (#x000c0f "TELUGU LETTER EE"                       nil     )
    (#x000c10 "TELUGU LETTER AI"                       nil     )
    (#x000c12 "TELUGU LETTER O"                        nil     )
    (#x000c13 "TELUGU LETTER OO"                       nil     )
    (#x000c14 "TELUGU LETTER AU"                       nil     )
    (#x000c15 "TELUGU LETTER KA"                       nil     )
    (#x000c16 "TELUGU LETTER KHA"                      nil     )
    (#x000c17 "TELUGU LETTER GA"                       nil     )
    (#x000c18 "TELUGU LETTER GHA"                      nil     )
    (#x000c19 "TELUGU LETTER NGA"                      nil     )
    (#x000c1a "TELUGU LETTER CA"                       nil     )
    (#x000c1b "TELUGU LETTER CHA"                      nil     )
    (#x000c1c "TELUGU LETTER JA"                       nil     )
    (#x000c1d "TELUGU LETTER JHA"                      nil     )
    (#x000c1e "TELUGU LETTER NYA"                      nil     )
    (#x000c1f "TELUGU LETTER TTA"                      nil     )
    (#x000c20 "TELUGU LETTER TTHA"                     nil     )
    (#x000c21 "TELUGU LETTER DDA"                      nil     )
    (#x000c22 "TELUGU LETTER DDHA"                     nil     )
    (#x000c23 "TELUGU LETTER NNA"                      nil     )
    (#x000c24 "TELUGU LETTER TA"                       nil     )
    (#x000c25 "TELUGU LETTER THA"                      nil     )
    (#x000c26 "TELUGU LETTER DA"                       nil     )
    (#x000c27 "TELUGU LETTER DHA"                      nil     )
    (#x000c28 "TELUGU LETTER NA"                       nil     )
    (#x000c2a "TELUGU LETTER PA"                       nil     )
    (#x000c2b "TELUGU LETTER PHA"                      nil     )
    (#x000c2c "TELUGU LETTER BA"                       nil     )
    (#x000c2d "TELUGU LETTER BHA"                      nil     )
    (#x000c2e "TELUGU LETTER MA"                       nil     )
    (#x000c2f "TELUGU LETTER YA"                       nil     )
    (#x000c30 "TELUGU LETTER RA"                       nil     )
    (#x000c31 "TELUGU LETTER RRA"                      nil     )
    (#x000c32 "TELUGU LETTER LA"                       nil     )
    (#x000c33 "TELUGU LETTER LLA"                      nil     )
    (#x000c34 "TELUGU LETTER LLLA"                     nil     )
    (#x000c35 "TELUGU LETTER VA"                       nil     )
    (#x000c36 "TELUGU LETTER SHA"                      nil     )
    (#x000c37 "TELUGU LETTER SSA"                      nil     )
    (#x000c38 "TELUGU LETTER SA"                       nil     )
    (#x000c39 "TELUGU LETTER HA"                       nil     )
    (#x000c3c "TELUGU SIGN NUKTA"                      nil     )
    (#x000c3d "TELUGU SIGN AVAGRAHA"                   nil     )
    (#x000c3e "TELUGU VOWEL SIGN AA"                   nil     )
    (#x000c3f "TELUGU VOWEL SIGN I"                    nil     )
    (#x000c40 "TELUGU VOWEL SIGN II"                   nil     )
    (#x000c41 "TELUGU VOWEL SIGN U"                    nil     )
    (#x000c42 "TELUGU VOWEL SIGN UU"                   nil     )
    (#x000c43 "TELUGU VOWEL SIGN VOCALIC R"            nil     )
    (#x000c44 "TELUGU VOWEL SIGN VOCALIC RR"           nil     )
    (#x000c46 "TELUGU VOWEL SIGN E"                    nil     )
    (#x000c47 "TELUGU VOWEL SIGN EE"                   nil     )
    (#x000c48 "TELUGU VOWEL SIGN AI"                   nil     )
    (#x000c4a "TELUGU VOWEL SIGN O"                    nil     )
    (#x000c4b "TELUGU VOWEL SIGN OO"                   nil     )
    (#x000c4c "TELUGU VOWEL SIGN AU"                   nil     )
    (#x000c4d "TELUGU SIGN VIRAMA"                     nil     )
    (#x000c55 "TELUGU LENGTH MARK"                     nil     )
    (#x000c56 "TELUGU AI LENGTH MARK"                  nil     )
    (#x000c58 "TELUGU LETTER TSA"                      nil     )
    (#x000c59 "TELUGU LETTER DZA"                      nil     )
    (#x000c5a "TELUGU LETTER RRRA"                     nil     )
    (#x000c5d "TELUGU LETTER NAKAARA POLLU"            nil     )
    (#x000c60 "TELUGU LETTER VOCALIC RR"               nil     )
    (#x000c61 "TELUGU LETTER VOCALIC LL"               nil     )
    (#x000c62 "TELUGU VOWEL SIGN VOCALIC L"            nil     )
    (#x000c63 "TELUGU VOWEL SIGN VOCALIC LL"           nil     )
    (#x000c66 "TELUGU DIGIT ZERO"                      nil     )
    (#x000c67 "TELUGU DIGIT ONE"                       nil     )
    (#x000c68 "TELUGU DIGIT TWO"                       nil     )
    (#x000c69 "TELUGU DIGIT THREE"                     nil     )
    (#x000c6a "TELUGU DIGIT FOUR"                      nil     )
    (#x000c6b "TELUGU DIGIT FIVE"                      nil     )
    (#x000c6c "TELUGU DIGIT SIX"                       nil     )
    (#x000c6d "TELUGU DIGIT SEVEN"                     nil     )
    (#x000c6e "TELUGU DIGIT EIGHT"                     nil     )
    (#x000c6f "TELUGU DIGIT NINE"                      nil     )
    (#x000c77 "TELUGU SIGN SIDDHAM"                    nil     )
    (#x000c78 "TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR" nil     )
    (#x000c79 "TELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FOUR" nil     )
    (#x000c7a "TELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOUR" nil     )
    (#x000c7b "TELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOUR" nil     )
    (#x000c7c "TELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOUR" nil     )
    (#x000c7d "TELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOUR" nil     )
    (#x000c7e "TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR" nil     )
    (#x000c7f "TELUGU SIGN TUUMU"                      nil     )
    (#x000c80 "KANNADA SIGN SPACING CANDRABINDU"       nil     )
    (#x000c81 "KANNADA SIGN CANDRABINDU"               nil     )
    (#x000c82 "KANNADA SIGN ANUSVARA"                  nil     )
    (#x000c83 "KANNADA SIGN VISARGA"                   nil     )
    (#x000c84 "KANNADA SIGN SIDDHAM"                   nil     )
    (#x000c85 "KANNADA LETTER A"                       nil     )
    (#x000c86 "KANNADA LETTER AA"                      nil     )
    (#x000c87 "KANNADA LETTER I"                       nil     )
    (#x000c88 "KANNADA LETTER II"                      nil     )
    (#x000c89 "KANNADA LETTER U"                       nil     )
    (#x000c8a "KANNADA LETTER UU"                      nil     )
    (#x000c8b "KANNADA LETTER VOCALIC R"               nil     )
    (#x000c8c "KANNADA LETTER VOCALIC L"               nil     )
    (#x000c8e "KANNADA LETTER E"                       nil     )
    (#x000c8f "KANNADA LETTER EE"                      nil     )
    (#x000c90 "KANNADA LETTER AI"                      nil     )
    (#x000c92 "KANNADA LETTER O"                       nil     )
    (#x000c93 "KANNADA LETTER OO"                      nil     )
    (#x000c94 "KANNADA LETTER AU"                      nil     )
    (#x000c95 "KANNADA LETTER KA"                      nil     )
    (#x000c96 "KANNADA LETTER KHA"                     nil     )
    (#x000c97 "KANNADA LETTER GA"                      nil     )
    (#x000c98 "KANNADA LETTER GHA"                     nil     )
    (#x000c99 "KANNADA LETTER NGA"                     nil     )
    (#x000c9a "KANNADA LETTER CA"                      nil     )
    (#x000c9b "KANNADA LETTER CHA"                     nil     )
    (#x000c9c "KANNADA LETTER JA"                      nil     )
    (#x000c9d "KANNADA LETTER JHA"                     nil     )
    (#x000c9e "KANNADA LETTER NYA"                     nil     )
    (#x000c9f "KANNADA LETTER TTA"                     nil     )
    (#x000ca0 "KANNADA LETTER TTHA"                    nil     )
    (#x000ca1 "KANNADA LETTER DDA"                     nil     )
    (#x000ca2 "KANNADA LETTER DDHA"                    nil     )
    (#x000ca3 "KANNADA LETTER NNA"                     nil     )
    (#x000ca4 "KANNADA LETTER TA"                      nil     )
    (#x000ca5 "KANNADA LETTER THA"                     nil     )
    (#x000ca6 "KANNADA LETTER DA"                      nil     )
    (#x000ca7 "KANNADA LETTER DHA"                     nil     )
    (#x000ca8 "KANNADA LETTER NA"                      nil     )
    (#x000caa "KANNADA LETTER PA"                      nil     )
    (#x000cab "KANNADA LETTER PHA"                     nil     )
    (#x000cac "KANNADA LETTER BA"                      nil     )
    (#x000cad "KANNADA LETTER BHA"                     nil     )
    (#x000cae "KANNADA LETTER MA"                      nil     )
    (#x000caf "KANNADA LETTER YA"                      nil     )
    (#x000cb0 "KANNADA LETTER RA"                      nil     )
    (#x000cb1 "KANNADA LETTER RRA"                     nil     )
    (#x000cb2 "KANNADA LETTER LA"                      nil     )
    (#x000cb3 "KANNADA LETTER LLA"                     nil     )
    (#x000cb5 "KANNADA LETTER VA"                      nil     )
    (#x000cb6 "KANNADA LETTER SHA"                     nil     )
    (#x000cb7 "KANNADA LETTER SSA"                     nil     )
    (#x000cb8 "KANNADA LETTER SA"                      nil     )
    (#x000cb9 "KANNADA LETTER HA"                      nil     )
    (#x000cbc "KANNADA SIGN NUKTA"                     nil     )
    (#x000cbd "KANNADA SIGN AVAGRAHA"                  nil     )
    (#x000cbe "KANNADA VOWEL SIGN AA"                  nil     )
    (#x000cbf "KANNADA VOWEL SIGN I"                   nil     )
    (#x000cc0 "KANNADA VOWEL SIGN II"                  nil     )
    (#x000cc1 "KANNADA VOWEL SIGN U"                   nil     )
    (#x000cc2 "KANNADA VOWEL SIGN UU"                  nil     )
    (#x000cc3 "KANNADA VOWEL SIGN VOCALIC R"           nil     )
    (#x000cc4 "KANNADA VOWEL SIGN VOCALIC RR"          nil     )
    (#x000cc6 "KANNADA VOWEL SIGN E"                   nil     )
    (#x000cc7 "KANNADA VOWEL SIGN EE"                  nil     )
    (#x000cc8 "KANNADA VOWEL SIGN AI"                  nil     )
    (#x000cca "KANNADA VOWEL SIGN O"                   nil     )
    (#x000ccb "KANNADA VOWEL SIGN OO"                  nil     )
    (#x000ccc "KANNADA VOWEL SIGN AU"                  nil     )
    (#x000ccd "KANNADA SIGN VIRAMA"                    nil     )
    (#x000cd5 "KANNADA LENGTH MARK"                    nil     )
    (#x000cd6 "KANNADA AI LENGTH MARK"                 nil     )
    (#x000cdd "KANNADA LETTER NAKAARA POLLU"           nil     )
    (#x000cde "KANNADA LETTER FA"                      nil     )
    (#x000ce0 "KANNADA LETTER VOCALIC RR"              nil     )
    (#x000ce1 "KANNADA LETTER VOCALIC LL"              nil     )
    (#x000ce2 "KANNADA VOWEL SIGN VOCALIC L"           nil     )
    (#x000ce3 "KANNADA VOWEL SIGN VOCALIC LL"          nil     )
    (#x000ce6 "KANNADA DIGIT ZERO"                     nil     )
    (#x000ce7 "KANNADA DIGIT ONE"                      nil     )
    (#x000ce8 "KANNADA DIGIT TWO"                      nil     )
    (#x000ce9 "KANNADA DIGIT THREE"                    nil     )
    (#x000cea "KANNADA DIGIT FOUR"                     nil     )
    (#x000ceb "KANNADA DIGIT FIVE"                     nil     )
    (#x000cec "KANNADA DIGIT SIX"                      nil     )
    (#x000ced "KANNADA DIGIT SEVEN"                    nil     )
    (#x000cee "KANNADA DIGIT EIGHT"                    nil     )
    (#x000cef "KANNADA DIGIT NINE"                     nil     )
    (#x000cf1 "KANNADA SIGN JIHVAMULIYA"               nil     )
    (#x000cf2 "KANNADA SIGN UPADHMANIYA"               nil     )
    (#x000cf3 "KANNADA SIGN COMBINING ANUSVARA ABOVE RIGHT" nil     )
    (#x000d00 "MALAYALAM SIGN COMBINING ANUSVARA ABOVE" nil     )
    (#x000d01 "MALAYALAM SIGN CANDRABINDU"             nil     )
    (#x000d02 "MALAYALAM SIGN ANUSVARA"                nil     )
    (#x000d03 "MALAYALAM SIGN VISARGA"                 nil     )
    (#x000d04 "MALAYALAM LETTER VEDIC ANUSVARA"        nil     )
    (#x000d05 "MALAYALAM LETTER A"                     nil     )
    (#x000d06 "MALAYALAM LETTER AA"                    nil     )
    (#x000d07 "MALAYALAM LETTER I"                     nil     )
    (#x000d08 "MALAYALAM LETTER II"                    nil     )
    (#x000d09 "MALAYALAM LETTER U"                     nil     )
    (#x000d0a "MALAYALAM LETTER UU"                    nil     )
    (#x000d0b "MALAYALAM LETTER VOCALIC R"             nil     )
    (#x000d0c "MALAYALAM LETTER VOCALIC L"             nil     )
    (#x000d0e "MALAYALAM LETTER E"                     nil     )
    (#x000d0f "MALAYALAM LETTER EE"                    nil     )
    (#x000d10 "MALAYALAM LETTER AI"                    nil     )
    (#x000d12 "MALAYALAM LETTER O"                     nil     )
    (#x000d13 "MALAYALAM LETTER OO"                    nil     )
    (#x000d14 "MALAYALAM LETTER AU"                    nil     )
    (#x000d15 "MALAYALAM LETTER KA"                    nil     )
    (#x000d16 "MALAYALAM LETTER KHA"                   nil     )
    (#x000d17 "MALAYALAM LETTER GA"                    nil     )
    (#x000d18 "MALAYALAM LETTER GHA"                   nil     )
    (#x000d19 "MALAYALAM LETTER NGA"                   nil     )
    (#x000d1a "MALAYALAM LETTER CA"                    nil     )
    (#x000d1b "MALAYALAM LETTER CHA"                   nil     )
    (#x000d1c "MALAYALAM LETTER JA"                    nil     )
    (#x000d1d "MALAYALAM LETTER JHA"                   nil     )
    (#x000d1e "MALAYALAM LETTER NYA"                   nil     )
    (#x000d1f "MALAYALAM LETTER TTA"                   nil     )
    (#x000d20 "MALAYALAM LETTER TTHA"                  nil     )
    (#x000d21 "MALAYALAM LETTER DDA"                   nil     )
    (#x000d22 "MALAYALAM LETTER DDHA"                  nil     )
    (#x000d23 "MALAYALAM LETTER NNA"                   nil     )
    (#x000d24 "MALAYALAM LETTER TA"                    nil     )
    (#x000d25 "MALAYALAM LETTER THA"                   nil     )
    (#x000d26 "MALAYALAM LETTER DA"                    nil     )
    (#x000d27 "MALAYALAM LETTER DHA"                   nil     )
    (#x000d28 "MALAYALAM LETTER NA"                    nil     )
    (#x000d29 "MALAYALAM LETTER NNNA"                  nil     )
    (#x000d2a "MALAYALAM LETTER PA"                    nil     )
    (#x000d2b "MALAYALAM LETTER PHA"                   nil     )
    (#x000d2c "MALAYALAM LETTER BA"                    nil     )
    (#x000d2d "MALAYALAM LETTER BHA"                   nil     )
    (#x000d2e "MALAYALAM LETTER MA"                    nil     )
    (#x000d2f "MALAYALAM LETTER YA"                    nil     )
    (#x000d30 "MALAYALAM LETTER RA"                    nil     )
    (#x000d31 "MALAYALAM LETTER RRA"                   nil     )
    (#x000d32 "MALAYALAM LETTER LA"                    nil     )
    (#x000d33 "MALAYALAM LETTER LLA"                   nil     )
    (#x000d34 "MALAYALAM LETTER LLLA"                  nil     )
    (#x000d35 "MALAYALAM LETTER VA"                    nil     )
    (#x000d36 "MALAYALAM LETTER SHA"                   nil     )
    (#x000d37 "MALAYALAM LETTER SSA"                   nil     )
    (#x000d38 "MALAYALAM LETTER SA"                    nil     )
    (#x000d39 "MALAYALAM LETTER HA"                    nil     )
    (#x000d3a "MALAYALAM LETTER TTTA"                  nil     )
    (#x000d3b "MALAYALAM SIGN VERTICAL BAR VIRAMA"     nil     )
    (#x000d3c "MALAYALAM SIGN CIRCULAR VIRAMA"         nil     )
    (#x000d3d "MALAYALAM SIGN AVAGRAHA"                nil     )
    (#x000d3e "MALAYALAM VOWEL SIGN AA"                nil     )
    (#x000d3f "MALAYALAM VOWEL SIGN I"                 nil     )
    (#x000d40 "MALAYALAM VOWEL SIGN II"                nil     )
    (#x000d41 "MALAYALAM VOWEL SIGN U"                 nil     )
    (#x000d42 "MALAYALAM VOWEL SIGN UU"                nil     )
    (#x000d43 "MALAYALAM VOWEL SIGN VOCALIC R"         nil     )
    (#x000d44 "MALAYALAM VOWEL SIGN VOCALIC RR"        nil     )
    (#x000d46 "MALAYALAM VOWEL SIGN E"                 nil     )
    (#x000d47 "MALAYALAM VOWEL SIGN EE"                nil     )
    (#x000d48 "MALAYALAM VOWEL SIGN AI"                nil     )
    (#x000d4a "MALAYALAM VOWEL SIGN O"                 nil     )
    (#x000d4b "MALAYALAM VOWEL SIGN OO"                nil     )
    (#x000d4c "MALAYALAM VOWEL SIGN AU"                nil     )
    (#x000d4d "MALAYALAM SIGN VIRAMA"                  nil     )
    (#x000d4e "MALAYALAM LETTER DOT REPH"              nil     )
    (#x000d4f "MALAYALAM SIGN PARA"                    nil     )
    (#x000d54 "MALAYALAM LETTER CHILLU M"              nil     )
    (#x000d55 "MALAYALAM LETTER CHILLU Y"              nil     )
    (#x000d56 "MALAYALAM LETTER CHILLU LLL"            nil     )
    (#x000d57 "MALAYALAM AU LENGTH MARK"               nil     )
    (#x000d58 "MALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIETH" nil     )
    (#x000d59 "MALAYALAM FRACTION ONE FORTIETH"        nil     )
    (#x000d5a "MALAYALAM FRACTION THREE EIGHTIETHS"    nil     )
    (#x000d5b "MALAYALAM FRACTION ONE TWENTIETH"       nil     )
    (#x000d5c "MALAYALAM FRACTION ONE TENTH"           nil     )
    (#x000d5d "MALAYALAM FRACTION THREE TWENTIETHS"    nil     )
    (#x000d5e "MALAYALAM FRACTION ONE FIFTH"           nil     )
    (#x000d5f "MALAYALAM LETTER ARCHAIC II"            nil     )
    (#x000d60 "MALAYALAM LETTER VOCALIC RR"            nil     )
    (#x000d61 "MALAYALAM LETTER VOCALIC LL"            nil     )
    (#x000d62 "MALAYALAM VOWEL SIGN VOCALIC L"         nil     )
    (#x000d63 "MALAYALAM VOWEL SIGN VOCALIC LL"        nil     )
    (#x000d66 "MALAYALAM DIGIT ZERO"                   nil     )
    (#x000d67 "MALAYALAM DIGIT ONE"                    nil     )
    (#x000d68 "MALAYALAM DIGIT TWO"                    nil     )
    (#x000d69 "MALAYALAM DIGIT THREE"                  nil     )
    (#x000d6a "MALAYALAM DIGIT FOUR"                   nil     )
    (#x000d6b "MALAYALAM DIGIT FIVE"                   nil     )
    (#x000d6c "MALAYALAM DIGIT SIX"                    nil     )
    (#x000d6d "MALAYALAM DIGIT SEVEN"                  nil     )
    (#x000d6e "MALAYALAM DIGIT EIGHT"                  nil     )
    (#x000d6f "MALAYALAM DIGIT NINE"                   nil     )
    (#x000d70 "MALAYALAM NUMBER TEN"                   nil     )
    (#x000d71 "MALAYALAM NUMBER ONE HUNDRED"           nil     )
    (#x000d72 "MALAYALAM NUMBER ONE THOUSAND"          nil     )
    (#x000d73 "MALAYALAM FRACTION ONE QUARTER"         nil     )
    (#x000d74 "MALAYALAM FRACTION ONE HALF"            nil     )
    (#x000d75 "MALAYALAM FRACTION THREE QUARTERS"      nil     )
    (#x000d76 "MALAYALAM FRACTION ONE SIXTEENTH"       nil     )
    (#x000d77 "MALAYALAM FRACTION ONE EIGHTH"          nil     )
    (#x000d78 "MALAYALAM FRACTION THREE SIXTEENTHS"    nil     )
    (#x000d79 "MALAYALAM DATE MARK"                    nil     )
    (#x000d7a "MALAYALAM LETTER CHILLU NN"             nil     )
    (#x000d7b "MALAYALAM LETTER CHILLU N"              nil     )
    (#x000d7c "MALAYALAM LETTER CHILLU RR"             nil     )
    (#x000d7d "MALAYALAM LETTER CHILLU L"              nil     )
    (#x000d7e "MALAYALAM LETTER CHILLU LL"             nil     )
    (#x000d7f "MALAYALAM LETTER CHILLU K"              nil     )
    (#x000d81 "SINHALA SIGN CANDRABINDU"               nil     )
    (#x000d82 "SINHALA SIGN ANUSVARAYA"                nil     )
    (#x000d83 "SINHALA SIGN VISARGAYA"                 nil     )
    (#x000d85 "SINHALA LETTER AYANNA"                  nil     )
    (#x000d86 "SINHALA LETTER AAYANNA"                 nil     )
    (#x000d87 "SINHALA LETTER AEYANNA"                 nil     )
    (#x000d88 "SINHALA LETTER AEEYANNA"                nil     )
    (#x000d89 "SINHALA LETTER IYANNA"                  nil     )
    (#x000d8a "SINHALA LETTER IIYANNA"                 nil     )
    (#x000d8b "SINHALA LETTER UYANNA"                  nil     )
    (#x000d8c "SINHALA LETTER UUYANNA"                 nil     )
    (#x000d8d "SINHALA LETTER IRUYANNA"                nil     )
    (#x000d8e "SINHALA LETTER IRUUYANNA"               nil     )
    (#x000d8f "SINHALA LETTER ILUYANNA"                nil     )
    (#x000d90 "SINHALA LETTER ILUUYANNA"               nil     )
    (#x000d91 "SINHALA LETTER EYANNA"                  nil     )
    (#x000d92 "SINHALA LETTER EEYANNA"                 nil     )
    (#x000d93 "SINHALA LETTER AIYANNA"                 nil     )
    (#x000d94 "SINHALA LETTER OYANNA"                  nil     )
    (#x000d95 "SINHALA LETTER OOYANNA"                 nil     )
    (#x000d96 "SINHALA LETTER AUYANNA"                 nil     )
    (#x000d9a "SINHALA LETTER ALPAPRAANA KAYANNA"      nil     )
    (#x000d9b "SINHALA LETTER MAHAAPRAANA KAYANNA"     nil     )
    (#x000d9c "SINHALA LETTER ALPAPRAANA GAYANNA"      nil     )
    (#x000d9d "SINHALA LETTER MAHAAPRAANA GAYANNA"     nil     )
    (#x000d9e "SINHALA LETTER KANTAJA NAASIKYAYA"      nil     )
    (#x000d9f "SINHALA LETTER SANYAKA GAYANNA"         nil     )
    (#x000da0 "SINHALA LETTER ALPAPRAANA CAYANNA"      nil     )
    (#x000da1 "SINHALA LETTER MAHAAPRAANA CAYANNA"     nil     )
    (#x000da2 "SINHALA LETTER ALPAPRAANA JAYANNA"      nil     )
    (#x000da3 "SINHALA LETTER MAHAAPRAANA JAYANNA"     nil     )
    (#x000da4 "SINHALA LETTER TAALUJA NAASIKYAYA"      nil     )
    (#x000da5 "SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA" nil     )
    (#x000da6 "SINHALA LETTER SANYAKA JAYANNA"         nil     )
    (#x000da7 "SINHALA LETTER ALPAPRAANA TTAYANNA"     nil     )
    (#x000da8 "SINHALA LETTER MAHAAPRAANA TTAYANNA"    nil     )
    (#x000da9 "SINHALA LETTER ALPAPRAANA DDAYANNA"     nil     )
    (#x000daa "SINHALA LETTER MAHAAPRAANA DDAYANNA"    nil     )
    (#x000dab "SINHALA LETTER MUURDHAJA NAYANNA"       nil     )
    (#x000dac "SINHALA LETTER SANYAKA DDAYANNA"        nil     )
    (#x000dad "SINHALA LETTER ALPAPRAANA TAYANNA"      nil     )
    (#x000dae "SINHALA LETTER MAHAAPRAANA TAYANNA"     nil     )
    (#x000daf "SINHALA LETTER ALPAPRAANA DAYANNA"      nil     )
    (#x000db0 "SINHALA LETTER MAHAAPRAANA DAYANNA"     nil     )
    (#x000db1 "SINHALA LETTER DANTAJA NAYANNA"         nil     )
    (#x000db3 "SINHALA LETTER SANYAKA DAYANNA"         nil     )
    (#x000db4 "SINHALA LETTER ALPAPRAANA PAYANNA"      nil     )
    (#x000db5 "SINHALA LETTER MAHAAPRAANA PAYANNA"     nil     )
    (#x000db6 "SINHALA LETTER ALPAPRAANA BAYANNA"      nil     )
    (#x000db7 "SINHALA LETTER MAHAAPRAANA BAYANNA"     nil     )
    (#x000db8 "SINHALA LETTER MAYANNA"                 nil     )
    (#x000db9 "SINHALA LETTER AMBA BAYANNA"            nil     )
    (#x000dba "SINHALA LETTER YAYANNA"                 nil     )
    (#x000dbb "SINHALA LETTER RAYANNA"                 nil     )
    (#x000dbd "SINHALA LETTER DANTAJA LAYANNA"         nil     )
    (#x000dc0 "SINHALA LETTER VAYANNA"                 nil     )
    (#x000dc1 "SINHALA LETTER TAALUJA SAYANNA"         nil     )
    (#x000dc2 "SINHALA LETTER MUURDHAJA SAYANNA"       nil     )
    (#x000dc3 "SINHALA LETTER DANTAJA SAYANNA"         nil     )
    (#x000dc4 "SINHALA LETTER HAYANNA"                 nil     )
    (#x000dc5 "SINHALA LETTER MUURDHAJA LAYANNA"       nil     )
    (#x000dc6 "SINHALA LETTER FAYANNA"                 nil     )
    (#x000dca "SINHALA SIGN AL-LAKUNA"                 nil     )
    (#x000dcf "SINHALA VOWEL SIGN AELA-PILLA"          nil     )
    (#x000dd0 "SINHALA VOWEL SIGN KETTI AEDA-PILLA"    nil     )
    (#x000dd1 "SINHALA VOWEL SIGN DIGA AEDA-PILLA"     nil     )
    (#x000dd2 "SINHALA VOWEL SIGN KETTI IS-PILLA"      nil     )
    (#x000dd3 "SINHALA VOWEL SIGN DIGA IS-PILLA"       nil     )
    (#x000dd4 "SINHALA VOWEL SIGN KETTI PAA-PILLA"     nil     )
    (#x000dd6 "SINHALA VOWEL SIGN DIGA PAA-PILLA"      nil     )
    (#x000dd8 "SINHALA VOWEL SIGN GAETTA-PILLA"        nil     )
    (#x000dd9 "SINHALA VOWEL SIGN KOMBUVA"             nil     )
    (#x000dda "SINHALA VOWEL SIGN DIGA KOMBUVA"        nil     )
    (#x000ddb "SINHALA VOWEL SIGN KOMBU DEKA"          nil     )
    (#x000ddc "SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA" nil     )
    (#x000ddd "SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA" nil     )
    (#x000dde "SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA" nil     )
    (#x000ddf "SINHALA VOWEL SIGN GAYANUKITTA"         nil     )
    (#x000de6 "SINHALA LITH DIGIT ZERO"                nil     )
    (#x000de7 "SINHALA LITH DIGIT ONE"                 nil     )
    (#x000de8 "SINHALA LITH DIGIT TWO"                 nil     )
    (#x000de9 "SINHALA LITH DIGIT THREE"               nil     )
    (#x000dea "SINHALA LITH DIGIT FOUR"                nil     )
    (#x000deb "SINHALA LITH DIGIT FIVE"                nil     )
    (#x000dec "SINHALA LITH DIGIT SIX"                 nil     )
    (#x000ded "SINHALA LITH DIGIT SEVEN"               nil     )
    (#x000dee "SINHALA LITH DIGIT EIGHT"               nil     )
    (#x000def "SINHALA LITH DIGIT NINE"                nil     )
    (#x000df2 "SINHALA VOWEL SIGN DIGA GAETTA-PILLA"   nil     )
    (#x000df3 "SINHALA VOWEL SIGN DIGA GAYANUKITTA"    nil     )
    (#x000df4 "SINHALA PUNCTUATION KUNDDALIYA"         nil     )
    (#x000e01 "THAI CHARACTER KO KAI"                  nil     )
    (#x000e02 "THAI CHARACTER KHO KHAI"                nil     )
    (#x000e03 "THAI CHARACTER KHO KHUAT"               nil     )
    (#x000e04 "THAI CHARACTER KHO KHWAI"               nil     )
    (#x000e05 "THAI CHARACTER KHO KHON"                nil     )
    (#x000e06 "THAI CHARACTER KHO RAKHANG"             nil     )
    (#x000e07 "THAI CHARACTER NGO NGU"                 nil     )
    (#x000e08 "THAI CHARACTER CHO CHAN"                nil     )
    (#x000e09 "THAI CHARACTER CHO CHING"               nil     )
    (#x000e0a "THAI CHARACTER CHO CHANG"               nil     )
    (#x000e0b "THAI CHARACTER SO SO"                   nil     )
    (#x000e0c "THAI CHARACTER CHO CHOE"                nil     )
    (#x000e0d "THAI CHARACTER YO YING"                 nil     )
    (#x000e0e "THAI CHARACTER DO CHADA"                nil     )
    (#x000e0f "THAI CHARACTER TO PATAK"                nil     )
    (#x000e10 "THAI CHARACTER THO THAN"                nil     )
    (#x000e11 "THAI CHARACTER THO NANGMONTHO"          nil     )
    (#x000e12 "THAI CHARACTER THO PHUTHAO"             nil     )
    (#x000e13 "THAI CHARACTER NO NEN"                  nil     )
    (#x000e14 "THAI CHARACTER DO DEK"                  nil     )
    (#x000e15 "THAI CHARACTER TO TAO"                  nil     )
    (#x000e16 "THAI CHARACTER THO THUNG"               nil     )
    (#x000e17 "THAI CHARACTER THO THAHAN"              nil     )
    (#x000e18 "THAI CHARACTER THO THONG"               nil     )
    (#x000e19 "THAI CHARACTER NO NU"                   nil     )
    (#x000e1a "THAI CHARACTER BO BAIMAI"               nil     )
    (#x000e1b "THAI CHARACTER PO PLA"                  nil     )
    (#x000e1c "THAI CHARACTER PHO PHUNG"               nil     )
    (#x000e1d "THAI CHARACTER FO FA"                   nil     )
    (#x000e1e "THAI CHARACTER PHO PHAN"                nil     )
    (#x000e1f "THAI CHARACTER FO FAN"                  nil     )
    (#x000e20 "THAI CHARACTER PHO SAMPHAO"             nil     )
    (#x000e21 "THAI CHARACTER MO MA"                   nil     )
    (#x000e22 "THAI CHARACTER YO YAK"                  nil     )
    (#x000e23 "THAI CHARACTER RO RUA"                  nil     )
    (#x000e24 "THAI CHARACTER RU"                      nil     )
    (#x000e25 "THAI CHARACTER LO LING"                 nil     )
    (#x000e26 "THAI CHARACTER LU"                      nil     )
    (#x000e27 "THAI CHARACTER WO WAEN"                 nil     )
    (#x000e28 "THAI CHARACTER SO SALA"                 nil     )
    (#x000e29 "THAI CHARACTER SO RUSI"                 nil     )
    (#x000e2a "THAI CHARACTER SO SUA"                  nil     )
    (#x000e2b "THAI CHARACTER HO HIP"                  nil     )
    (#x000e2c "THAI CHARACTER LO CHULA"                nil     )
    (#x000e2d "THAI CHARACTER O ANG"                   nil     )
    (#x000e2e "THAI CHARACTER HO NOKHUK"               nil     )
    (#x000e2f "THAI CHARACTER PAIYANNOI"               nil     )
    (#x000e30 "THAI CHARACTER SARA A"                  nil     )
    (#x000e31 "THAI CHARACTER MAI HAN-AKAT"            nil     )
    (#x000e32 "THAI CHARACTER SARA AA"                 nil     )
    (#x000e33 "THAI CHARACTER SARA AM"                 nil     )
    (#x000e34 "THAI CHARACTER SARA I"                  nil     )
    (#x000e35 "THAI CHARACTER SARA II"                 nil     )
    (#x000e36 "THAI CHARACTER SARA UE"                 nil     )
    (#x000e37 "THAI CHARACTER SARA UEE"                nil     )
    (#x000e38 "THAI CHARACTER SARA U"                  nil     )
    (#x000e39 "THAI CHARACTER SARA UU"                 nil     )
    (#x000e3a "THAI CHARACTER PHINTHU"                 nil     )
    (#x000e3f "THAI CURRENCY SYMBOL BAHT"              nil     )
    (#x000e40 "THAI CHARACTER SARA E"                  nil     )
    (#x000e41 "THAI CHARACTER SARA AE"                 nil     )
    (#x000e42 "THAI CHARACTER SARA O"                  nil     )
    (#x000e43 "THAI CHARACTER SARA AI MAIMUAN"         nil     )
    (#x000e44 "THAI CHARACTER SARA AI MAIMALAI"        nil     )
    (#x000e45 "THAI CHARACTER LAKKHANGYAO"             nil     )
    (#x000e46 "THAI CHARACTER MAIYAMOK"                nil     )
    (#x000e47 "THAI CHARACTER MAITAIKHU"               nil     )
    (#x000e48 "THAI CHARACTER MAI EK"                  nil     )
    (#x000e49 "THAI CHARACTER MAI THO"                 nil     )
    (#x000e4a "THAI CHARACTER MAI TRI"                 nil     )
    (#x000e4b "THAI CHARACTER MAI CHATTAWA"            nil     )
    (#x000e4c "THAI CHARACTER THANTHAKHAT"             nil     )
    (#x000e4d "THAI CHARACTER NIKHAHIT"                nil     )
    (#x000e4e "THAI CHARACTER YAMAKKAN"                nil     )
    (#x000e4f "THAI CHARACTER FONGMAN"                 nil     )
    (#x000e50 "THAI DIGIT ZERO"                        nil     )
    (#x000e51 "THAI DIGIT ONE"                         nil     )
    (#x000e52 "THAI DIGIT TWO"                         nil     )
    (#x000e53 "THAI DIGIT THREE"                       nil     )
    (#x000e54 "THAI DIGIT FOUR"                        nil     )
    (#x000e55 "THAI DIGIT FIVE"                        nil     )
    (#x000e56 "THAI DIGIT SIX"                         nil     )
    (#x000e57 "THAI DIGIT SEVEN"                       nil     )
    (#x000e58 "THAI DIGIT EIGHT"                       nil     )
    (#x000e59 "THAI DIGIT NINE"                        nil     )
    (#x000e5a "THAI CHARACTER ANGKHANKHU"              nil     )
    (#x000e5b "THAI CHARACTER KHOMUT"                  nil     )
    (#x000e81 "LAO LETTER KO"                          nil     )
    (#x000e82 "LAO LETTER KHO SUNG"                    nil     )
    (#x000e84 "LAO LETTER KHO TAM"                     nil     )
    (#x000e86 "LAO LETTER PALI GHA"                    nil     )
    (#x000e87 "LAO LETTER NGO"                         nil     )
    (#x000e88 "LAO LETTER CO"                          nil     )
    (#x000e89 "LAO LETTER PALI CHA"                    nil     )
    (#x000e8a "LAO LETTER SO TAM"                      nil     )
    (#x000e8c "LAO LETTER PALI JHA"                    nil     )
    (#x000e8d "LAO LETTER NYO"                         nil     )
    (#x000e8e "LAO LETTER PALI NYA"                    nil     )
    (#x000e8f "LAO LETTER PALI TTA"                    nil     )
    (#x000e90 "LAO LETTER PALI TTHA"                   nil     )
    (#x000e91 "LAO LETTER PALI DDA"                    nil     )
    (#x000e92 "LAO LETTER PALI DDHA"                   nil     )
    (#x000e93 "LAO LETTER PALI NNA"                    nil     )
    (#x000e94 "LAO LETTER DO"                          nil     )
    (#x000e95 "LAO LETTER TO"                          nil     )
    (#x000e96 "LAO LETTER THO SUNG"                    nil     )
    (#x000e97 "LAO LETTER THO TAM"                     nil     )
    (#x000e98 "LAO LETTER PALI DHA"                    nil     )
    (#x000e99 "LAO LETTER NO"                          nil     )
    (#x000e9a "LAO LETTER BO"                          nil     )
    (#x000e9b "LAO LETTER PO"                          nil     )
    (#x000e9c "LAO LETTER PHO SUNG"                    nil     )
    (#x000e9d "LAO LETTER FO TAM"                      nil     )
    (#x000e9e "LAO LETTER PHO TAM"                     nil     )
    (#x000e9f "LAO LETTER FO SUNG"                     nil     )
    (#x000ea0 "LAO LETTER PALI BHA"                    nil     )
    (#x000ea1 "LAO LETTER MO"                          nil     )
    (#x000ea2 "LAO LETTER YO"                          nil     )
    (#x000ea3 "LAO LETTER LO LING"                     nil     )
    (#x000ea5 "LAO LETTER LO LOOT"                     nil     )
    (#x000ea7 "LAO LETTER WO"                          nil     )
    (#x000ea8 "LAO LETTER SANSKRIT SHA"                nil     )
    (#x000ea9 "LAO LETTER SANSKRIT SSA"                nil     )
    (#x000eaa "LAO LETTER SO SUNG"                     nil     )
    (#x000eab "LAO LETTER HO SUNG"                     nil     )
    (#x000eac "LAO LETTER PALI LLA"                    nil     )
    (#x000ead "LAO LETTER O"                           nil     )
    (#x000eae "LAO LETTER HO TAM"                      nil     )
    (#x000eaf "LAO ELLIPSIS"                           nil     )
    (#x000eb0 "LAO VOWEL SIGN A"                       nil     )
    (#x000eb1 "LAO VOWEL SIGN MAI KAN"                 nil     )
    (#x000eb2 "LAO VOWEL SIGN AA"                      nil     )
    (#x000eb3 "LAO VOWEL SIGN AM"                      nil     )
    (#x000eb4 "LAO VOWEL SIGN I"                       nil     )
    (#x000eb5 "LAO VOWEL SIGN II"                      nil     )
    (#x000eb6 "LAO VOWEL SIGN Y"                       nil     )
    (#x000eb7 "LAO VOWEL SIGN YY"                      nil     )
    (#x000eb8 "LAO VOWEL SIGN U"                       nil     )
    (#x000eb9 "LAO VOWEL SIGN UU"                      nil     )
    (#x000eba "LAO SIGN PALI VIRAMA"                   nil     )
    (#x000ebb "LAO VOWEL SIGN MAI KON"                 nil     )
    (#x000ebc "LAO SEMIVOWEL SIGN LO"                  nil     )
    (#x000ebd "LAO SEMIVOWEL SIGN NYO"                 nil     )
    (#x000ec0 "LAO VOWEL SIGN E"                       nil     )
    (#x000ec1 "LAO VOWEL SIGN EI"                      nil     )
    (#x000ec2 "LAO VOWEL SIGN O"                       nil     )
    (#x000ec3 "LAO VOWEL SIGN AY"                      nil     )
    (#x000ec4 "LAO VOWEL SIGN AI"                      nil     )
    (#x000ec6 "LAO KO LA"                              nil     )
    (#x000ec8 "LAO TONE MAI EK"                        nil     )
    (#x000ec9 "LAO TONE MAI THO"                       nil     )
    (#x000eca "LAO TONE MAI TI"                        nil     )
    (#x000ecb "LAO TONE MAI CATAWA"                    nil     )
    (#x000ecc "LAO CANCELLATION MARK"                  nil     )
    (#x000ecd "LAO NIGGAHITA"                          nil     )
    (#x000ece "LAO YAMAKKAN"                           nil     )
    (#x000ed0 "LAO DIGIT ZERO"                         nil     )
    (#x000ed1 "LAO DIGIT ONE"                          nil     )
    (#x000ed2 "LAO DIGIT TWO"                          nil     )
    (#x000ed3 "LAO DIGIT THREE"                        nil     )
    (#x000ed4 "LAO DIGIT FOUR"                         nil     )
    (#x000ed5 "LAO DIGIT FIVE"                         nil     )
    (#x000ed6 "LAO DIGIT SIX"                          nil     )
    (#x000ed7 "LAO DIGIT SEVEN"                        nil     )
    (#x000ed8 "LAO DIGIT EIGHT"                        nil     )
    (#x000ed9 "LAO DIGIT NINE"                         nil     )
    (#x000edc "LAO HO NO"                              nil     )
    (#x000edd "LAO HO MO"                              nil     )
    (#x000ede "LAO LETTER KHMU GO"                     nil     )
    (#x000edf "LAO LETTER KHMU NYO"                    nil     )
    (#x000f00 "TIBETAN SYLLABLE OM"                    nil     )
    (#x000f01 "TIBETAN MARK GTER YIG MGO TRUNCATED A"  nil     )
    (#x000f02 "TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA" nil     )
    (#x000f03 "TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA" nil     )
    (#x000f04 "TIBETAN MARK INITIAL YIG MGO MDUN MA"   nil     )
    (#x000f05 "TIBETAN MARK CLOSING YIG MGO SGAB MA"   nil     )
    (#x000f06 "TIBETAN MARK CARET YIG MGO PHUR SHAD MA" nil     )
    (#x000f07 "TIBETAN MARK YIG MGO TSHEG SHAD MA"     nil     )
    (#x000f08 "TIBETAN MARK SBRUL SHAD"                nil     )
    (#x000f09 "TIBETAN MARK BSKUR YIG MGO"             nil     )
    (#x000f0a "TIBETAN MARK BKA- SHOG YIG MGO"         nil     )
    (#x000f0b "TIBETAN MARK INTERSYLLABIC TSHEG"       nil     )
    (#x000f0c "TIBETAN MARK DELIMITER TSHEG BSTAR"     nil     )
    (#x000f0d "TIBETAN MARK SHAD"                      nil     )
    (#x000f0e "TIBETAN MARK NYIS SHAD"                 nil     )
    (#x000f0f "TIBETAN MARK TSHEG SHAD"                nil     )
    (#x000f10 "TIBETAN MARK NYIS TSHEG SHAD"           nil     )
    (#x000f11 "TIBETAN MARK RIN CHEN SPUNGS SHAD"      nil     )
    (#x000f12 "TIBETAN MARK RGYA GRAM SHAD"            nil     )
    (#x000f13 "TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN" nil     )
    (#x000f14 "TIBETAN MARK GTER TSHEG"                nil     )
    (#x000f15 "TIBETAN LOGOTYPE SIGN CHAD RTAGS"       nil     )
    (#x000f16 "TIBETAN LOGOTYPE SIGN LHAG RTAGS"       nil     )
    (#x000f17 "TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS" nil     )
    (#x000f18 "TIBETAN ASTROLOGICAL SIGN -KHYUD PA"    nil     )
    (#x000f19 "TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS" nil     )
    (#x000f1a "TIBETAN SIGN RDEL DKAR GCIG"            nil     )
    (#x000f1b "TIBETAN SIGN RDEL DKAR GNYIS"           nil     )
    (#x000f1c "TIBETAN SIGN RDEL DKAR GSUM"            nil     )
    (#x000f1d "TIBETAN SIGN RDEL NAG GCIG"             nil     )
    (#x000f1e "TIBETAN SIGN RDEL NAG GNYIS"            nil     )
    (#x000f1f "TIBETAN SIGN RDEL DKAR RDEL NAG"        nil     )
    (#x000f20 "TIBETAN DIGIT ZERO"                     nil     )
    (#x000f21 "TIBETAN DIGIT ONE"                      nil     )
    (#x000f22 "TIBETAN DIGIT TWO"                      nil     )
    (#x000f23 "TIBETAN DIGIT THREE"                    nil     )
    (#x000f24 "TIBETAN DIGIT FOUR"                     nil     )
    (#x000f25 "TIBETAN DIGIT FIVE"                     nil     )
    (#x000f26 "TIBETAN DIGIT SIX"                      nil     )
    (#x000f27 "TIBETAN DIGIT SEVEN"                    nil     )
    (#x000f28 "TIBETAN DIGIT EIGHT"                    nil     )
    (#x000f29 "TIBETAN DIGIT NINE"                     nil     )
    (#x000f2a "TIBETAN DIGIT HALF ONE"                 nil     )
    (#x000f2b "TIBETAN DIGIT HALF TWO"                 nil     )
    (#x000f2c "TIBETAN DIGIT HALF THREE"               nil     )
    (#x000f2d "TIBETAN DIGIT HALF FOUR"                nil     )
    (#x000f2e "TIBETAN DIGIT HALF FIVE"                nil     )
    (#x000f2f "TIBETAN DIGIT HALF SIX"                 nil     )
    (#x000f30 "TIBETAN DIGIT HALF SEVEN"               nil     )
    (#x000f31 "TIBETAN DIGIT HALF EIGHT"               nil     )
    (#x000f32 "TIBETAN DIGIT HALF NINE"                nil     )
    (#x000f33 "TIBETAN DIGIT HALF ZERO"                nil     )
    (#x000f34 "TIBETAN MARK BSDUS RTAGS"               nil     )
    (#x000f35 "TIBETAN MARK NGAS BZUNG NYI ZLA"        nil     )
    (#x000f36 "TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN" nil     )
    (#x000f37 "TIBETAN MARK NGAS BZUNG SGOR RTAGS"     nil     )
    (#x000f38 "TIBETAN MARK CHE MGO"                   nil     )
    (#x000f39 "TIBETAN MARK TSA -PHRU"                 nil     )
    (#x000f3a "TIBETAN MARK GUG RTAGS GYON"            nil     )
    (#x000f3b "TIBETAN MARK GUG RTAGS GYAS"            nil     )
    (#x000f3c "TIBETAN MARK ANG KHANG GYON"            nil     )
    (#x000f3d "TIBETAN MARK ANG KHANG GYAS"            nil     )
    (#x000f3e "TIBETAN SIGN YAR TSHES"                 nil     )
    (#x000f3f "TIBETAN SIGN MAR TSHES"                 nil     )
    (#x000f40 "TIBETAN LETTER KA"                      nil     )
    (#x000f41 "TIBETAN LETTER KHA"                     nil     )
    (#x000f42 "TIBETAN LETTER GA"                      nil     )
    (#x000f43 "TIBETAN LETTER GHA"                     nil     )
    (#x000f44 "TIBETAN LETTER NGA"                     nil     )
    (#x000f45 "TIBETAN LETTER CA"                      nil     )
    (#x000f46 "TIBETAN LETTER CHA"                     nil     )
    (#x000f47 "TIBETAN LETTER JA"                      nil     )
    (#x000f49 "TIBETAN LETTER NYA"                     nil     )
    (#x000f4a "TIBETAN LETTER TTA"                     nil     )
    (#x000f4b "TIBETAN LETTER TTHA"                    nil     )
    (#x000f4c "TIBETAN LETTER DDA"                     nil     )
    (#x000f4d "TIBETAN LETTER DDHA"                    nil     )
    (#x000f4e "TIBETAN LETTER NNA"                     nil     )
    (#x000f4f "TIBETAN LETTER TA"                      nil     )
    (#x000f50 "TIBETAN LETTER THA"                     nil     )
    (#x000f51 "TIBETAN LETTER DA"                      nil     )
    (#x000f52 "TIBETAN LETTER DHA"                     nil     )
    (#x000f53 "TIBETAN LETTER NA"                      nil     )
    (#x000f54 "TIBETAN LETTER PA"                      nil     )
    (#x000f55 "TIBETAN LETTER PHA"                     nil     )
    (#x000f56 "TIBETAN LETTER BA"                      nil     )
    (#x000f57 "TIBETAN LETTER BHA"                     nil     )
    (#x000f58 "TIBETAN LETTER MA"                      nil     )
    (#x000f59 "TIBETAN LETTER TSA"                     nil     )
    (#x000f5a "TIBETAN LETTER TSHA"                    nil     )
    (#x000f5b "TIBETAN LETTER DZA"                     nil     )
    (#x000f5c "TIBETAN LETTER DZHA"                    nil     )
    (#x000f5d "TIBETAN LETTER WA"                      nil     )
    (#x000f5e "TIBETAN LETTER ZHA"                     nil     )
    (#x000f5f "TIBETAN LETTER ZA"                      nil     )
    (#x000f60 "TIBETAN LETTER -A"                      nil     )
    (#x000f61 "TIBETAN LETTER YA"                      nil     )
    (#x000f62 "TIBETAN LETTER RA"                      nil     )
    (#x000f63 "TIBETAN LETTER LA"                      nil     )
    (#x000f64 "TIBETAN LETTER SHA"                     nil     )
    (#x000f65 "TIBETAN LETTER SSA"                     nil     )
    (#x000f66 "TIBETAN LETTER SA"                      nil     )
    (#x000f67 "TIBETAN LETTER HA"                      nil     )
    (#x000f68 "TIBETAN LETTER A"                       nil     )
    (#x000f69 "TIBETAN LETTER KSSA"                    nil     )
    (#x000f6a "TIBETAN LETTER FIXED-FORM RA"           nil     )
    (#x000f6b "TIBETAN LETTER KKA"                     nil     )
    (#x000f6c "TIBETAN LETTER RRA"                     nil     )
    (#x000f71 "TIBETAN VOWEL SIGN AA"                  nil     )
    (#x000f72 "TIBETAN VOWEL SIGN I"                   nil     )
    (#x000f73 "TIBETAN VOWEL SIGN II"                  nil     )
    (#x000f74 "TIBETAN VOWEL SIGN U"                   nil     )
    (#x000f75 "TIBETAN VOWEL SIGN UU"                  nil     )
    (#x000f76 "TIBETAN VOWEL SIGN VOCALIC R"           nil     )
    (#x000f77 "TIBETAN VOWEL SIGN VOCALIC RR"          nil     )
    (#x000f78 "TIBETAN VOWEL SIGN VOCALIC L"           nil     )
    (#x000f79 "TIBETAN VOWEL SIGN VOCALIC LL"          nil     )
    (#x000f7a "TIBETAN VOWEL SIGN E"                   nil     )
    (#x000f7b "TIBETAN VOWEL SIGN EE"                  nil     )
    (#x000f7c "TIBETAN VOWEL SIGN O"                   nil     )
    (#x000f7d "TIBETAN VOWEL SIGN OO"                  nil     )
    (#x000f7e "TIBETAN SIGN RJES SU NGA RO"            nil     )
    (#x000f7f "TIBETAN SIGN RNAM BCAD"                 nil     )
    (#x000f80 "TIBETAN VOWEL SIGN REVERSED I"          nil     )
    (#x000f81 "TIBETAN VOWEL SIGN REVERSED II"         nil     )
    (#x000f82 "TIBETAN SIGN NYI ZLA NAA DA"            nil     )
    (#x000f83 "TIBETAN SIGN SNA LDAN"                  nil     )
    (#x000f84 "TIBETAN MARK HALANTA"                   nil     )
    (#x000f85 "TIBETAN MARK PALUTA"                    nil     )
    (#x000f86 "TIBETAN SIGN LCI RTAGS"                 nil     )
    (#x000f87 "TIBETAN SIGN YANG RTAGS"                nil     )
    (#x000f88 "TIBETAN SIGN LCE TSA CAN"               nil     )
    (#x000f89 "TIBETAN SIGN MCHU CAN"                  nil     )
    (#x000f8a "TIBETAN SIGN GRU CAN RGYINGS"           nil     )
    (#x000f8b "TIBETAN SIGN GRU MED RGYINGS"           nil     )
    (#x000f8c "TIBETAN SIGN INVERTED MCHU CAN"         nil     )
    (#x000f8d "TIBETAN SUBJOINED SIGN LCE TSA CAN"     nil     )
    (#x000f8e "TIBETAN SUBJOINED SIGN MCHU CAN"        nil     )
    (#x000f8f "TIBETAN SUBJOINED SIGN INVERTED MCHU CAN" nil     )
    (#x000f90 "TIBETAN SUBJOINED LETTER KA"            nil     )
    (#x000f91 "TIBETAN SUBJOINED LETTER KHA"           nil     )
    (#x000f92 "TIBETAN SUBJOINED LETTER GA"            nil     )
    (#x000f93 "TIBETAN SUBJOINED LETTER GHA"           nil     )
    (#x000f94 "TIBETAN SUBJOINED LETTER NGA"           nil     )
    (#x000f95 "TIBETAN SUBJOINED LETTER CA"            nil     )
    (#x000f96 "TIBETAN SUBJOINED LETTER CHA"           nil     )
    (#x000f97 "TIBETAN SUBJOINED LETTER JA"            nil     )
    (#x000f99 "TIBETAN SUBJOINED LETTER NYA"           nil     )
    (#x000f9a "TIBETAN SUBJOINED LETTER TTA"           nil     )
    (#x000f9b "TIBETAN SUBJOINED LETTER TTHA"          nil     )
    (#x000f9c "TIBETAN SUBJOINED LETTER DDA"           nil     )
    (#x000f9d "TIBETAN SUBJOINED LETTER DDHA"          nil     )
    (#x000f9e "TIBETAN SUBJOINED LETTER NNA"           nil     )
    (#x000f9f "TIBETAN SUBJOINED LETTER TA"            nil     )
    (#x000fa0 "TIBETAN SUBJOINED LETTER THA"           nil     )
    (#x000fa1 "TIBETAN SUBJOINED LETTER DA"            nil     )
    (#x000fa2 "TIBETAN SUBJOINED LETTER DHA"           nil     )
    (#x000fa3 "TIBETAN SUBJOINED LETTER NA"            nil     )
    (#x000fa4 "TIBETAN SUBJOINED LETTER PA"            nil     )
    (#x000fa5 "TIBETAN SUBJOINED LETTER PHA"           nil     )
    (#x000fa6 "TIBETAN SUBJOINED LETTER BA"            nil     )
    (#x000fa7 "TIBETAN SUBJOINED LETTER BHA"           nil     )
    (#x000fa8 "TIBETAN SUBJOINED LETTER MA"            nil     )
    (#x000fa9 "TIBETAN SUBJOINED LETTER TSA"           nil     )
    (#x000faa "TIBETAN SUBJOINED LETTER TSHA"          nil     )
    (#x000fab "TIBETAN SUBJOINED LETTER DZA"           nil     )
    (#x000fac "TIBETAN SUBJOINED LETTER DZHA"          nil     )
    (#x000fad "TIBETAN SUBJOINED LETTER WA"            nil     )
    (#x000fae "TIBETAN SUBJOINED LETTER ZHA"           nil     )
    (#x000faf "TIBETAN SUBJOINED LETTER ZA"            nil     )
    (#x000fb0 "TIBETAN SUBJOINED LETTER -A"            nil     )
    (#x000fb1 "TIBETAN SUBJOINED LETTER YA"            nil     )
    (#x000fb2 "TIBETAN SUBJOINED LETTER RA"            nil     )
    (#x000fb3 "TIBETAN SUBJOINED LETTER LA"            nil     )
    (#x000fb4 "TIBETAN SUBJOINED LETTER SHA"           nil     )
    (#x000fb5 "TIBETAN SUBJOINED LETTER SSA"           nil     )
    (#x000fb6 "TIBETAN SUBJOINED LETTER SA"            nil     )
    (#x000fb7 "TIBETAN SUBJOINED LETTER HA"            nil     )
    (#x000fb8 "TIBETAN SUBJOINED LETTER A"             nil     )
    (#x000fb9 "TIBETAN SUBJOINED LETTER KSSA"          nil     )
    (#x000fba "TIBETAN SUBJOINED LETTER FIXED-FORM WA" nil     )
    (#x000fbb "TIBETAN SUBJOINED LETTER FIXED-FORM YA" nil     )
    (#x000fbc "TIBETAN SUBJOINED LETTER FIXED-FORM RA" nil     )
    (#x000fbe "TIBETAN KU RU KHA"                      nil     )
    (#x000fbf "TIBETAN KU RU KHA BZHI MIG CAN"         nil     )
    (#x000fc0 "TIBETAN CANTILLATION SIGN HEAVY BEAT"   nil     )
    (#x000fc1 "TIBETAN CANTILLATION SIGN LIGHT BEAT"   nil     )
    (#x000fc2 "TIBETAN CANTILLATION SIGN CANG TE-U"    nil     )
    (#x000fc3 "TIBETAN CANTILLATION SIGN SBUB -CHAL"   nil     )
    (#x000fc4 "TIBETAN SYMBOL DRIL BU"                 nil     )
    (#x000fc5 "TIBETAN SYMBOL RDO RJE"                 nil     )
    (#x000fc6 "TIBETAN SYMBOL PADMA GDAN"              nil     )
    (#x000fc7 "TIBETAN SYMBOL RDO RJE RGYA GRAM"       nil     )
    (#x000fc8 "TIBETAN SYMBOL PHUR PA"                 nil     )
    (#x000fc9 "TIBETAN SYMBOL NOR BU"                  nil     )
    (#x000fca "TIBETAN SYMBOL NOR BU NYIS -KHYIL"      nil     )
    (#x000fcb "TIBETAN SYMBOL NOR BU GSUM -KHYIL"      nil     )
    (#x000fcc "TIBETAN SYMBOL NOR BU BZHI -KHYIL"      nil     )
    (#x000fce "TIBETAN SIGN RDEL NAG RDEL DKAR"        nil     )
    (#x000fcf "TIBETAN SIGN RDEL NAG GSUM"             nil     )
    (#x000fd0 "TIBETAN MARK BSKA- SHOG GI MGO RGYAN"   nil     )
    (#x000fd1 "TIBETAN MARK MNYAM YIG GI MGO RGYAN"    nil     )
    (#x000fd2 "TIBETAN MARK NYIS TSHEG"                nil     )
    (#x000fd3 "TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA" nil     )
    (#x000fd4 "TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA" nil     )
    (#x000fd5 "RIGHT-FACING SVASTI SIGN"               nil     )
    (#x000fd6 "LEFT-FACING SVASTI SIGN"                nil     )
    (#x000fd7 "RIGHT-FACING SVASTI SIGN WITH DOTS"     nil     )
    (#x000fd8 "LEFT-FACING SVASTI SIGN WITH DOTS"      nil     )
    (#x000fd9 "TIBETAN MARK LEADING MCHAN RTAGS"       nil     )
    (#x000fda "TIBETAN MARK TRAILING MCHAN RTAGS"      nil     )
    (#x001000 "MYANMAR LETTER KA"                      nil     )
    (#x001001 "MYANMAR LETTER KHA"                     nil     )
    (#x001002 "MYANMAR LETTER GA"                      nil     )
    (#x001003 "MYANMAR LETTER GHA"                     nil     )
    (#x001004 "MYANMAR LETTER NGA"                     nil     )
    (#x001005 "MYANMAR LETTER CA"                      nil     )
    (#x001006 "MYANMAR LETTER CHA"                     nil     )
    (#x001007 "MYANMAR LETTER JA"                      nil     )
    (#x001008 "MYANMAR LETTER JHA"                     nil     )
    (#x001009 "MYANMAR LETTER NYA"                     nil     )
    (#x00100a "MYANMAR LETTER NNYA"                    nil     )
    (#x00100b "MYANMAR LETTER TTA"                     nil     )
    (#x00100c "MYANMAR LETTER TTHA"                    nil     )
    (#x00100d "MYANMAR LETTER DDA"                     nil     )
    (#x00100e "MYANMAR LETTER DDHA"                    nil     )
    (#x00100f "MYANMAR LETTER NNA"                     nil     )
    (#x001010 "MYANMAR LETTER TA"                      nil     )
    (#x001011 "MYANMAR LETTER THA"                     nil     )
    (#x001012 "MYANMAR LETTER DA"                      nil     )
    (#x001013 "MYANMAR LETTER DHA"                     nil     )
    (#x001014 "MYANMAR LETTER NA"                      nil     )
    (#x001015 "MYANMAR LETTER PA"                      nil     )
    (#x001016 "MYANMAR LETTER PHA"                     nil     )
    (#x001017 "MYANMAR LETTER BA"                      nil     )
    (#x001018 "MYANMAR LETTER BHA"                     nil     )
    (#x001019 "MYANMAR LETTER MA"                      nil     )
    (#x00101a "MYANMAR LETTER YA"                      nil     )
    (#x00101b "MYANMAR LETTER RA"                      nil     )
    (#x00101c "MYANMAR LETTER LA"                      nil     )
    (#x00101d "MYANMAR LETTER WA"                      nil     )
    (#x00101e "MYANMAR LETTER SA"                      nil     )
    (#x00101f "MYANMAR LETTER HA"                      nil     )
    (#x001020 "MYANMAR LETTER LLA"                     nil     )
    (#x001021 "MYANMAR LETTER A"                       nil     )
    (#x001022 "MYANMAR LETTER SHAN A"                  nil     )
    (#x001023 "MYANMAR LETTER I"                       nil     )
    (#x001024 "MYANMAR LETTER II"                      nil     )
    (#x001025 "MYANMAR LETTER U"                       nil     )
    (#x001026 "MYANMAR LETTER UU"                      nil     )
    (#x001027 "MYANMAR LETTER E"                       nil     )
    (#x001028 "MYANMAR LETTER MON E"                   nil     )
    (#x001029 "MYANMAR LETTER O"                       nil     )
    (#x00102a "MYANMAR LETTER AU"                      nil     )
    (#x00102b "MYANMAR VOWEL SIGN TALL AA"             nil     )
    (#x00102c "MYANMAR VOWEL SIGN AA"                  nil     )
    (#x00102d "MYANMAR VOWEL SIGN I"                   nil     )
    (#x00102e "MYANMAR VOWEL SIGN II"                  nil     )
    (#x00102f "MYANMAR VOWEL SIGN U"                   nil     )
    (#x001030 "MYANMAR VOWEL SIGN UU"                  nil     )
    (#x001031 "MYANMAR VOWEL SIGN E"                   nil     )
    (#x001032 "MYANMAR VOWEL SIGN AI"                  nil     )
    (#x001033 "MYANMAR VOWEL SIGN MON II"              nil     )
    (#x001034 "MYANMAR VOWEL SIGN MON O"               nil     )
    (#x001035 "MYANMAR VOWEL SIGN E ABOVE"             nil     )
    (#x001036 "MYANMAR SIGN ANUSVARA"                  nil     )
    (#x001037 "MYANMAR SIGN DOT BELOW"                 nil     )
    (#x001038 "MYANMAR SIGN VISARGA"                   nil     )
    (#x001039 "MYANMAR SIGN VIRAMA"                    nil     )
    (#x00103a "MYANMAR SIGN ASAT"                      nil     )
    (#x00103b "MYANMAR CONSONANT SIGN MEDIAL YA"       nil     )
    (#x00103c "MYANMAR CONSONANT SIGN MEDIAL RA"       nil     )
    (#x00103d "MYANMAR CONSONANT SIGN MEDIAL WA"       nil     )
    (#x00103e "MYANMAR CONSONANT SIGN MEDIAL HA"       nil     )
    (#x00103f "MYANMAR LETTER GREAT SA"                nil     )
    (#x001040 "MYANMAR DIGIT ZERO"                     nil     )
    (#x001041 "MYANMAR DIGIT ONE"                      nil     )
    (#x001042 "MYANMAR DIGIT TWO"                      nil     )
    (#x001043 "MYANMAR DIGIT THREE"                    nil     )
    (#x001044 "MYANMAR DIGIT FOUR"                     nil     )
    (#x001045 "MYANMAR DIGIT FIVE"                     nil     )
    (#x001046 "MYANMAR DIGIT SIX"                      nil     )
    (#x001047 "MYANMAR DIGIT SEVEN"                    nil     )
    (#x001048 "MYANMAR DIGIT EIGHT"                    nil     )
    (#x001049 "MYANMAR DIGIT NINE"                     nil     )
    (#x00104a "MYANMAR SIGN LITTLE SECTION"            nil     )
    (#x00104b "MYANMAR SIGN SECTION"                   nil     )
    (#x00104c "MYANMAR SYMBOL LOCATIVE"                nil     )
    (#x00104d "MYANMAR SYMBOL COMPLETED"               nil     )
    (#x00104e "MYANMAR SYMBOL AFOREMENTIONED"          nil     )
    (#x00104f "MYANMAR SYMBOL GENITIVE"                nil     )
    (#x001050 "MYANMAR LETTER SHA"                     nil     )
    (#x001051 "MYANMAR LETTER SSA"                     nil     )
    (#x001052 "MYANMAR LETTER VOCALIC R"               nil     )
    (#x001053 "MYANMAR LETTER VOCALIC RR"              nil     )
    (#x001054 "MYANMAR LETTER VOCALIC L"               nil     )
    (#x001055 "MYANMAR LETTER VOCALIC LL"              nil     )
    (#x001056 "MYANMAR VOWEL SIGN VOCALIC R"           nil     )
    (#x001057 "MYANMAR VOWEL SIGN VOCALIC RR"          nil     )
    (#x001058 "MYANMAR VOWEL SIGN VOCALIC L"           nil     )
    (#x001059 "MYANMAR VOWEL SIGN VOCALIC LL"          nil     )
    (#x00105a "MYANMAR LETTER MON NGA"                 nil     )
    (#x00105b "MYANMAR LETTER MON JHA"                 nil     )
    (#x00105c "MYANMAR LETTER MON BBA"                 nil     )
    (#x00105d "MYANMAR LETTER MON BBE"                 nil     )
    (#x00105e "MYANMAR CONSONANT SIGN MON MEDIAL NA"   nil     )
    (#x00105f "MYANMAR CONSONANT SIGN MON MEDIAL MA"   nil     )
    (#x001060 "MYANMAR CONSONANT SIGN MON MEDIAL LA"   nil     )
    (#x001061 "MYANMAR LETTER SGAW KAREN SHA"          nil     )
    (#x001062 "MYANMAR VOWEL SIGN SGAW KAREN EU"       nil     )
    (#x001063 "MYANMAR TONE MARK SGAW KAREN HATHI"     nil     )
    (#x001064 "MYANMAR TONE MARK SGAW KAREN KE PHO"    nil     )
    (#x001065 "MYANMAR LETTER WESTERN PWO KAREN THA"   nil     )
    (#x001066 "MYANMAR LETTER WESTERN PWO KAREN PWA"   nil     )
    (#x001067 "MYANMAR VOWEL SIGN WESTERN PWO KAREN EU" nil     )
    (#x001068 "MYANMAR VOWEL SIGN WESTERN PWO KAREN UE" nil     )
    (#x001069 "MYANMAR SIGN WESTERN PWO KAREN TONE-1"  nil     )
    (#x00106a "MYANMAR SIGN WESTERN PWO KAREN TONE-2"  nil     )
    (#x00106b "MYANMAR SIGN WESTERN PWO KAREN TONE-3"  nil     )
    (#x00106c "MYANMAR SIGN WESTERN PWO KAREN TONE-4"  nil     )
    (#x00106d "MYANMAR SIGN WESTERN PWO KAREN TONE-5"  nil     )
    (#x00106e "MYANMAR LETTER EASTERN PWO KAREN NNA"   nil     )
    (#x00106f "MYANMAR LETTER EASTERN PWO KAREN YWA"   nil     )
    (#x001070 "MYANMAR LETTER EASTERN PWO KAREN GHWA"  nil     )
    (#x001071 "MYANMAR VOWEL SIGN GEBA KAREN I"        nil     )
    (#x001072 "MYANMAR VOWEL SIGN KAYAH OE"            nil     )
    (#x001073 "MYANMAR VOWEL SIGN KAYAH U"             nil     )
    (#x001074 "MYANMAR VOWEL SIGN KAYAH EE"            nil     )
    (#x001075 "MYANMAR LETTER SHAN KA"                 nil     )
    (#x001076 "MYANMAR LETTER SHAN KHA"                nil     )
    (#x001077 "MYANMAR LETTER SHAN GA"                 nil     )
    (#x001078 "MYANMAR LETTER SHAN CA"                 nil     )
    (#x001079 "MYANMAR LETTER SHAN ZA"                 nil     )
    (#x00107a "MYANMAR LETTER SHAN NYA"                nil     )
    (#x00107b "MYANMAR LETTER SHAN DA"                 nil     )
    (#x00107c "MYANMAR LETTER SHAN NA"                 nil     )
    (#x00107d "MYANMAR LETTER SHAN PHA"                nil     )
    (#x00107e "MYANMAR LETTER SHAN FA"                 nil     )
    (#x00107f "MYANMAR LETTER SHAN BA"                 nil     )
    (#x001080 "MYANMAR LETTER SHAN THA"                nil     )
    (#x001081 "MYANMAR LETTER SHAN HA"                 nil     )
    (#x001082 "MYANMAR CONSONANT SIGN SHAN MEDIAL WA"  nil     )
    (#x001083 "MYANMAR VOWEL SIGN SHAN AA"             nil     )
    (#x001084 "MYANMAR VOWEL SIGN SHAN E"              nil     )
    (#x001085 "MYANMAR VOWEL SIGN SHAN E ABOVE"        nil     )
    (#x001086 "MYANMAR VOWEL SIGN SHAN FINAL Y"        nil     )
    (#x001087 "MYANMAR SIGN SHAN TONE-2"               nil     )
    (#x001088 "MYANMAR SIGN SHAN TONE-3"               nil     )
    (#x001089 "MYANMAR SIGN SHAN TONE-5"               nil     )
    (#x00108a "MYANMAR SIGN SHAN TONE-6"               nil     )
    (#x00108b "MYANMAR SIGN SHAN COUNCIL TONE-2"       nil     )
    (#x00108c "MYANMAR SIGN SHAN COUNCIL TONE-3"       nil     )
    (#x00108d "MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE" nil     )
    (#x00108e "MYANMAR LETTER RUMAI PALAUNG FA"        nil     )
    (#x00108f "MYANMAR SIGN RUMAI PALAUNG TONE-5"      nil     )
    (#x001090 "MYANMAR SHAN DIGIT ZERO"                nil     )
    (#x001091 "MYANMAR SHAN DIGIT ONE"                 nil     )
    (#x001092 "MYANMAR SHAN DIGIT TWO"                 nil     )
    (#x001093 "MYANMAR SHAN DIGIT THREE"               nil     )
    (#x001094 "MYANMAR SHAN DIGIT FOUR"                nil     )
    (#x001095 "MYANMAR SHAN DIGIT FIVE"                nil     )
    (#x001096 "MYANMAR SHAN DIGIT SIX"                 nil     )
    (#x001097 "MYANMAR SHAN DIGIT SEVEN"               nil     )
    (#x001098 "MYANMAR SHAN DIGIT EIGHT"               nil     )
    (#x001099 "MYANMAR SHAN DIGIT NINE"                nil     )
    (#x00109a "MYANMAR SIGN KHAMTI TONE-1"             nil     )
    (#x00109b "MYANMAR SIGN KHAMTI TONE-3"             nil     )
    (#x00109c "MYANMAR VOWEL SIGN AITON A"             nil     )
    (#x00109d "MYANMAR VOWEL SIGN AITON AI"            nil     )
    (#x00109e "MYANMAR SYMBOL SHAN ONE"                nil     )
    (#x00109f "MYANMAR SYMBOL SHAN EXCLAMATION"        nil     )
    (#x0010a0 "GEORGIAN CAPITAL LETTER AN"             nil     )
    (#x0010a1 "GEORGIAN CAPITAL LETTER BAN"            nil     )
    (#x0010a2 "GEORGIAN CAPITAL LETTER GAN"            nil     )
    (#x0010a3 "GEORGIAN CAPITAL LETTER DON"            nil     )
    (#x0010a4 "GEORGIAN CAPITAL LETTER EN"             nil     )
    (#x0010a5 "GEORGIAN CAPITAL LETTER VIN"            nil     )
    (#x0010a6 "GEORGIAN CAPITAL LETTER ZEN"            nil     )
    (#x0010a7 "GEORGIAN CAPITAL LETTER TAN"            nil     )
    (#x0010a8 "GEORGIAN CAPITAL LETTER IN"             nil     )
    (#x0010a9 "GEORGIAN CAPITAL LETTER KAN"            nil     )
    (#x0010aa "GEORGIAN CAPITAL LETTER LAS"            nil     )
    (#x0010ab "GEORGIAN CAPITAL LETTER MAN"            nil     )
    (#x0010ac "GEORGIAN CAPITAL LETTER NAR"            nil     )
    (#x0010ad "GEORGIAN CAPITAL LETTER ON"             nil     )
    (#x0010ae "GEORGIAN CAPITAL LETTER PAR"            nil     )
    (#x0010af "GEORGIAN CAPITAL LETTER ZHAR"           nil     )
    (#x0010b0 "GEORGIAN CAPITAL LETTER RAE"            nil     )
    (#x0010b1 "GEORGIAN CAPITAL LETTER SAN"            nil     )
    (#x0010b2 "GEORGIAN CAPITAL LETTER TAR"            nil     )
    (#x0010b3 "GEORGIAN CAPITAL LETTER UN"             nil     )
    (#x0010b4 "GEORGIAN CAPITAL LETTER PHAR"           nil     )
    (#x0010b5 "GEORGIAN CAPITAL LETTER KHAR"           nil     )
    (#x0010b6 "GEORGIAN CAPITAL LETTER GHAN"           nil     )
    (#x0010b7 "GEORGIAN CAPITAL LETTER QAR"            nil     )
    (#x0010b8 "GEORGIAN CAPITAL LETTER SHIN"           nil     )
    (#x0010b9 "GEORGIAN CAPITAL LETTER CHIN"           nil     )
    (#x0010ba "GEORGIAN CAPITAL LETTER CAN"            nil     )
    (#x0010bb "GEORGIAN CAPITAL LETTER JIL"            nil     )
    (#x0010bc "GEORGIAN CAPITAL LETTER CIL"            nil     )
    (#x0010bd "GEORGIAN CAPITAL LETTER CHAR"           nil     )
    (#x0010be "GEORGIAN CAPITAL LETTER XAN"            nil     )
    (#x0010bf "GEORGIAN CAPITAL LETTER JHAN"           nil     )
    (#x0010c0 "GEORGIAN CAPITAL LETTER HAE"            nil     )
    (#x0010c1 "GEORGIAN CAPITAL LETTER HE"             nil     )
    (#x0010c2 "GEORGIAN CAPITAL LETTER HIE"            nil     )
    (#x0010c3 "GEORGIAN CAPITAL LETTER WE"             nil     )
    (#x0010c4 "GEORGIAN CAPITAL LETTER HAR"            nil     )
    (#x0010c5 "GEORGIAN CAPITAL LETTER HOE"            nil     )
    (#x0010c7 "GEORGIAN CAPITAL LETTER YN"             nil     )
    (#x0010cd "GEORGIAN CAPITAL LETTER AEN"            nil     )
    (#x0010d0 "GEORGIAN LETTER AN"                     nil     )
    (#x0010d1 "GEORGIAN LETTER BAN"                    nil     )
    (#x0010d2 "GEORGIAN LETTER GAN"                    nil     )
    (#x0010d3 "GEORGIAN LETTER DON"                    nil     )
    (#x0010d4 "GEORGIAN LETTER EN"                     nil     )
    (#x0010d5 "GEORGIAN LETTER VIN"                    nil     )
    (#x0010d6 "GEORGIAN LETTER ZEN"                    nil     )
    (#x0010d7 "GEORGIAN LETTER TAN"                    nil     )
    (#x0010d8 "GEORGIAN LETTER IN"                     nil     )
    (#x0010d9 "GEORGIAN LETTER KAN"                    nil     )
    (#x0010da "GEORGIAN LETTER LAS"                    nil     )
    (#x0010db "GEORGIAN LETTER MAN"                    nil     )
    (#x0010dc "GEORGIAN LETTER NAR"                    nil     )
    (#x0010dd "GEORGIAN LETTER ON"                     nil     )
    (#x0010de "GEORGIAN LETTER PAR"                    nil     )
    (#x0010df "GEORGIAN LETTER ZHAR"                   nil     )
    (#x0010e0 "GEORGIAN LETTER RAE"                    nil     )
    (#x0010e1 "GEORGIAN LETTER SAN"                    nil     )
    (#x0010e2 "GEORGIAN LETTER TAR"                    nil     )
    (#x0010e3 "GEORGIAN LETTER UN"                     nil     )
    (#x0010e4 "GEORGIAN LETTER PHAR"                   nil     )
    (#x0010e5 "GEORGIAN LETTER KHAR"                   nil     )
    (#x0010e6 "GEORGIAN LETTER GHAN"                   nil     )
    (#x0010e7 "GEORGIAN LETTER QAR"                    nil     )
    (#x0010e8 "GEORGIAN LETTER SHIN"                   nil     )
    (#x0010e9 "GEORGIAN LETTER CHIN"                   nil     )
    (#x0010ea "GEORGIAN LETTER CAN"                    nil     )
    (#x0010eb "GEORGIAN LETTER JIL"                    nil     )
    (#x0010ec "GEORGIAN LETTER CIL"                    nil     )
    (#x0010ed "GEORGIAN LETTER CHAR"                   nil     )
    (#x0010ee "GEORGIAN LETTER XAN"                    nil     )
    (#x0010ef "GEORGIAN LETTER JHAN"                   nil     )
    (#x0010f0 "GEORGIAN LETTER HAE"                    nil     )
    (#x0010f1 "GEORGIAN LETTER HE"                     nil     )
    (#x0010f2 "GEORGIAN LETTER HIE"                    nil     )
    (#x0010f3 "GEORGIAN LETTER WE"                     nil     )
    (#x0010f4 "GEORGIAN LETTER HAR"                    nil     )
    (#x0010f5 "GEORGIAN LETTER HOE"                    nil     )
    (#x0010f6 "GEORGIAN LETTER FI"                     nil     )
    (#x0010f7 "GEORGIAN LETTER YN"                     nil     )
    (#x0010f8 "GEORGIAN LETTER ELIFI"                  nil     )
    (#x0010f9 "GEORGIAN LETTER TURNED GAN"             nil     )
    (#x0010fa "GEORGIAN LETTER AIN"                    nil     )
    (#x0010fb "GEORGIAN PARAGRAPH SEPARATOR"           nil     )
    (#x0010fc "MODIFIER LETTER GEORGIAN NAR"           nil     )
    (#x0010fd "GEORGIAN LETTER AEN"                    nil     )
    (#x0010fe "GEORGIAN LETTER HARD SIGN"              nil     )
    (#x0010ff "GEORGIAN LETTER LABIAL SIGN"            nil     )
    (#x001100 "HANGUL CHOSEONG KIYEOK"                 nil     )
    (#x001101 "HANGUL CHOSEONG SSANGKIYEOK"            nil     )
    (#x001102 "HANGUL CHOSEONG NIEUN"                  nil     )
    (#x001103 "HANGUL CHOSEONG TIKEUT"                 nil     )
    (#x001104 "HANGUL CHOSEONG SSANGTIKEUT"            nil     )
    (#x001105 "HANGUL CHOSEONG RIEUL"                  nil     )
    (#x001106 "HANGUL CHOSEONG MIEUM"                  nil     )
    (#x001107 "HANGUL CHOSEONG PIEUP"                  nil     )
    (#x001108 "HANGUL CHOSEONG SSANGPIEUP"             nil     )
    (#x001109 "HANGUL CHOSEONG SIOS"                   nil     )
    (#x00110a "HANGUL CHOSEONG SSANGSIOS"              nil     )
    (#x00110b "HANGUL CHOSEONG IEUNG"                  nil     )
    (#x00110c "HANGUL CHOSEONG CIEUC"                  nil     )
    (#x00110d "HANGUL CHOSEONG SSANGCIEUC"             nil     )
    (#x00110e "HANGUL CHOSEONG CHIEUCH"                nil     )
    (#x00110f "HANGUL CHOSEONG KHIEUKH"                nil     )
    (#x001110 "HANGUL CHOSEONG THIEUTH"                nil     )
    (#x001111 "HANGUL CHOSEONG PHIEUPH"                nil     )
    (#x001112 "HANGUL CHOSEONG HIEUH"                  nil     )
    (#x001113 "HANGUL CHOSEONG NIEUN-KIYEOK"           nil     )
    (#x001114 "HANGUL CHOSEONG SSANGNIEUN"             nil     )
    (#x001115 "HANGUL CHOSEONG NIEUN-TIKEUT"           nil     )
    (#x001116 "HANGUL CHOSEONG NIEUN-PIEUP"            nil     )
    (#x001117 "HANGUL CHOSEONG TIKEUT-KIYEOK"          nil     )
    (#x001118 "HANGUL CHOSEONG RIEUL-NIEUN"            nil     )
    (#x001119 "HANGUL CHOSEONG SSANGRIEUL"             nil     )
    (#x00111a "HANGUL CHOSEONG RIEUL-HIEUH"            nil     )
    (#x00111b "HANGUL CHOSEONG KAPYEOUNRIEUL"          nil     )
    (#x00111c "HANGUL CHOSEONG MIEUM-PIEUP"            nil     )
    (#x00111d "HANGUL CHOSEONG KAPYEOUNMIEUM"          nil     )
    (#x00111e "HANGUL CHOSEONG PIEUP-KIYEOK"           nil     )
    (#x00111f "HANGUL CHOSEONG PIEUP-NIEUN"            nil     )
    (#x001120 "HANGUL CHOSEONG PIEUP-TIKEUT"           nil     )
    (#x001121 "HANGUL CHOSEONG PIEUP-SIOS"             nil     )
    (#x001122 "HANGUL CHOSEONG PIEUP-SIOS-KIYEOK"      nil     )
    (#x001123 "HANGUL CHOSEONG PIEUP-SIOS-TIKEUT"      nil     )
    (#x001124 "HANGUL CHOSEONG PIEUP-SIOS-PIEUP"       nil     )
    (#x001125 "HANGUL CHOSEONG PIEUP-SSANGSIOS"        nil     )
    (#x001126 "HANGUL CHOSEONG PIEUP-SIOS-CIEUC"       nil     )
    (#x001127 "HANGUL CHOSEONG PIEUP-CIEUC"            nil     )
    (#x001128 "HANGUL CHOSEONG PIEUP-CHIEUCH"          nil     )
    (#x001129 "HANGUL CHOSEONG PIEUP-THIEUTH"          nil     )
    (#x00112a "HANGUL CHOSEONG PIEUP-PHIEUPH"          nil     )
    (#x00112b "HANGUL CHOSEONG KAPYEOUNPIEUP"          nil     )
    (#x00112c "HANGUL CHOSEONG KAPYEOUNSSANGPIEUP"     nil     )
    (#x00112d "HANGUL CHOSEONG SIOS-KIYEOK"            nil     )
    (#x00112e "HANGUL CHOSEONG SIOS-NIEUN"             nil     )
    (#x00112f "HANGUL CHOSEONG SIOS-TIKEUT"            nil     )
    (#x001130 "HANGUL CHOSEONG SIOS-RIEUL"             nil     )
    (#x001131 "HANGUL CHOSEONG SIOS-MIEUM"             nil     )
    (#x001132 "HANGUL CHOSEONG SIOS-PIEUP"             nil     )
    (#x001133 "HANGUL CHOSEONG SIOS-PIEUP-KIYEOK"      nil     )
    (#x001134 "HANGUL CHOSEONG SIOS-SSANGSIOS"         nil     )
    (#x001135 "HANGUL CHOSEONG SIOS-IEUNG"             nil     )
    (#x001136 "HANGUL CHOSEONG SIOS-CIEUC"             nil     )
    (#x001137 "HANGUL CHOSEONG SIOS-CHIEUCH"           nil     )
    (#x001138 "HANGUL CHOSEONG SIOS-KHIEUKH"           nil     )
    (#x001139 "HANGUL CHOSEONG SIOS-THIEUTH"           nil     )
    (#x00113a "HANGUL CHOSEONG SIOS-PHIEUPH"           nil     )
    (#x00113b "HANGUL CHOSEONG SIOS-HIEUH"             nil     )
    (#x00113c "HANGUL CHOSEONG CHITUEUMSIOS"           nil     )
    (#x00113d "HANGUL CHOSEONG CHITUEUMSSANGSIOS"      nil     )
    (#x00113e "HANGUL CHOSEONG CEONGCHIEUMSIOS"        nil     )
    (#x00113f "HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS"   nil     )
    (#x001140 "HANGUL CHOSEONG PANSIOS"                nil     )
    (#x001141 "HANGUL CHOSEONG IEUNG-KIYEOK"           nil     )
    (#x001142 "HANGUL CHOSEONG IEUNG-TIKEUT"           nil     )
    (#x001143 "HANGUL CHOSEONG IEUNG-MIEUM"            nil     )
    (#x001144 "HANGUL CHOSEONG IEUNG-PIEUP"            nil     )
    (#x001145 "HANGUL CHOSEONG IEUNG-SIOS"             nil     )
    (#x001146 "HANGUL CHOSEONG IEUNG-PANSIOS"          nil     )
    (#x001147 "HANGUL CHOSEONG SSANGIEUNG"             nil     )
    (#x001148 "HANGUL CHOSEONG IEUNG-CIEUC"            nil     )
    (#x001149 "HANGUL CHOSEONG IEUNG-CHIEUCH"          nil     )
    (#x00114a "HANGUL CHOSEONG IEUNG-THIEUTH"          nil     )
    (#x00114b "HANGUL CHOSEONG IEUNG-PHIEUPH"          nil     )
    (#x00114c "HANGUL CHOSEONG YESIEUNG"               nil     )
    (#x00114d "HANGUL CHOSEONG CIEUC-IEUNG"            nil     )
    (#x00114e "HANGUL CHOSEONG CHITUEUMCIEUC"          nil     )
    (#x00114f "HANGUL CHOSEONG CHITUEUMSSANGCIEUC"     nil     )
    (#x001150 "HANGUL CHOSEONG CEONGCHIEUMCIEUC"       nil     )
    (#x001151 "HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC"  nil     )
    (#x001152 "HANGUL CHOSEONG CHIEUCH-KHIEUKH"        nil     )
    (#x001153 "HANGUL CHOSEONG CHIEUCH-HIEUH"          nil     )
    (#x001154 "HANGUL CHOSEONG CHITUEUMCHIEUCH"        nil     )
    (#x001155 "HANGUL CHOSEONG CEONGCHIEUMCHIEUCH"     nil     )
    (#x001156 "HANGUL CHOSEONG PHIEUPH-PIEUP"          nil     )
    (#x001157 "HANGUL CHOSEONG KAPYEOUNPHIEUPH"        nil     )
    (#x001158 "HANGUL CHOSEONG SSANGHIEUH"             nil     )
    (#x001159 "HANGUL CHOSEONG YEORINHIEUH"            nil     )
    (#x00115a "HANGUL CHOSEONG KIYEOK-TIKEUT"          nil     )
    (#x00115b "HANGUL CHOSEONG NIEUN-SIOS"             nil     )
    (#x00115c "HANGUL CHOSEONG NIEUN-CIEUC"            nil     )
    (#x00115d "HANGUL CHOSEONG NIEUN-HIEUH"            nil     )
    (#x00115e "HANGUL CHOSEONG TIKEUT-RIEUL"           nil     )
    (#x00115f "HANGUL CHOSEONG FILLER"                 nil     )
    (#x001160 "HANGUL JUNGSEONG FILLER"                nil     )
    (#x001161 "HANGUL JUNGSEONG A"                     nil     )
    (#x001162 "HANGUL JUNGSEONG AE"                    nil     )
    (#x001163 "HANGUL JUNGSEONG YA"                    nil     )
    (#x001164 "HANGUL JUNGSEONG YAE"                   nil     )
    (#x001165 "HANGUL JUNGSEONG EO"                    nil     )
    (#x001166 "HANGUL JUNGSEONG E"                     nil     )
    (#x001167 "HANGUL JUNGSEONG YEO"                   nil     )
    (#x001168 "HANGUL JUNGSEONG YE"                    nil     )
    (#x001169 "HANGUL JUNGSEONG O"                     nil     )
    (#x00116a "HANGUL JUNGSEONG WA"                    nil     )
    (#x00116b "HANGUL JUNGSEONG WAE"                   nil     )
    (#x00116c "HANGUL JUNGSEONG OE"                    nil     )
    (#x00116d "HANGUL JUNGSEONG YO"                    nil     )
    (#x00116e "HANGUL JUNGSEONG U"                     nil     )
    (#x00116f "HANGUL JUNGSEONG WEO"                   nil     )
    (#x001170 "HANGUL JUNGSEONG WE"                    nil     )
    (#x001171 "HANGUL JUNGSEONG WI"                    nil     )
    (#x001172 "HANGUL JUNGSEONG YU"                    nil     )
    (#x001173 "HANGUL JUNGSEONG EU"                    nil     )
    (#x001174 "HANGUL JUNGSEONG YI"                    nil     )
    (#x001175 "HANGUL JUNGSEONG I"                     nil     )
    (#x001176 "HANGUL JUNGSEONG A-O"                   nil     )
    (#x001177 "HANGUL JUNGSEONG A-U"                   nil     )
    (#x001178 "HANGUL JUNGSEONG YA-O"                  nil     )
    (#x001179 "HANGUL JUNGSEONG YA-YO"                 nil     )
    (#x00117a "HANGUL JUNGSEONG EO-O"                  nil     )
    (#x00117b "HANGUL JUNGSEONG EO-U"                  nil     )
    (#x00117c "HANGUL JUNGSEONG EO-EU"                 nil     )
    (#x00117d "HANGUL JUNGSEONG YEO-O"                 nil     )
    (#x00117e "HANGUL JUNGSEONG YEO-U"                 nil     )
    (#x00117f "HANGUL JUNGSEONG O-EO"                  nil     )
    (#x001180 "HANGUL JUNGSEONG O-E"                   nil     )
    (#x001181 "HANGUL JUNGSEONG O-YE"                  nil     )
    (#x001182 "HANGUL JUNGSEONG O-O"                   nil     )
    (#x001183 "HANGUL JUNGSEONG O-U"                   nil     )
    (#x001184 "HANGUL JUNGSEONG YO-YA"                 nil     )
    (#x001185 "HANGUL JUNGSEONG YO-YAE"                nil     )
    (#x001186 "HANGUL JUNGSEONG YO-YEO"                nil     )
    (#x001187 "HANGUL JUNGSEONG YO-O"                  nil     )
    (#x001188 "HANGUL JUNGSEONG YO-I"                  nil     )
    (#x001189 "HANGUL JUNGSEONG U-A"                   nil     )
    (#x00118a "HANGUL JUNGSEONG U-AE"                  nil     )
    (#x00118b "HANGUL JUNGSEONG U-EO-EU"               nil     )
    (#x00118c "HANGUL JUNGSEONG U-YE"                  nil     )
    (#x00118d "HANGUL JUNGSEONG U-U"                   nil     )
    (#x00118e "HANGUL JUNGSEONG YU-A"                  nil     )
    (#x00118f "HANGUL JUNGSEONG YU-EO"                 nil     )
    (#x001190 "HANGUL JUNGSEONG YU-E"                  nil     )
    (#x001191 "HANGUL JUNGSEONG YU-YEO"                nil     )
    (#x001192 "HANGUL JUNGSEONG YU-YE"                 nil     )
    (#x001193 "HANGUL JUNGSEONG YU-U"                  nil     )
    (#x001194 "HANGUL JUNGSEONG YU-I"                  nil     )
    (#x001195 "HANGUL JUNGSEONG EU-U"                  nil     )
    (#x001196 "HANGUL JUNGSEONG EU-EU"                 nil     )
    (#x001197 "HANGUL JUNGSEONG YI-U"                  nil     )
    (#x001198 "HANGUL JUNGSEONG I-A"                   nil     )
    (#x001199 "HANGUL JUNGSEONG I-YA"                  nil     )
    (#x00119a "HANGUL JUNGSEONG I-O"                   nil     )
    (#x00119b "HANGUL JUNGSEONG I-U"                   nil     )
    (#x00119c "HANGUL JUNGSEONG I-EU"                  nil     )
    (#x00119d "HANGUL JUNGSEONG I-ARAEA"               nil     )
    (#x00119e "HANGUL JUNGSEONG ARAEA"                 nil     )
    (#x00119f "HANGUL JUNGSEONG ARAEA-EO"              nil     )
    (#x0011a0 "HANGUL JUNGSEONG ARAEA-U"               nil     )
    (#x0011a1 "HANGUL JUNGSEONG ARAEA-I"               nil     )
    (#x0011a2 "HANGUL JUNGSEONG SSANGARAEA"            nil     )
    (#x0011a3 "HANGUL JUNGSEONG A-EU"                  nil     )
    (#x0011a4 "HANGUL JUNGSEONG YA-U"                  nil     )
    (#x0011a5 "HANGUL JUNGSEONG YEO-YA"                nil     )
    (#x0011a6 "HANGUL JUNGSEONG O-YA"                  nil     )
    (#x0011a7 "HANGUL JUNGSEONG O-YAE"                 nil     )
    (#x0011a8 "HANGUL JONGSEONG KIYEOK"                nil     )
    (#x0011a9 "HANGUL JONGSEONG SSANGKIYEOK"           nil     )
    (#x0011aa "HANGUL JONGSEONG KIYEOK-SIOS"           nil     )
    (#x0011ab "HANGUL JONGSEONG NIEUN"                 nil     )
    (#x0011ac "HANGUL JONGSEONG NIEUN-CIEUC"           nil     )
    (#x0011ad "HANGUL JONGSEONG NIEUN-HIEUH"           nil     )
    (#x0011ae "HANGUL JONGSEONG TIKEUT"                nil     )
    (#x0011af "HANGUL JONGSEONG RIEUL"                 nil     )
    (#x0011b0 "HANGUL JONGSEONG RIEUL-KIYEOK"          nil     )
    (#x0011b1 "HANGUL JONGSEONG RIEUL-MIEUM"           nil     )
    (#x0011b2 "HANGUL JONGSEONG RIEUL-PIEUP"           nil     )
    (#x0011b3 "HANGUL JONGSEONG RIEUL-SIOS"            nil     )
    (#x0011b4 "HANGUL JONGSEONG RIEUL-THIEUTH"         nil     )
    (#x0011b5 "HANGUL JONGSEONG RIEUL-PHIEUPH"         nil     )
    (#x0011b6 "HANGUL JONGSEONG RIEUL-HIEUH"           nil     )
    (#x0011b7 "HANGUL JONGSEONG MIEUM"                 nil     )
    (#x0011b8 "HANGUL JONGSEONG PIEUP"                 nil     )
    (#x0011b9 "HANGUL JONGSEONG PIEUP-SIOS"            nil     )
    (#x0011ba "HANGUL JONGSEONG SIOS"                  nil     )
    (#x0011bb "HANGUL JONGSEONG SSANGSIOS"             nil     )
    (#x0011bc "HANGUL JONGSEONG IEUNG"                 nil     )
    (#x0011bd "HANGUL JONGSEONG CIEUC"                 nil     )
    (#x0011be "HANGUL JONGSEONG CHIEUCH"               nil     )
    (#x0011bf "HANGUL JONGSEONG KHIEUKH"               nil     )
    (#x0011c0 "HANGUL JONGSEONG THIEUTH"               nil     )
    (#x0011c1 "HANGUL JONGSEONG PHIEUPH"               nil     )
    (#x0011c2 "HANGUL JONGSEONG HIEUH"                 nil     )
    (#x0011c3 "HANGUL JONGSEONG KIYEOK-RIEUL"          nil     )
    (#x0011c4 "HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK"    nil     )
    (#x0011c5 "HANGUL JONGSEONG NIEUN-KIYEOK"          nil     )
    (#x0011c6 "HANGUL JONGSEONG NIEUN-TIKEUT"          nil     )
    (#x0011c7 "HANGUL JONGSEONG NIEUN-SIOS"            nil     )
    (#x0011c8 "HANGUL JONGSEONG NIEUN-PANSIOS"         nil     )
    (#x0011c9 "HANGUL JONGSEONG NIEUN-THIEUTH"         nil     )
    (#x0011ca "HANGUL JONGSEONG TIKEUT-KIYEOK"         nil     )
    (#x0011cb "HANGUL JONGSEONG TIKEUT-RIEUL"          nil     )
    (#x0011cc "HANGUL JONGSEONG RIEUL-KIYEOK-SIOS"     nil     )
    (#x0011cd "HANGUL JONGSEONG RIEUL-NIEUN"           nil     )
    (#x0011ce "HANGUL JONGSEONG RIEUL-TIKEUT"          nil     )
    (#x0011cf "HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH"    nil     )
    (#x0011d0 "HANGUL JONGSEONG SSANGRIEUL"            nil     )
    (#x0011d1 "HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK"    nil     )
    (#x0011d2 "HANGUL JONGSEONG RIEUL-MIEUM-SIOS"      nil     )
    (#x0011d3 "HANGUL JONGSEONG RIEUL-PIEUP-SIOS"      nil     )
    (#x0011d4 "HANGUL JONGSEONG RIEUL-PIEUP-HIEUH"     nil     )
    (#x0011d5 "HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP"   nil     )
    (#x0011d6 "HANGUL JONGSEONG RIEUL-SSANGSIOS"       nil     )
    (#x0011d7 "HANGUL JONGSEONG RIEUL-PANSIOS"         nil     )
    (#x0011d8 "HANGUL JONGSEONG RIEUL-KHIEUKH"         nil     )
    (#x0011d9 "HANGUL JONGSEONG RIEUL-YEORINHIEUH"     nil     )
    (#x0011da "HANGUL JONGSEONG MIEUM-KIYEOK"          nil     )
    (#x0011db "HANGUL JONGSEONG MIEUM-RIEUL"           nil     )
    (#x0011dc "HANGUL JONGSEONG MIEUM-PIEUP"           nil     )
    (#x0011dd "HANGUL JONGSEONG MIEUM-SIOS"            nil     )
    (#x0011de "HANGUL JONGSEONG MIEUM-SSANGSIOS"       nil     )
    (#x0011df "HANGUL JONGSEONG MIEUM-PANSIOS"         nil     )
    (#x0011e0 "HANGUL JONGSEONG MIEUM-CHIEUCH"         nil     )
    (#x0011e1 "HANGUL JONGSEONG MIEUM-HIEUH"           nil     )
    (#x0011e2 "HANGUL JONGSEONG KAPYEOUNMIEUM"         nil     )
    (#x0011e3 "HANGUL JONGSEONG PIEUP-RIEUL"           nil     )
    (#x0011e4 "HANGUL JONGSEONG PIEUP-PHIEUPH"         nil     )
    (#x0011e5 "HANGUL JONGSEONG PIEUP-HIEUH"           nil     )
    (#x0011e6 "HANGUL JONGSEONG KAPYEOUNPIEUP"         nil     )
    (#x0011e7 "HANGUL JONGSEONG SIOS-KIYEOK"           nil     )
    (#x0011e8 "HANGUL JONGSEONG SIOS-TIKEUT"           nil     )
    (#x0011e9 "HANGUL JONGSEONG SIOS-RIEUL"            nil     )
    (#x0011ea "HANGUL JONGSEONG SIOS-PIEUP"            nil     )
    (#x0011eb "HANGUL JONGSEONG PANSIOS"               nil     )
    (#x0011ec "HANGUL JONGSEONG IEUNG-KIYEOK"          nil     )
    (#x0011ed "HANGUL JONGSEONG IEUNG-SSANGKIYEOK"     nil     )
    (#x0011ee "HANGUL JONGSEONG SSANGIEUNG"            nil     )
    (#x0011ef "HANGUL JONGSEONG IEUNG-KHIEUKH"         nil     )
    (#x0011f0 "HANGUL JONGSEONG YESIEUNG"              nil     )
    (#x0011f1 "HANGUL JONGSEONG YESIEUNG-SIOS"         nil     )
    (#x0011f2 "HANGUL JONGSEONG YESIEUNG-PANSIOS"      nil     )
    (#x0011f3 "HANGUL JONGSEONG PHIEUPH-PIEUP"         nil     )
    (#x0011f4 "HANGUL JONGSEONG KAPYEOUNPHIEUPH"       nil     )
    (#x0011f5 "HANGUL JONGSEONG HIEUH-NIEUN"           nil     )
    (#x0011f6 "HANGUL JONGSEONG HIEUH-RIEUL"           nil     )
    (#x0011f7 "HANGUL JONGSEONG HIEUH-MIEUM"           nil     )
    (#x0011f8 "HANGUL JONGSEONG HIEUH-PIEUP"           nil     )
    (#x0011f9 "HANGUL JONGSEONG YEORINHIEUH"           nil     )
    (#x0011fa "HANGUL JONGSEONG KIYEOK-NIEUN"          nil     )
    (#x0011fb "HANGUL JONGSEONG KIYEOK-PIEUP"          nil     )
    (#x0011fc "HANGUL JONGSEONG KIYEOK-CHIEUCH"        nil     )
    (#x0011fd "HANGUL JONGSEONG KIYEOK-KHIEUKH"        nil     )
    (#x0011fe "HANGUL JONGSEONG KIYEOK-HIEUH"          nil     )
    (#x0011ff "HANGUL JONGSEONG SSANGNIEUN"            nil     )
    (#x001200 "ETHIOPIC SYLLABLE HA"                   nil     )
    (#x001201 "ETHIOPIC SYLLABLE HU"                   nil     )
    (#x001202 "ETHIOPIC SYLLABLE HI"                   nil     )
    (#x001203 "ETHIOPIC SYLLABLE HAA"                  nil     )
    (#x001204 "ETHIOPIC SYLLABLE HEE"                  nil     )
    (#x001205 "ETHIOPIC SYLLABLE HE"                   nil     )
    (#x001206 "ETHIOPIC SYLLABLE HO"                   nil     )
    (#x001207 "ETHIOPIC SYLLABLE HOA"                  nil     )
    (#x001208 "ETHIOPIC SYLLABLE LA"                   nil     )
    (#x001209 "ETHIOPIC SYLLABLE LU"                   nil     )
    (#x00120a "ETHIOPIC SYLLABLE LI"                   nil     )
    (#x00120b "ETHIOPIC SYLLABLE LAA"                  nil     )
    (#x00120c "ETHIOPIC SYLLABLE LEE"                  nil     )
    (#x00120d "ETHIOPIC SYLLABLE LE"                   nil     )
    (#x00120e "ETHIOPIC SYLLABLE LO"                   nil     )
    (#x00120f "ETHIOPIC SYLLABLE LWA"                  nil     )
    (#x001210 "ETHIOPIC SYLLABLE HHA"                  nil     )
    (#x001211 "ETHIOPIC SYLLABLE HHU"                  nil     )
    (#x001212 "ETHIOPIC SYLLABLE HHI"                  nil     )
    (#x001213 "ETHIOPIC SYLLABLE HHAA"                 nil     )
    (#x001214 "ETHIOPIC SYLLABLE HHEE"                 nil     )
    (#x001215 "ETHIOPIC SYLLABLE HHE"                  nil     )
    (#x001216 "ETHIOPIC SYLLABLE HHO"                  nil     )
    (#x001217 "ETHIOPIC SYLLABLE HHWA"                 nil     )
    (#x001218 "ETHIOPIC SYLLABLE MA"                   nil     )
    (#x001219 "ETHIOPIC SYLLABLE MU"                   nil     )
    (#x00121a "ETHIOPIC SYLLABLE MI"                   nil     )
    (#x00121b "ETHIOPIC SYLLABLE MAA"                  nil     )
    (#x00121c "ETHIOPIC SYLLABLE MEE"                  nil     )
    (#x00121d "ETHIOPIC SYLLABLE ME"                   nil     )
    (#x00121e "ETHIOPIC SYLLABLE MO"                   nil     )
    (#x00121f "ETHIOPIC SYLLABLE MWA"                  nil     )
    (#x001220 "ETHIOPIC SYLLABLE SZA"                  nil     )
    (#x001221 "ETHIOPIC SYLLABLE SZU"                  nil     )
    (#x001222 "ETHIOPIC SYLLABLE SZI"                  nil     )
    (#x001223 "ETHIOPIC SYLLABLE SZAA"                 nil     )
    (#x001224 "ETHIOPIC SYLLABLE SZEE"                 nil     )
    (#x001225 "ETHIOPIC SYLLABLE SZE"                  nil     )
    (#x001226 "ETHIOPIC SYLLABLE SZO"                  nil     )
    (#x001227 "ETHIOPIC SYLLABLE SZWA"                 nil     )
    (#x001228 "ETHIOPIC SYLLABLE RA"                   nil     )
    (#x001229 "ETHIOPIC SYLLABLE RU"                   nil     )
    (#x00122a "ETHIOPIC SYLLABLE RI"                   nil     )
    (#x00122b "ETHIOPIC SYLLABLE RAA"                  nil     )
    (#x00122c "ETHIOPIC SYLLABLE REE"                  nil     )
    (#x00122d "ETHIOPIC SYLLABLE RE"                   nil     )
    (#x00122e "ETHIOPIC SYLLABLE RO"                   nil     )
    (#x00122f "ETHIOPIC SYLLABLE RWA"                  nil     )
    (#x001230 "ETHIOPIC SYLLABLE SA"                   nil     )
    (#x001231 "ETHIOPIC SYLLABLE SU"                   nil     )
    (#x001232 "ETHIOPIC SYLLABLE SI"                   nil     )
    (#x001233 "ETHIOPIC SYLLABLE SAA"                  nil     )
    (#x001234 "ETHIOPIC SYLLABLE SEE"                  nil     )
    (#x001235 "ETHIOPIC SYLLABLE SE"                   nil     )
    (#x001236 "ETHIOPIC SYLLABLE SO"                   nil     )
    (#x001237 "ETHIOPIC SYLLABLE SWA"                  nil     )
    (#x001238 "ETHIOPIC SYLLABLE SHA"                  nil     )
    (#x001239 "ETHIOPIC SYLLABLE SHU"                  nil     )
    (#x00123a "ETHIOPIC SYLLABLE SHI"                  nil     )
    (#x00123b "ETHIOPIC SYLLABLE SHAA"                 nil     )
    (#x00123c "ETHIOPIC SYLLABLE SHEE"                 nil     )
    (#x00123d "ETHIOPIC SYLLABLE SHE"                  nil     )
    (#x00123e "ETHIOPIC SYLLABLE SHO"                  nil     )
    (#x00123f "ETHIOPIC SYLLABLE SHWA"                 nil     )
    (#x001240 "ETHIOPIC SYLLABLE QA"                   nil     )
    (#x001241 "ETHIOPIC SYLLABLE QU"                   nil     )
    (#x001242 "ETHIOPIC SYLLABLE QI"                   nil     )
    (#x001243 "ETHIOPIC SYLLABLE QAA"                  nil     )
    (#x001244 "ETHIOPIC SYLLABLE QEE"                  nil     )
    (#x001245 "ETHIOPIC SYLLABLE QE"                   nil     )
    (#x001246 "ETHIOPIC SYLLABLE QO"                   nil     )
    (#x001247 "ETHIOPIC SYLLABLE QOA"                  nil     )
    (#x001248 "ETHIOPIC SYLLABLE QWA"                  nil     )
    (#x00124a "ETHIOPIC SYLLABLE QWI"                  nil     )
    (#x00124b "ETHIOPIC SYLLABLE QWAA"                 nil     )
    (#x00124c "ETHIOPIC SYLLABLE QWEE"                 nil     )
    (#x00124d "ETHIOPIC SYLLABLE QWE"                  nil     )
    (#x001250 "ETHIOPIC SYLLABLE QHA"                  nil     )
    (#x001251 "ETHIOPIC SYLLABLE QHU"                  nil     )
    (#x001252 "ETHIOPIC SYLLABLE QHI"                  nil     )
    (#x001253 "ETHIOPIC SYLLABLE QHAA"                 nil     )
    (#x001254 "ETHIOPIC SYLLABLE QHEE"                 nil     )
    (#x001255 "ETHIOPIC SYLLABLE QHE"                  nil     )
    (#x001256 "ETHIOPIC SYLLABLE QHO"                  nil     )
    (#x001258 "ETHIOPIC SYLLABLE QHWA"                 nil     )
    (#x00125a "ETHIOPIC SYLLABLE QHWI"                 nil     )
    (#x00125b "ETHIOPIC SYLLABLE QHWAA"                nil     )
    (#x00125c "ETHIOPIC SYLLABLE QHWEE"                nil     )
    (#x00125d "ETHIOPIC SYLLABLE QHWE"                 nil     )
    (#x001260 "ETHIOPIC SYLLABLE BA"                   nil     )
    (#x001261 "ETHIOPIC SYLLABLE BU"                   nil     )
    (#x001262 "ETHIOPIC SYLLABLE BI"                   nil     )
    (#x001263 "ETHIOPIC SYLLABLE BAA"                  nil     )
    (#x001264 "ETHIOPIC SYLLABLE BEE"                  nil     )
    (#x001265 "ETHIOPIC SYLLABLE BE"                   nil     )
    (#x001266 "ETHIOPIC SYLLABLE BO"                   nil     )
    (#x001267 "ETHIOPIC SYLLABLE BWA"                  nil     )
    (#x001268 "ETHIOPIC SYLLABLE VA"                   nil     )
    (#x001269 "ETHIOPIC SYLLABLE VU"                   nil     )
    (#x00126a "ETHIOPIC SYLLABLE VI"                   nil     )
    (#x00126b "ETHIOPIC SYLLABLE VAA"                  nil     )
    (#x00126c "ETHIOPIC SYLLABLE VEE"                  nil     )
    (#x00126d "ETHIOPIC SYLLABLE VE"                   nil     )
    (#x00126e "ETHIOPIC SYLLABLE VO"                   nil     )
    (#x00126f "ETHIOPIC SYLLABLE VWA"                  nil     )
    (#x001270 "ETHIOPIC SYLLABLE TA"                   nil     )
    (#x001271 "ETHIOPIC SYLLABLE TU"                   nil     )
    (#x001272 "ETHIOPIC SYLLABLE TI"                   nil     )
    (#x001273 "ETHIOPIC SYLLABLE TAA"                  nil     )
    (#x001274 "ETHIOPIC SYLLABLE TEE"                  nil     )
    (#x001275 "ETHIOPIC SYLLABLE TE"                   nil     )
    (#x001276 "ETHIOPIC SYLLABLE TO"                   nil     )
    (#x001277 "ETHIOPIC SYLLABLE TWA"                  nil     )
    (#x001278 "ETHIOPIC SYLLABLE CA"                   nil     )
    (#x001279 "ETHIOPIC SYLLABLE CU"                   nil     )
    (#x00127a "ETHIOPIC SYLLABLE CI"                   nil     )
    (#x00127b "ETHIOPIC SYLLABLE CAA"                  nil     )
    (#x00127c "ETHIOPIC SYLLABLE CEE"                  nil     )
    (#x00127d "ETHIOPIC SYLLABLE CE"                   nil     )
    (#x00127e "ETHIOPIC SYLLABLE CO"                   nil     )
    (#x00127f "ETHIOPIC SYLLABLE CWA"                  nil     )
    (#x001280 "ETHIOPIC SYLLABLE XA"                   nil     )
    (#x001281 "ETHIOPIC SYLLABLE XU"                   nil     )
    (#x001282 "ETHIOPIC SYLLABLE XI"                   nil     )
    (#x001283 "ETHIOPIC SYLLABLE XAA"                  nil     )
    (#x001284 "ETHIOPIC SYLLABLE XEE"                  nil     )
    (#x001285 "ETHIOPIC SYLLABLE XE"                   nil     )
    (#x001286 "ETHIOPIC SYLLABLE XO"                   nil     )
    (#x001287 "ETHIOPIC SYLLABLE XOA"                  nil     )
    (#x001288 "ETHIOPIC SYLLABLE XWA"                  nil     )
    (#x00128a "ETHIOPIC SYLLABLE XWI"                  nil     )
    (#x00128b "ETHIOPIC SYLLABLE XWAA"                 nil     )
    (#x00128c "ETHIOPIC SYLLABLE XWEE"                 nil     )
    (#x00128d "ETHIOPIC SYLLABLE XWE"                  nil     )
    (#x001290 "ETHIOPIC SYLLABLE NA"                   nil     )
    (#x001291 "ETHIOPIC SYLLABLE NU"                   nil     )
    (#x001292 "ETHIOPIC SYLLABLE NI"                   nil     )
    (#x001293 "ETHIOPIC SYLLABLE NAA"                  nil     )
    (#x001294 "ETHIOPIC SYLLABLE NEE"                  nil     )
    (#x001295 "ETHIOPIC SYLLABLE NE"                   nil     )
    (#x001296 "ETHIOPIC SYLLABLE NO"                   nil     )
    (#x001297 "ETHIOPIC SYLLABLE NWA"                  nil     )
    (#x001298 "ETHIOPIC SYLLABLE NYA"                  nil     )
    (#x001299 "ETHIOPIC SYLLABLE NYU"                  nil     )
    (#x00129a "ETHIOPIC SYLLABLE NYI"                  nil     )
    (#x00129b "ETHIOPIC SYLLABLE NYAA"                 nil     )
    (#x00129c "ETHIOPIC SYLLABLE NYEE"                 nil     )
    (#x00129d "ETHIOPIC SYLLABLE NYE"                  nil     )
    (#x00129e "ETHIOPIC SYLLABLE NYO"                  nil     )
    (#x00129f "ETHIOPIC SYLLABLE NYWA"                 nil     )
    (#x0012a0 "ETHIOPIC SYLLABLE GLOTTAL A"            nil     )
    (#x0012a1 "ETHIOPIC SYLLABLE GLOTTAL U"            nil     )
    (#x0012a2 "ETHIOPIC SYLLABLE GLOTTAL I"            nil     )
    (#x0012a3 "ETHIOPIC SYLLABLE GLOTTAL AA"           nil     )
    (#x0012a4 "ETHIOPIC SYLLABLE GLOTTAL EE"           nil     )
    (#x0012a5 "ETHIOPIC SYLLABLE GLOTTAL E"            nil     )
    (#x0012a6 "ETHIOPIC SYLLABLE GLOTTAL O"            nil     )
    (#x0012a7 "ETHIOPIC SYLLABLE GLOTTAL WA"           nil     )
    (#x0012a8 "ETHIOPIC SYLLABLE KA"                   nil     )
    (#x0012a9 "ETHIOPIC SYLLABLE KU"                   nil     )
    (#x0012aa "ETHIOPIC SYLLABLE KI"                   nil     )
    (#x0012ab "ETHIOPIC SYLLABLE KAA"                  nil     )
    (#x0012ac "ETHIOPIC SYLLABLE KEE"                  nil     )
    (#x0012ad "ETHIOPIC SYLLABLE KE"                   nil     )
    (#x0012ae "ETHIOPIC SYLLABLE KO"                   nil     )
    (#x0012af "ETHIOPIC SYLLABLE KOA"                  nil     )
    (#x0012b0 "ETHIOPIC SYLLABLE KWA"                  nil     )
    (#x0012b2 "ETHIOPIC SYLLABLE KWI"                  nil     )
    (#x0012b3 "ETHIOPIC SYLLABLE KWAA"                 nil     )
    (#x0012b4 "ETHIOPIC SYLLABLE KWEE"                 nil     )
    (#x0012b5 "ETHIOPIC SYLLABLE KWE"                  nil     )
    (#x0012b8 "ETHIOPIC SYLLABLE KXA"                  nil     )
    (#x0012b9 "ETHIOPIC SYLLABLE KXU"                  nil     )
    (#x0012ba "ETHIOPIC SYLLABLE KXI"                  nil     )
    (#x0012bb "ETHIOPIC SYLLABLE KXAA"                 nil     )
    (#x0012bc "ETHIOPIC SYLLABLE KXEE"                 nil     )
    (#x0012bd "ETHIOPIC SYLLABLE KXE"                  nil     )
    (#x0012be "ETHIOPIC SYLLABLE KXO"                  nil     )
    (#x0012c0 "ETHIOPIC SYLLABLE KXWA"                 nil     )
    (#x0012c2 "ETHIOPIC SYLLABLE KXWI"                 nil     )
    (#x0012c3 "ETHIOPIC SYLLABLE KXWAA"                nil     )
    (#x0012c4 "ETHIOPIC SYLLABLE KXWEE"                nil     )
    (#x0012c5 "ETHIOPIC SYLLABLE KXWE"                 nil     )
    (#x0012c8 "ETHIOPIC SYLLABLE WA"                   nil     )
    (#x0012c9 "ETHIOPIC SYLLABLE WU"                   nil     )
    (#x0012ca "ETHIOPIC SYLLABLE WI"                   nil     )
    (#x0012cb "ETHIOPIC SYLLABLE WAA"                  nil     )
    (#x0012cc "ETHIOPIC SYLLABLE WEE"                  nil     )
    (#x0012cd "ETHIOPIC SYLLABLE WE"                   nil     )
    (#x0012ce "ETHIOPIC SYLLABLE WO"                   nil     )
    (#x0012cf "ETHIOPIC SYLLABLE WOA"                  nil     )
    (#x0012d0 "ETHIOPIC SYLLABLE PHARYNGEAL A"         nil     )
    (#x0012d1 "ETHIOPIC SYLLABLE PHARYNGEAL U"         nil     )
    (#x0012d2 "ETHIOPIC SYLLABLE PHARYNGEAL I"         nil     )
    (#x0012d3 "ETHIOPIC SYLLABLE PHARYNGEAL AA"        nil     )
    (#x0012d4 "ETHIOPIC SYLLABLE PHARYNGEAL EE"        nil     )
    (#x0012d5 "ETHIOPIC SYLLABLE PHARYNGEAL E"         nil     )
    (#x0012d6 "ETHIOPIC SYLLABLE PHARYNGEAL O"         nil     )
    (#x0012d8 "ETHIOPIC SYLLABLE ZA"                   nil     )
    (#x0012d9 "ETHIOPIC SYLLABLE ZU"                   nil     )
    (#x0012da "ETHIOPIC SYLLABLE ZI"                   nil     )
    (#x0012db "ETHIOPIC SYLLABLE ZAA"                  nil     )
    (#x0012dc "ETHIOPIC SYLLABLE ZEE"                  nil     )
    (#x0012dd "ETHIOPIC SYLLABLE ZE"                   nil     )
    (#x0012de "ETHIOPIC SYLLABLE ZO"                   nil     )
    (#x0012df "ETHIOPIC SYLLABLE ZWA"                  nil     )
    (#x0012e0 "ETHIOPIC SYLLABLE ZHA"                  nil     )
    (#x0012e1 "ETHIOPIC SYLLABLE ZHU"                  nil     )
    (#x0012e2 "ETHIOPIC SYLLABLE ZHI"                  nil     )
    (#x0012e3 "ETHIOPIC SYLLABLE ZHAA"                 nil     )
    (#x0012e4 "ETHIOPIC SYLLABLE ZHEE"                 nil     )
    (#x0012e5 "ETHIOPIC SYLLABLE ZHE"                  nil     )
    (#x0012e6 "ETHIOPIC SYLLABLE ZHO"                  nil     )
    (#x0012e7 "ETHIOPIC SYLLABLE ZHWA"                 nil     )
    (#x0012e8 "ETHIOPIC SYLLABLE YA"                   nil     )
    (#x0012e9 "ETHIOPIC SYLLABLE YU"                   nil     )
    (#x0012ea "ETHIOPIC SYLLABLE YI"                   nil     )
    (#x0012eb "ETHIOPIC SYLLABLE YAA"                  nil     )
    (#x0012ec "ETHIOPIC SYLLABLE YEE"                  nil     )
    (#x0012ed "ETHIOPIC SYLLABLE YE"                   nil     )
    (#x0012ee "ETHIOPIC SYLLABLE YO"                   nil     )
    (#x0012ef "ETHIOPIC SYLLABLE YOA"                  nil     )
    (#x0012f0 "ETHIOPIC SYLLABLE DA"                   nil     )
    (#x0012f1 "ETHIOPIC SYLLABLE DU"                   nil     )
    (#x0012f2 "ETHIOPIC SYLLABLE DI"                   nil     )
    (#x0012f3 "ETHIOPIC SYLLABLE DAA"                  nil     )
    (#x0012f4 "ETHIOPIC SYLLABLE DEE"                  nil     )
    (#x0012f5 "ETHIOPIC SYLLABLE DE"                   nil     )
    (#x0012f6 "ETHIOPIC SYLLABLE DO"                   nil     )
    (#x0012f7 "ETHIOPIC SYLLABLE DWA"                  nil     )
    (#x0012f8 "ETHIOPIC SYLLABLE DDA"                  nil     )
    (#x0012f9 "ETHIOPIC SYLLABLE DDU"                  nil     )
    (#x0012fa "ETHIOPIC SYLLABLE DDI"                  nil     )
    (#x0012fb "ETHIOPIC SYLLABLE DDAA"                 nil     )
    (#x0012fc "ETHIOPIC SYLLABLE DDEE"                 nil     )
    (#x0012fd "ETHIOPIC SYLLABLE DDE"                  nil     )
    (#x0012fe "ETHIOPIC SYLLABLE DDO"                  nil     )
    (#x0012ff "ETHIOPIC SYLLABLE DDWA"                 nil     )
    (#x001300 "ETHIOPIC SYLLABLE JA"                   nil     )
    (#x001301 "ETHIOPIC SYLLABLE JU"                   nil     )
    (#x001302 "ETHIOPIC SYLLABLE JI"                   nil     )
    (#x001303 "ETHIOPIC SYLLABLE JAA"                  nil     )
    (#x001304 "ETHIOPIC SYLLABLE JEE"                  nil     )
    (#x001305 "ETHIOPIC SYLLABLE JE"                   nil     )
    (#x001306 "ETHIOPIC SYLLABLE JO"                   nil     )
    (#x001307 "ETHIOPIC SYLLABLE JWA"                  nil     )
    (#x001308 "ETHIOPIC SYLLABLE GA"                   nil     )
    (#x001309 "ETHIOPIC SYLLABLE GU"                   nil     )
    (#x00130a "ETHIOPIC SYLLABLE GI"                   nil     )
    (#x00130b "ETHIOPIC SYLLABLE GAA"                  nil     )
    (#x00130c "ETHIOPIC SYLLABLE GEE"                  nil     )
    (#x00130d "ETHIOPIC SYLLABLE GE"                   nil     )
    (#x00130e "ETHIOPIC SYLLABLE GO"                   nil     )
    (#x00130f "ETHIOPIC SYLLABLE GOA"                  nil     )
    (#x001310 "ETHIOPIC SYLLABLE GWA"                  nil     )
    (#x001312 "ETHIOPIC SYLLABLE GWI"                  nil     )
    (#x001313 "ETHIOPIC SYLLABLE GWAA"                 nil     )
    (#x001314 "ETHIOPIC SYLLABLE GWEE"                 nil     )
    (#x001315 "ETHIOPIC SYLLABLE GWE"                  nil     )
    (#x001318 "ETHIOPIC SYLLABLE GGA"                  nil     )
    (#x001319 "ETHIOPIC SYLLABLE GGU"                  nil     )
    (#x00131a "ETHIOPIC SYLLABLE GGI"                  nil     )
    (#x00131b "ETHIOPIC SYLLABLE GGAA"                 nil     )
    (#x00131c "ETHIOPIC SYLLABLE GGEE"                 nil     )
    (#x00131d "ETHIOPIC SYLLABLE GGE"                  nil     )
    (#x00131e "ETHIOPIC SYLLABLE GGO"                  nil     )
    (#x00131f "ETHIOPIC SYLLABLE GGWAA"                nil     )
    (#x001320 "ETHIOPIC SYLLABLE THA"                  nil     )
    (#x001321 "ETHIOPIC SYLLABLE THU"                  nil     )
    (#x001322 "ETHIOPIC SYLLABLE THI"                  nil     )
    (#x001323 "ETHIOPIC SYLLABLE THAA"                 nil     )
    (#x001324 "ETHIOPIC SYLLABLE THEE"                 nil     )
    (#x001325 "ETHIOPIC SYLLABLE THE"                  nil     )
    (#x001326 "ETHIOPIC SYLLABLE THO"                  nil     )
    (#x001327 "ETHIOPIC SYLLABLE THWA"                 nil     )
    (#x001328 "ETHIOPIC SYLLABLE CHA"                  nil     )
    (#x001329 "ETHIOPIC SYLLABLE CHU"                  nil     )
    (#x00132a "ETHIOPIC SYLLABLE CHI"                  nil     )
    (#x00132b "ETHIOPIC SYLLABLE CHAA"                 nil     )
    (#x00132c "ETHIOPIC SYLLABLE CHEE"                 nil     )
    (#x00132d "ETHIOPIC SYLLABLE CHE"                  nil     )
    (#x00132e "ETHIOPIC SYLLABLE CHO"                  nil     )
    (#x00132f "ETHIOPIC SYLLABLE CHWA"                 nil     )
    (#x001330 "ETHIOPIC SYLLABLE PHA"                  nil     )
    (#x001331 "ETHIOPIC SYLLABLE PHU"                  nil     )
    (#x001332 "ETHIOPIC SYLLABLE PHI"                  nil     )
    (#x001333 "ETHIOPIC SYLLABLE PHAA"                 nil     )
    (#x001334 "ETHIOPIC SYLLABLE PHEE"                 nil     )
    (#x001335 "ETHIOPIC SYLLABLE PHE"                  nil     )
    (#x001336 "ETHIOPIC SYLLABLE PHO"                  nil     )
    (#x001337 "ETHIOPIC SYLLABLE PHWA"                 nil     )
    (#x001338 "ETHIOPIC SYLLABLE TSA"                  nil     )
    (#x001339 "ETHIOPIC SYLLABLE TSU"                  nil     )
    (#x00133a "ETHIOPIC SYLLABLE TSI"                  nil     )
    (#x00133b "ETHIOPIC SYLLABLE TSAA"                 nil     )
    (#x00133c "ETHIOPIC SYLLABLE TSEE"                 nil     )
    (#x00133d "ETHIOPIC SYLLABLE TSE"                  nil     )
    (#x00133e "ETHIOPIC SYLLABLE TSO"                  nil     )
    (#x00133f "ETHIOPIC SYLLABLE TSWA"                 nil     )
    (#x001340 "ETHIOPIC SYLLABLE TZA"                  nil     )
    (#x001341 "ETHIOPIC SYLLABLE TZU"                  nil     )
    (#x001342 "ETHIOPIC SYLLABLE TZI"                  nil     )
    (#x001343 "ETHIOPIC SYLLABLE TZAA"                 nil     )
    (#x001344 "ETHIOPIC SYLLABLE TZEE"                 nil     )
    (#x001345 "ETHIOPIC SYLLABLE TZE"                  nil     )
    (#x001346 "ETHIOPIC SYLLABLE TZO"                  nil     )
    (#x001347 "ETHIOPIC SYLLABLE TZOA"                 nil     )
    (#x001348 "ETHIOPIC SYLLABLE FA"                   nil     )
    (#x001349 "ETHIOPIC SYLLABLE FU"                   nil     )
    (#x00134a "ETHIOPIC SYLLABLE FI"                   nil     )
    (#x00134b "ETHIOPIC SYLLABLE FAA"                  nil     )
    (#x00134c "ETHIOPIC SYLLABLE FEE"                  nil     )
    (#x00134d "ETHIOPIC SYLLABLE FE"                   nil     )
    (#x00134e "ETHIOPIC SYLLABLE FO"                   nil     )
    (#x00134f "ETHIOPIC SYLLABLE FWA"                  nil     )
    (#x001350 "ETHIOPIC SYLLABLE PA"                   nil     )
    (#x001351 "ETHIOPIC SYLLABLE PU"                   nil     )
    (#x001352 "ETHIOPIC SYLLABLE PI"                   nil     )
    (#x001353 "ETHIOPIC SYLLABLE PAA"                  nil     )
    (#x001354 "ETHIOPIC SYLLABLE PEE"                  nil     )
    (#x001355 "ETHIOPIC SYLLABLE PE"                   nil     )
    (#x001356 "ETHIOPIC SYLLABLE PO"                   nil     )
    (#x001357 "ETHIOPIC SYLLABLE PWA"                  nil     )
    (#x001358 "ETHIOPIC SYLLABLE RYA"                  nil     )
    (#x001359 "ETHIOPIC SYLLABLE MYA"                  nil     )
    (#x00135a "ETHIOPIC SYLLABLE FYA"                  nil     )
    (#x00135d "ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK" nil     )
    (#x00135e "ETHIOPIC COMBINING VOWEL LENGTH MARK"   nil     )
    (#x00135f "ETHIOPIC COMBINING GEMINATION MARK"     nil     )
    (#x001360 "ETHIOPIC SECTION MARK"                  nil     )
    (#x001361 "ETHIOPIC WORDSPACE"                     nil     )
    (#x001362 "ETHIOPIC FULL STOP"                     nil     )
    (#x001363 "ETHIOPIC COMMA"                         nil     )
    (#x001364 "ETHIOPIC SEMICOLON"                     nil     )
    (#x001365 "ETHIOPIC COLON"                         nil     )
    (#x001366 "ETHIOPIC PREFACE COLON"                 nil     )
    (#x001367 "ETHIOPIC QUESTION MARK"                 nil     )
    (#x001368 "ETHIOPIC PARAGRAPH SEPARATOR"           nil     )
    (#x001369 "ETHIOPIC DIGIT ONE"                     nil     )
    (#x00136a "ETHIOPIC DIGIT TWO"                     nil     )
    (#x00136b "ETHIOPIC DIGIT THREE"                   nil     )
    (#x00136c "ETHIOPIC DIGIT FOUR"                    nil     )
    (#x00136d "ETHIOPIC DIGIT FIVE"                    nil     )
    (#x00136e "ETHIOPIC DIGIT SIX"                     nil     )
    (#x00136f "ETHIOPIC DIGIT SEVEN"                   nil     )
    (#x001370 "ETHIOPIC DIGIT EIGHT"                   nil     )
    (#x001371 "ETHIOPIC DIGIT NINE"                    nil     )
    (#x001372 "ETHIOPIC NUMBER TEN"                    nil     )
    (#x001373 "ETHIOPIC NUMBER TWENTY"                 nil     )
    (#x001374 "ETHIOPIC NUMBER THIRTY"                 nil     )
    (#x001375 "ETHIOPIC NUMBER FORTY"                  nil     )
    (#x001376 "ETHIOPIC NUMBER FIFTY"                  nil     )
    (#x001377 "ETHIOPIC NUMBER SIXTY"                  nil     )
    (#x001378 "ETHIOPIC NUMBER SEVENTY"                nil     )
    (#x001379 "ETHIOPIC NUMBER EIGHTY"                 nil     )
    (#x00137a "ETHIOPIC NUMBER NINETY"                 nil     )
    (#x00137b "ETHIOPIC NUMBER HUNDRED"                nil     )
    (#x00137c "ETHIOPIC NUMBER TEN THOUSAND"           nil     )
    (#x001380 "ETHIOPIC SYLLABLE SEBATBEIT MWA"        nil     )
    (#x001381 "ETHIOPIC SYLLABLE MWI"                  nil     )
    (#x001382 "ETHIOPIC SYLLABLE MWEE"                 nil     )
    (#x001383 "ETHIOPIC SYLLABLE MWE"                  nil     )
    (#x001384 "ETHIOPIC SYLLABLE SEBATBEIT BWA"        nil     )
    (#x001385 "ETHIOPIC SYLLABLE BWI"                  nil     )
    (#x001386 "ETHIOPIC SYLLABLE BWEE"                 nil     )
    (#x001387 "ETHIOPIC SYLLABLE BWE"                  nil     )
    (#x001388 "ETHIOPIC SYLLABLE SEBATBEIT FWA"        nil     )
    (#x001389 "ETHIOPIC SYLLABLE FWI"                  nil     )
    (#x00138a "ETHIOPIC SYLLABLE FWEE"                 nil     )
    (#x00138b "ETHIOPIC SYLLABLE FWE"                  nil     )
    (#x00138c "ETHIOPIC SYLLABLE SEBATBEIT PWA"        nil     )
    (#x00138d "ETHIOPIC SYLLABLE PWI"                  nil     )
    (#x00138e "ETHIOPIC SYLLABLE PWEE"                 nil     )
    (#x00138f "ETHIOPIC SYLLABLE PWE"                  nil     )
    (#x001390 "ETHIOPIC TONAL MARK YIZET"              nil     )
    (#x001391 "ETHIOPIC TONAL MARK DERET"              nil     )
    (#x001392 "ETHIOPIC TONAL MARK RIKRIK"             nil     )
    (#x001393 "ETHIOPIC TONAL MARK SHORT RIKRIK"       nil     )
    (#x001394 "ETHIOPIC TONAL MARK DIFAT"              nil     )
    (#x001395 "ETHIOPIC TONAL MARK KENAT"              nil     )
    (#x001396 "ETHIOPIC TONAL MARK CHIRET"             nil     )
    (#x001397 "ETHIOPIC TONAL MARK HIDET"              nil     )
    (#x001398 "ETHIOPIC TONAL MARK DERET-HIDET"        nil     )
    (#x001399 "ETHIOPIC TONAL MARK KURT"               nil     )
    (#x0013a0 "CHEROKEE LETTER A"                      nil     )
    (#x0013a1 "CHEROKEE LETTER E"                      nil     )
    (#x0013a2 "CHEROKEE LETTER I"                      nil     )
    (#x0013a3 "CHEROKEE LETTER O"                      nil     )
    (#x0013a4 "CHEROKEE LETTER U"                      nil     )
    (#x0013a5 "CHEROKEE LETTER V"                      nil     )
    (#x0013a6 "CHEROKEE LETTER GA"                     nil     )
    (#x0013a7 "CHEROKEE LETTER KA"                     nil     )
    (#x0013a8 "CHEROKEE LETTER GE"                     nil     )
    (#x0013a9 "CHEROKEE LETTER GI"                     nil     )
    (#x0013aa "CHEROKEE LETTER GO"                     nil     )
    (#x0013ab "CHEROKEE LETTER GU"                     nil     )
    (#x0013ac "CHEROKEE LETTER GV"                     nil     )
    (#x0013ad "CHEROKEE LETTER HA"                     nil     )
    (#x0013ae "CHEROKEE LETTER HE"                     nil     )
    (#x0013af "CHEROKEE LETTER HI"                     nil     )
    (#x0013b0 "CHEROKEE LETTER HO"                     nil     )
    (#x0013b1 "CHEROKEE LETTER HU"                     nil     )
    (#x0013b2 "CHEROKEE LETTER HV"                     nil     )
    (#x0013b3 "CHEROKEE LETTER LA"                     nil     )
    (#x0013b4 "CHEROKEE LETTER LE"                     nil     )
    (#x0013b5 "CHEROKEE LETTER LI"                     nil     )
    (#x0013b6 "CHEROKEE LETTER LO"                     nil     )
    (#x0013b7 "CHEROKEE LETTER LU"                     nil     )
    (#x0013b8 "CHEROKEE LETTER LV"                     nil     )
    (#x0013b9 "CHEROKEE LETTER MA"                     nil     )
    (#x0013ba "CHEROKEE LETTER ME"                     nil     )
    (#x0013bb "CHEROKEE LETTER MI"                     nil     )
    (#x0013bc "CHEROKEE LETTER MO"                     nil     )
    (#x0013bd "CHEROKEE LETTER MU"                     nil     )
    (#x0013be "CHEROKEE LETTER NA"                     nil     )
    (#x0013bf "CHEROKEE LETTER HNA"                    nil     )
    (#x0013c0 "CHEROKEE LETTER NAH"                    nil     )
    (#x0013c1 "CHEROKEE LETTER NE"                     nil     )
    (#x0013c2 "CHEROKEE LETTER NI"                     nil     )
    (#x0013c3 "CHEROKEE LETTER NO"                     nil     )
    (#x0013c4 "CHEROKEE LETTER NU"                     nil     )
    (#x0013c5 "CHEROKEE LETTER NV"                     nil     )
    (#x0013c6 "CHEROKEE LETTER QUA"                    nil     )
    (#x0013c7 "CHEROKEE LETTER QUE"                    nil     )
    (#x0013c8 "CHEROKEE LETTER QUI"                    nil     )
    (#x0013c9 "CHEROKEE LETTER QUO"                    nil     )
    (#x0013ca "CHEROKEE LETTER QUU"                    nil     )
    (#x0013cb "CHEROKEE LETTER QUV"                    nil     )
    (#x0013cc "CHEROKEE LETTER SA"                     nil     )
    (#x0013cd "CHEROKEE LETTER S"                      nil     )
    (#x0013ce "CHEROKEE LETTER SE"                     nil     )
    (#x0013cf "CHEROKEE LETTER SI"                     nil     )
    (#x0013d0 "CHEROKEE LETTER SO"                     nil     )
    (#x0013d1 "CHEROKEE LETTER SU"                     nil     )
    (#x0013d2 "CHEROKEE LETTER SV"                     nil     )
    (#x0013d3 "CHEROKEE LETTER DA"                     nil     )
    (#x0013d4 "CHEROKEE LETTER TA"                     nil     )
    (#x0013d5 "CHEROKEE LETTER DE"                     nil     )
    (#x0013d6 "CHEROKEE LETTER TE"                     nil     )
    (#x0013d7 "CHEROKEE LETTER DI"                     nil     )
    (#x0013d8 "CHEROKEE LETTER TI"                     nil     )
    (#x0013d9 "CHEROKEE LETTER DO"                     nil     )
    (#x0013da "CHEROKEE LETTER DU"                     nil     )
    (#x0013db "CHEROKEE LETTER DV"                     nil     )
    (#x0013dc "CHEROKEE LETTER DLA"                    nil     )
    (#x0013dd "CHEROKEE LETTER TLA"                    nil     )
    (#x0013de "CHEROKEE LETTER TLE"                    nil     )
    (#x0013df "CHEROKEE LETTER TLI"                    nil     )
    (#x0013e0 "CHEROKEE LETTER TLO"                    nil     )
    (#x0013e1 "CHEROKEE LETTER TLU"                    nil     )
    (#x0013e2 "CHEROKEE LETTER TLV"                    nil     )
    (#x0013e3 "CHEROKEE LETTER TSA"                    nil     )
    (#x0013e4 "CHEROKEE LETTER TSE"                    nil     )
    (#x0013e5 "CHEROKEE LETTER TSI"                    nil     )
    (#x0013e6 "CHEROKEE LETTER TSO"                    nil     )
    (#x0013e7 "CHEROKEE LETTER TSU"                    nil     )
    (#x0013e8 "CHEROKEE LETTER TSV"                    nil     )
    (#x0013e9 "CHEROKEE LETTER WA"                     nil     )
    (#x0013ea "CHEROKEE LETTER WE"                     nil     )
    (#x0013eb "CHEROKEE LETTER WI"                     nil     )
    (#x0013ec "CHEROKEE LETTER WO"                     nil     )
    (#x0013ed "CHEROKEE LETTER WU"                     nil     )
    (#x0013ee "CHEROKEE LETTER WV"                     nil     )
    (#x0013ef "CHEROKEE LETTER YA"                     nil     )
    (#x0013f0 "CHEROKEE LETTER YE"                     nil     )
    (#x0013f1 "CHEROKEE LETTER YI"                     nil     )
    (#x0013f2 "CHEROKEE LETTER YO"                     nil     )
    (#x0013f3 "CHEROKEE LETTER YU"                     nil     )
    (#x0013f4 "CHEROKEE LETTER YV"                     nil     )
    (#x0013f5 "CHEROKEE LETTER MV"                     nil     )
    (#x0013f8 "CHEROKEE SMALL LETTER YE"               nil     )
    (#x0013f9 "CHEROKEE SMALL LETTER YI"               nil     )
    (#x0013fa "CHEROKEE SMALL LETTER YO"               nil     )
    (#x0013fb "CHEROKEE SMALL LETTER YU"               nil     )
    (#x0013fc "CHEROKEE SMALL LETTER YV"               nil     )
    (#x0013fd "CHEROKEE SMALL LETTER MV"               nil     )
    (#x001400 "CANADIAN SYLLABICS HYPHEN"              nil     )
    (#x001401 "CANADIAN SYLLABICS E"                   nil     )
    (#x001402 "CANADIAN SYLLABICS AAI"                 nil     )
    (#x001403 "CANADIAN SYLLABICS I"                   nil     )
    (#x001404 "CANADIAN SYLLABICS II"                  nil     )
    (#x001405 "CANADIAN SYLLABICS O"                   nil     )
    (#x001406 "CANADIAN SYLLABICS OO"                  nil     )
    (#x001407 "CANADIAN SYLLABICS Y-CREE OO"           nil     )
    (#x001408 "CANADIAN SYLLABICS CARRIER EE"          nil     )
    (#x001409 "CANADIAN SYLLABICS CARRIER I"           nil     )
    (#x00140a "CANADIAN SYLLABICS A"                   nil     )
    (#x00140b "CANADIAN SYLLABICS AA"                  nil     )
    (#x00140c "CANADIAN SYLLABICS WE"                  nil     )
    (#x00140d "CANADIAN SYLLABICS WEST-CREE WE"        nil     )
    (#x00140e "CANADIAN SYLLABICS WI"                  nil     )
    (#x00140f "CANADIAN SYLLABICS WEST-CREE WI"        nil     )
    (#x001410 "CANADIAN SYLLABICS WII"                 nil     )
    (#x001411 "CANADIAN SYLLABICS WEST-CREE WII"       nil     )
    (#x001412 "CANADIAN SYLLABICS WO"                  nil     )
    (#x001413 "CANADIAN SYLLABICS WEST-CREE WO"        nil     )
    (#x001414 "CANADIAN SYLLABICS WOO"                 nil     )
    (#x001415 "CANADIAN SYLLABICS WEST-CREE WOO"       nil     )
    (#x001416 "CANADIAN SYLLABICS NASKAPI WOO"         nil     )
    (#x001417 "CANADIAN SYLLABICS WA"                  nil     )
    (#x001418 "CANADIAN SYLLABICS WEST-CREE WA"        nil     )
    (#x001419 "CANADIAN SYLLABICS WAA"                 nil     )
    (#x00141a "CANADIAN SYLLABICS WEST-CREE WAA"       nil     )
    (#x00141b "CANADIAN SYLLABICS NASKAPI WAA"         nil     )
    (#x00141c "CANADIAN SYLLABICS AI"                  nil     )
    (#x00141d "CANADIAN SYLLABICS Y-CREE W"            nil     )
    (#x00141e "CANADIAN SYLLABICS GLOTTAL STOP"        nil     )
    (#x00141f "CANADIAN SYLLABICS FINAL ACUTE"         nil     )
    (#x001420 "CANADIAN SYLLABICS FINAL GRAVE"         nil     )
    (#x001421 "CANADIAN SYLLABICS FINAL BOTTOM HALF RING" nil     )
    (#x001422 "CANADIAN SYLLABICS FINAL TOP HALF RING" nil     )
    (#x001423 "CANADIAN SYLLABICS FINAL RIGHT HALF RING" nil     )
    (#x001424 "CANADIAN SYLLABICS FINAL RING"          nil     )
    (#x001425 "CANADIAN SYLLABICS FINAL DOUBLE ACUTE"  nil     )
    (#x001426 "CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES" nil     )
    (#x001427 "CANADIAN SYLLABICS FINAL MIDDLE DOT"    nil     )
    (#x001428 "CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE" nil     )
    (#x001429 "CANADIAN SYLLABICS FINAL PLUS"          nil     )
    (#x00142a "CANADIAN SYLLABICS FINAL DOWN TACK"     nil     )
    (#x00142b "CANADIAN SYLLABICS EN"                  nil     )
    (#x00142c "CANADIAN SYLLABICS IN"                  nil     )
    (#x00142d "CANADIAN SYLLABICS ON"                  nil     )
    (#x00142e "CANADIAN SYLLABICS AN"                  nil     )
    (#x00142f "CANADIAN SYLLABICS PE"                  nil     )
    (#x001430 "CANADIAN SYLLABICS PAAI"                nil     )
    (#x001431 "CANADIAN SYLLABICS PI"                  nil     )
    (#x001432 "CANADIAN SYLLABICS PII"                 nil     )
    (#x001433 "CANADIAN SYLLABICS PO"                  nil     )
    (#x001434 "CANADIAN SYLLABICS POO"                 nil     )
    (#x001435 "CANADIAN SYLLABICS Y-CREE POO"          nil     )
    (#x001436 "CANADIAN SYLLABICS CARRIER HEE"         nil     )
    (#x001437 "CANADIAN SYLLABICS CARRIER HI"          nil     )
    (#x001438 "CANADIAN SYLLABICS PA"                  nil     )
    (#x001439 "CANADIAN SYLLABICS PAA"                 nil     )
    (#x00143a "CANADIAN SYLLABICS PWE"                 nil     )
    (#x00143b "CANADIAN SYLLABICS WEST-CREE PWE"       nil     )
    (#x00143c "CANADIAN SYLLABICS PWI"                 nil     )
    (#x00143d "CANADIAN SYLLABICS WEST-CREE PWI"       nil     )
    (#x00143e "CANADIAN SYLLABICS PWII"                nil     )
    (#x00143f "CANADIAN SYLLABICS WEST-CREE PWII"      nil     )
    (#x001440 "CANADIAN SYLLABICS PWO"                 nil     )
    (#x001441 "CANADIAN SYLLABICS WEST-CREE PWO"       nil     )
    (#x001442 "CANADIAN SYLLABICS PWOO"                nil     )
    (#x001443 "CANADIAN SYLLABICS WEST-CREE PWOO"      nil     )
    (#x001444 "CANADIAN SYLLABICS PWA"                 nil     )
    (#x001445 "CANADIAN SYLLABICS WEST-CREE PWA"       nil     )
    (#x001446 "CANADIAN SYLLABICS PWAA"                nil     )
    (#x001447 "CANADIAN SYLLABICS WEST-CREE PWAA"      nil     )
    (#x001448 "CANADIAN SYLLABICS Y-CREE PWAA"         nil     )
    (#x001449 "CANADIAN SYLLABICS P"                   nil     )
    (#x00144a "CANADIAN SYLLABICS WEST-CREE P"         nil     )
    (#x00144b "CANADIAN SYLLABICS CARRIER H"           nil     )
    (#x00144c "CANADIAN SYLLABICS TE"                  nil     )
    (#x00144d "CANADIAN SYLLABICS TAAI"                nil     )
    (#x00144e "CANADIAN SYLLABICS TI"                  nil     )
    (#x00144f "CANADIAN SYLLABICS TII"                 nil     )
    (#x001450 "CANADIAN SYLLABICS TO"                  nil     )
    (#x001451 "CANADIAN SYLLABICS TOO"                 nil     )
    (#x001452 "CANADIAN SYLLABICS Y-CREE TOO"          nil     )
    (#x001453 "CANADIAN SYLLABICS CARRIER DEE"         nil     )
    (#x001454 "CANADIAN SYLLABICS CARRIER DI"          nil     )
    (#x001455 "CANADIAN SYLLABICS TA"                  nil     )
    (#x001456 "CANADIAN SYLLABICS TAA"                 nil     )
    (#x001457 "CANADIAN SYLLABICS TWE"                 nil     )
    (#x001458 "CANADIAN SYLLABICS WEST-CREE TWE"       nil     )
    (#x001459 "CANADIAN SYLLABICS TWI"                 nil     )
    (#x00145a "CANADIAN SYLLABICS WEST-CREE TWI"       nil     )
    (#x00145b "CANADIAN SYLLABICS TWII"                nil     )
    (#x00145c "CANADIAN SYLLABICS WEST-CREE TWII"      nil     )
    (#x00145d "CANADIAN SYLLABICS TWO"                 nil     )
    (#x00145e "CANADIAN SYLLABICS WEST-CREE TWO"       nil     )
    (#x00145f "CANADIAN SYLLABICS TWOO"                nil     )
    (#x001460 "CANADIAN SYLLABICS WEST-CREE TWOO"      nil     )
    (#x001461 "CANADIAN SYLLABICS TWA"                 nil     )
    (#x001462 "CANADIAN SYLLABICS WEST-CREE TWA"       nil     )
    (#x001463 "CANADIAN SYLLABICS TWAA"                nil     )
    (#x001464 "CANADIAN SYLLABICS WEST-CREE TWAA"      nil     )
    (#x001465 "CANADIAN SYLLABICS NASKAPI TWAA"        nil     )
    (#x001466 "CANADIAN SYLLABICS T"                   nil     )
    (#x001467 "CANADIAN SYLLABICS TTE"                 nil     )
    (#x001468 "CANADIAN SYLLABICS TTI"                 nil     )
    (#x001469 "CANADIAN SYLLABICS TTO"                 nil     )
    (#x00146a "CANADIAN SYLLABICS TTA"                 nil     )
    (#x00146b "CANADIAN SYLLABICS KE"                  nil     )
    (#x00146c "CANADIAN SYLLABICS KAAI"                nil     )
    (#x00146d "CANADIAN SYLLABICS KI"                  nil     )
    (#x00146e "CANADIAN SYLLABICS KII"                 nil     )
    (#x00146f "CANADIAN SYLLABICS KO"                  nil     )
    (#x001470 "CANADIAN SYLLABICS KOO"                 nil     )
    (#x001471 "CANADIAN SYLLABICS Y-CREE KOO"          nil     )
    (#x001472 "CANADIAN SYLLABICS KA"                  nil     )
    (#x001473 "CANADIAN SYLLABICS KAA"                 nil     )
    (#x001474 "CANADIAN SYLLABICS KWE"                 nil     )
    (#x001475 "CANADIAN SYLLABICS WEST-CREE KWE"       nil     )
    (#x001476 "CANADIAN SYLLABICS KWI"                 nil     )
    (#x001477 "CANADIAN SYLLABICS WEST-CREE KWI"       nil     )
    (#x001478 "CANADIAN SYLLABICS KWII"                nil     )
    (#x001479 "CANADIAN SYLLABICS WEST-CREE KWII"      nil     )
    (#x00147a "CANADIAN SYLLABICS KWO"                 nil     )
    (#x00147b "CANADIAN SYLLABICS WEST-CREE KWO"       nil     )
    (#x00147c "CANADIAN SYLLABICS KWOO"                nil     )
    (#x00147d "CANADIAN SYLLABICS WEST-CREE KWOO"      nil     )
    (#x00147e "CANADIAN SYLLABICS KWA"                 nil     )
    (#x00147f "CANADIAN SYLLABICS WEST-CREE KWA"       nil     )
    (#x001480 "CANADIAN SYLLABICS KWAA"                nil     )
    (#x001481 "CANADIAN SYLLABICS WEST-CREE KWAA"      nil     )
    (#x001482 "CANADIAN SYLLABICS NASKAPI KWAA"        nil     )
    (#x001483 "CANADIAN SYLLABICS K"                   nil     )
    (#x001484 "CANADIAN SYLLABICS KW"                  nil     )
    (#x001485 "CANADIAN SYLLABICS SOUTH-SLAVEY KEH"    nil     )
    (#x001486 "CANADIAN SYLLABICS SOUTH-SLAVEY KIH"    nil     )
    (#x001487 "CANADIAN SYLLABICS SOUTH-SLAVEY KOH"    nil     )
    (#x001488 "CANADIAN SYLLABICS SOUTH-SLAVEY KAH"    nil     )
    (#x001489 "CANADIAN SYLLABICS CE"                  nil     )
    (#x00148a "CANADIAN SYLLABICS CAAI"                nil     )
    (#x00148b "CANADIAN SYLLABICS CI"                  nil     )
    (#x00148c "CANADIAN SYLLABICS CII"                 nil     )
    (#x00148d "CANADIAN SYLLABICS CO"                  nil     )
    (#x00148e "CANADIAN SYLLABICS COO"                 nil     )
    (#x00148f "CANADIAN SYLLABICS Y-CREE COO"          nil     )
    (#x001490 "CANADIAN SYLLABICS CA"                  nil     )
    (#x001491 "CANADIAN SYLLABICS CAA"                 nil     )
    (#x001492 "CANADIAN SYLLABICS CWE"                 nil     )
    (#x001493 "CANADIAN SYLLABICS WEST-CREE CWE"       nil     )
    (#x001494 "CANADIAN SYLLABICS CWI"                 nil     )
    (#x001495 "CANADIAN SYLLABICS WEST-CREE CWI"       nil     )
    (#x001496 "CANADIAN SYLLABICS CWII"                nil     )
    (#x001497 "CANADIAN SYLLABICS WEST-CREE CWII"      nil     )
    (#x001498 "CANADIAN SYLLABICS CWO"                 nil     )
    (#x001499 "CANADIAN SYLLABICS WEST-CREE CWO"       nil     )
    (#x00149a "CANADIAN SYLLABICS CWOO"                nil     )
    (#x00149b "CANADIAN SYLLABICS WEST-CREE CWOO"      nil     )
    (#x00149c "CANADIAN SYLLABICS CWA"                 nil     )
    (#x00149d "CANADIAN SYLLABICS WEST-CREE CWA"       nil     )
    (#x00149e "CANADIAN SYLLABICS CWAA"                nil     )
    (#x00149f "CANADIAN SYLLABICS WEST-CREE CWAA"      nil     )
    (#x0014a0 "CANADIAN SYLLABICS NASKAPI CWAA"        nil     )
    (#x0014a1 "CANADIAN SYLLABICS C"                   nil     )
    (#x0014a2 "CANADIAN SYLLABICS SAYISI TH"           nil     )
    (#x0014a3 "CANADIAN SYLLABICS ME"                  nil     )
    (#x0014a4 "CANADIAN SYLLABICS MAAI"                nil     )
    (#x0014a5 "CANADIAN SYLLABICS MI"                  nil     )
    (#x0014a6 "CANADIAN SYLLABICS MII"                 nil     )
    (#x0014a7 "CANADIAN SYLLABICS MO"                  nil     )
    (#x0014a8 "CANADIAN SYLLABICS MOO"                 nil     )
    (#x0014a9 "CANADIAN SYLLABICS Y-CREE MOO"          nil     )
    (#x0014aa "CANADIAN SYLLABICS MA"                  nil     )
    (#x0014ab "CANADIAN SYLLABICS MAA"                 nil     )
    (#x0014ac "CANADIAN SYLLABICS MWE"                 nil     )
    (#x0014ad "CANADIAN SYLLABICS WEST-CREE MWE"       nil     )
    (#x0014ae "CANADIAN SYLLABICS MWI"                 nil     )
    (#x0014af "CANADIAN SYLLABICS WEST-CREE MWI"       nil     )
    (#x0014b0 "CANADIAN SYLLABICS MWII"                nil     )
    (#x0014b1 "CANADIAN SYLLABICS WEST-CREE MWII"      nil     )
    (#x0014b2 "CANADIAN SYLLABICS MWO"                 nil     )
    (#x0014b3 "CANADIAN SYLLABICS WEST-CREE MWO"       nil     )
    (#x0014b4 "CANADIAN SYLLABICS MWOO"                nil     )
    (#x0014b5 "CANADIAN SYLLABICS WEST-CREE MWOO"      nil     )
    (#x0014b6 "CANADIAN SYLLABICS MWA"                 nil     )
    (#x0014b7 "CANADIAN SYLLABICS WEST-CREE MWA"       nil     )
    (#x0014b8 "CANADIAN SYLLABICS MWAA"                nil     )
    (#x0014b9 "CANADIAN SYLLABICS WEST-CREE MWAA"      nil     )
    (#x0014ba "CANADIAN SYLLABICS NASKAPI MWAA"        nil     )
    (#x0014bb "CANADIAN SYLLABICS M"                   nil     )
    (#x0014bc "CANADIAN SYLLABICS WEST-CREE M"         nil     )
    (#x0014bd "CANADIAN SYLLABICS MH"                  nil     )
    (#x0014be "CANADIAN SYLLABICS ATHAPASCAN M"        nil     )
    (#x0014bf "CANADIAN SYLLABICS SAYISI M"            nil     )
    (#x0014c0 "CANADIAN SYLLABICS NE"                  nil     )
    (#x0014c1 "CANADIAN SYLLABICS NAAI"                nil     )
    (#x0014c2 "CANADIAN SYLLABICS NI"                  nil     )
    (#x0014c3 "CANADIAN SYLLABICS NII"                 nil     )
    (#x0014c4 "CANADIAN SYLLABICS NO"                  nil     )
    (#x0014c5 "CANADIAN SYLLABICS NOO"                 nil     )
    (#x0014c6 "CANADIAN SYLLABICS Y-CREE NOO"          nil     )
    (#x0014c7 "CANADIAN SYLLABICS NA"                  nil     )
    (#x0014c8 "CANADIAN SYLLABICS NAA"                 nil     )
    (#x0014c9 "CANADIAN SYLLABICS NWE"                 nil     )
    (#x0014ca "CANADIAN SYLLABICS WEST-CREE NWE"       nil     )
    (#x0014cb "CANADIAN SYLLABICS NWA"                 nil     )
    (#x0014cc "CANADIAN SYLLABICS WEST-CREE NWA"       nil     )
    (#x0014cd "CANADIAN SYLLABICS NWAA"                nil     )
    (#x0014ce "CANADIAN SYLLABICS WEST-CREE NWAA"      nil     )
    (#x0014cf "CANADIAN SYLLABICS NASKAPI NWAA"        nil     )
    (#x0014d0 "CANADIAN SYLLABICS N"                   nil     )
    (#x0014d1 "CANADIAN SYLLABICS CARRIER NG"          nil     )
    (#x0014d2 "CANADIAN SYLLABICS NH"                  nil     )
    (#x0014d3 "CANADIAN SYLLABICS LE"                  nil     )
    (#x0014d4 "CANADIAN SYLLABICS LAAI"                nil     )
    (#x0014d5 "CANADIAN SYLLABICS LI"                  nil     )
    (#x0014d6 "CANADIAN SYLLABICS LII"                 nil     )
    (#x0014d7 "CANADIAN SYLLABICS LO"                  nil     )
    (#x0014d8 "CANADIAN SYLLABICS LOO"                 nil     )
    (#x0014d9 "CANADIAN SYLLABICS Y-CREE LOO"          nil     )
    (#x0014da "CANADIAN SYLLABICS LA"                  nil     )
    (#x0014db "CANADIAN SYLLABICS LAA"                 nil     )
    (#x0014dc "CANADIAN SYLLABICS LWE"                 nil     )
    (#x0014dd "CANADIAN SYLLABICS WEST-CREE LWE"       nil     )
    (#x0014de "CANADIAN SYLLABICS LWI"                 nil     )
    (#x0014df "CANADIAN SYLLABICS WEST-CREE LWI"       nil     )
    (#x0014e0 "CANADIAN SYLLABICS LWII"                nil     )
    (#x0014e1 "CANADIAN SYLLABICS WEST-CREE LWII"      nil     )
    (#x0014e2 "CANADIAN SYLLABICS LWO"                 nil     )
    (#x0014e3 "CANADIAN SYLLABICS WEST-CREE LWO"       nil     )
    (#x0014e4 "CANADIAN SYLLABICS LWOO"                nil     )
    (#x0014e5 "CANADIAN SYLLABICS WEST-CREE LWOO"      nil     )
    (#x0014e6 "CANADIAN SYLLABICS LWA"                 nil     )
    (#x0014e7 "CANADIAN SYLLABICS WEST-CREE LWA"       nil     )
    (#x0014e8 "CANADIAN SYLLABICS LWAA"                nil     )
    (#x0014e9 "CANADIAN SYLLABICS WEST-CREE LWAA"      nil     )
    (#x0014ea "CANADIAN SYLLABICS L"                   nil     )
    (#x0014eb "CANADIAN SYLLABICS WEST-CREE L"         nil     )
    (#x0014ec "CANADIAN SYLLABICS MEDIAL L"            nil     )
    (#x0014ed "CANADIAN SYLLABICS SE"                  nil     )
    (#x0014ee "CANADIAN SYLLABICS SAAI"                nil     )
    (#x0014ef "CANADIAN SYLLABICS SI"                  nil     )
    (#x0014f0 "CANADIAN SYLLABICS SII"                 nil     )
    (#x0014f1 "CANADIAN SYLLABICS SO"                  nil     )
    (#x0014f2 "CANADIAN SYLLABICS SOO"                 nil     )
    (#x0014f3 "CANADIAN SYLLABICS Y-CREE SOO"          nil     )
    (#x0014f4 "CANADIAN SYLLABICS SA"                  nil     )
    (#x0014f5 "CANADIAN SYLLABICS SAA"                 nil     )
    (#x0014f6 "CANADIAN SYLLABICS SWE"                 nil     )
    (#x0014f7 "CANADIAN SYLLABICS WEST-CREE SWE"       nil     )
    (#x0014f8 "CANADIAN SYLLABICS SWI"                 nil     )
    (#x0014f9 "CANADIAN SYLLABICS WEST-CREE SWI"       nil     )
    (#x0014fa "CANADIAN SYLLABICS SWII"                nil     )
    (#x0014fb "CANADIAN SYLLABICS WEST-CREE SWII"      nil     )
    (#x0014fc "CANADIAN SYLLABICS SWO"                 nil     )
    (#x0014fd "CANADIAN SYLLABICS WEST-CREE SWO"       nil     )
    (#x0014fe "CANADIAN SYLLABICS SWOO"                nil     )
    (#x0014ff "CANADIAN SYLLABICS WEST-CREE SWOO"      nil     )
    (#x001500 "CANADIAN SYLLABICS SWA"                 nil     )
    (#x001501 "CANADIAN SYLLABICS WEST-CREE SWA"       nil     )
    (#x001502 "CANADIAN SYLLABICS SWAA"                nil     )
    (#x001503 "CANADIAN SYLLABICS WEST-CREE SWAA"      nil     )
    (#x001504 "CANADIAN SYLLABICS NASKAPI SWAA"        nil     )
    (#x001505 "CANADIAN SYLLABICS S"                   nil     )
    (#x001506 "CANADIAN SYLLABICS ATHAPASCAN S"        nil     )
    (#x001507 "CANADIAN SYLLABICS SW"                  nil     )
    (#x001508 "CANADIAN SYLLABICS BLACKFOOT S"         nil     )
    (#x001509 "CANADIAN SYLLABICS MOOSE-CREE SK"       nil     )
    (#x00150a "CANADIAN SYLLABICS NASKAPI SKW"         nil     )
    (#x00150b "CANADIAN SYLLABICS NASKAPI S-W"         nil     )
    (#x00150c "CANADIAN SYLLABICS NASKAPI SPWA"        nil     )
    (#x00150d "CANADIAN SYLLABICS NASKAPI STWA"        nil     )
    (#x00150e "CANADIAN SYLLABICS NASKAPI SKWA"        nil     )
    (#x00150f "CANADIAN SYLLABICS NASKAPI SCWA"        nil     )
    (#x001510 "CANADIAN SYLLABICS SHE"                 nil     )
    (#x001511 "CANADIAN SYLLABICS SHI"                 nil     )
    (#x001512 "CANADIAN SYLLABICS SHII"                nil     )
    (#x001513 "CANADIAN SYLLABICS SHO"                 nil     )
    (#x001514 "CANADIAN SYLLABICS SHOO"                nil     )
    (#x001515 "CANADIAN SYLLABICS SHA"                 nil     )
    (#x001516 "CANADIAN SYLLABICS SHAA"                nil     )
    (#x001517 "CANADIAN SYLLABICS SHWE"                nil     )
    (#x001518 "CANADIAN SYLLABICS WEST-CREE SHWE"      nil     )
    (#x001519 "CANADIAN SYLLABICS SHWI"                nil     )
    (#x00151a "CANADIAN SYLLABICS WEST-CREE SHWI"      nil     )
    (#x00151b "CANADIAN SYLLABICS SHWII"               nil     )
    (#x00151c "CANADIAN SYLLABICS WEST-CREE SHWII"     nil     )
    (#x00151d "CANADIAN SYLLABICS SHWO"                nil     )
    (#x00151e "CANADIAN SYLLABICS WEST-CREE SHWO"      nil     )
    (#x00151f "CANADIAN SYLLABICS SHWOO"               nil     )
    (#x001520 "CANADIAN SYLLABICS WEST-CREE SHWOO"     nil     )
    (#x001521 "CANADIAN SYLLABICS SHWA"                nil     )
    (#x001522 "CANADIAN SYLLABICS WEST-CREE SHWA"      nil     )
    (#x001523 "CANADIAN SYLLABICS SHWAA"               nil     )
    (#x001524 "CANADIAN SYLLABICS WEST-CREE SHWAA"     nil     )
    (#x001525 "CANADIAN SYLLABICS SH"                  nil     )
    (#x001526 "CANADIAN SYLLABICS YE"                  nil     )
    (#x001527 "CANADIAN SYLLABICS YAAI"                nil     )
    (#x001528 "CANADIAN SYLLABICS YI"                  nil     )
    (#x001529 "CANADIAN SYLLABICS YII"                 nil     )
    (#x00152a "CANADIAN SYLLABICS YO"                  nil     )
    (#x00152b "CANADIAN SYLLABICS YOO"                 nil     )
    (#x00152c "CANADIAN SYLLABICS Y-CREE YOO"          nil     )
    (#x00152d "CANADIAN SYLLABICS YA"                  nil     )
    (#x00152e "CANADIAN SYLLABICS YAA"                 nil     )
    (#x00152f "CANADIAN SYLLABICS YWE"                 nil     )
    (#x001530 "CANADIAN SYLLABICS WEST-CREE YWE"       nil     )
    (#x001531 "CANADIAN SYLLABICS YWI"                 nil     )
    (#x001532 "CANADIAN SYLLABICS WEST-CREE YWI"       nil     )
    (#x001533 "CANADIAN SYLLABICS YWII"                nil     )
    (#x001534 "CANADIAN SYLLABICS WEST-CREE YWII"      nil     )
    (#x001535 "CANADIAN SYLLABICS YWO"                 nil     )
    (#x001536 "CANADIAN SYLLABICS WEST-CREE YWO"       nil     )
    (#x001537 "CANADIAN SYLLABICS YWOO"                nil     )
    (#x001538 "CANADIAN SYLLABICS WEST-CREE YWOO"      nil     )
    (#x001539 "CANADIAN SYLLABICS YWA"                 nil     )
    (#x00153a "CANADIAN SYLLABICS WEST-CREE YWA"       nil     )
    (#x00153b "CANADIAN SYLLABICS YWAA"                nil     )
    (#x00153c "CANADIAN SYLLABICS WEST-CREE YWAA"      nil     )
    (#x00153d "CANADIAN SYLLABICS NASKAPI YWAA"        nil     )
    (#x00153e "CANADIAN SYLLABICS Y"                   nil     )
    (#x00153f "CANADIAN SYLLABICS BIBLE-CREE Y"        nil     )
    (#x001540 "CANADIAN SYLLABICS WEST-CREE Y"         nil     )
    (#x001541 "CANADIAN SYLLABICS SAYISI YI"           nil     )
    (#x001542 "CANADIAN SYLLABICS RE"                  nil     )
    (#x001543 "CANADIAN SYLLABICS R-CREE RE"           nil     )
    (#x001544 "CANADIAN SYLLABICS WEST-CREE LE"        nil     )
    (#x001545 "CANADIAN SYLLABICS RAAI"                nil     )
    (#x001546 "CANADIAN SYLLABICS RI"                  nil     )
    (#x001547 "CANADIAN SYLLABICS RII"                 nil     )
    (#x001548 "CANADIAN SYLLABICS RO"                  nil     )
    (#x001549 "CANADIAN SYLLABICS ROO"                 nil     )
    (#x00154a "CANADIAN SYLLABICS WEST-CREE LO"        nil     )
    (#x00154b "CANADIAN SYLLABICS RA"                  nil     )
    (#x00154c "CANADIAN SYLLABICS RAA"                 nil     )
    (#x00154d "CANADIAN SYLLABICS WEST-CREE LA"        nil     )
    (#x00154e "CANADIAN SYLLABICS RWAA"                nil     )
    (#x00154f "CANADIAN SYLLABICS WEST-CREE RWAA"      nil     )
    (#x001550 "CANADIAN SYLLABICS R"                   nil     )
    (#x001551 "CANADIAN SYLLABICS WEST-CREE R"         nil     )
    (#x001552 "CANADIAN SYLLABICS MEDIAL R"            nil     )
    (#x001553 "CANADIAN SYLLABICS FE"                  nil     )
    (#x001554 "CANADIAN SYLLABICS FAAI"                nil     )
    (#x001555 "CANADIAN SYLLABICS FI"                  nil     )
    (#x001556 "CANADIAN SYLLABICS FII"                 nil     )
    (#x001557 "CANADIAN SYLLABICS FO"                  nil     )
    (#x001558 "CANADIAN SYLLABICS FOO"                 nil     )
    (#x001559 "CANADIAN SYLLABICS FA"                  nil     )
    (#x00155a "CANADIAN SYLLABICS FAA"                 nil     )
    (#x00155b "CANADIAN SYLLABICS FWAA"                nil     )
    (#x00155c "CANADIAN SYLLABICS WEST-CREE FWAA"      nil     )
    (#x00155d "CANADIAN SYLLABICS F"                   nil     )
    (#x00155e "CANADIAN SYLLABICS THE"                 nil     )
    (#x00155f "CANADIAN SYLLABICS N-CREE THE"          nil     )
    (#x001560 "CANADIAN SYLLABICS THI"                 nil     )
    (#x001561 "CANADIAN SYLLABICS N-CREE THI"          nil     )
    (#x001562 "CANADIAN SYLLABICS THII"                nil     )
    (#x001563 "CANADIAN SYLLABICS N-CREE THII"         nil     )
    (#x001564 "CANADIAN SYLLABICS THO"                 nil     )
    (#x001565 "CANADIAN SYLLABICS THOO"                nil     )
    (#x001566 "CANADIAN SYLLABICS THA"                 nil     )
    (#x001567 "CANADIAN SYLLABICS THAA"                nil     )
    (#x001568 "CANADIAN SYLLABICS THWAA"               nil     )
    (#x001569 "CANADIAN SYLLABICS WEST-CREE THWAA"     nil     )
    (#x00156a "CANADIAN SYLLABICS TH"                  nil     )
    (#x00156b "CANADIAN SYLLABICS TTHE"                nil     )
    (#x00156c "CANADIAN SYLLABICS TTHI"                nil     )
    (#x00156d "CANADIAN SYLLABICS TTHO"                nil     )
    (#x00156e "CANADIAN SYLLABICS TTHA"                nil     )
    (#x00156f "CANADIAN SYLLABICS TTH"                 nil     )
    (#x001570 "CANADIAN SYLLABICS TYE"                 nil     )
    (#x001571 "CANADIAN SYLLABICS TYI"                 nil     )
    (#x001572 "CANADIAN SYLLABICS TYO"                 nil     )
    (#x001573 "CANADIAN SYLLABICS TYA"                 nil     )
    (#x001574 "CANADIAN SYLLABICS NUNAVIK HE"          nil     )
    (#x001575 "CANADIAN SYLLABICS NUNAVIK HI"          nil     )
    (#x001576 "CANADIAN SYLLABICS NUNAVIK HII"         nil     )
    (#x001577 "CANADIAN SYLLABICS NUNAVIK HO"          nil     )
    (#x001578 "CANADIAN SYLLABICS NUNAVIK HOO"         nil     )
    (#x001579 "CANADIAN SYLLABICS NUNAVIK HA"          nil     )
    (#x00157a "CANADIAN SYLLABICS NUNAVIK HAA"         nil     )
    (#x00157b "CANADIAN SYLLABICS NUNAVIK H"           nil     )
    (#x00157c "CANADIAN SYLLABICS NUNAVUT H"           nil     )
    (#x00157d "CANADIAN SYLLABICS HK"                  nil     )
    (#x00157e "CANADIAN SYLLABICS QAAI"                nil     )
    (#x00157f "CANADIAN SYLLABICS QI"                  nil     )
    (#x001580 "CANADIAN SYLLABICS QII"                 nil     )
    (#x001581 "CANADIAN SYLLABICS QO"                  nil     )
    (#x001582 "CANADIAN SYLLABICS QOO"                 nil     )
    (#x001583 "CANADIAN SYLLABICS QA"                  nil     )
    (#x001584 "CANADIAN SYLLABICS QAA"                 nil     )
    (#x001585 "CANADIAN SYLLABICS Q"                   nil     )
    (#x001586 "CANADIAN SYLLABICS TLHE"                nil     )
    (#x001587 "CANADIAN SYLLABICS TLHI"                nil     )
    (#x001588 "CANADIAN SYLLABICS TLHO"                nil     )
    (#x001589 "CANADIAN SYLLABICS TLHA"                nil     )
    (#x00158a "CANADIAN SYLLABICS WEST-CREE RE"        nil     )
    (#x00158b "CANADIAN SYLLABICS WEST-CREE RI"        nil     )
    (#x00158c "CANADIAN SYLLABICS WEST-CREE RO"        nil     )
    (#x00158d "CANADIAN SYLLABICS WEST-CREE RA"        nil     )
    (#x00158e "CANADIAN SYLLABICS NGAAI"               nil     )
    (#x00158f "CANADIAN SYLLABICS NGI"                 nil     )
    (#x001590 "CANADIAN SYLLABICS NGII"                nil     )
    (#x001591 "CANADIAN SYLLABICS NGO"                 nil     )
    (#x001592 "CANADIAN SYLLABICS NGOO"                nil     )
    (#x001593 "CANADIAN SYLLABICS NGA"                 nil     )
    (#x001594 "CANADIAN SYLLABICS NGAA"                nil     )
    (#x001595 "CANADIAN SYLLABICS NG"                  nil     )
    (#x001596 "CANADIAN SYLLABICS NNG"                 nil     )
    (#x001597 "CANADIAN SYLLABICS SAYISI SHE"          nil     )
    (#x001598 "CANADIAN SYLLABICS SAYISI SHI"          nil     )
    (#x001599 "CANADIAN SYLLABICS SAYISI SHO"          nil     )
    (#x00159a "CANADIAN SYLLABICS SAYISI SHA"          nil     )
    (#x00159b "CANADIAN SYLLABICS WOODS-CREE THE"      nil     )
    (#x00159c "CANADIAN SYLLABICS WOODS-CREE THI"      nil     )
    (#x00159d "CANADIAN SYLLABICS WOODS-CREE THO"      nil     )
    (#x00159e "CANADIAN SYLLABICS WOODS-CREE THA"      nil     )
    (#x00159f "CANADIAN SYLLABICS WOODS-CREE TH"       nil     )
    (#x0015a0 "CANADIAN SYLLABICS LHI"                 nil     )
    (#x0015a1 "CANADIAN SYLLABICS LHII"                nil     )
    (#x0015a2 "CANADIAN SYLLABICS LHO"                 nil     )
    (#x0015a3 "CANADIAN SYLLABICS LHOO"                nil     )
    (#x0015a4 "CANADIAN SYLLABICS LHA"                 nil     )
    (#x0015a5 "CANADIAN SYLLABICS LHAA"                nil     )
    (#x0015a6 "CANADIAN SYLLABICS LH"                  nil     )
    (#x0015a7 "CANADIAN SYLLABICS TH-CREE THE"         nil     )
    (#x0015a8 "CANADIAN SYLLABICS TH-CREE THI"         nil     )
    (#x0015a9 "CANADIAN SYLLABICS TH-CREE THII"        nil     )
    (#x0015aa "CANADIAN SYLLABICS TH-CREE THO"         nil     )
    (#x0015ab "CANADIAN SYLLABICS TH-CREE THOO"        nil     )
    (#x0015ac "CANADIAN SYLLABICS TH-CREE THA"         nil     )
    (#x0015ad "CANADIAN SYLLABICS TH-CREE THAA"        nil     )
    (#x0015ae "CANADIAN SYLLABICS TH-CREE TH"          nil     )
    (#x0015af "CANADIAN SYLLABICS AIVILIK B"           nil     )
    (#x0015b0 "CANADIAN SYLLABICS BLACKFOOT E"         nil     )
    (#x0015b1 "CANADIAN SYLLABICS BLACKFOOT I"         nil     )
    (#x0015b2 "CANADIAN SYLLABICS BLACKFOOT O"         nil     )
    (#x0015b3 "CANADIAN SYLLABICS BLACKFOOT A"         nil     )
    (#x0015b4 "CANADIAN SYLLABICS BLACKFOOT WE"        nil     )
    (#x0015b5 "CANADIAN SYLLABICS BLACKFOOT WI"        nil     )
    (#x0015b6 "CANADIAN SYLLABICS BLACKFOOT WO"        nil     )
    (#x0015b7 "CANADIAN SYLLABICS BLACKFOOT WA"        nil     )
    (#x0015b8 "CANADIAN SYLLABICS BLACKFOOT NE"        nil     )
    (#x0015b9 "CANADIAN SYLLABICS BLACKFOOT NI"        nil     )
    (#x0015ba "CANADIAN SYLLABICS BLACKFOOT NO"        nil     )
    (#x0015bb "CANADIAN SYLLABICS BLACKFOOT NA"        nil     )
    (#x0015bc "CANADIAN SYLLABICS BLACKFOOT KE"        nil     )
    (#x0015bd "CANADIAN SYLLABICS BLACKFOOT KI"        nil     )
    (#x0015be "CANADIAN SYLLABICS BLACKFOOT KO"        nil     )
    (#x0015bf "CANADIAN SYLLABICS BLACKFOOT KA"        nil     )
    (#x0015c0 "CANADIAN SYLLABICS SAYISI HE"           nil     )
    (#x0015c1 "CANADIAN SYLLABICS SAYISI HI"           nil     )
    (#x0015c2 "CANADIAN SYLLABICS SAYISI HO"           nil     )
    (#x0015c3 "CANADIAN SYLLABICS SAYISI HA"           nil     )
    (#x0015c4 "CANADIAN SYLLABICS CARRIER GHU"         nil     )
    (#x0015c5 "CANADIAN SYLLABICS CARRIER GHO"         nil     )
    (#x0015c6 "CANADIAN SYLLABICS CARRIER GHE"         nil     )
    (#x0015c7 "CANADIAN SYLLABICS CARRIER GHEE"        nil     )
    (#x0015c8 "CANADIAN SYLLABICS CARRIER GHI"         nil     )
    (#x0015c9 "CANADIAN SYLLABICS CARRIER GHA"         nil     )
    (#x0015ca "CANADIAN SYLLABICS CARRIER RU"          nil     )
    (#x0015cb "CANADIAN SYLLABICS CARRIER RO"          nil     )
    (#x0015cc "CANADIAN SYLLABICS CARRIER RE"          nil     )
    (#x0015cd "CANADIAN SYLLABICS CARRIER REE"         nil     )
    (#x0015ce "CANADIAN SYLLABICS CARRIER RI"          nil     )
    (#x0015cf "CANADIAN SYLLABICS CARRIER RA"          nil     )
    (#x0015d0 "CANADIAN SYLLABICS CARRIER WU"          nil     )
    (#x0015d1 "CANADIAN SYLLABICS CARRIER WO"          nil     )
    (#x0015d2 "CANADIAN SYLLABICS CARRIER WE"          nil     )
    (#x0015d3 "CANADIAN SYLLABICS CARRIER WEE"         nil     )
    (#x0015d4 "CANADIAN SYLLABICS CARRIER WI"          nil     )
    (#x0015d5 "CANADIAN SYLLABICS CARRIER WA"          nil     )
    (#x0015d6 "CANADIAN SYLLABICS CARRIER HWU"         nil     )
    (#x0015d7 "CANADIAN SYLLABICS CARRIER HWO"         nil     )
    (#x0015d8 "CANADIAN SYLLABICS CARRIER HWE"         nil     )
    (#x0015d9 "CANADIAN SYLLABICS CARRIER HWEE"        nil     )
    (#x0015da "CANADIAN SYLLABICS CARRIER HWI"         nil     )
    (#x0015db "CANADIAN SYLLABICS CARRIER HWA"         nil     )
    (#x0015dc "CANADIAN SYLLABICS CARRIER THU"         nil     )
    (#x0015dd "CANADIAN SYLLABICS CARRIER THO"         nil     )
    (#x0015de "CANADIAN SYLLABICS CARRIER THE"         nil     )
    (#x0015df "CANADIAN SYLLABICS CARRIER THEE"        nil     )
    (#x0015e0 "CANADIAN SYLLABICS CARRIER THI"         nil     )
    (#x0015e1 "CANADIAN SYLLABICS CARRIER THA"         nil     )
    (#x0015e2 "CANADIAN SYLLABICS CARRIER TTU"         nil     )
    (#x0015e3 "CANADIAN SYLLABICS CARRIER TTO"         nil     )
    (#x0015e4 "CANADIAN SYLLABICS CARRIER TTE"         nil     )
    (#x0015e5 "CANADIAN SYLLABICS CARRIER TTEE"        nil     )
    (#x0015e6 "CANADIAN SYLLABICS CARRIER TTI"         nil     )
    (#x0015e7 "CANADIAN SYLLABICS CARRIER TTA"         nil     )
    (#x0015e8 "CANADIAN SYLLABICS CARRIER PU"          nil     )
    (#x0015e9 "CANADIAN SYLLABICS CARRIER PO"          nil     )
    (#x0015ea "CANADIAN SYLLABICS CARRIER PE"          nil     )
    (#x0015eb "CANADIAN SYLLABICS CARRIER PEE"         nil     )
    (#x0015ec "CANADIAN SYLLABICS CARRIER PI"          nil     )
    (#x0015ed "CANADIAN SYLLABICS CARRIER PA"          nil     )
    (#x0015ee "CANADIAN SYLLABICS CARRIER P"           nil     )
    (#x0015ef "CANADIAN SYLLABICS CARRIER GU"          nil     )
    (#x0015f0 "CANADIAN SYLLABICS CARRIER GO"          nil     )
    (#x0015f1 "CANADIAN SYLLABICS CARRIER GE"          nil     )
    (#x0015f2 "CANADIAN SYLLABICS CARRIER GEE"         nil     )
    (#x0015f3 "CANADIAN SYLLABICS CARRIER GI"          nil     )
    (#x0015f4 "CANADIAN SYLLABICS CARRIER GA"          nil     )
    (#x0015f5 "CANADIAN SYLLABICS CARRIER KHU"         nil     )
    (#x0015f6 "CANADIAN SYLLABICS CARRIER KHO"         nil     )
    (#x0015f7 "CANADIAN SYLLABICS CARRIER KHE"         nil     )
    (#x0015f8 "CANADIAN SYLLABICS CARRIER KHEE"        nil     )
    (#x0015f9 "CANADIAN SYLLABICS CARRIER KHI"         nil     )
    (#x0015fa "CANADIAN SYLLABICS CARRIER KHA"         nil     )
    (#x0015fb "CANADIAN SYLLABICS CARRIER KKU"         nil     )
    (#x0015fc "CANADIAN SYLLABICS CARRIER KKO"         nil     )
    (#x0015fd "CANADIAN SYLLABICS CARRIER KKE"         nil     )
    (#x0015fe "CANADIAN SYLLABICS CARRIER KKEE"        nil     )
    (#x0015ff "CANADIAN SYLLABICS CARRIER KKI"         nil     )
    (#x001600 "CANADIAN SYLLABICS CARRIER KKA"         nil     )
    (#x001601 "CANADIAN SYLLABICS CARRIER KK"          nil     )
    (#x001602 "CANADIAN SYLLABICS CARRIER NU"          nil     )
    (#x001603 "CANADIAN SYLLABICS CARRIER NO"          nil     )
    (#x001604 "CANADIAN SYLLABICS CARRIER NE"          nil     )
    (#x001605 "CANADIAN SYLLABICS CARRIER NEE"         nil     )
    (#x001606 "CANADIAN SYLLABICS CARRIER NI"          nil     )
    (#x001607 "CANADIAN SYLLABICS CARRIER NA"          nil     )
    (#x001608 "CANADIAN SYLLABICS CARRIER MU"          nil     )
    (#x001609 "CANADIAN SYLLABICS CARRIER MO"          nil     )
    (#x00160a "CANADIAN SYLLABICS CARRIER ME"          nil     )
    (#x00160b "CANADIAN SYLLABICS CARRIER MEE"         nil     )
    (#x00160c "CANADIAN SYLLABICS CARRIER MI"          nil     )
    (#x00160d "CANADIAN SYLLABICS CARRIER MA"          nil     )
    (#x00160e "CANADIAN SYLLABICS CARRIER YU"          nil     )
    (#x00160f "CANADIAN SYLLABICS CARRIER YO"          nil     )
    (#x001610 "CANADIAN SYLLABICS CARRIER YE"          nil     )
    (#x001611 "CANADIAN SYLLABICS CARRIER YEE"         nil     )
    (#x001612 "CANADIAN SYLLABICS CARRIER YI"          nil     )
    (#x001613 "CANADIAN SYLLABICS CARRIER YA"          nil     )
    (#x001614 "CANADIAN SYLLABICS CARRIER JU"          nil     )
    (#x001615 "CANADIAN SYLLABICS SAYISI JU"           nil     )
    (#x001616 "CANADIAN SYLLABICS CARRIER JO"          nil     )
    (#x001617 "CANADIAN SYLLABICS CARRIER JE"          nil     )
    (#x001618 "CANADIAN SYLLABICS CARRIER JEE"         nil     )
    (#x001619 "CANADIAN SYLLABICS CARRIER JI"          nil     )
    (#x00161a "CANADIAN SYLLABICS SAYISI JI"           nil     )
    (#x00161b "CANADIAN SYLLABICS CARRIER JA"          nil     )
    (#x00161c "CANADIAN SYLLABICS CARRIER JJU"         nil     )
    (#x00161d "CANADIAN SYLLABICS CARRIER JJO"         nil     )
    (#x00161e "CANADIAN SYLLABICS CARRIER JJE"         nil     )
    (#x00161f "CANADIAN SYLLABICS CARRIER JJEE"        nil     )
    (#x001620 "CANADIAN SYLLABICS CARRIER JJI"         nil     )
    (#x001621 "CANADIAN SYLLABICS CARRIER JJA"         nil     )
    (#x001622 "CANADIAN SYLLABICS CARRIER LU"          nil     )
    (#x001623 "CANADIAN SYLLABICS CARRIER LO"          nil     )
    (#x001624 "CANADIAN SYLLABICS CARRIER LE"          nil     )
    (#x001625 "CANADIAN SYLLABICS CARRIER LEE"         nil     )
    (#x001626 "CANADIAN SYLLABICS CARRIER LI"          nil     )
    (#x001627 "CANADIAN SYLLABICS CARRIER LA"          nil     )
    (#x001628 "CANADIAN SYLLABICS CARRIER DLU"         nil     )
    (#x001629 "CANADIAN SYLLABICS CARRIER DLO"         nil     )
    (#x00162a "CANADIAN SYLLABICS CARRIER DLE"         nil     )
    (#x00162b "CANADIAN SYLLABICS CARRIER DLEE"        nil     )
    (#x00162c "CANADIAN SYLLABICS CARRIER DLI"         nil     )
    (#x00162d "CANADIAN SYLLABICS CARRIER DLA"         nil     )
    (#x00162e "CANADIAN SYLLABICS CARRIER LHU"         nil     )
    (#x00162f "CANADIAN SYLLABICS CARRIER LHO"         nil     )
    (#x001630 "CANADIAN SYLLABICS CARRIER LHE"         nil     )
    (#x001631 "CANADIAN SYLLABICS CARRIER LHEE"        nil     )
    (#x001632 "CANADIAN SYLLABICS CARRIER LHI"         nil     )
    (#x001633 "CANADIAN SYLLABICS CARRIER LHA"         nil     )
    (#x001634 "CANADIAN SYLLABICS CARRIER TLHU"        nil     )
    (#x001635 "CANADIAN SYLLABICS CARRIER TLHO"        nil     )
    (#x001636 "CANADIAN SYLLABICS CARRIER TLHE"        nil     )
    (#x001637 "CANADIAN SYLLABICS CARRIER TLHEE"       nil     )
    (#x001638 "CANADIAN SYLLABICS CARRIER TLHI"        nil     )
    (#x001639 "CANADIAN SYLLABICS CARRIER TLHA"        nil     )
    (#x00163a "CANADIAN SYLLABICS CARRIER TLU"         nil     )
    (#x00163b "CANADIAN SYLLABICS CARRIER TLO"         nil     )
    (#x00163c "CANADIAN SYLLABICS CARRIER TLE"         nil     )
    (#x00163d "CANADIAN SYLLABICS CARRIER TLEE"        nil     )
    (#x00163e "CANADIAN SYLLABICS CARRIER TLI"         nil     )
    (#x00163f "CANADIAN SYLLABICS CARRIER TLA"         nil     )
    (#x001640 "CANADIAN SYLLABICS CARRIER ZU"          nil     )
    (#x001641 "CANADIAN SYLLABICS CARRIER ZO"          nil     )
    (#x001642 "CANADIAN SYLLABICS CARRIER ZE"          nil     )
    (#x001643 "CANADIAN SYLLABICS CARRIER ZEE"         nil     )
    (#x001644 "CANADIAN SYLLABICS CARRIER ZI"          nil     )
    (#x001645 "CANADIAN SYLLABICS CARRIER ZA"          nil     )
    (#x001646 "CANADIAN SYLLABICS CARRIER Z"           nil     )
    (#x001647 "CANADIAN SYLLABICS CARRIER INITIAL Z"   nil     )
    (#x001648 "CANADIAN SYLLABICS CARRIER DZU"         nil     )
    (#x001649 "CANADIAN SYLLABICS CARRIER DZO"         nil     )
    (#x00164a "CANADIAN SYLLABICS CARRIER DZE"         nil     )
    (#x00164b "CANADIAN SYLLABICS CARRIER DZEE"        nil     )
    (#x00164c "CANADIAN SYLLABICS CARRIER DZI"         nil     )
    (#x00164d "CANADIAN SYLLABICS CARRIER DZA"         nil     )
    (#x00164e "CANADIAN SYLLABICS CARRIER SU"          nil     )
    (#x00164f "CANADIAN SYLLABICS CARRIER SO"          nil     )
    (#x001650 "CANADIAN SYLLABICS CARRIER SE"          nil     )
    (#x001651 "CANADIAN SYLLABICS CARRIER SEE"         nil     )
    (#x001652 "CANADIAN SYLLABICS CARRIER SI"          nil     )
    (#x001653 "CANADIAN SYLLABICS CARRIER SA"          nil     )
    (#x001654 "CANADIAN SYLLABICS CARRIER SHU"         nil     )
    (#x001655 "CANADIAN SYLLABICS CARRIER SHO"         nil     )
    (#x001656 "CANADIAN SYLLABICS CARRIER SHE"         nil     )
    (#x001657 "CANADIAN SYLLABICS CARRIER SHEE"        nil     )
    (#x001658 "CANADIAN SYLLABICS CARRIER SHI"         nil     )
    (#x001659 "CANADIAN SYLLABICS CARRIER SHA"         nil     )
    (#x00165a "CANADIAN SYLLABICS CARRIER SH"          nil     )
    (#x00165b "CANADIAN SYLLABICS CARRIER TSU"         nil     )
    (#x00165c "CANADIAN SYLLABICS CARRIER TSO"         nil     )
    (#x00165d "CANADIAN SYLLABICS CARRIER TSE"         nil     )
    (#x00165e "CANADIAN SYLLABICS CARRIER TSEE"        nil     )
    (#x00165f "CANADIAN SYLLABICS CARRIER TSI"         nil     )
    (#x001660 "CANADIAN SYLLABICS CARRIER TSA"         nil     )
    (#x001661 "CANADIAN SYLLABICS CARRIER CHU"         nil     )
    (#x001662 "CANADIAN SYLLABICS CARRIER CHO"         nil     )
    (#x001663 "CANADIAN SYLLABICS CARRIER CHE"         nil     )
    (#x001664 "CANADIAN SYLLABICS CARRIER CHEE"        nil     )
    (#x001665 "CANADIAN SYLLABICS CARRIER CHI"         nil     )
    (#x001666 "CANADIAN SYLLABICS CARRIER CHA"         nil     )
    (#x001667 "CANADIAN SYLLABICS CARRIER TTSU"        nil     )
    (#x001668 "CANADIAN SYLLABICS CARRIER TTSO"        nil     )
    (#x001669 "CANADIAN SYLLABICS CARRIER TTSE"        nil     )
    (#x00166a "CANADIAN SYLLABICS CARRIER TTSEE"       nil     )
    (#x00166b "CANADIAN SYLLABICS CARRIER TTSI"        nil     )
    (#x00166c "CANADIAN SYLLABICS CARRIER TTSA"        nil     )
    (#x00166d "CANADIAN SYLLABICS CHI SIGN"            nil     )
    (#x00166e "CANADIAN SYLLABICS FULL STOP"           nil     )
    (#x00166f "CANADIAN SYLLABICS QAI"                 nil     )
    (#x001670 "CANADIAN SYLLABICS NGAI"                nil     )
    (#x001671 "CANADIAN SYLLABICS NNGI"                nil     )
    (#x001672 "CANADIAN SYLLABICS NNGII"               nil     )
    (#x001673 "CANADIAN SYLLABICS NNGO"                nil     )
    (#x001674 "CANADIAN SYLLABICS NNGOO"               nil     )
    (#x001675 "CANADIAN SYLLABICS NNGA"                nil     )
    (#x001676 "CANADIAN SYLLABICS NNGAA"               nil     )
    (#x001677 "CANADIAN SYLLABICS WOODS-CREE THWEE"    nil     )
    (#x001678 "CANADIAN SYLLABICS WOODS-CREE THWI"     nil     )
    (#x001679 "CANADIAN SYLLABICS WOODS-CREE THWII"    nil     )
    (#x00167a "CANADIAN SYLLABICS WOODS-CREE THWO"     nil     )
    (#x00167b "CANADIAN SYLLABICS WOODS-CREE THWOO"    nil     )
    (#x00167c "CANADIAN SYLLABICS WOODS-CREE THWA"     nil     )
    (#x00167d "CANADIAN SYLLABICS WOODS-CREE THWAA"    nil     )
    (#x00167e "CANADIAN SYLLABICS WOODS-CREE FINAL TH" nil     )
    (#x00167f "CANADIAN SYLLABICS BLACKFOOT W"         nil     )
    (#x001680 "OGHAM SPACE MARK"                       nil     )
    (#x001681 "OGHAM LETTER BEITH"                     nil     )
    (#x001682 "OGHAM LETTER LUIS"                      nil     )
    (#x001683 "OGHAM LETTER FEARN"                     nil     )
    (#x001684 "OGHAM LETTER SAIL"                      nil     )
    (#x001685 "OGHAM LETTER NION"                      nil     )
    (#x001686 "OGHAM LETTER UATH"                      nil     )
    (#x001687 "OGHAM LETTER DAIR"                      nil     )
    (#x001688 "OGHAM LETTER TINNE"                     nil     )
    (#x001689 "OGHAM LETTER COLL"                      nil     )
    (#x00168a "OGHAM LETTER CEIRT"                     nil     )
    (#x00168b "OGHAM LETTER MUIN"                      nil     )
    (#x00168c "OGHAM LETTER GORT"                      nil     )
    (#x00168d "OGHAM LETTER NGEADAL"                   nil     )
    (#x00168e "OGHAM LETTER STRAIF"                    nil     )
    (#x00168f "OGHAM LETTER RUIS"                      nil     )
    (#x001690 "OGHAM LETTER AILM"                      nil     )
    (#x001691 "OGHAM LETTER ONN"                       nil     )
    (#x001692 "OGHAM LETTER UR"                        nil     )
    (#x001693 "OGHAM LETTER EADHADH"                   nil     )
    (#x001694 "OGHAM LETTER IODHADH"                   nil     )
    (#x001695 "OGHAM LETTER EABHADH"                   nil     )
    (#x001696 "OGHAM LETTER OR"                        nil     )
    (#x001697 "OGHAM LETTER UILLEANN"                  nil     )
    (#x001698 "OGHAM LETTER IFIN"                      nil     )
    (#x001699 "OGHAM LETTER EAMHANCHOLL"               nil     )
    (#x00169a "OGHAM LETTER PEITH"                     nil     )
    (#x00169b "OGHAM FEATHER MARK"                     nil     )
    (#x00169c "OGHAM REVERSED FEATHER MARK"            nil     )
    (#x0016a0 "RUNIC LETTER FEHU FEOH FE F"            nil     )
    (#x0016a1 "RUNIC LETTER V"                         nil     )
    (#x0016a2 "RUNIC LETTER URUZ UR U"                 nil     )
    (#x0016a3 "RUNIC LETTER YR"                        nil     )
    (#x0016a4 "RUNIC LETTER Y"                         nil     )
    (#x0016a5 "RUNIC LETTER W"                         nil     )
    (#x0016a6 "RUNIC LETTER THURISAZ THURS THORN"      nil     )
    (#x0016a7 "RUNIC LETTER ETH"                       nil     )
    (#x0016a8 "RUNIC LETTER ANSUZ A"                   nil     )
    (#x0016a9 "RUNIC LETTER OS O"                      nil     )
    (#x0016aa "RUNIC LETTER AC A"                      nil     )
    (#x0016ab "RUNIC LETTER AESC"                      nil     )
    (#x0016ac "RUNIC LETTER LONG-BRANCH-OSS O"         nil     )
    (#x0016ad "RUNIC LETTER SHORT-TWIG-OSS O"          nil     )
    (#x0016ae "RUNIC LETTER O"                         nil     )
    (#x0016af "RUNIC LETTER OE"                        nil     )
    (#x0016b0 "RUNIC LETTER ON"                        nil     )
    (#x0016b1 "RUNIC LETTER RAIDO RAD REID R"          nil     )
    (#x0016b2 "RUNIC LETTER KAUNA"                     nil     )
    (#x0016b3 "RUNIC LETTER CEN"                       nil     )
    (#x0016b4 "RUNIC LETTER KAUN K"                    nil     )
    (#x0016b5 "RUNIC LETTER G"                         nil     )
    (#x0016b6 "RUNIC LETTER ENG"                       nil     )
    (#x0016b7 "RUNIC LETTER GEBO GYFU G"               nil     )
    (#x0016b8 "RUNIC LETTER GAR"                       nil     )
    (#x0016b9 "RUNIC LETTER WUNJO WYNN W"              nil     )
    (#x0016ba "RUNIC LETTER HAGLAZ H"                  nil     )
    (#x0016bb "RUNIC LETTER HAEGL H"                   nil     )
    (#x0016bc "RUNIC LETTER LONG-BRANCH-HAGALL H"      nil     )
    (#x0016bd "RUNIC LETTER SHORT-TWIG-HAGALL H"       nil     )
    (#x0016be "RUNIC LETTER NAUDIZ NYD NAUD N"         nil     )
    (#x0016bf "RUNIC LETTER SHORT-TWIG-NAUD N"         nil     )
    (#x0016c0 "RUNIC LETTER DOTTED-N"                  nil     )
    (#x0016c1 "RUNIC LETTER ISAZ IS ISS I"             nil     )
    (#x0016c2 "RUNIC LETTER E"                         nil     )
    (#x0016c3 "RUNIC LETTER JERAN J"                   nil     )
    (#x0016c4 "RUNIC LETTER GER"                       nil     )
    (#x0016c5 "RUNIC LETTER LONG-BRANCH-AR AE"         nil     )
    (#x0016c6 "RUNIC LETTER SHORT-TWIG-AR A"           nil     )
    (#x0016c7 "RUNIC LETTER IWAZ EOH"                  nil     )
    (#x0016c8 "RUNIC LETTER PERTHO PEORTH P"           nil     )
    (#x0016c9 "RUNIC LETTER ALGIZ EOLHX"               nil     )
    (#x0016ca "RUNIC LETTER SOWILO S"                  nil     )
    (#x0016cb "RUNIC LETTER SIGEL LONG-BRANCH-SOL S"   nil     )
    (#x0016cc "RUNIC LETTER SHORT-TWIG-SOL S"          nil     )
    (#x0016cd "RUNIC LETTER C"                         nil     )
    (#x0016ce "RUNIC LETTER Z"                         nil     )
    (#x0016cf "RUNIC LETTER TIWAZ TIR TYR T"           nil     )
    (#x0016d0 "RUNIC LETTER SHORT-TWIG-TYR T"          nil     )
    (#x0016d1 "RUNIC LETTER D"                         nil     )
    (#x0016d2 "RUNIC LETTER BERKANAN BEORC BJARKAN B"  nil     )
    (#x0016d3 "RUNIC LETTER SHORT-TWIG-BJARKAN B"      nil     )
    (#x0016d4 "RUNIC LETTER DOTTED-P"                  nil     )
    (#x0016d5 "RUNIC LETTER OPEN-P"                    nil     )
    (#x0016d6 "RUNIC LETTER EHWAZ EH E"                nil     )
    (#x0016d7 "RUNIC LETTER MANNAZ MAN M"              nil     )
    (#x0016d8 "RUNIC LETTER LONG-BRANCH-MADR M"        nil     )
    (#x0016d9 "RUNIC LETTER SHORT-TWIG-MADR M"         nil     )
    (#x0016da "RUNIC LETTER LAUKAZ LAGU LOGR L"        nil     )
    (#x0016db "RUNIC LETTER DOTTED-L"                  nil     )
    (#x0016dc "RUNIC LETTER INGWAZ"                    nil     )
    (#x0016dd "RUNIC LETTER ING"                       nil     )
    (#x0016de "RUNIC LETTER DAGAZ DAEG D"              nil     )
    (#x0016df "RUNIC LETTER OTHALAN ETHEL O"           nil     )
    (#x0016e0 "RUNIC LETTER EAR"                       nil     )
    (#x0016e1 "RUNIC LETTER IOR"                       nil     )
    (#x0016e2 "RUNIC LETTER CWEORTH"                   nil     )
    (#x0016e3 "RUNIC LETTER CALC"                      nil     )
    (#x0016e4 "RUNIC LETTER CEALC"                     nil     )
    (#x0016e5 "RUNIC LETTER STAN"                      nil     )
    (#x0016e6 "RUNIC LETTER LONG-BRANCH-YR"            nil     )
    (#x0016e7 "RUNIC LETTER SHORT-TWIG-YR"             nil     )
    (#x0016e8 "RUNIC LETTER ICELANDIC-YR"              nil     )
    (#x0016e9 "RUNIC LETTER Q"                         nil     )
    (#x0016ea "RUNIC LETTER X"                         nil     )
    (#x0016eb "RUNIC SINGLE PUNCTUATION"               nil     )
    (#x0016ec "RUNIC MULTIPLE PUNCTUATION"             nil     )
    (#x0016ed "RUNIC CROSS PUNCTUATION"                nil     )
    (#x0016ee "RUNIC ARLAUG SYMBOL"                    nil     )
    (#x0016ef "RUNIC TVIMADUR SYMBOL"                  nil     )
    (#x0016f0 "RUNIC BELGTHOR SYMBOL"                  nil     )
    (#x0016f1 "RUNIC LETTER K"                         nil     )
    (#x0016f2 "RUNIC LETTER SH"                        nil     )
    (#x0016f3 "RUNIC LETTER OO"                        nil     )
    (#x0016f4 "RUNIC LETTER FRANKS CASKET OS"          nil     )
    (#x0016f5 "RUNIC LETTER FRANKS CASKET IS"          nil     )
    (#x0016f6 "RUNIC LETTER FRANKS CASKET EH"          nil     )
    (#x0016f7 "RUNIC LETTER FRANKS CASKET AC"          nil     )
    (#x0016f8 "RUNIC LETTER FRANKS CASKET AESC"        nil     )
    (#x001700 "TAGALOG LETTER A"                       nil     )
    (#x001701 "TAGALOG LETTER I"                       nil     )
    (#x001702 "TAGALOG LETTER U"                       nil     )
    (#x001703 "TAGALOG LETTER KA"                      nil     )
    (#x001704 "TAGALOG LETTER GA"                      nil     )
    (#x001705 "TAGALOG LETTER NGA"                     nil     )
    (#x001706 "TAGALOG LETTER TA"                      nil     )
    (#x001707 "TAGALOG LETTER DA"                      nil     )
    (#x001708 "TAGALOG LETTER NA"                      nil     )
    (#x001709 "TAGALOG LETTER PA"                      nil     )
    (#x00170a "TAGALOG LETTER BA"                      nil     )
    (#x00170b "TAGALOG LETTER MA"                      nil     )
    (#x00170c "TAGALOG LETTER YA"                      nil     )
    (#x00170d "TAGALOG LETTER RA"                      nil     )
    (#x00170e "TAGALOG LETTER LA"                      nil     )
    (#x00170f "TAGALOG LETTER WA"                      nil     )
    (#x001710 "TAGALOG LETTER SA"                      nil     )
    (#x001711 "TAGALOG LETTER HA"                      nil     )
    (#x001712 "TAGALOG VOWEL SIGN I"                   nil     )
    (#x001713 "TAGALOG VOWEL SIGN U"                   nil     )
    (#x001714 "TAGALOG SIGN VIRAMA"                    nil     )
    (#x001715 "TAGALOG SIGN PAMUDPOD"                  nil     )
    (#x00171f "TAGALOG LETTER ARCHAIC RA"              nil     )
    (#x001720 "HANUNOO LETTER A"                       nil     )
    (#x001721 "HANUNOO LETTER I"                       nil     )
    (#x001722 "HANUNOO LETTER U"                       nil     )
    (#x001723 "HANUNOO LETTER KA"                      nil     )
    (#x001724 "HANUNOO LETTER GA"                      nil     )
    (#x001725 "HANUNOO LETTER NGA"                     nil     )
    (#x001726 "HANUNOO LETTER TA"                      nil     )
    (#x001727 "HANUNOO LETTER DA"                      nil     )
    (#x001728 "HANUNOO LETTER NA"                      nil     )
    (#x001729 "HANUNOO LETTER PA"                      nil     )
    (#x00172a "HANUNOO LETTER BA"                      nil     )
    (#x00172b "HANUNOO LETTER MA"                      nil     )
    (#x00172c "HANUNOO LETTER YA"                      nil     )
    (#x00172d "HANUNOO LETTER RA"                      nil     )
    (#x00172e "HANUNOO LETTER LA"                      nil     )
    (#x00172f "HANUNOO LETTER WA"                      nil     )
    (#x001730 "HANUNOO LETTER SA"                      nil     )
    (#x001731 "HANUNOO LETTER HA"                      nil     )
    (#x001732 "HANUNOO VOWEL SIGN I"                   nil     )
    (#x001733 "HANUNOO VOWEL SIGN U"                   nil     )
    (#x001734 "HANUNOO SIGN PAMUDPOD"                  nil     )
    (#x001735 "PHILIPPINE SINGLE PUNCTUATION"          nil     )
    (#x001736 "PHILIPPINE DOUBLE PUNCTUATION"          nil     )
    (#x001740 "BUHID LETTER A"                         nil     )
    (#x001741 "BUHID LETTER I"                         nil     )
    (#x001742 "BUHID LETTER U"                         nil     )
    (#x001743 "BUHID LETTER KA"                        nil     )
    (#x001744 "BUHID LETTER GA"                        nil     )
    (#x001745 "BUHID LETTER NGA"                       nil     )
    (#x001746 "BUHID LETTER TA"                        nil     )
    (#x001747 "BUHID LETTER DA"                        nil     )
    (#x001748 "BUHID LETTER NA"                        nil     )
    (#x001749 "BUHID LETTER PA"                        nil     )
    (#x00174a "BUHID LETTER BA"                        nil     )
    (#x00174b "BUHID LETTER MA"                        nil     )
    (#x00174c "BUHID LETTER YA"                        nil     )
    (#x00174d "BUHID LETTER RA"                        nil     )
    (#x00174e "BUHID LETTER LA"                        nil     )
    (#x00174f "BUHID LETTER WA"                        nil     )
    (#x001750 "BUHID LETTER SA"                        nil     )
    (#x001751 "BUHID LETTER HA"                        nil     )
    (#x001752 "BUHID VOWEL SIGN I"                     nil     )
    (#x001753 "BUHID VOWEL SIGN U"                     nil     )
    (#x001760 "TAGBANWA LETTER A"                      nil     )
    (#x001761 "TAGBANWA LETTER I"                      nil     )
    (#x001762 "TAGBANWA LETTER U"                      nil     )
    (#x001763 "TAGBANWA LETTER KA"                     nil     )
    (#x001764 "TAGBANWA LETTER GA"                     nil     )
    (#x001765 "TAGBANWA LETTER NGA"                    nil     )
    (#x001766 "TAGBANWA LETTER TA"                     nil     )
    (#x001767 "TAGBANWA LETTER DA"                     nil     )
    (#x001768 "TAGBANWA LETTER NA"                     nil     )
    (#x001769 "TAGBANWA LETTER PA"                     nil     )
    (#x00176a "TAGBANWA LETTER BA"                     nil     )
    (#x00176b "TAGBANWA LETTER MA"                     nil     )
    (#x00176c "TAGBANWA LETTER YA"                     nil     )
    (#x00176e "TAGBANWA LETTER LA"                     nil     )
    (#x00176f "TAGBANWA LETTER WA"                     nil     )
    (#x001770 "TAGBANWA LETTER SA"                     nil     )
    (#x001772 "TAGBANWA VOWEL SIGN I"                  nil     )
    (#x001773 "TAGBANWA VOWEL SIGN U"                  nil     )
    (#x001780 "KHMER LETTER KA"                        nil     )
    (#x001781 "KHMER LETTER KHA"                       nil     )
    (#x001782 "KHMER LETTER KO"                        nil     )
    (#x001783 "KHMER LETTER KHO"                       nil     )
    (#x001784 "KHMER LETTER NGO"                       nil     )
    (#x001785 "KHMER LETTER CA"                        nil     )
    (#x001786 "KHMER LETTER CHA"                       nil     )
    (#x001787 "KHMER LETTER CO"                        nil     )
    (#x001788 "KHMER LETTER CHO"                       nil     )
    (#x001789 "KHMER LETTER NYO"                       nil     )
    (#x00178a "KHMER LETTER DA"                        nil     )
    (#x00178b "KHMER LETTER TTHA"                      nil     )
    (#x00178c "KHMER LETTER DO"                        nil     )
    (#x00178d "KHMER LETTER TTHO"                      nil     )
    (#x00178e "KHMER LETTER NNO"                       nil     )
    (#x00178f "KHMER LETTER TA"                        nil     )
    (#x001790 "KHMER LETTER THA"                       nil     )
    (#x001791 "KHMER LETTER TO"                        nil     )
    (#x001792 "KHMER LETTER THO"                       nil     )
    (#x001793 "KHMER LETTER NO"                        nil     )
    (#x001794 "KHMER LETTER BA"                        nil     )
    (#x001795 "KHMER LETTER PHA"                       nil     )
    (#x001796 "KHMER LETTER PO"                        nil     )
    (#x001797 "KHMER LETTER PHO"                       nil     )
    (#x001798 "KHMER LETTER MO"                        nil     )
    (#x001799 "KHMER LETTER YO"                        nil     )
    (#x00179a "KHMER LETTER RO"                        nil     )
    (#x00179b "KHMER LETTER LO"                        nil     )
    (#x00179c "KHMER LETTER VO"                        nil     )
    (#x00179d "KHMER LETTER SHA"                       nil     )
    (#x00179e "KHMER LETTER SSO"                       nil     )
    (#x00179f "KHMER LETTER SA"                        nil     )
    (#x0017a0 "KHMER LETTER HA"                        nil     )
    (#x0017a1 "KHMER LETTER LA"                        nil     )
    (#x0017a2 "KHMER LETTER QA"                        nil     )
    (#x0017a3 "KHMER INDEPENDENT VOWEL QAQ"            nil     )
    (#x0017a4 "KHMER INDEPENDENT VOWEL QAA"            nil     )
    (#x0017a5 "KHMER INDEPENDENT VOWEL QI"             nil     )
    (#x0017a6 "KHMER INDEPENDENT VOWEL QII"            nil     )
    (#x0017a7 "KHMER INDEPENDENT VOWEL QU"             nil     )
    (#x0017a8 "KHMER INDEPENDENT VOWEL QUK"            nil     )
    (#x0017a9 "KHMER INDEPENDENT VOWEL QUU"            nil     )
    (#x0017aa "KHMER INDEPENDENT VOWEL QUUV"           nil     )
    (#x0017ab "KHMER INDEPENDENT VOWEL RY"             nil     )
    (#x0017ac "KHMER INDEPENDENT VOWEL RYY"            nil     )
    (#x0017ad "KHMER INDEPENDENT VOWEL LY"             nil     )
    (#x0017ae "KHMER INDEPENDENT VOWEL LYY"            nil     )
    (#x0017af "KHMER INDEPENDENT VOWEL QE"             nil     )
    (#x0017b0 "KHMER INDEPENDENT VOWEL QAI"            nil     )
    (#x0017b1 "KHMER INDEPENDENT VOWEL QOO TYPE ONE"   nil     )
    (#x0017b2 "KHMER INDEPENDENT VOWEL QOO TYPE TWO"   nil     )
    (#x0017b3 "KHMER INDEPENDENT VOWEL QAU"            nil     )
    (#x0017b4 "KHMER VOWEL INHERENT AQ"                nil     )
    (#x0017b5 "KHMER VOWEL INHERENT AA"                nil     )
    (#x0017b6 "KHMER VOWEL SIGN AA"                    nil     )
    (#x0017b7 "KHMER VOWEL SIGN I"                     nil     )
    (#x0017b8 "KHMER VOWEL SIGN II"                    nil     )
    (#x0017b9 "KHMER VOWEL SIGN Y"                     nil     )
    (#x0017ba "KHMER VOWEL SIGN YY"                    nil     )
    (#x0017bb "KHMER VOWEL SIGN U"                     nil     )
    (#x0017bc "KHMER VOWEL SIGN UU"                    nil     )
    (#x0017bd "KHMER VOWEL SIGN UA"                    nil     )
    (#x0017be "KHMER VOWEL SIGN OE"                    nil     )
    (#x0017bf "KHMER VOWEL SIGN YA"                    nil     )
    (#x0017c0 "KHMER VOWEL SIGN IE"                    nil     )
    (#x0017c1 "KHMER VOWEL SIGN E"                     nil     )
    (#x0017c2 "KHMER VOWEL SIGN AE"                    nil     )
    (#x0017c3 "KHMER VOWEL SIGN AI"                    nil     )
    (#x0017c4 "KHMER VOWEL SIGN OO"                    nil     )
    (#x0017c5 "KHMER VOWEL SIGN AU"                    nil     )
    (#x0017c6 "KHMER SIGN NIKAHIT"                     nil     )
    (#x0017c7 "KHMER SIGN REAHMUK"                     nil     )
    (#x0017c8 "KHMER SIGN YUUKALEAPINTU"               nil     )
    (#x0017c9 "KHMER SIGN MUUSIKATOAN"                 nil     )
    (#x0017ca "KHMER SIGN TRIISAP"                     nil     )
    (#x0017cb "KHMER SIGN BANTOC"                      nil     )
    (#x0017cc "KHMER SIGN ROBAT"                       nil     )
    (#x0017cd "KHMER SIGN TOANDAKHIAT"                 nil     )
    (#x0017ce "KHMER SIGN KAKABAT"                     nil     )
    (#x0017cf "KHMER SIGN AHSDA"                       nil     )
    (#x0017d0 "KHMER SIGN SAMYOK SANNYA"               nil     )
    (#x0017d1 "KHMER SIGN VIRIAM"                      nil     )
    (#x0017d2 "KHMER SIGN COENG"                       nil     )
    (#x0017d3 "KHMER SIGN BATHAMASAT"                  nil     )
    (#x0017d4 "KHMER SIGN KHAN"                        nil     )
    (#x0017d5 "KHMER SIGN BARIYOOSAN"                  nil     )
    (#x0017d6 "KHMER SIGN CAMNUC PII KUUH"             nil     )
    (#x0017d7 "KHMER SIGN LEK TOO"                     nil     )
    (#x0017d8 "KHMER SIGN BEYYAL"                      nil     )
    (#x0017d9 "KHMER SIGN PHNAEK MUAN"                 nil     )
    (#x0017da "KHMER SIGN KOOMUUT"                     nil     )
    (#x0017db "KHMER CURRENCY SYMBOL RIEL"             nil     )
    (#x0017dc "KHMER SIGN AVAKRAHASANYA"               nil     )
    (#x0017dd "KHMER SIGN ATTHACAN"                    nil     )
    (#x0017e0 "KHMER DIGIT ZERO"                       nil     )
    (#x0017e1 "KHMER DIGIT ONE"                        nil     )
    (#x0017e2 "KHMER DIGIT TWO"                        nil     )
    (#x0017e3 "KHMER DIGIT THREE"                      nil     )
    (#x0017e4 "KHMER DIGIT FOUR"                       nil     )
    (#x0017e5 "KHMER DIGIT FIVE"                       nil     )
    (#x0017e6 "KHMER DIGIT SIX"                        nil     )
    (#x0017e7 "KHMER DIGIT SEVEN"                      nil     )
    (#x0017e8 "KHMER DIGIT EIGHT"                      nil     )
    (#x0017e9 "KHMER DIGIT NINE"                       nil     )
    (#x0017f0 "KHMER SYMBOL LEK ATTAK SON"             nil     )
    (#x0017f1 "KHMER SYMBOL LEK ATTAK MUOY"            nil     )
    (#x0017f2 "KHMER SYMBOL LEK ATTAK PII"             nil     )
    (#x0017f3 "KHMER SYMBOL LEK ATTAK BEI"             nil     )
    (#x0017f4 "KHMER SYMBOL LEK ATTAK BUON"            nil     )
    (#x0017f5 "KHMER SYMBOL LEK ATTAK PRAM"            nil     )
    (#x0017f6 "KHMER SYMBOL LEK ATTAK PRAM-MUOY"       nil     )
    (#x0017f7 "KHMER SYMBOL LEK ATTAK PRAM-PII"        nil     )
    (#x0017f8 "KHMER SYMBOL LEK ATTAK PRAM-BEI"        nil     )
    (#x0017f9 "KHMER SYMBOL LEK ATTAK PRAM-BUON"       nil     )
    (#x001800 "MONGOLIAN BIRGA"                        nil     )
    (#x001801 "MONGOLIAN ELLIPSIS"                     nil     )
    (#x001802 "MONGOLIAN COMMA"                        nil     )
    (#x001803 "MONGOLIAN FULL STOP"                    nil     )
    (#x001804 "MONGOLIAN COLON"                        nil     )
    (#x001805 "MONGOLIAN FOUR DOTS"                    nil     )
    (#x001806 "MONGOLIAN TODO SOFT HYPHEN"             nil     )
    (#x001807 "MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER" nil     )
    (#x001808 "MONGOLIAN MANCHU COMMA"                 nil     )
    (#x001809 "MONGOLIAN MANCHU FULL STOP"             nil     )
    (#x00180a "MONGOLIAN NIRUGU"                       nil     )
    (#x00180b "MONGOLIAN FREE VARIATION SELECTOR ONE"  nil     )
    (#x00180c "MONGOLIAN FREE VARIATION SELECTOR TWO"  nil     )
    (#x00180d "MONGOLIAN FREE VARIATION SELECTOR THREE" nil     )
    (#x00180e "MONGOLIAN VOWEL SEPARATOR"              nil     )
    (#x00180f "MONGOLIAN FREE VARIATION SELECTOR FOUR" nil     )
    (#x001810 "MONGOLIAN DIGIT ZERO"                   nil     )
    (#x001811 "MONGOLIAN DIGIT ONE"                    nil     )
    (#x001812 "MONGOLIAN DIGIT TWO"                    nil     )
    (#x001813 "MONGOLIAN DIGIT THREE"                  nil     )
    (#x001814 "MONGOLIAN DIGIT FOUR"                   nil     )
    (#x001815 "MONGOLIAN DIGIT FIVE"                   nil     )
    (#x001816 "MONGOLIAN DIGIT SIX"                    nil     )
    (#x001817 "MONGOLIAN DIGIT SEVEN"                  nil     )
    (#x001818 "MONGOLIAN DIGIT EIGHT"                  nil     )
    (#x001819 "MONGOLIAN DIGIT NINE"                   nil     )
    (#x001820 "MONGOLIAN LETTER A"                     nil     )
    (#x001821 "MONGOLIAN LETTER E"                     nil     )
    (#x001822 "MONGOLIAN LETTER I"                     nil     )
    (#x001823 "MONGOLIAN LETTER O"                     nil     )
    (#x001824 "MONGOLIAN LETTER U"                     nil     )
    (#x001825 "MONGOLIAN LETTER OE"                    nil     )
    (#x001826 "MONGOLIAN LETTER UE"                    nil     )
    (#x001827 "MONGOLIAN LETTER EE"                    nil     )
    (#x001828 "MONGOLIAN LETTER NA"                    nil     )
    (#x001829 "MONGOLIAN LETTER ANG"                   nil     )
    (#x00182a "MONGOLIAN LETTER BA"                    nil     )
    (#x00182b "MONGOLIAN LETTER PA"                    nil     )
    (#x00182c "MONGOLIAN LETTER QA"                    nil     )
    (#x00182d "MONGOLIAN LETTER GA"                    nil     )
    (#x00182e "MONGOLIAN LETTER MA"                    nil     )
    (#x00182f "MONGOLIAN LETTER LA"                    nil     )
    (#x001830 "MONGOLIAN LETTER SA"                    nil     )
    (#x001831 "MONGOLIAN LETTER SHA"                   nil     )
    (#x001832 "MONGOLIAN LETTER TA"                    nil     )
    (#x001833 "MONGOLIAN LETTER DA"                    nil     )
    (#x001834 "MONGOLIAN LETTER CHA"                   nil     )
    (#x001835 "MONGOLIAN LETTER JA"                    nil     )
    (#x001836 "MONGOLIAN LETTER YA"                    nil     )
    (#x001837 "MONGOLIAN LETTER RA"                    nil     )
    (#x001838 "MONGOLIAN LETTER WA"                    nil     )
    (#x001839 "MONGOLIAN LETTER FA"                    nil     )
    (#x00183a "MONGOLIAN LETTER KA"                    nil     )
    (#x00183b "MONGOLIAN LETTER KHA"                   nil     )
    (#x00183c "MONGOLIAN LETTER TSA"                   nil     )
    (#x00183d "MONGOLIAN LETTER ZA"                    nil     )
    (#x00183e "MONGOLIAN LETTER HAA"                   nil     )
    (#x00183f "MONGOLIAN LETTER ZRA"                   nil     )
    (#x001840 "MONGOLIAN LETTER LHA"                   nil     )
    (#x001841 "MONGOLIAN LETTER ZHI"                   nil     )
    (#x001842 "MONGOLIAN LETTER CHI"                   nil     )
    (#x001843 "MONGOLIAN LETTER TODO LONG VOWEL SIGN"  nil     )
    (#x001844 "MONGOLIAN LETTER TODO E"                nil     )
    (#x001845 "MONGOLIAN LETTER TODO I"                nil     )
    (#x001846 "MONGOLIAN LETTER TODO O"                nil     )
    (#x001847 "MONGOLIAN LETTER TODO U"                nil     )
    (#x001848 "MONGOLIAN LETTER TODO OE"               nil     )
    (#x001849 "MONGOLIAN LETTER TODO UE"               nil     )
    (#x00184a "MONGOLIAN LETTER TODO ANG"              nil     )
    (#x00184b "MONGOLIAN LETTER TODO BA"               nil     )
    (#x00184c "MONGOLIAN LETTER TODO PA"               nil     )
    (#x00184d "MONGOLIAN LETTER TODO QA"               nil     )
    (#x00184e "MONGOLIAN LETTER TODO GA"               nil     )
    (#x00184f "MONGOLIAN LETTER TODO MA"               nil     )
    (#x001850 "MONGOLIAN LETTER TODO TA"               nil     )
    (#x001851 "MONGOLIAN LETTER TODO DA"               nil     )
    (#x001852 "MONGOLIAN LETTER TODO CHA"              nil     )
    (#x001853 "MONGOLIAN LETTER TODO JA"               nil     )
    (#x001854 "MONGOLIAN LETTER TODO TSA"              nil     )
    (#x001855 "MONGOLIAN LETTER TODO YA"               nil     )
    (#x001856 "MONGOLIAN LETTER TODO WA"               nil     )
    (#x001857 "MONGOLIAN LETTER TODO KA"               nil     )
    (#x001858 "MONGOLIAN LETTER TODO GAA"              nil     )
    (#x001859 "MONGOLIAN LETTER TODO HAA"              nil     )
    (#x00185a "MONGOLIAN LETTER TODO JIA"              nil     )
    (#x00185b "MONGOLIAN LETTER TODO NIA"              nil     )
    (#x00185c "MONGOLIAN LETTER TODO DZA"              nil     )
    (#x00185d "MONGOLIAN LETTER SIBE E"                nil     )
    (#x00185e "MONGOLIAN LETTER SIBE I"                nil     )
    (#x00185f "MONGOLIAN LETTER SIBE IY"               nil     )
    (#x001860 "MONGOLIAN LETTER SIBE UE"               nil     )
    (#x001861 "MONGOLIAN LETTER SIBE U"                nil     )
    (#x001862 "MONGOLIAN LETTER SIBE ANG"              nil     )
    (#x001863 "MONGOLIAN LETTER SIBE KA"               nil     )
    (#x001864 "MONGOLIAN LETTER SIBE GA"               nil     )
    (#x001865 "MONGOLIAN LETTER SIBE HA"               nil     )
    (#x001866 "MONGOLIAN LETTER SIBE PA"               nil     )
    (#x001867 "MONGOLIAN LETTER SIBE SHA"              nil     )
    (#x001868 "MONGOLIAN LETTER SIBE TA"               nil     )
    (#x001869 "MONGOLIAN LETTER SIBE DA"               nil     )
    (#x00186a "MONGOLIAN LETTER SIBE JA"               nil     )
    (#x00186b "MONGOLIAN LETTER SIBE FA"               nil     )
    (#x00186c "MONGOLIAN LETTER SIBE GAA"              nil     )
    (#x00186d "MONGOLIAN LETTER SIBE HAA"              nil     )
    (#x00186e "MONGOLIAN LETTER SIBE TSA"              nil     )
    (#x00186f "MONGOLIAN LETTER SIBE ZA"               nil     )
    (#x001870 "MONGOLIAN LETTER SIBE RAA"              nil     )
    (#x001871 "MONGOLIAN LETTER SIBE CHA"              nil     )
    (#x001872 "MONGOLIAN LETTER SIBE ZHA"              nil     )
    (#x001873 "MONGOLIAN LETTER MANCHU I"              nil     )
    (#x001874 "MONGOLIAN LETTER MANCHU KA"             nil     )
    (#x001875 "MONGOLIAN LETTER MANCHU RA"             nil     )
    (#x001876 "MONGOLIAN LETTER MANCHU FA"             nil     )
    (#x001877 "MONGOLIAN LETTER MANCHU ZHA"            nil     )
    (#x001878 "MONGOLIAN LETTER CHA WITH TWO DOTS"     nil     )
    (#x001880 "MONGOLIAN LETTER ALI GALI ANUSVARA ONE" nil     )
    (#x001881 "MONGOLIAN LETTER ALI GALI VISARGA ONE"  nil     )
    (#x001882 "MONGOLIAN LETTER ALI GALI DAMARU"       nil     )
    (#x001883 "MONGOLIAN LETTER ALI GALI UBADAMA"      nil     )
    (#x001884 "MONGOLIAN LETTER ALI GALI INVERTED UBADAMA" nil     )
    (#x001885 "MONGOLIAN LETTER ALI GALI BALUDA"       nil     )
    (#x001886 "MONGOLIAN LETTER ALI GALI THREE BALUDA" nil     )
    (#x001887 "MONGOLIAN LETTER ALI GALI A"            nil     )
    (#x001888 "MONGOLIAN LETTER ALI GALI I"            nil     )
    (#x001889 "MONGOLIAN LETTER ALI GALI KA"           nil     )
    (#x00188a "MONGOLIAN LETTER ALI GALI NGA"          nil     )
    (#x00188b "MONGOLIAN LETTER ALI GALI CA"           nil     )
    (#x00188c "MONGOLIAN LETTER ALI GALI TTA"          nil     )
    (#x00188d "MONGOLIAN LETTER ALI GALI TTHA"         nil     )
    (#x00188e "MONGOLIAN LETTER ALI GALI DDA"          nil     )
    (#x00188f "MONGOLIAN LETTER ALI GALI NNA"          nil     )
    (#x001890 "MONGOLIAN LETTER ALI GALI TA"           nil     )
    (#x001891 "MONGOLIAN LETTER ALI GALI DA"           nil     )
    (#x001892 "MONGOLIAN LETTER ALI GALI PA"           nil     )
    (#x001893 "MONGOLIAN LETTER ALI GALI PHA"          nil     )
    (#x001894 "MONGOLIAN LETTER ALI GALI SSA"          nil     )
    (#x001895 "MONGOLIAN LETTER ALI GALI ZHA"          nil     )
    (#x001896 "MONGOLIAN LETTER ALI GALI ZA"           nil     )
    (#x001897 "MONGOLIAN LETTER ALI GALI AH"           nil     )
    (#x001898 "MONGOLIAN LETTER TODO ALI GALI TA"      nil     )
    (#x001899 "MONGOLIAN LETTER TODO ALI GALI ZHA"     nil     )
    (#x00189a "MONGOLIAN LETTER MANCHU ALI GALI GHA"   nil     )
    (#x00189b "MONGOLIAN LETTER MANCHU ALI GALI NGA"   nil     )
    (#x00189c "MONGOLIAN LETTER MANCHU ALI GALI CA"    nil     )
    (#x00189d "MONGOLIAN LETTER MANCHU ALI GALI JHA"   nil     )
    (#x00189e "MONGOLIAN LETTER MANCHU ALI GALI TTA"   nil     )
    (#x00189f "MONGOLIAN LETTER MANCHU ALI GALI DDHA"  nil     )
    (#x0018a0 "MONGOLIAN LETTER MANCHU ALI GALI TA"    nil     )
    (#x0018a1 "MONGOLIAN LETTER MANCHU ALI GALI DHA"   nil     )
    (#x0018a2 "MONGOLIAN LETTER MANCHU ALI GALI SSA"   nil     )
    (#x0018a3 "MONGOLIAN LETTER MANCHU ALI GALI CYA"   nil     )
    (#x0018a4 "MONGOLIAN LETTER MANCHU ALI GALI ZHA"   nil     )
    (#x0018a5 "MONGOLIAN LETTER MANCHU ALI GALI ZA"    nil     )
    (#x0018a6 "MONGOLIAN LETTER ALI GALI HALF U"       nil     )
    (#x0018a7 "MONGOLIAN LETTER ALI GALI HALF YA"      nil     )
    (#x0018a8 "MONGOLIAN LETTER MANCHU ALI GALI BHA"   nil     )
    (#x0018a9 "MONGOLIAN LETTER ALI GALI DAGALGA"      nil     )
    (#x0018aa "MONGOLIAN LETTER MANCHU ALI GALI LHA"   nil     )
    (#x0018b0 "CANADIAN SYLLABICS OY"                  nil     )
    (#x0018b1 "CANADIAN SYLLABICS AY"                  nil     )
    (#x0018b2 "CANADIAN SYLLABICS AAY"                 nil     )
    (#x0018b3 "CANADIAN SYLLABICS WAY"                 nil     )
    (#x0018b4 "CANADIAN SYLLABICS POY"                 nil     )
    (#x0018b5 "CANADIAN SYLLABICS PAY"                 nil     )
    (#x0018b6 "CANADIAN SYLLABICS PWOY"                nil     )
    (#x0018b7 "CANADIAN SYLLABICS TAY"                 nil     )
    (#x0018b8 "CANADIAN SYLLABICS KAY"                 nil     )
    (#x0018b9 "CANADIAN SYLLABICS KWAY"                nil     )
    (#x0018ba "CANADIAN SYLLABICS MAY"                 nil     )
    (#x0018bb "CANADIAN SYLLABICS NOY"                 nil     )
    (#x0018bc "CANADIAN SYLLABICS NAY"                 nil     )
    (#x0018bd "CANADIAN SYLLABICS LAY"                 nil     )
    (#x0018be "CANADIAN SYLLABICS SOY"                 nil     )
    (#x0018bf "CANADIAN SYLLABICS SAY"                 nil     )
    (#x0018c0 "CANADIAN SYLLABICS SHOY"                nil     )
    (#x0018c1 "CANADIAN SYLLABICS SHAY"                nil     )
    (#x0018c2 "CANADIAN SYLLABICS SHWOY"               nil     )
    (#x0018c3 "CANADIAN SYLLABICS YOY"                 nil     )
    (#x0018c4 "CANADIAN SYLLABICS YAY"                 nil     )
    (#x0018c5 "CANADIAN SYLLABICS RAY"                 nil     )
    (#x0018c6 "CANADIAN SYLLABICS NWI"                 nil     )
    (#x0018c7 "CANADIAN SYLLABICS OJIBWAY NWI"         nil     )
    (#x0018c8 "CANADIAN SYLLABICS NWII"                nil     )
    (#x0018c9 "CANADIAN SYLLABICS OJIBWAY NWII"        nil     )
    (#x0018ca "CANADIAN SYLLABICS NWO"                 nil     )
    (#x0018cb "CANADIAN SYLLABICS OJIBWAY NWO"         nil     )
    (#x0018cc "CANADIAN SYLLABICS NWOO"                nil     )
    (#x0018cd "CANADIAN SYLLABICS OJIBWAY NWOO"        nil     )
    (#x0018ce "CANADIAN SYLLABICS RWEE"                nil     )
    (#x0018cf "CANADIAN SYLLABICS RWI"                 nil     )
    (#x0018d0 "CANADIAN SYLLABICS RWII"                nil     )
    (#x0018d1 "CANADIAN SYLLABICS RWO"                 nil     )
    (#x0018d2 "CANADIAN SYLLABICS RWOO"                nil     )
    (#x0018d3 "CANADIAN SYLLABICS RWA"                 nil     )
    (#x0018d4 "CANADIAN SYLLABICS OJIBWAY P"           nil     )
    (#x0018d5 "CANADIAN SYLLABICS OJIBWAY T"           nil     )
    (#x0018d6 "CANADIAN SYLLABICS OJIBWAY K"           nil     )
    (#x0018d7 "CANADIAN SYLLABICS OJIBWAY C"           nil     )
    (#x0018d8 "CANADIAN SYLLABICS OJIBWAY M"           nil     )
    (#x0018d9 "CANADIAN SYLLABICS OJIBWAY N"           nil     )
    (#x0018da "CANADIAN SYLLABICS OJIBWAY S"           nil     )
    (#x0018db "CANADIAN SYLLABICS OJIBWAY SH"          nil     )
    (#x0018dc "CANADIAN SYLLABICS EASTERN W"           nil     )
    (#x0018dd "CANADIAN SYLLABICS WESTERN W"           nil     )
    (#x0018de "CANADIAN SYLLABICS FINAL SMALL RING"    nil     )
    (#x0018df "CANADIAN SYLLABICS FINAL RAISED DOT"    nil     )
    (#x0018e0 "CANADIAN SYLLABICS R-CREE RWE"          nil     )
    (#x0018e1 "CANADIAN SYLLABICS WEST-CREE LOO"       nil     )
    (#x0018e2 "CANADIAN SYLLABICS WEST-CREE LAA"       nil     )
    (#x0018e3 "CANADIAN SYLLABICS THWE"                nil     )
    (#x0018e4 "CANADIAN SYLLABICS THWA"                nil     )
    (#x0018e5 "CANADIAN SYLLABICS TTHWE"               nil     )
    (#x0018e6 "CANADIAN SYLLABICS TTHOO"               nil     )
    (#x0018e7 "CANADIAN SYLLABICS TTHAA"               nil     )
    (#x0018e8 "CANADIAN SYLLABICS TLHWE"               nil     )
    (#x0018e9 "CANADIAN SYLLABICS TLHOO"               nil     )
    (#x0018ea "CANADIAN SYLLABICS SAYISI SHWE"         nil     )
    (#x0018eb "CANADIAN SYLLABICS SAYISI SHOO"         nil     )
    (#x0018ec "CANADIAN SYLLABICS SAYISI HOO"          nil     )
    (#x0018ed "CANADIAN SYLLABICS CARRIER GWU"         nil     )
    (#x0018ee "CANADIAN SYLLABICS CARRIER DENE GEE"    nil     )
    (#x0018ef "CANADIAN SYLLABICS CARRIER GAA"         nil     )
    (#x0018f0 "CANADIAN SYLLABICS CARRIER GWA"         nil     )
    (#x0018f1 "CANADIAN SYLLABICS SAYISI JUU"          nil     )
    (#x0018f2 "CANADIAN SYLLABICS CARRIER JWA"         nil     )
    (#x0018f3 "CANADIAN SYLLABICS BEAVER DENE L"       nil     )
    (#x0018f4 "CANADIAN SYLLABICS BEAVER DENE R"       nil     )
    (#x0018f5 "CANADIAN SYLLABICS CARRIER DENTAL S"    nil     )
    (#x001900 "LIMBU VOWEL-CARRIER LETTER"             nil     )
    (#x001901 "LIMBU LETTER KA"                        nil     )
    (#x001902 "LIMBU LETTER KHA"                       nil     )
    (#x001903 "LIMBU LETTER GA"                        nil     )
    (#x001904 "LIMBU LETTER GHA"                       nil     )
    (#x001905 "LIMBU LETTER NGA"                       nil     )
    (#x001906 "LIMBU LETTER CA"                        nil     )
    (#x001907 "LIMBU LETTER CHA"                       nil     )
    (#x001908 "LIMBU LETTER JA"                        nil     )
    (#x001909 "LIMBU LETTER JHA"                       nil     )
    (#x00190a "LIMBU LETTER YAN"                       nil     )
    (#x00190b "LIMBU LETTER TA"                        nil     )
    (#x00190c "LIMBU LETTER THA"                       nil     )
    (#x00190d "LIMBU LETTER DA"                        nil     )
    (#x00190e "LIMBU LETTER DHA"                       nil     )
    (#x00190f "LIMBU LETTER NA"                        nil     )
    (#x001910 "LIMBU LETTER PA"                        nil     )
    (#x001911 "LIMBU LETTER PHA"                       nil     )
    (#x001912 "LIMBU LETTER BA"                        nil     )
    (#x001913 "LIMBU LETTER BHA"                       nil     )
    (#x001914 "LIMBU LETTER MA"                        nil     )
    (#x001915 "LIMBU LETTER YA"                        nil     )
    (#x001916 "LIMBU LETTER RA"                        nil     )
    (#x001917 "LIMBU LETTER LA"                        nil     )
    (#x001918 "LIMBU LETTER WA"                        nil     )
    (#x001919 "LIMBU LETTER SHA"                       nil     )
    (#x00191a "LIMBU LETTER SSA"                       nil     )
    (#x00191b "LIMBU LETTER SA"                        nil     )
    (#x00191c "LIMBU LETTER HA"                        nil     )
    (#x00191d "LIMBU LETTER GYAN"                      nil     )
    (#x00191e "LIMBU LETTER TRA"                       nil     )
    (#x001920 "LIMBU VOWEL SIGN A"                     nil     )
    (#x001921 "LIMBU VOWEL SIGN I"                     nil     )
    (#x001922 "LIMBU VOWEL SIGN U"                     nil     )
    (#x001923 "LIMBU VOWEL SIGN EE"                    nil     )
    (#x001924 "LIMBU VOWEL SIGN AI"                    nil     )
    (#x001925 "LIMBU VOWEL SIGN OO"                    nil     )
    (#x001926 "LIMBU VOWEL SIGN AU"                    nil     )
    (#x001927 "LIMBU VOWEL SIGN E"                     nil     )
    (#x001928 "LIMBU VOWEL SIGN O"                     nil     )
    (#x001929 "LIMBU SUBJOINED LETTER YA"              nil     )
    (#x00192a "LIMBU SUBJOINED LETTER RA"              nil     )
    (#x00192b "LIMBU SUBJOINED LETTER WA"              nil     )
    (#x001930 "LIMBU SMALL LETTER KA"                  nil     )
    (#x001931 "LIMBU SMALL LETTER NGA"                 nil     )
    (#x001932 "LIMBU SMALL LETTER ANUSVARA"            nil     )
    (#x001933 "LIMBU SMALL LETTER TA"                  nil     )
    (#x001934 "LIMBU SMALL LETTER NA"                  nil     )
    (#x001935 "LIMBU SMALL LETTER PA"                  nil     )
    (#x001936 "LIMBU SMALL LETTER MA"                  nil     )
    (#x001937 "LIMBU SMALL LETTER RA"                  nil     )
    (#x001938 "LIMBU SMALL LETTER LA"                  nil     )
    (#x001939 "LIMBU SIGN MUKPHRENG"                   nil     )
    (#x00193a "LIMBU SIGN KEMPHRENG"                   nil     )
    (#x00193b "LIMBU SIGN SA-I"                        nil     )
    (#x001940 "LIMBU SIGN LOO"                         nil     )
    (#x001944 "LIMBU EXCLAMATION MARK"                 nil     )
    (#x001945 "LIMBU QUESTION MARK"                    nil     )
    (#x001946 "LIMBU DIGIT ZERO"                       nil     )
    (#x001947 "LIMBU DIGIT ONE"                        nil     )
    (#x001948 "LIMBU DIGIT TWO"                        nil     )
    (#x001949 "LIMBU DIGIT THREE"                      nil     )
    (#x00194a "LIMBU DIGIT FOUR"                       nil     )
    (#x00194b "LIMBU DIGIT FIVE"                       nil     )
    (#x00194c "LIMBU DIGIT SIX"                        nil     )
    (#x00194d "LIMBU DIGIT SEVEN"                      nil     )
    (#x00194e "LIMBU DIGIT EIGHT"                      nil     )
    (#x00194f "LIMBU DIGIT NINE"                       nil     )
    (#x001950 "TAI LE LETTER KA"                       nil     )
    (#x001951 "TAI LE LETTER XA"                       nil     )
    (#x001952 "TAI LE LETTER NGA"                      nil     )
    (#x001953 "TAI LE LETTER TSA"                      nil     )
    (#x001954 "TAI LE LETTER SA"                       nil     )
    (#x001955 "TAI LE LETTER YA"                       nil     )
    (#x001956 "TAI LE LETTER TA"                       nil     )
    (#x001957 "TAI LE LETTER THA"                      nil     )
    (#x001958 "TAI LE LETTER LA"                       nil     )
    (#x001959 "TAI LE LETTER PA"                       nil     )
    (#x00195a "TAI LE LETTER PHA"                      nil     )
    (#x00195b "TAI LE LETTER MA"                       nil     )
    (#x00195c "TAI LE LETTER FA"                       nil     )
    (#x00195d "TAI LE LETTER VA"                       nil     )
    (#x00195e "TAI LE LETTER HA"                       nil     )
    (#x00195f "TAI LE LETTER QA"                       nil     )
    (#x001960 "TAI LE LETTER KHA"                      nil     )
    (#x001961 "TAI LE LETTER TSHA"                     nil     )
    (#x001962 "TAI LE LETTER NA"                       nil     )
    (#x001963 "TAI LE LETTER A"                        nil     )
    (#x001964 "TAI LE LETTER I"                        nil     )
    (#x001965 "TAI LE LETTER EE"                       nil     )
    (#x001966 "TAI LE LETTER EH"                       nil     )
    (#x001967 "TAI LE LETTER U"                        nil     )
    (#x001968 "TAI LE LETTER OO"                       nil     )
    (#x001969 "TAI LE LETTER O"                        nil     )
    (#x00196a "TAI LE LETTER UE"                       nil     )
    (#x00196b "TAI LE LETTER E"                        nil     )
    (#x00196c "TAI LE LETTER AUE"                      nil     )
    (#x00196d "TAI LE LETTER AI"                       nil     )
    (#x001970 "TAI LE LETTER TONE-2"                   nil     )
    (#x001971 "TAI LE LETTER TONE-3"                   nil     )
    (#x001972 "TAI LE LETTER TONE-4"                   nil     )
    (#x001973 "TAI LE LETTER TONE-5"                   nil     )
    (#x001974 "TAI LE LETTER TONE-6"                   nil     )
    (#x001980 "NEW TAI LUE LETTER HIGH QA"             nil     )
    (#x001981 "NEW TAI LUE LETTER LOW QA"              nil     )
    (#x001982 "NEW TAI LUE LETTER HIGH KA"             nil     )
    (#x001983 "NEW TAI LUE LETTER HIGH XA"             nil     )
    (#x001984 "NEW TAI LUE LETTER HIGH NGA"            nil     )
    (#x001985 "NEW TAI LUE LETTER LOW KA"              nil     )
    (#x001986 "NEW TAI LUE LETTER LOW XA"              nil     )
    (#x001987 "NEW TAI LUE LETTER LOW NGA"             nil     )
    (#x001988 "NEW TAI LUE LETTER HIGH TSA"            nil     )
    (#x001989 "NEW TAI LUE LETTER HIGH SA"             nil     )
    (#x00198a "NEW TAI LUE LETTER HIGH YA"             nil     )
    (#x00198b "NEW TAI LUE LETTER LOW TSA"             nil     )
    (#x00198c "NEW TAI LUE LETTER LOW SA"              nil     )
    (#x00198d "NEW TAI LUE LETTER LOW YA"              nil     )
    (#x00198e "NEW TAI LUE LETTER HIGH TA"             nil     )
    (#x00198f "NEW TAI LUE LETTER HIGH THA"            nil     )
    (#x001990 "NEW TAI LUE LETTER HIGH NA"             nil     )
    (#x001991 "NEW TAI LUE LETTER LOW TA"              nil     )
    (#x001992 "NEW TAI LUE LETTER LOW THA"             nil     )
    (#x001993 "NEW TAI LUE LETTER LOW NA"              nil     )
    (#x001994 "NEW TAI LUE LETTER HIGH PA"             nil     )
    (#x001995 "NEW TAI LUE LETTER HIGH PHA"            nil     )
    (#x001996 "NEW TAI LUE LETTER HIGH MA"             nil     )
    (#x001997 "NEW TAI LUE LETTER LOW PA"              nil     )
    (#x001998 "NEW TAI LUE LETTER LOW PHA"             nil     )
    (#x001999 "NEW TAI LUE LETTER LOW MA"              nil     )
    (#x00199a "NEW TAI LUE LETTER HIGH FA"             nil     )
    (#x00199b "NEW TAI LUE LETTER HIGH VA"             nil     )
    (#x00199c "NEW TAI LUE LETTER HIGH LA"             nil     )
    (#x00199d "NEW TAI LUE LETTER LOW FA"              nil     )
    (#x00199e "NEW TAI LUE LETTER LOW VA"              nil     )
    (#x00199f "NEW TAI LUE LETTER LOW LA"              nil     )
    (#x0019a0 "NEW TAI LUE LETTER HIGH HA"             nil     )
    (#x0019a1 "NEW TAI LUE LETTER HIGH DA"             nil     )
    (#x0019a2 "NEW TAI LUE LETTER HIGH BA"             nil     )
    (#x0019a3 "NEW TAI LUE LETTER LOW HA"              nil     )
    (#x0019a4 "NEW TAI LUE LETTER LOW DA"              nil     )
    (#x0019a5 "NEW TAI LUE LETTER LOW BA"              nil     )
    (#x0019a6 "NEW TAI LUE LETTER HIGH KVA"            nil     )
    (#x0019a7 "NEW TAI LUE LETTER HIGH XVA"            nil     )
    (#x0019a8 "NEW TAI LUE LETTER LOW KVA"             nil     )
    (#x0019a9 "NEW TAI LUE LETTER LOW XVA"             nil     )
    (#x0019aa "NEW TAI LUE LETTER HIGH SUA"            nil     )
    (#x0019ab "NEW TAI LUE LETTER LOW SUA"             nil     )
    (#x0019b0 "NEW TAI LUE VOWEL SIGN VOWEL SHORTENER" nil     )
    (#x0019b1 "NEW TAI LUE VOWEL SIGN AA"              nil     )
    (#x0019b2 "NEW TAI LUE VOWEL SIGN II"              nil     )
    (#x0019b3 "NEW TAI LUE VOWEL SIGN U"               nil     )
    (#x0019b4 "NEW TAI LUE VOWEL SIGN UU"              nil     )
    (#x0019b5 "NEW TAI LUE VOWEL SIGN E"               nil     )
    (#x0019b6 "NEW TAI LUE VOWEL SIGN AE"              nil     )
    (#x0019b7 "NEW TAI LUE VOWEL SIGN O"               nil     )
    (#x0019b8 "NEW TAI LUE VOWEL SIGN OA"              nil     )
    (#x0019b9 "NEW TAI LUE VOWEL SIGN UE"              nil     )
    (#x0019ba "NEW TAI LUE VOWEL SIGN AY"              nil     )
    (#x0019bb "NEW TAI LUE VOWEL SIGN AAY"             nil     )
    (#x0019bc "NEW TAI LUE VOWEL SIGN UY"              nil     )
    (#x0019bd "NEW TAI LUE VOWEL SIGN OY"              nil     )
    (#x0019be "NEW TAI LUE VOWEL SIGN OAY"             nil     )
    (#x0019bf "NEW TAI LUE VOWEL SIGN UEY"             nil     )
    (#x0019c0 "NEW TAI LUE VOWEL SIGN IY"              nil     )
    (#x0019c1 "NEW TAI LUE LETTER FINAL V"             nil     )
    (#x0019c2 "NEW TAI LUE LETTER FINAL NG"            nil     )
    (#x0019c3 "NEW TAI LUE LETTER FINAL N"             nil     )
    (#x0019c4 "NEW TAI LUE LETTER FINAL M"             nil     )
    (#x0019c5 "NEW TAI LUE LETTER FINAL K"             nil     )
    (#x0019c6 "NEW TAI LUE LETTER FINAL D"             nil     )
    (#x0019c7 "NEW TAI LUE LETTER FINAL B"             nil     )
    (#x0019c8 "NEW TAI LUE TONE MARK-1"                nil     )
    (#x0019c9 "NEW TAI LUE TONE MARK-2"                nil     )
    (#x0019d0 "NEW TAI LUE DIGIT ZERO"                 nil     )
    (#x0019d1 "NEW TAI LUE DIGIT ONE"                  nil     )
    (#x0019d2 "NEW TAI LUE DIGIT TWO"                  nil     )
    (#x0019d3 "NEW TAI LUE DIGIT THREE"                nil     )
    (#x0019d4 "NEW TAI LUE DIGIT FOUR"                 nil     )
    (#x0019d5 "NEW TAI LUE DIGIT FIVE"                 nil     )
    (#x0019d6 "NEW TAI LUE DIGIT SIX"                  nil     )
    (#x0019d7 "NEW TAI LUE DIGIT SEVEN"                nil     )
    (#x0019d8 "NEW TAI LUE DIGIT EIGHT"                nil     )
    (#x0019d9 "NEW TAI LUE DIGIT NINE"                 nil     )
    (#x0019da "NEW TAI LUE THAM DIGIT ONE"             nil     )
    (#x0019de "NEW TAI LUE SIGN LAE"                   nil     )
    (#x0019df "NEW TAI LUE SIGN LAEV"                  nil     )
    (#x0019e0 "KHMER SYMBOL PATHAMASAT"                nil     )
    (#x0019e1 "KHMER SYMBOL MUOY KOET"                 nil     )
    (#x0019e2 "KHMER SYMBOL PII KOET"                  nil     )
    (#x0019e3 "KHMER SYMBOL BEI KOET"                  nil     )
    (#x0019e4 "KHMER SYMBOL BUON KOET"                 nil     )
    (#x0019e5 "KHMER SYMBOL PRAM KOET"                 nil     )
    (#x0019e6 "KHMER SYMBOL PRAM-MUOY KOET"            nil     )
    (#x0019e7 "KHMER SYMBOL PRAM-PII KOET"             nil     )
    (#x0019e8 "KHMER SYMBOL PRAM-BEI KOET"             nil     )
    (#x0019e9 "KHMER SYMBOL PRAM-BUON KOET"            nil     )
    (#x0019ea "KHMER SYMBOL DAP KOET"                  nil     )
    (#x0019eb "KHMER SYMBOL DAP-MUOY KOET"             nil     )
    (#x0019ec "KHMER SYMBOL DAP-PII KOET"              nil     )
    (#x0019ed "KHMER SYMBOL DAP-BEI KOET"              nil     )
    (#x0019ee "KHMER SYMBOL DAP-BUON KOET"             nil     )
    (#x0019ef "KHMER SYMBOL DAP-PRAM KOET"             nil     )
    (#x0019f0 "KHMER SYMBOL TUTEYASAT"                 nil     )
    (#x0019f1 "KHMER SYMBOL MUOY ROC"                  nil     )
    (#x0019f2 "KHMER SYMBOL PII ROC"                   nil     )
    (#x0019f3 "KHMER SYMBOL BEI ROC"                   nil     )
    (#x0019f4 "KHMER SYMBOL BUON ROC"                  nil     )
    (#x0019f5 "KHMER SYMBOL PRAM ROC"                  nil     )
    (#x0019f6 "KHMER SYMBOL PRAM-MUOY ROC"             nil     )
    (#x0019f7 "KHMER SYMBOL PRAM-PII ROC"              nil     )
    (#x0019f8 "KHMER SYMBOL PRAM-BEI ROC"              nil     )
    (#x0019f9 "KHMER SYMBOL PRAM-BUON ROC"             nil     )
    (#x0019fa "KHMER SYMBOL DAP ROC"                   nil     )
    (#x0019fb "KHMER SYMBOL DAP-MUOY ROC"              nil     )
    (#x0019fc "KHMER SYMBOL DAP-PII ROC"               nil     )
    (#x0019fd "KHMER SYMBOL DAP-BEI ROC"               nil     )
    (#x0019fe "KHMER SYMBOL DAP-BUON ROC"              nil     )
    (#x0019ff "KHMER SYMBOL DAP-PRAM ROC"              nil     )
    (#x001a00 "BUGINESE LETTER KA"                     nil     )
    (#x001a01 "BUGINESE LETTER GA"                     nil     )
    (#x001a02 "BUGINESE LETTER NGA"                    nil     )
    (#x001a03 "BUGINESE LETTER NGKA"                   nil     )
    (#x001a04 "BUGINESE LETTER PA"                     nil     )
    (#x001a05 "BUGINESE LETTER BA"                     nil     )
    (#x001a06 "BUGINESE LETTER MA"                     nil     )
    (#x001a07 "BUGINESE LETTER MPA"                    nil     )
    (#x001a08 "BUGINESE LETTER TA"                     nil     )
    (#x001a09 "BUGINESE LETTER DA"                     nil     )
    (#x001a0a "BUGINESE LETTER NA"                     nil     )
    (#x001a0b "BUGINESE LETTER NRA"                    nil     )
    (#x001a0c "BUGINESE LETTER CA"                     nil     )
    (#x001a0d "BUGINESE LETTER JA"                     nil     )
    (#x001a0e "BUGINESE LETTER NYA"                    nil     )
    (#x001a0f "BUGINESE LETTER NYCA"                   nil     )
    (#x001a10 "BUGINESE LETTER YA"                     nil     )
    (#x001a11 "BUGINESE LETTER RA"                     nil     )
    (#x001a12 "BUGINESE LETTER LA"                     nil     )
    (#x001a13 "BUGINESE LETTER VA"                     nil     )
    (#x001a14 "BUGINESE LETTER SA"                     nil     )
    (#x001a15 "BUGINESE LETTER A"                      nil     )
    (#x001a16 "BUGINESE LETTER HA"                     nil     )
    (#x001a17 "BUGINESE VOWEL SIGN I"                  nil     )
    (#x001a18 "BUGINESE VOWEL SIGN U"                  nil     )
    (#x001a19 "BUGINESE VOWEL SIGN E"                  nil     )
    (#x001a1a "BUGINESE VOWEL SIGN O"                  nil     )
    (#x001a1b "BUGINESE VOWEL SIGN AE"                 nil     )
    (#x001a1e "BUGINESE PALLAWA"                       nil     )
    (#x001a1f "BUGINESE END OF SECTION"                nil     )
    (#x001a20 "TAI THAM LETTER HIGH KA"                nil     )
    (#x001a21 "TAI THAM LETTER HIGH KHA"               nil     )
    (#x001a22 "TAI THAM LETTER HIGH KXA"               nil     )
    (#x001a23 "TAI THAM LETTER LOW KA"                 nil     )
    (#x001a24 "TAI THAM LETTER LOW KXA"                nil     )
    (#x001a25 "TAI THAM LETTER LOW KHA"                nil     )
    (#x001a26 "TAI THAM LETTER NGA"                    nil     )
    (#x001a27 "TAI THAM LETTER HIGH CA"                nil     )
    (#x001a28 "TAI THAM LETTER HIGH CHA"               nil     )
    (#x001a29 "TAI THAM LETTER LOW CA"                 nil     )
    (#x001a2a "TAI THAM LETTER LOW SA"                 nil     )
    (#x001a2b "TAI THAM LETTER LOW CHA"                nil     )
    (#x001a2c "TAI THAM LETTER NYA"                    nil     )
    (#x001a2d "TAI THAM LETTER RATA"                   nil     )
    (#x001a2e "TAI THAM LETTER HIGH RATHA"             nil     )
    (#x001a2f "TAI THAM LETTER DA"                     nil     )
    (#x001a30 "TAI THAM LETTER LOW RATHA"              nil     )
    (#x001a31 "TAI THAM LETTER RANA"                   nil     )
    (#x001a32 "TAI THAM LETTER HIGH TA"                nil     )
    (#x001a33 "TAI THAM LETTER HIGH THA"               nil     )
    (#x001a34 "TAI THAM LETTER LOW TA"                 nil     )
    (#x001a35 "TAI THAM LETTER LOW THA"                nil     )
    (#x001a36 "TAI THAM LETTER NA"                     nil     )
    (#x001a37 "TAI THAM LETTER BA"                     nil     )
    (#x001a38 "TAI THAM LETTER HIGH PA"                nil     )
    (#x001a39 "TAI THAM LETTER HIGH PHA"               nil     )
    (#x001a3a "TAI THAM LETTER HIGH FA"                nil     )
    (#x001a3b "TAI THAM LETTER LOW PA"                 nil     )
    (#x001a3c "TAI THAM LETTER LOW FA"                 nil     )
    (#x001a3d "TAI THAM LETTER LOW PHA"                nil     )
    (#x001a3e "TAI THAM LETTER MA"                     nil     )
    (#x001a3f "TAI THAM LETTER LOW YA"                 nil     )
    (#x001a40 "TAI THAM LETTER HIGH YA"                nil     )
    (#x001a41 "TAI THAM LETTER RA"                     nil     )
    (#x001a42 "TAI THAM LETTER RUE"                    nil     )
    (#x001a43 "TAI THAM LETTER LA"                     nil     )
    (#x001a44 "TAI THAM LETTER LUE"                    nil     )
    (#x001a45 "TAI THAM LETTER WA"                     nil     )
    (#x001a46 "TAI THAM LETTER HIGH SHA"               nil     )
    (#x001a47 "TAI THAM LETTER HIGH SSA"               nil     )
    (#x001a48 "TAI THAM LETTER HIGH SA"                nil     )
    (#x001a49 "TAI THAM LETTER HIGH HA"                nil     )
    (#x001a4a "TAI THAM LETTER LLA"                    nil     )
    (#x001a4b "TAI THAM LETTER A"                      nil     )
    (#x001a4c "TAI THAM LETTER LOW HA"                 nil     )
    (#x001a4d "TAI THAM LETTER I"                      nil     )
    (#x001a4e "TAI THAM LETTER II"                     nil     )
    (#x001a4f "TAI THAM LETTER U"                      nil     )
    (#x001a50 "TAI THAM LETTER UU"                     nil     )
    (#x001a51 "TAI THAM LETTER EE"                     nil     )
    (#x001a52 "TAI THAM LETTER OO"                     nil     )
    (#x001a53 "TAI THAM LETTER LAE"                    nil     )
    (#x001a54 "TAI THAM LETTER GREAT SA"               nil     )
    (#x001a55 "TAI THAM CONSONANT SIGN MEDIAL RA"      nil     )
    (#x001a56 "TAI THAM CONSONANT SIGN MEDIAL LA"      nil     )
    (#x001a57 "TAI THAM CONSONANT SIGN LA TANG LAI"    nil     )
    (#x001a58 "TAI THAM SIGN MAI KANG LAI"             nil     )
    (#x001a59 "TAI THAM CONSONANT SIGN FINAL NGA"      nil     )
    (#x001a5a "TAI THAM CONSONANT SIGN LOW PA"         nil     )
    (#x001a5b "TAI THAM CONSONANT SIGN HIGH RATHA OR LOW PA" nil     )
    (#x001a5c "TAI THAM CONSONANT SIGN MA"             nil     )
    (#x001a5d "TAI THAM CONSONANT SIGN BA"             nil     )
    (#x001a5e "TAI THAM CONSONANT SIGN SA"             nil     )
    (#x001a60 "TAI THAM SIGN SAKOT"                    nil     )
    (#x001a61 "TAI THAM VOWEL SIGN A"                  nil     )
    (#x001a62 "TAI THAM VOWEL SIGN MAI SAT"            nil     )
    (#x001a63 "TAI THAM VOWEL SIGN AA"                 nil     )
    (#x001a64 "TAI THAM VOWEL SIGN TALL AA"            nil     )
    (#x001a65 "TAI THAM VOWEL SIGN I"                  nil     )
    (#x001a66 "TAI THAM VOWEL SIGN II"                 nil     )
    (#x001a67 "TAI THAM VOWEL SIGN UE"                 nil     )
    (#x001a68 "TAI THAM VOWEL SIGN UUE"                nil     )
    (#x001a69 "TAI THAM VOWEL SIGN U"                  nil     )
    (#x001a6a "TAI THAM VOWEL SIGN UU"                 nil     )
    (#x001a6b "TAI THAM VOWEL SIGN O"                  nil     )
    (#x001a6c "TAI THAM VOWEL SIGN OA BELOW"           nil     )
    (#x001a6d "TAI THAM VOWEL SIGN OY"                 nil     )
    (#x001a6e "TAI THAM VOWEL SIGN E"                  nil     )
    (#x001a6f "TAI THAM VOWEL SIGN AE"                 nil     )
    (#x001a70 "TAI THAM VOWEL SIGN OO"                 nil     )
    (#x001a71 "TAI THAM VOWEL SIGN AI"                 nil     )
    (#x001a72 "TAI THAM VOWEL SIGN THAM AI"            nil     )
    (#x001a73 "TAI THAM VOWEL SIGN OA ABOVE"           nil     )
    (#x001a74 "TAI THAM SIGN MAI KANG"                 nil     )
    (#x001a75 "TAI THAM SIGN TONE-1"                   nil     )
    (#x001a76 "TAI THAM SIGN TONE-2"                   nil     )
    (#x001a77 "TAI THAM SIGN KHUEN TONE-3"             nil     )
    (#x001a78 "TAI THAM SIGN KHUEN TONE-4"             nil     )
    (#x001a79 "TAI THAM SIGN KHUEN TONE-5"             nil     )
    (#x001a7a "TAI THAM SIGN RA HAAM"                  nil     )
    (#x001a7b "TAI THAM SIGN MAI SAM"                  nil     )
    (#x001a7c "TAI THAM SIGN KHUEN-LUE KARAN"          nil     )
    (#x001a7f "TAI THAM COMBINING CRYPTOGRAMMIC DOT"   nil     )
    (#x001a80 "TAI THAM HORA DIGIT ZERO"               nil     )
    (#x001a81 "TAI THAM HORA DIGIT ONE"                nil     )
    (#x001a82 "TAI THAM HORA DIGIT TWO"                nil     )
    (#x001a83 "TAI THAM HORA DIGIT THREE"              nil     )
    (#x001a84 "TAI THAM HORA DIGIT FOUR"               nil     )
    (#x001a85 "TAI THAM HORA DIGIT FIVE"               nil     )
    (#x001a86 "TAI THAM HORA DIGIT SIX"                nil     )
    (#x001a87 "TAI THAM HORA DIGIT SEVEN"              nil     )
    (#x001a88 "TAI THAM HORA DIGIT EIGHT"              nil     )
    (#x001a89 "TAI THAM HORA DIGIT NINE"               nil     )
    (#x001a90 "TAI THAM THAM DIGIT ZERO"               nil     )
    (#x001a91 "TAI THAM THAM DIGIT ONE"                nil     )
    (#x001a92 "TAI THAM THAM DIGIT TWO"                nil     )
    (#x001a93 "TAI THAM THAM DIGIT THREE"              nil     )
    (#x001a94 "TAI THAM THAM DIGIT FOUR"               nil     )
    (#x001a95 "TAI THAM THAM DIGIT FIVE"               nil     )
    (#x001a96 "TAI THAM THAM DIGIT SIX"                nil     )
    (#x001a97 "TAI THAM THAM DIGIT SEVEN"              nil     )
    (#x001a98 "TAI THAM THAM DIGIT EIGHT"              nil     )
    (#x001a99 "TAI THAM THAM DIGIT NINE"               nil     )
    (#x001aa0 "TAI THAM SIGN WIANG"                    nil     )
    (#x001aa1 "TAI THAM SIGN WIANGWAAK"                nil     )
    (#x001aa2 "TAI THAM SIGN SAWAN"                    nil     )
    (#x001aa3 "TAI THAM SIGN KEOW"                     nil     )
    (#x001aa4 "TAI THAM SIGN HOY"                      nil     )
    (#x001aa5 "TAI THAM SIGN DOKMAI"                   nil     )
    (#x001aa6 "TAI THAM SIGN REVERSED ROTATED RANA"    nil     )
    (#x001aa7 "TAI THAM SIGN MAI YAMOK"                nil     )
    (#x001aa8 "TAI THAM SIGN KAAN"                     nil     )
    (#x001aa9 "TAI THAM SIGN KAANKUU"                  nil     )
    (#x001aaa "TAI THAM SIGN SATKAAN"                  nil     )
    (#x001aab "TAI THAM SIGN SATKAANKUU"               nil     )
    (#x001aac "TAI THAM SIGN HANG"                     nil     )
    (#x001aad "TAI THAM SIGN CAANG"                    nil     )
    (#x001ab0 "COMBINING DOUBLED CIRCUMFLEX ACCENT"    nil     )
    (#x001ab1 "COMBINING DIAERESIS-RING"               nil     )
    (#x001ab2 "COMBINING INFINITY"                     nil     )
    (#x001ab3 "COMBINING DOWNWARDS ARROW"              nil     )
    (#x001ab4 "COMBINING TRIPLE DOT"                   nil     )
    (#x001ab5 "COMBINING X-X BELOW"                    nil     )
    (#x001ab6 "COMBINING WIGGLY LINE BELOW"            nil     )
    (#x001ab7 "COMBINING OPEN MARK BELOW"              nil     )
    (#x001ab8 "COMBINING DOUBLE OPEN MARK BELOW"       nil     )
    (#x001ab9 "COMBINING LIGHT CENTRALIZATION STROKE BELOW" nil     )
    (#x001aba "COMBINING STRONG CENTRALIZATION STROKE BELOW" nil     )
    (#x001abb "COMBINING PARENTHESES ABOVE"            nil     )
    (#x001abc "COMBINING DOUBLE PARENTHESES ABOVE"     nil     )
    (#x001abd "COMBINING PARENTHESES BELOW"            nil     )
    (#x001abe "COMBINING PARENTHESES OVERLAY"          nil     )
    (#x001abf "COMBINING LATIN SMALL LETTER W BELOW"   nil     )
    (#x001ac0 "COMBINING LATIN SMALL LETTER TURNED W BELOW" nil     )
    (#x001ac1 "COMBINING LEFT PARENTHESIS ABOVE LEFT"  nil     )
    (#x001ac2 "COMBINING RIGHT PARENTHESIS ABOVE RIGHT" nil     )
    (#x001ac3 "COMBINING LEFT PARENTHESIS BELOW LEFT"  nil     )
    (#x001ac4 "COMBINING RIGHT PARENTHESIS BELOW RIGHT" nil     )
    (#x001ac5 "COMBINING SQUARE BRACKETS ABOVE"        nil     )
    (#x001ac6 "COMBINING NUMBER SIGN ABOVE"            nil     )
    (#x001ac7 "COMBINING INVERTED DOUBLE ARCH ABOVE"   nil     )
    (#x001ac8 "COMBINING PLUS SIGN ABOVE"              nil     )
    (#x001ac9 "COMBINING DOUBLE PLUS SIGN ABOVE"       nil     )
    (#x001aca "COMBINING DOUBLE PLUS SIGN BELOW"       nil     )
    (#x001acb "COMBINING TRIPLE ACUTE ACCENT"          nil     )
    (#x001acc "COMBINING LATIN SMALL LETTER INSULAR G" nil     )
    (#x001acd "COMBINING LATIN SMALL LETTER INSULAR R" nil     )
    (#x001ace "COMBINING LATIN SMALL LETTER INSULAR T" nil     )
    (#x001b00 "BALINESE SIGN ULU RICEM"                nil     )
    (#x001b01 "BALINESE SIGN ULU CANDRA"               nil     )
    (#x001b02 "BALINESE SIGN CECEK"                    nil     )
    (#x001b03 "BALINESE SIGN SURANG"                   nil     )
    (#x001b04 "BALINESE SIGN BISAH"                    nil     )
    (#x001b05 "BALINESE LETTER AKARA"                  nil     )
    (#x001b06 "BALINESE LETTER AKARA TEDUNG"           nil     )
    (#x001b07 "BALINESE LETTER IKARA"                  nil     )
    (#x001b08 "BALINESE LETTER IKARA TEDUNG"           nil     )
    (#x001b09 "BALINESE LETTER UKARA"                  nil     )
    (#x001b0a "BALINESE LETTER UKARA TEDUNG"           nil     )
    (#x001b0b "BALINESE LETTER RA REPA"                nil     )
    (#x001b0c "BALINESE LETTER RA REPA TEDUNG"         nil     )
    (#x001b0d "BALINESE LETTER LA LENGA"               nil     )
    (#x001b0e "BALINESE LETTER LA LENGA TEDUNG"        nil     )
    (#x001b0f "BALINESE LETTER EKARA"                  nil     )
    (#x001b10 "BALINESE LETTER AIKARA"                 nil     )
    (#x001b11 "BALINESE LETTER OKARA"                  nil     )
    (#x001b12 "BALINESE LETTER OKARA TEDUNG"           nil     )
    (#x001b13 "BALINESE LETTER KA"                     nil     )
    (#x001b14 "BALINESE LETTER KA MAHAPRANA"           nil     )
    (#x001b15 "BALINESE LETTER GA"                     nil     )
    (#x001b16 "BALINESE LETTER GA GORA"                nil     )
    (#x001b17 "BALINESE LETTER NGA"                    nil     )
    (#x001b18 "BALINESE LETTER CA"                     nil     )
    (#x001b19 "BALINESE LETTER CA LACA"                nil     )
    (#x001b1a "BALINESE LETTER JA"                     nil     )
    (#x001b1b "BALINESE LETTER JA JERA"                nil     )
    (#x001b1c "BALINESE LETTER NYA"                    nil     )
    (#x001b1d "BALINESE LETTER TA LATIK"               nil     )
    (#x001b1e "BALINESE LETTER TA MURDA MAHAPRANA"     nil     )
    (#x001b1f "BALINESE LETTER DA MURDA ALPAPRANA"     nil     )
    (#x001b20 "BALINESE LETTER DA MURDA MAHAPRANA"     nil     )
    (#x001b21 "BALINESE LETTER NA RAMBAT"              nil     )
    (#x001b22 "BALINESE LETTER TA"                     nil     )
    (#x001b23 "BALINESE LETTER TA TAWA"                nil     )
    (#x001b24 "BALINESE LETTER DA"                     nil     )
    (#x001b25 "BALINESE LETTER DA MADU"                nil     )
    (#x001b26 "BALINESE LETTER NA"                     nil     )
    (#x001b27 "BALINESE LETTER PA"                     nil     )
    (#x001b28 "BALINESE LETTER PA KAPAL"               nil     )
    (#x001b29 "BALINESE LETTER BA"                     nil     )
    (#x001b2a "BALINESE LETTER BA KEMBANG"             nil     )
    (#x001b2b "BALINESE LETTER MA"                     nil     )
    (#x001b2c "BALINESE LETTER YA"                     nil     )
    (#x001b2d "BALINESE LETTER RA"                     nil     )
    (#x001b2e "BALINESE LETTER LA"                     nil     )
    (#x001b2f "BALINESE LETTER WA"                     nil     )
    (#x001b30 "BALINESE LETTER SA SAGA"                nil     )
    (#x001b31 "BALINESE LETTER SA SAPA"                nil     )
    (#x001b32 "BALINESE LETTER SA"                     nil     )
    (#x001b33 "BALINESE LETTER HA"                     nil     )
    (#x001b34 "BALINESE SIGN REREKAN"                  nil     )
    (#x001b35 "BALINESE VOWEL SIGN TEDUNG"             nil     )
    (#x001b36 "BALINESE VOWEL SIGN ULU"                nil     )
    (#x001b37 "BALINESE VOWEL SIGN ULU SARI"           nil     )
    (#x001b38 "BALINESE VOWEL SIGN SUKU"               nil     )
    (#x001b39 "BALINESE VOWEL SIGN SUKU ILUT"          nil     )
    (#x001b3a "BALINESE VOWEL SIGN RA REPA"            nil     )
    (#x001b3b "BALINESE VOWEL SIGN RA REPA TEDUNG"     nil     )
    (#x001b3c "BALINESE VOWEL SIGN LA LENGA"           nil     )
    (#x001b3d "BALINESE VOWEL SIGN LA LENGA TEDUNG"    nil     )
    (#x001b3e "BALINESE VOWEL SIGN TALING"             nil     )
    (#x001b3f "BALINESE VOWEL SIGN TALING REPA"        nil     )
    (#x001b40 "BALINESE VOWEL SIGN TALING TEDUNG"      nil     )
    (#x001b41 "BALINESE VOWEL SIGN TALING REPA TEDUNG" nil     )
    (#x001b42 "BALINESE VOWEL SIGN PEPET"              nil     )
    (#x001b43 "BALINESE VOWEL SIGN PEPET TEDUNG"       nil     )
    (#x001b44 "BALINESE ADEG ADEG"                     nil     )
    (#x001b45 "BALINESE LETTER KAF SASAK"              nil     )
    (#x001b46 "BALINESE LETTER KHOT SASAK"             nil     )
    (#x001b47 "BALINESE LETTER TZIR SASAK"             nil     )
    (#x001b48 "BALINESE LETTER EF SASAK"               nil     )
    (#x001b49 "BALINESE LETTER VE SASAK"               nil     )
    (#x001b4a "BALINESE LETTER ZAL SASAK"              nil     )
    (#x001b4b "BALINESE LETTER ASYURA SASAK"           nil     )
    (#x001b4c "BALINESE LETTER ARCHAIC JNYA"           nil     )
    (#x001b50 "BALINESE DIGIT ZERO"                    nil     )
    (#x001b51 "BALINESE DIGIT ONE"                     nil     )
    (#x001b52 "BALINESE DIGIT TWO"                     nil     )
    (#x001b53 "BALINESE DIGIT THREE"                   nil     )
    (#x001b54 "BALINESE DIGIT FOUR"                    nil     )
    (#x001b55 "BALINESE DIGIT FIVE"                    nil     )
    (#x001b56 "BALINESE DIGIT SIX"                     nil     )
    (#x001b57 "BALINESE DIGIT SEVEN"                   nil     )
    (#x001b58 "BALINESE DIGIT EIGHT"                   nil     )
    (#x001b59 "BALINESE DIGIT NINE"                    nil     )
    (#x001b5a "BALINESE PANTI"                         nil     )
    (#x001b5b "BALINESE PAMADA"                        nil     )
    (#x001b5c "BALINESE WINDU"                         nil     )
    (#x001b5d "BALINESE CARIK PAMUNGKAH"               nil     )
    (#x001b5e "BALINESE CARIK SIKI"                    nil     )
    (#x001b5f "BALINESE CARIK PAREREN"                 nil     )
    (#x001b60 "BALINESE PAMENENG"                      nil     )
    (#x001b61 "BALINESE MUSICAL SYMBOL DONG"           nil     )
    (#x001b62 "BALINESE MUSICAL SYMBOL DENG"           nil     )
    (#x001b63 "BALINESE MUSICAL SYMBOL DUNG"           nil     )
    (#x001b64 "BALINESE MUSICAL SYMBOL DANG"           nil     )
    (#x001b65 "BALINESE MUSICAL SYMBOL DANG SURANG"    nil     )
    (#x001b66 "BALINESE MUSICAL SYMBOL DING"           nil     )
    (#x001b67 "BALINESE MUSICAL SYMBOL DAENG"          nil     )
    (#x001b68 "BALINESE MUSICAL SYMBOL DEUNG"          nil     )
    (#x001b69 "BALINESE MUSICAL SYMBOL DAING"          nil     )
    (#x001b6a "BALINESE MUSICAL SYMBOL DANG GEDE"      nil     )
    (#x001b6b "BALINESE MUSICAL SYMBOL COMBINING TEGEH" nil     )
    (#x001b6c "BALINESE MUSICAL SYMBOL COMBINING ENDEP" nil     )
    (#x001b6d "BALINESE MUSICAL SYMBOL COMBINING KEMPUL" nil     )
    (#x001b6e "BALINESE MUSICAL SYMBOL COMBINING KEMPLI" nil     )
    (#x001b6f "BALINESE MUSICAL SYMBOL COMBINING JEGOGAN" nil     )
    (#x001b70 "BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN" nil     )
    (#x001b71 "BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN" nil     )
    (#x001b72 "BALINESE MUSICAL SYMBOL COMBINING BENDE" nil     )
    (#x001b73 "BALINESE MUSICAL SYMBOL COMBINING GONG" nil     )
    (#x001b74 "BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG" nil     )
    (#x001b75 "BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG" nil     )
    (#x001b76 "BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK" nil     )
    (#x001b77 "BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK" nil     )
    (#x001b78 "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG" nil     )
    (#x001b79 "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG" nil     )
    (#x001b7a "BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK" nil     )
    (#x001b7b "BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK" nil     )
    (#x001b7c "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING" nil     )
    (#x001b7d "BALINESE PANTI LANTANG"                 nil     )
    (#x001b7e "BALINESE PAMADA LANTANG"                nil     )
    (#x001b80 "SUNDANESE SIGN PANYECEK"                nil     )
    (#x001b81 "SUNDANESE SIGN PANGLAYAR"               nil     )
    (#x001b82 "SUNDANESE SIGN PANGWISAD"               nil     )
    (#x001b83 "SUNDANESE LETTER A"                     nil     )
    (#x001b84 "SUNDANESE LETTER I"                     nil     )
    (#x001b85 "SUNDANESE LETTER U"                     nil     )
    (#x001b86 "SUNDANESE LETTER AE"                    nil     )
    (#x001b87 "SUNDANESE LETTER O"                     nil     )
    (#x001b88 "SUNDANESE LETTER E"                     nil     )
    (#x001b89 "SUNDANESE LETTER EU"                    nil     )
    (#x001b8a "SUNDANESE LETTER KA"                    nil     )
    (#x001b8b "SUNDANESE LETTER QA"                    nil     )
    (#x001b8c "SUNDANESE LETTER GA"                    nil     )
    (#x001b8d "SUNDANESE LETTER NGA"                   nil     )
    (#x001b8e "SUNDANESE LETTER CA"                    nil     )
    (#x001b8f "SUNDANESE LETTER JA"                    nil     )
    (#x001b90 "SUNDANESE LETTER ZA"                    nil     )
    (#x001b91 "SUNDANESE LETTER NYA"                   nil     )
    (#x001b92 "SUNDANESE LETTER TA"                    nil     )
    (#x001b93 "SUNDANESE LETTER DA"                    nil     )
    (#x001b94 "SUNDANESE LETTER NA"                    nil     )
    (#x001b95 "SUNDANESE LETTER PA"                    nil     )
    (#x001b96 "SUNDANESE LETTER FA"                    nil     )
    (#x001b97 "SUNDANESE LETTER VA"                    nil     )
    (#x001b98 "SUNDANESE LETTER BA"                    nil     )
    (#x001b99 "SUNDANESE LETTER MA"                    nil     )
    (#x001b9a "SUNDANESE LETTER YA"                    nil     )
    (#x001b9b "SUNDANESE LETTER RA"                    nil     )
    (#x001b9c "SUNDANESE LETTER LA"                    nil     )
    (#x001b9d "SUNDANESE LETTER WA"                    nil     )
    (#x001b9e "SUNDANESE LETTER SA"                    nil     )
    (#x001b9f "SUNDANESE LETTER XA"                    nil     )
    (#x001ba0 "SUNDANESE LETTER HA"                    nil     )
    (#x001ba1 "SUNDANESE CONSONANT SIGN PAMINGKAL"     nil     )
    (#x001ba2 "SUNDANESE CONSONANT SIGN PANYAKRA"      nil     )
    (#x001ba3 "SUNDANESE CONSONANT SIGN PANYIKU"       nil     )
    (#x001ba4 "SUNDANESE VOWEL SIGN PANGHULU"          nil     )
    (#x001ba5 "SUNDANESE VOWEL SIGN PANYUKU"           nil     )
    (#x001ba6 "SUNDANESE VOWEL SIGN PANAELAENG"        nil     )
    (#x001ba7 "SUNDANESE VOWEL SIGN PANOLONG"          nil     )
    (#x001ba8 "SUNDANESE VOWEL SIGN PAMEPET"           nil     )
    (#x001ba9 "SUNDANESE VOWEL SIGN PANEULEUNG"        nil     )
    (#x001baa "SUNDANESE SIGN PAMAAEH"                 nil     )
    (#x001bab "SUNDANESE SIGN VIRAMA"                  nil     )
    (#x001bac "SUNDANESE CONSONANT SIGN PASANGAN MA"   nil     )
    (#x001bad "SUNDANESE CONSONANT SIGN PASANGAN WA"   nil     )
    (#x001bae "SUNDANESE LETTER KHA"                   nil     )
    (#x001baf "SUNDANESE LETTER SYA"                   nil     )
    (#x001bb0 "SUNDANESE DIGIT ZERO"                   nil     )
    (#x001bb1 "SUNDANESE DIGIT ONE"                    nil     )
    (#x001bb2 "SUNDANESE DIGIT TWO"                    nil     )
    (#x001bb3 "SUNDANESE DIGIT THREE"                  nil     )
    (#x001bb4 "SUNDANESE DIGIT FOUR"                   nil     )
    (#x001bb5 "SUNDANESE DIGIT FIVE"                   nil     )
    (#x001bb6 "SUNDANESE DIGIT SIX"                    nil     )
    (#x001bb7 "SUNDANESE DIGIT SEVEN"                  nil     )
    (#x001bb8 "SUNDANESE DIGIT EIGHT"                  nil     )
    (#x001bb9 "SUNDANESE DIGIT NINE"                   nil     )
    (#x001bba "SUNDANESE AVAGRAHA"                     nil     )
    (#x001bbb "SUNDANESE LETTER REU"                   nil     )
    (#x001bbc "SUNDANESE LETTER LEU"                   nil     )
    (#x001bbd "SUNDANESE LETTER BHA"                   nil     )
    (#x001bbe "SUNDANESE LETTER FINAL K"               nil     )
    (#x001bbf "SUNDANESE LETTER FINAL M"               nil     )
    (#x001bc0 "BATAK LETTER A"                         nil     )
    (#x001bc1 "BATAK LETTER SIMALUNGUN A"              nil     )
    (#x001bc2 "BATAK LETTER HA"                        nil     )
    (#x001bc3 "BATAK LETTER SIMALUNGUN HA"             nil     )
    (#x001bc4 "BATAK LETTER MANDAILING HA"             nil     )
    (#x001bc5 "BATAK LETTER BA"                        nil     )
    (#x001bc6 "BATAK LETTER KARO BA"                   nil     )
    (#x001bc7 "BATAK LETTER PA"                        nil     )
    (#x001bc8 "BATAK LETTER SIMALUNGUN PA"             nil     )
    (#x001bc9 "BATAK LETTER NA"                        nil     )
    (#x001bca "BATAK LETTER MANDAILING NA"             nil     )
    (#x001bcb "BATAK LETTER WA"                        nil     )
    (#x001bcc "BATAK LETTER SIMALUNGUN WA"             nil     )
    (#x001bcd "BATAK LETTER PAKPAK WA"                 nil     )
    (#x001bce "BATAK LETTER GA"                        nil     )
    (#x001bcf "BATAK LETTER SIMALUNGUN GA"             nil     )
    (#x001bd0 "BATAK LETTER JA"                        nil     )
    (#x001bd1 "BATAK LETTER DA"                        nil     )
    (#x001bd2 "BATAK LETTER RA"                        nil     )
    (#x001bd3 "BATAK LETTER SIMALUNGUN RA"             nil     )
    (#x001bd4 "BATAK LETTER MA"                        nil     )
    (#x001bd5 "BATAK LETTER SIMALUNGUN MA"             nil     )
    (#x001bd6 "BATAK LETTER SOUTHERN TA"               nil     )
    (#x001bd7 "BATAK LETTER NORTHERN TA"               nil     )
    (#x001bd8 "BATAK LETTER SA"                        nil     )
    (#x001bd9 "BATAK LETTER SIMALUNGUN SA"             nil     )
    (#x001bda "BATAK LETTER MANDAILING SA"             nil     )
    (#x001bdb "BATAK LETTER YA"                        nil     )
    (#x001bdc "BATAK LETTER SIMALUNGUN YA"             nil     )
    (#x001bdd "BATAK LETTER NGA"                       nil     )
    (#x001bde "BATAK LETTER LA"                        nil     )
    (#x001bdf "BATAK LETTER SIMALUNGUN LA"             nil     )
    (#x001be0 "BATAK LETTER NYA"                       nil     )
    (#x001be1 "BATAK LETTER CA"                        nil     )
    (#x001be2 "BATAK LETTER NDA"                       nil     )
    (#x001be3 "BATAK LETTER MBA"                       nil     )
    (#x001be4 "BATAK LETTER I"                         nil     )
    (#x001be5 "BATAK LETTER U"                         nil     )
    (#x001be6 "BATAK SIGN TOMPI"                       nil     )
    (#x001be7 "BATAK VOWEL SIGN E"                     nil     )
    (#x001be8 "BATAK VOWEL SIGN PAKPAK E"              nil     )
    (#x001be9 "BATAK VOWEL SIGN EE"                    nil     )
    (#x001bea "BATAK VOWEL SIGN I"                     nil     )
    (#x001beb "BATAK VOWEL SIGN KARO I"                nil     )
    (#x001bec "BATAK VOWEL SIGN O"                     nil     )
    (#x001bed "BATAK VOWEL SIGN KARO O"                nil     )
    (#x001bee "BATAK VOWEL SIGN U"                     nil     )
    (#x001bef "BATAK VOWEL SIGN U FOR SIMALUNGUN SA"   nil     )
    (#x001bf0 "BATAK CONSONANT SIGN NG"                nil     )
    (#x001bf1 "BATAK CONSONANT SIGN H"                 nil     )
    (#x001bf2 "BATAK PANGOLAT"                         nil     )
    (#x001bf3 "BATAK PANONGONAN"                       nil     )
    (#x001bfc "BATAK SYMBOL BINDU NA METEK"            nil     )
    (#x001bfd "BATAK SYMBOL BINDU PINARBORAS"          nil     )
    (#x001bfe "BATAK SYMBOL BINDU JUDUL"               nil     )
    (#x001bff "BATAK SYMBOL BINDU PANGOLAT"            nil     )
    (#x001c00 "LEPCHA LETTER KA"                       nil     )
    (#x001c01 "LEPCHA LETTER KLA"                      nil     )
    (#x001c02 "LEPCHA LETTER KHA"                      nil     )
    (#x001c03 "LEPCHA LETTER GA"                       nil     )
    (#x001c04 "LEPCHA LETTER GLA"                      nil     )
    (#x001c05 "LEPCHA LETTER NGA"                      nil     )
    (#x001c06 "LEPCHA LETTER CA"                       nil     )
    (#x001c07 "LEPCHA LETTER CHA"                      nil     )
    (#x001c08 "LEPCHA LETTER JA"                       nil     )
    (#x001c09 "LEPCHA LETTER NYA"                      nil     )
    (#x001c0a "LEPCHA LETTER TA"                       nil     )
    (#x001c0b "LEPCHA LETTER THA"                      nil     )
    (#x001c0c "LEPCHA LETTER DA"                       nil     )
    (#x001c0d "LEPCHA LETTER NA"                       nil     )
    (#x001c0e "LEPCHA LETTER PA"                       nil     )
    (#x001c0f "LEPCHA LETTER PLA"                      nil     )
    (#x001c10 "LEPCHA LETTER PHA"                      nil     )
    (#x001c11 "LEPCHA LETTER FA"                       nil     )
    (#x001c12 "LEPCHA LETTER FLA"                      nil     )
    (#x001c13 "LEPCHA LETTER BA"                       nil     )
    (#x001c14 "LEPCHA LETTER BLA"                      nil     )
    (#x001c15 "LEPCHA LETTER MA"                       nil     )
    (#x001c16 "LEPCHA LETTER MLA"                      nil     )
    (#x001c17 "LEPCHA LETTER TSA"                      nil     )
    (#x001c18 "LEPCHA LETTER TSHA"                     nil     )
    (#x001c19 "LEPCHA LETTER DZA"                      nil     )
    (#x001c1a "LEPCHA LETTER YA"                       nil     )
    (#x001c1b "LEPCHA LETTER RA"                       nil     )
    (#x001c1c "LEPCHA LETTER LA"                       nil     )
    (#x001c1d "LEPCHA LETTER HA"                       nil     )
    (#x001c1e "LEPCHA LETTER HLA"                      nil     )
    (#x001c1f "LEPCHA LETTER VA"                       nil     )
    (#x001c20 "LEPCHA LETTER SA"                       nil     )
    (#x001c21 "LEPCHA LETTER SHA"                      nil     )
    (#x001c22 "LEPCHA LETTER WA"                       nil     )
    (#x001c23 "LEPCHA LETTER A"                        nil     )
    (#x001c24 "LEPCHA SUBJOINED LETTER YA"             nil     )
    (#x001c25 "LEPCHA SUBJOINED LETTER RA"             nil     )
    (#x001c26 "LEPCHA VOWEL SIGN AA"                   nil     )
    (#x001c27 "LEPCHA VOWEL SIGN I"                    nil     )
    (#x001c28 "LEPCHA VOWEL SIGN O"                    nil     )
    (#x001c29 "LEPCHA VOWEL SIGN OO"                   nil     )
    (#x001c2a "LEPCHA VOWEL SIGN U"                    nil     )
    (#x001c2b "LEPCHA VOWEL SIGN UU"                   nil     )
    (#x001c2c "LEPCHA VOWEL SIGN E"                    nil     )
    (#x001c2d "LEPCHA CONSONANT SIGN K"                nil     )
    (#x001c2e "LEPCHA CONSONANT SIGN M"                nil     )
    (#x001c2f "LEPCHA CONSONANT SIGN L"                nil     )
    (#x001c30 "LEPCHA CONSONANT SIGN N"                nil     )
    (#x001c31 "LEPCHA CONSONANT SIGN P"                nil     )
    (#x001c32 "LEPCHA CONSONANT SIGN R"                nil     )
    (#x001c33 "LEPCHA CONSONANT SIGN T"                nil     )
    (#x001c34 "LEPCHA CONSONANT SIGN NYIN-DO"          nil     )
    (#x001c35 "LEPCHA CONSONANT SIGN KANG"             nil     )
    (#x001c36 "LEPCHA SIGN RAN"                        nil     )
    (#x001c37 "LEPCHA SIGN NUKTA"                      nil     )
    (#x001c3b "LEPCHA PUNCTUATION TA-ROL"              nil     )
    (#x001c3c "LEPCHA PUNCTUATION NYET THYOOM TA-ROL"  nil     )
    (#x001c3d "LEPCHA PUNCTUATION CER-WA"              nil     )
    (#x001c3e "LEPCHA PUNCTUATION TSHOOK CER-WA"       nil     )
    (#x001c3f "LEPCHA PUNCTUATION TSHOOK"              nil     )
    (#x001c40 "LEPCHA DIGIT ZERO"                      nil     )
    (#x001c41 "LEPCHA DIGIT ONE"                       nil     )
    (#x001c42 "LEPCHA DIGIT TWO"                       nil     )
    (#x001c43 "LEPCHA DIGIT THREE"                     nil     )
    (#x001c44 "LEPCHA DIGIT FOUR"                      nil     )
    (#x001c45 "LEPCHA DIGIT FIVE"                      nil     )
    (#x001c46 "LEPCHA DIGIT SIX"                       nil     )
    (#x001c47 "LEPCHA DIGIT SEVEN"                     nil     )
    (#x001c48 "LEPCHA DIGIT EIGHT"                     nil     )
    (#x001c49 "LEPCHA DIGIT NINE"                      nil     )
    (#x001c4d "LEPCHA LETTER TTA"                      nil     )
    (#x001c4e "LEPCHA LETTER TTHA"                     nil     )
    (#x001c4f "LEPCHA LETTER DDA"                      nil     )
    (#x001c50 "OL CHIKI DIGIT ZERO"                    nil     )
    (#x001c51 "OL CHIKI DIGIT ONE"                     nil     )
    (#x001c52 "OL CHIKI DIGIT TWO"                     nil     )
    (#x001c53 "OL CHIKI DIGIT THREE"                   nil     )
    (#x001c54 "OL CHIKI DIGIT FOUR"                    nil     )
    (#x001c55 "OL CHIKI DIGIT FIVE"                    nil     )
    (#x001c56 "OL CHIKI DIGIT SIX"                     nil     )
    (#x001c57 "OL CHIKI DIGIT SEVEN"                   nil     )
    (#x001c58 "OL CHIKI DIGIT EIGHT"                   nil     )
    (#x001c59 "OL CHIKI DIGIT NINE"                    nil     )
    (#x001c5a "OL CHIKI LETTER LA"                     nil     )
    (#x001c5b "OL CHIKI LETTER AT"                     nil     )
    (#x001c5c "OL CHIKI LETTER AG"                     nil     )
    (#x001c5d "OL CHIKI LETTER ANG"                    nil     )
    (#x001c5e "OL CHIKI LETTER AL"                     nil     )
    (#x001c5f "OL CHIKI LETTER LAA"                    nil     )
    (#x001c60 "OL CHIKI LETTER AAK"                    nil     )
    (#x001c61 "OL CHIKI LETTER AAJ"                    nil     )
    (#x001c62 "OL CHIKI LETTER AAM"                    nil     )
    (#x001c63 "OL CHIKI LETTER AAW"                    nil     )
    (#x001c64 "OL CHIKI LETTER LI"                     nil     )
    (#x001c65 "OL CHIKI LETTER IS"                     nil     )
    (#x001c66 "OL CHIKI LETTER IH"                     nil     )
    (#x001c67 "OL CHIKI LETTER INY"                    nil     )
    (#x001c68 "OL CHIKI LETTER IR"                     nil     )
    (#x001c69 "OL CHIKI LETTER LU"                     nil     )
    (#x001c6a "OL CHIKI LETTER UC"                     nil     )
    (#x001c6b "OL CHIKI LETTER UD"                     nil     )
    (#x001c6c "OL CHIKI LETTER UNN"                    nil     )
    (#x001c6d "OL CHIKI LETTER UY"                     nil     )
    (#x001c6e "OL CHIKI LETTER LE"                     nil     )
    (#x001c6f "OL CHIKI LETTER EP"                     nil     )
    (#x001c70 "OL CHIKI LETTER EDD"                    nil     )
    (#x001c71 "OL CHIKI LETTER EN"                     nil     )
    (#x001c72 "OL CHIKI LETTER ERR"                    nil     )
    (#x001c73 "OL CHIKI LETTER LO"                     nil     )
    (#x001c74 "OL CHIKI LETTER OTT"                    nil     )
    (#x001c75 "OL CHIKI LETTER OB"                     nil     )
    (#x001c76 "OL CHIKI LETTER OV"                     nil     )
    (#x001c77 "OL CHIKI LETTER OH"                     nil     )
    (#x001c78 "OL CHIKI MU TTUDDAG"                    nil     )
    (#x001c79 "OL CHIKI GAAHLAA TTUDDAAG"              nil     )
    (#x001c7a "OL CHIKI MU-GAAHLAA TTUDDAAG"           nil     )
    (#x001c7b "OL CHIKI RELAA"                         nil     )
    (#x001c7c "OL CHIKI PHAARKAA"                      nil     )
    (#x001c7d "OL CHIKI AHAD"                          nil     )
    (#x001c7e "OL CHIKI PUNCTUATION MUCAAD"            nil     )
    (#x001c7f "OL CHIKI PUNCTUATION DOUBLE MUCAAD"     nil     )
    (#x001c80 "CYRILLIC SMALL LETTER ROUNDED VE"       nil     )
    (#x001c81 "CYRILLIC SMALL LETTER LONG-LEGGED DE"   nil     )
    (#x001c82 "CYRILLIC SMALL LETTER NARROW O"         nil     )
    (#x001c83 "CYRILLIC SMALL LETTER WIDE ES"          nil     )
    (#x001c84 "CYRILLIC SMALL LETTER TALL TE"          nil     )
    (#x001c85 "CYRILLIC SMALL LETTER THREE-LEGGED TE"  nil     )
    (#x001c86 "CYRILLIC SMALL LETTER TALL HARD SIGN"   nil     )
    (#x001c87 "CYRILLIC SMALL LETTER TALL YAT"         nil     )
    (#x001c88 "CYRILLIC SMALL LETTER UNBLENDED UK"     nil     )
    (#x001c90 "GEORGIAN MTAVRULI CAPITAL LETTER AN"    nil     )
    (#x001c91 "GEORGIAN MTAVRULI CAPITAL LETTER BAN"   nil     )
    (#x001c92 "GEORGIAN MTAVRULI CAPITAL LETTER GAN"   nil     )
    (#x001c93 "GEORGIAN MTAVRULI CAPITAL LETTER DON"   nil     )
    (#x001c94 "GEORGIAN MTAVRULI CAPITAL LETTER EN"    nil     )
    (#x001c95 "GEORGIAN MTAVRULI CAPITAL LETTER VIN"   nil     )
    (#x001c96 "GEORGIAN MTAVRULI CAPITAL LETTER ZEN"   nil     )
    (#x001c97 "GEORGIAN MTAVRULI CAPITAL LETTER TAN"   nil     )
    (#x001c98 "GEORGIAN MTAVRULI CAPITAL LETTER IN"    nil     )
    (#x001c99 "GEORGIAN MTAVRULI CAPITAL LETTER KAN"   nil     )
    (#x001c9a "GEORGIAN MTAVRULI CAPITAL LETTER LAS"   nil     )
    (#x001c9b "GEORGIAN MTAVRULI CAPITAL LETTER MAN"   nil     )
    (#x001c9c "GEORGIAN MTAVRULI CAPITAL LETTER NAR"   nil     )
    (#x001c9d "GEORGIAN MTAVRULI CAPITAL LETTER ON"    nil     )
    (#x001c9e "GEORGIAN MTAVRULI CAPITAL LETTER PAR"   nil     )
    (#x001c9f "GEORGIAN MTAVRULI CAPITAL LETTER ZHAR"  nil     )
    (#x001ca0 "GEORGIAN MTAVRULI CAPITAL LETTER RAE"   nil     )
    (#x001ca1 "GEORGIAN MTAVRULI CAPITAL LETTER SAN"   nil     )
    (#x001ca2 "GEORGIAN MTAVRULI CAPITAL LETTER TAR"   nil     )
    (#x001ca3 "GEORGIAN MTAVRULI CAPITAL LETTER UN"    nil     )
    (#x001ca4 "GEORGIAN MTAVRULI CAPITAL LETTER PHAR"  nil     )
    (#x001ca5 "GEORGIAN MTAVRULI CAPITAL LETTER KHAR"  nil     )
    (#x001ca6 "GEORGIAN MTAVRULI CAPITAL LETTER GHAN"  nil     )
    (#x001ca7 "GEORGIAN MTAVRULI CAPITAL LETTER QAR"   nil     )
    (#x001ca8 "GEORGIAN MTAVRULI CAPITAL LETTER SHIN"  nil     )
    (#x001ca9 "GEORGIAN MTAVRULI CAPITAL LETTER CHIN"  nil     )
    (#x001caa "GEORGIAN MTAVRULI CAPITAL LETTER CAN"   nil     )
    (#x001cab "GEORGIAN MTAVRULI CAPITAL LETTER JIL"   nil     )
    (#x001cac "GEORGIAN MTAVRULI CAPITAL LETTER CIL"   nil     )
    (#x001cad "GEORGIAN MTAVRULI CAPITAL LETTER CHAR"  nil     )
    (#x001cae "GEORGIAN MTAVRULI CAPITAL LETTER XAN"   nil     )
    (#x001caf "GEORGIAN MTAVRULI CAPITAL LETTER JHAN"  nil     )
    (#x001cb0 "GEORGIAN MTAVRULI CAPITAL LETTER HAE"   nil     )
    (#x001cb1 "GEORGIAN MTAVRULI CAPITAL LETTER HE"    nil     )
    (#x001cb2 "GEORGIAN MTAVRULI CAPITAL LETTER HIE"   nil     )
    (#x001cb3 "GEORGIAN MTAVRULI CAPITAL LETTER WE"    nil     )
    (#x001cb4 "GEORGIAN MTAVRULI CAPITAL LETTER HAR"   nil     )
    (#x001cb5 "GEORGIAN MTAVRULI CAPITAL LETTER HOE"   nil     )
    (#x001cb6 "GEORGIAN MTAVRULI CAPITAL LETTER FI"    nil     )
    (#x001cb7 "GEORGIAN MTAVRULI CAPITAL LETTER YN"    nil     )
    (#x001cb8 "GEORGIAN MTAVRULI CAPITAL LETTER ELIFI" nil     )
    (#x001cb9 "GEORGIAN MTAVRULI CAPITAL LETTER TURNED GAN" nil     )
    (#x001cba "GEORGIAN MTAVRULI CAPITAL LETTER AIN"   nil     )
    (#x001cbd "GEORGIAN MTAVRULI CAPITAL LETTER AEN"   nil     )
    (#x001cbe "GEORGIAN MTAVRULI CAPITAL LETTER HARD SIGN" nil     )
    (#x001cbf "GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN" nil     )
    (#x001cc0 "SUNDANESE PUNCTUATION BINDU SURYA"      nil     )
    (#x001cc1 "SUNDANESE PUNCTUATION BINDU PANGLONG"   nil     )
    (#x001cc2 "SUNDANESE PUNCTUATION BINDU PURNAMA"    nil     )
    (#x001cc3 "SUNDANESE PUNCTUATION BINDU CAKRA"      nil     )
    (#x001cc4 "SUNDANESE PUNCTUATION BINDU LEU SATANGA" nil     )
    (#x001cc5 "SUNDANESE PUNCTUATION BINDU KA SATANGA" nil     )
    (#x001cc6 "SUNDANESE PUNCTUATION BINDU DA SATANGA" nil     )
    (#x001cc7 "SUNDANESE PUNCTUATION BINDU BA SATANGA" nil     )
    (#x001cd0 "VEDIC TONE KARSHANA"                    nil     )
    (#x001cd1 "VEDIC TONE SHARA"                       nil     )
    (#x001cd2 "VEDIC TONE PRENKHA"                     nil     )
    (#x001cd3 "VEDIC SIGN NIHSHVASA"                   nil     )
    (#x001cd4 "VEDIC SIGN YAJURVEDIC MIDLINE SVARITA"  nil     )
    (#x001cd5 "VEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITA" nil     )
    (#x001cd6 "VEDIC TONE YAJURVEDIC INDEPENDENT SVARITA" nil     )
    (#x001cd7 "VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA" nil     )
    (#x001cd8 "VEDIC TONE CANDRA BELOW"                nil     )
    (#x001cd9 "VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDER" nil     )
    (#x001cda "VEDIC TONE DOUBLE SVARITA"              nil     )
    (#x001cdb "VEDIC TONE TRIPLE SVARITA"              nil     )
    (#x001cdc "VEDIC TONE KATHAKA ANUDATTA"            nil     )
    (#x001cdd "VEDIC TONE DOT BELOW"                   nil     )
    (#x001cde "VEDIC TONE TWO DOTS BELOW"              nil     )
    (#x001cdf "VEDIC TONE THREE DOTS BELOW"            nil     )
    (#x001ce0 "VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA" nil     )
    (#x001ce1 "VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA" nil     )
    (#x001ce2 "VEDIC SIGN VISARGA SVARITA"             nil     )
    (#x001ce3 "VEDIC SIGN VISARGA UDATTA"              nil     )
    (#x001ce4 "VEDIC SIGN REVERSED VISARGA UDATTA"     nil     )
    (#x001ce5 "VEDIC SIGN VISARGA ANUDATTA"            nil     )
    (#x001ce6 "VEDIC SIGN REVERSED VISARGA ANUDATTA"   nil     )
    (#x001ce7 "VEDIC SIGN VISARGA UDATTA WITH TAIL"    nil     )
    (#x001ce8 "VEDIC SIGN VISARGA ANUDATTA WITH TAIL"  nil     )
    (#x001ce9 "VEDIC SIGN ANUSVARA ANTARGOMUKHA"       nil     )
    (#x001cea "VEDIC SIGN ANUSVARA BAHIRGOMUKHA"       nil     )
    (#x001ceb "VEDIC SIGN ANUSVARA VAMAGOMUKHA"        nil     )
    (#x001cec "VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL" nil     )
    (#x001ced "VEDIC SIGN TIRYAK"                      nil     )
    (#x001cee "VEDIC SIGN HEXIFORM LONG ANUSVARA"      nil     )
    (#x001cef "VEDIC SIGN LONG ANUSVARA"               nil     )
    (#x001cf0 "VEDIC SIGN RTHANG LONG ANUSVARA"        nil     )
    (#x001cf1 "VEDIC SIGN ANUSVARA UBHAYATO MUKHA"     nil     )
    (#x001cf2 "VEDIC SIGN ARDHAVISARGA"                nil     )
    (#x001cf3 "VEDIC SIGN ROTATED ARDHAVISARGA"        nil     )
    (#x001cf4 "VEDIC TONE CANDRA ABOVE"                nil     )
    (#x001cf5 "VEDIC SIGN JIHVAMULIYA"                 nil     )
    (#x001cf6 "VEDIC SIGN UPADHMANIYA"                 nil     )
    (#x001cf7 "VEDIC SIGN ATIKRAMA"                    nil     )
    (#x001cf8 "VEDIC TONE RING ABOVE"                  nil     )
    (#x001cf9 "VEDIC TONE DOUBLE RING ABOVE"           nil     )
    (#x001cfa "VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA" nil     )
    (#x001d00 "LATIN LETTER SMALL CAPITAL A"           nil     )
    (#x001d01 "LATIN LETTER SMALL CAPITAL AE"          nil     )
    (#x001d02 "LATIN SMALL LETTER TURNED AE"           nil     )
    (#x001d03 "LATIN LETTER SMALL CAPITAL BARRED B"    nil     )
    (#x001d04 "LATIN LETTER SMALL CAPITAL C"           nil     )
    (#x001d05 "LATIN LETTER SMALL CAPITAL D"           nil     )
    (#x001d06 "LATIN LETTER SMALL CAPITAL ETH"         nil     )
    (#x001d07 "LATIN LETTER SMALL CAPITAL E"           nil     )
    (#x001d08 "LATIN SMALL LETTER TURNED OPEN E"       nil     )
    (#x001d09 "LATIN SMALL LETTER TURNED I"            nil     )
    (#x001d0a "LATIN LETTER SMALL CAPITAL J"           nil     )
    (#x001d0b "LATIN LETTER SMALL CAPITAL K"           nil     )
    (#x001d0c "LATIN LETTER SMALL CAPITAL L WITH STROKE" nil     )
    (#x001d0d "LATIN LETTER SMALL CAPITAL M"           nil     )
    (#x001d0e "LATIN LETTER SMALL CAPITAL REVERSED N"  nil     )
    (#x001d0f "LATIN LETTER SMALL CAPITAL O"           nil     )
    (#x001d10 "LATIN LETTER SMALL CAPITAL OPEN O"      nil     )
    (#x001d11 "LATIN SMALL LETTER SIDEWAYS O"          nil     )
    (#x001d12 "LATIN SMALL LETTER SIDEWAYS OPEN O"     nil     )
    (#x001d13 "LATIN SMALL LETTER SIDEWAYS O WITH STROKE" nil     )
    (#x001d14 "LATIN SMALL LETTER TURNED OE"           nil     )
    (#x001d15 "LATIN LETTER SMALL CAPITAL OU"          nil     )
    (#x001d16 "LATIN SMALL LETTER TOP HALF O"          nil     )
    (#x001d17 "LATIN SMALL LETTER BOTTOM HALF O"       nil     )
    (#x001d18 "LATIN LETTER SMALL CAPITAL P"           nil     )
    (#x001d19 "LATIN LETTER SMALL CAPITAL REVERSED R"  nil     )
    (#x001d1a "LATIN LETTER SMALL CAPITAL TURNED R"    nil     )
    (#x001d1b "LATIN LETTER SMALL CAPITAL T"           nil     )
    (#x001d1c "LATIN LETTER SMALL CAPITAL U"           nil     )
    (#x001d1d "LATIN SMALL LETTER SIDEWAYS U"          nil     )
    (#x001d1e "LATIN SMALL LETTER SIDEWAYS DIAERESIZED U" nil     )
    (#x001d1f "LATIN SMALL LETTER SIDEWAYS TURNED M"   nil     )
    (#x001d20 "LATIN LETTER SMALL CAPITAL V"           nil     )
    (#x001d21 "LATIN LETTER SMALL CAPITAL W"           nil     )
    (#x001d22 "LATIN LETTER SMALL CAPITAL Z"           nil     )
    (#x001d23 "LATIN LETTER SMALL CAPITAL EZH"         nil     )
    (#x001d24 "LATIN LETTER VOICED LARYNGEAL SPIRANT"  nil     )
    (#x001d25 "LATIN LETTER AIN"                       nil     )
    (#x001d26 "GREEK LETTER SMALL CAPITAL GAMMA"       nil     )
    (#x001d27 "GREEK LETTER SMALL CAPITAL LAMDA"       nil     )
    (#x001d28 "GREEK LETTER SMALL CAPITAL PI"          nil     )
    (#x001d29 "GREEK LETTER SMALL CAPITAL RHO"         nil     )
    (#x001d2a "GREEK LETTER SMALL CAPITAL PSI"         nil     )
    (#x001d2b "CYRILLIC LETTER SMALL CAPITAL EL"       nil     )
    (#x001d2c "MODIFIER LETTER CAPITAL A"              nil     )
    (#x001d2d "MODIFIER LETTER CAPITAL AE"             nil     )
    (#x001d2e "MODIFIER LETTER CAPITAL B"              nil     )
    (#x001d2f "MODIFIER LETTER CAPITAL BARRED B"       nil     )
    (#x001d30 "MODIFIER LETTER CAPITAL D"              nil     )
    (#x001d31 "MODIFIER LETTER CAPITAL E"              nil     )
    (#x001d32 "MODIFIER LETTER CAPITAL REVERSED E"     nil     )
    (#x001d33 "MODIFIER LETTER CAPITAL G"              nil     )
    (#x001d34 "MODIFIER LETTER CAPITAL H"              nil     )
    (#x001d35 "MODIFIER LETTER CAPITAL I"              nil     )
    (#x001d36 "MODIFIER LETTER CAPITAL J"              nil     )
    (#x001d37 "MODIFIER LETTER CAPITAL K"              nil     )
    (#x001d38 "MODIFIER LETTER CAPITAL L"              nil     )
    (#x001d39 "MODIFIER LETTER CAPITAL M"              nil     )
    (#x001d3a "MODIFIER LETTER CAPITAL N"              nil     )
    (#x001d3b "MODIFIER LETTER CAPITAL REVERSED N"     nil     )
    (#x001d3c "MODIFIER LETTER CAPITAL O"              nil     )
    (#x001d3d "MODIFIER LETTER CAPITAL OU"             nil     )
    (#x001d3e "MODIFIER LETTER CAPITAL P"              nil     )
    (#x001d3f "MODIFIER LETTER CAPITAL R"              nil     )
    (#x001d40 "MODIFIER LETTER CAPITAL T"              nil     )
    (#x001d41 "MODIFIER LETTER CAPITAL U"              nil     )
    (#x001d42 "MODIFIER LETTER CAPITAL W"              nil     )
    (#x001d43 "MODIFIER LETTER SMALL A"                nil     )
    (#x001d44 "MODIFIER LETTER SMALL TURNED A"         nil     )
    (#x001d45 "MODIFIER LETTER SMALL ALPHA"            nil     )
    (#x001d46 "MODIFIER LETTER SMALL TURNED AE"        nil     )
    (#x001d47 "MODIFIER LETTER SMALL B"                nil     )
    (#x001d48 "MODIFIER LETTER SMALL D"                nil     )
    (#x001d49 "MODIFIER LETTER SMALL E"                nil     )
    (#x001d4a "MODIFIER LETTER SMALL SCHWA"            nil     )
    (#x001d4b "MODIFIER LETTER SMALL OPEN E"           nil     )
    (#x001d4c "MODIFIER LETTER SMALL TURNED OPEN E"    nil     )
    (#x001d4d "MODIFIER LETTER SMALL G"                nil     )
    (#x001d4e "MODIFIER LETTER SMALL TURNED I"         nil     )
    (#x001d4f "MODIFIER LETTER SMALL K"                nil     )
    (#x001d50 "MODIFIER LETTER SMALL M"                nil     )
    (#x001d51 "MODIFIER LETTER SMALL ENG"              nil     )
    (#x001d52 "MODIFIER LETTER SMALL O"                nil     )
    (#x001d53 "MODIFIER LETTER SMALL OPEN O"           nil     )
    (#x001d54 "MODIFIER LETTER SMALL TOP HALF O"       nil     )
    (#x001d55 "MODIFIER LETTER SMALL BOTTOM HALF O"    nil     )
    (#x001d56 "MODIFIER LETTER SMALL P"                nil     )
    (#x001d57 "MODIFIER LETTER SMALL T"                nil     )
    (#x001d58 "MODIFIER LETTER SMALL U"                nil     )
    (#x001d59 "MODIFIER LETTER SMALL SIDEWAYS U"       nil     )
    (#x001d5a "MODIFIER LETTER SMALL TURNED M"         nil     )
    (#x001d5b "MODIFIER LETTER SMALL V"                nil     )
    (#x001d5c "MODIFIER LETTER SMALL AIN"              nil     )
    (#x001d5d "MODIFIER LETTER SMALL BETA"             nil     )
    (#x001d5e "MODIFIER LETTER SMALL GREEK GAMMA"      nil     )
    (#x001d5f "MODIFIER LETTER SMALL DELTA"            nil     )
    (#x001d60 "MODIFIER LETTER SMALL GREEK PHI"        nil     )
    (#x001d61 "MODIFIER LETTER SMALL CHI"              nil     )
    (#x001d62 "LATIN SUBSCRIPT SMALL LETTER I"         nil     )
    (#x001d63 "LATIN SUBSCRIPT SMALL LETTER R"         nil     )
    (#x001d64 "LATIN SUBSCRIPT SMALL LETTER U"         nil     )
    (#x001d65 "LATIN SUBSCRIPT SMALL LETTER V"         nil     )
    (#x001d66 "GREEK SUBSCRIPT SMALL LETTER BETA"      nil     )
    (#x001d67 "GREEK SUBSCRIPT SMALL LETTER GAMMA"     nil     )
    (#x001d68 "GREEK SUBSCRIPT SMALL LETTER RHO"       nil     )
    (#x001d69 "GREEK SUBSCRIPT SMALL LETTER PHI"       nil     )
    (#x001d6a "GREEK SUBSCRIPT SMALL LETTER CHI"       nil     )
    (#x001d6b "LATIN SMALL LETTER UE"                  nil     )
    (#x001d6c "LATIN SMALL LETTER B WITH MIDDLE TILDE" nil     )
    (#x001d6d "LATIN SMALL LETTER D WITH MIDDLE TILDE" nil     )
    (#x001d6e "LATIN SMALL LETTER F WITH MIDDLE TILDE" nil     )
    (#x001d6f "LATIN SMALL LETTER M WITH MIDDLE TILDE" nil     )
    (#x001d70 "LATIN SMALL LETTER N WITH MIDDLE TILDE" nil     )
    (#x001d71 "LATIN SMALL LETTER P WITH MIDDLE TILDE" nil     )
    (#x001d72 "LATIN SMALL LETTER R WITH MIDDLE TILDE" nil     )
    (#x001d73 "LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE" nil     )
    (#x001d74 "LATIN SMALL LETTER S WITH MIDDLE TILDE" nil     )
    (#x001d75 "LATIN SMALL LETTER T WITH MIDDLE TILDE" nil     )
    (#x001d76 "LATIN SMALL LETTER Z WITH MIDDLE TILDE" nil     )
    (#x001d77 "LATIN SMALL LETTER TURNED G"            nil     )
    (#x001d78 "MODIFIER LETTER CYRILLIC EN"            nil     )
    (#x001d79 "LATIN SMALL LETTER INSULAR G"           nil     )
    (#x001d7a "LATIN SMALL LETTER TH WITH STRIKETHROUGH" nil     )
    (#x001d7b "LATIN SMALL CAPITAL LETTER I WITH STROKE" nil     )
    (#x001d7c "LATIN SMALL LETTER IOTA WITH STROKE"    nil     )
    (#x001d7d "LATIN SMALL LETTER P WITH STROKE"       nil     )
    (#x001d7e "LATIN SMALL CAPITAL LETTER U WITH STROKE" nil     )
    (#x001d7f "LATIN SMALL LETTER UPSILON WITH STROKE" nil     )
    (#x001d80 "LATIN SMALL LETTER B WITH PALATAL HOOK" nil     )
    (#x001d81 "LATIN SMALL LETTER D WITH PALATAL HOOK" nil     )
    (#x001d82 "LATIN SMALL LETTER F WITH PALATAL HOOK" nil     )
    (#x001d83 "LATIN SMALL LETTER G WITH PALATAL HOOK" nil     )
    (#x001d84 "LATIN SMALL LETTER K WITH PALATAL HOOK" nil     )
    (#x001d85 "LATIN SMALL LETTER L WITH PALATAL HOOK" nil     )
    (#x001d86 "LATIN SMALL LETTER M WITH PALATAL HOOK" nil     )
    (#x001d87 "LATIN SMALL LETTER N WITH PALATAL HOOK" nil     )
    (#x001d88 "LATIN SMALL LETTER P WITH PALATAL HOOK" nil     )
    (#x001d89 "LATIN SMALL LETTER R WITH PALATAL HOOK" nil     )
    (#x001d8a "LATIN SMALL LETTER S WITH PALATAL HOOK" nil     )
    (#x001d8b "LATIN SMALL LETTER ESH WITH PALATAL HOOK" nil     )
    (#x001d8c "LATIN SMALL LETTER V WITH PALATAL HOOK" nil     )
    (#x001d8d "LATIN SMALL LETTER X WITH PALATAL HOOK" nil     )
    (#x001d8e "LATIN SMALL LETTER Z WITH PALATAL HOOK" nil     )
    (#x001d8f "LATIN SMALL LETTER A WITH RETROFLEX HOOK" nil     )
    (#x001d90 "LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK" nil     )
    (#x001d91 "LATIN SMALL LETTER D WITH HOOK AND TAIL" nil     )
    (#x001d92 "LATIN SMALL LETTER E WITH RETROFLEX HOOK" nil     )
    (#x001d93 "LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK" nil     )
    (#x001d94 "LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK" nil     )
    (#x001d95 "LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK" nil     )
    (#x001d96 "LATIN SMALL LETTER I WITH RETROFLEX HOOK" nil     )
    (#x001d97 "LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK" nil     )
    (#x001d98 "LATIN SMALL LETTER ESH WITH RETROFLEX HOOK" nil     )
    (#x001d99 "LATIN SMALL LETTER U WITH RETROFLEX HOOK" nil     )
    (#x001d9a "LATIN SMALL LETTER EZH WITH RETROFLEX HOOK" nil     )
    (#x001d9b "MODIFIER LETTER SMALL TURNED ALPHA"     nil     )
    (#x001d9c "MODIFIER LETTER SMALL C"                nil     )
    (#x001d9d "MODIFIER LETTER SMALL C WITH CURL"      nil     )
    (#x001d9e "MODIFIER LETTER SMALL ETH"              nil     )
    (#x001d9f "MODIFIER LETTER SMALL REVERSED OPEN E"  nil     )
    (#x001da0 "MODIFIER LETTER SMALL F"                nil     )
    (#x001da1 "MODIFIER LETTER SMALL DOTLESS J WITH STROKE" nil     )
    (#x001da2 "MODIFIER LETTER SMALL SCRIPT G"         nil     )
    (#x001da3 "MODIFIER LETTER SMALL TURNED H"         nil     )
    (#x001da4 "MODIFIER LETTER SMALL I WITH STROKE"    nil     )
    (#x001da5 "MODIFIER LETTER SMALL IOTA"             nil     )
    (#x001da6 "MODIFIER LETTER SMALL CAPITAL I"        nil     )
    (#x001da7 "MODIFIER LETTER SMALL CAPITAL I WITH STROKE" nil     )
    (#x001da8 "MODIFIER LETTER SMALL J WITH CROSSED-TAIL" nil     )
    (#x001da9 "MODIFIER LETTER SMALL L WITH RETROFLEX HOOK" nil     )
    (#x001daa "MODIFIER LETTER SMALL L WITH PALATAL HOOK" nil     )
    (#x001dab "MODIFIER LETTER SMALL CAPITAL L"        nil     )
    (#x001dac "MODIFIER LETTER SMALL M WITH HOOK"      nil     )
    (#x001dad "MODIFIER LETTER SMALL TURNED M WITH LONG LEG" nil     )
    (#x001dae "MODIFIER LETTER SMALL N WITH LEFT HOOK" nil     )
    (#x001daf "MODIFIER LETTER SMALL N WITH RETROFLEX HOOK" nil     )
    (#x001db0 "MODIFIER LETTER SMALL CAPITAL N"        nil     )
    (#x001db1 "MODIFIER LETTER SMALL BARRED O"         nil     )
    (#x001db2 "MODIFIER LETTER SMALL PHI"              nil     )
    (#x001db3 "MODIFIER LETTER SMALL S WITH HOOK"      nil     )
    (#x001db4 "MODIFIER LETTER SMALL ESH"              nil     )
    (#x001db5 "MODIFIER LETTER SMALL T WITH PALATAL HOOK" nil     )
    (#x001db6 "MODIFIER LETTER SMALL U BAR"            nil     )
    (#x001db7 "MODIFIER LETTER SMALL UPSILON"          nil     )
    (#x001db8 "MODIFIER LETTER SMALL CAPITAL U"        nil     )
    (#x001db9 "MODIFIER LETTER SMALL V WITH HOOK"      nil     )
    (#x001dba "MODIFIER LETTER SMALL TURNED V"         nil     )
    (#x001dbb "MODIFIER LETTER SMALL Z"                nil     )
    (#x001dbc "MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK" nil     )
    (#x001dbd "MODIFIER LETTER SMALL Z WITH CURL"      nil     )
    (#x001dbe "MODIFIER LETTER SMALL EZH"              nil     )
    (#x001dbf "MODIFIER LETTER SMALL THETA"            nil     )
    (#x001dc0 "COMBINING DOTTED GRAVE ACCENT"          nil     )
    (#x001dc1 "COMBINING DOTTED ACUTE ACCENT"          nil     )
    (#x001dc2 "COMBINING SNAKE BELOW"                  nil     )
    (#x001dc3 "COMBINING SUSPENSION MARK"              nil     )
    (#x001dc4 "COMBINING MACRON-ACUTE"                 nil     )
    (#x001dc5 "COMBINING GRAVE-MACRON"                 nil     )
    (#x001dc6 "COMBINING MACRON-GRAVE"                 nil     )
    (#x001dc7 "COMBINING ACUTE-MACRON"                 nil     )
    (#x001dc8 "COMBINING GRAVE-ACUTE-GRAVE"            nil     )
    (#x001dc9 "COMBINING ACUTE-GRAVE-ACUTE"            nil     )
    (#x001dca "COMBINING LATIN SMALL LETTER R BELOW"   nil     )
    (#x001dcb "COMBINING BREVE-MACRON"                 nil     )
    (#x001dcc "COMBINING MACRON-BREVE"                 nil     )
    (#x001dcd "COMBINING DOUBLE CIRCUMFLEX ABOVE"      nil     )
    (#x001dce "COMBINING OGONEK ABOVE"                 nil     )
    (#x001dcf "COMBINING ZIGZAG BELOW"                 nil     )
    (#x001dd0 "COMBINING IS BELOW"                     nil     )
    (#x001dd1 "COMBINING UR ABOVE"                     nil     )
    (#x001dd2 "COMBINING US ABOVE"                     nil     )
    (#x001dd3 "COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE" nil     )
    (#x001dd4 "COMBINING LATIN SMALL LETTER AE"        nil     )
    (#x001dd5 "COMBINING LATIN SMALL LETTER AO"        nil     )
    (#x001dd6 "COMBINING LATIN SMALL LETTER AV"        nil     )
    (#x001dd7 "COMBINING LATIN SMALL LETTER C CEDILLA" nil     )
    (#x001dd8 "COMBINING LATIN SMALL LETTER INSULAR D" nil     )
    (#x001dd9 "COMBINING LATIN SMALL LETTER ETH"       nil     )
    (#x001dda "COMBINING LATIN SMALL LETTER G"         nil     )
    (#x001ddb "COMBINING LATIN LETTER SMALL CAPITAL G" nil     )
    (#x001ddc "COMBINING LATIN SMALL LETTER K"         nil     )
    (#x001ddd "COMBINING LATIN SMALL LETTER L"         nil     )
    (#x001dde "COMBINING LATIN LETTER SMALL CAPITAL L" nil     )
    (#x001ddf "COMBINING LATIN LETTER SMALL CAPITAL M" nil     )
    (#x001de0 "COMBINING LATIN SMALL LETTER N"         nil     )
    (#x001de1 "COMBINING LATIN LETTER SMALL CAPITAL N" nil     )
    (#x001de2 "COMBINING LATIN LETTER SMALL CAPITAL R" nil     )
    (#x001de3 "COMBINING LATIN SMALL LETTER R ROTUNDA" nil     )
    (#x001de4 "COMBINING LATIN SMALL LETTER S"         nil     )
    (#x001de5 "COMBINING LATIN SMALL LETTER LONG S"    nil     )
    (#x001de6 "COMBINING LATIN SMALL LETTER Z"         nil     )
    (#x001de7 "COMBINING LATIN SMALL LETTER ALPHA"     nil     )
    (#x001de8 "COMBINING LATIN SMALL LETTER B"         nil     )
    (#x001de9 "COMBINING LATIN SMALL LETTER BETA"      nil     )
    (#x001dea "COMBINING LATIN SMALL LETTER SCHWA"     nil     )
    (#x001deb "COMBINING LATIN SMALL LETTER F"         nil     )
    (#x001dec "COMBINING LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE" nil     )
    (#x001ded "COMBINING LATIN SMALL LETTER O WITH LIGHT CENTRALIZATION STROKE" nil     )
    (#x001dee "COMBINING LATIN SMALL LETTER P"         nil     )
    (#x001def "COMBINING LATIN SMALL LETTER ESH"       nil     )
    (#x001df0 "COMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALIZATION STROKE" nil     )
    (#x001df1 "COMBINING LATIN SMALL LETTER W"         nil     )
    (#x001df2 "COMBINING LATIN SMALL LETTER A WITH DIAERESIS" nil     )
    (#x001df3 "COMBINING LATIN SMALL LETTER O WITH DIAERESIS" nil     )
    (#x001df4 "COMBINING LATIN SMALL LETTER U WITH DIAERESIS" nil     )
    (#x001df5 "COMBINING UP TACK ABOVE"                nil     )
    (#x001df6 "COMBINING KAVYKA ABOVE RIGHT"           nil     )
    (#x001df7 "COMBINING KAVYKA ABOVE LEFT"            nil     )
    (#x001df8 "COMBINING DOT ABOVE LEFT"               nil     )
    (#x001df9 "COMBINING WIDE INVERTED BRIDGE BELOW"   nil     )
    (#x001dfa "COMBINING DOT BELOW LEFT"               nil     )
    (#x001dfb "COMBINING DELETION MARK"                nil     )
    (#x001dfc "COMBINING DOUBLE INVERTED BREVE BELOW"  nil     )
    (#x001dfd "COMBINING ALMOST EQUAL TO BELOW"        nil     )
    (#x001dfe "COMBINING LEFT ARROWHEAD ABOVE"         nil     )
    (#x001dff "COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW" nil     )
    (#x001e00 "LATIN CAPITAL LETTER A WITH RING BELOW" nil     )
    (#x001e01 "LATIN SMALL LETTER A WITH RING BELOW"   nil     )
    (#x001e02 "LATIN CAPITAL LETTER B WITH DOT ABOVE"  nil     )
    (#x001e03 "LATIN SMALL LETTER B WITH DOT ABOVE"    nil     )
    (#x001e04 "LATIN CAPITAL LETTER B WITH DOT BELOW"  nil     )
    (#x001e05 "LATIN SMALL LETTER B WITH DOT BELOW"    nil     )
    (#x001e06 "LATIN CAPITAL LETTER B WITH LINE BELOW" nil     )
    (#x001e07 "LATIN SMALL LETTER B WITH LINE BELOW"   nil     )
    (#x001e08 "LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE" nil     )
    (#x001e09 "LATIN SMALL LETTER C WITH CEDILLA AND ACUTE" nil     )
    (#x001e0a "LATIN CAPITAL LETTER D WITH DOT ABOVE"  nil     )
    (#x001e0b "LATIN SMALL LETTER D WITH DOT ABOVE"    nil     )
    (#x001e0c "LATIN CAPITAL LETTER D WITH DOT BELOW"  nil     )
    (#x001e0d "LATIN SMALL LETTER D WITH DOT BELOW"    nil     )
    (#x001e0e "LATIN CAPITAL LETTER D WITH LINE BELOW" nil     )
    (#x001e0f "LATIN SMALL LETTER D WITH LINE BELOW"   nil     )
    (#x001e10 "LATIN CAPITAL LETTER D WITH CEDILLA"    nil     )
    (#x001e11 "LATIN SMALL LETTER D WITH CEDILLA"      nil     )
    (#x001e12 "LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW" nil     )
    (#x001e13 "LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW" nil     )
    (#x001e14 "LATIN CAPITAL LETTER E WITH MACRON AND GRAVE" nil     )
    (#x001e15 "LATIN SMALL LETTER E WITH MACRON AND GRAVE" nil     )
    (#x001e16 "LATIN CAPITAL LETTER E WITH MACRON AND ACUTE" nil     )
    (#x001e17 "LATIN SMALL LETTER E WITH MACRON AND ACUTE" nil     )
    (#x001e18 "LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW" nil     )
    (#x001e19 "LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW" nil     )
    (#x001e1a "LATIN CAPITAL LETTER E WITH TILDE BELOW" nil     )
    (#x001e1b "LATIN SMALL LETTER E WITH TILDE BELOW"  nil     )
    (#x001e1c "LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE" nil     )
    (#x001e1d "LATIN SMALL LETTER E WITH CEDILLA AND BREVE" nil     )
    (#x001e1e "LATIN CAPITAL LETTER F WITH DOT ABOVE"  nil     )
    (#x001e1f "LATIN SMALL LETTER F WITH DOT ABOVE"    nil     )
    (#x001e20 "LATIN CAPITAL LETTER G WITH MACRON"     nil     )
    (#x001e21 "LATIN SMALL LETTER G WITH MACRON"       nil     )
    (#x001e22 "LATIN CAPITAL LETTER H WITH DOT ABOVE"  nil     )
    (#x001e23 "LATIN SMALL LETTER H WITH DOT ABOVE"    nil     )
    (#x001e24 "LATIN CAPITAL LETTER H WITH DOT BELOW"  nil     )
    (#x001e25 "LATIN SMALL LETTER H WITH DOT BELOW"    nil     )
    (#x001e26 "LATIN CAPITAL LETTER H WITH DIAERESIS"  nil     )
    (#x001e27 "LATIN SMALL LETTER H WITH DIAERESIS"    nil     )
    (#x001e28 "LATIN CAPITAL LETTER H WITH CEDILLA"    nil     )
    (#x001e29 "LATIN SMALL LETTER H WITH CEDILLA"      nil     )
    (#x001e2a "LATIN CAPITAL LETTER H WITH BREVE BELOW" nil     )
    (#x001e2b "LATIN SMALL LETTER H WITH BREVE BELOW"  nil     )
    (#x001e2c "LATIN CAPITAL LETTER I WITH TILDE BELOW" nil     )
    (#x001e2d "LATIN SMALL LETTER I WITH TILDE BELOW"  nil     )
    (#x001e2e "LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE" nil     )
    (#x001e2f "LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE" nil     )
    (#x001e30 "LATIN CAPITAL LETTER K WITH ACUTE"      nil     )
    (#x001e31 "LATIN SMALL LETTER K WITH ACUTE"        nil     )
    (#x001e32 "LATIN CAPITAL LETTER K WITH DOT BELOW"  nil     )
    (#x001e33 "LATIN SMALL LETTER K WITH DOT BELOW"    nil     )
    (#x001e34 "LATIN CAPITAL LETTER K WITH LINE BELOW" nil     )
    (#x001e35 "LATIN SMALL LETTER K WITH LINE BELOW"   nil     )
    (#x001e36 "LATIN CAPITAL LETTER L WITH DOT BELOW"  nil     )
    (#x001e37 "LATIN SMALL LETTER L WITH DOT BELOW"    nil     )
    (#x001e38 "LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON" nil     )
    (#x001e39 "LATIN SMALL LETTER L WITH DOT BELOW AND MACRON" nil     )
    (#x001e3a "LATIN CAPITAL LETTER L WITH LINE BELOW" nil     )
    (#x001e3b "LATIN SMALL LETTER L WITH LINE BELOW"   nil     )
    (#x001e3c "LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW" nil     )
    (#x001e3d "LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW" nil     )
    (#x001e3e "LATIN CAPITAL LETTER M WITH ACUTE"      nil     )
    (#x001e3f "LATIN SMALL LETTER M WITH ACUTE"        nil     )
    (#x001e40 "LATIN CAPITAL LETTER M WITH DOT ABOVE"  nil     )
    (#x001e41 "LATIN SMALL LETTER M WITH DOT ABOVE"    nil     )
    (#x001e42 "LATIN CAPITAL LETTER M WITH DOT BELOW"  nil     )
    (#x001e43 "LATIN SMALL LETTER M WITH DOT BELOW"    nil     )
    (#x001e44 "LATIN CAPITAL LETTER N WITH DOT ABOVE"  nil     )
    (#x001e45 "LATIN SMALL LETTER N WITH DOT ABOVE"    nil     )
    (#x001e46 "LATIN CAPITAL LETTER N WITH DOT BELOW"  nil     )
    (#x001e47 "LATIN SMALL LETTER N WITH DOT BELOW"    nil     )
    (#x001e48 "LATIN CAPITAL LETTER N WITH LINE BELOW" nil     )
    (#x001e49 "LATIN SMALL LETTER N WITH LINE BELOW"   nil     )
    (#x001e4a "LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW" nil     )
    (#x001e4b "LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW" nil     )
    (#x001e4c "LATIN CAPITAL LETTER O WITH TILDE AND ACUTE" nil     )
    (#x001e4d "LATIN SMALL LETTER O WITH TILDE AND ACUTE" nil     )
    (#x001e4e "LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS" nil     )
    (#x001e4f "LATIN SMALL LETTER O WITH TILDE AND DIAERESIS" nil     )
    (#x001e50 "LATIN CAPITAL LETTER O WITH MACRON AND GRAVE" nil     )
    (#x001e51 "LATIN SMALL LETTER O WITH MACRON AND GRAVE" nil     )
    (#x001e52 "LATIN CAPITAL LETTER O WITH MACRON AND ACUTE" nil     )
    (#x001e53 "LATIN SMALL LETTER O WITH MACRON AND ACUTE" nil     )
    (#x001e54 "LATIN CAPITAL LETTER P WITH ACUTE"      nil     )
    (#x001e55 "LATIN SMALL LETTER P WITH ACUTE"        nil     )
    (#x001e56 "LATIN CAPITAL LETTER P WITH DOT ABOVE"  nil     )
    (#x001e57 "LATIN SMALL LETTER P WITH DOT ABOVE"    nil     )
    (#x001e58 "LATIN CAPITAL LETTER R WITH DOT ABOVE"  nil     )
    (#x001e59 "LATIN SMALL LETTER R WITH DOT ABOVE"    nil     )
    (#x001e5a "LATIN CAPITAL LETTER R WITH DOT BELOW"  nil     )
    (#x001e5b "LATIN SMALL LETTER R WITH DOT BELOW"    nil     )
    (#x001e5c "LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON" nil     )
    (#x001e5d "LATIN SMALL LETTER R WITH DOT BELOW AND MACRON" nil     )
    (#x001e5e "LATIN CAPITAL LETTER R WITH LINE BELOW" nil     )
    (#x001e5f "LATIN SMALL LETTER R WITH LINE BELOW"   nil     )
    (#x001e60 "LATIN CAPITAL LETTER S WITH DOT ABOVE"  nil     )
    (#x001e61 "LATIN SMALL LETTER S WITH DOT ABOVE"    nil     )
    (#x001e62 "LATIN CAPITAL LETTER S WITH DOT BELOW"  nil     )
    (#x001e63 "LATIN SMALL LETTER S WITH DOT BELOW"    nil     )
    (#x001e64 "LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE" nil     )
    (#x001e65 "LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE" nil     )
    (#x001e66 "LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE" nil     )
    (#x001e67 "LATIN SMALL LETTER S WITH CARON AND DOT ABOVE" nil     )
    (#x001e68 "LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE" nil     )
    (#x001e69 "LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE" nil     )
    (#x001e6a "LATIN CAPITAL LETTER T WITH DOT ABOVE"  nil     )
    (#x001e6b "LATIN SMALL LETTER T WITH DOT ABOVE"    nil     )
    (#x001e6c "LATIN CAPITAL LETTER T WITH DOT BELOW"  nil     )
    (#x001e6d "LATIN SMALL LETTER T WITH DOT BELOW"    nil     )
    (#x001e6e "LATIN CAPITAL LETTER T WITH LINE BELOW" nil     )
    (#x001e6f "LATIN SMALL LETTER T WITH LINE BELOW"   nil     )
    (#x001e70 "LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW" nil     )
    (#x001e71 "LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW" nil     )
    (#x001e72 "LATIN CAPITAL LETTER U WITH DIAERESIS BELOW" nil     )
    (#x001e73 "LATIN SMALL LETTER U WITH DIAERESIS BELOW" nil     )
    (#x001e74 "LATIN CAPITAL LETTER U WITH TILDE BELOW" nil     )
    (#x001e75 "LATIN SMALL LETTER U WITH TILDE BELOW"  nil     )
    (#x001e76 "LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW" nil     )
    (#x001e77 "LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW" nil     )
    (#x001e78 "LATIN CAPITAL LETTER U WITH TILDE AND ACUTE" nil     )
    (#x001e79 "LATIN SMALL LETTER U WITH TILDE AND ACUTE" nil     )
    (#x001e7a "LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS" nil     )
    (#x001e7b "LATIN SMALL LETTER U WITH MACRON AND DIAERESIS" nil     )
    (#x001e7c "LATIN CAPITAL LETTER V WITH TILDE"      nil     )
    (#x001e7d "LATIN SMALL LETTER V WITH TILDE"        nil     )
    (#x001e7e "LATIN CAPITAL LETTER V WITH DOT BELOW"  nil     )
    (#x001e7f "LATIN SMALL LETTER V WITH DOT BELOW"    nil     )
    (#x001e80 "LATIN CAPITAL LETTER W WITH GRAVE"      nil     )
    (#x001e81 "LATIN SMALL LETTER W WITH GRAVE"        nil     )
    (#x001e82 "LATIN CAPITAL LETTER W WITH ACUTE"      nil     )
    (#x001e83 "LATIN SMALL LETTER W WITH ACUTE"        nil     )
    (#x001e84 "LATIN CAPITAL LETTER W WITH DIAERESIS"  nil     )
    (#x001e85 "LATIN SMALL LETTER W WITH DIAERESIS"    nil     )
    (#x001e86 "LATIN CAPITAL LETTER W WITH DOT ABOVE"  nil     )
    (#x001e87 "LATIN SMALL LETTER W WITH DOT ABOVE"    nil     )
    (#x001e88 "LATIN CAPITAL LETTER W WITH DOT BELOW"  nil     )
    (#x001e89 "LATIN SMALL LETTER W WITH DOT BELOW"    nil     )
    (#x001e8a "LATIN CAPITAL LETTER X WITH DOT ABOVE"  nil     )
    (#x001e8b "LATIN SMALL LETTER X WITH DOT ABOVE"    nil     )
    (#x001e8c "LATIN CAPITAL LETTER X WITH DIAERESIS"  nil     )
    (#x001e8d "LATIN SMALL LETTER X WITH DIAERESIS"    nil     )
    (#x001e8e "LATIN CAPITAL LETTER Y WITH DOT ABOVE"  nil     )
    (#x001e8f "LATIN SMALL LETTER Y WITH DOT ABOVE"    nil     )
    (#x001e90 "LATIN CAPITAL LETTER Z WITH CIRCUMFLEX" nil     )
    (#x001e91 "LATIN SMALL LETTER Z WITH CIRCUMFLEX"   nil     )
    (#x001e92 "LATIN CAPITAL LETTER Z WITH DOT BELOW"  nil     )
    (#x001e93 "LATIN SMALL LETTER Z WITH DOT BELOW"    nil     )
    (#x001e94 "LATIN CAPITAL LETTER Z WITH LINE BELOW" nil     )
    (#x001e95 "LATIN SMALL LETTER Z WITH LINE BELOW"   nil     )
    (#x001e96 "LATIN SMALL LETTER H WITH LINE BELOW"   nil     )
    (#x001e97 "LATIN SMALL LETTER T WITH DIAERESIS"    nil     )
    (#x001e98 "LATIN SMALL LETTER W WITH RING ABOVE"   nil     )
    (#x001e99 "LATIN SMALL LETTER Y WITH RING ABOVE"   nil     )
    (#x001e9a "LATIN SMALL LETTER A WITH RIGHT HALF RING" nil     )
    (#x001e9b "LATIN SMALL LETTER LONG S WITH DOT ABOVE" nil     )
    (#x001e9c "LATIN SMALL LETTER LONG S WITH DIAGONAL STROKE" nil     )
    (#x001e9d "LATIN SMALL LETTER LONG S WITH HIGH STROKE" nil     )
    (#x001e9e "LATIN CAPITAL LETTER SHARP S"           nil     )
    (#x001e9f "LATIN SMALL LETTER DELTA"               nil     )
    (#x001ea0 "LATIN CAPITAL LETTER A WITH DOT BELOW"  nil     )
    (#x001ea1 "LATIN SMALL LETTER A WITH DOT BELOW"    nil     )
    (#x001ea2 "LATIN CAPITAL LETTER A WITH HOOK ABOVE" nil     )
    (#x001ea3 "LATIN SMALL LETTER A WITH HOOK ABOVE"   nil     )
    (#x001ea4 "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE" nil     )
    (#x001ea5 "LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE" nil     )
    (#x001ea6 "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE" nil     )
    (#x001ea7 "LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE" nil     )
    (#x001ea8 "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE" nil     )
    (#x001ea9 "LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE" nil     )
    (#x001eaa "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE" nil     )
    (#x001eab "LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE" nil     )
    (#x001eac "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW" nil     )
    (#x001ead "LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW" nil     )
    (#x001eae "LATIN CAPITAL LETTER A WITH BREVE AND ACUTE" nil     )
    (#x001eaf "LATIN SMALL LETTER A WITH BREVE AND ACUTE" nil     )
    (#x001eb0 "LATIN CAPITAL LETTER A WITH BREVE AND GRAVE" nil     )
    (#x001eb1 "LATIN SMALL LETTER A WITH BREVE AND GRAVE" nil     )
    (#x001eb2 "LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE" nil     )
    (#x001eb3 "LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE" nil     )
    (#x001eb4 "LATIN CAPITAL LETTER A WITH BREVE AND TILDE" nil     )
    (#x001eb5 "LATIN SMALL LETTER A WITH BREVE AND TILDE" nil     )
    (#x001eb6 "LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW" nil     )
    (#x001eb7 "LATIN SMALL LETTER A WITH BREVE AND DOT BELOW" nil     )
    (#x001eb8 "LATIN CAPITAL LETTER E WITH DOT BELOW"  nil     )
    (#x001eb9 "LATIN SMALL LETTER E WITH DOT BELOW"    nil     )
    (#x001eba "LATIN CAPITAL LETTER E WITH HOOK ABOVE" nil     )
    (#x001ebb "LATIN SMALL LETTER E WITH HOOK ABOVE"   nil     )
    (#x001ebc "LATIN CAPITAL LETTER E WITH TILDE"      nil     )
    (#x001ebd "LATIN SMALL LETTER E WITH TILDE"        nil     )
    (#x001ebe "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE" nil     )
    (#x001ebf "LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE" nil     )
    (#x001ec0 "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE" nil     )
    (#x001ec1 "LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE" nil     )
    (#x001ec2 "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE" nil     )
    (#x001ec3 "LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE" nil     )
    (#x001ec4 "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE" nil     )
    (#x001ec5 "LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE" nil     )
    (#x001ec6 "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW" nil     )
    (#x001ec7 "LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW" nil     )
    (#x001ec8 "LATIN CAPITAL LETTER I WITH HOOK ABOVE" nil     )
    (#x001ec9 "LATIN SMALL LETTER I WITH HOOK ABOVE"   nil     )
    (#x001eca "LATIN CAPITAL LETTER I WITH DOT BELOW"  nil     )
    (#x001ecb "LATIN SMALL LETTER I WITH DOT BELOW"    nil     )
    (#x001ecc "LATIN CAPITAL LETTER O WITH DOT BELOW"  nil     )
    (#x001ecd "LATIN SMALL LETTER O WITH DOT BELOW"    nil     )
    (#x001ece "LATIN CAPITAL LETTER O WITH HOOK ABOVE" nil     )
    (#x001ecf "LATIN SMALL LETTER O WITH HOOK ABOVE"   nil     )
    (#x001ed0 "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE" nil     )
    (#x001ed1 "LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE" nil     )
    (#x001ed2 "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE" nil     )
    (#x001ed3 "LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE" nil     )
    (#x001ed4 "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE" nil     )
    (#x001ed5 "LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE" nil     )
    (#x001ed6 "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE" nil     )
    (#x001ed7 "LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE" nil     )
    (#x001ed8 "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW" nil     )
    (#x001ed9 "LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW" nil     )
    (#x001eda "LATIN CAPITAL LETTER O WITH HORN AND ACUTE" nil     )
    (#x001edb "LATIN SMALL LETTER O WITH HORN AND ACUTE" nil     )
    (#x001edc "LATIN CAPITAL LETTER O WITH HORN AND GRAVE" nil     )
    (#x001edd "LATIN SMALL LETTER O WITH HORN AND GRAVE" nil     )
    (#x001ede "LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE" nil     )
    (#x001edf "LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE" nil     )
    (#x001ee0 "LATIN CAPITAL LETTER O WITH HORN AND TILDE" nil     )
    (#x001ee1 "LATIN SMALL LETTER O WITH HORN AND TILDE" nil     )
    (#x001ee2 "LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW" nil     )
    (#x001ee3 "LATIN SMALL LETTER O WITH HORN AND DOT BELOW" nil     )
    (#x001ee4 "LATIN CAPITAL LETTER U WITH DOT BELOW"  nil     )
    (#x001ee5 "LATIN SMALL LETTER U WITH DOT BELOW"    nil     )
    (#x001ee6 "LATIN CAPITAL LETTER U WITH HOOK ABOVE" nil     )
    (#x001ee7 "LATIN SMALL LETTER U WITH HOOK ABOVE"   nil     )
    (#x001ee8 "LATIN CAPITAL LETTER U WITH HORN AND ACUTE" nil     )
    (#x001ee9 "LATIN SMALL LETTER U WITH HORN AND ACUTE" nil     )
    (#x001eea "LATIN CAPITAL LETTER U WITH HORN AND GRAVE" nil     )
    (#x001eeb "LATIN SMALL LETTER U WITH HORN AND GRAVE" nil     )
    (#x001eec "LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE" nil     )
    (#x001eed "LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE" nil     )
    (#x001eee "LATIN CAPITAL LETTER U WITH HORN AND TILDE" nil     )
    (#x001eef "LATIN SMALL LETTER U WITH HORN AND TILDE" nil     )
    (#x001ef0 "LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW" nil     )
    (#x001ef1 "LATIN SMALL LETTER U WITH HORN AND DOT BELOW" nil     )
    (#x001ef2 "LATIN CAPITAL LETTER Y WITH GRAVE"      nil     )
    (#x001ef3 "LATIN SMALL LETTER Y WITH GRAVE"        nil     )
    (#x001ef4 "LATIN CAPITAL LETTER Y WITH DOT BELOW"  nil     )
    (#x001ef5 "LATIN SMALL LETTER Y WITH DOT BELOW"    nil     )
    (#x001ef6 "LATIN CAPITAL LETTER Y WITH HOOK ABOVE" nil     )
    (#x001ef7 "LATIN SMALL LETTER Y WITH HOOK ABOVE"   nil     )
    (#x001ef8 "LATIN CAPITAL LETTER Y WITH TILDE"      nil     )
    (#x001ef9 "LATIN SMALL LETTER Y WITH TILDE"        nil     )
    (#x001efa "LATIN CAPITAL LETTER MIDDLE-WELSH LL"   nil     )
    (#x001efb "LATIN SMALL LETTER MIDDLE-WELSH LL"     nil     )
    (#x001efc "LATIN CAPITAL LETTER MIDDLE-WELSH V"    nil     )
    (#x001efd "LATIN SMALL LETTER MIDDLE-WELSH V"      nil     )
    (#x001efe "LATIN CAPITAL LETTER Y WITH LOOP"       nil     )
    (#x001eff "LATIN SMALL LETTER Y WITH LOOP"         nil     )
    (#x001f00 "GREEK SMALL LETTER ALPHA WITH PSILI"    nil     )
    (#x001f01 "GREEK SMALL LETTER ALPHA WITH DASIA"    nil     )
    (#x001f02 "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA" nil     )
    (#x001f03 "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA" nil     )
    (#x001f04 "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA" nil     )
    (#x001f05 "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA" nil     )
    (#x001f06 "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f07 "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f08 "GREEK CAPITAL LETTER ALPHA WITH PSILI"  nil     )
    (#x001f09 "GREEK CAPITAL LETTER ALPHA WITH DASIA"  nil     )
    (#x001f0a "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA" nil     )
    (#x001f0b "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA" nil     )
    (#x001f0c "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA" nil     )
    (#x001f0d "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA" nil     )
    (#x001f0e "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f0f "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f10 "GREEK SMALL LETTER EPSILON WITH PSILI"  nil     )
    (#x001f11 "GREEK SMALL LETTER EPSILON WITH DASIA"  nil     )
    (#x001f12 "GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA" nil     )
    (#x001f13 "GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA" nil     )
    (#x001f14 "GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA" nil     )
    (#x001f15 "GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA" nil     )
    (#x001f18 "GREEK CAPITAL LETTER EPSILON WITH PSILI" nil     )
    (#x001f19 "GREEK CAPITAL LETTER EPSILON WITH DASIA" nil     )
    (#x001f1a "GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA" nil     )
    (#x001f1b "GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA" nil     )
    (#x001f1c "GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA" nil     )
    (#x001f1d "GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA" nil     )
    (#x001f20 "GREEK SMALL LETTER ETA WITH PSILI"      nil     )
    (#x001f21 "GREEK SMALL LETTER ETA WITH DASIA"      nil     )
    (#x001f22 "GREEK SMALL LETTER ETA WITH PSILI AND VARIA" nil     )
    (#x001f23 "GREEK SMALL LETTER ETA WITH DASIA AND VARIA" nil     )
    (#x001f24 "GREEK SMALL LETTER ETA WITH PSILI AND OXIA" nil     )
    (#x001f25 "GREEK SMALL LETTER ETA WITH DASIA AND OXIA" nil     )
    (#x001f26 "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f27 "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f28 "GREEK CAPITAL LETTER ETA WITH PSILI"    nil     )
    (#x001f29 "GREEK CAPITAL LETTER ETA WITH DASIA"    nil     )
    (#x001f2a "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA" nil     )
    (#x001f2b "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA" nil     )
    (#x001f2c "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA" nil     )
    (#x001f2d "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA" nil     )
    (#x001f2e "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f2f "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f30 "GREEK SMALL LETTER IOTA WITH PSILI"     nil     )
    (#x001f31 "GREEK SMALL LETTER IOTA WITH DASIA"     nil     )
    (#x001f32 "GREEK SMALL LETTER IOTA WITH PSILI AND VARIA" nil     )
    (#x001f33 "GREEK SMALL LETTER IOTA WITH DASIA AND VARIA" nil     )
    (#x001f34 "GREEK SMALL LETTER IOTA WITH PSILI AND OXIA" nil     )
    (#x001f35 "GREEK SMALL LETTER IOTA WITH DASIA AND OXIA" nil     )
    (#x001f36 "GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f37 "GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f38 "GREEK CAPITAL LETTER IOTA WITH PSILI"   nil     )
    (#x001f39 "GREEK CAPITAL LETTER IOTA WITH DASIA"   nil     )
    (#x001f3a "GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA" nil     )
    (#x001f3b "GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA" nil     )
    (#x001f3c "GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA" nil     )
    (#x001f3d "GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA" nil     )
    (#x001f3e "GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f3f "GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f40 "GREEK SMALL LETTER OMICRON WITH PSILI"  nil     )
    (#x001f41 "GREEK SMALL LETTER OMICRON WITH DASIA"  nil     )
    (#x001f42 "GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA" nil     )
    (#x001f43 "GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA" nil     )
    (#x001f44 "GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA" nil     )
    (#x001f45 "GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA" nil     )
    (#x001f48 "GREEK CAPITAL LETTER OMICRON WITH PSILI" nil     )
    (#x001f49 "GREEK CAPITAL LETTER OMICRON WITH DASIA" nil     )
    (#x001f4a "GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA" nil     )
    (#x001f4b "GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA" nil     )
    (#x001f4c "GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA" nil     )
    (#x001f4d "GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA" nil     )
    (#x001f50 "GREEK SMALL LETTER UPSILON WITH PSILI"  nil     )
    (#x001f51 "GREEK SMALL LETTER UPSILON WITH DASIA"  nil     )
    (#x001f52 "GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA" nil     )
    (#x001f53 "GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA" nil     )
    (#x001f54 "GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA" nil     )
    (#x001f55 "GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA" nil     )
    (#x001f56 "GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI" nil     )
    (#x001f57 "GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI" nil     )
    (#x001f59 "GREEK CAPITAL LETTER UPSILON WITH DASIA" nil     )
    (#x001f5b "GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA" nil     )
    (#x001f5d "GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA" nil     )
    (#x001f5f "GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI" nil     )
    (#x001f60 "GREEK SMALL LETTER OMEGA WITH PSILI"    nil     )
    (#x001f61 "GREEK SMALL LETTER OMEGA WITH DASIA"    nil     )
    (#x001f62 "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA" nil     )
    (#x001f63 "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA" nil     )
    (#x001f64 "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA" nil     )
    (#x001f65 "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA" nil     )
    (#x001f66 "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f67 "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f68 "GREEK CAPITAL LETTER OMEGA WITH PSILI"  nil     )
    (#x001f69 "GREEK CAPITAL LETTER OMEGA WITH DASIA"  nil     )
    (#x001f6a "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA" nil     )
    (#x001f6b "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA" nil     )
    (#x001f6c "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA" nil     )
    (#x001f6d "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA" nil     )
    (#x001f6e "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI" nil     )
    (#x001f6f "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI" nil     )
    (#x001f70 "GREEK SMALL LETTER ALPHA WITH VARIA"    nil     )
    (#x001f71 "GREEK SMALL LETTER ALPHA WITH OXIA"     nil     )
    (#x001f72 "GREEK SMALL LETTER EPSILON WITH VARIA"  nil     )
    (#x001f73 "GREEK SMALL LETTER EPSILON WITH OXIA"   nil     )
    (#x001f74 "GREEK SMALL LETTER ETA WITH VARIA"      nil     )
    (#x001f75 "GREEK SMALL LETTER ETA WITH OXIA"       nil     )
    (#x001f76 "GREEK SMALL LETTER IOTA WITH VARIA"     nil     )
    (#x001f77 "GREEK SMALL LETTER IOTA WITH OXIA"      nil     )
    (#x001f78 "GREEK SMALL LETTER OMICRON WITH VARIA"  nil     )
    (#x001f79 "GREEK SMALL LETTER OMICRON WITH OXIA"   nil     )
    (#x001f7a "GREEK SMALL LETTER UPSILON WITH VARIA"  nil     )
    (#x001f7b "GREEK SMALL LETTER UPSILON WITH OXIA"   nil     )
    (#x001f7c "GREEK SMALL LETTER OMEGA WITH VARIA"    nil     )
    (#x001f7d "GREEK SMALL LETTER OMEGA WITH OXIA"     nil     )
    (#x001f80 "GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI" nil     )
    (#x001f81 "GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI" nil     )
    (#x001f82 "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI" nil     )
    (#x001f83 "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI" nil     )
    (#x001f84 "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI" nil     )
    (#x001f85 "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI" nil     )
    (#x001f86 "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001f87 "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001f88 "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI" nil     )
    (#x001f89 "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI" nil     )
    (#x001f8a "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI" nil     )
    (#x001f8b "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI" nil     )
    (#x001f8c "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI" nil     )
    (#x001f8d "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI" nil     )
    (#x001f8e "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" nil     )
    (#x001f8f "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" nil     )
    (#x001f90 "GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI" nil     )
    (#x001f91 "GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI" nil     )
    (#x001f92 "GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI" nil     )
    (#x001f93 "GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI" nil     )
    (#x001f94 "GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI" nil     )
    (#x001f95 "GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI" nil     )
    (#x001f96 "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001f97 "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001f98 "GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI" nil     )
    (#x001f99 "GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI" nil     )
    (#x001f9a "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI" nil     )
    (#x001f9b "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI" nil     )
    (#x001f9c "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI" nil     )
    (#x001f9d "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI" nil     )
    (#x001f9e "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" nil     )
    (#x001f9f "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" nil     )
    (#x001fa0 "GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI" nil     )
    (#x001fa1 "GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI" nil     )
    (#x001fa2 "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI" nil     )
    (#x001fa3 "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI" nil     )
    (#x001fa4 "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI" nil     )
    (#x001fa5 "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI" nil     )
    (#x001fa6 "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001fa7 "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001fa8 "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI" nil     )
    (#x001fa9 "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI" nil     )
    (#x001faa "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI" nil     )
    (#x001fab "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI" nil     )
    (#x001fac "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI" nil     )
    (#x001fad "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI" nil     )
    (#x001fae "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" nil     )
    (#x001faf "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" nil     )
    (#x001fb0 "GREEK SMALL LETTER ALPHA WITH VRACHY"   nil     )
    (#x001fb1 "GREEK SMALL LETTER ALPHA WITH MACRON"   nil     )
    (#x001fb2 "GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI" nil     )
    (#x001fb3 "GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI" nil     )
    (#x001fb4 "GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI" nil     )
    (#x001fb6 "GREEK SMALL LETTER ALPHA WITH PERISPOMENI" nil     )
    (#x001fb7 "GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001fb8 "GREEK CAPITAL LETTER ALPHA WITH VRACHY" nil     )
    (#x001fb9 "GREEK CAPITAL LETTER ALPHA WITH MACRON" nil     )
    (#x001fba "GREEK CAPITAL LETTER ALPHA WITH VARIA"  nil     )
    (#x001fbb "GREEK CAPITAL LETTER ALPHA WITH OXIA"   nil     )
    (#x001fbc "GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI" nil     )
    (#x001fbd "GREEK KORONIS"                          nil     )
    (#x001fbe "GREEK PROSGEGRAMMENI"                   nil     )
    (#x001fbf "GREEK PSILI"                            nil     )
    (#x001fc0 "GREEK PERISPOMENI"                      nil     )
    (#x001fc1 "GREEK DIALYTIKA AND PERISPOMENI"        nil     )
    (#x001fc2 "GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI" nil     )
    (#x001fc3 "GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI" nil     )
    (#x001fc4 "GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI" nil     )
    (#x001fc6 "GREEK SMALL LETTER ETA WITH PERISPOMENI" nil     )
    (#x001fc7 "GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001fc8 "GREEK CAPITAL LETTER EPSILON WITH VARIA" nil     )
    (#x001fc9 "GREEK CAPITAL LETTER EPSILON WITH OXIA" nil     )
    (#x001fca "GREEK CAPITAL LETTER ETA WITH VARIA"    nil     )
    (#x001fcb "GREEK CAPITAL LETTER ETA WITH OXIA"     nil     )
    (#x001fcc "GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI" nil     )
    (#x001fcd "GREEK PSILI AND VARIA"                  nil     )
    (#x001fce "GREEK PSILI AND OXIA"                   nil     )
    (#x001fcf "GREEK PSILI AND PERISPOMENI"            nil     )
    (#x001fd0 "GREEK SMALL LETTER IOTA WITH VRACHY"    nil     )
    (#x001fd1 "GREEK SMALL LETTER IOTA WITH MACRON"    nil     )
    (#x001fd2 "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA" nil     )
    (#x001fd3 "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA" nil     )
    (#x001fd6 "GREEK SMALL LETTER IOTA WITH PERISPOMENI" nil     )
    (#x001fd7 "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI" nil     )
    (#x001fd8 "GREEK CAPITAL LETTER IOTA WITH VRACHY"  nil     )
    (#x001fd9 "GREEK CAPITAL LETTER IOTA WITH MACRON"  nil     )
    (#x001fda "GREEK CAPITAL LETTER IOTA WITH VARIA"   nil     )
    (#x001fdb "GREEK CAPITAL LETTER IOTA WITH OXIA"    nil     )
    (#x001fdd "GREEK DASIA AND VARIA"                  nil     )
    (#x001fde "GREEK DASIA AND OXIA"                   nil     )
    (#x001fdf "GREEK DASIA AND PERISPOMENI"            nil     )
    (#x001fe0 "GREEK SMALL LETTER UPSILON WITH VRACHY" nil     )
    (#x001fe1 "GREEK SMALL LETTER UPSILON WITH MACRON" nil     )
    (#x001fe2 "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA" nil     )
    (#x001fe3 "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA" nil     )
    (#x001fe4 "GREEK SMALL LETTER RHO WITH PSILI"      nil     )
    (#x001fe5 "GREEK SMALL LETTER RHO WITH DASIA"      nil     )
    (#x001fe6 "GREEK SMALL LETTER UPSILON WITH PERISPOMENI" nil     )
    (#x001fe7 "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI" nil     )
    (#x001fe8 "GREEK CAPITAL LETTER UPSILON WITH VRACHY" nil     )
    (#x001fe9 "GREEK CAPITAL LETTER UPSILON WITH MACRON" nil     )
    (#x001fea "GREEK CAPITAL LETTER UPSILON WITH VARIA" nil     )
    (#x001feb "GREEK CAPITAL LETTER UPSILON WITH OXIA" nil     )
    (#x001fec "GREEK CAPITAL LETTER RHO WITH DASIA"    nil     )
    (#x001fed "GREEK DIALYTIKA AND VARIA"              nil     )
    (#x001fee "GREEK DIALYTIKA AND OXIA"               nil     )
    (#x001fef "GREEK VARIA"                            nil     )
    (#x001ff2 "GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI" nil     )
    (#x001ff3 "GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI" nil     )
    (#x001ff4 "GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI" nil     )
    (#x001ff6 "GREEK SMALL LETTER OMEGA WITH PERISPOMENI" nil     )
    (#x001ff7 "GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI" nil     )
    (#x001ff8 "GREEK CAPITAL LETTER OMICRON WITH VARIA" nil     )
    (#x001ff9 "GREEK CAPITAL LETTER OMICRON WITH OXIA" nil     )
    (#x001ffa "GREEK CAPITAL LETTER OMEGA WITH VARIA"  nil     )
    (#x001ffb "GREEK CAPITAL LETTER OMEGA WITH OXIA"   nil     )
    (#x001ffc "GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI" nil     )
    (#x001ffd "GREEK OXIA"                             nil     )
    (#x001ffe "GREEK DASIA"                            nil     )
    (#x002000 "EN QUAD"                                nil     )
    (#x002001 "EM QUAD"                                nil     )
    (#x002002 "EN SPACE"                               "ensp"  )
    (#x002003 "EM SPACE"                               "emsp"  )
    (#x002004 "THREE-PER-EM SPACE"                     "emsp13")
    (#x002005 "FOUR-PER-EM SPACE"                      "emsp14")
    (#x002006 "SIX-PER-EM SPACE"                       nil     )
    (#x002007 "FIGURE SPACE"                           "numsp" )
    (#x002008 "PUNCTUATION SPACE"                      "puncsp")
    (#x002009 "THIN SPACE"                             "thinsp")
    (#x00200a "HAIR SPACE"                             "hairsp")
    (#x00200b "ZERO WIDTH SPACE"                       nil     )
    (#x00200c "ZERO WIDTH NON-JOINER"                  nil     )
    (#x00200d "ZERO WIDTH JOINER"                      nil     )
    (#x00200e "LEFT-TO-RIGHT MARK"                     nil     )
    (#x00200f "RIGHT-TO-LEFT MARK"                     nil     )
    (#x002010 "HYPHEN"                                 "hyphen")
    (#x002011 "NON-BREAKING HYPHEN"                    nil     )
    (#x002012 "FIGURE DASH"                            nil     )
    (#x002013 "EN DASH"                                "ndash" )
    (#x002014 "EM DASH"                                "mdash" )
    (#x002015 "HORIZONTAL BAR"                         "horbar")
    (#x002016 "DOUBLE VERTICAL LINE"                   "Verbar")
    (#x002017 "DOUBLE LOW LINE"                        nil     )
    (#x002018 "LEFT SINGLE QUOTATION MARK"             "lsquo" )
    (#x002019 "RIGHT SINGLE QUOTATION MARK"            "rsquo" )
    (#x00201a "SINGLE LOW-9 QUOTATION MARK"            "lsquor")
    (#x00201b "SINGLE HIGH-REVERSED-9 QUOTATION MARK"  nil     )
    (#x00201c "LEFT DOUBLE QUOTATION MARK"             "ldquo" )
    (#x00201d "RIGHT DOUBLE QUOTATION MARK"            "rdquo" )
    (#x00201e "DOUBLE LOW-9 QUOTATION MARK"            "ldquor")
    (#x00201f "DOUBLE HIGH-REVERSED-9 QUOTATION MARK"  nil     )
    (#x002020 "DAGGER"                                 "dagger")
    (#x002021 "DOUBLE DAGGER"                          "Dagger")
    (#x002022 "BULLET"                                 "bull"  )
    (#x002023 "TRIANGULAR BULLET"                      nil     )
    (#x002024 "ONE DOT LEADER"                         nil     )
    (#x002025 "TWO DOT LEADER"                         "nldr"  )
    (#x002026 "HORIZONTAL ELLIPSIS"                    "hellip")
    (#x002027 "HYPHENATION POINT"                      nil     )
    (#x002028 "LINE SEPARATOR"                         nil     )
    (#x002029 "PARAGRAPH SEPARATOR"                    nil     )
    (#x00202a "LEFT-TO-RIGHT EMBEDDING"                nil     )
    (#x00202b "RIGHT-TO-LEFT EMBEDDING"                nil     )
    (#x00202c "POP DIRECTIONAL FORMATTING"             nil     )
    (#x00202d "LEFT-TO-RIGHT OVERRIDE"                 nil     )
    (#x00202e "RIGHT-TO-LEFT OVERRIDE"                 nil     )
    (#x00202f "NARROW NO-BREAK SPACE"                  nil     )
    (#x002030 "PER MILLE SIGN"                         "permil")
    (#x002031 "PER TEN THOUSAND SIGN"                  nil     )
    (#x002032 "PRIME"                                  "prime" )
    (#x002033 "DOUBLE PRIME"                           "Prime" )
    (#x002034 "TRIPLE PRIME"                           "tprime")
    (#x002035 "REVERSED PRIME"                         "bprime")
    (#x002036 "REVERSED DOUBLE PRIME"                  nil     )
    (#x002037 "REVERSED TRIPLE PRIME"                  nil     )
    (#x002038 "CARET"                                  nil     )
    (#x002039 "SINGLE LEFT-POINTING ANGLE QUOTATION MARK" nil     )
    (#x00203a "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK" nil     )
    (#x00203b "REFERENCE MARK"                         nil     )
    (#x00203c "DOUBLE EXCLAMATION MARK"                nil     )
    (#x00203d "INTERROBANG"                            nil     )
    (#x00203e "OVERLINE"                               nil     )
    (#x00203f "UNDERTIE"                               nil     )
    (#x002040 "CHARACTER TIE"                          nil     )
    (#x002041 "CARET INSERTION POINT"                  "caret" )
    (#x002042 "ASTERISM"                               nil     )
    (#x002043 "HYPHEN BULLET"                          "hybull")
    (#x002044 "FRACTION SLASH"                         nil     )
    (#x002045 "LEFT SQUARE BRACKET WITH QUILL"         nil     )
    (#x002046 "RIGHT SQUARE BRACKET WITH QUILL"        nil     )
    (#x002047 "DOUBLE QUESTION MARK"                   nil     )
    (#x002048 "QUESTION EXCLAMATION MARK"              nil     )
    (#x002049 "EXCLAMATION QUESTION MARK"              nil     )
    (#x00204a "TIRONIAN SIGN ET"                       nil     )
    (#x00204b "REVERSED PILCROW SIGN"                  nil     )
    (#x00204c "BLACK LEFTWARDS BULLET"                 nil     )
    (#x00204d "BLACK RIGHTWARDS BULLET"                nil     )
    (#x00204e "LOW ASTERISK"                           nil     )
    (#x00204f "REVERSED SEMICOLON"                     nil     )
    (#x002050 "CLOSE UP"                               nil     )
    (#x002051 "TWO ASTERISKS ALIGNED VERTICALLY"       nil     )
    (#x002052 "COMMERCIAL MINUS SIGN"                  nil     )
    (#x002053 "SWUNG DASH"                             nil     )
    (#x002054 "INVERTED UNDERTIE"                      nil     )
    (#x002055 "FLOWER PUNCTUATION MARK"                nil     )
    (#x002056 "THREE DOT PUNCTUATION"                  nil     )
    (#x002057 "QUADRUPLE PRIME"                        nil     )
    (#x002058 "FOUR DOT PUNCTUATION"                   nil     )
    (#x002059 "FIVE DOT PUNCTUATION"                   nil     )
    (#x00205a "TWO DOT PUNCTUATION"                    nil     )
    (#x00205b "FOUR DOT MARK"                          nil     )
    (#x00205c "DOTTED CROSS"                           nil     )
    (#x00205d "TRICOLON"                               nil     )
    (#x00205e "VERTICAL FOUR DOTS"                     nil     )
    (#x00205f "MEDIUM MATHEMATICAL SPACE"              nil     )
    (#x002060 "WORD JOINER"                            nil     )
    (#x002061 "FUNCTION APPLICATION"                   nil     )
    (#x002062 "INVISIBLE TIMES"                        nil     )
    (#x002063 "INVISIBLE SEPARATOR"                    nil     )
    (#x002064 "INVISIBLE PLUS"                         nil     )
    (#x002066 "LEFT-TO-RIGHT ISOLATE"                  nil     )
    (#x002067 "RIGHT-TO-LEFT ISOLATE"                  nil     )
    (#x002068 "FIRST STRONG ISOLATE"                   nil     )
    (#x002069 "POP DIRECTIONAL ISOLATE"                nil     )
    (#x00206a "INHIBIT SYMMETRIC SWAPPING"             nil     )
    (#x00206b "ACTIVATE SYMMETRIC SWAPPING"            nil     )
    (#x00206c "INHIBIT ARABIC FORM SHAPING"            nil     )
    (#x00206d "ACTIVATE ARABIC FORM SHAPING"           nil     )
    (#x00206e "NATIONAL DIGIT SHAPES"                  nil     )
    (#x00206f "NOMINAL DIGIT SHAPES"                   nil     )
    (#x002070 "SUPERSCRIPT ZERO"                       nil     )
    (#x002071 "SUPERSCRIPT LATIN SMALL LETTER I"       nil     )
    (#x002074 "SUPERSCRIPT FOUR"                       nil     )
    (#x002075 "SUPERSCRIPT FIVE"                       nil     )
    (#x002076 "SUPERSCRIPT SIX"                        nil     )
    (#x002077 "SUPERSCRIPT SEVEN"                      nil     )
    (#x002078 "SUPERSCRIPT EIGHT"                      nil     )
    (#x002079 "SUPERSCRIPT NINE"                       nil     )
    (#x00207a "SUPERSCRIPT PLUS SIGN"                  nil     )
    (#x00207b "SUPERSCRIPT MINUS"                      nil     )
    (#x00207c "SUPERSCRIPT EQUALS SIGN"                nil     )
    (#x00207d "SUPERSCRIPT LEFT PARENTHESIS"           nil     )
    (#x00207e "SUPERSCRIPT RIGHT PARENTHESIS"          nil     )
    (#x00207f "SUPERSCRIPT LATIN SMALL LETTER N"       nil     )
    (#x002080 "SUBSCRIPT ZERO"                         nil     )
    (#x002081 "SUBSCRIPT ONE"                          nil     )
    (#x002082 "SUBSCRIPT TWO"                          nil     )
    (#x002083 "SUBSCRIPT THREE"                        nil     )
    (#x002084 "SUBSCRIPT FOUR"                         nil     )
    (#x002085 "SUBSCRIPT FIVE"                         nil     )
    (#x002086 "SUBSCRIPT SIX"                          nil     )
    (#x002087 "SUBSCRIPT SEVEN"                        nil     )
    (#x002088 "SUBSCRIPT EIGHT"                        nil     )
    (#x002089 "SUBSCRIPT NINE"                         nil     )
    (#x00208a "SUBSCRIPT PLUS SIGN"                    nil     )
    (#x00208b "SUBSCRIPT MINUS"                        nil     )
    (#x00208c "SUBSCRIPT EQUALS SIGN"                  nil     )
    (#x00208d "SUBSCRIPT LEFT PARENTHESIS"             nil     )
    (#x00208e "SUBSCRIPT RIGHT PARENTHESIS"            nil     )
    (#x002090 "LATIN SUBSCRIPT SMALL LETTER A"         nil     )
    (#x002091 "LATIN SUBSCRIPT SMALL LETTER E"         nil     )
    (#x002092 "LATIN SUBSCRIPT SMALL LETTER O"         nil     )
    (#x002093 "LATIN SUBSCRIPT SMALL LETTER X"         nil     )
    (#x002094 "LATIN SUBSCRIPT SMALL LETTER SCHWA"     nil     )
    (#x002095 "LATIN SUBSCRIPT SMALL LETTER H"         nil     )
    (#x002096 "LATIN SUBSCRIPT SMALL LETTER K"         nil     )
    (#x002097 "LATIN SUBSCRIPT SMALL LETTER L"         nil     )
    (#x002098 "LATIN SUBSCRIPT SMALL LETTER M"         nil     )
    (#x002099 "LATIN SUBSCRIPT SMALL LETTER N"         nil     )
    (#x00209a "LATIN SUBSCRIPT SMALL LETTER P"         nil     )
    (#x00209b "LATIN SUBSCRIPT SMALL LETTER S"         nil     )
    (#x00209c "LATIN SUBSCRIPT SMALL LETTER T"         nil     )
    (#x0020a0 "EURO-CURRENCY SIGN"                     nil     )
    (#x0020a1 "COLON SIGN"                             nil     )
    (#x0020a2 "CRUZEIRO SIGN"                          nil     )
    (#x0020a3 "FRENCH FRANC SIGN"                      nil     )
    (#x0020a4 "LIRA SIGN"                              nil     )
    (#x0020a5 "MILL SIGN"                              nil     )
    (#x0020a6 "NAIRA SIGN"                             nil     )
    (#x0020a7 "PESETA SIGN"                            nil     )
    (#x0020a8 "RUPEE SIGN"                             nil     )
    (#x0020a9 "WON SIGN"                               nil     )
    (#x0020aa "NEW SHEQEL SIGN"                        nil     )
    (#x0020ab "DONG SIGN"                              nil     )
    (#x0020ac "EURO SIGN"                              nil     )
    (#x0020ad "KIP SIGN"                               nil     )
    (#x0020ae "TUGRIK SIGN"                            nil     )
    (#x0020af "DRACHMA SIGN"                           nil     )
    (#x0020b0 "GERMAN PENNY SIGN"                      nil     )
    (#x0020b1 "PESO SIGN"                              nil     )
    (#x0020b2 "GUARANI SIGN"                           nil     )
    (#x0020b3 "AUSTRAL SIGN"                           nil     )
    (#x0020b4 "HRYVNIA SIGN"                           nil     )
    (#x0020b5 "CEDI SIGN"                              nil     )
    (#x0020b6 "LIVRE TOURNOIS SIGN"                    nil     )
    (#x0020b7 "SPESMILO SIGN"                          nil     )
    (#x0020b8 "TENGE SIGN"                             nil     )
    (#x0020b9 "INDIAN RUPEE SIGN"                      nil     )
    (#x0020ba "TURKISH LIRA SIGN"                      nil     )
    (#x0020bb "NORDIC MARK SIGN"                       nil     )
    (#x0020bc "MANAT SIGN"                             nil     )
    (#x0020bd "RUBLE SIGN"                             nil     )
    (#x0020be "LARI SIGN"                              nil     )
    (#x0020bf "BITCOIN SIGN"                           nil     )
    (#x0020c0 "SOM SIGN"                               nil     )
    (#x0020d0 "COMBINING LEFT HARPOON ABOVE"           nil     )
    (#x0020d1 "COMBINING RIGHT HARPOON ABOVE"          nil     )
    (#x0020d2 "COMBINING LONG VERTICAL LINE OVERLAY"   nil     )
    (#x0020d3 "COMBINING SHORT VERTICAL LINE OVERLAY"  nil     )
    (#x0020d4 "COMBINING ANTICLOCKWISE ARROW ABOVE"    nil     )
    (#x0020d5 "COMBINING CLOCKWISE ARROW ABOVE"        nil     )
    (#x0020d6 "COMBINING LEFT ARROW ABOVE"             nil     )
    (#x0020d7 "COMBINING RIGHT ARROW ABOVE"            nil     )
    (#x0020d8 "COMBINING RING OVERLAY"                 nil     )
    (#x0020d9 "COMBINING CLOCKWISE RING OVERLAY"       nil     )
    (#x0020da "COMBINING ANTICLOCKWISE RING OVERLAY"   nil     )
    (#x0020db "COMBINING THREE DOTS ABOVE"             "tdot"  )
    (#x0020dc "COMBINING FOUR DOTS ABOVE"              "DotDot")
    (#x0020dd "COMBINING ENCLOSING CIRCLE"             nil     )
    (#x0020de "COMBINING ENCLOSING SQUARE"             nil     )
    (#x0020df "COMBINING ENCLOSING DIAMOND"            nil     )
    (#x0020e0 "COMBINING ENCLOSING CIRCLE BACKSLASH"   nil     )
    (#x0020e1 "COMBINING LEFT RIGHT ARROW ABOVE"       nil     )
    (#x0020e2 "COMBINING ENCLOSING SCREEN"             nil     )
    (#x0020e3 "COMBINING ENCLOSING KEYCAP"             nil     )
    (#x0020e4 "COMBINING ENCLOSING UPWARD POINTING TRIANGLE" nil     )
    (#x0020e5 "COMBINING REVERSE SOLIDUS OVERLAY"      nil     )
    (#x0020e6 "COMBINING DOUBLE VERTICAL STROKE OVERLAY" nil     )
    (#x0020e7 "COMBINING ANNUITY SYMBOL"               nil     )
    (#x0020e8 "COMBINING TRIPLE UNDERDOT"              nil     )
    (#x0020e9 "COMBINING WIDE BRIDGE ABOVE"            nil     )
    (#x0020ea "COMBINING LEFTWARDS ARROW OVERLAY"      nil     )
    (#x0020eb "COMBINING LONG DOUBLE SOLIDUS OVERLAY"  nil     )
    (#x0020ec "COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS" nil     )
    (#x0020ed "COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS" nil     )
    (#x0020ee "COMBINING LEFT ARROW BELOW"             nil     )
    (#x0020ef "COMBINING RIGHT ARROW BELOW"            nil     )
    (#x0020f0 "COMBINING ASTERISK ABOVE"               nil     )
    (#x002100 "ACCOUNT OF"                             nil     )
    (#x002101 "ADDRESSED TO THE SUBJECT"               nil     )
    (#x002102 "DOUBLE-STRUCK CAPITAL C"                nil     )
    (#x002103 "DEGREE CELSIUS"                         nil     )
    (#x002104 "CENTRE LINE SYMBOL"                     nil     )
    (#x002105 "CARE OF"                                "incare")
    (#x002106 "CADA UNA"                               nil     )
    (#x002107 "EULER CONSTANT"                         nil     )
    (#x002108 "SCRUPLE"                                nil     )
    (#x002109 "DEGREE FAHRENHEIT"                      nil     )
    (#x00210a "SCRIPT SMALL G"                         nil     )
    (#x00210b "SCRIPT CAPITAL H"                       "hamilt")
    (#x00210c "BLACK-LETTER CAPITAL H"                 nil     )
    (#x00210d "DOUBLE-STRUCK CAPITAL H"                nil     )
    (#x00210e "PLANCK CONSTANT"                        nil     )
    (#x00210f "PLANCK CONSTANT OVER TWO PI"            "planck")
    (#x002110 "SCRIPT CAPITAL I"                       nil     )
    (#x002111 "BLACK-LETTER CAPITAL I"                 nil     )
    (#x002112 "SCRIPT CAPITAL L"                       "lagran")
    (#x002113 "SCRIPT SMALL L"                         "ell"   )
    (#x002114 "L B BAR SYMBOL"                         nil     )
    (#x002115 "DOUBLE-STRUCK CAPITAL N"                nil     )
    (#x002116 "NUMERO SIGN"                            "numero")
    (#x002117 "SOUND RECORDING COPYRIGHT"              "copysr")
    (#x002118 "SCRIPT CAPITAL P"                       "weierp")
    (#x002119 "DOUBLE-STRUCK CAPITAL P"                nil     )
    (#x00211a "DOUBLE-STRUCK CAPITAL Q"                nil     )
    (#x00211b "SCRIPT CAPITAL R"                       nil     )
    (#x00211c "BLACK-LETTER CAPITAL R"                 "real"  )
    (#x00211d "DOUBLE-STRUCK CAPITAL R"                nil     )
    (#x00211e "PRESCRIPTION TAKE"                      "rx"    )
    (#x00211f "RESPONSE"                               nil     )
    (#x002120 "SERVICE MARK"                           nil     )
    (#x002121 "TELEPHONE SIGN"                         nil     )
    (#x002122 "TRADE MARK SIGN"                        "trade" )
    (#x002123 "VERSICLE"                               nil     )
    (#x002124 "DOUBLE-STRUCK CAPITAL Z"                nil     )
    (#x002125 "OUNCE SIGN"                             nil     )
    (#x002126 "OHM SIGN"                               "ohm"   )
    (#x002127 "INVERTED OHM SIGN"                      nil     )
    (#x002128 "BLACK-LETTER CAPITAL Z"                 nil     )
    (#x002129 "TURNED GREEK SMALL LETTER IOTA"         nil     )
    (#x00212a "KELVIN SIGN"                            nil     )
    (#x00212b "ANGSTROM SIGN"                          "angst" )
    (#x00212c "SCRIPT CAPITAL B"                       "bernou")
    (#x00212d "BLACK-LETTER CAPITAL C"                 nil     )
    (#x00212e "ESTIMATED SYMBOL"                       nil     )
    (#x00212f "SCRIPT SMALL E"                         nil     )
    (#x002130 "SCRIPT CAPITAL E"                       nil     )
    (#x002131 "SCRIPT CAPITAL F"                       nil     )
    (#x002132 "TURNED CAPITAL F"                       nil     )
    (#x002133 "SCRIPT CAPITAL M"                       "phmmat")
    (#x002134 "SCRIPT SMALL O"                         "order" )
    (#x002135 "ALEF SYMBOL"                            "aleph" )
    (#x002136 "BET SYMBOL"                             "beth"  )
    (#x002137 "GIMEL SYMBOL"                           "gimel" )
    (#x002138 "DALET SYMBOL"                           "daleth")
    (#x002139 "INFORMATION SOURCE"                     nil     )
    (#x00213a "ROTATED CAPITAL Q"                      nil     )
    (#x00213b "FACSIMILE SIGN"                         nil     )
    (#x00213c "DOUBLE-STRUCK SMALL PI"                 nil     )
    (#x00213d "DOUBLE-STRUCK SMALL GAMMA"              nil     )
    (#x00213e "DOUBLE-STRUCK CAPITAL GAMMA"            nil     )
    (#x00213f "DOUBLE-STRUCK CAPITAL PI"               nil     )
    (#x002140 "DOUBLE-STRUCK N-ARY SUMMATION"          nil     )
    (#x002141 "TURNED SANS-SERIF CAPITAL G"            nil     )
    (#x002142 "TURNED SANS-SERIF CAPITAL L"            nil     )
    (#x002143 "REVERSED SANS-SERIF CAPITAL L"          nil     )
    (#x002144 "TURNED SANS-SERIF CAPITAL Y"            nil     )
    (#x002145 "DOUBLE-STRUCK ITALIC CAPITAL D"         nil     )
    (#x002146 "DOUBLE-STRUCK ITALIC SMALL D"           nil     )
    (#x002147 "DOUBLE-STRUCK ITALIC SMALL E"           nil     )
    (#x002148 "DOUBLE-STRUCK ITALIC SMALL I"           nil     )
    (#x002149 "DOUBLE-STRUCK ITALIC SMALL J"           nil     )
    (#x00214a "PROPERTY LINE"                          nil     )
    (#x00214b "TURNED AMPERSAND"                       nil     )
    (#x00214c "PER SIGN"                               nil     )
    (#x00214d "AKTIESELSKAB"                           nil     )
    (#x00214e "TURNED SMALL F"                         nil     )
    (#x00214f "SYMBOL FOR SAMARITAN SOURCE"            nil     )
    (#x002150 "VULGAR FRACTION ONE SEVENTH"            nil     )
    (#x002151 "VULGAR FRACTION ONE NINTH"              nil     )
    (#x002152 "VULGAR FRACTION ONE TENTH"              nil     )
    (#x002153 "VULGAR FRACTION ONE THIRD"              "frac13")
    (#x002154 "VULGAR FRACTION TWO THIRDS"             "frac23")
    (#x002155 "VULGAR FRACTION ONE FIFTH"              "frac15")
    (#x002156 "VULGAR FRACTION TWO FIFTHS"             "frac25")
    (#x002157 "VULGAR FRACTION THREE FIFTHS"           "frac35")
    (#x002158 "VULGAR FRACTION FOUR FIFTHS"            "frac45")
    (#x002159 "VULGAR FRACTION ONE SIXTH"              "frac16")
    (#x00215a "VULGAR FRACTION FIVE SIXTHS"            "frac56")
    (#x00215b "VULGAR FRACTION ONE EIGHTH"             "frac18")
    (#x00215c "VULGAR FRACTION THREE EIGHTHS"          "frac38")
    (#x00215d "VULGAR FRACTION FIVE EIGHTHS"           "frac58")
    (#x00215e "VULGAR FRACTION SEVEN EIGHTHS"          "frac78")
    (#x00215f "FRACTION NUMERATOR ONE"                 nil     )
    (#x002160 "ROMAN NUMERAL ONE"                      nil     )
    (#x002161 "ROMAN NUMERAL TWO"                      nil     )
    (#x002162 "ROMAN NUMERAL THREE"                    nil     )
    (#x002163 "ROMAN NUMERAL FOUR"                     nil     )
    (#x002164 "ROMAN NUMERAL FIVE"                     nil     )
    (#x002165 "ROMAN NUMERAL SIX"                      nil     )
    (#x002166 "ROMAN NUMERAL SEVEN"                    nil     )
    (#x002167 "ROMAN NUMERAL EIGHT"                    nil     )
    (#x002168 "ROMAN NUMERAL NINE"                     nil     )
    (#x002169 "ROMAN NUMERAL TEN"                      nil     )
    (#x00216a "ROMAN NUMERAL ELEVEN"                   nil     )
    (#x00216b "ROMAN NUMERAL TWELVE"                   nil     )
    (#x00216c "ROMAN NUMERAL FIFTY"                    nil     )
    (#x00216d "ROMAN NUMERAL ONE HUNDRED"              nil     )
    (#x00216e "ROMAN NUMERAL FIVE HUNDRED"             nil     )
    (#x00216f "ROMAN NUMERAL ONE THOUSAND"             nil     )
    (#x002170 "SMALL ROMAN NUMERAL ONE"                nil     )
    (#x002171 "SMALL ROMAN NUMERAL TWO"                nil     )
    (#x002172 "SMALL ROMAN NUMERAL THREE"              nil     )
    (#x002173 "SMALL ROMAN NUMERAL FOUR"               nil     )
    (#x002174 "SMALL ROMAN NUMERAL FIVE"               nil     )
    (#x002175 "SMALL ROMAN NUMERAL SIX"                nil     )
    (#x002176 "SMALL ROMAN NUMERAL SEVEN"              nil     )
    (#x002177 "SMALL ROMAN NUMERAL EIGHT"              nil     )
    (#x002178 "SMALL ROMAN NUMERAL NINE"               nil     )
    (#x002179 "SMALL ROMAN NUMERAL TEN"                nil     )
    (#x00217a "SMALL ROMAN NUMERAL ELEVEN"             nil     )
    (#x00217b "SMALL ROMAN NUMERAL TWELVE"             nil     )
    (#x00217c "SMALL ROMAN NUMERAL FIFTY"              nil     )
    (#x00217d "SMALL ROMAN NUMERAL ONE HUNDRED"        nil     )
    (#x00217e "SMALL ROMAN NUMERAL FIVE HUNDRED"       nil     )
    (#x00217f "SMALL ROMAN NUMERAL ONE THOUSAND"       nil     )
    (#x002180 "ROMAN NUMERAL ONE THOUSAND C D"         nil     )
    (#x002181 "ROMAN NUMERAL FIVE THOUSAND"            nil     )
    (#x002182 "ROMAN NUMERAL TEN THOUSAND"             nil     )
    (#x002183 "ROMAN NUMERAL REVERSED ONE HUNDRED"     nil     )
    (#x002184 "LATIN SMALL LETTER REVERSED C"          nil     )
    (#x002185 "ROMAN NUMERAL SIX LATE FORM"            nil     )
    (#x002186 "ROMAN NUMERAL FIFTY EARLY FORM"         nil     )
    (#x002187 "ROMAN NUMERAL FIFTY THOUSAND"           nil     )
    (#x002188 "ROMAN NUMERAL ONE HUNDRED THOUSAND"     nil     )
    (#x002189 "VULGAR FRACTION ZERO THIRDS"            nil     )
    (#x00218a "TURNED DIGIT TWO"                       nil     )
    (#x00218b "TURNED DIGIT THREE"                     nil     )
    (#x002190 "LEFTWARDS ARROW"                        "larr"  )
    (#x002191 "UPWARDS ARROW"                          "uarr"  )
    (#x002192 "RIGHTWARDS ARROW"                       "rarr"  )
    (#x002193 "DOWNWARDS ARROW"                        "darr"  )
    (#x002194 "LEFT RIGHT ARROW"                       "harr"  )
    (#x002195 "UP DOWN ARROW"                          "varr"  )
    (#x002196 "NORTH WEST ARROW"                       "nwarr" )
    (#x002197 "NORTH EAST ARROW"                       "nearr" )
    (#x002198 "SOUTH EAST ARROW"                       "drarr" )
    (#x002199 "SOUTH WEST ARROW"                       "dlarr" )
    (#x00219a "LEFTWARDS ARROW WITH STROKE"            "nlarr" )
    (#x00219b "RIGHTWARDS ARROW WITH STROKE"           "nrarr" )
    (#x00219c "LEFTWARDS WAVE ARROW"                   nil     )
    (#x00219d "RIGHTWARDS WAVE ARROW"                  "rarrw" )
    (#x00219e "LEFTWARDS TWO HEADED ARROW"             "Larr"  )
    (#x00219f "UPWARDS TWO HEADED ARROW"               nil     )
    (#x0021a0 "RIGHTWARDS TWO HEADED ARROW"            "Rarr"  )
    (#x0021a1 "DOWNWARDS TWO HEADED ARROW"             nil     )
    (#x0021a2 "LEFTWARDS ARROW WITH TAIL"              "larrtl")
    (#x0021a3 "RIGHTWARDS ARROW WITH TAIL"             "rarrtl")
    (#x0021a4 "LEFTWARDS ARROW FROM BAR"               nil     )
    (#x0021a5 "UPWARDS ARROW FROM BAR"                 nil     )
    (#x0021a6 "RIGHTWARDS ARROW FROM BAR"              "map"   )
    (#x0021a7 "DOWNWARDS ARROW FROM BAR"               nil     )
    (#x0021a8 "UP DOWN ARROW WITH BASE"                nil     )
    (#x0021a9 "LEFTWARDS ARROW WITH HOOK"              "larrhk")
    (#x0021aa "RIGHTWARDS ARROW WITH HOOK"             "rarrhk")
    (#x0021ab "LEFTWARDS ARROW WITH LOOP"              "larrlp")
    (#x0021ac "RIGHTWARDS ARROW WITH LOOP"             "rarrlp")
    (#x0021ad "LEFT RIGHT WAVE ARROW"                  "harrw" )
    (#x0021ae "LEFT RIGHT ARROW WITH STROKE"           "nharr" )
    (#x0021af "DOWNWARDS ZIGZAG ARROW"                 nil     )
    (#x0021b0 "UPWARDS ARROW WITH TIP LEFTWARDS"       "lsh"   )
    (#x0021b1 "UPWARDS ARROW WITH TIP RIGHTWARDS"      "rsh"   )
    (#x0021b2 "DOWNWARDS ARROW WITH TIP LEFTWARDS"     nil     )
    (#x0021b3 "DOWNWARDS ARROW WITH TIP RIGHTWARDS"    nil     )
    (#x0021b4 "RIGHTWARDS ARROW WITH CORNER DOWNWARDS" nil     )
    (#x0021b5 "DOWNWARDS ARROW WITH CORNER LEFTWARDS"  nil     )
    (#x0021b6 "ANTICLOCKWISE TOP SEMICIRCLE ARROW"     "cularr")
    (#x0021b7 "CLOCKWISE TOP SEMICIRCLE ARROW"         "curarr")
    (#x0021b8 "NORTH WEST ARROW TO LONG BAR"           nil     )
    (#x0021b9 "LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR" nil     )
    (#x0021ba "ANTICLOCKWISE OPEN CIRCLE ARROW"        "olarr" )
    (#x0021bb "CLOCKWISE OPEN CIRCLE ARROW"            "orarr" )
    (#x0021bc "LEFTWARDS HARPOON WITH BARB UPWARDS"    "lharu" )
    (#x0021bd "LEFTWARDS HARPOON WITH BARB DOWNWARDS"  "lhard" )
    (#x0021be "UPWARDS HARPOON WITH BARB RIGHTWARDS"   "uharr" )
    (#x0021bf "UPWARDS HARPOON WITH BARB LEFTWARDS"    "uharl" )
    (#x0021c0 "RIGHTWARDS HARPOON WITH BARB UPWARDS"   "rharu" )
    (#x0021c1 "RIGHTWARDS HARPOON WITH BARB DOWNWARDS" "rhard" )
    (#x0021c2 "DOWNWARDS HARPOON WITH BARB RIGHTWARDS" "dharr" )
    (#x0021c3 "DOWNWARDS HARPOON WITH BARB LEFTWARDS"  "dharl" )
    (#x0021c4 "RIGHTWARDS ARROW OVER LEFTWARDS ARROW"  "rlarr2")
    (#x0021c5 "UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW" nil     )
    (#x0021c6 "LEFTWARDS ARROW OVER RIGHTWARDS ARROW"  "lrarr2")
    (#x0021c7 "LEFTWARDS PAIRED ARROWS"                "larr2" )
    (#x0021c8 "UPWARDS PAIRED ARROWS"                  "uarr2" )
    (#x0021c9 "RIGHTWARDS PAIRED ARROWS"               "rarr2" )
    (#x0021ca "DOWNWARDS PAIRED ARROWS"                "darr2" )
    (#x0021cb "LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON" "lrhar2")
    (#x0021cc "RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON" "rlhar2")
    (#x0021cd "LEFTWARDS DOUBLE ARROW WITH STROKE"     "nlArr" )
    (#x0021ce "LEFT RIGHT DOUBLE ARROW WITH STROKE"    "nhArr" )
    (#x0021cf "RIGHTWARDS DOUBLE ARROW WITH STROKE"    "nrArr" )
    (#x0021d0 "LEFTWARDS DOUBLE ARROW"                 "lArr"  )
    (#x0021d1 "UPWARDS DOUBLE ARROW"                   "uArr"  )
    (#x0021d2 "RIGHTWARDS DOUBLE ARROW"                "rArr"  )
    (#x0021d3 "DOWNWARDS DOUBLE ARROW"                 "dArr"  )
    (#x0021d4 "LEFT RIGHT DOUBLE ARROW"                "hArr"  )
    (#x0021d5 "UP DOWN DOUBLE ARROW"                   "vArr"  )
    (#x0021d6 "NORTH WEST DOUBLE ARROW"                nil     )
    (#x0021d7 "NORTH EAST DOUBLE ARROW"                nil     )
    (#x0021d8 "SOUTH EAST DOUBLE ARROW"                nil     )
    (#x0021d9 "SOUTH WEST DOUBLE ARROW"                nil     )
    (#x0021da "LEFTWARDS TRIPLE ARROW"                 "lAarr" )
    (#x0021db "RIGHTWARDS TRIPLE ARROW"                "rAarr" )
    (#x0021dc "LEFTWARDS SQUIGGLE ARROW"               nil     )
    (#x0021dd "RIGHTWARDS SQUIGGLE ARROW"              nil     )
    (#x0021de "UPWARDS ARROW WITH DOUBLE STROKE"       nil     )
    (#x0021df "DOWNWARDS ARROW WITH DOUBLE STROKE"     nil     )
    (#x0021e0 "LEFTWARDS DASHED ARROW"                 nil     )
    (#x0021e1 "UPWARDS DASHED ARROW"                   nil     )
    (#x0021e2 "RIGHTWARDS DASHED ARROW"                nil     )
    (#x0021e3 "DOWNWARDS DASHED ARROW"                 nil     )
    (#x0021e4 "LEFTWARDS ARROW TO BAR"                 nil     )
    (#x0021e5 "RIGHTWARDS ARROW TO BAR"                nil     )
    (#x0021e6 "LEFTWARDS WHITE ARROW"                  nil     )
    (#x0021e7 "UPWARDS WHITE ARROW"                    nil     )
    (#x0021e8 "RIGHTWARDS WHITE ARROW"                 nil     )
    (#x0021e9 "DOWNWARDS WHITE ARROW"                  nil     )
    (#x0021ea "UPWARDS WHITE ARROW FROM BAR"           nil     )
    (#x0021eb "UPWARDS WHITE ARROW ON PEDESTAL"        nil     )
    (#x0021ec "UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR" nil     )
    (#x0021ed "UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR" nil     )
    (#x0021ee "UPWARDS WHITE DOUBLE ARROW"             nil     )
    (#x0021ef "UPWARDS WHITE DOUBLE ARROW ON PEDESTAL" nil     )
    (#x0021f0 "RIGHTWARDS WHITE ARROW FROM WALL"       nil     )
    (#x0021f1 "NORTH WEST ARROW TO CORNER"             nil     )
    (#x0021f2 "SOUTH EAST ARROW TO CORNER"             nil     )
    (#x0021f3 "UP DOWN WHITE ARROW"                    nil     )
    (#x0021f4 "RIGHT ARROW WITH SMALL CIRCLE"          nil     )
    (#x0021f5 "DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW" nil     )
    (#x0021f6 "THREE RIGHTWARDS ARROWS"                nil     )
    (#x0021f7 "LEFTWARDS ARROW WITH VERTICAL STROKE"   nil     )
    (#x0021f8 "RIGHTWARDS ARROW WITH VERTICAL STROKE"  nil     )
    (#x0021f9 "LEFT RIGHT ARROW WITH VERTICAL STROKE"  nil     )
    (#x0021fa "LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE" nil     )
    (#x0021fb "RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE" nil     )
    (#x0021fc "LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE" nil     )
    (#x0021fd "LEFTWARDS OPEN-HEADED ARROW"            nil     )
    (#x0021fe "RIGHTWARDS OPEN-HEADED ARROW"           nil     )
    (#x0021ff "LEFT RIGHT OPEN-HEADED ARROW"           nil     )
    (#x002200 "FOR ALL"                                "forall")
    (#x002201 "COMPLEMENT"                             "comp"  )
    (#x002202 "PARTIAL DIFFERENTIAL"                   "part"  )
    (#x002203 "THERE EXISTS"                           "exist" )
    (#x002204 "THERE DOES NOT EXIST"                   "nexist")
    (#x002205 "EMPTY SET"                              "empty" )
    (#x002206 "INCREMENT"                              nil     )
    (#x002207 "NABLA"                                  "nabla" )
    (#x002208 "ELEMENT OF"                             "isin"  )
    (#x002209 "NOT AN ELEMENT OF"                      "notin" )
    (#x00220a "SMALL ELEMENT OF"                       nil     )
    (#x00220b "CONTAINS AS MEMBER"                     "ni"    )
    (#x00220c "DOES NOT CONTAIN AS MEMBER"             nil     )
    (#x00220d "SMALL CONTAINS AS MEMBER"               nil     )
    (#x00220e "END OF PROOF"                           nil     )
    (#x00220f "N-ARY PRODUCT"                          "prod"  )
    (#x002210 "N-ARY COPRODUCT"                        "coprod")
    (#x002211 "N-ARY SUMMATION"                        "sum"   )
    (#x002212 "MINUS SIGN"                             "minus" )
    (#x002213 "MINUS-OR-PLUS SIGN"                     "mnplus")
    (#x002214 "DOT PLUS"                               "plusdo")
    (#x002215 "DIVISION SLASH"                         nil     )
    (#x002216 "SET MINUS"                              "setmn" )
    (#x002217 "ASTERISK OPERATOR"                      "lowast")
    (#x002218 "RING OPERATOR"                          "compfn")
    (#x002219 "BULLET OPERATOR"                        nil     )
    (#x00221a "SQUARE ROOT"                            "radic" )
    (#x00221b "CUBE ROOT"                              nil     )
    (#x00221c "FOURTH ROOT"                            nil     )
    (#x00221d "PROPORTIONAL TO"                        "prop"  )
    (#x00221e "INFINITY"                               "infin" )
    (#x00221f "RIGHT ANGLE"                            "ang90" )
    (#x002220 "ANGLE"                                  "ang"   )
    (#x002221 "MEASURED ANGLE"                         "angmsd")
    (#x002222 "SPHERICAL ANGLE"                        "angsph")
    (#x002223 "DIVIDES"                                "mid"   )
    (#x002224 "DOES NOT DIVIDE"                        "nmid"  )
    (#x002225 "PARALLEL TO"                            "par"   )
    (#x002226 "NOT PARALLEL TO"                        "npar"  )
    (#x002227 "LOGICAL AND"                            "and"   )
    (#x002228 "LOGICAL OR"                             "or"    )
    (#x002229 "INTERSECTION"                           "cap"   )
    (#x00222a "UNION"                                  "cup"   )
    (#x00222b "INTEGRAL"                               "int"   )
    (#x00222c "DOUBLE INTEGRAL"                        nil     )
    (#x00222d "TRIPLE INTEGRAL"                        nil     )
    (#x00222e "CONTOUR INTEGRAL"                       "conint")
    (#x00222f "SURFACE INTEGRAL"                       nil     )
    (#x002230 "VOLUME INTEGRAL"                        nil     )
    (#x002231 "CLOCKWISE INTEGRAL"                     nil     )
    (#x002232 "CLOCKWISE CONTOUR INTEGRAL"             nil     )
    (#x002233 "ANTICLOCKWISE CONTOUR INTEGRAL"         nil     )
    (#x002234 "THEREFORE"                              "there4")
    (#x002235 "BECAUSE"                                "becaus")
    (#x002236 "RATIO"                                  nil     )
    (#x002237 "PROPORTION"                             nil     )
    (#x002238 "DOT MINUS"                              nil     )
    (#x002239 "EXCESS"                                 nil     )
    (#x00223a "GEOMETRIC PROPORTION"                   nil     )
    (#x00223b "HOMOTHETIC"                             nil     )
    (#x00223c "TILDE OPERATOR"                         "sim"   )
    (#x00223d "REVERSED TILDE"                         "bsim"  )
    (#x00223e "INVERTED LAZY S"                        nil     )
    (#x00223f "SINE WAVE"                              nil     )
    (#x002240 "WREATH PRODUCT"                         "wreath")
    (#x002241 "NOT TILDE"                              "nsim"  )
    (#x002242 "MINUS TILDE"                            nil     )
    (#x002243 "ASYMPTOTICALLY EQUAL TO"                "sime"  )
    (#x002244 "NOT ASYMPTOTICALLY EQUAL TO"            "nsime" )
    (#x002245 "APPROXIMATELY EQUAL TO"                 "cong"  )
    (#x002246 "APPROXIMATELY BUT NOT ACTUALLY EQUAL TO" nil     )
    (#x002247 "NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO" "ncong" )
    (#x002248 "ALMOST EQUAL TO"                        "asymp" )
    (#x002249 "NOT ALMOST EQUAL TO"                    "nap"   )
    (#x00224a "ALMOST EQUAL OR EQUAL TO"               "ape"   )
    (#x00224b "TRIPLE TILDE"                           nil     )
    (#x00224c "ALL EQUAL TO"                           "bcong" )
    (#x00224d "EQUIVALENT TO"                          nil     )
    (#x00224e "GEOMETRICALLY EQUIVALENT TO"            "bump"  )
    (#x00224f "DIFFERENCE BETWEEN"                     "bumpe" )
    (#x002250 "APPROACHES THE LIMIT"                   "esdot" )
    (#x002251 "GEOMETRICALLY EQUAL TO"                 "eDot"  )
    (#x002252 "APPROXIMATELY EQUAL TO OR THE IMAGE OF" "efDot" )
    (#x002253 "IMAGE OF OR APPROXIMATELY EQUAL TO"     "erDot" )
    (#x002254 "COLON EQUALS"                           "colone")
    (#x002255 "EQUALS COLON"                           "ecolon")
    (#x002256 "RING IN EQUAL TO"                       "ecir"  )
    (#x002257 "RING EQUAL TO"                          "cire"  )
    (#x002258 "CORRESPONDS TO"                         nil     )
    (#x002259 "ESTIMATES"                              "wedgeq")
    (#x00225a "EQUIANGULAR TO"                         nil     )
    (#x00225b "STAR EQUALS"                            nil     )
    (#x00225c "DELTA EQUAL TO"                         "trie"  )
    (#x00225d "EQUAL TO BY DEFINITION"                 nil     )
    (#x00225e "MEASURED BY"                            nil     )
    (#x00225f "QUESTIONED EQUAL TO"                    nil     )
    (#x002260 "NOT EQUAL TO"                           "ne"    )
    (#x002261 "IDENTICAL TO"                           "equiv" )
    (#x002262 "NOT IDENTICAL TO"                       "nequiv")
    (#x002263 "STRICTLY EQUIVALENT TO"                 nil     )
    (#x002264 "LESS-THAN OR EQUAL TO"                  "le"    )
    (#x002265 "GREATER-THAN OR EQUAL TO"               "ge"    )
    (#x002266 "LESS-THAN OVER EQUAL TO"                "lE"    )
    (#x002267 "GREATER-THAN OVER EQUAL TO"             "gE"    )
    (#x002268 "LESS-THAN BUT NOT EQUAL TO"             "lnE"   )
    (#x002269 "GREATER-THAN BUT NOT EQUAL TO"          "gnE"   )
    (#x00226a "MUCH LESS-THAN"                         "Lt"    )
    (#x00226b "MUCH GREATER-THAN"                      "Gt"    )
    (#x00226c "BETWEEN"                                "twixt" )
    (#x00226d "NOT EQUIVALENT TO"                      nil     )
    (#x00226e "NOT LESS-THAN"                          "nlt"   )
    (#x00226f "NOT GREATER-THAN"                       "ngt"   )
    (#x002270 "NEITHER LESS-THAN NOR EQUAL TO"         "nle"   )
    (#x002271 "NEITHER GREATER-THAN NOR EQUAL TO"      "nge"   )
    (#x002272 "LESS-THAN OR EQUIVALENT TO"             "lsim"  )
    (#x002273 "GREATER-THAN OR EQUIVALENT TO"          "gsim"  )
    (#x002274 "NEITHER LESS-THAN NOR EQUIVALENT TO"    nil     )
    (#x002275 "NEITHER GREATER-THAN NOR EQUIVALENT TO" nil     )
    (#x002276 "LESS-THAN OR GREATER-THAN"              "lg"    )
    (#x002277 "GREATER-THAN OR LESS-THAN"              "gl"    )
    (#x002278 "NEITHER LESS-THAN NOR GREATER-THAN"     nil     )
    (#x002279 "NEITHER GREATER-THAN NOR LESS-THAN"     nil     )
    (#x00227a "PRECEDES"                               "pr"    )
    (#x00227b "SUCCEEDS"                               "sc"    )
    (#x00227c "PRECEDES OR EQUAL TO"                   "cupre" )
    (#x00227d "SUCCEEDS OR EQUAL TO"                   "sccue" )
    (#x00227e "PRECEDES OR EQUIVALENT TO"              "prsim" )
    (#x00227f "SUCCEEDS OR EQUIVALENT TO"              "scsim" )
    (#x002280 "DOES NOT PRECEDE"                       "npr"   )
    (#x002281 "DOES NOT SUCCEED"                       "nsc"   )
    (#x002282 "SUBSET OF"                              "sub"   )
    (#x002283 "SUPERSET OF"                            "sup"   )
    (#x002284 "NOT A SUBSET OF"                        "nsub"  )
    (#x002285 "NOT A SUPERSET OF"                      "nsup"  )
    (#x002286 "SUBSET OF OR EQUAL TO"                  "sube"  )
    (#x002287 "SUPERSET OF OR EQUAL TO"                "supe"  )
    (#x002288 "NEITHER A SUBSET OF NOR EQUAL TO"       "nsube" )
    (#x002289 "NEITHER A SUPERSET OF NOR EQUAL TO"     "nsupe" )
    (#x00228a "SUBSET OF WITH NOT EQUAL TO"            "subne" )
    (#x00228b "SUPERSET OF WITH NOT EQUAL TO"          "supne" )
    (#x00228c "MULTISET"                               nil     )
    (#x00228d "MULTISET MULTIPLICATION"                nil     )
    (#x00228e "MULTISET UNION"                         "uplus" )
    (#x00228f "SQUARE IMAGE OF"                        "sqsub" )
    (#x002290 "SQUARE ORIGINAL OF"                     "sqsup" )
    (#x002291 "SQUARE IMAGE OF OR EQUAL TO"            "sqsube")
    (#x002292 "SQUARE ORIGINAL OF OR EQUAL TO"         "sqsupe")
    (#x002293 "SQUARE CAP"                             "sqcap" )
    (#x002294 "SQUARE CUP"                             "sqcup" )
    (#x002295 "CIRCLED PLUS"                           "oplus" )
    (#x002296 "CIRCLED MINUS"                          "ominus")
    (#x002297 "CIRCLED TIMES"                          "otimes")
    (#x002298 "CIRCLED DIVISION SLASH"                 "osol"  )
    (#x002299 "CIRCLED DOT OPERATOR"                   "odot"  )
    (#x00229a "CIRCLED RING OPERATOR"                  "ocir"  )
    (#x00229b "CIRCLED ASTERISK OPERATOR"              "oast"  )
    (#x00229c "CIRCLED EQUALS"                         nil     )
    (#x00229d "CIRCLED DASH"                           "odash" )
    (#x00229e "SQUARED PLUS"                           "plusb" )
    (#x00229f "SQUARED MINUS"                          "minusb")
    (#x0022a0 "SQUARED TIMES"                          "timesb")
    (#x0022a1 "SQUARED DOT OPERATOR"                   "sdotb" )
    (#x0022a2 "RIGHT TACK"                             "vdash" )
    (#x0022a3 "LEFT TACK"                              "dashv" )
    (#x0022a4 "DOWN TACK"                              "top"   )
    (#x0022a5 "UP TACK"                                "bottom")
    (#x0022a6 "ASSERTION"                              nil     )
    (#x0022a7 "MODELS"                                 "models")
    (#x0022a8 "TRUE"                                   "vDash" )
    (#x0022a9 "FORCES"                                 "Vdash" )
    (#x0022aa "TRIPLE VERTICAL BAR RIGHT TURNSTILE"    "Vvdash")
    (#x0022ab "DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" nil     )
    (#x0022ac "DOES NOT PROVE"                         "nvdash")
    (#x0022ad "NOT TRUE"                               "nvDash")
    (#x0022ae "DOES NOT FORCE"                         "nVdash")
    (#x0022af "NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" "nVDash")
    (#x0022b0 "PRECEDES UNDER RELATION"                nil     )
    (#x0022b1 "SUCCEEDS UNDER RELATION"                nil     )
    (#x0022b2 "NORMAL SUBGROUP OF"                     "vltri" )
    (#x0022b3 "CONTAINS AS NORMAL SUBGROUP"            "vrtri" )
    (#x0022b4 "NORMAL SUBGROUP OF OR EQUAL TO"         "ltrie" )
    (#x0022b5 "CONTAINS AS NORMAL SUBGROUP OR EQUAL TO" "rtrie" )
    (#x0022b6 "ORIGINAL OF"                            nil     )
    (#x0022b7 "IMAGE OF"                               nil     )
    (#x0022b8 "MULTIMAP"                               "mumap" )
    (#x0022b9 "HERMITIAN CONJUGATE MATRIX"             nil     )
    (#x0022ba "INTERCALATE"                            "intcal")
    (#x0022bb "XOR"                                    "veebar")
    (#x0022bc "NAND"                                   nil     )
    (#x0022bd "NOR"                                    nil     )
    (#x0022be "RIGHT ANGLE WITH ARC"                   nil     )
    (#x0022bf "RIGHT TRIANGLE"                         nil     )
    (#x0022c0 "N-ARY LOGICAL AND"                      nil     )
    (#x0022c1 "N-ARY LOGICAL OR"                       nil     )
    (#x0022c2 "N-ARY INTERSECTION"                     nil     )
    (#x0022c3 "N-ARY UNION"                            nil     )
    (#x0022c4 "DIAMOND OPERATOR"                       "diam"  )
    (#x0022c5 "DOT OPERATOR"                           "sdot"  )
    (#x0022c6 "STAR OPERATOR"                          "sstarf")
    (#x0022c7 "DIVISION TIMES"                         "divonx")
    (#x0022c8 "BOWTIE"                                 "bowtie")
    (#x0022c9 "LEFT NORMAL FACTOR SEMIDIRECT PRODUCT"  "ltimes")
    (#x0022ca "RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT" "rtimes")
    (#x0022cb "LEFT SEMIDIRECT PRODUCT"                "lthree")
    (#x0022cc "RIGHT SEMIDIRECT PRODUCT"               "rthree")
    (#x0022cd "REVERSED TILDE EQUALS"                  "bsime" )
    (#x0022ce "CURLY LOGICAL OR"                       "cuvee" )
    (#x0022cf "CURLY LOGICAL AND"                      "cuwed" )
    (#x0022d0 "DOUBLE SUBSET"                          "Sub"   )
    (#x0022d1 "DOUBLE SUPERSET"                        "Sup"   )
    (#x0022d2 "DOUBLE INTERSECTION"                    "Cap"   )
    (#x0022d3 "DOUBLE UNION"                           "Cup"   )
    (#x0022d4 "PITCHFORK"                              "fork"  )
    (#x0022d5 "EQUAL AND PARALLEL TO"                  nil     )
    (#x0022d6 "LESS-THAN WITH DOT"                     "ldot"  )
    (#x0022d7 "GREATER-THAN WITH DOT"                  "gsdot" )
    (#x0022d8 "VERY MUCH LESS-THAN"                    "Ll"    )
    (#x0022d9 "VERY MUCH GREATER-THAN"                 "Gg"    )
    (#x0022da "LESS-THAN EQUAL TO OR GREATER-THAN"     "leg"   )
    (#x0022db "GREATER-THAN EQUAL TO OR LESS-THAN"     "gel"   )
    (#x0022dc "EQUAL TO OR LESS-THAN"                  nil     )
    (#x0022dd "EQUAL TO OR GREATER-THAN"               nil     )
    (#x0022de "EQUAL TO OR PRECEDES"                   "cuepr" )
    (#x0022df "EQUAL TO OR SUCCEEDS"                   "cuesc" )
    (#x0022e0 "DOES NOT PRECEDE OR EQUAL"              nil     )
    (#x0022e1 "DOES NOT SUCCEED OR EQUAL"              nil     )
    (#x0022e2 "NOT SQUARE IMAGE OF OR EQUAL TO"        nil     )
    (#x0022e3 "NOT SQUARE ORIGINAL OF OR EQUAL TO"     nil     )
    (#x0022e4 "SQUARE IMAGE OF OR NOT EQUAL TO"        nil     )
    (#x0022e5 "SQUARE ORIGINAL OF OR NOT EQUAL TO"     nil     )
    (#x0022e6 "LESS-THAN BUT NOT EQUIVALENT TO"        "lnsim" )
    (#x0022e7 "GREATER-THAN BUT NOT EQUIVALENT TO"     "gnsim" )
    (#x0022e8 "PRECEDES BUT NOT EQUIVALENT TO"         "prnsim")
    (#x0022e9 "SUCCEEDS BUT NOT EQUIVALENT TO"         "scnsim")
    (#x0022ea "NOT NORMAL SUBGROUP OF"                 "nltri" )
    (#x0022eb "DOES NOT CONTAIN AS NORMAL SUBGROUP"    "nrtri" )
    (#x0022ec "NOT NORMAL SUBGROUP OF OR EQUAL TO"     "nltrie")
    (#x0022ed "DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL" "nrtrie")
    (#x0022ee "VERTICAL ELLIPSIS"                      "vellip")
    (#x0022ef "MIDLINE HORIZONTAL ELLIPSIS"            nil     )
    (#x0022f0 "UP RIGHT DIAGONAL ELLIPSIS"             nil     )
    (#x0022f1 "DOWN RIGHT DIAGONAL ELLIPSIS"           nil     )
    (#x0022f2 "ELEMENT OF WITH LONG HORIZONTAL STROKE" nil     )
    (#x0022f3 "ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" nil     )
    (#x0022f4 "SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" nil     )
    (#x0022f5 "ELEMENT OF WITH DOT ABOVE"              nil     )
    (#x0022f6 "ELEMENT OF WITH OVERBAR"                nil     )
    (#x0022f7 "SMALL ELEMENT OF WITH OVERBAR"          nil     )
    (#x0022f8 "ELEMENT OF WITH UNDERBAR"               nil     )
    (#x0022f9 "ELEMENT OF WITH TWO HORIZONTAL STROKES" nil     )
    (#x0022fa "CONTAINS WITH LONG HORIZONTAL STROKE"   nil     )
    (#x0022fb "CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" nil     )
    (#x0022fc "SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" nil     )
    (#x0022fd "CONTAINS WITH OVERBAR"                  nil     )
    (#x0022fe "SMALL CONTAINS WITH OVERBAR"            nil     )
    (#x0022ff "Z NOTATION BAG MEMBERSHIP"              nil     )
    (#x002300 "DIAMETER SIGN"                          nil     )
    (#x002301 "ELECTRIC ARROW"                         nil     )
    (#x002302 "HOUSE"                                  nil     )
    (#x002303 "UP ARROWHEAD"                           nil     )
    (#x002304 "DOWN ARROWHEAD"                         nil     )
    (#x002305 "PROJECTIVE"                             "barwed")
    (#x002306 "PERSPECTIVE"                            "Barwed")
    (#x002307 "WAVY LINE"                              nil     )
    (#x002308 "LEFT CEILING"                           "lceil" )
    (#x002309 "RIGHT CEILING"                          "rceil" )
    (#x00230a "LEFT FLOOR"                             "lfloor")
    (#x00230b "RIGHT FLOOR"                            "rfloor")
    (#x00230c "BOTTOM RIGHT CROP"                      "drcrop")
    (#x00230d "BOTTOM LEFT CROP"                       "dlcrop")
    (#x00230e "TOP RIGHT CROP"                         "urcrop")
    (#x00230f "TOP LEFT CROP"                          "ulcrop")
    (#x002310 "REVERSED NOT SIGN"                      nil     )
    (#x002311 "SQUARE LOZENGE"                         nil     )
    (#x002312 "ARC"                                    nil     )
    (#x002313 "SEGMENT"                                nil     )
    (#x002314 "SECTOR"                                 nil     )
    (#x002315 "TELEPHONE RECORDER"                     "telrec")
    (#x002316 "POSITION INDICATOR"                     "target")
    (#x002317 "VIEWDATA SQUARE"                        nil     )
    (#x002318 "PLACE OF INTEREST SIGN"                 nil     )
    (#x002319 "TURNED NOT SIGN"                        nil     )
    (#x00231a "WATCH"                                  nil     )
    (#x00231b "HOURGLASS"                              nil     )
    (#x00231c "TOP LEFT CORNER"                        "ulcorn")
    (#x00231d "TOP RIGHT CORNER"                       "urcorn")
    (#x00231e "BOTTOM LEFT CORNER"                     "dlcorn")
    (#x00231f "BOTTOM RIGHT CORNER"                    "drcorn")
    (#x002320 "TOP HALF INTEGRAL"                      nil     )
    (#x002321 "BOTTOM HALF INTEGRAL"                   nil     )
    (#x002322 "FROWN"                                  "frown" )
    (#x002323 "SMILE"                                  "smile" )
    (#x002324 "UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS" nil     )
    (#x002325 "OPTION KEY"                             nil     )
    (#x002326 "ERASE TO THE RIGHT"                     nil     )
    (#x002327 "X IN A RECTANGLE BOX"                   nil     )
    (#x002328 "KEYBOARD"                               nil     )
    (#x002329 "LEFT-POINTING ANGLE BRACKET"            "lang"  )
    (#x00232a "RIGHT-POINTING ANGLE BRACKET"           "rang"  )
    (#x00232b "ERASE TO THE LEFT"                      nil     )
    (#x00232c "BENZENE RING"                           nil     )
    (#x00232d "CYLINDRICITY"                           nil     )
    (#x00232e "ALL AROUND-PROFILE"                     nil     )
    (#x00232f "SYMMETRY"                               nil     )
    (#x002330 "TOTAL RUNOUT"                           nil     )
    (#x002331 "DIMENSION ORIGIN"                       nil     )
    (#x002332 "CONICAL TAPER"                          nil     )
    (#x002333 "SLOPE"                                  nil     )
    (#x002334 "COUNTERBORE"                            nil     )
    (#x002335 "COUNTERSINK"                            nil     )
    (#x002336 "APL FUNCTIONAL SYMBOL I-BEAM"           nil     )
    (#x002337 "APL FUNCTIONAL SYMBOL SQUISH QUAD"      nil     )
    (#x002338 "APL FUNCTIONAL SYMBOL QUAD EQUAL"       nil     )
    (#x002339 "APL FUNCTIONAL SYMBOL QUAD DIVIDE"      nil     )
    (#x00233a "APL FUNCTIONAL SYMBOL QUAD DIAMOND"     nil     )
    (#x00233b "APL FUNCTIONAL SYMBOL QUAD JOT"         nil     )
    (#x00233c "APL FUNCTIONAL SYMBOL QUAD CIRCLE"      nil     )
    (#x00233d "APL FUNCTIONAL SYMBOL CIRCLE STILE"     nil     )
    (#x00233e "APL FUNCTIONAL SYMBOL CIRCLE JOT"       nil     )
    (#x00233f "APL FUNCTIONAL SYMBOL SLASH BAR"        nil     )
    (#x002340 "APL FUNCTIONAL SYMBOL BACKSLASH BAR"    nil     )
    (#x002341 "APL FUNCTIONAL SYMBOL QUAD SLASH"       nil     )
    (#x002342 "APL FUNCTIONAL SYMBOL QUAD BACKSLASH"   nil     )
    (#x002343 "APL FUNCTIONAL SYMBOL QUAD LESS-THAN"   nil     )
    (#x002344 "APL FUNCTIONAL SYMBOL QUAD GREATER-THAN" nil     )
    (#x002345 "APL FUNCTIONAL SYMBOL LEFTWARDS VANE"   nil     )
    (#x002346 "APL FUNCTIONAL SYMBOL RIGHTWARDS VANE"  nil     )
    (#x002347 "APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW" nil     )
    (#x002348 "APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW" nil     )
    (#x002349 "APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH" nil     )
    (#x00234a "APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR" nil     )
    (#x00234b "APL FUNCTIONAL SYMBOL DELTA STILE"      nil     )
    (#x00234c "APL FUNCTIONAL SYMBOL QUAD DOWN CARET"  nil     )
    (#x00234d "APL FUNCTIONAL SYMBOL QUAD DELTA"       nil     )
    (#x00234e "APL FUNCTIONAL SYMBOL DOWN TACK JOT"    nil     )
    (#x00234f "APL FUNCTIONAL SYMBOL UPWARDS VANE"     nil     )
    (#x002350 "APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW" nil     )
    (#x002351 "APL FUNCTIONAL SYMBOL UP TACK OVERBAR"  nil     )
    (#x002352 "APL FUNCTIONAL SYMBOL DEL STILE"        nil     )
    (#x002353 "APL FUNCTIONAL SYMBOL QUAD UP CARET"    nil     )
    (#x002354 "APL FUNCTIONAL SYMBOL QUAD DEL"         nil     )
    (#x002355 "APL FUNCTIONAL SYMBOL UP TACK JOT"      nil     )
    (#x002356 "APL FUNCTIONAL SYMBOL DOWNWARDS VANE"   nil     )
    (#x002357 "APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW" nil     )
    (#x002358 "APL FUNCTIONAL SYMBOL QUOTE UNDERBAR"   nil     )
    (#x002359 "APL FUNCTIONAL SYMBOL DELTA UNDERBAR"   nil     )
    (#x00235a "APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR" nil     )
    (#x00235b "APL FUNCTIONAL SYMBOL JOT UNDERBAR"     nil     )
    (#x00235c "APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR"  nil     )
    (#x00235d "APL FUNCTIONAL SYMBOL UP SHOE JOT"      nil     )
    (#x00235e "APL FUNCTIONAL SYMBOL QUOTE QUAD"       nil     )
    (#x00235f "APL FUNCTIONAL SYMBOL CIRCLE STAR"      nil     )
    (#x002360 "APL FUNCTIONAL SYMBOL QUAD COLON"       nil     )
    (#x002361 "APL FUNCTIONAL SYMBOL UP TACK DIAERESIS" nil     )
    (#x002362 "APL FUNCTIONAL SYMBOL DEL DIAERESIS"    nil     )
    (#x002363 "APL FUNCTIONAL SYMBOL STAR DIAERESIS"   nil     )
    (#x002364 "APL FUNCTIONAL SYMBOL JOT DIAERESIS"    nil     )
    (#x002365 "APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS" nil     )
    (#x002366 "APL FUNCTIONAL SYMBOL DOWN SHOE STILE"  nil     )
    (#x002367 "APL FUNCTIONAL SYMBOL LEFT SHOE STILE"  nil     )
    (#x002368 "APL FUNCTIONAL SYMBOL TILDE DIAERESIS"  nil     )
    (#x002369 "APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS" nil     )
    (#x00236a "APL FUNCTIONAL SYMBOL COMMA BAR"        nil     )
    (#x00236b "APL FUNCTIONAL SYMBOL DEL TILDE"        nil     )
    (#x00236c "APL FUNCTIONAL SYMBOL ZILDE"            nil     )
    (#x00236d "APL FUNCTIONAL SYMBOL STILE TILDE"      nil     )
    (#x00236e "APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR" nil     )
    (#x00236f "APL FUNCTIONAL SYMBOL QUAD NOT EQUAL"   nil     )
    (#x002370 "APL FUNCTIONAL SYMBOL QUAD QUESTION"    nil     )
    (#x002371 "APL FUNCTIONAL SYMBOL DOWN CARET TILDE" nil     )
    (#x002372 "APL FUNCTIONAL SYMBOL UP CARET TILDE"   nil     )
    (#x002373 "APL FUNCTIONAL SYMBOL IOTA"             nil     )
    (#x002374 "APL FUNCTIONAL SYMBOL RHO"              nil     )
    (#x002375 "APL FUNCTIONAL SYMBOL OMEGA"            nil     )
    (#x002376 "APL FUNCTIONAL SYMBOL ALPHA UNDERBAR"   nil     )
    (#x002377 "APL FUNCTIONAL SYMBOL EPSILON UNDERBAR" nil     )
    (#x002378 "APL FUNCTIONAL SYMBOL IOTA UNDERBAR"    nil     )
    (#x002379 "APL FUNCTIONAL SYMBOL OMEGA UNDERBAR"   nil     )
    (#x00237a "APL FUNCTIONAL SYMBOL ALPHA"            nil     )
    (#x00237b "NOT CHECK MARK"                         nil     )
    (#x00237c "RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW" nil     )
    (#x00237d "SHOULDERED OPEN BOX"                    nil     )
    (#x00237e "BELL SYMBOL"                            nil     )
    (#x00237f "VERTICAL LINE WITH MIDDLE DOT"          nil     )
    (#x002380 "INSERTION SYMBOL"                       nil     )
    (#x002381 "CONTINUOUS UNDERLINE SYMBOL"            nil     )
    (#x002382 "DISCONTINUOUS UNDERLINE SYMBOL"         nil     )
    (#x002383 "EMPHASIS SYMBOL"                        nil     )
    (#x002384 "COMPOSITION SYMBOL"                     nil     )
    (#x002385 "WHITE SQUARE WITH CENTRE VERTICAL LINE" nil     )
    (#x002386 "ENTER SYMBOL"                           nil     )
    (#x002387 "ALTERNATIVE KEY SYMBOL"                 nil     )
    (#x002388 "HELM SYMBOL"                            nil     )
    (#x002389 "CIRCLED HORIZONTAL BAR WITH NOTCH"      nil     )
    (#x00238a "CIRCLED TRIANGLE DOWN"                  nil     )
    (#x00238b "BROKEN CIRCLE WITH NORTHWEST ARROW"     nil     )
    (#x00238c "UNDO SYMBOL"                            nil     )
    (#x00238d "MONOSTABLE SYMBOL"                      nil     )
    (#x00238e "HYSTERESIS SYMBOL"                      nil     )
    (#x00238f "OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL"      nil     )
    (#x002390 "OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL"      nil     )
    (#x002391 "PASSIVE-PULL-DOWN-OUTPUT SYMBOL"        nil     )
    (#x002392 "PASSIVE-PULL-UP-OUTPUT SYMBOL"          nil     )
    (#x002393 "DIRECT CURRENT SYMBOL FORM TWO"         nil     )
    (#x002394 "SOFTWARE-FUNCTION SYMBOL"               nil     )
    (#x002395 "APL FUNCTIONAL SYMBOL QUAD"             nil     )
    (#x002396 "DECIMAL SEPARATOR KEY SYMBOL"           nil     )
    (#x002397 "PREVIOUS PAGE"                          nil     )
    (#x002398 "NEXT PAGE"                              nil     )
    (#x002399 "PRINT SCREEN SYMBOL"                    nil     )
    (#x00239a "CLEAR SCREEN SYMBOL"                    nil     )
    (#x00239b "LEFT PARENTHESIS UPPER HOOK"            nil     )
    (#x00239c "LEFT PARENTHESIS EXTENSION"             nil     )
    (#x00239d "LEFT PARENTHESIS LOWER HOOK"            nil     )
    (#x00239e "RIGHT PARENTHESIS UPPER HOOK"           nil     )
    (#x00239f "RIGHT PARENTHESIS EXTENSION"            nil     )
    (#x0023a0 "RIGHT PARENTHESIS LOWER HOOK"           nil     )
    (#x0023a1 "LEFT SQUARE BRACKET UPPER CORNER"       nil     )
    (#x0023a2 "LEFT SQUARE BRACKET EXTENSION"          nil     )
    (#x0023a3 "LEFT SQUARE BRACKET LOWER CORNER"       nil     )
    (#x0023a4 "RIGHT SQUARE BRACKET UPPER CORNER"      nil     )
    (#x0023a5 "RIGHT SQUARE BRACKET EXTENSION"         nil     )
    (#x0023a6 "RIGHT SQUARE BRACKET LOWER CORNER"      nil     )
    (#x0023a7 "LEFT CURLY BRACKET UPPER HOOK"          nil     )
    (#x0023a8 "LEFT CURLY BRACKET MIDDLE PIECE"        nil     )
    (#x0023a9 "LEFT CURLY BRACKET LOWER HOOK"          nil     )
    (#x0023aa "CURLY BRACKET EXTENSION"                nil     )
    (#x0023ab "RIGHT CURLY BRACKET UPPER HOOK"         nil     )
    (#x0023ac "RIGHT CURLY BRACKET MIDDLE PIECE"       nil     )
    (#x0023ad "RIGHT CURLY BRACKET LOWER HOOK"         nil     )
    (#x0023ae "INTEGRAL EXTENSION"                     nil     )
    (#x0023af "HORIZONTAL LINE EXTENSION"              nil     )
    (#x0023b0 "UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION" nil     )
    (#x0023b1 "UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION" nil     )
    (#x0023b2 "SUMMATION TOP"                          nil     )
    (#x0023b3 "SUMMATION BOTTOM"                       nil     )
    (#x0023b4 "TOP SQUARE BRACKET"                     nil     )
    (#x0023b5 "BOTTOM SQUARE BRACKET"                  nil     )
    (#x0023b6 "BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET" nil     )
    (#x0023b7 "RADICAL SYMBOL BOTTOM"                  nil     )
    (#x0023b8 "LEFT VERTICAL BOX LINE"                 nil     )
    (#x0023b9 "RIGHT VERTICAL BOX LINE"                nil     )
    (#x0023ba "HORIZONTAL SCAN LINE-1"                 nil     )
    (#x0023bb "HORIZONTAL SCAN LINE-3"                 nil     )
    (#x0023bc "HORIZONTAL SCAN LINE-7"                 nil     )
    (#x0023bd "HORIZONTAL SCAN LINE-9"                 nil     )
    (#x0023be "DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT" nil     )
    (#x0023bf "DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT" nil     )
    (#x0023c0 "DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE" nil     )
    (#x0023c1 "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE" nil     )
    (#x0023c2 "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE" nil     )
    (#x0023c3 "DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE" nil     )
    (#x0023c4 "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE" nil     )
    (#x0023c5 "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE" nil     )
    (#x0023c6 "DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE" nil     )
    (#x0023c7 "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE" nil     )
    (#x0023c8 "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE" nil     )
    (#x0023c9 "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL" nil     )
    (#x0023ca "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL" nil     )
    (#x0023cb "DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT" nil     )
    (#x0023cc "DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT" nil     )
    (#x0023cd "SQUARE FOOT"                            nil     )
    (#x0023ce "RETURN SYMBOL"                          nil     )
    (#x0023cf "EJECT SYMBOL"                           nil     )
    (#x0023d0 "VERTICAL LINE EXTENSION"                nil     )
    (#x0023d1 "METRICAL BREVE"                         nil     )
    (#x0023d2 "METRICAL LONG OVER SHORT"               nil     )
    (#x0023d3 "METRICAL SHORT OVER LONG"               nil     )
    (#x0023d4 "METRICAL LONG OVER TWO SHORTS"          nil     )
    (#x0023d5 "METRICAL TWO SHORTS OVER LONG"          nil     )
    (#x0023d6 "METRICAL TWO SHORTS JOINED"             nil     )
    (#x0023d7 "METRICAL TRISEME"                       nil     )
    (#x0023d8 "METRICAL TETRASEME"                     nil     )
    (#x0023d9 "METRICAL PENTASEME"                     nil     )
    (#x0023da "EARTH GROUND"                           nil     )
    (#x0023db "FUSE"                                   nil     )
    (#x0023dc "TOP PARENTHESIS"                        nil     )
    (#x0023dd "BOTTOM PARENTHESIS"                     nil     )
    (#x0023de "TOP CURLY BRACKET"                      nil     )
    (#x0023df "BOTTOM CURLY BRACKET"                   nil     )
    (#x0023e0 "TOP TORTOISE SHELL BRACKET"             nil     )
    (#x0023e1 "BOTTOM TORTOISE SHELL BRACKET"          nil     )
    (#x0023e2 "WHITE TRAPEZIUM"                        nil     )
    (#x0023e3 "BENZENE RING WITH CIRCLE"               nil     )
    (#x0023e4 "STRAIGHTNESS"                           nil     )
    (#x0023e5 "FLATNESS"                               nil     )
    (#x0023e6 "AC CURRENT"                             nil     )
    (#x0023e7 "ELECTRICAL INTERSECTION"                nil     )
    (#x0023e8 "DECIMAL EXPONENT SYMBOL"                nil     )
    (#x0023e9 "BLACK RIGHT-POINTING DOUBLE TRIANGLE"   nil     )
    (#x0023ea "BLACK LEFT-POINTING DOUBLE TRIANGLE"    nil     )
    (#x0023eb "BLACK UP-POINTING DOUBLE TRIANGLE"      nil     )
    (#x0023ec "BLACK DOWN-POINTING DOUBLE TRIANGLE"    nil     )
    (#x0023ed "BLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR" nil     )
    (#x0023ee "BLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR" nil     )
    (#x0023ef "BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR" nil     )
    (#x0023f0 "ALARM CLOCK"                            nil     )
    (#x0023f1 "STOPWATCH"                              nil     )
    (#x0023f2 "TIMER CLOCK"                            nil     )
    (#x0023f3 "HOURGLASS WITH FLOWING SAND"            nil     )
    (#x0023f4 "BLACK MEDIUM LEFT-POINTING TRIANGLE"    nil     )
    (#x0023f5 "BLACK MEDIUM RIGHT-POINTING TRIANGLE"   nil     )
    (#x0023f6 "BLACK MEDIUM UP-POINTING TRIANGLE"      nil     )
    (#x0023f7 "BLACK MEDIUM DOWN-POINTING TRIANGLE"    nil     )
    (#x0023f8 "DOUBLE VERTICAL BAR"                    nil     )
    (#x0023f9 "BLACK SQUARE FOR STOP"                  nil     )
    (#x0023fa "BLACK CIRCLE FOR RECORD"                nil     )
    (#x0023fb "POWER SYMBOL"                           nil     )
    (#x0023fc "POWER ON-OFF SYMBOL"                    nil     )
    (#x0023fd "POWER ON SYMBOL"                        nil     )
    (#x0023fe "POWER SLEEP SYMBOL"                     nil     )
    (#x0023ff "OBSERVER EYE SYMBOL"                    nil     )
    (#x002400 "SYMBOL FOR NULL"                        nil     )
    (#x002401 "SYMBOL FOR START OF HEADING"            nil     )
    (#x002402 "SYMBOL FOR START OF TEXT"               nil     )
    (#x002403 "SYMBOL FOR END OF TEXT"                 nil     )
    (#x002404 "SYMBOL FOR END OF TRANSMISSION"         nil     )
    (#x002405 "SYMBOL FOR ENQUIRY"                     nil     )
    (#x002406 "SYMBOL FOR ACKNOWLEDGE"                 nil     )
    (#x002407 "SYMBOL FOR BELL"                        nil     )
    (#x002408 "SYMBOL FOR BACKSPACE"                   nil     )
    (#x002409 "SYMBOL FOR HORIZONTAL TABULATION"       nil     )
    (#x00240a "SYMBOL FOR LINE FEED"                   nil     )
    (#x00240b "SYMBOL FOR VERTICAL TABULATION"         nil     )
    (#x00240c "SYMBOL FOR FORM FEED"                   nil     )
    (#x00240d "SYMBOL FOR CARRIAGE RETURN"             nil     )
    (#x00240e "SYMBOL FOR SHIFT OUT"                   nil     )
    (#x00240f "SYMBOL FOR SHIFT IN"                    nil     )
    (#x002410 "SYMBOL FOR DATA LINK ESCAPE"            nil     )
    (#x002411 "SYMBOL FOR DEVICE CONTROL ONE"          nil     )
    (#x002412 "SYMBOL FOR DEVICE CONTROL TWO"          nil     )
    (#x002413 "SYMBOL FOR DEVICE CONTROL THREE"        nil     )
    (#x002414 "SYMBOL FOR DEVICE CONTROL FOUR"         nil     )
    (#x002415 "SYMBOL FOR NEGATIVE ACKNOWLEDGE"        nil     )
    (#x002416 "SYMBOL FOR SYNCHRONOUS IDLE"            nil     )
    (#x002417 "SYMBOL FOR END OF TRANSMISSION BLOCK"   nil     )
    (#x002418 "SYMBOL FOR CANCEL"                      nil     )
    (#x002419 "SYMBOL FOR END OF MEDIUM"               nil     )
    (#x00241a "SYMBOL FOR SUBSTITUTE"                  nil     )
    (#x00241b "SYMBOL FOR ESCAPE"                      nil     )
    (#x00241c "SYMBOL FOR FILE SEPARATOR"              nil     )
    (#x00241d "SYMBOL FOR GROUP SEPARATOR"             nil     )
    (#x00241e "SYMBOL FOR RECORD SEPARATOR"            nil     )
    (#x00241f "SYMBOL FOR UNIT SEPARATOR"              nil     )
    (#x002420 "SYMBOL FOR SPACE"                       nil     )
    (#x002421 "SYMBOL FOR DELETE"                      nil     )
    (#x002422 "BLANK SYMBOL"                           nil     )
    (#x002423 "OPEN BOX"                               "blank" )
    (#x002424 "SYMBOL FOR NEWLINE"                     nil     )
    (#x002425 "SYMBOL FOR DELETE FORM TWO"             nil     )
    (#x002426 "SYMBOL FOR SUBSTITUTE FORM TWO"         nil     )
    (#x002440 "OCR HOOK"                               nil     )
    (#x002441 "OCR CHAIR"                              nil     )
    (#x002442 "OCR FORK"                               nil     )
    (#x002443 "OCR INVERTED FORK"                      nil     )
    (#x002444 "OCR BELT BUCKLE"                        nil     )
    (#x002445 "OCR BOW TIE"                            nil     )
    (#x002446 "OCR BRANCH BANK IDENTIFICATION"         nil     )
    (#x002447 "OCR AMOUNT OF CHECK"                    nil     )
    (#x002448 "OCR DASH"                               nil     )
    (#x002449 "OCR CUSTOMER ACCOUNT NUMBER"            nil     )
    (#x00244a "OCR DOUBLE BACKSLASH"                   nil     )
    (#x002460 "CIRCLED DIGIT ONE"                      nil     )
    (#x002461 "CIRCLED DIGIT TWO"                      nil     )
    (#x002462 "CIRCLED DIGIT THREE"                    nil     )
    (#x002463 "CIRCLED DIGIT FOUR"                     nil     )
    (#x002464 "CIRCLED DIGIT FIVE"                     nil     )
    (#x002465 "CIRCLED DIGIT SIX"                      nil     )
    (#x002466 "CIRCLED DIGIT SEVEN"                    nil     )
    (#x002467 "CIRCLED DIGIT EIGHT"                    nil     )
    (#x002468 "CIRCLED DIGIT NINE"                     nil     )
    (#x002469 "CIRCLED NUMBER TEN"                     nil     )
    (#x00246a "CIRCLED NUMBER ELEVEN"                  nil     )
    (#x00246b "CIRCLED NUMBER TWELVE"                  nil     )
    (#x00246c "CIRCLED NUMBER THIRTEEN"                nil     )
    (#x00246d "CIRCLED NUMBER FOURTEEN"                nil     )
    (#x00246e "CIRCLED NUMBER FIFTEEN"                 nil     )
    (#x00246f "CIRCLED NUMBER SIXTEEN"                 nil     )
    (#x002470 "CIRCLED NUMBER SEVENTEEN"               nil     )
    (#x002471 "CIRCLED NUMBER EIGHTEEN"                nil     )
    (#x002472 "CIRCLED NUMBER NINETEEN"                nil     )
    (#x002473 "CIRCLED NUMBER TWENTY"                  nil     )
    (#x002474 "PARENTHESIZED DIGIT ONE"                nil     )
    (#x002475 "PARENTHESIZED DIGIT TWO"                nil     )
    (#x002476 "PARENTHESIZED DIGIT THREE"              nil     )
    (#x002477 "PARENTHESIZED DIGIT FOUR"               nil     )
    (#x002478 "PARENTHESIZED DIGIT FIVE"               nil     )
    (#x002479 "PARENTHESIZED DIGIT SIX"                nil     )
    (#x00247a "PARENTHESIZED DIGIT SEVEN"              nil     )
    (#x00247b "PARENTHESIZED DIGIT EIGHT"              nil     )
    (#x00247c "PARENTHESIZED DIGIT NINE"               nil     )
    (#x00247d "PARENTHESIZED NUMBER TEN"               nil     )
    (#x00247e "PARENTHESIZED NUMBER ELEVEN"            nil     )
    (#x00247f "PARENTHESIZED NUMBER TWELVE"            nil     )
    (#x002480 "PARENTHESIZED NUMBER THIRTEEN"          nil     )
    (#x002481 "PARENTHESIZED NUMBER FOURTEEN"          nil     )
    (#x002482 "PARENTHESIZED NUMBER FIFTEEN"           nil     )
    (#x002483 "PARENTHESIZED NUMBER SIXTEEN"           nil     )
    (#x002484 "PARENTHESIZED NUMBER SEVENTEEN"         nil     )
    (#x002485 "PARENTHESIZED NUMBER EIGHTEEN"          nil     )
    (#x002486 "PARENTHESIZED NUMBER NINETEEN"          nil     )
    (#x002487 "PARENTHESIZED NUMBER TWENTY"            nil     )
    (#x002488 "DIGIT ONE FULL STOP"                    nil     )
    (#x002489 "DIGIT TWO FULL STOP"                    nil     )
    (#x00248a "DIGIT THREE FULL STOP"                  nil     )
    (#x00248b "DIGIT FOUR FULL STOP"                   nil     )
    (#x00248c "DIGIT FIVE FULL STOP"                   nil     )
    (#x00248d "DIGIT SIX FULL STOP"                    nil     )
    (#x00248e "DIGIT SEVEN FULL STOP"                  nil     )
    (#x00248f "DIGIT EIGHT FULL STOP"                  nil     )
    (#x002490 "DIGIT NINE FULL STOP"                   nil     )
    (#x002491 "NUMBER TEN FULL STOP"                   nil     )
    (#x002492 "NUMBER ELEVEN FULL STOP"                nil     )
    (#x002493 "NUMBER TWELVE FULL STOP"                nil     )
    (#x002494 "NUMBER THIRTEEN FULL STOP"              nil     )
    (#x002495 "NUMBER FOURTEEN FULL STOP"              nil     )
    (#x002496 "NUMBER FIFTEEN FULL STOP"               nil     )
    (#x002497 "NUMBER SIXTEEN FULL STOP"               nil     )
    (#x002498 "NUMBER SEVENTEEN FULL STOP"             nil     )
    (#x002499 "NUMBER EIGHTEEN FULL STOP"              nil     )
    (#x00249a "NUMBER NINETEEN FULL STOP"              nil     )
    (#x00249b "NUMBER TWENTY FULL STOP"                nil     )
    (#x00249c "PARENTHESIZED LATIN SMALL LETTER A"     nil     )
    (#x00249d "PARENTHESIZED LATIN SMALL LETTER B"     nil     )
    (#x00249e "PARENTHESIZED LATIN SMALL LETTER C"     nil     )
    (#x00249f "PARENTHESIZED LATIN SMALL LETTER D"     nil     )
    (#x0024a0 "PARENTHESIZED LATIN SMALL LETTER E"     nil     )
    (#x0024a1 "PARENTHESIZED LATIN SMALL LETTER F"     nil     )
    (#x0024a2 "PARENTHESIZED LATIN SMALL LETTER G"     nil     )
    (#x0024a3 "PARENTHESIZED LATIN SMALL LETTER H"     nil     )
    (#x0024a4 "PARENTHESIZED LATIN SMALL LETTER I"     nil     )
    (#x0024a5 "PARENTHESIZED LATIN SMALL LETTER J"     nil     )
    (#x0024a6 "PARENTHESIZED LATIN SMALL LETTER K"     nil     )
    (#x0024a7 "PARENTHESIZED LATIN SMALL LETTER L"     nil     )
    (#x0024a8 "PARENTHESIZED LATIN SMALL LETTER M"     nil     )
    (#x0024a9 "PARENTHESIZED LATIN SMALL LETTER N"     nil     )
    (#x0024aa "PARENTHESIZED LATIN SMALL LETTER O"     nil     )
    (#x0024ab "PARENTHESIZED LATIN SMALL LETTER P"     nil     )
    (#x0024ac "PARENTHESIZED LATIN SMALL LETTER Q"     nil     )
    (#x0024ad "PARENTHESIZED LATIN SMALL LETTER R"     nil     )
    (#x0024ae "PARENTHESIZED LATIN SMALL LETTER S"     nil     )
    (#x0024af "PARENTHESIZED LATIN SMALL LETTER T"     nil     )
    (#x0024b0 "PARENTHESIZED LATIN SMALL LETTER U"     nil     )
    (#x0024b1 "PARENTHESIZED LATIN SMALL LETTER V"     nil     )
    (#x0024b2 "PARENTHESIZED LATIN SMALL LETTER W"     nil     )
    (#x0024b3 "PARENTHESIZED LATIN SMALL LETTER X"     nil     )
    (#x0024b4 "PARENTHESIZED LATIN SMALL LETTER Y"     nil     )
    (#x0024b5 "PARENTHESIZED LATIN SMALL LETTER Z"     nil     )
    (#x0024b6 "CIRCLED LATIN CAPITAL LETTER A"         nil     )
    (#x0024b7 "CIRCLED LATIN CAPITAL LETTER B"         nil     )
    (#x0024b8 "CIRCLED LATIN CAPITAL LETTER C"         nil     )
    (#x0024b9 "CIRCLED LATIN CAPITAL LETTER D"         nil     )
    (#x0024ba "CIRCLED LATIN CAPITAL LETTER E"         nil     )
    (#x0024bb "CIRCLED LATIN CAPITAL LETTER F"         nil     )
    (#x0024bc "CIRCLED LATIN CAPITAL LETTER G"         nil     )
    (#x0024bd "CIRCLED LATIN CAPITAL LETTER H"         nil     )
    (#x0024be "CIRCLED LATIN CAPITAL LETTER I"         nil     )
    (#x0024bf "CIRCLED LATIN CAPITAL LETTER J"         nil     )
    (#x0024c0 "CIRCLED LATIN CAPITAL LETTER K"         nil     )
    (#x0024c1 "CIRCLED LATIN CAPITAL LETTER L"         nil     )
    (#x0024c2 "CIRCLED LATIN CAPITAL LETTER M"         nil     )
    (#x0024c3 "CIRCLED LATIN CAPITAL LETTER N"         nil     )
    (#x0024c4 "CIRCLED LATIN CAPITAL LETTER O"         nil     )
    (#x0024c5 "CIRCLED LATIN CAPITAL LETTER P"         nil     )
    (#x0024c6 "CIRCLED LATIN CAPITAL LETTER Q"         nil     )
    (#x0024c7 "CIRCLED LATIN CAPITAL LETTER R"         nil     )
    (#x0024c8 "CIRCLED LATIN CAPITAL LETTER S"         "oS"    )
    (#x0024c9 "CIRCLED LATIN CAPITAL LETTER T"         nil     )
    (#x0024ca "CIRCLED LATIN CAPITAL LETTER U"         nil     )
    (#x0024cb "CIRCLED LATIN CAPITAL LETTER V"         nil     )
    (#x0024cc "CIRCLED LATIN CAPITAL LETTER W"         nil     )
    (#x0024cd "CIRCLED LATIN CAPITAL LETTER X"         nil     )
    (#x0024ce "CIRCLED LATIN CAPITAL LETTER Y"         nil     )
    (#x0024cf "CIRCLED LATIN CAPITAL LETTER Z"         nil     )
    (#x0024d0 "CIRCLED LATIN SMALL LETTER A"           nil     )
    (#x0024d1 "CIRCLED LATIN SMALL LETTER B"           nil     )
    (#x0024d2 "CIRCLED LATIN SMALL LETTER C"           nil     )
    (#x0024d3 "CIRCLED LATIN SMALL LETTER D"           nil     )
    (#x0024d4 "CIRCLED LATIN SMALL LETTER E"           nil     )
    (#x0024d5 "CIRCLED LATIN SMALL LETTER F"           nil     )
    (#x0024d6 "CIRCLED LATIN SMALL LETTER G"           nil     )
    (#x0024d7 "CIRCLED LATIN SMALL LETTER H"           nil     )
    (#x0024d8 "CIRCLED LATIN SMALL LETTER I"           nil     )
    (#x0024d9 "CIRCLED LATIN SMALL LETTER J"           nil     )
    (#x0024da "CIRCLED LATIN SMALL LETTER K"           nil     )
    (#x0024db "CIRCLED LATIN SMALL LETTER L"           nil     )
    (#x0024dc "CIRCLED LATIN SMALL LETTER M"           nil     )
    (#x0024dd "CIRCLED LATIN SMALL LETTER N"           nil     )
    (#x0024de "CIRCLED LATIN SMALL LETTER O"           nil     )
    (#x0024df "CIRCLED LATIN SMALL LETTER P"           nil     )
    (#x0024e0 "CIRCLED LATIN SMALL LETTER Q"           nil     )
    (#x0024e1 "CIRCLED LATIN SMALL LETTER R"           nil     )
    (#x0024e2 "CIRCLED LATIN SMALL LETTER S"           nil     )
    (#x0024e3 "CIRCLED LATIN SMALL LETTER T"           nil     )
    (#x0024e4 "CIRCLED LATIN SMALL LETTER U"           nil     )
    (#x0024e5 "CIRCLED LATIN SMALL LETTER V"           nil     )
    (#x0024e6 "CIRCLED LATIN SMALL LETTER W"           nil     )
    (#x0024e7 "CIRCLED LATIN SMALL LETTER X"           nil     )
    (#x0024e8 "CIRCLED LATIN SMALL LETTER Y"           nil     )
    (#x0024e9 "CIRCLED LATIN SMALL LETTER Z"           nil     )
    (#x0024ea "CIRCLED DIGIT ZERO"                     nil     )
    (#x0024eb "NEGATIVE CIRCLED NUMBER ELEVEN"         nil     )
    (#x0024ec "NEGATIVE CIRCLED NUMBER TWELVE"         nil     )
    (#x0024ed "NEGATIVE CIRCLED NUMBER THIRTEEN"       nil     )
    (#x0024ee "NEGATIVE CIRCLED NUMBER FOURTEEN"       nil     )
    (#x0024ef "NEGATIVE CIRCLED NUMBER FIFTEEN"        nil     )
    (#x0024f0 "NEGATIVE CIRCLED NUMBER SIXTEEN"        nil     )
    (#x0024f1 "NEGATIVE CIRCLED NUMBER SEVENTEEN"      nil     )
    (#x0024f2 "NEGATIVE CIRCLED NUMBER EIGHTEEN"       nil     )
    (#x0024f3 "NEGATIVE CIRCLED NUMBER NINETEEN"       nil     )
    (#x0024f4 "NEGATIVE CIRCLED NUMBER TWENTY"         nil     )
    (#x0024f5 "DOUBLE CIRCLED DIGIT ONE"               nil     )
    (#x0024f6 "DOUBLE CIRCLED DIGIT TWO"               nil     )
    (#x0024f7 "DOUBLE CIRCLED DIGIT THREE"             nil     )
    (#x0024f8 "DOUBLE CIRCLED DIGIT FOUR"              nil     )
    (#x0024f9 "DOUBLE CIRCLED DIGIT FIVE"              nil     )
    (#x0024fa "DOUBLE CIRCLED DIGIT SIX"               nil     )
    (#x0024fb "DOUBLE CIRCLED DIGIT SEVEN"             nil     )
    (#x0024fc "DOUBLE CIRCLED DIGIT EIGHT"             nil     )
    (#x0024fd "DOUBLE CIRCLED DIGIT NINE"              nil     )
    (#x0024fe "DOUBLE CIRCLED NUMBER TEN"              nil     )
    (#x0024ff "NEGATIVE CIRCLED DIGIT ZERO"            nil     )
    (#x002500 "BOX DRAWINGS LIGHT HORIZONTAL"          "boxh"  )
    (#x002501 "BOX DRAWINGS HEAVY HORIZONTAL"          nil     )
    (#x002502 "BOX DRAWINGS LIGHT VERTICAL"            "boxv"  )
    (#x002503 "BOX DRAWINGS HEAVY VERTICAL"            nil     )
    (#x002504 "BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL" nil     )
    (#x002505 "BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL" nil     )
    (#x002506 "BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL" nil     )
    (#x002507 "BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL" nil     )
    (#x002508 "BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL" nil     )
    (#x002509 "BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL" nil     )
    (#x00250a "BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL" nil     )
    (#x00250b "BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL" nil     )
    (#x00250c "BOX DRAWINGS LIGHT DOWN AND RIGHT"      "boxdr" )
    (#x00250d "BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY" nil     )
    (#x00250e "BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT" nil     )
    (#x00250f "BOX DRAWINGS HEAVY DOWN AND RIGHT"      nil     )
    (#x002510 "BOX DRAWINGS LIGHT DOWN AND LEFT"       "boxdl" )
    (#x002511 "BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY" nil     )
    (#x002512 "BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT" nil     )
    (#x002513 "BOX DRAWINGS HEAVY DOWN AND LEFT"       nil     )
    (#x002514 "BOX DRAWINGS LIGHT UP AND RIGHT"        "boxur" )
    (#x002515 "BOX DRAWINGS UP LIGHT AND RIGHT HEAVY"  nil     )
    (#x002516 "BOX DRAWINGS UP HEAVY AND RIGHT LIGHT"  nil     )
    (#x002517 "BOX DRAWINGS HEAVY UP AND RIGHT"        nil     )
    (#x002518 "BOX DRAWINGS LIGHT UP AND LEFT"         "boxul" )
    (#x002519 "BOX DRAWINGS UP LIGHT AND LEFT HEAVY"   nil     )
    (#x00251a "BOX DRAWINGS UP HEAVY AND LEFT LIGHT"   nil     )
    (#x00251b "BOX DRAWINGS HEAVY UP AND LEFT"         nil     )
    (#x00251c "BOX DRAWINGS LIGHT VERTICAL AND RIGHT"  "boxvr" )
    (#x00251d "BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY" nil     )
    (#x00251e "BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT" nil     )
    (#x00251f "BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT" nil     )
    (#x002520 "BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT" nil     )
    (#x002521 "BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY" nil     )
    (#x002522 "BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY" nil     )
    (#x002523 "BOX DRAWINGS HEAVY VERTICAL AND RIGHT"  nil     )
    (#x002524 "BOX DRAWINGS LIGHT VERTICAL AND LEFT"   "boxvl" )
    (#x002525 "BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY" nil     )
    (#x002526 "BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT" nil     )
    (#x002527 "BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT" nil     )
    (#x002528 "BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT" nil     )
    (#x002529 "BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY" nil     )
    (#x00252a "BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY" nil     )
    (#x00252b "BOX DRAWINGS HEAVY VERTICAL AND LEFT"   nil     )
    (#x00252c "BOX DRAWINGS LIGHT DOWN AND HORIZONTAL" "boxhd" )
    (#x00252d "BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT" nil     )
    (#x00252e "BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT" nil     )
    (#x00252f "BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY" nil     )
    (#x002530 "BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT" nil     )
    (#x002531 "BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY" nil     )
    (#x002532 "BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY" nil     )
    (#x002533 "BOX DRAWINGS HEAVY DOWN AND HORIZONTAL" nil     )
    (#x002534 "BOX DRAWINGS LIGHT UP AND HORIZONTAL"   "boxhu" )
    (#x002535 "BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT" nil     )
    (#x002536 "BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT" nil     )
    (#x002537 "BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY" nil     )
    (#x002538 "BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT" nil     )
    (#x002539 "BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY" nil     )
    (#x00253a "BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY" nil     )
    (#x00253b "BOX DRAWINGS HEAVY UP AND HORIZONTAL"   nil     )
    (#x00253c "BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL" "boxvh" )
    (#x00253d "BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT" nil     )
    (#x00253e "BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT" nil     )
    (#x00253f "BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY" nil     )
    (#x002540 "BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT" nil     )
    (#x002541 "BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT" nil     )
    (#x002542 "BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT" nil     )
    (#x002543 "BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT" nil     )
    (#x002544 "BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT" nil     )
    (#x002545 "BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT" nil     )
    (#x002546 "BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT" nil     )
    (#x002547 "BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY" nil     )
    (#x002548 "BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY" nil     )
    (#x002549 "BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY" nil     )
    (#x00254a "BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY" nil     )
    (#x00254b "BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL" nil     )
    (#x00254c "BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL" nil     )
    (#x00254d "BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL" nil     )
    (#x00254e "BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL" nil     )
    (#x00254f "BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL" nil     )
    (#x002550 "BOX DRAWINGS DOUBLE HORIZONTAL"         "boxH"  )
    (#x002551 "BOX DRAWINGS DOUBLE VERTICAL"           "boxV"  )
    (#x002552 "BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE" "boxdR" )
    (#x002553 "BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE" "boxDr" )
    (#x002554 "BOX DRAWINGS DOUBLE DOWN AND RIGHT"     "boxDR" )
    (#x002555 "BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE" "boxdL" )
    (#x002556 "BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE" "boxDl" )
    (#x002557 "BOX DRAWINGS DOUBLE DOWN AND LEFT"      "boxDL" )
    (#x002558 "BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE" "boxuR" )
    (#x002559 "BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE" "boxUr" )
    (#x00255a "BOX DRAWINGS DOUBLE UP AND RIGHT"       "boxUR" )
    (#x00255b "BOX DRAWINGS UP SINGLE AND LEFT DOUBLE" "boxuL" )
    (#x00255c "BOX DRAWINGS UP DOUBLE AND LEFT SINGLE" "boxUl" )
    (#x00255d "BOX DRAWINGS DOUBLE UP AND LEFT"        "boxUL" )
    (#x00255e "BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE" "boxvR" )
    (#x00255f "BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE" "boxVr" )
    (#x002560 "BOX DRAWINGS DOUBLE VERTICAL AND RIGHT" "boxVR" )
    (#x002561 "BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE" "boxvL" )
    (#x002562 "BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE" "boxVl" )
    (#x002563 "BOX DRAWINGS DOUBLE VERTICAL AND LEFT"  "boxVL" )
    (#x002564 "BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE" "boxHd" )
    (#x002565 "BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE" "boxhD" )
    (#x002566 "BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL" "boxHD" )
    (#x002567 "BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE" "boxHu" )
    (#x002568 "BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE" "boxhU" )
    (#x002569 "BOX DRAWINGS DOUBLE UP AND HORIZONTAL"  "boxHU" )
    (#x00256a "BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE" "boxvH" )
    (#x00256b "BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE" "boxVh" )
    (#x00256c "BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL" "boxVH" )
    (#x00256d "BOX DRAWINGS LIGHT ARC DOWN AND RIGHT"  nil     )
    (#x00256e "BOX DRAWINGS LIGHT ARC DOWN AND LEFT"   nil     )
    (#x00256f "BOX DRAWINGS LIGHT ARC UP AND LEFT"     nil     )
    (#x002570 "BOX DRAWINGS LIGHT ARC UP AND RIGHT"    nil     )
    (#x002571 "BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT" nil     )
    (#x002572 "BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT" nil     )
    (#x002573 "BOX DRAWINGS LIGHT DIAGONAL CROSS"      nil     )
    (#x002574 "BOX DRAWINGS LIGHT LEFT"                nil     )
    (#x002575 "BOX DRAWINGS LIGHT UP"                  nil     )
    (#x002576 "BOX DRAWINGS LIGHT RIGHT"               nil     )
    (#x002577 "BOX DRAWINGS LIGHT DOWN"                nil     )
    (#x002578 "BOX DRAWINGS HEAVY LEFT"                nil     )
    (#x002579 "BOX DRAWINGS HEAVY UP"                  nil     )
    (#x00257a "BOX DRAWINGS HEAVY RIGHT"               nil     )
    (#x00257b "BOX DRAWINGS HEAVY DOWN"                nil     )
    (#x00257c "BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT" nil     )
    (#x00257d "BOX DRAWINGS LIGHT UP AND HEAVY DOWN"   nil     )
    (#x00257e "BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT" nil     )
    (#x00257f "BOX DRAWINGS HEAVY UP AND LIGHT DOWN"   nil     )
    (#x002580 "UPPER HALF BLOCK"                       "uhblk" )
    (#x002581 "LOWER ONE EIGHTH BLOCK"                 nil     )
    (#x002582 "LOWER ONE QUARTER BLOCK"                nil     )
    (#x002583 "LOWER THREE EIGHTHS BLOCK"              nil     )
    (#x002584 "LOWER HALF BLOCK"                       "lhblk" )
    (#x002585 "LOWER FIVE EIGHTHS BLOCK"               nil     )
    (#x002586 "LOWER THREE QUARTERS BLOCK"             nil     )
    (#x002587 "LOWER SEVEN EIGHTHS BLOCK"              nil     )
    (#x002588 "FULL BLOCK"                             "block" )
    (#x002589 "LEFT SEVEN EIGHTHS BLOCK"               nil     )
    (#x00258a "LEFT THREE QUARTERS BLOCK"              nil     )
    (#x00258b "LEFT FIVE EIGHTHS BLOCK"                nil     )
    (#x00258c "LEFT HALF BLOCK"                        nil     )
    (#x00258d "LEFT THREE EIGHTHS BLOCK"               nil     )
    (#x00258e "LEFT ONE QUARTER BLOCK"                 nil     )
    (#x00258f "LEFT ONE EIGHTH BLOCK"                  nil     )
    (#x002590 "RIGHT HALF BLOCK"                       nil     )
    (#x002591 "LIGHT SHADE"                            "blk14" )
    (#x002592 "MEDIUM SHADE"                           "blk12" )
    (#x002593 "DARK SHADE"                             "blk34" )
    (#x002594 "UPPER ONE EIGHTH BLOCK"                 nil     )
    (#x002595 "RIGHT ONE EIGHTH BLOCK"                 nil     )
    (#x002596 "QUADRANT LOWER LEFT"                    nil     )
    (#x002597 "QUADRANT LOWER RIGHT"                   nil     )
    (#x002598 "QUADRANT UPPER LEFT"                    nil     )
    (#x002599 "QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT" nil     )
    (#x00259a "QUADRANT UPPER LEFT AND LOWER RIGHT"    nil     )
    (#x00259b "QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT" nil     )
    (#x00259c "QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT" nil     )
    (#x00259d "QUADRANT UPPER RIGHT"                   nil     )
    (#x00259e "QUADRANT UPPER RIGHT AND LOWER LEFT"    nil     )
    (#x00259f "QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT" nil     )
    (#x0025a0 "BLACK SQUARE"                           nil     )
    (#x0025a1 "WHITE SQUARE"                           "squ"   )
    (#x0025a2 "WHITE SQUARE WITH ROUNDED CORNERS"      nil     )
    (#x0025a3 "WHITE SQUARE CONTAINING BLACK SMALL SQUARE" nil     )
    (#x0025a4 "SQUARE WITH HORIZONTAL FILL"            nil     )
    (#x0025a5 "SQUARE WITH VERTICAL FILL"              nil     )
    (#x0025a6 "SQUARE WITH ORTHOGONAL CROSSHATCH FILL" nil     )
    (#x0025a7 "SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL" nil     )
    (#x0025a8 "SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL" nil     )
    (#x0025a9 "SQUARE WITH DIAGONAL CROSSHATCH FILL"   nil     )
    (#x0025aa "BLACK SMALL SQUARE"                     "squf"  )
    (#x0025ab "WHITE SMALL SQUARE"                     nil     )
    (#x0025ac "BLACK RECTANGLE"                        nil     )
    (#x0025ad "WHITE RECTANGLE"                        "rect"  )
    (#x0025ae "BLACK VERTICAL RECTANGLE"               "marker")
    (#x0025af "WHITE VERTICAL RECTANGLE"               nil     )
    (#x0025b0 "BLACK PARALLELOGRAM"                    nil     )
    (#x0025b1 "WHITE PARALLELOGRAM"                    nil     )
    (#x0025b2 "BLACK UP-POINTING TRIANGLE"             nil     )
    (#x0025b3 "WHITE UP-POINTING TRIANGLE"             "xutri" )
    (#x0025b4 "BLACK UP-POINTING SMALL TRIANGLE"       "utrif" )
    (#x0025b5 "WHITE UP-POINTING SMALL TRIANGLE"       "utri"  )
    (#x0025b6 "BLACK RIGHT-POINTING TRIANGLE"          nil     )
    (#x0025b7 "WHITE RIGHT-POINTING TRIANGLE"          nil     )
    (#x0025b8 "BLACK RIGHT-POINTING SMALL TRIANGLE"    "rtrif" )
    (#x0025b9 "WHITE RIGHT-POINTING SMALL TRIANGLE"    "rtri"  )
    (#x0025ba "BLACK RIGHT-POINTING POINTER"           nil     )
    (#x0025bb "WHITE RIGHT-POINTING POINTER"           nil     )
    (#x0025bc "BLACK DOWN-POINTING TRIANGLE"           nil     )
    (#x0025bd "WHITE DOWN-POINTING TRIANGLE"           "xdtri" )
    (#x0025be "BLACK DOWN-POINTING SMALL TRIANGLE"     "dtrif" )
    (#x0025bf "WHITE DOWN-POINTING SMALL TRIANGLE"     "dtri"  )
    (#x0025c0 "BLACK LEFT-POINTING TRIANGLE"           nil     )
    (#x0025c1 "WHITE LEFT-POINTING TRIANGLE"           nil     )
    (#x0025c2 "BLACK LEFT-POINTING SMALL TRIANGLE"     "ltrif" )
    (#x0025c3 "WHITE LEFT-POINTING SMALL TRIANGLE"     "ltri"  )
    (#x0025c4 "BLACK LEFT-POINTING POINTER"            nil     )
    (#x0025c5 "WHITE LEFT-POINTING POINTER"            nil     )
    (#x0025c6 "BLACK DIAMOND"                          nil     )
    (#x0025c7 "WHITE DIAMOND"                          nil     )
    (#x0025c8 "WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND" nil     )
    (#x0025c9 "FISHEYE"                                nil     )
    (#x0025ca "LOZENGE"                                "loz"   )
    (#x0025cb "WHITE CIRCLE"                           "cir"   )
    (#x0025cc "DOTTED CIRCLE"                          nil     )
    (#x0025cd "CIRCLE WITH VERTICAL FILL"              nil     )
    (#x0025ce "BULLSEYE"                               nil     )
    (#x0025cf "BLACK CIRCLE"                           nil     )
    (#x0025d0 "CIRCLE WITH LEFT HALF BLACK"            nil     )
    (#x0025d1 "CIRCLE WITH RIGHT HALF BLACK"           nil     )
    (#x0025d2 "CIRCLE WITH LOWER HALF BLACK"           nil     )
    (#x0025d3 "CIRCLE WITH UPPER HALF BLACK"           nil     )
    (#x0025d4 "CIRCLE WITH UPPER RIGHT QUADRANT BLACK" nil     )
    (#x0025d5 "CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK" nil     )
    (#x0025d6 "LEFT HALF BLACK CIRCLE"                 nil     )
    (#x0025d7 "RIGHT HALF BLACK CIRCLE"                nil     )
    (#x0025d8 "INVERSE BULLET"                         nil     )
    (#x0025d9 "INVERSE WHITE CIRCLE"                   nil     )
    (#x0025da "UPPER HALF INVERSE WHITE CIRCLE"        nil     )
    (#x0025db "LOWER HALF INVERSE WHITE CIRCLE"        nil     )
    (#x0025dc "UPPER LEFT QUADRANT CIRCULAR ARC"       nil     )
    (#x0025dd "UPPER RIGHT QUADRANT CIRCULAR ARC"      nil     )
    (#x0025de "LOWER RIGHT QUADRANT CIRCULAR ARC"      nil     )
    (#x0025df "LOWER LEFT QUADRANT CIRCULAR ARC"       nil     )
    (#x0025e0 "UPPER HALF CIRCLE"                      nil     )
    (#x0025e1 "LOWER HALF CIRCLE"                      nil     )
    (#x0025e2 "BLACK LOWER RIGHT TRIANGLE"             nil     )
    (#x0025e3 "BLACK LOWER LEFT TRIANGLE"              nil     )
    (#x0025e4 "BLACK UPPER LEFT TRIANGLE"              nil     )
    (#x0025e5 "BLACK UPPER RIGHT TRIANGLE"             nil     )
    (#x0025e6 "WHITE BULLET"                           nil     )
    (#x0025e7 "SQUARE WITH LEFT HALF BLACK"            nil     )
    (#x0025e8 "SQUARE WITH RIGHT HALF BLACK"           nil     )
    (#x0025e9 "SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK" nil     )
    (#x0025ea "SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK" nil     )
    (#x0025eb "WHITE SQUARE WITH VERTICAL BISECTING LINE" nil     )
    (#x0025ec "WHITE UP-POINTING TRIANGLE WITH DOT"    nil     )
    (#x0025ed "UP-POINTING TRIANGLE WITH LEFT HALF BLACK" nil     )
    (#x0025ee "UP-POINTING TRIANGLE WITH RIGHT HALF BLACK" nil     )
    (#x0025ef "LARGE CIRCLE"                           "xcirc" )
    (#x0025f0 "WHITE SQUARE WITH UPPER LEFT QUADRANT"  nil     )
    (#x0025f1 "WHITE SQUARE WITH LOWER LEFT QUADRANT"  nil     )
    (#x0025f2 "WHITE SQUARE WITH LOWER RIGHT QUADRANT" nil     )
    (#x0025f3 "WHITE SQUARE WITH UPPER RIGHT QUADRANT" nil     )
    (#x0025f4 "WHITE CIRCLE WITH UPPER LEFT QUADRANT"  nil     )
    (#x0025f5 "WHITE CIRCLE WITH LOWER LEFT QUADRANT"  nil     )
    (#x0025f6 "WHITE CIRCLE WITH LOWER RIGHT QUADRANT" nil     )
    (#x0025f7 "WHITE CIRCLE WITH UPPER RIGHT QUADRANT" nil     )
    (#x0025f8 "UPPER LEFT TRIANGLE"                    nil     )
    (#x0025f9 "UPPER RIGHT TRIANGLE"                   nil     )
    (#x0025fa "LOWER LEFT TRIANGLE"                    nil     )
    (#x0025fb "WHITE MEDIUM SQUARE"                    nil     )
    (#x0025fc "BLACK MEDIUM SQUARE"                    nil     )
    (#x0025fd "WHITE MEDIUM SMALL SQUARE"              nil     )
    (#x0025fe "BLACK MEDIUM SMALL SQUARE"              nil     )
    (#x0025ff "LOWER RIGHT TRIANGLE"                   nil     )
    (#x002600 "BLACK SUN WITH RAYS"                    nil     )
    (#x002601 "CLOUD"                                  nil     )
    (#x002602 "UMBRELLA"                               nil     )
    (#x002603 "SNOWMAN"                                nil     )
    (#x002604 "COMET"                                  nil     )
    (#x002605 "BLACK STAR"                             "starf" )
    (#x002606 "WHITE STAR"                             "star"  )
    (#x002607 "LIGHTNING"                              nil     )
    (#x002608 "THUNDERSTORM"                           nil     )
    (#x002609 "SUN"                                    nil     )
    (#x00260a "ASCENDING NODE"                         nil     )
    (#x00260b "DESCENDING NODE"                        nil     )
    (#x00260c "CONJUNCTION"                            nil     )
    (#x00260d "OPPOSITION"                             nil     )
    (#x00260e "BLACK TELEPHONE"                        "phone" )
    (#x00260f "WHITE TELEPHONE"                        nil     )
    (#x002610 "BALLOT BOX"                             nil     )
    (#x002611 "BALLOT BOX WITH CHECK"                  nil     )
    (#x002612 "BALLOT BOX WITH X"                      nil     )
    (#x002613 "SALTIRE"                                nil     )
    (#x002614 "UMBRELLA WITH RAIN DROPS"               nil     )
    (#x002615 "HOT BEVERAGE"                           nil     )
    (#x002616 "WHITE SHOGI PIECE"                      nil     )
    (#x002617 "BLACK SHOGI PIECE"                      nil     )
    (#x002618 "SHAMROCK"                               nil     )
    (#x002619 "REVERSED ROTATED FLORAL HEART BULLET"   nil     )
    (#x00261a "BLACK LEFT POINTING INDEX"              nil     )
    (#x00261b "BLACK RIGHT POINTING INDEX"             nil     )
    (#x00261c "WHITE LEFT POINTING INDEX"              nil     )
    (#x00261d "WHITE UP POINTING INDEX"                nil     )
    (#x00261e "WHITE RIGHT POINTING INDEX"             nil     )
    (#x00261f "WHITE DOWN POINTING INDEX"              nil     )
    (#x002620 "SKULL AND CROSSBONES"                   nil     )
    (#x002621 "CAUTION SIGN"                           nil     )
    (#x002622 "RADIOACTIVE SIGN"                       nil     )
    (#x002623 "BIOHAZARD SIGN"                         nil     )
    (#x002624 "CADUCEUS"                               nil     )
    (#x002625 "ANKH"                                   nil     )
    (#x002626 "ORTHODOX CROSS"                         nil     )
    (#x002627 "CHI RHO"                                nil     )
    (#x002628 "CROSS OF LORRAINE"                      nil     )
    (#x002629 "CROSS OF JERUSALEM"                     nil     )
    (#x00262a "STAR AND CRESCENT"                      nil     )
    (#x00262b "FARSI SYMBOL"                           nil     )
    (#x00262c "ADI SHAKTI"                             nil     )
    (#x00262d "HAMMER AND SICKLE"                      nil     )
    (#x00262e "PEACE SYMBOL"                           nil     )
    (#x00262f "YIN YANG"                               nil     )
    (#x002630 "TRIGRAM FOR HEAVEN"                     nil     )
    (#x002631 "TRIGRAM FOR LAKE"                       nil     )
    (#x002632 "TRIGRAM FOR FIRE"                       nil     )
    (#x002633 "TRIGRAM FOR THUNDER"                    nil     )
    (#x002634 "TRIGRAM FOR WIND"                       nil     )
    (#x002635 "TRIGRAM FOR WATER"                      nil     )
    (#x002636 "TRIGRAM FOR MOUNTAIN"                   nil     )
    (#x002637 "TRIGRAM FOR EARTH"                      nil     )
    (#x002638 "WHEEL OF DHARMA"                        nil     )
    (#x002639 "WHITE FROWNING FACE"                    nil     )
    (#x00263a "WHITE SMILING FACE"                     nil     )
    (#x00263b "BLACK SMILING FACE"                     nil     )
    (#x00263c "WHITE SUN WITH RAYS"                    nil     )
    (#x00263d "FIRST QUARTER MOON"                     nil     )
    (#x00263e "LAST QUARTER MOON"                      nil     )
    (#x00263f "MERCURY"                                nil     )
    (#x002640 "FEMALE SIGN"                            "female")
    (#x002641 "EARTH"                                  nil     )
    (#x002642 "MALE SIGN"                              "male"  )
    (#x002643 "JUPITER"                                nil     )
    (#x002644 "SATURN"                                 nil     )
    (#x002645 "URANUS"                                 nil     )
    (#x002646 "NEPTUNE"                                nil     )
    (#x002647 "PLUTO"                                  nil     )
    (#x002648 "ARIES"                                  nil     )
    (#x002649 "TAURUS"                                 nil     )
    (#x00264a "GEMINI"                                 nil     )
    (#x00264b "CANCER"                                 nil     )
    (#x00264c "LEO"                                    nil     )
    (#x00264d "VIRGO"                                  nil     )
    (#x00264e "LIBRA"                                  nil     )
    (#x00264f "SCORPIUS"                               nil     )
    (#x002650 "SAGITTARIUS"                            nil     )
    (#x002651 "CAPRICORN"                              nil     )
    (#x002652 "AQUARIUS"                               nil     )
    (#x002653 "PISCES"                                 nil     )
    (#x002654 "WHITE CHESS KING"                       nil     )
    (#x002655 "WHITE CHESS QUEEN"                      nil     )
    (#x002656 "WHITE CHESS ROOK"                       nil     )
    (#x002657 "WHITE CHESS BISHOP"                     nil     )
    (#x002658 "WHITE CHESS KNIGHT"                     nil     )
    (#x002659 "WHITE CHESS PAWN"                       nil     )
    (#x00265a "BLACK CHESS KING"                       nil     )
    (#x00265b "BLACK CHESS QUEEN"                      nil     )
    (#x00265c "BLACK CHESS ROOK"                       nil     )
    (#x00265d "BLACK CHESS BISHOP"                     nil     )
    (#x00265e "BLACK CHESS KNIGHT"                     nil     )
    (#x00265f "BLACK CHESS PAWN"                       nil     )
    (#x002660 "BLACK SPADE SUIT"                       "spades")
    (#x002661 "WHITE HEART SUIT"                       nil     )
    (#x002662 "WHITE DIAMOND SUIT"                     nil     )
    (#x002663 "BLACK CLUB SUIT"                        "clubs" )
    (#x002664 "WHITE SPADE SUIT"                       nil     )
    (#x002665 "BLACK HEART SUIT"                       "hearts")
    (#x002666 "BLACK DIAMOND SUIT"                     "diams" )
    (#x002667 "WHITE CLUB SUIT"                        nil     )
    (#x002668 "HOT SPRINGS"                            nil     )
    (#x002669 "QUARTER NOTE"                           nil     )
    (#x00266a "EIGHTH NOTE"                            "sung"  )
    (#x00266b "BEAMED EIGHTH NOTES"                    nil     )
    (#x00266c "BEAMED SIXTEENTH NOTES"                 nil     )
    (#x00266d "MUSIC FLAT SIGN"                        "flat"  )
    (#x00266e "MUSIC NATURAL SIGN"                     "natur" )
    (#x00266f "MUSIC SHARP SIGN"                       "sharp" )
    (#x002670 "WEST SYRIAC CROSS"                      nil     )
    (#x002671 "EAST SYRIAC CROSS"                      nil     )
    (#x002672 "UNIVERSAL RECYCLING SYMBOL"             nil     )
    (#x002673 "RECYCLING SYMBOL FOR TYPE-1 PLASTICS"   nil     )
    (#x002674 "RECYCLING SYMBOL FOR TYPE-2 PLASTICS"   nil     )
    (#x002675 "RECYCLING SYMBOL FOR TYPE-3 PLASTICS"   nil     )
    (#x002676 "RECYCLING SYMBOL FOR TYPE-4 PLASTICS"   nil     )
    (#x002677 "RECYCLING SYMBOL FOR TYPE-5 PLASTICS"   nil     )
    (#x002678 "RECYCLING SYMBOL FOR TYPE-6 PLASTICS"   nil     )
    (#x002679 "RECYCLING SYMBOL FOR TYPE-7 PLASTICS"   nil     )
    (#x00267a "RECYCLING SYMBOL FOR GENERIC MATERIALS" nil     )
    (#x00267b "BLACK UNIVERSAL RECYCLING SYMBOL"       nil     )
    (#x00267c "RECYCLED PAPER SYMBOL"                  nil     )
    (#x00267d "PARTIALLY-RECYCLED PAPER SYMBOL"        nil     )
    (#x00267e "PERMANENT PAPER SIGN"                   nil     )
    (#x00267f "WHEELCHAIR SYMBOL"                      nil     )
    (#x002680 "DIE FACE-1"                             nil     )
    (#x002681 "DIE FACE-2"                             nil     )
    (#x002682 "DIE FACE-3"                             nil     )
    (#x002683 "DIE FACE-4"                             nil     )
    (#x002684 "DIE FACE-5"                             nil     )
    (#x002685 "DIE FACE-6"                             nil     )
    (#x002686 "WHITE CIRCLE WITH DOT RIGHT"            nil     )
    (#x002687 "WHITE CIRCLE WITH TWO DOTS"             nil     )
    (#x002688 "BLACK CIRCLE WITH WHITE DOT RIGHT"      nil     )
    (#x002689 "BLACK CIRCLE WITH TWO WHITE DOTS"       nil     )
    (#x00268a "MONOGRAM FOR YANG"                      nil     )
    (#x00268b "MONOGRAM FOR YIN"                       nil     )
    (#x00268c "DIGRAM FOR GREATER YANG"                nil     )
    (#x00268d "DIGRAM FOR LESSER YIN"                  nil     )
    (#x00268e "DIGRAM FOR LESSER YANG"                 nil     )
    (#x00268f "DIGRAM FOR GREATER YIN"                 nil     )
    (#x002690 "WHITE FLAG"                             nil     )
    (#x002691 "BLACK FLAG"                             nil     )
    (#x002692 "HAMMER AND PICK"                        nil     )
    (#x002693 "ANCHOR"                                 nil     )
    (#x002694 "CROSSED SWORDS"                         nil     )
    (#x002695 "STAFF OF AESCULAPIUS"                   nil     )
    (#x002696 "SCALES"                                 nil     )
    (#x002697 "ALEMBIC"                                nil     )
    (#x002698 "FLOWER"                                 nil     )
    (#x002699 "GEAR"                                   nil     )
    (#x00269a "STAFF OF HERMES"                        nil     )
    (#x00269b "ATOM SYMBOL"                            nil     )
    (#x00269c "FLEUR-DE-LIS"                           nil     )
    (#x00269d "OUTLINED WHITE STAR"                    nil     )
    (#x00269e "THREE LINES CONVERGING RIGHT"           nil     )
    (#x00269f "THREE LINES CONVERGING LEFT"            nil     )
    (#x0026a0 "WARNING SIGN"                           nil     )
    (#x0026a1 "HIGH VOLTAGE SIGN"                      nil     )
    (#x0026a2 "DOUBLED FEMALE SIGN"                    nil     )
    (#x0026a3 "DOUBLED MALE SIGN"                      nil     )
    (#x0026a4 "INTERLOCKED FEMALE AND MALE SIGN"       nil     )
    (#x0026a5 "MALE AND FEMALE SIGN"                   nil     )
    (#x0026a6 "MALE WITH STROKE SIGN"                  nil     )
    (#x0026a7 "MALE WITH STROKE AND MALE AND FEMALE SIGN" nil     )
    (#x0026a8 "VERTICAL MALE WITH STROKE SIGN"         nil     )
    (#x0026a9 "HORIZONTAL MALE WITH STROKE SIGN"       nil     )
    (#x0026aa "MEDIUM WHITE CIRCLE"                    nil     )
    (#x0026ab "MEDIUM BLACK CIRCLE"                    nil     )
    (#x0026ac "MEDIUM SMALL WHITE CIRCLE"              nil     )
    (#x0026ad "MARRIAGE SYMBOL"                        nil     )
    (#x0026ae "DIVORCE SYMBOL"                         nil     )
    (#x0026af "UNMARRIED PARTNERSHIP SYMBOL"           nil     )
    (#x0026b0 "COFFIN"                                 nil     )
    (#x0026b1 "FUNERAL URN"                            nil     )
    (#x0026b2 "NEUTER"                                 nil     )
    (#x0026b3 "CERES"                                  nil     )
    (#x0026b4 "PALLAS"                                 nil     )
    (#x0026b5 "JUNO"                                   nil     )
    (#x0026b6 "VESTA"                                  nil     )
    (#x0026b7 "CHIRON"                                 nil     )
    (#x0026b8 "BLACK MOON LILITH"                      nil     )
    (#x0026b9 "SEXTILE"                                nil     )
    (#x0026ba "SEMISEXTILE"                            nil     )
    (#x0026bb "QUINCUNX"                               nil     )
    (#x0026bc "SESQUIQUADRATE"                         nil     )
    (#x0026bd "SOCCER BALL"                            nil     )
    (#x0026be "BASEBALL"                               nil     )
    (#x0026bf "SQUARED KEY"                            nil     )
    (#x0026c0 "WHITE DRAUGHTS MAN"                     nil     )
    (#x0026c1 "WHITE DRAUGHTS KING"                    nil     )
    (#x0026c2 "BLACK DRAUGHTS MAN"                     nil     )
    (#x0026c3 "BLACK DRAUGHTS KING"                    nil     )
    (#x0026c4 "SNOWMAN WITHOUT SNOW"                   nil     )
    (#x0026c5 "SUN BEHIND CLOUD"                       nil     )
    (#x0026c6 "RAIN"                                   nil     )
    (#x0026c7 "BLACK SNOWMAN"                          nil     )
    (#x0026c8 "THUNDER CLOUD AND RAIN"                 nil     )
    (#x0026c9 "TURNED WHITE SHOGI PIECE"               nil     )
    (#x0026ca "TURNED BLACK SHOGI PIECE"               nil     )
    (#x0026cb "WHITE DIAMOND IN SQUARE"                nil     )
    (#x0026cc "CROSSING LANES"                         nil     )
    (#x0026cd "DISABLED CAR"                           nil     )
    (#x0026ce "OPHIUCHUS"                              nil     )
    (#x0026cf "PICK"                                   nil     )
    (#x0026d0 "CAR SLIDING"                            nil     )
    (#x0026d1 "HELMET WITH WHITE CROSS"                nil     )
    (#x0026d2 "CIRCLED CROSSING LANES"                 nil     )
    (#x0026d3 "CHAINS"                                 nil     )
    (#x0026d4 "NO ENTRY"                               nil     )
    (#x0026d5 "ALTERNATE ONE-WAY LEFT WAY TRAFFIC"     nil     )
    (#x0026d6 "BLACK TWO-WAY LEFT WAY TRAFFIC"         nil     )
    (#x0026d7 "WHITE TWO-WAY LEFT WAY TRAFFIC"         nil     )
    (#x0026d8 "BLACK LEFT LANE MERGE"                  nil     )
    (#x0026d9 "WHITE LEFT LANE MERGE"                  nil     )
    (#x0026da "DRIVE SLOW SIGN"                        nil     )
    (#x0026db "HEAVY WHITE DOWN-POINTING TRIANGLE"     nil     )
    (#x0026dc "LEFT CLOSED ENTRY"                      nil     )
    (#x0026dd "SQUARED SALTIRE"                        nil     )
    (#x0026de "FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE" nil     )
    (#x0026df "BLACK TRUCK"                            nil     )
    (#x0026e0 "RESTRICTED LEFT ENTRY-1"                nil     )
    (#x0026e1 "RESTRICTED LEFT ENTRY-2"                nil     )
    (#x0026e2 "ASTRONOMICAL SYMBOL FOR URANUS"         nil     )
    (#x0026e3 "HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE" nil     )
    (#x0026e4 "PENTAGRAM"                              nil     )
    (#x0026e5 "RIGHT-HANDED INTERLACED PENTAGRAM"      nil     )
    (#x0026e6 "LEFT-HANDED INTERLACED PENTAGRAM"       nil     )
    (#x0026e7 "INVERTED PENTAGRAM"                     nil     )
    (#x0026e8 "BLACK CROSS ON SHIELD"                  nil     )
    (#x0026e9 "SHINTO SHRINE"                          nil     )
    (#x0026ea "CHURCH"                                 nil     )
    (#x0026eb "CASTLE"                                 nil     )
    (#x0026ec "HISTORIC SITE"                          nil     )
    (#x0026ed "GEAR WITHOUT HUB"                       nil     )
    (#x0026ee "GEAR WITH HANDLES"                      nil     )
    (#x0026ef "MAP SYMBOL FOR LIGHTHOUSE"              nil     )
    (#x0026f0 "MOUNTAIN"                               nil     )
    (#x0026f1 "UMBRELLA ON GROUND"                     nil     )
    (#x0026f2 "FOUNTAIN"                               nil     )
    (#x0026f3 "FLAG IN HOLE"                           nil     )
    (#x0026f4 "FERRY"                                  nil     )
    (#x0026f5 "SAILBOAT"                               nil     )
    (#x0026f6 "SQUARE FOUR CORNERS"                    nil     )
    (#x0026f7 "SKIER"                                  nil     )
    (#x0026f8 "ICE SKATE"                              nil     )
    (#x0026f9 "PERSON WITH BALL"                       nil     )
    (#x0026fa "TENT"                                   nil     )
    (#x0026fb "JAPANESE BANK SYMBOL"                   nil     )
    (#x0026fc "HEADSTONE GRAVEYARD SYMBOL"             nil     )
    (#x0026fd "FUEL PUMP"                              nil     )
    (#x0026fe "CUP ON BLACK SQUARE"                    nil     )
    (#x0026ff "WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE" nil     )
    (#x002700 "BLACK SAFETY SCISSORS"                  nil     )
    (#x002701 "UPPER BLADE SCISSORS"                   nil     )
    (#x002702 "BLACK SCISSORS"                         nil     )
    (#x002703 "LOWER BLADE SCISSORS"                   nil     )
    (#x002704 "WHITE SCISSORS"                         nil     )
    (#x002705 "WHITE HEAVY CHECK MARK"                 nil     )
    (#x002706 "TELEPHONE LOCATION SIGN"                nil     )
    (#x002707 "TAPE DRIVE"                             nil     )
    (#x002708 "AIRPLANE"                               nil     )
    (#x002709 "ENVELOPE"                               nil     )
    (#x00270a "RAISED FIST"                            nil     )
    (#x00270b "RAISED HAND"                            nil     )
    (#x00270c "VICTORY HAND"                           nil     )
    (#x00270d "WRITING HAND"                           nil     )
    (#x00270e "LOWER RIGHT PENCIL"                     nil     )
    (#x00270f "PENCIL"                                 nil     )
    (#x002710 "UPPER RIGHT PENCIL"                     nil     )
    (#x002711 "WHITE NIB"                              nil     )
    (#x002712 "BLACK NIB"                              nil     )
    (#x002713 "CHECK MARK"                             "check" )
    (#x002714 "HEAVY CHECK MARK"                       nil     )
    (#x002715 "MULTIPLICATION X"                       nil     )
    (#x002716 "HEAVY MULTIPLICATION X"                 nil     )
    (#x002717 "BALLOT X"                               "cross" )
    (#x002718 "HEAVY BALLOT X"                         nil     )
    (#x002719 "OUTLINED GREEK CROSS"                   nil     )
    (#x00271a "HEAVY GREEK CROSS"                      nil     )
    (#x00271b "OPEN CENTRE CROSS"                      nil     )
    (#x00271c "HEAVY OPEN CENTRE CROSS"                nil     )
    (#x00271d "LATIN CROSS"                            nil     )
    (#x00271e "SHADOWED WHITE LATIN CROSS"             nil     )
    (#x00271f "OUTLINED LATIN CROSS"                   nil     )
    (#x002720 "MALTESE CROSS"                          "malt"  )
    (#x002721 "STAR OF DAVID"                          nil     )
    (#x002722 "FOUR TEARDROP-SPOKED ASTERISK"          nil     )
    (#x002723 "FOUR BALLOON-SPOKED ASTERISK"           nil     )
    (#x002724 "HEAVY FOUR BALLOON-SPOKED ASTERISK"     nil     )
    (#x002725 "FOUR CLUB-SPOKED ASTERISK"              nil     )
    (#x002726 "BLACK FOUR POINTED STAR"                nil     )
    (#x002727 "WHITE FOUR POINTED STAR"                nil     )
    (#x002728 "SPARKLES"                               nil     )
    (#x002729 "STRESS OUTLINED WHITE STAR"             nil     )
    (#x00272a "CIRCLED WHITE STAR"                     nil     )
    (#x00272b "OPEN CENTRE BLACK STAR"                 nil     )
    (#x00272c "BLACK CENTRE WHITE STAR"                nil     )
    (#x00272d "OUTLINED BLACK STAR"                    nil     )
    (#x00272e "HEAVY OUTLINED BLACK STAR"              nil     )
    (#x00272f "PINWHEEL STAR"                          nil     )
    (#x002730 "SHADOWED WHITE STAR"                    nil     )
    (#x002731 "HEAVY ASTERISK"                         nil     )
    (#x002732 "OPEN CENTRE ASTERISK"                   nil     )
    (#x002733 "EIGHT SPOKED ASTERISK"                  nil     )
    (#x002734 "EIGHT POINTED BLACK STAR"               nil     )
    (#x002735 "EIGHT POINTED PINWHEEL STAR"            nil     )
    (#x002736 "SIX POINTED BLACK STAR"                 "sext"  )
    (#x002737 "EIGHT POINTED RECTILINEAR BLACK STAR"   nil     )
    (#x002738 "HEAVY EIGHT POINTED RECTILINEAR BLACK STAR" nil     )
    (#x002739 "TWELVE POINTED BLACK STAR"              nil     )
    (#x00273a "SIXTEEN POINTED ASTERISK"               nil     )
    (#x00273b "TEARDROP-SPOKED ASTERISK"               nil     )
    (#x00273c "OPEN CENTRE TEARDROP-SPOKED ASTERISK"   nil     )
    (#x00273d "HEAVY TEARDROP-SPOKED ASTERISK"         nil     )
    (#x00273e "SIX PETALLED BLACK AND WHITE FLORETTE"  nil     )
    (#x00273f "BLACK FLORETTE"                         nil     )
    (#x002740 "WHITE FLORETTE"                         nil     )
    (#x002741 "EIGHT PETALLED OUTLINED BLACK FLORETTE" nil     )
    (#x002742 "CIRCLED OPEN CENTRE EIGHT POINTED STAR" nil     )
    (#x002743 "HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK" nil     )
    (#x002744 "SNOWFLAKE"                              nil     )
    (#x002745 "TIGHT TRIFOLIATE SNOWFLAKE"             nil     )
    (#x002746 "HEAVY CHEVRON SNOWFLAKE"                nil     )
    (#x002747 "SPARKLE"                                nil     )
    (#x002748 "HEAVY SPARKLE"                          nil     )
    (#x002749 "BALLOON-SPOKED ASTERISK"                nil     )
    (#x00274a "EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" nil     )
    (#x00274b "HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" nil     )
    (#x00274c "CROSS MARK"                             nil     )
    (#x00274d "SHADOWED WHITE CIRCLE"                  nil     )
    (#x00274e "NEGATIVE SQUARED CROSS MARK"            nil     )
    (#x00274f "LOWER RIGHT DROP-SHADOWED WHITE SQUARE" nil     )
    (#x002750 "UPPER RIGHT DROP-SHADOWED WHITE SQUARE" nil     )
    (#x002751 "LOWER RIGHT SHADOWED WHITE SQUARE"      nil     )
    (#x002752 "UPPER RIGHT SHADOWED WHITE SQUARE"      nil     )
    (#x002753 "BLACK QUESTION MARK ORNAMENT"           nil     )
    (#x002754 "WHITE QUESTION MARK ORNAMENT"           nil     )
    (#x002755 "WHITE EXCLAMATION MARK ORNAMENT"        nil     )
    (#x002756 "BLACK DIAMOND MINUS WHITE X"            nil     )
    (#x002757 "HEAVY EXCLAMATION MARK SYMBOL"          nil     )
    (#x002758 "LIGHT VERTICAL BAR"                     nil     )
    (#x002759 "MEDIUM VERTICAL BAR"                    nil     )
    (#x00275a "HEAVY VERTICAL BAR"                     nil     )
    (#x00275b "HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT" nil     )
    (#x00275c "HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT" nil     )
    (#x00275d "HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT" nil     )
    (#x00275e "HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT" nil     )
    (#x00275f "HEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENT" nil     )
    (#x002760 "HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT" nil     )
    (#x002761 "CURVED STEM PARAGRAPH SIGN ORNAMENT"    nil     )
    (#x002762 "HEAVY EXCLAMATION MARK ORNAMENT"        nil     )
    (#x002763 "HEAVY HEART EXCLAMATION MARK ORNAMENT"  nil     )
    (#x002764 "HEAVY BLACK HEART"                      nil     )
    (#x002765 "ROTATED HEAVY BLACK HEART BULLET"       nil     )
    (#x002766 "FLORAL HEART"                           nil     )
    (#x002767 "ROTATED FLORAL HEART BULLET"            nil     )
    (#x002768 "MEDIUM LEFT PARENTHESIS ORNAMENT"       nil     )
    (#x002769 "MEDIUM RIGHT PARENTHESIS ORNAMENT"      nil     )
    (#x00276a "MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT" nil     )
    (#x00276b "MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT" nil     )
    (#x00276c "MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT" nil     )
    (#x00276d "MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT" nil     )
    (#x00276e "HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT" nil     )
    (#x00276f "HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT" nil     )
    (#x002770 "HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT" nil     )
    (#x002771 "HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT" nil     )
    (#x002772 "LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT" nil     )
    (#x002773 "LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT" nil     )
    (#x002774 "MEDIUM LEFT CURLY BRACKET ORNAMENT"     nil     )
    (#x002775 "MEDIUM RIGHT CURLY BRACKET ORNAMENT"    nil     )
    (#x002776 "DINGBAT NEGATIVE CIRCLED DIGIT ONE"     nil     )
    (#x002777 "DINGBAT NEGATIVE CIRCLED DIGIT TWO"     nil     )
    (#x002778 "DINGBAT NEGATIVE CIRCLED DIGIT THREE"   nil     )
    (#x002779 "DINGBAT NEGATIVE CIRCLED DIGIT FOUR"    nil     )
    (#x00277a "DINGBAT NEGATIVE CIRCLED DIGIT FIVE"    nil     )
    (#x00277b "DINGBAT NEGATIVE CIRCLED DIGIT SIX"     nil     )
    (#x00277c "DINGBAT NEGATIVE CIRCLED DIGIT SEVEN"   nil     )
    (#x00277d "DINGBAT NEGATIVE CIRCLED DIGIT EIGHT"   nil     )
    (#x00277e "DINGBAT NEGATIVE CIRCLED DIGIT NINE"    nil     )
    (#x00277f "DINGBAT NEGATIVE CIRCLED NUMBER TEN"    nil     )
    (#x002780 "DINGBAT CIRCLED SANS-SERIF DIGIT ONE"   nil     )
    (#x002781 "DINGBAT CIRCLED SANS-SERIF DIGIT TWO"   nil     )
    (#x002782 "DINGBAT CIRCLED SANS-SERIF DIGIT THREE" nil     )
    (#x002783 "DINGBAT CIRCLED SANS-SERIF DIGIT FOUR"  nil     )
    (#x002784 "DINGBAT CIRCLED SANS-SERIF DIGIT FIVE"  nil     )
    (#x002785 "DINGBAT CIRCLED SANS-SERIF DIGIT SIX"   nil     )
    (#x002786 "DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN" nil     )
    (#x002787 "DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT" nil     )
    (#x002788 "DINGBAT CIRCLED SANS-SERIF DIGIT NINE"  nil     )
    (#x002789 "DINGBAT CIRCLED SANS-SERIF NUMBER TEN"  nil     )
    (#x00278a "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE" nil     )
    (#x00278b "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO" nil     )
    (#x00278c "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE" nil     )
    (#x00278d "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR" nil     )
    (#x00278e "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE" nil     )
    (#x00278f "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX" nil     )
    (#x002790 "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN" nil     )
    (#x002791 "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT" nil     )
    (#x002792 "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE" nil     )
    (#x002793 "DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN" nil     )
    (#x002794 "HEAVY WIDE-HEADED RIGHTWARDS ARROW"     nil     )
    (#x002795 "HEAVY PLUS SIGN"                        nil     )
    (#x002796 "HEAVY MINUS SIGN"                       nil     )
    (#x002797 "HEAVY DIVISION SIGN"                    nil     )
    (#x002798 "HEAVY SOUTH EAST ARROW"                 nil     )
    (#x002799 "HEAVY RIGHTWARDS ARROW"                 nil     )
    (#x00279a "HEAVY NORTH EAST ARROW"                 nil     )
    (#x00279b "DRAFTING POINT RIGHTWARDS ARROW"        nil     )
    (#x00279c "HEAVY ROUND-TIPPED RIGHTWARDS ARROW"    nil     )
    (#x00279d "TRIANGLE-HEADED RIGHTWARDS ARROW"       nil     )
    (#x00279e "HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW" nil     )
    (#x00279f "DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" nil     )
    (#x0027a0 "HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" nil     )
    (#x0027a1 "BLACK RIGHTWARDS ARROW"                 nil     )
    (#x0027a2 "THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD" nil     )
    (#x0027a3 "THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD" nil     )
    (#x0027a4 "BLACK RIGHTWARDS ARROWHEAD"             nil     )
    (#x0027a5 "HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW" nil     )
    (#x0027a6 "HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW" nil     )
    (#x0027a7 "SQUAT BLACK RIGHTWARDS ARROW"           nil     )
    (#x0027a8 "HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW" nil     )
    (#x0027a9 "RIGHT-SHADED WHITE RIGHTWARDS ARROW"    nil     )
    (#x0027aa "LEFT-SHADED WHITE RIGHTWARDS ARROW"     nil     )
    (#x0027ab "BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW" nil     )
    (#x0027ac "FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW" nil     )
    (#x0027ad "HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" nil     )
    (#x0027ae "HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" nil     )
    (#x0027af "NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" nil     )
    (#x0027b0 "CURLY LOOP"                             nil     )
    (#x0027b1 "NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" nil     )
    (#x0027b2 "CIRCLED HEAVY WHITE RIGHTWARDS ARROW"   nil     )
    (#x0027b3 "WHITE-FEATHERED RIGHTWARDS ARROW"       nil     )
    (#x0027b4 "BLACK-FEATHERED SOUTH EAST ARROW"       nil     )
    (#x0027b5 "BLACK-FEATHERED RIGHTWARDS ARROW"       nil     )
    (#x0027b6 "BLACK-FEATHERED NORTH EAST ARROW"       nil     )
    (#x0027b7 "HEAVY BLACK-FEATHERED SOUTH EAST ARROW" nil     )
    (#x0027b8 "HEAVY BLACK-FEATHERED RIGHTWARDS ARROW" nil     )
    (#x0027b9 "HEAVY BLACK-FEATHERED NORTH EAST ARROW" nil     )
    (#x0027ba "TEARDROP-BARBED RIGHTWARDS ARROW"       nil     )
    (#x0027bb "HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW" nil     )
    (#x0027bc "WEDGE-TAILED RIGHTWARDS ARROW"          nil     )
    (#x0027bd "HEAVY WEDGE-TAILED RIGHTWARDS ARROW"    nil     )
    (#x0027be "OPEN-OUTLINED RIGHTWARDS ARROW"         nil     )
    (#x0027bf "DOUBLE CURLY LOOP"                      nil     )
    (#x0027c0 "THREE DIMENSIONAL ANGLE"                nil     )
    (#x0027c1 "WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE" nil     )
    (#x0027c2 "PERPENDICULAR"                          nil     )
    (#x0027c3 "OPEN SUBSET"                            nil     )
    (#x0027c4 "OPEN SUPERSET"                          nil     )
    (#x0027c5 "LEFT S-SHAPED BAG DELIMITER"            nil     )
    (#x0027c6 "RIGHT S-SHAPED BAG DELIMITER"           nil     )
    (#x0027c7 "OR WITH DOT INSIDE"                     nil     )
    (#x0027c8 "REVERSE SOLIDUS PRECEDING SUBSET"       nil     )
    (#x0027c9 "SUPERSET PRECEDING SOLIDUS"             nil     )
    (#x0027ca "VERTICAL BAR WITH HORIZONTAL STROKE"    nil     )
    (#x0027cb "MATHEMATICAL RISING DIAGONAL"           nil     )
    (#x0027cc "LONG DIVISION"                          nil     )
    (#x0027cd "MATHEMATICAL FALLING DIAGONAL"          nil     )
    (#x0027ce "SQUARED LOGICAL AND"                    nil     )
    (#x0027cf "SQUARED LOGICAL OR"                     nil     )
    (#x0027d0 "WHITE DIAMOND WITH CENTRED DOT"         nil     )
    (#x0027d1 "AND WITH DOT"                           nil     )
    (#x0027d2 "ELEMENT OF OPENING UPWARDS"             nil     )
    (#x0027d3 "LOWER RIGHT CORNER WITH DOT"            nil     )
    (#x0027d4 "UPPER LEFT CORNER WITH DOT"             nil     )
    (#x0027d5 "LEFT OUTER JOIN"                        nil     )
    (#x0027d6 "RIGHT OUTER JOIN"                       nil     )
    (#x0027d7 "FULL OUTER JOIN"                        nil     )
    (#x0027d8 "LARGE UP TACK"                          nil     )
    (#x0027d9 "LARGE DOWN TACK"                        nil     )
    (#x0027da "LEFT AND RIGHT DOUBLE TURNSTILE"        nil     )
    (#x0027db "LEFT AND RIGHT TACK"                    nil     )
    (#x0027dc "LEFT MULTIMAP"                          nil     )
    (#x0027dd "LONG RIGHT TACK"                        nil     )
    (#x0027de "LONG LEFT TACK"                         nil     )
    (#x0027df "UP TACK WITH CIRCLE ABOVE"              nil     )
    (#x0027e0 "LOZENGE DIVIDED BY HORIZONTAL RULE"     nil     )
    (#x0027e1 "WHITE CONCAVE-SIDED DIAMOND"            nil     )
    (#x0027e2 "WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK" nil     )
    (#x0027e3 "WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK" nil     )
    (#x0027e4 "WHITE SQUARE WITH LEFTWARDS TICK"       nil     )
    (#x0027e5 "WHITE SQUARE WITH RIGHTWARDS TICK"      nil     )
    (#x0027e6 "MATHEMATICAL LEFT WHITE SQUARE BRACKET" nil     )
    (#x0027e7 "MATHEMATICAL RIGHT WHITE SQUARE BRACKET" nil     )
    (#x0027e8 "MATHEMATICAL LEFT ANGLE BRACKET"        nil     )
    (#x0027e9 "MATHEMATICAL RIGHT ANGLE BRACKET"       nil     )
    (#x0027ea "MATHEMATICAL LEFT DOUBLE ANGLE BRACKET" nil     )
    (#x0027eb "MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET" nil     )
    (#x0027ec "MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET" nil     )
    (#x0027ed "MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET" nil     )
    (#x0027ee "MATHEMATICAL LEFT FLATTENED PARENTHESIS" nil     )
    (#x0027ef "MATHEMATICAL RIGHT FLATTENED PARENTHESIS" nil     )
    (#x0027f0 "UPWARDS QUADRUPLE ARROW"                nil     )
    (#x0027f1 "DOWNWARDS QUADRUPLE ARROW"              nil     )
    (#x0027f2 "ANTICLOCKWISE GAPPED CIRCLE ARROW"      nil     )
    (#x0027f3 "CLOCKWISE GAPPED CIRCLE ARROW"          nil     )
    (#x0027f4 "RIGHT ARROW WITH CIRCLED PLUS"          nil     )
    (#x0027f5 "LONG LEFTWARDS ARROW"                   nil     )
    (#x0027f6 "LONG RIGHTWARDS ARROW"                  nil     )
    (#x0027f7 "LONG LEFT RIGHT ARROW"                  "xharr" )
    (#x0027f8 "LONG LEFTWARDS DOUBLE ARROW"            "xlArr" )
    (#x0027f9 "LONG RIGHTWARDS DOUBLE ARROW"           "xrArr" )
    (#x0027fa "LONG LEFT RIGHT DOUBLE ARROW"           "xhArr" )
    (#x0027fb "LONG LEFTWARDS ARROW FROM BAR"          nil     )
    (#x0027fc "LONG RIGHTWARDS ARROW FROM BAR"         nil     )
    (#x0027fd "LONG LEFTWARDS DOUBLE ARROW FROM BAR"   nil     )
    (#x0027fe "LONG RIGHTWARDS DOUBLE ARROW FROM BAR"  nil     )
    (#x0027ff "LONG RIGHTWARDS SQUIGGLE ARROW"         nil     )
    (#x002800 "BRAILLE PATTERN BLANK"                  nil     )
    (#x002801 "BRAILLE PATTERN DOTS-1"                 nil     )
    (#x002802 "BRAILLE PATTERN DOTS-2"                 nil     )
    (#x002803 "BRAILLE PATTERN DOTS-12"                nil     )
    (#x002804 "BRAILLE PATTERN DOTS-3"                 nil     )
    (#x002805 "BRAILLE PATTERN DOTS-13"                nil     )
    (#x002806 "BRAILLE PATTERN DOTS-23"                nil     )
    (#x002807 "BRAILLE PATTERN DOTS-123"               nil     )
    (#x002808 "BRAILLE PATTERN DOTS-4"                 nil     )
    (#x002809 "BRAILLE PATTERN DOTS-14"                nil     )
    (#x00280a "BRAILLE PATTERN DOTS-24"                nil     )
    (#x00280b "BRAILLE PATTERN DOTS-124"               nil     )
    (#x00280c "BRAILLE PATTERN DOTS-34"                nil     )
    (#x00280d "BRAILLE PATTERN DOTS-134"               nil     )
    (#x00280e "BRAILLE PATTERN DOTS-234"               nil     )
    (#x00280f "BRAILLE PATTERN DOTS-1234"              nil     )
    (#x002810 "BRAILLE PATTERN DOTS-5"                 nil     )
    (#x002811 "BRAILLE PATTERN DOTS-15"                nil     )
    (#x002812 "BRAILLE PATTERN DOTS-25"                nil     )
    (#x002813 "BRAILLE PATTERN DOTS-125"               nil     )
    (#x002814 "BRAILLE PATTERN DOTS-35"                nil     )
    (#x002815 "BRAILLE PATTERN DOTS-135"               nil     )
    (#x002816 "BRAILLE PATTERN DOTS-235"               nil     )
    (#x002817 "BRAILLE PATTERN DOTS-1235"              nil     )
    (#x002818 "BRAILLE PATTERN DOTS-45"                nil     )
    (#x002819 "BRAILLE PATTERN DOTS-145"               nil     )
    (#x00281a "BRAILLE PATTERN DOTS-245"               nil     )
    (#x00281b "BRAILLE PATTERN DOTS-1245"              nil     )
    (#x00281c "BRAILLE PATTERN DOTS-345"               nil     )
    (#x00281d "BRAILLE PATTERN DOTS-1345"              nil     )
    (#x00281e "BRAILLE PATTERN DOTS-2345"              nil     )
    (#x00281f "BRAILLE PATTERN DOTS-12345"             nil     )
    (#x002820 "BRAILLE PATTERN DOTS-6"                 nil     )
    (#x002821 "BRAILLE PATTERN DOTS-16"                nil     )
    (#x002822 "BRAILLE PATTERN DOTS-26"                nil     )
    (#x002823 "BRAILLE PATTERN DOTS-126"               nil     )
    (#x002824 "BRAILLE PATTERN DOTS-36"                nil     )
    (#x002825 "BRAILLE PATTERN DOTS-136"               nil     )
    (#x002826 "BRAILLE PATTERN DOTS-236"               nil     )
    (#x002827 "BRAILLE PATTERN DOTS-1236"              nil     )
    (#x002828 "BRAILLE PATTERN DOTS-46"                nil     )
    (#x002829 "BRAILLE PATTERN DOTS-146"               nil     )
    (#x00282a "BRAILLE PATTERN DOTS-246"               nil     )
    (#x00282b "BRAILLE PATTERN DOTS-1246"              nil     )
    (#x00282c "BRAILLE PATTERN DOTS-346"               nil     )
    (#x00282d "BRAILLE PATTERN DOTS-1346"              nil     )
    (#x00282e "BRAILLE PATTERN DOTS-2346"              nil     )
    (#x00282f "BRAILLE PATTERN DOTS-12346"             nil     )
    (#x002830 "BRAILLE PATTERN DOTS-56"                nil     )
    (#x002831 "BRAILLE PATTERN DOTS-156"               nil     )
    (#x002832 "BRAILLE PATTERN DOTS-256"               nil     )
    (#x002833 "BRAILLE PATTERN DOTS-1256"              nil     )
    (#x002834 "BRAILLE PATTERN DOTS-356"               nil     )
    (#x002835 "BRAILLE PATTERN DOTS-1356"              nil     )
    (#x002836 "BRAILLE PATTERN DOTS-2356"              nil     )
    (#x002837 "BRAILLE PATTERN DOTS-12356"             nil     )
    (#x002838 "BRAILLE PATTERN DOTS-456"               nil     )
    (#x002839 "BRAILLE PATTERN DOTS-1456"              nil     )
    (#x00283a "BRAILLE PATTERN DOTS-2456"              nil     )
    (#x00283b "BRAILLE PATTERN DOTS-12456"             nil     )
    (#x00283c "BRAILLE PATTERN DOTS-3456"              nil     )
    (#x00283d "BRAILLE PATTERN DOTS-13456"             nil     )
    (#x00283e "BRAILLE PATTERN DOTS-23456"             nil     )
    (#x00283f "BRAILLE PATTERN DOTS-123456"            nil     )
    (#x002840 "BRAILLE PATTERN DOTS-7"                 nil     )
    (#x002841 "BRAILLE PATTERN DOTS-17"                nil     )
    (#x002842 "BRAILLE PATTERN DOTS-27"                nil     )
    (#x002843 "BRAILLE PATTERN DOTS-127"               nil     )
    (#x002844 "BRAILLE PATTERN DOTS-37"                nil     )
    (#x002845 "BRAILLE PATTERN DOTS-137"               nil     )
    (#x002846 "BRAILLE PATTERN DOTS-237"               nil     )
    (#x002847 "BRAILLE PATTERN DOTS-1237"              nil     )
    (#x002848 "BRAILLE PATTERN DOTS-47"                nil     )
    (#x002849 "BRAILLE PATTERN DOTS-147"               nil     )
    (#x00284a "BRAILLE PATTERN DOTS-247"               nil     )
    (#x00284b "BRAILLE PATTERN DOTS-1247"              nil     )
    (#x00284c "BRAILLE PATTERN DOTS-347"               nil     )
    (#x00284d "BRAILLE PATTERN DOTS-1347"              nil     )
    (#x00284e "BRAILLE PATTERN DOTS-2347"              nil     )
    (#x00284f "BRAILLE PATTERN DOTS-12347"             nil     )
    (#x002850 "BRAILLE PATTERN DOTS-57"                nil     )
    (#x002851 "BRAILLE PATTERN DOTS-157"               nil     )
    (#x002852 "BRAILLE PATTERN DOTS-257"               nil     )
    (#x002853 "BRAILLE PATTERN DOTS-1257"              nil     )
    (#x002854 "BRAILLE PATTERN DOTS-357"               nil     )
    (#x002855 "BRAILLE PATTERN DOTS-1357"              nil     )
    (#x002856 "BRAILLE PATTERN DOTS-2357"              nil     )
    (#x002857 "BRAILLE PATTERN DOTS-12357"             nil     )
    (#x002858 "BRAILLE PATTERN DOTS-457"               nil     )
    (#x002859 "BRAILLE PATTERN DOTS-1457"              nil     )
    (#x00285a "BRAILLE PATTERN DOTS-2457"              nil     )
    (#x00285b "BRAILLE PATTERN DOTS-12457"             nil     )
    (#x00285c "BRAILLE PATTERN DOTS-3457"              nil     )
    (#x00285d "BRAILLE PATTERN DOTS-13457"             nil     )
    (#x00285e "BRAILLE PATTERN DOTS-23457"             nil     )
    (#x00285f "BRAILLE PATTERN DOTS-123457"            nil     )
    (#x002860 "BRAILLE PATTERN DOTS-67"                nil     )
    (#x002861 "BRAILLE PATTERN DOTS-167"               nil     )
    (#x002862 "BRAILLE PATTERN DOTS-267"               nil     )
    (#x002863 "BRAILLE PATTERN DOTS-1267"              nil     )
    (#x002864 "BRAILLE PATTERN DOTS-367"               nil     )
    (#x002865 "BRAILLE PATTERN DOTS-1367"              nil     )
    (#x002866 "BRAILLE PATTERN DOTS-2367"              nil     )
    (#x002867 "BRAILLE PATTERN DOTS-12367"             nil     )
    (#x002868 "BRAILLE PATTERN DOTS-467"               nil     )
    (#x002869 "BRAILLE PATTERN DOTS-1467"              nil     )
    (#x00286a "BRAILLE PATTERN DOTS-2467"              nil     )
    (#x00286b "BRAILLE PATTERN DOTS-12467"             nil     )
    (#x00286c "BRAILLE PATTERN DOTS-3467"              nil     )
    (#x00286d "BRAILLE PATTERN DOTS-13467"             nil     )
    (#x00286e "BRAILLE PATTERN DOTS-23467"             nil     )
    (#x00286f "BRAILLE PATTERN DOTS-123467"            nil     )
    (#x002870 "BRAILLE PATTERN DOTS-567"               nil     )
    (#x002871 "BRAILLE PATTERN DOTS-1567"              nil     )
    (#x002872 "BRAILLE PATTERN DOTS-2567"              nil     )
    (#x002873 "BRAILLE PATTERN DOTS-12567"             nil     )
    (#x002874 "BRAILLE PATTERN DOTS-3567"              nil     )
    (#x002875 "BRAILLE PATTERN DOTS-13567"             nil     )
    (#x002876 "BRAILLE PATTERN DOTS-23567"             nil     )
    (#x002877 "BRAILLE PATTERN DOTS-123567"            nil     )
    (#x002878 "BRAILLE PATTERN DOTS-4567"              nil     )
    (#x002879 "BRAILLE PATTERN DOTS-14567"             nil     )
    (#x00287a "BRAILLE PATTERN DOTS-24567"             nil     )
    (#x00287b "BRAILLE PATTERN DOTS-124567"            nil     )
    (#x00287c "BRAILLE PATTERN DOTS-34567"             nil     )
    (#x00287d "BRAILLE PATTERN DOTS-134567"            nil     )
    (#x00287e "BRAILLE PATTERN DOTS-234567"            nil     )
    (#x00287f "BRAILLE PATTERN DOTS-1234567"           nil     )
    (#x002880 "BRAILLE PATTERN DOTS-8"                 nil     )
    (#x002881 "BRAILLE PATTERN DOTS-18"                nil     )
    (#x002882 "BRAILLE PATTERN DOTS-28"                nil     )
    (#x002883 "BRAILLE PATTERN DOTS-128"               nil     )
    (#x002884 "BRAILLE PATTERN DOTS-38"                nil     )
    (#x002885 "BRAILLE PATTERN DOTS-138"               nil     )
    (#x002886 "BRAILLE PATTERN DOTS-238"               nil     )
    (#x002887 "BRAILLE PATTERN DOTS-1238"              nil     )
    (#x002888 "BRAILLE PATTERN DOTS-48"                nil     )
    (#x002889 "BRAILLE PATTERN DOTS-148"               nil     )
    (#x00288a "BRAILLE PATTERN DOTS-248"               nil     )
    (#x00288b "BRAILLE PATTERN DOTS-1248"              nil     )
    (#x00288c "BRAILLE PATTERN DOTS-348"               nil     )
    (#x00288d "BRAILLE PATTERN DOTS-1348"              nil     )
    (#x00288e "BRAILLE PATTERN DOTS-2348"              nil     )
    (#x00288f "BRAILLE PATTERN DOTS-12348"             nil     )
    (#x002890 "BRAILLE PATTERN DOTS-58"                nil     )
    (#x002891 "BRAILLE PATTERN DOTS-158"               nil     )
    (#x002892 "BRAILLE PATTERN DOTS-258"               nil     )
    (#x002893 "BRAILLE PATTERN DOTS-1258"              nil     )
    (#x002894 "BRAILLE PATTERN DOTS-358"               nil     )
    (#x002895 "BRAILLE PATTERN DOTS-1358"              nil     )
    (#x002896 "BRAILLE PATTERN DOTS-2358"              nil     )
    (#x002897 "BRAILLE PATTERN DOTS-12358"             nil     )
    (#x002898 "BRAILLE PATTERN DOTS-458"               nil     )
    (#x002899 "BRAILLE PATTERN DOTS-1458"              nil     )
    (#x00289a "BRAILLE PATTERN DOTS-2458"              nil     )
    (#x00289b "BRAILLE PATTERN DOTS-12458"             nil     )
    (#x00289c "BRAILLE PATTERN DOTS-3458"              nil     )
    (#x00289d "BRAILLE PATTERN DOTS-13458"             nil     )
    (#x00289e "BRAILLE PATTERN DOTS-23458"             nil     )
    (#x00289f "BRAILLE PATTERN DOTS-123458"            nil     )
    (#x0028a0 "BRAILLE PATTERN DOTS-68"                nil     )
    (#x0028a1 "BRAILLE PATTERN DOTS-168"               nil     )
    (#x0028a2 "BRAILLE PATTERN DOTS-268"               nil     )
    (#x0028a3 "BRAILLE PATTERN DOTS-1268"              nil     )
    (#x0028a4 "BRAILLE PATTERN DOTS-368"               nil     )
    (#x0028a5 "BRAILLE PATTERN DOTS-1368"              nil     )
    (#x0028a6 "BRAILLE PATTERN DOTS-2368"              nil     )
    (#x0028a7 "BRAILLE PATTERN DOTS-12368"             nil     )
    (#x0028a8 "BRAILLE PATTERN DOTS-468"               nil     )
    (#x0028a9 "BRAILLE PATTERN DOTS-1468"              nil     )
    (#x0028aa "BRAILLE PATTERN DOTS-2468"              nil     )
    (#x0028ab "BRAILLE PATTERN DOTS-12468"             nil     )
    (#x0028ac "BRAILLE PATTERN DOTS-3468"              nil     )
    (#x0028ad "BRAILLE PATTERN DOTS-13468"             nil     )
    (#x0028ae "BRAILLE PATTERN DOTS-23468"             nil     )
    (#x0028af "BRAILLE PATTERN DOTS-123468"            nil     )
    (#x0028b0 "BRAILLE PATTERN DOTS-568"               nil     )
    (#x0028b1 "BRAILLE PATTERN DOTS-1568"              nil     )
    (#x0028b2 "BRAILLE PATTERN DOTS-2568"              nil     )
    (#x0028b3 "BRAILLE PATTERN DOTS-12568"             nil     )
    (#x0028b4 "BRAILLE PATTERN DOTS-3568"              nil     )
    (#x0028b5 "BRAILLE PATTERN DOTS-13568"             nil     )
    (#x0028b6 "BRAILLE PATTERN DOTS-23568"             nil     )
    (#x0028b7 "BRAILLE PATTERN DOTS-123568"            nil     )
    (#x0028b8 "BRAILLE PATTERN DOTS-4568"              nil     )
    (#x0028b9 "BRAILLE PATTERN DOTS-14568"             nil     )
    (#x0028ba "BRAILLE PATTERN DOTS-24568"             nil     )
    (#x0028bb "BRAILLE PATTERN DOTS-124568"            nil     )
    (#x0028bc "BRAILLE PATTERN DOTS-34568"             nil     )
    (#x0028bd "BRAILLE PATTERN DOTS-134568"            nil     )
    (#x0028be "BRAILLE PATTERN DOTS-234568"            nil     )
    (#x0028bf "BRAILLE PATTERN DOTS-1234568"           nil     )
    (#x0028c0 "BRAILLE PATTERN DOTS-78"                nil     )
    (#x0028c1 "BRAILLE PATTERN DOTS-178"               nil     )
    (#x0028c2 "BRAILLE PATTERN DOTS-278"               nil     )
    (#x0028c3 "BRAILLE PATTERN DOTS-1278"              nil     )
    (#x0028c4 "BRAILLE PATTERN DOTS-378"               nil     )
    (#x0028c5 "BRAILLE PATTERN DOTS-1378"              nil     )
    (#x0028c6 "BRAILLE PATTERN DOTS-2378"              nil     )
    (#x0028c7 "BRAILLE PATTERN DOTS-12378"             nil     )
    (#x0028c8 "BRAILLE PATTERN DOTS-478"               nil     )
    (#x0028c9 "BRAILLE PATTERN DOTS-1478"              nil     )
    (#x0028ca "BRAILLE PATTERN DOTS-2478"              nil     )
    (#x0028cb "BRAILLE PATTERN DOTS-12478"             nil     )
    (#x0028cc "BRAILLE PATTERN DOTS-3478"              nil     )
    (#x0028cd "BRAILLE PATTERN DOTS-13478"             nil     )
    (#x0028ce "BRAILLE PATTERN DOTS-23478"             nil     )
    (#x0028cf "BRAILLE PATTERN DOTS-123478"            nil     )
    (#x0028d0 "BRAILLE PATTERN DOTS-578"               nil     )
    (#x0028d1 "BRAILLE PATTERN DOTS-1578"              nil     )
    (#x0028d2 "BRAILLE PATTERN DOTS-2578"              nil     )
    (#x0028d3 "BRAILLE PATTERN DOTS-12578"             nil     )
    (#x0028d4 "BRAILLE PATTERN DOTS-3578"              nil     )
    (#x0028d5 "BRAILLE PATTERN DOTS-13578"             nil     )
    (#x0028d6 "BRAILLE PATTERN DOTS-23578"             nil     )
    (#x0028d7 "BRAILLE PATTERN DOTS-123578"            nil     )
    (#x0028d8 "BRAILLE PATTERN DOTS-4578"              nil     )
    (#x0028d9 "BRAILLE PATTERN DOTS-14578"             nil     )
    (#x0028da "BRAILLE PATTERN DOTS-24578"             nil     )
    (#x0028db "BRAILLE PATTERN DOTS-124578"            nil     )
    (#x0028dc "BRAILLE PATTERN DOTS-34578"             nil     )
    (#x0028dd "BRAILLE PATTERN DOTS-134578"            nil     )
    (#x0028de "BRAILLE PATTERN DOTS-234578"            nil     )
    (#x0028df "BRAILLE PATTERN DOTS-1234578"           nil     )
    (#x0028e0 "BRAILLE PATTERN DOTS-678"               nil     )
    (#x0028e1 "BRAILLE PATTERN DOTS-1678"              nil     )
    (#x0028e2 "BRAILLE PATTERN DOTS-2678"              nil     )
    (#x0028e3 "BRAILLE PATTERN DOTS-12678"             nil     )
    (#x0028e4 "BRAILLE PATTERN DOTS-3678"              nil     )
    (#x0028e5 "BRAILLE PATTERN DOTS-13678"             nil     )
    (#x0028e6 "BRAILLE PATTERN DOTS-23678"             nil     )
    (#x0028e7 "BRAILLE PATTERN DOTS-123678"            nil     )
    (#x0028e8 "BRAILLE PATTERN DOTS-4678"              nil     )
    (#x0028e9 "BRAILLE PATTERN DOTS-14678"             nil     )
    (#x0028ea "BRAILLE PATTERN DOTS-24678"             nil     )
    (#x0028eb "BRAILLE PATTERN DOTS-124678"            nil     )
    (#x0028ec "BRAILLE PATTERN DOTS-34678"             nil     )
    (#x0028ed "BRAILLE PATTERN DOTS-134678"            nil     )
    (#x0028ee "BRAILLE PATTERN DOTS-234678"            nil     )
    (#x0028ef "BRAILLE PATTERN DOTS-1234678"           nil     )
    (#x0028f0 "BRAILLE PATTERN DOTS-5678"              nil     )
    (#x0028f1 "BRAILLE PATTERN DOTS-15678"             nil     )
    (#x0028f2 "BRAILLE PATTERN DOTS-25678"             nil     )
    (#x0028f3 "BRAILLE PATTERN DOTS-125678"            nil     )
    (#x0028f4 "BRAILLE PATTERN DOTS-35678"             nil     )
    (#x0028f5 "BRAILLE PATTERN DOTS-135678"            nil     )
    (#x0028f6 "BRAILLE PATTERN DOTS-235678"            nil     )
    (#x0028f7 "BRAILLE PATTERN DOTS-1235678"           nil     )
    (#x0028f8 "BRAILLE PATTERN DOTS-45678"             nil     )
    (#x0028f9 "BRAILLE PATTERN DOTS-145678"            nil     )
    (#x0028fa "BRAILLE PATTERN DOTS-245678"            nil     )
    (#x0028fb "BRAILLE PATTERN DOTS-1245678"           nil     )
    (#x0028fc "BRAILLE PATTERN DOTS-345678"            nil     )
    (#x0028fd "BRAILLE PATTERN DOTS-1345678"           nil     )
    (#x0028fe "BRAILLE PATTERN DOTS-2345678"           nil     )
    (#x0028ff "BRAILLE PATTERN DOTS-12345678"          nil     )
    (#x002900 "RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE" nil     )
    (#x002901 "RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE" nil     )
    (#x002902 "LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE" nil     )
    (#x002903 "RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE" nil     )
    (#x002904 "LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE" nil     )
    (#x002905 "RIGHTWARDS TWO-HEADED ARROW FROM BAR"   nil     )
    (#x002906 "LEFTWARDS DOUBLE ARROW FROM BAR"        nil     )
    (#x002907 "RIGHTWARDS DOUBLE ARROW FROM BAR"       nil     )
    (#x002908 "DOWNWARDS ARROW WITH HORIZONTAL STROKE" nil     )
    (#x002909 "UPWARDS ARROW WITH HORIZONTAL STROKE"   nil     )
    (#x00290a "UPWARDS TRIPLE ARROW"                   nil     )
    (#x00290b "DOWNWARDS TRIPLE ARROW"                 nil     )
    (#x00290c "LEFTWARDS DOUBLE DASH ARROW"            nil     )
    (#x00290d "RIGHTWARDS DOUBLE DASH ARROW"           nil     )
    (#x00290e "LEFTWARDS TRIPLE DASH ARROW"            nil     )
    (#x00290f "RIGHTWARDS TRIPLE DASH ARROW"           nil     )
    (#x002910 "RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW" nil     )
    (#x002911 "RIGHTWARDS ARROW WITH DOTTED STEM"      nil     )
    (#x002912 "UPWARDS ARROW TO BAR"                   nil     )
    (#x002913 "DOWNWARDS ARROW TO BAR"                 nil     )
    (#x002914 "RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE" nil     )
    (#x002915 "RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" nil     )
    (#x002916 "RIGHTWARDS TWO-HEADED ARROW WITH TAIL"  nil     )
    (#x002917 "RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE" nil     )
    (#x002918 "RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" nil     )
    (#x002919 "LEFTWARDS ARROW-TAIL"                   nil     )
    (#x00291a "RIGHTWARDS ARROW-TAIL"                  nil     )
    (#x00291b "LEFTWARDS DOUBLE ARROW-TAIL"            nil     )
    (#x00291c "RIGHTWARDS DOUBLE ARROW-TAIL"           nil     )
    (#x00291d "LEFTWARDS ARROW TO BLACK DIAMOND"       nil     )
    (#x00291e "RIGHTWARDS ARROW TO BLACK DIAMOND"      nil     )
    (#x00291f "LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND" nil     )
    (#x002920 "RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND" nil     )
    (#x002921 "NORTH WEST AND SOUTH EAST ARROW"        nil     )
    (#x002922 "NORTH EAST AND SOUTH WEST ARROW"        nil     )
    (#x002923 "NORTH WEST ARROW WITH HOOK"             nil     )
    (#x002924 "NORTH EAST ARROW WITH HOOK"             nil     )
    (#x002925 "SOUTH EAST ARROW WITH HOOK"             nil     )
    (#x002926 "SOUTH WEST ARROW WITH HOOK"             nil     )
    (#x002927 "NORTH WEST ARROW AND NORTH EAST ARROW"  nil     )
    (#x002928 "NORTH EAST ARROW AND SOUTH EAST ARROW"  nil     )
    (#x002929 "SOUTH EAST ARROW AND SOUTH WEST ARROW"  nil     )
    (#x00292a "SOUTH WEST ARROW AND NORTH WEST ARROW"  nil     )
    (#x00292b "RISING DIAGONAL CROSSING FALLING DIAGONAL" nil     )
    (#x00292c "FALLING DIAGONAL CROSSING RISING DIAGONAL" nil     )
    (#x00292d "SOUTH EAST ARROW CROSSING NORTH EAST ARROW" nil     )
    (#x00292e "NORTH EAST ARROW CROSSING SOUTH EAST ARROW" nil     )
    (#x00292f "FALLING DIAGONAL CROSSING NORTH EAST ARROW" nil     )
    (#x002930 "RISING DIAGONAL CROSSING SOUTH EAST ARROW" nil     )
    (#x002931 "NORTH EAST ARROW CROSSING NORTH WEST ARROW" nil     )
    (#x002932 "NORTH WEST ARROW CROSSING NORTH EAST ARROW" nil     )
    (#x002933 "WAVE ARROW POINTING DIRECTLY RIGHT"     nil     )
    (#x002934 "ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS" nil     )
    (#x002935 "ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS" nil     )
    (#x002936 "ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS" nil     )
    (#x002937 "ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS" nil     )
    (#x002938 "RIGHT-SIDE ARC CLOCKWISE ARROW"         nil     )
    (#x002939 "LEFT-SIDE ARC ANTICLOCKWISE ARROW"      nil     )
    (#x00293a "TOP ARC ANTICLOCKWISE ARROW"            nil     )
    (#x00293b "BOTTOM ARC ANTICLOCKWISE ARROW"         nil     )
    (#x00293c "TOP ARC CLOCKWISE ARROW WITH MINUS"     nil     )
    (#x00293d "TOP ARC ANTICLOCKWISE ARROW WITH PLUS"  nil     )
    (#x00293e "LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW" nil     )
    (#x00293f "LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW" nil     )
    (#x002940 "ANTICLOCKWISE CLOSED CIRCLE ARROW"      nil     )
    (#x002941 "CLOCKWISE CLOSED CIRCLE ARROW"          nil     )
    (#x002942 "RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW" nil     )
    (#x002943 "LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW" nil     )
    (#x002944 "SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW" nil     )
    (#x002945 "RIGHTWARDS ARROW WITH PLUS BELOW"       nil     )
    (#x002946 "LEFTWARDS ARROW WITH PLUS BELOW"        nil     )
    (#x002947 "RIGHTWARDS ARROW THROUGH X"             nil     )
    (#x002948 "LEFT RIGHT ARROW THROUGH SMALL CIRCLE"  nil     )
    (#x002949 "UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE" nil     )
    (#x00294a "LEFT BARB UP RIGHT BARB DOWN HARPOON"   nil     )
    (#x00294b "LEFT BARB DOWN RIGHT BARB UP HARPOON"   nil     )
    (#x00294c "UP BARB RIGHT DOWN BARB LEFT HARPOON"   nil     )
    (#x00294d "UP BARB LEFT DOWN BARB RIGHT HARPOON"   nil     )
    (#x00294e "LEFT BARB UP RIGHT BARB UP HARPOON"     nil     )
    (#x00294f "UP BARB RIGHT DOWN BARB RIGHT HARPOON"  nil     )
    (#x002950 "LEFT BARB DOWN RIGHT BARB DOWN HARPOON" nil     )
    (#x002951 "UP BARB LEFT DOWN BARB LEFT HARPOON"    nil     )
    (#x002952 "LEFTWARDS HARPOON WITH BARB UP TO BAR"  nil     )
    (#x002953 "RIGHTWARDS HARPOON WITH BARB UP TO BAR" nil     )
    (#x002954 "UPWARDS HARPOON WITH BARB RIGHT TO BAR" nil     )
    (#x002955 "DOWNWARDS HARPOON WITH BARB RIGHT TO BAR" nil     )
    (#x002956 "LEFTWARDS HARPOON WITH BARB DOWN TO BAR" nil     )
    (#x002957 "RIGHTWARDS HARPOON WITH BARB DOWN TO BAR" nil     )
    (#x002958 "UPWARDS HARPOON WITH BARB LEFT TO BAR"  nil     )
    (#x002959 "DOWNWARDS HARPOON WITH BARB LEFT TO BAR" nil     )
    (#x00295a "LEFTWARDS HARPOON WITH BARB UP FROM BAR" nil     )
    (#x00295b "RIGHTWARDS HARPOON WITH BARB UP FROM BAR" nil     )
    (#x00295c "UPWARDS HARPOON WITH BARB RIGHT FROM BAR" nil     )
    (#x00295d "DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR" nil     )
    (#x00295e "LEFTWARDS HARPOON WITH BARB DOWN FROM BAR" nil     )
    (#x00295f "RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR" nil     )
    (#x002960 "UPWARDS HARPOON WITH BARB LEFT FROM BAR" nil     )
    (#x002961 "DOWNWARDS HARPOON WITH BARB LEFT FROM BAR" nil     )
    (#x002962 "LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN" nil     )
    (#x002963 "UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT" nil     )
    (#x002964 "RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN" nil     )
    (#x002965 "DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT" nil     )
    (#x002966 "LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP" nil     )
    (#x002967 "LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN" nil     )
    (#x002968 "RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP" nil     )
    (#x002969 "RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN" nil     )
    (#x00296a "LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH" nil     )
    (#x00296b "LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH" nil     )
    (#x00296c "RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH" nil     )
    (#x00296d "RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH" nil     )
    (#x00296e "UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT" nil     )
    (#x00296f "DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT" nil     )
    (#x002970 "RIGHT DOUBLE ARROW WITH ROUNDED HEAD"   nil     )
    (#x002971 "EQUALS SIGN ABOVE RIGHTWARDS ARROW"     nil     )
    (#x002972 "TILDE OPERATOR ABOVE RIGHTWARDS ARROW"  nil     )
    (#x002973 "LEFTWARDS ARROW ABOVE TILDE OPERATOR"   nil     )
    (#x002974 "RIGHTWARDS ARROW ABOVE TILDE OPERATOR"  nil     )
    (#x002975 "RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO" nil     )
    (#x002976 "LESS-THAN ABOVE LEFTWARDS ARROW"        nil     )
    (#x002977 "LEFTWARDS ARROW THROUGH LESS-THAN"      nil     )
    (#x002978 "GREATER-THAN ABOVE RIGHTWARDS ARROW"    nil     )
    (#x002979 "SUBSET ABOVE RIGHTWARDS ARROW"          nil     )
    (#x00297a "LEFTWARDS ARROW THROUGH SUBSET"         nil     )
    (#x00297b "SUPERSET ABOVE LEFTWARDS ARROW"         nil     )
    (#x00297c "LEFT FISH TAIL"                         nil     )
    (#x00297d "RIGHT FISH TAIL"                        nil     )
    (#x00297e "UP FISH TAIL"                           nil     )
    (#x00297f "DOWN FISH TAIL"                         nil     )
    (#x002980 "TRIPLE VERTICAL BAR DELIMITER"          nil     )
    (#x002981 "Z NOTATION SPOT"                        nil     )
    (#x002982 "Z NOTATION TYPE COLON"                  nil     )
    (#x002983 "LEFT WHITE CURLY BRACKET"               nil     )
    (#x002984 "RIGHT WHITE CURLY BRACKET"              nil     )
    (#x002985 "LEFT WHITE PARENTHESIS"                 nil     )
    (#x002986 "RIGHT WHITE PARENTHESIS"                nil     )
    (#x002987 "Z NOTATION LEFT IMAGE BRACKET"          nil     )
    (#x002988 "Z NOTATION RIGHT IMAGE BRACKET"         nil     )
    (#x002989 "Z NOTATION LEFT BINDING BRACKET"        nil     )
    (#x00298a "Z NOTATION RIGHT BINDING BRACKET"       nil     )
    (#x00298b "LEFT SQUARE BRACKET WITH UNDERBAR"      nil     )
    (#x00298c "RIGHT SQUARE BRACKET WITH UNDERBAR"     nil     )
    (#x00298d "LEFT SQUARE BRACKET WITH TICK IN TOP CORNER" nil     )
    (#x00298e "RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER" nil     )
    (#x00298f "LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER" nil     )
    (#x002990 "RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER" nil     )
    (#x002991 "LEFT ANGLE BRACKET WITH DOT"            nil     )
    (#x002992 "RIGHT ANGLE BRACKET WITH DOT"           nil     )
    (#x002993 "LEFT ARC LESS-THAN BRACKET"             nil     )
    (#x002994 "RIGHT ARC GREATER-THAN BRACKET"         "rpargt")
    (#x002995 "DOUBLE LEFT ARC GREATER-THAN BRACKET"   nil     )
    (#x002996 "DOUBLE RIGHT ARC LESS-THAN BRACKET"     nil     )
    (#x002997 "LEFT BLACK TORTOISE SHELL BRACKET"      nil     )
    (#x002998 "RIGHT BLACK TORTOISE SHELL BRACKET"     nil     )
    (#x002999 "DOTTED FENCE"                           nil     )
    (#x00299a "VERTICAL ZIGZAG LINE"                   nil     )
    (#x00299b "MEASURED ANGLE OPENING LEFT"            nil     )
    (#x00299c "RIGHT ANGLE VARIANT WITH SQUARE"        nil     )
    (#x00299d "MEASURED RIGHT ANGLE WITH DOT"          nil     )
    (#x00299e "ANGLE WITH S INSIDE"                    nil     )
    (#x00299f "ACUTE ANGLE"                            nil     )
    (#x0029a0 "SPHERICAL ANGLE OPENING LEFT"           "lpargt")
    (#x0029a1 "SPHERICAL ANGLE OPENING UP"             nil     )
    (#x0029a2 "TURNED ANGLE"                           nil     )
    (#x0029a3 "REVERSED ANGLE"                         nil     )
    (#x0029a4 "ANGLE WITH UNDERBAR"                    nil     )
    (#x0029a5 "REVERSED ANGLE WITH UNDERBAR"           nil     )
    (#x0029a6 "OBLIQUE ANGLE OPENING UP"               nil     )
    (#x0029a7 "OBLIQUE ANGLE OPENING DOWN"             nil     )
    (#x0029a8 "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT" nil     )
    (#x0029a9 "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT" nil     )
    (#x0029aa "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT" nil     )
    (#x0029ab "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT" nil     )
    (#x0029ac "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP" nil     )
    (#x0029ad "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP" nil     )
    (#x0029ae "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN" nil     )
    (#x0029af "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN" nil     )
    (#x0029b0 "REVERSED EMPTY SET"                     nil     )
    (#x0029b1 "EMPTY SET WITH OVERBAR"                 nil     )
    (#x0029b2 "EMPTY SET WITH SMALL CIRCLE ABOVE"      nil     )
    (#x0029b3 "EMPTY SET WITH RIGHT ARROW ABOVE"       nil     )
    (#x0029b4 "EMPTY SET WITH LEFT ARROW ABOVE"        nil     )
    (#x0029b5 "CIRCLE WITH HORIZONTAL BAR"             nil     )
    (#x0029b6 "CIRCLED VERTICAL BAR"                   nil     )
    (#x0029b7 "CIRCLED PARALLEL"                       nil     )
    (#x0029b8 "CIRCLED REVERSE SOLIDUS"                nil     )
    (#x0029b9 "CIRCLED PERPENDICULAR"                  nil     )
    (#x0029ba "CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR" nil     )
    (#x0029bb "CIRCLE WITH SUPERIMPOSED X"             nil     )
    (#x0029bc "CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN" nil     )
    (#x0029bd "UP ARROW THROUGH CIRCLE"                nil     )
    (#x0029be "CIRCLED WHITE BULLET"                   nil     )
    (#x0029bf "CIRCLED BULLET"                         nil     )
    (#x0029c0 "CIRCLED LESS-THAN"                      nil     )
    (#x0029c1 "CIRCLED GREATER-THAN"                   nil     )
    (#x0029c2 "CIRCLE WITH SMALL CIRCLE TO THE RIGHT"  nil     )
    (#x0029c3 "CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT" nil     )
    (#x0029c4 "SQUARED RISING DIAGONAL SLASH"          nil     )
    (#x0029c5 "SQUARED FALLING DIAGONAL SLASH"         nil     )
    (#x0029c6 "SQUARED ASTERISK"                       nil     )
    (#x0029c7 "SQUARED SMALL CIRCLE"                   nil     )
    (#x0029c8 "SQUARED SQUARE"                         nil     )
    (#x0029c9 "TWO JOINED SQUARES"                     nil     )
    (#x0029ca "TRIANGLE WITH DOT ABOVE"                nil     )
    (#x0029cb "TRIANGLE WITH UNDERBAR"                 nil     )
    (#x0029cc "S IN TRIANGLE"                          nil     )
    (#x0029cd "TRIANGLE WITH SERIFS AT BOTTOM"         nil     )
    (#x0029ce "RIGHT TRIANGLE ABOVE LEFT TRIANGLE"     nil     )
    (#x0029cf "LEFT TRIANGLE BESIDE VERTICAL BAR"      nil     )
    (#x0029d0 "VERTICAL BAR BESIDE RIGHT TRIANGLE"     nil     )
    (#x0029d1 "BOWTIE WITH LEFT HALF BLACK"            nil     )
    (#x0029d2 "BOWTIE WITH RIGHT HALF BLACK"           nil     )
    (#x0029d3 "BLACK BOWTIE"                           nil     )
    (#x0029d4 "TIMES WITH LEFT HALF BLACK"             nil     )
    (#x0029d5 "TIMES WITH RIGHT HALF BLACK"            nil     )
    (#x0029d6 "WHITE HOURGLASS"                        nil     )
    (#x0029d7 "BLACK HOURGLASS"                        nil     )
    (#x0029d8 "LEFT WIGGLY FENCE"                      nil     )
    (#x0029d9 "RIGHT WIGGLY FENCE"                     nil     )
    (#x0029da "LEFT DOUBLE WIGGLY FENCE"               nil     )
    (#x0029db "RIGHT DOUBLE WIGGLY FENCE"              nil     )
    (#x0029dc "INCOMPLETE INFINITY"                    nil     )
    (#x0029dd "TIE OVER INFINITY"                      nil     )
    (#x0029de "INFINITY NEGATED WITH VERTICAL BAR"     nil     )
    (#x0029df "DOUBLE-ENDED MULTIMAP"                  nil     )
    (#x0029e0 "SQUARE WITH CONTOURED OUTLINE"          nil     )
    (#x0029e1 "INCREASES AS"                           nil     )
    (#x0029e2 "SHUFFLE PRODUCT"                        nil     )
    (#x0029e3 "EQUALS SIGN AND SLANTED PARALLEL"       nil     )
    (#x0029e4 "EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE" nil     )
    (#x0029e5 "IDENTICAL TO AND SLANTED PARALLEL"      nil     )
    (#x0029e6 "GLEICH STARK"                           nil     )
    (#x0029e7 "THERMODYNAMIC"                          nil     )
    (#x0029e8 "DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK" nil     )
    (#x0029e9 "DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK" nil     )
    (#x0029ea "BLACK DIAMOND WITH DOWN ARROW"          nil     )
    (#x0029eb "BLACK LOZENGE"                          "lozf"  )
    (#x0029ec "WHITE CIRCLE WITH DOWN ARROW"           nil     )
    (#x0029ed "BLACK CIRCLE WITH DOWN ARROW"           nil     )
    (#x0029ee "ERROR-BARRED WHITE SQUARE"              nil     )
    (#x0029ef "ERROR-BARRED BLACK SQUARE"              nil     )
    (#x0029f0 "ERROR-BARRED WHITE DIAMOND"             nil     )
    (#x0029f1 "ERROR-BARRED BLACK DIAMOND"             nil     )
    (#x0029f2 "ERROR-BARRED WHITE CIRCLE"              nil     )
    (#x0029f3 "ERROR-BARRED BLACK CIRCLE"              nil     )
    (#x0029f4 "RULE-DELAYED"                           nil     )
    (#x0029f5 "REVERSE SOLIDUS OPERATOR"               nil     )
    (#x0029f6 "SOLIDUS WITH OVERBAR"                   nil     )
    (#x0029f7 "REVERSE SOLIDUS WITH HORIZONTAL STROKE" nil     )
    (#x0029f8 "BIG SOLIDUS"                            nil     )
    (#x0029f9 "BIG REVERSE SOLIDUS"                    nil     )
    (#x0029fa "DOUBLE PLUS"                            nil     )
    (#x0029fb "TRIPLE PLUS"                            nil     )
    (#x0029fc "LEFT-POINTING CURVED ANGLE BRACKET"     nil     )
    (#x0029fd "RIGHT-POINTING CURVED ANGLE BRACKET"    nil     )
    (#x0029fe "TINY"                                   nil     )
    (#x0029ff "MINY"                                   nil     )
    (#x002a00 "N-ARY CIRCLED DOT OPERATOR"             nil     )
    (#x002a01 "N-ARY CIRCLED PLUS OPERATOR"            nil     )
    (#x002a02 "N-ARY CIRCLED TIMES OPERATOR"           nil     )
    (#x002a03 "N-ARY UNION OPERATOR WITH DOT"          nil     )
    (#x002a04 "N-ARY UNION OPERATOR WITH PLUS"         nil     )
    (#x002a05 "N-ARY SQUARE INTERSECTION OPERATOR"     nil     )
    (#x002a06 "N-ARY SQUARE UNION OPERATOR"            nil     )
    (#x002a07 "TWO LOGICAL AND OPERATOR"               nil     )
    (#x002a08 "TWO LOGICAL OR OPERATOR"                nil     )
    (#x002a09 "N-ARY TIMES OPERATOR"                   nil     )
    (#x002a0a "MODULO TWO SUM"                         nil     )
    (#x002a0b "SUMMATION WITH INTEGRAL"                nil     )
    (#x002a0c "QUADRUPLE INTEGRAL OPERATOR"            nil     )
    (#x002a0d "FINITE PART INTEGRAL"                   nil     )
    (#x002a0e "INTEGRAL WITH DOUBLE STROKE"            nil     )
    (#x002a0f "INTEGRAL AVERAGE WITH SLASH"            nil     )
    (#x002a10 "CIRCULATION FUNCTION"                   nil     )
    (#x002a11 "ANTICLOCKWISE INTEGRATION"              nil     )
    (#x002a12 "LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE" nil     )
    (#x002a13 "LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE" nil     )
    (#x002a14 "LINE INTEGRATION NOT INCLUDING THE POLE" nil     )
    (#x002a15 "INTEGRAL AROUND A POINT OPERATOR"       nil     )
    (#x002a16 "QUATERNION INTEGRAL OPERATOR"           nil     )
    (#x002a17 "INTEGRAL WITH LEFTWARDS ARROW WITH HOOK" nil     )
    (#x002a18 "INTEGRAL WITH TIMES SIGN"               nil     )
    (#x002a19 "INTEGRAL WITH INTERSECTION"             nil     )
    (#x002a1a "INTEGRAL WITH UNION"                    nil     )
    (#x002a1b "INTEGRAL WITH OVERBAR"                  nil     )
    (#x002a1c "INTEGRAL WITH UNDERBAR"                 nil     )
    (#x002a1d "JOIN"                                   nil     )
    (#x002a1e "LARGE LEFT TRIANGLE OPERATOR"           nil     )
    (#x002a1f "Z NOTATION SCHEMA COMPOSITION"          nil     )
    (#x002a20 "Z NOTATION SCHEMA PIPING"               nil     )
    (#x002a21 "Z NOTATION SCHEMA PROJECTION"           nil     )
    (#x002a22 "PLUS SIGN WITH SMALL CIRCLE ABOVE"      nil     )
    (#x002a23 "PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE" nil     )
    (#x002a24 "PLUS SIGN WITH TILDE ABOVE"             nil     )
    (#x002a25 "PLUS SIGN WITH DOT BELOW"               nil     )
    (#x002a26 "PLUS SIGN WITH TILDE BELOW"             nil     )
    (#x002a27 "PLUS SIGN WITH SUBSCRIPT TWO"           nil     )
    (#x002a28 "PLUS SIGN WITH BLACK TRIANGLE"          nil     )
    (#x002a29 "MINUS SIGN WITH COMMA ABOVE"            nil     )
    (#x002a2a "MINUS SIGN WITH DOT BELOW"              nil     )
    (#x002a2b "MINUS SIGN WITH FALLING DOTS"           nil     )
    (#x002a2c "MINUS SIGN WITH RISING DOTS"            nil     )
    (#x002a2d "PLUS SIGN IN LEFT HALF CIRCLE"          nil     )
    (#x002a2e "PLUS SIGN IN RIGHT HALF CIRCLE"         nil     )
    (#x002a2f "VECTOR OR CROSS PRODUCT"                nil     )
    (#x002a30 "MULTIPLICATION SIGN WITH DOT ABOVE"     nil     )
    (#x002a31 "MULTIPLICATION SIGN WITH UNDERBAR"      nil     )
    (#x002a32 "SEMIDIRECT PRODUCT WITH BOTTOM CLOSED"  nil     )
    (#x002a33 "SMASH PRODUCT"                          nil     )
    (#x002a34 "MULTIPLICATION SIGN IN LEFT HALF CIRCLE" nil     )
    (#x002a35 "MULTIPLICATION SIGN IN RIGHT HALF CIRCLE" nil     )
    (#x002a36 "CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT" nil     )
    (#x002a37 "MULTIPLICATION SIGN IN DOUBLE CIRCLE"   nil     )
    (#x002a38 "CIRCLED DIVISION SIGN"                  nil     )
    (#x002a39 "PLUS SIGN IN TRIANGLE"                  nil     )
    (#x002a3a "MINUS SIGN IN TRIANGLE"                 nil     )
    (#x002a3b "MULTIPLICATION SIGN IN TRIANGLE"        nil     )
    (#x002a3c "INTERIOR PRODUCT"                       nil     )
    (#x002a3d "RIGHTHAND INTERIOR PRODUCT"             nil     )
    (#x002a3e "Z NOTATION RELATIONAL COMPOSITION"      nil     )
    (#x002a3f "AMALGAMATION OR COPRODUCT"              "amalg" )
    (#x002a40 "INTERSECTION WITH DOT"                  nil     )
    (#x002a41 "UNION WITH MINUS SIGN"                  nil     )
    (#x002a42 "UNION WITH OVERBAR"                     nil     )
    (#x002a43 "INTERSECTION WITH OVERBAR"              nil     )
    (#x002a44 "INTERSECTION WITH LOGICAL AND"          nil     )
    (#x002a45 "UNION WITH LOGICAL OR"                  nil     )
    (#x002a46 "UNION ABOVE INTERSECTION"               nil     )
    (#x002a47 "INTERSECTION ABOVE UNION"               nil     )
    (#x002a48 "UNION ABOVE BAR ABOVE INTERSECTION"     nil     )
    (#x002a49 "INTERSECTION ABOVE BAR ABOVE UNION"     nil     )
    (#x002a4a "UNION BESIDE AND JOINED WITH UNION"     nil     )
    (#x002a4b "INTERSECTION BESIDE AND JOINED WITH INTERSECTION" nil     )
    (#x002a4c "CLOSED UNION WITH SERIFS"               nil     )
    (#x002a4d "CLOSED INTERSECTION WITH SERIFS"        nil     )
    (#x002a4e "DOUBLE SQUARE INTERSECTION"             nil     )
    (#x002a4f "DOUBLE SQUARE UNION"                    nil     )
    (#x002a50 "CLOSED UNION WITH SERIFS AND SMASH PRODUCT" nil     )
    (#x002a51 "LOGICAL AND WITH DOT ABOVE"             nil     )
    (#x002a52 "LOGICAL OR WITH DOT ABOVE"              nil     )
    (#x002a53 "DOUBLE LOGICAL AND"                     nil     )
    (#x002a54 "DOUBLE LOGICAL OR"                      nil     )
    (#x002a55 "TWO INTERSECTING LOGICAL AND"           nil     )
    (#x002a56 "TWO INTERSECTING LOGICAL OR"            nil     )
    (#x002a57 "SLOPING LARGE OR"                       nil     )
    (#x002a58 "SLOPING LARGE AND"                      nil     )
    (#x002a59 "LOGICAL OR OVERLAPPING LOGICAL AND"     nil     )
    (#x002a5a "LOGICAL AND WITH MIDDLE STEM"           nil     )
    (#x002a5b "LOGICAL OR WITH MIDDLE STEM"            nil     )
    (#x002a5c "LOGICAL AND WITH HORIZONTAL DASH"       nil     )
    (#x002a5d "LOGICAL OR WITH HORIZONTAL DASH"        nil     )
    (#x002a5e "LOGICAL AND WITH DOUBLE OVERBAR"        nil     )
    (#x002a5f "LOGICAL AND WITH UNDERBAR"              nil     )
    (#x002a60 "LOGICAL AND WITH DOUBLE UNDERBAR"       nil     )
    (#x002a61 "SMALL VEE WITH UNDERBAR"                nil     )
    (#x002a62 "LOGICAL OR WITH DOUBLE OVERBAR"         nil     )
    (#x002a63 "LOGICAL OR WITH DOUBLE UNDERBAR"        nil     )
    (#x002a64 "Z NOTATION DOMAIN ANTIRESTRICTION"      nil     )
    (#x002a65 "Z NOTATION RANGE ANTIRESTRICTION"       nil     )
    (#x002a66 "EQUALS SIGN WITH DOT BELOW"             nil     )
    (#x002a67 "IDENTICAL WITH DOT ABOVE"               nil     )
    (#x002a68 "TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE" nil     )
    (#x002a69 "TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE" nil     )
    (#x002a6a "TILDE OPERATOR WITH DOT ABOVE"          nil     )
    (#x002a6b "TILDE OPERATOR WITH RISING DOTS"        nil     )
    (#x002a6c "SIMILAR MINUS SIMILAR"                  nil     )
    (#x002a6d "CONGRUENT WITH DOT ABOVE"               nil     )
    (#x002a6e "EQUALS WITH ASTERISK"                   nil     )
    (#x002a6f "ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT" nil     )
    (#x002a70 "APPROXIMATELY EQUAL OR EQUAL TO"        nil     )
    (#x002a71 "EQUALS SIGN ABOVE PLUS SIGN"            nil     )
    (#x002a72 "PLUS SIGN ABOVE EQUALS SIGN"            nil     )
    (#x002a73 "EQUALS SIGN ABOVE TILDE OPERATOR"       nil     )
    (#x002a74 "DOUBLE COLON EQUAL"                     nil     )
    (#x002a75 "TWO CONSECUTIVE EQUALS SIGNS"           nil     )
    (#x002a76 "THREE CONSECUTIVE EQUALS SIGNS"         nil     )
    (#x002a77 "EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW" nil     )
    (#x002a78 "EQUIVALENT WITH FOUR DOTS ABOVE"        nil     )
    (#x002a79 "LESS-THAN WITH CIRCLE INSIDE"           nil     )
    (#x002a7a "GREATER-THAN WITH CIRCLE INSIDE"        nil     )
    (#x002a7b "LESS-THAN WITH QUESTION MARK ABOVE"     nil     )
    (#x002a7c "GREATER-THAN WITH QUESTION MARK ABOVE"  nil     )
    (#x002a7d "LESS-THAN OR SLANTED EQUAL TO"          "les"   )
    (#x002a7e "GREATER-THAN OR SLANTED EQUAL TO"       "ges"   )
    (#x002a7f "LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE" nil     )
    (#x002a80 "GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE" nil     )
    (#x002a81 "LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE" nil     )
    (#x002a82 "GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE" nil     )
    (#x002a83 "LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT" nil     )
    (#x002a84 "GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT" nil     )
    (#x002a85 "LESS-THAN OR APPROXIMATE"               "lap"   )
    (#x002a86 "GREATER-THAN OR APPROXIMATE"            "gap"   )
    (#x002a87 "LESS-THAN AND SINGLE-LINE NOT EQUAL TO" "lne"   )
    (#x002a88 "GREATER-THAN AND SINGLE-LINE NOT EQUAL TO" "gne"   )
    (#x002a89 "LESS-THAN AND NOT APPROXIMATE"          "lnap"  )
    (#x002a8a "GREATER-THAN AND NOT APPROXIMATE"       "gnap"  )
    (#x002a8b "LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN" "lEg"   )
    (#x002a8c "GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN" "gEl"   )
    (#x002a8d "LESS-THAN ABOVE SIMILAR OR EQUAL"       nil     )
    (#x002a8e "GREATER-THAN ABOVE SIMILAR OR EQUAL"    nil     )
    (#x002a8f "LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN" nil     )
    (#x002a90 "GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN" nil     )
    (#x002a91 "LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL" nil     )
    (#x002a92 "GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL" nil     )
    (#x002a93 "LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL" nil     )
    (#x002a94 "GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL" nil     )
    (#x002a95 "SLANTED EQUAL TO OR LESS-THAN"          "els"   )
    (#x002a96 "SLANTED EQUAL TO OR GREATER-THAN"       "egs"   )
    (#x002a97 "SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE" nil     )
    (#x002a98 "SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE" nil     )
    (#x002a99 "DOUBLE-LINE EQUAL TO OR LESS-THAN"      nil     )
    (#x002a9a "DOUBLE-LINE EQUAL TO OR GREATER-THAN"   nil     )
    (#x002a9b "DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN" nil     )
    (#x002a9c "DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN" nil     )
    (#x002a9d "SIMILAR OR LESS-THAN"                   nil     )
    (#x002a9e "SIMILAR OR GREATER-THAN"                nil     )
    (#x002a9f "SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN" nil     )
    (#x002aa0 "SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN" nil     )
    (#x002aa1 "DOUBLE NESTED LESS-THAN"                nil     )
    (#x002aa2 "DOUBLE NESTED GREATER-THAN"             nil     )
    (#x002aa3 "DOUBLE NESTED LESS-THAN WITH UNDERBAR"  nil     )
    (#x002aa4 "GREATER-THAN OVERLAPPING LESS-THAN"     nil     )
    (#x002aa5 "GREATER-THAN BESIDE LESS-THAN"          nil     )
    (#x002aa6 "LESS-THAN CLOSED BY CURVE"              nil     )
    (#x002aa7 "GREATER-THAN CLOSED BY CURVE"           nil     )
    (#x002aa8 "LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL" nil     )
    (#x002aa9 "GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL" nil     )
    (#x002aaa "SMALLER THAN"                           nil     )
    (#x002aab "LARGER THAN"                            nil     )
    (#x002aac "SMALLER THAN OR EQUAL TO"               nil     )
    (#x002aad "LARGER THAN OR EQUAL TO"                nil     )
    (#x002aae "EQUALS SIGN WITH BUMPY ABOVE"           nil     )
    (#x002aaf "PRECEDES ABOVE SINGLE-LINE EQUALS SIGN" "pre"   )
    (#x002ab0 "SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN" "sce"   )
    (#x002ab1 "PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO" nil     )
    (#x002ab2 "SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO" nil     )
    (#x002ab3 "PRECEDES ABOVE EQUALS SIGN"             nil     )
    (#x002ab4 "SUCCEEDS ABOVE EQUALS SIGN"             nil     )
    (#x002ab5 "PRECEDES ABOVE NOT EQUAL TO"            "prnE"  )
    (#x002ab6 "SUCCEEDS ABOVE NOT EQUAL TO"            "scnE"  )
    (#x002ab7 "PRECEDES ABOVE ALMOST EQUAL TO"         "prap"  )
    (#x002ab8 "SUCCEEDS ABOVE ALMOST EQUAL TO"         "scap"  )
    (#x002ab9 "PRECEDES ABOVE NOT ALMOST EQUAL TO"     "prnap" )
    (#x002aba "SUCCEEDS ABOVE NOT ALMOST EQUAL TO"     "scnap" )
    (#x002abb "DOUBLE PRECEDES"                        nil     )
    (#x002abc "DOUBLE SUCCEEDS"                        nil     )
    (#x002abd "SUBSET WITH DOT"                        nil     )
    (#x002abe "SUPERSET WITH DOT"                      nil     )
    (#x002abf "SUBSET WITH PLUS SIGN BELOW"            nil     )
    (#x002ac0 "SUPERSET WITH PLUS SIGN BELOW"          nil     )
    (#x002ac1 "SUBSET WITH MULTIPLICATION SIGN BELOW"  nil     )
    (#x002ac2 "SUPERSET WITH MULTIPLICATION SIGN BELOW" nil     )
    (#x002ac3 "SUBSET OF OR EQUAL TO WITH DOT ABOVE"   nil     )
    (#x002ac4 "SUPERSET OF OR EQUAL TO WITH DOT ABOVE" nil     )
    (#x002ac5 "SUBSET OF ABOVE EQUALS SIGN"            "subE"  )
    (#x002ac6 "SUPERSET OF ABOVE EQUALS SIGN"          "supE"  )
    (#x002ac7 "SUBSET OF ABOVE TILDE OPERATOR"         nil     )
    (#x002ac8 "SUPERSET OF ABOVE TILDE OPERATOR"       nil     )
    (#x002ac9 "SUBSET OF ABOVE ALMOST EQUAL TO"        nil     )
    (#x002aca "SUPERSET OF ABOVE ALMOST EQUAL TO"      nil     )
    (#x002acb "SUBSET OF ABOVE NOT EQUAL TO"           "subnE" )
    (#x002acc "SUPERSET OF ABOVE NOT EQUAL TO"         "supnE" )
    (#x002acd "SQUARE LEFT OPEN BOX OPERATOR"          nil     )
    (#x002ace "SQUARE RIGHT OPEN BOX OPERATOR"         nil     )
    (#x002acf "CLOSED SUBSET"                          nil     )
    (#x002ad0 "CLOSED SUPERSET"                        nil     )
    (#x002ad1 "CLOSED SUBSET OR EQUAL TO"              nil     )
    (#x002ad2 "CLOSED SUPERSET OR EQUAL TO"            nil     )
    (#x002ad3 "SUBSET ABOVE SUPERSET"                  nil     )
    (#x002ad4 "SUPERSET ABOVE SUBSET"                  nil     )
    (#x002ad5 "SUBSET ABOVE SUBSET"                    nil     )
    (#x002ad6 "SUPERSET ABOVE SUPERSET"                nil     )
    (#x002ad7 "SUPERSET BESIDE SUBSET"                 nil     )
    (#x002ad8 "SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET" nil     )
    (#x002ad9 "ELEMENT OF OPENING DOWNWARDS"           nil     )
    (#x002ada "PITCHFORK WITH TEE TOP"                 nil     )
    (#x002adb "TRANSVERSAL INTERSECTION"               nil     )
    (#x002adc "FORKING"                                nil     )
    (#x002add "NONFORKING"                             nil     )
    (#x002ade "SHORT LEFT TACK"                        nil     )
    (#x002adf "SHORT DOWN TACK"                        nil     )
    (#x002ae0 "SHORT UP TACK"                          nil     )
    (#x002ae1 "PERPENDICULAR WITH S"                   nil     )
    (#x002ae2 "VERTICAL BAR TRIPLE RIGHT TURNSTILE"    nil     )
    (#x002ae3 "DOUBLE VERTICAL BAR LEFT TURNSTILE"     nil     )
    (#x002ae4 "VERTICAL BAR DOUBLE LEFT TURNSTILE"     nil     )
    (#x002ae5 "DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE" nil     )
    (#x002ae6 "LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL" nil     )
    (#x002ae7 "SHORT DOWN TACK WITH OVERBAR"           nil     )
    (#x002ae8 "SHORT UP TACK WITH UNDERBAR"            nil     )
    (#x002ae9 "SHORT UP TACK ABOVE SHORT DOWN TACK"    nil     )
    (#x002aea "DOUBLE DOWN TACK"                       nil     )
    (#x002aeb "DOUBLE UP TACK"                         nil     )
    (#x002aec "DOUBLE STROKE NOT SIGN"                 nil     )
    (#x002aed "REVERSED DOUBLE STROKE NOT SIGN"        nil     )
    (#x002aee "DOES NOT DIVIDE WITH REVERSED NEGATION SLASH" nil     )
    (#x002aef "VERTICAL LINE WITH CIRCLE ABOVE"        nil     )
    (#x002af0 "VERTICAL LINE WITH CIRCLE BELOW"        nil     )
    (#x002af1 "DOWN TACK WITH CIRCLE BELOW"            nil     )
    (#x002af2 "PARALLEL WITH HORIZONTAL STROKE"        nil     )
    (#x002af3 "PARALLEL WITH TILDE OPERATOR"           nil     )
    (#x002af4 "TRIPLE VERTICAL BAR BINARY RELATION"    nil     )
    (#x002af5 "TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE" nil     )
    (#x002af6 "TRIPLE COLON OPERATOR"                  nil     )
    (#x002af7 "TRIPLE NESTED LESS-THAN"                nil     )
    (#x002af8 "TRIPLE NESTED GREATER-THAN"             nil     )
    (#x002af9 "DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO" nil     )
    (#x002afa "DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO" nil     )
    (#x002afb "TRIPLE SOLIDUS BINARY RELATION"         nil     )
    (#x002afc "LARGE TRIPLE VERTICAL BAR OPERATOR"     nil     )
    (#x002afd "DOUBLE SOLIDUS OPERATOR"                nil     )
    (#x002afe "WHITE VERTICAL BAR"                     nil     )
    (#x002aff "N-ARY WHITE VERTICAL BAR"               nil     )
    (#x002b00 "NORTH EAST WHITE ARROW"                 nil     )
    (#x002b01 "NORTH WEST WHITE ARROW"                 nil     )
    (#x002b02 "SOUTH EAST WHITE ARROW"                 nil     )
    (#x002b03 "SOUTH WEST WHITE ARROW"                 nil     )
    (#x002b04 "LEFT RIGHT WHITE ARROW"                 nil     )
    (#x002b05 "LEFTWARDS BLACK ARROW"                  nil     )
    (#x002b06 "UPWARDS BLACK ARROW"                    nil     )
    (#x002b07 "DOWNWARDS BLACK ARROW"                  nil     )
    (#x002b08 "NORTH EAST BLACK ARROW"                 nil     )
    (#x002b09 "NORTH WEST BLACK ARROW"                 nil     )
    (#x002b0a "SOUTH EAST BLACK ARROW"                 nil     )
    (#x002b0b "SOUTH WEST BLACK ARROW"                 nil     )
    (#x002b0c "LEFT RIGHT BLACK ARROW"                 nil     )
    (#x002b0d "UP DOWN BLACK ARROW"                    nil     )
    (#x002b0e "RIGHTWARDS ARROW WITH TIP DOWNWARDS"    nil     )
    (#x002b0f "RIGHTWARDS ARROW WITH TIP UPWARDS"      nil     )
    (#x002b10 "LEFTWARDS ARROW WITH TIP DOWNWARDS"     nil     )
    (#x002b11 "LEFTWARDS ARROW WITH TIP UPWARDS"       nil     )
    (#x002b12 "SQUARE WITH TOP HALF BLACK"             nil     )
    (#x002b13 "SQUARE WITH BOTTOM HALF BLACK"          nil     )
    (#x002b14 "SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK" nil     )
    (#x002b15 "SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK" nil     )
    (#x002b16 "DIAMOND WITH LEFT HALF BLACK"           nil     )
    (#x002b17 "DIAMOND WITH RIGHT HALF BLACK"          nil     )
    (#x002b18 "DIAMOND WITH TOP HALF BLACK"            nil     )
    (#x002b19 "DIAMOND WITH BOTTOM HALF BLACK"         nil     )
    (#x002b1a "DOTTED SQUARE"                          nil     )
    (#x002b1b "BLACK LARGE SQUARE"                     nil     )
    (#x002b1c "WHITE LARGE SQUARE"                     nil     )
    (#x002b1d "BLACK VERY SMALL SQUARE"                nil     )
    (#x002b1e "WHITE VERY SMALL SQUARE"                nil     )
    (#x002b1f "BLACK PENTAGON"                         nil     )
    (#x002b20 "WHITE PENTAGON"                         nil     )
    (#x002b21 "WHITE HEXAGON"                          nil     )
    (#x002b22 "BLACK HEXAGON"                          nil     )
    (#x002b23 "HORIZONTAL BLACK HEXAGON"               nil     )
    (#x002b24 "BLACK LARGE CIRCLE"                     nil     )
    (#x002b25 "BLACK MEDIUM DIAMOND"                   nil     )
    (#x002b26 "WHITE MEDIUM DIAMOND"                   nil     )
    (#x002b27 "BLACK MEDIUM LOZENGE"                   nil     )
    (#x002b28 "WHITE MEDIUM LOZENGE"                   nil     )
    (#x002b29 "BLACK SMALL DIAMOND"                    nil     )
    (#x002b2a "BLACK SMALL LOZENGE"                    nil     )
    (#x002b2b "WHITE SMALL LOZENGE"                    nil     )
    (#x002b2c "BLACK HORIZONTAL ELLIPSE"               nil     )
    (#x002b2d "WHITE HORIZONTAL ELLIPSE"               nil     )
    (#x002b2e "BLACK VERTICAL ELLIPSE"                 nil     )
    (#x002b2f "WHITE VERTICAL ELLIPSE"                 nil     )
    (#x002b30 "LEFT ARROW WITH SMALL CIRCLE"           nil     )
    (#x002b31 "THREE LEFTWARDS ARROWS"                 nil     )
    (#x002b32 "LEFT ARROW WITH CIRCLED PLUS"           nil     )
    (#x002b33 "LONG LEFTWARDS SQUIGGLE ARROW"          nil     )
    (#x002b34 "LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE" nil     )
    (#x002b35 "LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE" nil     )
    (#x002b36 "LEFTWARDS TWO-HEADED ARROW FROM BAR"    nil     )
    (#x002b37 "LEFTWARDS TWO-HEADED TRIPLE DASH ARROW" nil     )
    (#x002b38 "LEFTWARDS ARROW WITH DOTTED STEM"       nil     )
    (#x002b39 "LEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKE" nil     )
    (#x002b3a "LEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" nil     )
    (#x002b3b "LEFTWARDS TWO-HEADED ARROW WITH TAIL"   nil     )
    (#x002b3c "LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE" nil     )
    (#x002b3d "LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" nil     )
    (#x002b3e "LEFTWARDS ARROW THROUGH X"              nil     )
    (#x002b3f "WAVE ARROW POINTING DIRECTLY LEFT"      nil     )
    (#x002b40 "EQUALS SIGN ABOVE LEFTWARDS ARROW"      nil     )
    (#x002b41 "REVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROW" nil     )
    (#x002b42 "LEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO" nil     )
    (#x002b43 "RIGHTWARDS ARROW THROUGH GREATER-THAN"  nil     )
    (#x002b44 "RIGHTWARDS ARROW THROUGH SUPERSET"      nil     )
    (#x002b45 "LEFTWARDS QUADRUPLE ARROW"              nil     )
    (#x002b46 "RIGHTWARDS QUADRUPLE ARROW"             nil     )
    (#x002b47 "REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW" nil     )
    (#x002b48 "RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO" nil     )
    (#x002b49 "TILDE OPERATOR ABOVE LEFTWARDS ARROW"   nil     )
    (#x002b4a "LEFTWARDS ARROW ABOVE ALMOST EQUAL TO"  nil     )
    (#x002b4b "LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR" nil     )
    (#x002b4c "RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR" nil     )
    (#x002b4d "DOWNWARDS TRIANGLE-HEADED ZIGZAG ARROW" nil     )
    (#x002b4e "SHORT SLANTED NORTH ARROW"              nil     )
    (#x002b4f "SHORT BACKSLANTED SOUTH ARROW"          nil     )
    (#x002b50 "WHITE MEDIUM STAR"                      nil     )
    (#x002b51 "BLACK SMALL STAR"                       nil     )
    (#x002b52 "WHITE SMALL STAR"                       nil     )
    (#x002b53 "BLACK RIGHT-POINTING PENTAGON"          nil     )
    (#x002b54 "WHITE RIGHT-POINTING PENTAGON"          nil     )
    (#x002b55 "HEAVY LARGE CIRCLE"                     nil     )
    (#x002b56 "HEAVY OVAL WITH OVAL INSIDE"            nil     )
    (#x002b57 "HEAVY CIRCLE WITH CIRCLE INSIDE"        nil     )
    (#x002b58 "HEAVY CIRCLE"                           nil     )
    (#x002b59 "HEAVY CIRCLED SALTIRE"                  nil     )
    (#x002b5a "SLANTED NORTH ARROW WITH HOOKED HEAD"   nil     )
    (#x002b5b "BACKSLANTED SOUTH ARROW WITH HOOKED TAIL" nil     )
    (#x002b5c "SLANTED NORTH ARROW WITH HORIZONTAL TAIL" nil     )
    (#x002b5d "BACKSLANTED SOUTH ARROW WITH HORIZONTAL TAIL" nil     )
    (#x002b5e "BENT ARROW POINTING DOWNWARDS THEN NORTH EAST" nil     )
    (#x002b5f "SHORT BENT ARROW POINTING DOWNWARDS THEN NORTH EAST" nil     )
    (#x002b60 "LEFTWARDS TRIANGLE-HEADED ARROW"        nil     )
    (#x002b61 "UPWARDS TRIANGLE-HEADED ARROW"          nil     )
    (#x002b62 "RIGHTWARDS TRIANGLE-HEADED ARROW"       nil     )
    (#x002b63 "DOWNWARDS TRIANGLE-HEADED ARROW"        nil     )
    (#x002b64 "LEFT RIGHT TRIANGLE-HEADED ARROW"       nil     )
    (#x002b65 "UP DOWN TRIANGLE-HEADED ARROW"          nil     )
    (#x002b66 "NORTH WEST TRIANGLE-HEADED ARROW"       nil     )
    (#x002b67 "NORTH EAST TRIANGLE-HEADED ARROW"       nil     )
    (#x002b68 "SOUTH EAST TRIANGLE-HEADED ARROW"       nil     )
    (#x002b69 "SOUTH WEST TRIANGLE-HEADED ARROW"       nil     )
    (#x002b6a "LEFTWARDS TRIANGLE-HEADED DASHED ARROW" nil     )
    (#x002b6b "UPWARDS TRIANGLE-HEADED DASHED ARROW"   nil     )
    (#x002b6c "RIGHTWARDS TRIANGLE-HEADED DASHED ARROW" nil     )
    (#x002b6d "DOWNWARDS TRIANGLE-HEADED DASHED ARROW" nil     )
    (#x002b6e "CLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW" nil     )
    (#x002b6f "ANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW" nil     )
    (#x002b70 "LEFTWARDS TRIANGLE-HEADED ARROW TO BAR" nil     )
    (#x002b71 "UPWARDS TRIANGLE-HEADED ARROW TO BAR"   nil     )
    (#x002b72 "RIGHTWARDS TRIANGLE-HEADED ARROW TO BAR" nil     )
    (#x002b73 "DOWNWARDS TRIANGLE-HEADED ARROW TO BAR" nil     )
    (#x002b76 "NORTH WEST TRIANGLE-HEADED ARROW TO BAR" nil     )
    (#x002b77 "NORTH EAST TRIANGLE-HEADED ARROW TO BAR" nil     )
    (#x002b78 "SOUTH EAST TRIANGLE-HEADED ARROW TO BAR" nil     )
    (#x002b79 "SOUTH WEST TRIANGLE-HEADED ARROW TO BAR" nil     )
    (#x002b7a "LEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE" nil     )
    (#x002b7b "UPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE" nil     )
    (#x002b7c "RIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE" nil     )
    (#x002b7d "DOWNWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE" nil     )
    (#x002b7e "HORIZONTAL TAB KEY"                     nil     )
    (#x002b7f "VERTICAL TAB KEY"                       nil     )
    (#x002b80 "LEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HEADED ARROW" nil     )
    (#x002b81 "UPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW" nil     )
    (#x002b82 "RIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEADED ARROW" nil     )
    (#x002b83 "DOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW" nil     )
    (#x002b84 "LEFTWARDS TRIANGLE-HEADED PAIRED ARROWS" nil     )
    (#x002b85 "UPWARDS TRIANGLE-HEADED PAIRED ARROWS"  nil     )
    (#x002b86 "RIGHTWARDS TRIANGLE-HEADED PAIRED ARROWS" nil     )
    (#x002b87 "DOWNWARDS TRIANGLE-HEADED PAIRED ARROWS" nil     )
    (#x002b88 "LEFTWARDS BLACK CIRCLED WHITE ARROW"    nil     )
    (#x002b89 "UPWARDS BLACK CIRCLED WHITE ARROW"      nil     )
    (#x002b8a "RIGHTWARDS BLACK CIRCLED WHITE ARROW"   nil     )
    (#x002b8b "DOWNWARDS BLACK CIRCLED WHITE ARROW"    nil     )
    (#x002b8c "ANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROW" nil     )
    (#x002b8d "ANTICLOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROW" nil     )
    (#x002b8e "ANTICLOCKWISE TRIANGLE-HEADED LEFT U-SHAPED ARROW" nil     )
    (#x002b8f "ANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROW" nil     )
    (#x002b90 "RETURN LEFT"                            nil     )
    (#x002b91 "RETURN RIGHT"                           nil     )
    (#x002b92 "NEWLINE LEFT"                           nil     )
    (#x002b93 "NEWLINE RIGHT"                          nil     )
    (#x002b94 "FOUR CORNER ARROWS CIRCLING ANTICLOCKWISE" nil     )
    (#x002b95 "RIGHTWARDS BLACK ARROW"                 nil     )
    (#x002b97 "SYMBOL FOR TYPE A ELECTRONICS"          nil     )
    (#x002b98 "THREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEAD" nil     )
    (#x002b99 "THREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD" nil     )
    (#x002b9a "THREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEAD" nil     )
    (#x002b9b "THREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD" nil     )
    (#x002b9c "BLACK LEFTWARDS EQUILATERAL ARROWHEAD"  nil     )
    (#x002b9d "BLACK UPWARDS EQUILATERAL ARROWHEAD"    nil     )
    (#x002b9e "BLACK RIGHTWARDS EQUILATERAL ARROWHEAD" nil     )
    (#x002b9f "BLACK DOWNWARDS EQUILATERAL ARROWHEAD"  nil     )
    (#x002ba0 "DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS" nil     )
    (#x002ba1 "DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS" nil     )
    (#x002ba2 "UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS" nil     )
    (#x002ba3 "UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS" nil     )
    (#x002ba4 "LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS" nil     )
    (#x002ba5 "RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS" nil     )
    (#x002ba6 "LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS" nil     )
    (#x002ba7 "RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS" nil     )
    (#x002ba8 "BLACK CURVED DOWNWARDS AND LEFTWARDS ARROW" nil     )
    (#x002ba9 "BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW" nil     )
    (#x002baa "BLACK CURVED UPWARDS AND LEFTWARDS ARROW" nil     )
    (#x002bab "BLACK CURVED UPWARDS AND RIGHTWARDS ARROW" nil     )
    (#x002bac "BLACK CURVED LEFTWARDS AND UPWARDS ARROW" nil     )
    (#x002bad "BLACK CURVED RIGHTWARDS AND UPWARDS ARROW" nil     )
    (#x002bae "BLACK CURVED LEFTWARDS AND DOWNWARDS ARROW" nil     )
    (#x002baf "BLACK CURVED RIGHTWARDS AND DOWNWARDS ARROW" nil     )
    (#x002bb0 "RIBBON ARROW DOWN LEFT"                 nil     )
    (#x002bb1 "RIBBON ARROW DOWN RIGHT"                nil     )
    (#x002bb2 "RIBBON ARROW UP LEFT"                   nil     )
    (#x002bb3 "RIBBON ARROW UP RIGHT"                  nil     )
    (#x002bb4 "RIBBON ARROW LEFT UP"                   nil     )
    (#x002bb5 "RIBBON ARROW RIGHT UP"                  nil     )
    (#x002bb6 "RIBBON ARROW LEFT DOWN"                 nil     )
    (#x002bb7 "RIBBON ARROW RIGHT DOWN"                nil     )
    (#x002bb8 "UPWARDS WHITE ARROW FROM BAR WITH HORIZONTAL BAR" nil     )
    (#x002bb9 "UP ARROWHEAD IN A RECTANGLE BOX"        nil     )
    (#x002bba "OVERLAPPING WHITE SQUARES"              nil     )
    (#x002bbb "OVERLAPPING WHITE AND BLACK SQUARES"    nil     )
    (#x002bbc "OVERLAPPING BLACK SQUARES"              nil     )
    (#x002bbd "BALLOT BOX WITH LIGHT X"                nil     )
    (#x002bbe "CIRCLED X"                              nil     )
    (#x002bbf "CIRCLED BOLD X"                         nil     )
    (#x002bc0 "BLACK SQUARE CENTRED"                   nil     )
    (#x002bc1 "BLACK DIAMOND CENTRED"                  nil     )
    (#x002bc2 "TURNED BLACK PENTAGON"                  nil     )
    (#x002bc3 "HORIZONTAL BLACK OCTAGON"               nil     )
    (#x002bc4 "BLACK OCTAGON"                          nil     )
    (#x002bc5 "BLACK MEDIUM UP-POINTING TRIANGLE CENTRED" nil     )
    (#x002bc6 "BLACK MEDIUM DOWN-POINTING TRIANGLE CENTRED" nil     )
    (#x002bc7 "BLACK MEDIUM LEFT-POINTING TRIANGLE CENTRED" nil     )
    (#x002bc8 "BLACK MEDIUM RIGHT-POINTING TRIANGLE CENTRED" nil     )
    (#x002bc9 "NEPTUNE FORM TWO"                       nil     )
    (#x002bca "TOP HALF BLACK CIRCLE"                  nil     )
    (#x002bcb "BOTTOM HALF BLACK CIRCLE"               nil     )
    (#x002bcc "LIGHT FOUR POINTED BLACK CUSP"          nil     )
    (#x002bcd "ROTATED LIGHT FOUR POINTED BLACK CUSP"  nil     )
    (#x002bce "WHITE FOUR POINTED CUSP"                nil     )
    (#x002bcf "ROTATED WHITE FOUR POINTED CUSP"        nil     )
    (#x002bd0 "SQUARE POSITION INDICATOR"              nil     )
    (#x002bd1 "UNCERTAINTY SIGN"                       nil     )
    (#x002bd2 "GROUP MARK"                             nil     )
    (#x002bd3 "PLUTO FORM TWO"                         nil     )
    (#x002bd4 "PLUTO FORM THREE"                       nil     )
    (#x002bd5 "PLUTO FORM FOUR"                        nil     )
    (#x002bd6 "PLUTO FORM FIVE"                        nil     )
    (#x002bd7 "TRANSPLUTO"                             nil     )
    (#x002bd8 "PROSERPINA"                             nil     )
    (#x002bd9 "ASTRAEA"                                nil     )
    (#x002bda "HYGIEA"                                 nil     )
    (#x002bdb "PHOLUS"                                 nil     )
    (#x002bdc "NESSUS"                                 nil     )
    (#x002bdd "WHITE MOON SELENA"                      nil     )
    (#x002bde "BLACK DIAMOND ON CROSS"                 nil     )
    (#x002bdf "TRUE LIGHT MOON ARTA"                   nil     )
    (#x002be0 "CUPIDO"                                 nil     )
    (#x002be1 "HADES"                                  nil     )
    (#x002be2 "ZEUS"                                   nil     )
    (#x002be3 "KRONOS"                                 nil     )
    (#x002be4 "APOLLON"                                nil     )
    (#x002be5 "ADMETOS"                                nil     )
    (#x002be6 "VULCANUS"                               nil     )
    (#x002be7 "POSEIDON"                               nil     )
    (#x002be8 "LEFT HALF BLACK STAR"                   nil     )
    (#x002be9 "RIGHT HALF BLACK STAR"                  nil     )
    (#x002bea "STAR WITH LEFT HALF BLACK"              nil     )
    (#x002beb "STAR WITH RIGHT HALF BLACK"             nil     )
    (#x002bec "LEFTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS" nil     )
    (#x002bed "UPWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS" nil     )
    (#x002bee "RIGHTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS" nil     )
    (#x002bef "DOWNWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS" nil     )
    (#x002bf0 "ERIS FORM ONE"                          nil     )
    (#x002bf1 "ERIS FORM TWO"                          nil     )
    (#x002bf2 "SEDNA"                                  nil     )
    (#x002bf3 "RUSSIAN ASTROLOGICAL SYMBOL VIGINTILE"  nil     )
    (#x002bf4 "RUSSIAN ASTROLOGICAL SYMBOL NOVILE"     nil     )
    (#x002bf5 "RUSSIAN ASTROLOGICAL SYMBOL QUINTILE"   nil     )
    (#x002bf6 "RUSSIAN ASTROLOGICAL SYMBOL BINOVILE"   nil     )
    (#x002bf7 "RUSSIAN ASTROLOGICAL SYMBOL SENTAGON"   nil     )
    (#x002bf8 "RUSSIAN ASTROLOGICAL SYMBOL TREDECILE"  nil     )
    (#x002bf9 "EQUALS SIGN WITH INFINITY BELOW"        nil     )
    (#x002bfa "UNITED SYMBOL"                          nil     )
    (#x002bfb "SEPARATED SYMBOL"                       nil     )
    (#x002bfc "DOUBLED SYMBOL"                         nil     )
    (#x002bfd "PASSED SYMBOL"                          nil     )
    (#x002bfe "REVERSED RIGHT ANGLE"                   nil     )
    (#x002bff "HELLSCHREIBER PAUSE SYMBOL"             nil     )
    (#x002c00 "GLAGOLITIC CAPITAL LETTER AZU"          nil     )
    (#x002c01 "GLAGOLITIC CAPITAL LETTER BUKY"         nil     )
    (#x002c02 "GLAGOLITIC CAPITAL LETTER VEDE"         nil     )
    (#x002c03 "GLAGOLITIC CAPITAL LETTER GLAGOLI"      nil     )
    (#x002c04 "GLAGOLITIC CAPITAL LETTER DOBRO"        nil     )
    (#x002c05 "GLAGOLITIC CAPITAL LETTER YESTU"        nil     )
    (#x002c06 "GLAGOLITIC CAPITAL LETTER ZHIVETE"      nil     )
    (#x002c07 "GLAGOLITIC CAPITAL LETTER DZELO"        nil     )
    (#x002c08 "GLAGOLITIC CAPITAL LETTER ZEMLJA"       nil     )
    (#x002c09 "GLAGOLITIC CAPITAL LETTER IZHE"         nil     )
    (#x002c0a "GLAGOLITIC CAPITAL LETTER INITIAL IZHE" nil     )
    (#x002c0b "GLAGOLITIC CAPITAL LETTER I"            nil     )
    (#x002c0c "GLAGOLITIC CAPITAL LETTER DJERVI"       nil     )
    (#x002c0d "GLAGOLITIC CAPITAL LETTER KAKO"         nil     )
    (#x002c0e "GLAGOLITIC CAPITAL LETTER LJUDIJE"      nil     )
    (#x002c0f "GLAGOLITIC CAPITAL LETTER MYSLITE"      nil     )
    (#x002c10 "GLAGOLITIC CAPITAL LETTER NASHI"        nil     )
    (#x002c11 "GLAGOLITIC CAPITAL LETTER ONU"          nil     )
    (#x002c12 "GLAGOLITIC CAPITAL LETTER POKOJI"       nil     )
    (#x002c13 "GLAGOLITIC CAPITAL LETTER RITSI"        nil     )
    (#x002c14 "GLAGOLITIC CAPITAL LETTER SLOVO"        nil     )
    (#x002c15 "GLAGOLITIC CAPITAL LETTER TVRIDO"       nil     )
    (#x002c16 "GLAGOLITIC CAPITAL LETTER UKU"          nil     )
    (#x002c17 "GLAGOLITIC CAPITAL LETTER FRITU"        nil     )
    (#x002c18 "GLAGOLITIC CAPITAL LETTER HERU"         nil     )
    (#x002c19 "GLAGOLITIC CAPITAL LETTER OTU"          nil     )
    (#x002c1a "GLAGOLITIC CAPITAL LETTER PE"           nil     )
    (#x002c1b "GLAGOLITIC CAPITAL LETTER SHTA"         nil     )
    (#x002c1c "GLAGOLITIC CAPITAL LETTER TSI"          nil     )
    (#x002c1d "GLAGOLITIC CAPITAL LETTER CHRIVI"       nil     )
    (#x002c1e "GLAGOLITIC CAPITAL LETTER SHA"          nil     )
    (#x002c1f "GLAGOLITIC CAPITAL LETTER YERU"         nil     )
    (#x002c20 "GLAGOLITIC CAPITAL LETTER YERI"         nil     )
    (#x002c21 "GLAGOLITIC CAPITAL LETTER YATI"         nil     )
    (#x002c22 "GLAGOLITIC CAPITAL LETTER SPIDERY HA"   nil     )
    (#x002c23 "GLAGOLITIC CAPITAL LETTER YU"           nil     )
    (#x002c24 "GLAGOLITIC CAPITAL LETTER SMALL YUS"    nil     )
    (#x002c25 "GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL" nil     )
    (#x002c26 "GLAGOLITIC CAPITAL LETTER YO"           nil     )
    (#x002c27 "GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS" nil     )
    (#x002c28 "GLAGOLITIC CAPITAL LETTER BIG YUS"      nil     )
    (#x002c29 "GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS" nil     )
    (#x002c2a "GLAGOLITIC CAPITAL LETTER FITA"         nil     )
    (#x002c2b "GLAGOLITIC CAPITAL LETTER IZHITSA"      nil     )
    (#x002c2c "GLAGOLITIC CAPITAL LETTER SHTAPIC"      nil     )
    (#x002c2d "GLAGOLITIC CAPITAL LETTER TROKUTASTI A" nil     )
    (#x002c2e "GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE" nil     )
    (#x002c2f "GLAGOLITIC CAPITAL LETTER CAUDATE CHRIVI" nil     )
    (#x002c30 "GLAGOLITIC SMALL LETTER AZU"            nil     )
    (#x002c31 "GLAGOLITIC SMALL LETTER BUKY"           nil     )
    (#x002c32 "GLAGOLITIC SMALL LETTER VEDE"           nil     )
    (#x002c33 "GLAGOLITIC SMALL LETTER GLAGOLI"        nil     )
    (#x002c34 "GLAGOLITIC SMALL LETTER DOBRO"          nil     )
    (#x002c35 "GLAGOLITIC SMALL LETTER YESTU"          nil     )
    (#x002c36 "GLAGOLITIC SMALL LETTER ZHIVETE"        nil     )
    (#x002c37 "GLAGOLITIC SMALL LETTER DZELO"          nil     )
    (#x002c38 "GLAGOLITIC SMALL LETTER ZEMLJA"         nil     )
    (#x002c39 "GLAGOLITIC SMALL LETTER IZHE"           nil     )
    (#x002c3a "GLAGOLITIC SMALL LETTER INITIAL IZHE"   nil     )
    (#x002c3b "GLAGOLITIC SMALL LETTER I"              nil     )
    (#x002c3c "GLAGOLITIC SMALL LETTER DJERVI"         nil     )
    (#x002c3d "GLAGOLITIC SMALL LETTER KAKO"           nil     )
    (#x002c3e "GLAGOLITIC SMALL LETTER LJUDIJE"        nil     )
    (#x002c3f "GLAGOLITIC SMALL LETTER MYSLITE"        nil     )
    (#x002c40 "GLAGOLITIC SMALL LETTER NASHI"          nil     )
    (#x002c41 "GLAGOLITIC SMALL LETTER ONU"            nil     )
    (#x002c42 "GLAGOLITIC SMALL LETTER POKOJI"         nil     )
    (#x002c43 "GLAGOLITIC SMALL LETTER RITSI"          nil     )
    (#x002c44 "GLAGOLITIC SMALL LETTER SLOVO"          nil     )
    (#x002c45 "GLAGOLITIC SMALL LETTER TVRIDO"         nil     )
    (#x002c46 "GLAGOLITIC SMALL LETTER UKU"            nil     )
    (#x002c47 "GLAGOLITIC SMALL LETTER FRITU"          nil     )
    (#x002c48 "GLAGOLITIC SMALL LETTER HERU"           nil     )
    (#x002c49 "GLAGOLITIC SMALL LETTER OTU"            nil     )
    (#x002c4a "GLAGOLITIC SMALL LETTER PE"             nil     )
    (#x002c4b "GLAGOLITIC SMALL LETTER SHTA"           nil     )
    (#x002c4c "GLAGOLITIC SMALL LETTER TSI"            nil     )
    (#x002c4d "GLAGOLITIC SMALL LETTER CHRIVI"         nil     )
    (#x002c4e "GLAGOLITIC SMALL LETTER SHA"            nil     )
    (#x002c4f "GLAGOLITIC SMALL LETTER YERU"           nil     )
    (#x002c50 "GLAGOLITIC SMALL LETTER YERI"           nil     )
    (#x002c51 "GLAGOLITIC SMALL LETTER YATI"           nil     )
    (#x002c52 "GLAGOLITIC SMALL LETTER SPIDERY HA"     nil     )
    (#x002c53 "GLAGOLITIC SMALL LETTER YU"             nil     )
    (#x002c54 "GLAGOLITIC SMALL LETTER SMALL YUS"      nil     )
    (#x002c55 "GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL" nil     )
    (#x002c56 "GLAGOLITIC SMALL LETTER YO"             nil     )
    (#x002c57 "GLAGOLITIC SMALL LETTER IOTATED SMALL YUS" nil     )
    (#x002c58 "GLAGOLITIC SMALL LETTER BIG YUS"        nil     )
    (#x002c59 "GLAGOLITIC SMALL LETTER IOTATED BIG YUS" nil     )
    (#x002c5a "GLAGOLITIC SMALL LETTER FITA"           nil     )
    (#x002c5b "GLAGOLITIC SMALL LETTER IZHITSA"        nil     )
    (#x002c5c "GLAGOLITIC SMALL LETTER SHTAPIC"        nil     )
    (#x002c5d "GLAGOLITIC SMALL LETTER TROKUTASTI A"   nil     )
    (#x002c5e "GLAGOLITIC SMALL LETTER LATINATE MYSLITE" nil     )
    (#x002c5f "GLAGOLITIC SMALL LETTER CAUDATE CHRIVI" nil     )
    (#x002c60 "LATIN CAPITAL LETTER L WITH DOUBLE BAR" nil     )
    (#x002c61 "LATIN SMALL LETTER L WITH DOUBLE BAR"   nil     )
    (#x002c62 "LATIN CAPITAL LETTER L WITH MIDDLE TILDE" nil     )
    (#x002c63 "LATIN CAPITAL LETTER P WITH STROKE"     nil     )
    (#x002c64 "LATIN CAPITAL LETTER R WITH TAIL"       nil     )
    (#x002c65 "LATIN SMALL LETTER A WITH STROKE"       nil     )
    (#x002c66 "LATIN SMALL LETTER T WITH DIAGONAL STROKE" nil     )
    (#x002c67 "LATIN CAPITAL LETTER H WITH DESCENDER"  nil     )
    (#x002c68 "LATIN SMALL LETTER H WITH DESCENDER"    nil     )
    (#x002c69 "LATIN CAPITAL LETTER K WITH DESCENDER"  nil     )
    (#x002c6a "LATIN SMALL LETTER K WITH DESCENDER"    nil     )
    (#x002c6b "LATIN CAPITAL LETTER Z WITH DESCENDER"  nil     )
    (#x002c6c "LATIN SMALL LETTER Z WITH DESCENDER"    nil     )
    (#x002c6d "LATIN CAPITAL LETTER ALPHA"             nil     )
    (#x002c6e "LATIN CAPITAL LETTER M WITH HOOK"       nil     )
    (#x002c6f "LATIN CAPITAL LETTER TURNED A"          nil     )
    (#x002c70 "LATIN CAPITAL LETTER TURNED ALPHA"      nil     )
    (#x002c71 "LATIN SMALL LETTER V WITH RIGHT HOOK"   nil     )
    (#x002c72 "LATIN CAPITAL LETTER W WITH HOOK"       nil     )
    (#x002c73 "LATIN SMALL LETTER W WITH HOOK"         nil     )
    (#x002c74 "LATIN SMALL LETTER V WITH CURL"         nil     )
    (#x002c75 "LATIN CAPITAL LETTER HALF H"            nil     )
    (#x002c76 "LATIN SMALL LETTER HALF H"              nil     )
    (#x002c77 "LATIN SMALL LETTER TAILLESS PHI"        nil     )
    (#x002c78 "LATIN SMALL LETTER E WITH NOTCH"        nil     )
    (#x002c79 "LATIN SMALL LETTER TURNED R WITH TAIL"  nil     )
    (#x002c7a "LATIN SMALL LETTER O WITH LOW RING INSIDE" nil     )
    (#x002c7b "LATIN LETTER SMALL CAPITAL TURNED E"    nil     )
    (#x002c7c "LATIN SUBSCRIPT SMALL LETTER J"         nil     )
    (#x002c7d "MODIFIER LETTER CAPITAL V"              nil     )
    (#x002c7e "LATIN CAPITAL LETTER S WITH SWASH TAIL" nil     )
    (#x002c7f "LATIN CAPITAL LETTER Z WITH SWASH TAIL" nil     )
    (#x002c80 "COPTIC CAPITAL LETTER ALFA"             nil     )
    (#x002c81 "COPTIC SMALL LETTER ALFA"               nil     )
    (#x002c82 "COPTIC CAPITAL LETTER VIDA"             nil     )
    (#x002c83 "COPTIC SMALL LETTER VIDA"               nil     )
    (#x002c84 "COPTIC CAPITAL LETTER GAMMA"            nil     )
    (#x002c85 "COPTIC SMALL LETTER GAMMA"              nil     )
    (#x002c86 "COPTIC CAPITAL LETTER DALDA"            nil     )
    (#x002c87 "COPTIC SMALL LETTER DALDA"              nil     )
    (#x002c88 "COPTIC CAPITAL LETTER EIE"              nil     )
    (#x002c89 "COPTIC SMALL LETTER EIE"                nil     )
    (#x002c8a "COPTIC CAPITAL LETTER SOU"              nil     )
    (#x002c8b "COPTIC SMALL LETTER SOU"                nil     )
    (#x002c8c "COPTIC CAPITAL LETTER ZATA"             nil     )
    (#x002c8d "COPTIC SMALL LETTER ZATA"               nil     )
    (#x002c8e "COPTIC CAPITAL LETTER HATE"             nil     )
    (#x002c8f "COPTIC SMALL LETTER HATE"               nil     )
    (#x002c90 "COPTIC CAPITAL LETTER THETHE"           nil     )
    (#x002c91 "COPTIC SMALL LETTER THETHE"             nil     )
    (#x002c92 "COPTIC CAPITAL LETTER IAUDA"            nil     )
    (#x002c93 "COPTIC SMALL LETTER IAUDA"              nil     )
    (#x002c94 "COPTIC CAPITAL LETTER KAPA"             nil     )
    (#x002c95 "COPTIC SMALL LETTER KAPA"               nil     )
    (#x002c96 "COPTIC CAPITAL LETTER LAULA"            nil     )
    (#x002c97 "COPTIC SMALL LETTER LAULA"              nil     )
    (#x002c98 "COPTIC CAPITAL LETTER MI"               nil     )
    (#x002c99 "COPTIC SMALL LETTER MI"                 nil     )
    (#x002c9a "COPTIC CAPITAL LETTER NI"               nil     )
    (#x002c9b "COPTIC SMALL LETTER NI"                 nil     )
    (#x002c9c "COPTIC CAPITAL LETTER KSI"              nil     )
    (#x002c9d "COPTIC SMALL LETTER KSI"                nil     )
    (#x002c9e "COPTIC CAPITAL LETTER O"                nil     )
    (#x002c9f "COPTIC SMALL LETTER O"                  nil     )
    (#x002ca0 "COPTIC CAPITAL LETTER PI"               nil     )
    (#x002ca1 "COPTIC SMALL LETTER PI"                 nil     )
    (#x002ca2 "COPTIC CAPITAL LETTER RO"               nil     )
    (#x002ca3 "COPTIC SMALL LETTER RO"                 nil     )
    (#x002ca4 "COPTIC CAPITAL LETTER SIMA"             nil     )
    (#x002ca5 "COPTIC SMALL LETTER SIMA"               nil     )
    (#x002ca6 "COPTIC CAPITAL LETTER TAU"              nil     )
    (#x002ca7 "COPTIC SMALL LETTER TAU"                nil     )
    (#x002ca8 "COPTIC CAPITAL LETTER UA"               nil     )
    (#x002ca9 "COPTIC SMALL LETTER UA"                 nil     )
    (#x002caa "COPTIC CAPITAL LETTER FI"               nil     )
    (#x002cab "COPTIC SMALL LETTER FI"                 nil     )
    (#x002cac "COPTIC CAPITAL LETTER KHI"              nil     )
    (#x002cad "COPTIC SMALL LETTER KHI"                nil     )
    (#x002cae "COPTIC CAPITAL LETTER PSI"              nil     )
    (#x002caf "COPTIC SMALL LETTER PSI"                nil     )
    (#x002cb0 "COPTIC CAPITAL LETTER OOU"              nil     )
    (#x002cb1 "COPTIC SMALL LETTER OOU"                nil     )
    (#x002cb2 "COPTIC CAPITAL LETTER DIALECT-P ALEF"   nil     )
    (#x002cb3 "COPTIC SMALL LETTER DIALECT-P ALEF"     nil     )
    (#x002cb4 "COPTIC CAPITAL LETTER OLD COPTIC AIN"   nil     )
    (#x002cb5 "COPTIC SMALL LETTER OLD COPTIC AIN"     nil     )
    (#x002cb6 "COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE" nil     )
    (#x002cb7 "COPTIC SMALL LETTER CRYPTOGRAMMIC EIE"  nil     )
    (#x002cb8 "COPTIC CAPITAL LETTER DIALECT-P KAPA"   nil     )
    (#x002cb9 "COPTIC SMALL LETTER DIALECT-P KAPA"     nil     )
    (#x002cba "COPTIC CAPITAL LETTER DIALECT-P NI"     nil     )
    (#x002cbb "COPTIC SMALL LETTER DIALECT-P NI"       nil     )
    (#x002cbc "COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI" nil     )
    (#x002cbd "COPTIC SMALL LETTER CRYPTOGRAMMIC NI"   nil     )
    (#x002cbe "COPTIC CAPITAL LETTER OLD COPTIC OOU"   nil     )
    (#x002cbf "COPTIC SMALL LETTER OLD COPTIC OOU"     nil     )
    (#x002cc0 "COPTIC CAPITAL LETTER SAMPI"            nil     )
    (#x002cc1 "COPTIC SMALL LETTER SAMPI"              nil     )
    (#x002cc2 "COPTIC CAPITAL LETTER CROSSED SHEI"     nil     )
    (#x002cc3 "COPTIC SMALL LETTER CROSSED SHEI"       nil     )
    (#x002cc4 "COPTIC CAPITAL LETTER OLD COPTIC SHEI"  nil     )
    (#x002cc5 "COPTIC SMALL LETTER OLD COPTIC SHEI"    nil     )
    (#x002cc6 "COPTIC CAPITAL LETTER OLD COPTIC ESH"   nil     )
    (#x002cc7 "COPTIC SMALL LETTER OLD COPTIC ESH"     nil     )
    (#x002cc8 "COPTIC CAPITAL LETTER AKHMIMIC KHEI"    nil     )
    (#x002cc9 "COPTIC SMALL LETTER AKHMIMIC KHEI"      nil     )
    (#x002cca "COPTIC CAPITAL LETTER DIALECT-P HORI"   nil     )
    (#x002ccb "COPTIC SMALL LETTER DIALECT-P HORI"     nil     )
    (#x002ccc "COPTIC CAPITAL LETTER OLD COPTIC HORI"  nil     )
    (#x002ccd "COPTIC SMALL LETTER OLD COPTIC HORI"    nil     )
    (#x002cce "COPTIC CAPITAL LETTER OLD COPTIC HA"    nil     )
    (#x002ccf "COPTIC SMALL LETTER OLD COPTIC HA"      nil     )
    (#x002cd0 "COPTIC CAPITAL LETTER L-SHAPED HA"      nil     )
    (#x002cd1 "COPTIC SMALL LETTER L-SHAPED HA"        nil     )
    (#x002cd2 "COPTIC CAPITAL LETTER OLD COPTIC HEI"   nil     )
    (#x002cd3 "COPTIC SMALL LETTER OLD COPTIC HEI"     nil     )
    (#x002cd4 "COPTIC CAPITAL LETTER OLD COPTIC HAT"   nil     )
    (#x002cd5 "COPTIC SMALL LETTER OLD COPTIC HAT"     nil     )
    (#x002cd6 "COPTIC CAPITAL LETTER OLD COPTIC GANGIA" nil     )
    (#x002cd7 "COPTIC SMALL LETTER OLD COPTIC GANGIA"  nil     )
    (#x002cd8 "COPTIC CAPITAL LETTER OLD COPTIC DJA"   nil     )
    (#x002cd9 "COPTIC SMALL LETTER OLD COPTIC DJA"     nil     )
    (#x002cda "COPTIC CAPITAL LETTER OLD COPTIC SHIMA" nil     )
    (#x002cdb "COPTIC SMALL LETTER OLD COPTIC SHIMA"   nil     )
    (#x002cdc "COPTIC CAPITAL LETTER OLD NUBIAN SHIMA" nil     )
    (#x002cdd "COPTIC SMALL LETTER OLD NUBIAN SHIMA"   nil     )
    (#x002cde "COPTIC CAPITAL LETTER OLD NUBIAN NGI"   nil     )
    (#x002cdf "COPTIC SMALL LETTER OLD NUBIAN NGI"     nil     )
    (#x002ce0 "COPTIC CAPITAL LETTER OLD NUBIAN NYI"   nil     )
    (#x002ce1 "COPTIC SMALL LETTER OLD NUBIAN NYI"     nil     )
    (#x002ce2 "COPTIC CAPITAL LETTER OLD NUBIAN WAU"   nil     )
    (#x002ce3 "COPTIC SMALL LETTER OLD NUBIAN WAU"     nil     )
    (#x002ce4 "COPTIC SYMBOL KAI"                      nil     )
    (#x002ce5 "COPTIC SYMBOL MI RO"                    nil     )
    (#x002ce6 "COPTIC SYMBOL PI RO"                    nil     )
    (#x002ce7 "COPTIC SYMBOL STAUROS"                  nil     )
    (#x002ce8 "COPTIC SYMBOL TAU RO"                   nil     )
    (#x002ce9 "COPTIC SYMBOL KHI RO"                   nil     )
    (#x002cea "COPTIC SYMBOL SHIMA SIMA"               nil     )
    (#x002ceb "COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI" nil     )
    (#x002cec "COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI" nil     )
    (#x002ced "COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA" nil     )
    (#x002cee "COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA" nil     )
    (#x002cef "COPTIC COMBINING NI ABOVE"              nil     )
    (#x002cf0 "COPTIC COMBINING SPIRITUS ASPER"        nil     )
    (#x002cf1 "COPTIC COMBINING SPIRITUS LENIS"        nil     )
    (#x002cf2 "COPTIC CAPITAL LETTER BOHAIRIC KHEI"    nil     )
    (#x002cf3 "COPTIC SMALL LETTER BOHAIRIC KHEI"      nil     )
    (#x002cf9 "COPTIC OLD NUBIAN FULL STOP"            nil     )
    (#x002cfa "COPTIC OLD NUBIAN DIRECT QUESTION MARK" nil     )
    (#x002cfb "COPTIC OLD NUBIAN INDIRECT QUESTION MARK" nil     )
    (#x002cfc "COPTIC OLD NUBIAN VERSE DIVIDER"        nil     )
    (#x002cfd "COPTIC FRACTION ONE HALF"               nil     )
    (#x002cfe "COPTIC FULL STOP"                       nil     )
    (#x002cff "COPTIC MORPHOLOGICAL DIVIDER"           nil     )
    (#x002d00 "GEORGIAN SMALL LETTER AN"               nil     )
    (#x002d01 "GEORGIAN SMALL LETTER BAN"              nil     )
    (#x002d02 "GEORGIAN SMALL LETTER GAN"              nil     )
    (#x002d03 "GEORGIAN SMALL LETTER DON"              nil     )
    (#x002d04 "GEORGIAN SMALL LETTER EN"               nil     )
    (#x002d05 "GEORGIAN SMALL LETTER VIN"              nil     )
    (#x002d06 "GEORGIAN SMALL LETTER ZEN"              nil     )
    (#x002d07 "GEORGIAN SMALL LETTER TAN"              nil     )
    (#x002d08 "GEORGIAN SMALL LETTER IN"               nil     )
    (#x002d09 "GEORGIAN SMALL LETTER KAN"              nil     )
    (#x002d0a "GEORGIAN SMALL LETTER LAS"              nil     )
    (#x002d0b "GEORGIAN SMALL LETTER MAN"              nil     )
    (#x002d0c "GEORGIAN SMALL LETTER NAR"              nil     )
    (#x002d0d "GEORGIAN SMALL LETTER ON"               nil     )
    (#x002d0e "GEORGIAN SMALL LETTER PAR"              nil     )
    (#x002d0f "GEORGIAN SMALL LETTER ZHAR"             nil     )
    (#x002d10 "GEORGIAN SMALL LETTER RAE"              nil     )
    (#x002d11 "GEORGIAN SMALL LETTER SAN"              nil     )
    (#x002d12 "GEORGIAN SMALL LETTER TAR"              nil     )
    (#x002d13 "GEORGIAN SMALL LETTER UN"               nil     )
    (#x002d14 "GEORGIAN SMALL LETTER PHAR"             nil     )
    (#x002d15 "GEORGIAN SMALL LETTER KHAR"             nil     )
    (#x002d16 "GEORGIAN SMALL LETTER GHAN"             nil     )
    (#x002d17 "GEORGIAN SMALL LETTER QAR"              nil     )
    (#x002d18 "GEORGIAN SMALL LETTER SHIN"             nil     )
    (#x002d19 "GEORGIAN SMALL LETTER CHIN"             nil     )
    (#x002d1a "GEORGIAN SMALL LETTER CAN"              nil     )
    (#x002d1b "GEORGIAN SMALL LETTER JIL"              nil     )
    (#x002d1c "GEORGIAN SMALL LETTER CIL"              nil     )
    (#x002d1d "GEORGIAN SMALL LETTER CHAR"             nil     )
    (#x002d1e "GEORGIAN SMALL LETTER XAN"              nil     )
    (#x002d1f "GEORGIAN SMALL LETTER JHAN"             nil     )
    (#x002d20 "GEORGIAN SMALL LETTER HAE"              nil     )
    (#x002d21 "GEORGIAN SMALL LETTER HE"               nil     )
    (#x002d22 "GEORGIAN SMALL LETTER HIE"              nil     )
    (#x002d23 "GEORGIAN SMALL LETTER WE"               nil     )
    (#x002d24 "GEORGIAN SMALL LETTER HAR"              nil     )
    (#x002d25 "GEORGIAN SMALL LETTER HOE"              nil     )
    (#x002d27 "GEORGIAN SMALL LETTER YN"               nil     )
    (#x002d2d "GEORGIAN SMALL LETTER AEN"              nil     )
    (#x002d30 "TIFINAGH LETTER YA"                     nil     )
    (#x002d31 "TIFINAGH LETTER YAB"                    nil     )
    (#x002d32 "TIFINAGH LETTER YABH"                   nil     )
    (#x002d33 "TIFINAGH LETTER YAG"                    nil     )
    (#x002d34 "TIFINAGH LETTER YAGHH"                  nil     )
    (#x002d35 "TIFINAGH LETTER BERBER ACADEMY YAJ"     nil     )
    (#x002d36 "TIFINAGH LETTER YAJ"                    nil     )
    (#x002d37 "TIFINAGH LETTER YAD"                    nil     )
    (#x002d38 "TIFINAGH LETTER YADH"                   nil     )
    (#x002d39 "TIFINAGH LETTER YADD"                   nil     )
    (#x002d3a "TIFINAGH LETTER YADDH"                  nil     )
    (#x002d3b "TIFINAGH LETTER YEY"                    nil     )
    (#x002d3c "TIFINAGH LETTER YAF"                    nil     )
    (#x002d3d "TIFINAGH LETTER YAK"                    nil     )
    (#x002d3e "TIFINAGH LETTER TUAREG YAK"             nil     )
    (#x002d3f "TIFINAGH LETTER YAKHH"                  nil     )
    (#x002d40 "TIFINAGH LETTER YAH"                    nil     )
    (#x002d41 "TIFINAGH LETTER BERBER ACADEMY YAH"     nil     )
    (#x002d42 "TIFINAGH LETTER TUAREG YAH"             nil     )
    (#x002d43 "TIFINAGH LETTER YAHH"                   nil     )
    (#x002d44 "TIFINAGH LETTER YAA"                    nil     )
    (#x002d45 "TIFINAGH LETTER YAKH"                   nil     )
    (#x002d46 "TIFINAGH LETTER TUAREG YAKH"            nil     )
    (#x002d47 "TIFINAGH LETTER YAQ"                    nil     )
    (#x002d48 "TIFINAGH LETTER TUAREG YAQ"             nil     )
    (#x002d49 "TIFINAGH LETTER YI"                     nil     )
    (#x002d4a "TIFINAGH LETTER YAZH"                   nil     )
    (#x002d4b "TIFINAGH LETTER AHAGGAR YAZH"           nil     )
    (#x002d4c "TIFINAGH LETTER TUAREG YAZH"            nil     )
    (#x002d4d "TIFINAGH LETTER YAL"                    nil     )
    (#x002d4e "TIFINAGH LETTER YAM"                    nil     )
    (#x002d4f "TIFINAGH LETTER YAN"                    nil     )
    (#x002d50 "TIFINAGH LETTER TUAREG YAGN"            nil     )
    (#x002d51 "TIFINAGH LETTER TUAREG YANG"            nil     )
    (#x002d52 "TIFINAGH LETTER YAP"                    nil     )
    (#x002d53 "TIFINAGH LETTER YU"                     nil     )
    (#x002d54 "TIFINAGH LETTER YAR"                    nil     )
    (#x002d55 "TIFINAGH LETTER YARR"                   nil     )
    (#x002d56 "TIFINAGH LETTER YAGH"                   nil     )
    (#x002d57 "TIFINAGH LETTER TUAREG YAGH"            nil     )
    (#x002d58 "TIFINAGH LETTER AYER YAGH"              nil     )
    (#x002d59 "TIFINAGH LETTER YAS"                    nil     )
    (#x002d5a "TIFINAGH LETTER YASS"                   nil     )
    (#x002d5b "TIFINAGH LETTER YASH"                   nil     )
    (#x002d5c "TIFINAGH LETTER YAT"                    nil     )
    (#x002d5d "TIFINAGH LETTER YATH"                   nil     )
    (#x002d5e "TIFINAGH LETTER YACH"                   nil     )
    (#x002d5f "TIFINAGH LETTER YATT"                   nil     )
    (#x002d60 "TIFINAGH LETTER YAV"                    nil     )
    (#x002d61 "TIFINAGH LETTER YAW"                    nil     )
    (#x002d62 "TIFINAGH LETTER YAY"                    nil     )
    (#x002d63 "TIFINAGH LETTER YAZ"                    nil     )
    (#x002d64 "TIFINAGH LETTER TAWELLEMET YAZ"         nil     )
    (#x002d65 "TIFINAGH LETTER YAZZ"                   nil     )
    (#x002d66 "TIFINAGH LETTER YE"                     nil     )
    (#x002d67 "TIFINAGH LETTER YO"                     nil     )
    (#x002d6f "TIFINAGH MODIFIER LETTER LABIALIZATION MARK" nil     )
    (#x002d70 "TIFINAGH SEPARATOR MARK"                nil     )
    (#x002d7f "TIFINAGH CONSONANT JOINER"              nil     )
    (#x002d80 "ETHIOPIC SYLLABLE LOA"                  nil     )
    (#x002d81 "ETHIOPIC SYLLABLE MOA"                  nil     )
    (#x002d82 "ETHIOPIC SYLLABLE ROA"                  nil     )
    (#x002d83 "ETHIOPIC SYLLABLE SOA"                  nil     )
    (#x002d84 "ETHIOPIC SYLLABLE SHOA"                 nil     )
    (#x002d85 "ETHIOPIC SYLLABLE BOA"                  nil     )
    (#x002d86 "ETHIOPIC SYLLABLE TOA"                  nil     )
    (#x002d87 "ETHIOPIC SYLLABLE COA"                  nil     )
    (#x002d88 "ETHIOPIC SYLLABLE NOA"                  nil     )
    (#x002d89 "ETHIOPIC SYLLABLE NYOA"                 nil     )
    (#x002d8a "ETHIOPIC SYLLABLE GLOTTAL OA"           nil     )
    (#x002d8b "ETHIOPIC SYLLABLE ZOA"                  nil     )
    (#x002d8c "ETHIOPIC SYLLABLE DOA"                  nil     )
    (#x002d8d "ETHIOPIC SYLLABLE DDOA"                 nil     )
    (#x002d8e "ETHIOPIC SYLLABLE JOA"                  nil     )
    (#x002d8f "ETHIOPIC SYLLABLE THOA"                 nil     )
    (#x002d90 "ETHIOPIC SYLLABLE CHOA"                 nil     )
    (#x002d91 "ETHIOPIC SYLLABLE PHOA"                 nil     )
    (#x002d92 "ETHIOPIC SYLLABLE POA"                  nil     )
    (#x002d93 "ETHIOPIC SYLLABLE GGWA"                 nil     )
    (#x002d94 "ETHIOPIC SYLLABLE GGWI"                 nil     )
    (#x002d95 "ETHIOPIC SYLLABLE GGWEE"                nil     )
    (#x002d96 "ETHIOPIC SYLLABLE GGWE"                 nil     )
    (#x002da0 "ETHIOPIC SYLLABLE SSA"                  nil     )
    (#x002da1 "ETHIOPIC SYLLABLE SSU"                  nil     )
    (#x002da2 "ETHIOPIC SYLLABLE SSI"                  nil     )
    (#x002da3 "ETHIOPIC SYLLABLE SSAA"                 nil     )
    (#x002da4 "ETHIOPIC SYLLABLE SSEE"                 nil     )
    (#x002da5 "ETHIOPIC SYLLABLE SSE"                  nil     )
    (#x002da6 "ETHIOPIC SYLLABLE SSO"                  nil     )
    (#x002da8 "ETHIOPIC SYLLABLE CCA"                  nil     )
    (#x002da9 "ETHIOPIC SYLLABLE CCU"                  nil     )
    (#x002daa "ETHIOPIC SYLLABLE CCI"                  nil     )
    (#x002dab "ETHIOPIC SYLLABLE CCAA"                 nil     )
    (#x002dac "ETHIOPIC SYLLABLE CCEE"                 nil     )
    (#x002dad "ETHIOPIC SYLLABLE CCE"                  nil     )
    (#x002dae "ETHIOPIC SYLLABLE CCO"                  nil     )
    (#x002db0 "ETHIOPIC SYLLABLE ZZA"                  nil     )
    (#x002db1 "ETHIOPIC SYLLABLE ZZU"                  nil     )
    (#x002db2 "ETHIOPIC SYLLABLE ZZI"                  nil     )
    (#x002db3 "ETHIOPIC SYLLABLE ZZAA"                 nil     )
    (#x002db4 "ETHIOPIC SYLLABLE ZZEE"                 nil     )
    (#x002db5 "ETHIOPIC SYLLABLE ZZE"                  nil     )
    (#x002db6 "ETHIOPIC SYLLABLE ZZO"                  nil     )
    (#x002db8 "ETHIOPIC SYLLABLE CCHA"                 nil     )
    (#x002db9 "ETHIOPIC SYLLABLE CCHU"                 nil     )
    (#x002dba "ETHIOPIC SYLLABLE CCHI"                 nil     )
    (#x002dbb "ETHIOPIC SYLLABLE CCHAA"                nil     )
    (#x002dbc "ETHIOPIC SYLLABLE CCHEE"                nil     )
    (#x002dbd "ETHIOPIC SYLLABLE CCHE"                 nil     )
    (#x002dbe "ETHIOPIC SYLLABLE CCHO"                 nil     )
    (#x002dc0 "ETHIOPIC SYLLABLE QYA"                  nil     )
    (#x002dc1 "ETHIOPIC SYLLABLE QYU"                  nil     )
    (#x002dc2 "ETHIOPIC SYLLABLE QYI"                  nil     )
    (#x002dc3 "ETHIOPIC SYLLABLE QYAA"                 nil     )
    (#x002dc4 "ETHIOPIC SYLLABLE QYEE"                 nil     )
    (#x002dc5 "ETHIOPIC SYLLABLE QYE"                  nil     )
    (#x002dc6 "ETHIOPIC SYLLABLE QYO"                  nil     )
    (#x002dc8 "ETHIOPIC SYLLABLE KYA"                  nil     )
    (#x002dc9 "ETHIOPIC SYLLABLE KYU"                  nil     )
    (#x002dca "ETHIOPIC SYLLABLE KYI"                  nil     )
    (#x002dcb "ETHIOPIC SYLLABLE KYAA"                 nil     )
    (#x002dcc "ETHIOPIC SYLLABLE KYEE"                 nil     )
    (#x002dcd "ETHIOPIC SYLLABLE KYE"                  nil     )
    (#x002dce "ETHIOPIC SYLLABLE KYO"                  nil     )
    (#x002dd0 "ETHIOPIC SYLLABLE XYA"                  nil     )
    (#x002dd1 "ETHIOPIC SYLLABLE XYU"                  nil     )
    (#x002dd2 "ETHIOPIC SYLLABLE XYI"                  nil     )
    (#x002dd3 "ETHIOPIC SYLLABLE XYAA"                 nil     )
    (#x002dd4 "ETHIOPIC SYLLABLE XYEE"                 nil     )
    (#x002dd5 "ETHIOPIC SYLLABLE XYE"                  nil     )
    (#x002dd6 "ETHIOPIC SYLLABLE XYO"                  nil     )
    (#x002dd8 "ETHIOPIC SYLLABLE GYA"                  nil     )
    (#x002dd9 "ETHIOPIC SYLLABLE GYU"                  nil     )
    (#x002dda "ETHIOPIC SYLLABLE GYI"                  nil     )
    (#x002ddb "ETHIOPIC SYLLABLE GYAA"                 nil     )
    (#x002ddc "ETHIOPIC SYLLABLE GYEE"                 nil     )
    (#x002ddd "ETHIOPIC SYLLABLE GYE"                  nil     )
    (#x002dde "ETHIOPIC SYLLABLE GYO"                  nil     )
    (#x002de0 "COMBINING CYRILLIC LETTER BE"           nil     )
    (#x002de1 "COMBINING CYRILLIC LETTER VE"           nil     )
    (#x002de2 "COMBINING CYRILLIC LETTER GHE"          nil     )
    (#x002de3 "COMBINING CYRILLIC LETTER DE"           nil     )
    (#x002de4 "COMBINING CYRILLIC LETTER ZHE"          nil     )
    (#x002de5 "COMBINING CYRILLIC LETTER ZE"           nil     )
    (#x002de6 "COMBINING CYRILLIC LETTER KA"           nil     )
    (#x002de7 "COMBINING CYRILLIC LETTER EL"           nil     )
    (#x002de8 "COMBINING CYRILLIC LETTER EM"           nil     )
    (#x002de9 "COMBINING CYRILLIC LETTER EN"           nil     )
    (#x002dea "COMBINING CYRILLIC LETTER O"            nil     )
    (#x002deb "COMBINING CYRILLIC LETTER PE"           nil     )
    (#x002dec "COMBINING CYRILLIC LETTER ER"           nil     )
    (#x002ded "COMBINING CYRILLIC LETTER ES"           nil     )
    (#x002dee "COMBINING CYRILLIC LETTER TE"           nil     )
    (#x002def "COMBINING CYRILLIC LETTER HA"           nil     )
    (#x002df0 "COMBINING CYRILLIC LETTER TSE"          nil     )
    (#x002df1 "COMBINING CYRILLIC LETTER CHE"          nil     )
    (#x002df2 "COMBINING CYRILLIC LETTER SHA"          nil     )
    (#x002df3 "COMBINING CYRILLIC LETTER SHCHA"        nil     )
    (#x002df4 "COMBINING CYRILLIC LETTER FITA"         nil     )
    (#x002df5 "COMBINING CYRILLIC LETTER ES-TE"        nil     )
    (#x002df6 "COMBINING CYRILLIC LETTER A"            nil     )
    (#x002df7 "COMBINING CYRILLIC LETTER IE"           nil     )
    (#x002df8 "COMBINING CYRILLIC LETTER DJERV"        nil     )
    (#x002df9 "COMBINING CYRILLIC LETTER MONOGRAPH UK" nil     )
    (#x002dfa "COMBINING CYRILLIC LETTER YAT"          nil     )
    (#x002dfb "COMBINING CYRILLIC LETTER YU"           nil     )
    (#x002dfc "COMBINING CYRILLIC LETTER IOTIFIED A"   nil     )
    (#x002dfd "COMBINING CYRILLIC LETTER LITTLE YUS"   nil     )
    (#x002dfe "COMBINING CYRILLIC LETTER BIG YUS"      nil     )
    (#x002dff "COMBINING CYRILLIC LETTER IOTIFIED BIG YUS" nil     )
    (#x002e00 "RIGHT ANGLE SUBSTITUTION MARKER"        nil     )
    (#x002e01 "RIGHT ANGLE DOTTED SUBSTITUTION MARKER" nil     )
    (#x002e02 "LEFT SUBSTITUTION BRACKET"              nil     )
    (#x002e03 "RIGHT SUBSTITUTION BRACKET"             nil     )
    (#x002e04 "LEFT DOTTED SUBSTITUTION BRACKET"       nil     )
    (#x002e05 "RIGHT DOTTED SUBSTITUTION BRACKET"      nil     )
    (#x002e06 "RAISED INTERPOLATION MARKER"            nil     )
    (#x002e07 "RAISED DOTTED INTERPOLATION MARKER"     nil     )
    (#x002e08 "DOTTED TRANSPOSITION MARKER"            nil     )
    (#x002e09 "LEFT TRANSPOSITION BRACKET"             nil     )
    (#x002e0a "RIGHT TRANSPOSITION BRACKET"            nil     )
    (#x002e0b "RAISED SQUARE"                          nil     )
    (#x002e0c "LEFT RAISED OMISSION BRACKET"           nil     )
    (#x002e0d "RIGHT RAISED OMISSION BRACKET"          nil     )
    (#x002e0e "EDITORIAL CORONIS"                      nil     )
    (#x002e0f "PARAGRAPHOS"                            nil     )
    (#x002e10 "FORKED PARAGRAPHOS"                     nil     )
    (#x002e11 "REVERSED FORKED PARAGRAPHOS"            nil     )
    (#x002e12 "HYPODIASTOLE"                           nil     )
    (#x002e13 "DOTTED OBELOS"                          nil     )
    (#x002e14 "DOWNWARDS ANCORA"                       nil     )
    (#x002e15 "UPWARDS ANCORA"                         nil     )
    (#x002e16 "DOTTED RIGHT-POINTING ANGLE"            nil     )
    (#x002e17 "DOUBLE OBLIQUE HYPHEN"                  nil     )
    (#x002e18 "INVERTED INTERROBANG"                   nil     )
    (#x002e19 "PALM BRANCH"                            nil     )
    (#x002e1a "HYPHEN WITH DIAERESIS"                  nil     )
    (#x002e1b "TILDE WITH RING ABOVE"                  nil     )
    (#x002e1c "LEFT LOW PARAPHRASE BRACKET"            nil     )
    (#x002e1d "RIGHT LOW PARAPHRASE BRACKET"           nil     )
    (#x002e1e "TILDE WITH DOT ABOVE"                   nil     )
    (#x002e1f "TILDE WITH DOT BELOW"                   nil     )
    (#x002e20 "LEFT VERTICAL BAR WITH QUILL"           nil     )
    (#x002e21 "RIGHT VERTICAL BAR WITH QUILL"          nil     )
    (#x002e22 "TOP LEFT HALF BRACKET"                  nil     )
    (#x002e23 "TOP RIGHT HALF BRACKET"                 nil     )
    (#x002e24 "BOTTOM LEFT HALF BRACKET"               nil     )
    (#x002e25 "BOTTOM RIGHT HALF BRACKET"              nil     )
    (#x002e26 "LEFT SIDEWAYS U BRACKET"                nil     )
    (#x002e27 "RIGHT SIDEWAYS U BRACKET"               nil     )
    (#x002e28 "LEFT DOUBLE PARENTHESIS"                nil     )
    (#x002e29 "RIGHT DOUBLE PARENTHESIS"               nil     )
    (#x002e2a "TWO DOTS OVER ONE DOT PUNCTUATION"      nil     )
    (#x002e2b "ONE DOT OVER TWO DOTS PUNCTUATION"      nil     )
    (#x002e2c "SQUARED FOUR DOT PUNCTUATION"           nil     )
    (#x002e2d "FIVE DOT MARK"                          nil     )
    (#x002e2e "REVERSED QUESTION MARK"                 nil     )
    (#x002e2f "VERTICAL TILDE"                         nil     )
    (#x002e30 "RING POINT"                             nil     )
    (#x002e31 "WORD SEPARATOR MIDDLE DOT"              nil     )
    (#x002e32 "TURNED COMMA"                           nil     )
    (#x002e33 "RAISED DOT"                             nil     )
    (#x002e34 "RAISED COMMA"                           nil     )
    (#x002e35 "TURNED SEMICOLON"                       nil     )
    (#x002e36 "DAGGER WITH LEFT GUARD"                 nil     )
    (#x002e37 "DAGGER WITH RIGHT GUARD"                nil     )
    (#x002e38 "TURNED DAGGER"                          nil     )
    (#x002e39 "TOP HALF SECTION SIGN"                  nil     )
    (#x002e3a "TWO-EM DASH"                            nil     )
    (#x002e3b "THREE-EM DASH"                          nil     )
    (#x002e3c "STENOGRAPHIC FULL STOP"                 nil     )
    (#x002e3d "VERTICAL SIX DOTS"                      nil     )
    (#x002e3e "WIGGLY VERTICAL LINE"                   nil     )
    (#x002e3f "CAPITULUM"                              nil     )
    (#x002e40 "DOUBLE HYPHEN"                          nil     )
    (#x002e41 "REVERSED COMMA"                         nil     )
    (#x002e42 "DOUBLE LOW-REVERSED-9 QUOTATION MARK"   nil     )
    (#x002e43 "DASH WITH LEFT UPTURN"                  nil     )
    (#x002e44 "DOUBLE SUSPENSION MARK"                 nil     )
    (#x002e45 "INVERTED LOW KAVYKA"                    nil     )
    (#x002e46 "INVERTED LOW KAVYKA WITH KAVYKA ABOVE"  nil     )
    (#x002e47 "LOW KAVYKA"                             nil     )
    (#x002e48 "LOW KAVYKA WITH DOT"                    nil     )
    (#x002e49 "DOUBLE STACKED COMMA"                   nil     )
    (#x002e4a "DOTTED SOLIDUS"                         nil     )
    (#x002e4b "TRIPLE DAGGER"                          nil     )
    (#x002e4c "MEDIEVAL COMMA"                         nil     )
    (#x002e4d "PARAGRAPHUS MARK"                       nil     )
    (#x002e4e "PUNCTUS ELEVATUS MARK"                  nil     )
    (#x002e4f "CORNISH VERSE DIVIDER"                  nil     )
    (#x002e50 "CROSS PATTY WITH RIGHT CROSSBAR"        nil     )
    (#x002e51 "CROSS PATTY WITH LEFT CROSSBAR"         nil     )
    (#x002e52 "TIRONIAN SIGN CAPITAL ET"               nil     )
    (#x002e53 "MEDIEVAL EXCLAMATION MARK"              nil     )
    (#x002e54 "MEDIEVAL QUESTION MARK"                 nil     )
    (#x002e55 "LEFT SQUARE BRACKET WITH STROKE"        nil     )
    (#x002e56 "RIGHT SQUARE BRACKET WITH STROKE"       nil     )
    (#x002e57 "LEFT SQUARE BRACKET WITH DOUBLE STROKE" nil     )
    (#x002e58 "RIGHT SQUARE BRACKET WITH DOUBLE STROKE" nil     )
    (#x002e59 "TOP HALF LEFT PARENTHESIS"              nil     )
    (#x002e5a "TOP HALF RIGHT PARENTHESIS"             nil     )
    (#x002e5b "BOTTOM HALF LEFT PARENTHESIS"           nil     )
    (#x002e5c "BOTTOM HALF RIGHT PARENTHESIS"          nil     )
    (#x002e5d "OBLIQUE HYPHEN"                         nil     )
    (#x002e80 "CJK RADICAL REPEAT"                     nil     )
    (#x002e81 "CJK RADICAL CLIFF"                      nil     )
    (#x002e82 "CJK RADICAL SECOND ONE"                 nil     )
    (#x002e83 "CJK RADICAL SECOND TWO"                 nil     )
    (#x002e84 "CJK RADICAL SECOND THREE"               nil     )
    (#x002e85 "CJK RADICAL PERSON"                     nil     )
    (#x002e86 "CJK RADICAL BOX"                        nil     )
    (#x002e87 "CJK RADICAL TABLE"                      nil     )
    (#x002e88 "CJK RADICAL KNIFE ONE"                  nil     )
    (#x002e89 "CJK RADICAL KNIFE TWO"                  nil     )
    (#x002e8a "CJK RADICAL DIVINATION"                 nil     )
    (#x002e8b "CJK RADICAL SEAL"                       nil     )
    (#x002e8c "CJK RADICAL SMALL ONE"                  nil     )
    (#x002e8d "CJK RADICAL SMALL TWO"                  nil     )
    (#x002e8e "CJK RADICAL LAME ONE"                   nil     )
    (#x002e8f "CJK RADICAL LAME TWO"                   nil     )
    (#x002e90 "CJK RADICAL LAME THREE"                 nil     )
    (#x002e91 "CJK RADICAL LAME FOUR"                  nil     )
    (#x002e92 "CJK RADICAL SNAKE"                      nil     )
    (#x002e93 "CJK RADICAL THREAD"                     nil     )
    (#x002e94 "CJK RADICAL SNOUT ONE"                  nil     )
    (#x002e95 "CJK RADICAL SNOUT TWO"                  nil     )
    (#x002e96 "CJK RADICAL HEART ONE"                  nil     )
    (#x002e97 "CJK RADICAL HEART TWO"                  nil     )
    (#x002e98 "CJK RADICAL HAND"                       nil     )
    (#x002e99 "CJK RADICAL RAP"                        nil     )
    (#x002e9b "CJK RADICAL CHOKE"                      nil     )
    (#x002e9c "CJK RADICAL SUN"                        nil     )
    (#x002e9d "CJK RADICAL MOON"                       nil     )
    (#x002e9e "CJK RADICAL DEATH"                      nil     )
    (#x002e9f "CJK RADICAL MOTHER"                     nil     )
    (#x002ea0 "CJK RADICAL CIVILIAN"                   nil     )
    (#x002ea1 "CJK RADICAL WATER ONE"                  nil     )
    (#x002ea2 "CJK RADICAL WATER TWO"                  nil     )
    (#x002ea3 "CJK RADICAL FIRE"                       nil     )
    (#x002ea4 "CJK RADICAL PAW ONE"                    nil     )
    (#x002ea5 "CJK RADICAL PAW TWO"                    nil     )
    (#x002ea6 "CJK RADICAL SIMPLIFIED HALF TREE TRUNK" nil     )
    (#x002ea7 "CJK RADICAL COW"                        nil     )
    (#x002ea8 "CJK RADICAL DOG"                        nil     )
    (#x002ea9 "CJK RADICAL JADE"                       nil     )
    (#x002eaa "CJK RADICAL BOLT OF CLOTH"              nil     )
    (#x002eab "CJK RADICAL EYE"                        nil     )
    (#x002eac "CJK RADICAL SPIRIT ONE"                 nil     )
    (#x002ead "CJK RADICAL SPIRIT TWO"                 nil     )
    (#x002eae "CJK RADICAL BAMBOO"                     nil     )
    (#x002eaf "CJK RADICAL SILK"                       nil     )
    (#x002eb0 "CJK RADICAL C-SIMPLIFIED SILK"          nil     )
    (#x002eb1 "CJK RADICAL NET ONE"                    nil     )
    (#x002eb2 "CJK RADICAL NET TWO"                    nil     )
    (#x002eb3 "CJK RADICAL NET THREE"                  nil     )
    (#x002eb4 "CJK RADICAL NET FOUR"                   nil     )
    (#x002eb5 "CJK RADICAL MESH"                       nil     )
    (#x002eb6 "CJK RADICAL SHEEP"                      nil     )
    (#x002eb7 "CJK RADICAL RAM"                        nil     )
    (#x002eb8 "CJK RADICAL EWE"                        nil     )
    (#x002eb9 "CJK RADICAL OLD"                        nil     )
    (#x002eba "CJK RADICAL BRUSH ONE"                  nil     )
    (#x002ebb "CJK RADICAL BRUSH TWO"                  nil     )
    (#x002ebc "CJK RADICAL MEAT"                       nil     )
    (#x002ebd "CJK RADICAL MORTAR"                     nil     )
    (#x002ebe "CJK RADICAL GRASS ONE"                  nil     )
    (#x002ebf "CJK RADICAL GRASS TWO"                  nil     )
    (#x002ec0 "CJK RADICAL GRASS THREE"                nil     )
    (#x002ec1 "CJK RADICAL TIGER"                      nil     )
    (#x002ec2 "CJK RADICAL CLOTHES"                    nil     )
    (#x002ec3 "CJK RADICAL WEST ONE"                   nil     )
    (#x002ec4 "CJK RADICAL WEST TWO"                   nil     )
    (#x002ec5 "CJK RADICAL C-SIMPLIFIED SEE"           nil     )
    (#x002ec6 "CJK RADICAL SIMPLIFIED HORN"            nil     )
    (#x002ec7 "CJK RADICAL HORN"                       nil     )
    (#x002ec8 "CJK RADICAL C-SIMPLIFIED SPEECH"        nil     )
    (#x002ec9 "CJK RADICAL C-SIMPLIFIED SHELL"         nil     )
    (#x002eca "CJK RADICAL FOOT"                       nil     )
    (#x002ecb "CJK RADICAL C-SIMPLIFIED CART"          nil     )
    (#x002ecc "CJK RADICAL SIMPLIFIED WALK"            nil     )
    (#x002ecd "CJK RADICAL WALK ONE"                   nil     )
    (#x002ece "CJK RADICAL WALK TWO"                   nil     )
    (#x002ecf "CJK RADICAL CITY"                       nil     )
    (#x002ed0 "CJK RADICAL C-SIMPLIFIED GOLD"          nil     )
    (#x002ed1 "CJK RADICAL LONG ONE"                   nil     )
    (#x002ed2 "CJK RADICAL LONG TWO"                   nil     )
    (#x002ed3 "CJK RADICAL C-SIMPLIFIED LONG"          nil     )
    (#x002ed4 "CJK RADICAL C-SIMPLIFIED GATE"          nil     )
    (#x002ed5 "CJK RADICAL MOUND ONE"                  nil     )
    (#x002ed6 "CJK RADICAL MOUND TWO"                  nil     )
    (#x002ed7 "CJK RADICAL RAIN"                       nil     )
    (#x002ed8 "CJK RADICAL BLUE"                       nil     )
    (#x002ed9 "CJK RADICAL C-SIMPLIFIED TANNED LEATHER" nil     )
    (#x002eda "CJK RADICAL C-SIMPLIFIED LEAF"          nil     )
    (#x002edb "CJK RADICAL C-SIMPLIFIED WIND"          nil     )
    (#x002edc "CJK RADICAL C-SIMPLIFIED FLY"           nil     )
    (#x002edd "CJK RADICAL EAT ONE"                    nil     )
    (#x002ede "CJK RADICAL EAT TWO"                    nil     )
    (#x002edf "CJK RADICAL EAT THREE"                  nil     )
    (#x002ee0 "CJK RADICAL C-SIMPLIFIED EAT"           nil     )
    (#x002ee1 "CJK RADICAL HEAD"                       nil     )
    (#x002ee2 "CJK RADICAL C-SIMPLIFIED HORSE"         nil     )
    (#x002ee3 "CJK RADICAL BONE"                       nil     )
    (#x002ee4 "CJK RADICAL GHOST"                      nil     )
    (#x002ee5 "CJK RADICAL C-SIMPLIFIED FISH"          nil     )
    (#x002ee6 "CJK RADICAL C-SIMPLIFIED BIRD"          nil     )
    (#x002ee7 "CJK RADICAL C-SIMPLIFIED SALT"          nil     )
    (#x002ee8 "CJK RADICAL SIMPLIFIED WHEAT"           nil     )
    (#x002ee9 "CJK RADICAL SIMPLIFIED YELLOW"          nil     )
    (#x002eea "CJK RADICAL C-SIMPLIFIED FROG"          nil     )
    (#x002eeb "CJK RADICAL J-SIMPLIFIED EVEN"          nil     )
    (#x002eec "CJK RADICAL C-SIMPLIFIED EVEN"          nil     )
    (#x002eed "CJK RADICAL J-SIMPLIFIED TOOTH"         nil     )
    (#x002eee "CJK RADICAL C-SIMPLIFIED TOOTH"         nil     )
    (#x002eef "CJK RADICAL J-SIMPLIFIED DRAGON"        nil     )
    (#x002ef0 "CJK RADICAL C-SIMPLIFIED DRAGON"        nil     )
    (#x002ef1 "CJK RADICAL TURTLE"                     nil     )
    (#x002ef2 "CJK RADICAL J-SIMPLIFIED TURTLE"        nil     )
    (#x002ef3 "CJK RADICAL C-SIMPLIFIED TURTLE"        nil     )
    (#x002f00 "KANGXI RADICAL ONE"                     nil     )
    (#x002f01 "KANGXI RADICAL LINE"                    nil     )
    (#x002f02 "KANGXI RADICAL DOT"                     nil     )
    (#x002f03 "KANGXI RADICAL SLASH"                   nil     )
    (#x002f04 "KANGXI RADICAL SECOND"                  nil     )
    (#x002f05 "KANGXI RADICAL HOOK"                    nil     )
    (#x002f06 "KANGXI RADICAL TWO"                     nil     )
    (#x002f07 "KANGXI RADICAL LID"                     nil     )
    (#x002f08 "KANGXI RADICAL MAN"                     nil     )
    (#x002f09 "KANGXI RADICAL LEGS"                    nil     )
    (#x002f0a "KANGXI RADICAL ENTER"                   nil     )
    (#x002f0b "KANGXI RADICAL EIGHT"                   nil     )
    (#x002f0c "KANGXI RADICAL DOWN BOX"                nil     )
    (#x002f0d "KANGXI RADICAL COVER"                   nil     )
    (#x002f0e "KANGXI RADICAL ICE"                     nil     )
    (#x002f0f "KANGXI RADICAL TABLE"                   nil     )
    (#x002f10 "KANGXI RADICAL OPEN BOX"                nil     )
    (#x002f11 "KANGXI RADICAL KNIFE"                   nil     )
    (#x002f12 "KANGXI RADICAL POWER"                   nil     )
    (#x002f13 "KANGXI RADICAL WRAP"                    nil     )
    (#x002f14 "KANGXI RADICAL SPOON"                   nil     )
    (#x002f15 "KANGXI RADICAL RIGHT OPEN BOX"          nil     )
    (#x002f16 "KANGXI RADICAL HIDING ENCLOSURE"        nil     )
    (#x002f17 "KANGXI RADICAL TEN"                     nil     )
    (#x002f18 "KANGXI RADICAL DIVINATION"              nil     )
    (#x002f19 "KANGXI RADICAL SEAL"                    nil     )
    (#x002f1a "KANGXI RADICAL CLIFF"                   nil     )
    (#x002f1b "KANGXI RADICAL PRIVATE"                 nil     )
    (#x002f1c "KANGXI RADICAL AGAIN"                   nil     )
    (#x002f1d "KANGXI RADICAL MOUTH"                   nil     )
    (#x002f1e "KANGXI RADICAL ENCLOSURE"               nil     )
    (#x002f1f "KANGXI RADICAL EARTH"                   nil     )
    (#x002f20 "KANGXI RADICAL SCHOLAR"                 nil     )
    (#x002f21 "KANGXI RADICAL GO"                      nil     )
    (#x002f22 "KANGXI RADICAL GO SLOWLY"               nil     )
    (#x002f23 "KANGXI RADICAL EVENING"                 nil     )
    (#x002f24 "KANGXI RADICAL BIG"                     nil     )
    (#x002f25 "KANGXI RADICAL WOMAN"                   nil     )
    (#x002f26 "KANGXI RADICAL CHILD"                   nil     )
    (#x002f27 "KANGXI RADICAL ROOF"                    nil     )
    (#x002f28 "KANGXI RADICAL INCH"                    nil     )
    (#x002f29 "KANGXI RADICAL SMALL"                   nil     )
    (#x002f2a "KANGXI RADICAL LAME"                    nil     )
    (#x002f2b "KANGXI RADICAL CORPSE"                  nil     )
    (#x002f2c "KANGXI RADICAL SPROUT"                  nil     )
    (#x002f2d "KANGXI RADICAL MOUNTAIN"                nil     )
    (#x002f2e "KANGXI RADICAL RIVER"                   nil     )
    (#x002f2f "KANGXI RADICAL WORK"                    nil     )
    (#x002f30 "KANGXI RADICAL ONESELF"                 nil     )
    (#x002f31 "KANGXI RADICAL TURBAN"                  nil     )
    (#x002f32 "KANGXI RADICAL DRY"                     nil     )
    (#x002f33 "KANGXI RADICAL SHORT THREAD"            nil     )
    (#x002f34 "KANGXI RADICAL DOTTED CLIFF"            nil     )
    (#x002f35 "KANGXI RADICAL LONG STRIDE"             nil     )
    (#x002f36 "KANGXI RADICAL TWO HANDS"               nil     )
    (#x002f37 "KANGXI RADICAL SHOOT"                   nil     )
    (#x002f38 "KANGXI RADICAL BOW"                     nil     )
    (#x002f39 "KANGXI RADICAL SNOUT"                   nil     )
    (#x002f3a "KANGXI RADICAL BRISTLE"                 nil     )
    (#x002f3b "KANGXI RADICAL STEP"                    nil     )
    (#x002f3c "KANGXI RADICAL HEART"                   nil     )
    (#x002f3d "KANGXI RADICAL HALBERD"                 nil     )
    (#x002f3e "KANGXI RADICAL DOOR"                    nil     )
    (#x002f3f "KANGXI RADICAL HAND"                    nil     )
    (#x002f40 "KANGXI RADICAL BRANCH"                  nil     )
    (#x002f41 "KANGXI RADICAL RAP"                     nil     )
    (#x002f42 "KANGXI RADICAL SCRIPT"                  nil     )
    (#x002f43 "KANGXI RADICAL DIPPER"                  nil     )
    (#x002f44 "KANGXI RADICAL AXE"                     nil     )
    (#x002f45 "KANGXI RADICAL SQUARE"                  nil     )
    (#x002f46 "KANGXI RADICAL NOT"                     nil     )
    (#x002f47 "KANGXI RADICAL SUN"                     nil     )
    (#x002f48 "KANGXI RADICAL SAY"                     nil     )
    (#x002f49 "KANGXI RADICAL MOON"                    nil     )
    (#x002f4a "KANGXI RADICAL TREE"                    nil     )
    (#x002f4b "KANGXI RADICAL LACK"                    nil     )
    (#x002f4c "KANGXI RADICAL STOP"                    nil     )
    (#x002f4d "KANGXI RADICAL DEATH"                   nil     )
    (#x002f4e "KANGXI RADICAL WEAPON"                  nil     )
    (#x002f4f "KANGXI RADICAL DO NOT"                  nil     )
    (#x002f50 "KANGXI RADICAL COMPARE"                 nil     )
    (#x002f51 "KANGXI RADICAL FUR"                     nil     )
    (#x002f52 "KANGXI RADICAL CLAN"                    nil     )
    (#x002f53 "KANGXI RADICAL STEAM"                   nil     )
    (#x002f54 "KANGXI RADICAL WATER"                   nil     )
    (#x002f55 "KANGXI RADICAL FIRE"                    nil     )
    (#x002f56 "KANGXI RADICAL CLAW"                    nil     )
    (#x002f57 "KANGXI RADICAL FATHER"                  nil     )
    (#x002f58 "KANGXI RADICAL DOUBLE X"                nil     )
    (#x002f59 "KANGXI RADICAL HALF TREE TRUNK"         nil     )
    (#x002f5a "KANGXI RADICAL SLICE"                   nil     )
    (#x002f5b "KANGXI RADICAL FANG"                    nil     )
    (#x002f5c "KANGXI RADICAL COW"                     nil     )
    (#x002f5d "KANGXI RADICAL DOG"                     nil     )
    (#x002f5e "KANGXI RADICAL PROFOUND"                nil     )
    (#x002f5f "KANGXI RADICAL JADE"                    nil     )
    (#x002f60 "KANGXI RADICAL MELON"                   nil     )
    (#x002f61 "KANGXI RADICAL TILE"                    nil     )
    (#x002f62 "KANGXI RADICAL SWEET"                   nil     )
    (#x002f63 "KANGXI RADICAL LIFE"                    nil     )
    (#x002f64 "KANGXI RADICAL USE"                     nil     )
    (#x002f65 "KANGXI RADICAL FIELD"                   nil     )
    (#x002f66 "KANGXI RADICAL BOLT OF CLOTH"           nil     )
    (#x002f67 "KANGXI RADICAL SICKNESS"                nil     )
    (#x002f68 "KANGXI RADICAL DOTTED TENT"             nil     )
    (#x002f69 "KANGXI RADICAL WHITE"                   nil     )
    (#x002f6a "KANGXI RADICAL SKIN"                    nil     )
    (#x002f6b "KANGXI RADICAL DISH"                    nil     )
    (#x002f6c "KANGXI RADICAL EYE"                     nil     )
    (#x002f6d "KANGXI RADICAL SPEAR"                   nil     )
    (#x002f6e "KANGXI RADICAL ARROW"                   nil     )
    (#x002f6f "KANGXI RADICAL STONE"                   nil     )
    (#x002f70 "KANGXI RADICAL SPIRIT"                  nil     )
    (#x002f71 "KANGXI RADICAL TRACK"                   nil     )
    (#x002f72 "KANGXI RADICAL GRAIN"                   nil     )
    (#x002f73 "KANGXI RADICAL CAVE"                    nil     )
    (#x002f74 "KANGXI RADICAL STAND"                   nil     )
    (#x002f75 "KANGXI RADICAL BAMBOO"                  nil     )
    (#x002f76 "KANGXI RADICAL RICE"                    nil     )
    (#x002f77 "KANGXI RADICAL SILK"                    nil     )
    (#x002f78 "KANGXI RADICAL JAR"                     nil     )
    (#x002f79 "KANGXI RADICAL NET"                     nil     )
    (#x002f7a "KANGXI RADICAL SHEEP"                   nil     )
    (#x002f7b "KANGXI RADICAL FEATHER"                 nil     )
    (#x002f7c "KANGXI RADICAL OLD"                     nil     )
    (#x002f7d "KANGXI RADICAL AND"                     nil     )
    (#x002f7e "KANGXI RADICAL PLOW"                    nil     )
    (#x002f7f "KANGXI RADICAL EAR"                     nil     )
    (#x002f80 "KANGXI RADICAL BRUSH"                   nil     )
    (#x002f81 "KANGXI RADICAL MEAT"                    nil     )
    (#x002f82 "KANGXI RADICAL MINISTER"                nil     )
    (#x002f83 "KANGXI RADICAL SELF"                    nil     )
    (#x002f84 "KANGXI RADICAL ARRIVE"                  nil     )
    (#x002f85 "KANGXI RADICAL MORTAR"                  nil     )
    (#x002f86 "KANGXI RADICAL TONGUE"                  nil     )
    (#x002f87 "KANGXI RADICAL OPPOSE"                  nil     )
    (#x002f88 "KANGXI RADICAL BOAT"                    nil     )
    (#x002f89 "KANGXI RADICAL STOPPING"                nil     )
    (#x002f8a "KANGXI RADICAL COLOR"                   nil     )
    (#x002f8b "KANGXI RADICAL GRASS"                   nil     )
    (#x002f8c "KANGXI RADICAL TIGER"                   nil     )
    (#x002f8d "KANGXI RADICAL INSECT"                  nil     )
    (#x002f8e "KANGXI RADICAL BLOOD"                   nil     )
    (#x002f8f "KANGXI RADICAL WALK ENCLOSURE"          nil     )
    (#x002f90 "KANGXI RADICAL CLOTHES"                 nil     )
    (#x002f91 "KANGXI RADICAL WEST"                    nil     )
    (#x002f92 "KANGXI RADICAL SEE"                     nil     )
    (#x002f93 "KANGXI RADICAL HORN"                    nil     )
    (#x002f94 "KANGXI RADICAL SPEECH"                  nil     )
    (#x002f95 "KANGXI RADICAL VALLEY"                  nil     )
    (#x002f96 "KANGXI RADICAL BEAN"                    nil     )
    (#x002f97 "KANGXI RADICAL PIG"                     nil     )
    (#x002f98 "KANGXI RADICAL BADGER"                  nil     )
    (#x002f99 "KANGXI RADICAL SHELL"                   nil     )
    (#x002f9a "KANGXI RADICAL RED"                     nil     )
    (#x002f9b "KANGXI RADICAL RUN"                     nil     )
    (#x002f9c "KANGXI RADICAL FOOT"                    nil     )
    (#x002f9d "KANGXI RADICAL BODY"                    nil     )
    (#x002f9e "KANGXI RADICAL CART"                    nil     )
    (#x002f9f "KANGXI RADICAL BITTER"                  nil     )
    (#x002fa0 "KANGXI RADICAL MORNING"                 nil     )
    (#x002fa1 "KANGXI RADICAL WALK"                    nil     )
    (#x002fa2 "KANGXI RADICAL CITY"                    nil     )
    (#x002fa3 "KANGXI RADICAL WINE"                    nil     )
    (#x002fa4 "KANGXI RADICAL DISTINGUISH"             nil     )
    (#x002fa5 "KANGXI RADICAL VILLAGE"                 nil     )
    (#x002fa6 "KANGXI RADICAL GOLD"                    nil     )
    (#x002fa7 "KANGXI RADICAL LONG"                    nil     )
    (#x002fa8 "KANGXI RADICAL GATE"                    nil     )
    (#x002fa9 "KANGXI RADICAL MOUND"                   nil     )
    (#x002faa "KANGXI RADICAL SLAVE"                   nil     )
    (#x002fab "KANGXI RADICAL SHORT TAILED BIRD"       nil     )
    (#x002fac "KANGXI RADICAL RAIN"                    nil     )
    (#x002fad "KANGXI RADICAL BLUE"                    nil     )
    (#x002fae "KANGXI RADICAL WRONG"                   nil     )
    (#x002faf "KANGXI RADICAL FACE"                    nil     )
    (#x002fb0 "KANGXI RADICAL LEATHER"                 nil     )
    (#x002fb1 "KANGXI RADICAL TANNED LEATHER"          nil     )
    (#x002fb2 "KANGXI RADICAL LEEK"                    nil     )
    (#x002fb3 "KANGXI RADICAL SOUND"                   nil     )
    (#x002fb4 "KANGXI RADICAL LEAF"                    nil     )
    (#x002fb5 "KANGXI RADICAL WIND"                    nil     )
    (#x002fb6 "KANGXI RADICAL FLY"                     nil     )
    (#x002fb7 "KANGXI RADICAL EAT"                     nil     )
    (#x002fb8 "KANGXI RADICAL HEAD"                    nil     )
    (#x002fb9 "KANGXI RADICAL FRAGRANT"                nil     )
    (#x002fba "KANGXI RADICAL HORSE"                   nil     )
    (#x002fbb "KANGXI RADICAL BONE"                    nil     )
    (#x002fbc "KANGXI RADICAL TALL"                    nil     )
    (#x002fbd "KANGXI RADICAL HAIR"                    nil     )
    (#x002fbe "KANGXI RADICAL FIGHT"                   nil     )
    (#x002fbf "KANGXI RADICAL SACRIFICIAL WINE"        nil     )
    (#x002fc0 "KANGXI RADICAL CAULDRON"                nil     )
    (#x002fc1 "KANGXI RADICAL GHOST"                   nil     )
    (#x002fc2 "KANGXI RADICAL FISH"                    nil     )
    (#x002fc3 "KANGXI RADICAL BIRD"                    nil     )
    (#x002fc4 "KANGXI RADICAL SALT"                    nil     )
    (#x002fc5 "KANGXI RADICAL DEER"                    nil     )
    (#x002fc6 "KANGXI RADICAL WHEAT"                   nil     )
    (#x002fc7 "KANGXI RADICAL HEMP"                    nil     )
    (#x002fc8 "KANGXI RADICAL YELLOW"                  nil     )
    (#x002fc9 "KANGXI RADICAL MILLET"                  nil     )
    (#x002fca "KANGXI RADICAL BLACK"                   nil     )
    (#x002fcb "KANGXI RADICAL EMBROIDERY"              nil     )
    (#x002fcc "KANGXI RADICAL FROG"                    nil     )
    (#x002fcd "KANGXI RADICAL TRIPOD"                  nil     )
    (#x002fce "KANGXI RADICAL DRUM"                    nil     )
    (#x002fcf "KANGXI RADICAL RAT"                     nil     )
    (#x002fd0 "KANGXI RADICAL NOSE"                    nil     )
    (#x002fd1 "KANGXI RADICAL EVEN"                    nil     )
    (#x002fd2 "KANGXI RADICAL TOOTH"                   nil     )
    (#x002fd3 "KANGXI RADICAL DRAGON"                  nil     )
    (#x002fd4 "KANGXI RADICAL TURTLE"                  nil     )
    (#x002fd5 "KANGXI RADICAL FLUTE"                   nil     )
    (#x002ff0 "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT" nil     )
    (#x002ff1 "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW" nil     )
    (#x002ff2 "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT" nil     )
    (#x002ff3 "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW" nil     )
    (#x002ff4 "IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND" nil     )
    (#x002ff5 "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE" nil     )
    (#x002ff6 "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW" nil     )
    (#x002ff7 "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT" nil     )
    (#x002ff8 "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT" nil     )
    (#x002ff9 "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT" nil     )
    (#x002ffa "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT" nil     )
    (#x002ffb "IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID" nil     )
    (#x003000 "IDEOGRAPHIC SPACE"                      nil     )
    (#x003001 "IDEOGRAPHIC COMMA"                      nil     )
    (#x003002 "IDEOGRAPHIC FULL STOP"                  nil     )
    (#x003003 "DITTO MARK"                             nil     )
    (#x003004 "JAPANESE INDUSTRIAL STANDARD SYMBOL"    nil     )
    (#x003005 "IDEOGRAPHIC ITERATION MARK"             nil     )
    (#x003006 "IDEOGRAPHIC CLOSING MARK"               nil     )
    (#x003007 "IDEOGRAPHIC NUMBER ZERO"                nil     )
    (#x003008 "LEFT ANGLE BRACKET"                     nil     )
    (#x003009 "RIGHT ANGLE BRACKET"                    nil     )
    (#x00300a "LEFT DOUBLE ANGLE BRACKET"              nil     )
    (#x00300b "RIGHT DOUBLE ANGLE BRACKET"             nil     )
    (#x00300c "LEFT CORNER BRACKET"                    nil     )
    (#x00300d "RIGHT CORNER BRACKET"                   nil     )
    (#x00300e "LEFT WHITE CORNER BRACKET"              nil     )
    (#x00300f "RIGHT WHITE CORNER BRACKET"             nil     )
    (#x003010 "LEFT BLACK LENTICULAR BRACKET"          nil     )
    (#x003011 "RIGHT BLACK LENTICULAR BRACKET"         nil     )
    (#x003012 "POSTAL MARK"                            nil     )
    (#x003013 "GETA MARK"                              nil     )
    (#x003014 "LEFT TORTOISE SHELL BRACKET"            nil     )
    (#x003015 "RIGHT TORTOISE SHELL BRACKET"           nil     )
    (#x003016 "LEFT WHITE LENTICULAR BRACKET"          nil     )
    (#x003017 "RIGHT WHITE LENTICULAR BRACKET"         nil     )
    (#x003018 "LEFT WHITE TORTOISE SHELL BRACKET"      nil     )
    (#x003019 "RIGHT WHITE TORTOISE SHELL BRACKET"     nil     )
    (#x00301a "LEFT WHITE SQUARE BRACKET"              nil     )
    (#x00301b "RIGHT WHITE SQUARE BRACKET"             nil     )
    (#x00301c "WAVE DASH"                              nil     )
    (#x00301d "REVERSED DOUBLE PRIME QUOTATION MARK"   nil     )
    (#x00301e "DOUBLE PRIME QUOTATION MARK"            nil     )
    (#x00301f "LOW DOUBLE PRIME QUOTATION MARK"        nil     )
    (#x003020 "POSTAL MARK FACE"                       nil     )
    (#x003021 "HANGZHOU NUMERAL ONE"                   nil     )
    (#x003022 "HANGZHOU NUMERAL TWO"                   nil     )
    (#x003023 "HANGZHOU NUMERAL THREE"                 nil     )
    (#x003024 "HANGZHOU NUMERAL FOUR"                  nil     )
    (#x003025 "HANGZHOU NUMERAL FIVE"                  nil     )
    (#x003026 "HANGZHOU NUMERAL SIX"                   nil     )
    (#x003027 "HANGZHOU NUMERAL SEVEN"                 nil     )
    (#x003028 "HANGZHOU NUMERAL EIGHT"                 nil     )
    (#x003029 "HANGZHOU NUMERAL NINE"                  nil     )
    (#x00302a "IDEOGRAPHIC LEVEL TONE MARK"            nil     )
    (#x00302b "IDEOGRAPHIC RISING TONE MARK"           nil     )
    (#x00302c "IDEOGRAPHIC DEPARTING TONE MARK"        nil     )
    (#x00302d "IDEOGRAPHIC ENTERING TONE MARK"         nil     )
    (#x00302e "HANGUL SINGLE DOT TONE MARK"            nil     )
    (#x00302f "HANGUL DOUBLE DOT TONE MARK"            nil     )
    (#x003030 "WAVY DASH"                              nil     )
    (#x003031 "VERTICAL KANA REPEAT MARK"              nil     )
    (#x003032 "VERTICAL KANA REPEAT WITH VOICED SOUND MARK" nil     )
    (#x003033 "VERTICAL KANA REPEAT MARK UPPER HALF"   nil     )
    (#x003034 "VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF" nil     )
    (#x003035 "VERTICAL KANA REPEAT MARK LOWER HALF"   nil     )
    (#x003036 "CIRCLED POSTAL MARK"                    nil     )
    (#x003037 "IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL" nil     )
    (#x003038 "HANGZHOU NUMERAL TEN"                   nil     )
    (#x003039 "HANGZHOU NUMERAL TWENTY"                nil     )
    (#x00303a "HANGZHOU NUMERAL THIRTY"                nil     )
    (#x00303b "VERTICAL IDEOGRAPHIC ITERATION MARK"    nil     )
    (#x00303c "MASU MARK"                              nil     )
    (#x00303d "PART ALTERNATION MARK"                  nil     )
    (#x00303e "IDEOGRAPHIC VARIATION INDICATOR"        nil     )
    (#x00303f "IDEOGRAPHIC HALF FILL SPACE"            nil     )
    (#x003041 "HIRAGANA LETTER SMALL A"                nil     )
    (#x003042 "HIRAGANA LETTER A"                      nil     )
    (#x003043 "HIRAGANA LETTER SMALL I"                nil     )
    (#x003044 "HIRAGANA LETTER I"                      nil     )
    (#x003045 "HIRAGANA LETTER SMALL U"                nil     )
    (#x003046 "HIRAGANA LETTER U"                      nil     )
    (#x003047 "HIRAGANA LETTER SMALL E"                nil     )
    (#x003048 "HIRAGANA LETTER E"                      nil     )
    (#x003049 "HIRAGANA LETTER SMALL O"                nil     )
    (#x00304a "HIRAGANA LETTER O"                      nil     )
    (#x00304b "HIRAGANA LETTER KA"                     nil     )
    (#x00304c "HIRAGANA LETTER GA"                     nil     )
    (#x00304d "HIRAGANA LETTER KI"                     nil     )
    (#x00304e "HIRAGANA LETTER GI"                     nil     )
    (#x00304f "HIRAGANA LETTER KU"                     nil     )
    (#x003050 "HIRAGANA LETTER GU"                     nil     )
    (#x003051 "HIRAGANA LETTER KE"                     nil     )
    (#x003052 "HIRAGANA LETTER GE"                     nil     )
    (#x003053 "HIRAGANA LETTER KO"                     nil     )
    (#x003054 "HIRAGANA LETTER GO"                     nil     )
    (#x003055 "HIRAGANA LETTER SA"                     nil     )
    (#x003056 "HIRAGANA LETTER ZA"                     nil     )
    (#x003057 "HIRAGANA LETTER SI"                     nil     )
    (#x003058 "HIRAGANA LETTER ZI"                     nil     )
    (#x003059 "HIRAGANA LETTER SU"                     nil     )
    (#x00305a "HIRAGANA LETTER ZU"                     nil     )
    (#x00305b "HIRAGANA LETTER SE"                     nil     )
    (#x00305c "HIRAGANA LETTER ZE"                     nil     )
    (#x00305d "HIRAGANA LETTER SO"                     nil     )
    (#x00305e "HIRAGANA LETTER ZO"                     nil     )
    (#x00305f "HIRAGANA LETTER TA"                     nil     )
    (#x003060 "HIRAGANA LETTER DA"                     nil     )
    (#x003061 "HIRAGANA LETTER TI"                     nil     )
    (#x003062 "HIRAGANA LETTER DI"                     nil     )
    (#x003063 "HIRAGANA LETTER SMALL TU"               nil     )
    (#x003064 "HIRAGANA LETTER TU"                     nil     )
    (#x003065 "HIRAGANA LETTER DU"                     nil     )
    (#x003066 "HIRAGANA LETTER TE"                     nil     )
    (#x003067 "HIRAGANA LETTER DE"                     nil     )
    (#x003068 "HIRAGANA LETTER TO"                     nil     )
    (#x003069 "HIRAGANA LETTER DO"                     nil     )
    (#x00306a "HIRAGANA LETTER NA"                     nil     )
    (#x00306b "HIRAGANA LETTER NI"                     nil     )
    (#x00306c "HIRAGANA LETTER NU"                     nil     )
    (#x00306d "HIRAGANA LETTER NE"                     nil     )
    (#x00306e "HIRAGANA LETTER NO"                     nil     )
    (#x00306f "HIRAGANA LETTER HA"                     nil     )
    (#x003070 "HIRAGANA LETTER BA"                     nil     )
    (#x003071 "HIRAGANA LETTER PA"                     nil     )
    (#x003072 "HIRAGANA LETTER HI"                     nil     )
    (#x003073 "HIRAGANA LETTER BI"                     nil     )
    (#x003074 "HIRAGANA LETTER PI"                     nil     )
    (#x003075 "HIRAGANA LETTER HU"                     nil     )
    (#x003076 "HIRAGANA LETTER BU"                     nil     )
    (#x003077 "HIRAGANA LETTER PU"                     nil     )
    (#x003078 "HIRAGANA LETTER HE"                     nil     )
    (#x003079 "HIRAGANA LETTER BE"                     nil     )
    (#x00307a "HIRAGANA LETTER PE"                     nil     )
    (#x00307b "HIRAGANA LETTER HO"                     nil     )
    (#x00307c "HIRAGANA LETTER BO"                     nil     )
    (#x00307d "HIRAGANA LETTER PO"                     nil     )
    (#x00307e "HIRAGANA LETTER MA"                     nil     )
    (#x00307f "HIRAGANA LETTER MI"                     nil     )
    (#x003080 "HIRAGANA LETTER MU"                     nil     )
    (#x003081 "HIRAGANA LETTER ME"                     nil     )
    (#x003082 "HIRAGANA LETTER MO"                     nil     )
    (#x003083 "HIRAGANA LETTER SMALL YA"               nil     )
    (#x003084 "HIRAGANA LETTER YA"                     nil     )
    (#x003085 "HIRAGANA LETTER SMALL YU"               nil     )
    (#x003086 "HIRAGANA LETTER YU"                     nil     )
    (#x003087 "HIRAGANA LETTER SMALL YO"               nil     )
    (#x003088 "HIRAGANA LETTER YO"                     nil     )
    (#x003089 "HIRAGANA LETTER RA"                     nil     )
    (#x00308a "HIRAGANA LETTER RI"                     nil     )
    (#x00308b "HIRAGANA LETTER RU"                     nil     )
    (#x00308c "HIRAGANA LETTER RE"                     nil     )
    (#x00308d "HIRAGANA LETTER RO"                     nil     )
    (#x00308e "HIRAGANA LETTER SMALL WA"               nil     )
    (#x00308f "HIRAGANA LETTER WA"                     nil     )
    (#x003090 "HIRAGANA LETTER WI"                     nil     )
    (#x003091 "HIRAGANA LETTER WE"                     nil     )
    (#x003092 "HIRAGANA LETTER WO"                     nil     )
    (#x003093 "HIRAGANA LETTER N"                      nil     )
    (#x003094 "HIRAGANA LETTER VU"                     nil     )
    (#x003095 "HIRAGANA LETTER SMALL KA"               nil     )
    (#x003096 "HIRAGANA LETTER SMALL KE"               nil     )
    (#x003099 "COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK" nil     )
    (#x00309a "COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" nil     )
    (#x00309b "KATAKANA-HIRAGANA VOICED SOUND MARK"    nil     )
    (#x00309c "KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" nil     )
    (#x00309d "HIRAGANA ITERATION MARK"                nil     )
    (#x00309e "HIRAGANA VOICED ITERATION MARK"         nil     )
    (#x00309f "HIRAGANA DIGRAPH YORI"                  nil     )
    (#x0030a0 "KATAKANA-HIRAGANA DOUBLE HYPHEN"        nil     )
    (#x0030a1 "KATAKANA LETTER SMALL A"                nil     )
    (#x0030a2 "KATAKANA LETTER A"                      nil     )
    (#x0030a3 "KATAKANA LETTER SMALL I"                nil     )
    (#x0030a4 "KATAKANA LETTER I"                      nil     )
    (#x0030a5 "KATAKANA LETTER SMALL U"                nil     )
    (#x0030a6 "KATAKANA LETTER U"                      nil     )
    (#x0030a7 "KATAKANA LETTER SMALL E"                nil     )
    (#x0030a8 "KATAKANA LETTER E"                      nil     )
    (#x0030a9 "KATAKANA LETTER SMALL O"                nil     )
    (#x0030aa "KATAKANA LETTER O"                      nil     )
    (#x0030ab "KATAKANA LETTER KA"                     nil     )
    (#x0030ac "KATAKANA LETTER GA"                     nil     )
    (#x0030ad "KATAKANA LETTER KI"                     nil     )
    (#x0030ae "KATAKANA LETTER GI"                     nil     )
    (#x0030af "KATAKANA LETTER KU"                     nil     )
    (#x0030b0 "KATAKANA LETTER GU"                     nil     )
    (#x0030b1 "KATAKANA LETTER KE"                     nil     )
    (#x0030b2 "KATAKANA LETTER GE"                     nil     )
    (#x0030b3 "KATAKANA LETTER KO"                     nil     )
    (#x0030b4 "KATAKANA LETTER GO"                     nil     )
    (#x0030b5 "KATAKANA LETTER SA"                     nil     )
    (#x0030b6 "KATAKANA LETTER ZA"                     nil     )
    (#x0030b7 "KATAKANA LETTER SI"                     nil     )
    (#x0030b8 "KATAKANA LETTER ZI"                     nil     )
    (#x0030b9 "KATAKANA LETTER SU"                     nil     )
    (#x0030ba "KATAKANA LETTER ZU"                     nil     )
    (#x0030bb "KATAKANA LETTER SE"                     nil     )
    (#x0030bc "KATAKANA LETTER ZE"                     nil     )
    (#x0030bd "KATAKANA LETTER SO"                     nil     )
    (#x0030be "KATAKANA LETTER ZO"                     nil     )
    (#x0030bf "KATAKANA LETTER TA"                     nil     )
    (#x0030c0 "KATAKANA LETTER DA"                     nil     )
    (#x0030c1 "KATAKANA LETTER TI"                     nil     )
    (#x0030c2 "KATAKANA LETTER DI"                     nil     )
    (#x0030c3 "KATAKANA LETTER SMALL TU"               nil     )
    (#x0030c4 "KATAKANA LETTER TU"                     nil     )
    (#x0030c5 "KATAKANA LETTER DU"                     nil     )
    (#x0030c6 "KATAKANA LETTER TE"                     nil     )
    (#x0030c7 "KATAKANA LETTER DE"                     nil     )
    (#x0030c8 "KATAKANA LETTER TO"                     nil     )
    (#x0030c9 "KATAKANA LETTER DO"                     nil     )
    (#x0030ca "KATAKANA LETTER NA"                     nil     )
    (#x0030cb "KATAKANA LETTER NI"                     nil     )
    (#x0030cc "KATAKANA LETTER NU"                     nil     )
    (#x0030cd "KATAKANA LETTER NE"                     nil     )
    (#x0030ce "KATAKANA LETTER NO"                     nil     )
    (#x0030cf "KATAKANA LETTER HA"                     nil     )
    (#x0030d0 "KATAKANA LETTER BA"                     nil     )
    (#x0030d1 "KATAKANA LETTER PA"                     nil     )
    (#x0030d2 "KATAKANA LETTER HI"                     nil     )
    (#x0030d3 "KATAKANA LETTER BI"                     nil     )
    (#x0030d4 "KATAKANA LETTER PI"                     nil     )
    (#x0030d5 "KATAKANA LETTER HU"                     nil     )
    (#x0030d6 "KATAKANA LETTER BU"                     nil     )
    (#x0030d7 "KATAKANA LETTER PU"                     nil     )
    (#x0030d8 "KATAKANA LETTER HE"                     nil     )
    (#x0030d9 "KATAKANA LETTER BE"                     nil     )
    (#x0030da "KATAKANA LETTER PE"                     nil     )
    (#x0030db "KATAKANA LETTER HO"                     nil     )
    (#x0030dc "KATAKANA LETTER BO"                     nil     )
    (#x0030dd "KATAKANA LETTER PO"                     nil     )
    (#x0030de "KATAKANA LETTER MA"                     nil     )
    (#x0030df "KATAKANA LETTER MI"                     nil     )
    (#x0030e0 "KATAKANA LETTER MU"                     nil     )
    (#x0030e1 "KATAKANA LETTER ME"                     nil     )
    (#x0030e2 "KATAKANA LETTER MO"                     nil     )
    (#x0030e3 "KATAKANA LETTER SMALL YA"               nil     )
    (#x0030e4 "KATAKANA LETTER YA"                     nil     )
    (#x0030e5 "KATAKANA LETTER SMALL YU"               nil     )
    (#x0030e6 "KATAKANA LETTER YU"                     nil     )
    (#x0030e7 "KATAKANA LETTER SMALL YO"               nil     )
    (#x0030e8 "KATAKANA LETTER YO"                     nil     )
    (#x0030e9 "KATAKANA LETTER RA"                     nil     )
    (#x0030ea "KATAKANA LETTER RI"                     nil     )
    (#x0030eb "KATAKANA LETTER RU"                     nil     )
    (#x0030ec "KATAKANA LETTER RE"                     nil     )
    (#x0030ed "KATAKANA LETTER RO"                     nil     )
    (#x0030ee "KATAKANA LETTER SMALL WA"               nil     )
    (#x0030ef "KATAKANA LETTER WA"                     nil     )
    (#x0030f0 "KATAKANA LETTER WI"                     nil     )
    (#x0030f1 "KATAKANA LETTER WE"                     nil     )
    (#x0030f2 "KATAKANA LETTER WO"                     nil     )
    (#x0030f3 "KATAKANA LETTER N"                      nil     )
    (#x0030f4 "KATAKANA LETTER VU"                     nil     )
    (#x0030f5 "KATAKANA LETTER SMALL KA"               nil     )
    (#x0030f6 "KATAKANA LETTER SMALL KE"               nil     )
    (#x0030f7 "KATAKANA LETTER VA"                     nil     )
    (#x0030f8 "KATAKANA LETTER VI"                     nil     )
    (#x0030f9 "KATAKANA LETTER VE"                     nil     )
    (#x0030fa "KATAKANA LETTER VO"                     nil     )
    (#x0030fb "KATAKANA MIDDLE DOT"                    nil     )
    (#x0030fc "KATAKANA-HIRAGANA PROLONGED SOUND MARK" nil     )
    (#x0030fd "KATAKANA ITERATION MARK"                nil     )
    (#x0030fe "KATAKANA VOICED ITERATION MARK"         nil     )
    (#x0030ff "KATAKANA DIGRAPH KOTO"                  nil     )
    (#x003105 "BOPOMOFO LETTER B"                      nil     )
    (#x003106 "BOPOMOFO LETTER P"                      nil     )
    (#x003107 "BOPOMOFO LETTER M"                      nil     )
    (#x003108 "BOPOMOFO LETTER F"                      nil     )
    (#x003109 "BOPOMOFO LETTER D"                      nil     )
    (#x00310a "BOPOMOFO LETTER T"                      nil     )
    (#x00310b "BOPOMOFO LETTER N"                      nil     )
    (#x00310c "BOPOMOFO LETTER L"                      nil     )
    (#x00310d "BOPOMOFO LETTER G"                      nil     )
    (#x00310e "BOPOMOFO LETTER K"                      nil     )
    (#x00310f "BOPOMOFO LETTER H"                      nil     )
    (#x003110 "BOPOMOFO LETTER J"                      nil     )
    (#x003111 "BOPOMOFO LETTER Q"                      nil     )
    (#x003112 "BOPOMOFO LETTER X"                      nil     )
    (#x003113 "BOPOMOFO LETTER ZH"                     nil     )
    (#x003114 "BOPOMOFO LETTER CH"                     nil     )
    (#x003115 "BOPOMOFO LETTER SH"                     nil     )
    (#x003116 "BOPOMOFO LETTER R"                      nil     )
    (#x003117 "BOPOMOFO LETTER Z"                      nil     )
    (#x003118 "BOPOMOFO LETTER C"                      nil     )
    (#x003119 "BOPOMOFO LETTER S"                      nil     )
    (#x00311a "BOPOMOFO LETTER A"                      nil     )
    (#x00311b "BOPOMOFO LETTER O"                      nil     )
    (#x00311c "BOPOMOFO LETTER E"                      nil     )
    (#x00311d "BOPOMOFO LETTER EH"                     nil     )
    (#x00311e "BOPOMOFO LETTER AI"                     nil     )
    (#x00311f "BOPOMOFO LETTER EI"                     nil     )
    (#x003120 "BOPOMOFO LETTER AU"                     nil     )
    (#x003121 "BOPOMOFO LETTER OU"                     nil     )
    (#x003122 "BOPOMOFO LETTER AN"                     nil     )
    (#x003123 "BOPOMOFO LETTER EN"                     nil     )
    (#x003124 "BOPOMOFO LETTER ANG"                    nil     )
    (#x003125 "BOPOMOFO LETTER ENG"                    nil     )
    (#x003126 "BOPOMOFO LETTER ER"                     nil     )
    (#x003127 "BOPOMOFO LETTER I"                      nil     )
    (#x003128 "BOPOMOFO LETTER U"                      nil     )
    (#x003129 "BOPOMOFO LETTER IU"                     nil     )
    (#x00312a "BOPOMOFO LETTER V"                      nil     )
    (#x00312b "BOPOMOFO LETTER NG"                     nil     )
    (#x00312c "BOPOMOFO LETTER GN"                     nil     )
    (#x00312d "BOPOMOFO LETTER IH"                     nil     )
    (#x00312e "BOPOMOFO LETTER O WITH DOT ABOVE"       nil     )
    (#x00312f "BOPOMOFO LETTER NN"                     nil     )
    (#x003131 "HANGUL LETTER KIYEOK"                   nil     )
    (#x003132 "HANGUL LETTER SSANGKIYEOK"              nil     )
    (#x003133 "HANGUL LETTER KIYEOK-SIOS"              nil     )
    (#x003134 "HANGUL LETTER NIEUN"                    nil     )
    (#x003135 "HANGUL LETTER NIEUN-CIEUC"              nil     )
    (#x003136 "HANGUL LETTER NIEUN-HIEUH"              nil     )
    (#x003137 "HANGUL LETTER TIKEUT"                   nil     )
    (#x003138 "HANGUL LETTER SSANGTIKEUT"              nil     )
    (#x003139 "HANGUL LETTER RIEUL"                    nil     )
    (#x00313a "HANGUL LETTER RIEUL-KIYEOK"             nil     )
    (#x00313b "HANGUL LETTER RIEUL-MIEUM"              nil     )
    (#x00313c "HANGUL LETTER RIEUL-PIEUP"              nil     )
    (#x00313d "HANGUL LETTER RIEUL-SIOS"               nil     )
    (#x00313e "HANGUL LETTER RIEUL-THIEUTH"            nil     )
    (#x00313f "HANGUL LETTER RIEUL-PHIEUPH"            nil     )
    (#x003140 "HANGUL LETTER RIEUL-HIEUH"              nil     )
    (#x003141 "HANGUL LETTER MIEUM"                    nil     )
    (#x003142 "HANGUL LETTER PIEUP"                    nil     )
    (#x003143 "HANGUL LETTER SSANGPIEUP"               nil     )
    (#x003144 "HANGUL LETTER PIEUP-SIOS"               nil     )
    (#x003145 "HANGUL LETTER SIOS"                     nil     )
    (#x003146 "HANGUL LETTER SSANGSIOS"                nil     )
    (#x003147 "HANGUL LETTER IEUNG"                    nil     )
    (#x003148 "HANGUL LETTER CIEUC"                    nil     )
    (#x003149 "HANGUL LETTER SSANGCIEUC"               nil     )
    (#x00314a "HANGUL LETTER CHIEUCH"                  nil     )
    (#x00314b "HANGUL LETTER KHIEUKH"                  nil     )
    (#x00314c "HANGUL LETTER THIEUTH"                  nil     )
    (#x00314d "HANGUL LETTER PHIEUPH"                  nil     )
    (#x00314e "HANGUL LETTER HIEUH"                    nil     )
    (#x00314f "HANGUL LETTER A"                        nil     )
    (#x003150 "HANGUL LETTER AE"                       nil     )
    (#x003151 "HANGUL LETTER YA"                       nil     )
    (#x003152 "HANGUL LETTER YAE"                      nil     )
    (#x003153 "HANGUL LETTER EO"                       nil     )
    (#x003154 "HANGUL LETTER E"                        nil     )
    (#x003155 "HANGUL LETTER YEO"                      nil     )
    (#x003156 "HANGUL LETTER YE"                       nil     )
    (#x003157 "HANGUL LETTER O"                        nil     )
    (#x003158 "HANGUL LETTER WA"                       nil     )
    (#x003159 "HANGUL LETTER WAE"                      nil     )
    (#x00315a "HANGUL LETTER OE"                       nil     )
    (#x00315b "HANGUL LETTER YO"                       nil     )
    (#x00315c "HANGUL LETTER U"                        nil     )
    (#x00315d "HANGUL LETTER WEO"                      nil     )
    (#x00315e "HANGUL LETTER WE"                       nil     )
    (#x00315f "HANGUL LETTER WI"                       nil     )
    (#x003160 "HANGUL LETTER YU"                       nil     )
    (#x003161 "HANGUL LETTER EU"                       nil     )
    (#x003162 "HANGUL LETTER YI"                       nil     )
    (#x003163 "HANGUL LETTER I"                        nil     )
    (#x003164 "HANGUL FILLER"                          nil     )
    (#x003165 "HANGUL LETTER SSANGNIEUN"               nil     )
    (#x003166 "HANGUL LETTER NIEUN-TIKEUT"             nil     )
    (#x003167 "HANGUL LETTER NIEUN-SIOS"               nil     )
    (#x003168 "HANGUL LETTER NIEUN-PANSIOS"            nil     )
    (#x003169 "HANGUL LETTER RIEUL-KIYEOK-SIOS"        nil     )
    (#x00316a "HANGUL LETTER RIEUL-TIKEUT"             nil     )
    (#x00316b "HANGUL LETTER RIEUL-PIEUP-SIOS"         nil     )
    (#x00316c "HANGUL LETTER RIEUL-PANSIOS"            nil     )
    (#x00316d "HANGUL LETTER RIEUL-YEORINHIEUH"        nil     )
    (#x00316e "HANGUL LETTER MIEUM-PIEUP"              nil     )
    (#x00316f "HANGUL LETTER MIEUM-SIOS"               nil     )
    (#x003170 "HANGUL LETTER MIEUM-PANSIOS"            nil     )
    (#x003171 "HANGUL LETTER KAPYEOUNMIEUM"            nil     )
    (#x003172 "HANGUL LETTER PIEUP-KIYEOK"             nil     )
    (#x003173 "HANGUL LETTER PIEUP-TIKEUT"             nil     )
    (#x003174 "HANGUL LETTER PIEUP-SIOS-KIYEOK"        nil     )
    (#x003175 "HANGUL LETTER PIEUP-SIOS-TIKEUT"        nil     )
    (#x003176 "HANGUL LETTER PIEUP-CIEUC"              nil     )
    (#x003177 "HANGUL LETTER PIEUP-THIEUTH"            nil     )
    (#x003178 "HANGUL LETTER KAPYEOUNPIEUP"            nil     )
    (#x003179 "HANGUL LETTER KAPYEOUNSSANGPIEUP"       nil     )
    (#x00317a "HANGUL LETTER SIOS-KIYEOK"              nil     )
    (#x00317b "HANGUL LETTER SIOS-NIEUN"               nil     )
    (#x00317c "HANGUL LETTER SIOS-TIKEUT"              nil     )
    (#x00317d "HANGUL LETTER SIOS-PIEUP"               nil     )
    (#x00317e "HANGUL LETTER SIOS-CIEUC"               nil     )
    (#x00317f "HANGUL LETTER PANSIOS"                  nil     )
    (#x003180 "HANGUL LETTER SSANGIEUNG"               nil     )
    (#x003181 "HANGUL LETTER YESIEUNG"                 nil     )
    (#x003182 "HANGUL LETTER YESIEUNG-SIOS"            nil     )
    (#x003183 "HANGUL LETTER YESIEUNG-PANSIOS"         nil     )
    (#x003184 "HANGUL LETTER KAPYEOUNPHIEUPH"          nil     )
    (#x003185 "HANGUL LETTER SSANGHIEUH"               nil     )
    (#x003186 "HANGUL LETTER YEORINHIEUH"              nil     )
    (#x003187 "HANGUL LETTER YO-YA"                    nil     )
    (#x003188 "HANGUL LETTER YO-YAE"                   nil     )
    (#x003189 "HANGUL LETTER YO-I"                     nil     )
    (#x00318a "HANGUL LETTER YU-YEO"                   nil     )
    (#x00318b "HANGUL LETTER YU-YE"                    nil     )
    (#x00318c "HANGUL LETTER YU-I"                     nil     )
    (#x00318d "HANGUL LETTER ARAEA"                    nil     )
    (#x00318e "HANGUL LETTER ARAEAE"                   nil     )
    (#x003190 "IDEOGRAPHIC ANNOTATION LINKING MARK"    nil     )
    (#x003191 "IDEOGRAPHIC ANNOTATION REVERSE MARK"    nil     )
    (#x003192 "IDEOGRAPHIC ANNOTATION ONE MARK"        nil     )
    (#x003193 "IDEOGRAPHIC ANNOTATION TWO MARK"        nil     )
    (#x003194 "IDEOGRAPHIC ANNOTATION THREE MARK"      nil     )
    (#x003195 "IDEOGRAPHIC ANNOTATION FOUR MARK"       nil     )
    (#x003196 "IDEOGRAPHIC ANNOTATION TOP MARK"        nil     )
    (#x003197 "IDEOGRAPHIC ANNOTATION MIDDLE MARK"     nil     )
    (#x003198 "IDEOGRAPHIC ANNOTATION BOTTOM MARK"     nil     )
    (#x003199 "IDEOGRAPHIC ANNOTATION FIRST MARK"      nil     )
    (#x00319a "IDEOGRAPHIC ANNOTATION SECOND MARK"     nil     )
    (#x00319b "IDEOGRAPHIC ANNOTATION THIRD MARK"      nil     )
    (#x00319c "IDEOGRAPHIC ANNOTATION FOURTH MARK"     nil     )
    (#x00319d "IDEOGRAPHIC ANNOTATION HEAVEN MARK"     nil     )
    (#x00319e "IDEOGRAPHIC ANNOTATION EARTH MARK"      nil     )
    (#x00319f "IDEOGRAPHIC ANNOTATION MAN MARK"        nil     )
    (#x0031a0 "BOPOMOFO LETTER BU"                     nil     )
    (#x0031a1 "BOPOMOFO LETTER ZI"                     nil     )
    (#x0031a2 "BOPOMOFO LETTER JI"                     nil     )
    (#x0031a3 "BOPOMOFO LETTER GU"                     nil     )
    (#x0031a4 "BOPOMOFO LETTER EE"                     nil     )
    (#x0031a5 "BOPOMOFO LETTER ENN"                    nil     )
    (#x0031a6 "BOPOMOFO LETTER OO"                     nil     )
    (#x0031a7 "BOPOMOFO LETTER ONN"                    nil     )
    (#x0031a8 "BOPOMOFO LETTER IR"                     nil     )
    (#x0031a9 "BOPOMOFO LETTER ANN"                    nil     )
    (#x0031aa "BOPOMOFO LETTER INN"                    nil     )
    (#x0031ab "BOPOMOFO LETTER UNN"                    nil     )
    (#x0031ac "BOPOMOFO LETTER IM"                     nil     )
    (#x0031ad "BOPOMOFO LETTER NGG"                    nil     )
    (#x0031ae "BOPOMOFO LETTER AINN"                   nil     )
    (#x0031af "BOPOMOFO LETTER AUNN"                   nil     )
    (#x0031b0 "BOPOMOFO LETTER AM"                     nil     )
    (#x0031b1 "BOPOMOFO LETTER OM"                     nil     )
    (#x0031b2 "BOPOMOFO LETTER ONG"                    nil     )
    (#x0031b3 "BOPOMOFO LETTER INNN"                   nil     )
    (#x0031b4 "BOPOMOFO FINAL LETTER P"                nil     )
    (#x0031b5 "BOPOMOFO FINAL LETTER T"                nil     )
    (#x0031b6 "BOPOMOFO FINAL LETTER K"                nil     )
    (#x0031b7 "BOPOMOFO FINAL LETTER H"                nil     )
    (#x0031b8 "BOPOMOFO LETTER GH"                     nil     )
    (#x0031b9 "BOPOMOFO LETTER LH"                     nil     )
    (#x0031ba "BOPOMOFO LETTER ZY"                     nil     )
    (#x0031bb "BOPOMOFO FINAL LETTER G"                nil     )
    (#x0031bc "BOPOMOFO LETTER GW"                     nil     )
    (#x0031bd "BOPOMOFO LETTER KW"                     nil     )
    (#x0031be "BOPOMOFO LETTER OE"                     nil     )
    (#x0031bf "BOPOMOFO LETTER AH"                     nil     )
    (#x0031c0 "CJK STROKE T"                           nil     )
    (#x0031c1 "CJK STROKE WG"                          nil     )
    (#x0031c2 "CJK STROKE XG"                          nil     )
    (#x0031c3 "CJK STROKE BXG"                         nil     )
    (#x0031c4 "CJK STROKE SW"                          nil     )
    (#x0031c5 "CJK STROKE HZZ"                         nil     )
    (#x0031c6 "CJK STROKE HZG"                         nil     )
    (#x0031c7 "CJK STROKE HP"                          nil     )
    (#x0031c8 "CJK STROKE HZWG"                        nil     )
    (#x0031c9 "CJK STROKE SZWG"                        nil     )
    (#x0031ca "CJK STROKE HZT"                         nil     )
    (#x0031cb "CJK STROKE HZZP"                        nil     )
    (#x0031cc "CJK STROKE HPWG"                        nil     )
    (#x0031cd "CJK STROKE HZW"                         nil     )
    (#x0031ce "CJK STROKE HZZZ"                        nil     )
    (#x0031cf "CJK STROKE N"                           nil     )
    (#x0031d0 "CJK STROKE H"                           nil     )
    (#x0031d1 "CJK STROKE S"                           nil     )
    (#x0031d2 "CJK STROKE P"                           nil     )
    (#x0031d3 "CJK STROKE SP"                          nil     )
    (#x0031d4 "CJK STROKE D"                           nil     )
    (#x0031d5 "CJK STROKE HZ"                          nil     )
    (#x0031d6 "CJK STROKE HG"                          nil     )
    (#x0031d7 "CJK STROKE SZ"                          nil     )
    (#x0031d8 "CJK STROKE SWZ"                         nil     )
    (#x0031d9 "CJK STROKE ST"                          nil     )
    (#x0031da "CJK STROKE SG"                          nil     )
    (#x0031db "CJK STROKE PD"                          nil     )
    (#x0031dc "CJK STROKE PZ"                          nil     )
    (#x0031dd "CJK STROKE TN"                          nil     )
    (#x0031de "CJK STROKE SZZ"                         nil     )
    (#x0031df "CJK STROKE SWG"                         nil     )
    (#x0031e0 "CJK STROKE HXWG"                        nil     )
    (#x0031e1 "CJK STROKE HZZZG"                       nil     )
    (#x0031e2 "CJK STROKE PG"                          nil     )
    (#x0031e3 "CJK STROKE Q"                           nil     )
    (#x0031f0 "KATAKANA LETTER SMALL KU"               nil     )
    (#x0031f1 "KATAKANA LETTER SMALL SI"               nil     )
    (#x0031f2 "KATAKANA LETTER SMALL SU"               nil     )
    (#x0031f3 "KATAKANA LETTER SMALL TO"               nil     )
    (#x0031f4 "KATAKANA LETTER SMALL NU"               nil     )
    (#x0031f5 "KATAKANA LETTER SMALL HA"               nil     )
    (#x0031f6 "KATAKANA LETTER SMALL HI"               nil     )
    (#x0031f7 "KATAKANA LETTER SMALL HU"               nil     )
    (#x0031f8 "KATAKANA LETTER SMALL HE"               nil     )
    (#x0031f9 "KATAKANA LETTER SMALL HO"               nil     )
    (#x0031fa "KATAKANA LETTER SMALL MU"               nil     )
    (#x0031fb "KATAKANA LETTER SMALL RA"               nil     )
    (#x0031fc "KATAKANA LETTER SMALL RI"               nil     )
    (#x0031fd "KATAKANA LETTER SMALL RU"               nil     )
    (#x0031fe "KATAKANA LETTER SMALL RE"               nil     )
    (#x0031ff "KATAKANA LETTER SMALL RO"               nil     )
    (#x003200 "PARENTHESIZED HANGUL KIYEOK"            nil     )
    (#x003201 "PARENTHESIZED HANGUL NIEUN"             nil     )
    (#x003202 "PARENTHESIZED HANGUL TIKEUT"            nil     )
    (#x003203 "PARENTHESIZED HANGUL RIEUL"             nil     )
    (#x003204 "PARENTHESIZED HANGUL MIEUM"             nil     )
    (#x003205 "PARENTHESIZED HANGUL PIEUP"             nil     )
    (#x003206 "PARENTHESIZED HANGUL SIOS"              nil     )
    (#x003207 "PARENTHESIZED HANGUL IEUNG"             nil     )
    (#x003208 "PARENTHESIZED HANGUL CIEUC"             nil     )
    (#x003209 "PARENTHESIZED HANGUL CHIEUCH"           nil     )
    (#x00320a "PARENTHESIZED HANGUL KHIEUKH"           nil     )
    (#x00320b "PARENTHESIZED HANGUL THIEUTH"           nil     )
    (#x00320c "PARENTHESIZED HANGUL PHIEUPH"           nil     )
    (#x00320d "PARENTHESIZED HANGUL HIEUH"             nil     )
    (#x00320e "PARENTHESIZED HANGUL KIYEOK A"          nil     )
    (#x00320f "PARENTHESIZED HANGUL NIEUN A"           nil     )
    (#x003210 "PARENTHESIZED HANGUL TIKEUT A"          nil     )
    (#x003211 "PARENTHESIZED HANGUL RIEUL A"           nil     )
    (#x003212 "PARENTHESIZED HANGUL MIEUM A"           nil     )
    (#x003213 "PARENTHESIZED HANGUL PIEUP A"           nil     )
    (#x003214 "PARENTHESIZED HANGUL SIOS A"            nil     )
    (#x003215 "PARENTHESIZED HANGUL IEUNG A"           nil     )
    (#x003216 "PARENTHESIZED HANGUL CIEUC A"           nil     )
    (#x003217 "PARENTHESIZED HANGUL CHIEUCH A"         nil     )
    (#x003218 "PARENTHESIZED HANGUL KHIEUKH A"         nil     )
    (#x003219 "PARENTHESIZED HANGUL THIEUTH A"         nil     )
    (#x00321a "PARENTHESIZED HANGUL PHIEUPH A"         nil     )
    (#x00321b "PARENTHESIZED HANGUL HIEUH A"           nil     )
    (#x00321c "PARENTHESIZED HANGUL CIEUC U"           nil     )
    (#x00321d "PARENTHESIZED KOREAN CHARACTER OJEON"   nil     )
    (#x00321e "PARENTHESIZED KOREAN CHARACTER O HU"    nil     )
    (#x003220 "PARENTHESIZED IDEOGRAPH ONE"            nil     )
    (#x003221 "PARENTHESIZED IDEOGRAPH TWO"            nil     )
    (#x003222 "PARENTHESIZED IDEOGRAPH THREE"          nil     )
    (#x003223 "PARENTHESIZED IDEOGRAPH FOUR"           nil     )
    (#x003224 "PARENTHESIZED IDEOGRAPH FIVE"           nil     )
    (#x003225 "PARENTHESIZED IDEOGRAPH SIX"            nil     )
    (#x003226 "PARENTHESIZED IDEOGRAPH SEVEN"          nil     )
    (#x003227 "PARENTHESIZED IDEOGRAPH EIGHT"          nil     )
    (#x003228 "PARENTHESIZED IDEOGRAPH NINE"           nil     )
    (#x003229 "PARENTHESIZED IDEOGRAPH TEN"            nil     )
    (#x00322a "PARENTHESIZED IDEOGRAPH MOON"           nil     )
    (#x00322b "PARENTHESIZED IDEOGRAPH FIRE"           nil     )
    (#x00322c "PARENTHESIZED IDEOGRAPH WATER"          nil     )
    (#x00322d "PARENTHESIZED IDEOGRAPH WOOD"           nil     )
    (#x00322e "PARENTHESIZED IDEOGRAPH METAL"          nil     )
    (#x00322f "PARENTHESIZED IDEOGRAPH EARTH"          nil     )
    (#x003230 "PARENTHESIZED IDEOGRAPH SUN"            nil     )
    (#x003231 "PARENTHESIZED IDEOGRAPH STOCK"          nil     )
    (#x003232 "PARENTHESIZED IDEOGRAPH HAVE"           nil     )
    (#x003233 "PARENTHESIZED IDEOGRAPH SOCIETY"        nil     )
    (#x003234 "PARENTHESIZED IDEOGRAPH NAME"           nil     )
    (#x003235 "PARENTHESIZED IDEOGRAPH SPECIAL"        nil     )
    (#x003236 "PARENTHESIZED IDEOGRAPH FINANCIAL"      nil     )
    (#x003237 "PARENTHESIZED IDEOGRAPH CONGRATULATION" nil     )
    (#x003238 "PARENTHESIZED IDEOGRAPH LABOR"          nil     )
    (#x003239 "PARENTHESIZED IDEOGRAPH REPRESENT"      nil     )
    (#x00323a "PARENTHESIZED IDEOGRAPH CALL"           nil     )
    (#x00323b "PARENTHESIZED IDEOGRAPH STUDY"          nil     )
    (#x00323c "PARENTHESIZED IDEOGRAPH SUPERVISE"      nil     )
    (#x00323d "PARENTHESIZED IDEOGRAPH ENTERPRISE"     nil     )
    (#x00323e "PARENTHESIZED IDEOGRAPH RESOURCE"       nil     )
    (#x00323f "PARENTHESIZED IDEOGRAPH ALLIANCE"       nil     )
    (#x003240 "PARENTHESIZED IDEOGRAPH FESTIVAL"       nil     )
    (#x003241 "PARENTHESIZED IDEOGRAPH REST"           nil     )
    (#x003242 "PARENTHESIZED IDEOGRAPH SELF"           nil     )
    (#x003243 "PARENTHESIZED IDEOGRAPH REACH"          nil     )
    (#x003244 "CIRCLED IDEOGRAPH QUESTION"             nil     )
    (#x003245 "CIRCLED IDEOGRAPH KINDERGARTEN"         nil     )
    (#x003246 "CIRCLED IDEOGRAPH SCHOOL"               nil     )
    (#x003247 "CIRCLED IDEOGRAPH KOTO"                 nil     )
    (#x003248 "CIRCLED NUMBER TEN ON BLACK SQUARE"     nil     )
    (#x003249 "CIRCLED NUMBER TWENTY ON BLACK SQUARE"  nil     )
    (#x00324a "CIRCLED NUMBER THIRTY ON BLACK SQUARE"  nil     )
    (#x00324b "CIRCLED NUMBER FORTY ON BLACK SQUARE"   nil     )
    (#x00324c "CIRCLED NUMBER FIFTY ON BLACK SQUARE"   nil     )
    (#x00324d "CIRCLED NUMBER SIXTY ON BLACK SQUARE"   nil     )
    (#x00324e "CIRCLED NUMBER SEVENTY ON BLACK SQUARE" nil     )
    (#x00324f "CIRCLED NUMBER EIGHTY ON BLACK SQUARE"  nil     )
    (#x003250 "PARTNERSHIP SIGN"                       nil     )
    (#x003251 "CIRCLED NUMBER TWENTY ONE"              nil     )
    (#x003252 "CIRCLED NUMBER TWENTY TWO"              nil     )
    (#x003253 "CIRCLED NUMBER TWENTY THREE"            nil     )
    (#x003254 "CIRCLED NUMBER TWENTY FOUR"             nil     )
    (#x003255 "CIRCLED NUMBER TWENTY FIVE"             nil     )
    (#x003256 "CIRCLED NUMBER TWENTY SIX"              nil     )
    (#x003257 "CIRCLED NUMBER TWENTY SEVEN"            nil     )
    (#x003258 "CIRCLED NUMBER TWENTY EIGHT"            nil     )
    (#x003259 "CIRCLED NUMBER TWENTY NINE"             nil     )
    (#x00325a "CIRCLED NUMBER THIRTY"                  nil     )
    (#x00325b "CIRCLED NUMBER THIRTY ONE"              nil     )
    (#x00325c "CIRCLED NUMBER THIRTY TWO"              nil     )
    (#x00325d "CIRCLED NUMBER THIRTY THREE"            nil     )
    (#x00325e "CIRCLED NUMBER THIRTY FOUR"             nil     )
    (#x00325f "CIRCLED NUMBER THIRTY FIVE"             nil     )
    (#x003260 "CIRCLED HANGUL KIYEOK"                  nil     )
    (#x003261 "CIRCLED HANGUL NIEUN"                   nil     )
    (#x003262 "CIRCLED HANGUL TIKEUT"                  nil     )
    (#x003263 "CIRCLED HANGUL RIEUL"                   nil     )
    (#x003264 "CIRCLED HANGUL MIEUM"                   nil     )
    (#x003265 "CIRCLED HANGUL PIEUP"                   nil     )
    (#x003266 "CIRCLED HANGUL SIOS"                    nil     )
    (#x003267 "CIRCLED HANGUL IEUNG"                   nil     )
    (#x003268 "CIRCLED HANGUL CIEUC"                   nil     )
    (#x003269 "CIRCLED HANGUL CHIEUCH"                 nil     )
    (#x00326a "CIRCLED HANGUL KHIEUKH"                 nil     )
    (#x00326b "CIRCLED HANGUL THIEUTH"                 nil     )
    (#x00326c "CIRCLED HANGUL PHIEUPH"                 nil     )
    (#x00326d "CIRCLED HANGUL HIEUH"                   nil     )
    (#x00326e "CIRCLED HANGUL KIYEOK A"                nil     )
    (#x00326f "CIRCLED HANGUL NIEUN A"                 nil     )
    (#x003270 "CIRCLED HANGUL TIKEUT A"                nil     )
    (#x003271 "CIRCLED HANGUL RIEUL A"                 nil     )
    (#x003272 "CIRCLED HANGUL MIEUM A"                 nil     )
    (#x003273 "CIRCLED HANGUL PIEUP A"                 nil     )
    (#x003274 "CIRCLED HANGUL SIOS A"                  nil     )
    (#x003275 "CIRCLED HANGUL IEUNG A"                 nil     )
    (#x003276 "CIRCLED HANGUL CIEUC A"                 nil     )
    (#x003277 "CIRCLED HANGUL CHIEUCH A"               nil     )
    (#x003278 "CIRCLED HANGUL KHIEUKH A"               nil     )
    (#x003279 "CIRCLED HANGUL THIEUTH A"               nil     )
    (#x00327a "CIRCLED HANGUL PHIEUPH A"               nil     )
    (#x00327b "CIRCLED HANGUL HIEUH A"                 nil     )
    (#x00327c "CIRCLED KOREAN CHARACTER CHAMKO"        nil     )
    (#x00327d "CIRCLED KOREAN CHARACTER JUEUI"         nil     )
    (#x00327e "CIRCLED HANGUL IEUNG U"                 nil     )
    (#x00327f "KOREAN STANDARD SYMBOL"                 nil     )
    (#x003280 "CIRCLED IDEOGRAPH ONE"                  nil     )
    (#x003281 "CIRCLED IDEOGRAPH TWO"                  nil     )
    (#x003282 "CIRCLED IDEOGRAPH THREE"                nil     )
    (#x003283 "CIRCLED IDEOGRAPH FOUR"                 nil     )
    (#x003284 "CIRCLED IDEOGRAPH FIVE"                 nil     )
    (#x003285 "CIRCLED IDEOGRAPH SIX"                  nil     )
    (#x003286 "CIRCLED IDEOGRAPH SEVEN"                nil     )
    (#x003287 "CIRCLED IDEOGRAPH EIGHT"                nil     )
    (#x003288 "CIRCLED IDEOGRAPH NINE"                 nil     )
    (#x003289 "CIRCLED IDEOGRAPH TEN"                  nil     )
    (#x00328a "CIRCLED IDEOGRAPH MOON"                 nil     )
    (#x00328b "CIRCLED IDEOGRAPH FIRE"                 nil     )
    (#x00328c "CIRCLED IDEOGRAPH WATER"                nil     )
    (#x00328d "CIRCLED IDEOGRAPH WOOD"                 nil     )
    (#x00328e "CIRCLED IDEOGRAPH METAL"                nil     )
    (#x00328f "CIRCLED IDEOGRAPH EARTH"                nil     )
    (#x003290 "CIRCLED IDEOGRAPH SUN"                  nil     )
    (#x003291 "CIRCLED IDEOGRAPH STOCK"                nil     )
    (#x003292 "CIRCLED IDEOGRAPH HAVE"                 nil     )
    (#x003293 "CIRCLED IDEOGRAPH SOCIETY"              nil     )
    (#x003294 "CIRCLED IDEOGRAPH NAME"                 nil     )
    (#x003295 "CIRCLED IDEOGRAPH SPECIAL"              nil     )
    (#x003296 "CIRCLED IDEOGRAPH FINANCIAL"            nil     )
    (#x003297 "CIRCLED IDEOGRAPH CONGRATULATION"       nil     )
    (#x003298 "CIRCLED IDEOGRAPH LABOR"                nil     )
    (#x003299 "CIRCLED IDEOGRAPH SECRET"               nil     )
    (#x00329a "CIRCLED IDEOGRAPH MALE"                 nil     )
    (#x00329b "CIRCLED IDEOGRAPH FEMALE"               nil     )
    (#x00329c "CIRCLED IDEOGRAPH SUITABLE"             nil     )
    (#x00329d "CIRCLED IDEOGRAPH EXCELLENT"            nil     )
    (#x00329e "CIRCLED IDEOGRAPH PRINT"                nil     )
    (#x00329f "CIRCLED IDEOGRAPH ATTENTION"            nil     )
    (#x0032a0 "CIRCLED IDEOGRAPH ITEM"                 nil     )
    (#x0032a1 "CIRCLED IDEOGRAPH REST"                 nil     )
    (#x0032a2 "CIRCLED IDEOGRAPH COPY"                 nil     )
    (#x0032a3 "CIRCLED IDEOGRAPH CORRECT"              nil     )
    (#x0032a4 "CIRCLED IDEOGRAPH HIGH"                 nil     )
    (#x0032a5 "CIRCLED IDEOGRAPH CENTRE"               nil     )
    (#x0032a6 "CIRCLED IDEOGRAPH LOW"                  nil     )
    (#x0032a7 "CIRCLED IDEOGRAPH LEFT"                 nil     )
    (#x0032a8 "CIRCLED IDEOGRAPH RIGHT"                nil     )
    (#x0032a9 "CIRCLED IDEOGRAPH MEDICINE"             nil     )
    (#x0032aa "CIRCLED IDEOGRAPH RELIGION"             nil     )
    (#x0032ab "CIRCLED IDEOGRAPH STUDY"                nil     )
    (#x0032ac "CIRCLED IDEOGRAPH SUPERVISE"            nil     )
    (#x0032ad "CIRCLED IDEOGRAPH ENTERPRISE"           nil     )
    (#x0032ae "CIRCLED IDEOGRAPH RESOURCE"             nil     )
    (#x0032af "CIRCLED IDEOGRAPH ALLIANCE"             nil     )
    (#x0032b0 "CIRCLED IDEOGRAPH NIGHT"                nil     )
    (#x0032b1 "CIRCLED NUMBER THIRTY SIX"              nil     )
    (#x0032b2 "CIRCLED NUMBER THIRTY SEVEN"            nil     )
    (#x0032b3 "CIRCLED NUMBER THIRTY EIGHT"            nil     )
    (#x0032b4 "CIRCLED NUMBER THIRTY NINE"             nil     )
    (#x0032b5 "CIRCLED NUMBER FORTY"                   nil     )
    (#x0032b6 "CIRCLED NUMBER FORTY ONE"               nil     )
    (#x0032b7 "CIRCLED NUMBER FORTY TWO"               nil     )
    (#x0032b8 "CIRCLED NUMBER FORTY THREE"             nil     )
    (#x0032b9 "CIRCLED NUMBER FORTY FOUR"              nil     )
    (#x0032ba "CIRCLED NUMBER FORTY FIVE"              nil     )
    (#x0032bb "CIRCLED NUMBER FORTY SIX"               nil     )
    (#x0032bc "CIRCLED NUMBER FORTY SEVEN"             nil     )
    (#x0032bd "CIRCLED NUMBER FORTY EIGHT"             nil     )
    (#x0032be "CIRCLED NUMBER FORTY NINE"              nil     )
    (#x0032bf "CIRCLED NUMBER FIFTY"                   nil     )
    (#x0032c0 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY" nil     )
    (#x0032c1 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY" nil     )
    (#x0032c2 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH" nil     )
    (#x0032c3 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL" nil     )
    (#x0032c4 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY"   nil     )
    (#x0032c5 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE"  nil     )
    (#x0032c6 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY"  nil     )
    (#x0032c7 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST" nil     )
    (#x0032c8 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER" nil     )
    (#x0032c9 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER" nil     )
    (#x0032ca "IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER" nil     )
    (#x0032cb "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER" nil     )
    (#x0032cc "SQUARE HG"                              nil     )
    (#x0032cd "SQUARE ERG"                             nil     )
    (#x0032ce "SQUARE EV"                              nil     )
    (#x0032cf "LIMITED LIABILITY SIGN"                 nil     )
    (#x0032d0 "CIRCLED KATAKANA A"                     nil     )
    (#x0032d1 "CIRCLED KATAKANA I"                     nil     )
    (#x0032d2 "CIRCLED KATAKANA U"                     nil     )
    (#x0032d3 "CIRCLED KATAKANA E"                     nil     )
    (#x0032d4 "CIRCLED KATAKANA O"                     nil     )
    (#x0032d5 "CIRCLED KATAKANA KA"                    nil     )
    (#x0032d6 "CIRCLED KATAKANA KI"                    nil     )
    (#x0032d7 "CIRCLED KATAKANA KU"                    nil     )
    (#x0032d8 "CIRCLED KATAKANA KE"                    nil     )
    (#x0032d9 "CIRCLED KATAKANA KO"                    nil     )
    (#x0032da "CIRCLED KATAKANA SA"                    nil     )
    (#x0032db "CIRCLED KATAKANA SI"                    nil     )
    (#x0032dc "CIRCLED KATAKANA SU"                    nil     )
    (#x0032dd "CIRCLED KATAKANA SE"                    nil     )
    (#x0032de "CIRCLED KATAKANA SO"                    nil     )
    (#x0032df "CIRCLED KATAKANA TA"                    nil     )
    (#x0032e0 "CIRCLED KATAKANA TI"                    nil     )
    (#x0032e1 "CIRCLED KATAKANA TU"                    nil     )
    (#x0032e2 "CIRCLED KATAKANA TE"                    nil     )
    (#x0032e3 "CIRCLED KATAKANA TO"                    nil     )
    (#x0032e4 "CIRCLED KATAKANA NA"                    nil     )
    (#x0032e5 "CIRCLED KATAKANA NI"                    nil     )
    (#x0032e6 "CIRCLED KATAKANA NU"                    nil     )
    (#x0032e7 "CIRCLED KATAKANA NE"                    nil     )
    (#x0032e8 "CIRCLED KATAKANA NO"                    nil     )
    (#x0032e9 "CIRCLED KATAKANA HA"                    nil     )
    (#x0032ea "CIRCLED KATAKANA HI"                    nil     )
    (#x0032eb "CIRCLED KATAKANA HU"                    nil     )
    (#x0032ec "CIRCLED KATAKANA HE"                    nil     )
    (#x0032ed "CIRCLED KATAKANA HO"                    nil     )
    (#x0032ee "CIRCLED KATAKANA MA"                    nil     )
    (#x0032ef "CIRCLED KATAKANA MI"                    nil     )
    (#x0032f0 "CIRCLED KATAKANA MU"                    nil     )
    (#x0032f1 "CIRCLED KATAKANA ME"                    nil     )
    (#x0032f2 "CIRCLED KATAKANA MO"                    nil     )
    (#x0032f3 "CIRCLED KATAKANA YA"                    nil     )
    (#x0032f4 "CIRCLED KATAKANA YU"                    nil     )
    (#x0032f5 "CIRCLED KATAKANA YO"                    nil     )
    (#x0032f6 "CIRCLED KATAKANA RA"                    nil     )
    (#x0032f7 "CIRCLED KATAKANA RI"                    nil     )
    (#x0032f8 "CIRCLED KATAKANA RU"                    nil     )
    (#x0032f9 "CIRCLED KATAKANA RE"                    nil     )
    (#x0032fa "CIRCLED KATAKANA RO"                    nil     )
    (#x0032fb "CIRCLED KATAKANA WA"                    nil     )
    (#x0032fc "CIRCLED KATAKANA WI"                    nil     )
    (#x0032fd "CIRCLED KATAKANA WE"                    nil     )
    (#x0032fe "CIRCLED KATAKANA WO"                    nil     )
    (#x0032ff "SQUARE ERA NAME REIWA"                  nil     )
    (#x003300 "SQUARE APAATO"                          nil     )
    (#x003301 "SQUARE ARUHUA"                          nil     )
    (#x003302 "SQUARE ANPEA"                           nil     )
    (#x003303 "SQUARE AARU"                            nil     )
    (#x003304 "SQUARE ININGU"                          nil     )
    (#x003305 "SQUARE INTI"                            nil     )
    (#x003306 "SQUARE UON"                             nil     )
    (#x003307 "SQUARE ESUKUUDO"                        nil     )
    (#x003308 "SQUARE EEKAA"                           nil     )
    (#x003309 "SQUARE ONSU"                            nil     )
    (#x00330a "SQUARE OOMU"                            nil     )
    (#x00330b "SQUARE KAIRI"                           nil     )
    (#x00330c "SQUARE KARATTO"                         nil     )
    (#x00330d "SQUARE KARORII"                         nil     )
    (#x00330e "SQUARE GARON"                           nil     )
    (#x00330f "SQUARE GANMA"                           nil     )
    (#x003310 "SQUARE GIGA"                            nil     )
    (#x003311 "SQUARE GINII"                           nil     )
    (#x003312 "SQUARE KYURII"                          nil     )
    (#x003313 "SQUARE GIRUDAA"                         nil     )
    (#x003314 "SQUARE KIRO"                            nil     )
    (#x003315 "SQUARE KIROGURAMU"                      nil     )
    (#x003316 "SQUARE KIROMEETORU"                     nil     )
    (#x003317 "SQUARE KIROWATTO"                       nil     )
    (#x003318 "SQUARE GURAMU"                          nil     )
    (#x003319 "SQUARE GURAMUTON"                       nil     )
    (#x00331a "SQUARE KURUZEIRO"                       nil     )
    (#x00331b "SQUARE KUROONE"                         nil     )
    (#x00331c "SQUARE KEESU"                           nil     )
    (#x00331d "SQUARE KORUNA"                          nil     )
    (#x00331e "SQUARE KOOPO"                           nil     )
    (#x00331f "SQUARE SAIKURU"                         nil     )
    (#x003320 "SQUARE SANTIIMU"                        nil     )
    (#x003321 "SQUARE SIRINGU"                         nil     )
    (#x003322 "SQUARE SENTI"                           nil     )
    (#x003323 "SQUARE SENTO"                           nil     )
    (#x003324 "SQUARE DAASU"                           nil     )
    (#x003325 "SQUARE DESI"                            nil     )
    (#x003326 "SQUARE DORU"                            nil     )
    (#x003327 "SQUARE TON"                             nil     )
    (#x003328 "SQUARE NANO"                            nil     )
    (#x003329 "SQUARE NOTTO"                           nil     )
    (#x00332a "SQUARE HAITU"                           nil     )
    (#x00332b "SQUARE PAASENTO"                        nil     )
    (#x00332c "SQUARE PAATU"                           nil     )
    (#x00332d "SQUARE BAARERU"                         nil     )
    (#x00332e "SQUARE PIASUTORU"                       nil     )
    (#x00332f "SQUARE PIKURU"                          nil     )
    (#x003330 "SQUARE PIKO"                            nil     )
    (#x003331 "SQUARE BIRU"                            nil     )
    (#x003332 "SQUARE HUARADDO"                        nil     )
    (#x003333 "SQUARE HUIITO"                          nil     )
    (#x003334 "SQUARE BUSSYERU"                        nil     )
    (#x003335 "SQUARE HURAN"                           nil     )
    (#x003336 "SQUARE HEKUTAARU"                       nil     )
    (#x003337 "SQUARE PESO"                            nil     )
    (#x003338 "SQUARE PENIHI"                          nil     )
    (#x003339 "SQUARE HERUTU"                          nil     )
    (#x00333a "SQUARE PENSU"                           nil     )
    (#x00333b "SQUARE PEEZI"                           nil     )
    (#x00333c "SQUARE BEETA"                           nil     )
    (#x00333d "SQUARE POINTO"                          nil     )
    (#x00333e "SQUARE BORUTO"                          nil     )
    (#x00333f "SQUARE HON"                             nil     )
    (#x003340 "SQUARE PONDO"                           nil     )
    (#x003341 "SQUARE HOORU"                           nil     )
    (#x003342 "SQUARE HOON"                            nil     )
    (#x003343 "SQUARE MAIKURO"                         nil     )
    (#x003344 "SQUARE MAIRU"                           nil     )
    (#x003345 "SQUARE MAHHA"                           nil     )
    (#x003346 "SQUARE MARUKU"                          nil     )
    (#x003347 "SQUARE MANSYON"                         nil     )
    (#x003348 "SQUARE MIKURON"                         nil     )
    (#x003349 "SQUARE MIRI"                            nil     )
    (#x00334a "SQUARE MIRIBAARU"                       nil     )
    (#x00334b "SQUARE MEGA"                            nil     )
    (#x00334c "SQUARE MEGATON"                         nil     )
    (#x00334d "SQUARE MEETORU"                         nil     )
    (#x00334e "SQUARE YAADO"                           nil     )
    (#x00334f "SQUARE YAARU"                           nil     )
    (#x003350 "SQUARE YUAN"                            nil     )
    (#x003351 "SQUARE RITTORU"                         nil     )
    (#x003352 "SQUARE RIRA"                            nil     )
    (#x003353 "SQUARE RUPII"                           nil     )
    (#x003354 "SQUARE RUUBURU"                         nil     )
    (#x003355 "SQUARE REMU"                            nil     )
    (#x003356 "SQUARE RENTOGEN"                        nil     )
    (#x003357 "SQUARE WATTO"                           nil     )
    (#x003358 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO" nil     )
    (#x003359 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE" nil     )
    (#x00335a "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO" nil     )
    (#x00335b "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE" nil     )
    (#x00335c "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR" nil     )
    (#x00335d "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE" nil     )
    (#x00335e "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX" nil     )
    (#x00335f "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN" nil     )
    (#x003360 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT" nil     )
    (#x003361 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE" nil     )
    (#x003362 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN" nil     )
    (#x003363 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN" nil     )
    (#x003364 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE" nil     )
    (#x003365 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN" nil     )
    (#x003366 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN" nil     )
    (#x003367 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN" nil     )
    (#x003368 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN" nil     )
    (#x003369 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN" nil     )
    (#x00336a "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN" nil     )
    (#x00336b "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN" nil     )
    (#x00336c "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY" nil     )
    (#x00336d "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE" nil     )
    (#x00336e "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO" nil     )
    (#x00336f "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE" nil     )
    (#x003370 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR" nil     )
    (#x003371 "SQUARE HPA"                             nil     )
    (#x003372 "SQUARE DA"                              nil     )
    (#x003373 "SQUARE AU"                              nil     )
    (#x003374 "SQUARE BAR"                             nil     )
    (#x003375 "SQUARE OV"                              nil     )
    (#x003376 "SQUARE PC"                              nil     )
    (#x003377 "SQUARE DM"                              nil     )
    (#x003378 "SQUARE DM SQUARED"                      nil     )
    (#x003379 "SQUARE DM CUBED"                        nil     )
    (#x00337a "SQUARE IU"                              nil     )
    (#x00337b "SQUARE ERA NAME HEISEI"                 nil     )
    (#x00337c "SQUARE ERA NAME SYOUWA"                 nil     )
    (#x00337d "SQUARE ERA NAME TAISYOU"                nil     )
    (#x00337e "SQUARE ERA NAME MEIZI"                  nil     )
    (#x00337f "SQUARE CORPORATION"                     nil     )
    (#x003380 "SQUARE PA AMPS"                         nil     )
    (#x003381 "SQUARE NA"                              nil     )
    (#x003382 "SQUARE MU A"                            nil     )
    (#x003383 "SQUARE MA"                              nil     )
    (#x003384 "SQUARE KA"                              nil     )
    (#x003385 "SQUARE KB"                              nil     )
    (#x003386 "SQUARE MB"                              nil     )
    (#x003387 "SQUARE GB"                              nil     )
    (#x003388 "SQUARE CAL"                             nil     )
    (#x003389 "SQUARE KCAL"                            nil     )
    (#x00338a "SQUARE PF"                              nil     )
    (#x00338b "SQUARE NF"                              nil     )
    (#x00338c "SQUARE MU F"                            nil     )
    (#x00338d "SQUARE MU G"                            nil     )
    (#x00338e "SQUARE MG"                              nil     )
    (#x00338f "SQUARE KG"                              nil     )
    (#x003390 "SQUARE HZ"                              nil     )
    (#x003391 "SQUARE KHZ"                             nil     )
    (#x003392 "SQUARE MHZ"                             nil     )
    (#x003393 "SQUARE GHZ"                             nil     )
    (#x003394 "SQUARE THZ"                             nil     )
    (#x003395 "SQUARE MU L"                            nil     )
    (#x003396 "SQUARE ML"                              nil     )
    (#x003397 "SQUARE DL"                              nil     )
    (#x003398 "SQUARE KL"                              nil     )
    (#x003399 "SQUARE FM"                              nil     )
    (#x00339a "SQUARE NM"                              nil     )
    (#x00339b "SQUARE MU M"                            nil     )
    (#x00339c "SQUARE MM"                              nil     )
    (#x00339d "SQUARE CM"                              nil     )
    (#x00339e "SQUARE KM"                              nil     )
    (#x00339f "SQUARE MM SQUARED"                      nil     )
    (#x0033a0 "SQUARE CM SQUARED"                      nil     )
    (#x0033a1 "SQUARE M SQUARED"                       nil     )
    (#x0033a2 "SQUARE KM SQUARED"                      nil     )
    (#x0033a3 "SQUARE MM CUBED"                        nil     )
    (#x0033a4 "SQUARE CM CUBED"                        nil     )
    (#x0033a5 "SQUARE M CUBED"                         nil     )
    (#x0033a6 "SQUARE KM CUBED"                        nil     )
    (#x0033a7 "SQUARE M OVER S"                        nil     )
    (#x0033a8 "SQUARE M OVER S SQUARED"                nil     )
    (#x0033a9 "SQUARE PA"                              nil     )
    (#x0033aa "SQUARE KPA"                             nil     )
    (#x0033ab "SQUARE MPA"                             nil     )
    (#x0033ac "SQUARE GPA"                             nil     )
    (#x0033ad "SQUARE RAD"                             nil     )
    (#x0033ae "SQUARE RAD OVER S"                      nil     )
    (#x0033af "SQUARE RAD OVER S SQUARED"              nil     )
    (#x0033b0 "SQUARE PS"                              nil     )
    (#x0033b1 "SQUARE NS"                              nil     )
    (#x0033b2 "SQUARE MU S"                            nil     )
    (#x0033b3 "SQUARE MS"                              nil     )
    (#x0033b4 "SQUARE PV"                              nil     )
    (#x0033b5 "SQUARE NV"                              nil     )
    (#x0033b6 "SQUARE MU V"                            nil     )
    (#x0033b7 "SQUARE MV"                              nil     )
    (#x0033b8 "SQUARE KV"                              nil     )
    (#x0033b9 "SQUARE MV MEGA"                         nil     )
    (#x0033ba "SQUARE PW"                              nil     )
    (#x0033bb "SQUARE NW"                              nil     )
    (#x0033bc "SQUARE MU W"                            nil     )
    (#x0033bd "SQUARE MW"                              nil     )
    (#x0033be "SQUARE KW"                              nil     )
    (#x0033bf "SQUARE MW MEGA"                         nil     )
    (#x0033c0 "SQUARE K OHM"                           nil     )
    (#x0033c1 "SQUARE M OHM"                           nil     )
    (#x0033c2 "SQUARE AM"                              nil     )
    (#x0033c3 "SQUARE BQ"                              nil     )
    (#x0033c4 "SQUARE CC"                              nil     )
    (#x0033c5 "SQUARE CD"                              nil     )
    (#x0033c6 "SQUARE C OVER KG"                       nil     )
    (#x0033c7 "SQUARE CO"                              nil     )
    (#x0033c8 "SQUARE DB"                              nil     )
    (#x0033c9 "SQUARE GY"                              nil     )
    (#x0033ca "SQUARE HA"                              nil     )
    (#x0033cb "SQUARE HP"                              nil     )
    (#x0033cc "SQUARE IN"                              nil     )
    (#x0033cd "SQUARE KK"                              nil     )
    (#x0033ce "SQUARE KM CAPITAL"                      nil     )
    (#x0033cf "SQUARE KT"                              nil     )
    (#x0033d0 "SQUARE LM"                              nil     )
    (#x0033d1 "SQUARE LN"                              nil     )
    (#x0033d2 "SQUARE LOG"                             nil     )
    (#x0033d3 "SQUARE LX"                              nil     )
    (#x0033d4 "SQUARE MB SMALL"                        nil     )
    (#x0033d5 "SQUARE MIL"                             nil     )
    (#x0033d6 "SQUARE MOL"                             nil     )
    (#x0033d7 "SQUARE PH"                              nil     )
    (#x0033d8 "SQUARE PM"                              nil     )
    (#x0033d9 "SQUARE PPM"                             nil     )
    (#x0033da "SQUARE PR"                              nil     )
    (#x0033db "SQUARE SR"                              nil     )
    (#x0033dc "SQUARE SV"                              nil     )
    (#x0033dd "SQUARE WB"                              nil     )
    (#x0033de "SQUARE V OVER M"                        nil     )
    (#x0033df "SQUARE A OVER M"                        nil     )
    (#x0033e0 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE" nil     )
    (#x0033e1 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO" nil     )
    (#x0033e2 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE" nil     )
    (#x0033e3 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR" nil     )
    (#x0033e4 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE" nil     )
    (#x0033e5 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX" nil     )
    (#x0033e6 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN" nil     )
    (#x0033e7 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT" nil     )
    (#x0033e8 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE" nil     )
    (#x0033e9 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN" nil     )
    (#x0033ea "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN" nil     )
    (#x0033eb "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE" nil     )
    (#x0033ec "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN" nil     )
    (#x0033ed "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN" nil     )
    (#x0033ee "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN" nil     )
    (#x0033ef "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN" nil     )
    (#x0033f0 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN" nil     )
    (#x0033f1 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN" nil     )
    (#x0033f2 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN" nil     )
    (#x0033f3 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY" nil     )
    (#x0033f4 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE" nil     )
    (#x0033f5 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO" nil     )
    (#x0033f6 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE" nil     )
    (#x0033f7 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR" nil     )
    (#x0033f8 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE" nil     )
    (#x0033f9 "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX" nil     )
    (#x0033fa "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN" nil     )
    (#x0033fb "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT" nil     )
    (#x0033fc "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE" nil     )
    (#x0033fd "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY" nil     )
    (#x0033fe "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE" nil     )
    (#x0033ff "SQUARE GAL"                             nil     )
    (#x004dc0 "HEXAGRAM FOR THE CREATIVE HEAVEN"       nil     )
    (#x004dc1 "HEXAGRAM FOR THE RECEPTIVE EARTH"       nil     )
    (#x004dc2 "HEXAGRAM FOR DIFFICULTY AT THE BEGINNING" nil     )
    (#x004dc3 "HEXAGRAM FOR YOUTHFUL FOLLY"            nil     )
    (#x004dc4 "HEXAGRAM FOR WAITING"                   nil     )
    (#x004dc5 "HEXAGRAM FOR CONFLICT"                  nil     )
    (#x004dc6 "HEXAGRAM FOR THE ARMY"                  nil     )
    (#x004dc7 "HEXAGRAM FOR HOLDING TOGETHER"          nil     )
    (#x004dc8 "HEXAGRAM FOR SMALL TAMING"              nil     )
    (#x004dc9 "HEXAGRAM FOR TREADING"                  nil     )
    (#x004dca "HEXAGRAM FOR PEACE"                     nil     )
    (#x004dcb "HEXAGRAM FOR STANDSTILL"                nil     )
    (#x004dcc "HEXAGRAM FOR FELLOWSHIP"                nil     )
    (#x004dcd "HEXAGRAM FOR GREAT POSSESSION"          nil     )
    (#x004dce "HEXAGRAM FOR MODESTY"                   nil     )
    (#x004dcf "HEXAGRAM FOR ENTHUSIASM"                nil     )
    (#x004dd0 "HEXAGRAM FOR FOLLOWING"                 nil     )
    (#x004dd1 "HEXAGRAM FOR WORK ON THE DECAYED"       nil     )
    (#x004dd2 "HEXAGRAM FOR APPROACH"                  nil     )
    (#x004dd3 "HEXAGRAM FOR CONTEMPLATION"             nil     )
    (#x004dd4 "HEXAGRAM FOR BITING THROUGH"            nil     )
    (#x004dd5 "HEXAGRAM FOR GRACE"                     nil     )
    (#x004dd6 "HEXAGRAM FOR SPLITTING APART"           nil     )
    (#x004dd7 "HEXAGRAM FOR RETURN"                    nil     )
    (#x004dd8 "HEXAGRAM FOR INNOCENCE"                 nil     )
    (#x004dd9 "HEXAGRAM FOR GREAT TAMING"              nil     )
    (#x004dda "HEXAGRAM FOR MOUTH CORNERS"             nil     )
    (#x004ddb "HEXAGRAM FOR GREAT PREPONDERANCE"       nil     )
    (#x004ddc "HEXAGRAM FOR THE ABYSMAL WATER"         nil     )
    (#x004ddd "HEXAGRAM FOR THE CLINGING FIRE"         nil     )
    (#x004dde "HEXAGRAM FOR INFLUENCE"                 nil     )
    (#x004ddf "HEXAGRAM FOR DURATION"                  nil     )
    (#x004de0 "HEXAGRAM FOR RETREAT"                   nil     )
    (#x004de1 "HEXAGRAM FOR GREAT POWER"               nil     )
    (#x004de2 "HEXAGRAM FOR PROGRESS"                  nil     )
    (#x004de3 "HEXAGRAM FOR DARKENING OF THE LIGHT"    nil     )
    (#x004de4 "HEXAGRAM FOR THE FAMILY"                nil     )
    (#x004de5 "HEXAGRAM FOR OPPOSITION"                nil     )
    (#x004de6 "HEXAGRAM FOR OBSTRUCTION"               nil     )
    (#x004de7 "HEXAGRAM FOR DELIVERANCE"               nil     )
    (#x004de8 "HEXAGRAM FOR DECREASE"                  nil     )
    (#x004de9 "HEXAGRAM FOR INCREASE"                  nil     )
    (#x004dea "HEXAGRAM FOR BREAKTHROUGH"              nil     )
    (#x004deb "HEXAGRAM FOR COMING TO MEET"            nil     )
    (#x004dec "HEXAGRAM FOR GATHERING TOGETHER"        nil     )
    (#x004ded "HEXAGRAM FOR PUSHING UPWARD"            nil     )
    (#x004dee "HEXAGRAM FOR OPPRESSION"                nil     )
    (#x004def "HEXAGRAM FOR THE WELL"                  nil     )
    (#x004df0 "HEXAGRAM FOR REVOLUTION"                nil     )
    (#x004df1 "HEXAGRAM FOR THE CAULDRON"              nil     )
    (#x004df2 "HEXAGRAM FOR THE AROUSING THUNDER"      nil     )
    (#x004df3 "HEXAGRAM FOR THE KEEPING STILL MOUNTAIN" nil     )
    (#x004df4 "HEXAGRAM FOR DEVELOPMENT"               nil     )
    (#x004df5 "HEXAGRAM FOR THE MARRYING MAIDEN"       nil     )
    (#x004df6 "HEXAGRAM FOR ABUNDANCE"                 nil     )
    (#x004df7 "HEXAGRAM FOR THE WANDERER"              nil     )
    (#x004df8 "HEXAGRAM FOR THE GENTLE WIND"           nil     )
    (#x004df9 "HEXAGRAM FOR THE JOYOUS LAKE"           nil     )
    (#x004dfa "HEXAGRAM FOR DISPERSION"                nil     )
    (#x004dfb "HEXAGRAM FOR LIMITATION"                nil     )
    (#x004dfc "HEXAGRAM FOR INNER TRUTH"               nil     )
    (#x004dfd "HEXAGRAM FOR SMALL PREPONDERANCE"       nil     )
    (#x004dfe "HEXAGRAM FOR AFTER COMPLETION"          nil     )
    (#x004dff "HEXAGRAM FOR BEFORE COMPLETION"         nil     )
    (#x00a000 "YI SYLLABLE IT"                         nil     )
    (#x00a001 "YI SYLLABLE IX"                         nil     )
    (#x00a002 "YI SYLLABLE I"                          nil     )
    (#x00a003 "YI SYLLABLE IP"                         nil     )
    (#x00a004 "YI SYLLABLE IET"                        nil     )
    (#x00a005 "YI SYLLABLE IEX"                        nil     )
    (#x00a006 "YI SYLLABLE IE"                         nil     )
    (#x00a007 "YI SYLLABLE IEP"                        nil     )
    (#x00a008 "YI SYLLABLE AT"                         nil     )
    (#x00a009 "YI SYLLABLE AX"                         nil     )
    (#x00a00a "YI SYLLABLE A"                          nil     )
    (#x00a00b "YI SYLLABLE AP"                         nil     )
    (#x00a00c "YI SYLLABLE UOX"                        nil     )
    (#x00a00d "YI SYLLABLE UO"                         nil     )
    (#x00a00e "YI SYLLABLE UOP"                        nil     )
    (#x00a00f "YI SYLLABLE OT"                         nil     )
    (#x00a010 "YI SYLLABLE OX"                         nil     )
    (#x00a011 "YI SYLLABLE O"                          nil     )
    (#x00a012 "YI SYLLABLE OP"                         nil     )
    (#x00a013 "YI SYLLABLE EX"                         nil     )
    (#x00a014 "YI SYLLABLE E"                          nil     )
    (#x00a015 "YI SYLLABLE WU"                         nil     )
    (#x00a016 "YI SYLLABLE BIT"                        nil     )
    (#x00a017 "YI SYLLABLE BIX"                        nil     )
    (#x00a018 "YI SYLLABLE BI"                         nil     )
    (#x00a019 "YI SYLLABLE BIP"                        nil     )
    (#x00a01a "YI SYLLABLE BIET"                       nil     )
    (#x00a01b "YI SYLLABLE BIEX"                       nil     )
    (#x00a01c "YI SYLLABLE BIE"                        nil     )
    (#x00a01d "YI SYLLABLE BIEP"                       nil     )
    (#x00a01e "YI SYLLABLE BAT"                        nil     )
    (#x00a01f "YI SYLLABLE BAX"                        nil     )
    (#x00a020 "YI SYLLABLE BA"                         nil     )
    (#x00a021 "YI SYLLABLE BAP"                        nil     )
    (#x00a022 "YI SYLLABLE BUOX"                       nil     )
    (#x00a023 "YI SYLLABLE BUO"                        nil     )
    (#x00a024 "YI SYLLABLE BUOP"                       nil     )
    (#x00a025 "YI SYLLABLE BOT"                        nil     )
    (#x00a026 "YI SYLLABLE BOX"                        nil     )
    (#x00a027 "YI SYLLABLE BO"                         nil     )
    (#x00a028 "YI SYLLABLE BOP"                        nil     )
    (#x00a029 "YI SYLLABLE BEX"                        nil     )
    (#x00a02a "YI SYLLABLE BE"                         nil     )
    (#x00a02b "YI SYLLABLE BEP"                        nil     )
    (#x00a02c "YI SYLLABLE BUT"                        nil     )
    (#x00a02d "YI SYLLABLE BUX"                        nil     )
    (#x00a02e "YI SYLLABLE BU"                         nil     )
    (#x00a02f "YI SYLLABLE BUP"                        nil     )
    (#x00a030 "YI SYLLABLE BURX"                       nil     )
    (#x00a031 "YI SYLLABLE BUR"                        nil     )
    (#x00a032 "YI SYLLABLE BYT"                        nil     )
    (#x00a033 "YI SYLLABLE BYX"                        nil     )
    (#x00a034 "YI SYLLABLE BY"                         nil     )
    (#x00a035 "YI SYLLABLE BYP"                        nil     )
    (#x00a036 "YI SYLLABLE BYRX"                       nil     )
    (#x00a037 "YI SYLLABLE BYR"                        nil     )
    (#x00a038 "YI SYLLABLE PIT"                        nil     )
    (#x00a039 "YI SYLLABLE PIX"                        nil     )
    (#x00a03a "YI SYLLABLE PI"                         nil     )
    (#x00a03b "YI SYLLABLE PIP"                        nil     )
    (#x00a03c "YI SYLLABLE PIEX"                       nil     )
    (#x00a03d "YI SYLLABLE PIE"                        nil     )
    (#x00a03e "YI SYLLABLE PIEP"                       nil     )
    (#x00a03f "YI SYLLABLE PAT"                        nil     )
    (#x00a040 "YI SYLLABLE PAX"                        nil     )
    (#x00a041 "YI SYLLABLE PA"                         nil     )
    (#x00a042 "YI SYLLABLE PAP"                        nil     )
    (#x00a043 "YI SYLLABLE PUOX"                       nil     )
    (#x00a044 "YI SYLLABLE PUO"                        nil     )
    (#x00a045 "YI SYLLABLE PUOP"                       nil     )
    (#x00a046 "YI SYLLABLE POT"                        nil     )
    (#x00a047 "YI SYLLABLE POX"                        nil     )
    (#x00a048 "YI SYLLABLE PO"                         nil     )
    (#x00a049 "YI SYLLABLE POP"                        nil     )
    (#x00a04a "YI SYLLABLE PUT"                        nil     )
    (#x00a04b "YI SYLLABLE PUX"                        nil     )
    (#x00a04c "YI SYLLABLE PU"                         nil     )
    (#x00a04d "YI SYLLABLE PUP"                        nil     )
    (#x00a04e "YI SYLLABLE PURX"                       nil     )
    (#x00a04f "YI SYLLABLE PUR"                        nil     )
    (#x00a050 "YI SYLLABLE PYT"                        nil     )
    (#x00a051 "YI SYLLABLE PYX"                        nil     )
    (#x00a052 "YI SYLLABLE PY"                         nil     )
    (#x00a053 "YI SYLLABLE PYP"                        nil     )
    (#x00a054 "YI SYLLABLE PYRX"                       nil     )
    (#x00a055 "YI SYLLABLE PYR"                        nil     )
    (#x00a056 "YI SYLLABLE BBIT"                       nil     )
    (#x00a057 "YI SYLLABLE BBIX"                       nil     )
    (#x00a058 "YI SYLLABLE BBI"                        nil     )
    (#x00a059 "YI SYLLABLE BBIP"                       nil     )
    (#x00a05a "YI SYLLABLE BBIET"                      nil     )
    (#x00a05b "YI SYLLABLE BBIEX"                      nil     )
    (#x00a05c "YI SYLLABLE BBIE"                       nil     )
    (#x00a05d "YI SYLLABLE BBIEP"                      nil     )
    (#x00a05e "YI SYLLABLE BBAT"                       nil     )
    (#x00a05f "YI SYLLABLE BBAX"                       nil     )
    (#x00a060 "YI SYLLABLE BBA"                        nil     )
    (#x00a061 "YI SYLLABLE BBAP"                       nil     )
    (#x00a062 "YI SYLLABLE BBUOX"                      nil     )
    (#x00a063 "YI SYLLABLE BBUO"                       nil     )
    (#x00a064 "YI SYLLABLE BBUOP"                      nil     )
    (#x00a065 "YI SYLLABLE BBOT"                       nil     )
    (#x00a066 "YI SYLLABLE BBOX"                       nil     )
    (#x00a067 "YI SYLLABLE BBO"                        nil     )
    (#x00a068 "YI SYLLABLE BBOP"                       nil     )
    (#x00a069 "YI SYLLABLE BBEX"                       nil     )
    (#x00a06a "YI SYLLABLE BBE"                        nil     )
    (#x00a06b "YI SYLLABLE BBEP"                       nil     )
    (#x00a06c "YI SYLLABLE BBUT"                       nil     )
    (#x00a06d "YI SYLLABLE BBUX"                       nil     )
    (#x00a06e "YI SYLLABLE BBU"                        nil     )
    (#x00a06f "YI SYLLABLE BBUP"                       nil     )
    (#x00a070 "YI SYLLABLE BBURX"                      nil     )
    (#x00a071 "YI SYLLABLE BBUR"                       nil     )
    (#x00a072 "YI SYLLABLE BBYT"                       nil     )
    (#x00a073 "YI SYLLABLE BBYX"                       nil     )
    (#x00a074 "YI SYLLABLE BBY"                        nil     )
    (#x00a075 "YI SYLLABLE BBYP"                       nil     )
    (#x00a076 "YI SYLLABLE NBIT"                       nil     )
    (#x00a077 "YI SYLLABLE NBIX"                       nil     )
    (#x00a078 "YI SYLLABLE NBI"                        nil     )
    (#x00a079 "YI SYLLABLE NBIP"                       nil     )
    (#x00a07a "YI SYLLABLE NBIEX"                      nil     )
    (#x00a07b "YI SYLLABLE NBIE"                       nil     )
    (#x00a07c "YI SYLLABLE NBIEP"                      nil     )
    (#x00a07d "YI SYLLABLE NBAT"                       nil     )
    (#x00a07e "YI SYLLABLE NBAX"                       nil     )
    (#x00a07f "YI SYLLABLE NBA"                        nil     )
    (#x00a080 "YI SYLLABLE NBAP"                       nil     )
    (#x00a081 "YI SYLLABLE NBOT"                       nil     )
    (#x00a082 "YI SYLLABLE NBOX"                       nil     )
    (#x00a083 "YI SYLLABLE NBO"                        nil     )
    (#x00a084 "YI SYLLABLE NBOP"                       nil     )
    (#x00a085 "YI SYLLABLE NBUT"                       nil     )
    (#x00a086 "YI SYLLABLE NBUX"                       nil     )
    (#x00a087 "YI SYLLABLE NBU"                        nil     )
    (#x00a088 "YI SYLLABLE NBUP"                       nil     )
    (#x00a089 "YI SYLLABLE NBURX"                      nil     )
    (#x00a08a "YI SYLLABLE NBUR"                       nil     )
    (#x00a08b "YI SYLLABLE NBYT"                       nil     )
    (#x00a08c "YI SYLLABLE NBYX"                       nil     )
    (#x00a08d "YI SYLLABLE NBY"                        nil     )
    (#x00a08e "YI SYLLABLE NBYP"                       nil     )
    (#x00a08f "YI SYLLABLE NBYRX"                      nil     )
    (#x00a090 "YI SYLLABLE NBYR"                       nil     )
    (#x00a091 "YI SYLLABLE HMIT"                       nil     )
    (#x00a092 "YI SYLLABLE HMIX"                       nil     )
    (#x00a093 "YI SYLLABLE HMI"                        nil     )
    (#x00a094 "YI SYLLABLE HMIP"                       nil     )
    (#x00a095 "YI SYLLABLE HMIEX"                      nil     )
    (#x00a096 "YI SYLLABLE HMIE"                       nil     )
    (#x00a097 "YI SYLLABLE HMIEP"                      nil     )
    (#x00a098 "YI SYLLABLE HMAT"                       nil     )
    (#x00a099 "YI SYLLABLE HMAX"                       nil     )
    (#x00a09a "YI SYLLABLE HMA"                        nil     )
    (#x00a09b "YI SYLLABLE HMAP"                       nil     )
    (#x00a09c "YI SYLLABLE HMUOX"                      nil     )
    (#x00a09d "YI SYLLABLE HMUO"                       nil     )
    (#x00a09e "YI SYLLABLE HMUOP"                      nil     )
    (#x00a09f "YI SYLLABLE HMOT"                       nil     )
    (#x00a0a0 "YI SYLLABLE HMOX"                       nil     )
    (#x00a0a1 "YI SYLLABLE HMO"                        nil     )
    (#x00a0a2 "YI SYLLABLE HMOP"                       nil     )
    (#x00a0a3 "YI SYLLABLE HMUT"                       nil     )
    (#x00a0a4 "YI SYLLABLE HMUX"                       nil     )
    (#x00a0a5 "YI SYLLABLE HMU"                        nil     )
    (#x00a0a6 "YI SYLLABLE HMUP"                       nil     )
    (#x00a0a7 "YI SYLLABLE HMURX"                      nil     )
    (#x00a0a8 "YI SYLLABLE HMUR"                       nil     )
    (#x00a0a9 "YI SYLLABLE HMYX"                       nil     )
    (#x00a0aa "YI SYLLABLE HMY"                        nil     )
    (#x00a0ab "YI SYLLABLE HMYP"                       nil     )
    (#x00a0ac "YI SYLLABLE HMYRX"                      nil     )
    (#x00a0ad "YI SYLLABLE HMYR"                       nil     )
    (#x00a0ae "YI SYLLABLE MIT"                        nil     )
    (#x00a0af "YI SYLLABLE MIX"                        nil     )
    (#x00a0b0 "YI SYLLABLE MI"                         nil     )
    (#x00a0b1 "YI SYLLABLE MIP"                        nil     )
    (#x00a0b2 "YI SYLLABLE MIEX"                       nil     )
    (#x00a0b3 "YI SYLLABLE MIE"                        nil     )
    (#x00a0b4 "YI SYLLABLE MIEP"                       nil     )
    (#x00a0b5 "YI SYLLABLE MAT"                        nil     )
    (#x00a0b6 "YI SYLLABLE MAX"                        nil     )
    (#x00a0b7 "YI SYLLABLE MA"                         nil     )
    (#x00a0b8 "YI SYLLABLE MAP"                        nil     )
    (#x00a0b9 "YI SYLLABLE MUOT"                       nil     )
    (#x00a0ba "YI SYLLABLE MUOX"                       nil     )
    (#x00a0bb "YI SYLLABLE MUO"                        nil     )
    (#x00a0bc "YI SYLLABLE MUOP"                       nil     )
    (#x00a0bd "YI SYLLABLE MOT"                        nil     )
    (#x00a0be "YI SYLLABLE MOX"                        nil     )
    (#x00a0bf "YI SYLLABLE MO"                         nil     )
    (#x00a0c0 "YI SYLLABLE MOP"                        nil     )
    (#x00a0c1 "YI SYLLABLE MEX"                        nil     )
    (#x00a0c2 "YI SYLLABLE ME"                         nil     )
    (#x00a0c3 "YI SYLLABLE MUT"                        nil     )
    (#x00a0c4 "YI SYLLABLE MUX"                        nil     )
    (#x00a0c5 "YI SYLLABLE MU"                         nil     )
    (#x00a0c6 "YI SYLLABLE MUP"                        nil     )
    (#x00a0c7 "YI SYLLABLE MURX"                       nil     )
    (#x00a0c8 "YI SYLLABLE MUR"                        nil     )
    (#x00a0c9 "YI SYLLABLE MYT"                        nil     )
    (#x00a0ca "YI SYLLABLE MYX"                        nil     )
    (#x00a0cb "YI SYLLABLE MY"                         nil     )
    (#x00a0cc "YI SYLLABLE MYP"                        nil     )
    (#x00a0cd "YI SYLLABLE FIT"                        nil     )
    (#x00a0ce "YI SYLLABLE FIX"                        nil     )
    (#x00a0cf "YI SYLLABLE FI"                         nil     )
    (#x00a0d0 "YI SYLLABLE FIP"                        nil     )
    (#x00a0d1 "YI SYLLABLE FAT"                        nil     )
    (#x00a0d2 "YI SYLLABLE FAX"                        nil     )
    (#x00a0d3 "YI SYLLABLE FA"                         nil     )
    (#x00a0d4 "YI SYLLABLE FAP"                        nil     )
    (#x00a0d5 "YI SYLLABLE FOX"                        nil     )
    (#x00a0d6 "YI SYLLABLE FO"                         nil     )
    (#x00a0d7 "YI SYLLABLE FOP"                        nil     )
    (#x00a0d8 "YI SYLLABLE FUT"                        nil     )
    (#x00a0d9 "YI SYLLABLE FUX"                        nil     )
    (#x00a0da "YI SYLLABLE FU"                         nil     )
    (#x00a0db "YI SYLLABLE FUP"                        nil     )
    (#x00a0dc "YI SYLLABLE FURX"                       nil     )
    (#x00a0dd "YI SYLLABLE FUR"                        nil     )
    (#x00a0de "YI SYLLABLE FYT"                        nil     )
    (#x00a0df "YI SYLLABLE FYX"                        nil     )
    (#x00a0e0 "YI SYLLABLE FY"                         nil     )
    (#x00a0e1 "YI SYLLABLE FYP"                        nil     )
    (#x00a0e2 "YI SYLLABLE VIT"                        nil     )
    (#x00a0e3 "YI SYLLABLE VIX"                        nil     )
    (#x00a0e4 "YI SYLLABLE VI"                         nil     )
    (#x00a0e5 "YI SYLLABLE VIP"                        nil     )
    (#x00a0e6 "YI SYLLABLE VIET"                       nil     )
    (#x00a0e7 "YI SYLLABLE VIEX"                       nil     )
    (#x00a0e8 "YI SYLLABLE VIE"                        nil     )
    (#x00a0e9 "YI SYLLABLE VIEP"                       nil     )
    (#x00a0ea "YI SYLLABLE VAT"                        nil     )
    (#x00a0eb "YI SYLLABLE VAX"                        nil     )
    (#x00a0ec "YI SYLLABLE VA"                         nil     )
    (#x00a0ed "YI SYLLABLE VAP"                        nil     )
    (#x00a0ee "YI SYLLABLE VOT"                        nil     )
    (#x00a0ef "YI SYLLABLE VOX"                        nil     )
    (#x00a0f0 "YI SYLLABLE VO"                         nil     )
    (#x00a0f1 "YI SYLLABLE VOP"                        nil     )
    (#x00a0f2 "YI SYLLABLE VEX"                        nil     )
    (#x00a0f3 "YI SYLLABLE VEP"                        nil     )
    (#x00a0f4 "YI SYLLABLE VUT"                        nil     )
    (#x00a0f5 "YI SYLLABLE VUX"                        nil     )
    (#x00a0f6 "YI SYLLABLE VU"                         nil     )
    (#x00a0f7 "YI SYLLABLE VUP"                        nil     )
    (#x00a0f8 "YI SYLLABLE VURX"                       nil     )
    (#x00a0f9 "YI SYLLABLE VUR"                        nil     )
    (#x00a0fa "YI SYLLABLE VYT"                        nil     )
    (#x00a0fb "YI SYLLABLE VYX"                        nil     )
    (#x00a0fc "YI SYLLABLE VY"                         nil     )
    (#x00a0fd "YI SYLLABLE VYP"                        nil     )
    (#x00a0fe "YI SYLLABLE VYRX"                       nil     )
    (#x00a0ff "YI SYLLABLE VYR"                        nil     )
    (#x00a100 "YI SYLLABLE DIT"                        nil     )
    (#x00a101 "YI SYLLABLE DIX"                        nil     )
    (#x00a102 "YI SYLLABLE DI"                         nil     )
    (#x00a103 "YI SYLLABLE DIP"                        nil     )
    (#x00a104 "YI SYLLABLE DIEX"                       nil     )
    (#x00a105 "YI SYLLABLE DIE"                        nil     )
    (#x00a106 "YI SYLLABLE DIEP"                       nil     )
    (#x00a107 "YI SYLLABLE DAT"                        nil     )
    (#x00a108 "YI SYLLABLE DAX"                        nil     )
    (#x00a109 "YI SYLLABLE DA"                         nil     )
    (#x00a10a "YI SYLLABLE DAP"                        nil     )
    (#x00a10b "YI SYLLABLE DUOX"                       nil     )
    (#x00a10c "YI SYLLABLE DUO"                        nil     )
    (#x00a10d "YI SYLLABLE DOT"                        nil     )
    (#x00a10e "YI SYLLABLE DOX"                        nil     )
    (#x00a10f "YI SYLLABLE DO"                         nil     )
    (#x00a110 "YI SYLLABLE DOP"                        nil     )
    (#x00a111 "YI SYLLABLE DEX"                        nil     )
    (#x00a112 "YI SYLLABLE DE"                         nil     )
    (#x00a113 "YI SYLLABLE DEP"                        nil     )
    (#x00a114 "YI SYLLABLE DUT"                        nil     )
    (#x00a115 "YI SYLLABLE DUX"                        nil     )
    (#x00a116 "YI SYLLABLE DU"                         nil     )
    (#x00a117 "YI SYLLABLE DUP"                        nil     )
    (#x00a118 "YI SYLLABLE DURX"                       nil     )
    (#x00a119 "YI SYLLABLE DUR"                        nil     )
    (#x00a11a "YI SYLLABLE TIT"                        nil     )
    (#x00a11b "YI SYLLABLE TIX"                        nil     )
    (#x00a11c "YI SYLLABLE TI"                         nil     )
    (#x00a11d "YI SYLLABLE TIP"                        nil     )
    (#x00a11e "YI SYLLABLE TIEX"                       nil     )
    (#x00a11f "YI SYLLABLE TIE"                        nil     )
    (#x00a120 "YI SYLLABLE TIEP"                       nil     )
    (#x00a121 "YI SYLLABLE TAT"                        nil     )
    (#x00a122 "YI SYLLABLE TAX"                        nil     )
    (#x00a123 "YI SYLLABLE TA"                         nil     )
    (#x00a124 "YI SYLLABLE TAP"                        nil     )
    (#x00a125 "YI SYLLABLE TUOT"                       nil     )
    (#x00a126 "YI SYLLABLE TUOX"                       nil     )
    (#x00a127 "YI SYLLABLE TUO"                        nil     )
    (#x00a128 "YI SYLLABLE TUOP"                       nil     )
    (#x00a129 "YI SYLLABLE TOT"                        nil     )
    (#x00a12a "YI SYLLABLE TOX"                        nil     )
    (#x00a12b "YI SYLLABLE TO"                         nil     )
    (#x00a12c "YI SYLLABLE TOP"                        nil     )
    (#x00a12d "YI SYLLABLE TEX"                        nil     )
    (#x00a12e "YI SYLLABLE TE"                         nil     )
    (#x00a12f "YI SYLLABLE TEP"                        nil     )
    (#x00a130 "YI SYLLABLE TUT"                        nil     )
    (#x00a131 "YI SYLLABLE TUX"                        nil     )
    (#x00a132 "YI SYLLABLE TU"                         nil     )
    (#x00a133 "YI SYLLABLE TUP"                        nil     )
    (#x00a134 "YI SYLLABLE TURX"                       nil     )
    (#x00a135 "YI SYLLABLE TUR"                        nil     )
    (#x00a136 "YI SYLLABLE DDIT"                       nil     )
    (#x00a137 "YI SYLLABLE DDIX"                       nil     )
    (#x00a138 "YI SYLLABLE DDI"                        nil     )
    (#x00a139 "YI SYLLABLE DDIP"                       nil     )
    (#x00a13a "YI SYLLABLE DDIEX"                      nil     )
    (#x00a13b "YI SYLLABLE DDIE"                       nil     )
    (#x00a13c "YI SYLLABLE DDIEP"                      nil     )
    (#x00a13d "YI SYLLABLE DDAT"                       nil     )
    (#x00a13e "YI SYLLABLE DDAX"                       nil     )
    (#x00a13f "YI SYLLABLE DDA"                        nil     )
    (#x00a140 "YI SYLLABLE DDAP"                       nil     )
    (#x00a141 "YI SYLLABLE DDUOX"                      nil     )
    (#x00a142 "YI SYLLABLE DDUO"                       nil     )
    (#x00a143 "YI SYLLABLE DDUOP"                      nil     )
    (#x00a144 "YI SYLLABLE DDOT"                       nil     )
    (#x00a145 "YI SYLLABLE DDOX"                       nil     )
    (#x00a146 "YI SYLLABLE DDO"                        nil     )
    (#x00a147 "YI SYLLABLE DDOP"                       nil     )
    (#x00a148 "YI SYLLABLE DDEX"                       nil     )
    (#x00a149 "YI SYLLABLE DDE"                        nil     )
    (#x00a14a "YI SYLLABLE DDEP"                       nil     )
    (#x00a14b "YI SYLLABLE DDUT"                       nil     )
    (#x00a14c "YI SYLLABLE DDUX"                       nil     )
    (#x00a14d "YI SYLLABLE DDU"                        nil     )
    (#x00a14e "YI SYLLABLE DDUP"                       nil     )
    (#x00a14f "YI SYLLABLE DDURX"                      nil     )
    (#x00a150 "YI SYLLABLE DDUR"                       nil     )
    (#x00a151 "YI SYLLABLE NDIT"                       nil     )
    (#x00a152 "YI SYLLABLE NDIX"                       nil     )
    (#x00a153 "YI SYLLABLE NDI"                        nil     )
    (#x00a154 "YI SYLLABLE NDIP"                       nil     )
    (#x00a155 "YI SYLLABLE NDIEX"                      nil     )
    (#x00a156 "YI SYLLABLE NDIE"                       nil     )
    (#x00a157 "YI SYLLABLE NDAT"                       nil     )
    (#x00a158 "YI SYLLABLE NDAX"                       nil     )
    (#x00a159 "YI SYLLABLE NDA"                        nil     )
    (#x00a15a "YI SYLLABLE NDAP"                       nil     )
    (#x00a15b "YI SYLLABLE NDOT"                       nil     )
    (#x00a15c "YI SYLLABLE NDOX"                       nil     )
    (#x00a15d "YI SYLLABLE NDO"                        nil     )
    (#x00a15e "YI SYLLABLE NDOP"                       nil     )
    (#x00a15f "YI SYLLABLE NDEX"                       nil     )
    (#x00a160 "YI SYLLABLE NDE"                        nil     )
    (#x00a161 "YI SYLLABLE NDEP"                       nil     )
    (#x00a162 "YI SYLLABLE NDUT"                       nil     )
    (#x00a163 "YI SYLLABLE NDUX"                       nil     )
    (#x00a164 "YI SYLLABLE NDU"                        nil     )
    (#x00a165 "YI SYLLABLE NDUP"                       nil     )
    (#x00a166 "YI SYLLABLE NDURX"                      nil     )
    (#x00a167 "YI SYLLABLE NDUR"                       nil     )
    (#x00a168 "YI SYLLABLE HNIT"                       nil     )
    (#x00a169 "YI SYLLABLE HNIX"                       nil     )
    (#x00a16a "YI SYLLABLE HNI"                        nil     )
    (#x00a16b "YI SYLLABLE HNIP"                       nil     )
    (#x00a16c "YI SYLLABLE HNIET"                      nil     )
    (#x00a16d "YI SYLLABLE HNIEX"                      nil     )
    (#x00a16e "YI SYLLABLE HNIE"                       nil     )
    (#x00a16f "YI SYLLABLE HNIEP"                      nil     )
    (#x00a170 "YI SYLLABLE HNAT"                       nil     )
    (#x00a171 "YI SYLLABLE HNAX"                       nil     )
    (#x00a172 "YI SYLLABLE HNA"                        nil     )
    (#x00a173 "YI SYLLABLE HNAP"                       nil     )
    (#x00a174 "YI SYLLABLE HNUOX"                      nil     )
    (#x00a175 "YI SYLLABLE HNUO"                       nil     )
    (#x00a176 "YI SYLLABLE HNOT"                       nil     )
    (#x00a177 "YI SYLLABLE HNOX"                       nil     )
    (#x00a178 "YI SYLLABLE HNOP"                       nil     )
    (#x00a179 "YI SYLLABLE HNEX"                       nil     )
    (#x00a17a "YI SYLLABLE HNE"                        nil     )
    (#x00a17b "YI SYLLABLE HNEP"                       nil     )
    (#x00a17c "YI SYLLABLE HNUT"                       nil     )
    (#x00a17d "YI SYLLABLE NIT"                        nil     )
    (#x00a17e "YI SYLLABLE NIX"                        nil     )
    (#x00a17f "YI SYLLABLE NI"                         nil     )
    (#x00a180 "YI SYLLABLE NIP"                        nil     )
    (#x00a181 "YI SYLLABLE NIEX"                       nil     )
    (#x00a182 "YI SYLLABLE NIE"                        nil     )
    (#x00a183 "YI SYLLABLE NIEP"                       nil     )
    (#x00a184 "YI SYLLABLE NAX"                        nil     )
    (#x00a185 "YI SYLLABLE NA"                         nil     )
    (#x00a186 "YI SYLLABLE NAP"                        nil     )
    (#x00a187 "YI SYLLABLE NUOX"                       nil     )
    (#x00a188 "YI SYLLABLE NUO"                        nil     )
    (#x00a189 "YI SYLLABLE NUOP"                       nil     )
    (#x00a18a "YI SYLLABLE NOT"                        nil     )
    (#x00a18b "YI SYLLABLE NOX"                        nil     )
    (#x00a18c "YI SYLLABLE NO"                         nil     )
    (#x00a18d "YI SYLLABLE NOP"                        nil     )
    (#x00a18e "YI SYLLABLE NEX"                        nil     )
    (#x00a18f "YI SYLLABLE NE"                         nil     )
    (#x00a190 "YI SYLLABLE NEP"                        nil     )
    (#x00a191 "YI SYLLABLE NUT"                        nil     )
    (#x00a192 "YI SYLLABLE NUX"                        nil     )
    (#x00a193 "YI SYLLABLE NU"                         nil     )
    (#x00a194 "YI SYLLABLE NUP"                        nil     )
    (#x00a195 "YI SYLLABLE NURX"                       nil     )
    (#x00a196 "YI SYLLABLE NUR"                        nil     )
    (#x00a197 "YI SYLLABLE HLIT"                       nil     )
    (#x00a198 "YI SYLLABLE HLIX"                       nil     )
    (#x00a199 "YI SYLLABLE HLI"                        nil     )
    (#x00a19a "YI SYLLABLE HLIP"                       nil     )
    (#x00a19b "YI SYLLABLE HLIEX"                      nil     )
    (#x00a19c "YI SYLLABLE HLIE"                       nil     )
    (#x00a19d "YI SYLLABLE HLIEP"                      nil     )
    (#x00a19e "YI SYLLABLE HLAT"                       nil     )
    (#x00a19f "YI SYLLABLE HLAX"                       nil     )
    (#x00a1a0 "YI SYLLABLE HLA"                        nil     )
    (#x00a1a1 "YI SYLLABLE HLAP"                       nil     )
    (#x00a1a2 "YI SYLLABLE HLUOX"                      nil     )
    (#x00a1a3 "YI SYLLABLE HLUO"                       nil     )
    (#x00a1a4 "YI SYLLABLE HLUOP"                      nil     )
    (#x00a1a5 "YI SYLLABLE HLOX"                       nil     )
    (#x00a1a6 "YI SYLLABLE HLO"                        nil     )
    (#x00a1a7 "YI SYLLABLE HLOP"                       nil     )
    (#x00a1a8 "YI SYLLABLE HLEX"                       nil     )
    (#x00a1a9 "YI SYLLABLE HLE"                        nil     )
    (#x00a1aa "YI SYLLABLE HLEP"                       nil     )
    (#x00a1ab "YI SYLLABLE HLUT"                       nil     )
    (#x00a1ac "YI SYLLABLE HLUX"                       nil     )
    (#x00a1ad "YI SYLLABLE HLU"                        nil     )
    (#x00a1ae "YI SYLLABLE HLUP"                       nil     )
    (#x00a1af "YI SYLLABLE HLURX"                      nil     )
    (#x00a1b0 "YI SYLLABLE HLUR"                       nil     )
    (#x00a1b1 "YI SYLLABLE HLYT"                       nil     )
    (#x00a1b2 "YI SYLLABLE HLYX"                       nil     )
    (#x00a1b3 "YI SYLLABLE HLY"                        nil     )
    (#x00a1b4 "YI SYLLABLE HLYP"                       nil     )
    (#x00a1b5 "YI SYLLABLE HLYRX"                      nil     )
    (#x00a1b6 "YI SYLLABLE HLYR"                       nil     )
    (#x00a1b7 "YI SYLLABLE LIT"                        nil     )
    (#x00a1b8 "YI SYLLABLE LIX"                        nil     )
    (#x00a1b9 "YI SYLLABLE LI"                         nil     )
    (#x00a1ba "YI SYLLABLE LIP"                        nil     )
    (#x00a1bb "YI SYLLABLE LIET"                       nil     )
    (#x00a1bc "YI SYLLABLE LIEX"                       nil     )
    (#x00a1bd "YI SYLLABLE LIE"                        nil     )
    (#x00a1be "YI SYLLABLE LIEP"                       nil     )
    (#x00a1bf "YI SYLLABLE LAT"                        nil     )
    (#x00a1c0 "YI SYLLABLE LAX"                        nil     )
    (#x00a1c1 "YI SYLLABLE LA"                         nil     )
    (#x00a1c2 "YI SYLLABLE LAP"                        nil     )
    (#x00a1c3 "YI SYLLABLE LUOT"                       nil     )
    (#x00a1c4 "YI SYLLABLE LUOX"                       nil     )
    (#x00a1c5 "YI SYLLABLE LUO"                        nil     )
    (#x00a1c6 "YI SYLLABLE LUOP"                       nil     )
    (#x00a1c7 "YI SYLLABLE LOT"                        nil     )
    (#x00a1c8 "YI SYLLABLE LOX"                        nil     )
    (#x00a1c9 "YI SYLLABLE LO"                         nil     )
    (#x00a1ca "YI SYLLABLE LOP"                        nil     )
    (#x00a1cb "YI SYLLABLE LEX"                        nil     )
    (#x00a1cc "YI SYLLABLE LE"                         nil     )
    (#x00a1cd "YI SYLLABLE LEP"                        nil     )
    (#x00a1ce "YI SYLLABLE LUT"                        nil     )
    (#x00a1cf "YI SYLLABLE LUX"                        nil     )
    (#x00a1d0 "YI SYLLABLE LU"                         nil     )
    (#x00a1d1 "YI SYLLABLE LUP"                        nil     )
    (#x00a1d2 "YI SYLLABLE LURX"                       nil     )
    (#x00a1d3 "YI SYLLABLE LUR"                        nil     )
    (#x00a1d4 "YI SYLLABLE LYT"                        nil     )
    (#x00a1d5 "YI SYLLABLE LYX"                        nil     )
    (#x00a1d6 "YI SYLLABLE LY"                         nil     )
    (#x00a1d7 "YI SYLLABLE LYP"                        nil     )
    (#x00a1d8 "YI SYLLABLE LYRX"                       nil     )
    (#x00a1d9 "YI SYLLABLE LYR"                        nil     )
    (#x00a1da "YI SYLLABLE GIT"                        nil     )
    (#x00a1db "YI SYLLABLE GIX"                        nil     )
    (#x00a1dc "YI SYLLABLE GI"                         nil     )
    (#x00a1dd "YI SYLLABLE GIP"                        nil     )
    (#x00a1de "YI SYLLABLE GIET"                       nil     )
    (#x00a1df "YI SYLLABLE GIEX"                       nil     )
    (#x00a1e0 "YI SYLLABLE GIE"                        nil     )
    (#x00a1e1 "YI SYLLABLE GIEP"                       nil     )
    (#x00a1e2 "YI SYLLABLE GAT"                        nil     )
    (#x00a1e3 "YI SYLLABLE GAX"                        nil     )
    (#x00a1e4 "YI SYLLABLE GA"                         nil     )
    (#x00a1e5 "YI SYLLABLE GAP"                        nil     )
    (#x00a1e6 "YI SYLLABLE GUOT"                       nil     )
    (#x00a1e7 "YI SYLLABLE GUOX"                       nil     )
    (#x00a1e8 "YI SYLLABLE GUO"                        nil     )
    (#x00a1e9 "YI SYLLABLE GUOP"                       nil     )
    (#x00a1ea "YI SYLLABLE GOT"                        nil     )
    (#x00a1eb "YI SYLLABLE GOX"                        nil     )
    (#x00a1ec "YI SYLLABLE GO"                         nil     )
    (#x00a1ed "YI SYLLABLE GOP"                        nil     )
    (#x00a1ee "YI SYLLABLE GET"                        nil     )
    (#x00a1ef "YI SYLLABLE GEX"                        nil     )
    (#x00a1f0 "YI SYLLABLE GE"                         nil     )
    (#x00a1f1 "YI SYLLABLE GEP"                        nil     )
    (#x00a1f2 "YI SYLLABLE GUT"                        nil     )
    (#x00a1f3 "YI SYLLABLE GUX"                        nil     )
    (#x00a1f4 "YI SYLLABLE GU"                         nil     )
    (#x00a1f5 "YI SYLLABLE GUP"                        nil     )
    (#x00a1f6 "YI SYLLABLE GURX"                       nil     )
    (#x00a1f7 "YI SYLLABLE GUR"                        nil     )
    (#x00a1f8 "YI SYLLABLE KIT"                        nil     )
    (#x00a1f9 "YI SYLLABLE KIX"                        nil     )
    (#x00a1fa "YI SYLLABLE KI"                         nil     )
    (#x00a1fb "YI SYLLABLE KIP"                        nil     )
    (#x00a1fc "YI SYLLABLE KIEX"                       nil     )
    (#x00a1fd "YI SYLLABLE KIE"                        nil     )
    (#x00a1fe "YI SYLLABLE KIEP"                       nil     )
    (#x00a1ff "YI SYLLABLE KAT"                        nil     )
    (#x00a200 "YI SYLLABLE KAX"                        nil     )
    (#x00a201 "YI SYLLABLE KA"                         nil     )
    (#x00a202 "YI SYLLABLE KAP"                        nil     )
    (#x00a203 "YI SYLLABLE KUOX"                       nil     )
    (#x00a204 "YI SYLLABLE KUO"                        nil     )
    (#x00a205 "YI SYLLABLE KUOP"                       nil     )
    (#x00a206 "YI SYLLABLE KOT"                        nil     )
    (#x00a207 "YI SYLLABLE KOX"                        nil     )
    (#x00a208 "YI SYLLABLE KO"                         nil     )
    (#x00a209 "YI SYLLABLE KOP"                        nil     )
    (#x00a20a "YI SYLLABLE KET"                        nil     )
    (#x00a20b "YI SYLLABLE KEX"                        nil     )
    (#x00a20c "YI SYLLABLE KE"                         nil     )
    (#x00a20d "YI SYLLABLE KEP"                        nil     )
    (#x00a20e "YI SYLLABLE KUT"                        nil     )
    (#x00a20f "YI SYLLABLE KUX"                        nil     )
    (#x00a210 "YI SYLLABLE KU"                         nil     )
    (#x00a211 "YI SYLLABLE KUP"                        nil     )
    (#x00a212 "YI SYLLABLE KURX"                       nil     )
    (#x00a213 "YI SYLLABLE KUR"                        nil     )
    (#x00a214 "YI SYLLABLE GGIT"                       nil     )
    (#x00a215 "YI SYLLABLE GGIX"                       nil     )
    (#x00a216 "YI SYLLABLE GGI"                        nil     )
    (#x00a217 "YI SYLLABLE GGIEX"                      nil     )
    (#x00a218 "YI SYLLABLE GGIE"                       nil     )
    (#x00a219 "YI SYLLABLE GGIEP"                      nil     )
    (#x00a21a "YI SYLLABLE GGAT"                       nil     )
    (#x00a21b "YI SYLLABLE GGAX"                       nil     )
    (#x00a21c "YI SYLLABLE GGA"                        nil     )
    (#x00a21d "YI SYLLABLE GGAP"                       nil     )
    (#x00a21e "YI SYLLABLE GGUOT"                      nil     )
    (#x00a21f "YI SYLLABLE GGUOX"                      nil     )
    (#x00a220 "YI SYLLABLE GGUO"                       nil     )
    (#x00a221 "YI SYLLABLE GGUOP"                      nil     )
    (#x00a222 "YI SYLLABLE GGOT"                       nil     )
    (#x00a223 "YI SYLLABLE GGOX"                       nil     )
    (#x00a224 "YI SYLLABLE GGO"                        nil     )
    (#x00a225 "YI SYLLABLE GGOP"                       nil     )
    (#x00a226 "YI SYLLABLE GGET"                       nil     )
    (#x00a227 "YI SYLLABLE GGEX"                       nil     )
    (#x00a228 "YI SYLLABLE GGE"                        nil     )
    (#x00a229 "YI SYLLABLE GGEP"                       nil     )
    (#x00a22a "YI SYLLABLE GGUT"                       nil     )
    (#x00a22b "YI SYLLABLE GGUX"                       nil     )
    (#x00a22c "YI SYLLABLE GGU"                        nil     )
    (#x00a22d "YI SYLLABLE GGUP"                       nil     )
    (#x00a22e "YI SYLLABLE GGURX"                      nil     )
    (#x00a22f "YI SYLLABLE GGUR"                       nil     )
    (#x00a230 "YI SYLLABLE MGIEX"                      nil     )
    (#x00a231 "YI SYLLABLE MGIE"                       nil     )
    (#x00a232 "YI SYLLABLE MGAT"                       nil     )
    (#x00a233 "YI SYLLABLE MGAX"                       nil     )
    (#x00a234 "YI SYLLABLE MGA"                        nil     )
    (#x00a235 "YI SYLLABLE MGAP"                       nil     )
    (#x00a236 "YI SYLLABLE MGUOX"                      nil     )
    (#x00a237 "YI SYLLABLE MGUO"                       nil     )
    (#x00a238 "YI SYLLABLE MGUOP"                      nil     )
    (#x00a239 "YI SYLLABLE MGOT"                       nil     )
    (#x00a23a "YI SYLLABLE MGOX"                       nil     )
    (#x00a23b "YI SYLLABLE MGO"                        nil     )
    (#x00a23c "YI SYLLABLE MGOP"                       nil     )
    (#x00a23d "YI SYLLABLE MGEX"                       nil     )
    (#x00a23e "YI SYLLABLE MGE"                        nil     )
    (#x00a23f "YI SYLLABLE MGEP"                       nil     )
    (#x00a240 "YI SYLLABLE MGUT"                       nil     )
    (#x00a241 "YI SYLLABLE MGUX"                       nil     )
    (#x00a242 "YI SYLLABLE MGU"                        nil     )
    (#x00a243 "YI SYLLABLE MGUP"                       nil     )
    (#x00a244 "YI SYLLABLE MGURX"                      nil     )
    (#x00a245 "YI SYLLABLE MGUR"                       nil     )
    (#x00a246 "YI SYLLABLE HXIT"                       nil     )
    (#x00a247 "YI SYLLABLE HXIX"                       nil     )
    (#x00a248 "YI SYLLABLE HXI"                        nil     )
    (#x00a249 "YI SYLLABLE HXIP"                       nil     )
    (#x00a24a "YI SYLLABLE HXIET"                      nil     )
    (#x00a24b "YI SYLLABLE HXIEX"                      nil     )
    (#x00a24c "YI SYLLABLE HXIE"                       nil     )
    (#x00a24d "YI SYLLABLE HXIEP"                      nil     )
    (#x00a24e "YI SYLLABLE HXAT"                       nil     )
    (#x00a24f "YI SYLLABLE HXAX"                       nil     )
    (#x00a250 "YI SYLLABLE HXA"                        nil     )
    (#x00a251 "YI SYLLABLE HXAP"                       nil     )
    (#x00a252 "YI SYLLABLE HXUOT"                      nil     )
    (#x00a253 "YI SYLLABLE HXUOX"                      nil     )
    (#x00a254 "YI SYLLABLE HXUO"                       nil     )
    (#x00a255 "YI SYLLABLE HXUOP"                      nil     )
    (#x00a256 "YI SYLLABLE HXOT"                       nil     )
    (#x00a257 "YI SYLLABLE HXOX"                       nil     )
    (#x00a258 "YI SYLLABLE HXO"                        nil     )
    (#x00a259 "YI SYLLABLE HXOP"                       nil     )
    (#x00a25a "YI SYLLABLE HXEX"                       nil     )
    (#x00a25b "YI SYLLABLE HXE"                        nil     )
    (#x00a25c "YI SYLLABLE HXEP"                       nil     )
    (#x00a25d "YI SYLLABLE NGIEX"                      nil     )
    (#x00a25e "YI SYLLABLE NGIE"                       nil     )
    (#x00a25f "YI SYLLABLE NGIEP"                      nil     )
    (#x00a260 "YI SYLLABLE NGAT"                       nil     )
    (#x00a261 "YI SYLLABLE NGAX"                       nil     )
    (#x00a262 "YI SYLLABLE NGA"                        nil     )
    (#x00a263 "YI SYLLABLE NGAP"                       nil     )
    (#x00a264 "YI SYLLABLE NGUOT"                      nil     )
    (#x00a265 "YI SYLLABLE NGUOX"                      nil     )
    (#x00a266 "YI SYLLABLE NGUO"                       nil     )
    (#x00a267 "YI SYLLABLE NGOT"                       nil     )
    (#x00a268 "YI SYLLABLE NGOX"                       nil     )
    (#x00a269 "YI SYLLABLE NGO"                        nil     )
    (#x00a26a "YI SYLLABLE NGOP"                       nil     )
    (#x00a26b "YI SYLLABLE NGEX"                       nil     )
    (#x00a26c "YI SYLLABLE NGE"                        nil     )
    (#x00a26d "YI SYLLABLE NGEP"                       nil     )
    (#x00a26e "YI SYLLABLE HIT"                        nil     )
    (#x00a26f "YI SYLLABLE HIEX"                       nil     )
    (#x00a270 "YI SYLLABLE HIE"                        nil     )
    (#x00a271 "YI SYLLABLE HAT"                        nil     )
    (#x00a272 "YI SYLLABLE HAX"                        nil     )
    (#x00a273 "YI SYLLABLE HA"                         nil     )
    (#x00a274 "YI SYLLABLE HAP"                        nil     )
    (#x00a275 "YI SYLLABLE HUOT"                       nil     )
    (#x00a276 "YI SYLLABLE HUOX"                       nil     )
    (#x00a277 "YI SYLLABLE HUO"                        nil     )
    (#x00a278 "YI SYLLABLE HUOP"                       nil     )
    (#x00a279 "YI SYLLABLE HOT"                        nil     )
    (#x00a27a "YI SYLLABLE HOX"                        nil     )
    (#x00a27b "YI SYLLABLE HO"                         nil     )
    (#x00a27c "YI SYLLABLE HOP"                        nil     )
    (#x00a27d "YI SYLLABLE HEX"                        nil     )
    (#x00a27e "YI SYLLABLE HE"                         nil     )
    (#x00a27f "YI SYLLABLE HEP"                        nil     )
    (#x00a280 "YI SYLLABLE WAT"                        nil     )
    (#x00a281 "YI SYLLABLE WAX"                        nil     )
    (#x00a282 "YI SYLLABLE WA"                         nil     )
    (#x00a283 "YI SYLLABLE WAP"                        nil     )
    (#x00a284 "YI SYLLABLE WUOX"                       nil     )
    (#x00a285 "YI SYLLABLE WUO"                        nil     )
    (#x00a286 "YI SYLLABLE WUOP"                       nil     )
    (#x00a287 "YI SYLLABLE WOX"                        nil     )
    (#x00a288 "YI SYLLABLE WO"                         nil     )
    (#x00a289 "YI SYLLABLE WOP"                        nil     )
    (#x00a28a "YI SYLLABLE WEX"                        nil     )
    (#x00a28b "YI SYLLABLE WE"                         nil     )
    (#x00a28c "YI SYLLABLE WEP"                        nil     )
    (#x00a28d "YI SYLLABLE ZIT"                        nil     )
    (#x00a28e "YI SYLLABLE ZIX"                        nil     )
    (#x00a28f "YI SYLLABLE ZI"                         nil     )
    (#x00a290 "YI SYLLABLE ZIP"                        nil     )
    (#x00a291 "YI SYLLABLE ZIEX"                       nil     )
    (#x00a292 "YI SYLLABLE ZIE"                        nil     )
    (#x00a293 "YI SYLLABLE ZIEP"                       nil     )
    (#x00a294 "YI SYLLABLE ZAT"                        nil     )
    (#x00a295 "YI SYLLABLE ZAX"                        nil     )
    (#x00a296 "YI SYLLABLE ZA"                         nil     )
    (#x00a297 "YI SYLLABLE ZAP"                        nil     )
    (#x00a298 "YI SYLLABLE ZUOX"                       nil     )
    (#x00a299 "YI SYLLABLE ZUO"                        nil     )
    (#x00a29a "YI SYLLABLE ZUOP"                       nil     )
    (#x00a29b "YI SYLLABLE ZOT"                        nil     )
    (#x00a29c "YI SYLLABLE ZOX"                        nil     )
    (#x00a29d "YI SYLLABLE ZO"                         nil     )
    (#x00a29e "YI SYLLABLE ZOP"                        nil     )
    (#x00a29f "YI SYLLABLE ZEX"                        nil     )
    (#x00a2a0 "YI SYLLABLE ZE"                         nil     )
    (#x00a2a1 "YI SYLLABLE ZEP"                        nil     )
    (#x00a2a2 "YI SYLLABLE ZUT"                        nil     )
    (#x00a2a3 "YI SYLLABLE ZUX"                        nil     )
    (#x00a2a4 "YI SYLLABLE ZU"                         nil     )
    (#x00a2a5 "YI SYLLABLE ZUP"                        nil     )
    (#x00a2a6 "YI SYLLABLE ZURX"                       nil     )
    (#x00a2a7 "YI SYLLABLE ZUR"                        nil     )
    (#x00a2a8 "YI SYLLABLE ZYT"                        nil     )
    (#x00a2a9 "YI SYLLABLE ZYX"                        nil     )
    (#x00a2aa "YI SYLLABLE ZY"                         nil     )
    (#x00a2ab "YI SYLLABLE ZYP"                        nil     )
    (#x00a2ac "YI SYLLABLE ZYRX"                       nil     )
    (#x00a2ad "YI SYLLABLE ZYR"                        nil     )
    (#x00a2ae "YI SYLLABLE CIT"                        nil     )
    (#x00a2af "YI SYLLABLE CIX"                        nil     )
    (#x00a2b0 "YI SYLLABLE CI"                         nil     )
    (#x00a2b1 "YI SYLLABLE CIP"                        nil     )
    (#x00a2b2 "YI SYLLABLE CIET"                       nil     )
    (#x00a2b3 "YI SYLLABLE CIEX"                       nil     )
    (#x00a2b4 "YI SYLLABLE CIE"                        nil     )
    (#x00a2b5 "YI SYLLABLE CIEP"                       nil     )
    (#x00a2b6 "YI SYLLABLE CAT"                        nil     )
    (#x00a2b7 "YI SYLLABLE CAX"                        nil     )
    (#x00a2b8 "YI SYLLABLE CA"                         nil     )
    (#x00a2b9 "YI SYLLABLE CAP"                        nil     )
    (#x00a2ba "YI SYLLABLE CUOX"                       nil     )
    (#x00a2bb "YI SYLLABLE CUO"                        nil     )
    (#x00a2bc "YI SYLLABLE CUOP"                       nil     )
    (#x00a2bd "YI SYLLABLE COT"                        nil     )
    (#x00a2be "YI SYLLABLE COX"                        nil     )
    (#x00a2bf "YI SYLLABLE CO"                         nil     )
    (#x00a2c0 "YI SYLLABLE COP"                        nil     )
    (#x00a2c1 "YI SYLLABLE CEX"                        nil     )
    (#x00a2c2 "YI SYLLABLE CE"                         nil     )
    (#x00a2c3 "YI SYLLABLE CEP"                        nil     )
    (#x00a2c4 "YI SYLLABLE CUT"                        nil     )
    (#x00a2c5 "YI SYLLABLE CUX"                        nil     )
    (#x00a2c6 "YI SYLLABLE CU"                         nil     )
    (#x00a2c7 "YI SYLLABLE CUP"                        nil     )
    (#x00a2c8 "YI SYLLABLE CURX"                       nil     )
    (#x00a2c9 "YI SYLLABLE CUR"                        nil     )
    (#x00a2ca "YI SYLLABLE CYT"                        nil     )
    (#x00a2cb "YI SYLLABLE CYX"                        nil     )
    (#x00a2cc "YI SYLLABLE CY"                         nil     )
    (#x00a2cd "YI SYLLABLE CYP"                        nil     )
    (#x00a2ce "YI SYLLABLE CYRX"                       nil     )
    (#x00a2cf "YI SYLLABLE CYR"                        nil     )
    (#x00a2d0 "YI SYLLABLE ZZIT"                       nil     )
    (#x00a2d1 "YI SYLLABLE ZZIX"                       nil     )
    (#x00a2d2 "YI SYLLABLE ZZI"                        nil     )
    (#x00a2d3 "YI SYLLABLE ZZIP"                       nil     )
    (#x00a2d4 "YI SYLLABLE ZZIET"                      nil     )
    (#x00a2d5 "YI SYLLABLE ZZIEX"                      nil     )
    (#x00a2d6 "YI SYLLABLE ZZIE"                       nil     )
    (#x00a2d7 "YI SYLLABLE ZZIEP"                      nil     )
    (#x00a2d8 "YI SYLLABLE ZZAT"                       nil     )
    (#x00a2d9 "YI SYLLABLE ZZAX"                       nil     )
    (#x00a2da "YI SYLLABLE ZZA"                        nil     )
    (#x00a2db "YI SYLLABLE ZZAP"                       nil     )
    (#x00a2dc "YI SYLLABLE ZZOX"                       nil     )
    (#x00a2dd "YI SYLLABLE ZZO"                        nil     )
    (#x00a2de "YI SYLLABLE ZZOP"                       nil     )
    (#x00a2df "YI SYLLABLE ZZEX"                       nil     )
    (#x00a2e0 "YI SYLLABLE ZZE"                        nil     )
    (#x00a2e1 "YI SYLLABLE ZZEP"                       nil     )
    (#x00a2e2 "YI SYLLABLE ZZUX"                       nil     )
    (#x00a2e3 "YI SYLLABLE ZZU"                        nil     )
    (#x00a2e4 "YI SYLLABLE ZZUP"                       nil     )
    (#x00a2e5 "YI SYLLABLE ZZURX"                      nil     )
    (#x00a2e6 "YI SYLLABLE ZZUR"                       nil     )
    (#x00a2e7 "YI SYLLABLE ZZYT"                       nil     )
    (#x00a2e8 "YI SYLLABLE ZZYX"                       nil     )
    (#x00a2e9 "YI SYLLABLE ZZY"                        nil     )
    (#x00a2ea "YI SYLLABLE ZZYP"                       nil     )
    (#x00a2eb "YI SYLLABLE ZZYRX"                      nil     )
    (#x00a2ec "YI SYLLABLE ZZYR"                       nil     )
    (#x00a2ed "YI SYLLABLE NZIT"                       nil     )
    (#x00a2ee "YI SYLLABLE NZIX"                       nil     )
    (#x00a2ef "YI SYLLABLE NZI"                        nil     )
    (#x00a2f0 "YI SYLLABLE NZIP"                       nil     )
    (#x00a2f1 "YI SYLLABLE NZIEX"                      nil     )
    (#x00a2f2 "YI SYLLABLE NZIE"                       nil     )
    (#x00a2f3 "YI SYLLABLE NZIEP"                      nil     )
    (#x00a2f4 "YI SYLLABLE NZAT"                       nil     )
    (#x00a2f5 "YI SYLLABLE NZAX"                       nil     )
    (#x00a2f6 "YI SYLLABLE NZA"                        nil     )
    (#x00a2f7 "YI SYLLABLE NZAP"                       nil     )
    (#x00a2f8 "YI SYLLABLE NZUOX"                      nil     )
    (#x00a2f9 "YI SYLLABLE NZUO"                       nil     )
    (#x00a2fa "YI SYLLABLE NZOX"                       nil     )
    (#x00a2fb "YI SYLLABLE NZOP"                       nil     )
    (#x00a2fc "YI SYLLABLE NZEX"                       nil     )
    (#x00a2fd "YI SYLLABLE NZE"                        nil     )
    (#x00a2fe "YI SYLLABLE NZUX"                       nil     )
    (#x00a2ff "YI SYLLABLE NZU"                        nil     )
    (#x00a300 "YI SYLLABLE NZUP"                       nil     )
    (#x00a301 "YI SYLLABLE NZURX"                      nil     )
    (#x00a302 "YI SYLLABLE NZUR"                       nil     )
    (#x00a303 "YI SYLLABLE NZYT"                       nil     )
    (#x00a304 "YI SYLLABLE NZYX"                       nil     )
    (#x00a305 "YI SYLLABLE NZY"                        nil     )
    (#x00a306 "YI SYLLABLE NZYP"                       nil     )
    (#x00a307 "YI SYLLABLE NZYRX"                      nil     )
    (#x00a308 "YI SYLLABLE NZYR"                       nil     )
    (#x00a309 "YI SYLLABLE SIT"                        nil     )
    (#x00a30a "YI SYLLABLE SIX"                        nil     )
    (#x00a30b "YI SYLLABLE SI"                         nil     )
    (#x00a30c "YI SYLLABLE SIP"                        nil     )
    (#x00a30d "YI SYLLABLE SIEX"                       nil     )
    (#x00a30e "YI SYLLABLE SIE"                        nil     )
    (#x00a30f "YI SYLLABLE SIEP"                       nil     )
    (#x00a310 "YI SYLLABLE SAT"                        nil     )
    (#x00a311 "YI SYLLABLE SAX"                        nil     )
    (#x00a312 "YI SYLLABLE SA"                         nil     )
    (#x00a313 "YI SYLLABLE SAP"                        nil     )
    (#x00a314 "YI SYLLABLE SUOX"                       nil     )
    (#x00a315 "YI SYLLABLE SUO"                        nil     )
    (#x00a316 "YI SYLLABLE SUOP"                       nil     )
    (#x00a317 "YI SYLLABLE SOT"                        nil     )
    (#x00a318 "YI SYLLABLE SOX"                        nil     )
    (#x00a319 "YI SYLLABLE SO"                         nil     )
    (#x00a31a "YI SYLLABLE SOP"                        nil     )
    (#x00a31b "YI SYLLABLE SEX"                        nil     )
    (#x00a31c "YI SYLLABLE SE"                         nil     )
    (#x00a31d "YI SYLLABLE SEP"                        nil     )
    (#x00a31e "YI SYLLABLE SUT"                        nil     )
    (#x00a31f "YI SYLLABLE SUX"                        nil     )
    (#x00a320 "YI SYLLABLE SU"                         nil     )
    (#x00a321 "YI SYLLABLE SUP"                        nil     )
    (#x00a322 "YI SYLLABLE SURX"                       nil     )
    (#x00a323 "YI SYLLABLE SUR"                        nil     )
    (#x00a324 "YI SYLLABLE SYT"                        nil     )
    (#x00a325 "YI SYLLABLE SYX"                        nil     )
    (#x00a326 "YI SYLLABLE SY"                         nil     )
    (#x00a327 "YI SYLLABLE SYP"                        nil     )
    (#x00a328 "YI SYLLABLE SYRX"                       nil     )
    (#x00a329 "YI SYLLABLE SYR"                        nil     )
    (#x00a32a "YI SYLLABLE SSIT"                       nil     )
    (#x00a32b "YI SYLLABLE SSIX"                       nil     )
    (#x00a32c "YI SYLLABLE SSI"                        nil     )
    (#x00a32d "YI SYLLABLE SSIP"                       nil     )
    (#x00a32e "YI SYLLABLE SSIEX"                      nil     )
    (#x00a32f "YI SYLLABLE SSIE"                       nil     )
    (#x00a330 "YI SYLLABLE SSIEP"                      nil     )
    (#x00a331 "YI SYLLABLE SSAT"                       nil     )
    (#x00a332 "YI SYLLABLE SSAX"                       nil     )
    (#x00a333 "YI SYLLABLE SSA"                        nil     )
    (#x00a334 "YI SYLLABLE SSAP"                       nil     )
    (#x00a335 "YI SYLLABLE SSOT"                       nil     )
    (#x00a336 "YI SYLLABLE SSOX"                       nil     )
    (#x00a337 "YI SYLLABLE SSO"                        nil     )
    (#x00a338 "YI SYLLABLE SSOP"                       nil     )
    (#x00a339 "YI SYLLABLE SSEX"                       nil     )
    (#x00a33a "YI SYLLABLE SSE"                        nil     )
    (#x00a33b "YI SYLLABLE SSEP"                       nil     )
    (#x00a33c "YI SYLLABLE SSUT"                       nil     )
    (#x00a33d "YI SYLLABLE SSUX"                       nil     )
    (#x00a33e "YI SYLLABLE SSU"                        nil     )
    (#x00a33f "YI SYLLABLE SSUP"                       nil     )
    (#x00a340 "YI SYLLABLE SSYT"                       nil     )
    (#x00a341 "YI SYLLABLE SSYX"                       nil     )
    (#x00a342 "YI SYLLABLE SSY"                        nil     )
    (#x00a343 "YI SYLLABLE SSYP"                       nil     )
    (#x00a344 "YI SYLLABLE SSYRX"                      nil     )
    (#x00a345 "YI SYLLABLE SSYR"                       nil     )
    (#x00a346 "YI SYLLABLE ZHAT"                       nil     )
    (#x00a347 "YI SYLLABLE ZHAX"                       nil     )
    (#x00a348 "YI SYLLABLE ZHA"                        nil     )
    (#x00a349 "YI SYLLABLE ZHAP"                       nil     )
    (#x00a34a "YI SYLLABLE ZHUOX"                      nil     )
    (#x00a34b "YI SYLLABLE ZHUO"                       nil     )
    (#x00a34c "YI SYLLABLE ZHUOP"                      nil     )
    (#x00a34d "YI SYLLABLE ZHOT"                       nil     )
    (#x00a34e "YI SYLLABLE ZHOX"                       nil     )
    (#x00a34f "YI SYLLABLE ZHO"                        nil     )
    (#x00a350 "YI SYLLABLE ZHOP"                       nil     )
    (#x00a351 "YI SYLLABLE ZHET"                       nil     )
    (#x00a352 "YI SYLLABLE ZHEX"                       nil     )
    (#x00a353 "YI SYLLABLE ZHE"                        nil     )
    (#x00a354 "YI SYLLABLE ZHEP"                       nil     )
    (#x00a355 "YI SYLLABLE ZHUT"                       nil     )
    (#x00a356 "YI SYLLABLE ZHUX"                       nil     )
    (#x00a357 "YI SYLLABLE ZHU"                        nil     )
    (#x00a358 "YI SYLLABLE ZHUP"                       nil     )
    (#x00a359 "YI SYLLABLE ZHURX"                      nil     )
    (#x00a35a "YI SYLLABLE ZHUR"                       nil     )
    (#x00a35b "YI SYLLABLE ZHYT"                       nil     )
    (#x00a35c "YI SYLLABLE ZHYX"                       nil     )
    (#x00a35d "YI SYLLABLE ZHY"                        nil     )
    (#x00a35e "YI SYLLABLE ZHYP"                       nil     )
    (#x00a35f "YI SYLLABLE ZHYRX"                      nil     )
    (#x00a360 "YI SYLLABLE ZHYR"                       nil     )
    (#x00a361 "YI SYLLABLE CHAT"                       nil     )
    (#x00a362 "YI SYLLABLE CHAX"                       nil     )
    (#x00a363 "YI SYLLABLE CHA"                        nil     )
    (#x00a364 "YI SYLLABLE CHAP"                       nil     )
    (#x00a365 "YI SYLLABLE CHUOT"                      nil     )
    (#x00a366 "YI SYLLABLE CHUOX"                      nil     )
    (#x00a367 "YI SYLLABLE CHUO"                       nil     )
    (#x00a368 "YI SYLLABLE CHUOP"                      nil     )
    (#x00a369 "YI SYLLABLE CHOT"                       nil     )
    (#x00a36a "YI SYLLABLE CHOX"                       nil     )
    (#x00a36b "YI SYLLABLE CHO"                        nil     )
    (#x00a36c "YI SYLLABLE CHOP"                       nil     )
    (#x00a36d "YI SYLLABLE CHET"                       nil     )
    (#x00a36e "YI SYLLABLE CHEX"                       nil     )
    (#x00a36f "YI SYLLABLE CHE"                        nil     )
    (#x00a370 "YI SYLLABLE CHEP"                       nil     )
    (#x00a371 "YI SYLLABLE CHUX"                       nil     )
    (#x00a372 "YI SYLLABLE CHU"                        nil     )
    (#x00a373 "YI SYLLABLE CHUP"                       nil     )
    (#x00a374 "YI SYLLABLE CHURX"                      nil     )
    (#x00a375 "YI SYLLABLE CHUR"                       nil     )
    (#x00a376 "YI SYLLABLE CHYT"                       nil     )
    (#x00a377 "YI SYLLABLE CHYX"                       nil     )
    (#x00a378 "YI SYLLABLE CHY"                        nil     )
    (#x00a379 "YI SYLLABLE CHYP"                       nil     )
    (#x00a37a "YI SYLLABLE CHYRX"                      nil     )
    (#x00a37b "YI SYLLABLE CHYR"                       nil     )
    (#x00a37c "YI SYLLABLE RRAX"                       nil     )
    (#x00a37d "YI SYLLABLE RRA"                        nil     )
    (#x00a37e "YI SYLLABLE RRUOX"                      nil     )
    (#x00a37f "YI SYLLABLE RRUO"                       nil     )
    (#x00a380 "YI SYLLABLE RROT"                       nil     )
    (#x00a381 "YI SYLLABLE RROX"                       nil     )
    (#x00a382 "YI SYLLABLE RRO"                        nil     )
    (#x00a383 "YI SYLLABLE RROP"                       nil     )
    (#x00a384 "YI SYLLABLE RRET"                       nil     )
    (#x00a385 "YI SYLLABLE RREX"                       nil     )
    (#x00a386 "YI SYLLABLE RRE"                        nil     )
    (#x00a387 "YI SYLLABLE RREP"                       nil     )
    (#x00a388 "YI SYLLABLE RRUT"                       nil     )
    (#x00a389 "YI SYLLABLE RRUX"                       nil     )
    (#x00a38a "YI SYLLABLE RRU"                        nil     )
    (#x00a38b "YI SYLLABLE RRUP"                       nil     )
    (#x00a38c "YI SYLLABLE RRURX"                      nil     )
    (#x00a38d "YI SYLLABLE RRUR"                       nil     )
    (#x00a38e "YI SYLLABLE RRYT"                       nil     )
    (#x00a38f "YI SYLLABLE RRYX"                       nil     )
    (#x00a390 "YI SYLLABLE RRY"                        nil     )
    (#x00a391 "YI SYLLABLE RRYP"                       nil     )
    (#x00a392 "YI SYLLABLE RRYRX"                      nil     )
    (#x00a393 "YI SYLLABLE RRYR"                       nil     )
    (#x00a394 "YI SYLLABLE NRAT"                       nil     )
    (#x00a395 "YI SYLLABLE NRAX"                       nil     )
    (#x00a396 "YI SYLLABLE NRA"                        nil     )
    (#x00a397 "YI SYLLABLE NRAP"                       nil     )
    (#x00a398 "YI SYLLABLE NROX"                       nil     )
    (#x00a399 "YI SYLLABLE NRO"                        nil     )
    (#x00a39a "YI SYLLABLE NROP"                       nil     )
    (#x00a39b "YI SYLLABLE NRET"                       nil     )
    (#x00a39c "YI SYLLABLE NREX"                       nil     )
    (#x00a39d "YI SYLLABLE NRE"                        nil     )
    (#x00a39e "YI SYLLABLE NREP"                       nil     )
    (#x00a39f "YI SYLLABLE NRUT"                       nil     )
    (#x00a3a0 "YI SYLLABLE NRUX"                       nil     )
    (#x00a3a1 "YI SYLLABLE NRU"                        nil     )
    (#x00a3a2 "YI SYLLABLE NRUP"                       nil     )
    (#x00a3a3 "YI SYLLABLE NRURX"                      nil     )
    (#x00a3a4 "YI SYLLABLE NRUR"                       nil     )
    (#x00a3a5 "YI SYLLABLE NRYT"                       nil     )
    (#x00a3a6 "YI SYLLABLE NRYX"                       nil     )
    (#x00a3a7 "YI SYLLABLE NRY"                        nil     )
    (#x00a3a8 "YI SYLLABLE NRYP"                       nil     )
    (#x00a3a9 "YI SYLLABLE NRYRX"                      nil     )
    (#x00a3aa "YI SYLLABLE NRYR"                       nil     )
    (#x00a3ab "YI SYLLABLE SHAT"                       nil     )
    (#x00a3ac "YI SYLLABLE SHAX"                       nil     )
    (#x00a3ad "YI SYLLABLE SHA"                        nil     )
    (#x00a3ae "YI SYLLABLE SHAP"                       nil     )
    (#x00a3af "YI SYLLABLE SHUOX"                      nil     )
    (#x00a3b0 "YI SYLLABLE SHUO"                       nil     )
    (#x00a3b1 "YI SYLLABLE SHUOP"                      nil     )
    (#x00a3b2 "YI SYLLABLE SHOT"                       nil     )
    (#x00a3b3 "YI SYLLABLE SHOX"                       nil     )
    (#x00a3b4 "YI SYLLABLE SHO"                        nil     )
    (#x00a3b5 "YI SYLLABLE SHOP"                       nil     )
    (#x00a3b6 "YI SYLLABLE SHET"                       nil     )
    (#x00a3b7 "YI SYLLABLE SHEX"                       nil     )
    (#x00a3b8 "YI SYLLABLE SHE"                        nil     )
    (#x00a3b9 "YI SYLLABLE SHEP"                       nil     )
    (#x00a3ba "YI SYLLABLE SHUT"                       nil     )
    (#x00a3bb "YI SYLLABLE SHUX"                       nil     )
    (#x00a3bc "YI SYLLABLE SHU"                        nil     )
    (#x00a3bd "YI SYLLABLE SHUP"                       nil     )
    (#x00a3be "YI SYLLABLE SHURX"                      nil     )
    (#x00a3bf "YI SYLLABLE SHUR"                       nil     )
    (#x00a3c0 "YI SYLLABLE SHYT"                       nil     )
    (#x00a3c1 "YI SYLLABLE SHYX"                       nil     )
    (#x00a3c2 "YI SYLLABLE SHY"                        nil     )
    (#x00a3c3 "YI SYLLABLE SHYP"                       nil     )
    (#x00a3c4 "YI SYLLABLE SHYRX"                      nil     )
    (#x00a3c5 "YI SYLLABLE SHYR"                       nil     )
    (#x00a3c6 "YI SYLLABLE RAT"                        nil     )
    (#x00a3c7 "YI SYLLABLE RAX"                        nil     )
    (#x00a3c8 "YI SYLLABLE RA"                         nil     )
    (#x00a3c9 "YI SYLLABLE RAP"                        nil     )
    (#x00a3ca "YI SYLLABLE RUOX"                       nil     )
    (#x00a3cb "YI SYLLABLE RUO"                        nil     )
    (#x00a3cc "YI SYLLABLE RUOP"                       nil     )
    (#x00a3cd "YI SYLLABLE ROT"                        nil     )
    (#x00a3ce "YI SYLLABLE ROX"                        nil     )
    (#x00a3cf "YI SYLLABLE RO"                         nil     )
    (#x00a3d0 "YI SYLLABLE ROP"                        nil     )
    (#x00a3d1 "YI SYLLABLE REX"                        nil     )
    (#x00a3d2 "YI SYLLABLE RE"                         nil     )
    (#x00a3d3 "YI SYLLABLE REP"                        nil     )
    (#x00a3d4 "YI SYLLABLE RUT"                        nil     )
    (#x00a3d5 "YI SYLLABLE RUX"                        nil     )
    (#x00a3d6 "YI SYLLABLE RU"                         nil     )
    (#x00a3d7 "YI SYLLABLE RUP"                        nil     )
    (#x00a3d8 "YI SYLLABLE RURX"                       nil     )
    (#x00a3d9 "YI SYLLABLE RUR"                        nil     )
    (#x00a3da "YI SYLLABLE RYT"                        nil     )
    (#x00a3db "YI SYLLABLE RYX"                        nil     )
    (#x00a3dc "YI SYLLABLE RY"                         nil     )
    (#x00a3dd "YI SYLLABLE RYP"                        nil     )
    (#x00a3de "YI SYLLABLE RYRX"                       nil     )
    (#x00a3df "YI SYLLABLE RYR"                        nil     )
    (#x00a3e0 "YI SYLLABLE JIT"                        nil     )
    (#x00a3e1 "YI SYLLABLE JIX"                        nil     )
    (#x00a3e2 "YI SYLLABLE JI"                         nil     )
    (#x00a3e3 "YI SYLLABLE JIP"                        nil     )
    (#x00a3e4 "YI SYLLABLE JIET"                       nil     )
    (#x00a3e5 "YI SYLLABLE JIEX"                       nil     )
    (#x00a3e6 "YI SYLLABLE JIE"                        nil     )
    (#x00a3e7 "YI SYLLABLE JIEP"                       nil     )
    (#x00a3e8 "YI SYLLABLE JUOT"                       nil     )
    (#x00a3e9 "YI SYLLABLE JUOX"                       nil     )
    (#x00a3ea "YI SYLLABLE JUO"                        nil     )
    (#x00a3eb "YI SYLLABLE JUOP"                       nil     )
    (#x00a3ec "YI SYLLABLE JOT"                        nil     )
    (#x00a3ed "YI SYLLABLE JOX"                        nil     )
    (#x00a3ee "YI SYLLABLE JO"                         nil     )
    (#x00a3ef "YI SYLLABLE JOP"                        nil     )
    (#x00a3f0 "YI SYLLABLE JUT"                        nil     )
    (#x00a3f1 "YI SYLLABLE JUX"                        nil     )
    (#x00a3f2 "YI SYLLABLE JU"                         nil     )
    (#x00a3f3 "YI SYLLABLE JUP"                        nil     )
    (#x00a3f4 "YI SYLLABLE JURX"                       nil     )
    (#x00a3f5 "YI SYLLABLE JUR"                        nil     )
    (#x00a3f6 "YI SYLLABLE JYT"                        nil     )
    (#x00a3f7 "YI SYLLABLE JYX"                        nil     )
    (#x00a3f8 "YI SYLLABLE JY"                         nil     )
    (#x00a3f9 "YI SYLLABLE JYP"                        nil     )
    (#x00a3fa "YI SYLLABLE JYRX"                       nil     )
    (#x00a3fb "YI SYLLABLE JYR"                        nil     )
    (#x00a3fc "YI SYLLABLE QIT"                        nil     )
    (#x00a3fd "YI SYLLABLE QIX"                        nil     )
    (#x00a3fe "YI SYLLABLE QI"                         nil     )
    (#x00a3ff "YI SYLLABLE QIP"                        nil     )
    (#x00a400 "YI SYLLABLE QIET"                       nil     )
    (#x00a401 "YI SYLLABLE QIEX"                       nil     )
    (#x00a402 "YI SYLLABLE QIE"                        nil     )
    (#x00a403 "YI SYLLABLE QIEP"                       nil     )
    (#x00a404 "YI SYLLABLE QUOT"                       nil     )
    (#x00a405 "YI SYLLABLE QUOX"                       nil     )
    (#x00a406 "YI SYLLABLE QUO"                        nil     )
    (#x00a407 "YI SYLLABLE QUOP"                       nil     )
    (#x00a408 "YI SYLLABLE QOT"                        nil     )
    (#x00a409 "YI SYLLABLE QOX"                        nil     )
    (#x00a40a "YI SYLLABLE QO"                         nil     )
    (#x00a40b "YI SYLLABLE QOP"                        nil     )
    (#x00a40c "YI SYLLABLE QUT"                        nil     )
    (#x00a40d "YI SYLLABLE QUX"                        nil     )
    (#x00a40e "YI SYLLABLE QU"                         nil     )
    (#x00a40f "YI SYLLABLE QUP"                        nil     )
    (#x00a410 "YI SYLLABLE QURX"                       nil     )
    (#x00a411 "YI SYLLABLE QUR"                        nil     )
    (#x00a412 "YI SYLLABLE QYT"                        nil     )
    (#x00a413 "YI SYLLABLE QYX"                        nil     )
    (#x00a414 "YI SYLLABLE QY"                         nil     )
    (#x00a415 "YI SYLLABLE QYP"                        nil     )
    (#x00a416 "YI SYLLABLE QYRX"                       nil     )
    (#x00a417 "YI SYLLABLE QYR"                        nil     )
    (#x00a418 "YI SYLLABLE JJIT"                       nil     )
    (#x00a419 "YI SYLLABLE JJIX"                       nil     )
    (#x00a41a "YI SYLLABLE JJI"                        nil     )
    (#x00a41b "YI SYLLABLE JJIP"                       nil     )
    (#x00a41c "YI SYLLABLE JJIET"                      nil     )
    (#x00a41d "YI SYLLABLE JJIEX"                      nil     )
    (#x00a41e "YI SYLLABLE JJIE"                       nil     )
    (#x00a41f "YI SYLLABLE JJIEP"                      nil     )
    (#x00a420 "YI SYLLABLE JJUOX"                      nil     )
    (#x00a421 "YI SYLLABLE JJUO"                       nil     )
    (#x00a422 "YI SYLLABLE JJUOP"                      nil     )
    (#x00a423 "YI SYLLABLE JJOT"                       nil     )
    (#x00a424 "YI SYLLABLE JJOX"                       nil     )
    (#x00a425 "YI SYLLABLE JJO"                        nil     )
    (#x00a426 "YI SYLLABLE JJOP"                       nil     )
    (#x00a427 "YI SYLLABLE JJUT"                       nil     )
    (#x00a428 "YI SYLLABLE JJUX"                       nil     )
    (#x00a429 "YI SYLLABLE JJU"                        nil     )
    (#x00a42a "YI SYLLABLE JJUP"                       nil     )
    (#x00a42b "YI SYLLABLE JJURX"                      nil     )
    (#x00a42c "YI SYLLABLE JJUR"                       nil     )
    (#x00a42d "YI SYLLABLE JJYT"                       nil     )
    (#x00a42e "YI SYLLABLE JJYX"                       nil     )
    (#x00a42f "YI SYLLABLE JJY"                        nil     )
    (#x00a430 "YI SYLLABLE JJYP"                       nil     )
    (#x00a431 "YI SYLLABLE NJIT"                       nil     )
    (#x00a432 "YI SYLLABLE NJIX"                       nil     )
    (#x00a433 "YI SYLLABLE NJI"                        nil     )
    (#x00a434 "YI SYLLABLE NJIP"                       nil     )
    (#x00a435 "YI SYLLABLE NJIET"                      nil     )
    (#x00a436 "YI SYLLABLE NJIEX"                      nil     )
    (#x00a437 "YI SYLLABLE NJIE"                       nil     )
    (#x00a438 "YI SYLLABLE NJIEP"                      nil     )
    (#x00a439 "YI SYLLABLE NJUOX"                      nil     )
    (#x00a43a "YI SYLLABLE NJUO"                       nil     )
    (#x00a43b "YI SYLLABLE NJOT"                       nil     )
    (#x00a43c "YI SYLLABLE NJOX"                       nil     )
    (#x00a43d "YI SYLLABLE NJO"                        nil     )
    (#x00a43e "YI SYLLABLE NJOP"                       nil     )
    (#x00a43f "YI SYLLABLE NJUX"                       nil     )
    (#x00a440 "YI SYLLABLE NJU"                        nil     )
    (#x00a441 "YI SYLLABLE NJUP"                       nil     )
    (#x00a442 "YI SYLLABLE NJURX"                      nil     )
    (#x00a443 "YI SYLLABLE NJUR"                       nil     )
    (#x00a444 "YI SYLLABLE NJYT"                       nil     )
    (#x00a445 "YI SYLLABLE NJYX"                       nil     )
    (#x00a446 "YI SYLLABLE NJY"                        nil     )
    (#x00a447 "YI SYLLABLE NJYP"                       nil     )
    (#x00a448 "YI SYLLABLE NJYRX"                      nil     )
    (#x00a449 "YI SYLLABLE NJYR"                       nil     )
    (#x00a44a "YI SYLLABLE NYIT"                       nil     )
    (#x00a44b "YI SYLLABLE NYIX"                       nil     )
    (#x00a44c "YI SYLLABLE NYI"                        nil     )
    (#x00a44d "YI SYLLABLE NYIP"                       nil     )
    (#x00a44e "YI SYLLABLE NYIET"                      nil     )
    (#x00a44f "YI SYLLABLE NYIEX"                      nil     )
    (#x00a450 "YI SYLLABLE NYIE"                       nil     )
    (#x00a451 "YI SYLLABLE NYIEP"                      nil     )
    (#x00a452 "YI SYLLABLE NYUOX"                      nil     )
    (#x00a453 "YI SYLLABLE NYUO"                       nil     )
    (#x00a454 "YI SYLLABLE NYUOP"                      nil     )
    (#x00a455 "YI SYLLABLE NYOT"                       nil     )
    (#x00a456 "YI SYLLABLE NYOX"                       nil     )
    (#x00a457 "YI SYLLABLE NYO"                        nil     )
    (#x00a458 "YI SYLLABLE NYOP"                       nil     )
    (#x00a459 "YI SYLLABLE NYUT"                       nil     )
    (#x00a45a "YI SYLLABLE NYUX"                       nil     )
    (#x00a45b "YI SYLLABLE NYU"                        nil     )
    (#x00a45c "YI SYLLABLE NYUP"                       nil     )
    (#x00a45d "YI SYLLABLE XIT"                        nil     )
    (#x00a45e "YI SYLLABLE XIX"                        nil     )
    (#x00a45f "YI SYLLABLE XI"                         nil     )
    (#x00a460 "YI SYLLABLE XIP"                        nil     )
    (#x00a461 "YI SYLLABLE XIET"                       nil     )
    (#x00a462 "YI SYLLABLE XIEX"                       nil     )
    (#x00a463 "YI SYLLABLE XIE"                        nil     )
    (#x00a464 "YI SYLLABLE XIEP"                       nil     )
    (#x00a465 "YI SYLLABLE XUOX"                       nil     )
    (#x00a466 "YI SYLLABLE XUO"                        nil     )
    (#x00a467 "YI SYLLABLE XOT"                        nil     )
    (#x00a468 "YI SYLLABLE XOX"                        nil     )
    (#x00a469 "YI SYLLABLE XO"                         nil     )
    (#x00a46a "YI SYLLABLE XOP"                        nil     )
    (#x00a46b "YI SYLLABLE XYT"                        nil     )
    (#x00a46c "YI SYLLABLE XYX"                        nil     )
    (#x00a46d "YI SYLLABLE XY"                         nil     )
    (#x00a46e "YI SYLLABLE XYP"                        nil     )
    (#x00a46f "YI SYLLABLE XYRX"                       nil     )
    (#x00a470 "YI SYLLABLE XYR"                        nil     )
    (#x00a471 "YI SYLLABLE YIT"                        nil     )
    (#x00a472 "YI SYLLABLE YIX"                        nil     )
    (#x00a473 "YI SYLLABLE YI"                         nil     )
    (#x00a474 "YI SYLLABLE YIP"                        nil     )
    (#x00a475 "YI SYLLABLE YIET"                       nil     )
    (#x00a476 "YI SYLLABLE YIEX"                       nil     )
    (#x00a477 "YI SYLLABLE YIE"                        nil     )
    (#x00a478 "YI SYLLABLE YIEP"                       nil     )
    (#x00a479 "YI SYLLABLE YUOT"                       nil     )
    (#x00a47a "YI SYLLABLE YUOX"                       nil     )
    (#x00a47b "YI SYLLABLE YUO"                        nil     )
    (#x00a47c "YI SYLLABLE YUOP"                       nil     )
    (#x00a47d "YI SYLLABLE YOT"                        nil     )
    (#x00a47e "YI SYLLABLE YOX"                        nil     )
    (#x00a47f "YI SYLLABLE YO"                         nil     )
    (#x00a480 "YI SYLLABLE YOP"                        nil     )
    (#x00a481 "YI SYLLABLE YUT"                        nil     )
    (#x00a482 "YI SYLLABLE YUX"                        nil     )
    (#x00a483 "YI SYLLABLE YU"                         nil     )
    (#x00a484 "YI SYLLABLE YUP"                        nil     )
    (#x00a485 "YI SYLLABLE YURX"                       nil     )
    (#x00a486 "YI SYLLABLE YUR"                        nil     )
    (#x00a487 "YI SYLLABLE YYT"                        nil     )
    (#x00a488 "YI SYLLABLE YYX"                        nil     )
    (#x00a489 "YI SYLLABLE YY"                         nil     )
    (#x00a48a "YI SYLLABLE YYP"                        nil     )
    (#x00a48b "YI SYLLABLE YYRX"                       nil     )
    (#x00a48c "YI SYLLABLE YYR"                        nil     )
    (#x00a490 "YI RADICAL QOT"                         nil     )
    (#x00a491 "YI RADICAL LI"                          nil     )
    (#x00a492 "YI RADICAL KIT"                         nil     )
    (#x00a493 "YI RADICAL NYIP"                        nil     )
    (#x00a494 "YI RADICAL CYP"                         nil     )
    (#x00a495 "YI RADICAL SSI"                         nil     )
    (#x00a496 "YI RADICAL GGOP"                        nil     )
    (#x00a497 "YI RADICAL GEP"                         nil     )
    (#x00a498 "YI RADICAL MI"                          nil     )
    (#x00a499 "YI RADICAL HXIT"                        nil     )
    (#x00a49a "YI RADICAL LYR"                         nil     )
    (#x00a49b "YI RADICAL BBUT"                        nil     )
    (#x00a49c "YI RADICAL MOP"                         nil     )
    (#x00a49d "YI RADICAL YO"                          nil     )
    (#x00a49e "YI RADICAL PUT"                         nil     )
    (#x00a49f "YI RADICAL HXUO"                        nil     )
    (#x00a4a0 "YI RADICAL TAT"                         nil     )
    (#x00a4a1 "YI RADICAL GA"                          nil     )
    (#x00a4a2 "YI RADICAL ZUP"                         nil     )
    (#x00a4a3 "YI RADICAL CYT"                         nil     )
    (#x00a4a4 "YI RADICAL DDUR"                        nil     )
    (#x00a4a5 "YI RADICAL BUR"                         nil     )
    (#x00a4a6 "YI RADICAL GGUO"                        nil     )
    (#x00a4a7 "YI RADICAL NYOP"                        nil     )
    (#x00a4a8 "YI RADICAL TU"                          nil     )
    (#x00a4a9 "YI RADICAL OP"                          nil     )
    (#x00a4aa "YI RADICAL JJUT"                        nil     )
    (#x00a4ab "YI RADICAL ZOT"                         nil     )
    (#x00a4ac "YI RADICAL PYT"                         nil     )
    (#x00a4ad "YI RADICAL HMO"                         nil     )
    (#x00a4ae "YI RADICAL YIT"                         nil     )
    (#x00a4af "YI RADICAL VUR"                         nil     )
    (#x00a4b0 "YI RADICAL SHY"                         nil     )
    (#x00a4b1 "YI RADICAL VEP"                         nil     )
    (#x00a4b2 "YI RADICAL ZA"                          nil     )
    (#x00a4b3 "YI RADICAL JO"                          nil     )
    (#x00a4b4 "YI RADICAL NZUP"                        nil     )
    (#x00a4b5 "YI RADICAL JJY"                         nil     )
    (#x00a4b6 "YI RADICAL GOT"                         nil     )
    (#x00a4b7 "YI RADICAL JJIE"                        nil     )
    (#x00a4b8 "YI RADICAL WO"                          nil     )
    (#x00a4b9 "YI RADICAL DU"                          nil     )
    (#x00a4ba "YI RADICAL SHUR"                        nil     )
    (#x00a4bb "YI RADICAL LIE"                         nil     )
    (#x00a4bc "YI RADICAL CY"                          nil     )
    (#x00a4bd "YI RADICAL CUOP"                        nil     )
    (#x00a4be "YI RADICAL CIP"                         nil     )
    (#x00a4bf "YI RADICAL HXOP"                        nil     )
    (#x00a4c0 "YI RADICAL SHAT"                        nil     )
    (#x00a4c1 "YI RADICAL ZUR"                         nil     )
    (#x00a4c2 "YI RADICAL SHOP"                        nil     )
    (#x00a4c3 "YI RADICAL CHE"                         nil     )
    (#x00a4c4 "YI RADICAL ZZIET"                       nil     )
    (#x00a4c5 "YI RADICAL NBIE"                        nil     )
    (#x00a4c6 "YI RADICAL KE"                          nil     )
    (#x00a4d0 "LISU LETTER BA"                         nil     )
    (#x00a4d1 "LISU LETTER PA"                         nil     )
    (#x00a4d2 "LISU LETTER PHA"                        nil     )
    (#x00a4d3 "LISU LETTER DA"                         nil     )
    (#x00a4d4 "LISU LETTER TA"                         nil     )
    (#x00a4d5 "LISU LETTER THA"                        nil     )
    (#x00a4d6 "LISU LETTER GA"                         nil     )
    (#x00a4d7 "LISU LETTER KA"                         nil     )
    (#x00a4d8 "LISU LETTER KHA"                        nil     )
    (#x00a4d9 "LISU LETTER JA"                         nil     )
    (#x00a4da "LISU LETTER CA"                         nil     )
    (#x00a4db "LISU LETTER CHA"                        nil     )
    (#x00a4dc "LISU LETTER DZA"                        nil     )
    (#x00a4dd "LISU LETTER TSA"                        nil     )
    (#x00a4de "LISU LETTER TSHA"                       nil     )
    (#x00a4df "LISU LETTER MA"                         nil     )
    (#x00a4e0 "LISU LETTER NA"                         nil     )
    (#x00a4e1 "LISU LETTER LA"                         nil     )
    (#x00a4e2 "LISU LETTER SA"                         nil     )
    (#x00a4e3 "LISU LETTER ZHA"                        nil     )
    (#x00a4e4 "LISU LETTER ZA"                         nil     )
    (#x00a4e5 "LISU LETTER NGA"                        nil     )
    (#x00a4e6 "LISU LETTER HA"                         nil     )
    (#x00a4e7 "LISU LETTER XA"                         nil     )
    (#x00a4e8 "LISU LETTER HHA"                        nil     )
    (#x00a4e9 "LISU LETTER FA"                         nil     )
    (#x00a4ea "LISU LETTER WA"                         nil     )
    (#x00a4eb "LISU LETTER SHA"                        nil     )
    (#x00a4ec "LISU LETTER YA"                         nil     )
    (#x00a4ed "LISU LETTER GHA"                        nil     )
    (#x00a4ee "LISU LETTER A"                          nil     )
    (#x00a4ef "LISU LETTER AE"                         nil     )
    (#x00a4f0 "LISU LETTER E"                          nil     )
    (#x00a4f1 "LISU LETTER EU"                         nil     )
    (#x00a4f2 "LISU LETTER I"                          nil     )
    (#x00a4f3 "LISU LETTER O"                          nil     )
    (#x00a4f4 "LISU LETTER U"                          nil     )
    (#x00a4f5 "LISU LETTER UE"                         nil     )
    (#x00a4f6 "LISU LETTER UH"                         nil     )
    (#x00a4f7 "LISU LETTER OE"                         nil     )
    (#x00a4f8 "LISU LETTER TONE MYA TI"                nil     )
    (#x00a4f9 "LISU LETTER TONE NA PO"                 nil     )
    (#x00a4fa "LISU LETTER TONE MYA CYA"               nil     )
    (#x00a4fb "LISU LETTER TONE MYA BO"                nil     )
    (#x00a4fc "LISU LETTER TONE MYA NA"                nil     )
    (#x00a4fd "LISU LETTER TONE MYA JEU"               nil     )
    (#x00a4fe "LISU PUNCTUATION COMMA"                 nil     )
    (#x00a4ff "LISU PUNCTUATION FULL STOP"             nil     )
    (#x00a500 "VAI SYLLABLE EE"                        nil     )
    (#x00a501 "VAI SYLLABLE EEN"                       nil     )
    (#x00a502 "VAI SYLLABLE HEE"                       nil     )
    (#x00a503 "VAI SYLLABLE WEE"                       nil     )
    (#x00a504 "VAI SYLLABLE WEEN"                      nil     )
    (#x00a505 "VAI SYLLABLE PEE"                       nil     )
    (#x00a506 "VAI SYLLABLE BHEE"                      nil     )
    (#x00a507 "VAI SYLLABLE BEE"                       nil     )
    (#x00a508 "VAI SYLLABLE MBEE"                      nil     )
    (#x00a509 "VAI SYLLABLE KPEE"                      nil     )
    (#x00a50a "VAI SYLLABLE MGBEE"                     nil     )
    (#x00a50b "VAI SYLLABLE GBEE"                      nil     )
    (#x00a50c "VAI SYLLABLE FEE"                       nil     )
    (#x00a50d "VAI SYLLABLE VEE"                       nil     )
    (#x00a50e "VAI SYLLABLE TEE"                       nil     )
    (#x00a50f "VAI SYLLABLE THEE"                      nil     )
    (#x00a510 "VAI SYLLABLE DHEE"                      nil     )
    (#x00a511 "VAI SYLLABLE DHHEE"                     nil     )
    (#x00a512 "VAI SYLLABLE LEE"                       nil     )
    (#x00a513 "VAI SYLLABLE REE"                       nil     )
    (#x00a514 "VAI SYLLABLE DEE"                       nil     )
    (#x00a515 "VAI SYLLABLE NDEE"                      nil     )
    (#x00a516 "VAI SYLLABLE SEE"                       nil     )
    (#x00a517 "VAI SYLLABLE SHEE"                      nil     )
    (#x00a518 "VAI SYLLABLE ZEE"                       nil     )
    (#x00a519 "VAI SYLLABLE ZHEE"                      nil     )
    (#x00a51a "VAI SYLLABLE CEE"                       nil     )
    (#x00a51b "VAI SYLLABLE JEE"                       nil     )
    (#x00a51c "VAI SYLLABLE NJEE"                      nil     )
    (#x00a51d "VAI SYLLABLE YEE"                       nil     )
    (#x00a51e "VAI SYLLABLE KEE"                       nil     )
    (#x00a51f "VAI SYLLABLE NGGEE"                     nil     )
    (#x00a520 "VAI SYLLABLE GEE"                       nil     )
    (#x00a521 "VAI SYLLABLE MEE"                       nil     )
    (#x00a522 "VAI SYLLABLE NEE"                       nil     )
    (#x00a523 "VAI SYLLABLE NYEE"                      nil     )
    (#x00a524 "VAI SYLLABLE I"                         nil     )
    (#x00a525 "VAI SYLLABLE IN"                        nil     )
    (#x00a526 "VAI SYLLABLE HI"                        nil     )
    (#x00a527 "VAI SYLLABLE HIN"                       nil     )
    (#x00a528 "VAI SYLLABLE WI"                        nil     )
    (#x00a529 "VAI SYLLABLE WIN"                       nil     )
    (#x00a52a "VAI SYLLABLE PI"                        nil     )
    (#x00a52b "VAI SYLLABLE BHI"                       nil     )
    (#x00a52c "VAI SYLLABLE BI"                        nil     )
    (#x00a52d "VAI SYLLABLE MBI"                       nil     )
    (#x00a52e "VAI SYLLABLE KPI"                       nil     )
    (#x00a52f "VAI SYLLABLE MGBI"                      nil     )
    (#x00a530 "VAI SYLLABLE GBI"                       nil     )
    (#x00a531 "VAI SYLLABLE FI"                        nil     )
    (#x00a532 "VAI SYLLABLE VI"                        nil     )
    (#x00a533 "VAI SYLLABLE TI"                        nil     )
    (#x00a534 "VAI SYLLABLE THI"                       nil     )
    (#x00a535 "VAI SYLLABLE DHI"                       nil     )
    (#x00a536 "VAI SYLLABLE DHHI"                      nil     )
    (#x00a537 "VAI SYLLABLE LI"                        nil     )
    (#x00a538 "VAI SYLLABLE RI"                        nil     )
    (#x00a539 "VAI SYLLABLE DI"                        nil     )
    (#x00a53a "VAI SYLLABLE NDI"                       nil     )
    (#x00a53b "VAI SYLLABLE SI"                        nil     )
    (#x00a53c "VAI SYLLABLE SHI"                       nil     )
    (#x00a53d "VAI SYLLABLE ZI"                        nil     )
    (#x00a53e "VAI SYLLABLE ZHI"                       nil     )
    (#x00a53f "VAI SYLLABLE CI"                        nil     )
    (#x00a540 "VAI SYLLABLE JI"                        nil     )
    (#x00a541 "VAI SYLLABLE NJI"                       nil     )
    (#x00a542 "VAI SYLLABLE YI"                        nil     )
    (#x00a543 "VAI SYLLABLE KI"                        nil     )
    (#x00a544 "VAI SYLLABLE NGGI"                      nil     )
    (#x00a545 "VAI SYLLABLE GI"                        nil     )
    (#x00a546 "VAI SYLLABLE MI"                        nil     )
    (#x00a547 "VAI SYLLABLE NI"                        nil     )
    (#x00a548 "VAI SYLLABLE NYI"                       nil     )
    (#x00a549 "VAI SYLLABLE A"                         nil     )
    (#x00a54a "VAI SYLLABLE AN"                        nil     )
    (#x00a54b "VAI SYLLABLE NGAN"                      nil     )
    (#x00a54c "VAI SYLLABLE HA"                        nil     )
    (#x00a54d "VAI SYLLABLE HAN"                       nil     )
    (#x00a54e "VAI SYLLABLE WA"                        nil     )
    (#x00a54f "VAI SYLLABLE WAN"                       nil     )
    (#x00a550 "VAI SYLLABLE PA"                        nil     )
    (#x00a551 "VAI SYLLABLE BHA"                       nil     )
    (#x00a552 "VAI SYLLABLE BA"                        nil     )
    (#x00a553 "VAI SYLLABLE MBA"                       nil     )
    (#x00a554 "VAI SYLLABLE KPA"                       nil     )
    (#x00a555 "VAI SYLLABLE KPAN"                      nil     )
    (#x00a556 "VAI SYLLABLE MGBA"                      nil     )
    (#x00a557 "VAI SYLLABLE GBA"                       nil     )
    (#x00a558 "VAI SYLLABLE FA"                        nil     )
    (#x00a559 "VAI SYLLABLE VA"                        nil     )
    (#x00a55a "VAI SYLLABLE TA"                        nil     )
    (#x00a55b "VAI SYLLABLE THA"                       nil     )
    (#x00a55c "VAI SYLLABLE DHA"                       nil     )
    (#x00a55d "VAI SYLLABLE DHHA"                      nil     )
    (#x00a55e "VAI SYLLABLE LA"                        nil     )
    (#x00a55f "VAI SYLLABLE RA"                        nil     )
    (#x00a560 "VAI SYLLABLE DA"                        nil     )
    (#x00a561 "VAI SYLLABLE NDA"                       nil     )
    (#x00a562 "VAI SYLLABLE SA"                        nil     )
    (#x00a563 "VAI SYLLABLE SHA"                       nil     )
    (#x00a564 "VAI SYLLABLE ZA"                        nil     )
    (#x00a565 "VAI SYLLABLE ZHA"                       nil     )
    (#x00a566 "VAI SYLLABLE CA"                        nil     )
    (#x00a567 "VAI SYLLABLE JA"                        nil     )
    (#x00a568 "VAI SYLLABLE NJA"                       nil     )
    (#x00a569 "VAI SYLLABLE YA"                        nil     )
    (#x00a56a "VAI SYLLABLE KA"                        nil     )
    (#x00a56b "VAI SYLLABLE KAN"                       nil     )
    (#x00a56c "VAI SYLLABLE NGGA"                      nil     )
    (#x00a56d "VAI SYLLABLE GA"                        nil     )
    (#x00a56e "VAI SYLLABLE MA"                        nil     )
    (#x00a56f "VAI SYLLABLE NA"                        nil     )
    (#x00a570 "VAI SYLLABLE NYA"                       nil     )
    (#x00a571 "VAI SYLLABLE OO"                        nil     )
    (#x00a572 "VAI SYLLABLE OON"                       nil     )
    (#x00a573 "VAI SYLLABLE HOO"                       nil     )
    (#x00a574 "VAI SYLLABLE WOO"                       nil     )
    (#x00a575 "VAI SYLLABLE WOON"                      nil     )
    (#x00a576 "VAI SYLLABLE POO"                       nil     )
    (#x00a577 "VAI SYLLABLE BHOO"                      nil     )
    (#x00a578 "VAI SYLLABLE BOO"                       nil     )
    (#x00a579 "VAI SYLLABLE MBOO"                      nil     )
    (#x00a57a "VAI SYLLABLE KPOO"                      nil     )
    (#x00a57b "VAI SYLLABLE MGBOO"                     nil     )
    (#x00a57c "VAI SYLLABLE GBOO"                      nil     )
    (#x00a57d "VAI SYLLABLE FOO"                       nil     )
    (#x00a57e "VAI SYLLABLE VOO"                       nil     )
    (#x00a57f "VAI SYLLABLE TOO"                       nil     )
    (#x00a580 "VAI SYLLABLE THOO"                      nil     )
    (#x00a581 "VAI SYLLABLE DHOO"                      nil     )
    (#x00a582 "VAI SYLLABLE DHHOO"                     nil     )
    (#x00a583 "VAI SYLLABLE LOO"                       nil     )
    (#x00a584 "VAI SYLLABLE ROO"                       nil     )
    (#x00a585 "VAI SYLLABLE DOO"                       nil     )
    (#x00a586 "VAI SYLLABLE NDOO"                      nil     )
    (#x00a587 "VAI SYLLABLE SOO"                       nil     )
    (#x00a588 "VAI SYLLABLE SHOO"                      nil     )
    (#x00a589 "VAI SYLLABLE ZOO"                       nil     )
    (#x00a58a "VAI SYLLABLE ZHOO"                      nil     )
    (#x00a58b "VAI SYLLABLE COO"                       nil     )
    (#x00a58c "VAI SYLLABLE JOO"                       nil     )
    (#x00a58d "VAI SYLLABLE NJOO"                      nil     )
    (#x00a58e "VAI SYLLABLE YOO"                       nil     )
    (#x00a58f "VAI SYLLABLE KOO"                       nil     )
    (#x00a590 "VAI SYLLABLE NGGOO"                     nil     )
    (#x00a591 "VAI SYLLABLE GOO"                       nil     )
    (#x00a592 "VAI SYLLABLE MOO"                       nil     )
    (#x00a593 "VAI SYLLABLE NOO"                       nil     )
    (#x00a594 "VAI SYLLABLE NYOO"                      nil     )
    (#x00a595 "VAI SYLLABLE U"                         nil     )
    (#x00a596 "VAI SYLLABLE UN"                        nil     )
    (#x00a597 "VAI SYLLABLE HU"                        nil     )
    (#x00a598 "VAI SYLLABLE HUN"                       nil     )
    (#x00a599 "VAI SYLLABLE WU"                        nil     )
    (#x00a59a "VAI SYLLABLE WUN"                       nil     )
    (#x00a59b "VAI SYLLABLE PU"                        nil     )
    (#x00a59c "VAI SYLLABLE BHU"                       nil     )
    (#x00a59d "VAI SYLLABLE BU"                        nil     )
    (#x00a59e "VAI SYLLABLE MBU"                       nil     )
    (#x00a59f "VAI SYLLABLE KPU"                       nil     )
    (#x00a5a0 "VAI SYLLABLE MGBU"                      nil     )
    (#x00a5a1 "VAI SYLLABLE GBU"                       nil     )
    (#x00a5a2 "VAI SYLLABLE FU"                        nil     )
    (#x00a5a3 "VAI SYLLABLE VU"                        nil     )
    (#x00a5a4 "VAI SYLLABLE TU"                        nil     )
    (#x00a5a5 "VAI SYLLABLE THU"                       nil     )
    (#x00a5a6 "VAI SYLLABLE DHU"                       nil     )
    (#x00a5a7 "VAI SYLLABLE DHHU"                      nil     )
    (#x00a5a8 "VAI SYLLABLE LU"                        nil     )
    (#x00a5a9 "VAI SYLLABLE RU"                        nil     )
    (#x00a5aa "VAI SYLLABLE DU"                        nil     )
    (#x00a5ab "VAI SYLLABLE NDU"                       nil     )
    (#x00a5ac "VAI SYLLABLE SU"                        nil     )
    (#x00a5ad "VAI SYLLABLE SHU"                       nil     )
    (#x00a5ae "VAI SYLLABLE ZU"                        nil     )
    (#x00a5af "VAI SYLLABLE ZHU"                       nil     )
    (#x00a5b0 "VAI SYLLABLE CU"                        nil     )
    (#x00a5b1 "VAI SYLLABLE JU"                        nil     )
    (#x00a5b2 "VAI SYLLABLE NJU"                       nil     )
    (#x00a5b3 "VAI SYLLABLE YU"                        nil     )
    (#x00a5b4 "VAI SYLLABLE KU"                        nil     )
    (#x00a5b5 "VAI SYLLABLE NGGU"                      nil     )
    (#x00a5b6 "VAI SYLLABLE GU"                        nil     )
    (#x00a5b7 "VAI SYLLABLE MU"                        nil     )
    (#x00a5b8 "VAI SYLLABLE NU"                        nil     )
    (#x00a5b9 "VAI SYLLABLE NYU"                       nil     )
    (#x00a5ba "VAI SYLLABLE O"                         nil     )
    (#x00a5bb "VAI SYLLABLE ON"                        nil     )
    (#x00a5bc "VAI SYLLABLE NGON"                      nil     )
    (#x00a5bd "VAI SYLLABLE HO"                        nil     )
    (#x00a5be "VAI SYLLABLE HON"                       nil     )
    (#x00a5bf "VAI SYLLABLE WO"                        nil     )
    (#x00a5c0 "VAI SYLLABLE WON"                       nil     )
    (#x00a5c1 "VAI SYLLABLE PO"                        nil     )
    (#x00a5c2 "VAI SYLLABLE BHO"                       nil     )
    (#x00a5c3 "VAI SYLLABLE BO"                        nil     )
    (#x00a5c4 "VAI SYLLABLE MBO"                       nil     )
    (#x00a5c5 "VAI SYLLABLE KPO"                       nil     )
    (#x00a5c6 "VAI SYLLABLE MGBO"                      nil     )
    (#x00a5c7 "VAI SYLLABLE GBO"                       nil     )
    (#x00a5c8 "VAI SYLLABLE GBON"                      nil     )
    (#x00a5c9 "VAI SYLLABLE FO"                        nil     )
    (#x00a5ca "VAI SYLLABLE VO"                        nil     )
    (#x00a5cb "VAI SYLLABLE TO"                        nil     )
    (#x00a5cc "VAI SYLLABLE THO"                       nil     )
    (#x00a5cd "VAI SYLLABLE DHO"                       nil     )
    (#x00a5ce "VAI SYLLABLE DHHO"                      nil     )
    (#x00a5cf "VAI SYLLABLE LO"                        nil     )
    (#x00a5d0 "VAI SYLLABLE RO"                        nil     )
    (#x00a5d1 "VAI SYLLABLE DO"                        nil     )
    (#x00a5d2 "VAI SYLLABLE NDO"                       nil     )
    (#x00a5d3 "VAI SYLLABLE SO"                        nil     )
    (#x00a5d4 "VAI SYLLABLE SHO"                       nil     )
    (#x00a5d5 "VAI SYLLABLE ZO"                        nil     )
    (#x00a5d6 "VAI SYLLABLE ZHO"                       nil     )
    (#x00a5d7 "VAI SYLLABLE CO"                        nil     )
    (#x00a5d8 "VAI SYLLABLE JO"                        nil     )
    (#x00a5d9 "VAI SYLLABLE NJO"                       nil     )
    (#x00a5da "VAI SYLLABLE YO"                        nil     )
    (#x00a5db "VAI SYLLABLE KO"                        nil     )
    (#x00a5dc "VAI SYLLABLE NGGO"                      nil     )
    (#x00a5dd "VAI SYLLABLE GO"                        nil     )
    (#x00a5de "VAI SYLLABLE MO"                        nil     )
    (#x00a5df "VAI SYLLABLE NO"                        nil     )
    (#x00a5e0 "VAI SYLLABLE NYO"                       nil     )
    (#x00a5e1 "VAI SYLLABLE E"                         nil     )
    (#x00a5e2 "VAI SYLLABLE EN"                        nil     )
    (#x00a5e3 "VAI SYLLABLE NGEN"                      nil     )
    (#x00a5e4 "VAI SYLLABLE HE"                        nil     )
    (#x00a5e5 "VAI SYLLABLE HEN"                       nil     )
    (#x00a5e6 "VAI SYLLABLE WE"                        nil     )
    (#x00a5e7 "VAI SYLLABLE WEN"                       nil     )
    (#x00a5e8 "VAI SYLLABLE PE"                        nil     )
    (#x00a5e9 "VAI SYLLABLE BHE"                       nil     )
    (#x00a5ea "VAI SYLLABLE BE"                        nil     )
    (#x00a5eb "VAI SYLLABLE MBE"                       nil     )
    (#x00a5ec "VAI SYLLABLE KPE"                       nil     )
    (#x00a5ed "VAI SYLLABLE KPEN"                      nil     )
    (#x00a5ee "VAI SYLLABLE MGBE"                      nil     )
    (#x00a5ef "VAI SYLLABLE GBE"                       nil     )
    (#x00a5f0 "VAI SYLLABLE GBEN"                      nil     )
    (#x00a5f1 "VAI SYLLABLE FE"                        nil     )
    (#x00a5f2 "VAI SYLLABLE VE"                        nil     )
    (#x00a5f3 "VAI SYLLABLE TE"                        nil     )
    (#x00a5f4 "VAI SYLLABLE THE"                       nil     )
    (#x00a5f5 "VAI SYLLABLE DHE"                       nil     )
    (#x00a5f6 "VAI SYLLABLE DHHE"                      nil     )
    (#x00a5f7 "VAI SYLLABLE LE"                        nil     )
    (#x00a5f8 "VAI SYLLABLE RE"                        nil     )
    (#x00a5f9 "VAI SYLLABLE DE"                        nil     )
    (#x00a5fa "VAI SYLLABLE NDE"                       nil     )
    (#x00a5fb "VAI SYLLABLE SE"                        nil     )
    (#x00a5fc "VAI SYLLABLE SHE"                       nil     )
    (#x00a5fd "VAI SYLLABLE ZE"                        nil     )
    (#x00a5fe "VAI SYLLABLE ZHE"                       nil     )
    (#x00a5ff "VAI SYLLABLE CE"                        nil     )
    (#x00a600 "VAI SYLLABLE JE"                        nil     )
    (#x00a601 "VAI SYLLABLE NJE"                       nil     )
    (#x00a602 "VAI SYLLABLE YE"                        nil     )
    (#x00a603 "VAI SYLLABLE KE"                        nil     )
    (#x00a604 "VAI SYLLABLE NGGE"                      nil     )
    (#x00a605 "VAI SYLLABLE NGGEN"                     nil     )
    (#x00a606 "VAI SYLLABLE GE"                        nil     )
    (#x00a607 "VAI SYLLABLE GEN"                       nil     )
    (#x00a608 "VAI SYLLABLE ME"                        nil     )
    (#x00a609 "VAI SYLLABLE NE"                        nil     )
    (#x00a60a "VAI SYLLABLE NYE"                       nil     )
    (#x00a60b "VAI SYLLABLE NG"                        nil     )
    (#x00a60c "VAI SYLLABLE LENGTHENER"                nil     )
    (#x00a60d "VAI COMMA"                              nil     )
    (#x00a60e "VAI FULL STOP"                          nil     )
    (#x00a60f "VAI QUESTION MARK"                      nil     )
    (#x00a610 "VAI SYLLABLE NDOLE FA"                  nil     )
    (#x00a611 "VAI SYLLABLE NDOLE KA"                  nil     )
    (#x00a612 "VAI SYLLABLE NDOLE SOO"                 nil     )
    (#x00a613 "VAI SYMBOL FEENG"                       nil     )
    (#x00a614 "VAI SYMBOL KEENG"                       nil     )
    (#x00a615 "VAI SYMBOL TING"                        nil     )
    (#x00a616 "VAI SYMBOL NII"                         nil     )
    (#x00a617 "VAI SYMBOL BANG"                        nil     )
    (#x00a618 "VAI SYMBOL FAA"                         nil     )
    (#x00a619 "VAI SYMBOL TAA"                         nil     )
    (#x00a61a "VAI SYMBOL DANG"                        nil     )
    (#x00a61b "VAI SYMBOL DOONG"                       nil     )
    (#x00a61c "VAI SYMBOL KUNG"                        nil     )
    (#x00a61d "VAI SYMBOL TONG"                        nil     )
    (#x00a61e "VAI SYMBOL DO-O"                        nil     )
    (#x00a61f "VAI SYMBOL JONG"                        nil     )
    (#x00a620 "VAI DIGIT ZERO"                         nil     )
    (#x00a621 "VAI DIGIT ONE"                          nil     )
    (#x00a622 "VAI DIGIT TWO"                          nil     )
    (#x00a623 "VAI DIGIT THREE"                        nil     )
    (#x00a624 "VAI DIGIT FOUR"                         nil     )
    (#x00a625 "VAI DIGIT FIVE"                         nil     )
    (#x00a626 "VAI DIGIT SIX"                          nil     )
    (#x00a627 "VAI DIGIT SEVEN"                        nil     )
    (#x00a628 "VAI DIGIT EIGHT"                        nil     )
    (#x00a629 "VAI DIGIT NINE"                         nil     )
    (#x00a62a "VAI SYLLABLE NDOLE MA"                  nil     )
    (#x00a62b "VAI SYLLABLE NDOLE DO"                  nil     )
    (#x00a640 "CYRILLIC CAPITAL LETTER ZEMLYA"         nil     )
    (#x00a641 "CYRILLIC SMALL LETTER ZEMLYA"           nil     )
    (#x00a642 "CYRILLIC CAPITAL LETTER DZELO"          nil     )
    (#x00a643 "CYRILLIC SMALL LETTER DZELO"            nil     )
    (#x00a644 "CYRILLIC CAPITAL LETTER REVERSED DZE"   nil     )
    (#x00a645 "CYRILLIC SMALL LETTER REVERSED DZE"     nil     )
    (#x00a646 "CYRILLIC CAPITAL LETTER IOTA"           nil     )
    (#x00a647 "CYRILLIC SMALL LETTER IOTA"             nil     )
    (#x00a648 "CYRILLIC CAPITAL LETTER DJERV"          nil     )
    (#x00a649 "CYRILLIC SMALL LETTER DJERV"            nil     )
    (#x00a64a "CYRILLIC CAPITAL LETTER MONOGRAPH UK"   nil     )
    (#x00a64b "CYRILLIC SMALL LETTER MONOGRAPH UK"     nil     )
    (#x00a64c "CYRILLIC CAPITAL LETTER BROAD OMEGA"    nil     )
    (#x00a64d "CYRILLIC SMALL LETTER BROAD OMEGA"      nil     )
    (#x00a64e "CYRILLIC CAPITAL LETTER NEUTRAL YER"    nil     )
    (#x00a64f "CYRILLIC SMALL LETTER NEUTRAL YER"      nil     )
    (#x00a650 "CYRILLIC CAPITAL LETTER YERU WITH BACK YER" nil     )
    (#x00a651 "CYRILLIC SMALL LETTER YERU WITH BACK YER" nil     )
    (#x00a652 "CYRILLIC CAPITAL LETTER IOTIFIED YAT"   nil     )
    (#x00a653 "CYRILLIC SMALL LETTER IOTIFIED YAT"     nil     )
    (#x00a654 "CYRILLIC CAPITAL LETTER REVERSED YU"    nil     )
    (#x00a655 "CYRILLIC SMALL LETTER REVERSED YU"      nil     )
    (#x00a656 "CYRILLIC CAPITAL LETTER IOTIFIED A"     nil     )
    (#x00a657 "CYRILLIC SMALL LETTER IOTIFIED A"       nil     )
    (#x00a658 "CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS" nil     )
    (#x00a659 "CYRILLIC SMALL LETTER CLOSED LITTLE YUS" nil     )
    (#x00a65a "CYRILLIC CAPITAL LETTER BLENDED YUS"    nil     )
    (#x00a65b "CYRILLIC SMALL LETTER BLENDED YUS"      nil     )
    (#x00a65c "CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS" nil     )
    (#x00a65d "CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS" nil     )
    (#x00a65e "CYRILLIC CAPITAL LETTER YN"             nil     )
    (#x00a65f "CYRILLIC SMALL LETTER YN"               nil     )
    (#x00a660 "CYRILLIC CAPITAL LETTER REVERSED TSE"   nil     )
    (#x00a661 "CYRILLIC SMALL LETTER REVERSED TSE"     nil     )
    (#x00a662 "CYRILLIC CAPITAL LETTER SOFT DE"        nil     )
    (#x00a663 "CYRILLIC SMALL LETTER SOFT DE"          nil     )
    (#x00a664 "CYRILLIC CAPITAL LETTER SOFT EL"        nil     )
    (#x00a665 "CYRILLIC SMALL LETTER SOFT EL"          nil     )
    (#x00a666 "CYRILLIC CAPITAL LETTER SOFT EM"        nil     )
    (#x00a667 "CYRILLIC SMALL LETTER SOFT EM"          nil     )
    (#x00a668 "CYRILLIC CAPITAL LETTER MONOCULAR O"    nil     )
    (#x00a669 "CYRILLIC SMALL LETTER MONOCULAR O"      nil     )
    (#x00a66a "CYRILLIC CAPITAL LETTER BINOCULAR O"    nil     )
    (#x00a66b "CYRILLIC SMALL LETTER BINOCULAR O"      nil     )
    (#x00a66c "CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O" nil     )
    (#x00a66d "CYRILLIC SMALL LETTER DOUBLE MONOCULAR O" nil     )
    (#x00a66e "CYRILLIC LETTER MULTIOCULAR O"          nil     )
    (#x00a66f "COMBINING CYRILLIC VZMET"               nil     )
    (#x00a670 "COMBINING CYRILLIC TEN MILLIONS SIGN"   nil     )
    (#x00a671 "COMBINING CYRILLIC HUNDRED MILLIONS SIGN" nil     )
    (#x00a672 "COMBINING CYRILLIC THOUSAND MILLIONS SIGN" nil     )
    (#x00a673 "SLAVONIC ASTERISK"                      nil     )
    (#x00a674 "COMBINING CYRILLIC LETTER UKRAINIAN IE" nil     )
    (#x00a675 "COMBINING CYRILLIC LETTER I"            nil     )
    (#x00a676 "COMBINING CYRILLIC LETTER YI"           nil     )
    (#x00a677 "COMBINING CYRILLIC LETTER U"            nil     )
    (#x00a678 "COMBINING CYRILLIC LETTER HARD SIGN"    nil     )
    (#x00a679 "COMBINING CYRILLIC LETTER YERU"         nil     )
    (#x00a67a "COMBINING CYRILLIC LETTER SOFT SIGN"    nil     )
    (#x00a67b "COMBINING CYRILLIC LETTER OMEGA"        nil     )
    (#x00a67c "COMBINING CYRILLIC KAVYKA"              nil     )
    (#x00a67d "COMBINING CYRILLIC PAYEROK"             nil     )
    (#x00a67e "CYRILLIC KAVYKA"                        nil     )
    (#x00a67f "CYRILLIC PAYEROK"                       nil     )
    (#x00a680 "CYRILLIC CAPITAL LETTER DWE"            nil     )
    (#x00a681 "CYRILLIC SMALL LETTER DWE"              nil     )
    (#x00a682 "CYRILLIC CAPITAL LETTER DZWE"           nil     )
    (#x00a683 "CYRILLIC SMALL LETTER DZWE"             nil     )
    (#x00a684 "CYRILLIC CAPITAL LETTER ZHWE"           nil     )
    (#x00a685 "CYRILLIC SMALL LETTER ZHWE"             nil     )
    (#x00a686 "CYRILLIC CAPITAL LETTER CCHE"           nil     )
    (#x00a687 "CYRILLIC SMALL LETTER CCHE"             nil     )
    (#x00a688 "CYRILLIC CAPITAL LETTER DZZE"           nil     )
    (#x00a689 "CYRILLIC SMALL LETTER DZZE"             nil     )
    (#x00a68a "CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK" nil     )
    (#x00a68b "CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK" nil     )
    (#x00a68c "CYRILLIC CAPITAL LETTER TWE"            nil     )
    (#x00a68d "CYRILLIC SMALL LETTER TWE"              nil     )
    (#x00a68e "CYRILLIC CAPITAL LETTER TSWE"           nil     )
    (#x00a68f "CYRILLIC SMALL LETTER TSWE"             nil     )
    (#x00a690 "CYRILLIC CAPITAL LETTER TSSE"           nil     )
    (#x00a691 "CYRILLIC SMALL LETTER TSSE"             nil     )
    (#x00a692 "CYRILLIC CAPITAL LETTER TCHE"           nil     )
    (#x00a693 "CYRILLIC SMALL LETTER TCHE"             nil     )
    (#x00a694 "CYRILLIC CAPITAL LETTER HWE"            nil     )
    (#x00a695 "CYRILLIC SMALL LETTER HWE"              nil     )
    (#x00a696 "CYRILLIC CAPITAL LETTER SHWE"           nil     )
    (#x00a697 "CYRILLIC SMALL LETTER SHWE"             nil     )
    (#x00a698 "CYRILLIC CAPITAL LETTER DOUBLE O"       nil     )
    (#x00a699 "CYRILLIC SMALL LETTER DOUBLE O"         nil     )
    (#x00a69a "CYRILLIC CAPITAL LETTER CROSSED O"      nil     )
    (#x00a69b "CYRILLIC SMALL LETTER CROSSED O"        nil     )
    (#x00a69c "MODIFIER LETTER CYRILLIC HARD SIGN"     nil     )
    (#x00a69d "MODIFIER LETTER CYRILLIC SOFT SIGN"     nil     )
    (#x00a69e "COMBINING CYRILLIC LETTER EF"           nil     )
    (#x00a69f "COMBINING CYRILLIC LETTER IOTIFIED E"   nil     )
    (#x00a6a0 "BAMUM LETTER A"                         nil     )
    (#x00a6a1 "BAMUM LETTER KA"                        nil     )
    (#x00a6a2 "BAMUM LETTER U"                         nil     )
    (#x00a6a3 "BAMUM LETTER KU"                        nil     )
    (#x00a6a4 "BAMUM LETTER EE"                        nil     )
    (#x00a6a5 "BAMUM LETTER REE"                       nil     )
    (#x00a6a6 "BAMUM LETTER TAE"                       nil     )
    (#x00a6a7 "BAMUM LETTER O"                         nil     )
    (#x00a6a8 "BAMUM LETTER NYI"                       nil     )
    (#x00a6a9 "BAMUM LETTER I"                         nil     )
    (#x00a6aa "BAMUM LETTER LA"                        nil     )
    (#x00a6ab "BAMUM LETTER PA"                        nil     )
    (#x00a6ac "BAMUM LETTER RII"                       nil     )
    (#x00a6ad "BAMUM LETTER RIEE"                      nil     )
    (#x00a6ae "BAMUM LETTER LEEEE"                     nil     )
    (#x00a6af "BAMUM LETTER MEEEE"                     nil     )
    (#x00a6b0 "BAMUM LETTER TAA"                       nil     )
    (#x00a6b1 "BAMUM LETTER NDAA"                      nil     )
    (#x00a6b2 "BAMUM LETTER NJAEM"                     nil     )
    (#x00a6b3 "BAMUM LETTER M"                         nil     )
    (#x00a6b4 "BAMUM LETTER SUU"                       nil     )
    (#x00a6b5 "BAMUM LETTER MU"                        nil     )
    (#x00a6b6 "BAMUM LETTER SHII"                      nil     )
    (#x00a6b7 "BAMUM LETTER SI"                        nil     )
    (#x00a6b8 "BAMUM LETTER SHEUX"                     nil     )
    (#x00a6b9 "BAMUM LETTER SEUX"                      nil     )
    (#x00a6ba "BAMUM LETTER KYEE"                      nil     )
    (#x00a6bb "BAMUM LETTER KET"                       nil     )
    (#x00a6bc "BAMUM LETTER NUAE"                      nil     )
    (#x00a6bd "BAMUM LETTER NU"                        nil     )
    (#x00a6be "BAMUM LETTER NJUAE"                     nil     )
    (#x00a6bf "BAMUM LETTER YOQ"                       nil     )
    (#x00a6c0 "BAMUM LETTER SHU"                       nil     )
    (#x00a6c1 "BAMUM LETTER YUQ"                       nil     )
    (#x00a6c2 "BAMUM LETTER YA"                        nil     )
    (#x00a6c3 "BAMUM LETTER NSHA"                      nil     )
    (#x00a6c4 "BAMUM LETTER KEUX"                      nil     )
    (#x00a6c5 "BAMUM LETTER PEUX"                      nil     )
    (#x00a6c6 "BAMUM LETTER NJEE"                      nil     )
    (#x00a6c7 "BAMUM LETTER NTEE"                      nil     )
    (#x00a6c8 "BAMUM LETTER PUE"                       nil     )
    (#x00a6c9 "BAMUM LETTER WUE"                       nil     )
    (#x00a6ca "BAMUM LETTER PEE"                       nil     )
    (#x00a6cb "BAMUM LETTER FEE"                       nil     )
    (#x00a6cc "BAMUM LETTER RU"                        nil     )
    (#x00a6cd "BAMUM LETTER LU"                        nil     )
    (#x00a6ce "BAMUM LETTER MI"                        nil     )
    (#x00a6cf "BAMUM LETTER NI"                        nil     )
    (#x00a6d0 "BAMUM LETTER REUX"                      nil     )
    (#x00a6d1 "BAMUM LETTER RAE"                       nil     )
    (#x00a6d2 "BAMUM LETTER KEN"                       nil     )
    (#x00a6d3 "BAMUM LETTER NGKWAEN"                   nil     )
    (#x00a6d4 "BAMUM LETTER NGGA"                      nil     )
    (#x00a6d5 "BAMUM LETTER NGA"                       nil     )
    (#x00a6d6 "BAMUM LETTER SHO"                       nil     )
    (#x00a6d7 "BAMUM LETTER PUAE"                      nil     )
    (#x00a6d8 "BAMUM LETTER FU"                        nil     )
    (#x00a6d9 "BAMUM LETTER FOM"                       nil     )
    (#x00a6da "BAMUM LETTER WA"                        nil     )
    (#x00a6db "BAMUM LETTER NA"                        nil     )
    (#x00a6dc "BAMUM LETTER LI"                        nil     )
    (#x00a6dd "BAMUM LETTER PI"                        nil     )
    (#x00a6de "BAMUM LETTER LOQ"                       nil     )
    (#x00a6df "BAMUM LETTER KO"                        nil     )
    (#x00a6e0 "BAMUM LETTER MBEN"                      nil     )
    (#x00a6e1 "BAMUM LETTER REN"                       nil     )
    (#x00a6e2 "BAMUM LETTER MEN"                       nil     )
    (#x00a6e3 "BAMUM LETTER MA"                        nil     )
    (#x00a6e4 "BAMUM LETTER TI"                        nil     )
    (#x00a6e5 "BAMUM LETTER KI"                        nil     )
    (#x00a6e6 "BAMUM LETTER MO"                        nil     )
    (#x00a6e7 "BAMUM LETTER MBAA"                      nil     )
    (#x00a6e8 "BAMUM LETTER TET"                       nil     )
    (#x00a6e9 "BAMUM LETTER KPA"                       nil     )
    (#x00a6ea "BAMUM LETTER TEN"                       nil     )
    (#x00a6eb "BAMUM LETTER NTUU"                      nil     )
    (#x00a6ec "BAMUM LETTER SAMBA"                     nil     )
    (#x00a6ed "BAMUM LETTER FAAMAE"                    nil     )
    (#x00a6ee "BAMUM LETTER KOVUU"                     nil     )
    (#x00a6ef "BAMUM LETTER KOGHOM"                    nil     )
    (#x00a6f0 "BAMUM COMBINING MARK KOQNDON"           nil     )
    (#x00a6f1 "BAMUM COMBINING MARK TUKWENTIS"         nil     )
    (#x00a6f2 "BAMUM NJAEMLI"                          nil     )
    (#x00a6f3 "BAMUM FULL STOP"                        nil     )
    (#x00a6f4 "BAMUM COLON"                            nil     )
    (#x00a6f5 "BAMUM COMMA"                            nil     )
    (#x00a6f6 "BAMUM SEMICOLON"                        nil     )
    (#x00a6f7 "BAMUM QUESTION MARK"                    nil     )
    (#x00a700 "MODIFIER LETTER CHINESE TONE YIN PING"  nil     )
    (#x00a701 "MODIFIER LETTER CHINESE TONE YANG PING" nil     )
    (#x00a702 "MODIFIER LETTER CHINESE TONE YIN SHANG" nil     )
    (#x00a703 "MODIFIER LETTER CHINESE TONE YANG SHANG" nil     )
    (#x00a704 "MODIFIER LETTER CHINESE TONE YIN QU"    nil     )
    (#x00a705 "MODIFIER LETTER CHINESE TONE YANG QU"   nil     )
    (#x00a706 "MODIFIER LETTER CHINESE TONE YIN RU"    nil     )
    (#x00a707 "MODIFIER LETTER CHINESE TONE YANG RU"   nil     )
    (#x00a708 "MODIFIER LETTER EXTRA-HIGH DOTTED TONE BAR" nil     )
    (#x00a709 "MODIFIER LETTER HIGH DOTTED TONE BAR"   nil     )
    (#x00a70a "MODIFIER LETTER MID DOTTED TONE BAR"    nil     )
    (#x00a70b "MODIFIER LETTER LOW DOTTED TONE BAR"    nil     )
    (#x00a70c "MODIFIER LETTER EXTRA-LOW DOTTED TONE BAR" nil     )
    (#x00a70d "MODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE BAR" nil     )
    (#x00a70e "MODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BAR" nil     )
    (#x00a70f "MODIFIER LETTER MID DOTTED LEFT-STEM TONE BAR" nil     )
    (#x00a710 "MODIFIER LETTER LOW DOTTED LEFT-STEM TONE BAR" nil     )
    (#x00a711 "MODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BAR" nil     )
    (#x00a712 "MODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BAR" nil     )
    (#x00a713 "MODIFIER LETTER HIGH LEFT-STEM TONE BAR" nil     )
    (#x00a714 "MODIFIER LETTER MID LEFT-STEM TONE BAR" nil     )
    (#x00a715 "MODIFIER LETTER LOW LEFT-STEM TONE BAR" nil     )
    (#x00a716 "MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR" nil     )
    (#x00a717 "MODIFIER LETTER DOT VERTICAL BAR"       nil     )
    (#x00a718 "MODIFIER LETTER DOT SLASH"              nil     )
    (#x00a719 "MODIFIER LETTER DOT HORIZONTAL BAR"     nil     )
    (#x00a71a "MODIFIER LETTER LOWER RIGHT CORNER ANGLE" nil     )
    (#x00a71b "MODIFIER LETTER RAISED UP ARROW"        nil     )
    (#x00a71c "MODIFIER LETTER RAISED DOWN ARROW"      nil     )
    (#x00a71d "MODIFIER LETTER RAISED EXCLAMATION MARK" nil     )
    (#x00a71e "MODIFIER LETTER RAISED INVERTED EXCLAMATION MARK" nil     )
    (#x00a71f "MODIFIER LETTER LOW INVERTED EXCLAMATION MARK" nil     )
    (#x00a720 "MODIFIER LETTER STRESS AND HIGH TONE"   nil     )
    (#x00a721 "MODIFIER LETTER STRESS AND LOW TONE"    nil     )
    (#x00a722 "LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF" nil     )
    (#x00a723 "LATIN SMALL LETTER EGYPTOLOGICAL ALEF"  nil     )
    (#x00a724 "LATIN CAPITAL LETTER EGYPTOLOGICAL AIN" nil     )
    (#x00a725 "LATIN SMALL LETTER EGYPTOLOGICAL AIN"   nil     )
    (#x00a726 "LATIN CAPITAL LETTER HENG"              nil     )
    (#x00a727 "LATIN SMALL LETTER HENG"                nil     )
    (#x00a728 "LATIN CAPITAL LETTER TZ"                nil     )
    (#x00a729 "LATIN SMALL LETTER TZ"                  nil     )
    (#x00a72a "LATIN CAPITAL LETTER TRESILLO"          nil     )
    (#x00a72b "LATIN SMALL LETTER TRESILLO"            nil     )
    (#x00a72c "LATIN CAPITAL LETTER CUATRILLO"         nil     )
    (#x00a72d "LATIN SMALL LETTER CUATRILLO"           nil     )
    (#x00a72e "LATIN CAPITAL LETTER CUATRILLO WITH COMMA" nil     )
    (#x00a72f "LATIN SMALL LETTER CUATRILLO WITH COMMA" nil     )
    (#x00a730 "LATIN LETTER SMALL CAPITAL F"           nil     )
    (#x00a731 "LATIN LETTER SMALL CAPITAL S"           nil     )
    (#x00a732 "LATIN CAPITAL LETTER AA"                nil     )
    (#x00a733 "LATIN SMALL LETTER AA"                  nil     )
    (#x00a734 "LATIN CAPITAL LETTER AO"                nil     )
    (#x00a735 "LATIN SMALL LETTER AO"                  nil     )
    (#x00a736 "LATIN CAPITAL LETTER AU"                nil     )
    (#x00a737 "LATIN SMALL LETTER AU"                  nil     )
    (#x00a738 "LATIN CAPITAL LETTER AV"                nil     )
    (#x00a739 "LATIN SMALL LETTER AV"                  nil     )
    (#x00a73a "LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR" nil     )
    (#x00a73b "LATIN SMALL LETTER AV WITH HORIZONTAL BAR" nil     )
    (#x00a73c "LATIN CAPITAL LETTER AY"                nil     )
    (#x00a73d "LATIN SMALL LETTER AY"                  nil     )
    (#x00a73e "LATIN CAPITAL LETTER REVERSED C WITH DOT" nil     )
    (#x00a73f "LATIN SMALL LETTER REVERSED C WITH DOT" nil     )
    (#x00a740 "LATIN CAPITAL LETTER K WITH STROKE"     nil     )
    (#x00a741 "LATIN SMALL LETTER K WITH STROKE"       nil     )
    (#x00a742 "LATIN CAPITAL LETTER K WITH DIAGONAL STROKE" nil     )
    (#x00a743 "LATIN SMALL LETTER K WITH DIAGONAL STROKE" nil     )
    (#x00a744 "LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE" nil     )
    (#x00a745 "LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE" nil     )
    (#x00a746 "LATIN CAPITAL LETTER BROKEN L"          nil     )
    (#x00a747 "LATIN SMALL LETTER BROKEN L"            nil     )
    (#x00a748 "LATIN CAPITAL LETTER L WITH HIGH STROKE" nil     )
    (#x00a749 "LATIN SMALL LETTER L WITH HIGH STROKE"  nil     )
    (#x00a74a "LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY" nil     )
    (#x00a74b "LATIN SMALL LETTER O WITH LONG STROKE OVERLAY" nil     )
    (#x00a74c "LATIN CAPITAL LETTER O WITH LOOP"       nil     )
    (#x00a74d "LATIN SMALL LETTER O WITH LOOP"         nil     )
    (#x00a74e "LATIN CAPITAL LETTER OO"                nil     )
    (#x00a74f "LATIN SMALL LETTER OO"                  nil     )
    (#x00a750 "LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER" nil     )
    (#x00a751 "LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER" nil     )
    (#x00a752 "LATIN CAPITAL LETTER P WITH FLOURISH"   nil     )
    (#x00a753 "LATIN SMALL LETTER P WITH FLOURISH"     nil     )
    (#x00a754 "LATIN CAPITAL LETTER P WITH SQUIRREL TAIL" nil     )
    (#x00a755 "LATIN SMALL LETTER P WITH SQUIRREL TAIL" nil     )
    (#x00a756 "LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER" nil     )
    (#x00a757 "LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER" nil     )
    (#x00a758 "LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE" nil     )
    (#x00a759 "LATIN SMALL LETTER Q WITH DIAGONAL STROKE" nil     )
    (#x00a75a "LATIN CAPITAL LETTER R ROTUNDA"         nil     )
    (#x00a75b "LATIN SMALL LETTER R ROTUNDA"           nil     )
    (#x00a75c "LATIN CAPITAL LETTER RUM ROTUNDA"       nil     )
    (#x00a75d "LATIN SMALL LETTER RUM ROTUNDA"         nil     )
    (#x00a75e "LATIN CAPITAL LETTER V WITH DIAGONAL STROKE" nil     )
    (#x00a75f "LATIN SMALL LETTER V WITH DIAGONAL STROKE" nil     )
    (#x00a760 "LATIN CAPITAL LETTER VY"                nil     )
    (#x00a761 "LATIN SMALL LETTER VY"                  nil     )
    (#x00a762 "LATIN CAPITAL LETTER VISIGOTHIC Z"      nil     )
    (#x00a763 "LATIN SMALL LETTER VISIGOTHIC Z"        nil     )
    (#x00a764 "LATIN CAPITAL LETTER THORN WITH STROKE" nil     )
    (#x00a765 "LATIN SMALL LETTER THORN WITH STROKE"   nil     )
    (#x00a766 "LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER" nil     )
    (#x00a767 "LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER" nil     )
    (#x00a768 "LATIN CAPITAL LETTER VEND"              nil     )
    (#x00a769 "LATIN SMALL LETTER VEND"                nil     )
    (#x00a76a "LATIN CAPITAL LETTER ET"                nil     )
    (#x00a76b "LATIN SMALL LETTER ET"                  nil     )
    (#x00a76c "LATIN CAPITAL LETTER IS"                nil     )
    (#x00a76d "LATIN SMALL LETTER IS"                  nil     )
    (#x00a76e "LATIN CAPITAL LETTER CON"               nil     )
    (#x00a76f "LATIN SMALL LETTER CON"                 nil     )
    (#x00a770 "MODIFIER LETTER US"                     nil     )
    (#x00a771 "LATIN SMALL LETTER DUM"                 nil     )
    (#x00a772 "LATIN SMALL LETTER LUM"                 nil     )
    (#x00a773 "LATIN SMALL LETTER MUM"                 nil     )
    (#x00a774 "LATIN SMALL LETTER NUM"                 nil     )
    (#x00a775 "LATIN SMALL LETTER RUM"                 nil     )
    (#x00a776 "LATIN LETTER SMALL CAPITAL RUM"         nil     )
    (#x00a777 "LATIN SMALL LETTER TUM"                 nil     )
    (#x00a778 "LATIN SMALL LETTER UM"                  nil     )
    (#x00a779 "LATIN CAPITAL LETTER INSULAR D"         nil     )
    (#x00a77a "LATIN SMALL LETTER INSULAR D"           nil     )
    (#x00a77b "LATIN CAPITAL LETTER INSULAR F"         nil     )
    (#x00a77c "LATIN SMALL LETTER INSULAR F"           nil     )
    (#x00a77d "LATIN CAPITAL LETTER INSULAR G"         nil     )
    (#x00a77e "LATIN CAPITAL LETTER TURNED INSULAR G"  nil     )
    (#x00a77f "LATIN SMALL LETTER TURNED INSULAR G"    nil     )
    (#x00a780 "LATIN CAPITAL LETTER TURNED L"          nil     )
    (#x00a781 "LATIN SMALL LETTER TURNED L"            nil     )
    (#x00a782 "LATIN CAPITAL LETTER INSULAR R"         nil     )
    (#x00a783 "LATIN SMALL LETTER INSULAR R"           nil     )
    (#x00a784 "LATIN CAPITAL LETTER INSULAR S"         nil     )
    (#x00a785 "LATIN SMALL LETTER INSULAR S"           nil     )
    (#x00a786 "LATIN CAPITAL LETTER INSULAR T"         nil     )
    (#x00a787 "LATIN SMALL LETTER INSULAR T"           nil     )
    (#x00a788 "MODIFIER LETTER LOW CIRCUMFLEX ACCENT"  nil     )
    (#x00a789 "MODIFIER LETTER COLON"                  nil     )
    (#x00a78a "MODIFIER LETTER SHORT EQUALS SIGN"      nil     )
    (#x00a78b "LATIN CAPITAL LETTER SALTILLO"          nil     )
    (#x00a78c "LATIN SMALL LETTER SALTILLO"            nil     )
    (#x00a78d "LATIN CAPITAL LETTER TURNED H"          nil     )
    (#x00a78e "LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT" nil     )
    (#x00a78f "LATIN LETTER SINOLOGICAL DOT"           nil     )
    (#x00a790 "LATIN CAPITAL LETTER N WITH DESCENDER"  nil     )
    (#x00a791 "LATIN SMALL LETTER N WITH DESCENDER"    nil     )
    (#x00a792 "LATIN CAPITAL LETTER C WITH BAR"        nil     )
    (#x00a793 "LATIN SMALL LETTER C WITH BAR"          nil     )
    (#x00a794 "LATIN SMALL LETTER C WITH PALATAL HOOK" nil     )
    (#x00a795 "LATIN SMALL LETTER H WITH PALATAL HOOK" nil     )
    (#x00a796 "LATIN CAPITAL LETTER B WITH FLOURISH"   nil     )
    (#x00a797 "LATIN SMALL LETTER B WITH FLOURISH"     nil     )
    (#x00a798 "LATIN CAPITAL LETTER F WITH STROKE"     nil     )
    (#x00a799 "LATIN SMALL LETTER F WITH STROKE"       nil     )
    (#x00a79a "LATIN CAPITAL LETTER VOLAPUK AE"        nil     )
    (#x00a79b "LATIN SMALL LETTER VOLAPUK AE"          nil     )
    (#x00a79c "LATIN CAPITAL LETTER VOLAPUK OE"        nil     )
    (#x00a79d "LATIN SMALL LETTER VOLAPUK OE"          nil     )
    (#x00a79e "LATIN CAPITAL LETTER VOLAPUK UE"        nil     )
    (#x00a79f "LATIN SMALL LETTER VOLAPUK UE"          nil     )
    (#x00a7a0 "LATIN CAPITAL LETTER G WITH OBLIQUE STROKE" nil     )
    (#x00a7a1 "LATIN SMALL LETTER G WITH OBLIQUE STROKE" nil     )
    (#x00a7a2 "LATIN CAPITAL LETTER K WITH OBLIQUE STROKE" nil     )
    (#x00a7a3 "LATIN SMALL LETTER K WITH OBLIQUE STROKE" nil     )
    (#x00a7a4 "LATIN CAPITAL LETTER N WITH OBLIQUE STROKE" nil     )
    (#x00a7a5 "LATIN SMALL LETTER N WITH OBLIQUE STROKE" nil     )
    (#x00a7a6 "LATIN CAPITAL LETTER R WITH OBLIQUE STROKE" nil     )
    (#x00a7a7 "LATIN SMALL LETTER R WITH OBLIQUE STROKE" nil     )
    (#x00a7a8 "LATIN CAPITAL LETTER S WITH OBLIQUE STROKE" nil     )
    (#x00a7a9 "LATIN SMALL LETTER S WITH OBLIQUE STROKE" nil     )
    (#x00a7aa "LATIN CAPITAL LETTER H WITH HOOK"       nil     )
    (#x00a7ab "LATIN CAPITAL LETTER REVERSED OPEN E"   nil     )
    (#x00a7ac "LATIN CAPITAL LETTER SCRIPT G"          nil     )
    (#x00a7ad "LATIN CAPITAL LETTER L WITH BELT"       nil     )
    (#x00a7ae "LATIN CAPITAL LETTER SMALL CAPITAL I"   nil     )
    (#x00a7af "LATIN LETTER SMALL CAPITAL Q"           nil     )
    (#x00a7b0 "LATIN CAPITAL LETTER TURNED K"          nil     )
    (#x00a7b1 "LATIN CAPITAL LETTER TURNED T"          nil     )
    (#x00a7b2 "LATIN CAPITAL LETTER J WITH CROSSED-TAIL" nil     )
    (#x00a7b3 "LATIN CAPITAL LETTER CHI"               nil     )
    (#x00a7b4 "LATIN CAPITAL LETTER BETA"              nil     )
    (#x00a7b5 "LATIN SMALL LETTER BETA"                nil     )
    (#x00a7b6 "LATIN CAPITAL LETTER OMEGA"             nil     )
    (#x00a7b7 "LATIN SMALL LETTER OMEGA"               nil     )
    (#x00a7b8 "LATIN CAPITAL LETTER U WITH STROKE"     nil     )
    (#x00a7b9 "LATIN SMALL LETTER U WITH STROKE"       nil     )
    (#x00a7ba "LATIN CAPITAL LETTER GLOTTAL A"         nil     )
    (#x00a7bb "LATIN SMALL LETTER GLOTTAL A"           nil     )
    (#x00a7bc "LATIN CAPITAL LETTER GLOTTAL I"         nil     )
    (#x00a7bd "LATIN SMALL LETTER GLOTTAL I"           nil     )
    (#x00a7be "LATIN CAPITAL LETTER GLOTTAL U"         nil     )
    (#x00a7bf "LATIN SMALL LETTER GLOTTAL U"           nil     )
    (#x00a7c0 "LATIN CAPITAL LETTER OLD POLISH O"      nil     )
    (#x00a7c1 "LATIN SMALL LETTER OLD POLISH O"        nil     )
    (#x00a7c2 "LATIN CAPITAL LETTER ANGLICANA W"       nil     )
    (#x00a7c3 "LATIN SMALL LETTER ANGLICANA W"         nil     )
    (#x00a7c4 "LATIN CAPITAL LETTER C WITH PALATAL HOOK" nil     )
    (#x00a7c5 "LATIN CAPITAL LETTER S WITH HOOK"       nil     )
    (#x00a7c6 "LATIN CAPITAL LETTER Z WITH PALATAL HOOK" nil     )
    (#x00a7c7 "LATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAY" nil     )
    (#x00a7c8 "LATIN SMALL LETTER D WITH SHORT STROKE OVERLAY" nil     )
    (#x00a7c9 "LATIN CAPITAL LETTER S WITH SHORT STROKE OVERLAY" nil     )
    (#x00a7ca "LATIN SMALL LETTER S WITH SHORT STROKE OVERLAY" nil     )
    (#x00a7d0 "LATIN CAPITAL LETTER CLOSED INSULAR G"  nil     )
    (#x00a7d1 "LATIN SMALL LETTER CLOSED INSULAR G"    nil     )
    (#x00a7d3 "LATIN SMALL LETTER DOUBLE THORN"        nil     )
    (#x00a7d5 "LATIN SMALL LETTER DOUBLE WYNN"         nil     )
    (#x00a7d6 "LATIN CAPITAL LETTER MIDDLE SCOTS S"    nil     )
    (#x00a7d7 "LATIN SMALL LETTER MIDDLE SCOTS S"      nil     )
    (#x00a7d8 "LATIN CAPITAL LETTER SIGMOID S"         nil     )
    (#x00a7d9 "LATIN SMALL LETTER SIGMOID S"           nil     )
    (#x00a7f2 "MODIFIER LETTER CAPITAL C"              nil     )
    (#x00a7f3 "MODIFIER LETTER CAPITAL F"              nil     )
    (#x00a7f4 "MODIFIER LETTER CAPITAL Q"              nil     )
    (#x00a7f5 "LATIN CAPITAL LETTER REVERSED HALF H"   nil     )
    (#x00a7f6 "LATIN SMALL LETTER REVERSED HALF H"     nil     )
    (#x00a7f7 "LATIN EPIGRAPHIC LETTER SIDEWAYS I"     nil     )
    (#x00a7f8 "MODIFIER LETTER CAPITAL H WITH STROKE"  nil     )
    (#x00a7f9 "MODIFIER LETTER SMALL LIGATURE OE"      nil     )
    (#x00a7fa "LATIN LETTER SMALL CAPITAL TURNED M"    nil     )
    (#x00a7fb "LATIN EPIGRAPHIC LETTER REVERSED F"     nil     )
    (#x00a7fc "LATIN EPIGRAPHIC LETTER REVERSED P"     nil     )
    (#x00a7fd "LATIN EPIGRAPHIC LETTER INVERTED M"     nil     )
    (#x00a7fe "LATIN EPIGRAPHIC LETTER I LONGA"        nil     )
    (#x00a7ff "LATIN EPIGRAPHIC LETTER ARCHAIC M"      nil     )
    (#x00a800 "SYLOTI NAGRI LETTER A"                  nil     )
    (#x00a801 "SYLOTI NAGRI LETTER I"                  nil     )
    (#x00a802 "SYLOTI NAGRI SIGN DVISVARA"             nil     )
    (#x00a803 "SYLOTI NAGRI LETTER U"                  nil     )
    (#x00a804 "SYLOTI NAGRI LETTER E"                  nil     )
    (#x00a805 "SYLOTI NAGRI LETTER O"                  nil     )
    (#x00a806 "SYLOTI NAGRI SIGN HASANTA"              nil     )
    (#x00a807 "SYLOTI NAGRI LETTER KO"                 nil     )
    (#x00a808 "SYLOTI NAGRI LETTER KHO"                nil     )
    (#x00a809 "SYLOTI NAGRI LETTER GO"                 nil     )
    (#x00a80a "SYLOTI NAGRI LETTER GHO"                nil     )
    (#x00a80b "SYLOTI NAGRI SIGN ANUSVARA"             nil     )
    (#x00a80c "SYLOTI NAGRI LETTER CO"                 nil     )
    (#x00a80d "SYLOTI NAGRI LETTER CHO"                nil     )
    (#x00a80e "SYLOTI NAGRI LETTER JO"                 nil     )
    (#x00a80f "SYLOTI NAGRI LETTER JHO"                nil     )
    (#x00a810 "SYLOTI NAGRI LETTER TTO"                nil     )
    (#x00a811 "SYLOTI NAGRI LETTER TTHO"               nil     )
    (#x00a812 "SYLOTI NAGRI LETTER DDO"                nil     )
    (#x00a813 "SYLOTI NAGRI LETTER DDHO"               nil     )
    (#x00a814 "SYLOTI NAGRI LETTER TO"                 nil     )
    (#x00a815 "SYLOTI NAGRI LETTER THO"                nil     )
    (#x00a816 "SYLOTI NAGRI LETTER DO"                 nil     )
    (#x00a817 "SYLOTI NAGRI LETTER DHO"                nil     )
    (#x00a818 "SYLOTI NAGRI LETTER NO"                 nil     )
    (#x00a819 "SYLOTI NAGRI LETTER PO"                 nil     )
    (#x00a81a "SYLOTI NAGRI LETTER PHO"                nil     )
    (#x00a81b "SYLOTI NAGRI LETTER BO"                 nil     )
    (#x00a81c "SYLOTI NAGRI LETTER BHO"                nil     )
    (#x00a81d "SYLOTI NAGRI LETTER MO"                 nil     )
    (#x00a81e "SYLOTI NAGRI LETTER RO"                 nil     )
    (#x00a81f "SYLOTI NAGRI LETTER LO"                 nil     )
    (#x00a820 "SYLOTI NAGRI LETTER RRO"                nil     )
    (#x00a821 "SYLOTI NAGRI LETTER SO"                 nil     )
    (#x00a822 "SYLOTI NAGRI LETTER HO"                 nil     )
    (#x00a823 "SYLOTI NAGRI VOWEL SIGN A"              nil     )
    (#x00a824 "SYLOTI NAGRI VOWEL SIGN I"              nil     )
    (#x00a825 "SYLOTI NAGRI VOWEL SIGN U"              nil     )
    (#x00a826 "SYLOTI NAGRI VOWEL SIGN E"              nil     )
    (#x00a827 "SYLOTI NAGRI VOWEL SIGN OO"             nil     )
    (#x00a828 "SYLOTI NAGRI POETRY MARK-1"             nil     )
    (#x00a829 "SYLOTI NAGRI POETRY MARK-2"             nil     )
    (#x00a82a "SYLOTI NAGRI POETRY MARK-3"             nil     )
    (#x00a82b "SYLOTI NAGRI POETRY MARK-4"             nil     )
    (#x00a82c "SYLOTI NAGRI SIGN ALTERNATE HASANTA"    nil     )
    (#x00a830 "NORTH INDIC FRACTION ONE QUARTER"       nil     )
    (#x00a831 "NORTH INDIC FRACTION ONE HALF"          nil     )
    (#x00a832 "NORTH INDIC FRACTION THREE QUARTERS"    nil     )
    (#x00a833 "NORTH INDIC FRACTION ONE SIXTEENTH"     nil     )
    (#x00a834 "NORTH INDIC FRACTION ONE EIGHTH"        nil     )
    (#x00a835 "NORTH INDIC FRACTION THREE SIXTEENTHS"  nil     )
    (#x00a836 "NORTH INDIC QUARTER MARK"               nil     )
    (#x00a837 "NORTH INDIC PLACEHOLDER MARK"           nil     )
    (#x00a838 "NORTH INDIC RUPEE MARK"                 nil     )
    (#x00a839 "NORTH INDIC QUANTITY MARK"              nil     )
    (#x00a840 "PHAGS-PA LETTER KA"                     nil     )
    (#x00a841 "PHAGS-PA LETTER KHA"                    nil     )
    (#x00a842 "PHAGS-PA LETTER GA"                     nil     )
    (#x00a843 "PHAGS-PA LETTER NGA"                    nil     )
    (#x00a844 "PHAGS-PA LETTER CA"                     nil     )
    (#x00a845 "PHAGS-PA LETTER CHA"                    nil     )
    (#x00a846 "PHAGS-PA LETTER JA"                     nil     )
    (#x00a847 "PHAGS-PA LETTER NYA"                    nil     )
    (#x00a848 "PHAGS-PA LETTER TA"                     nil     )
    (#x00a849 "PHAGS-PA LETTER THA"                    nil     )
    (#x00a84a "PHAGS-PA LETTER DA"                     nil     )
    (#x00a84b "PHAGS-PA LETTER NA"                     nil     )
    (#x00a84c "PHAGS-PA LETTER PA"                     nil     )
    (#x00a84d "PHAGS-PA LETTER PHA"                    nil     )
    (#x00a84e "PHAGS-PA LETTER BA"                     nil     )
    (#x00a84f "PHAGS-PA LETTER MA"                     nil     )
    (#x00a850 "PHAGS-PA LETTER TSA"                    nil     )
    (#x00a851 "PHAGS-PA LETTER TSHA"                   nil     )
    (#x00a852 "PHAGS-PA LETTER DZA"                    nil     )
    (#x00a853 "PHAGS-PA LETTER WA"                     nil     )
    (#x00a854 "PHAGS-PA LETTER ZHA"                    nil     )
    (#x00a855 "PHAGS-PA LETTER ZA"                     nil     )
    (#x00a856 "PHAGS-PA LETTER SMALL A"                nil     )
    (#x00a857 "PHAGS-PA LETTER YA"                     nil     )
    (#x00a858 "PHAGS-PA LETTER RA"                     nil     )
    (#x00a859 "PHAGS-PA LETTER LA"                     nil     )
    (#x00a85a "PHAGS-PA LETTER SHA"                    nil     )
    (#x00a85b "PHAGS-PA LETTER SA"                     nil     )
    (#x00a85c "PHAGS-PA LETTER HA"                     nil     )
    (#x00a85d "PHAGS-PA LETTER A"                      nil     )
    (#x00a85e "PHAGS-PA LETTER I"                      nil     )
    (#x00a85f "PHAGS-PA LETTER U"                      nil     )
    (#x00a860 "PHAGS-PA LETTER E"                      nil     )
    (#x00a861 "PHAGS-PA LETTER O"                      nil     )
    (#x00a862 "PHAGS-PA LETTER QA"                     nil     )
    (#x00a863 "PHAGS-PA LETTER XA"                     nil     )
    (#x00a864 "PHAGS-PA LETTER FA"                     nil     )
    (#x00a865 "PHAGS-PA LETTER GGA"                    nil     )
    (#x00a866 "PHAGS-PA LETTER EE"                     nil     )
    (#x00a867 "PHAGS-PA SUBJOINED LETTER WA"           nil     )
    (#x00a868 "PHAGS-PA SUBJOINED LETTER YA"           nil     )
    (#x00a869 "PHAGS-PA LETTER TTA"                    nil     )
    (#x00a86a "PHAGS-PA LETTER TTHA"                   nil     )
    (#x00a86b "PHAGS-PA LETTER DDA"                    nil     )
    (#x00a86c "PHAGS-PA LETTER NNA"                    nil     )
    (#x00a86d "PHAGS-PA LETTER ALTERNATE YA"           nil     )
    (#x00a86e "PHAGS-PA LETTER VOICELESS SHA"          nil     )
    (#x00a86f "PHAGS-PA LETTER VOICED HA"              nil     )
    (#x00a870 "PHAGS-PA LETTER ASPIRATED FA"           nil     )
    (#x00a871 "PHAGS-PA SUBJOINED LETTER RA"           nil     )
    (#x00a872 "PHAGS-PA SUPERFIXED LETTER RA"          nil     )
    (#x00a873 "PHAGS-PA LETTER CANDRABINDU"            nil     )
    (#x00a874 "PHAGS-PA SINGLE HEAD MARK"              nil     )
    (#x00a875 "PHAGS-PA DOUBLE HEAD MARK"              nil     )
    (#x00a876 "PHAGS-PA MARK SHAD"                     nil     )
    (#x00a877 "PHAGS-PA MARK DOUBLE SHAD"              nil     )
    (#x00a880 "SAURASHTRA SIGN ANUSVARA"               nil     )
    (#x00a881 "SAURASHTRA SIGN VISARGA"                nil     )
    (#x00a882 "SAURASHTRA LETTER A"                    nil     )
    (#x00a883 "SAURASHTRA LETTER AA"                   nil     )
    (#x00a884 "SAURASHTRA LETTER I"                    nil     )
    (#x00a885 "SAURASHTRA LETTER II"                   nil     )
    (#x00a886 "SAURASHTRA LETTER U"                    nil     )
    (#x00a887 "SAURASHTRA LETTER UU"                   nil     )
    (#x00a888 "SAURASHTRA LETTER VOCALIC R"            nil     )
    (#x00a889 "SAURASHTRA LETTER VOCALIC RR"           nil     )
    (#x00a88a "SAURASHTRA LETTER VOCALIC L"            nil     )
    (#x00a88b "SAURASHTRA LETTER VOCALIC LL"           nil     )
    (#x00a88c "SAURASHTRA LETTER E"                    nil     )
    (#x00a88d "SAURASHTRA LETTER EE"                   nil     )
    (#x00a88e "SAURASHTRA LETTER AI"                   nil     )
    (#x00a88f "SAURASHTRA LETTER O"                    nil     )
    (#x00a890 "SAURASHTRA LETTER OO"                   nil     )
    (#x00a891 "SAURASHTRA LETTER AU"                   nil     )
    (#x00a892 "SAURASHTRA LETTER KA"                   nil     )
    (#x00a893 "SAURASHTRA LETTER KHA"                  nil     )
    (#x00a894 "SAURASHTRA LETTER GA"                   nil     )
    (#x00a895 "SAURASHTRA LETTER GHA"                  nil     )
    (#x00a896 "SAURASHTRA LETTER NGA"                  nil     )
    (#x00a897 "SAURASHTRA LETTER CA"                   nil     )
    (#x00a898 "SAURASHTRA LETTER CHA"                  nil     )
    (#x00a899 "SAURASHTRA LETTER JA"                   nil     )
    (#x00a89a "SAURASHTRA LETTER JHA"                  nil     )
    (#x00a89b "SAURASHTRA LETTER NYA"                  nil     )
    (#x00a89c "SAURASHTRA LETTER TTA"                  nil     )
    (#x00a89d "SAURASHTRA LETTER TTHA"                 nil     )
    (#x00a89e "SAURASHTRA LETTER DDA"                  nil     )
    (#x00a89f "SAURASHTRA LETTER DDHA"                 nil     )
    (#x00a8a0 "SAURASHTRA LETTER NNA"                  nil     )
    (#x00a8a1 "SAURASHTRA LETTER TA"                   nil     )
    (#x00a8a2 "SAURASHTRA LETTER THA"                  nil     )
    (#x00a8a3 "SAURASHTRA LETTER DA"                   nil     )
    (#x00a8a4 "SAURASHTRA LETTER DHA"                  nil     )
    (#x00a8a5 "SAURASHTRA LETTER NA"                   nil     )
    (#x00a8a6 "SAURASHTRA LETTER PA"                   nil     )
    (#x00a8a7 "SAURASHTRA LETTER PHA"                  nil     )
    (#x00a8a8 "SAURASHTRA LETTER BA"                   nil     )
    (#x00a8a9 "SAURASHTRA LETTER BHA"                  nil     )
    (#x00a8aa "SAURASHTRA LETTER MA"                   nil     )
    (#x00a8ab "SAURASHTRA LETTER YA"                   nil     )
    (#x00a8ac "SAURASHTRA LETTER RA"                   nil     )
    (#x00a8ad "SAURASHTRA LETTER LA"                   nil     )
    (#x00a8ae "SAURASHTRA LETTER VA"                   nil     )
    (#x00a8af "SAURASHTRA LETTER SHA"                  nil     )
    (#x00a8b0 "SAURASHTRA LETTER SSA"                  nil     )
    (#x00a8b1 "SAURASHTRA LETTER SA"                   nil     )
    (#x00a8b2 "SAURASHTRA LETTER HA"                   nil     )
    (#x00a8b3 "SAURASHTRA LETTER LLA"                  nil     )
    (#x00a8b4 "SAURASHTRA CONSONANT SIGN HAARU"        nil     )
    (#x00a8b5 "SAURASHTRA VOWEL SIGN AA"               nil     )
    (#x00a8b6 "SAURASHTRA VOWEL SIGN I"                nil     )
    (#x00a8b7 "SAURASHTRA VOWEL SIGN II"               nil     )
    (#x00a8b8 "SAURASHTRA VOWEL SIGN U"                nil     )
    (#x00a8b9 "SAURASHTRA VOWEL SIGN UU"               nil     )
    (#x00a8ba "SAURASHTRA VOWEL SIGN VOCALIC R"        nil     )
    (#x00a8bb "SAURASHTRA VOWEL SIGN VOCALIC RR"       nil     )
    (#x00a8bc "SAURASHTRA VOWEL SIGN VOCALIC L"        nil     )
    (#x00a8bd "SAURASHTRA VOWEL SIGN VOCALIC LL"       nil     )
    (#x00a8be "SAURASHTRA VOWEL SIGN E"                nil     )
    (#x00a8bf "SAURASHTRA VOWEL SIGN EE"               nil     )
    (#x00a8c0 "SAURASHTRA VOWEL SIGN AI"               nil     )
    (#x00a8c1 "SAURASHTRA VOWEL SIGN O"                nil     )
    (#x00a8c2 "SAURASHTRA VOWEL SIGN OO"               nil     )
    (#x00a8c3 "SAURASHTRA VOWEL SIGN AU"               nil     )
    (#x00a8c4 "SAURASHTRA SIGN VIRAMA"                 nil     )
    (#x00a8c5 "SAURASHTRA SIGN CANDRABINDU"            nil     )
    (#x00a8ce "SAURASHTRA DANDA"                       nil     )
    (#x00a8cf "SAURASHTRA DOUBLE DANDA"                nil     )
    (#x00a8d0 "SAURASHTRA DIGIT ZERO"                  nil     )
    (#x00a8d1 "SAURASHTRA DIGIT ONE"                   nil     )
    (#x00a8d2 "SAURASHTRA DIGIT TWO"                   nil     )
    (#x00a8d3 "SAURASHTRA DIGIT THREE"                 nil     )
    (#x00a8d4 "SAURASHTRA DIGIT FOUR"                  nil     )
    (#x00a8d5 "SAURASHTRA DIGIT FIVE"                  nil     )
    (#x00a8d6 "SAURASHTRA DIGIT SIX"                   nil     )
    (#x00a8d7 "SAURASHTRA DIGIT SEVEN"                 nil     )
    (#x00a8d8 "SAURASHTRA DIGIT EIGHT"                 nil     )
    (#x00a8d9 "SAURASHTRA DIGIT NINE"                  nil     )
    (#x00a8e0 "COMBINING DEVANAGARI DIGIT ZERO"        nil     )
    (#x00a8e1 "COMBINING DEVANAGARI DIGIT ONE"         nil     )
    (#x00a8e2 "COMBINING DEVANAGARI DIGIT TWO"         nil     )
    (#x00a8e3 "COMBINING DEVANAGARI DIGIT THREE"       nil     )
    (#x00a8e4 "COMBINING DEVANAGARI DIGIT FOUR"        nil     )
    (#x00a8e5 "COMBINING DEVANAGARI DIGIT FIVE"        nil     )
    (#x00a8e6 "COMBINING DEVANAGARI DIGIT SIX"         nil     )
    (#x00a8e7 "COMBINING DEVANAGARI DIGIT SEVEN"       nil     )
    (#x00a8e8 "COMBINING DEVANAGARI DIGIT EIGHT"       nil     )
    (#x00a8e9 "COMBINING DEVANAGARI DIGIT NINE"        nil     )
    (#x00a8ea "COMBINING DEVANAGARI LETTER A"          nil     )
    (#x00a8eb "COMBINING DEVANAGARI LETTER U"          nil     )
    (#x00a8ec "COMBINING DEVANAGARI LETTER KA"         nil     )
    (#x00a8ed "COMBINING DEVANAGARI LETTER NA"         nil     )
    (#x00a8ee "COMBINING DEVANAGARI LETTER PA"         nil     )
    (#x00a8ef "COMBINING DEVANAGARI LETTER RA"         nil     )
    (#x00a8f0 "COMBINING DEVANAGARI LETTER VI"         nil     )
    (#x00a8f1 "COMBINING DEVANAGARI SIGN AVAGRAHA"     nil     )
    (#x00a8f2 "DEVANAGARI SIGN SPACING CANDRABINDU"    nil     )
    (#x00a8f3 "DEVANAGARI SIGN CANDRABINDU VIRAMA"     nil     )
    (#x00a8f4 "DEVANAGARI SIGN DOUBLE CANDRABINDU VIRAMA" nil     )
    (#x00a8f5 "DEVANAGARI SIGN CANDRABINDU TWO"        nil     )
    (#x00a8f6 "DEVANAGARI SIGN CANDRABINDU THREE"      nil     )
    (#x00a8f7 "DEVANAGARI SIGN CANDRABINDU AVAGRAHA"   nil     )
    (#x00a8f8 "DEVANAGARI SIGN PUSHPIKA"               nil     )
    (#x00a8f9 "DEVANAGARI GAP FILLER"                  nil     )
    (#x00a8fa "DEVANAGARI CARET"                       nil     )
    (#x00a8fb "DEVANAGARI HEADSTROKE"                  nil     )
    (#x00a8fc "DEVANAGARI SIGN SIDDHAM"                nil     )
    (#x00a8fd "DEVANAGARI JAIN OM"                     nil     )
    (#x00a8fe "DEVANAGARI LETTER AY"                   nil     )
    (#x00a8ff "DEVANAGARI VOWEL SIGN AY"               nil     )
    (#x00a900 "KAYAH LI DIGIT ZERO"                    nil     )
    (#x00a901 "KAYAH LI DIGIT ONE"                     nil     )
    (#x00a902 "KAYAH LI DIGIT TWO"                     nil     )
    (#x00a903 "KAYAH LI DIGIT THREE"                   nil     )
    (#x00a904 "KAYAH LI DIGIT FOUR"                    nil     )
    (#x00a905 "KAYAH LI DIGIT FIVE"                    nil     )
    (#x00a906 "KAYAH LI DIGIT SIX"                     nil     )
    (#x00a907 "KAYAH LI DIGIT SEVEN"                   nil     )
    (#x00a908 "KAYAH LI DIGIT EIGHT"                   nil     )
    (#x00a909 "KAYAH LI DIGIT NINE"                    nil     )
    (#x00a90a "KAYAH LI LETTER KA"                     nil     )
    (#x00a90b "KAYAH LI LETTER KHA"                    nil     )
    (#x00a90c "KAYAH LI LETTER GA"                     nil     )
    (#x00a90d "KAYAH LI LETTER NGA"                    nil     )
    (#x00a90e "KAYAH LI LETTER SA"                     nil     )
    (#x00a90f "KAYAH LI LETTER SHA"                    nil     )
    (#x00a910 "KAYAH LI LETTER ZA"                     nil     )
    (#x00a911 "KAYAH LI LETTER NYA"                    nil     )
    (#x00a912 "KAYAH LI LETTER TA"                     nil     )
    (#x00a913 "KAYAH LI LETTER HTA"                    nil     )
    (#x00a914 "KAYAH LI LETTER NA"                     nil     )
    (#x00a915 "KAYAH LI LETTER PA"                     nil     )
    (#x00a916 "KAYAH LI LETTER PHA"                    nil     )
    (#x00a917 "KAYAH LI LETTER MA"                     nil     )
    (#x00a918 "KAYAH LI LETTER DA"                     nil     )
    (#x00a919 "KAYAH LI LETTER BA"                     nil     )
    (#x00a91a "KAYAH LI LETTER RA"                     nil     )
    (#x00a91b "KAYAH LI LETTER YA"                     nil     )
    (#x00a91c "KAYAH LI LETTER LA"                     nil     )
    (#x00a91d "KAYAH LI LETTER WA"                     nil     )
    (#x00a91e "KAYAH LI LETTER THA"                    nil     )
    (#x00a91f "KAYAH LI LETTER HA"                     nil     )
    (#x00a920 "KAYAH LI LETTER VA"                     nil     )
    (#x00a921 "KAYAH LI LETTER CA"                     nil     )
    (#x00a922 "KAYAH LI LETTER A"                      nil     )
    (#x00a923 "KAYAH LI LETTER OE"                     nil     )
    (#x00a924 "KAYAH LI LETTER I"                      nil     )
    (#x00a925 "KAYAH LI LETTER OO"                     nil     )
    (#x00a926 "KAYAH LI VOWEL UE"                      nil     )
    (#x00a927 "KAYAH LI VOWEL E"                       nil     )
    (#x00a928 "KAYAH LI VOWEL U"                       nil     )
    (#x00a929 "KAYAH LI VOWEL EE"                      nil     )
    (#x00a92a "KAYAH LI VOWEL O"                       nil     )
    (#x00a92b "KAYAH LI TONE PLOPHU"                   nil     )
    (#x00a92c "KAYAH LI TONE CALYA"                    nil     )
    (#x00a92d "KAYAH LI TONE CALYA PLOPHU"             nil     )
    (#x00a92e "KAYAH LI SIGN CWI"                      nil     )
    (#x00a92f "KAYAH LI SIGN SHYA"                     nil     )
    (#x00a930 "REJANG LETTER KA"                       nil     )
    (#x00a931 "REJANG LETTER GA"                       nil     )
    (#x00a932 "REJANG LETTER NGA"                      nil     )
    (#x00a933 "REJANG LETTER TA"                       nil     )
    (#x00a934 "REJANG LETTER DA"                       nil     )
    (#x00a935 "REJANG LETTER NA"                       nil     )
    (#x00a936 "REJANG LETTER PA"                       nil     )
    (#x00a937 "REJANG LETTER BA"                       nil     )
    (#x00a938 "REJANG LETTER MA"                       nil     )
    (#x00a939 "REJANG LETTER CA"                       nil     )
    (#x00a93a "REJANG LETTER JA"                       nil     )
    (#x00a93b "REJANG LETTER NYA"                      nil     )
    (#x00a93c "REJANG LETTER SA"                       nil     )
    (#x00a93d "REJANG LETTER RA"                       nil     )
    (#x00a93e "REJANG LETTER LA"                       nil     )
    (#x00a93f "REJANG LETTER YA"                       nil     )
    (#x00a940 "REJANG LETTER WA"                       nil     )
    (#x00a941 "REJANG LETTER HA"                       nil     )
    (#x00a942 "REJANG LETTER MBA"                      nil     )
    (#x00a943 "REJANG LETTER NGGA"                     nil     )
    (#x00a944 "REJANG LETTER NDA"                      nil     )
    (#x00a945 "REJANG LETTER NYJA"                     nil     )
    (#x00a946 "REJANG LETTER A"                        nil     )
    (#x00a947 "REJANG VOWEL SIGN I"                    nil     )
    (#x00a948 "REJANG VOWEL SIGN U"                    nil     )
    (#x00a949 "REJANG VOWEL SIGN E"                    nil     )
    (#x00a94a "REJANG VOWEL SIGN AI"                   nil     )
    (#x00a94b "REJANG VOWEL SIGN O"                    nil     )
    (#x00a94c "REJANG VOWEL SIGN AU"                   nil     )
    (#x00a94d "REJANG VOWEL SIGN EU"                   nil     )
    (#x00a94e "REJANG VOWEL SIGN EA"                   nil     )
    (#x00a94f "REJANG CONSONANT SIGN NG"               nil     )
    (#x00a950 "REJANG CONSONANT SIGN N"                nil     )
    (#x00a951 "REJANG CONSONANT SIGN R"                nil     )
    (#x00a952 "REJANG CONSONANT SIGN H"                nil     )
    (#x00a953 "REJANG VIRAMA"                          nil     )
    (#x00a95f "REJANG SECTION MARK"                    nil     )
    (#x00a960 "HANGUL CHOSEONG TIKEUT-MIEUM"           nil     )
    (#x00a961 "HANGUL CHOSEONG TIKEUT-PIEUP"           nil     )
    (#x00a962 "HANGUL CHOSEONG TIKEUT-SIOS"            nil     )
    (#x00a963 "HANGUL CHOSEONG TIKEUT-CIEUC"           nil     )
    (#x00a964 "HANGUL CHOSEONG RIEUL-KIYEOK"           nil     )
    (#x00a965 "HANGUL CHOSEONG RIEUL-SSANGKIYEOK"      nil     )
    (#x00a966 "HANGUL CHOSEONG RIEUL-TIKEUT"           nil     )
    (#x00a967 "HANGUL CHOSEONG RIEUL-SSANGTIKEUT"      nil     )
    (#x00a968 "HANGUL CHOSEONG RIEUL-MIEUM"            nil     )
    (#x00a969 "HANGUL CHOSEONG RIEUL-PIEUP"            nil     )
    (#x00a96a "HANGUL CHOSEONG RIEUL-SSANGPIEUP"       nil     )
    (#x00a96b "HANGUL CHOSEONG RIEUL-KAPYEOUNPIEUP"    nil     )
    (#x00a96c "HANGUL CHOSEONG RIEUL-SIOS"             nil     )
    (#x00a96d "HANGUL CHOSEONG RIEUL-CIEUC"            nil     )
    (#x00a96e "HANGUL CHOSEONG RIEUL-KHIEUKH"          nil     )
    (#x00a96f "HANGUL CHOSEONG MIEUM-KIYEOK"           nil     )
    (#x00a970 "HANGUL CHOSEONG MIEUM-TIKEUT"           nil     )
    (#x00a971 "HANGUL CHOSEONG MIEUM-SIOS"             nil     )
    (#x00a972 "HANGUL CHOSEONG PIEUP-SIOS-THIEUTH"     nil     )
    (#x00a973 "HANGUL CHOSEONG PIEUP-KHIEUKH"          nil     )
    (#x00a974 "HANGUL CHOSEONG PIEUP-HIEUH"            nil     )
    (#x00a975 "HANGUL CHOSEONG SSANGSIOS-PIEUP"        nil     )
    (#x00a976 "HANGUL CHOSEONG IEUNG-RIEUL"            nil     )
    (#x00a977 "HANGUL CHOSEONG IEUNG-HIEUH"            nil     )
    (#x00a978 "HANGUL CHOSEONG SSANGCIEUC-HIEUH"       nil     )
    (#x00a979 "HANGUL CHOSEONG SSANGTHIEUTH"           nil     )
    (#x00a97a "HANGUL CHOSEONG PHIEUPH-HIEUH"          nil     )
    (#x00a97b "HANGUL CHOSEONG HIEUH-SIOS"             nil     )
    (#x00a97c "HANGUL CHOSEONG SSANGYEORINHIEUH"       nil     )
    (#x00a980 "JAVANESE SIGN PANYANGGA"                nil     )
    (#x00a981 "JAVANESE SIGN CECAK"                    nil     )
    (#x00a982 "JAVANESE SIGN LAYAR"                    nil     )
    (#x00a983 "JAVANESE SIGN WIGNYAN"                  nil     )
    (#x00a984 "JAVANESE LETTER A"                      nil     )
    (#x00a985 "JAVANESE LETTER I KAWI"                 nil     )
    (#x00a986 "JAVANESE LETTER I"                      nil     )
    (#x00a987 "JAVANESE LETTER II"                     nil     )
    (#x00a988 "JAVANESE LETTER U"                      nil     )
    (#x00a989 "JAVANESE LETTER PA CEREK"               nil     )
    (#x00a98a "JAVANESE LETTER NGA LELET"              nil     )
    (#x00a98b "JAVANESE LETTER NGA LELET RASWADI"      nil     )
    (#x00a98c "JAVANESE LETTER E"                      nil     )
    (#x00a98d "JAVANESE LETTER AI"                     nil     )
    (#x00a98e "JAVANESE LETTER O"                      nil     )
    (#x00a98f "JAVANESE LETTER KA"                     nil     )
    (#x00a990 "JAVANESE LETTER KA SASAK"               nil     )
    (#x00a991 "JAVANESE LETTER KA MURDA"               nil     )
    (#x00a992 "JAVANESE LETTER GA"                     nil     )
    (#x00a993 "JAVANESE LETTER GA MURDA"               nil     )
    (#x00a994 "JAVANESE LETTER NGA"                    nil     )
    (#x00a995 "JAVANESE LETTER CA"                     nil     )
    (#x00a996 "JAVANESE LETTER CA MURDA"               nil     )
    (#x00a997 "JAVANESE LETTER JA"                     nil     )
    (#x00a998 "JAVANESE LETTER NYA MURDA"              nil     )
    (#x00a999 "JAVANESE LETTER JA MAHAPRANA"           nil     )
    (#x00a99a "JAVANESE LETTER NYA"                    nil     )
    (#x00a99b "JAVANESE LETTER TTA"                    nil     )
    (#x00a99c "JAVANESE LETTER TTA MAHAPRANA"          nil     )
    (#x00a99d "JAVANESE LETTER DDA"                    nil     )
    (#x00a99e "JAVANESE LETTER DDA MAHAPRANA"          nil     )
    (#x00a99f "JAVANESE LETTER NA MURDA"               nil     )
    (#x00a9a0 "JAVANESE LETTER TA"                     nil     )
    (#x00a9a1 "JAVANESE LETTER TA MURDA"               nil     )
    (#x00a9a2 "JAVANESE LETTER DA"                     nil     )
    (#x00a9a3 "JAVANESE LETTER DA MAHAPRANA"           nil     )
    (#x00a9a4 "JAVANESE LETTER NA"                     nil     )
    (#x00a9a5 "JAVANESE LETTER PA"                     nil     )
    (#x00a9a6 "JAVANESE LETTER PA MURDA"               nil     )
    (#x00a9a7 "JAVANESE LETTER BA"                     nil     )
    (#x00a9a8 "JAVANESE LETTER BA MURDA"               nil     )
    (#x00a9a9 "JAVANESE LETTER MA"                     nil     )
    (#x00a9aa "JAVANESE LETTER YA"                     nil     )
    (#x00a9ab "JAVANESE LETTER RA"                     nil     )
    (#x00a9ac "JAVANESE LETTER RA AGUNG"               nil     )
    (#x00a9ad "JAVANESE LETTER LA"                     nil     )
    (#x00a9ae "JAVANESE LETTER WA"                     nil     )
    (#x00a9af "JAVANESE LETTER SA MURDA"               nil     )
    (#x00a9b0 "JAVANESE LETTER SA MAHAPRANA"           nil     )
    (#x00a9b1 "JAVANESE LETTER SA"                     nil     )
    (#x00a9b2 "JAVANESE LETTER HA"                     nil     )
    (#x00a9b3 "JAVANESE SIGN CECAK TELU"               nil     )
    (#x00a9b4 "JAVANESE VOWEL SIGN TARUNG"             nil     )
    (#x00a9b5 "JAVANESE VOWEL SIGN TOLONG"             nil     )
    (#x00a9b6 "JAVANESE VOWEL SIGN WULU"               nil     )
    (#x00a9b7 "JAVANESE VOWEL SIGN WULU MELIK"         nil     )
    (#x00a9b8 "JAVANESE VOWEL SIGN SUKU"               nil     )
    (#x00a9b9 "JAVANESE VOWEL SIGN SUKU MENDUT"        nil     )
    (#x00a9ba "JAVANESE VOWEL SIGN TALING"             nil     )
    (#x00a9bb "JAVANESE VOWEL SIGN DIRGA MURE"         nil     )
    (#x00a9bc "JAVANESE VOWEL SIGN PEPET"              nil     )
    (#x00a9bd "JAVANESE CONSONANT SIGN KERET"          nil     )
    (#x00a9be "JAVANESE CONSONANT SIGN PENGKAL"        nil     )
    (#x00a9bf "JAVANESE CONSONANT SIGN CAKRA"          nil     )
    (#x00a9c0 "JAVANESE PANGKON"                       nil     )
    (#x00a9c1 "JAVANESE LEFT RERENGGAN"                nil     )
    (#x00a9c2 "JAVANESE RIGHT RERENGGAN"               nil     )
    (#x00a9c3 "JAVANESE PADA ANDAP"                    nil     )
    (#x00a9c4 "JAVANESE PADA MADYA"                    nil     )
    (#x00a9c5 "JAVANESE PADA LUHUR"                    nil     )
    (#x00a9c6 "JAVANESE PADA WINDU"                    nil     )
    (#x00a9c7 "JAVANESE PADA PANGKAT"                  nil     )
    (#x00a9c8 "JAVANESE PADA LINGSA"                   nil     )
    (#x00a9c9 "JAVANESE PADA LUNGSI"                   nil     )
    (#x00a9ca "JAVANESE PADA ADEG"                     nil     )
    (#x00a9cb "JAVANESE PADA ADEG ADEG"                nil     )
    (#x00a9cc "JAVANESE PADA PISELEH"                  nil     )
    (#x00a9cd "JAVANESE TURNED PADA PISELEH"           nil     )
    (#x00a9cf "JAVANESE PANGRANGKEP"                   nil     )
    (#x00a9d0 "JAVANESE DIGIT ZERO"                    nil     )
    (#x00a9d1 "JAVANESE DIGIT ONE"                     nil     )
    (#x00a9d2 "JAVANESE DIGIT TWO"                     nil     )
    (#x00a9d3 "JAVANESE DIGIT THREE"                   nil     )
    (#x00a9d4 "JAVANESE DIGIT FOUR"                    nil     )
    (#x00a9d5 "JAVANESE DIGIT FIVE"                    nil     )
    (#x00a9d6 "JAVANESE DIGIT SIX"                     nil     )
    (#x00a9d7 "JAVANESE DIGIT SEVEN"                   nil     )
    (#x00a9d8 "JAVANESE DIGIT EIGHT"                   nil     )
    (#x00a9d9 "JAVANESE DIGIT NINE"                    nil     )
    (#x00a9de "JAVANESE PADA TIRTA TUMETES"            nil     )
    (#x00a9df "JAVANESE PADA ISEN-ISEN"                nil     )
    (#x00a9e0 "MYANMAR LETTER SHAN GHA"                nil     )
    (#x00a9e1 "MYANMAR LETTER SHAN CHA"                nil     )
    (#x00a9e2 "MYANMAR LETTER SHAN JHA"                nil     )
    (#x00a9e3 "MYANMAR LETTER SHAN NNA"                nil     )
    (#x00a9e4 "MYANMAR LETTER SHAN BHA"                nil     )
    (#x00a9e5 "MYANMAR SIGN SHAN SAW"                  nil     )
    (#x00a9e6 "MYANMAR MODIFIER LETTER SHAN REDUPLICATION" nil     )
    (#x00a9e7 "MYANMAR LETTER TAI LAING NYA"           nil     )
    (#x00a9e8 "MYANMAR LETTER TAI LAING FA"            nil     )
    (#x00a9e9 "MYANMAR LETTER TAI LAING GA"            nil     )
    (#x00a9ea "MYANMAR LETTER TAI LAING GHA"           nil     )
    (#x00a9eb "MYANMAR LETTER TAI LAING JA"            nil     )
    (#x00a9ec "MYANMAR LETTER TAI LAING JHA"           nil     )
    (#x00a9ed "MYANMAR LETTER TAI LAING DDA"           nil     )
    (#x00a9ee "MYANMAR LETTER TAI LAING DDHA"          nil     )
    (#x00a9ef "MYANMAR LETTER TAI LAING NNA"           nil     )
    (#x00a9f0 "MYANMAR TAI LAING DIGIT ZERO"           nil     )
    (#x00a9f1 "MYANMAR TAI LAING DIGIT ONE"            nil     )
    (#x00a9f2 "MYANMAR TAI LAING DIGIT TWO"            nil     )
    (#x00a9f3 "MYANMAR TAI LAING DIGIT THREE"          nil     )
    (#x00a9f4 "MYANMAR TAI LAING DIGIT FOUR"           nil     )
    (#x00a9f5 "MYANMAR TAI LAING DIGIT FIVE"           nil     )
    (#x00a9f6 "MYANMAR TAI LAING DIGIT SIX"            nil     )
    (#x00a9f7 "MYANMAR TAI LAING DIGIT SEVEN"          nil     )
    (#x00a9f8 "MYANMAR TAI LAING DIGIT EIGHT"          nil     )
    (#x00a9f9 "MYANMAR TAI LAING DIGIT NINE"           nil     )
    (#x00a9fa "MYANMAR LETTER TAI LAING LLA"           nil     )
    (#x00a9fb "MYANMAR LETTER TAI LAING DA"            nil     )
    (#x00a9fc "MYANMAR LETTER TAI LAING DHA"           nil     )
    (#x00a9fd "MYANMAR LETTER TAI LAING BA"            nil     )
    (#x00a9fe "MYANMAR LETTER TAI LAING BHA"           nil     )
    (#x00aa00 "CHAM LETTER A"                          nil     )
    (#x00aa01 "CHAM LETTER I"                          nil     )
    (#x00aa02 "CHAM LETTER U"                          nil     )
    (#x00aa03 "CHAM LETTER E"                          nil     )
    (#x00aa04 "CHAM LETTER AI"                         nil     )
    (#x00aa05 "CHAM LETTER O"                          nil     )
    (#x00aa06 "CHAM LETTER KA"                         nil     )
    (#x00aa07 "CHAM LETTER KHA"                        nil     )
    (#x00aa08 "CHAM LETTER GA"                         nil     )
    (#x00aa09 "CHAM LETTER GHA"                        nil     )
    (#x00aa0a "CHAM LETTER NGUE"                       nil     )
    (#x00aa0b "CHAM LETTER NGA"                        nil     )
    (#x00aa0c "CHAM LETTER CHA"                        nil     )
    (#x00aa0d "CHAM LETTER CHHA"                       nil     )
    (#x00aa0e "CHAM LETTER JA"                         nil     )
    (#x00aa0f "CHAM LETTER JHA"                        nil     )
    (#x00aa10 "CHAM LETTER NHUE"                       nil     )
    (#x00aa11 "CHAM LETTER NHA"                        nil     )
    (#x00aa12 "CHAM LETTER NHJA"                       nil     )
    (#x00aa13 "CHAM LETTER TA"                         nil     )
    (#x00aa14 "CHAM LETTER THA"                        nil     )
    (#x00aa15 "CHAM LETTER DA"                         nil     )
    (#x00aa16 "CHAM LETTER DHA"                        nil     )
    (#x00aa17 "CHAM LETTER NUE"                        nil     )
    (#x00aa18 "CHAM LETTER NA"                         nil     )
    (#x00aa19 "CHAM LETTER DDA"                        nil     )
    (#x00aa1a "CHAM LETTER PA"                         nil     )
    (#x00aa1b "CHAM LETTER PPA"                        nil     )
    (#x00aa1c "CHAM LETTER PHA"                        nil     )
    (#x00aa1d "CHAM LETTER BA"                         nil     )
    (#x00aa1e "CHAM LETTER BHA"                        nil     )
    (#x00aa1f "CHAM LETTER MUE"                        nil     )
    (#x00aa20 "CHAM LETTER MA"                         nil     )
    (#x00aa21 "CHAM LETTER BBA"                        nil     )
    (#x00aa22 "CHAM LETTER YA"                         nil     )
    (#x00aa23 "CHAM LETTER RA"                         nil     )
    (#x00aa24 "CHAM LETTER LA"                         nil     )
    (#x00aa25 "CHAM LETTER VA"                         nil     )
    (#x00aa26 "CHAM LETTER SSA"                        nil     )
    (#x00aa27 "CHAM LETTER SA"                         nil     )
    (#x00aa28 "CHAM LETTER HA"                         nil     )
    (#x00aa29 "CHAM VOWEL SIGN AA"                     nil     )
    (#x00aa2a "CHAM VOWEL SIGN I"                      nil     )
    (#x00aa2b "CHAM VOWEL SIGN II"                     nil     )
    (#x00aa2c "CHAM VOWEL SIGN EI"                     nil     )
    (#x00aa2d "CHAM VOWEL SIGN U"                      nil     )
    (#x00aa2e "CHAM VOWEL SIGN OE"                     nil     )
    (#x00aa2f "CHAM VOWEL SIGN O"                      nil     )
    (#x00aa30 "CHAM VOWEL SIGN AI"                     nil     )
    (#x00aa31 "CHAM VOWEL SIGN AU"                     nil     )
    (#x00aa32 "CHAM VOWEL SIGN UE"                     nil     )
    (#x00aa33 "CHAM CONSONANT SIGN YA"                 nil     )
    (#x00aa34 "CHAM CONSONANT SIGN RA"                 nil     )
    (#x00aa35 "CHAM CONSONANT SIGN LA"                 nil     )
    (#x00aa36 "CHAM CONSONANT SIGN WA"                 nil     )
    (#x00aa40 "CHAM LETTER FINAL K"                    nil     )
    (#x00aa41 "CHAM LETTER FINAL G"                    nil     )
    (#x00aa42 "CHAM LETTER FINAL NG"                   nil     )
    (#x00aa43 "CHAM CONSONANT SIGN FINAL NG"           nil     )
    (#x00aa44 "CHAM LETTER FINAL CH"                   nil     )
    (#x00aa45 "CHAM LETTER FINAL T"                    nil     )
    (#x00aa46 "CHAM LETTER FINAL N"                    nil     )
    (#x00aa47 "CHAM LETTER FINAL P"                    nil     )
    (#x00aa48 "CHAM LETTER FINAL Y"                    nil     )
    (#x00aa49 "CHAM LETTER FINAL R"                    nil     )
    (#x00aa4a "CHAM LETTER FINAL L"                    nil     )
    (#x00aa4b "CHAM LETTER FINAL SS"                   nil     )
    (#x00aa4c "CHAM CONSONANT SIGN FINAL M"            nil     )
    (#x00aa4d "CHAM CONSONANT SIGN FINAL H"            nil     )
    (#x00aa50 "CHAM DIGIT ZERO"                        nil     )
    (#x00aa51 "CHAM DIGIT ONE"                         nil     )
    (#x00aa52 "CHAM DIGIT TWO"                         nil     )
    (#x00aa53 "CHAM DIGIT THREE"                       nil     )
    (#x00aa54 "CHAM DIGIT FOUR"                        nil     )
    (#x00aa55 "CHAM DIGIT FIVE"                        nil     )
    (#x00aa56 "CHAM DIGIT SIX"                         nil     )
    (#x00aa57 "CHAM DIGIT SEVEN"                       nil     )
    (#x00aa58 "CHAM DIGIT EIGHT"                       nil     )
    (#x00aa59 "CHAM DIGIT NINE"                        nil     )
    (#x00aa5c "CHAM PUNCTUATION SPIRAL"                nil     )
    (#x00aa5d "CHAM PUNCTUATION DANDA"                 nil     )
    (#x00aa5e "CHAM PUNCTUATION DOUBLE DANDA"          nil     )
    (#x00aa5f "CHAM PUNCTUATION TRIPLE DANDA"          nil     )
    (#x00aa60 "MYANMAR LETTER KHAMTI GA"               nil     )
    (#x00aa61 "MYANMAR LETTER KHAMTI CA"               nil     )
    (#x00aa62 "MYANMAR LETTER KHAMTI CHA"              nil     )
    (#x00aa63 "MYANMAR LETTER KHAMTI JA"               nil     )
    (#x00aa64 "MYANMAR LETTER KHAMTI JHA"              nil     )
    (#x00aa65 "MYANMAR LETTER KHAMTI NYA"              nil     )
    (#x00aa66 "MYANMAR LETTER KHAMTI TTA"              nil     )
    (#x00aa67 "MYANMAR LETTER KHAMTI TTHA"             nil     )
    (#x00aa68 "MYANMAR LETTER KHAMTI DDA"              nil     )
    (#x00aa69 "MYANMAR LETTER KHAMTI DDHA"             nil     )
    (#x00aa6a "MYANMAR LETTER KHAMTI DHA"              nil     )
    (#x00aa6b "MYANMAR LETTER KHAMTI NA"               nil     )
    (#x00aa6c "MYANMAR LETTER KHAMTI SA"               nil     )
    (#x00aa6d "MYANMAR LETTER KHAMTI HA"               nil     )
    (#x00aa6e "MYANMAR LETTER KHAMTI HHA"              nil     )
    (#x00aa6f "MYANMAR LETTER KHAMTI FA"               nil     )
    (#x00aa70 "MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION" nil     )
    (#x00aa71 "MYANMAR LETTER KHAMTI XA"               nil     )
    (#x00aa72 "MYANMAR LETTER KHAMTI ZA"               nil     )
    (#x00aa73 "MYANMAR LETTER KHAMTI RA"               nil     )
    (#x00aa74 "MYANMAR LOGOGRAM KHAMTI OAY"            nil     )
    (#x00aa75 "MYANMAR LOGOGRAM KHAMTI QN"             nil     )
    (#x00aa76 "MYANMAR LOGOGRAM KHAMTI HM"             nil     )
    (#x00aa77 "MYANMAR SYMBOL AITON EXCLAMATION"       nil     )
    (#x00aa78 "MYANMAR SYMBOL AITON ONE"               nil     )
    (#x00aa79 "MYANMAR SYMBOL AITON TWO"               nil     )
    (#x00aa7a "MYANMAR LETTER AITON RA"                nil     )
    (#x00aa7b "MYANMAR SIGN PAO KAREN TONE"            nil     )
    (#x00aa7c "MYANMAR SIGN TAI LAING TONE-2"          nil     )
    (#x00aa7d "MYANMAR SIGN TAI LAING TONE-5"          nil     )
    (#x00aa7e "MYANMAR LETTER SHWE PALAUNG CHA"        nil     )
    (#x00aa7f "MYANMAR LETTER SHWE PALAUNG SHA"        nil     )
    (#x00aa80 "TAI VIET LETTER LOW KO"                 nil     )
    (#x00aa81 "TAI VIET LETTER HIGH KO"                nil     )
    (#x00aa82 "TAI VIET LETTER LOW KHO"                nil     )
    (#x00aa83 "TAI VIET LETTER HIGH KHO"               nil     )
    (#x00aa84 "TAI VIET LETTER LOW KHHO"               nil     )
    (#x00aa85 "TAI VIET LETTER HIGH KHHO"              nil     )
    (#x00aa86 "TAI VIET LETTER LOW GO"                 nil     )
    (#x00aa87 "TAI VIET LETTER HIGH GO"                nil     )
    (#x00aa88 "TAI VIET LETTER LOW NGO"                nil     )
    (#x00aa89 "TAI VIET LETTER HIGH NGO"               nil     )
    (#x00aa8a "TAI VIET LETTER LOW CO"                 nil     )
    (#x00aa8b "TAI VIET LETTER HIGH CO"                nil     )
    (#x00aa8c "TAI VIET LETTER LOW CHO"                nil     )
    (#x00aa8d "TAI VIET LETTER HIGH CHO"               nil     )
    (#x00aa8e "TAI VIET LETTER LOW SO"                 nil     )
    (#x00aa8f "TAI VIET LETTER HIGH SO"                nil     )
    (#x00aa90 "TAI VIET LETTER LOW NYO"                nil     )
    (#x00aa91 "TAI VIET LETTER HIGH NYO"               nil     )
    (#x00aa92 "TAI VIET LETTER LOW DO"                 nil     )
    (#x00aa93 "TAI VIET LETTER HIGH DO"                nil     )
    (#x00aa94 "TAI VIET LETTER LOW TO"                 nil     )
    (#x00aa95 "TAI VIET LETTER HIGH TO"                nil     )
    (#x00aa96 "TAI VIET LETTER LOW THO"                nil     )
    (#x00aa97 "TAI VIET LETTER HIGH THO"               nil     )
    (#x00aa98 "TAI VIET LETTER LOW NO"                 nil     )
    (#x00aa99 "TAI VIET LETTER HIGH NO"                nil     )
    (#x00aa9a "TAI VIET LETTER LOW BO"                 nil     )
    (#x00aa9b "TAI VIET LETTER HIGH BO"                nil     )
    (#x00aa9c "TAI VIET LETTER LOW PO"                 nil     )
    (#x00aa9d "TAI VIET LETTER HIGH PO"                nil     )
    (#x00aa9e "TAI VIET LETTER LOW PHO"                nil     )
    (#x00aa9f "TAI VIET LETTER HIGH PHO"               nil     )
    (#x00aaa0 "TAI VIET LETTER LOW FO"                 nil     )
    (#x00aaa1 "TAI VIET LETTER HIGH FO"                nil     )
    (#x00aaa2 "TAI VIET LETTER LOW MO"                 nil     )
    (#x00aaa3 "TAI VIET LETTER HIGH MO"                nil     )
    (#x00aaa4 "TAI VIET LETTER LOW YO"                 nil     )
    (#x00aaa5 "TAI VIET LETTER HIGH YO"                nil     )
    (#x00aaa6 "TAI VIET LETTER LOW RO"                 nil     )
    (#x00aaa7 "TAI VIET LETTER HIGH RO"                nil     )
    (#x00aaa8 "TAI VIET LETTER LOW LO"                 nil     )
    (#x00aaa9 "TAI VIET LETTER HIGH LO"                nil     )
    (#x00aaaa "TAI VIET LETTER LOW VO"                 nil     )
    (#x00aaab "TAI VIET LETTER HIGH VO"                nil     )
    (#x00aaac "TAI VIET LETTER LOW HO"                 nil     )
    (#x00aaad "TAI VIET LETTER HIGH HO"                nil     )
    (#x00aaae "TAI VIET LETTER LOW O"                  nil     )
    (#x00aaaf "TAI VIET LETTER HIGH O"                 nil     )
    (#x00aab0 "TAI VIET MAI KANG"                      nil     )
    (#x00aab1 "TAI VIET VOWEL AA"                      nil     )
    (#x00aab2 "TAI VIET VOWEL I"                       nil     )
    (#x00aab3 "TAI VIET VOWEL UE"                      nil     )
    (#x00aab4 "TAI VIET VOWEL U"                       nil     )
    (#x00aab5 "TAI VIET VOWEL E"                       nil     )
    (#x00aab6 "TAI VIET VOWEL O"                       nil     )
    (#x00aab7 "TAI VIET MAI KHIT"                      nil     )
    (#x00aab8 "TAI VIET VOWEL IA"                      nil     )
    (#x00aab9 "TAI VIET VOWEL UEA"                     nil     )
    (#x00aaba "TAI VIET VOWEL UA"                      nil     )
    (#x00aabb "TAI VIET VOWEL AUE"                     nil     )
    (#x00aabc "TAI VIET VOWEL AY"                      nil     )
    (#x00aabd "TAI VIET VOWEL AN"                      nil     )
    (#x00aabe "TAI VIET VOWEL AM"                      nil     )
    (#x00aabf "TAI VIET TONE MAI EK"                   nil     )
    (#x00aac0 "TAI VIET TONE MAI NUENG"                nil     )
    (#x00aac1 "TAI VIET TONE MAI THO"                  nil     )
    (#x00aac2 "TAI VIET TONE MAI SONG"                 nil     )
    (#x00aadb "TAI VIET SYMBOL KON"                    nil     )
    (#x00aadc "TAI VIET SYMBOL NUENG"                  nil     )
    (#x00aadd "TAI VIET SYMBOL SAM"                    nil     )
    (#x00aade "TAI VIET SYMBOL HO HOI"                 nil     )
    (#x00aadf "TAI VIET SYMBOL KOI KOI"                nil     )
    (#x00aae0 "MEETEI MAYEK LETTER E"                  nil     )
    (#x00aae1 "MEETEI MAYEK LETTER O"                  nil     )
    (#x00aae2 "MEETEI MAYEK LETTER CHA"                nil     )
    (#x00aae3 "MEETEI MAYEK LETTER NYA"                nil     )
    (#x00aae4 "MEETEI MAYEK LETTER TTA"                nil     )
    (#x00aae5 "MEETEI MAYEK LETTER TTHA"               nil     )
    (#x00aae6 "MEETEI MAYEK LETTER DDA"                nil     )
    (#x00aae7 "MEETEI MAYEK LETTER DDHA"               nil     )
    (#x00aae8 "MEETEI MAYEK LETTER NNA"                nil     )
    (#x00aae9 "MEETEI MAYEK LETTER SHA"                nil     )
    (#x00aaea "MEETEI MAYEK LETTER SSA"                nil     )
    (#x00aaeb "MEETEI MAYEK VOWEL SIGN II"             nil     )
    (#x00aaec "MEETEI MAYEK VOWEL SIGN UU"             nil     )
    (#x00aaed "MEETEI MAYEK VOWEL SIGN AAI"            nil     )
    (#x00aaee "MEETEI MAYEK VOWEL SIGN AU"             nil     )
    (#x00aaef "MEETEI MAYEK VOWEL SIGN AAU"            nil     )
    (#x00aaf0 "MEETEI MAYEK CHEIKHAN"                  nil     )
    (#x00aaf1 "MEETEI MAYEK AHANG KHUDAM"              nil     )
    (#x00aaf2 "MEETEI MAYEK ANJI"                      nil     )
    (#x00aaf3 "MEETEI MAYEK SYLLABLE REPETITION MARK"  nil     )
    (#x00aaf4 "MEETEI MAYEK WORD REPETITION MARK"      nil     )
    (#x00aaf5 "MEETEI MAYEK VOWEL SIGN VISARGA"        nil     )
    (#x00aaf6 "MEETEI MAYEK VIRAMA"                    nil     )
    (#x00ab01 "ETHIOPIC SYLLABLE TTHU"                 nil     )
    (#x00ab02 "ETHIOPIC SYLLABLE TTHI"                 nil     )
    (#x00ab03 "ETHIOPIC SYLLABLE TTHAA"                nil     )
    (#x00ab04 "ETHIOPIC SYLLABLE TTHEE"                nil     )
    (#x00ab05 "ETHIOPIC SYLLABLE TTHE"                 nil     )
    (#x00ab06 "ETHIOPIC SYLLABLE TTHO"                 nil     )
    (#x00ab09 "ETHIOPIC SYLLABLE DDHU"                 nil     )
    (#x00ab0a "ETHIOPIC SYLLABLE DDHI"                 nil     )
    (#x00ab0b "ETHIOPIC SYLLABLE DDHAA"                nil     )
    (#x00ab0c "ETHIOPIC SYLLABLE DDHEE"                nil     )
    (#x00ab0d "ETHIOPIC SYLLABLE DDHE"                 nil     )
    (#x00ab0e "ETHIOPIC SYLLABLE DDHO"                 nil     )
    (#x00ab11 "ETHIOPIC SYLLABLE DZU"                  nil     )
    (#x00ab12 "ETHIOPIC SYLLABLE DZI"                  nil     )
    (#x00ab13 "ETHIOPIC SYLLABLE DZAA"                 nil     )
    (#x00ab14 "ETHIOPIC SYLLABLE DZEE"                 nil     )
    (#x00ab15 "ETHIOPIC SYLLABLE DZE"                  nil     )
    (#x00ab16 "ETHIOPIC SYLLABLE DZO"                  nil     )
    (#x00ab20 "ETHIOPIC SYLLABLE CCHHA"                nil     )
    (#x00ab21 "ETHIOPIC SYLLABLE CCHHU"                nil     )
    (#x00ab22 "ETHIOPIC SYLLABLE CCHHI"                nil     )
    (#x00ab23 "ETHIOPIC SYLLABLE CCHHAA"               nil     )
    (#x00ab24 "ETHIOPIC SYLLABLE CCHHEE"               nil     )
    (#x00ab25 "ETHIOPIC SYLLABLE CCHHE"                nil     )
    (#x00ab26 "ETHIOPIC SYLLABLE CCHHO"                nil     )
    (#x00ab28 "ETHIOPIC SYLLABLE BBA"                  nil     )
    (#x00ab29 "ETHIOPIC SYLLABLE BBU"                  nil     )
    (#x00ab2a "ETHIOPIC SYLLABLE BBI"                  nil     )
    (#x00ab2b "ETHIOPIC SYLLABLE BBAA"                 nil     )
    (#x00ab2c "ETHIOPIC SYLLABLE BBEE"                 nil     )
    (#x00ab2d "ETHIOPIC SYLLABLE BBE"                  nil     )
    (#x00ab2e "ETHIOPIC SYLLABLE BBO"                  nil     )
    (#x00ab30 "LATIN SMALL LETTER BARRED ALPHA"        nil     )
    (#x00ab31 "LATIN SMALL LETTER A REVERSED-SCHWA"    nil     )
    (#x00ab32 "LATIN SMALL LETTER BLACKLETTER E"       nil     )
    (#x00ab33 "LATIN SMALL LETTER BARRED E"            nil     )
    (#x00ab34 "LATIN SMALL LETTER E WITH FLOURISH"     nil     )
    (#x00ab35 "LATIN SMALL LETTER LENIS F"             nil     )
    (#x00ab36 "LATIN SMALL LETTER SCRIPT G WITH CROSSED-TAIL" nil     )
    (#x00ab37 "LATIN SMALL LETTER L WITH INVERTED LAZY S" nil     )
    (#x00ab38 "LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE" nil     )
    (#x00ab39 "LATIN SMALL LETTER L WITH MIDDLE RING"  nil     )
    (#x00ab3a "LATIN SMALL LETTER M WITH CROSSED-TAIL" nil     )
    (#x00ab3b "LATIN SMALL LETTER N WITH CROSSED-TAIL" nil     )
    (#x00ab3c "LATIN SMALL LETTER ENG WITH CROSSED-TAIL" nil     )
    (#x00ab3d "LATIN SMALL LETTER BLACKLETTER O"       nil     )
    (#x00ab3e "LATIN SMALL LETTER BLACKLETTER O WITH STROKE" nil     )
    (#x00ab3f "LATIN SMALL LETTER OPEN O WITH STROKE"  nil     )
    (#x00ab40 "LATIN SMALL LETTER INVERTED OE"         nil     )
    (#x00ab41 "LATIN SMALL LETTER TURNED OE WITH STROKE" nil     )
    (#x00ab42 "LATIN SMALL LETTER TURNED OE WITH HORIZONTAL STROKE" nil     )
    (#x00ab43 "LATIN SMALL LETTER TURNED O OPEN-O"     nil     )
    (#x00ab44 "LATIN SMALL LETTER TURNED O OPEN-O WITH STROKE" nil     )
    (#x00ab45 "LATIN SMALL LETTER STIRRUP R"           nil     )
    (#x00ab46 "LATIN LETTER SMALL CAPITAL R WITH RIGHT LEG" nil     )
    (#x00ab47 "LATIN SMALL LETTER R WITHOUT HANDLE"    nil     )
    (#x00ab48 "LATIN SMALL LETTER DOUBLE R"            nil     )
    (#x00ab49 "LATIN SMALL LETTER R WITH CROSSED-TAIL" nil     )
    (#x00ab4a "LATIN SMALL LETTER DOUBLE R WITH CROSSED-TAIL" nil     )
    (#x00ab4b "LATIN SMALL LETTER SCRIPT R"            nil     )
    (#x00ab4c "LATIN SMALL LETTER SCRIPT R WITH RING"  nil     )
    (#x00ab4d "LATIN SMALL LETTER BASELINE ESH"        nil     )
    (#x00ab4e "LATIN SMALL LETTER U WITH SHORT RIGHT LEG" nil     )
    (#x00ab4f "LATIN SMALL LETTER U BAR WITH SHORT RIGHT LEG" nil     )
    (#x00ab50 "LATIN SMALL LETTER UI"                  nil     )
    (#x00ab51 "LATIN SMALL LETTER TURNED UI"           nil     )
    (#x00ab52 "LATIN SMALL LETTER U WITH LEFT HOOK"    nil     )
    (#x00ab53 "LATIN SMALL LETTER CHI"                 nil     )
    (#x00ab54 "LATIN SMALL LETTER CHI WITH LOW RIGHT RING" nil     )
    (#x00ab55 "LATIN SMALL LETTER CHI WITH LOW LEFT SERIF" nil     )
    (#x00ab56 "LATIN SMALL LETTER X WITH LOW RIGHT RING" nil     )
    (#x00ab57 "LATIN SMALL LETTER X WITH LONG LEFT LEG" nil     )
    (#x00ab58 "LATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RING" nil     )
    (#x00ab59 "LATIN SMALL LETTER X WITH LONG LEFT LEG WITH SERIF" nil     )
    (#x00ab5a "LATIN SMALL LETTER Y WITH SHORT RIGHT LEG" nil     )
    (#x00ab5b "MODIFIER BREVE WITH INVERTED BREVE"     nil     )
    (#x00ab5c "MODIFIER LETTER SMALL HENG"             nil     )
    (#x00ab5d "MODIFIER LETTER SMALL L WITH INVERTED LAZY S" nil     )
    (#x00ab5e "MODIFIER LETTER SMALL L WITH MIDDLE TILDE" nil     )
    (#x00ab5f "MODIFIER LETTER SMALL U WITH LEFT HOOK" nil     )
    (#x00ab60 "LATIN SMALL LETTER SAKHA YAT"           nil     )
    (#x00ab61 "LATIN SMALL LETTER IOTIFIED E"          nil     )
    (#x00ab62 "LATIN SMALL LETTER OPEN OE"             nil     )
    (#x00ab63 "LATIN SMALL LETTER UO"                  nil     )
    (#x00ab64 "LATIN SMALL LETTER INVERTED ALPHA"      nil     )
    (#x00ab65 "GREEK LETTER SMALL CAPITAL OMEGA"       nil     )
    (#x00ab66 "LATIN SMALL LETTER DZ DIGRAPH WITH RETROFLEX HOOK" nil     )
    (#x00ab67 "LATIN SMALL LETTER TS DIGRAPH WITH RETROFLEX HOOK" nil     )
    (#x00ab68 "LATIN SMALL LETTER TURNED R WITH MIDDLE TILDE" nil     )
    (#x00ab69 "MODIFIER LETTER SMALL TURNED W"         nil     )
    (#x00ab6a "MODIFIER LETTER LEFT TACK"              nil     )
    (#x00ab6b "MODIFIER LETTER RIGHT TACK"             nil     )
    (#x00ab70 "CHEROKEE SMALL LETTER A"                nil     )
    (#x00ab71 "CHEROKEE SMALL LETTER E"                nil     )
    (#x00ab72 "CHEROKEE SMALL LETTER I"                nil     )
    (#x00ab73 "CHEROKEE SMALL LETTER O"                nil     )
    (#x00ab74 "CHEROKEE SMALL LETTER U"                nil     )
    (#x00ab75 "CHEROKEE SMALL LETTER V"                nil     )
    (#x00ab76 "CHEROKEE SMALL LETTER GA"               nil     )
    (#x00ab77 "CHEROKEE SMALL LETTER KA"               nil     )
    (#x00ab78 "CHEROKEE SMALL LETTER GE"               nil     )
    (#x00ab79 "CHEROKEE SMALL LETTER GI"               nil     )
    (#x00ab7a "CHEROKEE SMALL LETTER GO"               nil     )
    (#x00ab7b "CHEROKEE SMALL LETTER GU"               nil     )
    (#x00ab7c "CHEROKEE SMALL LETTER GV"               nil     )
    (#x00ab7d "CHEROKEE SMALL LETTER HA"               nil     )
    (#x00ab7e "CHEROKEE SMALL LETTER HE"               nil     )
    (#x00ab7f "CHEROKEE SMALL LETTER HI"               nil     )
    (#x00ab80 "CHEROKEE SMALL LETTER HO"               nil     )
    (#x00ab81 "CHEROKEE SMALL LETTER HU"               nil     )
    (#x00ab82 "CHEROKEE SMALL LETTER HV"               nil     )
    (#x00ab83 "CHEROKEE SMALL LETTER LA"               nil     )
    (#x00ab84 "CHEROKEE SMALL LETTER LE"               nil     )
    (#x00ab85 "CHEROKEE SMALL LETTER LI"               nil     )
    (#x00ab86 "CHEROKEE SMALL LETTER LO"               nil     )
    (#x00ab87 "CHEROKEE SMALL LETTER LU"               nil     )
    (#x00ab88 "CHEROKEE SMALL LETTER LV"               nil     )
    (#x00ab89 "CHEROKEE SMALL LETTER MA"               nil     )
    (#x00ab8a "CHEROKEE SMALL LETTER ME"               nil     )
    (#x00ab8b "CHEROKEE SMALL LETTER MI"               nil     )
    (#x00ab8c "CHEROKEE SMALL LETTER MO"               nil     )
    (#x00ab8d "CHEROKEE SMALL LETTER MU"               nil     )
    (#x00ab8e "CHEROKEE SMALL LETTER NA"               nil     )
    (#x00ab8f "CHEROKEE SMALL LETTER HNA"              nil     )
    (#x00ab90 "CHEROKEE SMALL LETTER NAH"              nil     )
    (#x00ab91 "CHEROKEE SMALL LETTER NE"               nil     )
    (#x00ab92 "CHEROKEE SMALL LETTER NI"               nil     )
    (#x00ab93 "CHEROKEE SMALL LETTER NO"               nil     )
    (#x00ab94 "CHEROKEE SMALL LETTER NU"               nil     )
    (#x00ab95 "CHEROKEE SMALL LETTER NV"               nil     )
    (#x00ab96 "CHEROKEE SMALL LETTER QUA"              nil     )
    (#x00ab97 "CHEROKEE SMALL LETTER QUE"              nil     )
    (#x00ab98 "CHEROKEE SMALL LETTER QUI"              nil     )
    (#x00ab99 "CHEROKEE SMALL LETTER QUO"              nil     )
    (#x00ab9a "CHEROKEE SMALL LETTER QUU"              nil     )
    (#x00ab9b "CHEROKEE SMALL LETTER QUV"              nil     )
    (#x00ab9c "CHEROKEE SMALL LETTER SA"               nil     )
    (#x00ab9d "CHEROKEE SMALL LETTER S"                nil     )
    (#x00ab9e "CHEROKEE SMALL LETTER SE"               nil     )
    (#x00ab9f "CHEROKEE SMALL LETTER SI"               nil     )
    (#x00aba0 "CHEROKEE SMALL LETTER SO"               nil     )
    (#x00aba1 "CHEROKEE SMALL LETTER SU"               nil     )
    (#x00aba2 "CHEROKEE SMALL LETTER SV"               nil     )
    (#x00aba3 "CHEROKEE SMALL LETTER DA"               nil     )
    (#x00aba4 "CHEROKEE SMALL LETTER TA"               nil     )
    (#x00aba5 "CHEROKEE SMALL LETTER DE"               nil     )
    (#x00aba6 "CHEROKEE SMALL LETTER TE"               nil     )
    (#x00aba7 "CHEROKEE SMALL LETTER DI"               nil     )
    (#x00aba8 "CHEROKEE SMALL LETTER TI"               nil     )
    (#x00aba9 "CHEROKEE SMALL LETTER DO"               nil     )
    (#x00abaa "CHEROKEE SMALL LETTER DU"               nil     )
    (#x00abab "CHEROKEE SMALL LETTER DV"               nil     )
    (#x00abac "CHEROKEE SMALL LETTER DLA"              nil     )
    (#x00abad "CHEROKEE SMALL LETTER TLA"              nil     )
    (#x00abae "CHEROKEE SMALL LETTER TLE"              nil     )
    (#x00abaf "CHEROKEE SMALL LETTER TLI"              nil     )
    (#x00abb0 "CHEROKEE SMALL LETTER TLO"              nil     )
    (#x00abb1 "CHEROKEE SMALL LETTER TLU"              nil     )
    (#x00abb2 "CHEROKEE SMALL LETTER TLV"              nil     )
    (#x00abb3 "CHEROKEE SMALL LETTER TSA"              nil     )
    (#x00abb4 "CHEROKEE SMALL LETTER TSE"              nil     )
    (#x00abb5 "CHEROKEE SMALL LETTER TSI"              nil     )
    (#x00abb6 "CHEROKEE SMALL LETTER TSO"              nil     )
    (#x00abb7 "CHEROKEE SMALL LETTER TSU"              nil     )
    (#x00abb8 "CHEROKEE SMALL LETTER TSV"              nil     )
    (#x00abb9 "CHEROKEE SMALL LETTER WA"               nil     )
    (#x00abba "CHEROKEE SMALL LETTER WE"               nil     )
    (#x00abbb "CHEROKEE SMALL LETTER WI"               nil     )
    (#x00abbc "CHEROKEE SMALL LETTER WO"               nil     )
    (#x00abbd "CHEROKEE SMALL LETTER WU"               nil     )
    (#x00abbe "CHEROKEE SMALL LETTER WV"               nil     )
    (#x00abbf "CHEROKEE SMALL LETTER YA"               nil     )
    (#x00abc0 "MEETEI MAYEK LETTER KOK"                nil     )
    (#x00abc1 "MEETEI MAYEK LETTER SAM"                nil     )
    (#x00abc2 "MEETEI MAYEK LETTER LAI"                nil     )
    (#x00abc3 "MEETEI MAYEK LETTER MIT"                nil     )
    (#x00abc4 "MEETEI MAYEK LETTER PA"                 nil     )
    (#x00abc5 "MEETEI MAYEK LETTER NA"                 nil     )
    (#x00abc6 "MEETEI MAYEK LETTER CHIL"               nil     )
    (#x00abc7 "MEETEI MAYEK LETTER TIL"                nil     )
    (#x00abc8 "MEETEI MAYEK LETTER KHOU"               nil     )
    (#x00abc9 "MEETEI MAYEK LETTER NGOU"               nil     )
    (#x00abca "MEETEI MAYEK LETTER THOU"               nil     )
    (#x00abcb "MEETEI MAYEK LETTER WAI"                nil     )
    (#x00abcc "MEETEI MAYEK LETTER YANG"               nil     )
    (#x00abcd "MEETEI MAYEK LETTER HUK"                nil     )
    (#x00abce "MEETEI MAYEK LETTER UN"                 nil     )
    (#x00abcf "MEETEI MAYEK LETTER I"                  nil     )
    (#x00abd0 "MEETEI MAYEK LETTER PHAM"               nil     )
    (#x00abd1 "MEETEI MAYEK LETTER ATIYA"              nil     )
    (#x00abd2 "MEETEI MAYEK LETTER GOK"                nil     )
    (#x00abd3 "MEETEI MAYEK LETTER JHAM"               nil     )
    (#x00abd4 "MEETEI MAYEK LETTER RAI"                nil     )
    (#x00abd5 "MEETEI MAYEK LETTER BA"                 nil     )
    (#x00abd6 "MEETEI MAYEK LETTER JIL"                nil     )
    (#x00abd7 "MEETEI MAYEK LETTER DIL"                nil     )
    (#x00abd8 "MEETEI MAYEK LETTER GHOU"               nil     )
    (#x00abd9 "MEETEI MAYEK LETTER DHOU"               nil     )
    (#x00abda "MEETEI MAYEK LETTER BHAM"               nil     )
    (#x00abdb "MEETEI MAYEK LETTER KOK LONSUM"         nil     )
    (#x00abdc "MEETEI MAYEK LETTER LAI LONSUM"         nil     )
    (#x00abdd "MEETEI MAYEK LETTER MIT LONSUM"         nil     )
    (#x00abde "MEETEI MAYEK LETTER PA LONSUM"          nil     )
    (#x00abdf "MEETEI MAYEK LETTER NA LONSUM"          nil     )
    (#x00abe0 "MEETEI MAYEK LETTER TIL LONSUM"         nil     )
    (#x00abe1 "MEETEI MAYEK LETTER NGOU LONSUM"        nil     )
    (#x00abe2 "MEETEI MAYEK LETTER I LONSUM"           nil     )
    (#x00abe3 "MEETEI MAYEK VOWEL SIGN ONAP"           nil     )
    (#x00abe4 "MEETEI MAYEK VOWEL SIGN INAP"           nil     )
    (#x00abe5 "MEETEI MAYEK VOWEL SIGN ANAP"           nil     )
    (#x00abe6 "MEETEI MAYEK VOWEL SIGN YENAP"          nil     )
    (#x00abe7 "MEETEI MAYEK VOWEL SIGN SOUNAP"         nil     )
    (#x00abe8 "MEETEI MAYEK VOWEL SIGN UNAP"           nil     )
    (#x00abe9 "MEETEI MAYEK VOWEL SIGN CHEINAP"        nil     )
    (#x00abea "MEETEI MAYEK VOWEL SIGN NUNG"           nil     )
    (#x00abeb "MEETEI MAYEK CHEIKHEI"                  nil     )
    (#x00abec "MEETEI MAYEK LUM IYEK"                  nil     )
    (#x00abed "MEETEI MAYEK APUN IYEK"                 nil     )
    (#x00abf0 "MEETEI MAYEK DIGIT ZERO"                nil     )
    (#x00abf1 "MEETEI MAYEK DIGIT ONE"                 nil     )
    (#x00abf2 "MEETEI MAYEK DIGIT TWO"                 nil     )
    (#x00abf3 "MEETEI MAYEK DIGIT THREE"               nil     )
    (#x00abf4 "MEETEI MAYEK DIGIT FOUR"                nil     )
    (#x00abf5 "MEETEI MAYEK DIGIT FIVE"                nil     )
    (#x00abf6 "MEETEI MAYEK DIGIT SIX"                 nil     )
    (#x00abf7 "MEETEI MAYEK DIGIT SEVEN"               nil     )
    (#x00abf8 "MEETEI MAYEK DIGIT EIGHT"               nil     )
    (#x00abf9 "MEETEI MAYEK DIGIT NINE"                nil     )
    (#x00d7b0 "HANGUL JUNGSEONG O-YEO"                 nil     )
    (#x00d7b1 "HANGUL JUNGSEONG O-O-I"                 nil     )
    (#x00d7b2 "HANGUL JUNGSEONG YO-A"                  nil     )
    (#x00d7b3 "HANGUL JUNGSEONG YO-AE"                 nil     )
    (#x00d7b4 "HANGUL JUNGSEONG YO-EO"                 nil     )
    (#x00d7b5 "HANGUL JUNGSEONG U-YEO"                 nil     )
    (#x00d7b6 "HANGUL JUNGSEONG U-I-I"                 nil     )
    (#x00d7b7 "HANGUL JUNGSEONG YU-AE"                 nil     )
    (#x00d7b8 "HANGUL JUNGSEONG YU-O"                  nil     )
    (#x00d7b9 "HANGUL JUNGSEONG EU-A"                  nil     )
    (#x00d7ba "HANGUL JUNGSEONG EU-EO"                 nil     )
    (#x00d7bb "HANGUL JUNGSEONG EU-E"                  nil     )
    (#x00d7bc "HANGUL JUNGSEONG EU-O"                  nil     )
    (#x00d7bd "HANGUL JUNGSEONG I-YA-O"                nil     )
    (#x00d7be "HANGUL JUNGSEONG I-YAE"                 nil     )
    (#x00d7bf "HANGUL JUNGSEONG I-YEO"                 nil     )
    (#x00d7c0 "HANGUL JUNGSEONG I-YE"                  nil     )
    (#x00d7c1 "HANGUL JUNGSEONG I-O-I"                 nil     )
    (#x00d7c2 "HANGUL JUNGSEONG I-YO"                  nil     )
    (#x00d7c3 "HANGUL JUNGSEONG I-YU"                  nil     )
    (#x00d7c4 "HANGUL JUNGSEONG I-I"                   nil     )
    (#x00d7c5 "HANGUL JUNGSEONG ARAEA-A"               nil     )
    (#x00d7c6 "HANGUL JUNGSEONG ARAEA-E"               nil     )
    (#x00d7cb "HANGUL JONGSEONG NIEUN-RIEUL"           nil     )
    (#x00d7cc "HANGUL JONGSEONG NIEUN-CHIEUCH"         nil     )
    (#x00d7cd "HANGUL JONGSEONG SSANGTIKEUT"           nil     )
    (#x00d7ce "HANGUL JONGSEONG SSANGTIKEUT-PIEUP"     nil     )
    (#x00d7cf "HANGUL JONGSEONG TIKEUT-PIEUP"          nil     )
    (#x00d7d0 "HANGUL JONGSEONG TIKEUT-SIOS"           nil     )
    (#x00d7d1 "HANGUL JONGSEONG TIKEUT-SIOS-KIYEOK"    nil     )
    (#x00d7d2 "HANGUL JONGSEONG TIKEUT-CIEUC"          nil     )
    (#x00d7d3 "HANGUL JONGSEONG TIKEUT-CHIEUCH"        nil     )
    (#x00d7d4 "HANGUL JONGSEONG TIKEUT-THIEUTH"        nil     )
    (#x00d7d5 "HANGUL JONGSEONG RIEUL-SSANGKIYEOK"     nil     )
    (#x00d7d6 "HANGUL JONGSEONG RIEUL-KIYEOK-HIEUH"    nil     )
    (#x00d7d7 "HANGUL JONGSEONG SSANGRIEUL-KHIEUKH"    nil     )
    (#x00d7d8 "HANGUL JONGSEONG RIEUL-MIEUM-HIEUH"     nil     )
    (#x00d7d9 "HANGUL JONGSEONG RIEUL-PIEUP-TIKEUT"    nil     )
    (#x00d7da "HANGUL JONGSEONG RIEUL-PIEUP-PHIEUPH"   nil     )
    (#x00d7db "HANGUL JONGSEONG RIEUL-YESIEUNG"        nil     )
    (#x00d7dc "HANGUL JONGSEONG RIEUL-YEORINHIEUH-HIEUH" nil     )
    (#x00d7dd "HANGUL JONGSEONG KAPYEOUNRIEUL"         nil     )
    (#x00d7de "HANGUL JONGSEONG MIEUM-NIEUN"           nil     )
    (#x00d7df "HANGUL JONGSEONG MIEUM-SSANGNIEUN"      nil     )
    (#x00d7e0 "HANGUL JONGSEONG SSANGMIEUM"            nil     )
    (#x00d7e1 "HANGUL JONGSEONG MIEUM-PIEUP-SIOS"      nil     )
    (#x00d7e2 "HANGUL JONGSEONG MIEUM-CIEUC"           nil     )
    (#x00d7e3 "HANGUL JONGSEONG PIEUP-TIKEUT"          nil     )
    (#x00d7e4 "HANGUL JONGSEONG PIEUP-RIEUL-PHIEUPH"   nil     )
    (#x00d7e5 "HANGUL JONGSEONG PIEUP-MIEUM"           nil     )
    (#x00d7e6 "HANGUL JONGSEONG SSANGPIEUP"            nil     )
    (#x00d7e7 "HANGUL JONGSEONG PIEUP-SIOS-TIKEUT"     nil     )
    (#x00d7e8 "HANGUL JONGSEONG PIEUP-CIEUC"           nil     )
    (#x00d7e9 "HANGUL JONGSEONG PIEUP-CHIEUCH"         nil     )
    (#x00d7ea "HANGUL JONGSEONG SIOS-MIEUM"            nil     )
    (#x00d7eb "HA