;;; vegetative-theme.el --- A Theme based on green CRT terminals

;; Copyright (c) 2022 Jason Milkins (GNU/GPL Licence)

;; Authors: Jason Milkins <jasonm23@gmail.com>
;; URL: http://github.com/emacsfodder/emacs-theme-vegetative
;; Package-Version: 1.0.2
;; Package-Revision: db60ce0fe327
;; Package-Requires: ((autothemer "0.2") (emacs "24"))

;;; License
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 51 Franklin Street, Fifth
;; Floor, Boston, MA 02110-1301, USA.

;;; Commentary:

;;  A Theme based on green CRT terminals.

;;; GUI Support only.

;;; Code:
(require 'autothemer)

(unless (>= emacs-major-version 24)
  (error "Requires Emacs 24 or later"))

(autothemer-deftheme  vegetative
                      "A Theme based on green CRT terminals."
 ((((class color) (min-colors #xFFFFFF))) ;; GUI/24bit only

  (vegetative-background-0-hard     "#000000")
  (vegetative-background-0          "#081900")
  (vegetative-background-0-soft     "#0A2000")
  (vegetative-background-1          "#0F3000")
  (vegetative-background-2          "#154000")
  (vegetative-background-3          "#174700")
  (vegetative-background-4          "#1A4F00")

  (vegetative-medium                "#49DD00")

  (vegetative-foreground-0-hard     "#FEFFFE")
  (vegetative-foreground-0          "#D4FFC0")
  (vegetative-foreground-0-soft     "#74FF30")
  (vegetative-foreground-1          "#5FFF10")
  (vegetative-foreground-2          "#59F00F")
  (vegetative-foreground-3          "#54E00E")
  (vegetative-foreground-4          "#4FD00E")

  (vegetative-bright-red           "#FF0000")
  (vegetative-bright-green         "#00FF00")
  (vegetative-bright-yellow        "#FFFF00")
  (vegetative-bright-blue          "#0000FF")
  (vegetative-bright-purple        "#FF00FF")
  (vegetative-bright-teal          "#008080")
  (vegetative-bright-orange        "#FF8800")
  (vegetative-bright-cyan          "#00FFFF")

  (vegetative-neutral-red          "#54FF00")
  (vegetative-neutral-green        "#4BE500")
  (vegetative-neutral-yellow       "#56FF01")
  (vegetative-neutral-blue         "#7FFF40")
  (vegetative-neutral-purple       "#58B22C")
  (vegetative-neutral-teal         "#8AFF50")
  (vegetative-neutral-orange       "#54FF00")
  (vegetative-neutral-cyan         "#AAFF80")

  (vegetative-faded-red            "#73CC47")
  (vegetative-faded-green          "#4B852E")
  (vegetative-faded-yellow         "#73CC47")
  (vegetative-faded-blue           "#59A037")
  (vegetative-faded-purple         "#90FF59")
  (vegetative-faded-teal           "#519032")
  (vegetative-faded-orange         "#4C862F")
  (vegetative-faded-cyan           "#4C862F")

  (vegetative-muted-red            "#D4FFBF")
  (vegetative-muted-green          "#99B98A")
  (vegetative-muted-yellow         "#D4FFBF")
  (vegetative-muted-blue           "#85A078")
  (vegetative-muted-purple         "#D4FFBF")
  (vegetative-muted-teal           "#77906C")
  (vegetative-muted-orange         "#9ABA8B")
  (vegetative-muted-cyan           "#9ABA8B")

  (vegetative-background-red       "#091901")
  (vegetative-background-green     "#192613")
  (vegetative-background-yellow    "#0D2601")
  (vegetative-background-blue      "#14260C")
  (vegetative-background-purple    "#1D2619")
  (vegetative-background-teal      "#192614")
  (vegetative-background-orange    "#0C2600")
  (vegetative-background-cyan      "#20261E")

  (vegetative-mid-red              "#3FBF00")
  (vegetative-mid-green            "#36890E")
  (vegetative-mid-yellow           "#3AAF00")
  (vegetative-mid-blue             "#3A930F")
  (vegetative-mid-purple           "#49BF0F")
  (vegetative-mid-teal             "#3AB000")
  (vegetative-mid-orange           "#3FBF00")
  (vegetative-mid-cyan             "#3BB200")

  (vegetative-delimiter-1          "#54FF00")
  (vegetative-delimiter-2          "#4AE100")
  (vegetative-delimiter-3          "#45D000")
  (vegetative-delimiter-4          "#38AA00")

  (vegetative-identifiers-1        "#54FF00")
  (vegetative-identifiers-2        "#4EED00")
  (vegetative-identifiers-3        "#47D700")
  (vegetative-identifiers-4        "#40C100")
  (vegetative-identifiers-5        "#3EBB00")
  (vegetative-identifiers-6        "#54FF00")
  (vegetative-identifiers-7        "#4EED00")
  (vegetative-identifiers-8        "#47D700")
  (vegetative-identifiers-9        "#40C100")
  (vegetative-identifiers-10       "#3EBB00")
  (vegetative-identifiers-11       "#54FF00")
  (vegetative-identifiers-12       "#4EED00")
  (vegetative-identifiers-13       "#47D700")
  (vegetative-identifiers-14       "#40C100")
  (vegetative-identifiers-15       "#3EBB00")

  (vegetative-white                "#FFFFFF")
  (vegetative-black                "#000000")
  (vegetative-accent-1             "#54FF00")
  (vegetative-accent-2             "#54FF00")
  (vegetative-accent-3             "#54FF00")
  (vegetative-accent-4             "#54FF00")
  (vegetative-accent-5             "#54FF00")
  (vegetative-accent-6             "#52F700")

  (vegetative-dark-accent-1        "#329800")
  (vegetative-dark-accent-2        "#2D8800")
  (vegetative-dark-accent-3        "#277800")
  (vegetative-dark-accent-4        "#226800")
  (vegetative-dark-accent-5        "#1D5800")
  (vegetative-dark-accent-6        "#174800"))

 ((Info-quoted                               (:inherit 'fixed-pitch-serif))
  (ac-candidate-face                         (:inherit 'popup-face))
  (ac-candidate-mouse-face                   (:inherit 'popup-menu-mouse-face))
  (ac-cider-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-cider-selection-face                   (:inherit 'ac-selection-face))
  (ac-completion-face                        (:underline t :foreground vegetative-neutral-purple))
  (ac-dabbrev-menu-face                      (:inherit 'popup-face))
  (ac-dabbrev-selection-face                 (:inherit 'popup-menu-selection-face))
  (ac-emmet-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-emmet-selection-face                   (:inherit 'ac-selection-face))
  (ac-gtags-candidate-face                   (:foreground vegetative-mid-cyan :inherit 'ac-candidate-face))
  (ac-gtags-selection-face                   (:background vegetative-background-cyan :inherit 'ac-selection-face))
  (ac-nrepl-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-nrepl-selection-face                   (:inherit 'ac-selection-face))
  (ac-selection-face                         (:inherit 'popup-menu-selection-face))
  (ac-yasnippet-candidate-face               (:foreground vegetative-black :background vegetative-foreground-3 :inherit 'ac-candidate-face))
  (ac-yasnippet-selection-face               (:background vegetative-background-red :inherit 'ac-selection-face))
  (ag-hit-face                               (:foreground vegetative-foreground-1))
  (ag-match-face                             (:foreground vegetative-foreground-2))
  (ansible::section-face                     (:foreground vegetative-neutral-red))
  (ansible::task-label-face                  (:foreground vegetative-black))
  (anzu-match-1                              (:foreground vegetative-foreground-0 :background vegetative-dark-accent-3))
  (anzu-match-2                              (:foreground vegetative-foreground-0 :background vegetative-dark-accent-2))
  (anzu-match-3                              (:foreground vegetative-foreground-0 :background vegetative-dark-accent-1))
  (anzu-mode-line                            (:foreground vegetative-foreground-0 :height 100 :background vegetative-background-3))
  (anzu-mode-line-no-match                   (:inherit 'anzu-mode-line))
  (anzu-replace-highlight                    (:background vegetative-background-4))
  (anzu-replace-to                           (:background vegetative-background-3))
  (avy-background-face                       (:foreground vegetative-background-4))
  (avy-goto-char-timer-face                  (:inherit 'highlight))
  (avy-lead-face                             (:foreground vegetative-accent-3))
  (avy-lead-face-0                           (:foreground vegetative-accent-4))
  (avy-lead-face-1                           (:foreground vegetative-accent-1))
  (avy-lead-face-2                           (:foreground vegetative-accent-2))
  (bold                                      (:weight 'bold))
  (bold-italic                               (:weight 'bold :slant 'italic))
  (border                                    (:background vegetative-background-2))

  (buffer-menu-buffer                        (:weight 'bold))
  (button                                    (:inherit 'link))
  (c-annotation-face                         (:inherit 'font-lock-constant-face))
  (change-log-acknowledgment                 (:inherit 'font-lock-comment-face))
  (change-log-conditionals                   (:inherit 'font-lock-variable-name-face))
  (change-log-date                           (:inherit 'font-lock-string-face))
  (change-log-email                          (:inherit 'font-lock-variable-name-face))
  (change-log-file                           (:inherit 'font-lock-function-name-face))
  (change-log-function                       (:inherit 'font-lock-variable-name-face))
  (change-log-list                           (:inherit 'font-lock-keyword-face))
  (change-log-name                           (:inherit 'font-lock-constant-face))
  (col-highlight                             (:inherit 'vline))
  (column-enforce-face                       (:foreground vegetative-background-4 :background vegetative-background-red))
  (column-marker-1                           (:background vegetative-faded-blue))
  (column-marker-2                           (:background vegetative-faded-purple))

  (column-marker-3                           (:background vegetative-faded-cyan))
  (comint-highlight-input                    (:weight 'bold))
  (comint-highlight-prompt                   (:inherit 'minibuffer-prompt))
  (company-echo                              (:inherit 'company-echo-common))
  (company-echo-common                       (:foreground vegetative-bright-blue :background nil))
  (company-preview                           (:inherit 'company-preview-common))
  (company-preview-common                    (:inherit 'font-lock-comment-face))
  (company-preview-common                    (:underline vegetative-foreground-1))
  (company-preview-search                    (:inherit 'company-preview-common))
  (company-scrollbar-bg                      (:foreground nil :background vegetative-background-3))
  (company-scrollbar-fg                      (:foreground nil :background vegetative-background-2))
  (company-template-field                    (:foreground vegetative-bright-blue :background nil :underline vegetative-background-blue))
  (company-tooltip                           (:foreground vegetative-foreground-0-hard :background vegetative-background-1))
  (company-tooltip-annotation                (:foreground vegetative-foreground-0 :background vegetative-background-1))
  (company-tooltip-common                    (:foreground vegetative-foreground-0 :background vegetative-background-1))
  (company-tooltip-common-selection          (:foreground vegetative-foreground-0 :background vegetative-background-2))
  (company-tooltip-mouse                     (:foreground vegetative-foreground-0 :background vegetative-background-3))
  (company-tooltip-selection                 (:foreground vegetative-foreground-0 :background vegetative-background-4))
  (compilation-column-number                 (:inherit 'font-lock-doc-face))
  (compilation-error                         (:inherit 'error))
  (compilation-info                          (:foreground vegetative-neutral-green))
  (compilation-line-number                  (:inherit 'font-lock-keyword-face))
  (compilation-mode-line-exit               (:weight 'bold :foreground vegetative-mid-teal :inherit 'compilation-info))
  (compilation-mode-line-fail                (:foreground vegetative-neutral-red))
  (compilation-mode-line-run                (:inherit 'compilation-warning))
  (compilation-warning                      (:inherit 'warning))
  (completions-annotations                   (:inherit 'italic))
  (completions-common-part nil)
  (completions-first-difference              (:inherit 'bold))
  (cua-global-mark                           (:foreground vegetative-white :background vegetative-background-3))
  (cua-rectangle                             (:background vegetative-background-2 :distant-foreground vegetative-foreground-0))
  (cua-rectangle-noselect                    (:foreground vegetative-white :background vegetative-background-4 :inherit 'region))
  (cursor                                    (:background vegetative-foreground-4))
  (custom-button                             (:box (:line-width 2 :style 'released-button) :foreground vegetative-black :background vegetative-identifiers-1))
  (custom-button-mouse                       (:box (:line-width 2 :style 'released-button) :foreground vegetative-black :background vegetative-identifiers-2))
  (custom-button-pressed                     (:box (:line-width 2 :style 'pressed-button) :foreground vegetative-black :background vegetative-identifiers-1))
  (custom-button-pressed-unraised            (:foreground vegetative-identifiers-13 :inherit 'custom-button-unraised))
  (custom-button-unraised                    (:inherit 'underline))
  (custom-changed                            (:foreground vegetative-white :background vegetative-mid-cyan))
  (custom-comment                            (:background vegetative-background-4))
  (custom-comment-tag                        (:foreground vegetative-identifiers-4))
  (custom-documentation nil)
  (custom-face-tag                           (:inherit 'custom-variable-tag))
  (custom-group-subtitle                     (:weight 'bold))
  (custom-group-tag                          (:height 1.2 :weight 'bold :foreground vegetative-identifiers-9 :inherit 'variable-pitch))
  (custom-group-tag-1                        (:height 1.2 :weight 'bold :foreground vegetative-identifiers-15 :inherit 'variable-pitch))
  (custom-invalid                            (:foreground vegetative-foreground-0-hard :background vegetative-faded-red))
  (custom-link                               (:inherit 'link))
  (custom-modified                           (:foreground vegetative-white :background vegetative-mid-cyan))
  (custom-rogue                              (:foreground vegetative-identifiers-15 :background vegetative-black))
  (custom-saved                              (:underline t))
  (custom-set                                (:foreground vegetative-mid-cyan :background vegetative-white))
  (custom-state                              (:foreground vegetative-mid-yellow))
  (custom-themed                             (:foreground vegetative-white :background vegetative-mid-cyan))
  (custom-variable-button                    (:weight 'bold :underline t))
  (custom-variable-tag                       (:weight 'bold :foreground vegetative-identifiers-9))
  (custom-visibility                         (:height 0.8 :inherit 'link))
  (default                                   (:foreground vegetative-foreground-0 :background vegetative-background-0))
  (describe-variable-value                   (:foreground vegetative-bright-orange))
  (diff-added                                (:foreground vegetative-foreground-1 :background vegetative-background-green))
  (diff-changed                              (:foreground vegetative-foreground-1 :background vegetative-background-purple)) (diff-context                              (:foreground vegetative-identifiers-2)) (diff-file-header                          (:weight 'bold :background vegetative-faded-purple))
  (diff-function                             (:inherit 'diff-header))
  (diff-header                               (:background vegetative-background-4))
  (diff-hl-change                            (:inherit 'diff-changed))
  (diff-hl-delete                            (:inherit 'diff-removed)) (diff-hl-insert                            (:inherit 'diff-added)) (diff-hunk-header                          (:inherit 'diff-header)) (diff-index                                (:inherit 'diff-file-header)) (diff-indicator-added                      (:inherit 'diff-added))
  (diff-indicator-changed                    (:inherit 'diff-changed))
  (diff-indicator-removed                    (:inherit 'diff-removed))
  (diff-nonexistent                          (:inherit 'diff-file-header))
  (diff-refine-added                         (:background vegetative-background-green :inherit 'diff-refine-change))
  (diff-refine-changed                       (:background vegetative-background-blue))
  (diff-refine-removed                       (:background vegetative-background-red :inherit 'diff-refine-change))
  (diff-removed                              (:foreground vegetative-foreground-1 :background vegetative-background-red))
  (dired-directory                           (:inherit 'font-lock-function-name-face))
  (dired-flagged                             (:inherit 'error))
  (dired-header                              (:inherit 'font-lock-type-face))
  (dired-ignored                             (:inherit 'shadow))
  (dired-mark                                (:inherit 'font-lock-constant-face))
  (dired-marked                              (:inherit 'warning))
  (dired-perm-write                          (:inherit 'font-lock-comment-delimiter-face))
  (dired-subtree-depth-1-face                (:background nil))
  (dired-subtree-depth-2-face                (:background nil))
  (dired-subtree-depth-3-face                (:background nil))
  (dired-subtree-depth-4-face                (:background nil))
  (dired-subtree-depth-5-face                (:background nil))
  (dired-subtree-depth-6-face                (:background nil))
  (dired-symlink                             (:inherit 'font-lock-keyword-face))
  (dired-warning                             (:inherit 'font-lock-warning-face))
  (diredfl-autofile-name                     (:foreground vegetative-foreground-1))
  (diredfl-compressed-file-name              (:foreground vegetative-foreground-1))
  (diredfl-compressed-file-suffix            (:foreground vegetative-foreground-1))
  (diredfl-date-time                         (:foreground vegetative-accent-5))
  (diredfl-deletion                          (:foreground vegetative-faded-red))
  (diredfl-deletion-file-name                (:foreground vegetative-faded-red))
  (diredfl-dir-heading                       (:foreground vegetative-foreground-1))
  (diredfl-dir-name                          (:foreground vegetative-bright-cyan))
  (diredfl-dir-priv                          (:foreground vegetative-bright-cyan :background vegetative-background-1))
  (diredfl-exec-priv                         (:foreground vegetative-bright-orange :background vegetative-background-1))
  (diredfl-executable-tag                    (:foreground vegetative-bright-orange))
  (diredfl-file-name                         (:foreground vegetative-faded-teal))
  (diredfl-file-suffix                       (:foreground vegetative-faded-teal))
  (diredfl-flag-mark                         (:foreground vegetative-bright-cyan))
  (diredfl-flag-mark-line                    (:foreground vegetative-foreground-0 :background vegetative-background-1))
  (diredfl-ignored-file-name                 (:foreground vegetative-foreground-3))
  (diredfl-link-priv                         (:foreground vegetative-bright-purple :background vegetative-background-1))
  (diredfl-no-priv                           (:foreground vegetative-foreground-4 :background vegetative-background-1))
  (diredfl-number                            (:foreground vegetative-foreground-2))
  (diredfl-other-priv                        (:background vegetative-background-1))
  (diredfl-rare-priv                         (:background vegetative-background-1))
  (diredfl-read-priv                         (:foreground vegetative-bright-teal :background vegetative-background-1))
  (diredfl-symlink                           (:foreground vegetative-neutral-cyan))
  (diredfl-tagged-autofile-name              (:foreground vegetative-foreground-1 :background vegetative-background-1))
  (diredfl-write-priv                        (:foreground vegetative-bright-green :background vegetative-background-1))
  (diredp-autofile-name                      (:inherit 'diredfl-autofile-name))
  (diredp-compressed-file-name               (:inherit 'diredfl-compressed-file-name))
  (diredp-compressed-file-suffix             (:inherit 'diredfl-compressed-file-suffix))
  (diredp-date-time                          (:inherit 'diredfl-date-time))
  (diredp-deletion                           (:inherit 'diredfl-deletion))
  (diredp-deletion-file-name                 (:inherit 'diredfl-deletion-file-name))
  (diredp-dir-heading                        (:inherit 'diredfl-dir-heading))
  (diredp-dir-name                           (:inherit 'diredfl-dir-name))
  (diredp-dir-priv                           (:inherit 'diredfl-dir-priv))
  (diredp-exec-priv                          (:inherit 'diredfl-exec-priv))
  (diredp-executable-tag                     (:inherit 'diredfl-executable-tag))
  (diredp-file-name                          (:inherit 'diredfl-file-name))
  (diredp-file-suffix                        (:inherit 'diredfl-file-suffix))
  (diredp-flag-mark                          (:inherit 'diredfl-flag-mark))
  (diredp-flag-mark-line                     (:inherit 'diredfl-flag-mark-line))
  (diredp-ignored-file-name                  (:inherit 'diredfl-ignored-file-name))
  (diredp-link-priv                          (:inherit 'diredfl-link-priv))
  (diredp-no-priv                            (:inherit 'diredfl-no-priv))
  (diredp-number                             (:inherit 'diredfl-number))
  (diredp-other-priv                         (:inherit 'diredfl-other-priv))
  (diredp-rare-priv                          (:inherit 'diredfl-rare-priv))
  (diredp-read-priv                          (:inherit 'diredfl-read-priv))
  (diredp-symlink                            (:inherit 'diredfl-symlink))
  (diredp-tagged-autofile-name               (:inherit 'diredfl-tagged-autofile-name))
  (diredp-write-priv                         (:inherit 'diredfl-write-priv))
  (dropdown-list-face                        (:foreground vegetative-black :background vegetative-foreground-0-hard :inherit 'default))
  (dropdown-list-selection-face              (:background vegetative-bright-purple :inherit 'dropdown-list))
  (el-search-match                           (:background vegetative-background-cyan))
  (el-search-other-match                     (:background vegetative-background-blue))
  (eldoc-highlight-function-argument         (:inherit 'bold))
  (elfeed-search-date-face                   (:foreground vegetative-muted-cyan))
  (elfeed-search-feed-face                   (:foreground vegetative-faded-cyan))
  (elfeed-search-tag-face                    (:foreground vegetative-foreground-3))
  (elfeed-search-title-face                  (:foreground vegetative-foreground-3 :bold nil))
  (elfeed-search-unread-title-face           (:foreground vegetative-foreground-0-hard :bold nil))
  (elscreen-tab-background-face              (:background vegetative-background-0 :box nil))
  (elscreen-tab-control-face                 (:foreground vegetative-neutral-red :background vegetative-background-2 :box nil :underline nil))
  (elscreen-tab-current-screen-face          (:foreground vegetative-background-0 :background vegetative-background-4 :box nil))
  (elscreen-tab-other-screen-face            (:foreground vegetative-foreground-4 :background vegetative-background-2 :box nil :underline nil))
  (embrace-help-key-face                     (:foreground   vegetative-accent-3  :weight 'bold))
  (embrace-help-mark-func-face               (:foreground   vegetative-accent-4))
  (embrace-help-pair-face                    (:foreground   vegetative-accent-1))
  (embrace-help-separator-face               (:foreground   vegetative-accent-2))
  (erc-action-face                           (:inherit 'erc-default-face))
  (erc-bold-face                             (:weight 'bold))
  (erc-button                                (:weight 'bold  :underline t))
  (erc-current-nick-face                     (:foreground vegetative-accent-3 :weight 'bold))
  (erc-dangerous-host-face                   (:inherit 'font-lock-warning-face))
  (erc-default-face                          (:inherit 'default))
  (erc-direct-msg-face                       (:inherit 'erc-default-face))
  (erc-error-face                            (:inherit 'font-lock-warning-face))
  (erc-fool-face                             (:inherit 'erc-default-face))
  (erc-input-face                            (:foreground vegetative-accent-3))
  (erc-keyword-face                          (:foreground vegetative-bright-orange :weight 'bold))
  (erc-my-nick-face                          (:foreground vegetative-accent-3 :weight 'bold))
  (erc-nick-default-face                     (:weight 'bold))
  (erc-nick-msg-face                         (:inherit 'erc-default-face))
  (erc-notice-face                           (:foreground vegetative-background-4))
  (erc-pal-face                              (:foreground vegetative-neutral-yellow :weight 'bold))
  (erc-prompt-face                           (:foreground vegetative-accent-3 :weight 'bold))
  (erc-timestamp-face                        (:foreground vegetative-neutral-green))
  (erc-underline-face                        (:underline t))
  (erefactor-highlight-face                  (:inherit 'match))
  (error                                     (:foreground vegetative-bright-red :bold t))
  (escape-glyph                              (:foreground vegetative-neutral-cyan))
  (eww-form-checkbox                         (:box (:line-width 2 :style 'released-button) :foreground vegetative-black :background vegetative-identifiers-1))
  (eww-form-file                             (:box (:line-width 2 :style 'released-button) :foreground vegetative-black :background vegetative-muted-purple))
  (eww-form-select                           (:box (:line-width 2 :style 'released-button) :foreground vegetative-black :background vegetative-identifiers-1))
  (eww-form-submit                           (:box (:line-width 2 :style 'released-button) :foreground vegetative-black :background vegetative-muted-purple))
  (eww-form-text                             (:box (:line-width 1) :foreground vegetative-white :background vegetative-background-2))
  (eww-form-textarea                         (:box (:line-width 1) :foreground vegetative-black :background vegetative-neutral-purple))
  (eww-invalid-certificate                   (:weight 'bold :foreground vegetative-faded-red))
  (eww-valid-certificate                     (:weight 'bold :foreground vegetative-mid-teal))
  (ffap                                      (:inherit 'highlight))
  (file-name-shadow                          (:inherit 'shadow))
  (fixed-pitch                               (:family "Monospace"))
  (fixed-pitch-serif                         (:family "Monospace Serif"))
  (flx-highlight-face                        (:weight 'bold :underline t :inherit 'font-lock-variable-name-face))
  (flycheck-error                            (:underline (:style 'wave :color vegetative-faded-red)))
  (flycheck-error-list-checker-name          (:inherit 'font-lock-function-name-face))
  (flycheck-error-list-column-number         (:inherit 'font-lock-constant-face))
  (flycheck-error-list-error                 (:inherit 'error))
  (flycheck-error-list-highlight             (:inherit 'highlight))
  (flycheck-error-list-id                    (:inherit 'font-lock-type-face))
  (flycheck-error-list-id-with-explainer     (:box (:style 'released-button) :inherit 'flycheck-error-list-id))
  (flycheck-error-list-info                  (:inherit 'success))
  (flycheck-error-list-line-number           (:inherit 'font-lock-constant-face))
  (flycheck-error-list-warning               (:inherit 'warning))
  (flycheck-fringe-error                     (:inherit 'error))
  (flycheck-fringe-info                      (:inherit 'success))
  (flycheck-fringe-warning                   (:inherit 'warning))
  (flycheck-info                             (:underline (:style 'wave :color vegetative-mid-teal)))
  (flycheck-warning                          (:underline (:style 'wave :color vegetative-bright-red)))
  (flymake-errline                           (:underline (:style 'wave :color vegetative-faded-red)))
  (flymake-warnline                          (:underline (:style 'wave :color vegetative-bright-red)))
  (font-latex-math-face                      (:foreground vegetative-accent-3))
  (font-latex-sectioning-5-face              (:foreground vegetative-neutral-green))
  (font-latex-string-face                    (:inherit 'font-lock-string-face))
  (font-latex-warning-face                   (:inherit 'warning))
  (font-lock-builtin-face                           (:foreground vegetative-foreground-3))
  (font-lock-comment-delimiter-face                 (:inherit 'font-lock-comment-face))
  (font-lock-comment-face                           (:foreground vegetative-foreground-4))
  (font-lock-constant-face                          (:foreground vegetative-accent-4))
  (font-lock-doc-face                               (:inherit 'font-lock-string-face))
  (font-lock-function-name-face                     (:foreground vegetative-foreground-2))
  (font-lock-keyword-face                           (:foreground vegetative-accent-1))
  (font-lock-negation-char-face                     (:foreground vegetative-foreground-1))
  (font-lock-preprocessor-face                      (:inherit 'font-lock-builtin-face))
  (font-lock-regexp-grouping-backslash              (:inherit 'bold))
  (font-lock-regexp-grouping-construct              (:inherit 'bold))
  (font-lock-string-face                            (:foreground vegetative-accent-2))
  (font-lock-type-face                              (:foreground vegetative-accent-3))
  (font-lock-variable-name-face                     (:foreground vegetative-accent-5))
  (font-lock-warning-face                           (:foreground vegetative-bright-red :bold t))
  (fringe                                    (:background vegetative-background-0))
  (git-commit-comment-action                 (:inherit 'git-commit-comment-branch))
  (git-commit-comment-branch                 (:inherit 'font-lock-variable-name-face))
  (git-commit-comment-detached               (:inherit 'git-commit-comment-branch))
  (git-commit-comment-file                   (:inherit 'git-commit-pseudo-header))
  (git-commit-comment-heading                (:inherit 'git-commit-known-pseudo-header))
  (git-commit-known-pseudo-header            (:inherit 'font-lock-keyword-face))
  (git-commit-nonempty-second-line           (:inherit 'font-lock-warning-face))
  (git-commit-note                           (:inherit 'font-lock-string-face))
  (git-commit-overlong-summary               (:inherit 'font-lock-warning-face))
  (git-commit-pseudo-header                  (:inherit 'font-lock-string-face))
  (git-commit-summary                        (:inherit 'font-lock-type-face))
  (git-gutter+-added                         (:foreground vegetative-bright-green :background vegetative-background-green))
  (git-gutter+-commit-header-face            (:inherit 'font-lock-comment-face))
  (git-gutter+-deleted                       (:foreground vegetative-bright-red :background vegetative-background-red))
  (git-gutter+-modified                      (:foreground vegetative-bright-purple :background vegetative-background-purple))
  (git-gutter+-separator                     (:foreground vegetative-bright-cyan :background vegetative-muted-cyan))
  (git-gutter+-unchanged                     (:foreground vegetative-bright-yellow :background vegetative-muted-yellow))
  (git-gutter-fr+-added                      (:inherit 'git-gutter+-added))
  (git-gutter-fr+-deleted                    (:inherit 'git-gutter+-deleted))
  (git-gutter-fr+-modified                   (:inherit 'git-gutter+-modified))
  (git-gutter-fr:added                       (:foreground vegetative-bright-green :background vegetative-background-green))
  (git-gutter-fr:deleted                     (:foreground vegetative-bright-red :background vegetative-background-red))
  (git-gutter-fr:modified                    (:foreground vegetative-bright-purple :background vegetative-background-purple))
  (git-gutter:added                          (:foreground vegetative-bright-green :background vegetative-background-green))
  (git-gutter:deleted                        (:foreground vegetative-bright-red :background vegetative-background-red))
  (git-gutter:modified                       (:foreground vegetative-bright-purple :background vegetative-background-purple))
  (git-gutter:separator                      (:foreground vegetative-bright-cyan :background vegetative-muted-cyan))
  (git-gutter:unchanged                      (:foreground vegetative-bright-yellow :background vegetative-muted-yellow))
  (glyphless-char                            (:height 0.6))
  (gnus-group-mail-1                         (:weight 'bold :foreground vegetative-foreground-0-hard))
  (gnus-group-mail-1-empty                   (:foreground vegetative-foreground-0-hard))
  (gnus-group-mail-2                         (:weight 'bold :foreground vegetative-identifiers-4))
  (gnus-group-mail-2-empty                   (:foreground vegetative-identifiers-4))
  (gnus-group-mail-3                         (:weight 'bold :foreground vegetative-bright-orange))
  (gnus-group-mail-3-empty                   (:foreground vegetative-bright-orange))
  (gnus-group-mail-low                       (:weight 'bold :foreground vegetative-faded-orange))
  (gnus-group-mail-low-empty                 (:foreground vegetative-faded-orange))
  (gnus-group-news-1                         (:weight 'bold :foreground vegetative-identifiers-7))
  (gnus-group-news-1-empty                   (:foreground vegetative-identifiers-7))
  (gnus-group-news-2                         (:weight 'bold :foreground vegetative-bright-cyan))
  (gnus-group-news-2-empty                   (:foreground vegetative-bright-cyan))
  (gnus-group-news-3                         (:weight 'bold))
  (gnus-group-news-3-empty nil)
  (gnus-group-news-4                         (:weight 'bold))
  (gnus-group-news-4-empty nil)
  (gnus-group-news-5                         (:weight 'bold))
  (gnus-group-news-5-empty nil)
  (gnus-group-news-6                         (:weight 'bold))
  (gnus-group-news-6-empty nil)
  (gnus-group-news-low                       (:weight 'bold :foreground vegetative-neutral-cyan))
  (gnus-group-news-low-empty                 (:foreground vegetative-neutral-cyan))
  (gnus-splash                               (:foreground vegetative-identifiers-4))
  (gnus-summary-cancelled                    (:foreground vegetative-foreground-0-hard :background vegetative-black))
  (gnus-summary-high-ancient                 (:weight 'bold :foreground vegetative-bright-green))
  (gnus-summary-high-read                    (:weight 'bold :foreground vegetative-neutral-yellow))
  (gnus-summary-high-ticked                  (:weight 'bold :foreground vegetative-identifiers-15))
  (gnus-summary-high-undownloaded            (:weight 'bold :foreground vegetative-identifiers-1))
  (gnus-summary-high-unread                  (:weight 'bold))
  (gnus-summary-low-ancient                  (:slant 'italic :foreground vegetative-bright-green))
  (gnus-summary-low-read                     (:slant 'italic :foreground vegetative-neutral-yellow))
  (gnus-summary-low-ticked                   (:slant 'italic :foreground vegetative-identifiers-15))
  (gnus-summary-low-undownloaded             (:weight 'normal :slant 'italic :foreground vegetative-faded-cyan))
  (gnus-summary-low-unread                   (:slant 'italic))
  (gnus-summary-normal-ancient               (:foreground vegetative-bright-green))
  (gnus-summary-normal-read                  (:foreground vegetative-neutral-yellow))
  (gnus-summary-normal-ticked                (:foreground vegetative-identifiers-15))
  (gnus-summary-normal-undownloaded          (:weight 'normal :foreground vegetative-faded-cyan))
  (gnus-summary-normal-unread nil)
  (gnus-summary-selected                     (:underline t))
  (haskell-constructor-face                  (:foreground vegetative-neutral-teal :background nil))
  (haskell-debug-heading-face                (:inherit ('quote 'font-lock-keyword-face)))
  (haskell-debug-keybinding-face             (:weight 'bold :inherit ('quote 'font-lock-type-face)))
  (haskell-debug-muted-face                  (:foreground vegetative-muted-purple))
  (haskell-debug-newline-face                (:weight 'bold :background vegetative-white))
  (haskell-debug-trace-number-face           (:weight 'bold :background vegetative-white))
  (haskell-debug-warning-face                (:inherit ('quote 'compilation-warning)))
  (haskell-error-face                        (:underline (:style 'wave :color vegetative-bright-red)))
  (haskell-hole-face                         (:underline (:style 'wave :color vegetative-muted-green)))
  (haskell-interactive-face-compile-error    (:underline (:color vegetative-bright-red :style 'wave)))
  (haskell-interactive-face-compile-warning  (:underline (:color vegetative-bright-yellow :style 'wave)))
  (haskell-interactive-face-garbage          (:foreground vegetative-background-4 :background nil))
  (haskell-interactive-face-prompt           (:foreground vegetative-foreground-0 :background nil))
  (haskell-interactive-face-prompt2          (:inherit 'font-lock-keyword-face))
  (haskell-interactive-face-result           (:foreground vegetative-foreground-3 :background nil))
  (haskell-keyword-face                      (:inherit 'font-lock-keyword-face))
  (haskell-liquid-haskell-annotation-face    (:inherit 'haskell-pragma-face))
  (haskell-literate-comment-face             (:foreground vegetative-foreground-0 :background nil))
  (haskell-operator-face                     (:inherit 'font-lock-variable-name-face))
  (haskell-pragma-face                       (:foreground vegetative-medium :background nil))
  (haskell-type-face                         (:inherit 'font-lock-type-face))
  (haskell-warning-face                      (:underline (:style 'wave :color vegetative-medium)))
  (header-line                               (:foreground vegetative-accent-6 :background vegetative-background-0 :bold nil))
  (helm-M-x-key                              (:foreground vegetative-neutral-orange))
  (helm-action                               (:foreground vegetative-white :underline t))
  (helm-bookmark-addressbook                 (:foreground vegetative-neutral-red))
  (helm-bookmark-directory                   (:foreground vegetative-bright-purple))
  (helm-bookmark-file                        (:foreground vegetative-faded-blue))
  (helm-bookmark-gnus                        (:foreground vegetative-faded-purple))
  (helm-bookmark-info                        (:foreground vegetative-accent-6))
  (helm-bookmark-man                         (:foreground vegetative-accent-1))
  (helm-bookmark-w3m                         (:foreground vegetative-neutral-yellow))
  (helm-buffer-directory                     (:foreground vegetative-white :background vegetative-bright-blue))
  (helm-buffer-not-saved                     (:foreground vegetative-faded-red))
  (helm-buffer-process                       (:foreground vegetative-accent-4))
  (helm-buffer-saved-out                     (:foreground vegetative-bright-red))
  (helm-buffer-size                          (:foreground vegetative-bright-purple))
  (helm-candidate-number                     (:foreground vegetative-neutral-green))
  (helm-ff-directory                         (:foreground vegetative-neutral-purple))
  (helm-ff-executable                        (:foreground vegetative-accent-6))
  (helm-ff-file                              (:foreground vegetative-accent-1))
  (helm-ff-invalid-symlink                   (:foreground vegetative-white :background vegetative-bright-red))
  (helm-ff-prefix                            (:foreground vegetative-black :background vegetative-neutral-yellow))
  (helm-ff-symlink                           (:foreground vegetative-neutral-orange))
  (helm-grep-cmd-line                        (:foreground vegetative-neutral-green))
  (helm-grep-file                            (:foreground vegetative-faded-purple))
  (helm-grep-finish                          (:foreground vegetative-accent-6))
  (helm-grep-lineno                          (:foreground vegetative-neutral-orange))
  (helm-grep-match                           (:foreground vegetative-neutral-yellow))
  (helm-grep-running                         (:foreground vegetative-neutral-red))
  (helm-header                               (:foreground vegetative-accent-5))
  (helm-helper                               (:foreground vegetative-accent-5))
  (helm-history-deleted                      (:foreground vegetative-black :background vegetative-bright-red))
  (helm-history-remote                       (:foreground vegetative-faded-red))
  (helm-lisp-completion-info                 (:foreground vegetative-faded-orange))
  (helm-lisp-show-completion                 (:foreground vegetative-bright-red))
  (helm-locate-finish                        (:foreground vegetative-white :background vegetative-accent-5))
  (helm-match                                (:foreground vegetative-neutral-orange))
  (helm-moccur-buffer                        (:foreground vegetative-bright-teal :underline t))
  (helm-prefarg                              (:foreground vegetative-accent-6))
  (helm-selection                            (:foreground vegetative-white :background vegetative-background-2))
  (helm-selection-line                       (:foreground vegetative-white :background vegetative-background-2))
  (helm-separator                            (:foreground vegetative-faded-red))
  (helm-source-header                        (:foreground vegetative-foreground-2 :background vegetative-background-1))
  (helm-visible-mark                         (:foreground vegetative-black :background vegetative-foreground-3))
  (help-argument-name                        (:inherit 'italic))
  (hi-black-b                                (:foreground vegetative-bright-orange :background vegetative-background-0-hard :bold t))
  (hi-black-hb                               (:foreground vegetative-bright-cyan :background vegetative-background-0-hard :bold t))
  (hi-blue                                   (:foreground vegetative-background-0-hard :background vegetative-bright-blue))
  (hi-blue-b                                 (:foreground vegetative-bright-blue :bold t))
  (hi-green                                  (:foreground vegetative-background-0-hard :background vegetative-bright-green))
  (hi-green-b                                (:foreground vegetative-bright-green :bold t))
  (hi-pink                                   (:foreground vegetative-background-0-hard :background vegetative-bright-purple))
  (hi-red-b                                  (:foreground vegetative-bright-red :bold t))
  (hi-yellow                                 (:foreground vegetative-background-0-hard :background vegetative-bright-yellow))
  (highlight                                 (:foreground vegetative-foreground-0-hard :background vegetative-background-3))
  (highlight-indentation-current-column-face (:background vegetative-background-4))
  (highlight-indentation-face                (:background vegetative-background-1))
  (highlight-numbers-number                  (:foreground vegetative-foreground-1 :bold t))
  (highlight-symbol-face                     (:foreground vegetative-neutral-purple))
  (hl-line                                   (:background vegetative-background-1))
  (hl-spotlight                              (:inherit 'highlight))
  (hydra-face-amaranth                       (:foreground vegetative-accent-4))
  (hydra-face-blue                           (:foreground vegetative-accent-2))
  (hydra-face-pink                           (:foreground vegetative-accent-3))
  (hydra-face-red                            (:foreground vegetative-accent-1))
  (hydra-face-teal                           (:foreground vegetative-accent-5))
  (ido-first-match                           (:foreground vegetative-faded-cyan :background vegetative-background-0-hard))
  (ido-incomplete-regexp                     (:inherit 'font-lock-warning-face))
  (ido-indicator                             (:background vegetative-bright-red :foreground vegetative-bright-yellow))
  (ido-only-match                            (:foreground vegetative-accent-2))
  (ido-subdir                                (:foreground vegetative-foreground-3))
  (ido-vertical-first-match-face             (:foreground vegetative-faded-cyan :background vegetative-background-blue))
  (ido-vertical-match-face                   (:bold t))
  (ido-vertical-only-match-face              (:foreground vegetative-faded-cyan))
  (ido-virtual                               (:inherit 'font-lock-builtin-face))
  (iedit-occurrence                          (:inherit 'highlight))
  (iedit-read-only-occurrence                (:inherit 'region))
  (info-header-node                          (:inherit 'info-node))
  (info-header-xref                          (:inherit 'info-xref))
  (info-index-match                          (:inherit 'match))
  (info-menu-header                          (:weight 'bold :inherit 'variable-pitch))
  (info-menu-star                            (:foreground vegetative-faded-red))
  (info-node                                 (:weight 'bold :slant 'italic :foreground vegetative-white))
  (info-title-1                              (:height 1.2 :inherit 'info-title-2))
  (info-title-2                              (:height 1.2 :inherit 'info-title-3))
  (info-title-3                              (:height 1.2 :inherit 'info-title-4))
  (info-title-4                              (:weight 'bold :inherit 'variable-pitch))
  (info-xref                                 (:inherit 'link))
  (info-xref-visited                         (:inherit ('link-visited 'info-xref)))
  (isearch                                   (:foreground vegetative-foreground-0-hard :background vegetative-background-2))
  (isearch-fail                              (:foreground vegetative-foreground-0-hard :background vegetative-background-red))
  (isearch-group-1                           (:foreground vegetative-foreground-0-hard :background vegetative-dark-accent-3))
  (isearch-group-2                           (:foreground vegetative-foreground-0-hard :background vegetative-dark-accent-5))
  (italic                                    (:slant 'italic))
  (ivy-action                                (:inherit 'font-lock-builtin-face))
  (ivy-confirm-face                          (:foreground vegetative-bright-green))
  (ivy-current-match                         (:foreground vegetative-foreground-0 :background vegetative-background-3))
  (ivy-cursor                                (:foreground vegetative-white :background vegetative-black))
  (ivy-match-required-face                   (:foreground vegetative-bright-red))
  (ivy-minibuffer-match-face-1               (:background vegetative-background-1))
  (ivy-minibuffer-match-face-2               (:background vegetative-background-2))
  (ivy-minibuffer-match-face-3               (:background vegetative-faded-teal))
  (ivy-minibuffer-match-face-4               (:background vegetative-faded-purple))
  (ivy-modified-buffer                       (:inherit 'default))
  (ivy-remote                                (:foreground vegetative-neutral-blue))
  (ivy-subdir                                (:inherit 'dired-directory))
  (ivy-virtual                               (:inherit 'font-lock-builtin-face))
  (js2-error                                 (:underline (:color vegetative-bright-red :style 'wave)))
  (js2-external-variable                     (:underline (:color vegetative-bright-teal :style 'wave)))
  (js2-function-call                         (:foreground vegetative-bright-blue :background nil))
  (js2-function-param                        (:foreground vegetative-bright-teal :background nil))
  (js2-instance-member                       (:foreground vegetative-bright-orange :background nil))
  (js2-jsdoc-html-tag-delimiter              (:foreground vegetative-foreground-3 :background nil))
  (js2-jsdoc-html-tag-name                   (:foreground vegetative-foreground-4 :background nil))
  (js2-jsdoc-tag                             (:foreground vegetative-medium :background nil))
  (js2-jsdoc-type                            (:foreground vegetative-foreground-4 :background nil))
  (js2-jsdoc-value                           (:foreground vegetative-foreground-3 :background nil))
  (js2-object-property                       (:inherit 'default))
  (js2-private-function-call                 (:foreground vegetative-faded-teal :background nil))
  (js2-private-member                        (:foreground vegetative-faded-yellow :background nil))
  (js2-warning                               (:underline (:color vegetative-bright-yellow :style 'wave)))
  (lacarte-shortcut                          (:foreground vegetative-neutral-purple))
  (lazy-highlight                            (:foreground vegetative-foreground-0 :background vegetative-background-3))
  (link                                      (:foreground vegetative-faded-blue :underline t))
  (link-visited                              (:foreground vegetative-faded-blue :underline nil))
  (linum                                     (:foreground vegetative-background-4))
  (linum-relative-current-face               (:foreground vegetative-foreground-4 :background vegetative-background-1))
  (log-edit-header                           (:inherit 'font-lock-keyword-face))
  (log-edit-summary                          (:inherit 'font-lock-function-name-face))
  (log-edit-unknown-header                   (:inherit 'font-lock-comment-face))
  (lv-separator                              (:background vegetative-background-2))
  (magit-bisect-bad                          (:foreground vegetative-faded-red))
  (magit-bisect-good                         (:foreground vegetative-neutral-green))
  (magit-bisect-skip                         (:foreground vegetative-foreground-2))
  (magit-blame-date                          (:inherit 'magit-blame-heading))
  (magit-blame-hash                          (:inherit 'magit-blame-heading))
  (magit-blame-heading                       (:background vegetative-background-1 :foreground vegetative-foreground-0))
  (magit-blame-name                          (:inherit 'magit-blame-heading))
  (magit-blame-summary                       (:inherit 'magit-blame-heading))
  (magit-branch                              (:foreground vegetative-accent-6 :background nil))
  (magit-branch-current                      (:box 1 :inherit 'magit-branch-local))
  (magit-branch-local                        (:foreground vegetative-accent-6 :background nil))
  (magit-branch-remote                       (:foreground vegetative-accent-5 :background nil))
  (magit-cherry-equivalent                   (:foreground vegetative-neutral-orange))
  (magit-cherry-unmatched                    (:foreground vegetative-neutral-purple))
  (magit-diff-add                            (:foreground vegetative-bright-green))
  (magit-diff-added                          (:foreground vegetative-bright-green :background vegetative-background-green))
  (magit-diff-added-highlight                (:foreground vegetative-bright-green :background vegetative-background-green))
  (magit-diff-base                           (:foreground vegetative-foreground-0-hard :background vegetative-background-2))
  (magit-diff-base-highlight                 (:foreground vegetative-foreground-0-soft :background vegetative-background-3))
  (magit-diff-conflict-heading               (:inherit 'magit-diff-hunk-heading))
  (magit-diff-context                        (:foreground vegetative-foreground-4 :background nil))
  (magit-diff-context-highlight              (:foreground vegetative-foreground-4 :background vegetative-background-0-soft))
  (magit-diff-del                            (:foreground vegetative-bright-red))
  (magit-diff-file-header                    (:foreground vegetative-foreground-0))
  (magit-diff-file-heading                   (:weight 'bold))
  (magit-diff-file-heading-highlight         (:inherit ('magit-section-highlight)))
  (magit-diff-file-heading-selection         (:foreground vegetative-medium :inherit 'magit-diff-file-heading-highlight))
  (magit-diff-hunk-header                    (:foreground vegetative-neutral-teal))
  (magit-diff-hunk-heading                   (:foreground vegetative-neutral-purple :background vegetative-background-1))
  (magit-diff-hunk-heading-highlight         (:foreground vegetative-neutral-purple :background vegetative-background-3))
  (magit-diff-hunk-heading-selection         (:foreground vegetative-medium :inherit 'magit-diff-hunk-heading-highlight))
  (magit-diff-hunk-region                    (:inherit 'bold))
  (magit-diff-lines-boundary                 (:inherit 'magit-diff-lines-heading))
  (magit-diff-lines-heading                  (:foreground vegetative-identifiers-4 :background vegetative-background-2 :inherit 'magit-diff-hunk-heading-highlight))
  (magit-diff-merge-current                  (:background vegetative-background-yellow))
  (magit-diff-merge-diff3-separator          (:foreground vegetative-neutral-orange :weight 'bold))
  (magit-diff-merge-proposed                 (:background vegetative-background-green))
  (magit-diff-merge-separator                (:foreground vegetative-neutral-orange))
  (magit-diff-none                           (:foreground vegetative-medium))
  (magit-diff-our                            (:inherit 'magit-diff-removed))
  (magit-diff-our-highlight                  (:inherit 'magit-diff-removed-highlight))
  (magit-diff-removed                        (:foreground vegetative-bright-red :background vegetative-background-red))
  (magit-diff-removed-highlight              (:foreground vegetative-bright-red :background vegetative-background-red))
  (magit-diff-their                          (:inherit 'magit-diff-added))
  (magit-diff-their-highlight                (:inherit 'magit-diff-added-highlight))
  (magit-diff-whitespace-warning             (:inherit 'trailing-whitespace))
  (magit-diffstat-added                      (:foreground vegetative-delimiter-3))
  (magit-diffstat-removed                    (:foreground vegetative-background-2))
  (magit-dimmed                              (:foreground vegetative-muted-purple))
  (magit-filename                            (:weight 'normal))
  (magit-hash                                (:foreground vegetative-background-3))
  (magit-head                                (:inherit 'magit-branch-local))
  (magit-header-line                         (:inherit 'magit-section-heading))
  (magit-item-highlight                      (:background vegetative-background-1 :weight 'normal))
  (magit-item-mark                           (:background vegetative-background-0))
  (magit-key-mode-args-face                  (:foreground vegetative-foreground-4))
  (magit-key-mode-button-face                (:foreground vegetative-neutral-orange :weight 'bold))
  (magit-key-mode-header-face                (:foreground vegetative-foreground-4 :weight 'bold))
  (magit-key-mode-switch-face                (:foreground vegetative-accent-6 :weight 'bold))
  (magit-log-author                          (:foreground vegetative-neutral-teal))
  (magit-log-date                            (:foreground vegetative-faded-orange))
  (magit-log-graph                           (:foreground vegetative-foreground-1))
  (magit-log-head-label-bisect-bad           (:foreground vegetative-bright-red))
  (magit-log-head-label-bisect-good          (:foreground vegetative-bright-green))
  (magit-log-head-label-bisect-skip          (:foreground vegetative-neutral-yellow))
  (magit-log-head-label-default              (:foreground vegetative-neutral-blue))
  (magit-log-head-label-head                 (:foreground vegetative-foreground-0 :background vegetative-background-teal))
  (magit-log-head-label-local                (:foreground vegetative-faded-blue :weight 'bold))
  (magit-log-head-label-patches              (:foreground vegetative-faded-orange))
  (magit-log-head-label-remote               (:foreground vegetative-neutral-blue :weight 'bold))
  (magit-log-head-label-tags                 (:foreground vegetative-neutral-teal))
  (magit-log-head-label-wip                  (:foreground vegetative-neutral-red))
  (magit-log-message                         (:foreground vegetative-foreground-1))
  (magit-log-reflog-label-amend              (:foreground vegetative-bright-blue))
  (magit-log-reflog-label-checkout           (:foreground vegetative-bright-yellow))
  (magit-log-reflog-label-cherry-pick        (:foreground vegetative-neutral-red))
  (magit-log-reflog-label-commit             (:foreground vegetative-neutral-green))
  (magit-log-reflog-label-merge              (:foreground vegetative-bright-green))
  (magit-log-reflog-label-other              (:foreground vegetative-faded-red))
  (magit-log-reflog-label-rebase             (:foreground vegetative-bright-blue))
  (magit-log-reflog-label-remote             (:foreground vegetative-neutral-orange))
  (magit-log-reflog-label-reset              (:foreground vegetative-neutral-yellow))
  (magit-log-sha1                            (:foreground vegetative-bright-orange))
  (magit-popup-argument                      (:inherit 'font-lock-warning-face))
  (magit-popup-disabled-argument             (:foreground vegetative-foreground-4))
  (magit-popup-heading                       (:inherit 'font-lock-keyword-face))
  (magit-popup-key                           (:inherit 'font-lock-builtin-face))
  (magit-popup-option-value                  (:inherit 'font-lock-string-face))
  (magit-process-ng                          (:foreground vegetative-bright-red :weight 'bold))
  (magit-process-ok                          (:foreground vegetative-bright-green :weight 'bold))
  (magit-reflog-amend                        (:foreground vegetative-identifiers-13))
  (magit-reflog-checkout                     (:foreground vegetative-mid-cyan))
  (magit-reflog-cherry-pick                  (:foreground vegetative-black))
  (magit-reflog-commit                       (:foreground vegetative-black))
  (magit-reflog-merge                        (:foreground vegetative-black))
  (magit-reflog-other                        (:foreground vegetative-neutral-cyan))
  (magit-reflog-rebase                       (:foreground vegetative-identifiers-13))
  (magit-reflog-remote                       (:foreground vegetative-neutral-cyan))
  (magit-reflog-reset                        (:foreground vegetative-faded-red))
  (magit-refname                             (:foreground vegetative-foreground-2))
  (magit-refname-stash                       (:inherit 'magit-refname))
  (magit-refname-wip                         (:inherit 'magit-refname))
  (magit-section-heading                     (:foreground vegetative-foreground-2 :background vegetative-background-blue))
  (magit-section-heading-selection           (:foreground vegetative-medium))
  (magit-section-highlight                   (:background vegetative-background-0-soft))
  (magit-section-secondary-heading           (:weight 'bold))
  (magit-sequence-done                       (:inherit 'magit-hash))
  (magit-sequence-drop                       (:foreground vegetative-faded-red))
  (magit-sequence-head                       (:foreground vegetative-faded-cyan))
  (magit-sequence-onto                       (:inherit 'magit-sequence-done))
  (magit-sequence-part                       (:foreground vegetative-bright-yellow))
  (magit-sequence-pick                       (:inherit 'default))
  (magit-sequence-stop                       (:foreground vegetative-bright-teal))
  (magit-signature-bad                       (:foreground vegetative-bright-red :weight 'bold))
  (magit-signature-error                     (:foreground vegetative-muted-red))
  (magit-signature-expired                   (:foreground vegetative-bright-red))
  (magit-signature-expired-key               (:inherit 'magit-signature-expired))
  (magit-signature-good                      (:foreground vegetative-bright-green :weight 'bold))
  (magit-signature-none                      (:foreground vegetative-faded-red))
  (magit-signature-revoked                   (:foreground vegetative-foreground-3))
  (magit-signature-untrusted                 (:foreground vegetative-bright-purple :weight 'bold))
  (magit-tag                                 (:foreground vegetative-accent-2))
  (magit-whitespace-warning-face             (:background vegetative-faded-red))
  (markdown-header-face-1                    (:height 1.9 :inherit 'variable-pitch :foreground vegetative-foreground-4))
  (markdown-header-face-2                    (:height 1.8 :inherit 'variable-pitch :foreground vegetative-foreground-3))
  (markdown-header-face-3                    (:height 1.6 :inherit 'variable-pitch :foreground vegetative-foreground-2))
  (markdown-header-face-4                    (:height 1.5 :inherit 'variable-pitch :foreground vegetative-foreground-1))
  (markdown-header-face-5                    (:height 1.4 :inherit 'variable-pitch :foreground vegetative-foreground-0-soft))
  (markdown-header-face-6                    (:height 1.3 :inherit 'variable-pitch :foreground vegetative-foreground-0))
  (match                                     (:foreground vegetative-foreground-0 :background vegetative-background-2))
  (mc/cursor-bar-face                        (:height 1 :background vegetative-black))
  (mc/cursor-face                            (:inverse-video t))
  (mc/region-face                            (:inherit 'region))
  (menu nil)
  (message-cited-text                        (:foreground vegetative-foreground-3))
  (message-header-cc                         (:foreground vegetative-bright-cyan))
  (message-header-name                       (:foreground vegetative-bright-cyan))
  (message-header-newsgroups                 (:foreground vegetative-bright-cyan))
  (message-header-other                      (:foreground vegetative-muted-cyan))
  (message-header-subject                    (:foreground vegetative-foreground-2))
  (message-header-to                         (:foreground vegetative-bright-cyan))
  (message-header-xheader                    (:foreground vegetative-faded-cyan))
  (message-mml                               (:foreground vegetative-faded-teal))
  (message-separator                         (:foreground vegetative-faded-cyan))
  (minibuffer-complete-cycle                 (:inherit 'secondary-selection))
  (minibuffer-prompt                         (:foreground vegetative-accent-1 :background vegetative-background-0 :bold nil))
  (mm-command-output                         (:foreground vegetative-mid-teal))
  (mode-line                                 (:foreground vegetative-foreground-1 :background vegetative-background-0-hard :box nil))
  (mode-line-buffer-id                       (:weight 'bold))
  (mode-line-emphasis                        (:weight 'bold))
  (mode-line-highlight                       (:box (:line-width 2 :color vegetative-background-3 :style 'released-button)))
  (mode-line-inactive                        (:foreground vegetative-foreground-4 :background vegetative-background-2 :box nil))
  (mouse nil)
  (nameless-face                             (:inherit 'font-lock-type-face))
  (next-error                                (:inherit 'region))
  (nobreak-space                             (:underline t :inherit 'escape-glyph))
  (orderless-match-face-0                    (:foreground vegetative-accent-1))
  (orderless-match-face-1                    (:foreground vegetative-accent-2))
  (orderless-match-face-2                    (:foreground vegetative-accent-3))
  (orderless-match-face-3                    (:foreground vegetative-accent-4))
  (org-agenda-date-today                     (:foreground vegetative-foreground-2 :slant 'italic :weight 'bold))
  (org-agenda-structure                      (:inherit 'font-lock-comment-face))
  (org-archived                              (:foreground vegetative-foreground-0 :weight 'bold))
  (org-checkbox                              (:foreground vegetative-foreground-2 :background vegetative-background-0 :box (:line-width 1 :style 'released-button)))
  (org-column                                (:background vegetative-background-0))
  (org-column-title                          (:background vegetative-background-0-hard :underline t :weight 'bold))
  (org-date                                  (:foreground vegetative-faded-blue :underline t))
  (org-deadline-announce                     (:foreground vegetative-faded-red))
  (org-done                                  (:foreground vegetative-bright-green :bold t :weight 'bold))
  (org-ellipsis                              (:foreground vegetative-bright-yellow :underline t))
  (org-footnote                              (:foreground vegetative-faded-teal :underline t))
  (org-formula                               (:foreground vegetative-bright-yellow))
  (org-headline-done                         (:foreground vegetative-bright-green))
  (org-hide                                  (:foreground vegetative-background-0))
  (org-level-1                               (:foreground vegetative-bright-orange))
  (org-level-2                               (:foreground vegetative-bright-green))
  (org-level-3                               (:foreground vegetative-bright-blue))
  (org-level-4                               (:foreground vegetative-bright-yellow))
  (org-level-5                               (:foreground vegetative-faded-teal))
  (org-level-6                               (:foreground vegetative-bright-green))
  (org-level-7                               (:foreground vegetative-bright-red))
  (org-level-8                               (:foreground vegetative-bright-blue))
  (org-link                                  (:foreground vegetative-bright-yellow :underline t))
  (org-mode-line-clock                       (:foreground vegetative-foreground-2 :background vegetative-background-0))
  (org-mode-line-clock-overrun               (:foreground vegetative-black :background vegetative-bright-red))
  (org-scheduled                             (:foreground vegetative-bright-green))
  (org-scheduled-previously                  (:foreground vegetative-bright-red))
  (org-scheduled-today                       (:foreground vegetative-bright-blue))
  (org-sexp-date                             (:foreground vegetative-bright-blue :underline t))
  (org-special-keyword                       (:inherit 'font-lock-comment-face))
  (org-table                                 (:foreground vegetative-bright-green))
  (org-tag                                   (:bold t :weight 'bold))
  (org-time-grid                             (:foreground vegetative-bright-orange))
  (org-todo                                  (:foreground vegetative-bright-red :weight 'bold :bold t))
  (org-upcoming-deadline                     (:inherit 'font-lock-keyword-face))
  (org-warning                               (:foreground vegetative-bright-red :weight 'bold :underline nil :bold t))
  (package-description                       (:inherit 'default))
  (package-help-section-name                 (:inherit ('bold 'font-lock-function-name-face)))
  (package-name                              (:inherit 'link))
  (package-status-avail-obso                 (:inherit 'package-status-incompat))
  (package-status-available                  (:inherit 'default))
  (package-status-built-in                   (:inherit 'font-lock-builtin-face))
  (package-status-dependency                 (:inherit 'package-status-installed))
  (package-status-disabled                   (:inherit 'font-lock-warning-face))
  (package-status-external                   (:inherit 'package-status-built-in))
  (package-status-held                       (:inherit 'font-lock-constant-face))
  (package-status-incompat                   (:inherit 'font-lock-comment-face))
  (package-status-installed                  (:inherit 'font-lock-comment-face))
  (package-status-new                        (:inherit ('bold 'package-status-available)))
  (package-status-unsigned                   (:inherit 'font-lock-warning-face))
  (popup-face                                (:foreground vegetative-foreground-0 :background vegetative-background-1))
  (popup-isearch-match                       (:background vegetative-background-green :inherit 'default))
  (popup-menu-face                           (:inherit 'popup-face))
  (popup-menu-mouse-face                     (:foreground vegetative-foreground-0 :background vegetative-faded-blue))
  (popup-menu-selection-face                 (:foreground vegetative-foreground-0 :background vegetative-faded-blue))
  (popup-menu-summary-face                   (:inherit 'popup-summary-face))
  (popup-scroll-bar-background-face          (:background vegetative-neutral-purple))
  (popup-scroll-bar-foreground-face          (:background vegetative-black))
  (popup-summary-face                        (:foreground vegetative-background-4 :inherit 'popup-face))
  (popup-tip-face                            (:foreground vegetative-foreground-0-hard :background vegetative-background-teal))
  (powerline-active1                         (:background vegetative-background-2 :inherit 'mode-line))
  (powerline-active2                         (:background vegetative-background-1 :inherit 'mode-line))
  (powerline-inactive1                       (:background vegetative-medium :inherit 'mode-line-inactive))
  (powerline-inactive2                       (:background vegetative-background-2 :inherit 'mode-line-inactive))
  (query-replace                             (:inherit 'isearch))
  (rainbow-delimiters-depth-1-face           (:foreground vegetative-delimiter-1))
  (rainbow-delimiters-depth-10-face          (:foreground vegetative-delimiter-2))
  (rainbow-delimiters-depth-11-face          (:foreground vegetative-delimiter-3))
  (rainbow-delimiters-depth-12-face          (:foreground vegetative-delimiter-4))
  (rainbow-delimiters-depth-2-face           (:foreground vegetative-delimiter-2))
  (rainbow-delimiters-depth-3-face           (:foreground vegetative-delimiter-3))
  (rainbow-delimiters-depth-4-face           (:foreground vegetative-delimiter-4))
  (rainbow-delimiters-depth-5-face           (:foreground vegetative-delimiter-1))
  (rainbow-delimiters-depth-6-face           (:foreground vegetative-delimiter-2))
  (rainbow-delimiters-depth-7-face           (:foreground vegetative-delimiter-3))
  (rainbow-delimiters-depth-8-face           (:foreground vegetative-delimiter-4))
  (rainbow-delimiters-depth-9-face           (:foreground vegetative-delimiter-1))
  (rainbow-delimiters-mismatched-face        (:inherit 'rainbow-delimiters-unmatched-face))
  (rainbow-delimiters-unmatched-face         (:foreground vegetative-foreground-0 :background nil))
  (rainbow-identifiers-identifier-1          (:foreground vegetative-identifiers-1))
  (rainbow-identifiers-identifier-10         (:foreground vegetative-identifiers-10))
  (rainbow-identifiers-identifier-11         (:foreground vegetative-identifiers-11))
  (rainbow-identifiers-identifier-12         (:foreground vegetative-identifiers-12))
  (rainbow-identifiers-identifier-13         (:foreground vegetative-identifiers-13))
  (rainbow-identifiers-identifier-14         (:foreground vegetative-identifiers-14))
  (rainbow-identifiers-identifier-15         (:foreground vegetative-identifiers-15))
  (rainbow-identifiers-identifier-2          (:foreground vegetative-identifiers-2))
  (rainbow-identifiers-identifier-3          (:foreground vegetative-identifiers-3))
  (rainbow-identifiers-identifier-4          (:foreground vegetative-identifiers-4))
  (rainbow-identifiers-identifier-5          (:foreground vegetative-identifiers-5))
  (rainbow-identifiers-identifier-6          (:foreground vegetative-identifiers-6))
  (rainbow-identifiers-identifier-7          (:foreground vegetative-identifiers-7))
  (rainbow-identifiers-identifier-8          (:foreground vegetative-identifiers-8))
  (rainbow-identifiers-identifier-9          (:foreground vegetative-identifiers-9))
  (rectangle-preview                         (:inherit 'region))
  (region                                    (:background vegetative-background-2 :distant-foreground vegetative-foreground-0))
  (ripgrep-hit-face                          (:inherit 'ag-hit-face))
  (ripgrep-match-face                        (:inherit 'ag-match-face))
  (scroll-bar nil)
  (secondary-selection                       (:background vegetative-background-3))
  (semantic-highlight-edits-face             (:background vegetative-background-0-soft))
  (semantic-highlight-func-current-tag-face  (:background vegetative-background-0-soft))
  (semantic-unmatched-syntax-face            (:underline vegetative-faded-red))
  (sgml-namespace                            (:inherit 'font-lock-builtin-face))
  (sh-heredoc                                (:foreground vegetative-accent-2 :background nil))
  (sh-quoted-exec                            (:foreground vegetative-accent-2 :background nil))
  (shadow                                    (:foreground vegetative-neutral-purple))
  (show-paren-match                          (:foreground vegetative-medium :background vegetative-background-3))
  (show-paren-mismatch                       (:foreground vegetative-bright-red :background vegetative-background-3))
  (shr-link                                  (:inherit 'link))
  (shr-strike-through                        (:strike-through t))
  (smerge-base                               (:background vegetative-medium))
  (smerge-markers                            (:background vegetative-background-0-soft))
  (smerge-mine                               (:background vegetative-background-2))
  (smerge-other                              (:background vegetative-background-1))
  (smerge-refined-added                      (:background vegetative-background-green))
  (smerge-refined-changed nil)
  (smerge-refined-removed                    (:background vegetative-background-red))
  (sml/charging                              (:foreground vegetative-faded-teal))
  (sml/col-number                            (:foreground vegetative-neutral-orange))
  (sml/discharging                           (:foreground vegetative-faded-teal :weight 'bold))
  (sml/filename                              (:foreground vegetative-foreground-0-hard :weight 'bold :bold t))
  (sml/git                                   (:inherit 'sml/prefix))
  (sml/minor-modes                           (:foreground vegetative-neutral-orange))
  (sml/modes                                 (:foreground vegetative-foreground-0-hard :weight 'bold :bold t))
  (sml/modified                              (:foreground vegetative-neutral-blue))
  (sml/outside-modified                      (:foreground vegetative-neutral-blue))
  (sml/position-percentage                   (:foreground vegetative-faded-teal))
  (sml/prefix                                (:foreground vegetative-neutral-blue))
  (sml/process                               (:inherit 'sml/prefix))
  (sml/read-only                             (:foreground vegetative-neutral-blue))
  (sml/sudo                                  (:foreground vegetative-background-orange :weight 'bold))
  (sml/vc                                    (:foreground vegetative-faded-green))
  (sml/vc-edited                             (:foreground vegetative-bright-green))
  (sp-pair-overlay-face                      (:background vegetative-background-2))
  (sp-show-pair-enclosing                    (:inherit 'highlight))
  (sp-show-pair-match-face                   (:background vegetative-background-2))
  (sp-show-pair-mismatch-face                (:background vegetative-bright-red))
  (sp-wrap-overlay-closing-pair              (:foreground vegetative-faded-red :inherit 'sp-wrap-overlay-face))
  (sp-wrap-overlay-face                      (:inherit 'sp-pair-overlay-face))
  (sp-wrap-overlay-opening-pair              (:foreground vegetative-black :inherit 'sp-wrap-overlay-face))
  (sp-wrap-tag-overlay-face                  (:inherit 'sp-pair-overlay-face))
  (spaceline-evil-emacs                      (:background vegetative-bright-red :foreground vegetative-background-0))
  (spaceline-evil-insert                     (:background vegetative-bright-yellow :foreground vegetative-background-0))
  (spaceline-evil-motion                     (:background vegetative-bright-green :foreground vegetative-background-0))
  (spaceline-evil-normal                     (:background vegetative-bright-blue :foreground vegetative-background-0))
  (spaceline-evil-replace                    (:background vegetative-bright-orange :foreground vegetative-background-0))
  (spaceline-evil-visual                     (:background vegetative-bright-purple :foreground vegetative-background-0))
  (stripe-highlight                          (:background vegetative-background-0-hard))
  (success                                   (:foreground vegetative-bright-green :bold t))
  (swiper-line-face                          (:inherit 'highlight))
  (swiper-match-face-1                       (:inherit 'isearch-lazy-highlight-face))
  (swiper-match-face-2                       (:inherit 'isearch))
  (swiper-match-face-3                       (:inherit 'match))
  (swiper-match-face-4                       (:inherit 'isearch-fail))
  (term-color-black                          (:foreground vegetative-background-1))
  (term-color-blue                           (:foreground vegetative-neutral-blue))
  (term-color-cyan                           (:foreground vegetative-neutral-cyan))
  (term-color-green                          (:foreground vegetative-neutral-green))
  (term-color-magenta                        (:foreground vegetative-neutral-purple))
  (term-color-red                            (:foreground vegetative-neutral-red))
  (term-color-white                          (:foreground vegetative-foreground-1))
  (term-color-yellow                         (:foreground vegetative-neutral-yellow))
  (term-default-bg-color                     (:background vegetative-background-0))
  (term-default-fg-color                     (:foreground vegetative-foreground-0))
  (tool-bar                                  (:box (:line-width 1 :style 'released-button) :foreground vegetative-black :background vegetative-neutral-purple))
  (tooltip                                   (:foreground vegetative-black :background vegetative-foreground-0-hard :inherit 'variable-pitch))
  (trailing-whitespace                       (:background vegetative-faded-red))
  (tty-menu-disabled-face                    (:foreground vegetative-identifiers-1 :background vegetative-mid-cyan))
  (tty-menu-enabled-face                     (:weight 'bold :foreground vegetative-foreground-0-hard :background vegetative-mid-cyan))
  (tty-menu-selected-face                    (:background vegetative-faded-red))
  (underline                                 (:underline t))
  (variable-pitch                            (:family "Sans Serif"))
  (vc-conflict-state                         (:inherit 'vc-state-base))
  (vc-edited-state                           (:inherit 'vc-state-base))
  (vc-locally-added-state                    (:inherit 'vc-state-base))
  (vc-locked-state                           (:inherit 'vc-state-base))
  (vc-missing-state                          (:inherit 'vc-state-base))
  (vc-needs-update-state                     (:inherit 'vc-state-base))
  (vc-removed-state                          (:inherit 'vc-state-base))
  (vc-state-base nil)
  (vc-up-to-date-state                       (:inherit 'vc-state-base))
  (vertical-border                           (:foreground vegetative-background-2))
  (vertico-posframe                          (:background vegetative-background-0-hard))
  (vertico-posframe-border                   (:background vegetative-background-0-hard))
  (vertico-posframe-border-2                 (:background vegetative-background-0))
  (vertico-posframe-border-3                 (:background vegetative-background-1))
  (vertico-posframe-border-4                 (:background vegetative-background-2))
  (vline                                     (:background vegetative-background-teal))
  (vline-visual                              (:background vegetative-background-teal))
  (w3m-haddock-heading-face                  (:inherit 'highlight))
  (warning                                   (:foreground vegetative-bright-red :bold t))
  (web-mode-doctype-face                     (:foreground vegetative-foreground-2 :weight 'bold))
  (web-mode-html-attr-equal-face             (:inherit 'default))
  (web-mode-html-attr-name-face              (:inherit 'font-lock-variable-name-face))
  (web-mode-html-tag-bracket-face            (:inherit 'default))
  (web-mode-html-tag-face                    (:foreground vegetative-foreground-3))
  (which-key-command-description-face        (:inherit 'font-lock-function-name-face))
  (which-key-group-description-face          (:inherit 'font-lock-keyword-face))
  (which-key-highlighted-command-face        (:underline t :inherit 'which-key-command-description-face))
  (which-key-key-face                        (:inherit 'font-lock-constant-face))
  (which-key-local-map-description-face      (:inherit 'which-key-command-description-face))
  (which-key-note-face                       (:inherit 'which-key-separator-face))
  (which-key-separator-face                  (:inherit 'font-lock-comment-face))
  (which-key-special-key-face                (:weight 'bold :inverse-video t :inherit 'which-key-key-face))
  (whitespace-empty                          (:foreground nil :background nil))
  (whitespace-hspace                         (:foreground vegetative-background-4 :background vegetative-background-0))
  (whitespace-indentation                    (:foreground vegetative-background-4 :background vegetative-background-0))
  (whitespace-line                           (:foreground vegetative-neutral-red :background vegetative-background-1))
  (whitespace-newline                        (:foreground vegetative-background-4 :background vegetative-background-0))
  (whitespace-space                          (:foreground vegetative-background-4 :background vegetative-background-0))
  (whitespace-space-after-tab                (:foreground vegetative-background-4 :background vegetative-background-0))
  (whitespace-space-before-tab               (:foreground vegetative-background-4 :background vegetative-background-0))
  (whitespace-tab                            (:foreground vegetative-background-4 :background vegetative-background-0))
  (whitespace-trailing                       (:foreground vegetative-neutral-red :background vegetative-background-1))
  (widget-button                             (:weight 'bold))
  (widget-button-pressed                     (:foreground vegetative-faded-red))
  (widget-documentation                      (:foreground vegetative-mid-yellow))
  (widget-field                              (:background vegetative-background-4))
  (widget-inactive                           (:inherit 'shadow))
  (widget-single-line-field                  (:background vegetative-background-4))
  (window-divider                            (:foreground vegetative-background-2))
  (window-divider-first-pixel                (:foreground vegetative-background-2))
  (window-divider-last-pixel                 (:foreground vegetative-background-2))
  (yas-field-highlight-face                  (:inherit 'region)))

 (custom-theme-set-variables 'vegetative
                             `(pos-tip-foreground-color ,vegetative-foreground-0-hard)
                             `(pos-tip-background-color ,vegetative-background-teal)
                             `(ansi-color-names-vector [,vegetative-background-1
                                                        ,vegetative-bright-red
                                                        ,vegetative-bright-green
                                                        ,vegetative-bright-yellow
                                                        ,vegetative-bright-blue
                                                        ,vegetative-bright-purple
                                                        ,vegetative-bright-cyan
                                                        ,vegetative-foreground-1])))

;;;###autoload
(and load-file-name
     (boundp 'custom-theme-load-path)
     (add-to-list 'custom-theme-load-path
                  (file-name-as-directory
                   (file-name-directory load-file-name))))

(provide-theme 'vegetative)

;; Local Variables:
;; eval: (when (fboundp 'rainbow-mode) (rainbow-mode 1))
;; End:

;;; vegetative-theme.el ends here.
