;;; ucs-utils-6.0-delta.el --- Unicode 5.2 to 6.0 delta
;;
;; Copyright (c) 2012-2015 Roland Walker
;;
;; Author: Roland Walker <walker@pobox.com>
;; Homepage: http://github.com/rolandwalker/ucs-utils
;; URL: http://raw.githubusercontent.com/rolandwalker/ucs-utils/master/ucs-utils-6.0-delta.el
;; Last-Updated: 12 Aug 2015
;; EmacsWiki: UcsUtils
;; Keywords: i18n, extensions
;;
;; Simplified BSD License
;;
;;; Commentary:
;;
;; This library is automatically loaded by ucs-utils.el for Emacs 23.x,
;; so that characters added in Unicode 6.0 may be recognized.
;;
;; If loaded manually, this file must be loaded after ucs-utils.el.
;;
;; This library is not required for Emacs 24.1 and above.
;;
;; See Also
;;
;;     M-x customize-group RET ucs-utils RET
;;
;; Notes
;;
;; Bugs
;;
;; TODO
;;
;;; License
;;
;; Simplified BSD License:
;;
;; Redistribution and use in source and binary forms, with or
;; without modification, are permitted provided that the following
;; conditions are met:
;;
;;   1. Redistributions of source code must retain the above
;;      copyright notice, this list of conditions and the following
;;      disclaimer.
;;
;;   2. Redistributions in binary form must reproduce the above
;;      copyright notice, this list of conditions and the following
;;      disclaimer in the documentation and/or other materials
;;      provided with the distribution.
;;
;; This software is provided by Roland Walker "AS IS" and any express
;; or implied warranties, including, but not limited to, the implied
;; warranties of merchantability and fitness for a particular
;; purpose are disclaimed.  In no event shall Roland Walker or
;; contributors be liable for any direct, indirect, incidental,
;; special, exemplary, or consequential damages (including, but not
;; limited to, procurement of substitute goods or services; loss of
;; use, data, or profits; or business interruption) however caused
;; and on any theory of liability, whether in contract, strict
;; liability, or tort (including negligence or otherwise) arising in
;; any way out of the use of this software, even if advised of the
;; possibility of such damage.
;;
;; The views and conclusions contained in the software and
;; documentation are those of the authors and should not be
;; interpreted as representing official policies, either expressed
;; or implied, of Roland Walker.
;;
;; No rights are claimed over data created by the Unicode
;; Consortium, which are included here under the terms of
;; the Unicode Terms of Use.
;;
;;; Code:
;;

;;; declarations

(eval-when-compile
  (defvar ucs-utils-names-corrections))

;;; supplement values from main library

(when (and (not (assoc "CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER" ucs-utils-names-corrections))
           (not (assoc "CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER" (ucs-names))))
  (nconc ucs-utils-names-corrections
         '(
           ;; Unicode 5.2 to 6.0 delta
           ("CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER"                                     .  #x0526)
           ("CYRILLIC SMALL LETTER SHHA WITH DESCENDER"                                       .  #x0527)
           ("ARABIC LETTER KASHMIRI YEH"                                                      .  #x0620)
           ("ARABIC WAVY HAMZA BELOW"                                                         .  #x065F)
           ("MANDAIC LETTER HALQA"                                                            .  #x0840)
           ("MANDAIC LETTER AB"                                                               .  #x0841)
           ("MANDAIC LETTER AG"                                                               .  #x0842)
           ("MANDAIC LETTER AD"                                                               .  #x0843)
           ("MANDAIC LETTER AH"                                                               .  #x0844)
           ("MANDAIC LETTER USHENNA"                                                          .  #x0845)
           ("MANDAIC LETTER AZ"                                                               .  #x0846)
           ("MANDAIC LETTER IT"                                                               .  #x0847)
           ("MANDAIC LETTER ATT"                                                              .  #x0848)
           ("MANDAIC LETTER AKSA"                                                             .  #x0849)
           ("MANDAIC LETTER AK"                                                               .  #x084A)
           ("MANDAIC LETTER AL"                                                               .  #x084B)
           ("MANDAIC LETTER AM"                                                               .  #x084C)
           ("MANDAIC LETTER AN"                                                               .  #x084D)
           ("MANDAIC LETTER AS"                                                               .  #x084E)
           ("MANDAIC LETTER IN"                                                               .  #x084F)
           ("MANDAIC LETTER AP"                                                               .  #x0850)
           ("MANDAIC LETTER ASZ"                                                              .  #x0851)
           ("MANDAIC LETTER AQ"                                                               .  #x0852)
           ("MANDAIC LETTER AR"                                                               .  #x0853)
           ("MANDAIC LETTER ASH"                                                              .  #x0854)
           ("MANDAIC LETTER AT"                                                               .  #x0855)
           ("MANDAIC LETTER DUSHENNA"                                                         .  #x0856)
           ("MANDAIC LETTER KAD"                                                              .  #x0857)
           ("MANDAIC LETTER AIN"                                                              .  #x0858)
           ("MANDAIC AFFRICATION MARK"                                                        .  #x0859)
           ("MANDAIC VOCALIZATION MARK"                                                       .  #x085A)
           ("MANDAIC GEMINATION MARK"                                                         .  #x085B)
           ("MANDAIC PUNCTUATION"                                                             .  #x085E)
           ("DEVANAGARI VOWEL SIGN OE"                                                        .  #x093A)
           ("DEVANAGARI VOWEL SIGN OOE"                                                       .  #x093B)
           ("DEVANAGARI VOWEL SIGN AW"                                                        .  #x094F)
           ("DEVANAGARI VOWEL SIGN UE"                                                        .  #x0956)
           ("DEVANAGARI VOWEL SIGN UUE"                                                       .  #x0957)
           ("DEVANAGARI LETTER OE"                                                            .  #x0973)
           ("DEVANAGARI LETTER OOE"                                                           .  #x0974)
           ("DEVANAGARI LETTER AW"                                                            .  #x0975)
           ("DEVANAGARI LETTER UE"                                                            .  #x0976)
           ("DEVANAGARI LETTER UUE"                                                           .  #x0977)
           ("ORIYA FRACTION ONE QUARTER"                                                      .  #x0B72)
           ("ORIYA FRACTION ONE HALF"                                                         .  #x0B73)
           ("ORIYA FRACTION THREE QUARTERS"                                                   .  #x0B74)
           ("ORIYA FRACTION ONE SIXTEENTH"                                                    .  #x0B75)
           ("ORIYA FRACTION ONE EIGHTH"                                                       .  #x0B76)
           ("ORIYA FRACTION THREE SIXTEENTHS"                                                 .  #x0B77)
           ("MALAYALAM LETTER NNNA"                                                           .  #x0D29)
           ("MALAYALAM LETTER TTTA"                                                           .  #x0D3A)
           ("MALAYALAM LETTER DOT REPH"                                                       .  #x0D4E)
           ("TIBETAN SIGN INVERTED MCHU CAN"                                                  .  #x0F8C)
           ("TIBETAN SUBJOINED SIGN LCE TSA CAN"                                              .  #x0F8D)
           ("TIBETAN SUBJOINED SIGN MCHU CAN"                                                 .  #x0F8E)
           ("TIBETAN MARK LEADING MCHAN RTAGS"                                                .  #x0FD9)
           ("TIBETAN MARK TRAILING MCHAN RTAGS"                                               .  #x0FDA)
           ("ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK"                             .  #x135D)
           ("ETHIOPIC COMBINING VOWEL LENGTH MARK"                                            .  #x135E)
           ("BATAK LETTER A"                                                                  .  #x1BC0)
           ("BATAK LETTER SIMALUNGUN A"                                                       .  #x1BC1)
           ("BATAK LETTER HA"                                                                 .  #x1BC2)
           ("BATAK LETTER SIMALUNGUN HA"                                                      .  #x1BC3)
           ("BATAK LETTER MANDAILING HA"                                                      .  #x1BC4)
           ("BATAK LETTER BA"                                                                 .  #x1BC5)
           ("BATAK LETTER KARO BA"                                                            .  #x1BC6)
           ("BATAK LETTER PA"                                                                 .  #x1BC7)
           ("BATAK LETTER SIMALUNGUN PA"                                                      .  #x1BC8)
           ("BATAK LETTER NA"                                                                 .  #x1BC9)
           ("BATAK LETTER MANDAILING NA"                                                      .  #x1BCA)
           ("BATAK LETTER WA"                                                                 .  #x1BCB)
           ("BATAK LETTER SIMALUNGUN WA"                                                      .  #x1BCC)
           ("BATAK LETTER PAKPAK WA"                                                          .  #x1BCD)
           ("BATAK LETTER GA"                                                                 .  #x1BCE)
           ("BATAK LETTER SIMALUNGUN GA"                                                      .  #x1BCF)
           ("BATAK LETTER JA"                                                                 .  #x1BD0)
           ("BATAK LETTER DA"                                                                 .  #x1BD1)
           ("BATAK LETTER RA"                                                                 .  #x1BD2)
           ("BATAK LETTER SIMALUNGUN RA"                                                      .  #x1BD3)
           ("BATAK LETTER MA"                                                                 .  #x1BD4)
           ("BATAK LETTER SIMALUNGUN MA"                                                      .  #x1BD5)
           ("BATAK LETTER SOUTHERN TA"                                                        .  #x1BD6)
           ("BATAK LETTER NORTHERN TA"                                                        .  #x1BD7)
           ("BATAK LETTER SA"                                                                 .  #x1BD8)
           ("BATAK LETTER SIMALUNGUN SA"                                                      .  #x1BD9)
           ("BATAK LETTER MANDAILING SA"                                                      .  #x1BDA)
           ("BATAK LETTER YA"                                                                 .  #x1BDB)
           ("BATAK LETTER SIMALUNGUN YA"                                                      .  #x1BDC)
           ("BATAK LETTER NGA"                                                                .  #x1BDD)
           ("BATAK LETTER LA"                                                                 .  #x1BDE)
           ("BATAK LETTER SIMALUNGUN LA"                                                      .  #x1BDF)
           ("BATAK LETTER NYA"                                                                .  #x1BE0)
           ("BATAK LETTER CA"                                                                 .  #x1BE1)
           ("BATAK LETTER NDA"                                                                .  #x1BE2)
           ("BATAK LETTER MBA"                                                                .  #x1BE3)
           ("BATAK LETTER I"                                                                  .  #x1BE4)
           ("BATAK LETTER U"                                                                  .  #x1BE5)
           ("BATAK SIGN TOMPI"                                                                .  #x1BE6)
           ("BATAK VOWEL SIGN E"                                                              .  #x1BE7)
           ("BATAK VOWEL SIGN PAKPAK E"                                                       .  #x1BE8)
           ("BATAK VOWEL SIGN EE"                                                             .  #x1BE9)
           ("BATAK VOWEL SIGN I"                                                              .  #x1BEA)
           ("BATAK VOWEL SIGN KARO I"                                                         .  #x1BEB)
           ("BATAK VOWEL SIGN O"                                                              .  #x1BEC)
           ("BATAK VOWEL SIGN KARO O"                                                         .  #x1BED)
           ("BATAK VOWEL SIGN U"                                                              .  #x1BEE)
           ("BATAK VOWEL SIGN U FOR SIMALUNGUN SA"                                            .  #x1BEF)
           ("BATAK CONSONANT SIGN NG"                                                         .  #x1BF0)
           ("BATAK CONSONANT SIGN H"                                                          .  #x1BF1)
           ("BATAK PANGOLAT"                                                                  .  #x1BF2)
           ("BATAK PANONGONAN"                                                                .  #x1BF3)
           ("BATAK SYMBOL BINDU NA METEK"                                                     .  #x1BFC)
           ("BATAK SYMBOL BINDU PINARBORAS"                                                   .  #x1BFD)
           ("BATAK SYMBOL BINDU JUDUL"                                                        .  #x1BFE)
           ("BATAK SYMBOL BINDU PANGOLAT"                                                     .  #x1BFF)
           ("COMBINING DOUBLE INVERTED BREVE BELOW"                                           .  #x1DFC)
           ("LATIN SUBSCRIPT SMALL LETTER H"                                                  .  #x2095)
           ("LATIN SUBSCRIPT SMALL LETTER K"                                                  .  #x2096)
           ("LATIN SUBSCRIPT SMALL LETTER L"                                                  .  #x2097)
           ("LATIN SUBSCRIPT SMALL LETTER M"                                                  .  #x2098)
           ("LATIN SUBSCRIPT SMALL LETTER N"                                                  .  #x2099)
           ("LATIN SUBSCRIPT SMALL LETTER P"                                                  .  #x209A)
           ("LATIN SUBSCRIPT SMALL LETTER S"                                                  .  #x209B)
           ("LATIN SUBSCRIPT SMALL LETTER T"                                                  .  #x209C)
           ("INDIAN RUPEE SIGN"                                                               .  #x20B9)
           ("BLACK RIGHT-POINTING DOUBLE TRIANGLE"                                            .  #x23E9)
           ("BLACK LEFT-POINTING DOUBLE TRIANGLE"                                             .  #x23EA)
           ("BLACK UP-POINTING DOUBLE TRIANGLE"                                               .  #x23EB)
           ("BLACK DOWN-POINTING DOUBLE TRIANGLE"                                             .  #x23EC)
           ("BLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR"                          .  #x23ED)
           ("BLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR"                           .  #x23EE)
           ("BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR"                          .  #x23EF)
           ("ALARM CLOCK"                                                                     .  #x23F0)
           ("STOPWATCH"                                                                       .  #x23F1)
           ("TIMER CLOCK"                                                                     .  #x23F2)
           ("HOURGLASS WITH FLOWING SAND"                                                     .  #x23F3)
           ("OPHIUCHUS"                                                                       .  #x26CE)
           ("ASTRONOMICAL SYMBOL FOR URANUS"                                                  .  #x26E2)
           ("PENTAGRAM"                                                                       .  #x26E4)
           ("RIGHT-HANDED INTERLACED PENTAGRAM"                                               .  #x26E5)
           ("LEFT-HANDED INTERLACED PENTAGRAM"                                                .  #x26E6)
           ("INVERTED PENTAGRAM"                                                              .  #x26E7)
           ("WHITE HEAVY CHECK MARK"                                                          .  #x2705)
           ("RAISED FIST"                                                                     .  #x270A)
           ("RAISED HAND"                                                                     .  #x270B)
           ("SPARKLES"                                                                        .  #x2728)
           ("CROSS MARK"                                                                      .  #x274C)
           ("NEGATIVE SQUARED CROSS MARK"                                                     .  #x274E)
           ("BLACK QUESTION MARK ORNAMENT"                                                    .  #x2753)
           ("WHITE QUESTION MARK ORNAMENT"                                                    .  #x2754)
           ("WHITE EXCLAMATION MARK ORNAMENT"                                                 .  #x2755)
           ("HEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENT"                                  .  #x275F)
           ("HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT"                                  .  #x2760)
           ("HEAVY PLUS SIGN"                                                                 .  #x2795)
           ("HEAVY MINUS SIGN"                                                                .  #x2796)
           ("HEAVY DIVISION SIGN"                                                             .  #x2797)
           ("CURLY LOOP"                                                                      .  #x27B0)
           ("DOUBLE CURLY LOOP"                                                               .  #x27BF)
           ("SQUARED LOGICAL AND"                                                             .  #x27CE)
           ("SQUARED LOGICAL OR"                                                              .  #x27CF)
           ("TIFINAGH SEPARATOR MARK"                                                         .  #x2D70)
           ("TIFINAGH CONSONANT JOINER"                                                       .  #x2D7F)
           ("BOPOMOFO LETTER GH"                                                              .  #x31B8)
           ("BOPOMOFO LETTER LH"                                                              .  #x31B9)
           ("BOPOMOFO LETTER ZY"                                                              .  #x31BA)
           ("CYRILLIC CAPITAL LETTER REVERSED TSE"                                            .  #xA660)
           ("CYRILLIC SMALL LETTER REVERSED TSE"                                              .  #xA661)
           ("LATIN CAPITAL LETTER TURNED H"                                                   .  #xA78D)
           ("LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT"                               .  #xA78E)
           ("LATIN CAPITAL LETTER N WITH DESCENDER"                                           .  #xA790)
           ("LATIN SMALL LETTER N WITH DESCENDER"                                             .  #xA791)
           ("LATIN CAPITAL LETTER G WITH OBLIQUE STROKE"                                      .  #xA7A0)
           ("LATIN SMALL LETTER G WITH OBLIQUE STROKE"                                        .  #xA7A1)
           ("LATIN CAPITAL LETTER K WITH OBLIQUE STROKE"                                      .  #xA7A2)
           ("LATIN SMALL LETTER K WITH OBLIQUE STROKE"                                        .  #xA7A3)
           ("LATIN CAPITAL LETTER N WITH OBLIQUE STROKE"                                      .  #xA7A4)
           ("LATIN SMALL LETTER N WITH OBLIQUE STROKE"                                        .  #xA7A5)
           ("LATIN CAPITAL LETTER R WITH OBLIQUE STROKE"                                      .  #xA7A6)
           ("LATIN SMALL LETTER R WITH OBLIQUE STROKE"                                        .  #xA7A7)
           ("LATIN CAPITAL LETTER S WITH OBLIQUE STROKE"                                      .  #xA7A8)
           ("LATIN SMALL LETTER S WITH OBLIQUE STROKE"                                        .  #xA7A9)
           ("LATIN LETTER SMALL CAPITAL TURNED M"                                             .  #xA7FA)
           ("ETHIOPIC SYLLABLE TTHU"                                                          .  #xAB01)
           ("ETHIOPIC SYLLABLE TTHI"                                                          .  #xAB02)
           ("ETHIOPIC SYLLABLE TTHAA"                                                         .  #xAB03)
           ("ETHIOPIC SYLLABLE TTHEE"                                                         .  #xAB04)
           ("ETHIOPIC SYLLABLE TTHE"                                                          .  #xAB05)
           ("ETHIOPIC SYLLABLE TTHO"                                                          .  #xAB06)
           ("ETHIOPIC SYLLABLE DDHU"                                                          .  #xAB09)
           ("ETHIOPIC SYLLABLE DDHI"                                                          .  #xAB0A)
           ("ETHIOPIC SYLLABLE DDHAA"                                                         .  #xAB0B)
           ("ETHIOPIC SYLLABLE DDHEE"                                                         .  #xAB0C)
           ("ETHIOPIC SYLLABLE DDHE"                                                          .  #xAB0D)
           ("ETHIOPIC SYLLABLE DDHO"                                                          .  #xAB0E)
           ("ETHIOPIC SYLLABLE DZU"                                                           .  #xAB11)
           ("ETHIOPIC SYLLABLE DZI"                                                           .  #xAB12)
           ("ETHIOPIC SYLLABLE DZAA"                                                          .  #xAB13)
           ("ETHIOPIC SYLLABLE DZEE"                                                          .  #xAB14)
           ("ETHIOPIC SYLLABLE DZE"                                                           .  #xAB15)
           ("ETHIOPIC SYLLABLE DZO"                                                           .  #xAB16)
           ("ETHIOPIC SYLLABLE CCHHA"                                                         .  #xAB20)
           ("ETHIOPIC SYLLABLE CCHHU"                                                         .  #xAB21)
           ("ETHIOPIC SYLLABLE CCHHI"                                                         .  #xAB22)
           ("ETHIOPIC SYLLABLE CCHHAA"                                                        .  #xAB23)
           ("ETHIOPIC SYLLABLE CCHHEE"                                                        .  #xAB24)
           ("ETHIOPIC SYLLABLE CCHHE"                                                         .  #xAB25)
           ("ETHIOPIC SYLLABLE CCHHO"                                                         .  #xAB26)
           ("ETHIOPIC SYLLABLE BBA"                                                           .  #xAB28)
           ("ETHIOPIC SYLLABLE BBU"                                                           .  #xAB29)
           ("ETHIOPIC SYLLABLE BBI"                                                           .  #xAB2A)
           ("ETHIOPIC SYLLABLE BBAA"                                                          .  #xAB2B)
           ("ETHIOPIC SYLLABLE BBEE"                                                          .  #xAB2C)
           ("ETHIOPIC SYLLABLE BBE"                                                           .  #xAB2D)
           ("ETHIOPIC SYLLABLE BBO"                                                           .  #xAB2E)
           ("ARABIC SYMBOL DOT ABOVE"                                                         .  #xFBB2)
           ("ARABIC SYMBOL DOT BELOW"                                                         .  #xFBB3)
           ("ARABIC SYMBOL TWO DOTS ABOVE"                                                    .  #xFBB4)
           ("ARABIC SYMBOL TWO DOTS BELOW"                                                    .  #xFBB5)
           ("ARABIC SYMBOL THREE DOTS ABOVE"                                                  .  #xFBB6)
           ("ARABIC SYMBOL THREE DOTS BELOW"                                                  .  #xFBB7)
           ("ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVE"                               .  #xFBB8)
           ("ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS BELOW"                               .  #xFBB9)
           ("ARABIC SYMBOL FOUR DOTS ABOVE"                                                   .  #xFBBA)
           ("ARABIC SYMBOL FOUR DOTS BELOW"                                                   .  #xFBBB)
           ("ARABIC SYMBOL DOUBLE VERTICAL BAR BELOW"                                         .  #xFBBC)
           ("ARABIC SYMBOL TWO DOTS VERTICALLY ABOVE"                                         .  #xFBBD)
           ("ARABIC SYMBOL TWO DOTS VERTICALLY BELOW"                                         .  #xFBBE)
           ("ARABIC SYMBOL RING"                                                              .  #xFBBF)
           ("ARABIC SYMBOL SMALL TAH ABOVE"                                                   .  #xFBC0)
           ("ARABIC SYMBOL SMALL TAH BELOW"                                                   .  #xFBC1)
           ("BRAHMI SIGN CANDRABINDU"                                                         .  #x11000)
           ("BRAHMI SIGN ANUSVARA"                                                            .  #x11001)
           ("BRAHMI SIGN VISARGA"                                                             .  #x11002)
           ("BRAHMI SIGN JIHVAMULIYA"                                                         .  #x11003)
           ("BRAHMI SIGN UPADHMANIYA"                                                         .  #x11004)
           ("BRAHMI LETTER A"                                                                 .  #x11005)
           ("BRAHMI LETTER AA"                                                                .  #x11006)
           ("BRAHMI LETTER I"                                                                 .  #x11007)
           ("BRAHMI LETTER II"                                                                .  #x11008)
           ("BRAHMI LETTER U"                                                                 .  #x11009)
           ("BRAHMI LETTER UU"                                                                .  #x1100A)
           ("BRAHMI LETTER VOCALIC R"                                                         .  #x1100B)
           ("BRAHMI LETTER VOCALIC RR"                                                        .  #x1100C)
           ("BRAHMI LETTER VOCALIC L"                                                         .  #x1100D)
           ("BRAHMI LETTER VOCALIC LL"                                                        .  #x1100E)
           ("BRAHMI LETTER E"                                                                 .  #x1100F)
           ("BRAHMI LETTER AI"                                                                .  #x11010)
           ("BRAHMI LETTER O"                                                                 .  #x11011)
           ("BRAHMI LETTER AU"                                                                .  #x11012)
           ("BRAHMI LETTER KA"                                                                .  #x11013)
           ("BRAHMI LETTER KHA"                                                               .  #x11014)
           ("BRAHMI LETTER GA"                                                                .  #x11015)
           ("BRAHMI LETTER GHA"                                                               .  #x11016)
           ("BRAHMI LETTER NGA"                                                               .  #x11017)
           ("BRAHMI LETTER CA"                                                                .  #x11018)
           ("BRAHMI LETTER CHA"                                                               .  #x11019)
           ("BRAHMI LETTER JA"                                                                .  #x1101A)
           ("BRAHMI LETTER JHA"                                                               .  #x1101B)
           ("BRAHMI LETTER NYA"                                                               .  #x1101C)
           ("BRAHMI LETTER TTA"                                                               .  #x1101D)
           ("BRAHMI LETTER TTHA"                                                              .  #x1101E)
           ("BRAHMI LETTER DDA"                                                               .  #x1101F)
           ("BRAHMI LETTER DDHA"                                                              .  #x11020)
           ("BRAHMI LETTER NNA"                                                               .  #x11021)
           ("BRAHMI LETTER TA"                                                                .  #x11022)
           ("BRAHMI LETTER THA"                                                               .  #x11023)
           ("BRAHMI LETTER DA"                                                                .  #x11024)
           ("BRAHMI LETTER DHA"                                                               .  #x11025)
           ("BRAHMI LETTER NA"                                                                .  #x11026)
           ("BRAHMI LETTER PA"                                                                .  #x11027)
           ("BRAHMI LETTER PHA"                                                               .  #x11028)
           ("BRAHMI LETTER BA"                                                                .  #x11029)
           ("BRAHMI LETTER BHA"                                                               .  #x1102A)
           ("BRAHMI LETTER MA"                                                                .  #x1102B)
           ("BRAHMI LETTER YA"                                                                .  #x1102C)
           ("BRAHMI LETTER RA"                                                                .  #x1102D)
           ("BRAHMI LETTER LA"                                                                .  #x1102E)
           ("BRAHMI LETTER VA"                                                                .  #x1102F)
           ("BRAHMI LETTER SHA"                                                               .  #x11030)
           ("BRAHMI LETTER SSA"                                                               .  #x11031)
           ("BRAHMI LETTER SA"                                                                .  #x11032)
           ("BRAHMI LETTER HA"                                                                .  #x11033)
           ("BRAHMI LETTER LLA"                                                               .  #x11034)
           ("BRAHMI LETTER OLD TAMIL LLLA"                                                    .  #x11035)
           ("BRAHMI LETTER OLD TAMIL RRA"                                                     .  #x11036)
           ("BRAHMI LETTER OLD TAMIL NNNA"                                                    .  #x11037)
           ("BRAHMI VOWEL SIGN AA"                                                            .  #x11038)
           ("BRAHMI VOWEL SIGN BHATTIPROLU AA"                                                .  #x11039)
           ("BRAHMI VOWEL SIGN I"                                                             .  #x1103A)
           ("BRAHMI VOWEL SIGN II"                                                            .  #x1103B)
           ("BRAHMI VOWEL SIGN U"                                                             .  #x1103C)
           ("BRAHMI VOWEL SIGN UU"                                                            .  #x1103D)
           ("BRAHMI VOWEL SIGN VOCALIC R"                                                     .  #x1103E)
           ("BRAHMI VOWEL SIGN VOCALIC RR"                                                    .  #x1103F)
           ("BRAHMI VOWEL SIGN VOCALIC L"                                                     .  #x11040)
           ("BRAHMI VOWEL SIGN VOCALIC LL"                                                    .  #x11041)
           ("BRAHMI VOWEL SIGN E"                                                             .  #x11042)
           ("BRAHMI VOWEL SIGN AI"                                                            .  #x11043)
           ("BRAHMI VOWEL SIGN O"                                                             .  #x11044)
           ("BRAHMI VOWEL SIGN AU"                                                            .  #x11045)
           ("BRAHMI VIRAMA"                                                                   .  #x11046)
           ("BRAHMI DANDA"                                                                    .  #x11047)
           ("BRAHMI DOUBLE DANDA"                                                             .  #x11048)
           ("BRAHMI PUNCTUATION DOT"                                                          .  #x11049)
           ("BRAHMI PUNCTUATION DOUBLE DOT"                                                   .  #x1104A)
           ("BRAHMI PUNCTUATION LINE"                                                         .  #x1104B)
           ("BRAHMI PUNCTUATION CRESCENT BAR"                                                 .  #x1104C)
           ("BRAHMI PUNCTUATION LOTUS"                                                        .  #x1104D)
           ("BRAHMI NUMBER ONE"                                                               .  #x11052)
           ("BRAHMI NUMBER TWO"                                                               .  #x11053)
           ("BRAHMI NUMBER THREE"                                                             .  #x11054)
           ("BRAHMI NUMBER FOUR"                                                              .  #x11055)
           ("BRAHMI NUMBER FIVE"                                                              .  #x11056)
           ("BRAHMI NUMBER SIX"                                                               .  #x11057)
           ("BRAHMI NUMBER SEVEN"                                                             .  #x11058)
           ("BRAHMI NUMBER EIGHT"                                                             .  #x11059)
           ("BRAHMI NUMBER NINE"                                                              .  #x1105A)
           ("BRAHMI NUMBER TEN"                                                               .  #x1105B)
           ("BRAHMI NUMBER TWENTY"                                                            .  #x1105C)
           ("BRAHMI NUMBER THIRTY"                                                            .  #x1105D)
           ("BRAHMI NUMBER FORTY"                                                             .  #x1105E)
           ("BRAHMI NUMBER FIFTY"                                                             .  #x1105F)
           ("BRAHMI NUMBER SIXTY"                                                             .  #x11060)
           ("BRAHMI NUMBER SEVENTY"                                                           .  #x11061)
           ("BRAHMI NUMBER EIGHTY"                                                            .  #x11062)
           ("BRAHMI NUMBER NINETY"                                                            .  #x11063)
           ("BRAHMI NUMBER ONE HUNDRED"                                                       .  #x11064)
           ("BRAHMI NUMBER ONE THOUSAND"                                                      .  #x11065)
           ("BRAHMI DIGIT ZERO"                                                               .  #x11066)
           ("BRAHMI DIGIT ONE"                                                                .  #x11067)
           ("BRAHMI DIGIT TWO"                                                                .  #x11068)
           ("BRAHMI DIGIT THREE"                                                              .  #x11069)
           ("BRAHMI DIGIT FOUR"                                                               .  #x1106A)
           ("BRAHMI DIGIT FIVE"                                                               .  #x1106B)
           ("BRAHMI DIGIT SIX"                                                                .  #x1106C)
           ("BRAHMI DIGIT SEVEN"                                                              .  #x1106D)
           ("BRAHMI DIGIT EIGHT"                                                              .  #x1106E)
           ("BRAHMI DIGIT NINE"                                                               .  #x1106F)
           ("BAMUM LETTER PHASE-A NGKUE MFON"                                                 .  #x16800)
           ("BAMUM LETTER PHASE-A GBIEE FON"                                                  .  #x16801)
           ("BAMUM LETTER PHASE-A PON MFON PIPAEMGBIEE"                                       .  #x16802)
           ("BAMUM LETTER PHASE-A PON MFON PIPAEMBA"                                          .  #x16803)
           ("BAMUM LETTER PHASE-A NAA MFON"                                                   .  #x16804)
           ("BAMUM LETTER PHASE-A SHUENSHUET"                                                 .  #x16805)
           ("BAMUM LETTER PHASE-A TITA MFON"                                                  .  #x16806)
           ("BAMUM LETTER PHASE-A NZA MFON"                                                   .  #x16807)
           ("BAMUM LETTER PHASE-A SHINDA PA NJI"                                              .  #x16808)
           ("BAMUM LETTER PHASE-A PON PA NJI PIPAEMGBIEE"                                     .  #x16809)
           ("BAMUM LETTER PHASE-A PON PA NJI PIPAEMBA"                                        .  #x1680A)
           ("BAMUM LETTER PHASE-A MAEMBGBIEE"                                                 .  #x1680B)
           ("BAMUM LETTER PHASE-A TU MAEMBA"                                                  .  #x1680C)
           ("BAMUM LETTER PHASE-A NGANGU"                                                     .  #x1680D)
           ("BAMUM LETTER PHASE-A MAEMVEUX"                                                   .  #x1680E)
           ("BAMUM LETTER PHASE-A MANSUAE"                                                    .  #x1680F)
           ("BAMUM LETTER PHASE-A MVEUAENGAM"                                                 .  #x16810)
           ("BAMUM LETTER PHASE-A SEUNYAM"                                                    .  #x16811)
           ("BAMUM LETTER PHASE-A NTOQPEN"                                                    .  #x16812)
           ("BAMUM LETTER PHASE-A KEUKEUTNDA"                                                 .  #x16813)
           ("BAMUM LETTER PHASE-A NKINDI"                                                     .  #x16814)
           ("BAMUM LETTER PHASE-A SUU"                                                        .  #x16815)
           ("BAMUM LETTER PHASE-A NGKUENZEUM"                                                 .  #x16816)
           ("BAMUM LETTER PHASE-A LAPAQ"                                                      .  #x16817)
           ("BAMUM LETTER PHASE-A LET KUT"                                                    .  #x16818)
           ("BAMUM LETTER PHASE-A NTAP MFAA"                                                  .  #x16819)
           ("BAMUM LETTER PHASE-A MAEKEUP"                                                    .  #x1681A)
           ("BAMUM LETTER PHASE-A PASHAE"                                                     .  #x1681B)
           ("BAMUM LETTER PHASE-A GHEUAERAE"                                                  .  #x1681C)
           ("BAMUM LETTER PHASE-A PAMSHAE"                                                    .  #x1681D)
           ("BAMUM LETTER PHASE-A MON NGGEUAET"                                               .  #x1681E)
           ("BAMUM LETTER PHASE-A NZUN MEUT"                                                  .  #x1681F)
           ("BAMUM LETTER PHASE-A U YUQ NAE"                                                  .  #x16820)
           ("BAMUM LETTER PHASE-A GHEUAEGHEUAE"                                               .  #x16821)
           ("BAMUM LETTER PHASE-A NTAP NTAA"                                                  .  #x16822)
           ("BAMUM LETTER PHASE-A SISA"                                                       .  #x16823)
           ("BAMUM LETTER PHASE-A MGBASA"                                                     .  #x16824)
           ("BAMUM LETTER PHASE-A MEUNJOMNDEUQ"                                               .  #x16825)
           ("BAMUM LETTER PHASE-A MOOMPUQ"                                                    .  #x16826)
           ("BAMUM LETTER PHASE-A KAFA"                                                       .  #x16827)
           ("BAMUM LETTER PHASE-A PA LEERAEWA"                                                .  #x16828)
           ("BAMUM LETTER PHASE-A NDA LEERAEWA"                                               .  #x16829)
           ("BAMUM LETTER PHASE-A PET"                                                        .  #x1682A)
           ("BAMUM LETTER PHASE-A MAEMKPEN"                                                   .  #x1682B)
           ("BAMUM LETTER PHASE-A NIKA"                                                       .  #x1682C)
           ("BAMUM LETTER PHASE-A PUP"                                                        .  #x1682D)
           ("BAMUM LETTER PHASE-A TUAEP"                                                      .  #x1682E)
           ("BAMUM LETTER PHASE-A LUAEP"                                                      .  #x1682F)
           ("BAMUM LETTER PHASE-A SONJAM"                                                     .  #x16830)
           ("BAMUM LETTER PHASE-A TEUTEUWEN"                                                  .  #x16831)
           ("BAMUM LETTER PHASE-A MAENYI"                                                     .  #x16832)
           ("BAMUM LETTER PHASE-A KET"                                                        .  #x16833)
           ("BAMUM LETTER PHASE-A NDAANGGEUAET"                                               .  #x16834)
           ("BAMUM LETTER PHASE-A KUOQ"                                                       .  #x16835)
           ("BAMUM LETTER PHASE-A MOOMEUT"                                                    .  #x16836)
           ("BAMUM LETTER PHASE-A SHUM"                                                       .  #x16837)
           ("BAMUM LETTER PHASE-A LOMMAE"                                                     .  #x16838)
           ("BAMUM LETTER PHASE-A FIRI"                                                       .  #x16839)
           ("BAMUM LETTER PHASE-A ROM"                                                        .  #x1683A)
           ("BAMUM LETTER PHASE-A KPOQ"                                                       .  #x1683B)
           ("BAMUM LETTER PHASE-A SOQ"                                                        .  #x1683C)
           ("BAMUM LETTER PHASE-A MAP PIEET"                                                  .  #x1683D)
           ("BAMUM LETTER PHASE-A SHIRAE"                                                     .  #x1683E)
           ("BAMUM LETTER PHASE-A NTAP"                                                       .  #x1683F)
           ("BAMUM LETTER PHASE-A SHOQ NSHUT YUM"                                             .  #x16840)
           ("BAMUM LETTER PHASE-A NYIT MONGKEUAEQ"                                            .  #x16841)
           ("BAMUM LETTER PHASE-A PAARAE"                                                     .  #x16842)
           ("BAMUM LETTER PHASE-A NKAARAE"                                                    .  #x16843)
           ("BAMUM LETTER PHASE-A UNKNOWN"                                                    .  #x16844)
           ("BAMUM LETTER PHASE-A NGGEN"                                                      .  #x16845)
           ("BAMUM LETTER PHASE-A MAESI"                                                      .  #x16846)
           ("BAMUM LETTER PHASE-A NJAM"                                                       .  #x16847)
           ("BAMUM LETTER PHASE-A MBANYI"                                                     .  #x16848)
           ("BAMUM LETTER PHASE-A NYET"                                                       .  #x16849)
           ("BAMUM LETTER PHASE-A TEUAEN"                                                     .  #x1684A)
           ("BAMUM LETTER PHASE-A SOT"                                                        .  #x1684B)
           ("BAMUM LETTER PHASE-A PAAM"                                                       .  #x1684C)
           ("BAMUM LETTER PHASE-A NSHIEE"                                                     .  #x1684D)
           ("BAMUM LETTER PHASE-A MAEM"                                                       .  #x1684E)
           ("BAMUM LETTER PHASE-A NYI"                                                        .  #x1684F)
           ("BAMUM LETTER PHASE-A KAQ"                                                        .  #x16850)
           ("BAMUM LETTER PHASE-A NSHA"                                                       .  #x16851)
           ("BAMUM LETTER PHASE-A VEE"                                                        .  #x16852)
           ("BAMUM LETTER PHASE-A LU"                                                         .  #x16853)
           ("BAMUM LETTER PHASE-A NEN"                                                        .  #x16854)
           ("BAMUM LETTER PHASE-A NAQ"                                                        .  #x16855)
           ("BAMUM LETTER PHASE-A MBAQ"                                                       .  #x16856)
           ("BAMUM LETTER PHASE-B NSHUET"                                                     .  #x16857)
           ("BAMUM LETTER PHASE-B TU MAEMGBIEE"                                               .  #x16858)
           ("BAMUM LETTER PHASE-B SIEE"                                                       .  #x16859)
           ("BAMUM LETTER PHASE-B SET TU"                                                     .  #x1685A)
           ("BAMUM LETTER PHASE-B LOM NTEUM"                                                  .  #x1685B)
           ("BAMUM LETTER PHASE-B MBA MAELEE"                                                 .  #x1685C)
           ("BAMUM LETTER PHASE-B KIEEM"                                                      .  #x1685D)
           ("BAMUM LETTER PHASE-B YEURAE"                                                     .  #x1685E)
           ("BAMUM LETTER PHASE-B MBAARAE"                                                    .  #x1685F)
           ("BAMUM LETTER PHASE-B KAM"                                                        .  #x16860)
           ("BAMUM LETTER PHASE-B PEESHI"                                                     .  #x16861)
           ("BAMUM LETTER PHASE-B YAFU LEERAEWA"                                              .  #x16862)
           ("BAMUM LETTER PHASE-B LAM NSHUT NYAM"                                             .  #x16863)
           ("BAMUM LETTER PHASE-B NTIEE SHEUOQ"                                               .  #x16864)
           ("BAMUM LETTER PHASE-B NDU NJAA"                                                   .  #x16865)
           ("BAMUM LETTER PHASE-B GHEUGHEUAEM"                                                .  #x16866)
           ("BAMUM LETTER PHASE-B PIT"                                                        .  #x16867)
           ("BAMUM LETTER PHASE-B TU NSIEE"                                                   .  #x16868)
           ("BAMUM LETTER PHASE-B SHET NJAQ"                                                  .  #x16869)
           ("BAMUM LETTER PHASE-B SHEUAEQTU"                                                  .  #x1686A)
           ("BAMUM LETTER PHASE-B MFON TEUAEQ"                                                .  #x1686B)
           ("BAMUM LETTER PHASE-B MBIT MBAAKET"                                               .  #x1686C)
           ("BAMUM LETTER PHASE-B NYI NTEUM"                                                  .  #x1686D)
           ("BAMUM LETTER PHASE-B KEUPUQ"                                                     .  #x1686E)
           ("BAMUM LETTER PHASE-B GHEUGHEN"                                                   .  #x1686F)
           ("BAMUM LETTER PHASE-B KEUYEUX"                                                    .  #x16870)
           ("BAMUM LETTER PHASE-B LAANAE"                                                     .  #x16871)
           ("BAMUM LETTER PHASE-B PARUM"                                                      .  #x16872)
           ("BAMUM LETTER PHASE-B VEUM"                                                       .  #x16873)
           ("BAMUM LETTER PHASE-B NGKINDI MVOP"                                               .  #x16874)
           ("BAMUM LETTER PHASE-B NGGEU MBU"                                                  .  #x16875)
           ("BAMUM LETTER PHASE-B WUAET"                                                      .  #x16876)
           ("BAMUM LETTER PHASE-B SAKEUAE"                                                    .  #x16877)
           ("BAMUM LETTER PHASE-B TAAM"                                                       .  #x16878)
           ("BAMUM LETTER PHASE-B MEUQ"                                                       .  #x16879)
           ("BAMUM LETTER PHASE-B NGGUOQ"                                                     .  #x1687A)
           ("BAMUM LETTER PHASE-B NGGUOQ LARGE"                                               .  #x1687B)
           ("BAMUM LETTER PHASE-B MFIYAQ"                                                     .  #x1687C)
           ("BAMUM LETTER PHASE-B SUE"                                                        .  #x1687D)
           ("BAMUM LETTER PHASE-B MBEURI"                                                     .  #x1687E)
           ("BAMUM LETTER PHASE-B MONTIEEN"                                                   .  #x1687F)
           ("BAMUM LETTER PHASE-B NYAEMAE"                                                    .  #x16880)
           ("BAMUM LETTER PHASE-B PUNGAAM"                                                    .  #x16881)
           ("BAMUM LETTER PHASE-B MEUT NGGEET"                                                .  #x16882)
           ("BAMUM LETTER PHASE-B FEUX"                                                       .  #x16883)
           ("BAMUM LETTER PHASE-B MBUOQ"                                                      .  #x16884)
           ("BAMUM LETTER PHASE-B FEE"                                                        .  #x16885)
           ("BAMUM LETTER PHASE-B KEUAEM"                                                     .  #x16886)
           ("BAMUM LETTER PHASE-B MA NJEUAENA"                                                .  #x16887)
           ("BAMUM LETTER PHASE-B MA NJUQA"                                                   .  #x16888)
           ("BAMUM LETTER PHASE-B LET"                                                        .  #x16889)
           ("BAMUM LETTER PHASE-B NGGAAM"                                                     .  #x1688A)
           ("BAMUM LETTER PHASE-B NSEN"                                                       .  #x1688B)
           ("BAMUM LETTER PHASE-B MA"                                                         .  #x1688C)
           ("BAMUM LETTER PHASE-B KIQ"                                                        .  #x1688D)
           ("BAMUM LETTER PHASE-B NGOM"                                                       .  #x1688E)
           ("BAMUM LETTER PHASE-C NGKUE MAEMBA"                                               .  #x1688F)
           ("BAMUM LETTER PHASE-C NZA"                                                        .  #x16890)
           ("BAMUM LETTER PHASE-C YUM"                                                        .  #x16891)
           ("BAMUM LETTER PHASE-C WANGKUOQ"                                                   .  #x16892)
           ("BAMUM LETTER PHASE-C NGGEN"                                                      .  #x16893)
           ("BAMUM LETTER PHASE-C NDEUAEREE"                                                  .  #x16894)
           ("BAMUM LETTER PHASE-C NGKAQ"                                                      .  #x16895)
           ("BAMUM LETTER PHASE-C GHARAE"                                                     .  #x16896)
           ("BAMUM LETTER PHASE-C MBEEKEET"                                                   .  #x16897)
           ("BAMUM LETTER PHASE-C GBAYI"                                                      .  #x16898)
           ("BAMUM LETTER PHASE-C NYIR MKPARAQ MEUN"                                          .  #x16899)
           ("BAMUM LETTER PHASE-C NTU MBIT"                                                   .  #x1689A)
           ("BAMUM LETTER PHASE-C MBEUM"                                                      .  #x1689B)
           ("BAMUM LETTER PHASE-C PIRIEEN"                                                    .  #x1689C)
           ("BAMUM LETTER PHASE-C NDOMBU"                                                     .  #x1689D)
           ("BAMUM LETTER PHASE-C MBAA CABBAGE-TREE"                                          .  #x1689E)
           ("BAMUM LETTER PHASE-C KEUSHEUAEP"                                                 .  #x1689F)
           ("BAMUM LETTER PHASE-C GHAP"                                                       .  #x168A0)
           ("BAMUM LETTER PHASE-C KEUKAQ"                                                     .  #x168A1)
           ("BAMUM LETTER PHASE-C YU MUOMAE"                                                  .  #x168A2)
           ("BAMUM LETTER PHASE-C NZEUM"                                                      .  #x168A3)
           ("BAMUM LETTER PHASE-C MBUE"                                                       .  #x168A4)
           ("BAMUM LETTER PHASE-C NSEUAEN"                                                    .  #x168A5)
           ("BAMUM LETTER PHASE-C MBIT"                                                       .  #x168A6)
           ("BAMUM LETTER PHASE-C YEUQ"                                                       .  #x168A7)
           ("BAMUM LETTER PHASE-C KPARAQ"                                                     .  #x168A8)
           ("BAMUM LETTER PHASE-C KAA"                                                        .  #x168A9)
           ("BAMUM LETTER PHASE-C SEUX"                                                       .  #x168AA)
           ("BAMUM LETTER PHASE-C NDIDA"                                                      .  #x168AB)
           ("BAMUM LETTER PHASE-C TAASHAE"                                                    .  #x168AC)
           ("BAMUM LETTER PHASE-C NJUEQ"                                                      .  #x168AD)
           ("BAMUM LETTER PHASE-C TITA YUE"                                                   .  #x168AE)
           ("BAMUM LETTER PHASE-C SUAET"                                                      .  #x168AF)
           ("BAMUM LETTER PHASE-C NGGUAEN NYAM"                                               .  #x168B0)
           ("BAMUM LETTER PHASE-C VEUX"                                                       .  #x168B1)
           ("BAMUM LETTER PHASE-C NANSANAQ"                                                   .  #x168B2)
           ("BAMUM LETTER PHASE-C MA KEUAERI"                                                 .  #x168B3)
           ("BAMUM LETTER PHASE-C NTAA"                                                       .  #x168B4)
           ("BAMUM LETTER PHASE-C NGGUON"                                                     .  #x168B5)
           ("BAMUM LETTER PHASE-C LAP"                                                        .  #x168B6)
           ("BAMUM LETTER PHASE-C MBIRIEEN"                                                   .  #x168B7)
           ("BAMUM LETTER PHASE-C MGBASAQ"                                                    .  #x168B8)
           ("BAMUM LETTER PHASE-C NTEUNGBA"                                                   .  #x168B9)
           ("BAMUM LETTER PHASE-C TEUTEUX"                                                    .  #x168BA)
           ("BAMUM LETTER PHASE-C NGGUM"                                                      .  #x168BB)
           ("BAMUM LETTER PHASE-C FUE"                                                        .  #x168BC)
           ("BAMUM LETTER PHASE-C NDEUT"                                                      .  #x168BD)
           ("BAMUM LETTER PHASE-C NSA"                                                        .  #x168BE)
           ("BAMUM LETTER PHASE-C NSHAQ"                                                      .  #x168BF)
           ("BAMUM LETTER PHASE-C BUNG"                                                       .  #x168C0)
           ("BAMUM LETTER PHASE-C VEUAEPEN"                                                   .  #x168C1)
           ("BAMUM LETTER PHASE-C MBERAE"                                                     .  #x168C2)
           ("BAMUM LETTER PHASE-C RU"                                                         .  #x168C3)
           ("BAMUM LETTER PHASE-C NJAEM"                                                      .  #x168C4)
           ("BAMUM LETTER PHASE-C LAM"                                                        .  #x168C5)
           ("BAMUM LETTER PHASE-C TITUAEP"                                                    .  #x168C6)
           ("BAMUM LETTER PHASE-C NSUOT NGOM"                                                 .  #x168C7)
           ("BAMUM LETTER PHASE-C NJEEEE"                                                     .  #x168C8)
           ("BAMUM LETTER PHASE-C KET"                                                        .  #x168C9)
           ("BAMUM LETTER PHASE-C NGGU"                                                       .  #x168CA)
           ("BAMUM LETTER PHASE-C MAESI"                                                      .  #x168CB)
           ("BAMUM LETTER PHASE-C MBUAEM"                                                     .  #x168CC)
           ("BAMUM LETTER PHASE-C LU"                                                         .  #x168CD)
           ("BAMUM LETTER PHASE-C KUT"                                                        .  #x168CE)
           ("BAMUM LETTER PHASE-C NJAM"                                                       .  #x168CF)
           ("BAMUM LETTER PHASE-C NGOM"                                                       .  #x168D0)
           ("BAMUM LETTER PHASE-C WUP"                                                        .  #x168D1)
           ("BAMUM LETTER PHASE-C NGGUEET"                                                    .  #x168D2)
           ("BAMUM LETTER PHASE-C NSOM"                                                       .  #x168D3)
           ("BAMUM LETTER PHASE-C NTEN"                                                       .  #x168D4)
           ("BAMUM LETTER PHASE-C KUOP NKAARAE"                                               .  #x168D5)
           ("BAMUM LETTER PHASE-C NSUN"                                                       .  #x168D6)
           ("BAMUM LETTER PHASE-C NDAM"                                                       .  #x168D7)
           ("BAMUM LETTER PHASE-C MA NSIEE"                                                   .  #x168D8)
           ("BAMUM LETTER PHASE-C YAA"                                                        .  #x168D9)
           ("BAMUM LETTER PHASE-C NDAP"                                                       .  #x168DA)
           ("BAMUM LETTER PHASE-C SHUEQ"                                                      .  #x168DB)
           ("BAMUM LETTER PHASE-C SETFON"                                                     .  #x168DC)
           ("BAMUM LETTER PHASE-C MBI"                                                        .  #x168DD)
           ("BAMUM LETTER PHASE-C MAEMBA"                                                     .  #x168DE)
           ("BAMUM LETTER PHASE-C MBANYI"                                                     .  #x168DF)
           ("BAMUM LETTER PHASE-C KEUSEUX"                                                    .  #x168E0)
           ("BAMUM LETTER PHASE-C MBEUX"                                                      .  #x168E1)
           ("BAMUM LETTER PHASE-C KEUM"                                                       .  #x168E2)
           ("BAMUM LETTER PHASE-C MBAA PICKET"                                                .  #x168E3)
           ("BAMUM LETTER PHASE-C YUWOQ"                                                      .  #x168E4)
           ("BAMUM LETTER PHASE-C NJEUX"                                                      .  #x168E5)
           ("BAMUM LETTER PHASE-C MIEE"                                                       .  #x168E6)
           ("BAMUM LETTER PHASE-C MUAE"                                                       .  #x168E7)
           ("BAMUM LETTER PHASE-C SHIQ"                                                       .  #x168E8)
           ("BAMUM LETTER PHASE-C KEN LAW"                                                    .  #x168E9)
           ("BAMUM LETTER PHASE-C KEN FATIGUE"                                                .  #x168EA)
           ("BAMUM LETTER PHASE-C NGAQ"                                                       .  #x168EB)
           ("BAMUM LETTER PHASE-C NAQ"                                                        .  #x168EC)
           ("BAMUM LETTER PHASE-C LIQ"                                                        .  #x168ED)
           ("BAMUM LETTER PHASE-C PIN"                                                        .  #x168EE)
           ("BAMUM LETTER PHASE-C PEN"                                                        .  #x168EF)
           ("BAMUM LETTER PHASE-C TET"                                                        .  #x168F0)
           ("BAMUM LETTER PHASE-D MBUO"                                                       .  #x168F1)
           ("BAMUM LETTER PHASE-D WAP"                                                        .  #x168F2)
           ("BAMUM LETTER PHASE-D NJI"                                                        .  #x168F3)
           ("BAMUM LETTER PHASE-D MFON"                                                       .  #x168F4)
           ("BAMUM LETTER PHASE-D NJIEE"                                                      .  #x168F5)
           ("BAMUM LETTER PHASE-D LIEE"                                                       .  #x168F6)
           ("BAMUM LETTER PHASE-D NJEUT"                                                      .  #x168F7)
           ("BAMUM LETTER PHASE-D NSHEE"                                                      .  #x168F8)
           ("BAMUM LETTER PHASE-D NGGAAMAE"                                                   .  #x168F9)
           ("BAMUM LETTER PHASE-D NYAM"                                                       .  #x168FA)
           ("BAMUM LETTER PHASE-D WUAEN"                                                      .  #x168FB)
           ("BAMUM LETTER PHASE-D NGKUN"                                                      .  #x168FC)
           ("BAMUM LETTER PHASE-D SHEE"                                                       .  #x168FD)
           ("BAMUM LETTER PHASE-D NGKAP"                                                      .  #x168FE)
           ("BAMUM LETTER PHASE-D KEUAETMEUN"                                                 .  #x168FF)
           ("BAMUM LETTER PHASE-D TEUT"                                                       .  #x16900)
           ("BAMUM LETTER PHASE-D SHEUAE"                                                     .  #x16901)
           ("BAMUM LETTER PHASE-D NJAP"                                                       .  #x16902)
           ("BAMUM LETTER PHASE-D SUE"                                                        .  #x16903)
           ("BAMUM LETTER PHASE-D KET"                                                        .  #x16904)
           ("BAMUM LETTER PHASE-D YAEMMAE"                                                    .  #x16905)
           ("BAMUM LETTER PHASE-D KUOM"                                                       .  #x16906)
           ("BAMUM LETTER PHASE-D SAP"                                                        .  #x16907)
           ("BAMUM LETTER PHASE-D MFEUT"                                                      .  #x16908)
           ("BAMUM LETTER PHASE-D NDEUX"                                                      .  #x16909)
           ("BAMUM LETTER PHASE-D MALEERI"                                                    .  #x1690A)
           ("BAMUM LETTER PHASE-D MEUT"                                                       .  #x1690B)
           ("BAMUM LETTER PHASE-D SEUAEQ"                                                     .  #x1690C)
           ("BAMUM LETTER PHASE-D YEN"                                                        .  #x1690D)
           ("BAMUM LETTER PHASE-D NJEUAEM"                                                    .  #x1690E)
           ("BAMUM LETTER PHASE-D KEUOT MBUAE"                                                .  #x1690F)
           ("BAMUM LETTER PHASE-D NGKEURI"                                                    .  #x16910)
           ("BAMUM LETTER PHASE-D TU"                                                         .  #x16911)
           ("BAMUM LETTER PHASE-D GHAA"                                                       .  #x16912)
           ("BAMUM LETTER PHASE-D NGKYEE"                                                     .  #x16913)
           ("BAMUM LETTER PHASE-D FEUFEUAET"                                                  .  #x16914)
           ("BAMUM LETTER PHASE-D NDEE"                                                       .  #x16915)
           ("BAMUM LETTER PHASE-D MGBOFUM"                                                    .  #x16916)
           ("BAMUM LETTER PHASE-D LEUAEP"                                                     .  #x16917)
           ("BAMUM LETTER PHASE-D NDON"                                                       .  #x16918)
           ("BAMUM LETTER PHASE-D MONI"                                                       .  #x16919)
           ("BAMUM LETTER PHASE-D MGBEUN"                                                     .  #x1691A)
           ("BAMUM LETTER PHASE-D PUUT"                                                       .  #x1691B)
           ("BAMUM LETTER PHASE-D MGBIEE"                                                     .  #x1691C)
           ("BAMUM LETTER PHASE-D MFO"                                                        .  #x1691D)
           ("BAMUM LETTER PHASE-D LUM"                                                        .  #x1691E)
           ("BAMUM LETTER PHASE-D NSIEEP"                                                     .  #x1691F)
           ("BAMUM LETTER PHASE-D MBAA"                                                       .  #x16920)
           ("BAMUM LETTER PHASE-D KWAET"                                                      .  #x16921)
           ("BAMUM LETTER PHASE-D NYET"                                                       .  #x16922)
           ("BAMUM LETTER PHASE-D TEUAEN"                                                     .  #x16923)
           ("BAMUM LETTER PHASE-D SOT"                                                        .  #x16924)
           ("BAMUM LETTER PHASE-D YUWOQ"                                                      .  #x16925)
           ("BAMUM LETTER PHASE-D KEUM"                                                       .  #x16926)
           ("BAMUM LETTER PHASE-D RAEM"                                                       .  #x16927)
           ("BAMUM LETTER PHASE-D TEEEE"                                                      .  #x16928)
           ("BAMUM LETTER PHASE-D NGKEUAEQ"                                                   .  #x16929)
           ("BAMUM LETTER PHASE-D MFEUAE"                                                     .  #x1692A)
           ("BAMUM LETTER PHASE-D NSIEET"                                                     .  #x1692B)
           ("BAMUM LETTER PHASE-D KEUP"                                                       .  #x1692C)
           ("BAMUM LETTER PHASE-D PIP"                                                        .  #x1692D)
           ("BAMUM LETTER PHASE-D PEUTAE"                                                     .  #x1692E)
           ("BAMUM LETTER PHASE-D NYUE"                                                       .  #x1692F)
           ("BAMUM LETTER PHASE-D LET"                                                        .  #x16930)
           ("BAMUM LETTER PHASE-D NGGAAM"                                                     .  #x16931)
           ("BAMUM LETTER PHASE-D MFIEE"                                                      .  #x16932)
           ("BAMUM LETTER PHASE-D NGGWAEN"                                                    .  #x16933)
           ("BAMUM LETTER PHASE-D YUOM"                                                       .  #x16934)
           ("BAMUM LETTER PHASE-D PAP"                                                        .  #x16935)
           ("BAMUM LETTER PHASE-D YUOP"                                                       .  #x16936)
           ("BAMUM LETTER PHASE-D NDAM"                                                       .  #x16937)
           ("BAMUM LETTER PHASE-D NTEUM"                                                      .  #x16938)
           ("BAMUM LETTER PHASE-D SUAE"                                                       .  #x16939)
           ("BAMUM LETTER PHASE-D KUN"                                                        .  #x1693A)
           ("BAMUM LETTER PHASE-D NGGEUX"                                                     .  #x1693B)
           ("BAMUM LETTER PHASE-D NGKIEE"                                                     .  #x1693C)
           ("BAMUM LETTER PHASE-D TUOT"                                                       .  #x1693D)
           ("BAMUM LETTER PHASE-D MEUN"                                                       .  #x1693E)
           ("BAMUM LETTER PHASE-D KUQ"                                                        .  #x1693F)
           ("BAMUM LETTER PHASE-D NSUM"                                                       .  #x16940)
           ("BAMUM LETTER PHASE-D TEUN"                                                       .  #x16941)
           ("BAMUM LETTER PHASE-D MAENJET"                                                    .  #x16942)
           ("BAMUM LETTER PHASE-D NGGAP"                                                      .  #x16943)
           ("BAMUM LETTER PHASE-D LEUM"                                                       .  #x16944)
           ("BAMUM LETTER PHASE-D NGGUOM"                                                     .  #x16945)
           ("BAMUM LETTER PHASE-D NSHUT"                                                      .  #x16946)
           ("BAMUM LETTER PHASE-D NJUEQ"                                                      .  #x16947)
           ("BAMUM LETTER PHASE-D GHEUAE"                                                     .  #x16948)
           ("BAMUM LETTER PHASE-D KU"                                                         .  #x16949)
           ("BAMUM LETTER PHASE-D REN OLD"                                                    .  #x1694A)
           ("BAMUM LETTER PHASE-D TAE"                                                        .  #x1694B)
           ("BAMUM LETTER PHASE-D TOQ"                                                        .  #x1694C)
           ("BAMUM LETTER PHASE-D NYI"                                                        .  #x1694D)
           ("BAMUM LETTER PHASE-D RII"                                                        .  #x1694E)
           ("BAMUM LETTER PHASE-D LEEEE"                                                      .  #x1694F)
           ("BAMUM LETTER PHASE-D MEEEE"                                                      .  #x16950)
           ("BAMUM LETTER PHASE-D M"                                                          .  #x16951)
           ("BAMUM LETTER PHASE-D SUU"                                                        .  #x16952)
           ("BAMUM LETTER PHASE-D MU"                                                         .  #x16953)
           ("BAMUM LETTER PHASE-D SHII"                                                       .  #x16954)
           ("BAMUM LETTER PHASE-D SHEUX"                                                      .  #x16955)
           ("BAMUM LETTER PHASE-D KYEE"                                                       .  #x16956)
           ("BAMUM LETTER PHASE-D NU"                                                         .  #x16957)
           ("BAMUM LETTER PHASE-D SHU"                                                        .  #x16958)
           ("BAMUM LETTER PHASE-D NTEE"                                                       .  #x16959)
           ("BAMUM LETTER PHASE-D PEE"                                                        .  #x1695A)
           ("BAMUM LETTER PHASE-D NI"                                                         .  #x1695B)
           ("BAMUM LETTER PHASE-D SHOQ"                                                       .  #x1695C)
           ("BAMUM LETTER PHASE-D PUQ"                                                        .  #x1695D)
           ("BAMUM LETTER PHASE-D MVOP"                                                       .  #x1695E)
           ("BAMUM LETTER PHASE-D LOQ"                                                        .  #x1695F)
           ("BAMUM LETTER PHASE-D REN MUCH"                                                   .  #x16960)
           ("BAMUM LETTER PHASE-D TI"                                                         .  #x16961)
           ("BAMUM LETTER PHASE-D NTUU"                                                       .  #x16962)
           ("BAMUM LETTER PHASE-D MBAA SEVEN"                                                 .  #x16963)
           ("BAMUM LETTER PHASE-D SAQ"                                                        .  #x16964)
           ("BAMUM LETTER PHASE-D FAA"                                                        .  #x16965)
           ("BAMUM LETTER PHASE-E NDAP"                                                       .  #x16966)
           ("BAMUM LETTER PHASE-E TOON"                                                       .  #x16967)
           ("BAMUM LETTER PHASE-E MBEUM"                                                      .  #x16968)
           ("BAMUM LETTER PHASE-E LAP"                                                        .  #x16969)
           ("BAMUM LETTER PHASE-E VOM"                                                        .  #x1696A)
           ("BAMUM LETTER PHASE-E LOON"                                                       .  #x1696B)
           ("BAMUM LETTER PHASE-E PAA"                                                        .  #x1696C)
           ("BAMUM LETTER PHASE-E SOM"                                                        .  #x1696D)
           ("BAMUM LETTER PHASE-E RAQ"                                                        .  #x1696E)
           ("BAMUM LETTER PHASE-E NSHUOP"                                                     .  #x1696F)
           ("BAMUM LETTER PHASE-E NDUN"                                                       .  #x16970)
           ("BAMUM LETTER PHASE-E PUAE"                                                       .  #x16971)
           ("BAMUM LETTER PHASE-E TAM"                                                        .  #x16972)
           ("BAMUM LETTER PHASE-E NGKA"                                                       .  #x16973)
           ("BAMUM LETTER PHASE-E KPEUX"                                                      .  #x16974)
           ("BAMUM LETTER PHASE-E WUO"                                                        .  #x16975)
           ("BAMUM LETTER PHASE-E SEE"                                                        .  #x16976)
           ("BAMUM LETTER PHASE-E NGGEUAET"                                                   .  #x16977)
           ("BAMUM LETTER PHASE-E PAAM"                                                       .  #x16978)
           ("BAMUM LETTER PHASE-E TOO"                                                        .  #x16979)
           ("BAMUM LETTER PHASE-E KUOP"                                                       .  #x1697A)
           ("BAMUM LETTER PHASE-E LOM"                                                        .  #x1697B)
           ("BAMUM LETTER PHASE-E NSHIEE"                                                     .  #x1697C)
           ("BAMUM LETTER PHASE-E NGOP"                                                       .  #x1697D)
           ("BAMUM LETTER PHASE-E MAEM"                                                       .  #x1697E)
           ("BAMUM LETTER PHASE-E NGKEUX"                                                     .  #x1697F)
           ("BAMUM LETTER PHASE-E NGOQ"                                                       .  #x16980)
           ("BAMUM LETTER PHASE-E NSHUE"                                                      .  #x16981)
           ("BAMUM LETTER PHASE-E RIMGBA"                                                     .  #x16982)
           ("BAMUM LETTER PHASE-E NJEUX"                                                      .  #x16983)
           ("BAMUM LETTER PHASE-E PEEM"                                                       .  #x16984)
           ("BAMUM LETTER PHASE-E SAA"                                                        .  #x16985)
           ("BAMUM LETTER PHASE-E NGGURAE"                                                    .  #x16986)
           ("BAMUM LETTER PHASE-E MGBA"                                                       .  #x16987)
           ("BAMUM LETTER PHASE-E GHEUX"                                                      .  #x16988)
           ("BAMUM LETTER PHASE-E NGKEUAEM"                                                   .  #x16989)
           ("BAMUM LETTER PHASE-E NJAEMLI"                                                    .  #x1698A)
           ("BAMUM LETTER PHASE-E MAP"                                                        .  #x1698B)
           ("BAMUM LETTER PHASE-E LOOT"                                                       .  #x1698C)
           ("BAMUM LETTER PHASE-E NGGEEEE"                                                    .  #x1698D)
           ("BAMUM LETTER PHASE-E NDIQ"                                                       .  #x1698E)
           ("BAMUM LETTER PHASE-E TAEN NTEUM"                                                 .  #x1698F)
           ("BAMUM LETTER PHASE-E SET"                                                        .  #x16990)
           ("BAMUM LETTER PHASE-E PUM"                                                        .  #x16991)
           ("BAMUM LETTER PHASE-E NDAA SOFTNESS"                                              .  #x16992)
           ("BAMUM LETTER PHASE-E NGGUAESHAE NYAM"                                            .  #x16993)
           ("BAMUM LETTER PHASE-E YIEE"                                                       .  #x16994)
           ("BAMUM LETTER PHASE-E GHEUN"                                                      .  #x16995)
           ("BAMUM LETTER PHASE-E TUAE"                                                       .  #x16996)
           ("BAMUM LETTER PHASE-E YEUAE"                                                      .  #x16997)
           ("BAMUM LETTER PHASE-E PO"                                                         .  #x16998)
           ("BAMUM LETTER PHASE-E TUMAE"                                                      .  #x16999)
           ("BAMUM LETTER PHASE-E KEUAE"                                                      .  #x1699A)
           ("BAMUM LETTER PHASE-E SUAEN"                                                      .  #x1699B)
           ("BAMUM LETTER PHASE-E TEUAEQ"                                                     .  #x1699C)
           ("BAMUM LETTER PHASE-E VEUAE"                                                      .  #x1699D)
           ("BAMUM LETTER PHASE-E WEUX"                                                       .  #x1699E)
           ("BAMUM LETTER PHASE-E LAAM"                                                       .  #x1699F)
           ("BAMUM LETTER PHASE-E PU"                                                         .  #x169A0)
           ("BAMUM LETTER PHASE-E TAAQ"                                                       .  #x169A1)
           ("BAMUM LETTER PHASE-E GHAAMAE"                                                    .  #x169A2)
           ("BAMUM LETTER PHASE-E NGEUREUT"                                                   .  #x169A3)
           ("BAMUM LETTER PHASE-E SHEUAEQ"                                                    .  #x169A4)
           ("BAMUM LETTER PHASE-E MGBEN"                                                      .  #x169A5)
           ("BAMUM LETTER PHASE-E MBEE"                                                       .  #x169A6)
           ("BAMUM LETTER PHASE-E NZAQ"                                                       .  #x169A7)
           ("BAMUM LETTER PHASE-E NKOM"                                                       .  #x169A8)
           ("BAMUM LETTER PHASE-E GBET"                                                       .  #x169A9)
           ("BAMUM LETTER PHASE-E TUM"                                                        .  #x169AA)
           ("BAMUM LETTER PHASE-E KUET"                                                       .  #x169AB)
           ("BAMUM LETTER PHASE-E YAP"                                                        .  #x169AC)
           ("BAMUM LETTER PHASE-E NYI CLEAVER"                                                .  #x169AD)
           ("BAMUM LETTER PHASE-E YIT"                                                        .  #x169AE)
           ("BAMUM LETTER PHASE-E MFEUQ"                                                      .  #x169AF)
           ("BAMUM LETTER PHASE-E NDIAQ"                                                      .  #x169B0)
           ("BAMUM LETTER PHASE-E PIEEQ"                                                      .  #x169B1)
           ("BAMUM LETTER PHASE-E YUEQ"                                                       .  #x169B2)
           ("BAMUM LETTER PHASE-E LEUAEM"                                                     .  #x169B3)
           ("BAMUM LETTER PHASE-E FUE"                                                        .  #x169B4)
           ("BAMUM LETTER PHASE-E GBEUX"                                                      .  #x169B5)
           ("BAMUM LETTER PHASE-E NGKUP"                                                      .  #x169B6)
           ("BAMUM LETTER PHASE-E KET"                                                        .  #x169B7)
           ("BAMUM LETTER PHASE-E MAE"                                                        .  #x169B8)
           ("BAMUM LETTER PHASE-E NGKAAMI"                                                    .  #x169B9)
           ("BAMUM LETTER PHASE-E GHET"                                                       .  #x169BA)
           ("BAMUM LETTER PHASE-E FA"                                                         .  #x169BB)
           ("BAMUM LETTER PHASE-E NTUM"                                                       .  #x169BC)
           ("BAMUM LETTER PHASE-E PEUT"                                                       .  #x169BD)
           ("BAMUM LETTER PHASE-E YEUM"                                                       .  #x169BE)
           ("BAMUM LETTER PHASE-E NGGEUAE"                                                    .  #x169BF)
           ("BAMUM LETTER PHASE-E NYI BETWEEN"                                                .  #x169C0)
           ("BAMUM LETTER PHASE-E NZUQ"                                                       .  #x169C1)
           ("BAMUM LETTER PHASE-E POON"                                                       .  #x169C2)
           ("BAMUM LETTER PHASE-E MIEE"                                                       .  #x169C3)
           ("BAMUM LETTER PHASE-E FUET"                                                       .  #x169C4)
           ("BAMUM LETTER PHASE-E NAE"                                                        .  #x169C5)
           ("BAMUM LETTER PHASE-E MUAE"                                                       .  #x169C6)
           ("BAMUM LETTER PHASE-E GHEUAE"                                                     .  #x169C7)
           ("BAMUM LETTER PHASE-E FU I"                                                       .  #x169C8)
           ("BAMUM LETTER PHASE-E MVI"                                                        .  #x169C9)
           ("BAMUM LETTER PHASE-E PUAQ"                                                       .  #x169CA)
           ("BAMUM LETTER PHASE-E NGKUM"                                                      .  #x169CB)
           ("BAMUM LETTER PHASE-E KUT"                                                        .  #x169CC)
           ("BAMUM LETTER PHASE-E PIET"                                                       .  #x169CD)
           ("BAMUM LETTER PHASE-E NTAP"                                                       .  #x169CE)
           ("BAMUM LETTER PHASE-E YEUAET"                                                     .  #x169CF)
           ("BAMUM LETTER PHASE-E NGGUP"                                                      .  #x169D0)
           ("BAMUM LETTER PHASE-E PA PEOPLE"                                                  .  #x169D1)
           ("BAMUM LETTER PHASE-E FU CALL"                                                    .  #x169D2)
           ("BAMUM LETTER PHASE-E FOM"                                                        .  #x169D3)
           ("BAMUM LETTER PHASE-E NJEE"                                                       .  #x169D4)
           ("BAMUM LETTER PHASE-E A"                                                          .  #x169D5)
           ("BAMUM LETTER PHASE-E TOQ"                                                        .  #x169D6)
           ("BAMUM LETTER PHASE-E O"                                                          .  #x169D7)
           ("BAMUM LETTER PHASE-E I"                                                          .  #x169D8)
           ("BAMUM LETTER PHASE-E LAQ"                                                        .  #x169D9)
           ("BAMUM LETTER PHASE-E PA PLURAL"                                                  .  #x169DA)
           ("BAMUM LETTER PHASE-E TAA"                                                        .  #x169DB)
           ("BAMUM LETTER PHASE-E TAQ"                                                        .  #x169DC)
           ("BAMUM LETTER PHASE-E NDAA MY HOUSE"                                              .  #x169DD)
           ("BAMUM LETTER PHASE-E SHIQ"                                                       .  #x169DE)
           ("BAMUM LETTER PHASE-E YEUX"                                                       .  #x169DF)
           ("BAMUM LETTER PHASE-E NGUAE"                                                      .  #x169E0)
           ("BAMUM LETTER PHASE-E YUAEN"                                                      .  #x169E1)
           ("BAMUM LETTER PHASE-E YOQ SWIMMING"                                               .  #x169E2)
           ("BAMUM LETTER PHASE-E YOQ COVER"                                                  .  #x169E3)
           ("BAMUM LETTER PHASE-E YUQ"                                                        .  #x169E4)
           ("BAMUM LETTER PHASE-E YUN"                                                        .  #x169E5)
           ("BAMUM LETTER PHASE-E KEUX"                                                       .  #x169E6)
           ("BAMUM LETTER PHASE-E PEUX"                                                       .  #x169E7)
           ("BAMUM LETTER PHASE-E NJEE EPOCH"                                                 .  #x169E8)
           ("BAMUM LETTER PHASE-E PUE"                                                        .  #x169E9)
           ("BAMUM LETTER PHASE-E WUE"                                                        .  #x169EA)
           ("BAMUM LETTER PHASE-E FEE"                                                        .  #x169EB)
           ("BAMUM LETTER PHASE-E VEE"                                                        .  #x169EC)
           ("BAMUM LETTER PHASE-E LU"                                                         .  #x169ED)
           ("BAMUM LETTER PHASE-E MI"                                                         .  #x169EE)
           ("BAMUM LETTER PHASE-E REUX"                                                       .  #x169EF)
           ("BAMUM LETTER PHASE-E RAE"                                                        .  #x169F0)
           ("BAMUM LETTER PHASE-E NGUAET"                                                     .  #x169F1)
           ("BAMUM LETTER PHASE-E NGA"                                                        .  #x169F2)
           ("BAMUM LETTER PHASE-E SHO"                                                        .  #x169F3)
           ("BAMUM LETTER PHASE-E SHOQ"                                                       .  #x169F4)
           ("BAMUM LETTER PHASE-E FU REMEDY"                                                  .  #x169F5)
           ("BAMUM LETTER PHASE-E NA"                                                         .  #x169F6)
           ("BAMUM LETTER PHASE-E PI"                                                         .  #x169F7)
           ("BAMUM LETTER PHASE-E LOQ"                                                        .  #x169F8)
           ("BAMUM LETTER PHASE-E KO"                                                         .  #x169F9)
           ("BAMUM LETTER PHASE-E MEN"                                                        .  #x169FA)
           ("BAMUM LETTER PHASE-E MA"                                                         .  #x169FB)
           ("BAMUM LETTER PHASE-E MAQ"                                                        .  #x169FC)
           ("BAMUM LETTER PHASE-E TEU"                                                        .  #x169FD)
           ("BAMUM LETTER PHASE-E KI"                                                         .  #x169FE)
           ("BAMUM LETTER PHASE-E MON"                                                        .  #x169FF)
           ("BAMUM LETTER PHASE-E TEN"                                                        .  #x16A00)
           ("BAMUM LETTER PHASE-E FAQ"                                                        .  #x16A01)
           ("BAMUM LETTER PHASE-E GHOM"                                                       .  #x16A02)
           ("BAMUM LETTER PHASE-F KA"                                                         .  #x16A03)
           ("BAMUM LETTER PHASE-F U"                                                          .  #x16A04)
           ("BAMUM LETTER PHASE-F KU"                                                         .  #x16A05)
           ("BAMUM LETTER PHASE-F EE"                                                         .  #x16A06)
           ("BAMUM LETTER PHASE-F REE"                                                        .  #x16A07)
           ("BAMUM LETTER PHASE-F TAE"                                                        .  #x16A08)
           ("BAMUM LETTER PHASE-F NYI"                                                        .  #x16A09)
           ("BAMUM LETTER PHASE-F LA"                                                         .  #x16A0A)
           ("BAMUM LETTER PHASE-F RII"                                                        .  #x16A0B)
           ("BAMUM LETTER PHASE-F RIEE"                                                       .  #x16A0C)
           ("BAMUM LETTER PHASE-F MEEEE"                                                      .  #x16A0D)
           ("BAMUM LETTER PHASE-F TAA"                                                        .  #x16A0E)
           ("BAMUM LETTER PHASE-F NDAA"                                                       .  #x16A0F)
           ("BAMUM LETTER PHASE-F NJAEM"                                                      .  #x16A10)
           ("BAMUM LETTER PHASE-F M"                                                          .  #x16A11)
           ("BAMUM LETTER PHASE-F SUU"                                                        .  #x16A12)
           ("BAMUM LETTER PHASE-F SHII"                                                       .  #x16A13)
           ("BAMUM LETTER PHASE-F SI"                                                         .  #x16A14)
           ("BAMUM LETTER PHASE-F SEUX"                                                       .  #x16A15)
           ("BAMUM LETTER PHASE-F KYEE"                                                       .  #x16A16)
           ("BAMUM LETTER PHASE-F KET"                                                        .  #x16A17)
           ("BAMUM LETTER PHASE-F NUAE"                                                       .  #x16A18)
           ("BAMUM LETTER PHASE-F NU"                                                         .  #x16A19)
           ("BAMUM LETTER PHASE-F NJUAE"                                                      .  #x16A1A)
           ("BAMUM LETTER PHASE-F YOQ"                                                        .  #x16A1B)
           ("BAMUM LETTER PHASE-F SHU"                                                        .  #x16A1C)
           ("BAMUM LETTER PHASE-F YA"                                                         .  #x16A1D)
           ("BAMUM LETTER PHASE-F NSHA"                                                       .  #x16A1E)
           ("BAMUM LETTER PHASE-F PEUX"                                                       .  #x16A1F)
           ("BAMUM LETTER PHASE-F NTEE"                                                       .  #x16A20)
           ("BAMUM LETTER PHASE-F WUE"                                                        .  #x16A21)
           ("BAMUM LETTER PHASE-F PEE"                                                        .  #x16A22)
           ("BAMUM LETTER PHASE-F RU"                                                         .  #x16A23)
           ("BAMUM LETTER PHASE-F NI"                                                         .  #x16A24)
           ("BAMUM LETTER PHASE-F REUX"                                                       .  #x16A25)
           ("BAMUM LETTER PHASE-F KEN"                                                        .  #x16A26)
           ("BAMUM LETTER PHASE-F NGKWAEN"                                                    .  #x16A27)
           ("BAMUM LETTER PHASE-F NGGA"                                                       .  #x16A28)
           ("BAMUM LETTER PHASE-F SHO"                                                        .  #x16A29)
           ("BAMUM LETTER PHASE-F PUAE"                                                       .  #x16A2A)
           ("BAMUM LETTER PHASE-F FOM"                                                        .  #x16A2B)
           ("BAMUM LETTER PHASE-F WA"                                                         .  #x16A2C)
           ("BAMUM LETTER PHASE-F LI"                                                         .  #x16A2D)
           ("BAMUM LETTER PHASE-F LOQ"                                                        .  #x16A2E)
           ("BAMUM LETTER PHASE-F KO"                                                         .  #x16A2F)
           ("BAMUM LETTER PHASE-F MBEN"                                                       .  #x16A30)
           ("BAMUM LETTER PHASE-F REN"                                                        .  #x16A31)
           ("BAMUM LETTER PHASE-F MA"                                                         .  #x16A32)
           ("BAMUM LETTER PHASE-F MO"                                                         .  #x16A33)
           ("BAMUM LETTER PHASE-F MBAA"                                                       .  #x16A34)
           ("BAMUM LETTER PHASE-F TET"                                                        .  #x16A35)
           ("BAMUM LETTER PHASE-F KPA"                                                        .  #x16A36)
           ("BAMUM LETTER PHASE-F SAMBA"                                                      .  #x16A37)
           ("BAMUM LETTER PHASE-F VUEQ"                                                       .  #x16A38)
           ("KATAKANA LETTER ARCHAIC E"                                                       .  #x1B000)
           ("HIRAGANA LETTER ARCHAIC YE"                                                      .  #x1B001)
           ("PLAYING CARD BACK"                                                               .  #x1F0A0)
           ("PLAYING CARD ACE OF SPADES"                                                      .  #x1F0A1)
           ("PLAYING CARD TWO OF SPADES"                                                      .  #x1F0A2)
           ("PLAYING CARD THREE OF SPADES"                                                    .  #x1F0A3)
           ("PLAYING CARD FOUR OF SPADES"                                                     .  #x1F0A4)
           ("PLAYING CARD FIVE OF SPADES"                                                     .  #x1F0A5)
           ("PLAYING CARD SIX OF SPADES"                                                      .  #x1F0A6)
           ("PLAYING CARD SEVEN OF SPADES"                                                    .  #x1F0A7)
           ("PLAYING CARD EIGHT OF SPADES"                                                    .  #x1F0A8)
           ("PLAYING CARD NINE OF SPADES"                                                     .  #x1F0A9)
           ("PLAYING CARD TEN OF SPADES"                                                      .  #x1F0AA)
           ("PLAYING CARD JACK OF SPADES"                                                     .  #x1F0AB)
           ("PLAYING CARD KNIGHT OF SPADES"                                                   .  #x1F0AC)
           ("PLAYING CARD QUEEN OF SPADES"                                                    .  #x1F0AD)
           ("PLAYING CARD KING OF SPADES"                                                     .  #x1F0AE)
           ("PLAYING CARD ACE OF HEARTS"                                                      .  #x1F0B1)
           ("PLAYING CARD TWO OF HEARTS"                                                      .  #x1F0B2)
           ("PLAYING CARD THREE OF HEARTS"                                                    .  #x1F0B3)
           ("PLAYING CARD FOUR OF HEARTS"                                                     .  #x1F0B4)
           ("PLAYING CARD FIVE OF HEARTS"                                                     .  #x1F0B5)
           ("PLAYING CARD SIX OF HEARTS"                                                      .  #x1F0B6)
           ("PLAYING CARD SEVEN OF HEARTS"                                                    .  #x1F0B7)
           ("PLAYING CARD EIGHT OF HEARTS"                                                    .  #x1F0B8)
           ("PLAYING CARD NINE OF HEARTS"                                                     .  #x1F0B9)
           ("PLAYING CARD TEN OF HEARTS"                                                      .  #x1F0BA)
           ("PLAYING CARD JACK OF HEARTS"                                                     .  #x1F0BB)
           ("PLAYING CARD KNIGHT OF HEARTS"                                                   .  #x1F0BC)
           ("PLAYING CARD QUEEN OF HEARTS"                                                    .  #x1F0BD)
           ("PLAYING CARD KING OF HEARTS"                                                     .  #x1F0BE)
           ("PLAYING CARD ACE OF DIAMONDS"                                                    .  #x1F0C1)
           ("PLAYING CARD TWO OF DIAMONDS"                                                    .  #x1F0C2)
           ("PLAYING CARD THREE OF DIAMONDS"                                                  .  #x1F0C3)
           ("PLAYING CARD FOUR OF DIAMONDS"                                                   .  #x1F0C4)
           ("PLAYING CARD FIVE OF DIAMONDS"                                                   .  #x1F0C5)
           ("PLAYING CARD SIX OF DIAMONDS"                                                    .  #x1F0C6)
           ("PLAYING CARD SEVEN OF DIAMONDS"                                                  .  #x1F0C7)
           ("PLAYING CARD EIGHT OF DIAMONDS"                                                  .  #x1F0C8)
           ("PLAYING CARD NINE OF DIAMONDS"                                                   .  #x1F0C9)
           ("PLAYING CARD TEN OF DIAMONDS"                                                    .  #x1F0CA)
           ("PLAYING CARD JACK OF DIAMONDS"                                                   .  #x1F0CB)
           ("PLAYING CARD KNIGHT OF DIAMONDS"                                                 .  #x1F0CC)
           ("PLAYING CARD QUEEN OF DIAMONDS"                                                  .  #x1F0CD)
           ("PLAYING CARD KING OF DIAMONDS"                                                   .  #x1F0CE)
           ("PLAYING CARD BLACK JOKER"                                                        .  #x1F0CF)
           ("PLAYING CARD ACE OF CLUBS"                                                       .  #x1F0D1)
           ("PLAYING CARD TWO OF CLUBS"                                                       .  #x1F0D2)
           ("PLAYING CARD THREE OF CLUBS"                                                     .  #x1F0D3)
           ("PLAYING CARD FOUR OF CLUBS"                                                      .  #x1F0D4)
           ("PLAYING CARD FIVE OF CLUBS"                                                      .  #x1F0D5)
           ("PLAYING CARD SIX OF CLUBS"                                                       .  #x1F0D6)
           ("PLAYING CARD SEVEN OF CLUBS"                                                     .  #x1F0D7)
           ("PLAYING CARD EIGHT OF CLUBS"                                                     .  #x1F0D8)
           ("PLAYING CARD NINE OF CLUBS"                                                      .  #x1F0D9)
           ("PLAYING CARD TEN OF CLUBS"                                                       .  #x1F0DA)
           ("PLAYING CARD JACK OF CLUBS"                                                      .  #x1F0DB)
           ("PLAYING CARD KNIGHT OF CLUBS"                                                    .  #x1F0DC)
           ("PLAYING CARD QUEEN OF CLUBS"                                                     .  #x1F0DD)
           ("PLAYING CARD KING OF CLUBS"                                                      .  #x1F0DE)
           ("PLAYING CARD WHITE JOKER"                                                        .  #x1F0DF)
           ("SQUARED LATIN CAPITAL LETTER A"                                                  .  #x1F130)
           ("SQUARED LATIN CAPITAL LETTER C"                                                  .  #x1F132)
           ("SQUARED LATIN CAPITAL LETTER D"                                                  .  #x1F133)
           ("SQUARED LATIN CAPITAL LETTER E"                                                  .  #x1F134)
           ("SQUARED LATIN CAPITAL LETTER F"                                                  .  #x1F135)
           ("SQUARED LATIN CAPITAL LETTER G"                                                  .  #x1F136)
           ("SQUARED LATIN CAPITAL LETTER H"                                                  .  #x1F137)
           ("SQUARED LATIN CAPITAL LETTER I"                                                  .  #x1F138)
           ("SQUARED LATIN CAPITAL LETTER J"                                                  .  #x1F139)
           ("SQUARED LATIN CAPITAL LETTER K"                                                  .  #x1F13A)
           ("SQUARED LATIN CAPITAL LETTER L"                                                  .  #x1F13B)
           ("SQUARED LATIN CAPITAL LETTER M"                                                  .  #x1F13C)
           ("SQUARED LATIN CAPITAL LETTER O"                                                  .  #x1F13E)
           ("SQUARED LATIN CAPITAL LETTER Q"                                                  .  #x1F140)
           ("SQUARED LATIN CAPITAL LETTER R"                                                  .  #x1F141)
           ("SQUARED LATIN CAPITAL LETTER T"                                                  .  #x1F143)
           ("SQUARED LATIN CAPITAL LETTER U"                                                  .  #x1F144)
           ("SQUARED LATIN CAPITAL LETTER V"                                                  .  #x1F145)
           ("SQUARED LATIN CAPITAL LETTER X"                                                  .  #x1F147)
           ("SQUARED LATIN CAPITAL LETTER Y"                                                  .  #x1F148)
           ("SQUARED LATIN CAPITAL LETTER Z"                                                  .  #x1F149)
           ("SQUARED WC"                                                                      .  #x1F14F)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER A"                                         .  #x1F150)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER B"                                         .  #x1F151)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER C"                                         .  #x1F152)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER D"                                         .  #x1F153)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER E"                                         .  #x1F154)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER F"                                         .  #x1F155)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER G"                                         .  #x1F156)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER I"                                         .  #x1F158)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER J"                                         .  #x1F159)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER K"                                         .  #x1F15A)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER L"                                         .  #x1F15B)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER M"                                         .  #x1F15C)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER N"                                         .  #x1F15D)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER O"                                         .  #x1F15E)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER Q"                                         .  #x1F160)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER R"                                         .  #x1F161)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER S"                                         .  #x1F162)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER T"                                         .  #x1F163)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER U"                                         .  #x1F164)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER V"                                         .  #x1F165)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER W"                                         .  #x1F166)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER X"                                         .  #x1F167)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER Y"                                         .  #x1F168)
           ("NEGATIVE CIRCLED LATIN CAPITAL LETTER Z"                                         .  #x1F169)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER A"                                         .  #x1F170)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER B"                                         .  #x1F171)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER C"                                         .  #x1F172)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER D"                                         .  #x1F173)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER E"                                         .  #x1F174)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER F"                                         .  #x1F175)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER G"                                         .  #x1F176)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER H"                                         .  #x1F177)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER I"                                         .  #x1F178)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER K"                                         .  #x1F17A)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER N"                                         .  #x1F17D)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER O"                                         .  #x1F17E)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER Q"                                         .  #x1F180)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER R"                                         .  #x1F181)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER S"                                         .  #x1F182)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER T"                                         .  #x1F183)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER U"                                         .  #x1F184)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER V"                                         .  #x1F185)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER W"                                         .  #x1F186)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER X"                                         .  #x1F187)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER Y"                                         .  #x1F188)
           ("NEGATIVE SQUARED LATIN CAPITAL LETTER Z"                                         .  #x1F189)
           ("NEGATIVE SQUARED AB"                                                             .  #x1F18E)
           ("NEGATIVE SQUARED WC"                                                             .  #x1F18F)
           ("SQUARED CL"                                                                      .  #x1F191)
           ("SQUARED COOL"                                                                    .  #x1F192)
           ("SQUARED FREE"                                                                    .  #x1F193)
           ("SQUARED ID"                                                                      .  #x1F194)
           ("SQUARED NEW"                                                                     .  #x1F195)
           ("SQUARED NG"                                                                      .  #x1F196)
           ("SQUARED OK"                                                                      .  #x1F197)
           ("SQUARED SOS"                                                                     .  #x1F198)
           ("SQUARED UP WITH EXCLAMATION MARK"                                                .  #x1F199)
           ("SQUARED VS"                                                                      .  #x1F19A)
           ("REGIONAL INDICATOR SYMBOL LETTER A"                                              .  #x1F1E6)
           ("REGIONAL INDICATOR SYMBOL LETTER B"                                              .  #x1F1E7)
           ("REGIONAL INDICATOR SYMBOL LETTER C"                                              .  #x1F1E8)
           ("REGIONAL INDICATOR SYMBOL LETTER D"                                              .  #x1F1E9)
           ("REGIONAL INDICATOR SYMBOL LETTER E"                                              .  #x1F1EA)
           ("REGIONAL INDICATOR SYMBOL LETTER F"                                              .  #x1F1EB)
           ("REGIONAL INDICATOR SYMBOL LETTER G"                                              .  #x1F1EC)
           ("REGIONAL INDICATOR SYMBOL LETTER H"                                              .  #x1F1ED)
           ("REGIONAL INDICATOR SYMBOL LETTER I"                                              .  #x1F1EE)
           ("REGIONAL INDICATOR SYMBOL LETTER J"                                              .  #x1F1EF)
           ("REGIONAL INDICATOR SYMBOL LETTER K"                                              .  #x1F1F0)
           ("REGIONAL INDICATOR SYMBOL LETTER L"                                              .  #x1F1F1)
           ("REGIONAL INDICATOR SYMBOL LETTER M"                                              .  #x1F1F2)
           ("REGIONAL INDICATOR SYMBOL LETTER N"                                              .  #x1F1F3)
           ("REGIONAL INDICATOR SYMBOL LETTER O"                                              .  #x1F1F4)
           ("REGIONAL INDICATOR SYMBOL LETTER P"                                              .  #x1F1F5)
           ("REGIONAL INDICATOR SYMBOL LETTER Q"                                              .  #x1F1F6)
           ("REGIONAL INDICATOR SYMBOL LETTER R"                                              .  #x1F1F7)
           ("REGIONAL INDICATOR SYMBOL LETTER S"                                              .  #x1F1F8)
           ("REGIONAL INDICATOR SYMBOL LETTER T"                                              .  #x1F1F9)
           ("REGIONAL INDICATOR SYMBOL LETTER U"                                              .  #x1F1FA)
           ("REGIONAL INDICATOR SYMBOL LETTER V"                                              .  #x1F1FB)
           ("REGIONAL INDICATOR SYMBOL LETTER W"                                              .  #x1F1FC)
           ("REGIONAL INDICATOR SYMBOL LETTER X"                                              .  #x1F1FD)
           ("REGIONAL INDICATOR SYMBOL LETTER Y"                                              .  #x1F1FE)
           ("REGIONAL INDICATOR SYMBOL LETTER Z"                                              .  #x1F1FF)
           ("SQUARED KATAKANA KOKO"                                                           .  #x1F201)
           ("SQUARED KATAKANA SA"                                                             .  #x1F202)
           ("SQUARED CJK UNIFIED IDEOGRAPH-7981"                                              .  #x1F232)
           ("SQUARED CJK UNIFIED IDEOGRAPH-7A7A"                                              .  #x1F233)
           ("SQUARED CJK UNIFIED IDEOGRAPH-5408"                                              .  #x1F234)
           ("SQUARED CJK UNIFIED IDEOGRAPH-6E80"                                              .  #x1F235)
           ("SQUARED CJK UNIFIED IDEOGRAPH-6709"                                              .  #x1F236)
           ("SQUARED CJK UNIFIED IDEOGRAPH-6708"                                              .  #x1F237)
           ("SQUARED CJK UNIFIED IDEOGRAPH-7533"                                              .  #x1F238)
           ("SQUARED CJK UNIFIED IDEOGRAPH-5272"                                              .  #x1F239)
           ("SQUARED CJK UNIFIED IDEOGRAPH-55B6"                                              .  #x1F23A)
           ("CIRCLED IDEOGRAPH ADVANTAGE"                                                     .  #x1F250)
           ("CIRCLED IDEOGRAPH ACCEPT"                                                        .  #x1F251)
           ("CYCLONE"                                                                         .  #x1F300)
           ("FOGGY"                                                                           .  #x1F301)
           ("CLOSED UMBRELLA"                                                                 .  #x1F302)
           ("NIGHT WITH STARS"                                                                .  #x1F303)
           ("SUNRISE OVER MOUNTAINS"                                                          .  #x1F304)
           ("SUNRISE"                                                                         .  #x1F305)
           ("CITYSCAPE AT DUSK"                                                               .  #x1F306)
           ("SUNSET OVER BUILDINGS"                                                           .  #x1F307)
           ("RAINBOW"                                                                         .  #x1F308)
           ("BRIDGE AT NIGHT"                                                                 .  #x1F309)
           ("WATER WAVE"                                                                      .  #x1F30A)
           ("VOLCANO"                                                                         .  #x1F30B)
           ("MILKY WAY"                                                                       .  #x1F30C)
           ("EARTH GLOBE EUROPE-AFRICA"                                                       .  #x1F30D)
           ("EARTH GLOBE AMERICAS"                                                            .  #x1F30E)
           ("EARTH GLOBE ASIA-AUSTRALIA"                                                      .  #x1F30F)
           ("GLOBE WITH MERIDIANS"                                                            .  #x1F310)
           ("NEW MOON SYMBOL"                                                                 .  #x1F311)
           ("WAXING CRESCENT MOON SYMBOL"                                                     .  #x1F312)
           ("FIRST QUARTER MOON SYMBOL"                                                       .  #x1F313)
           ("WAXING GIBBOUS MOON SYMBOL"                                                      .  #x1F314)
           ("FULL MOON SYMBOL"                                                                .  #x1F315)
           ("WANING GIBBOUS MOON SYMBOL"                                                      .  #x1F316)
           ("LAST QUARTER MOON SYMBOL"                                                        .  #x1F317)
           ("WANING CRESCENT MOON SYMBOL"                                                     .  #x1F318)
           ("CRESCENT MOON"                                                                   .  #x1F319)
           ("NEW MOON WITH FACE"                                                              .  #x1F31A)
           ("FIRST QUARTER MOON WITH FACE"                                                    .  #x1F31B)
           ("LAST QUARTER MOON WITH FACE"                                                     .  #x1F31C)
           ("FULL MOON WITH FACE"                                                             .  #x1F31D)
           ("SUN WITH FACE"                                                                   .  #x1F31E)
           ("GLOWING STAR"                                                                    .  #x1F31F)
           ("SHOOTING STAR"                                                                   .  #x1F320)
           ("CHESTNUT"                                                                        .  #x1F330)
           ("SEEDLING"                                                                        .  #x1F331)
           ("EVERGREEN TREE"                                                                  .  #x1F332)
           ("DECIDUOUS TREE"                                                                  .  #x1F333)
           ("PALM TREE"                                                                       .  #x1F334)
           ("CACTUS"                                                                          .  #x1F335)
           ("TULIP"                                                                           .  #x1F337)
           ("CHERRY BLOSSOM"                                                                  .  #x1F338)
           ("ROSE"                                                                            .  #x1F339)
           ("HIBISCUS"                                                                        .  #x1F33A)
           ("SUNFLOWER"                                                                       .  #x1F33B)
           ("BLOSSOM"                                                                         .  #x1F33C)
           ("EAR OF MAIZE"                                                                    .  #x1F33D)
           ("EAR OF RICE"                                                                     .  #x1F33E)
           ("HERB"                                                                            .  #x1F33F)
           ("FOUR LEAF CLOVER"                                                                .  #x1F340)
           ("MAPLE LEAF"                                                                      .  #x1F341)
           ("FALLEN LEAF"                                                                     .  #x1F342)
           ("LEAF FLUTTERING IN WIND"                                                         .  #x1F343)
           ("MUSHROOM"                                                                        .  #x1F344)
           ("TOMATO"                                                                          .  #x1F345)
           ("AUBERGINE"                                                                       .  #x1F346)
           ("GRAPES"                                                                          .  #x1F347)
           ("MELON"                                                                           .  #x1F348)
           ("WATERMELON"                                                                      .  #x1F349)
           ("TANGERINE"                                                                       .  #x1F34A)
           ("LEMON"                                                                           .  #x1F34B)
           ("BANANA"                                                                          .  #x1F34C)
           ("PINEAPPLE"                                                                       .  #x1F34D)
           ("RED APPLE"                                                                       .  #x1F34E)
           ("GREEN APPLE"                                                                     .  #x1F34F)
           ("PEAR"                                                                            .  #x1F350)
           ("PEACH"                                                                           .  #x1F351)
           ("CHERRIES"                                                                        .  #x1F352)
           ("STRAWBERRY"                                                                      .  #x1F353)
           ("HAMBURGER"                                                                       .  #x1F354)
           ("SLICE OF PIZZA"                                                                  .  #x1F355)
           ("MEAT ON BONE"                                                                    .  #x1F356)
           ("POULTRY LEG"                                                                     .  #x1F357)
           ("RICE CRACKER"                                                                    .  #x1F358)
           ("RICE BALL"                                                                       .  #x1F359)
           ("COOKED RICE"                                                                     .  #x1F35A)
           ("CURRY AND RICE"                                                                  .  #x1F35B)
           ("STEAMING BOWL"                                                                   .  #x1F35C)
           ("SPAGHETTI"                                                                       .  #x1F35D)
           ("BREAD"                                                                           .  #x1F35E)
           ("FRENCH FRIES"                                                                    .  #x1F35F)
           ("ROASTED SWEET POTATO"                                                            .  #x1F360)
           ("DANGO"                                                                           .  #x1F361)
           ("ODEN"                                                                            .  #x1F362)
           ("SUSHI"                                                                           .  #x1F363)
           ("FRIED SHRIMP"                                                                    .  #x1F364)
           ("FISH CAKE WITH SWIRL DESIGN"                                                     .  #x1F365)
           ("SOFT ICE CREAM"                                                                  .  #x1F366)
           ("SHAVED ICE"                                                                      .  #x1F367)
           ("ICE CREAM"                                                                       .  #x1F368)
           ("DOUGHNUT"                                                                        .  #x1F369)
           ("COOKIE"                                                                          .  #x1F36A)
           ("CHOCOLATE BAR"                                                                   .  #x1F36B)
           ("CANDY"                                                                           .  #x1F36C)
           ("LOLLIPOP"                                                                        .  #x1F36D)
           ("CUSTARD"                                                                         .  #x1F36E)
           ("HONEY POT"                                                                       .  #x1F36F)
           ("SHORTCAKE"                                                                       .  #x1F370)
           ("BENTO BOX"                                                                       .  #x1F371)
           ("POT OF FOOD"                                                                     .  #x1F372)
           ("COOKING"                                                                         .  #x1F373)
           ("FORK AND KNIFE"                                                                  .  #x1F374)
           ("TEACUP WITHOUT HANDLE"                                                           .  #x1F375)
           ("SAKE BOTTLE AND CUP"                                                             .  #x1F376)
           ("WINE GLASS"                                                                      .  #x1F377)
           ("COCKTAIL GLASS"                                                                  .  #x1F378)
           ("TROPICAL DRINK"                                                                  .  #x1F379)
           ("BEER MUG"                                                                        .  #x1F37A)
           ("CLINKING BEER MUGS"                                                              .  #x1F37B)
           ("BABY BOTTLE"                                                                     .  #x1F37C)
           ("RIBBON"                                                                          .  #x1F380)
           ("WRAPPED PRESENT"                                                                 .  #x1F381)
           ("BIRTHDAY CAKE"                                                                   .  #x1F382)
           ("JACK-O-LANTERN"                                                                  .  #x1F383)
           ("CHRISTMAS TREE"                                                                  .  #x1F384)
           ("FATHER CHRISTMAS"                                                                .  #x1F385)
           ("FIREWORKS"                                                                       .  #x1F386)
           ("FIREWORK SPARKLER"                                                               .  #x1F387)
           ("BALLOON"                                                                         .  #x1F388)
           ("PARTY POPPER"                                                                    .  #x1F389)
           ("CONFETTI BALL"                                                                   .  #x1F38A)
           ("TANABATA TREE"                                                                   .  #x1F38B)
           ("CROSSED FLAGS"                                                                   .  #x1F38C)
           ("PINE DECORATION"                                                                 .  #x1F38D)
           ("JAPANESE DOLLS"                                                                  .  #x1F38E)
           ("CARP STREAMER"                                                                   .  #x1F38F)
           ("WIND CHIME"                                                                      .  #x1F390)
           ("MOON VIEWING CEREMONY"                                                           .  #x1F391)
           ("SCHOOL SATCHEL"                                                                  .  #x1F392)
           ("GRADUATION CAP"                                                                  .  #x1F393)
           ("CAROUSEL HORSE"                                                                  .  #x1F3A0)
           ("FERRIS WHEEL"                                                                    .  #x1F3A1)
           ("ROLLER COASTER"                                                                  .  #x1F3A2)
           ("FISHING POLE AND FISH"                                                           .  #x1F3A3)
           ("MICROPHONE"                                                                      .  #x1F3A4)
           ("MOVIE CAMERA"                                                                    .  #x1F3A5)
           ("CINEMA"                                                                          .  #x1F3A6)
           ("HEADPHONE"                                                                       .  #x1F3A7)
           ("ARTIST PALETTE"                                                                  .  #x1F3A8)
           ("TOP HAT"                                                                         .  #x1F3A9)
           ("CIRCUS TENT"                                                                     .  #x1F3AA)
           ("TICKET"                                                                          .  #x1F3AB)
           ("CLAPPER BOARD"                                                                   .  #x1F3AC)
           ("PERFORMING ARTS"                                                                 .  #x1F3AD)
           ("VIDEO GAME"                                                                      .  #x1F3AE)
           ("DIRECT HIT"                                                                      .  #x1F3AF)
           ("SLOT MACHINE"                                                                    .  #x1F3B0)
           ("BILLIARDS"                                                                       .  #x1F3B1)
           ("GAME DIE"                                                                        .  #x1F3B2)
           ("BOWLING"                                                                         .  #x1F3B3)
           ("FLOWER PLAYING CARDS"                                                            .  #x1F3B4)
           ("MUSICAL NOTE"                                                                    .  #x1F3B5)
           ("MULTIPLE MUSICAL NOTES"                                                          .  #x1F3B6)
           ("SAXOPHONE"                                                                       .  #x1F3B7)
           ("GUITAR"                                                                          .  #x1F3B8)
           ("MUSICAL KEYBOARD"                                                                .  #x1F3B9)
           ("TRUMPET"                                                                         .  #x1F3BA)
           ("VIOLIN"                                                                          .  #x1F3BB)
           ("MUSICAL SCORE"                                                                   .  #x1F3BC)
           ("RUNNING SHIRT WITH SASH"                                                         .  #x1F3BD)
           ("TENNIS RACQUET AND BALL"                                                         .  #x1F3BE)
           ("SKI AND SKI BOOT"                                                                .  #x1F3BF)
           ("BASKETBALL AND HOOP"                                                             .  #x1F3C0)
           ("CHEQUERED FLAG"                                                                  .  #x1F3C1)
           ("SNOWBOARDER"                                                                     .  #x1F3C2)
           ("RUNNER"                                                                          .  #x1F3C3)
           ("SURFER"                                                                          .  #x1F3C4)
           ("TROPHY"                                                                          .  #x1F3C6)
           ("HORSE RACING"                                                                    .  #x1F3C7)
           ("AMERICAN FOOTBALL"                                                               .  #x1F3C8)
           ("RUGBY FOOTBALL"                                                                  .  #x1F3C9)
           ("SWIMMER"                                                                         .  #x1F3CA)
           ("HOUSE BUILDING"                                                                  .  #x1F3E0)
           ("HOUSE WITH GARDEN"                                                               .  #x1F3E1)
           ("OFFICE BUILDING"                                                                 .  #x1F3E2)
           ("JAPANESE POST OFFICE"                                                            .  #x1F3E3)
           ("EUROPEAN POST OFFICE"                                                            .  #x1F3E4)
           ("HOSPITAL"                                                                        .  #x1F3E5)
           ("BANK"                                                                            .  #x1F3E6)
           ("AUTOMATED TELLER MACHINE"                                                        .  #x1F3E7)
           ("HOTEL"                                                                           .  #x1F3E8)
           ("LOVE HOTEL"                                                                      .  #x1F3E9)
           ("CONVENIENCE STORE"                                                               .  #x1F3EA)
           ("SCHOOL"                                                                          .  #x1F3EB)
           ("DEPARTMENT STORE"                                                                .  #x1F3EC)
           ("FACTORY"                                                                         .  #x1F3ED)
           ("IZAKAYA LANTERN"                                                                 .  #x1F3EE)
           ("JAPANESE CASTLE"                                                                 .  #x1F3EF)
           ("EUROPEAN CASTLE"                                                                 .  #x1F3F0)
           ("RAT"                                                                             .  #x1F400)
           ("MOUSE"                                                                           .  #x1F401)
           ("OX"                                                                              .  #x1F402)
           ("WATER BUFFALO"                                                                   .  #x1F403)
           ("COW"                                                                             .  #x1F404)
           ("TIGER"                                                                           .  #x1F405)
           ("LEOPARD"                                                                         .  #x1F406)
           ("RABBIT"                                                                          .  #x1F407)
           ("CAT"                                                                             .  #x1F408)
           ("DRAGON"                                                                          .  #x1F409)
           ("CROCODILE"                                                                       .  #x1F40A)
           ("WHALE"                                                                           .  #x1F40B)
           ("SNAIL"                                                                           .  #x1F40C)
           ("SNAKE"                                                                           .  #x1F40D)
           ("HORSE"                                                                           .  #x1F40E)
           ("RAM"                                                                             .  #x1F40F)
           ("GOAT"                                                                            .  #x1F410)
           ("SHEEP"                                                                           .  #x1F411)
           ("MONKEY"                                                                          .  #x1F412)
           ("ROOSTER"                                                                         .  #x1F413)
           ("CHICKEN"                                                                         .  #x1F414)
           ("DOG"                                                                             .  #x1F415)
           ("PIG"                                                                             .  #x1F416)
           ("BOAR"                                                                            .  #x1F417)
           ("ELEPHANT"                                                                        .  #x1F418)
           ("OCTOPUS"                                                                         .  #x1F419)
           ("SPIRAL SHELL"                                                                    .  #x1F41A)
           ("BUG"                                                                             .  #x1F41B)
           ("ANT"                                                                             .  #x1F41C)
           ("HONEYBEE"                                                                        .  #x1F41D)
           ("LADY BEETLE"                                                                     .  #x1F41E)
           ("FISH"                                                                            .  #x1F41F)
           ("TROPICAL FISH"                                                                   .  #x1F420)
           ("BLOWFISH"                                                                        .  #x1F421)
           ("TURTLE"                                                                          .  #x1F422)
           ("HATCHING CHICK"                                                                  .  #x1F423)
           ("BABY CHICK"                                                                      .  #x1F424)
           ("FRONT-FACING BABY CHICK"                                                         .  #x1F425)
           ("BIRD"                                                                            .  #x1F426)
           ("PENGUIN"                                                                         .  #x1F427)
           ("KOALA"                                                                           .  #x1F428)
           ("POODLE"                                                                          .  #x1F429)
           ("DROMEDARY CAMEL"                                                                 .  #x1F42A)
           ("BACTRIAN CAMEL"                                                                  .  #x1F42B)
           ("DOLPHIN"                                                                         .  #x1F42C)
           ("MOUSE FACE"                                                                      .  #x1F42D)
           ("COW FACE"                                                                        .  #x1F42E)
           ("TIGER FACE"                                                                      .  #x1F42F)
           ("RABBIT FACE"                                                                     .  #x1F430)
           ("CAT FACE"                                                                        .  #x1F431)
           ("DRAGON FACE"                                                                     .  #x1F432)
           ("SPOUTING WHALE"                                                                  .  #x1F433)
           ("HORSE FACE"                                                                      .  #x1F434)
           ("MONKEY FACE"                                                                     .  #x1F435)
           ("DOG FACE"                                                                        .  #x1F436)
           ("PIG FACE"                                                                        .  #x1F437)
           ("FROG FACE"                                                                       .  #x1F438)
           ("HAMSTER FACE"                                                                    .  #x1F439)
           ("WOLF FACE"                                                                       .  #x1F43A)
           ("BEAR FACE"                                                                       .  #x1F43B)
           ("PANDA FACE"                                                                      .  #x1F43C)
           ("PIG NOSE"                                                                        .  #x1F43D)
           ("PAW PRINTS"                                                                      .  #x1F43E)
           ("EYES"                                                                            .  #x1F440)
           ("EAR"                                                                             .  #x1F442)
           ("NOSE"                                                                            .  #x1F443)
           ("MOUTH"                                                                           .  #x1F444)
           ("TONGUE"                                                                          .  #x1F445)
           ("WHITE UP POINTING BACKHAND INDEX"                                                .  #x1F446)
           ("WHITE DOWN POINTING BACKHAND INDEX"                                              .  #x1F447)
           ("WHITE LEFT POINTING BACKHAND INDEX"                                              .  #x1F448)
           ("WHITE RIGHT POINTING BACKHAND INDEX"                                             .  #x1F449)
           ("FISTED HAND SIGN"                                                                .  #x1F44A)
           ("WAVING HAND SIGN"                                                                .  #x1F44B)
           ("OK HAND SIGN"                                                                    .  #x1F44C)
           ("THUMBS UP SIGN"                                                                  .  #x1F44D)
           ("THUMBS DOWN SIGN"                                                                .  #x1F44E)
           ("CLAPPING HANDS SIGN"                                                             .  #x1F44F)
           ("OPEN HANDS SIGN"                                                                 .  #x1F450)
           ("CROWN"                                                                           .  #x1F451)
           ("WOMANS HAT"                                                                      .  #x1F452)
           ("EYEGLASSES"                                                                      .  #x1F453)
           ("NECKTIE"                                                                         .  #x1F454)
           ("T-SHIRT"                                                                         .  #x1F455)
           ("JEANS"                                                                           .  #x1F456)
           ("DRESS"                                                                           .  #x1F457)
           ("KIMONO"                                                                          .  #x1F458)
           ("BIKINI"                                                                          .  #x1F459)
           ("WOMANS CLOTHES"                                                                  .  #x1F45A)
           ("PURSE"                                                                           .  #x1F45B)
           ("HANDBAG"                                                                         .  #x1F45C)
           ("POUCH"                                                                           .  #x1F45D)
           ("MANS SHOE"                                                                       .  #x1F45E)
           ("ATHLETIC SHOE"                                                                   .  #x1F45F)
           ("HIGH-HEELED SHOE"                                                                .  #x1F460)
           ("WOMANS SANDAL"                                                                   .  #x1F461)
           ("WOMANS BOOTS"                                                                    .  #x1F462)
           ("FOOTPRINTS"                                                                      .  #x1F463)
           ("BUST IN SILHOUETTE"                                                              .  #x1F464)
           ("BUSTS IN SILHOUETTE"                                                             .  #x1F465)
           ("BOY"                                                                             .  #x1F466)
           ("GIRL"                                                                            .  #x1F467)
           ("MAN"                                                                             .  #x1F468)
           ("WOMAN"                                                                           .  #x1F469)
           ("FAMILY"                                                                          .  #x1F46A)
           ("MAN AND WOMAN HOLDING HANDS"                                                     .  #x1F46B)
           ("TWO MEN HOLDING HANDS"                                                           .  #x1F46C)
           ("TWO WOMEN HOLDING HANDS"                                                         .  #x1F46D)
           ("POLICE OFFICER"                                                                  .  #x1F46E)
           ("WOMAN WITH BUNNY EARS"                                                           .  #x1F46F)
           ("BRIDE WITH VEIL"                                                                 .  #x1F470)
           ("PERSON WITH BLOND HAIR"                                                          .  #x1F471)
           ("MAN WITH GUA PI MAO"                                                             .  #x1F472)
           ("MAN WITH TURBAN"                                                                 .  #x1F473)
           ("OLDER MAN"                                                                       .  #x1F474)
           ("OLDER WOMAN"                                                                     .  #x1F475)
           ("BABY"                                                                            .  #x1F476)
           ("CONSTRUCTION WORKER"                                                             .  #x1F477)
           ("PRINCESS"                                                                        .  #x1F478)
           ("JAPANESE OGRE"                                                                   .  #x1F479)
           ("JAPANESE GOBLIN"                                                                 .  #x1F47A)
           ("GHOST"                                                                           .  #x1F47B)
           ("BABY ANGEL"                                                                      .  #x1F47C)
           ("EXTRATERRESTRIAL ALIEN"                                                          .  #x1F47D)
           ("ALIEN MONSTER"                                                                   .  #x1F47E)
           ("IMP"                                                                             .  #x1F47F)
           ("SKULL"                                                                           .  #x1F480)
           ("INFORMATION DESK PERSON"                                                         .  #x1F481)
           ("GUARDSMAN"                                                                       .  #x1F482)
           ("DANCER"                                                                          .  #x1F483)
           ("LIPSTICK"                                                                        .  #x1F484)
           ("NAIL POLISH"                                                                     .  #x1F485)
           ("FACE MASSAGE"                                                                    .  #x1F486)
           ("HAIRCUT"                                                                         .  #x1F487)
           ("BARBER POLE"                                                                     .  #x1F488)
           ("SYRINGE"                                                                         .  #x1F489)
           ("PILL"                                                                            .  #x1F48A)
           ("KISS MARK"                                                                       .  #x1F48B)
           ("LOVE LETTER"                                                                     .  #x1F48C)
           ("RING"                                                                            .  #x1F48D)
           ("GEM STONE"                                                                       .  #x1F48E)
           ("KISS"                                                                            .  #x1F48F)
           ("BOUQUET"                                                                         .  #x1F490)
           ("COUPLE WITH HEART"                                                               .  #x1F491)
           ("WEDDING"                                                                         .  #x1F492)
           ("BEATING HEART"                                                                   .  #x1F493)
           ("BROKEN HEART"                                                                    .  #x1F494)
           ("TWO HEARTS"                                                                      .  #x1F495)
           ("SPARKLING HEART"                                                                 .  #x1F496)
           ("GROWING HEART"                                                                   .  #x1F497)
           ("HEART WITH ARROW"                                                                .  #x1F498)
           ("BLUE HEART"                                                                      .  #x1F499)
           ("GREEN HEART"                                                                     .  #x1F49A)
           ("YELLOW HEART"                                                                    .  #x1F49B)
           ("PURPLE HEART"                                                                    .  #x1F49C)
           ("HEART WITH RIBBON"                                                               .  #x1F49D)
           ("REVOLVING HEARTS"                                                                .  #x1F49E)
           ("HEART DECORATION"                                                                .  #x1F49F)
           ("DIAMOND SHAPE WITH A DOT INSIDE"                                                 .  #x1F4A0)
           ("ELECTRIC LIGHT BULB"                                                             .  #x1F4A1)
           ("ANGER SYMBOL"                                                                    .  #x1F4A2)
           ("BOMB"                                                                            .  #x1F4A3)
           ("SLEEPING SYMBOL"                                                                 .  #x1F4A4)
           ("COLLISION SYMBOL"                                                                .  #x1F4A5)
           ("SPLASHING SWEAT SYMBOL"                                                          .  #x1F4A6)
           ("DROPLET"                                                                         .  #x1F4A7)
           ("DASH SYMBOL"                                                                     .  #x1F4A8)
           ("PILE OF POO"                                                                     .  #x1F4A9)
           ("FLEXED BICEPS"                                                                   .  #x1F4AA)
           ("DIZZY SYMBOL"                                                                    .  #x1F4AB)
           ("SPEECH BALLOON"                                                                  .  #x1F4AC)
           ("THOUGHT BALLOON"                                                                 .  #x1F4AD)
           ("WHITE FLOWER"                                                                    .  #x1F4AE)
           ("HUNDRED POINTS SYMBOL"                                                           .  #x1F4AF)
           ("MONEY BAG"                                                                       .  #x1F4B0)
           ("CURRENCY EXCHANGE"                                                               .  #x1F4B1)
           ("HEAVY DOLLAR SIGN"                                                               .  #x1F4B2)
           ("CREDIT CARD"                                                                     .  #x1F4B3)
           ("BANKNOTE WITH YEN SIGN"                                                          .  #x1F4B4)
           ("BANKNOTE WITH DOLLAR SIGN"                                                       .  #x1F4B5)
           ("BANKNOTE WITH EURO SIGN"                                                         .  #x1F4B6)
           ("BANKNOTE WITH POUND SIGN"                                                        .  #x1F4B7)
           ("MONEY WITH WINGS"                                                                .  #x1F4B8)
           ("CHART WITH UPWARDS TREND AND YEN SIGN"                                           .  #x1F4B9)
           ("SEAT"                                                                            .  #x1F4BA)
           ("PERSONAL COMPUTER"                                                               .  #x1F4BB)
           ("BRIEFCASE"                                                                       .  #x1F4BC)
           ("MINIDISC"                                                                        .  #x1F4BD)
           ("FLOPPY DISK"                                                                     .  #x1F4BE)
           ("OPTICAL DISC"                                                                    .  #x1F4BF)
           ("DVD"                                                                             .  #x1F4C0)
           ("FILE FOLDER"                                                                     .  #x1F4C1)
           ("OPEN FILE FOLDER"                                                                .  #x1F4C2)
           ("PAGE WITH CURL"                                                                  .  #x1F4C3)
           ("PAGE FACING UP"                                                                  .  #x1F4C4)
           ("CALENDAR"                                                                        .  #x1F4C5)
           ("TEAR-OFF CALENDAR"                                                               .  #x1F4C6)
           ("CARD INDEX"                                                                      .  #x1F4C7)
           ("CHART WITH UPWARDS TREND"                                                        .  #x1F4C8)
           ("CHART WITH DOWNWARDS TREND"                                                      .  #x1F4C9)
           ("BAR CHART"                                                                       .  #x1F4CA)
           ("CLIPBOARD"                                                                       .  #x1F4CB)
           ("PUSHPIN"                                                                         .  #x1F4CC)
           ("ROUND PUSHPIN"                                                                   .  #x1F4CD)
           ("PAPERCLIP"                                                                       .  #x1F4CE)
           ("STRAIGHT RULER"                                                                  .  #x1F4CF)
           ("TRIANGULAR RULER"                                                                .  #x1F4D0)
           ("BOOKMARK TABS"                                                                   .  #x1F4D1)
           ("LEDGER"                                                                          .  #x1F4D2)
           ("NOTEBOOK"                                                                        .  #x1F4D3)
           ("NOTEBOOK WITH DECORATIVE COVER"                                                  .  #x1F4D4)
           ("CLOSED BOOK"                                                                     .  #x1F4D5)
           ("OPEN BOOK"                                                                       .  #x1F4D6)
           ("GREEN BOOK"                                                                      .  #x1F4D7)
           ("BLUE BOOK"                                                                       .  #x1F4D8)
           ("ORANGE BOOK"                                                                     .  #x1F4D9)
           ("BOOKS"                                                                           .  #x1F4DA)
           ("NAME BADGE"                                                                      .  #x1F4DB)
           ("SCROLL"                                                                          .  #x1F4DC)
           ("MEMO"                                                                            .  #x1F4DD)
           ("TELEPHONE RECEIVER"                                                              .  #x1F4DE)
           ("PAGER"                                                                           .  #x1F4DF)
           ("FAX MACHINE"                                                                     .  #x1F4E0)
           ("SATELLITE ANTENNA"                                                               .  #x1F4E1)
           ("PUBLIC ADDRESS LOUDSPEAKER"                                                      .  #x1F4E2)
           ("CHEERING MEGAPHONE"                                                              .  #x1F4E3)
           ("OUTBOX TRAY"                                                                     .  #x1F4E4)
           ("INBOX TRAY"                                                                      .  #x1F4E5)
           ("PACKAGE"                                                                         .  #x1F4E6)
           ("E-MAIL SYMBOL"                                                                   .  #x1F4E7)
           ("INCOMING ENVELOPE"                                                               .  #x1F4E8)
           ("ENVELOPE WITH DOWNWARDS ARROW ABOVE"                                             .  #x1F4E9)
           ("CLOSED MAILBOX WITH LOWERED FLAG"                                                .  #x1F4EA)
           ("CLOSED MAILBOX WITH RAISED FLAG"                                                 .  #x1F4EB)
           ("OPEN MAILBOX WITH RAISED FLAG"                                                   .  #x1F4EC)
           ("OPEN MAILBOX WITH LOWERED FLAG"                                                  .  #x1F4ED)
           ("POSTBOX"                                                                         .  #x1F4EE)
           ("POSTAL HORN"                                                                     .  #x1F4EF)
           ("NEWSPAPER"                                                                       .  #x1F4F0)
           ("MOBILE PHONE"                                                                    .  #x1F4F1)
           ("MOBILE PHONE WITH RIGHTWARDS ARROW AT LEFT"                                      .  #x1F4F2)
           ("VIBRATION MODE"                                                                  .  #x1F4F3)
           ("MOBILE PHONE OFF"                                                                .  #x1F4F4)
           ("NO MOBILE PHONES"                                                                .  #x1F4F5)
           ("ANTENNA WITH BARS"                                                               .  #x1F4F6)
           ("CAMERA"                                                                          .  #x1F4F7)
           ("VIDEO CAMERA"                                                                    .  #x1F4F9)
           ("TELEVISION"                                                                      .  #x1F4FA)
           ("RADIO"                                                                           .  #x1F4FB)
           ("VIDEOCASSETTE"                                                                   .  #x1F4FC)
           ("TWISTED RIGHTWARDS ARROWS"                                                       .  #x1F500)
           ("CLOCKWISE RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS"                           .  #x1F501)
           ("CLOCKWISE RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS WITH CIRCLED ONE OVERLAY"  .  #x1F502)
           ("CLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS"                              .  #x1F503)
           ("ANTICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS"                          .  #x1F504)
           ("LOW BRIGHTNESS SYMBOL"                                                           .  #x1F505)
           ("HIGH BRIGHTNESS SYMBOL"                                                          .  #x1F506)
           ("SPEAKER WITH CANCELLATION STROKE"                                                .  #x1F507)
           ("SPEAKER"                                                                         .  #x1F508)
           ("SPEAKER WITH ONE SOUND WAVE"                                                     .  #x1F509)
           ("SPEAKER WITH THREE SOUND WAVES"                                                  .  #x1F50A)
           ("BATTERY"                                                                         .  #x1F50B)
           ("ELECTRIC PLUG"                                                                   .  #x1F50C)
           ("LEFT-POINTING MAGNIFYING GLASS"                                                  .  #x1F50D)
           ("RIGHT-POINTING MAGNIFYING GLASS"                                                 .  #x1F50E)
           ("LOCK WITH INK PEN"                                                               .  #x1F50F)
           ("CLOSED LOCK WITH KEY"                                                            .  #x1F510)
           ("KEY"                                                                             .  #x1F511)
           ("LOCK"                                                                            .  #x1F512)
           ("OPEN LOCK"                                                                       .  #x1F513)
           ("BELL"                                                                            .  #x1F514)
           ("BELL WITH CANCELLATION STROKE"                                                   .  #x1F515)
           ("BOOKMARK"                                                                        .  #x1F516)
           ("LINK SYMBOL"                                                                     .  #x1F517)
           ("RADIO BUTTON"                                                                    .  #x1F518)
           ("BACK WITH LEFTWARDS ARROW ABOVE"                                                 .  #x1F519)
           ("END WITH LEFTWARDS ARROW ABOVE"                                                  .  #x1F51A)
           ("ON WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE"                            .  #x1F51B)
           ("SOON WITH RIGHTWARDS ARROW ABOVE"                                                .  #x1F51C)
           ("TOP WITH UPWARDS ARROW ABOVE"                                                    .  #x1F51D)
           ("NO ONE UNDER EIGHTEEN SYMBOL"                                                    .  #x1F51E)
           ("KEYCAP TEN"                                                                      .  #x1F51F)
           ("INPUT SYMBOL FOR LATIN CAPITAL LETTERS"                                          .  #x1F520)
           ("INPUT SYMBOL FOR LATIN SMALL LETTERS"                                            .  #x1F521)
           ("INPUT SYMBOL FOR NUMBERS"                                                        .  #x1F522)
           ("INPUT SYMBOL FOR SYMBOLS"                                                        .  #x1F523)
           ("INPUT SYMBOL FOR LATIN LETTERS"                                                  .  #x1F524)
           ("FIRE"                                                                            .  #x1F525)
           ("ELECTRIC TORCH"                                                                  .  #x1F526)
           ("WRENCH"                                                                          .  #x1F527)
           ("HAMMER"                                                                          .  #x1F528)
           ("NUT AND BOLT"                                                                    .  #x1F529)
           ("HOCHO"                                                                           .  #x1F52A)
           ("PISTOL"                                                                          .  #x1F52B)
           ("MICROSCOPE"                                                                      .  #x1F52C)
           ("TELESCOPE"                                                                       .  #x1F52D)
           ("CRYSTAL BALL"                                                                    .  #x1F52E)
           ("SIX POINTED STAR WITH MIDDLE DOT"                                                .  #x1F52F)
           ("JAPANESE SYMBOL FOR BEGINNER"                                                    .  #x1F530)
           ("TRIDENT EMBLEM"                                                                  .  #x1F531)
           ("BLACK SQUARE BUTTON"                                                             .  #x1F532)
           ("WHITE SQUARE BUTTON"                                                             .  #x1F533)
           ("LARGE RED CIRCLE"                                                                .  #x1F534)
           ("LARGE BLUE CIRCLE"                                                               .  #x1F535)
           ("LARGE ORANGE DIAMOND"                                                            .  #x1F536)
           ("LARGE BLUE DIAMOND"                                                              .  #x1F537)
           ("SMALL ORANGE DIAMOND"                                                            .  #x1F538)
           ("SMALL BLUE DIAMOND"                                                              .  #x1F539)
           ("UP-POINTING RED TRIANGLE"                                                        .  #x1F53A)
           ("DOWN-POINTING RED TRIANGLE"                                                      .  #x1F53B)
           ("UP-POINTING SMALL RED TRIANGLE"                                                  .  #x1F53C)
           ("DOWN-POINTING SMALL RED TRIANGLE"                                                .  #x1F53D)
           ("CLOCK FACE ONE OCLOCK"                                                           .  #x1F550)
           ("CLOCK FACE TWO OCLOCK"                                                           .  #x1F551)
           ("CLOCK FACE THREE OCLOCK"                                                         .  #x1F552)
           ("CLOCK FACE FOUR OCLOCK"                                                          .  #x1F553)
           ("CLOCK FACE FIVE OCLOCK"                                                          .  #x1F554)
           ("CLOCK FACE SIX OCLOCK"                                                           .  #x1F555)
           ("CLOCK FACE SEVEN OCLOCK"                                                         .  #x1F556)
           ("CLOCK FACE EIGHT OCLOCK"                                                         .  #x1F557)
           ("CLOCK FACE NINE OCLOCK"                                                          .  #x1F558)
           ("CLOCK FACE TEN OCLOCK"                                                           .  #x1F559)
           ("CLOCK FACE ELEVEN OCLOCK"                                                        .  #x1F55A)
           ("CLOCK FACE TWELVE OCLOCK"                                                        .  #x1F55B)
           ("CLOCK FACE ONE-THIRTY"                                                           .  #x1F55C)
           ("CLOCK FACE TWO-THIRTY"                                                           .  #x1F55D)
           ("CLOCK FACE THREE-THIRTY"                                                         .  #x1F55E)
           ("CLOCK FACE FOUR-THIRTY"                                                          .  #x1F55F)
           ("CLOCK FACE FIVE-THIRTY"                                                          .  #x1F560)
           ("CLOCK FACE SIX-THIRTY"                                                           .  #x1F561)
           ("CLOCK FACE SEVEN-THIRTY"                                                         .  #x1F562)
           ("CLOCK FACE EIGHT-THIRTY"                                                         .  #x1F563)
           ("CLOCK FACE NINE-THIRTY"                                                          .  #x1F564)
           ("CLOCK FACE TEN-THIRTY"                                                           .  #x1F565)
           ("CLOCK FACE ELEVEN-THIRTY"                                                        .  #x1F566)
           ("CLOCK FACE TWELVE-THIRTY"                                                        .  #x1F567)
           ("MOUNT FUJI"                                                                      .  #x1F5FB)
           ("TOKYO TOWER"                                                                     .  #x1F5FC)
           ("STATUE OF LIBERTY"                                                               .  #x1F5FD)
           ("SILHOUETTE OF JAPAN"                                                             .  #x1F5FE)
           ("MOYAI"                                                                           .  #x1F5FF)
           ("GRINNING FACE WITH SMILING EYES"                                                 .  #x1F601)
           ("FACE WITH TEARS OF JOY"                                                          .  #x1F602)
           ("SMILING FACE WITH OPEN MOUTH"                                                    .  #x1F603)
           ("SMILING FACE WITH OPEN MOUTH AND SMILING EYES"                                   .  #x1F604)
           ("SMILING FACE WITH OPEN MOUTH AND COLD SWEAT"                                     .  #x1F605)
           ("SMILING FACE WITH OPEN MOUTH AND TIGHTLY-CLOSED EYES"                            .  #x1F606)
           ("SMILING FACE WITH HALO"                                                          .  #x1F607)
           ("SMILING FACE WITH HORNS"                                                         .  #x1F608)
           ("WINKING FACE"                                                                    .  #x1F609)
           ("SMILING FACE WITH SMILING EYES"                                                  .  #x1F60A)
           ("FACE SAVOURING DELICIOUS FOOD"                                                   .  #x1F60B)
           ("RELIEVED FACE"                                                                   .  #x1F60C)
           ("SMILING FACE WITH HEART-SHAPED EYES"                                             .  #x1F60D)
           ("SMILING FACE WITH SUNGLASSES"                                                    .  #x1F60E)
           ("SMIRKING FACE"                                                                   .  #x1F60F)
           ("NEUTRAL FACE"                                                                    .  #x1F610)
           ("UNAMUSED FACE"                                                                   .  #x1F612)
           ("FACE WITH COLD SWEAT"                                                            .  #x1F613)
           ("PENSIVE FACE"                                                                    .  #x1F614)
           ("CONFOUNDED FACE"                                                                 .  #x1F616)
           ("FACE THROWING A KISS"                                                            .  #x1F618)
           ("KISSING FACE WITH CLOSED EYES"                                                   .  #x1F61A)
           ("FACE WITH STUCK-OUT TONGUE AND WINKING EYE"                                      .  #x1F61C)
           ("FACE WITH STUCK-OUT TONGUE AND TIGHTLY-CLOSED EYES"                              .  #x1F61D)
           ("DISAPPOINTED FACE"                                                               .  #x1F61E)
           ("ANGRY FACE"                                                                      .  #x1F620)
           ("POUTING FACE"                                                                    .  #x1F621)
           ("CRYING FACE"                                                                     .  #x1F622)
           ("PERSEVERING FACE"                                                                .  #x1F623)
           ("FACE WITH LOOK OF TRIUMPH"                                                       .  #x1F624)
           ("DISAPPOINTED BUT RELIEVED FACE"                                                  .  #x1F625)
           ("FEARFUL FACE"                                                                    .  #x1F628)
           ("WEARY FACE"                                                                      .  #x1F629)
           ("SLEEPY FACE"                                                                     .  #x1F62A)
           ("TIRED FACE"                                                                      .  #x1F62B)
           ("LOUDLY CRYING FACE"                                                              .  #x1F62D)
           ("FACE WITH OPEN MOUTH AND COLD SWEAT"                                             .  #x1F630)
           ("FACE SCREAMING IN FEAR"                                                          .  #x1F631)
           ("ASTONISHED FACE"                                                                 .  #x1F632)
           ("FLUSHED FACE"                                                                    .  #x1F633)
           ("DIZZY FACE"                                                                      .  #x1F635)
           ("FACE WITHOUT MOUTH"                                                              .  #x1F636)
           ("FACE WITH MEDICAL MASK"                                                          .  #x1F637)
           ("GRINNING CAT FACE WITH SMILING EYES"                                             .  #x1F638)
           ("CAT FACE WITH TEARS OF JOY"                                                      .  #x1F639)
           ("SMILING CAT FACE WITH OPEN MOUTH"                                                .  #x1F63A)
           ("SMILING CAT FACE WITH HEART-SHAPED EYES"                                         .  #x1F63B)
           ("CAT FACE WITH WRY SMILE"                                                         .  #x1F63C)
           ("KISSING CAT FACE WITH CLOSED EYES"                                               .  #x1F63D)
           ("POUTING CAT FACE"                                                                .  #x1F63E)
           ("CRYING CAT FACE"                                                                 .  #x1F63F)
           ("WEARY CAT FACE"                                                                  .  #x1F640)
           ("FACE WITH NO GOOD GESTURE"                                                       .  #x1F645)
           ("FACE WITH OK GESTURE"                                                            .  #x1F646)
           ("PERSON BOWING DEEPLY"                                                            .  #x1F647)
           ("SEE-NO-EVIL MONKEY"                                                              .  #x1F648)
           ("HEAR-NO-EVIL MONKEY"                                                             .  #x1F649)
           ("SPEAK-NO-EVIL MONKEY"                                                            .  #x1F64A)
           ("HAPPY PERSON RAISING ONE HAND"                                                   .  #x1F64B)
           ("PERSON RAISING BOTH HANDS IN CELEBRATION"                                        .  #x1F64C)
           ("PERSON FROWNING"                                                                 .  #x1F64D)
           ("PERSON WITH POUTING FACE"                                                        .  #x1F64E)
           ("PERSON WITH FOLDED HANDS"                                                        .  #x1F64F)
           ("ROCKET"                                                                          .  #x1F680)
           ("HELICOPTER"                                                                      .  #x1F681)
           ("STEAM LOCOMOTIVE"                                                                .  #x1F682)
           ("RAILWAY CAR"                                                                     .  #x1F683)
           ("HIGH-SPEED TRAIN"                                                                .  #x1F684)
           ("HIGH-SPEED TRAIN WITH BULLET NOSE"                                               .  #x1F685)
           ("TRAIN"                                                                           .  #x1F686)
           ("METRO"                                                                           .  #x1F687)
           ("LIGHT RAIL"                                                                      .  #x1F688)
           ("STATION"                                                                         .  #x1F689)
           ("TRAM"                                                                            .  #x1F68A)
           ("TRAM CAR"                                                                        .  #x1F68B)
           ("BUS"                                                                             .  #x1F68C)
           ("ONCOMING BUS"                                                                    .  #x1F68D)
           ("TROLLEYBUS"                                                                      .  #x1F68E)
           ("BUS STOP"                                                                        .  #x1F68F)
           ("MINIBUS"                                                                         .  #x1F690)
           ("AMBULANCE"                                                                       .  #x1F691)
           ("FIRE ENGINE"                                                                     .  #x1F692)
           ("POLICE CAR"                                                                      .  #x1F693)
           ("ONCOMING POLICE CAR"                                                             .  #x1F694)
           ("TAXI"                                                                            .  #x1F695)
           ("ONCOMING TAXI"                                                                   .  #x1F696)
           ("AUTOMOBILE"                                                                      .  #x1F697)
           ("ONCOMING AUTOMOBILE"                                                             .  #x1F698)
           ("RECREATIONAL VEHICLE"                                                            .  #x1F699)
           ("DELIVERY TRUCK"                                                                  .  #x1F69A)
           ("ARTICULATED LORRY"                                                               .  #x1F69B)
           ("TRACTOR"                                                                         .  #x1F69C)
           ("MONORAIL"                                                                        .  #x1F69D)
           ("MOUNTAIN RAILWAY"                                                                .  #x1F69E)
           ("SUSPENSION RAILWAY"                                                              .  #x1F69F)
           ("MOUNTAIN CABLEWAY"                                                               .  #x1F6A0)
           ("AERIAL TRAMWAY"                                                                  .  #x1F6A1)
           ("SHIP"                                                                            .  #x1F6A2)
           ("ROWBOAT"                                                                         .  #x1F6A3)
           ("SPEEDBOAT"                                                                       .  #x1F6A4)
           ("HORIZONTAL TRAFFIC LIGHT"                                                        .  #x1F6A5)
           ("VERTICAL TRAFFIC LIGHT"                                                          .  #x1F6A6)
           ("CONSTRUCTION SIGN"                                                               .  #x1F6A7)
           ("POLICE CARS REVOLVING LIGHT"                                                     .  #x1F6A8)
           ("TRIANGULAR FLAG ON POST"                                                         .  #x1F6A9)
           ("DOOR"                                                                            .  #x1F6AA)
           ("NO ENTRY SIGN"                                                                   .  #x1F6AB)
           ("SMOKING SYMBOL"                                                                  .  #x1F6AC)
           ("NO SMOKING SYMBOL"                                                               .  #x1F6AD)
           ("PUT LITTER IN ITS PLACE SYMBOL"                                                  .  #x1F6AE)
           ("DO NOT LITTER SYMBOL"                                                            .  #x1F6AF)
           ("POTABLE WATER SYMBOL"                                                            .  #x1F6B0)
           ("NON-POTABLE WATER SYMBOL"                                                        .  #x1F6B1)
           ("BICYCLE"                                                                         .  #x1F6B2)
           ("NO BICYCLES"                                                                     .  #x1F6B3)
           ("BICYCLIST"                                                                       .  #x1F6B4)
           ("MOUNTAIN BICYCLIST"                                                              .  #x1F6B5)
           ("PEDESTRIAN"                                                                      .  #x1F6B6)
           ("NO PEDESTRIANS"                                                                  .  #x1F6B7)
           ("CHILDREN CROSSING"                                                               .  #x1F6B8)
           ("MENS SYMBOL"                                                                     .  #x1F6B9)
           ("WOMENS SYMBOL"                                                                   .  #x1F6BA)
           ("RESTROOM"                                                                        .  #x1F6BB)
           ("BABY SYMBOL"                                                                     .  #x1F6BC)
           ("TOILET"                                                                          .  #x1F6BD)
           ("WATER CLOSET"                                                                    .  #x1F6BE)
           ("SHOWER"                                                                          .  #x1F6BF)
           ("BATH"                                                                            .  #x1F6C0)
           ("BATHTUB"                                                                         .  #x1F6C1)
           ("PASSPORT CONTROL"                                                                .  #x1F6C2)
           ("CUSTOMS"                                                                         .  #x1F6C3)
           ("BAGGAGE CLAIM"                                                                   .  #x1F6C4)
           ("LEFT LUGGAGE"                                                                    .  #x1F6C5)
           ("ALCHEMICAL SYMBOL FOR QUINTESSENCE"                                              .  #x1F700)
           ("ALCHEMICAL SYMBOL FOR AIR"                                                       .  #x1F701)
           ("ALCHEMICAL SYMBOL FOR FIRE"                                                      .  #x1F702)
           ("ALCHEMICAL SYMBOL FOR EARTH"                                                     .  #x1F703)
           ("ALCHEMICAL SYMBOL FOR WATER"                                                     .  #x1F704)
           ("ALCHEMICAL SYMBOL FOR AQUAFORTIS"                                                .  #x1F705)
           ("ALCHEMICAL SYMBOL FOR AQUA REGIA"                                                .  #x1F706)
           ("ALCHEMICAL SYMBOL FOR AQUA REGIA-2"                                              .  #x1F707)
           ("ALCHEMICAL SYMBOL FOR AQUA VITAE"                                                .  #x1F708)
           ("ALCHEMICAL SYMBOL FOR AQUA VITAE-2"                                              .  #x1F709)
           ("ALCHEMICAL SYMBOL FOR VINEGAR"                                                   .  #x1F70A)
           ("ALCHEMICAL SYMBOL FOR VINEGAR-2"                                                 .  #x1F70B)
           ("ALCHEMICAL SYMBOL FOR VINEGAR-3"                                                 .  #x1F70C)
           ("ALCHEMICAL SYMBOL FOR SULFUR"                                                    .  #x1F70D)
           ("ALCHEMICAL SYMBOL FOR PHILOSOPHERS SULFUR"                                       .  #x1F70E)
           ("ALCHEMICAL SYMBOL FOR BLACK SULFUR"                                              .  #x1F70F)
           ("ALCHEMICAL SYMBOL FOR MERCURY SUBLIMATE"                                         .  #x1F710)
           ("ALCHEMICAL SYMBOL FOR MERCURY SUBLIMATE-2"                                       .  #x1F711)
           ("ALCHEMICAL SYMBOL FOR MERCURY SUBLIMATE-3"                                       .  #x1F712)
           ("ALCHEMICAL SYMBOL FOR CINNABAR"                                                  .  #x1F713)
           ("ALCHEMICAL SYMBOL FOR SALT"                                                      .  #x1F714)
           ("ALCHEMICAL SYMBOL FOR NITRE"                                                     .  #x1F715)
           ("ALCHEMICAL SYMBOL FOR VITRIOL"                                                   .  #x1F716)
           ("ALCHEMICAL SYMBOL FOR VITRIOL-2"                                                 .  #x1F717)
           ("ALCHEMICAL SYMBOL FOR ROCK SALT"                                                 .  #x1F718)
           ("ALCHEMICAL SYMBOL FOR ROCK SALT-2"                                               .  #x1F719)
           ("ALCHEMICAL SYMBOL FOR GOLD"                                                      .  #x1F71A)
           ("ALCHEMICAL SYMBOL FOR SILVER"                                                    .  #x1F71B)
           ("ALCHEMICAL SYMBOL FOR IRON ORE"                                                  .  #x1F71C)
           ("ALCHEMICAL SYMBOL FOR IRON ORE-2"                                                .  #x1F71D)
           ("ALCHEMICAL SYMBOL FOR CROCUS OF IRON"                                            .  #x1F71E)
           ("ALCHEMICAL SYMBOL FOR REGULUS OF IRON"                                           .  #x1F71F)
           ("ALCHEMICAL SYMBOL FOR COPPER ORE"                                                .  #x1F720)
           ("ALCHEMICAL SYMBOL FOR IRON-COPPER ORE"                                           .  #x1F721)
           ("ALCHEMICAL SYMBOL FOR SUBLIMATE OF COPPER"                                       .  #x1F722)
           ("ALCHEMICAL SYMBOL FOR CROCUS OF COPPER"                                          .  #x1F723)
           ("ALCHEMICAL SYMBOL FOR CROCUS OF COPPER-2"                                        .  #x1F724)
           ("ALCHEMICAL SYMBOL FOR COPPER ANTIMONIATE"                                        .  #x1F725)
           ("ALCHEMICAL SYMBOL FOR SALT OF COPPER ANTIMONIATE"                                .  #x1F726)
           ("ALCHEMICAL SYMBOL FOR SUBLIMATE OF SALT OF COPPER"                               .  #x1F727)
           ("ALCHEMICAL SYMBOL FOR VERDIGRIS"                                                 .  #x1F728)
           ("ALCHEMICAL SYMBOL FOR TIN ORE"                                                   .  #x1F729)
           ("ALCHEMICAL SYMBOL FOR LEAD ORE"                                                  .  #x1F72A)
           ("ALCHEMICAL SYMBOL FOR ANTIMONY ORE"                                              .  #x1F72B)
           ("ALCHEMICAL SYMBOL FOR SUBLIMATE OF ANTIMONY"                                     .  #x1F72C)
           ("ALCHEMICAL SYMBOL FOR SALT OF ANTIMONY"                                          .  #x1F72D)
           ("ALCHEMICAL SYMBOL FOR SUBLIMATE OF SALT OF ANTIMONY"                             .  #x1F72E)
           ("ALCHEMICAL SYMBOL FOR VINEGAR OF ANTIMONY"                                       .  #x1F72F)
           ("ALCHEMICAL SYMBOL FOR REGULUS OF ANTIMONY"                                       .  #x1F730)
           ("ALCHEMICAL SYMBOL FOR REGULUS OF ANTIMONY-2"                                     .  #x1F731)
           ("ALCHEMICAL SYMBOL FOR REGULUS"                                                   .  #x1F732)
           ("ALCHEMICAL SYMBOL FOR REGULUS-2"                                                 .  #x1F733)
           ("ALCHEMICAL SYMBOL FOR REGULUS-3"                                                 .  #x1F734)
           ("ALCHEMICAL SYMBOL FOR REGULUS-4"                                                 .  #x1F735)
           ("ALCHEMICAL SYMBOL FOR ALKALI"                                                    .  #x1F736)
           ("ALCHEMICAL SYMBOL FOR ALKALI-2"                                                  .  #x1F737)
           ("ALCHEMICAL SYMBOL FOR MARCASITE"                                                 .  #x1F738)
           ("ALCHEMICAL SYMBOL FOR SAL-AMMONIAC"                                              .  #x1F739)
           ("ALCHEMICAL SYMBOL FOR ARSENIC"                                                   .  #x1F73A)
           ("ALCHEMICAL SYMBOL FOR REALGAR"                                                   .  #x1F73B)
           ("ALCHEMICAL SYMBOL FOR REALGAR-2"                                                 .  #x1F73C)
           ("ALCHEMICAL SYMBOL FOR AURIPIGMENT"                                               .  #x1F73D)
           ("ALCHEMICAL SYMBOL FOR BISMUTH ORE"                                               .  #x1F73E)
           ("ALCHEMICAL SYMBOL FOR TARTAR"                                                    .  #x1F73F)
           ("ALCHEMICAL SYMBOL FOR TARTAR-2"                                                  .  #x1F740)
           ("ALCHEMICAL SYMBOL FOR QUICK LIME"                                                .  #x1F741)
           ("ALCHEMICAL SYMBOL FOR BORAX"                                                     .  #x1F742)
           ("ALCHEMICAL SYMBOL FOR BORAX-2"                                                   .  #x1F743)
           ("ALCHEMICAL SYMBOL FOR BORAX-3"                                                   .  #x1F744)
           ("ALCHEMICAL SYMBOL FOR ALUM"                                                      .  #x1F745)
           ("ALCHEMICAL SYMBOL FOR OIL"                                                       .  #x1F746)
           ("ALCHEMICAL SYMBOL FOR SPIRIT"                                                    .  #x1F747)
           ("ALCHEMICAL SYMBOL FOR TINCTURE"                                                  .  #x1F748)
           ("ALCHEMICAL SYMBOL FOR GUM"                                                       .  #x1F749)
           ("ALCHEMICAL SYMBOL FOR WAX"                                                       .  #x1F74A)
           ("ALCHEMICAL SYMBOL FOR POWDER"                                                    .  #x1F74B)
           ("ALCHEMICAL SYMBOL FOR CALX"                                                      .  #x1F74C)
           ("ALCHEMICAL SYMBOL FOR TUTTY"                                                     .  #x1F74D)
           ("ALCHEMICAL SYMBOL FOR CAPUT MORTUUM"                                             .  #x1F74E)
           ("ALCHEMICAL SYMBOL FOR SCEPTER OF JOVE"                                           .  #x1F74F)
           ("ALCHEMICAL SYMBOL FOR CADUCEUS"                                                  .  #x1F750)
           ("ALCHEMICAL SYMBOL FOR TRIDENT"                                                   .  #x1F751)
           ("ALCHEMICAL SYMBOL FOR STARRED TRIDENT"                                           .  #x1F752)
           ("ALCHEMICAL SYMBOL FOR LODESTONE"                                                 .  #x1F753)
           ("ALCHEMICAL SYMBOL FOR SOAP"                                                      .  #x1F754)
           ("ALCHEMICAL SYMBOL FOR URINE"                                                     .  #x1F755)
           ("ALCHEMICAL SYMBOL FOR HORSE DUNG"                                                .  #x1F756)
           ("ALCHEMICAL SYMBOL FOR ASHES"                                                     .  #x1F757)
           ("ALCHEMICAL SYMBOL FOR POT ASHES"                                                 .  #x1F758)
           ("ALCHEMICAL SYMBOL FOR BRICK"                                                     .  #x1F759)
           ("ALCHEMICAL SYMBOL FOR POWDERED BRICK"                                            .  #x1F75A)
           ("ALCHEMICAL SYMBOL FOR AMALGAM"                                                   .  #x1F75B)
           ("ALCHEMICAL SYMBOL FOR STRATUM SUPER STRATUM"                                     .  #x1F75C)
           ("ALCHEMICAL SYMBOL FOR STRATUM SUPER STRATUM-2"                                   .  #x1F75D)
           ("ALCHEMICAL SYMBOL FOR SUBLIMATION"                                               .  #x1F75E)
           ("ALCHEMICAL SYMBOL FOR PRECIPITATE"                                               .  #x1F75F)
           ("ALCHEMICAL SYMBOL FOR DISTILL"                                                   .  #x1F760)
           ("ALCHEMICAL SYMBOL FOR DISSOLVE"                                                  .  #x1F761)
           ("ALCHEMICAL SYMBOL FOR DISSOLVE-2"                                                .  #x1F762)
           ("ALCHEMICAL SYMBOL FOR PURIFY"                                                    .  #x1F763)
           ("ALCHEMICAL SYMBOL FOR PUTREFACTION"                                              .  #x1F764)
           ("ALCHEMICAL SYMBOL FOR CRUCIBLE"                                                  .  #x1F765)
           ("ALCHEMICAL SYMBOL FOR CRUCIBLE-2"                                                .  #x1F766)
           ("ALCHEMICAL SYMBOL FOR CRUCIBLE-3"                                                .  #x1F767)
           ("ALCHEMICAL SYMBOL FOR CRUCIBLE-4"                                                .  #x1F768)
           ("ALCHEMICAL SYMBOL FOR CRUCIBLE-5"                                                .  #x1F769)
           ("ALCHEMICAL SYMBOL FOR ALEMBIC"                                                   .  #x1F76A)
           ("ALCHEMICAL SYMBOL FOR BATH OF MARY"                                              .  #x1F76B)
           ("ALCHEMICAL SYMBOL FOR BATH OF VAPOURS"                                           .  #x1F76C)
           ("ALCHEMICAL SYMBOL FOR RETORT"                                                    .  #x1F76D)
           ("ALCHEMICAL SYMBOL FOR HOUR"                                                      .  #x1F76E)
           ("ALCHEMICAL SYMBOL FOR NIGHT"                                                     .  #x1F76F)
           ("ALCHEMICAL SYMBOL FOR DAY-NIGHT"                                                 .  #x1F770)
           ("ALCHEMICAL SYMBOL FOR MONTH"                                                     .  #x1F771)
           ("ALCHEMICAL SYMBOL FOR HALF DRAM"                                                 .  #x1F772)
           ("ALCHEMICAL SYMBOL FOR HALF OUNCE"                                                .  #x1F773)))

  ;; generated names for CJK Unified Ideographs Extension D
  (nconc ucs-utils-names-corrections
         (mapcar #'(lambda (x)
                     (cons (format "CJK IDEOGRAPH-%X" x) x))
                 (number-sequence #x2B740 #x2B81D))))

(provide 'ucs-utils-6.0-delta)

;;
;; Emacs
;;
;; Local Variables:
;; indent-tabs-mode: nil
;; mangle-whitespace: t
;; require-final-newline: t
;; coding: utf-8
;; byte-compile-warnings: (not cl-functions redefine)
;; End:
;;
;; LocalWords: UcsUtils
;;

;;; ucs-utils-6.0-delta.el ends here
