;;; stan-keywords.el --- Variables used by `stan-mode' -*- lexical-binding: t; -*-

;; Copyright (C) 2012, 2013, 2014, 2015, 2016  Jeffrey Arnold, Daniel Lee
;;               2019 Kazuki Yoshida

;; Author: Jeffrey Arnold <jeffrey.arnold@gmail.com>,
;;         Daniel Lee <bearlee@alum.mit.edu>,
;;         Kazuki Yoshida <kazukiyoshida@mail.harvard.edu>
;; Maintainer: Kazuki Yoshida <kazukiyoshida@mail.harvard.edu>
;; URL: https://github.com/stan-dev/stan-mode/tree/master/stan-mode
;; Keywords: languages,c
;; Created: 2012-08-18
;; Package-Requires: ((emacs "24.3"))

;; This file is not part of GNU Emacs.

;;; Commentary:

;; DO NOT EDIT! file auto generated by create_stan_keywords.py

;;; Code:

(defconst stan-keywords--language-version "2.24"
  "Stan modeling language version supported by `stan-mode'.")

(defconst stan-keywords--types-list
  '(
    "cholesky_factor_corr"
    "cholesky_factor_cov"
    "corr_matrix"
    "cov_matrix"
    "int"
    "matrix"
    "ordered"
    "positive_ordered"
    "real"
    "row_vector"
    "simplex"
    "unit_vector"
    "vector")
  "List of data types in Stan.

   This includes both variable declariations and function return types.")

(defconst stan-keywords--function-return-types-list
  '(
    "int"
    "matrix"
    "real"
    "row_vector"
    "vector"
    "void")
  "List of return types of Stan functions.")

(defconst stan-keywords--blocks-list
  '(
    "data"
    "functions"
    "generated quantities"
    "model"
    "parameters"
    "transformed data"
    "transformed parameters")
  "List of the names of blocks in Stan.")

(defconst stan-keywords--range-constraints-list
  '(
    "lower"
    "upper")
  "List of range constraint keywords in Stan.")

(defconst stan-keywords--keywords-list
  '(
    "break"
    "continue"
    "else"
    "for"
    "if"
    "in"
    "multiplier"
    "offset"
    "print"
    "reject"
    "repeat"
    "return"
    "target"
    "then"
    "until"
    "while")
  "List of keywords in Stan.")

(defconst stan-keywords--functions-list
  '(
    "Phi"
    "Phi_approx"
    "abs"
    "acos"
    "acosh"
    "add_diag"
    "algebra_solver"
    "append_array"
    "append_col"
    "append_row"
    "asin"
    "asinh"
    "atan"
    "atan2"
    "atanh"
    "bernoulli_cdf"
    "bernoulli_lccdf"
    "bernoulli_lcdf"
    "bernoulli_logit_glm_lpmf"
    "bernoulli_logit_lpmf"
    "bernoulli_logit_rng"
    "bernoulli_lpmf"
    "bernoulli_rng"
    "bessel_first_kind"
    "bessel_second_kind"
    "beta_binomial_cdf"
    "beta_binomial_lccdf"
    "beta_binomial_lcdf"
    "beta_binomial_lpmf"
    "beta_binomial_rng"
    "beta_cdf"
    "beta_lccdf"
    "beta_lcdf"
    "beta_lpdf"
    "beta_proportion_lccdf"
    "beta_proportion_lcdf"
    "beta_proportion_rng"
    "beta_rng"
    "binary_log_loss"
    "binomial_cdf"
    "binomial_lccdf"
    "binomial_lcdf"
    "binomial_logit_lpmf"
    "binomial_lpmf"
    "binomial_rng"
    "block"
    "categorical_logit_glm_lpmf"
    "categorical_logit_lpmf"
    "categorical_logit_rng"
    "categorical_lpmf"
    "categorical_rng"
    "cauchy_cdf"
    "cauchy_lccdf"
    "cauchy_lcdf"
    "cauchy_lpdf"
    "cauchy_rng"
    "cbrt"
    "ceil"
    "chi_square_cdf"
    "chi_square_lccdf"
    "chi_square_lcdf"
    "chi_square_lpdf"
    "chi_square_rng"
    "cholesky_decompose"
    "choose"
    "col"
    "cols"
    "columns_dot_product"
    "columns_dot_self"
    "cos"
    "cosh"
    "cov_exp_quad"
    "crossprod"
    "csr_extract_u"
    "csr_extract_v"
    "csr_extract_w"
    "csr_matrix_times_vector"
    "csr_to_dense_matrix"
    "cumulative_sum"
    "determinant"
    "diag_matrix"
    "diag_post_multiply"
    "diag_pre_multiply"
    "diagonal"
    "digamma"
    "dims"
    "dirichlet_lpdf"
    "dirichlet_rng"
    "distance"
    "dot_product"
    "dot_self"
    "double_exponential_cdf"
    "double_exponential_lccdf"
    "double_exponential_lcdf"
    "double_exponential_lpdf"
    "double_exponential_rng"
    "eigenvalues_sym"
    "eigenvectors_sym"
    "erf"
    "erfc"
    "exp"
    "exp2"
    "exp_mod_normal_cdf"
    "exp_mod_normal_lccdf"
    "exp_mod_normal_lcdf"
    "exp_mod_normal_lpdf"
    "exp_mod_normal_rng"
    "expm1"
    "exponential_cdf"
    "exponential_lccdf"
    "exponential_lcdf"
    "exponential_lpdf"
    "exponential_rng"
    "fabs"
    "falling_factorial"
    "fdim"
    "floor"
    "fma"
    "fmax"
    "fmin"
    "fmod"
    "frechet_cdf"
    "frechet_lccdf"
    "frechet_lcdf"
    "frechet_lpdf"
    "frechet_rng"
    "gamma_cdf"
    "gamma_lccdf"
    "gamma_lcdf"
    "gamma_lpdf"
    "gamma_p"
    "gamma_q"
    "gamma_rng"
    "gaussian_dlm_obs_lpdf"
    "gumbel_cdf"
    "gumbel_lccdf"
    "gumbel_lcdf"
    "gumbel_lpdf"
    "gumbel_rng"
    "head"
    "hypergeometric_lpmf"
    "hypergeometric_rng"
    "hypot"
    "inc_beta"
    "int_step"
    "integrate_1d"
    "inv"
    "inv_Phi"
    "inv_chi_square_cdf"
    "inv_chi_square_lccdf"
    "inv_chi_square_lcdf"
    "inv_chi_square_lpdf"
    "inv_chi_square_rng"
    "inv_cloglog"
    "inv_gamma_cdf"
    "inv_gamma_lccdf"
    "inv_gamma_lcdf"
    "inv_gamma_lpdf"
    "inv_gamma_rng"
    "inv_logit"
    "inv_sqrt"
    "inv_square"
    "inv_wishart_lpdf"
    "inv_wishart_rng"
    "inverse"
    "inverse_spd"
    "is_inf"
    "is_nan"
    "lbeta"
    "lchoose"
    "lgamma"
    "lkj_corr_cholesky_lpdf"
    "lkj_corr_cholesky_rng"
    "lkj_corr_lpdf"
    "lkj_corr_rng"
    "lmgamma"
    "lmultiply"
    "log"
    "log10"
    "log1m"
    "log1m_exp"
    "log1m_inv_logit"
    "log1p"
    "log1p_exp"
    "log2"
    "log_determinant"
    "log_diff_exp"
    "log_falling_factorial"
    "log_inv_logit"
    "log_mix"
    "log_rising_factorial"
    "log_softmax"
    "log_sum_exp"
    "logistic_cdf"
    "logistic_lccdf"
    "logistic_lcdf"
    "logistic_lpdf"
    "logistic_rng"
    "logit"
    "lognormal_cdf"
    "lognormal_lccdf"
    "lognormal_lcdf"
    "lognormal_lpdf"
    "lognormal_rng"
    "map_rect"
    "matrix_exp"
    "matrix_exp_multiply"
    "matrix_power"
    "max"
    "mdivide_left_spd"
    "mdivide_left_tri_low"
    "mdivide_right_spd"
    "mdivide_right_tri_low"
    "mean"
    "min"
    "modified_bessel_first_kind"
    "modified_bessel_second_kind"
    "multi_gp_cholesky_lpdf"
    "multi_gp_lpdf"
    "multi_normal_cholesky_lpdf"
    "multi_normal_cholesky_rng"
    "multi_normal_lpdf"
    "multi_normal_prec_lpdf"
    "multi_normal_rng"
    "multi_student_t_lpdf"
    "multi_student_t_rng"
    "multinomial_logit_lpmf"
    "multinomial_logit_rng"
    "multinomial_lpmf"
    "multinomial_rng"
    "multiply_lower_tri_self_transpose"
    "neg_binomial_2_cdf"
    "neg_binomial_2_lccdf"
    "neg_binomial_2_lcdf"
    "neg_binomial_2_log_glm_lpmf"
    "neg_binomial_2_log_lpmf"
    "neg_binomial_2_log_rng"
    "neg_binomial_2_lpmf"
    "neg_binomial_2_rng"
    "neg_binomial_cdf"
    "neg_binomial_lccdf"
    "neg_binomial_lcdf"
    "neg_binomial_lpmf"
    "neg_binomial_rng"
    "normal_cdf"
    "normal_id_glm_lpdf"
    "normal_lccdf"
    "normal_lcdf"
    "normal_lpdf"
    "normal_rng"
    "num_elements"
    "ordered_logistic_glm_lpmf"
    "ordered_logistic_lpmf"
    "ordered_logistic_rng"
    "ordered_probit_lpmf"
    "ordered_probit_rng"
    "owens_t"
    "pareto_cdf"
    "pareto_lccdf"
    "pareto_lcdf"
    "pareto_lpdf"
    "pareto_rng"
    "pareto_type_2_cdf"
    "pareto_type_2_lccdf"
    "pareto_type_2_lcdf"
    "pareto_type_2_lpdf"
    "pareto_type_2_rng"
    "poisson_cdf"
    "poisson_lccdf"
    "poisson_lcdf"
    "poisson_log_glm_lpmf"
    "poisson_log_lpmf"
    "poisson_log_rng"
    "poisson_lpmf"
    "poisson_rng"
    "pow"
    "prod"
    "qr_Q"
    "qr_R"
    "qr_thin_Q"
    "qr_thin_R"
    "quad_form"
    "quad_form_diag"
    "quad_form_sym"
    "rank"
    "rayleigh_cdf"
    "rayleigh_lccdf"
    "rayleigh_lcdf"
    "rayleigh_lpdf"
    "rayleigh_rng"
    "reduce_sum"
    "rep_array"
    "rep_matrix"
    "rep_row_vector"
    "rep_vector"
    "reverse"
    "rising_factorial"
    "round"
    "row"
    "rows"
    "rows_dot_product"
    "rows_dot_self"
    "scale_matrix_exp_multiply"
    "scaled_inv_chi_square_cdf"
    "scaled_inv_chi_square_lccdf"
    "scaled_inv_chi_square_lcdf"
    "scaled_inv_chi_square_lpdf"
    "scaled_inv_chi_square_rng"
    "sd"
    "segment"
    "sin"
    "singular_values"
    "sinh"
    "size"
    "skew_normal_cdf"
    "skew_normal_lccdf"
    "skew_normal_lcdf"
    "skew_normal_lpdf"
    "skew_normal_rng"
    "softmax"
    "sort_asc"
    "sort_desc"
    "sort_indices_asc"
    "sort_indices_desc"
    "sqrt"
    "square"
    "squared_distance"
    "std_normal_cdf"
    "std_normal_lccdf"
    "std_normal_lcdf"
    "std_normal_lpdf"
    "std_normal_rng"
    "step"
    "student_t_cdf"
    "student_t_lccdf"
    "student_t_lcdf"
    "student_t_lpdf"
    "student_t_rng"
    "sub_col"
    "sub_row"
    "sum"
    "tail"
    "tan"
    "tanh"
    "tcrossprod"
    "tgamma"
    "to_array_1d"
    "to_array_2d"
    "to_matrix"
    "to_row_vector"
    "to_vector"
    "trace"
    "trace_gen_quad_form"
    "trace_quad_form"
    "trigamma"
    "trunc"
    "uniform_cdf"
    "uniform_lccdf"
    "uniform_lcdf"
    "uniform_lpdf"
    "uniform_rng"
    "variance"
    "von_mises_lpdf"
    "von_mises_rng"
    "weibull_cdf"
    "weibull_lccdf"
    "weibull_lcdf"
    "weibull_lpdf"
    "weibull_rng"
    "wiener_lpdf"
    "wishart_lpdf"
    "wishart_rng")
  "List of functions in Stan.")

(defconst stan-keywords--distribution-list
  '(
    "bernoulli"
    "bernoulli_logit"
    "bernoulli_logit_glm"
    "beta"
    "beta_binomial"
    "binomial"
    "binomial_logit"
    "categorical"
    "categorical_logit"
    "categorical_logit_glm"
    "cauchy"
    "chi_square"
    "dirichlet"
    "double_exponential"
    "exp_mod_normal"
    "exponential"
    "frechet"
    "gamma"
    "gaussian_dlm_obs"
    "gumbel"
    "hypergeometric"
    "inv_chi_square"
    "inv_gamma"
    "inv_wishart"
    "lkj_corr"
    "lkj_corr_cholesky"
    "logistic"
    "lognormal"
    "multi_gp"
    "multi_gp_cholesky"
    "multi_normal"
    "multi_normal_cholesky"
    "multi_normal_prec"
    "multi_student_t"
    "multinomial"
    "multinomial_logit"
    "neg_binomial"
    "neg_binomial_2"
    "neg_binomial_2_log"
    "neg_binomial_2_log_glm"
    "normal"
    "normal_id_glm"
    "ordered_logistic"
    "ordered_logistic_glm"
    "ordered_probit"
    "pareto"
    "pareto_type_2"
    "poisson"
    "poisson_log"
    "poisson_log_glm"
    "rayleigh"
    "scaled_inv_chi_square"
    "skew_normal"
    "std_normal"
    "student_t"
    "uniform"
    "von_mises"
    "weibull"
    "wiener"
    "wishart")
  "List of distributions in Stan.")

(defconst stan-keywords--reserved-list
  '(
    "STAN_MAJOR"
    "STAN_MATH_MAJOR"
    "STAN_MATH_MINOR"
    "STAN_MATH_PATCH"
    "STAN_MINOR"
    "STAN_PATCH"
    "alignas"
    "alignof"
    "and"
    "and_eq"
    "asm"
    "auto"
    "bitand"
    "bitor"
    "bool"
    "case"
    "catch"
    "char"
    "char16_t"
    "char32_t"
    "class"
    "compl"
    "const"
    "const_cast"
    "constexpr"
    "decltype"
    "default"
    "delete"
    "do"
    "double"
    "dynamic_cast"
    "enum"
    "explicit"
    "export"
    "extern"
    "false"
    "float"
    "friend"
    "fvar"
    "goto"
    "inline"
    "int"
    "long"
    "lp__"
    "mutable"
    "namespace"
    "new"
    "noexcept"
    "not"
    "not_eq"
    "nullptr"
    "operator"
    "or"
    "or_eq"
    "private"
    "protected"
    "public"
    "register"
    "reinterpret_cast"
    "short"
    "signed"
    "sizeof"
    "static"
    "static_assert"
    "static_cast"
    "struct"
    "switch"
    "template"
    "this"
    "thread_local"
    "throw"
    "true"
    "try"
    "typedef"
    "typeid"
    "typename"
    "union"
    "unsigned"
    "using"
    "var"
    "virtual"
    "void"
    "volatile"
    "wchar_t"
    "xor"
    "xor_eq")
  "List of reserved keywords in Stan.")

(defconst stan-keywords--deprecated-function-list
  '(
    "bernoulli_ccdf_log"
    "bernoulli_cdf_log"
    "bernoulli_log"
    "bernoulli_logit_glm_log"
    "bernoulli_logit_log"
    "beta_binomial_ccdf_log"
    "beta_binomial_cdf_log"
    "beta_binomial_log"
    "beta_ccdf_log"
    "beta_cdf_log"
    "beta_log"
    "beta_proportion_ccdf_log"
    "beta_proportion_cdf_log"
    "binomial_ccdf_log"
    "binomial_cdf_log"
    "binomial_coefficient_log"
    "binomial_log"
    "binomial_logit_log"
    "categorical_log"
    "categorical_logit_glm_log"
    "categorical_logit_log"
    "cauchy_ccdf_log"
    "cauchy_cdf_log"
    "cauchy_log"
    "chi_square_ccdf_log"
    "chi_square_cdf_log"
    "chi_square_log"
    "dirichlet_log"
    "double_exponential_ccdf_log"
    "double_exponential_cdf_log"
    "double_exponential_log"
    "exp_mod_normal_ccdf_log"
    "exp_mod_normal_cdf_log"
    "exp_mod_normal_log"
    "exponential_ccdf_log"
    "exponential_cdf_log"
    "exponential_log"
    "frechet_ccdf_log"
    "frechet_cdf_log"
    "frechet_log"
    "gamma_ccdf_log"
    "gamma_cdf_log"
    "gamma_log"
    "gaussian_dlm_obs_log"
    "get_lp"
    "gumbel_ccdf_log"
    "gumbel_cdf_log"
    "gumbel_log"
    "hypergeometric_log"
    "if_else"
    "increment_log_prob"
    "integrate_ode"
    "inv_chi_square_ccdf_log"
    "inv_chi_square_cdf_log"
    "inv_chi_square_log"
    "inv_gamma_ccdf_log"
    "inv_gamma_cdf_log"
    "inv_gamma_log"
    "inv_wishart_log"
    "lkj_corr_cholesky_log"
    "lkj_corr_log"
    "lkj_cov"
    "logistic_ccdf_log"
    "logistic_cdf_log"
    "logistic_log"
    "lognormal_ccdf_log"
    "lognormal_cdf_log"
    "lognormal_log"
    "multi_gp_cholesky_log"
    "multi_gp_log"
    "multi_normal_cholesky_log"
    "multi_normal_log"
    "multi_normal_prec_log"
    "multi_student_t_log"
    "multinomial_log"
    "multinomial_logit_log"
    "multiply_log"
    "neg_binomial_2_ccdf_log"
    "neg_binomial_2_cdf_log"
    "neg_binomial_2_log_glm_log"
    "neg_binomial_2_log_log"
    "neg_binomial_ccdf_log"
    "neg_binomial_cdf_log"
    "neg_binomial_log"
    "normal_ccdf_log"
    "normal_cdf_log"
    "normal_id_glm_log"
    "normal_log"
    "ordered_logistic_glm_log"
    "ordered_logistic_log"
    "ordered_probit_log"
    "pareto_ccdf_log"
    "pareto_cdf_log"
    "pareto_log"
    "pareto_type_2_ccdf_log"
    "pareto_type_2_cdf_log"
    "pareto_type_2_log"
    "poisson_ccdf_log"
    "poisson_cdf_log"
    "poisson_log_glm_log"
    "poisson_log_log"
    "rayleigh_ccdf_log"
    "rayleigh_cdf_log"
    "rayleigh_log"
    "scaled_inv_chi_square_ccdf_log"
    "scaled_inv_chi_square_cdf_log"
    "scaled_inv_chi_square_log"
    "skew_normal_ccdf_log"
    "skew_normal_cdf_log"
    "skew_normal_log"
    "std_normal_ccdf_log"
    "std_normal_cdf_log"
    "std_normal_log"
    "student_t_ccdf_log"
    "student_t_cdf_log"
    "student_t_log"
    "uniform_ccdf_log"
    "uniform_cdf_log"
    "uniform_log"
    "von_mises_log"
    "weibull_ccdf_log"
    "weibull_cdf_log"
    "weibull_log"
    "wiener_log"
    "wishart_log")
  "List of deprecated functions in Stan.")

(provide 'stan-keywords)

;;; stan-keywords.el ends here

