;;; sakura-theme.el --- Filled with cherry blossoms

;; Copyright (c) 2022 Jason Milkins (GNU/GPL Licence)

;; Authors: Jason Milkins <jasonm23@gmail.com>
;; URL: http://github.com/emacsfodder/emacs-theme-sakura
;; Package-Version: 1.0.1
;; Package-Revision: d78648632a94
;; ;; Package-Requires: ((autothemer "0.2") (emacs "24"))

;;; License
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 51 Franklin Street, Fifth
;; Floor, Boston, MA 02110-1301, USA.

;;; Commentary:
;;  Filled with cherry blossoms

;;; GUI Support only.

;;; Code:
(require 'autothemer)

(unless (>= emacs-major-version 24)
  (error "Requires Emacs 24 or later"))

(autothemer-deftheme  sakura
                      "Filled with cherry blossoms"
 ((((class color) (min-colors #xFFFFFF))) ;; GUI/24bit only

  (sakura-background-0-hard     "#030007")
  (sakura-background-0          "#110C11")
  (sakura-background-0-soft     "#040206")
  (sakura-background-1          "#110815")
  (sakura-background-2          "#2B1C31")
  (sakura-background-3          "#2D1538")
  (sakura-background-4          "#331840")

  (sakura-medium                "#A12CDD")

  (sakura-foreground-0-hard     "#FFF9FF")
  (sakura-foreground-0          "#FFE0FF")
  (sakura-foreground-0-soft     "#ECC7FF")
  (sakura-foreground-1          "#E0B0F9")
  (sakura-foreground-2          "#E5B3FF")
  (sakura-foreground-3          "#E5B3FF")
  (sakura-foreground-4          "#E5B3FF")

  (sakura-bright-red           "#FF0000")
  (sakura-bright-green         "#00FF00")
  (sakura-bright-yellow        "#FFFF00")
  (sakura-bright-blue          "#0000FF")
  (sakura-bright-purple        "#FF00FF")
  (sakura-bright-teal          "#008080")
  (sakura-bright-orange        "#FF8800")
  (sakura-bright-cyan          "#00FFFF")

  (sakura-neutral-red          "#C34CFF")
  (sakura-neutral-green        "#C34CFF")
  (sakura-neutral-yellow       "#C34DFF")
  (sakura-neutral-blue         "#D88CFF")
  (sakura-neutral-purple       "#D88CFF")
  (sakura-neutral-teal         "#DE9CFF")
  (sakura-neutral-orange       "#C34CFF")
  (sakura-neutral-cyan         "#EECCFF")

  (sakura-faded-red            "#E1A5FF")
  (sakura-faded-green          "#A377B9")
  (sakura-faded-yellow         "#E1A5FF")
  (sakura-faded-blue           "#8D67A0")
  (sakura-faded-purple         "#E1A5FF")
  (sakura-faded-teal           "#7F5C90")
  (sakura-faded-orange         "#A478BA")
  (sakura-faded-cyan           "#A478BA")

  (sakura-muted-red            "#E9BFFF")
  (sakura-muted-green          "#A98AB9")
  (sakura-muted-yellow         "#E9BFFF")
  (sakura-muted-blue           "#9278A0")
  (sakura-muted-purple         "#E9BFFF")
  (sakura-muted-teal           "#846C90")
  (sakura-muted-orange         "#AA8BBA")
  (sakura-muted-cyan           "#AA8BBA")

  (sakura-background-red       "#110319")
  (sakura-background-green     "#201626")
  (sakura-background-yellow    "#1A0426")
  (sakura-background-blue      "#1E0F26")
  (sakura-background-purple    "#221C26")
  (sakura-background-teal      "#211726")
  (sakura-background-orange    "#1A0226")
  (sakura-background-cyan      "#242126")

  (sakura-mid-red              "#9238BF")
  (sakura-mid-green            "#6D3789")
  (sakura-mid-yellow           "#8634AF")
  (sakura-mid-blue             "#753A93")
  (sakura-mid-purple           "#9747BF")
  (sakura-mid-teal             "#8633B0")
  (sakura-mid-orange           "#9238BF")
  (sakura-mid-cyan             "#8835B2")

  (sakura-delimiter-1          "#C34CFF")
  (sakura-delimiter-2          "#AC42E1")
  (sakura-delimiter-3          "#9F3ED0")
  (sakura-delimiter-4          "#8233AA")

  (sakura-identifiers-1        "#DC98FF")
  (sakura-identifiers-2        "#CD8EED")
  (sakura-identifiers-3        "#BA80D7")
  (sakura-identifiers-4        "#A672C1")
  (sakura-identifiers-5        "#A26FBB")
  (sakura-identifiers-6        "#DC98FF")
  (sakura-identifiers-7        "#CD8EED")
  (sakura-identifiers-8        "#BA80D7")
  (sakura-identifiers-9        "#A672C1")
  (sakura-identifiers-10       "#A26FBB")
  (sakura-identifiers-11       "#DC98FF")
  (sakura-identifiers-12       "#CD8EED")
  (sakura-identifiers-13       "#BA80D7")
  (sakura-identifiers-14       "#A672C1")
  (sakura-identifiers-15       "#A26FBB")

  (sakura-white                "#FFFFFF")
  (sakura-black                "#000000")

  (sakura-accent-1             "#E3ADFF")
  (sakura-accent-2             "#DEA2FD")
  (sakura-accent-3             "#D895FD")
  (sakura-accent-4             "#CB82F1")
  (sakura-accent-5             "#CA82F1")
  (sakura-accent-6             "#C877F1")

  (sakura-dark-accent-1        "#650098")
  (sakura-dark-accent-2        "#5A0088")
  (sakura-dark-accent-3        "#500078")
  (sakura-dark-accent-4        "#450068")
  (sakura-dark-accent-5        "#3A0058")
  (sakura-dark-accent-6        "#300048"))

 ((Info-quoted                               (:inherit 'fixed-pitch-serif))
  (ac-candidate-face                         (:inherit 'popup-face))
  (ac-candidate-mouse-face                   (:inherit 'popup-menu-mouse-face))
  (ac-cider-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-cider-selection-face                   (:inherit 'ac-selection-face))
  (ac-completion-face                        (:underline t :foreground sakura-neutral-purple))
  (ac-dabbrev-menu-face                      (:inherit 'popup-face))
  (ac-dabbrev-selection-face                 (:inherit 'popup-menu-selection-face))
  (ac-emmet-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-emmet-selection-face                   (:inherit 'ac-selection-face))
  (ac-gtags-candidate-face                   (:foreground sakura-mid-cyan :inherit 'ac-candidate-face))
  (ac-gtags-selection-face                   (:background sakura-background-cyan :inherit 'ac-selection-face))
  (ac-nrepl-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-nrepl-selection-face                   (:inherit 'ac-selection-face))
  (ac-selection-face                         (:inherit 'popup-menu-selection-face))
  (ac-yasnippet-candidate-face               (:foreground sakura-black :background sakura-foreground-3 :inherit 'ac-candidate-face))
  (ac-yasnippet-selection-face               (:background sakura-background-red :inherit 'ac-selection-face))
  (ag-hit-face                               (:foreground sakura-foreground-1))
  (ag-match-face                             (:foreground sakura-foreground-2))
  (ansible::section-face                     (:foreground sakura-neutral-red))
  (ansible::task-label-face                  (:foreground sakura-black))
  (anzu-match-1                              (:foreground sakura-foreground-0 :background sakura-dark-accent-3))
  (anzu-match-2                              (:foreground sakura-foreground-0 :background sakura-dark-accent-2))
  (anzu-match-3                              (:foreground sakura-foreground-0 :background sakura-dark-accent-1))
  (anzu-mode-line                            (:foreground sakura-foreground-0 :height 100 :background sakura-background-3))
  (anzu-mode-line-no-match                   (:inherit 'anzu-mode-line))
  (anzu-replace-highlight                    (:background sakura-background-4))
  (anzu-replace-to                           (:background sakura-background-3))
  (avy-background-face                       (:foreground sakura-background-4))
  (avy-goto-char-timer-face                  (:inherit 'highlight))
  (avy-lead-face                             (:foreground sakura-accent-3))
  (avy-lead-face-0                           (:foreground sakura-accent-4))
  (avy-lead-face-1                           (:foreground sakura-accent-1))
  (avy-lead-face-2                           (:foreground sakura-accent-2))
  (bold                                      (:weight 'bold))
  (bold-italic                               (:weight 'bold :slant 'italic))
  (border                                    (:background sakura-background-2))

  (buffer-menu-buffer                        (:weight 'bold))
  (button                                    (:inherit 'link))
  (c-annotation-face                         (:inherit 'font-lock-constant-face))
  (change-log-acknowledgment                 (:inherit 'font-lock-comment-face))
  (change-log-conditionals                   (:inherit 'font-lock-variable-name-face))
  (change-log-date                           (:inherit 'font-lock-string-face))
  (change-log-email                          (:inherit 'font-lock-variable-name-face))
  (change-log-file                           (:inherit 'font-lock-function-name-face))
  (change-log-function                       (:inherit 'font-lock-variable-name-face))
  (change-log-list                           (:inherit 'font-lock-keyword-face))
  (change-log-name                           (:inherit 'font-lock-constant-face))
  (col-highlight                             (:inherit 'vline))
  (column-enforce-face                       (:foreground sakura-background-4 :background sakura-background-red))
  (column-marker-1                           (:background sakura-faded-blue))
  (column-marker-2                           (:background sakura-faded-purple))

  (column-marker-3                           (:background sakura-faded-cyan))
  (comint-highlight-input                    (:weight 'bold))
  (comint-highlight-prompt                   (:inherit 'minibuffer-prompt))
  (company-echo                              (:inherit 'company-echo-common))
  (company-echo-common                       (:foreground sakura-bright-blue :background nil))
  (company-preview                           (:inherit 'company-preview-common))
  (company-preview-common                    (:inherit 'font-lock-comment-face))
  (company-preview-common                    (:underline sakura-foreground-1))
  (company-preview-search                    (:inherit 'company-preview-common))
  (company-scrollbar-bg                      (:foreground nil :background sakura-background-3))
  (company-scrollbar-fg                      (:foreground nil :background sakura-background-2))
  (company-template-field                    (:foreground sakura-bright-blue :background nil :underline sakura-background-blue))
  (company-tooltip                           (:foreground sakura-foreground-0-hard :background sakura-background-1))
  (company-tooltip-annotation                (:foreground sakura-foreground-0 :background sakura-background-1))
  (company-tooltip-common                    (:foreground sakura-foreground-0 :background sakura-background-1))
  (company-tooltip-common-selection          (:foreground sakura-foreground-0 :background sakura-background-2))
  (company-tooltip-mouse                     (:foreground sakura-foreground-0 :background sakura-background-3))
  (company-tooltip-selection                 (:foreground sakura-foreground-0 :background sakura-background-4))
  (compilation-column-number                 (:inherit 'font-lock-doc-face))
  (compilation-error                         (:inherit 'error))
  (compilation-info                          (:foreground sakura-neutral-green))
  (compilation-line-number                   (:inherit 'font-lock-keyword-face))
  (compilation-mode-line-exit                (:weight 'bold :foreground sakura-mid-teal :inherit 'compilation-info))
  (compilation-mode-line-fail                (:foreground sakura-neutral-red))
  (compilation-mode-line-run                 (:inherit 'compilation-warning))
  (compilation-warning                       (:inherit 'warning))
  (completions-annotations                   (:inherit 'italic))
  (completions-common-part nil)
  (completions-first-difference              (:inherit 'bold))
  (cua-global-mark                           (:foreground sakura-white :background sakura-background-3))
  (cua-rectangle                             (:background sakura-background-2 :distant-foreground sakura-foreground-0))
  (cua-rectangle-noselect                    (:foreground sakura-white :background sakura-background-4 :inherit 'region))
  (cursor                                    (:background sakura-foreground-4))
  (custom-button                             (:box (:line-width 2 :style 'released-button) :foreground sakura-black :background sakura-identifiers-1))
  (custom-button-mouse                       (:box (:line-width 2 :style 'released-button) :foreground sakura-black :background sakura-identifiers-2))
  (custom-button-pressed                     (:box (:line-width 2 :style 'pressed-button) :foreground sakura-black :background sakura-identifiers-1))
  (custom-button-pressed-unraised            (:foreground sakura-identifiers-13 :inherit 'custom-button-unraised))
  (custom-button-unraised                    (:inherit 'underline))
  (custom-changed                            (:foreground sakura-white :background sakura-mid-cyan))
  (custom-comment                            (:background sakura-background-4))
  (custom-comment-tag                        (:foreground sakura-identifiers-4))
  (custom-documentation nil)
  (custom-face-tag                           (:inherit 'custom-variable-tag))
  (custom-group-subtitle                     (:weight 'bold))
  (custom-group-tag                          (:height 1.2 :weight 'bold :foreground sakura-identifiers-9 :inherit 'variable-pitch))
  (custom-group-tag-1                        (:height 1.2 :weight 'bold :foreground sakura-identifiers-15 :inherit 'variable-pitch))
  (custom-invalid                            (:foreground sakura-foreground-0-hard :background sakura-faded-red))
  (custom-link                               (:inherit 'link))
  (custom-modified                           (:foreground sakura-white :background sakura-mid-cyan))
  (custom-rogue                              (:foreground sakura-identifiers-15 :background sakura-black))
  (custom-saved                              (:underline t))
  (custom-set                                (:foreground sakura-mid-cyan :background sakura-white))
  (custom-state                              (:foreground sakura-mid-yellow))
  (custom-themed                             (:foreground sakura-white :background sakura-mid-cyan))
  (custom-variable-button                    (:weight 'bold :underline t))
  (custom-variable-tag                       (:weight 'bold :foreground sakura-identifiers-9))
  (custom-visibility                         (:height 0.8 :inherit 'link))
  (default                                   (:foreground sakura-foreground-0 :background sakura-background-0))
  (describe-variable-value                   (:foreground sakura-bright-orange))
  (diff-added                                (:foreground sakura-foreground-1 :background sakura-background-green))
  (diff-changed                              (:foreground sakura-foreground-1 :background sakura-background-purple)) (diff-context                              (:foreground sakura-identifiers-2)) (diff-file-header                          (:weight 'bold :background sakura-faded-purple))
  (diff-function                             (:inherit 'diff-header))
  (diff-header                               (:background sakura-background-4))
  (diff-hl-change                            (:inherit 'diff-changed))
  (diff-hl-delete                            (:inherit 'diff-removed)) (diff-hl-insert                            (:inherit 'diff-added)) (diff-hunk-header                          (:inherit 'diff-header)) (diff-index                                (:inherit 'diff-file-header)) (diff-indicator-added                      (:inherit 'diff-added))
  (diff-indicator-changed                    (:inherit 'diff-changed))
  (diff-indicator-removed                    (:inherit 'diff-removed))
  (diff-nonexistent                          (:inherit 'diff-file-header))
  (diff-refine-added                         (:background sakura-background-green :inherit 'diff-refine-change))
  (diff-refine-changed                       (:background sakura-background-blue))
  (diff-refine-removed                       (:background sakura-background-red :inherit 'diff-refine-change))
  (diff-removed                              (:foreground sakura-foreground-1 :background sakura-background-red))
  (dired-directory                           (:inherit 'font-lock-function-name-face))
  (dired-flagged                             (:inherit 'error))
  (dired-header                              (:inherit 'font-lock-type-face))
  (dired-ignored                             (:inherit 'shadow))
  (dired-mark                                (:inherit 'font-lock-constant-face))
  (dired-marked                              (:inherit 'warning))
  (dired-perm-write                          (:inherit 'font-lock-comment-delimiter-face))
  (dired-subtree-depth-1-face                (:background nil))
  (dired-subtree-depth-2-face                (:background nil))
  (dired-subtree-depth-3-face                (:background nil))
  (dired-subtree-depth-4-face                (:background nil))
  (dired-subtree-depth-5-face                (:background nil))
  (dired-subtree-depth-6-face                (:background nil))
  (dired-symlink                             (:inherit 'font-lock-keyword-face))
  (dired-warning                             (:inherit 'font-lock-warning-face))
  (diredfl-autofile-name                     (:foreground sakura-foreground-1))
  (diredfl-compressed-file-name              (:foreground sakura-foreground-1))
  (diredfl-compressed-file-suffix            (:foreground sakura-foreground-1))
  (diredfl-date-time                         (:foreground sakura-accent-5))
  (diredfl-deletion                          (:foreground sakura-faded-red))
  (diredfl-deletion-file-name                (:foreground sakura-faded-red))
  (diredfl-dir-heading                       (:foreground sakura-foreground-1))
  (diredfl-dir-name                          (:foreground sakura-bright-cyan))
  (diredfl-dir-priv                          (:foreground sakura-bright-cyan :background sakura-background-1))
  (diredfl-exec-priv                         (:foreground sakura-bright-orange :background sakura-background-1))
  (diredfl-executable-tag                    (:foreground sakura-bright-orange))
  (diredfl-file-name                         (:foreground sakura-faded-teal))
  (diredfl-file-suffix                       (:foreground sakura-faded-teal))
  (diredfl-flag-mark                         (:foreground sakura-bright-cyan))
  (diredfl-flag-mark-line                    (:foreground sakura-foreground-0 :background sakura-background-1))
  (diredfl-ignored-file-name                 (:foreground sakura-foreground-3))
  (diredfl-link-priv                         (:foreground sakura-bright-purple :background sakura-background-1))
  (diredfl-no-priv                           (:foreground sakura-foreground-4 :background sakura-background-1))
  (diredfl-number                            (:foreground sakura-foreground-2))
  (diredfl-other-priv                        (:background sakura-background-1))
  (diredfl-rare-priv                         (:background sakura-background-1))
  (diredfl-read-priv                         (:foreground sakura-bright-teal :background sakura-background-1))
  (diredfl-symlink                           (:foreground sakura-neutral-cyan))
  (diredfl-tagged-autofile-name              (:foreground sakura-foreground-1 :background sakura-background-1))
  (diredfl-write-priv                        (:foreground sakura-bright-green :background sakura-background-1))
  (diredp-autofile-name                      (:inherit 'diredfl-autofile-name))
  (diredp-compressed-file-name               (:inherit 'diredfl-compressed-file-name))
  (diredp-compressed-file-suffix             (:inherit 'diredfl-compressed-file-suffix))
  (diredp-date-time                          (:inherit 'diredfl-date-time))
  (diredp-deletion                           (:inherit 'diredfl-deletion))
  (diredp-deletion-file-name                 (:inherit 'diredfl-deletion-file-name))
  (diredp-dir-heading                        (:inherit 'diredfl-dir-heading))
  (diredp-dir-name                           (:inherit 'diredfl-dir-name))
  (diredp-dir-priv                           (:inherit 'diredfl-dir-priv))
  (diredp-exec-priv                          (:inherit 'diredfl-exec-priv))
  (diredp-executable-tag                     (:inherit 'diredfl-executable-tag))
  (diredp-file-name                          (:inherit 'diredfl-file-name))
  (diredp-file-suffix                        (:inherit 'diredfl-file-suffix))
  (diredp-flag-mark                          (:inherit 'diredfl-flag-mark))
  (diredp-flag-mark-line                     (:inherit 'diredfl-flag-mark-line))
  (diredp-ignored-file-name                  (:inherit 'diredfl-ignored-file-name))
  (diredp-link-priv                          (:inherit 'diredfl-link-priv))
  (diredp-no-priv                            (:inherit 'diredfl-no-priv))
  (diredp-number                             (:inherit 'diredfl-number))
  (diredp-other-priv                         (:inherit 'diredfl-other-priv))
  (diredp-rare-priv                          (:inherit 'diredfl-rare-priv))
  (diredp-read-priv                          (:inherit 'diredfl-read-priv))
  (diredp-symlink                            (:inherit 'diredfl-symlink))
  (diredp-tagged-autofile-name               (:inherit 'diredfl-tagged-autofile-name))
  (diredp-write-priv                         (:inherit 'diredfl-write-priv))
  (dropdown-list-face                        (:foreground sakura-black :background sakura-foreground-0-hard :inherit 'default))
  (dropdown-list-selection-face              (:background sakura-bright-purple :inherit 'dropdown-list))
  (el-search-match                           (:background sakura-background-cyan))
  (el-search-other-match                     (:background sakura-background-blue))
  (eldoc-highlight-function-argument         (:inherit 'bold))
  (elfeed-search-date-face                   (:foreground sakura-muted-cyan))
  (elfeed-search-feed-face                   (:foreground sakura-faded-cyan))
  (elfeed-search-tag-face                    (:foreground sakura-foreground-3))
  (elfeed-search-title-face                  (:foreground sakura-foreground-3 :bold nil))
  (elfeed-search-unread-title-face           (:foreground sakura-foreground-0-hard :bold nil))
  (elscreen-tab-background-face              (:background sakura-background-0 :box nil))
  (elscreen-tab-control-face                 (:foreground sakura-neutral-red :background sakura-background-2 :box nil :underline nil))
  (elscreen-tab-current-screen-face          (:foreground sakura-background-0 :background sakura-background-4 :box nil))
  (elscreen-tab-other-screen-face            (:foreground sakura-foreground-4 :background sakura-background-2 :box nil :underline nil))
  (embrace-help-key-face                     (:foreground   sakura-accent-3  :weight 'bold))
  (embrace-help-mark-func-face               (:foreground   sakura-accent-4))
  (embrace-help-pair-face                    (:foreground   sakura-accent-1))
  (embrace-help-separator-face               (:foreground   sakura-accent-2))
  (erc-action-face                           (:inherit 'erc-default-face))
  (erc-bold-face                             (:weight 'bold))
  (erc-button                                (:weight 'bold  :underline t))
  (erc-current-nick-face                     (:foreground sakura-accent-3 :weight 'bold))
  (erc-dangerous-host-face                   (:inherit 'font-lock-warning-face))
  (erc-default-face                          (:inherit 'default))
  (erc-direct-msg-face                       (:inherit 'erc-default-face))
  (erc-error-face                            (:inherit 'font-lock-warning-face))
  (erc-fool-face                             (:inherit 'erc-default-face))
  (erc-input-face                            (:foreground sakura-accent-3))
  (erc-keyword-face                          (:foreground sakura-bright-orange :weight 'bold))
  (erc-my-nick-face                          (:foreground sakura-accent-3 :weight 'bold))
  (erc-nick-default-face                     (:weight 'bold))
  (erc-nick-msg-face                         (:inherit 'erc-default-face))
  (erc-notice-face                           (:foreground sakura-background-4))
  (erc-pal-face                              (:foreground sakura-neutral-yellow :weight 'bold))
  (erc-prompt-face                           (:foreground sakura-accent-3 :weight 'bold))
  (erc-timestamp-face                        (:foreground sakura-neutral-green))
  (erc-underline-face                        (:underline t))
  (erefactor-highlight-face                  (:inherit 'match))
  (error                                     (:foreground sakura-bright-red :bold t))
  (escape-glyph                              (:foreground sakura-neutral-cyan))
  (eww-form-checkbox                         (:box (:line-width 2 :style 'released-button) :foreground sakura-black :background sakura-identifiers-1))
  (eww-form-file                             (:box (:line-width 2 :style 'released-button) :foreground sakura-black :background sakura-muted-purple))
  (eww-form-select                           (:box (:line-width 2 :style 'released-button) :foreground sakura-black :background sakura-identifiers-1))
  (eww-form-submit                           (:box (:line-width 2 :style 'released-button) :foreground sakura-black :background sakura-muted-purple))
  (eww-form-text                             (:box (:line-width 1) :foreground sakura-white :background sakura-background-2))
  (eww-form-textarea                         (:box (:line-width 1) :foreground sakura-black :background sakura-neutral-purple))
  (eww-invalid-certificate                   (:weight 'bold :foreground sakura-faded-red))
  (eww-valid-certificate                     (:weight 'bold :foreground sakura-mid-teal))
  (ffap                                      (:inherit 'highlight))
  (file-name-shadow                          (:inherit 'shadow))
  (fixed-pitch                               (:family "Monospace"))
  (fixed-pitch-serif                         (:family "Monospace Serif"))
  (flx-highlight-face                        (:weight 'bold :underline t :inherit 'font-lock-variable-name-face))
  (flycheck-error                            (:underline (:style 'wave :color sakura-faded-red)))
  (flycheck-error-list-checker-name          (:inherit 'font-lock-function-name-face))
  (flycheck-error-list-column-number         (:inherit 'font-lock-constant-face))
  (flycheck-error-list-error                 (:inherit 'error))
  (flycheck-error-list-highlight             (:inherit 'highlight))
  (flycheck-error-list-id                    (:inherit 'font-lock-type-face))
  (flycheck-error-list-id-with-explainer     (:box (:style 'released-button) :inherit 'flycheck-error-list-id))
  (flycheck-error-list-info                  (:inherit 'success))
  (flycheck-error-list-line-number           (:inherit 'font-lock-constant-face))
  (flycheck-error-list-warning               (:inherit 'warning))
  (flycheck-fringe-error                     (:inherit 'error))
  (flycheck-fringe-info                      (:inherit 'success))
  (flycheck-fringe-warning                   (:inherit 'warning))
  (flycheck-info                             (:underline (:style 'wave :color sakura-mid-teal)))
  (flycheck-warning                          (:underline (:style 'wave :color sakura-bright-red)))
  (flymake-errline                           (:underline (:style 'wave :color sakura-faded-red)))
  (flymake-warnline                          (:underline (:style 'wave :color sakura-bright-red)))
  (font-latex-math-face                      (:foreground sakura-accent-3))
  (font-latex-sectioning-5-face              (:foreground sakura-neutral-green))
  (font-latex-string-face                    (:inherit 'font-lock-string-face))
  (font-latex-warning-face                   (:inherit 'warning))
  (font-lock-builtin-face                    (:foreground sakura-foreground-3))
  (font-lock-comment-delimiter-face          (:inherit 'font-lock-comment-face))
  (font-lock-comment-face                    (:foreground sakura-foreground-4))
  (font-lock-constant-face                   (:foreground sakura-accent-4))
  (font-lock-doc-face                        (:inherit 'font-lock-string-face))
  (font-lock-function-name-face              (:foreground sakura-foreground-2))
  (font-lock-keyword-face                    (:foreground sakura-accent-1))
  (font-lock-negation-char-face              (:foreground sakura-foreground-1))
  (font-lock-preprocessor-face               (:inherit 'font-lock-builtin-face))
  (font-lock-regexp-grouping-backslash       (:inherit 'bold))
  (font-lock-regexp-grouping-construct       (:inherit 'bold))
  (font-lock-string-face                     (:foreground sakura-accent-2))
  (font-lock-type-face                       (:foreground sakura-accent-3))
  (font-lock-variable-name-face              (:foreground sakura-accent-5))
  (font-lock-warning-face                    (:foreground sakura-bright-red :bold t))
  (fringe                                    (:background sakura-background-0))
  (git-commit-comment-action                 (:inherit 'git-commit-comment-branch))
  (git-commit-comment-branch                 (:inherit 'font-lock-variable-name-face))
  (git-commit-comment-detached               (:inherit 'git-commit-comment-branch))
  (git-commit-comment-file                   (:inherit 'git-commit-pseudo-header))
  (git-commit-comment-heading                (:inherit 'git-commit-known-pseudo-header))
  (git-commit-known-pseudo-header            (:inherit 'font-lock-keyword-face))
  (git-commit-nonempty-second-line           (:inherit 'font-lock-warning-face))
  (git-commit-note                           (:inherit 'font-lock-string-face))
  (git-commit-overlong-summary               (:inherit 'font-lock-warning-face))
  (git-commit-pseudo-header                  (:inherit 'font-lock-string-face))
  (git-commit-summary                        (:inherit 'font-lock-type-face))
  (git-gutter+-added                         (:foreground sakura-bright-green :background sakura-background-green))
  (git-gutter+-commit-header-face            (:inherit 'font-lock-comment-face))
  (git-gutter+-deleted                       (:foreground sakura-bright-red :background sakura-background-red))
  (git-gutter+-modified                      (:foreground sakura-bright-purple :background sakura-background-purple))
  (git-gutter+-separator                     (:foreground sakura-bright-cyan :background sakura-muted-cyan))
  (git-gutter+-unchanged                     (:foreground sakura-bright-yellow :background sakura-muted-yellow))
  (git-gutter-fr+-added                      (:inherit 'git-gutter+-added))
  (git-gutter-fr+-deleted                    (:inherit 'git-gutter+-deleted))
  (git-gutter-fr+-modified                   (:inherit 'git-gutter+-modified))
  (git-gutter-fr:added                       (:foreground sakura-bright-green :background sakura-background-green))
  (git-gutter-fr:deleted                     (:foreground sakura-bright-red :background sakura-background-red))
  (git-gutter-fr:modified                    (:foreground sakura-bright-purple :background sakura-background-purple))
  (git-gutter:added                          (:foreground sakura-bright-green :background sakura-background-green))
  (git-gutter:deleted                        (:foreground sakura-bright-red :background sakura-background-red))
  (git-gutter:modified                       (:foreground sakura-bright-purple :background sakura-background-purple))
  (git-gutter:separator                      (:foreground sakura-bright-cyan :background sakura-muted-cyan))
  (git-gutter:unchanged                      (:foreground sakura-bright-yellow :background sakura-muted-yellow))
  (glyphless-char                            (:height 0.6))
  (gnus-group-mail-1                         (:weight 'bold :foreground sakura-foreground-0-hard))
  (gnus-group-mail-1-empty                   (:foreground sakura-foreground-0-hard))
  (gnus-group-mail-2                         (:weight 'bold :foreground sakura-identifiers-4))
  (gnus-group-mail-2-empty                   (:foreground sakura-identifiers-4))
  (gnus-group-mail-3                         (:weight 'bold :foreground sakura-bright-orange))
  (gnus-group-mail-3-empty                   (:foreground sakura-bright-orange))
  (gnus-group-mail-low                       (:weight 'bold :foreground sakura-faded-orange))
  (gnus-group-mail-low-empty                 (:foreground sakura-faded-orange))
  (gnus-group-news-1                         (:weight 'bold :foreground sakura-identifiers-7))
  (gnus-group-news-1-empty                   (:foreground sakura-identifiers-7))
  (gnus-group-news-2                         (:weight 'bold :foreground sakura-bright-cyan))
  (gnus-group-news-2-empty                   (:foreground sakura-bright-cyan))
  (gnus-group-news-3                         (:weight 'bold))
  (gnus-group-news-3-empty nil)
  (gnus-group-news-4                         (:weight 'bold))
  (gnus-group-news-4-empty nil)
  (gnus-group-news-5                         (:weight 'bold))
  (gnus-group-news-5-empty nil)
  (gnus-group-news-6                         (:weight 'bold))
  (gnus-group-news-6-empty nil)
  (gnus-group-news-low                       (:weight 'bold :foreground sakura-neutral-cyan))
  (gnus-group-news-low-empty                 (:foreground sakura-neutral-cyan))
  (gnus-splash                               (:foreground sakura-identifiers-4))
  (gnus-summary-cancelled                    (:foreground sakura-foreground-0-hard :background sakura-black))
  (gnus-summary-high-ancient                 (:weight 'bold :foreground sakura-bright-green))
  (gnus-summary-high-read                    (:weight 'bold :foreground sakura-neutral-yellow))
  (gnus-summary-high-ticked                  (:weight 'bold :foreground sakura-identifiers-15))
  (gnus-summary-high-undownloaded            (:weight 'bold :foreground sakura-identifiers-1))
  (gnus-summary-high-unread                  (:weight 'bold))
  (gnus-summary-low-ancient                  (:slant 'italic :foreground sakura-bright-green))
  (gnus-summary-low-read                     (:slant 'italic :foreground sakura-neutral-yellow))
  (gnus-summary-low-ticked                   (:slant 'italic :foreground sakura-identifiers-15))
  (gnus-summary-low-undownloaded             (:weight 'normal :slant 'italic :foreground sakura-faded-cyan))
  (gnus-summary-low-unread                   (:slant 'italic))
  (gnus-summary-normal-ancient               (:foreground sakura-bright-green))
  (gnus-summary-normal-read                  (:foreground sakura-neutral-yellow))
  (gnus-summary-normal-ticked                (:foreground sakura-identifiers-15))
  (gnus-summary-normal-undownloaded          (:weight 'normal :foreground sakura-faded-cyan))
  (gnus-summary-normal-unread nil)
  (gnus-summary-selected                     (:underline t))
  (haskell-constructor-face                  (:foreground sakura-neutral-teal :background nil))
  (haskell-debug-heading-face                (:inherit ('quote 'font-lock-keyword-face)))
  (haskell-debug-keybinding-face             (:weight 'bold :inherit ('quote 'font-lock-type-face)))
  (haskell-debug-muted-face                  (:foreground sakura-muted-purple))
  (haskell-debug-newline-face                (:weight 'bold :background sakura-white))
  (haskell-debug-trace-number-face           (:weight 'bold :background sakura-white))
  (haskell-debug-warning-face                (:inherit ('quote 'compilation-warning)))
  (haskell-error-face                        (:underline (:style 'wave :color sakura-bright-red)))
  (haskell-hole-face                         (:underline (:style 'wave :color sakura-muted-green)))
  (haskell-interactive-face-compile-error    (:underline (:color sakura-bright-red :style 'wave)))
  (haskell-interactive-face-compile-warning  (:underline (:color sakura-bright-yellow :style 'wave)))
  (haskell-interactive-face-garbage          (:foreground sakura-background-4 :background nil))
  (haskell-interactive-face-prompt           (:foreground sakura-foreground-0 :background nil))
  (haskell-interactive-face-prompt2          (:inherit 'font-lock-keyword-face))
  (haskell-interactive-face-result           (:foreground sakura-foreground-3 :background nil))
  (haskell-keyword-face                      (:inherit 'font-lock-keyword-face))
  (haskell-liquid-haskell-annotation-face    (:inherit 'haskell-pragma-face))
  (haskell-literate-comment-face             (:foreground sakura-foreground-0 :background nil))
  (haskell-operator-face                     (:inherit 'font-lock-variable-name-face))
  (haskell-pragma-face                       (:foreground sakura-medium :background nil))
  (haskell-type-face                         (:inherit 'font-lock-type-face))
  (haskell-warning-face                      (:underline (:style 'wave :color sakura-medium)))
  (header-line                               (:foreground sakura-accent-6 :background sakura-background-0 :bold nil))
  (helm-M-x-key                              (:foreground sakura-neutral-orange))
  (helm-action                               (:foreground sakura-white :underline t))
  (helm-bookmark-addressbook                 (:foreground sakura-neutral-red))
  (helm-bookmark-directory                   (:foreground sakura-bright-purple))
  (helm-bookmark-file                        (:foreground sakura-faded-blue))
  (helm-bookmark-gnus                        (:foreground sakura-faded-purple))
  (helm-bookmark-info                        (:foreground sakura-accent-6))
  (helm-bookmark-man                         (:foreground sakura-accent-1))
  (helm-bookmark-w3m                         (:foreground sakura-neutral-yellow))
  (helm-buffer-directory                     (:foreground sakura-white :background sakura-bright-blue))
  (helm-buffer-not-saved                     (:foreground sakura-faded-red))
  (helm-buffer-process                       (:foreground sakura-accent-4))
  (helm-buffer-saved-out                     (:foreground sakura-bright-red))
  (helm-buffer-size                          (:foreground sakura-bright-purple))
  (helm-candidate-number                     (:foreground sakura-neutral-green))
  (helm-ff-directory                         (:foreground sakura-neutral-purple))
  (helm-ff-executable                        (:foreground sakura-accent-6))
  (helm-ff-file                              (:foreground sakura-accent-1))
  (helm-ff-invalid-symlink                   (:foreground sakura-white :background sakura-bright-red))
  (helm-ff-prefix                            (:foreground sakura-black :background sakura-neutral-yellow))
  (helm-ff-symlink                           (:foreground sakura-neutral-orange))
  (helm-grep-cmd-line                        (:foreground sakura-neutral-green))
  (helm-grep-file                            (:foreground sakura-faded-purple))
  (helm-grep-finish                          (:foreground sakura-accent-6))
  (helm-grep-lineno                          (:foreground sakura-neutral-orange))
  (helm-grep-match                           (:foreground sakura-neutral-yellow))
  (helm-grep-running                         (:foreground sakura-neutral-red))
  (helm-header                               (:foreground sakura-accent-5))
  (helm-helper                               (:foreground sakura-accent-5))
  (helm-history-deleted                      (:foreground sakura-black :background sakura-bright-red))
  (helm-history-remote                       (:foreground sakura-faded-red))
  (helm-lisp-completion-info                 (:foreground sakura-faded-orange))
  (helm-lisp-show-completion                 (:foreground sakura-bright-red))
  (helm-locate-finish                        (:foreground sakura-white :background sakura-accent-5))
  (helm-match                                (:foreground sakura-neutral-orange))
  (helm-moccur-buffer                        (:foreground sakura-bright-teal :underline t))
  (helm-prefarg                              (:foreground sakura-accent-6))
  (helm-selection                            (:foreground sakura-white :background sakura-background-2))
  (helm-selection-line                       (:foreground sakura-white :background sakura-background-2))
  (helm-separator                            (:foreground sakura-faded-red))
  (helm-source-header                        (:foreground sakura-foreground-2 :background sakura-background-1))
  (helm-visible-mark                         (:foreground sakura-black :background sakura-foreground-3))
  (help-argument-name                        (:inherit 'italic))
  (hi-black-b                                (:foreground sakura-bright-orange :background sakura-background-0-hard :bold t))
  (hi-black-hb                               (:foreground sakura-bright-cyan :background sakura-background-0-hard :bold t))
  (hi-blue                                   (:foreground sakura-background-0-hard :background sakura-bright-blue))
  (hi-blue-b                                 (:foreground sakura-bright-blue :bold t))
  (hi-green                                  (:foreground sakura-background-0-hard :background sakura-bright-green))
  (hi-green-b                                (:foreground sakura-bright-green :bold t))
  (hi-pink                                   (:foreground sakura-background-0-hard :background sakura-bright-purple))
  (hi-red-b                                  (:foreground sakura-bright-red :bold t))
  (hi-yellow                                 (:foreground sakura-background-0-hard :background sakura-bright-yellow))
  (highlight                                 (:foreground sakura-foreground-0-hard :background sakura-background-3))
  (highlight-indentation-current-column-face (:background sakura-background-4))
  (highlight-indentation-face                (:background sakura-background-1))
  (highlight-numbers-number                  (:foreground sakura-foreground-1 :bold t))
  (highlight-symbol-face                     (:foreground sakura-neutral-purple))
  (hl-line                                   (:background sakura-background-1))
  (hl-spotlight                              (:inherit 'highlight))
  (hydra-face-amaranth                       (:foreground sakura-accent-4))
  (hydra-face-blue                           (:foreground sakura-accent-2))
  (hydra-face-pink                           (:foreground sakura-accent-3))
  (hydra-face-red                            (:foreground sakura-accent-1))
  (hydra-face-teal                           (:foreground sakura-accent-5))
  (ido-first-match                           (:foreground sakura-faded-cyan :background sakura-background-0-hard))
  (ido-incomplete-regexp                     (:inherit 'font-lock-warning-face))
  (ido-indicator                             (:background sakura-bright-red :foreground sakura-bright-yellow))
  (ido-only-match                            (:foreground sakura-accent-2))
  (ido-subdir                                (:foreground sakura-foreground-3))
  (ido-vertical-first-match-face             (:foreground sakura-faded-cyan :background sakura-background-blue))
  (ido-vertical-match-face                   (:bold t))
  (ido-vertical-only-match-face              (:foreground sakura-faded-cyan))
  (ido-virtual                               (:inherit 'font-lock-builtin-face))
  (iedit-occurrence                          (:inherit 'highlight))
  (iedit-read-only-occurrence                (:inherit 'region))
  (info-header-node                          (:inherit 'info-node))
  (info-header-xref                          (:inherit 'info-xref))
  (info-index-match                          (:inherit 'match))
  (info-menu-header                          (:weight 'bold :inherit 'variable-pitch))
  (info-menu-star                            (:foreground sakura-faded-red))
  (info-node                                 (:weight 'bold :slant 'italic :foreground sakura-white))
  (info-title-1                              (:height 1.2 :inherit 'info-title-2))
  (info-title-2                              (:height 1.2 :inherit 'info-title-3))
  (info-title-3                              (:height 1.2 :inherit 'info-title-4))
  (info-title-4                              (:weight 'bold :inherit 'variable-pitch))
  (info-xref                                 (:inherit 'link))
  (info-xref-visited                         (:inherit ('link-visited 'info-xref)))
  (isearch                                   (:foreground sakura-foreground-0-hard :background sakura-background-2))
  (isearch-fail                              (:foreground sakura-foreground-0-hard :background sakura-background-red))
  (isearch-group-1                           (:foreground sakura-foreground-0-hard :background sakura-dark-accent-3))
  (isearch-group-2                           (:foreground sakura-foreground-0-hard :background sakura-dark-accent-5))
  (italic                                    (:slant 'italic))
  (ivy-action                                (:inherit 'font-lock-builtin-face))
  (ivy-confirm-face                          (:foreground sakura-bright-green))
  (ivy-current-match                         (:foreground sakura-foreground-0 :background sakura-background-3))
  (ivy-cursor                                (:foreground sakura-white :background sakura-black))
  (ivy-match-required-face                   (:foreground sakura-bright-red))
  (ivy-minibuffer-match-face-1               (:background sakura-background-1))
  (ivy-minibuffer-match-face-2               (:background sakura-background-2))
  (ivy-minibuffer-match-face-3               (:background sakura-faded-teal))
  (ivy-minibuffer-match-face-4               (:background sakura-faded-purple))
  (ivy-modified-buffer                       (:inherit 'default))
  (ivy-remote                                (:foreground sakura-neutral-blue))
  (ivy-subdir                                (:inherit 'dired-directory))
  (ivy-virtual                               (:inherit 'font-lock-builtin-face))
  (js2-error                                 (:underline (:color sakura-bright-red :style 'wave)))
  (js2-external-variable                     (:underline (:color sakura-bright-teal :style 'wave)))
  (js2-function-call                         (:foreground sakura-bright-blue :background nil))
  (js2-function-param                        (:foreground sakura-bright-teal :background nil))
  (js2-instance-member                       (:foreground sakura-bright-orange :background nil))
  (js2-jsdoc-html-tag-delimiter              (:foreground sakura-foreground-3 :background nil))
  (js2-jsdoc-html-tag-name                   (:foreground sakura-foreground-4 :background nil))
  (js2-jsdoc-tag                             (:foreground sakura-medium :background nil))
  (js2-jsdoc-type                            (:foreground sakura-foreground-4 :background nil))
  (js2-jsdoc-value                           (:foreground sakura-foreground-3 :background nil))
  (js2-object-property                       (:inherit 'default))
  (js2-private-function-call                 (:foreground sakura-faded-teal :background nil))
  (js2-private-member                        (:foreground sakura-faded-yellow :background nil))
  (js2-warning                               (:underline (:color sakura-bright-yellow :style 'wave)))
  (lacarte-shortcut                          (:foreground sakura-neutral-purple))
  (lazy-highlight                            (:foreground sakura-foreground-0 :background sakura-background-3))
  (link                                      (:foreground sakura-faded-blue :underline t))
  (link-visited                              (:foreground sakura-faded-blue :underline nil))
  (linum                                     (:foreground sakura-background-4))
  (linum-relative-current-face               (:foreground sakura-foreground-4 :background sakura-background-1))
  (log-edit-header                           (:inherit 'font-lock-keyword-face))
  (log-edit-summary                          (:inherit 'font-lock-function-name-face))
  (log-edit-unknown-header                   (:inherit 'font-lock-comment-face))
  (lv-separator                              (:background sakura-background-2))
  (magit-bisect-bad                          (:foreground sakura-faded-red))
  (magit-bisect-good                         (:foreground sakura-neutral-green))
  (magit-bisect-skip                         (:foreground sakura-foreground-2))
  (magit-blame-date                          (:inherit 'magit-blame-heading))
  (magit-blame-hash                          (:inherit 'magit-blame-heading))
  (magit-blame-heading                       (:background sakura-background-1 :foreground sakura-foreground-0))
  (magit-blame-name                          (:inherit 'magit-blame-heading))
  (magit-blame-summary                       (:inherit 'magit-blame-heading))
  (magit-branch                              (:foreground sakura-accent-6 :background nil))
  (magit-branch-current                      (:box 1 :inherit 'magit-branch-local))
  (magit-branch-local                        (:foreground sakura-accent-6 :background nil))
  (magit-branch-remote                       (:foreground sakura-accent-5 :background nil))
  (magit-cherry-equivalent                   (:foreground sakura-neutral-orange))
  (magit-cherry-unmatched                    (:foreground sakura-neutral-purple))
  (magit-diff-add                            (:foreground sakura-bright-green))
  (magit-diff-added                          (:foreground sakura-bright-green :background sakura-background-green))
  (magit-diff-added-highlight                (:foreground sakura-bright-green :background sakura-background-green))
  (magit-diff-base                           (:foreground sakura-foreground-0-hard :background sakura-background-2))
  (magit-diff-base-highlight                 (:foreground sakura-foreground-0-soft :background sakura-background-3))
  (magit-diff-conflict-heading               (:inherit 'magit-diff-hunk-heading))
  (magit-diff-context                        (:foreground sakura-foreground-4 :background nil))
  (magit-diff-context-highlight              (:foreground sakura-foreground-4 :background sakura-background-0-soft))
  (magit-diff-del                            (:foreground sakura-bright-red))
  (magit-diff-file-header                    (:foreground sakura-foreground-0))
  (magit-diff-file-heading                   (:weight 'bold))
  (magit-diff-file-heading-highlight         (:inherit ('magit-section-highlight)))
  (magit-diff-file-heading-selection         (:foreground sakura-medium :inherit 'magit-diff-file-heading-highlight))
  (magit-diff-hunk-header                    (:foreground sakura-neutral-teal))
  (magit-diff-hunk-heading                   (:foreground sakura-neutral-purple :background sakura-background-1))
  (magit-diff-hunk-heading-highlight         (:foreground sakura-neutral-purple :background sakura-background-3))
  (magit-diff-hunk-heading-selection         (:foreground sakura-medium :inherit 'magit-diff-hunk-heading-highlight))
  (magit-diff-hunk-region                    (:inherit 'bold))
  (magit-diff-lines-boundary                 (:inherit 'magit-diff-lines-heading))
  (magit-diff-lines-heading                  (:foreground sakura-identifiers-4 :background sakura-background-2 :inherit 'magit-diff-hunk-heading-highlight))
  (magit-diff-merge-current                  (:background sakura-background-yellow))
  (magit-diff-merge-diff3-separator          (:foreground sakura-neutral-orange :weight 'bold))
  (magit-diff-merge-proposed                 (:background sakura-background-green))
  (magit-diff-merge-separator                (:foreground sakura-neutral-orange))
  (magit-diff-none                           (:foreground sakura-medium))
  (magit-diff-our                            (:inherit 'magit-diff-removed))
  (magit-diff-our-highlight                  (:inherit 'magit-diff-removed-highlight))
  (magit-diff-removed                        (:foreground sakura-bright-red :background sakura-background-red))
  (magit-diff-removed-highlight              (:foreground sakura-bright-red :background sakura-background-red))
  (magit-diff-their                          (:inherit 'magit-diff-added))
  (magit-diff-their-highlight                (:inherit 'magit-diff-added-highlight))
  (magit-diff-whitespace-warning             (:inherit 'trailing-whitespace))
  (magit-diffstat-added                      (:foreground sakura-delimiter-3))
  (magit-diffstat-removed                    (:foreground sakura-background-2))
  (magit-dimmed                              (:foreground sakura-muted-purple))
  (magit-filename                            (:weight 'normal))
  (magit-hash                                (:foreground sakura-background-3))
  (magit-head                                (:inherit 'magit-branch-local))
  (magit-header-line                         (:inherit 'magit-section-heading))
  (magit-item-highlight                      (:background sakura-background-1 :weight 'normal))
  (magit-item-mark                           (:background sakura-background-0))
  (magit-key-mode-args-face                  (:foreground sakura-foreground-4))
  (magit-key-mode-button-face                (:foreground sakura-neutral-orange :weight 'bold))
  (magit-key-mode-header-face                (:foreground sakura-foreground-4 :weight 'bold))
  (magit-key-mode-switch-face                (:foreground sakura-accent-6 :weight 'bold))
  (magit-log-author                          (:foreground sakura-neutral-teal))
  (magit-log-date                            (:foreground sakura-faded-orange))
  (magit-log-graph                           (:foreground sakura-foreground-1))
  (magit-log-head-label-bisect-bad           (:foreground sakura-bright-red))
  (magit-log-head-label-bisect-good          (:foreground sakura-bright-green))
  (magit-log-head-label-bisect-skip          (:foreground sakura-neutral-yellow))
  (magit-log-head-label-default              (:foreground sakura-neutral-blue))
  (magit-log-head-label-head                 (:foreground sakura-foreground-0 :background sakura-background-teal))
  (magit-log-head-label-local                (:foreground sakura-faded-blue :weight 'bold))
  (magit-log-head-label-patches              (:foreground sakura-faded-orange))
  (magit-log-head-label-remote               (:foreground sakura-neutral-blue :weight 'bold))
  (magit-log-head-label-tags                 (:foreground sakura-neutral-teal))
  (magit-log-head-label-wip                  (:foreground sakura-neutral-red))
  (magit-log-message                         (:foreground sakura-foreground-1))
  (magit-log-reflog-label-amend              (:foreground sakura-bright-blue))
  (magit-log-reflog-label-checkout           (:foreground sakura-bright-yellow))
  (magit-log-reflog-label-cherry-pick        (:foreground sakura-neutral-red))
  (magit-log-reflog-label-commit             (:foreground sakura-neutral-green))
  (magit-log-reflog-label-merge              (:foreground sakura-bright-green))
  (magit-log-reflog-label-other              (:foreground sakura-faded-red))
  (magit-log-reflog-label-rebase             (:foreground sakura-bright-blue))
  (magit-log-reflog-label-remote             (:foreground sakura-neutral-orange))
  (magit-log-reflog-label-reset              (:foreground sakura-neutral-yellow))
  (magit-log-sha1                            (:foreground sakura-bright-orange))
  (magit-popup-argument                      (:inherit 'font-lock-warning-face))
  (magit-popup-disabled-argument             (:foreground sakura-foreground-4))
  (magit-popup-heading                       (:inherit 'font-lock-keyword-face))
  (magit-popup-key                           (:inherit 'font-lock-builtin-face))
  (magit-popup-option-value                  (:inherit 'font-lock-string-face))
  (magit-process-ng                          (:foreground sakura-bright-red :weight 'bold))
  (magit-process-ok                          (:foreground sakura-bright-green :weight 'bold))
  (magit-reflog-amend                        (:foreground sakura-identifiers-13))
  (magit-reflog-checkout                     (:foreground sakura-mid-cyan))
  (magit-reflog-cherry-pick                  (:foreground sakura-black))
  (magit-reflog-commit                       (:foreground sakura-black))
  (magit-reflog-merge                        (:foreground sakura-black))
  (magit-reflog-other                        (:foreground sakura-neutral-cyan))
  (magit-reflog-rebase                       (:foreground sakura-identifiers-13))
  (magit-reflog-remote                       (:foreground sakura-neutral-cyan))
  (magit-reflog-reset                        (:foreground sakura-faded-red))
  (magit-refname                             (:foreground sakura-foreground-2))
  (magit-refname-stash                       (:inherit 'magit-refname))
  (magit-refname-wip                         (:inherit 'magit-refname))
  (magit-section-heading                     (:foreground sakura-foreground-2 :background sakura-background-blue))
  (magit-section-heading-selection           (:foreground sakura-medium))
  (magit-section-highlight                   (:background sakura-background-0-soft))
  (magit-section-secondary-heading           (:weight 'bold))
  (magit-sequence-done                       (:inherit 'magit-hash))
  (magit-sequence-drop                       (:foreground sakura-faded-red))
  (magit-sequence-head                       (:foreground sakura-faded-cyan))
  (magit-sequence-onto                       (:inherit 'magit-sequence-done))
  (magit-sequence-part                       (:foreground sakura-bright-yellow))
  (magit-sequence-pick                       (:inherit 'default))
  (magit-sequence-stop                       (:foreground sakura-bright-teal))
  (magit-signature-bad                       (:foreground sakura-bright-red :weight 'bold))
  (magit-signature-error                     (:foreground sakura-muted-red))
  (magit-signature-expired                   (:foreground sakura-bright-red))
  (magit-signature-expired-key               (:inherit 'magit-signature-expired))
  (magit-signature-good                      (:foreground sakura-bright-green :weight 'bold))
  (magit-signature-none                      (:foreground sakura-faded-red))
  (magit-signature-revoked                   (:foreground sakura-foreground-3))
  (magit-signature-untrusted                 (:foreground sakura-bright-purple :weight 'bold))
  (magit-tag                                 (:foreground sakura-accent-2))
  (magit-whitespace-warning-face             (:background sakura-faded-red))
  (markdown-header-face-1                    (:height 1.9 :inherit 'variable-pitch :foreground sakura-foreground-4))
  (markdown-header-face-2                    (:height 1.8 :inherit 'variable-pitch :foreground sakura-foreground-3))
  (markdown-header-face-3                    (:height 1.6 :inherit 'variable-pitch :foreground sakura-foreground-2))
  (markdown-header-face-4                    (:height 1.5 :inherit 'variable-pitch :foreground sakura-foreground-1))
  (markdown-header-face-5                    (:height 1.4 :inherit 'variable-pitch :foreground sakura-foreground-0-soft))
  (markdown-header-face-6                    (:height 1.3 :inherit 'variable-pitch :foreground sakura-foreground-0))
  (match                                     (:foreground sakura-foreground-0 :background sakura-background-2))
  (mc/cursor-bar-face                        (:height 1 :background sakura-black))
  (mc/cursor-face                            (:inverse-video t))
  (mc/region-face                            (:inherit 'region))
  (menu nil)
  (message-cited-text                        (:foreground sakura-foreground-3))
  (message-header-cc                         (:foreground sakura-bright-cyan))
  (message-header-name                       (:foreground sakura-bright-cyan))
  (message-header-newsgroups                 (:foreground sakura-bright-cyan))
  (message-header-other                      (:foreground sakura-muted-cyan))
  (message-header-subject                    (:foreground sakura-foreground-2))
  (message-header-to                         (:foreground sakura-bright-cyan))
  (message-header-xheader                    (:foreground sakura-faded-cyan))
  (message-mml                               (:foreground sakura-faded-teal))
  (message-separator                         (:foreground sakura-faded-cyan))
  (minibuffer-complete-cycle                 (:inherit 'secondary-selection))
  (minibuffer-prompt                         (:foreground sakura-accent-1 :background sakura-background-0 :bold nil))
  (mm-command-output                         (:foreground sakura-mid-teal))
  (mode-line                                 (:foreground sakura-foreground-1 :background sakura-background-0-hard :box nil))
  (mode-line-buffer-id                       (:weight 'bold))
  (mode-line-emphasis                        (:weight 'bold))
  (mode-line-highlight                       (:box (:line-width 2 :color sakura-background-3 :style 'released-button)))
  (mode-line-inactive                        (:foreground sakura-foreground-4 :background sakura-background-2 :box nil))
  (mouse nil)
  (nameless-face                             (:inherit 'font-lock-type-face))
  (next-error                                (:inherit 'region))
  (nobreak-space                             (:underline t :inherit 'escape-glyph))
  (orderless-match-face-0                    (:foreground sakura-accent-1))
  (orderless-match-face-1                    (:foreground sakura-accent-2))
  (orderless-match-face-2                    (:foreground sakura-accent-3))
  (orderless-match-face-3                    (:foreground sakura-accent-4))
  (org-agenda-date-today                     (:foreground sakura-foreground-2 :slant 'italic :weight 'bold))
  (org-agenda-structure                      (:inherit 'font-lock-comment-face))
  (org-archived                              (:foreground sakura-foreground-0 :weight 'bold))
  (org-checkbox                              (:foreground sakura-foreground-2 :background sakura-background-0 :box (:line-width 1 :style 'released-button)))
  (org-column                                (:background sakura-background-0))
  (org-column-title                          (:background sakura-background-0-hard :underline t :weight 'bold))
  (org-date                                  (:foreground sakura-faded-blue :underline t))
  (org-deadline-announce                     (:foreground sakura-faded-red))
  (org-done                                  (:foreground sakura-bright-green :bold t :weight 'bold))
  (org-ellipsis                              (:foreground sakura-bright-yellow :underline t))
  (org-footnote                              (:foreground sakura-faded-teal :underline t))
  (org-formula                               (:foreground sakura-bright-yellow))
  (org-headline-done                         (:foreground sakura-bright-green))
  (org-hide                                  (:foreground sakura-background-0))
  (org-level-1                               (:foreground sakura-bright-orange))
  (org-level-2                               (:foreground sakura-bright-green))
  (org-level-3                               (:foreground sakura-bright-blue))
  (org-level-4                               (:foreground sakura-bright-yellow))
  (org-level-5                               (:foreground sakura-faded-teal))
  (org-level-6                               (:foreground sakura-bright-green))
  (org-level-7                               (:foreground sakura-bright-red))
  (org-level-8                               (:foreground sakura-bright-blue))
  (org-link                                  (:foreground sakura-bright-yellow :underline t))
  (org-mode-line-clock                       (:foreground sakura-foreground-2 :background sakura-background-0))
  (org-mode-line-clock-overrun               (:foreground sakura-black :background sakura-bright-red))
  (org-scheduled                             (:foreground sakura-bright-green))
  (org-scheduled-previously                  (:foreground sakura-bright-red))
  (org-scheduled-today                       (:foreground sakura-bright-blue))
  (org-sexp-date                             (:foreground sakura-bright-blue :underline t))
  (org-special-keyword                       (:inherit 'font-lock-comment-face))
  (org-table                                 (:foreground sakura-bright-green))
  (org-tag                                   (:bold t :weight 'bold))
  (org-time-grid                             (:foreground sakura-bright-orange))
  (org-todo                                  (:foreground sakura-bright-red :weight 'bold :bold t))
  (org-upcoming-deadline                     (:inherit 'font-lock-keyword-face))
  (org-warning                               (:foreground sakura-bright-red :weight 'bold :underline nil :bold t))
  (package-description                       (:inherit 'default))
  (package-help-section-name                 (:inherit ('bold 'font-lock-function-name-face)))
  (package-name                              (:inherit 'link))
  (package-status-avail-obso                 (:inherit 'package-status-incompat))
  (package-status-available                  (:inherit 'default))
  (package-status-built-in                   (:inherit 'font-lock-builtin-face))
  (package-status-dependency                 (:inherit 'package-status-installed))
  (package-status-disabled                   (:inherit 'font-lock-warning-face))
  (package-status-external                   (:inherit 'package-status-built-in))
  (package-status-held                       (:inherit 'font-lock-constant-face))
  (package-status-incompat                   (:inherit 'font-lock-comment-face))
  (package-status-installed                  (:inherit 'font-lock-comment-face))
  (package-status-new                        (:inherit ('bold 'package-status-available)))
  (package-status-unsigned                   (:inherit 'font-lock-warning-face))
  (popup-face                                (:foreground sakura-foreground-0 :background sakura-background-1))
  (popup-isearch-match                       (:background sakura-background-green :inherit 'default))
  (popup-menu-face                           (:inherit 'popup-face))
  (popup-menu-mouse-face                     (:foreground sakura-foreground-0 :background sakura-faded-blue))
  (popup-menu-selection-face                 (:foreground sakura-foreground-0 :background sakura-faded-blue))
  (popup-menu-summary-face                   (:inherit 'popup-summary-face))
  (popup-scroll-bar-background-face          (:background sakura-neutral-purple))
  (popup-scroll-bar-foreground-face          (:background sakura-black))
  (popup-summary-face                        (:foreground sakura-background-4 :inherit 'popup-face))
  (popup-tip-face                            (:foreground sakura-foreground-0-hard :background sakura-background-teal))
  (powerline-active1                         (:background sakura-background-2 :inherit 'mode-line))
  (powerline-active2                         (:background sakura-background-1 :inherit 'mode-line))
  (powerline-inactive1                       (:background sakura-medium :inherit 'mode-line-inactive))
  (powerline-inactive2                       (:background sakura-background-2 :inherit 'mode-line-inactive))
  (query-replace                             (:inherit 'isearch))
  (rainbow-delimiters-depth-1-face           (:foreground sakura-delimiter-1))
  (rainbow-delimiters-depth-10-face          (:foreground sakura-delimiter-2))
  (rainbow-delimiters-depth-11-face          (:foreground sakura-delimiter-3))
  (rainbow-delimiters-depth-12-face          (:foreground sakura-delimiter-4))
  (rainbow-delimiters-depth-2-face           (:foreground sakura-delimiter-2))
  (rainbow-delimiters-depth-3-face           (:foreground sakura-delimiter-3))
  (rainbow-delimiters-depth-4-face           (:foreground sakura-delimiter-4))
  (rainbow-delimiters-depth-5-face           (:foreground sakura-delimiter-1))
  (rainbow-delimiters-depth-6-face           (:foreground sakura-delimiter-2))
  (rainbow-delimiters-depth-7-face           (:foreground sakura-delimiter-3))
  (rainbow-delimiters-depth-8-face           (:foreground sakura-delimiter-4))
  (rainbow-delimiters-depth-9-face           (:foreground sakura-delimiter-1))
  (rainbow-delimiters-mismatched-face        (:inherit 'rainbow-delimiters-unmatched-face))
  (rainbow-delimiters-unmatched-face         (:foreground sakura-foreground-0 :background nil))
  (rainbow-identifiers-identifier-1          (:foreground sakura-identifiers-1))
  (rainbow-identifiers-identifier-10         (:foreground sakura-identifiers-10))
  (rainbow-identifiers-identifier-11         (:foreground sakura-identifiers-11))
  (rainbow-identifiers-identifier-12         (:foreground sakura-identifiers-12))
  (rainbow-identifiers-identifier-13         (:foreground sakura-identifiers-13))
  (rainbow-identifiers-identifier-14         (:foreground sakura-identifiers-14))
  (rainbow-identifiers-identifier-15         (:foreground sakura-identifiers-15))
  (rainbow-identifiers-identifier-2          (:foreground sakura-identifiers-2))
  (rainbow-identifiers-identifier-3          (:foreground sakura-identifiers-3))
  (rainbow-identifiers-identifier-4          (:foreground sakura-identifiers-4))
  (rainbow-identifiers-identifier-5          (:foreground sakura-identifiers-5))
  (rainbow-identifiers-identifier-6          (:foreground sakura-identifiers-6))
  (rainbow-identifiers-identifier-7          (:foreground sakura-identifiers-7))
  (rainbow-identifiers-identifier-8          (:foreground sakura-identifiers-8))
  (rainbow-identifiers-identifier-9          (:foreground sakura-identifiers-9))
  (rectangle-preview                         (:inherit 'region))
  (region                                    (:background sakura-background-2 :distant-foreground sakura-foreground-0))
  (ripgrep-hit-face                          (:inherit 'ag-hit-face))
  (ripgrep-match-face                        (:inherit 'ag-match-face))
  (scroll-bar nil)
  (secondary-selection                       (:background sakura-background-3))
  (semantic-highlight-edits-face             (:background sakura-background-0-soft))
  (semantic-highlight-func-current-tag-face  (:background sakura-background-0-soft))
  (semantic-unmatched-syntax-face            (:underline sakura-faded-red))
  (sgml-namespace                            (:inherit 'font-lock-builtin-face))
  (sh-heredoc                                (:foreground sakura-accent-2 :background nil))
  (sh-quoted-exec                            (:foreground sakura-accent-2 :background nil))
  (shadow                                    (:foreground sakura-neutral-purple))
  (show-paren-match                          (:foreground sakura-medium :background sakura-background-3))
  (show-paren-mismatch                       (:foreground sakura-bright-red :background sakura-background-3))
  (shr-link                                  (:inherit 'link))
  (shr-strike-through                        (:strike-through t))
  (smerge-base                               (:background sakura-medium))
  (smerge-markers                            (:background sakura-background-0-soft))
  (smerge-mine                               (:background sakura-background-2))
  (smerge-other                              (:background sakura-background-1))
  (smerge-refined-added                      (:background sakura-background-green))
  (smerge-refined-changed nil)
  (smerge-refined-removed                    (:background sakura-background-red))
  (sml/charging                              (:foreground sakura-faded-teal))
  (sml/col-number                            (:foreground sakura-neutral-orange))
  (sml/discharging                           (:foreground sakura-faded-teal :weight 'bold))
  (sml/filename                              (:foreground sakura-foreground-0-hard :weight 'bold :bold t))
  (sml/git                                   (:inherit 'sml/prefix))
  (sml/minor-modes                           (:foreground sakura-neutral-orange))
  (sml/modes                                 (:foreground sakura-foreground-0-hard :weight 'bold :bold t))
  (sml/modified                              (:foreground sakura-neutral-blue))
  (sml/outside-modified                      (:foreground sakura-neutral-blue))
  (sml/position-percentage                   (:foreground sakura-faded-teal))
  (sml/prefix                                (:foreground sakura-neutral-blue))
  (sml/process                               (:inherit 'sml/prefix))
  (sml/read-only                             (:foreground sakura-neutral-blue))
  (sml/sudo                                  (:foreground sakura-background-orange :weight 'bold))
  (sml/vc                                    (:foreground sakura-faded-green))
  (sml/vc-edited                             (:foreground sakura-bright-green))
  (sp-pair-overlay-face                      (:background sakura-background-2))
  (sp-show-pair-enclosing                    (:inherit 'highlight))
  (sp-show-pair-match-face                   (:background sakura-background-2))
  (sp-show-pair-mismatch-face                (:background sakura-bright-red))
  (sp-wrap-overlay-closing-pair              (:foreground sakura-faded-red :inherit 'sp-wrap-overlay-face))
  (sp-wrap-overlay-face                      (:inherit 'sp-pair-overlay-face))
  (sp-wrap-overlay-opening-pair              (:foreground sakura-black :inherit 'sp-wrap-overlay-face))
  (sp-wrap-tag-overlay-face                  (:inherit 'sp-pair-overlay-face))
  (spaceline-evil-emacs                      (:background sakura-bright-red :foreground sakura-background-0))
  (spaceline-evil-insert                     (:background sakura-bright-yellow :foreground sakura-background-0))
  (spaceline-evil-motion                     (:background sakura-bright-green :foreground sakura-background-0))
  (spaceline-evil-normal                     (:background sakura-bright-blue :foreground sakura-background-0))
  (spaceline-evil-replace                    (:background sakura-bright-orange :foreground sakura-background-0))
  (spaceline-evil-visual                     (:background sakura-bright-purple :foreground sakura-background-0))
  (stripe-highlight                          (:background sakura-background-0-hard))
  (success                                   (:foreground sakura-bright-green :bold t))
  (swiper-line-face                          (:inherit 'highlight))
  (swiper-match-face-1                       (:inherit 'isearch-lazy-highlight-face))
  (swiper-match-face-2                       (:inherit 'isearch))
  (swiper-match-face-3                       (:inherit 'match))
  (swiper-match-face-4                       (:inherit 'isearch-fail))
  (term-color-black                          (:foreground sakura-background-1))
  (term-color-blue                           (:foreground sakura-neutral-blue))
  (term-color-cyan                           (:foreground sakura-neutral-cyan))
  (term-color-green                          (:foreground sakura-neutral-green))
  (term-color-magenta                        (:foreground sakura-neutral-purple))
  (term-color-red                            (:foreground sakura-neutral-red))
  (term-color-white                          (:foreground sakura-foreground-1))
  (term-color-yellow                         (:foreground sakura-neutral-yellow))
  (term-default-bg-color                     (:background sakura-background-0))
  (term-default-fg-color                     (:foreground sakura-foreground-0))
  (tool-bar                                  (:box (:line-width 1 :style 'released-button) :foreground sakura-black :background sakura-neutral-purple))
  (tooltip                                   (:foreground sakura-black :background sakura-foreground-0-hard :inherit 'variable-pitch))
  (trailing-whitespace                       (:background sakura-faded-red))
  (tty-menu-disabled-face                    (:foreground sakura-identifiers-1 :background sakura-mid-cyan))
  (tty-menu-enabled-face                     (:weight 'bold :foreground sakura-foreground-0-hard :background sakura-mid-cyan))
  (tty-menu-selected-face                    (:background sakura-faded-red))
  (underline                                 (:underline t))
  (variable-pitch                            (:family "Sans Serif"))
  (vc-conflict-state                         (:inherit 'vc-state-base))
  (vc-edited-state                           (:inherit 'vc-state-base))
  (vc-locally-added-state                    (:inherit 'vc-state-base))
  (vc-locked-state                           (:inherit 'vc-state-base))
  (vc-missing-state                          (:inherit 'vc-state-base))
  (vc-needs-update-state                     (:inherit 'vc-state-base))
  (vc-removed-state                          (:inherit 'vc-state-base))
  (vc-state-base nil)
  (vc-up-to-date-state                       (:inherit 'vc-state-base))
  (vertical-border                           (:foreground sakura-background-2))
  (vertico-posframe                          (:background sakura-background-0-hard))
  (vertico-posframe-border                   (:background sakura-background-0-hard))
  (vertico-posframe-border-2                 (:background sakura-background-0))
  (vertico-posframe-border-3                 (:background sakura-background-1))
  (vertico-posframe-border-4                 (:background sakura-background-2))
  (vline                                     (:background sakura-background-teal))
  (vline-visual                              (:background sakura-background-teal))
  (w3m-haddock-heading-face                  (:inherit 'highlight))
  (warning                                   (:foreground sakura-bright-red :bold t))
  (web-mode-doctype-face                     (:foreground sakura-foreground-2 :weight 'bold))
  (web-mode-html-attr-equal-face             (:inherit 'default))
  (web-mode-html-attr-name-face              (:inherit 'font-lock-variable-name-face))
  (web-mode-html-tag-bracket-face            (:inherit 'default))
  (web-mode-html-tag-face                    (:foreground sakura-foreground-3))
  (which-key-command-description-face        (:inherit 'font-lock-function-name-face))
  (which-key-group-description-face          (:inherit 'font-lock-keyword-face))
  (which-key-highlighted-command-face        (:underline t :inherit 'which-key-command-description-face))
  (which-key-key-face                        (:inherit 'font-lock-constant-face))
  (which-key-local-map-description-face      (:inherit 'which-key-command-description-face))
  (which-key-note-face                       (:inherit 'which-key-separator-face))
  (which-key-separator-face                  (:inherit 'font-lock-comment-face))
  (which-key-special-key-face                (:weight 'bold :inverse-video t :inherit 'which-key-key-face))
  (whitespace-empty                          (:foreground nil :background nil))
  (whitespace-hspace                         (:foreground sakura-background-4 :background sakura-background-0))
  (whitespace-indentation                    (:foreground sakura-background-4 :background sakura-background-0))
  (whitespace-line                           (:foreground sakura-neutral-red :background sakura-background-1))
  (whitespace-newline                        (:foreground sakura-background-4 :background sakura-background-0))
  (whitespace-space                          (:foreground sakura-background-4 :background sakura-background-0))
  (whitespace-space-after-tab                (:foreground sakura-background-4 :background sakura-background-0))
  (whitespace-space-before-tab               (:foreground sakura-background-4 :background sakura-background-0))
  (whitespace-tab                            (:foreground sakura-background-4 :background sakura-background-0))
  (whitespace-trailing                       (:foreground sakura-neutral-red :background sakura-background-1))
  (widget-button                             (:weight 'bold))
  (widget-button-pressed                     (:foreground sakura-faded-red))
  (widget-documentation                      (:foreground sakura-mid-yellow))
  (widget-field                              (:background sakura-background-4))
  (widget-inactive                           (:inherit 'shadow))
  (widget-single-line-field                  (:background sakura-background-4))
  (window-divider                            (:foreground sakura-background-2))
  (window-divider-first-pixel                (:foreground sakura-background-2))
  (window-divider-last-pixel                 (:foreground sakura-background-2))
  (yas-field-highlight-face                  (:inherit 'region)))

 (custom-theme-set-variables 'sakura
                             `(pos-tip-foreground-color ,sakura-foreground-0-hard)
                             `(pos-tip-background-color ,sakura-background-teal)
                             `(ansi-color-names-vector [,sakura-background-1
                                                        ,sakura-bright-red
                                                        ,sakura-bright-green
                                                        ,sakura-bright-yellow
                                                        ,sakura-bright-blue
                                                        ,sakura-bright-purple
                                                        ,sakura-bright-cyan
                                                        ,sakura-foreground-1])))

;;;###autoload
(and load-file-name
     (boundp 'custom-theme-load-path)
     (add-to-list 'custom-theme-load-path
                  (file-name-as-directory
                   (file-name-directory load-file-name))))

(provide-theme 'sakura)

;; Local Variables:
;; eval: (when (fboundp 'rainbow-mode) (rainbow-mode 1))
;; End:

;;; sakura-theme.el ends here.
