/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dtd.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMStateSet;
import com.sun.org.apache.xerces.internal.xni.QName;

public class CMLeaf
extends CMNode {
    private QName fElement = new QName();
    private int fPosition = -1;

    public CMLeaf(QName qName, int n) {
        super(0);
        this.fElement.setValues(qName);
        this.fPosition = n;
    }

    public CMLeaf(QName qName) {
        super(0);
        this.fElement.setValues(qName);
    }

    final QName getElement() {
        return this.fElement;
    }

    final int getPosition() {
        return this.fPosition;
    }

    final void setPosition(int n) {
        this.fPosition = n;
    }

    @Override
    public boolean isNullable() {
        return this.fPosition == -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.fElement.toString());
        stringBuilder.append(" (");
        stringBuilder.append(this.fElement.uri);
        stringBuilder.append(',');
        stringBuilder.append(this.fElement.localpart);
        stringBuilder.append(')');
        if (this.fPosition >= 0) {
            stringBuilder.append(" (Pos:" + this.fPosition + ")");
        }
        return stringBuilder.toString();
    }

    @Override
    protected void calcFirstPos(CMStateSet cMStateSet) {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }

    @Override
    protected void calcLastPos(CMStateSet cMStateSet) {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }
}

