/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodHandle;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodType;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConstantPool
implements Cloneable,
Node {
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constantArray) {
        this.constant_pool = constantArray;
    }

    public ConstantPool(DataInput dataInput) throws IOException, ClassFormatException {
        int n = dataInput.readUnsignedShort();
        this.constant_pool = new Constant[n];
        for (int i = 1; i < n; ++i) {
            this.constant_pool[i] = Constant.readConstant(dataInput);
            byte by = this.constant_pool[i].getTag();
            if (by != 6 && by != 5) continue;
            ++i;
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    public String constantToString(Constant constant) throws ClassFormatException {
        String string;
        byte by = constant.getTag();
        switch (by) {
            case 7: {
                int n = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstant(n, (byte)1);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = this.getConstant(n, (byte)1);
                string = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            case 1: {
                string = ((ConstantUtf8)constant).getBytes();
                break;
            }
            case 6: {
                string = String.valueOf(((ConstantDouble)constant).getBytes());
                break;
            }
            case 4: {
                string = String.valueOf(((ConstantFloat)constant).getBytes());
                break;
            }
            case 5: {
                string = String.valueOf(((ConstantLong)constant).getBytes());
                break;
            }
            case 3: {
                string = String.valueOf(((ConstantInteger)constant).getBytes());
                break;
            }
            case 12: {
                string = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 15: {
                ConstantMethodHandle constantMethodHandle = (ConstantMethodHandle)constant;
                string = Const.getMethodHandleName(constantMethodHandle.getReferenceKind()) + " " + this.constantToString(constantMethodHandle.getReferenceIndex(), this.getConstant(constantMethodHandle.getReferenceIndex()).getTag());
                break;
            }
            case 16: {
                ConstantMethodType constantMethodType = (ConstantMethodType)constant;
                string = this.constantToString(constantMethodType.getDescriptorIndex(), (byte)1);
                break;
            }
            case 18: {
                ConstantInvokeDynamic constantInvokeDynamic = (ConstantInvokeDynamic)constant;
                string = constantInvokeDynamic.getBootstrapMethodAttrIndex() + ":" + this.constantToString(constantInvokeDynamic.getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + by);
            }
        }
        return string;
    }

    private static String escape(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 5);
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                default: {
                    stringBuilder.append(cArray[i]);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String constantToString(int n, byte by) throws ClassFormatException {
        Constant constant = this.getConstant(n, by);
        return this.constantToString(constant);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constant_pool.length);
        for (int i = 1; i < this.constant_pool.length; ++i) {
            if (this.constant_pool[i] == null) continue;
            this.constant_pool[i].dump(dataOutputStream);
        }
    }

    public Constant getConstant(int n) {
        if (n >= this.constant_pool.length || n < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + n + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[n];
    }

    public Constant getConstant(int n, byte by) throws ClassFormatException {
        Constant constant = this.getConstant(n);
        if (constant == null) {
            throw new ClassFormatException("Constant pool at index " + n + " is null.");
        }
        if (constant.getTag() != by) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(by) + "' at index " + n + " and got " + constant);
        }
        return constant;
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int n, byte by) throws ClassFormatException {
        int n2;
        Constant constant = this.getConstant(n, by);
        switch (by) {
            case 7: {
                n2 = ((ConstantClass)constant).getNameIndex();
                break;
            }
            case 8: {
                n2 = ((ConstantString)constant).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by);
            }
        }
        constant = this.getConstant(n2, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public int getLength() {
        return this.constant_pool == null ? 0 : this.constant_pool.length;
    }

    public void setConstant(int n, Constant constant) {
        this.constant_pool[n] = constant;
    }

    public void setConstantPool(Constant[] constantArray) {
        this.constant_pool = constantArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < this.constant_pool.length; ++i) {
            stringBuilder.append(i).append(")").append(this.constant_pool[i]).append("\n");
        }
        return stringBuilder.toString();
    }

    public ConstantPool copy() {
        ConstantPool constantPool = null;
        try {
            constantPool = (ConstantPool)this.clone();
            constantPool.constant_pool = new Constant[this.constant_pool.length];
            for (int i = 1; i < this.constant_pool.length; ++i) {
                if (this.constant_pool[i] == null) continue;
                constantPool.constant_pool[i] = this.constant_pool[i].copy();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return constantPool;
    }
}

