/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLMasterKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.util.KeyUtil;

final class RSAKeyExchange {
    static final SSLPossessionGenerator poGenerator = new EphemeralRSAPossessionGenerator();
    static final SSLKeyAgreementGenerator kaGenerator = new RSAKAGenerator();

    RSAKeyExchange() {
    }

    static final class EphemeralRSACredentials
    implements SSLCredentials {
        final RSAPublicKey popPublicKey;

        EphemeralRSACredentials(RSAPublicKey rSAPublicKey) {
            this.popPublicKey = rSAPublicKey;
        }
    }

    static final class EphemeralRSAPossession
    implements SSLPossession {
        final RSAPublicKey popPublicKey;
        final PrivateKey popPrivateKey;

        EphemeralRSAPossession(PrivateKey privateKey, RSAPublicKey rSAPublicKey) {
            this.popPublicKey = rSAPublicKey;
            this.popPrivateKey = privateKey;
        }
    }

    private static final class EphemeralRSAPossessionGenerator
    implements SSLPossessionGenerator {
        private EphemeralRSAPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            try {
                EphemeralKeyManager ephemeralKeyManager = handshakeContext.sslContext.getEphemeralKeyManager();
                KeyPair keyPair = ephemeralKeyManager.getRSAKeyPair(true, handshakeContext.sslContext.getSecureRandom());
                if (keyPair != null) {
                    return new EphemeralRSAPossession(keyPair.getPrivate(), (RSAPublicKey)keyPair.getPublic());
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }
    }

    private static final class RSAKAGenerator
    implements SSLKeyAgreementGenerator {
        private RSAKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            RSAPremasterSecret rSAPremasterSecret = null;
            if (handshakeContext instanceof ClientHandshakeContext) {
                for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                    if (!(sSLPossession instanceof RSAPremasterSecret)) continue;
                    rSAPremasterSecret = (RSAPremasterSecret)sSLPossession;
                    break;
                }
            } else {
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof RSAPremasterSecret)) continue;
                    rSAPremasterSecret = (RSAPremasterSecret)sSLCredentials;
                    break;
                }
            }
            if (rSAPremasterSecret == null) {
                handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient RSA key agreement parameters negotiated");
            }
            return new RSAKAKeyDerivation(handshakeContext, rSAPremasterSecret.premasterSecret);
        }

        private static final class RSAKAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final SecretKey preMasterSecret;

            RSAKAKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) {
                this.context = handshakeContext;
                this.preMasterSecret = secretKey;
            }

            @Override
            public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (sSLMasterKeyDerivation == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, this.preMasterSecret);
                return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
            }
        }
    }

    static final class RSAPremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final SecretKey premasterSecret;

        RSAPremasterSecret(SecretKey secretKey) {
            this.premasterSecret = secretKey;
        }

        byte[] getEncoded(PublicKey publicKey, SecureRandom secureRandom) throws GeneralSecurityException {
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, secureRandom);
            return cipher.wrap(this.premasterSecret);
        }

        static RSAPremasterSecret createPremasterSecret(ClientHandshakeContext clientHandshakeContext) throws GeneralSecurityException {
            String string = clientHandshakeContext.negotiatedProtocol.useTLS12PlusSpec() ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string);
            TlsRsaPremasterSecretParameterSpec tlsRsaPremasterSecretParameterSpec = new TlsRsaPremasterSecretParameterSpec(clientHandshakeContext.clientHelloVersion, clientHandshakeContext.negotiatedProtocol.id);
            keyGenerator.init(tlsRsaPremasterSecretParameterSpec, clientHandshakeContext.sslContext.getSecureRandom());
            return new RSAPremasterSecret(keyGenerator.generateKey());
        }

        static RSAPremasterSecret decode(ServerHandshakeContext serverHandshakeContext, PrivateKey privateKey, byte[] byArray) throws GeneralSecurityException {
            SecretKey secretKey;
            byte[] byArray2 = null;
            boolean bl = false;
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            try {
                cipher.init(4, (Key)privateKey, new TlsRsaPremasterSecretParameterSpec(serverHandshakeContext.clientHelloVersion, serverHandshakeContext.negotiatedProtocol.id), serverHandshakeContext.sslContext.getSecureRandom());
                bl = !KeyUtil.isOracleJCEProvider(cipher.getProvider().getName());
            }
            catch (UnsupportedOperationException | InvalidKeyException exception) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("The Cipher provider " + RSAPremasterSecret.safeProviderName(cipher) + " caused exception: " + exception.getMessage(), new Object[0]);
                }
                bl = true;
            }
            if (bl) {
                cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
                cipher.init(2, privateKey);
                boolean bl2 = false;
                try {
                    byArray2 = cipher.doFinal(byArray);
                }
                catch (BadPaddingException badPaddingException) {
                    bl2 = true;
                }
                byArray2 = KeyUtil.checkTlsPreMasterSecretKey(serverHandshakeContext.clientHelloVersion, serverHandshakeContext.negotiatedProtocol.id, serverHandshakeContext.sslContext.getSecureRandom(), byArray2, bl2);
                secretKey = RSAPremasterSecret.generatePremasterSecret(serverHandshakeContext.clientHelloVersion, serverHandshakeContext.negotiatedProtocol.id, byArray2, serverHandshakeContext.sslContext.getSecureRandom());
            } else {
                secretKey = (SecretKey)cipher.unwrap(byArray, "TlsRsaPremasterSecret", 3);
            }
            return new RSAPremasterSecret(secretKey);
        }

        private static String safeProviderName(Cipher cipher) {
            try {
                return cipher.getProvider().toString();
            }
            catch (Exception exception) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Retrieving The Cipher provider name caused exception ", exception);
                }
                try {
                    return ((Object)cipher).toString() + " (provider name not available)";
                }
                catch (Exception exception2) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Retrieving The Cipher name caused exception ", exception2);
                    }
                    return "(cipher/provider names not available)";
                }
            }
        }

        private static SecretKey generatePremasterSecret(int n, int n2, byte[] byArray, SecureRandom secureRandom) throws GeneralSecurityException {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Generating a premaster secret", new Object[0]);
            }
            try {
                String string = n >= ProtocolVersion.TLS12.id ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
                KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string);
                keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(n, n2, byArray), secureRandom);
                return keyGenerator.generateKey();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("RSA premaster secret generation error:", new Object[0]);
                    generalSecurityException.printStackTrace(System.out);
                }
                throw new GeneralSecurityException("Could not generate premaster secret", generalSecurityException);
            }
        }
    }
}

