// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.util');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.pprint');
goog.require('clojure.string');
goog.require('cljs.reader');
goog.require('goog.async.Debouncer');
org_analyzer.view.util.date_string = (function org_analyzer$view$util$date_string(date){
return cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(date.toISOString(),"T"));
});
org_analyzer.view.util.weeks = (function org_analyzer$view$util$weeks(days){
var week = cljs.core.PersistentVector.EMPTY;
var weeks = cljs.core.PersistentVector.EMPTY;
var days__$1 = days;
while(true){
if(cljs.core.empty_QMARK_(days__$1)){
if(cljs.core.empty_QMARK_(week)){
return weeks;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(weeks,week);
}
} else {
var vec__15041 = days__$1;
var seq__15042 = cljs.core.seq(vec__15041);
var first__15043 = cljs.core.first(seq__15042);
var seq__15042__$1 = cljs.core.next(seq__15042);
var day = first__15043;
var days__$2 = seq__15042__$1;
var week__$1 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(week,day);
var sunday_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((7),cljs.core.cst$kw$dow.cljs$core$IFn$_invoke$arity$1(day));
var weeks__$1 = ((sunday_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(weeks,week__$1):weeks);
var G__15044 = ((sunday_QMARK_)?cljs.core.PersistentVector.EMPTY:week__$1);
var G__15045 = weeks__$1;
var G__15046 = days__$2;
week = G__15044;
weeks = G__15045;
days__$1 = G__15046;
continue;
}
break;
}
});
org_analyzer.view.util.sum_clocks_mins = (function org_analyzer$view$util$sum_clocks_mins(clocks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,(function (){var iter__4523__auto__ = (function org_analyzer$view$util$sum_clocks_mins_$_iter__15048(s__15049){
return (new cljs.core.LazySeq(null,(function (){
var s__15049__$1 = s__15049;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__15049__$1);
if(temp__5457__auto__){
var s__15049__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__15049__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__15049__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__15051 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__15050 = (0);
while(true){
if((i__15050 < size__4522__auto__)){
var map__15052 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__15050);
var map__15052__$1 = (((((!((map__15052 == null))))?(((((map__15052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15052.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15052):map__15052);
var duration = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15052__$1,cljs.core.cst$kw$duration);
cljs.core.chunk_append(b__15051,(function (){var vec__15054 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__15050,map__15052,map__15052__$1,duration,c__4521__auto__,size__4522__auto__,b__15051,s__15049__$2,temp__5457__auto__){
return (function (p1__15047_SHARP_){
return (new Number(p1__15047_SHARP_));
});})(i__15050,map__15052,map__15052__$1,duration,c__4521__auto__,size__4522__auto__,b__15051,s__15049__$2,temp__5457__auto__))
,clojure.string.split.cljs$core$IFn$_invoke$arity$2(duration,":"));
var hours = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15054,(0),null);
var mins = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15054,(1),null);
var result = (((60) * hours) + mins);
if(cljs.core.truth_(isNaN(result))){
return (0);
} else {
return result;
}
})());

var G__15062 = (i__15050 + (1));
i__15050 = G__15062;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15051),org_analyzer$view$util$sum_clocks_mins_$_iter__15048(cljs.core.chunk_rest(s__15049__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15051),null);
}
} else {
var map__15057 = cljs.core.first(s__15049__$2);
var map__15057__$1 = (((((!((map__15057 == null))))?(((((map__15057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15057.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15057):map__15057);
var duration = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15057__$1,cljs.core.cst$kw$duration);
return cljs.core.cons((function (){var vec__15059 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__15057,map__15057__$1,duration,s__15049__$2,temp__5457__auto__){
return (function (p1__15047_SHARP_){
return (new Number(p1__15047_SHARP_));
});})(map__15057,map__15057__$1,duration,s__15049__$2,temp__5457__auto__))
,clojure.string.split.cljs$core$IFn$_invoke$arity$2(duration,":"));
var hours = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15059,(0),null);
var mins = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15059,(1),null);
var result = (((60) * hours) + mins);
if(cljs.core.truth_(isNaN(result))){
return (0);
} else {
return result;
}
})(),org_analyzer$view$util$sum_clocks_mins_$_iter__15048(cljs.core.rest(s__15049__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(clocks);
})());
});
org_analyzer.view.util.sum_clocks_count = (function org_analyzer$view$util$sum_clocks_count(clocks){
return cljs.core.count(clocks);
});
org_analyzer.view.util.org_link_re = /(.*)\[\[([^\]]+)\]\[([^\]]+)\]\](.*)/;
org_analyzer.view.util.parse_org_link = (function org_analyzer$view$util$parse_org_link(string,i){
var temp__5455__auto__ = cljs.core.re_find(org_analyzer.view.util.org_link_re,string);
if(cljs.core.truth_(temp__5455__auto__)){
var vec__15063 = temp__5455__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15063,(0),null);
var before = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15063,(1),null);
var link = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15063,(2),null);
var link_title = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15063,(3),null);
var after = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15063,(4),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,i], null),before], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$key,((1) + i),cljs.core.cst$kw$href,link,cljs.core.cst$kw$target,"_blank"], null),link_title], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,((2) + i)], null),after], null)], null);
} else {
return null;
}
});
org_analyzer.view.util.parse_all_org_links = (function org_analyzer$view$util$parse_all_org_links(string){
var G__15072 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,(0)], null),string], null)], null);
var vec__15073 = G__15072;
var seq__15074 = cljs.core.seq(vec__15073);
var first__15075 = cljs.core.first(seq__15074);
var seq__15074__$1 = cljs.core.next(seq__15074);
var vec__15076 = first__15075;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15076,(0),null);
var attrs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15076,(1),null);
var string__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15076,(2),null);
var rest = seq__15074__$1;
var i = (1);
var G__15072__$1 = G__15072;
var i__$1 = i;
while(true){
var vec__15088 = G__15072__$1;
var seq__15089 = cljs.core.seq(vec__15088);
var first__15090 = cljs.core.first(seq__15089);
var seq__15089__$1 = cljs.core.next(seq__15089);
var vec__15091 = first__15090;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15091,(0),null);
var attrs__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15091,(1),null);
var string__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15091,(2),null);
var rest__$1 = seq__15089__$1;
var i__$2 = i__$1;
var temp__5455__auto__ = org_analyzer.view.util.parse_org_link(string__$2,i__$2);
if(cljs.core.truth_(temp__5455__auto__)){
var vec__15094 = temp__5455__auto__;
var seq__15095 = cljs.core.seq(vec__15094);
var parsed = seq__15095;
var G__15097 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(parsed,rest__$1);
var G__15098 = (i__$2 + cljs.core.count(parsed));
G__15072__$1 = G__15097;
i__$1 = G__15098;
continue;
} else {
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,attrs__$1,string__$2], null)], null),rest__$1);
}
break;
}
});
org_analyzer.view.util.print_duration_mins = (function org_analyzer$view$util$print_duration_mins(mins){
var hours = cljs.core.quot(mins,(60));
var mins__$1 = (mins - (hours * (60)));
return cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~d:~2,'0d",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([hours,mins__$1], 0));
});
org_analyzer.view.util.format_date_time = (function org_analyzer$view$util$format_date_time(d){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.pprint.cl_format,null,"~d-~2,'0d-~2,'0d ~2,'0d:~2,'0d",(function (){var fexpr__15104 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((function (p1__15099_SHARP_){
return p1__15099_SHARP_.getFullYear();
}),(function (p1__15100_SHARP_){
return (p1__15100_SHARP_.getMonth() + (1));
}),(function (p1__15101_SHARP_){
return p1__15101_SHARP_.getDate();
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (p1__15102_SHARP_){
return p1__15102_SHARP_.getHours();
}),(function (p1__15103_SHARP_){
return p1__15103_SHARP_.getMinutes();
})], 0));
return (fexpr__15104.cljs$core$IFn$_invoke$arity$1 ? fexpr__15104.cljs$core$IFn$_invoke$arity$1(d) : fexpr__15104.call(null,d));
})());
});
org_analyzer.view.util.debounce = (function org_analyzer$view$util$debounce(f,interval){
var dbnc = (new goog.async.Debouncer(f,interval));
return ((function (dbnc){
return (function() { 
var G__15105__delegate = function (args){
return dbnc.fire.apply(dbnc,cljs.core.to_array(args));
};
var G__15105 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15106__i = 0, G__15106__a = new Array(arguments.length -  0);
while (G__15106__i < G__15106__a.length) {G__15106__a[G__15106__i] = arguments[G__15106__i + 0]; ++G__15106__i;}
  args = new cljs.core.IndexedSeq(G__15106__a,0,null);
} 
return G__15105__delegate.call(this,args);};
G__15105.cljs$lang$maxFixedArity = 0;
G__15105.cljs$lang$applyTo = (function (arglist__15107){
var args = cljs.core.seq(arglist__15107);
return G__15105__delegate(args);
});
G__15105.cljs$core$IFn$_invoke$arity$variadic = G__15105__delegate;
return G__15105;
})()
;
;})(dbnc))
});
org_analyzer.view.util.minutes_since_midnight = (function org_analyzer$view$util$minutes_since_midnight(time_string){
if(cljs.core.truth_(time_string)){
var vec__15108 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.reader.read_string,cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.re_find(/0?([0-9]{1,2}):0?([0-9]{1,2})/,time_string)));
var hours = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15108,(0),null);
var mins = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15108,(1),null);
return (((60) * hours) + mins);
} else {
return null;
}
});
org_analyzer.view.util.clocks_each_minute = (function org_analyzer$view$util$clocks_each_minute(clocks){
var mins = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.transient$,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((24) * (60)),cljs.core.PersistentVector.EMPTY));
var seq__15111_15127 = cljs.core.seq(clocks);
var chunk__15118_15128 = null;
var count__15119_15129 = (0);
var i__15120_15130 = (0);
while(true){
if((i__15120_15130 < count__15119_15129)){
var clock_15131 = chunk__15118_15128.cljs$core$IIndexed$_nth$arity$2(null,i__15120_15130);
var start_15132 = org_analyzer.view.util.minutes_since_midnight(cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(clock_15131));
var end_15133 = org_analyzer.view.util.minutes_since_midnight(cljs.core.cst$kw$end.cljs$core$IFn$_invoke$arity$1(clock_15131));
var end_15134__$1 = (((end_15133 === (0)))?(((start_15132 === (0)))?(0):(1440)):(((end_15133 < start_15132))?null:end_15133
));
if(cljs.core.truth_(end_15134__$1)){
var seq__15123_15135 = cljs.core.seq(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start_15132,end_15134__$1));
var chunk__15124_15136 = null;
var count__15125_15137 = (0);
var i__15126_15138 = (0);
while(true){
if((i__15126_15138 < count__15125_15137)){
var i_15139 = chunk__15124_15136.cljs$core$IIndexed$_nth$arity$2(null,i__15126_15138);
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mins,i_15139),clock_15131);


var G__15140 = seq__15123_15135;
var G__15141 = chunk__15124_15136;
var G__15142 = count__15125_15137;
var G__15143 = (i__15126_15138 + (1));
seq__15123_15135 = G__15140;
chunk__15124_15136 = G__15141;
count__15125_15137 = G__15142;
i__15126_15138 = G__15143;
continue;
} else {
var temp__5457__auto___15144 = cljs.core.seq(seq__15123_15135);
if(temp__5457__auto___15144){
var seq__15123_15145__$1 = temp__5457__auto___15144;
if(cljs.core.chunked_seq_QMARK_(seq__15123_15145__$1)){
var c__4550__auto___15146 = cljs.core.chunk_first(seq__15123_15145__$1);
var G__15147 = cljs.core.chunk_rest(seq__15123_15145__$1);
var G__15148 = c__4550__auto___15146;
var G__15149 = cljs.core.count(c__4550__auto___15146);
var G__15150 = (0);
seq__15123_15135 = G__15147;
chunk__15124_15136 = G__15148;
count__15125_15137 = G__15149;
i__15126_15138 = G__15150;
continue;
} else {
var i_15151 = cljs.core.first(seq__15123_15145__$1);
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mins,i_15151),clock_15131);


var G__15152 = cljs.core.next(seq__15123_15145__$1);
var G__15153 = null;
var G__15154 = (0);
var G__15155 = (0);
seq__15123_15135 = G__15152;
chunk__15124_15136 = G__15153;
count__15125_15137 = G__15154;
i__15126_15138 = G__15155;
continue;
}
} else {
}
}
break;
}

var G__15156 = seq__15111_15127;
var G__15157 = chunk__15118_15128;
var G__15158 = count__15119_15129;
var G__15159 = (i__15120_15130 + (1));
seq__15111_15127 = G__15156;
chunk__15118_15128 = G__15157;
count__15119_15129 = G__15158;
i__15120_15130 = G__15159;
continue;
} else {
var G__15160 = seq__15111_15127;
var G__15161 = chunk__15118_15128;
var G__15162 = count__15119_15129;
var G__15163 = (i__15120_15130 + (1));
seq__15111_15127 = G__15160;
chunk__15118_15128 = G__15161;
count__15119_15129 = G__15162;
i__15120_15130 = G__15163;
continue;
}
} else {
var temp__5457__auto___15164 = cljs.core.seq(seq__15111_15127);
if(temp__5457__auto___15164){
var seq__15111_15165__$1 = temp__5457__auto___15164;
if(cljs.core.chunked_seq_QMARK_(seq__15111_15165__$1)){
var c__4550__auto___15166 = cljs.core.chunk_first(seq__15111_15165__$1);
var G__15167 = cljs.core.chunk_rest(seq__15111_15165__$1);
var G__15168 = c__4550__auto___15166;
var G__15169 = cljs.core.count(c__4550__auto___15166);
var G__15170 = (0);
seq__15111_15127 = G__15167;
chunk__15118_15128 = G__15168;
count__15119_15129 = G__15169;
i__15120_15130 = G__15170;
continue;
} else {
var clock_15171 = cljs.core.first(seq__15111_15165__$1);
var start_15172 = org_analyzer.view.util.minutes_since_midnight(cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(clock_15171));
var end_15173 = org_analyzer.view.util.minutes_since_midnight(cljs.core.cst$kw$end.cljs$core$IFn$_invoke$arity$1(clock_15171));
var end_15174__$1 = (((end_15173 === (0)))?(((start_15172 === (0)))?(0):(1440)):(((end_15173 < start_15172))?null:end_15173
));
if(cljs.core.truth_(end_15174__$1)){
var seq__15114_15175 = cljs.core.seq(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start_15172,end_15174__$1));
var chunk__15115_15176 = null;
var count__15116_15177 = (0);
var i__15117_15178 = (0);
while(true){
if((i__15117_15178 < count__15116_15177)){
var i_15179 = chunk__15115_15176.cljs$core$IIndexed$_nth$arity$2(null,i__15117_15178);
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mins,i_15179),clock_15171);


var G__15180 = seq__15114_15175;
var G__15181 = chunk__15115_15176;
var G__15182 = count__15116_15177;
var G__15183 = (i__15117_15178 + (1));
seq__15114_15175 = G__15180;
chunk__15115_15176 = G__15181;
count__15116_15177 = G__15182;
i__15117_15178 = G__15183;
continue;
} else {
var temp__5457__auto___15184__$1 = cljs.core.seq(seq__15114_15175);
if(temp__5457__auto___15184__$1){
var seq__15114_15185__$1 = temp__5457__auto___15184__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15114_15185__$1)){
var c__4550__auto___15186 = cljs.core.chunk_first(seq__15114_15185__$1);
var G__15187 = cljs.core.chunk_rest(seq__15114_15185__$1);
var G__15188 = c__4550__auto___15186;
var G__15189 = cljs.core.count(c__4550__auto___15186);
var G__15190 = (0);
seq__15114_15175 = G__15187;
chunk__15115_15176 = G__15188;
count__15116_15177 = G__15189;
i__15117_15178 = G__15190;
continue;
} else {
var i_15191 = cljs.core.first(seq__15114_15185__$1);
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mins,i_15191),clock_15171);


var G__15192 = cljs.core.next(seq__15114_15185__$1);
var G__15193 = null;
var G__15194 = (0);
var G__15195 = (0);
seq__15114_15175 = G__15192;
chunk__15115_15176 = G__15193;
count__15116_15177 = G__15194;
i__15117_15178 = G__15195;
continue;
}
} else {
}
}
break;
}

var G__15196 = cljs.core.next(seq__15111_15165__$1);
var G__15197 = null;
var G__15198 = (0);
var G__15199 = (0);
seq__15111_15127 = G__15196;
chunk__15118_15128 = G__15197;
count__15119_15129 = G__15198;
i__15120_15130 = G__15199;
continue;
} else {
var G__15200 = cljs.core.next(seq__15111_15165__$1);
var G__15201 = null;
var G__15202 = (0);
var G__15203 = (0);
seq__15111_15127 = G__15200;
chunk__15118_15128 = G__15201;
count__15119_15129 = G__15202;
i__15120_15130 = G__15203;
continue;
}
}
} else {
}
}
break;
}

return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.persistent_BANG_,mins);
});
org_analyzer.view.util.clock_minute_intervals = (function org_analyzer$view$util$clock_minute_intervals(clocks){
var i = (0);
var current_clocks = cljs.core.PersistentVector.EMPTY;
var each_minute = org_analyzer.view.util.clocks_each_minute(clocks);
var result = cljs.core.PersistentVector.EMPTY;
while(true){
if(cljs.core.empty_QMARK_(each_minute)){
return result;
} else {
var n = cljs.core.count(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (i,current_clocks,each_minute,result){
return (function (p1__15204_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_clocks,p1__15204_SHARP_);
});})(i,current_clocks,each_minute,result))
,each_minute));
var next_i = (i + n);
var next = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,each_minute);
var G__15205 = next_i;
var G__15206 = cljs.core.first(next);
var G__15207 = next;
var G__15208 = (((n === (0)))?result:cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,(i + n),current_clocks], null)));
i = G__15205;
current_clocks = G__15206;
each_minute = G__15207;
result = G__15208;
continue;
}
break;
}
});
org_analyzer.view.util.clock_minute_intervals_by_day = (function org_analyzer$view$util$clock_minute_intervals_by_day(clocks_by_day){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by(cljs.core._LT_),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__15209){
var vec__15210 = p__15209;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15210,(0),null);
var clocks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15210,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,org_analyzer.view.util.clock_minute_intervals(clocks)], null);
}),clocks_by_day));
});
