// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.timeline');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('reagent.core');
goog.require('reagent.ratom');
goog.require('org_analyzer.view.geo');
goog.require('org_analyzer.view.dom');
goog.require('clojure.set');
goog.require('org_analyzer.view.util');
goog.require('cljs.pprint');
goog.require('clojure.string');
org_analyzer.view.timeline.clock_bounds_on_canvas = (function org_analyzer$view$timeline$clock_bounds_on_canvas(intervals_with_clocks,offset_x,offset_y,minute_width,row,row_height){
var iter__4523__auto__ = (function org_analyzer$view$timeline$clock_bounds_on_canvas_$_iter__19487(s__19488){
return (new cljs.core.LazySeq(null,(function (){
var s__19488__$1 = s__19488;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19488__$1);
if(temp__5457__auto__){
var s__19488__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19488__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19488__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19490 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19489 = (0);
while(true){
if((i__19489 < size__4522__auto__)){
var vec__19491 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19489);
var from = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19491,(0),null);
var to = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19491,(1),null);
var clocks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19491,(2),null);
var x = (from * minute_width);
var y = (row * row_height);
var w = ((to * minute_width) - x);
var h = (((row + (1)) * row_height) - y);
var x__$1 = (x + offset_x);
var y__$1 = (y + offset_y);
cljs.core.chunk_append(b__19490,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [x__$1,y__$1,w,h,clocks], null));

var G__19497 = (i__19489 + (1));
i__19489 = G__19497;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19490),org_analyzer$view$timeline$clock_bounds_on_canvas_$_iter__19487(cljs.core.chunk_rest(s__19488__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19490),null);
}
} else {
var vec__19494 = cljs.core.first(s__19488__$2);
var from = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19494,(0),null);
var to = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19494,(1),null);
var clocks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19494,(2),null);
var x = (from * minute_width);
var y = (row * row_height);
var w = ((to * minute_width) - x);
var h = (((row + (1)) * row_height) - y);
var x__$1 = (x + offset_x);
var y__$1 = (y + offset_y);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [x__$1,y__$1,w,h,clocks], null),org_analyzer$view$timeline$clock_bounds_on_canvas_$_iter__19487(cljs.core.rest(s__19488__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(intervals_with_clocks);
});
org_analyzer.view.timeline.activities_by_minute_view = (function org_analyzer$view$timeline$activities_by_minute_view(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19609 = arguments.length;
var i__4731__auto___19610 = (0);
while(true){
if((i__4731__auto___19610 < len__4730__auto___19609)){
args__4736__auto__.push((arguments[i__4731__auto___19610]));

var G__19611 = (i__4731__auto___19610 + (1));
i__4731__auto___19610 = G__19611;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return org_analyzer.view.timeline.activities_by_minute_view.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

org_analyzer.view.timeline.activities_by_minute_view.cljs$core$IFn$_invoke$arity$variadic = (function (clock_minute_intervals_by_day,highlighted_entries,tooltip,opts){
var hovered_over_clock = reagent.ratom.atom.cljs$core$IFn$_invoke$arity$1(null);
return ((function (hovered_over_clock){
return (function() { 
var G__19612__delegate = function (clock_minute_intervals_by_day__$1,highlighted_entries__$1,tooltip__$1,p__19503){
var vec__19504 = p__19503;
var map__19507 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19504,(0),null);
var map__19507__$1 = (((((!((map__19507 == null))))?(((((map__19507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19507.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19507):map__19507);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19507__$1,cljs.core.cst$kw$width);
var n_days = cljs.core.count(clock_minute_intervals_by_day__$1);
var heading_h = (22);
var padding_left = (((n_days > (31)))?(10):(35));
var padding_right = (10);
var w = ((width - padding_left) - padding_right);
var w_ea = (w / ((60) * (24)));
var h_ea = (function (){var pred__19509 = cljs.core._GT_;
var expr__19510 = n_days;
if(cljs.core.truth_((pred__19509.cljs$core$IFn$_invoke$arity$2 ? pred__19509.cljs$core$IFn$_invoke$arity$2((10),expr__19510) : pred__19509.call(null,(10),expr__19510)))){
return (15);
} else {
if(cljs.core.truth_((pred__19509.cljs$core$IFn$_invoke$arity$2 ? pred__19509.cljs$core$IFn$_invoke$arity$2((20),expr__19510) : pred__19509.call(null,(20),expr__19510)))){
return (14);
} else {
if(cljs.core.truth_((pred__19509.cljs$core$IFn$_invoke$arity$2 ? pred__19509.cljs$core$IFn$_invoke$arity$2((31),expr__19510) : pred__19509.call(null,(31),expr__19510)))){
return (12);
} else {
if(cljs.core.truth_((pred__19509.cljs$core$IFn$_invoke$arity$2 ? pred__19509.cljs$core$IFn$_invoke$arity$2((100),expr__19510) : pred__19509.call(null,(100),expr__19510)))){
return (8);
} else {
return (4);
}
}
}
}
})();
var height = ((h_ea * cljs.core.count(clock_minute_intervals_by_day__$1)) + heading_h);
var clocks_in_rows = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,clock_minute_intervals_by_day__$1);
var clock_bounds = (function (){var iter__4523__auto__ = ((function (n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function org_analyzer$view$timeline$iter__19512(s__19513){
return (new cljs.core.LazySeq(null,((function (n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function (){
var s__19513__$1 = s__19513;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19513__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var vec__19518 = cljs.core.first(xs__6012__auto__);
var row = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19518,(0),null);
var vec__19521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19518,(1),null);
var date = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19521,(0),null);
var clock_intervals = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19521,(1),null);
var iterys__4519__auto__ = ((function (s__19513__$1,vec__19518,row,vec__19521,date,clock_intervals,xs__6012__auto__,temp__5457__auto__,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function org_analyzer$view$timeline$iter__19512_$_iter__19514(s__19515){
return (new cljs.core.LazySeq(null,((function (s__19513__$1,vec__19518,row,vec__19521,date,clock_intervals,xs__6012__auto__,temp__5457__auto__,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function (){
var s__19515__$1 = s__19515;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__19515__$1);
if(temp__5457__auto____$1){
var s__19515__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__19515__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19515__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19517 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19516 = (0);
while(true){
if((i__19516 < size__4522__auto__)){
var bounds = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19516);
cljs.core.chunk_append(b__19517,cljs.core.with_meta(bounds,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$row,row], null)));

var G__19613 = (i__19516 + (1));
i__19516 = G__19613;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19517),org_analyzer$view$timeline$iter__19512_$_iter__19514(cljs.core.chunk_rest(s__19515__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19517),null);
}
} else {
var bounds = cljs.core.first(s__19515__$2);
return cljs.core.cons(cljs.core.with_meta(bounds,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$row,row], null)),org_analyzer$view$timeline$iter__19512_$_iter__19514(cljs.core.rest(s__19515__$2)));
}
} else {
return null;
}
break;
}
});})(s__19513__$1,vec__19518,row,vec__19521,date,clock_intervals,xs__6012__auto__,temp__5457__auto__,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
,null,null));
});})(s__19513__$1,vec__19518,row,vec__19521,date,clock_intervals,xs__6012__auto__,temp__5457__auto__,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(org_analyzer.view.timeline.clock_bounds_on_canvas(clock_intervals,padding_left,heading_h,w_ea,row,h_ea)));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,org_analyzer$view$timeline$iter__19512(cljs.core.rest(s__19513__$1)));
} else {
var G__19614 = cljs.core.rest(s__19513__$1);
s__19513__$1 = G__19614;
continue;
}
} else {
return null;
}
break;
}
});})(n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
,null,null));
});})(n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
;
return iter__4523__auto__(clocks_in_rows);
})();
var hovered_over = cljs.core.deref(hovered_over_clock);
var selected_clocks = cljs.core.deref(highlighted_entries__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$canvas$activities_DASH_by_DASH_minute_DASH_canvas,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$width,width,cljs.core.cst$kw$height,height,cljs.core.cst$kw$on_DASH_mouse_DASH_out,((function (n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function (evt){
return cljs.core.reset_BANG_(hovered_over_clock,null);
});})(n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
,cljs.core.cst$kw$on_DASH_mouse_DASH_move,((function (n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function (evt){
var p = org_analyzer.view.dom.mouse_position.cljs$core$IFn$_invoke$arity$variadic(evt,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$relative_QMARK_,true], 0));
var bounds = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (p,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function (p1__19498_SHARP_){
return org_analyzer.view.geo.contains_point_QMARK_(p1__19498_SHARP_,p);
});})(p,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
,clock_bounds));
var temp__5457__auto___19615 = bounds;
if(cljs.core.truth_(temp__5457__auto___19615)){
var vec__19524_19616 = temp__5457__auto___19615;
var __19617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19524_19616,(0),null);
var __19618__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19524_19616,(1),null);
var __19619__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19524_19616,(2),null);
var __19620__$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19524_19616,(3),null);
var clocks_19621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19524_19616,(4),null);
cljs.core.reset_BANG_(highlighted_entries__$1,cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$location,clocks_19621)));

if(cljs.core.truth_(tooltip__$1)){
cljs.core.reset_BANG_(tooltip__$1,(((cljs.core.count(clocks_19621) === (0)))?null:(function (){var vec__19527 = clocks_19621;
var map__19530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19527,(0),null);
var map__19530__$1 = (((((!((map__19530 == null))))?(((((map__19530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19530.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19530):map__19530);
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19530__$1,cljs.core.cst$kw$start);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19530__$1,cljs.core.cst$kw$end);
var time = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(start)," - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(end)].join('');
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,time,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),(function (){var iter__4523__auto__ = ((function (vec__19527,map__19530,map__19530__$1,start,end,time,vec__19524_19616,__19617,__19618__$1,__19619__$2,__19620__$3,clocks_19621,temp__5457__auto___19615,p,bounds,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function org_analyzer$view$timeline$iter__19532(s__19533){
return (new cljs.core.LazySeq(null,((function (vec__19527,map__19530,map__19530__$1,start,end,time,vec__19524_19616,__19617,__19618__$1,__19619__$2,__19620__$3,clocks_19621,temp__5457__auto___19615,p,bounds,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function (){
var s__19533__$1 = s__19533;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__19533__$1);
if(temp__5457__auto____$1){
var s__19533__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__19533__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19533__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19535 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19534 = (0);
while(true){
if((i__19534 < size__4522__auto__)){
var map__19536 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19534);
var map__19536__$1 = (((((!((map__19536 == null))))?(((((map__19536.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19536.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19536):map__19536);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19536__$1,cljs.core.cst$kw$path);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19536__$1,cljs.core.cst$kw$name);
cljs.core.chunk_append(b__19535,cljs.core.with_meta(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,"[",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(" > ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.parse_all_org_links,clojure.string.trim),path)),"]",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$name,org_analyzer.view.util.parse_all_org_links(name)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,start], null)));

var G__19622 = (i__19534 + (1));
i__19534 = G__19622;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19535),org_analyzer$view$timeline$iter__19532(cljs.core.chunk_rest(s__19533__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19535),null);
}
} else {
var map__19538 = cljs.core.first(s__19533__$2);
var map__19538__$1 = (((((!((map__19538 == null))))?(((((map__19538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19538):map__19538);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19538__$1,cljs.core.cst$kw$path);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19538__$1,cljs.core.cst$kw$name);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,"[",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(" > ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.parse_all_org_links,clojure.string.trim),path)),"]",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$name,org_analyzer.view.util.parse_all_org_links(name)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,start], null)),org_analyzer$view$timeline$iter__19532(cljs.core.rest(s__19533__$2)));
}
} else {
return null;
}
break;
}
});})(vec__19527,map__19530,map__19530__$1,start,end,time,vec__19524_19616,__19617,__19618__$1,__19619__$2,__19620__$3,clocks_19621,temp__5457__auto___19615,p,bounds,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
,null,null));
});})(vec__19527,map__19530,map__19530__$1,start,end,time,vec__19524_19616,__19617,__19618__$1,__19619__$2,__19620__$3,clocks_19621,temp__5457__auto___19615,p,bounds,n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
;
return iter__4523__auto__(clocks_19621);
})())], null);
})()));
} else {
}
} else {
}

return cljs.core.reset_BANG_(hovered_over_clock,bounds);
});})(n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
,cljs.core.cst$kw$ref,((function (n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock){
return (function (canvas){
if(cljs.core.truth_(canvas)){
var ctx = canvas.getContext("2d");
var G__19540_19623 = ctx;
G__19540_19623.clearRect((0),(0),width,height);

G__19540_19623.save();


var seq__19541_19624 = cljs.core.seq(clock_bounds);
var chunk__19542_19625 = null;
var count__19543_19626 = (0);
var i__19544_19627 = (0);
while(true){
if((i__19544_19627 < count__19543_19626)){
var bounds_19628 = chunk__19542_19625.cljs$core$IIndexed$_nth$arity$2(null,i__19544_19627);
var vec__19559_19629 = bounds_19628;
var x_19630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19559_19629,(0),null);
var y_19631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19559_19629,(1),null);
var w_19632__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19559_19629,(2),null);
var h_19633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19559_19629,(3),null);
var clocks_19634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19559_19629,(4),null);
var map__19562_19635 = cljs.core.meta(bounds_19628);
var map__19562_19636__$1 = (((((!((map__19562_19635 == null))))?(((((map__19562_19635.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19562_19635.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19562_19635):map__19562_19635);
var row_19637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19562_19636__$1,cljs.core.cst$kw$row);
var map__19563_19638 = cljs.core.meta(hovered_over);
var map__19563_19639__$1 = (((((!((map__19563_19638 == null))))?(((((map__19563_19638.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19563_19638.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19563_19638):map__19563_19638);
var selected_row_19640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19563_19639__$1,cljs.core.cst$kw$row);
var row_selected_QMARK__19641 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(row_19637,selected_row_19640);
var bounds_selected_QMARK__19642 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hovered_over,bounds_19628);
var no_clocks_QMARK__19643 = cljs.core.empty_QMARK_(clocks_19634);
var highlighted_a_bit_QMARK__19644 = (!(cljs.core.empty_QMARK_(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(selected_clocks,cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$location,clocks_19634))))));
var color_19645 = ((((no_clocks_QMARK__19643) && (row_selected_QMARK__19641)))?"#ddd":((no_clocks_QMARK__19643)?"#fff":((bounds_selected_QMARK__19642)?"red":((highlighted_a_bit_QMARK__19644)?"salmon":((row_selected_QMARK__19641)?"#6fA":"#3e8"
)))));
ctx.fillStyle = color_19645;

ctx.strokeStyle = "rgba(60,160,120,.4)";

ctx.lineWidth = (1);

ctx.fillRect(x_19630,y_19631,w_19632__$1,h_19633);

if(no_clocks_QMARK__19643){
} else {
ctx.strokeRect((x_19630 + (1)),(y_19631 + (1)),(w_19632__$1 - (1)),(h_19633 - (1)));
}


var G__19646 = seq__19541_19624;
var G__19647 = chunk__19542_19625;
var G__19648 = count__19543_19626;
var G__19649 = (i__19544_19627 + (1));
seq__19541_19624 = G__19646;
chunk__19542_19625 = G__19647;
count__19543_19626 = G__19648;
i__19544_19627 = G__19649;
continue;
} else {
var temp__5457__auto___19650 = cljs.core.seq(seq__19541_19624);
if(temp__5457__auto___19650){
var seq__19541_19651__$1 = temp__5457__auto___19650;
if(cljs.core.chunked_seq_QMARK_(seq__19541_19651__$1)){
var c__4550__auto___19652 = cljs.core.chunk_first(seq__19541_19651__$1);
var G__19653 = cljs.core.chunk_rest(seq__19541_19651__$1);
var G__19654 = c__4550__auto___19652;
var G__19655 = cljs.core.count(c__4550__auto___19652);
var G__19656 = (0);
seq__19541_19624 = G__19653;
chunk__19542_19625 = G__19654;
count__19543_19626 = G__19655;
i__19544_19627 = G__19656;
continue;
} else {
var bounds_19657 = cljs.core.first(seq__19541_19651__$1);
var vec__19566_19658 = bounds_19657;
var x_19659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19566_19658,(0),null);
var y_19660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19566_19658,(1),null);
var w_19661__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19566_19658,(2),null);
var h_19662 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19566_19658,(3),null);
var clocks_19663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19566_19658,(4),null);
var map__19569_19664 = cljs.core.meta(bounds_19657);
var map__19569_19665__$1 = (((((!((map__19569_19664 == null))))?(((((map__19569_19664.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19569_19664.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19569_19664):map__19569_19664);
var row_19666 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19569_19665__$1,cljs.core.cst$kw$row);
var map__19570_19667 = cljs.core.meta(hovered_over);
var map__19570_19668__$1 = (((((!((map__19570_19667 == null))))?(((((map__19570_19667.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19570_19667.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19570_19667):map__19570_19667);
var selected_row_19669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19570_19668__$1,cljs.core.cst$kw$row);
var row_selected_QMARK__19670 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(row_19666,selected_row_19669);
var bounds_selected_QMARK__19671 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hovered_over,bounds_19657);
var no_clocks_QMARK__19672 = cljs.core.empty_QMARK_(clocks_19663);
var highlighted_a_bit_QMARK__19673 = (!(cljs.core.empty_QMARK_(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(selected_clocks,cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$location,clocks_19663))))));
var color_19674 = ((((no_clocks_QMARK__19672) && (row_selected_QMARK__19670)))?"#ddd":((no_clocks_QMARK__19672)?"#fff":((bounds_selected_QMARK__19671)?"red":((highlighted_a_bit_QMARK__19673)?"salmon":((row_selected_QMARK__19670)?"#6fA":"#3e8"
)))));
ctx.fillStyle = color_19674;

ctx.strokeStyle = "rgba(60,160,120,.4)";

ctx.lineWidth = (1);

ctx.fillRect(x_19659,y_19660,w_19661__$1,h_19662);

if(no_clocks_QMARK__19672){
} else {
ctx.strokeRect((x_19659 + (1)),(y_19660 + (1)),(w_19661__$1 - (1)),(h_19662 - (1)));
}


var G__19675 = cljs.core.next(seq__19541_19651__$1);
var G__19676 = null;
var G__19677 = (0);
var G__19678 = (0);
seq__19541_19624 = G__19675;
chunk__19542_19625 = G__19676;
count__19543_19626 = G__19677;
i__19544_19627 = G__19678;
continue;
}
} else {
}
}
break;
}

var G__19573_19679 = ctx;
G__19573_19679.restore();

G__19573_19679.save();


ctx.textBaseline = "top";

ctx.textAlign = "center";

ctx.font = "10px sans-serif";

ctx.strokeStyle = "black";

var seq__19574_19680 = cljs.core.seq(cljs.core.range.cljs$core$IFn$_invoke$arity$1((25)));
var chunk__19576_19681 = null;
var count__19577_19682 = (0);
var i__19578_19683 = (0);
while(true){
if((i__19578_19683 < count__19577_19682)){
var h_19684 = chunk__19576_19681.cljs$core$IIndexed$_nth$arity$2(null,i__19578_19683);
var x_19685 = (padding_left + ((h_19684 * (60)) * w_ea));
ctx.fillText(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h_19684,(24)))?"0":cljs.core.str.cljs$core$IFn$_invoke$arity$1(h_19684)),x_19685,(2));


var G__19686 = seq__19574_19680;
var G__19687 = chunk__19576_19681;
var G__19688 = count__19577_19682;
var G__19689 = (i__19578_19683 + (1));
seq__19574_19680 = G__19686;
chunk__19576_19681 = G__19687;
count__19577_19682 = G__19688;
i__19578_19683 = G__19689;
continue;
} else {
var temp__5457__auto___19690 = cljs.core.seq(seq__19574_19680);
if(temp__5457__auto___19690){
var seq__19574_19691__$1 = temp__5457__auto___19690;
if(cljs.core.chunked_seq_QMARK_(seq__19574_19691__$1)){
var c__4550__auto___19692 = cljs.core.chunk_first(seq__19574_19691__$1);
var G__19693 = cljs.core.chunk_rest(seq__19574_19691__$1);
var G__19694 = c__4550__auto___19692;
var G__19695 = cljs.core.count(c__4550__auto___19692);
var G__19696 = (0);
seq__19574_19680 = G__19693;
chunk__19576_19681 = G__19694;
count__19577_19682 = G__19695;
i__19578_19683 = G__19696;
continue;
} else {
var h_19697 = cljs.core.first(seq__19574_19691__$1);
var x_19698 = (padding_left + ((h_19697 * (60)) * w_ea));
ctx.fillText(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h_19697,(24)))?"0":cljs.core.str.cljs$core$IFn$_invoke$arity$1(h_19697)),x_19698,(2));


var G__19699 = cljs.core.next(seq__19574_19691__$1);
var G__19700 = null;
var G__19701 = (0);
var G__19702 = (0);
seq__19574_19680 = G__19699;
chunk__19576_19681 = G__19700;
count__19577_19682 = G__19701;
i__19578_19683 = G__19702;
continue;
}
} else {
}
}
break;
}

if((h_ea >= (10))){
ctx.textBaseline = "middle";

ctx.textAlign = "left";

var seq__19580_19703 = cljs.core.seq(clocks_in_rows);
var chunk__19581_19704 = null;
var count__19582_19705 = (0);
var i__19583_19706 = (0);
while(true){
if((i__19583_19706 < count__19582_19705)){
var vec__19596_19707 = chunk__19581_19704.cljs$core$IIndexed$_nth$arity$2(null,i__19583_19706);
var row_19708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19596_19707,(0),null);
var vec__19599_19709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19596_19707,(1),null);
var day_19710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19599_19709,(0),null);
var __19711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19599_19709,(1),null);
ctx.fillText(clojure.string.replace(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(day_19710,(5)),"-","/"),(3),((heading_h + (h_ea * row_19708)) + (h_ea / (2))));


var G__19712 = seq__19580_19703;
var G__19713 = chunk__19581_19704;
var G__19714 = count__19582_19705;
var G__19715 = (i__19583_19706 + (1));
seq__19580_19703 = G__19712;
chunk__19581_19704 = G__19713;
count__19582_19705 = G__19714;
i__19583_19706 = G__19715;
continue;
} else {
var temp__5457__auto___19716 = cljs.core.seq(seq__19580_19703);
if(temp__5457__auto___19716){
var seq__19580_19717__$1 = temp__5457__auto___19716;
if(cljs.core.chunked_seq_QMARK_(seq__19580_19717__$1)){
var c__4550__auto___19718 = cljs.core.chunk_first(seq__19580_19717__$1);
var G__19719 = cljs.core.chunk_rest(seq__19580_19717__$1);
var G__19720 = c__4550__auto___19718;
var G__19721 = cljs.core.count(c__4550__auto___19718);
var G__19722 = (0);
seq__19580_19703 = G__19719;
chunk__19581_19704 = G__19720;
count__19582_19705 = G__19721;
i__19583_19706 = G__19722;
continue;
} else {
var vec__19602_19723 = cljs.core.first(seq__19580_19717__$1);
var row_19724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19602_19723,(0),null);
var vec__19605_19725 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19602_19723,(1),null);
var day_19726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19605_19725,(0),null);
var __19727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19605_19725,(1),null);
ctx.fillText(clojure.string.replace(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(day_19726,(5)),"-","/"),(3),((heading_h + (h_ea * row_19724)) + (h_ea / (2))));


var G__19728 = cljs.core.next(seq__19580_19717__$1);
var G__19729 = null;
var G__19730 = (0);
var G__19731 = (0);
seq__19580_19703 = G__19728;
chunk__19581_19704 = G__19729;
count__19582_19705 = G__19730;
i__19583_19706 = G__19731;
continue;
}
} else {
}
}
break;
}
} else {
}

var G__19608 = ctx;
G__19608.stroke();

G__19608.restore();

return G__19608;
} else {
return null;
}
});})(n_days,heading_h,padding_left,padding_right,w,w_ea,h_ea,height,clocks_in_rows,clock_bounds,hovered_over,selected_clocks,vec__19504,map__19507,map__19507__$1,width,hovered_over_clock))
], null)], null);
};
var G__19612 = function (clock_minute_intervals_by_day__$1,highlighted_entries__$1,tooltip__$1,var_args){
var p__19503 = null;
if (arguments.length > 3) {
var G__19732__i = 0, G__19732__a = new Array(arguments.length -  3);
while (G__19732__i < G__19732__a.length) {G__19732__a[G__19732__i] = arguments[G__19732__i + 3]; ++G__19732__i;}
  p__19503 = new cljs.core.IndexedSeq(G__19732__a,0,null);
} 
return G__19612__delegate.call(this,clock_minute_intervals_by_day__$1,highlighted_entries__$1,tooltip__$1,p__19503);};
G__19612.cljs$lang$maxFixedArity = 3;
G__19612.cljs$lang$applyTo = (function (arglist__19733){
var clock_minute_intervals_by_day__$1 = cljs.core.first(arglist__19733);
arglist__19733 = cljs.core.next(arglist__19733);
var highlighted_entries__$1 = cljs.core.first(arglist__19733);
arglist__19733 = cljs.core.next(arglist__19733);
var tooltip__$1 = cljs.core.first(arglist__19733);
var p__19503 = cljs.core.rest(arglist__19733);
return G__19612__delegate(clock_minute_intervals_by_day__$1,highlighted_entries__$1,tooltip__$1,p__19503);
});
G__19612.cljs$core$IFn$_invoke$arity$variadic = G__19612__delegate;
return G__19612;
})()
;
;})(hovered_over_clock))
});

org_analyzer.view.timeline.activities_by_minute_view.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
org_analyzer.view.timeline.activities_by_minute_view.cljs$lang$applyTo = (function (seq19499){
var G__19500 = cljs.core.first(seq19499);
var seq19499__$1 = cljs.core.next(seq19499);
var G__19501 = cljs.core.first(seq19499__$1);
var seq19499__$2 = cljs.core.next(seq19499__$1);
var G__19502 = cljs.core.first(seq19499__$2);
var seq19499__$3 = cljs.core.next(seq19499__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19500,G__19501,G__19502,seq19499__$3);
});

